#ifndef _CLIENTCONNECTMANAGER_H
#define _CLIENTCONNECTMANAGER_H

#include "ace/Connector.h"
#include "ace/SOCK_Connector.h"

#include "TimerManager.hpp"
#include "BaseClientConnectManager.h"
#include "ReactorUDPClient.h"
#include "HashTable.h"
#include "XmlConfig.h"
#include "ConnectClient.h"
#include <unordered_map>

const uint32 RE_CONNECT_SERVER_TIMEOUT = 100 * 1000;
const uint32 WAIT_FOR_RECONNECT_FINISH = 5000;

using CConnectClientConnector = ACE_Connector<CConnectClient, ACE_SOCK_CONNECTOR>;

class CReactorClientInfo
{
public:
    CReactorClientInfo()  = default;

    bool Init(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, CConnectClientConnector* pReactorConnect, IClientMessage* pClientMessage, ACE_Reactor* pReactor, uint32 u4PacketParseID);  //ʼӵַͶ˿
    void SetLocalAddr(const char* pIP, uint16 u2Port, uint8 u1IPType);                         //󶨱صIPͶ˿
    bool Run(bool blIsReady, EM_Server_Connect_State emState = EM_Server_Connect_State::SERVER_CONNECT_RECONNECT);  //ʼ
    bool SendData(ACE_Message_Block* pmblk);                                               //
    int  GetServerID() const;                                                              //õID
    bool Close();                                                                          //رշ
    void SetConnectClient(CConnectClient* pConnectClient);                                 //״̬
    CConnectClient* GetConnectClient();                                                    //õProConnectClientָ
    IClientMessage* GetClientMessage();                                                    //õǰϢָ
    ACE_INET_Addr GetServerAddr() const;                                                   //÷ĵַ
    EM_Server_Connect_State GetServerConnectState() const;                                 //õǰ״̬
    void SetServerConnectState(EM_Server_Connect_State objState);                          //õǰ״̬
    void SetPacketParseID(uint32 u4PacketParseID);                                         //ýID
    uint32 GetPacketParseID() const;                                                       //ýID

private:
    ACE_INET_Addr              m_AddrLocal;                               //صӵַָ
    ACE_INET_Addr              m_AddrServer;                              //Զ̷ĵַ
    CConnectClient*            m_pConnectClient  = nullptr;               //ǰӶ
    CConnectClientConnector*   m_pReactorConnect = nullptr;               //ConnectorӶ
    IClientMessage*            m_pClientMessage  = nullptr;               //ص࣬صشͷݷ
    uint32                     m_u4PacketParseID = 0;                     //õPacketParseID
    ACE_Reactor*               m_pReactor        = nullptr;               //¼ʹõķӦ
    bool                       m_blIsLocal       = false;                 //ǷҪƶض˿
    int                        m_nServerID       = 0;                     //Զ̷ID
    EM_Server_Connect_State    m_emConnectState  = EM_Server_Connect_State::SERVER_CONNECT_READY;  //״̬
};

class CClientReConnectManager : public IClientManager
{
public:
    CClientReConnectManager(void) = default;

    bool Init(ACE_Reactor* pReactor);
    bool Connect(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, IClientMessage* pClientMessage, uint32 u4PacketParseID) final;                                                                 //ӷ(TCP)
    bool Connect(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, const char* pLocalIP, uint16 u2LocalPort, uint8 u1LocalIPType, IClientMessage* pClientMessage, uint32 u4PacketParseID) final;  //ӷ(TCP)ָصַ

    bool ConnectFrame(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, uint32 u4PacketParseID) final;                //ָķPacketParseID
    bool ConnectFrame(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, const char* pLocalIP, uint16 u2LocalPort, uint8 u1LocalIPType, uint32 u4PacketParseID) final;    //ָķPacketParseID

    bool ConnectUDP(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, EM_UDP_TYPE emType, IClientUDPMessage* pClientUDPMessage) final;                                //һָUDPӣUDP
    bool ReConnect(int nServerID);                                                                                                  //һָķ(TCP)
    bool CloseByClient(int nServerID);                                                                                              //Զ̱ر(TCP)
    bool Close(int nServerID) final;                                                                                                //ر
    bool CloseUDP(int nServerID) final;                                                                                             //رӣUDP
    bool ConnectErrorClose(int nServerID);                                                                                          //ڲʧܣProConnectClient
    bool SendData(int nServerID, char*& pData, int nSize, bool blIsDelete = true) final;                                            //
    bool SendDataUDP(int nServerID, const char* pIP, uint16 u2Port, char*& pMessage, uint32 u4Len, bool blIsDelete = true) final;   //ݣUDP
    bool SetHandler(int nServerID, CConnectClient* pConnectClient);                                                                 //ָCProConnectClient*󶨸nServerID
    IClientMessage* GetClientMessage(int nServerID) final;                                                                          //ClientMessage
    bool StartConnectTask(uint16 u2IntervalTime = CONNECT_LIMIT_RETRY) final;                                                           //ԶĶʱ
    void CancelConnectTask() final;                                                                                                 //رʱ
    void Close() final;                                                                                                             //ر
    ACE_INET_Addr GetServerAddr(int nServerID);                                                                                     //õָԶ̵ַϢ
    bool SetServerConnectState(int nServerID, EM_Server_Connect_State objState);                                                    //ָӵ״̬
    bool GetServerIPInfo(int nServerID, _ClientIPInfo& objServerIPInfo) final;                                                      //õһnServerIDӦServerIPϢ
    bool DeleteIClientMessage(IClientMessage* pClientMessage) final;                                                                //ɾһڽIClientMessage

    void GetConnectInfo(vecClientConnectInfo& VecClientConnectInfo);      //صǰӵϢTCP
    void GetUDPConnectInfo(vecClientConnectInfo& VecClientConnectInfo);   //صǰӵϢUDP
    EM_Server_Connect_State GetConnectState(int nServerID) final;         //õһǰ״̬
    uint32 GetPacketParseID(int nServerID) final;                         //õǰPacketParseID

    int timer_task(brynet::TimerMgr::Ptr timerMgr);                       //ʱ
    void start_new_task(brynet::TimerMgr::Ptr timerMgr);                  //öʱ


private:
    shared_ptr<CReactorClientInfo> ConnectTcpInit(int nServerID);
    shared_ptr<CReactorUDPClient> ConnectUdpInit(int nServerID);

public:
    using hashmapClientTCPList = unordered_map<int, shared_ptr<CReactorClientInfo>>;
    using hashmapClientUDPList = unordered_map<int, shared_ptr<CReactorUDPClient>>;
    hashmapClientTCPList            m_objClientTCPList;                            //TCPͻ
    hashmapClientUDPList            m_objClientUDPList;                            //UDPͻ
    CConnectClientConnector         m_ReactorConnect;                              //Reactorӿͻ˶
    ACE_Recursive_Thread_Mutex      m_ThreadWritrLock;                             //߳
    ACE_Reactor*                    m_pReactor               = nullptr;            //ǰķӦ
    bool                            m_blReactorFinish        = false;              //ReactorǷѾע
    bool                            m_blTimerState           = true;               //ʱǷ
    uint16                          m_u2ThreadTimeCheck = CONNECT_LIMIT_RETRY;     //ʱļʱ
    uint32                          m_u4ConnectServerTimeout = 0;                  //Ӽʱ
    uint32                          m_u4MaxPoolCount         = 0;                  //ӳص
    EM_S2S_Run_State                m_emS2SRunState          = EM_S2S_Run_State::S2S_Run_State_Init; //ǰ״̬
    vector<CS2SConnectGetRandyInfo> m_GetReadyInfoList;                            //ҪȴӵϢ
};

using App_ClientReConnectManager = PSS_singleton<CClientReConnectManager>;
#endif
