#ifndef _PROCONNECTMANAGER_H
#define _PROCONNECTMANAGER_H

//Զ̷Ĺ
//һṹConectHandlerָ
//add by freeeyes 2010-12-27

#include "ace/INET_Addr.h"
#include "ace/Guard_T.h"

#include "TimerManager.hpp"
#include "ProAsynchConnect.h"
#include "BaseClientConnectManager.h"
#include "ProactorUDPClient.h"
#include "HashTable.h"
#include "XmlConfig.h"

#define PRO_CONNECT_SERVER_TIMEOUT 100*1000

#define WAIT_FOR_PROCONNECT_FINISH 5000

class CProactorClientInfo
{
public:
    CProactorClientInfo();
    ~CProactorClientInfo();

    bool Init(const char* pIP, uint16 u2Port, uint8 u1IPType, int nServerID, CProAsynchConnect* pProAsynchConnect, IClientMessage* pClientMessage, uint32 u4PacketParseID);  //ʼӵַͶ˿
    void SetLocalAddr(const char* pIP, uint16 u2Port, uint8 u1IPType);                             //ñIPͶ˿
    bool Run(bool blIsReadly, EM_Server_Connect_State emState = EM_Server_Connect_State::SERVER_CONNECT_RECONNECT);     //ʼ
    bool SendData(ACE_Message_Block* pmblk);                                                   //
    int  GetServerID();                                                                        //õID
    bool Close();                                                                              //رշ
    void SetProConnectClient(CProConnectClient* pProConnectClient);                            //ProConnectClientָ
    CProConnectClient* GetProConnectClient();                                                  //õProConnectClientָ
    IClientMessage* GetClientMessage();                                                        //õǰϢָ
    ACE_INET_Addr GetServerAddr();                                                             //÷ĵַ
    EM_Server_Connect_State GetServerConnectState();                                           //õǰ״̬
    void SetServerConnectState(EM_Server_Connect_State objState);                              //õǰ״̬
    void SetPacketParseID(uint32 u4PacketParseID);                                             //ýID
    uint32 GetPacketParseID();                                                                 //ýID

private:
    ACE_INET_Addr             m_AddrLocal;                //صӵַָ
    ACE_INET_Addr             m_AddrServer;               //Զ̷ĵַ
    CProConnectClient*        m_pProConnectClient;        //ǰӶ
    CProAsynchConnect*        m_pProAsynchConnect;        //첽Ӷ
    IClientMessage*           m_pClientMessage;           //ص࣬صشͷݷ
    uint32                    m_u4PacketParseID;          //õPacketParseID
    bool                      m_blIsLocal;                //ǷҪƶض˿
    int                       m_nServerID;                //IDû
    EM_Server_Connect_State   m_emConnectState;           //״̬
};

//ӵĹ
class CClientProConnectManager : public IClientManager
{
public:
    CClientProConnectManager(void);
    ~CClientProConnectManager(void);

    bool Init(ACE_Proactor* pProactor);                                                                                        //ʼ
    bool Connect(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, IClientMessage* pClientMessage, uint32 u4PacketParseID) final;                   //ָķTCP
    bool Connect(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, const char* pLocalIP, uint16 u2LocalPort, uint8 u1LocalIPType, IClientMessage* pClientMessage, uint32 u4PacketParseID) final;  //ӷ(TCP)ָصַ
    bool ConnectFrame(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, uint32 u4PacketParse) final;                //ָķPacketParseID
    bool ConnectFrame(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, const char* pLocalIP, uint16 u2LocalPort, uint8 u1LocalIPType, uint32 u4PacketParse) final;      //ָķPacketParseID
    bool ConnectUDP(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, EM_UDP_TYPE emType, IClientUDPMessage* pClientUDPMessage) final;                                //һָUDPӣUDP
    bool ReConnect(int nServerID);                                                                                             //һָķ(TCP)
    bool CloseByClient(int nServerID);                                                                                         //Զ̱ر(TCP)
    virtual bool Close(int nServerID);                                                                                                 //رӣTCP
    virtual bool CloseUDP(int nServerID);                                                                                              //رӣUDP
    bool ConnectErrorClose(int nServerID);                                                                                     //ڲʧܣProConnectClient
    virtual bool SendData(int nServerID, char*& pData, int nSize, bool blIsDelete = true);                                             //ݣTCP
    virtual bool SendDataUDP(int nServerID,const char* pIP, uint16 u2Port, char*& pMessage, uint32 u4Len, bool blIsDelete = true);   //ݣUDP
    bool SetHandler(int nServerID, CProConnectClient* pProConnectClient);                                                      //ָCProConnectClient*󶨸nServerID
    virtual IClientMessage* GetClientMessage(int nServerID);                                                                           //ClientMessage
    virtual uint32 GetPacketParseID(int nServerID);                                                                           //PacketParseID
    virtual bool StartConnectTask(uint16 u2IntervalTime = CONNECT_LIMIT_RETRY);                                                            //ԶĶʱ
    virtual void CancelConnectTask();                                                                                                  //رʱ
    virtual void Close();                                                                                                              //ر
    ACE_INET_Addr GetServerAddr(int nServerID);                                                                                //õָԶ̵ַϢ
    bool SetServerConnectState(int nServerID, EM_Server_Connect_State objState);                                               //ָӵ״̬
    bool DeleteIClientMessage(IClientMessage* pClientMessage);                                                                 //ɾһڽIClientMessage

    virtual void GetConnectInfo(vecClientConnectInfo& VecClientConnectInfo);      //صǰӵϢTCP
    virtual void GetUDPConnectInfo(vecClientConnectInfo& VecClientConnectInfo);   //صǰӵϢUDP
    virtual EM_Server_Connect_State GetConnectState(int nServerID);               //õһǰ״̬
    bool GetServerIPInfo(int nServerID, _ClientIPInfo& objServerIPInfo);  //õһnServerIDӦServerIPϢ

    int timer_task(brynet::TimerMgr::Ptr timerMgr);                       //ʱ
    void start_new_task(brynet::TimerMgr::Ptr timerMgr);                  //öʱ

private:
    bool ConnectTcpInit(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, const char* pLocalIP, int nLocalPort, uint8 u1LocalIPType, IClientMessage* pClientMessage, CProactorClientInfo*& pClientInfo, uint32 u4PacketParseID = 0);
    bool ConnectUdpInit(int nServerID, CProactorUDPClient*& pProactorUDPClient);

private:
    CProAsynchConnect               m_ProAsynchConnect;
    CHashTable<CProactorClientInfo> m_objClientTCPList;                        //TCPͻ
    CHashTable<CProactorUDPClient>  m_objClientUDPList;                        //UDPͻ
    ACE_Recursive_Thread_Mutex      m_ThreadWritrLock;                         //߳
    bool                            m_blProactorFinish  = false;               //ProactorǷѾע
    bool                            m_blTimerState      = true;                //ʱǷ
    uint16                          m_u2ThreadTimeCheck = CONNECT_LIMIT_RETRY; //ʱļʱ
    uint32                          m_u4ConnectServerTimeout;                  //Ӽʱ
    uint32                          m_u4MaxPoolCount;                          //ӳص
    EM_S2S_Run_State                m_emS2SRunState;                           //ǰ״̬
    vector<CS2SConnectGetRandyInfo> m_GetReadyInfoList;                        //ҪȴӵϢ
};

using App_ClientProConnectManager = PSS_singleton<CClientProConnectManager>;

#endif
