#ifndef _MESSAGESERVICE_H
#define _MESSAGESERVICE_H

#include "ace/Synch.h"
#include "ace/Malloc_T.h"
#include "ace/Singleton.h"
#include "ace/Thread_Mutex.h"
#include "ace/Date_Time.h"

#include "BaseTask.h"
#include "Message.h"
#include "MessageManager.h"
#include "LogManager.h"
#include "ThreadInfo.h"
#include "BuffPacket.h"
#include "TimerManager.hpp"
#include "WorkThreadAI.h"
#include "MessageDyeingManager.h"
#include "ObjectLru.h"
#include "PerformanceCounter.h"
#include "BuffPacketManager.h"

#if PSS_PLATFORM == PLATFORM_WIN
#include "WindowsCPU.h"
#else
#include "LinuxCPU.h"
#endif

enum class MESSAGE_SERVICE_THREAD_STATE
{
    THREAD_RUN = 0,               //߳
    THREAD_MODULE_UNLOAD,         //ģأҪִ֧߳˹
    THREAD_STOP,                  //ֹ߳ͣ
};

class CWorkThread_Packet_Info
{
public:
    uint8  m_u1ThreadID  = 0;
    uint32 m_u4PacketIn  = 0;
    uint32 m_u4PacketOut = 0;
    uint32 m_u4RecvSize  = 0;
    uint32 m_u4SendSize  = 0;
    
    uint8 m_u1Minute    = 0;    //ǰʱ䣬շͳ

    void Clear()
    {
        m_u4PacketIn  = 0;
        m_u4PacketOut = 0;
        m_u4RecvSize  = 0;
        m_u4SendSize  = 0;
    }
};

//߳ݰͳ
class CWorkThread_Process
{
public:
    CWorkThread_Packet_Info m_objPacketCounter;

    void Clear(uint8 u1NowMinite)
    {
        if (u1NowMinite != m_objPacketCounter.m_u1Minute)
        {
            m_objPacketCounter.Clear();
            m_objPacketCounter.m_u1Minute = u1NowMinite;
        }
    }

    void AddPacketIn(uint32 m_u4PacketIn, uint8 u1Minute)
    {
        Clear(u1Minute);
        
        m_objPacketCounter.m_u4PacketIn++;
        m_objPacketCounter.m_u4RecvSize = m_u4PacketIn;
    }

    void AddPacketOut(uint32 m_u4PacketOut, uint8 u1Minute)
    {
        Clear(u1Minute);

        m_objPacketCounter.m_u4PacketOut++;
        m_objPacketCounter.m_u4SendSize = m_u4PacketOut;
    }

    CWorkThread_Packet_Info GetCurrInfo(uint8 u1Minute)
    {
        Clear(u1Minute);
        return m_objPacketCounter;
    }
};

//߳ʱģʽ
class CMessageService
{
public:
    CMessageService();

    int open();
    int svc (void);
    int Close();

    void Init(uint32 u4ThreadID, uint32 u4MaxQueue = MAX_MSG_THREADQUEUE, uint32 u4LowMask = MAX_MSG_MASK, uint32 u4HighMask = MAX_MSG_MASK, bool blIsCpuAffinity = false);

    bool Start();

    bool PutMessage(shared_ptr<CWorkThreadMessageList> pMessage);
    bool PutUpdateCommandMessage(uint32 u4UpdateIndex);

    _ThreadInfo* GetThreadInfo();
    bool SaveThreadInfoData(const PSS_Time_Point& tvNow);   //¼ǰ߳״̬Ϣ־

    void GetAIInfo(_WorkThreadAIInfo& objAIInfo) const;           //õй̵߳AI
    void GetAITO(vecCommandTimeout& objTimeout) const;            //õеAIʱݰϢ
    void GetAITF(vecCommandTimeout& objTimeout) const;            //õеAIݰϢ
    void SetAI(uint8 u1AI, uint32 u4DisposeTime, uint32 u4WTCheckTime, uint32 u4WTStopTime);  //AI

    void SetThreadState(MESSAGE_SERVICE_THREAD_STATE emState);             //߳״̬
    MESSAGE_SERVICE_THREAD_STATE GetThreadState() const;                   //õǰ߳״̬
    THREADSTATE GetStepState() const;                                      //õǰϢ
    uint32 GetUsedMessageCount();                                          //õʹõMessage

    uint32 GetThreadID() const;

    uint32 GetHandlerCount() const;                                        //õǰ߳Handlerĸ

    void CopyMessageManagerList();                                         //MessageManagerлб

    shared_ptr<CWorkThreadMessage> CreateMessage() const;
    void DeleteMessage(shared_ptr<CWorkThreadMessage> pMessage) const;

    void GetFlowPortList(const PSS_Time_Point& tvNow, vector<CWorkThread_Packet_Info>& vec_Port_Data_Account); //õǰбϢ

    bool Synchronize_SendPostMessage(shared_ptr<CWorkThread_Handler_info> pHandlerInfo, const PSS_Time_Point& tvMessage);
    bool SendPostMessage(const CSendMessageInfo& objSendMessageInfo);          //
    bool SendCloseMessage(uint32 u4ConnectID);                                //رָ 

    _ClientIPInfo GetClientIPInfo(uint32 u4ConnectID);                        //õͻ˽˿
    _ClientIPInfo GetLocalIPInfo(uint32 u4ConnectID);                         //õͻ˼˿

    void Check_Handler_Recv_Timeout();                                        //նʱ䳬ʱ
    EM_Client_Connect_status GetConnectState(uint32 u4ConnectID);             //õǰ״̬ 

    uint32 GetThreadID();

private:
    shared_ptr<CWorkThread_Handler_info> ProcessRecvMessage(shared_ptr<CWorkThreadMessage> pMessage, uint32 u4ThreadID); //¼
    bool ProcessSendMessage(shared_ptr<CWorkThreadMessage> pMessage, uint32 u4ThreadID); //¼
    bool ProcessSendClose(shared_ptr<CWorkThreadMessage> pMessage, uint32 u4ThreadID);   //¼
    bool ProcessSendIsLog(shared_ptr<CWorkThreadMessage> pMessage, uint32 u4ThreadID);   //¼
    void CloseCommandList();                                                  //ǰб
    shared_ptr<CClientCommandList> GetClientCommandList(uint16 u2CommandID);
    bool DoMessage(IMessage* pMessage, uint16& u2CommandID, uint16& u2Count, bool& bDeleteFlag);

    void UpdateCommandList(uint32 u4UpdateIndex);                        //ָб
    bool Dispose_Queue(shared_ptr<CWorkThreadMessageList> msgList);      //

    uint32                         m_u4ThreadID         = 0;                     //ǰ߳ID
    uint32                         m_u4MaxQueue         = MAX_MSG_THREADQUEUE;   //߳Ϣ
    uint32                         m_u4HighMask         = 0;        
    uint32                         m_u4LowMask          = 0;
    uint32                         m_u4WorkQueuePutTime = 0;                     //ӳʱʱ
    uint32                         m_u4MaxRecvWait      = 0;                     //ȴʱ  
    uint16                         m_u2ThreadTimeOut    = 0;
    uint8                          m_u1PacketCounter    = 0;                     //Ƿͳ,0ǹرգ1ǿ
    bool                           m_blRun              = false;                 //߳Ƿ
    bool                           m_blIsCpuAffinity    = false;                 //ǷCPU

    MESSAGE_SERVICE_THREAD_STATE   m_emThreadState      = MESSAGE_SERVICE_THREAD_STATE::THREAD_STOP; //ǰ߳״̬

    CBuffPacket                    m_objBuffSendPacket;

    _ThreadInfo                    m_ThreadInfo;           //ǰ߳Ϣ
    CWorkThreadAI                  m_WorkThreadAI;         //߳ҼصAI߼
    CWorkThread_Process            m_objWorkThreadProcess; //ͳ߳һӵݰ

    CDeviceHandlerPool             m_DeviceHandlerPool;    // 

    using hashmapClientCommandList = unordered_map<uint16, shared_ptr<CClientCommandList>>;
    using hashmapHandlerInfoList   = unordered_map<uint32, shared_ptr<CWorkThread_Handler_info>>;
    hashmapClientCommandList                            m_objClientCommandList;  //ִеб
    hashmapHandlerInfoList                              m_objHandlerList;        //ӦHandlerб

    CPerformanceCounter m_PerformanceCounter;
    std::thread                                         m_ttQueue;               //Ϣ߳
    CMessageQueue<shared_ptr<CWorkThreadMessageList>>   m_objThreadQueue;        //ҵϢ
};

//add by freeeyes
//̹߳ûԴɸACE_TaskÿTaskӦһ̣߳һConnectidֻӦһ̡߳
class CMessageServiceGroup
{
public:
    CMessageServiceGroup();

    int timer_task(brynet::TimerMgr::Ptr timerMgr);
    void start_new_task(brynet::TimerMgr::Ptr timerMgr);

    bool Init(uint32 u4ThreadCount = MAX_MSG_THREADCOUNT, uint32 u4MaxQueue = MAX_MSG_THREADQUEUE, uint32 u4LowMask = MAX_MSG_MASK);
    bool PutMessage(shared_ptr<CWorkThreadMessageList> pMessage);                            //͵Ӧ߳ȥ
    bool PutUpdateCommandMessage(uint32 u4UpdateIndex) const;                                //ϢͬеĹ߳
    void Close();

    bool Start();
    void GetThreadInfo(vector<_ThreadInfo>& vecWorkThreadList) const;
    uint32 GetUsedMessageCount() const;

    uint32 GetWorkThreadCount() const;                                                        //õǰ̵߳
    uint32 GetWorkThreadIDByIndex(uint32 u4Index);                                            //õ̵ָ߳߳ID
    void GetWorkThreadAIInfo(vecWorkThreadAIInfo& objvecWorkThreadAIInfo) const;              //õ̹߳AIϢ
    void GetAITO(vecCommandTimeout& objTimeout) const;                                        //õеAIʱݰϢ
    void GetAITF(vecCommandTimeout& objTimeout) const;                                        //õеAIݰϢ
    void SetAI(uint8 u1AI, uint32 u4DisposeTime, uint32 u4WTCheckTime, uint32 u4WTStopTime) const;  //AI

    shared_ptr<CWorkThreadMessage> CreateMessage(uint32 u4ConnectID, EM_CONNECT_IO_TYPE u1PacketType);   //߳лȡһMessage
    void DeleteMessage(shared_ptr<CWorkThreadMessage> pMessage);                                         //߳лһMessage

    void CopyMessageManagerList() const;                                                      //MessageManagerлб

    void AddDyringIP(const char* pClientIP, uint16 u2MaxCount);                               //ȾɫָIP
    bool AddDyeingCommand(uint16 u2CommandID, uint16 u2MaxCount);                             //ȾɫָCommandID
    void GetDyeingCommand(vec_Dyeing_Command_list& objList) const;                            //õǰȾɫ״̬

    void GetFlowPortList(vector<CWorkThread_Packet_Info>& vec_Port_Data_Account) const;       //õǰбϢ
    bool CheckCPUAndMemory(bool blTest = false) const;                                        //CPUڴ

    bool Send_Post_Message(const CSendMessageInfo& objSendMessageInfo);                       //Ϣ
    bool Send_Close_Message(uint32 u4ConnectID);                                              //رտͻ
    _ClientIPInfo GetClientIPInfo(uint32 u4ConnectID);                                        //õָӵĿͻID 
    _ClientIPInfo GetLocalIPInfo(uint32 u4ConnectID);                                         //õIPϢ
    uint32 GetHandlerCount() const;                                                           //õǰ
    EM_Client_Connect_status GetConnectState(uint32 u4ConnectID);                             //õǰ״̬ 

private:
    uint32 GetWorkThreadID(uint32 u4ConnectID, EM_CONNECT_IO_TYPE emPacketType) const;        //ݲͺConnectIDǸ߳ID

    bool StartTimer();
    bool KillTimer();

    bool CheckRecvTimeout() const;                                                            //еĳʱ
    bool CheckWorkThread(const PSS_Time_Point& tvNow) const;                                  //еĹ߳״̬
    bool CheckPlugInState() const;                                                            //в״̬
   
	using vecMessageService = vector<shared_ptr<CMessageService>>;
	vecMessageService                                   m_vecMessageService;
    uint32                                              m_u4MaxQueue           = 0;              //߳Ϣ
    uint32                                              m_u4HighMask           = 0;              //̸߳ˮλ
    uint32                                              m_u4LowMask            = 0;              //̵߳ˮλ
    uint16                                              m_u2ThreadTimeCheck    = 0;              //߳Լʱ
    uint16                                              m_u2CurrThreadID       = 0;              //ǰѯ߳ID
    uint16                                              m_u2CpuNumber          = 0;              //ǰCPUĺ
    bool                                                m_blTimerState         = true;           //ʱǷ
    CMessageDyeingManager                               m_objMessageDyeingManager; //Ⱦɫ
    ACE_Recursive_Thread_Mutex                          m_ThreadLock;              //̲֤߳߳CurrThreadID
};

using App_MessageServiceGroup = PSS_singleton<CMessageServiceGroup>;
#endif
