#ifndef _MESSAGEMANAGER_H
#define _MESSAGEMANAGER_H

#pragma once

#include "IMessageManager.h"
#include "Message.h"
#include "LoadModule.h"
#include "HashTable.h"
#include <unordered_map>

//޸һ£һӦһģƵġ
//ΪһԶӦĴģ飬ͱȽϺˡ
//hashԻۻߵ
//add by freeeyes

//ߵĸʽ
class _ClientCommandInfo
{
public:
    uint32          m_u4Count                    = 0;                  //ǰõĴ
    uint32          m_u4TimeCost                 = 0;                  //ǰʱ
    uint32          m_u4CurrUsedCount            = 0;                  //ǰʹõô
    shared_ptr<CClientCommand> m_pClientCommand  = nullptr;            //ǰָ
    uint16          m_u2CommandID                = 0;                  //ǰӦID
    string          m_strModuleName;                                   //ģ
    ACE_Date_Time   m_dtLoadTime;                                      //ǰʱ
    _ClientIPInfo   m_objListenIPInfo;                                 //ǰIPͶ˿ڣĬеǰ˿

    _ClientCommandInfo() = default;
};

//ģ_ClientCommandInfo֮ĶӦϵ
class _ModuleClient
{
public:
    vector<shared_ptr<_ClientCommandInfo>> m_vecClientCommandInfo;    //һģжӦб
};

//һϢԶӦһCClientCommand*飬ϢʱַЩ
class CClientCommandList
{
private:
    uint16  m_u2CommandID = 0;                      //ǰID
    uint16  m_u2Timeout   = 0;                      //ǰʱʱ
    using vecClientCommandList = vector<shared_ptr<_ClientCommandInfo>>;
    vecClientCommandList m_vecClientCommandList;

public:
    CClientCommandList() = default;

    explicit CClientCommandList(uint16 u2CommandID) : m_u2CommandID(u2CommandID)
    {
    }

    void SetCommandTimeout(uint16 u2Timeout)
    {
        m_u2Timeout = u2Timeout;
    }

    uint16 GetCommandTimeout() const
    {
        return m_u2Timeout;
    }

    void SetCommandID(uint16 u2CommandID)
    {
        m_u2CommandID = u2CommandID;
    }

    uint16 GetCommandID() const
    {
        return m_u2CommandID;
    }

    void Close()
    {
        m_vecClientCommandList.clear();
    }

    shared_ptr<_ClientCommandInfo> AddClientCommand(shared_ptr<CClientCommand> pClientCommand, const char* pMuduleName, const _ClientIPInfo* pListenInfo)
    {
        auto pClientCommandInfo = std::make_shared<_ClientCommandInfo>();
        pClientCommandInfo->m_pClientCommand   = pClientCommand;
        pClientCommandInfo->m_strModuleName    = pMuduleName;

        if (nullptr != pListenInfo)
        {
            pClientCommandInfo->m_objListenIPInfo = (*pListenInfo);
        }

        m_vecClientCommandList.emplace_back(pClientCommandInfo);

        return pClientCommandInfo;
    }

    //Ϊtrue֤ϢѾûжӦҪΧHashгȥ
    bool DelClientCommand(shared_ptr<CClientCommand> pClientCommand)
    {
        for(vecClientCommandList::iterator b = m_vecClientCommandList.begin(); b!= m_vecClientCommandList.end(); ++b)
        {
            auto pClientCommandInfo = *b;

            if(nullptr != pClientCommandInfo 
                && pClientCommand == pClientCommandInfo->m_pClientCommand)
            {
                m_vecClientCommandList.erase(b);
                break;
            }
        }

        if((int)m_vecClientCommandList.size() == 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    //õ
    int GetCount() const
    {
        return (int)m_vecClientCommandList.size();
    }

    //õָλõָ
    shared_ptr<_ClientCommandInfo> GetClientCommandIndex(int nIndex)
    {
        if(nIndex >= (int)m_vecClientCommandList.size())
        {
            return nullptr;
        }
        else
        {
            return m_vecClientCommandList[nIndex];
        }
    }
};

using hashmapClientCommandList = unordered_map<uint16, shared_ptr<CClientCommandList>>;
using hashmapModuleClientList = unordered_map<string, shared_ptr<_ModuleClient>>;

class CMessageManager : public IMessageManager
{
public:
    CMessageManager(void) = default;

    void Init(uint16 u2MaxModuleCount, uint32 u4MaxCommandCount);

    void Close();

    bool AddClientCommand(uint16 u2CommandID, shared_ptr<CClientCommand> pClientCommand, const char* pModuleName, _ClientIPInfo* pListenInfo) final;   //ע
    bool AddClientCommand(uint16 u2CommandID, shared_ptr<CClientCommand> pClientCommand, const char* pModuleName) final;   //ע
    bool DelClientCommand(uint16 u2CommandID, shared_ptr<CClientCommand> pClientCommand) final;                            //ж

    bool UnloadModuleCommand(const char* pModuleName, uint8 u1LoadState, uint32 u4ThreadCount);  //жָģ¼u1State= 1 жأ2 

    int  GetCommandCount() const;                                      //õǰעĸ
    shared_ptr<CClientCommandList> GetClientCommandExist(uint16 u2CommandID);     //õǰָǷѴڵǰб

    hashmapModuleClientList GetModuleClient() const;                      //ģעϢ

    uint32 GetWorkThreadCount() final;
    uint32 GetWorkThreadByIndex(uint32 u4Index) final;

    uint16 GetMaxCommandCount() const;
    uint32 GetUpdateIndex() const;

    hashmapClientCommandList GetHashCommandList() const;              //õǰHashCommandListĸ

private:
    bool AddClientCommand_Ex(uint16 u2CommandID, shared_ptr<CClientCommand> pClientCommand, const char* pModuleName, const _ClientIPInfo* pListenInfo);   //ע
    void DeleteCommandByModule(shared_ptr<_ClientCommandInfo> pClientCommandInfo);                                                                  //бɾָ
    void Add_ClientCommandList(const xmlCommandsTimeout::_CommandsTimeout* pCommandTimeout, 
        shared_ptr<CClientCommandList> 
        pClientCommandList, 
        uint16 u2CommandID, 
        shared_ptr<CClientCommand> pClientCommand, 
        const char* pModuleName, 
        const _ClientIPInfo* pListenInfo);

    uint32                         m_u4UpdateIndex       = 0;               //ǰID
    uint32                         m_u4MaxCommandCount   = 0;               //е
    uint32                         m_u4CurrCommandCount  = 0;               //ǰЧ
    uint16                         m_u2MaxModuleCount    = 0;               //ģ
    hashmapClientCommandList       m_objClientCommandList;                  //ֶӦ
    hashmapModuleClientList        m_objModuleClientList;                   //ģӦϢ
    ACE_Recursive_Thread_Mutex     m_ThreadWriteLock;                       //

};

using App_MessageManager = PSS_singleton<CMessageManager>;
#endif
