#ifndef _LOGMANAGER_H
#define _LOGMANAGER_H

//־ĳ
//һʹ飬־÷ּ
//Ҳ־
//ʹC11̶߳滻ACE_Task,ִд
//add by freeeyes

#include <stdio.h>
#include "ILogObject.h"
#include "ILogManager.h"
#include "BaseTask.h"
#include "ThreadQueue.h"

class CLogManager : public ILogManager
{
public:
    CLogManager(void) = default;

    int open();
    int svc(void);
    int Close();

    void Init(int nThreadCount = 1, int nQueueMax = MAX_MSG_THREADQUEUE, uint32 u4MailID = 0);
    int Start();
    int Stop();
    bool IsRun() const;

    int PutLog(shared_ptr<_LogBlockInfo> pLogBlockInfo);
    int RegisterLog(shared_ptr<IServerLogger> pServerLogger);
    int UnRegisterLog() const;

    void SetReset(bool blReset);

    void ResetLogData(uint16 u2LogLevel);

    //άӿ
    uint32 GetLogCount() const;
    uint32 GetCurrLevel() const;

    uint16 GetLogID(uint16 u2Index) const;
    const char*  GetLogInfoByServerName(uint16 u2LogID) const;
    const char*  GetLogInfoByLogName(uint16 u2LogID) const;
    int    GetLogInfoByLogDisplay(uint16 u2LogID) const;
    uint16 GetLogInfoByLogLevel(uint16 u2LogID) const;

    //д־Ľӿ
    int WriteLog_i(uint16 u2LogType, const string& strLog);

    int WriteToMail_i(uint16 u2LogType, uint16 u2MailID, const string& strTitle, const string& strLog);

    //д־Ľӿ
    int WriteLogBinary(uint16 u2LogType, const string& strText) final;

    int WriteLog_r(uint16 u2LogType, const string& strLog) final;

    int WriteToMail_r(uint16 u2LogType, uint16 u2MailID, const string& strTitle, const string& strLog) final;

private:
    bool Dispose_Queue(shared_ptr<_LogBlockInfo> msg) const;
    int ProcessLog(shared_ptr<_LogBlockInfo> msg) const;

    //رϢ
    bool                                     m_blRun          = false;               //־ϵͳǷ
    bool                                     m_blIsNeedReset  = false;               //־ģȼñ־
    bool                                     m_blIsMail       = false;               //ǷԷʼ
    int                                      m_nThreadCount   = 1;                   //¼־̸߳ĿǰĬ1
    int                                      m_nQueueMax      = MAX_MSG_THREADQUEUE; //־߳и
    shared_ptr<IServerLogger>                m_pServerLogger = nullptr;              //־ģָ
    CMessageQueue<shared_ptr<_LogBlockInfo>> m_objThreadQueue;
    std::thread                              m_ttQueue;                              //Ϣ߳
};

using AppLogManager = PSS_singleton<CLogManager>;

#endif
