#ifndef _FILETESTMANAGER_H_
#define _FILETESTMANAGER_H_

#include "HashTable.h"
#include "XmlOpeation.h"
#include "HandlerManager.h"

#include "ace/FILE_Addr.h"
#include "ace/FILE_Connector.h"
#include "ace/FILE_IO.h"
#include "FileTest.h"
#include <sstream>
#include <unordered_map>

class CFileTestManager : public IFileTestManager
{
public:
    CFileTestManager(void) = default;

    //ļԷ
    FileTestResultInfoSt FileTestStart(const char* szXmlFileTestName);      //ʼļ
    int FileTestEnd() const;                                                //ļ
    void HandlerServerResponse(uint32 u4ConnectID) final;                   //ǰӷݰĻص
    void Close();                                                           //

private:
    bool LoadXmlCfg(const char* szXmlFileTestName, FileTestResultInfoSt& objFileTestResult);        //ȡļ
    FILE_TEST_RESULT ReadTestFile(const char* pFileName, int nType, FileTestDataInfoSt& objFileTestDataInfo) const;   //Ϣļݽṹ
    int  InitResponseRecordList();                                                                  //ʼResponseRecord
    bool AddResponseRecordList(uint32 u4ConnectID, const ACE_Time_Value& tv);                       //ResponseRecordList

    ACE_Recursive_Thread_Mutex  m_ThreadWriteLock;
    //ļԱ
    bool m_bFileTesting       = false;       //Ƿڽļ

    CXmlOpeation m_MainConfig;
    string m_strProFilePath;
    uint32 m_u4TimeInterval   = 1000;   //ʱ¼
    uint32 m_u4ConnectCount   = 0;      //ģ
    uint32 m_u4ResponseCount  = 0;      //Ӧ
    uint32 m_u4ExpectTime     = 0;      //ʱܵĺʱ(λ)
    uint32 m_u4ParseID        = 0;      //ID
    uint32 m_u4ContentType    = 0;      //Э,1ǶЭ,0ıЭ

    using vecFileTestDataInfoSt = vector<FileTestDataInfoSt>;
    vecFileTestDataInfoSt m_vecFileTestDataInfoSt;

    //ڲʹõӳ
    class ResponseRecordSt
    {
    public:
        uint64 m_u8StartTime     = 0;
        uint8  m_u1ResponseCount = 0;
        uint32 m_u4ConnectID     = 0;

        ResponseRecordSt() = default;
    } ;

    //ղ
    using hashmapResponseRecord = unordered_map<uint32, shared_ptr<ResponseRecordSt>>;
    hashmapResponseRecord m_objResponseRecordList;

};

using App_FileTestManager = PSS_singleton<CFileTestManager>;
#endif //_FILETESTMANAGER_H_