#ifndef POSTSERVER_MESSAGE_H
#define POSTSERVER_MESSAGE_H

#include "IBuffPacket.h"
#include "ClientCommand.h"
#include "ClientReConnectManager.h"

//ദ͸߼

#define RECV_BUFF_SIZE  MAX_BUFF_1024      //ջС

class CPostServerData : public IClientMessage
{
public:
    CPostServerData() = default;

    ~CPostServerData() final = default;

    bool Need_Send_Format() final
    {
        //Ҫ÷װﷵtrue
        //ҪĻﷵfalseSend_Format_dataͲᱻ
        return true;
    }

    //ڼ䷢ݵװ
    bool Send_Format_data(char* pData, uint32 u4Len, IMessageBlockManager* pMessageBlockManager, ACE_Message_Block*& mbSend) final
    {
        //жϻǷڣ򷵻ʧ
        if(nullptr == pMessageBlockManager)
        {
            return false;
        }

        //뷢͵ڴ
        mbSend = pMessageBlockManager->Create(u4Len);

        if(nullptr == mbSend)
        {
            PSS_LOGGER_DEBUG("[CPostServerData::Send_Format_data]({0})Format Create Data nullptr({1}) OK.", m_u4ServerID, u4Len);
            return false;
        }

        //ҪװݣдĴ
        //ֻֻ򵥵ڴ濽ʾĲ
        memcpy_safe(pData, u4Len, mbSend->wr_ptr(), u4Len);
        mbSend->wr_ptr(u4Len);
        return true;
    }

    //ṩƴ㷨ݰRecvData
    bool Recv_Format_data(ACE_Message_Block* mbRecv, IMessageBlockManager* pMessageBlockManager, uint16& u2CommandID, ACE_Message_Block*& mbFinishRecv, EM_PACKET_ROUTE& emPacketRoute) final
    {
        emPacketRoute = EM_PACKET_ROUTE::PACKET_ROUTE_SELF;
        u2CommandID = 0x1000;

        //жϷݿǷС8߳󻺳С
        if(m_u2RecvBuffLength + mbRecv->length() < 8 || mbRecv->length() >= RECV_BUFF_SIZE)
        {
            PSS_LOGGER_DEBUG("[CPostServerData::Recv_Format_data]Get Data Error({0}).", mbRecv->length());
            return false;
        }
        else
        {
            //ͳһ뻺壬ли
            m_u2RecvBuffLength += (uint16)mbRecv->length();
        }



        //ݰ㷨
        uint32 u4Count = 0;
        memcpy_safe(mbRecv->rd_ptr(), sizeof(uint32), (char*)&u4Count, sizeof(uint32));
        mbRecv->rd_ptr(sizeof(uint32));

        //¼ݰͼ
        uint32 u4RecvFinish = u4Count;

        if (u4RecvFinish <= m_u2RecvBuffLength)
        {
            //ݰ
            mbFinishRecv = pMessageBlockManager->Create(u4RecvFinish);
            memcpy_safe(mbRecv->rd_ptr(), u4RecvFinish, mbFinishRecv->rd_ptr(), u4RecvFinish);
            mbFinishRecv->wr_ptr(u4RecvFinish);
            mbRecv->rd_ptr(u4RecvFinish);

            m_u2RecvBuffLength -= u4RecvFinish;
        }

        return true;
    }

    bool RecvData(uint16 u2CommandID, ACE_Message_Block* mbRecv,  const _ClientIPInfo& objServerIPInfo) final
    {
        //ݰѾȫﴦ
        ACE_UNUSED_ARG(u2CommandID);
        ACE_UNUSED_ARG(mbRecv);
        ACE_UNUSED_ARG(objServerIPInfo);

        return true;
    }

    void ReConnect(int nServerID) final
    {
        PSS_LOGGER_DEBUG("[CPostServerData::ReConnect]nServerID={0}.", nServerID);
    }

    bool ConnectError(int nError, _ClientIPInfo const& objServerIPInfo) final
    {
        ACE_UNUSED_ARG(objServerIPInfo);
        PSS_LOGGER_DEBUG("[CPostServerData::ConnectError]nServerID={0}, nError={1}.", m_u4ServerID, nError);
        return true;
    }

    void SetServerID(uint32 u4ServerID)
    {
        m_u4ServerID = u4ServerID;
    }

private:
    uint32                     m_u4ServerID                     = 0;
    uint16                     m_u2RecvBuffLength               = 0;       //ջ峤
};

#endif
