#ifndef MAKEPACKET_COMMON_H
#define MAKEPACKET_COMMON_H

#include "define.h"
#include "PacketParse.h"
#include "IHandler.h"

class _MakePacket
{
public:
	uint32                   m_u4ConnectID     = 0;                                   //ID
	uint32                   m_u4PacketParseID = 0;                                   //ӦConnectIDPacketParseID
	int32                    m_nHashID         = 0;                                   //Ӧ¼hashID
	shared_ptr<CPacketParse> m_pPacketParse    = nullptr;                             //ݰָ
	EM_CONNECT_IO_TYPE       m_emPacketType    = EM_CONNECT_IO_TYPE::CONNECT_IO_TCP;  //ݰ
	uint8                    m_u1Option        = 0;                                   //
	ACE_INET_Addr            m_AddrRemote;                                            //ݰԴIPϢ
	ACE_INET_Addr            m_AddrListen;                                            //ݰԴIPϢ
	IHandler*                m_pHandler        = nullptr;                             //ǰHandler
	PSS_Time_Point           m_tvRecv;                                                //ݵʱ 

	_MakePacket() = default;

	void Clear()
	{
		m_emPacketType    = EM_CONNECT_IO_TYPE::CONNECT_IO_TCP;  //0ΪTCP,1UDP ĬTCP
		m_u4ConnectID     = 0;
		m_u1Option        = 0;
		m_pPacketParse    = nullptr;
		m_u4PacketParseID = 0;
		m_pHandler        = nullptr;
	}

	void SetHashID(int32 nHashID)
	{
		m_nHashID = nHashID;
	}

	int32 GetHashID() const
	{
		return m_nHashID;
	}
};

#endif