#ifndef _BUFFPACKET_H
#define _BUFFPACKET_H

#include "ace/Thread_Mutex.h"

#include "IBuffPacket.h"
#include <stdexcept>
#include <string>
#include <sstream>

const uint32 DEFINE_PACKET_SIZE      = 1024;
const uint32 DEFINE_PACKET_ADD       = 1024;
const uint8  USER_PACKET_MEMORY_POOL = 1; //ʹACEڴط

class CBuffPacket : public IBuffPacket
{
public:
    CBuffPacket() = default;
    CBuffPacket(int32 nSize, int32 nMaxBuffSize);
    ~CBuffPacket() final;

    uint32 GetPacketSize() final;       //õݰĸʽ
    uint32 GetPacketLen() final;        //õݰʵʳ
    uint32 GetReadLen() final;          //õȡĳ
    uint32 GetWriteLen() final;         //õдĳ
    uint32 GetHeadLen() final;          //õݰͷĳ
    uint32 GetPacketCount() final;      //õݰĸ
    const char*  GetData() const final; //õǰָ

    bool Init(int32 nSize = DEFINE_PACKET_SIZE, int32 nMaxBuffSize = MAX_PACKET_SIZE);
    bool Close() final;              //ɾѾʹõڴ
    bool Clear() final;              //еı־λɾڴ档

    bool WriteStream(const char* pData, uint32 u4Len) final;
    bool ReadStream(char* pData, uint32& u4Len) final;
    char* ReadPtr() final;                            //öָ
    char* WritePtr() final;                           //дָ
    void SetReadPtr(uint32 u4Pos) final;              //öָλ
    void SetPacketCount(uint32 u4PacketCount) final;  //ûݰĸ
    bool RollBack(uint32 u4Len) final;                //ȡɾݼ
    void ReadBuffPtr(uint32 u4Size) final;
    void WriteBuffPtr(uint32 u4Size) final;

    bool AddBuff(uint32 u4Size) final;                //PacketİС


    void SetNetSort(bool blState) final;              //ֽأfalseΪtrueΪ

    void SetBuffID(uint32 u4BuffID);            //BuffID
    uint32 GetBuffID() const;                   //õBuffID

    int32 GetHashID() const;                    //HashID
    void SetHashID(int32 nHashID);              //õHashID

    const char* GetError() const;               //شϢ

private:
    void ReadPtr(uint32 u4Size);
    void WritePtr(uint32 u4Size);


public:
    //ȡ
    CBuffPacket& operator >> (uint8& u1Data) final;
    CBuffPacket& operator >> (uint16& u2Data) final;
    CBuffPacket& operator >> (uint32& u4Data) final;
    CBuffPacket& operator >> (uint64& u8Data) final;
    CBuffPacket& operator >> (int8& n1Data) final;
    CBuffPacket& operator >> (int16& n2Data) final;
    CBuffPacket& operator >> (int32& n8Data) final;

    CBuffPacket& operator >> (float32& f4Data) final;
    CBuffPacket& operator >> (float64& f8Data) final;

    CBuffPacket& operator >> (VCHARS_STR& str) final;
    CBuffPacket& operator >> (VCHARM_STR& str) final;
    CBuffPacket& operator >> (VCHARB_STR& str) final;
    CBuffPacket& operator >> (string& str) final;

    //д
    CBuffPacket& operator << (uint8 u1Data) final;
    CBuffPacket& operator << (uint16 u2Data) final;
    CBuffPacket& operator << (uint32 u4Data) final;
    CBuffPacket& operator << (uint64 u8Data) final;
    CBuffPacket& operator << (int8 u1Data) final;
    CBuffPacket& operator << (int16 u2Data) final;
    CBuffPacket& operator << (int32 u4Data) final;

    CBuffPacket& operator << (float32 f4Data) final;
    CBuffPacket& operator << (float64 f8Data) final;

    CBuffPacket& operator << (VCHARS_STR& str) final;
    CBuffPacket& operator << (VCHARM_STR& str) final;
    CBuffPacket& operator << (VCHARB_STR& str) final;
    CBuffPacket& operator << (string& str) final;

private:
    char*                      m_szData          = nullptr;                //ָ
    uint32                     m_u4ReadPtr       = 0;                   //λ
    uint32                     m_u4WritePtr      = 0;                   //дλ
    uint32                     m_u4PacketLen     = 0 ;                  //ܳ
    uint32                     m_u4PacketCount   = 0;                   //ǰݰĸ
    uint32                     m_u4MaxPacketSize = 0;                   //ǰBuffPacket
    uint32                     m_u4BuffID        = 0;                   //Buffer֣ں˶ڴʹãѰڴй¶
    int32                      m_nHashID         = 0;                   //¼ǰHashеλ
    bool                       m_blNetSort       = false;               //ֽأfalseΪתΪֽtrueΪתΪֽ
    string                     m_strError;                              //Ϣ
};
#endif
