#ifndef _TRACE_H
#define _TRACE_H

#include "stdio.h"
#include "stdlib.h"
#include "define.h"

#if PSS_PLATFORM == PLATFORM_WIN
#include <windows.h>
#include <process.h>
#else
#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdarg.h>
#include <sys/syscall.h>
#define gettid() syscall(SYS_gettid)
#endif  // _WIND32
#include <string>

using namespace std;

// 64λ
#if defined(_WIN32) && !defined(CYGWIN)
typedef __int64 int64_t;
#else
typedef long long int64t;
#endif  // _WIN32

//һΨһTraceID
struct _TRACE_ID
{
    int64_t m_nTime;     //ǰʱ䣬ȷ΢
    int m_nPID;          //ǰID
    int m_nTID;          //ǰ߳ID
    unsigned int m_nIP;  //ǰûIP
    short m_sPort;       //ǰû˿
    short m_sCommandID;  //ǰID

    _TRACE_ID()
    {
        m_nTime      = 0;
        m_nPID       = 0;
        m_nTID       = 0;
        m_nIP        = 0;
        m_sPort      = 0;
        m_sCommandID = 0;
    }
};

typedef _TRACE_ID TRACE_ID;

// 1601110:0:0:0001970110:0:0:000ʱ(λ100ns)
#if defined(_WIN32)
#define EPOCHFILETIME   (116444736000000000UL)
#endif

//¼ʱ߹
//add by freeeyes

// ȡϵͳĵǰʱ䣬λ΢(us)
inline int64_t GetSysTimeMicros()
{
#if defined(_WIN32)
    FILETIME ft;
    LARGE_INTEGER li;
    int64_t tt = 0;
    GetSystemTimeAsFileTime(&ft);
    li.LowPart = ft.dwLowDateTime;
    li.HighPart = ft.dwHighDateTime;
    // 1970110:0:0:000ڵ΢(UTCʱ)
    tt = (li.QuadPart - EPOCHFILETIME) / 10;
    return tt;
#else
    timeval tv;
    gettimeofday(&tv, 0);
    return (int64_t)tv.tv_sec * 1000000 + (int64_t)tv.tv_usec;
#endif // _WIN32
}

//֤һIP
static bool effective(const char* pIP)//ipַЧ
{
    int cnt = 0;
    char* ip = (char*)pIP;

    while (*ip != '\0')
    {
        if (*ip == '.')
        {
            cnt++;
        }

        if ((*ip >= '0' && *ip <= '9') || *ip == '.')
        {
            ip++;
        }
        else
        {
            return false;
        }
    }

    if (cnt != 3)
    {
        return false;
    }

    return true;
}

//һIPתΪ
static unsigned int GetValueByIP(const char* pIP)
{
    if (!effective(pIP))
    {
        return 0;
    }

    unsigned int res = 0;

    unsigned char value[4] = { 0 };//IPַĸ
    char word[10] = { 0 };
    int cnt = 0, cntNum = 0;
    char* ip = (char*)pIP;

    while (*ip != '\0')//ֵvalue
    {
        while (*ip != '\0' && *ip != '.')
        {
            word[cnt++] = *ip;
            ip++;
        }

        word[cnt] = '\0';
        cnt = 0;

        if (atoi(word) > 255 || atoi(word) < 0)
        {
            return 0;
        }

        value[cntNum++] = atoi(word);

        if (cntNum == 4)
        {
            break;
        }

        ip++;
    }

    res = (value[0] << 24) | (value[1] << 16) | (value[2] << 8) | value[3];//ĸֽƴӳһ
    return res;
}

//һ֧ڴԽ
inline void sprintf_trace_safe(char* szText, int nLen, const char* fmt ...)
{
    if (szText == nullptr)
    {
        return;
    }

    va_list ap;
    va_start(ap, fmt);

    vsnprintf(szText, nLen, fmt, ap);
    szText[nLen - 1] = '\0';

    va_end(ap);
};

//һTRACE_ID
inline TRACE_ID CreateTraceID(const char* pIP, short sPort, short sCommandID)
{
    TRACE_ID objTraceID;

    //ɹ ʱ + PID + TID + IP
    objTraceID.m_nTime = GetSysTimeMicros();
    printf("[CreateTraceID]%lld.\n", (long long int)objTraceID.m_nTime);

#if defined(_WIN32)
    objTraceID.m_nPID = (int)_getpid();
    objTraceID.m_nTID = GetCurrentThreadId();
#else
    objTraceID.m_nPID = (int)getpid();
    objTraceID.m_nTID = (int)gettid();
#endif

    objTraceID.m_nIP         = GetValueByIP(pIP);
    objTraceID.m_sPort       = sPort;
    objTraceID.m_sCommandID = sCommandID;
    return objTraceID ;
}

//һtraceID־
inline void WriteTrace(const char* pFilePath, const char* pTraceID, const char* pFileName, int nCodeLine)
{
    //ĿǰʽΪXML
    char szFileLog[400] = { '\0' };
    char szTemp[1024] = { '\0' };

    if (nullptr != pTraceID && 0 < strlen(pTraceID))
    {
        sprintf_trace_safe(szFileLog, 200, "%s/%s.xml", pFilePath, pTraceID);
#if defined(_WIN32)
        FILE* pFile = nullptr;
        fopen_s(&pFile, szFileLog, "a+");
#else
        FILE* pFile = fopen(szFileLog, "w");
#endif

        if (nullptr != pFile)
        {
            sprintf_trace_safe(szTemp, 1024, "<Info Time=\"%lld\" FileName=\"%s\" CodeLine=\"%d\"/>\n",
                               GetSysTimeMicros(),
                               pFileName,
                               nCodeLine);
            fwrite(szTemp, strlen(szTemp), sizeof(char), pFile);

            fclose(pFile);
        }
    }
}

//TraceIDתstring
inline string Convert_TraceID_To_char(const char* pIP, short sPort, short sCommandID)
{
    TRACE_ID objTraceID = CreateTraceID(pIP, sPort, sCommandID);

    char pTraceID[100] = { '\0' };
    sprintf_trace_safe(pTraceID, 100, "%016llx%08x%08x%08x%04x%04x",
                       objTraceID.m_nTime,
                       objTraceID.m_nPID,
                       objTraceID.m_nTID,
                       objTraceID.m_nIP,
                       objTraceID.m_sPort,
                       objTraceID.m_sCommandID);
    return (string)pTraceID;
}

//ֲtraceIDϢ
inline void ShowKey(const char* pTraceID)
{
    char szTime[50]      = { '\0' };
    char szPID[50]       = { '\0' };
    char szTID[50]       = { '\0' };
    char szIP[50]        = { '\0' };
    char szPort[50]      = { '\0' };
    char szCommandID[50] = { '\0' };

    //traceIDϢչֳ
    if (nullptr == pTraceID || strlen(pTraceID) != 48)
    {
        return;
    }

    memcpy(szTime, (char*)pTraceID, 16);
    int64_t n8Time = strtoull(szTime, nullptr, 16);
    printf("[ShowKey]Time=%lld.\n", (long long int)n8Time);

    memcpy(szPID, (char*)&pTraceID[16], 8);
    int nPID = (int)strtoul(szPID, nullptr, 16);
    printf("[ShowKey]PTD=%d.\n", nPID);

    memcpy(szTID, (char*)&pTraceID[24], 8);
    int nTID = (int)strtoul(szTID, nullptr, 16);
    printf("[ShowKey]PTD=%d.\n", nTID);

    memcpy(szIP, (char*)&pTraceID[32], 8);
    int nIP = (int)strtoul(szIP, nullptr, 16);
    printf("[ShowKey]PTD=%d.\n", nIP);

    memcpy(szPort, (char*)&pTraceID[40], 4);
    int nPort = (int)strtoul(szPort, nullptr, 16);
    printf("[ShowKey]PTD=%d.\n", nPort);

    memcpy(szCommandID, (char*)&pTraceID[44], 4);
    int nCommandID = (int)strtoul(szCommandID, nullptr, 16);
    printf("[ShowKey]PTD=0x%04x.\n", nCommandID);
}

//ú
#define CREATE_TRACE(x,y,z) Convert_TraceID_To_char(x,y, z);
#define DO_TRACE(x, y) WriteTrace(x, y, __FILE__, __LINE__);
#define SHOW_TRACE_ID(x) ShowKey(x)

#endif

