#ifndef _TIMEWHEELLINK_H
#define _TIMEWHEELLINK_H

//ʱ
//add by freeeyes
#include "HashTable.h"
#include "define.h"
#include <vector>

using namespace std;

#define MAX_TIMEWHEEL_KEY 20
#define INVAILD_BLOCKID   -1  //ЧĿ

//ָģ
template<class T, void(*Timeout_Callback)(void*, vector<T*>)>
void Timeout_Callback_Ex(void* p, vector<T*> a)
{
    Timeout_Callback(p, a);
}

template <class T>
class CTimeWheelLink
{
private:
    typedef void(*Timeout_Callback)(void*, vector<T*>);

public:
    CTimeWheelLink()
    {
        m_nTimeInterval       = 0;
        m_nTimeCycle          = 0;
        m_nContainSize        = 0;
        m_nCurrBlockID        = 0;
        m_fn_Timeout_Callback = nullptr;
        m_pBlockIDList        = nullptr;
        m_nBlockIDListIndex   = 0;
        m_nBlackCount         = 0;
        m_pArgContext         = nullptr;
    }

    ~CTimeWheelLink()
    {
        Close();
    }

    //ʼ
    void Init(int nTimeCycle, int nTimeInterval, int nContainSize, Timeout_Callback fn_Timeout_Callback, void* pArgContext)
    {
        Close();

        m_nTimeInterval       = nTimeInterval;
        m_nTimeCycle          = nTimeCycle;
        m_nContainSize        = nContainSize;
        m_fn_Timeout_Callback = fn_Timeout_Callback;
        m_pArgContext         = pArgContext;

        if(m_nTimeInterval < 1)
        {
            m_nTimeInterval = 1;
        }

        //пܴС
        if (nTimeCycle % m_nTimeInterval != 0)
        {
            m_nBlackCount = nTimeCycle / m_nTimeInterval + 1;
        }
        else
        {
            m_nBlackCount = nTimeCycle / m_nTimeInterval;
        }

        //ʼʱ
        for (int i = 0; i < m_nBlackCount; i++)
        {
            CHashTable<T>* pHashContainer = new CHashTable<T>();
            pHashContainer->Init(m_nContainSize, MAX_TIMEWHEEL_KEY);
            m_vecHashContain.push_back(pHashContainer);
        }

        int nListSize = m_nBlackCount * m_nContainSize;
        //ʼʱӳ
        m_htIndexList.Init(nListSize, MAX_TIMEWHEEL_KEY);

        m_pBlockIDList = new int[nListSize];

        for (int i = 0; i < nListSize; i++)
        {
            m_pBlockIDList[i] = INVAILD_BLOCKID;
        }

        m_nBlockIDListIndex = 0;

        m_nCurrBlockID = 0;
    }

    //
    void Close()
    {
        for (int i = 0; i < (int)m_vecHashContain.size(); i++)
        {
            m_vecHashContain[i]->Close();
            delete m_vecHashContain[i];
        }

        m_vecHashContain.clear();

        if (nullptr != m_pBlockIDList)
        {
            delete[] m_pBlockIDList;
            m_pBlockIDList = nullptr;
        }

        m_nBlockIDListIndex = 0;
        m_nBlackCount = 0;
    }

    //һ
    bool Add_TimeWheel_Object(T* pEntey)
    {
        //жϸָǷĳһ
        char szKey[MAX_TIMEWHEEL_KEY] = { '\0' };

        if (nullptr == pEntey)
        {
            return false;
        }

        sprintf_safe(szKey, MAX_TIMEWHEEL_KEY, "0x%08x", pEntey);

        int* pCurrBlockListID = m_htIndexList.Get_Hash_Box_Data(szKey);

        if (nullptr == pCurrBlockListID || INVAILD_BLOCKID == *pCurrBlockListID)
        {
            //ûκָӵָ
            if (0 > m_vecHashContain[m_nCurrBlockID]->Add_Hash_Data(szKey, pEntey))
            {
                return false;
            }
            else
            {
                //
                int* pBlockID = Get_BlockIDList_Cell();

                if(nullptr != pBlockID)
                {
                    *pBlockID = m_nCurrBlockID;
                    int n4Result = m_htIndexList.Add_Hash_Data(szKey, pBlockID);

                    if(-1 == n4Result)
                    {
                        PSS_LOGGER_DEBUG("[Add_TimeWheel_Object]({0})({1})", szKey, n4Result);
                        return false;
                    }

                    return true;
                }
                else
                {
                    return false;
                }
            }
        }
        else
        {
            //Ѿָ
            //УʲôҲ
            if(*pCurrBlockListID == m_nCurrBlockID)
            {
                return true;
            }
            else
            {
                //ɾָʱеָ
                m_vecHashContain[*pCurrBlockListID]->Del_Hash_Data(szKey);

                //ɾӦʱе
                *pCurrBlockListID = INVAILD_BLOCKID;

                if (-1 == m_htIndexList.Del_Hash_Data(szKey))
                {
                    PSS_LOGGER_DEBUG("[CTimeWheelLink::Add_TimeWheel_Object]Deltet({0}) error.", szKey);
                }

                if (0 > m_vecHashContain[m_nCurrBlockID]->Add_Hash_Data(szKey, pEntey))
                {
                    return false;
                }
                else
                {
                    //
                    int* pBlockID = Get_BlockIDList_Cell();

                    if(nullptr != pBlockID)
                    {
                        *pBlockID = m_nCurrBlockID;
                        int n4Result = m_htIndexList.Add_Hash_Data(szKey, pBlockID);

                        if(-1 == n4Result)
                        {
                            PSS_LOGGER_DEBUG("[Add_TimeWheel_Object]({0})({1}).", szKey, n4Result);
                            return false;
                        }

                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
            }
        }
    }

    //ɾһ
    void Del_TimeWheel_Object(T* pEntey)
    {
        char szKey[MAX_TIMEWHEEL_KEY] = { '\0' };
        sprintf_safe(szKey, MAX_TIMEWHEEL_KEY, "0x%08x", pEntey);

        int* pCurrBlockListID = m_htIndexList.Get_Hash_Box_Data(szKey);

        if (nullptr != pCurrBlockListID && INVAILD_BLOCKID != *pCurrBlockListID)
        {
            // ɾָھݣݷµС
            m_vecHashContain[*pCurrBlockListID]->Del_Hash_Data(szKey);
            *pCurrBlockListID = INVAILD_BLOCKID;
        }

        //Ϣ
        if (-1 == m_htIndexList.Del_Hash_Data(szKey))
        {
            PSS_LOGGER_DEBUG("[CTimeWheelLink::Del_TimeWheel_Object]Delete({0}) no exist.", szKey);
        }
    }

    //õһеm_pBlockIDListλ
    int* Get_BlockIDList_Cell()
    {
        int nListSize = m_nBlackCount * m_nContainSize;

        for (int i = m_nBlockIDListIndex; i < nListSize; i++)
        {
            if (m_pBlockIDList[i] == INVAILD_BLOCKID)
            {
                if(i == nListSize - 1)
                {
                    m_nBlockIDListIndex = 0;
                }
                else
                {
                    m_nBlockIDListIndex = i + 1;
                }

                return &m_pBlockIDList[i];
            }
        }

        for (int i = 0; i < m_nBlockIDListIndex; i++)
        {
            if (m_pBlockIDList[i] == INVAILD_BLOCKID)
            {
                m_nBlockIDListIndex = i + 1;
                return &m_pBlockIDList[i];
            }
        }

        return nullptr;
    }

    //ת
    void Tick()
    {
        //һָID
        int nLastBlockID = m_nCurrBlockID;

        if (m_nCurrBlockID >= (int)m_vecHashContain.size() - 1)
        {
            nLastBlockID = 0;
        }
        else
        {
            nLastBlockID++;
        }

        //õһҪĶϢ
        if (nullptr != m_vecHashContain[nLastBlockID])
        {
            vector<T*> vecEntey;
            m_vecHashContain[nLastBlockID]->Get_All_Used(vecEntey);

            //Ϣ
            for (int i = 0; i < (int)vecEntey.size(); i++)
            {
                char szKey[MAX_TIMEWHEEL_KEY] = { '\0' };
                sprintf_safe(szKey, MAX_TIMEWHEEL_KEY, "0x%08x", vecEntey[i]);

                //Key
                Del_TimeWheel_Object(vecEntey[i]);
            }

            if (nullptr != m_fn_Timeout_Callback)
            {
                m_fn_Timeout_Callback(m_pArgContext, vecEntey);
            }

            m_vecHashContain[nLastBlockID]->Clear();
        }
        else
        {
            PSS_LOGGER_DEBUG("[CTimeWheelLink::Tick]m_vecHashContain is nullptr,nLastBlockID={0}.", nLastBlockID);
        }

        m_nCurrBlockID = nLastBlockID;
    }
private:
    typedef vector<CHashTable<T>*> vecHashContain;

private:
    int              m_nTimeCycle;                        //ʱ
    int              m_nTimeInterval;                     //̼ʱ
    int              m_nContainSize;                      //ÿӼС
    int              m_nCurrBlockID;                      //ǰvector±
    int*             m_pBlockIDList;                      //¼BlockIDӦ
    int              m_nBlockIDListIndex;                 //¼BlockIDĵǰλ
    int              m_nBlackCount;                       //ָ
    CHashTable<int>  m_htIndexList;                       //¼ǰӳ
    vecHashContain   m_vecHashContain;                    //ÿɸCEntey
    Timeout_Callback m_fn_Timeout_Callback;               //صӿ
    void*            m_pArgContext;                       //صĲָ
};
#endif

