#pragma once

#include <iostream>
#include <queue>
#include <mutex>
#include <condition_variable>
#include <thread>

template<class Type>
class CMessageQueue
{
public:
    CMessageQueue& operator = (const CMessageQueue&) = delete;
    CMessageQueue(const CMessageQueue& mq) = delete;


    CMessageQueue() :_queue(), _mutex(), _condition() {}
    virtual ~CMessageQueue() {}

    void Push(Type msg) {
        std::lock_guard <std::mutex> lock(_mutex);
        _queue.push(msg);
        //ʹģʽϢлȡϢʱconditionϢʱѵȴ߳
        _condition.notify_one();
    }

    //blockedʷʽͬ߷ģʽ
    bool Pop(Type& msg, bool isBlocked = true) {
        if (isBlocked)
        {
            std::unique_lock <std::mutex> lock(_mutex);
            while (_queue.empty())
            {
                _condition.wait(lock);

            }
            //עһαifУΪlockif
            msg = std::move(_queue.front());
            _queue.pop();
            return true;

        }
        else
        {
            std::lock_guard<std::mutex> lock(_mutex);
            if (_queue.empty())
                return false;


            msg = std::move(_queue.front());
            _queue.pop();
            return true;
        }

    }

    int32_t Size() {
        std::lock_guard<std::mutex> lock(_mutex);
        return (int32_t)_queue.size();
    }

    bool Empty() {
        std::lock_guard<std::mutex> lock(_mutex);
        return _queue.empty();
    }
private:
    std::queue<Type> _queue;//洢ϢĶ
    mutable std::mutex _mutex;//ͬ
    std::condition_variable _condition;//ʵͬʽȡϢ
};
