#ifndef _ICLIENTMANAGER_H
#define _ICLIENTMANAGER_H

#include "ClientMessage.h"
#include "ClientUDPMassage.h"

//Server 2 server
enum class EM_S2S_Run_State
{
    S2S_Run_State_Init = 0,
    S2S_Run_State_Run,
};

//¼׼ӵķϢ
class CS2SConnectGetRandyInfo
{
public:
    CS2SConnectGetRandyInfo() 
    {
    };

    uint32 m_nServerID               = 0;
    string m_strServerIP;
    uint16 m_u2ServerPort            = 0;
    uint8 m_u1Type                   = 0;
    string m_strLocalIP;
    uint16 m_u2LocalPort             = 0;
    uint8 m_u1LocalIPType            = 0;
    IClientMessage* m_pClientMessage = NULL;
    uint32 m_u4PacketParseID         = 0;
};

//ͨѶݹ
class IClientManager
{
public:
    virtual ~IClientManager() {}

    //TCPӲpClientMessageΪԶݵﴦࡣ
    virtual bool Connect(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, IClientMessage* pClientMessage, uint32 u4PacketParseID) = 0;
    //TCPӲpClientMessageΪԶݵﴦ࣬ñIPͶ˿ڡ
    virtual bool Connect(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, const char* pLocalIP, uint16 u2LocalPort, uint8 u1LocalIPType, IClientMessage* pClientMessage, uint32 u4PacketParseID) = 0;

    //TCPӲpClientMessageΪԶݵﴦࡣ
    virtual bool ConnectFrame(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, uint32 u4PacketParse) = 0;
    //TCPӲpClientMessageΪԶݵﴦ࣬ñIPͶ˿ڡ
    virtual bool ConnectFrame(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, const char* pLocalIP, uint16 u2LocalPort, uint8 u1LocalIPType, uint32 u4PacketParse) = 0;

    //UDPӲpClientUDPMessageΪԶݵﴦࡣ
    virtual bool ConnectUDP(int nServerID, const char* pIP, uint16 u2Port, uint8 u1IPType, EM_UDP_TYPE emType, IClientUDPMessage* pClientUDPMessage) = 0;
    //رĳһServerIDӦTCP
    virtual bool Close(int nServerID)                                                                                                 = 0;
    //رĳһServerIDӦUDP
    virtual bool CloseUDP(int nServerID)                                                                                              = 0;
    //һTCPݰblIsDeleteǷɿܻգ߼գʹCBuffPacketΪڴأﲻɾ
    virtual bool SendData(int nServerID, char*& pData, int nSize, bool blIsDelete = true)                                             = 0;
    //һUDPݰblIsDeleteǷɿܻգ߼գʹCBuffPacketΪڴأﲻɾ
    virtual bool SendDataUDP(int nServerID, const char* pIP, uint16 u2Port, char*& pMessage, uint32 u4Len, bool blIsDelete = true)    = 0;
    //Ӵ飬ڲݰʱϿˣԶؽ
    virtual bool StartConnectTask(uint16 u2IntervalTime)                                                                              = 0;
    //رӴ
    virtual void CancelConnectTask()                                                                                                  = 0;
    //رжӰTCPUDP
    virtual void Close()                                                                                                              = 0;
    //õһӵĵǰ״̬
    virtual EM_Server_Connect_State GetConnectState(int nServerID)                                                                    = 0;
    //һServerIDӦpClientMessageϢ
    virtual IClientMessage* GetClientMessage(int nServerID)                                                                           = 0;
    //һServerIDӦPacketParseID
    virtual uint32 GetPacketParseID(int nServerID)                                                                                    = 0;
    //һServerIDӦIPϢ
    virtual bool GetServerIPInfo(int nServerID, _ClientIPInfo& objServerIPInfo)                                                       = 0;
    //ɾһʹõIClientMessage
    virtual bool DeleteIClientMessage(IClientMessage* pClientMessage)                                                                 = 0;
};

#endif
