#ifndef _IBUFFPACKET_H
#define _IBUFFPACKET_H

#include "define.h"

//BuffPacketĽӿ
class IBuffPacket
{
public:
    virtual ~IBuffPacket() = default;

    virtual uint32 GetPacketSize()      = 0;    //õݰĸʽ
    virtual uint32 GetPacketLen()       = 0;    //õݰʵʳ
    virtual uint32 GetReadLen()         = 0;    //õȡĳ
    virtual uint32 GetWriteLen()        = 0;    //õдĳ
    virtual uint32 GetHeadLen()         = 0;    //õݰͷĳ
    virtual uint32 GetPacketCount()     = 0;    //õݰĸ

    virtual bool Close()                = 0;
    virtual bool Clear()                = 0;

    virtual bool AddBuff(uint32 u4Size) = 0;
    virtual const char* GetData() const = 0;

    virtual void SetReadPtr(uint32 u4Pos)                                = 0;    //öָλ
    virtual void SetPacketCount(uint32 u4PacketCount)                    = 0;    //ûݰĸ
    virtual bool WriteStream(const char* pData, uint32 u4Len)            = 0;    //ֱдһݿ
    virtual bool ReadStream(char* pData, uint32& u4Len)                  = 0;    //ֱӶȡһݿ
    virtual char* ReadPtr()                                              = 0;    //öָ
    virtual char* WritePtr()                                             = 0;    //дָ
    virtual bool RollBack(uint32 u4Len)                                  = 0;    //ȡɾݼ

    virtual void ReadBuffPtr(uint32 u4Size)                              = 0;    //ƶָȵĶָ
    virtual void WriteBuffPtr(uint32 u4Size)                             = 0;    //ƶָȵдָ

    virtual void SetNetSort(bool blState)                                = 0;    //ǷֽfalseΪtrueΪ

    //ȡ
    virtual IBuffPacket& operator >> (uint8& u1Data)   = 0;        //һuint81ֽ޷
    virtual IBuffPacket& operator >> (uint16& u2Data)  = 0;        //һuint162ֽ޷
    virtual IBuffPacket& operator >> (uint32& u4Data)  = 0;        //һuint324ֽ޷
    virtual IBuffPacket& operator >> (uint64& u8Data)  = 0;        //һuint648ֽ޷
    virtual IBuffPacket& operator >> (int8& n1Data)    = 0;        //һint81ֽ޷
    virtual IBuffPacket& operator >> (int16& n2Data)   = 0;        //һint162ֽ޷
    virtual IBuffPacket& operator >> (int32& n8Data)   = 0;        //һint324ֽ޷
    virtual IBuffPacket& operator >> (float32& f4Data) = 0;        //һfloat324ֽС
    virtual IBuffPacket& operator >> (float64& f8Data) = 0;        //һfloat648ֽС

    virtual IBuffPacket& operator >> (VCHARS_STR& str) = 0;        //һһֽڳȵݿ飨1uint8ݳȺͺݿʵ壩
    virtual IBuffPacket& operator >> (VCHARM_STR& str) = 0;        //һһֽڳȵݿ飨1uint16ݳȺͺݿʵ壩
    virtual IBuffPacket& operator >> (VCHARB_STR& str) = 0;        //һһֽڳȵݿ飨1uint32ݳȺͺݿʵ壩
    virtual IBuffPacket& operator >> (string& str)     = 0;        //һstring

    //д
    virtual IBuffPacket& operator << (uint8 u1Data)    = 0;        //дһuint81ֽ޷
    virtual IBuffPacket& operator << (uint16 u2Data)   = 0;        //дһuint162ֽ޷
    virtual IBuffPacket& operator << (uint32 u4Data)   = 0;        //дһuint324ֽ޷
    virtual IBuffPacket& operator << (uint64 u8Data)   = 0;        //дһuint648ֽ޷
    virtual IBuffPacket& operator << (int8 u1Data)     = 0;        //дһint81ֽ޷
    virtual IBuffPacket& operator << (int16 u2Data)    = 0;        //дһint162ֽ޷
    virtual IBuffPacket& operator << (int32 u4Data)    = 0;        //дһint324ֽ޷

    virtual IBuffPacket& operator << (float32 f4Data)  = 0;        //дһfloat324ֽС
    virtual IBuffPacket& operator << (float64 f8Data)  = 0;        //дһfloat648ֽС

    virtual IBuffPacket& operator << (VCHARS_STR& str) = 0;        //дһһֽڳȵݿ飨1uint8ݳȺͺݿʵ壩
    virtual IBuffPacket& operator << (VCHARM_STR& str) = 0;        //дһһֽڳȵݿ飨1uint16ݳȺͺݿʵ壩
    virtual IBuffPacket& operator << (VCHARB_STR& str) = 0;        //дһһֽڳȵݿ飨1uint32ݳȺͺݿʵ壩
    virtual IBuffPacket& operator << (string& str)     = 0;        //дһstring
};

#endif
