#include "StdAfx.h"
#include "ClientUdpSocket.h"

CClientUdpSocket::CClientUdpSocket(void)
{
	m_pSocket_Info       = NULL;
	m_pSocket_State_Info = NULL;
	m_blRun              = false;
}

CClientUdpSocket::~CClientUdpSocket(void)
{
  Close();
}

void CClientUdpSocket::Close()
{
	if(NULL != m_pSocket_Info)
	{
		delete m_pSocket_Info;
		m_pSocket_Info = NULL;
	}

	if(NULL != m_pSocket_State_Info)
	{
		delete m_pSocket_State_Info;
		m_pSocket_State_Info = NULL;
	}
}

void CClientUdpSocket::Run()
{
	int nPacketCount = 1;
	m_blRun = true;
	SOCKET sckClient;
	SOCKET sckServer;

	//˲ΪLua
	//Ϊ˼ٲҪnewdeleteԲ
	_ParamData* pSendParam1   = NULL;
	_ParamData* pSendParam2   = NULL;
	_ParamData* pSendParam3   = NULL;
	_ParamData* pSendParam4   = NULL;
	_ParamData* pSendParamOut = NULL;
	_ParamData* pRecvParam1   = NULL;
	_ParamData* pRecvParam2   = NULL;
	_ParamData* pRecvParam3   = NULL;
	_ParamData* pRecvParam4   = NULL;
	_ParamData* pRecvParamOut = NULL;

	int nLuaBufferMaxLength = m_pSocket_Info->m_pLogic->GetSendLength();

	if(m_pSocket_Info == NULL || m_pSocket_State_Info == NULL)
	{
		m_blRun = false;
		return;
	}

	//Ǹ߼ģʽ
	if(m_pSocket_Info->m_blLuaAdvance == true)
	{
		m_objLuaFn.InitClass();

		bool blState = m_objLuaFn.LoadLuaFile(m_pSocket_Info->m_szLuaFileName);
		if(false == blState)
		{
			printf_s("[Main]Open Lua file error.\n");
			return;
		}

		//ʼҪʹõLua
		pSendParam1   = new _ParamData();
		pSendParam2   = new _ParamData();
		pSendParam3   = new _ParamData();
		pSendParam4   = new _ParamData();
		pSendParamOut = new _ParamData();
		pRecvParam1   = new _ParamData();
		pRecvParam2   = new _ParamData();
		pRecvParam3   = new _ParamData();
		pRecvParam4   = new _ParamData();
		pRecvParamOut = new _ParamData(); 

	}

	//ǷǳӣǳӣֻһΡ
	bool blIsConnect = false;

	//socket׼
	struct sockaddr_in svrsockaddr;

	memset(&svrsockaddr, 0, sizeof(SOCKADDR_IN));
	svrsockaddr.sin_family = AF_INET;
	svrsockaddr.sin_port   = htons(m_pSocket_Info->m_nPort);
	svrsockaddr.sin_addr.S_un.S_addr = inet_addr(m_pSocket_Info->m_szSerevrIP);

	sckClient = socket(AF_INET, SOCK_DGRAM, 0);

	DWORD TimeOut = (DWORD)m_pSocket_Info->m_nRecvTimeout;
	::setsockopt(sckClient, SOL_SOCKET, SO_RCVTIMEO, (char *)&TimeOut, sizeof(TimeOut));

	//ýռ˿
	sckServer = socket(AF_INET, SOCK_DGRAM, 0);

	struct sockaddr_in clientsockaddr;
	memset(&clientsockaddr, 0, sizeof(SOCKADDR_IN));
	clientsockaddr.sin_family = AF_INET;
	clientsockaddr.sin_port   = htons(m_pSocket_Info->m_nUdpClientPort);
	clientsockaddr.sin_addr.S_un.S_addr = inet_addr(m_pSocket_Info->m_szSerevrIP);

	bind(sckServer, (SOCKADDR *) &clientsockaddr, sizeof(clientsockaddr));

	//󶨷˿
	struct sockaddr_in clisockaddr;
	clisockaddr.sin_family = AF_INET;
	clisockaddr.sin_port = htons(m_pSocket_Info->m_nUdpClientPort);
	clisockaddr.sin_addr.s_addr = 0;
	bind(sckClient, (struct sockaddr*)&clisockaddr, sizeof(clisockaddr));

	//ʹ
	int nSendIndex = 0;

	while(m_blRun)
	{
		unsigned int tBegin = (unsigned int)GetTickCount();
		if(m_pSocket_Info->m_nSendCount != 0 && m_pSocket_State_Info->m_nSuccessSend >= m_pSocket_Info->m_nSendCount)
		{
			//ָĿݰ
			break;
		}

		//鿴Ƿ߼ģʽ
		if(m_pSocket_Info->m_blLuaAdvance == true)
		{
			//û󳤶
			m_pSocket_Info->m_pLogic->SetMaxSendLength(nLuaBufferMaxLength);

			//ʼLuaűȥ֯ݿ
			CParamGroup objIn;
			CParamGroup objOut;

			objIn.NeedRetrieve(false);
			objOut.NeedRetrieve(false);

			int nLuaSendLen = m_pSocket_Info->m_pLogic->GetSendLength();
			pSendParam1->SetParam((char* )m_pSocket_Info->m_pLogic->GetSendData(), "void", sizeof(int));
			pSendParam2->SetParam((char* )&nLuaSendLen, "int", sizeof(int));
			pSendParam3->SetParam((char* )&m_nThreadID, "int", sizeof(int));
			pSendParam4->SetParam((char* )&nSendIndex, "int", sizeof(int));

			int nSendLength = 0;
			pSendParamOut->SetParam((char* )&nSendLength, "int", sizeof(int));

			objIn.Push(pSendParam1);
			objIn.Push(pSendParam2);
			objIn.Push(pSendParam3);
			objIn.Push(pSendParam4);
			objOut.Push(pSendParamOut);

			m_objLuaFn.CallFileFn("PassTcp_CreateSendData", objIn, objOut);

			int* pLength = (int* )pSendParamOut->GetParam();
			m_pSocket_Info->m_pLogic->SetMaxSendLength((int)(*pLength));
		}


		if(blIsConnect == false)
		{
			DWORD dwSleepTime = (DWORD)m_pSocket_Info->m_nDelaySecond;
			if(m_pSocket_Info->m_blIsRadomaDelay == true)
			{
				//ģ1-1000֮һʱ
				dwSleepTime = (DWORD)RandomValue(1, 1000);
			}

			//ָʱ
			Sleep(dwSleepTime);

			m_pSocket_State_Info->m_nSuccessConnect++;
			m_pSocket_State_Info->m_nCurrectSocket = 1;
			blIsConnect = true;
		}

		if(blIsConnect == true)
		{
			//
			char szSendBuffData[MAX_BUFF_1024 * 100] = {'\0'};
			char szRecvBuffData[MAX_BUFF_1024 * 100] = {'\0'};

			char* pSendData   = NULL;
			int nSendLen      = 0;
			int nTotalRecvLen = 0;
			//Ϊݰ
			if(m_pSocket_Info->m_blIsSendCount == true)
			{
				int nSendCount = RandomValue(1, 10);

				//׷һ߼¼ǰǷƥ䣬ܳǰ
				if(m_pSocket_Info->m_nSendCount != 0 && nSendCount + m_pSocket_State_Info->m_nSuccessSend > m_pSocket_Info->m_nSendCount)
				{
					nSendCount = m_pSocket_Info->m_nSendCount - m_pSocket_State_Info->m_nSuccessSend;
				}

				char* pData = m_pSocket_Info->m_pLogic->GetSendData(m_pSocket_Info->m_nThreadID, nSendIndex, nSendLen);
				for(int i = 0; i < nSendCount; i++)
				{
					MEMCOPY_SAFE(&szSendBuffData[i * nSendLen], 
						pData, 
						nSendLen);
				}
				nPacketCount = nSendCount;

				//
				pSendData     = (char* )szSendBuffData;
				nSendLen      = m_pSocket_Info->m_pLogic->GetSendLength() * nSendCount;
				nTotalRecvLen = m_pSocket_Info->m_pLogic->GetSendLength() * nSendCount;
			}
			else
			{
				//
				pSendData     = (char* )m_pSocket_Info->m_pLogic->GetSendData(m_pSocket_Info->m_nThreadID, nSendIndex, nSendLen);
				nTotalRecvLen = m_pSocket_Info->m_pLogic->GetRecvLength();
			}

			//¼Ӧֽ
			int nRecvAllSize = nTotalRecvLen;

			//Ҫ¼־ݼ־
			if(m_pSocket_Info->m_blIsWriteFile == true)
			{
				WriteFile_SendBuff(pSendData, nSendLen);
			}

			int nTotalSendLen = nSendLen;
			int nBeginSend    = 0;
			int nCurrSendLen  = 0;
			bool blSendFlag   = false;
			int nBeginRecv    = 0;
			int nCurrRecvLen  = 0;
			bool blRecvFlag   = false;
			while(true)
			{
				//UDP
				int nssssSize = sizeof(SOCKADDR);
				nCurrSendLen = sendto(sckClient, pSendData + nBeginSend, nTotalSendLen, 0, (sockaddr* )&svrsockaddr, sizeof(SOCKADDR));
				if(nCurrSendLen <= 0)
				{
					DWORD dwError = GetLastError();
					WriteFile_Error("sendto error", (int)dwError);
					m_pSocket_State_Info->m_nFailSend += nPacketCount;
					m_pSocket_State_Info->m_nCurrectSocket = 0;
					blIsConnect = false;
					break;
				}
				else
				{
					nTotalSendLen -= nCurrSendLen;
					if(nTotalSendLen == 0)
					{
						//
						m_pSocket_State_Info->m_nSuccessSend += nPacketCount;
						blSendFlag = true;
						break;
					}
					else
					{
						nBeginSend += nCurrSendLen;
					}
				}
			}

			//
			if(blSendFlag == true && m_pSocket_Info->m_blIsRecv == true)
			{
				while(true)
				{
					//ͳɹˣ
					int nClientAddrSize = sizeof(SOCKADDR_IN);

					//socket׼
					struct sockaddr_in clientsockaddr1;
					/*
					struct sockaddr_in clientsockaddr;

					memset(&clientsockaddr, 0, sizeof(SOCKADDR_IN));
					clientsockaddr.sin_family = AF_INET;
					clientsockaddr.sin_port   = htons(20004);
					clientsockaddr.sin_addr.S_un.S_addr = inet_addr(m_pSocket_Info->m_szSerevrIP);
					*/

					nCurrRecvLen = recvfrom(sckServer, (char* )szRecvBuffData + nBeginRecv, nTotalRecvLen, 0, (sockaddr* )&clientsockaddr1, &nClientAddrSize);
					if(nCurrRecvLen <= 0)
					{
						DWORD dwError = GetLastError();
						WriteFile_Error("sendto error", (int)dwError);
						m_pSocket_State_Info->m_nFailRecv += nPacketCount;
						//closesocket(sckClient);
						m_pSocket_State_Info->m_nCurrectSocket = 0;
						blIsConnect = false;
						break;
					}
					else
					{
						//Ǹ߼ģʽLuaӿڷ
						if(m_pSocket_Info->m_blLuaAdvance == true)
						{
							m_pSocket_State_Info->m_nRecvByteCount += nCurrRecvLen;
							int nState = 0;

							CParamGroup objRecvIn;
							CParamGroup objRecvOut;

							objRecvIn.NeedRetrieve(false);
							objRecvOut.NeedRetrieve(false);

							pRecvParam1->SetParam((char* )szRecvBuffData, "void", sizeof(int));
							pRecvParam2->SetParam((char* )&nCurrRecvLen, "int", sizeof(int));
							pRecvParam3->SetParam((char* )&m_nThreadID, "int", sizeof(int));
							pRecvParam4->SetParam((char* )&nSendIndex, "int", sizeof(int));

							pRecvParamOut->SetParam((char* )&nState, "int", sizeof(int));

							objRecvIn.Push(pRecvParam1);
							objRecvIn.Push(pRecvParam2);
							objRecvIn.Push(pRecvParam3);
							objRecvIn.Push(pRecvParam4);
							objRecvOut.Push(pRecvParamOut);

							//ýպ
							m_objLuaFn.CallFileFn("PassTcp_GetRecvData", objRecvIn, objRecvOut);

							int* pReturn = (int* )pRecvParamOut->GetParam();
							nState = (int)(*pReturn);

							objRecvIn.Close(false);
							objRecvOut.Close(false);

							//жϽűֵ
							if(nState == 0)
							{
								//֤ɹ
								m_pSocket_State_Info->m_nSuccessRecv += nPacketCount;
								blRecvFlag = true;

								//Ҫ¼־ݼ־
								if(m_pSocket_Info->m_blIsWriteFile == true)
								{
									WriteFile_RecvBuff(szRecvBuffData, nRecvAllSize);
								}

								//Сʱʱ
								int tTime = (int)((unsigned int)GetTickCount() - tBegin);
								if(tTime > 0 && m_pSocket_State_Info->m_nMinRecvTime == 0)
								{
									m_pSocket_State_Info->m_nMinRecvTime = tTime;
								}
								else if(tTime < m_pSocket_State_Info->m_nMinRecvTime)
								{
									m_pSocket_State_Info->m_nMinRecvTime = tTime;
								}

								if(tTime > 0 && m_pSocket_State_Info->m_nMaxRecvTime == 0)
								{
									m_pSocket_State_Info->m_nMaxRecvTime = tTime;
								}
								else if(tTime > m_pSocket_State_Info->m_nMaxRecvTime)
								{
									m_pSocket_State_Info->m_nMaxRecvTime = tTime;
								}

								break;
							}
							else if(nState == 1)
							{
								//
								nBeginRecv += nCurrRecvLen;
							}
							else
							{
								//հ֤ʧ
								m_pSocket_State_Info->m_nFailRecv += nPacketCount;
								blRecvFlag = true;

								//Ҫ¼־ݼ־
								if(m_pSocket_Info->m_blIsWriteFile == true)
								{
									WriteFile_RecvBuff(szRecvBuffData, nRecvAllSize);
								}

								break;
							}
						}
						else
						{
							//Ǹ߼ģʽõж׼
							m_pSocket_State_Info->m_nRecvByteCount += nCurrRecvLen;
							nTotalRecvLen -= nCurrRecvLen;

							EM_DATA_RETURN_STATE emState = m_pSocket_Info->m_pLogic->GetRecvData(m_nThreadID, nSendLen, szRecvBuffData, nCurrRecvLen);
							if(emState == DATA_RETURN_STATE_SUCCESS)
							{
								//
								m_pSocket_State_Info->m_nSuccessRecv += nPacketCount;
								blRecvFlag = true;

								//Ҫ¼־ݼ־
								if(m_pSocket_Info->m_blIsWriteFile == true)
								{
									WriteFile_RecvBuff(szRecvBuffData, nRecvAllSize);
								}

								//Сʱʱ
								int tTime = (int)((unsigned int)GetTickCount() - tBegin);
								if(tTime > 0 && m_pSocket_State_Info->m_nMinRecvTime == 0)
								{
									m_pSocket_State_Info->m_nMinRecvTime = tTime;
								}
								else if(tTime < m_pSocket_State_Info->m_nMinRecvTime)
								{
									m_pSocket_State_Info->m_nMinRecvTime = tTime;
								}

								if(tTime > 0 && m_pSocket_State_Info->m_nMaxRecvTime == 0)
								{
									m_pSocket_State_Info->m_nMaxRecvTime = tTime;
								}
								else if(tTime > m_pSocket_State_Info->m_nMaxRecvTime)
								{
									m_pSocket_State_Info->m_nMaxRecvTime = tTime;
								}

								break;
							}
							else
							{
								nBeginRecv += nCurrRecvLen;
							}
						}
					}
				}
			}

			//ݰsleepָʱ
			if(m_pSocket_Info->m_nPacketTimewait > 0)
			{
				DWORD dwSleepTime = (DWORD)m_pSocket_Info->m_nPacketTimewait;
				Sleep(dwSleepTime);
			}

			//ǳӣ򲻹ر
			if(m_pSocket_Info->m_blIsAlwayConnect == false)
			{
				//closesocket(sckClient);
				m_pSocket_State_Info->m_nCurrectSocket = 0;
				blIsConnect = false;
			}
		}

		//ֻһΣ˳
		if(m_pSocket_Info->m_blIsSendOne == true)
		{
			m_blRun = false;
		}
	}

	//ûϣϿ
	closesocket(sckClient);
	closesocket(sckServer);
	m_pSocket_State_Info->m_nCurrectSocket = 0;
	blIsConnect = false;

	//еLuaڴ
	delete pSendParam1;
	delete pSendParam2;
	delete pSendParam3;
	delete pSendParam4;
	delete pSendParamOut;
	delete pRecvParam1;
	delete pRecvParam2;
	delete pRecvParam3;
	delete pRecvParam4;
	delete pRecvParamOut;
}

void CClientUdpSocket::Stop()
{
	m_blRun = false;
}

void CClientUdpSocket::SetSocketThread( _Socket_Info* pSocket_Info, _Socket_State_Info* pSocket_State_Info )
{
	Close();

	m_pSocket_Info       = pSocket_Info;
	m_pSocket_State_Info = pSocket_State_Info;
}

_Socket_State_Info* CClientUdpSocket::GetStateInfo()
{
	return m_pSocket_State_Info;
}

bool CClientUdpSocket::WriteFile_SendBuff( const char* pData, int nLen )
{
	FILE* pFile = NULL;
	char szFileName[20];
	sprintf_s(szFileName, "Thread%d.log", m_pSocket_Info->m_nThreadID);
	fopen_s(&pFile, szFileName, "a+");
	if(pFile == NULL)
	{
		return false;
	}

	string strLog;
	strLog = "[SendBuff]";

	for(int i = 0; i < nLen; i++)
	{
		char szChar[20];
		sprintf_s(szChar, 20, " 0x%02X", (unsigned char )pData[i]);
		strLog += szChar;
	}

	strLog += "\n";

	fwrite(strLog.c_str(), strLog.length(), sizeof(char), pFile);

	fclose(pFile);
	return true;
}

bool CClientUdpSocket::WriteFile_RecvBuff( const char* pData, int nLen )
{
	FILE* pFile = NULL;
	char szFileName[20];
	sprintf_s(szFileName, "Thread%d.log", m_pSocket_Info->m_nThreadID);
	fopen_s(&pFile, szFileName, "a+");
	if(pFile == NULL)
	{
		return false;
	}

	string strLog;
	strLog = "[RecvBuff]";

	for(int i = 0; i < nLen; i++)
	{
		char szChar[20];
		sprintf_s(szChar, 20, " 0x%02X", (unsigned char )pData[i]);
		strLog += szChar;
	}

	strLog += "\n";

	fwrite(strLog.c_str(), strLog.length(), sizeof(char), pFile);

	fclose(pFile);
	return true;
}

bool CClientUdpSocket::WriteFile_Error( const char* pError, int nErrorNumber )
{
	time_t ttNow    = time(NULL);
	struct tm tmNow;
	localtime_s(&tmNow, &ttNow);

	char szTimeNow[30] = {'\0'};
	sprintf_s(szTimeNow, 30, "[%04d-%02d-%02d %02d:%02d:%02d]", tmNow.tm_year + 1900, tmNow.tm_mon + 1, tmNow.tm_mday, tmNow.tm_hour, tmNow.tm_min, tmNow.tm_sec);

	//ƴӳ־
	char szError[1024] = {'\0'};
	sprintf_s(szError, 1024, "%s %s, errno=%d.\n", szTimeNow, pError, nErrorNumber);

	FILE* pFile = NULL;
	char szFileName[30];
	sprintf_s(szFileName, "StressTest_Error.log");
	fopen_s(&pFile, szFileName, "a+");
	if(pFile == NULL)
	{
		return false;
	}

	fwrite(szError, strlen(szError), sizeof(char), pFile);

	fclose(pFile);
	return true;
}

void CClientUdpSocket::SetThreadID( int nThreadID )
{
	m_nThreadID = nThreadID;
}