#pragma once

//ѽӶ
#include <winsock.h>
#include <Windows.h>
#include <vector>

using namespace std;

#define MAX_BUFF_50    50
#define MAX_BUFF_1024  1024

#define FUNC_SUCCESS          0      //ִгɹ
#define FUNC_FAIL_EXIST       -1     //Ѿ
#define FUNC_FAIL_NO_EXIST    -2     //Ӳ 
#define FUNC_SEND_ERROR       -3     //ʧ

#define INTVALID_SERVERID     -1     //ЧID

#define TIMER_EVENT_ID        1      //ʱϢID
#define TIMER_EVENT_INTERVAL  2000   //ʱʱ䣨λ룩
#define TCP_RECV_TIMEOUT      5000   //ݳʱʱ
#define TCP_RECV_SLEEP        1000   //ݼʱ

//ݵݸʽ
class CRecvData
{
public:
	virtual void RecvData(char* pRecvData, int nLen) = 0;
};

//TCPӶ
struct _TpClientInfo
{
	int        m_nServerID;             //ID
	char       m_szTpIP[MAX_BUFF_50];   //TCPIP
	int        m_nPort;                 //TCPĶ˿
	SOCKET     m_sckClient;             //Socket
	int        m_nState;                //0Ϊδӣ1Ϊ
	CRecvData* m_pRecvData;             //ݵĻص

	_TpClientInfo()
	{
		m_nServerID = INTVALID_SERVERID;
		m_szTpIP[0] = '\0';
		m_nPort     = 0;
		m_sckClient = INVALID_SOCKET;
		m_nState    = 0;
		m_pRecvData = NULL;
	}
};

class CTpClientManager
{
public:
	~CTpClientManager(void);

	static CTpClientManager& Instance()
	{
		//ʼTCP
		WSADATA wsaData;
		int nErr = WSAStartup(MAKEWORD(2, 2), &wsaData);
		if(nErr != 0)
		{
			//MessageBox(_T("socketʧܣ鱾socket汾"), _T("Ϣ"), MB_OK);
			printf_s("socketʧܣ鱾socket汾");
		}

		if(m_pTpClientManager == NULL)
		{
			m_pTpClientManager = new CTpClientManager();
		}

		return *m_pTpClientManager;
	}

	//Զ̷
	int TPClient_Connect(int nServerID, const char* pIP, int nPort, CRecvData* pRecvData = NULL);

	//رԶ̷
	int TPClient_DisConnect(int nServerID);

	//ر
	int TPClient_DisConnect_All();

	//ָӵ
	int TPClient_Send(int nServerID, const char* pBuff, int nLen);

	//һӵָ״̬
	int TPClient_ConnectState(int nServerID);

	//ԶĳһָServerID
	int TPClient_ReConnect(int nServerID);

	//ʱ¼ڴʱ
	int TPClient_HandleEvents(int nEventsID);

	//ʱ
	int TPClient_Run(bool blIsDebug = false);

	//н
	void Recv_All_Data();

	//ԶδӵĿͻ
	void Connect_All_Server();

	//Ƿʾdebug
	void SetDebug(bool blDebug);

private:
	CTpClientManager(void);
	typedef vector<_TpClientInfo> vecTpClientInfo;

	bool           IsFindTpClient(int nServerID);           //ѯָServerIDǷ
	_TpClientInfo* IsGetTpClient(int nServerID);            //ҵָServerID
	bool           DelTcpClient(int nServerID);             //ɾָServerID
	bool           DelTcpClient_All();                      //ɾеServerID

	int            ConnectToServer(_TpClientInfo& objTpClientInfo);    //Զ̷

private:
	static CTpClientManager* m_pTpClientManager;
	vecTpClientInfo          m_vecTpClientInfo;
	bool                     m_blDebug;
};
