# 在PSS中使用数据染色  
## 1.Trace功能的设计目的  
> 考虑到在实际使用中，我们经常遇到有些用户抱怨服务器响应速度慢。  
> 对于这些问题，运维一般是直接转手研发去处理。研发最多能做的也就是根据日志去分析用户行为。  
> 这种查找模式效率低下。从实际来讲，如果每个功能都追加日志，会整体拖慢程序的运行速度。  
> 尤其在高性能场景下，这种设计是有很大隐患的。   
> 但是，不加日志，当系统出了问题，就比较难排查。   
> 那么能不能在问题反映给运维的时候，由运维发起这种自我的检查呢？  
> 这就是我设计数据染色的目的，研发在实际插件开发过程中，在自己的代码关键地方埋入一些必要的"桩"。  
> 在正常运行过程中，"桩"不会记录任何东西（默认是关闭的），也不会影响程序的运行。  
> 当一些这类事件发生，运维可以通过后台工具唤醒这些"桩"，输出运行时间，执行代码位置，所在进程，线程等等信息。  
> "桩"的唤醒，依赖于一个key的生成，当一个key生成并输入到"桩"里面，"桩"就会执行记录代码。  
> 这样做，就能在最小代价下，为快速查找问题提供了一种方法。  
> 这些"桩"是可以跨进程，跨线程，甚至跨机器的。  
> 同一个key所走过的"桩"将会都写入到一个文件中。这些文件将会展现数据流的方向，位置，以及过程。  
> Trace.h是提供给插件使用的一组功能，包括三个宏组成  
> (1) CREATE_TRACE(x,y,z) 创建一个key, x是客户端IP,y是端口,z是当前信令ID(key是由48个字符组成的字符串)  
> (2) DO_TRACE(x,y) "桩"，这个代码可以加在插件代码里的任意地方，x是输出文件的路径，y是key，如果key为空，"桩"不做任何操作。  
> (3) SHOW_TRACE_ID(x) 展现一个key里面的所有信息，包括key的生成时间,IP,端口,进程ID,线程ID,信令ID  

## 2.Trace功能的使用
> 你可以在你需要的时候，生成一个key。这个可以在你的插件逻辑代码中决定。  
> 当你的key生成以后，只要在每个函数调用"桩"的地方输入这个key，"桩"就会执行记录。  
> 例如，你在插件的DoMessage()函数里面，接收到某一个指令，你可以  
> string strKey = CREATE_TRACE(Clinet.IP, Client.port, Client.Command);  
> 然后在你的一系列数据处理过程中，添加  
> DO_TRACE("./", strKey.c_str());  
> 在一些情况下，我们需要对数据进行运行时间的统计。  
> 你可以输出这个key的生成时间。  
> SHOW_TRACE_ID(strKey.c_str());  

## 3.运维如何使用PSS框架，动态数据染色？
> 根据以上原理，框架支持两种数据染色机制。  
> (1)针对某一个客户端IP来源的数据包进行染色。（需要指定染色的数据包总数，数据包从该指令下发候开始计算，达到总数既停止）  
> 具体方式是，在PSS_ClientManager或者Telnet下，调用SetTrackIP向PSS框架发出指令。[具体操作文档看这里](PSSFrameCommand.md)  
> (2)针对某个信令进行染色。（需要指定染色的数据包总数，数据包从该指令下发候开始计算，达到总数既停止）  
> 具体方式是，在PSS_ClientManager或者Telnet下，调用SetTrackIP向PSS框架发出指令。[具体操作文档看这里](PSSFrameCommand.md)  