# Programming Exercises

This is a list of exercises I took from the [playlist of python exercises](https://youtube.com/playlist?list=PLHz_AreHm4dm6wYOIW20Nyg12TAjmMGT-)
from [curso em video](https://www.cursoemvideo.com) by professor [gustavo guanabara](https://github.com/gustavoguanabara)

## List of Exercises

<ol>
	<li>
		<a href='001'>Create a program that writes 'Hello World!' on the screen.</a>
	</li>
	<li>
		<a href='002'>Make a program that reads a person's name and displays a welcome message.</a>
	</li>
	<li>
		<a href='003'>Create a program that reads two numbers and displays the sum between them.</a>
	</li>
	<li>
		<a href='004'>Make a program that reads something from the keyboard and displays its primitive type and all possible information about it on the screen.</a>
	</li>
	<li>
		<a href='005'>Make a program that reads an Integer and displays its successor and predecessor on the screen.</a>
	</li>
	<li>
		<a href='006'>Create an algorithm that reads a number and shows its double, triple and square root.</a>
	</li>
	<li>
		<a href='007'>Develop a program that reads a student's two grades, calculates and displays their average.</a>
	</li>
	<li>
		<a href='008'>Write a program that reads a value in meters and displays it converted to centimeters and millimeters.</a>
	</li>
	<li>
		<a href='009'>Make a program that reads any Integer and displays your times tables on the screen.</a>
	</li>
	<li>
		<a href='010'>Create a program that reads how much money a person has in their wallet and shows how many reals they can buy. Consider U$1.00 = R$3.27.</a>
	</li>
	<li>
		<a href='011'>Make a program that reads the width and height of a wall in meters, calculates its area and the amount of paint needed to paint it, knowing that each liter of paint paints an area of 2 square meters.</a>
	</li>
	<li>
		<a href='012'>Make an algorithm that reads the price of a product and shows its new price, with 5% off.</a>
	</li>
	<li>
		<a href='013'>Make an algorithm that reads an employee's salary and shows their new salary, with a 15% increase.</a>
	</li>
	<li>
		<a href='014'>Write a program that converts a temperature by typing in degrees Celsius and converts it to degrees Fahrenheit.</a>
	</li>
	<li>
		<a href='015'>Write a program that asks how many miles a rental car has traveled and how many days it has been rented. Calculate the price to pay, knowing that the car costs R$60 per day and R$0.15 per km driven.</a>
	</li>
	<li>
		<a href='016'>Create a program that reads any real number from the keyboard and displays its Iteger portion on the screen.</a>
	</li>
	<li>
		<a href='017'>Write a program that reads the length of the opposite side and the adjacent side of a right triangle. Calculate and show the length of the hypotenuse.</a>
	</li>
	<li>
		<a href='018'>Write a program that reads any angle and displays the sine, cosine and tangent value of that angle on the screen.</a>
	</li>
	<li>
		<a href='019'>A teacher wants to draw one of his four students to erase the board. Make a program that helps him by reading the names of the students and writing the name of the chosen one on the screen.</a>
	</li>
	<li>
		<a href='020'>The same teacher in challenge 019 wants to draw the order in which students' work is presented. Make a program that reads the names of the four students and shows the order drawn.</a>
	</li>
	<li>
		<a href='021'>Make a program that opens and plays audio from an MP3 file.</a>
	</li>
	<li>
		<a href='022'>Create a program that reads a person's full name and displays:</a>
		<br>- The name in all uppercase and lowercase letters.
		<br>- How many letters in all (not including spaces).
		<br>- How many letters is the first one Name.
	</li>
	<li>
		<a href='023'>Make a program that reads a number from 0 to 9999 and displays each of the separate digits on the screen.</a>
	</li>
	<li>
		<a href='024'>Create a program that reads the name of a city and says whether or not it starts with the name "SANTO".</a>
	</li>
	<li>
		<a href='025'>Create a program that reads a person's name and tells them if they have "SILVA" in their name.</a>
	</li>
	<li>
		<a href='026'>Make a program that reads a sentence from the keyboard and shows how many times the letter "A" appears, in which position it appears the first time, and in which position it appears the last time.</a>
	</li>
	<li>
		<a href='027'>Make a program that reads a person's full name, then showing the first and last name separately.</a>
		<br>Ex: Ana Maria de Souza (first = Ana; last = Souza).
	</li>
	<li>
		<a href='028'>Write a program that makes the computer "think" of an integer between 0 and 5 and ask the user to try to find out what the number chosen by the computer was. The program should write on the screen if the user won or lost.</a>
	</li>
	<li>
		<a href='029'>Write a program that reads the speed of a car. If he goes over 80km/h, show a message saying he was fined. The fine will cost R$7.00 for each km over the limit.</a>
	</li>
	<li>
		<a href='030'>Create a program that reads an integer and shows on the screen whether it is EVEN or ODD.</a>
	</li>
	<li>
		<a href='031'>Develop a program that asks the distance of a trip in Km. Calculate the ticket price, charging R$0.50 per Km for trips of up to 200Km and R$0.45 for longer trips.</a>
	</li>
	<li>
		<a href='032'>Make a program that reads any year and shows if it is a leap year.</a>
	</li>
	<li>
		<a href='033'>Make a program that reads three numbers and shows which is the largest and which is the smallest.</a>
	</li>
	<li>
		<a href='034'>Write a program that asks for an employee's salary and calculates the amount of his raise. For salaries above R$1250.00, calculate a 10% increase. For inferiors or equals, the increase is 15%.</a>
	</li>
	<li>
		<a href='035'>Develop a program that reads the length of three lines and tells the user whether or not they can form a triangle.</a>
	</li>
	<li>
		<a href='036'>Write a program to approve the bank loan for the purchase of a house. Ask the value of the house, the buyer's salary and in how many years he will pay. The monthly payment cannot exceed 30% of the salary or the loan will be denied.</a>
	</li>
	<li>
		<a href='037'>Write a Python program that reads any integer and ask the user to choose the base conversion: 1 to binary, 2 to octal, and 3 to hexadecimal.</a>
	</li>
	<li>
		<a href='038'>Write a program that reads two whole numbers and compares them. showing on the screen a message:</a>
		<br>- The first value is greater
		<br>- The second value is greater
		<br>- There is no greater value, the two are equal.
	</li>
	<li>
		<a href='039'>Make a program that reads a young person's year of birth and tells them, based on their age, whether they are still enlisting, whether it is the exact time to enlist, or whether it is past enlistment time. Your program should also show the time that is missing or past the deadline.</a>
	</li>
	<li>
		<a href='040'>Create a program that reads two grades from a student and calculates their average, showing a message at the end, according to the average achieved:</a>
		<br>- Average below 5.0
	</li>
	<li>
		<a href='041'>The National Swimming Confederation needs a program that reads the year of birth of an athlete and shows his category, according to age:</a>
		<br>- Up to 9 years old:
		<br>- Up to 9 years old: MIRIM
		<br>- Up to 14 years old: CHILDREN
		<br>- Up to 19 years old: JUNIOR
		<br>- Up to 25 years old: SENIOR
		<br>- Over 25 years old: MASTER
	</li>
	<li>
		<a href='042'>Redo CHALLENGE 035 of the triangles, adding the feature to show what kind of triangle will be formed:</a>
		<br>- EQUILATERO: all sides equal
		<br>- ISOSCELES: two sides equal, one different
		<br>- SCALENE: all sides different
	</li>
	<li>
		<a href='043'>Develop a logic that reads a person's weight and height, calculates their Body Mass Index (BMI) and shows their status, according to the table below:</a>
		<br>- BMI below 18.5: Underweight
		<br> - Between 18.5 and 25: Ideal Weight
		<br>- 25 to 30: Overweight
		<br>- 30 to 40: Obesity
		<br>- Over 40: Morbid Obesity
	</li>
	<li>
		<a href='044'>Develop a program that calculates the amount to be paid for a product, considering its normal price and payment terms:</a>
		<br>- cash/check: 10% discount
		<br>- cash on the card: 5% discount
		<br>- up to 2 installments on the card: formal price
		<br>- 3 installments or more on the card: 20% interest
	</li>
	<li>
		<a href='045'>Create a program that makes the computer play Jokenpo with you.</a>
	</li>
	<li>
		<a href='046'>Make a program that shows on screen a countdown to the fireworks burst, going from 10 to 0, with a 1 second pause between them.</a>
	</li>
	<li>
		<a href='047'>Create a program that displays on screen all the even numbers that are in the range between 1 and 50.</a>
	</li>
	<li>
		<a href='048'>Write a program that calculates the sum of all numbers that are multiples of three and that fall in the range of 1 to 500.</a>
	</li>
	<li>
		<a href='049'>Redo challenge 009, showing the times tables of a number that the user chooses, but now using a for loop.</a>
	</li>
	<li>
		<a href='050'>Develop a program that reads six whole numbers and shows the sum of only those that are even. If the value entered is odd, disregard it.</a>
	</li>
	<li>
		<a href='051'>Develop a program that reads the first term and reason of an AP. At the end, show the first 10 terms of this progression.</a>
	</li>
	<li>
		<a href='052'>Write a program that reads an integer and tells you whether or not it is a prime number.</a>
	</li>
	<li>
		<a href='053'>Create a program that reads any sentence and says if it is a palindrome, disregarding the spaces.</a>
		<br>Examples of palindromes: AFTER THE SOUP, THE BALCONY OF THE HOUSE, THE DEFEAT TOWER, THE WOLF LOVES CAKE, THEY WRITE DOWN THE DATE OF THE MARATHON.
	</li>
	<li>
		<a href='054'>Create a program that reads the birth year of seven people. At the end, show how many people are not yet of legal age and how many are of legal age.</a>
	</li>
	<li>
		<a href='055'>Make a program that reads the weight of five people. At the end, show which was the highest and lowest weight read.</a>
	</li>
	<li>
		<a href='056'>Develop a program that reads the name, age and gender of 4 people. At the end of the program, show: the average age of the group, what the oldest man's name is, and how many women are under 20 years old.</a>
	</li>
	<li>
		<a href='057'>Make a program that reads a person's gender, but only accepts 'M' or 'F' values. If wrong, ask to type again until you have a correct value.</a>
	</li>
	<li>
		<a href='058'>Improve the CHALLENGE 028 game where the computer will "think" on a number between 0 and 10. Only now the player will try to guess until right, showing at the end how many guesses were needed to win.</a>
	</li>
	<li>
		<a href='059'>Create a program that reads two values and displays a menu on the screen:</a>
		<br>[ 1 ] add
		<br>[ 2 ] multiply
		<br>[ 3 ] greater
		<br>[ 4 ] new numbers
		<br>[ 5 ] exit program
		<br>Your program must carry out the requested operation in each case.
	</li>
	<li>
		<a href='060'>Make a program that reads any number and displays its factorial.</a>
		<br>E.g: 5! = 5 x 4 x 3 x 2 x 1 = 120
	</li>
	<li>
		<a href='061'>Redo CHALLENGE 051, reading the first term and reason from an AP, showing the first 10 terms of the progression using the while structure.</a>
	</li>
	<li>
		<a href='062'>Improve CHALLENGE 061 by asking the user if he wants to show some more terms. The program will exit when it says it wants to show 0 terms.</a>
	</li>
	<li>
		<a href='063'>Write a program that reads any integer N and displays the first N elements of a Fibonacci Sequence on the screen.</a>
		<br>Ex: 0 - 1 - 1 - 2 - 3 - 5 - 8
	</li>
	<li>
		<a href='064'>Create a program that reads multiple integers from the keyboard. The program will only stop when the user enters the value 999, which is the stopping condition. At the end, show how many numbers were entered and what was the sum between them (disregarding the flag).</a>
	</li>
	<li>
		<a href='065'>Create a program that reads multiple integers from the keyboard. At the end of the run, show the average between all values and which were the highest and lowest values read. The program should ask the user whether or not he wants to continue entering values.</a>
	</li>
	<li>
		<a href='066'>Create a program that reads whole numbers from the keyboard. The program will only stop when the user enters the value 999, which is the stopping condition. At the end, show how many numbers were typed and what was the sum between them (disregarding the flag).</a>
	</li>
	<li>
		<a href='067'>Make a program that displays the times tables of several numbers, one at a time, for each value entered by the user. The program will stop when the requested number is negative.</a>
	</li>
	<li>
		<a href='068'>Make a program that plays even or odd with the computer. The game will only be stopped when the player loses, showing the total consecutive victories he has won at the end of the game.</a>
	</li>
	<li>
		<a href='069'>Create a program that reads the age and gender of various people. For each registered person, the program must ask whether the user wants to continue or not. At the end, show:</a>
		<br>A) how many people are over 18.
		<br>B) how many men have been registered.
		<br>C) how many women are under 20.
	</li>
	<li>
		<a href='070'>Create a program that reads the name and price of various products. The program should ask whether the user will continue or not. At the end, show:</a>
		<br>A) what is the total spent on the purchase.
		<br>B) how many products cost more than R$1000.
		<br>C) what is the name of the cheapest product.
	</li>
	<li>
		<a href='071'>Create a program that simulates the operation of an ATM. At the beginning, ask the user what will be the amount to be withdrawn (integer) and the program will inform how many bills of each amount will be delivered.</a>
		<br>NOTE: consider that the cashier has bills of BRL 50, BRL 20, BRL 10 and BRL $1.
	</li>
	<li>
		<a href='072'>Create a program that has a fully populated pair with a count in full, from zero to twenty. Your program should read a number from the keyboard (between 0 and 20) and display it in full.</a>
	</li>
	<li>
		<a href='073'>Create a tuple filled with the top 20 placed on the Brazilian Football Championship Table, in order of placement. Then show:</a>
		<br>a) Top 5 teams.
		<br>b) Last 4 placed.
		<br>c) Teams in alphabetical order. 
		<br>d) What position is the Chapecoense team in.
	</li>
	<li>
		<a href='074'>Create a program that will generate five random numbers and put them into a tuple. After that, show the list of generated numbers and also indicate the smallest and largest values that are in the tuple.</a>
	</li>
	<li>
		<a href='075'>Develop a program that reads four values from the keyboard and stores them in a tuple. At the end, show::</a>
		<br>A) How many times did the value 9.
		<br>B) In which position was typed the first value 3.
		<br>C) What were the even numbers.
	</li>
	<li>
		<a href='076'>Create a program that has a single tuple with product names and their prices, in sequence. At the end, show a price list, arranging the data in tabular form.</a>
	</li>
	<li>
		<a href='077'>Create a program that has a tuple with several words (don't use accents). After that, you should show, for each word, what your vowels are.</a>
	</li>
	<li>
		<a href='078'>Make a program that reads 5 numeric values and stores them in a list. At the end, show which was the highest and lowest value entered and their respective positions in the list.</a>
	</li>
	<li>
		<a href='079'>Create a program where the user can type several numerical values and register them in a list. If the number already exists inside, it will not be added. At the end, all the unique values entered will be displayed in ascending order.</a>
	</li>
	<li>
		<a href='080'>Create a program where the user can type five numerical values and register them in a list, already in the correct insertion position (without using sort()). At the end, show the ordered list on the screen.</a>
	</li>
	<li>
		<a href='081'>Create a program that will read multiple numbers and put them in a list. After that, show:</a>
		<br>A) How many numbers were entered.
		<br>B) The list of values, sorted in descending order.
		<br>C) Whether the value 5 was entered and is or is not in the list.
	</li>
	<li>
		<a href='082'>Create a program that will read multiple numbers and put them in a list. After that, create two extra lists that will contain only the even values and the odd values you typed, respectively. At the end, show the content of the three generated lists.</a>
	</li>
	<li>
		<a href='083'>Create a program where the user types any expression that uses parentheses. Your application should analyze whether the expression passed has open and closed parentheses in the correct order.</a>
	</li>
	<li>
		<a href='084'>Make a program that reads multiple people's names and weights, keeping everything in a list. At the end, show:</a>
		<br>A) How many people were registered.
		<br>B) A list with the heavier people.
		<br>C) A list with the lightest people.
	</li>
	<li>
		<a href='085'>Create a program where the user can type seven numeric values and enter them in a single list that keeps the odd and even values separate. At the end, show the odd and even values in ascending order.</a>
	</li>
	<li>
		<a href='086'>Create a program that declares a 3x3 dimensional array and fills it with keyboard-readable values. At the end, show the matrix on the screen, with the correct formatting.</a>
	</li>
	<li>
		<a href='087'>Enhance the previous challenge by showing at the end: </a>
		<br>A) The sum of all the even values entered.
		<br>B) The sum of the values in the third column.
		<br>C) The highest value in the second row.
	</li>
	<li>
		<a href='088'>Make a program that helps a MEGA SENA player to create guesses. The program will ask how many games will be generated and will draw 6 numbers between 1 and 60 for each game, registering everything in a composite list.</a>
	</li>
	<li>
		<a href='089'>Create a program that reads names and two grades from multiple students and saves them all in a composite list. At the end, show a report containing the average of each one and allow the user to show the grades of each individual student.</a>
	</li>
	<li>
		<a href='090'>Make a program that reads a student's name and average, also saving the situation in a dictionary. At the end, show the content of the structure on the screen.</a>
	</li>
	<li>
		<a href='091'>Create a program where 4 players roll a die and have random results. Store these results in a Python dictionary. At the end, put this dictionary in order, knowing that the winner rolled the highest number on the dice.</a>
	</li>
	<li>
		<a href='092'>Create a program that reads name, year of birth and work card and registers it (with age) in a dictionary. If by chance the CTPS is different from ZERO, the dictionary will also receive the year of employment and salary. Calculate and add, in addition to age, how old the person will retire at.</a>
	</li>
	<li>
		<a href='093'>Create a program that manages a football player's performance. The program will read the player's name and how many games he has played. Then it will read the number of goals scored in each match. In the end, all this will be stored in a dictionary, including the total goals scored during the championship.</a>
	</li>
	<li>
		<a href='094'>Create a program that reads the name, sex and age of multiple people, saving each person's data in a dictionary and all dictionaries in a list. At the end, show: </a>
		<br>A) How many people were registered
		<br>B) The average age
		<br>C) A list of women
		<br>D) A list of people above average age.
	</li>
	<li>
		<a href='095'>Enhance Challenge 93 to work with multiple players by including a system to view each player's achievement details.</a>
	</li>
	<li>
		<a href='096'>Make a program that has a function called area(), which receives the dimensions of a rectangular terrain (width and length) and shows the area of the terrain.</a>
	</li>
	<li>
		<a href='097'>Make a program that has a function called write(), which takes any text as a parameter and displays a message with adaptable size.</a>
		<br>Ex: 
		<br>write('Hello, World!')
		<br>Output:
		<br>~~~ ~~~~~~
		<br> Hello World!
		<br>~~~~~~~~~
	</li>
	<li>
		<a href='098'>Make a program that has a function called counter(), which takes three parameters: start, end and step. Your program has to perform three counts through the created function:</a>
		<br>a) from 1 to 10, from 1 to 1
		<br>b) from 10 to 0, from 2 to 2
		<br>c) a custom count
	</li>
	<li>
		<a href='099'>Write a program that has a function called larger(), which takes several integer-valued parameters. Your program has to analyze all the values and say which one is the biggest.</a>
	</li>
	<li>
		<a href='100'>Write a program that has a list called numbers and two functions called draw() and PaiSum(). The first function will draw 5 numbers and place them into the list and the second function will show the sum of all the even values drawn by the previous function.</a>
	</li>
	<li>
		<a href='101'>Create a program that has a function called vote() that will receive as a parameter the year of birth of a person, returning a literal value indicating whether a person has a DENIED, OPTIONAL and MANDATORY vote in elections.</a>
	</li>
	<li>
		<a href='102'>Create a program that has a factorial() function that receives two parameters: the first one indicating the number to calculate and the other called show, which will be a logical value (optional) indicating whether or not the factorial calculation process will be shown on the screen .</a>
	</li>
	<li>
		<a href='103'>Make a program that has a function called token(), which takes two optional parameters: a player's name and how many goals he scored. The program must be able to show the player's record, even if some data has not been entered correctly.</a>
	</li>
	<li>
		<a href='104'>Create a program that has the readInt() function, which will work similarly to the Python input() function, except that it validates to accept only a numeric value.</a>
		<br>Ex: n = readInt('Type one n: ')
	</li>
	<li>
		<a href='105'>Make a program that has a grades() function that can receive various grades from students and it will return a dictionary with the following information:</a>
		<br>- Number of grades
		<br>- Highest grade
		<br>- Lowest grade
		<br>- The class average
		<br>- The situation (optional)
		<br>Also add the docstrings of this function for query by the developer.
	</li>
	<li>
		<a href='106'>Make a mini-system that uses Python's Interactive Help. The user will type the command and the manual will appear. When the user enters the word 'END', the program will terminate. Important: use colors.</a>
	</li>
	<li>
		<a href='107'>Create a module called currency.py that has the built-in functions increase(), decrease(), double(), and half(). Also make a program that imports this module and uses some of these functions.</a>
	</li>
	<li>
		<a href='108'>Adapt the code from challenge #107 by creating an additional function called currency() that can display the numbers as a formatted monetary value.</a>
	</li>
	<li>
		<a href='109'>Modify the functions created in challenge 107 so that they accept one more parameter, informing whether or not the value returned by them will be formatted by the currency() function, developed in challenge 108.</a>
	</li>
	<li>
		<a href='110'>Add the currency.py module created in the previous challenges, a function called summary(), which shows on the screen some information generated by the functions we already have in the module created so far.</a>
	</li>
	<li>
		<a href='111'>Create a package called utilitiesCeV that has two built-in modules called currency and data. Transfer all the functions used in challenges 107, 108 and 109 to the first package and keep everything running.</a>
	</li>
	<li>
		<a href='112'>Within the utilitiesCeV package that we created in challenge 111, we have a module called data. Create a function called readMoney() that is able to work like the imput() function, but with a data validation to only accept values that are monetary.</a>
	</li>
	<li>
		<a href='113'>Rewrite the readInt() function we did in challenge 104, now including the possibility of entering a number of an invalid type. Enjoy and also create a readFloat() function with the same functionality.</a>
	</li>
	<li>
		<a href='114'>Create Python code that tests whether the pudding site is accessible by the computer being used.</a>
	</li>
	<li>
		<a href='115a'>Let's create a menu in Python, using modularization.</a>
	</li>
	<li>
		<a href='115b'>Let's see how to access files using Python.</a>
	</li>
	<li>
		<a href='115c'>Let's finish the file access project in Python.</a>
	</li>
</ol>
