# Contributing to _sockpp_

Thank you for your interest in the _sockpp_ library!

Contributions are accepted and much appreciated. You can contribute updates, bug fixes, and bug reports through the GitHub site for the project.

1. New and unstable development is done in the `develop` branch. Please make all pull requests against the `develop` branch.

1. Please follow the naming and format conventions of the existing code.

1. New features should be zero cost. Existing applications that do not use the feature(s) should not pay a cost in speed or size due to the new additions.

1. Prefer smaller, targeted pull requests (PR's). 
    1. Put each different new feature in a separate PR. 
    1. Separate bug fixes and new features in individual PR's.
 
1. Include unit tests for new features.
 
1. Please indicate the system, OS, and compiler used for development and whether there are any known incompatibilities with other supported systems.

1. Please only contribute code for which you have legal right to ownership. **Do not** contribute any code written at an employer site or on equipment ownd by an employer, if you have not been given explicit, written consent by the employer to contribute to open-source projects.
