const mongoose = require("mongoose");
// import { MongoMemoryServer } from 'mongodb-memory-server';
const { MongoMemoryServer } = require("mongodb-memory-server");

let mongod;

/**
 * Connect to the in-memory database.
 */
module.exports.connect = async () => {
  mongod = await MongoMemoryServer.create();
  const uri = await mongod.getUri();

  const mongooseOpts = {
    useNewUrlParser: true,
    autoReconnect: true,
    reconnectTries: Number.MAX_VALUE,
    reconnectInterval: 1000,
  };

  await mongoose.connect(uri, mongooseOpts);
};

/**
 * Drop database, close the connection and stop mongod.
 */
module.exports.closeDatabase = async () => {
  await mongoose.connection.dropDatabase();
  await mongoose.connection.close();
  await mongod.stop();
};

/**
 * Remove all the data for all db collections.
 */
module.exports.clearDatabase = async () => {
  // const { collections } = mongoose.connection;
  // for (const key in collections) {
  //   const collection = collections[key];
  //   await collection.deleteMany();
  // }
};
