(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define(factory) :
    (global = global || self, global.IntlRelativeFormat = factory());
}(this, function () { 'use strict';

    /*
    Copyright (c) 2014, Yahoo! Inc. All rights reserved.
    Copyrights licensed under the New BSD License.
    See the accompanying LICENSE file for terms.
    */

    /* jslint esnext: true */

    var hop = Object.prototype.hasOwnProperty;

    function extend(obj) {
        var sources = Array.prototype.slice.call(arguments, 1),
            i, len, source, key;

        for (i = 0, len = sources.length; i < len; i += 1) {
            source = sources[i];
            if (!source) { continue; }

            for (key in source) {
                if (hop.call(source, key)) {
                    obj[key] = source[key];
                }
            }
        }

        return obj;
    }

    /*
    Copyright (c) 2014, Yahoo! Inc. All rights reserved.
    Copyrights licensed under the New BSD License.
    See the accompanying LICENSE file for terms.
    */

    // Purposely using the same implementation as the Intl.js `Intl` polyfill.
    // Copyright 2013 Andy Earnshaw, MIT License

    var realDefineProp = (function () {
        try { return !!Object.defineProperty({}, 'a', {}); }
        catch (e) { return false; }
    })();

    var defineProperty = realDefineProp ? Object.defineProperty :
            function (obj, name, desc) {

        if ('get' in desc && obj.__defineGetter__) {
            obj.__defineGetter__(name, desc.get);
        } else if (!hop.call(obj, name) || 'value' in desc) {
            obj[name] = desc.value;
        }
    };

    var objCreate = Object.create || function (proto, props) {
        var obj, k;

        function F() {}
        F.prototype = proto;
        obj = new F();

        for (k in props) {
            if (hop.call(props, k)) {
                defineProperty(obj, k, props[k]);
            }
        }

        return obj;
    };

    /*
    Copyright (c) 2014, Yahoo! Inc. All rights reserved.
    Copyrights licensed under the New BSD License.
    See the accompanying LICENSE file for terms.
    */

    function Compiler(locales, formats, pluralFn) {
        this.locales  = locales;
        this.formats  = formats;
        this.pluralFn = pluralFn;
    }

    Compiler.prototype.compile = function (ast) {
        this.pluralStack        = [];
        this.currentPlural      = null;
        this.pluralNumberFormat = null;

        return this.compileMessage(ast);
    };

    Compiler.prototype.compileMessage = function (ast) {
        if (!(ast && ast.type === 'messageFormatPattern')) {
            throw new Error('Message AST is not of type: "messageFormatPattern"');
        }

        var elements = ast.elements,
            pattern  = [];

        var i, len, element;

        for (i = 0, len = elements.length; i < len; i += 1) {
            element = elements[i];

            switch (element.type) {
                case 'messageTextElement':
                    pattern.push(this.compileMessageText(element));
                    break;

                case 'argumentElement':
                    pattern.push(this.compileArgument(element));
                    break;

                default:
                    throw new Error('Message element does not have a valid type');
            }
        }

        return pattern;
    };

    Compiler.prototype.compileMessageText = function (element) {
        // When this `element` is part of plural sub-pattern and its value contains
        // an unescaped '#', use a `PluralOffsetString` helper to properly output
        // the number with the correct offset in the string.
        if (this.currentPlural && /(^|[^\\])#/g.test(element.value)) {
            // Create a cache a NumberFormat instance that can be reused for any
            // PluralOffsetString instance in this message.
            if (!this.pluralNumberFormat) {
                this.pluralNumberFormat = new Intl.NumberFormat(this.locales);
            }

            return new PluralOffsetString(
                    this.currentPlural.id,
                    this.currentPlural.format.offset,
                    this.pluralNumberFormat,
                    element.value);
        }

        // Unescape the escaped '#'s in the message text.
        return element.value.replace(/\\#/g, '#');
    };

    Compiler.prototype.compileArgument = function (element) {
        var format = element.format;

        if (!format) {
            return new StringFormat(element.id);
        }

        var formats  = this.formats,
            locales  = this.locales,
            pluralFn = this.pluralFn,
            options;

        switch (format.type) {
            case 'numberFormat':
                options = formats.number[format.style];
                return {
                    id    : element.id,
                    format: new Intl.NumberFormat(locales, options).format
                };

            case 'dateFormat':
                options = formats.date[format.style];
                return {
                    id    : element.id,
                    format: new Intl.DateTimeFormat(locales, options).format
                };

            case 'timeFormat':
                options = formats.time[format.style];
                return {
                    id    : element.id,
                    format: new Intl.DateTimeFormat(locales, options).format
                };

            case 'pluralFormat':
                options = this.compileOptions(element);
                return new PluralFormat(
                    element.id, format.ordinal, format.offset, options, pluralFn
                );

            case 'selectFormat':
                options = this.compileOptions(element);
                return new SelectFormat(element.id, options);

            default:
                throw new Error('Message element does not have a valid format type');
        }
    };

    Compiler.prototype.compileOptions = function (element) {
        var format      = element.format,
            options     = format.options,
            optionsHash = {};

        // Save the current plural element, if any, then set it to a new value when
        // compiling the options sub-patterns. This conforms the spec's algorithm
        // for handling `"#"` syntax in message text.
        this.pluralStack.push(this.currentPlural);
        this.currentPlural = format.type === 'pluralFormat' ? element : null;

        var i, len, option;

        for (i = 0, len = options.length; i < len; i += 1) {
            option = options[i];

            // Compile the sub-pattern and save it under the options's selector.
            optionsHash[option.selector] = this.compileMessage(option.value);
        }

        // Pop the plural stack to put back the original current plural value.
        this.currentPlural = this.pluralStack.pop();

        return optionsHash;
    };

    // -- Compiler Helper Classes --------------------------------------------------

    function StringFormat(id) {
        this.id = id;
    }

    StringFormat.prototype.format = function (value) {
        if (!value && typeof value !== 'number') {
            return '';
        }

        return typeof value === 'string' ? value : String(value);
    };

    function PluralFormat(id, useOrdinal, offset, options, pluralFn) {
        this.id         = id;
        this.useOrdinal = useOrdinal;
        this.offset     = offset;
        this.options    = options;
        this.pluralFn   = pluralFn;
    }

    PluralFormat.prototype.getOption = function (value) {
        var options = this.options;

        var option = options['=' + value] ||
                options[this.pluralFn(value - this.offset, this.useOrdinal)];

        return option || options.other;
    };

    function PluralOffsetString(id, offset, numberFormat, string) {
        this.id           = id;
        this.offset       = offset;
        this.numberFormat = numberFormat;
        this.string       = string;
    }

    PluralOffsetString.prototype.format = function (value) {
        var number = this.numberFormat.format(value - this.offset);

        return this.string
                .replace(/(^|[^\\])#/g, '$1' + number)
                .replace(/\\#/g, '#');
    };

    function SelectFormat(id, options) {
        this.id      = id;
        this.options = options;
    }

    SelectFormat.prototype.getOption = function (value) {
        var options = this.options;
        return options[value] || options.other;
    };

    var parser = (function() {

      /*
       * Generated by PEG.js 0.9.0.
       *
       * http://pegjs.org/
       */

      function peg$subclass(child, parent) {
        function ctor() { this.constructor = child; }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
      }

      function peg$SyntaxError(message, expected, found, location) {
        this.message  = message;
        this.expected = expected;
        this.found    = found;
        this.location = location;
        this.name     = "SyntaxError";

        if (typeof Error.captureStackTrace === "function") {
          Error.captureStackTrace(this, peg$SyntaxError);
        }
      }

      peg$subclass(peg$SyntaxError, Error);

      function peg$parse(input) {
        var options = arguments.length > 1 ? arguments[1] : {},
            peg$FAILED = {},

            peg$startRuleFunctions = { start: peg$parsestart },
            peg$startRuleFunction  = peg$parsestart,

            peg$c0 = function(elements) {
                    return {
                        type    : 'messageFormatPattern',
                        elements: elements,
                        location: location()
                    };
                },
            peg$c1 = function(text) {
                    var string = '',
                        i, j, outerLen, inner, innerLen;

                    for (i = 0, outerLen = text.length; i < outerLen; i += 1) {
                        inner = text[i];

                        for (j = 0, innerLen = inner.length; j < innerLen; j += 1) {
                            string += inner[j];
                        }
                    }

                    return string;
                },
            peg$c2 = function(messageText) {
                    return {
                        type : 'messageTextElement',
                        value: messageText,
                        location: location()
                    };
                },
            peg$c3 = /^[^ \t\n\r,.+={}#]/,
            peg$c4 = { type: "class", value: "[^ \\t\\n\\r,.+={}#]", description: "[^ \\t\\n\\r,.+={}#]" },
            peg$c5 = "{",
            peg$c6 = { type: "literal", value: "{", description: "\"{\"" },
            peg$c7 = ",",
            peg$c8 = { type: "literal", value: ",", description: "\",\"" },
            peg$c9 = "}",
            peg$c10 = { type: "literal", value: "}", description: "\"}\"" },
            peg$c11 = function(id, format) {
                    return {
                        type  : 'argumentElement',
                        id    : id,
                        format: format && format[2],
                        location: location()
                    };
                },
            peg$c12 = "number",
            peg$c13 = { type: "literal", value: "number", description: "\"number\"" },
            peg$c14 = "date",
            peg$c15 = { type: "literal", value: "date", description: "\"date\"" },
            peg$c16 = "time",
            peg$c17 = { type: "literal", value: "time", description: "\"time\"" },
            peg$c18 = function(type, style) {
                    return {
                        type : type + 'Format',
                        style: style && style[2],
                        location: location()
                    };
                },
            peg$c19 = "plural",
            peg$c20 = { type: "literal", value: "plural", description: "\"plural\"" },
            peg$c21 = function(pluralStyle) {
                    return {
                        type   : pluralStyle.type,
                        ordinal: false,
                        offset : pluralStyle.offset || 0,
                        options: pluralStyle.options,
                        location: location()
                    };
                },
            peg$c22 = "selectordinal",
            peg$c23 = { type: "literal", value: "selectordinal", description: "\"selectordinal\"" },
            peg$c24 = function(pluralStyle) {
                    return {
                        type   : pluralStyle.type,
                        ordinal: true,
                        offset : pluralStyle.offset || 0,
                        options: pluralStyle.options,
                        location: location()
                    }
                },
            peg$c25 = "select",
            peg$c26 = { type: "literal", value: "select", description: "\"select\"" },
            peg$c27 = function(options) {
                    return {
                        type   : 'selectFormat',
                        options: options,
                        location: location()
                    };
                },
            peg$c28 = "=",
            peg$c29 = { type: "literal", value: "=", description: "\"=\"" },
            peg$c30 = function(selector, pattern) {
                    return {
                        type    : 'optionalFormatPattern',
                        selector: selector,
                        value   : pattern,
                        location: location()
                    };
                },
            peg$c31 = "offset:",
            peg$c32 = { type: "literal", value: "offset:", description: "\"offset:\"" },
            peg$c33 = function(number) {
                    return number;
                },
            peg$c34 = function(offset, options) {
                    return {
                        type   : 'pluralFormat',
                        offset : offset,
                        options: options,
                        location: location()
                    };
                },
            peg$c35 = { type: "other", description: "whitespace" },
            peg$c36 = /^[ \t\n\r]/,
            peg$c37 = { type: "class", value: "[ \\t\\n\\r]", description: "[ \\t\\n\\r]" },
            peg$c38 = { type: "other", description: "optionalWhitespace" },
            peg$c39 = /^[0-9]/,
            peg$c40 = { type: "class", value: "[0-9]", description: "[0-9]" },
            peg$c41 = /^[0-9a-f]/i,
            peg$c42 = { type: "class", value: "[0-9a-f]i", description: "[0-9a-f]i" },
            peg$c43 = "0",
            peg$c44 = { type: "literal", value: "0", description: "\"0\"" },
            peg$c45 = /^[1-9]/,
            peg$c46 = { type: "class", value: "[1-9]", description: "[1-9]" },
            peg$c47 = function(digits) {
                return parseInt(digits, 10);
            },
            peg$c48 = /^[^{}\\\0-\x1F \t\n\r]/,
            peg$c49 = { type: "class", value: "[^{}\\\\\\0-\\x1F\\x7f \\t\\n\\r]", description: "[^{}\\\\\\0-\\x1F\\x7f \\t\\n\\r]" },
            peg$c50 = "\\\\",
            peg$c51 = { type: "literal", value: "\\\\", description: "\"\\\\\\\\\"" },
            peg$c52 = function() { return '\\'; },
            peg$c53 = "\\#",
            peg$c54 = { type: "literal", value: "\\#", description: "\"\\\\#\"" },
            peg$c55 = function() { return '\\#'; },
            peg$c56 = "\\{",
            peg$c57 = { type: "literal", value: "\\{", description: "\"\\\\{\"" },
            peg$c58 = function() { return '\u007B'; },
            peg$c59 = "\\}",
            peg$c60 = { type: "literal", value: "\\}", description: "\"\\\\}\"" },
            peg$c61 = function() { return '\u007D'; },
            peg$c62 = "\\u",
            peg$c63 = { type: "literal", value: "\\u", description: "\"\\\\u\"" },
            peg$c64 = function(digits) {
                    return String.fromCharCode(parseInt(digits, 16));
                },
            peg$c65 = function(chars) { return chars.join(''); },

            peg$currPos          = 0,
            peg$savedPos         = 0,
            peg$posDetailsCache  = [{ line: 1, column: 1, seenCR: false }],
            peg$maxFailPos       = 0,
            peg$maxFailExpected  = [],
            peg$silentFails      = 0,

            peg$result;

        if ("startRule" in options) {
          if (!(options.startRule in peg$startRuleFunctions)) {
            throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
          }

          peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
        }

        function location() {
          return peg$computeLocation(peg$savedPos, peg$currPos);
        }

        function peg$computePosDetails(pos) {
          var details = peg$posDetailsCache[pos],
              p, ch;

          if (details) {
            return details;
          } else {
            p = pos - 1;
            while (!peg$posDetailsCache[p]) {
              p--;
            }

            details = peg$posDetailsCache[p];
            details = {
              line:   details.line,
              column: details.column,
              seenCR: details.seenCR
            };

            while (p < pos) {
              ch = input.charAt(p);
              if (ch === "\n") {
                if (!details.seenCR) { details.line++; }
                details.column = 1;
                details.seenCR = false;
              } else if (ch === "\r" || ch === "\u2028" || ch === "\u2029") {
                details.line++;
                details.column = 1;
                details.seenCR = true;
              } else {
                details.column++;
                details.seenCR = false;
              }

              p++;
            }

            peg$posDetailsCache[pos] = details;
            return details;
          }
        }

        function peg$computeLocation(startPos, endPos) {
          var startPosDetails = peg$computePosDetails(startPos),
              endPosDetails   = peg$computePosDetails(endPos);

          return {
            start: {
              offset: startPos,
              line:   startPosDetails.line,
              column: startPosDetails.column
            },
            end: {
              offset: endPos,
              line:   endPosDetails.line,
              column: endPosDetails.column
            }
          };
        }

        function peg$fail(expected) {
          if (peg$currPos < peg$maxFailPos) { return; }

          if (peg$currPos > peg$maxFailPos) {
            peg$maxFailPos = peg$currPos;
            peg$maxFailExpected = [];
          }

          peg$maxFailExpected.push(expected);
        }

        function peg$buildException(message, expected, found, location) {
          function cleanupExpected(expected) {
            var i = 1;

            expected.sort(function(a, b) {
              if (a.description < b.description) {
                return -1;
              } else if (a.description > b.description) {
                return 1;
              } else {
                return 0;
              }
            });

            while (i < expected.length) {
              if (expected[i - 1] === expected[i]) {
                expected.splice(i, 1);
              } else {
                i++;
              }
            }
          }

          function buildMessage(expected, found) {
            function stringEscape(s) {
              function hex(ch) { return ch.charCodeAt(0).toString(16).toUpperCase(); }

              return s
                .replace(/\\/g,   '\\\\')
                .replace(/"/g,    '\\"')
                .replace(/\x08/g, '\\b')
                .replace(/\t/g,   '\\t')
                .replace(/\n/g,   '\\n')
                .replace(/\f/g,   '\\f')
                .replace(/\r/g,   '\\r')
                .replace(/[\x00-\x07\x0B\x0E\x0F]/g, function(ch) { return '\\x0' + hex(ch); })
                .replace(/[\x10-\x1F\x80-\xFF]/g,    function(ch) { return '\\x'  + hex(ch); })
                .replace(/[\u0100-\u0FFF]/g,         function(ch) { return '\\u0' + hex(ch); })
                .replace(/[\u1000-\uFFFF]/g,         function(ch) { return '\\u'  + hex(ch); });
            }

            var expectedDescs = new Array(expected.length),
                expectedDesc, foundDesc, i;

            for (i = 0; i < expected.length; i++) {
              expectedDescs[i] = expected[i].description;
            }

            expectedDesc = expected.length > 1
              ? expectedDescs.slice(0, -1).join(", ")
                  + " or "
                  + expectedDescs[expected.length - 1]
              : expectedDescs[0];

            foundDesc = found ? "\"" + stringEscape(found) + "\"" : "end of input";

            return "Expected " + expectedDesc + " but " + foundDesc + " found.";
          }

          if (expected !== null) {
            cleanupExpected(expected);
          }

          return new peg$SyntaxError(
            message !== null ? message : buildMessage(expected, found),
            expected,
            found,
            location
          );
        }

        function peg$parsestart() {
          var s0;

          s0 = peg$parsemessageFormatPattern();

          return s0;
        }

        function peg$parsemessageFormatPattern() {
          var s0, s1, s2;

          s0 = peg$currPos;
          s1 = [];
          s2 = peg$parsemessageFormatElement();
          while (s2 !== peg$FAILED) {
            s1.push(s2);
            s2 = peg$parsemessageFormatElement();
          }
          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c0(s1);
          }
          s0 = s1;

          return s0;
        }

        function peg$parsemessageFormatElement() {
          var s0;

          s0 = peg$parsemessageTextElement();
          if (s0 === peg$FAILED) {
            s0 = peg$parseargumentElement();
          }

          return s0;
        }

        function peg$parsemessageText() {
          var s0, s1, s2, s3, s4, s5;

          s0 = peg$currPos;
          s1 = [];
          s2 = peg$currPos;
          s3 = peg$parse_();
          if (s3 !== peg$FAILED) {
            s4 = peg$parsechars();
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                s3 = [s3, s4, s5];
                s2 = s3;
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
          if (s2 !== peg$FAILED) {
            while (s2 !== peg$FAILED) {
              s1.push(s2);
              s2 = peg$currPos;
              s3 = peg$parse_();
              if (s3 !== peg$FAILED) {
                s4 = peg$parsechars();
                if (s4 !== peg$FAILED) {
                  s5 = peg$parse_();
                  if (s5 !== peg$FAILED) {
                    s3 = [s3, s4, s5];
                    s2 = s3;
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            }
          } else {
            s1 = peg$FAILED;
          }
          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c1(s1);
          }
          s0 = s1;
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parsews();
            if (s1 !== peg$FAILED) {
              s0 = input.substring(s0, peg$currPos);
            } else {
              s0 = s1;
            }
          }

          return s0;
        }

        function peg$parsemessageTextElement() {
          var s0, s1;

          s0 = peg$currPos;
          s1 = peg$parsemessageText();
          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c2(s1);
          }
          s0 = s1;

          return s0;
        }

        function peg$parseargument() {
          var s0, s1, s2;

          s0 = peg$parsenumber();
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = [];
            if (peg$c3.test(input.charAt(peg$currPos))) {
              s2 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c4); }
            }
            if (s2 !== peg$FAILED) {
              while (s2 !== peg$FAILED) {
                s1.push(s2);
                if (peg$c3.test(input.charAt(peg$currPos))) {
                  s2 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s2 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c4); }
                }
              }
            } else {
              s1 = peg$FAILED;
            }
            if (s1 !== peg$FAILED) {
              s0 = input.substring(s0, peg$currPos);
            } else {
              s0 = s1;
            }
          }

          return s0;
        }

        function peg$parseargumentElement() {
          var s0, s1, s2, s3, s4, s5, s6, s7, s8;

          s0 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 123) {
            s1 = peg$c5;
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c6); }
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parse_();
            if (s2 !== peg$FAILED) {
              s3 = peg$parseargument();
              if (s3 !== peg$FAILED) {
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                  s5 = peg$currPos;
                  if (input.charCodeAt(peg$currPos) === 44) {
                    s6 = peg$c7;
                    peg$currPos++;
                  } else {
                    s6 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c8); }
                  }
                  if (s6 !== peg$FAILED) {
                    s7 = peg$parse_();
                    if (s7 !== peg$FAILED) {
                      s8 = peg$parseelementFormat();
                      if (s8 !== peg$FAILED) {
                        s6 = [s6, s7, s8];
                        s5 = s6;
                      } else {
                        peg$currPos = s5;
                        s5 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s5;
                      s5 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                  if (s5 === peg$FAILED) {
                    s5 = null;
                  }
                  if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 125) {
                        s7 = peg$c9;
                        peg$currPos++;
                      } else {
                        s7 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c10); }
                      }
                      if (s7 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c11(s3, s5);
                        s0 = s1;
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }

          return s0;
        }

        function peg$parseelementFormat() {
          var s0;

          s0 = peg$parsesimpleFormat();
          if (s0 === peg$FAILED) {
            s0 = peg$parsepluralFormat();
            if (s0 === peg$FAILED) {
              s0 = peg$parseselectOrdinalFormat();
              if (s0 === peg$FAILED) {
                s0 = peg$parseselectFormat();
              }
            }
          }

          return s0;
        }

        function peg$parsesimpleFormat() {
          var s0, s1, s2, s3, s4, s5, s6;

          s0 = peg$currPos;
          if (input.substr(peg$currPos, 6) === peg$c12) {
            s1 = peg$c12;
            peg$currPos += 6;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c13); }
          }
          if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 4) === peg$c14) {
              s1 = peg$c14;
              peg$currPos += 4;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c15); }
            }
            if (s1 === peg$FAILED) {
              if (input.substr(peg$currPos, 4) === peg$c16) {
                s1 = peg$c16;
                peg$currPos += 4;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c17); }
              }
            }
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parse_();
            if (s2 !== peg$FAILED) {
              s3 = peg$currPos;
              if (input.charCodeAt(peg$currPos) === 44) {
                s4 = peg$c7;
                peg$currPos++;
              } else {
                s4 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c8); }
              }
              if (s4 !== peg$FAILED) {
                s5 = peg$parse_();
                if (s5 !== peg$FAILED) {
                  s6 = peg$parsechars();
                  if (s6 !== peg$FAILED) {
                    s4 = [s4, s5, s6];
                    s3 = s4;
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
              if (s3 === peg$FAILED) {
                s3 = null;
              }
              if (s3 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c18(s1, s3);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }

          return s0;
        }

        function peg$parsepluralFormat() {
          var s0, s1, s2, s3, s4, s5;

          s0 = peg$currPos;
          if (input.substr(peg$currPos, 6) === peg$c19) {
            s1 = peg$c19;
            peg$currPos += 6;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c20); }
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parse_();
            if (s2 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 44) {
                s3 = peg$c7;
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c8); }
              }
              if (s3 !== peg$FAILED) {
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                  s5 = peg$parsepluralStyle();
                  if (s5 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c21(s5);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }

          return s0;
        }

        function peg$parseselectOrdinalFormat() {
          var s0, s1, s2, s3, s4, s5;

          s0 = peg$currPos;
          if (input.substr(peg$currPos, 13) === peg$c22) {
            s1 = peg$c22;
            peg$currPos += 13;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c23); }
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parse_();
            if (s2 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 44) {
                s3 = peg$c7;
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c8); }
              }
              if (s3 !== peg$FAILED) {
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                  s5 = peg$parsepluralStyle();
                  if (s5 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c24(s5);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }

          return s0;
        }

        function peg$parseselectFormat() {
          var s0, s1, s2, s3, s4, s5, s6;

          s0 = peg$currPos;
          if (input.substr(peg$currPos, 6) === peg$c25) {
            s1 = peg$c25;
            peg$currPos += 6;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c26); }
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parse_();
            if (s2 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 44) {
                s3 = peg$c7;
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c8); }
              }
              if (s3 !== peg$FAILED) {
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                  s5 = [];
                  s6 = peg$parseoptionalFormatPattern();
                  if (s6 !== peg$FAILED) {
                    while (s6 !== peg$FAILED) {
                      s5.push(s6);
                      s6 = peg$parseoptionalFormatPattern();
                    }
                  } else {
                    s5 = peg$FAILED;
                  }
                  if (s5 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c27(s5);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }

          return s0;
        }

        function peg$parseselector() {
          var s0, s1, s2, s3;

          s0 = peg$currPos;
          s1 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 61) {
            s2 = peg$c28;
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c29); }
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$parsenumber();
            if (s3 !== peg$FAILED) {
              s2 = [s2, s3];
              s1 = s2;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
          if (s1 !== peg$FAILED) {
            s0 = input.substring(s0, peg$currPos);
          } else {
            s0 = s1;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$parsechars();
          }

          return s0;
        }

        function peg$parseoptionalFormatPattern() {
          var s0, s1, s2, s3, s4, s5, s6, s7, s8;

          s0 = peg$currPos;
          s1 = peg$parse_();
          if (s1 !== peg$FAILED) {
            s2 = peg$parseselector();
            if (s2 !== peg$FAILED) {
              s3 = peg$parse_();
              if (s3 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 123) {
                  s4 = peg$c5;
                  peg$currPos++;
                } else {
                  s4 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c6); }
                }
                if (s4 !== peg$FAILED) {
                  s5 = peg$parse_();
                  if (s5 !== peg$FAILED) {
                    s6 = peg$parsemessageFormatPattern();
                    if (s6 !== peg$FAILED) {
                      s7 = peg$parse_();
                      if (s7 !== peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 125) {
                          s8 = peg$c9;
                          peg$currPos++;
                        } else {
                          s8 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c10); }
                        }
                        if (s8 !== peg$FAILED) {
                          peg$savedPos = s0;
                          s1 = peg$c30(s2, s6);
                          s0 = s1;
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }

          return s0;
        }

        function peg$parseoffset() {
          var s0, s1, s2, s3;

          s0 = peg$currPos;
          if (input.substr(peg$currPos, 7) === peg$c31) {
            s1 = peg$c31;
            peg$currPos += 7;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c32); }
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parse_();
            if (s2 !== peg$FAILED) {
              s3 = peg$parsenumber();
              if (s3 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c33(s3);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }

          return s0;
        }

        function peg$parsepluralStyle() {
          var s0, s1, s2, s3, s4;

          s0 = peg$currPos;
          s1 = peg$parseoffset();
          if (s1 === peg$FAILED) {
            s1 = null;
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parse_();
            if (s2 !== peg$FAILED) {
              s3 = [];
              s4 = peg$parseoptionalFormatPattern();
              if (s4 !== peg$FAILED) {
                while (s4 !== peg$FAILED) {
                  s3.push(s4);
                  s4 = peg$parseoptionalFormatPattern();
                }
              } else {
                s3 = peg$FAILED;
              }
              if (s3 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c34(s1, s3);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }

          return s0;
        }

        function peg$parsews() {
          var s0, s1;

          peg$silentFails++;
          s0 = [];
          if (peg$c36.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c37); }
          }
          if (s1 !== peg$FAILED) {
            while (s1 !== peg$FAILED) {
              s0.push(s1);
              if (peg$c36.test(input.charAt(peg$currPos))) {
                s1 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c37); }
              }
            }
          } else {
            s0 = peg$FAILED;
          }
          peg$silentFails--;
          if (s0 === peg$FAILED) {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c35); }
          }

          return s0;
        }

        function peg$parse_() {
          var s0, s1, s2;

          peg$silentFails++;
          s0 = peg$currPos;
          s1 = [];
          s2 = peg$parsews();
          while (s2 !== peg$FAILED) {
            s1.push(s2);
            s2 = peg$parsews();
          }
          if (s1 !== peg$FAILED) {
            s0 = input.substring(s0, peg$currPos);
          } else {
            s0 = s1;
          }
          peg$silentFails--;
          if (s0 === peg$FAILED) {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c38); }
          }

          return s0;
        }

        function peg$parsedigit() {
          var s0;

          if (peg$c39.test(input.charAt(peg$currPos))) {
            s0 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c40); }
          }

          return s0;
        }

        function peg$parsehexDigit() {
          var s0;

          if (peg$c41.test(input.charAt(peg$currPos))) {
            s0 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c42); }
          }

          return s0;
        }

        function peg$parsenumber() {
          var s0, s1, s2, s3, s4, s5;

          s0 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 48) {
            s1 = peg$c43;
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c44); }
          }
          if (s1 === peg$FAILED) {
            s1 = peg$currPos;
            s2 = peg$currPos;
            if (peg$c45.test(input.charAt(peg$currPos))) {
              s3 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c46); }
            }
            if (s3 !== peg$FAILED) {
              s4 = [];
              s5 = peg$parsedigit();
              while (s5 !== peg$FAILED) {
                s4.push(s5);
                s5 = peg$parsedigit();
              }
              if (s4 !== peg$FAILED) {
                s3 = [s3, s4];
                s2 = s3;
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
            if (s2 !== peg$FAILED) {
              s1 = input.substring(s1, peg$currPos);
            } else {
              s1 = s2;
            }
          }
          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c47(s1);
          }
          s0 = s1;

          return s0;
        }

        function peg$parsechar() {
          var s0, s1, s2, s3, s4, s5, s6, s7;

          if (peg$c48.test(input.charAt(peg$currPos))) {
            s0 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c49); }
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 2) === peg$c50) {
              s1 = peg$c50;
              peg$currPos += 2;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c51); }
            }
            if (s1 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c52();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              if (input.substr(peg$currPos, 2) === peg$c53) {
                s1 = peg$c53;
                peg$currPos += 2;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c54); }
              }
              if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c55();
              }
              s0 = s1;
              if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.substr(peg$currPos, 2) === peg$c56) {
                  s1 = peg$c56;
                  peg$currPos += 2;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c57); }
                }
                if (s1 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c58();
                }
                s0 = s1;
                if (s0 === peg$FAILED) {
                  s0 = peg$currPos;
                  if (input.substr(peg$currPos, 2) === peg$c59) {
                    s1 = peg$c59;
                    peg$currPos += 2;
                  } else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c60); }
                  }
                  if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c61();
                  }
                  s0 = s1;
                  if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    if (input.substr(peg$currPos, 2) === peg$c62) {
                      s1 = peg$c62;
                      peg$currPos += 2;
                    } else {
                      s1 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c63); }
                    }
                    if (s1 !== peg$FAILED) {
                      s2 = peg$currPos;
                      s3 = peg$currPos;
                      s4 = peg$parsehexDigit();
                      if (s4 !== peg$FAILED) {
                        s5 = peg$parsehexDigit();
                        if (s5 !== peg$FAILED) {
                          s6 = peg$parsehexDigit();
                          if (s6 !== peg$FAILED) {
                            s7 = peg$parsehexDigit();
                            if (s7 !== peg$FAILED) {
                              s4 = [s4, s5, s6, s7];
                              s3 = s4;
                            } else {
                              peg$currPos = s3;
                              s3 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s3;
                          s3 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                      }
                      if (s3 !== peg$FAILED) {
                        s2 = input.substring(s2, peg$currPos);
                      } else {
                        s2 = s3;
                      }
                      if (s2 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c64(s2);
                        s0 = s1;
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  }
                }
              }
            }
          }

          return s0;
        }

        function peg$parsechars() {
          var s0, s1, s2;

          s0 = peg$currPos;
          s1 = [];
          s2 = peg$parsechar();
          if (s2 !== peg$FAILED) {
            while (s2 !== peg$FAILED) {
              s1.push(s2);
              s2 = peg$parsechar();
            }
          } else {
            s1 = peg$FAILED;
          }
          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c65(s1);
          }
          s0 = s1;

          return s0;
        }

        peg$result = peg$startRuleFunction();

        if (peg$result !== peg$FAILED && peg$currPos === input.length) {
          return peg$result;
        } else {
          if (peg$result !== peg$FAILED && peg$currPos < input.length) {
            peg$fail({ type: "end", description: "end of input" });
          }

          throw peg$buildException(
            null,
            peg$maxFailExpected,
            peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
            peg$maxFailPos < input.length
              ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
              : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
          );
        }
      }

      return {
        SyntaxError: peg$SyntaxError,
        parse:       peg$parse
      };
    })();

    /*
    Copyright (c) 2014, Yahoo! Inc. All rights reserved.
    Copyrights licensed under the New BSD License.
    See the accompanying LICENSE file for terms.
    */

    // -- MessageFormat --------------------------------------------------------

    function MessageFormat(message, locales, formats) {
        // Parse string messages into an AST.
        var ast = typeof message === 'string' ?
                MessageFormat.__parse(message) : message;

        if (!(ast && ast.type === 'messageFormatPattern')) {
            throw new TypeError('A message must be provided as a String or AST.');
        }

        // Creates a new object with the specified `formats` merged with the default
        // formats.
        formats = this._mergeFormats(MessageFormat.formats, formats);

        // Defined first because it's used to build the format pattern.
        defineProperty(this, '_locale',  {value: this._resolveLocale(locales)});

        // Compile the `ast` to a pattern that is highly optimized for repeated
        // `format()` invocations. **Note:** This passes the `locales` set provided
        // to the constructor instead of just the resolved locale.
        var pluralFn = this._findPluralRuleFunction(this._locale);
        var pattern  = this._compilePattern(ast, locales, formats, pluralFn);

        // "Bind" `format()` method to `this` so it can be passed by reference like
        // the other `Intl` APIs.
        var messageFormat = this;
        this.format = function (values) {
          try {
            return messageFormat._format(pattern, values);
          } catch (e) {
            if (e.variableId) {
              throw new Error(
                'The intl string context variable \'' + e.variableId + '\'' +
                ' was not provided to the string \'' + message + '\''
              );
            } else {
              throw e;
            }
          }
        };
    }

    // Default format options used as the prototype of the `formats` provided to the
    // constructor. These are used when constructing the internal Intl.NumberFormat
    // and Intl.DateTimeFormat instances.
    defineProperty(MessageFormat, 'formats', {
        enumerable: true,

        value: {
            number: {
                'currency': {
                    style: 'currency'
                },

                'percent': {
                    style: 'percent'
                }
            },

            date: {
                'short': {
                    month: 'numeric',
                    day  : 'numeric',
                    year : '2-digit'
                },

                'medium': {
                    month: 'short',
                    day  : 'numeric',
                    year : 'numeric'
                },

                'long': {
                    month: 'long',
                    day  : 'numeric',
                    year : 'numeric'
                },

                'full': {
                    weekday: 'long',
                    month  : 'long',
                    day    : 'numeric',
                    year   : 'numeric'
                }
            },

            time: {
                'short': {
                    hour  : 'numeric',
                    minute: 'numeric'
                },

                'medium':  {
                    hour  : 'numeric',
                    minute: 'numeric',
                    second: 'numeric'
                },

                'long': {
                    hour        : 'numeric',
                    minute      : 'numeric',
                    second      : 'numeric',
                    timeZoneName: 'short'
                },

                'full': {
                    hour        : 'numeric',
                    minute      : 'numeric',
                    second      : 'numeric',
                    timeZoneName: 'short'
                }
            }
        }
    });

    // Define internal private properties for dealing with locale data.
    defineProperty(MessageFormat, '__localeData__', {value: objCreate(null)});
    defineProperty(MessageFormat, '__addLocaleData', {value: function (data) {
        if (!(data && data.locale)) {
            throw new Error(
                'Locale data provided to IntlMessageFormat is missing a ' +
                '`locale` property'
            );
        }

        MessageFormat.__localeData__[data.locale.toLowerCase()] = data;
    }});

    // Defines `__parse()` static method as an exposed private.
    defineProperty(MessageFormat, '__parse', {value: parser.parse});

    // Define public `defaultLocale` property which defaults to English, but can be
    // set by the developer.
    defineProperty(MessageFormat, 'defaultLocale', {
        enumerable: true,
        writable  : true,
        value     : undefined
    });

    MessageFormat.prototype.resolvedOptions = function () {
        // TODO: Provide anything else?
        return {
            locale: this._locale
        };
    };

    MessageFormat.prototype._compilePattern = function (ast, locales, formats, pluralFn) {
        var compiler = new Compiler(locales, formats, pluralFn);
        return compiler.compile(ast);
    };

    MessageFormat.prototype._findPluralRuleFunction = function (locale) {
        var localeData = MessageFormat.__localeData__;
        var data       = localeData[locale.toLowerCase()];

        // The locale data is de-duplicated, so we have to traverse the locale's
        // hierarchy until we find a `pluralRuleFunction` to return.
        while (data) {
            if (data.pluralRuleFunction) {
                return data.pluralRuleFunction;
            }

            data = data.parentLocale && localeData[data.parentLocale.toLowerCase()];
        }

        throw new Error(
            'Locale data added to IntlMessageFormat is missing a ' +
            '`pluralRuleFunction` for :' + locale
        );
    };

    MessageFormat.prototype._format = function (pattern, values) {
        var result = '',
            i, len, part, id, value, err;

        for (i = 0, len = pattern.length; i < len; i += 1) {
            part = pattern[i];

            // Exist early for string parts.
            if (typeof part === 'string') {
                result += part;
                continue;
            }

            id = part.id;

            // Enforce that all required values are provided by the caller.
            if (!(values && hop.call(values, id))) {
              err = new Error('A value must be provided for: ' + id);
              err.variableId = id;
              throw err;
            }

            value = values[id];

            // Recursively format plural and select parts' option — which can be a
            // nested pattern structure. The choosing of the option to use is
            // abstracted-by and delegated-to the part helper object.
            if (part.options) {
                result += this._format(part.getOption(value), values);
            } else {
                result += part.format(value);
            }
        }

        return result;
    };

    MessageFormat.prototype._mergeFormats = function (defaults, formats) {
        var mergedFormats = {},
            type, mergedType;

        for (type in defaults) {
            if (!hop.call(defaults, type)) { continue; }

            mergedFormats[type] = mergedType = objCreate(defaults[type]);

            if (formats && hop.call(formats, type)) {
                extend(mergedType, formats[type]);
            }
        }

        return mergedFormats;
    };

    MessageFormat.prototype._resolveLocale = function (locales) {
        if (typeof locales === 'string') {
            locales = [locales];
        }

        // Create a copy of the array so we can push on the default locale.
        locales = (locales || []).concat(MessageFormat.defaultLocale);

        var localeData = MessageFormat.__localeData__;
        var i, len, localeParts, data;

        // Using the set of locales + the default locale, we look for the first one
        // which that has been registered. When data does not exist for a locale, we
        // traverse its ancestors to find something that's been registered within
        // its hierarchy of locales. Since we lack the proper `parentLocale` data
        // here, we must take a naive approach to traversal.
        for (i = 0, len = locales.length; i < len; i += 1) {
            localeParts = locales[i].toLowerCase().split('-');

            while (localeParts.length) {
                data = localeData[localeParts.join('-')];
                if (data) {
                    // Return the normalized locale string; e.g., we return "en-US",
                    // instead of "en-us".
                    return data.locale;
                }

                localeParts.pop();
            }
        }

        var defaultLocale = locales.pop();
        throw new Error(
            'No locale data has been added to IntlMessageFormat for: ' +
            locales.join(', ') + ', or the default locale: ' + defaultLocale
        );
    };

    // GENERATED FILE
    var defaultLocale = {"locale":"en","pluralRuleFunction":function (n,ord){var s=String(n).split("."),v0=!s[1],t0=Number(s[0])==n,n10=t0&&s[0].slice(-1),n100=t0&&s[0].slice(-2);if(ord)return n10==1&&n100!=11?"one":n10==2&&n100!=12?"two":n10==3&&n100!=13?"few":"other";return n==1&&v0?"one":"other"}};

    /* jslint esnext: true */

    MessageFormat.__addLocaleData(defaultLocale);
    MessageFormat.defaultLocale = 'en';

    /*
    Copyright (c) 2014, Yahoo! Inc. All rights reserved.
    Copyrights licensed under the New BSD License.
    See the accompanying LICENSE file for terms.
    */

    /* jslint esnext: true */

    var round = Math.round;

    function daysToYears(days) {
        // 400 years have 146097 days (taking into account leap year rules)
        return days * 400 / 146097;
    }

    function diff (from, to) {
        // Convert to ms timestamps.
        from = +from;
        to   = +to;

        var millisecond = round(to - from),
            second      = round(millisecond / 1000),
            minute      = round(second / 60),
            hour        = round(minute / 60),
            day         = round(hour / 24),
            week        = round(day / 7);

        var rawYears = daysToYears(day),
            month    = round(rawYears * 12),
            year     = round(rawYears);

        return {
            millisecond    : millisecond,
            second         : second,
            'second-short' : second,
            minute         : minute,
            'minute-short' : minute,
            hour           : hour,
            'hour-short'   : hour,
            day            : day,
            'day-short'    : day,
            week           : week,
            'week-short'   : week,
            month          : month,
            'month-short'  : month,
            year           : year,
            'year-short'   : year
        };
    }

    /*
    Copyright (c) 2014, Yahoo! Inc. All rights reserved.
    Copyrights licensed under the New BSD License.
    See the accompanying LICENSE file for terms.
    */

    /* jslint esnext: true */

    // Purposely using the same implementation as the Intl.js `Intl` polyfill.
    // Copyright 2013 Andy Earnshaw, MIT License

    var hop$1 = Object.prototype.hasOwnProperty;
    var toString = Object.prototype.toString;

    var realDefineProp$1 = (function () {
        try { return !!Object.defineProperty({}, 'a', {}); }
        catch (e) { return false; }
    })();

    var defineProperty$1 = realDefineProp$1 ? Object.defineProperty :
            function (obj, name, desc) {

        if ('get' in desc && obj.__defineGetter__) {
            obj.__defineGetter__(name, desc.get);
        } else if (!hop$1.call(obj, name) || 'value' in desc) {
            obj[name] = desc.value;
        }
    };

    var objCreate$1 = Object.create || function (proto, props) {
        var obj, k;

        function F() {}
        F.prototype = proto;
        obj = new F();

        for (k in props) {
            if (hop$1.call(props, k)) {
                defineProperty$1(obj, k, props[k]);
            }
        }

        return obj;
    };

    var arrIndexOf = Array.prototype.indexOf || function (search, fromIndex) {
        /*jshint validthis:true */
        var arr = this;
        if (!arr.length) {
            return -1;
        }

        for (var i = fromIndex || 0, max = arr.length; i < max; i++) {
            if (arr[i] === search) {
                return i;
            }
        }

        return -1;
    };

    var isArray = Array.isArray || function (obj) {
        return toString.call(obj) === '[object Array]';
    };

    var dateNow = Date.now || function () {
        return new Date().getTime();
    };

    /*
    Copyright (c) 2014, Yahoo! Inc. All rights reserved.
    Copyrights licensed under the New BSD License.
    See the accompanying LICENSE file for terms.
    */

    // -----------------------------------------------------------------------------

    var FIELDS = [
        'second', 'second-short',
        'minute', 'minute-short',
        'hour', 'hour-short',
        'day', 'day-short',
        'month', 'month-short',
        'year', 'year-short'
    ];
    var STYLES = ['best fit', 'numeric'];

    // -- RelativeFormat -----------------------------------------------------------

    function RelativeFormat(locales, options) {
        options = options || {};

        // Make a copy of `locales` if it's an array, so that it doesn't change
        // since it's used lazily.
        if (isArray(locales)) {
            locales = locales.concat();
        }

        defineProperty$1(this, '_locale', {value: this._resolveLocale(locales)});
        defineProperty$1(this, '_options', {value: {
            style: this._resolveStyle(options.style),
            units: this._isValidUnits(options.units) && options.units
        }});

        defineProperty$1(this, '_locales', {value: locales});
        defineProperty$1(this, '_fields', {value: this._findFields(this._locale)});
        defineProperty$1(this, '_messages', {value: objCreate$1(null)});

        // "Bind" `format()` method to `this` so it can be passed by reference like
        // the other `Intl` APIs.
        var relativeFormat = this;
        this.format = function format(date, options) {
            return relativeFormat._format(date, options);
        };
    }

    // Define internal private properties for dealing with locale data.
    defineProperty$1(RelativeFormat, '__localeData__', {value: objCreate$1(null)});
    defineProperty$1(RelativeFormat, '__addLocaleData', {value: function () {
        for (var i = 0; i < arguments.length; i++) {
            var datum = arguments[i];
            if (!(datum && datum.locale)) {
                throw new Error(
                    'Locale data provided to IntlRelativeFormat is missing a ' +
                    '`locale` property value'
                );
            }
        
            RelativeFormat.__localeData__[datum.locale.toLowerCase()] = datum;
        
            // Add data to IntlMessageFormat.
            MessageFormat.__addLocaleData(datum);
        }
    }});

    // Define public `defaultLocale` property which can be set by the developer, or
    // it will be set when the first RelativeFormat instance is created by
    // leveraging the resolved locale from `Intl`.
    defineProperty$1(RelativeFormat, 'defaultLocale', {
        enumerable: true,
        writable  : true,
        value     : undefined
    });

    // Define public `thresholds` property which can be set by the developer, and
    // defaults to relative time thresholds from moment.js.
    defineProperty$1(RelativeFormat, 'thresholds', {
        enumerable: true,

        value: {
            second: 45, 'second-short': 45,  // seconds to minute
            minute: 45, 'minute-short': 45, // minutes to hour
            hour  : 22, 'hour-short': 22, // hours to day
            day   : 26, 'day-short': 26, // days to month
            month : 11, 'month-short': 11 // months to year
        }
    });

    RelativeFormat.prototype.resolvedOptions = function () {
        return {
            locale: this._locale,
            style : this._options.style,
            units : this._options.units
        };
    };

    RelativeFormat.prototype._compileMessage = function (units) {
        // `this._locales` is the original set of locales the user specified to the
        // constructor, while `this._locale` is the resolved root locale.
        var locales        = this._locales;
        var resolvedLocale = this._locale;

        var field        = this._fields[units];
        var relativeTime = field.relativeTime;
        var future       = '';
        var past         = '';
        var i;

        for (i in relativeTime.future) {
            if (relativeTime.future.hasOwnProperty(i)) {
                future += ' ' + i + ' {' +
                    relativeTime.future[i].replace('{0}', '#') + '}';
            }
        }

        for (i in relativeTime.past) {
            if (relativeTime.past.hasOwnProperty(i)) {
                past += ' ' + i + ' {' +
                    relativeTime.past[i].replace('{0}', '#') + '}';
            }
        }

        var message = '{when, select, future {{0, plural, ' + future + '}}' +
                                     'past {{0, plural, ' + past + '}}}';

        // Create the synthetic IntlMessageFormat instance using the original
        // locales value specified by the user when constructing the the parent
        // IntlRelativeFormat instance.
        return new MessageFormat(message, locales);
    };

    RelativeFormat.prototype._getMessage = function (units) {
        var messages = this._messages;

        // Create a new synthetic message based on the locale data from CLDR.
        if (!messages[units]) {
            messages[units] = this._compileMessage(units);
        }

        return messages[units];
    };

    RelativeFormat.prototype._getRelativeUnits = function (diff, units) {
        var field = this._fields[units];

        if (field.relative) {
            return field.relative[diff];
        }
    };

    RelativeFormat.prototype._findFields = function (locale) {
        var localeData = RelativeFormat.__localeData__;
        var data       = localeData[locale.toLowerCase()];

        // The locale data is de-duplicated, so we have to traverse the locale's
        // hierarchy until we find `fields` to return.
        while (data) {
            if (data.fields) {
                return data.fields;
            }

            data = data.parentLocale && localeData[data.parentLocale.toLowerCase()];
        }

        throw new Error(
            'Locale data added to IntlRelativeFormat is missing `fields` for :' +
            locale
        );
    };

    RelativeFormat.prototype._format = function (date, options) {
        var now = options && options.now !== undefined ? options.now : dateNow();

        if (date === undefined) {
            date = now;
        }

        // Determine if the `date` and optional `now` values are valid, and throw a
        // similar error to what `Intl.DateTimeFormat#format()` would throw.
        if (!isFinite(now)) {
            throw new RangeError(
                'The `now` option provided to IntlRelativeFormat#format() is not ' +
                'in valid range.'
            );
        }

        if (!isFinite(date)) {
            throw new RangeError(
                'The date value provided to IntlRelativeFormat#format() is not ' +
                'in valid range.'
            );
        }

        var diffReport  = diff(now, date);
        var units       = this._options.units || this._selectUnits(diffReport);
        var diffInUnits = diffReport[units];

        if (this._options.style !== 'numeric') {
            var relativeUnits = this._getRelativeUnits(diffInUnits, units);
            if (relativeUnits) {
                return relativeUnits;
            }
        }

        return this._getMessage(units).format({
            '0' : Math.abs(diffInUnits),
            when: diffInUnits < 0 ? 'past' : 'future'
        });
    };

    RelativeFormat.prototype._isValidUnits = function (units) {
        if (!units || arrIndexOf.call(FIELDS, units) >= 0) {
            return true;
        }

        if (typeof units === 'string') {
            var suggestion = /s$/.test(units) && units.substr(0, units.length - 1);
            if (suggestion && arrIndexOf.call(FIELDS, suggestion) >= 0) {
                throw new Error(
                    '"' + units + '" is not a valid IntlRelativeFormat `units` ' +
                    'value, did you mean: ' + suggestion
                );
            }
        }

        throw new Error(
            '"' + units + '" is not a valid IntlRelativeFormat `units` value, it ' +
            'must be one of: "' + FIELDS.join('", "') + '"'
        );
    };

    RelativeFormat.prototype._resolveLocale = function (locales) {
        if (typeof locales === 'string') {
            locales = [locales];
        }

        // Create a copy of the array so we can push on the default locale.
        locales = (locales || []).concat(RelativeFormat.defaultLocale);

        var localeData = RelativeFormat.__localeData__;
        var i, len, localeParts, data;

        // Using the set of locales + the default locale, we look for the first one
        // which that has been registered. When data does not exist for a locale, we
        // traverse its ancestors to find something that's been registered within
        // its hierarchy of locales. Since we lack the proper `parentLocale` data
        // here, we must take a naive approach to traversal.
        for (i = 0, len = locales.length; i < len; i += 1) {
            localeParts = locales[i].toLowerCase().split('-');

            while (localeParts.length) {
                data = localeData[localeParts.join('-')];
                if (data) {
                    // Return the normalized locale string; e.g., we return "en-US",
                    // instead of "en-us".
                    return data.locale;
                }

                localeParts.pop();
            }
        }

        var defaultLocale = locales.pop();
        throw new Error(
            'No locale data has been added to IntlRelativeFormat for: ' +
            locales.join(', ') + ', or the default locale: ' + defaultLocale
        );
    };

    RelativeFormat.prototype._resolveStyle = function (style) {
        // Default to "best fit" style.
        if (!style) {
            return STYLES[0];
        }

        if (arrIndexOf.call(STYLES, style) >= 0) {
            return style;
        }

        throw new Error(
            '"' + style + '" is not a valid IntlRelativeFormat `style` value, it ' +
            'must be one of: "' + STYLES.join('", "') + '"'
        );
    };

    RelativeFormat.prototype._selectUnits = function (diffReport) {
        var i, l, units;
        var fields = FIELDS.filter(function(field) {
            return field.indexOf('-short') < 1;
        });

        for (i = 0, l = fields.length; i < l; i += 1) {
            units = fields[i];

            if (Math.abs(diffReport[units]) < RelativeFormat.thresholds[units]) {
                break;
            }
        }

        return units;
    };

    /* @generated */	

    RelativeFormat.__addLocaleData({"locale":"af","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"jaar","relative":{"0":"hierdie jaar","1":"volgende jaar","-1":"verlede jaar"},"relativeTime":{"future":{"one":"oor {0} jaar","other":"oor {0} jaar"},"past":{"one":"{0} jaar gelede","other":"{0} jaar gelede"}}},"year-short":{"displayName":"j.","relative":{"0":"hierdie jaar","1":"volgende jaar","-1":"verlede jaar"},"relativeTime":{"future":{"one":"oor {0} j.","other":"oor {0} j."},"past":{"one":"{0} j. gelede","other":"{0} j. gelede"}}},"month":{"displayName":"maand","relative":{"0":"vandeesmaand","1":"volgende maand","-1":"verlede maand"},"relativeTime":{"future":{"one":"oor {0} maand","other":"oor {0} maande"},"past":{"one":"{0} maand gelede","other":"{0} maande gelede"}}},"month-short":{"displayName":"md.","relative":{"0":"vandeesmaand","1":"volgende maand","-1":"verlede maand"},"relativeTime":{"future":{"one":"oor {0} md.","other":"oor {0} md."},"past":{"one":"{0} md. gelede","other":"{0} md. gelede"}}},"week":{"displayName":"week","relativePeriod":"die week van {0}","relative":{"0":"hierdie week","1":"volgende week","-1":"verlede week"},"relativeTime":{"future":{"one":"oor {0} week","other":"oor {0} weke"},"past":{"one":"{0} week gelede","other":"{0} weke gelede"}}},"week-short":{"displayName":"wk.","relativePeriod":"die week van {0}","relative":{"0":"hierdie week","1":"volgende week","-1":"verlede week"},"relativeTime":{"future":{"one":"oor {0} w.","other":"oor {0} w."},"past":{"one":"{0} w. gelede","other":"{0} w. gelede"}}},"day":{"displayName":"dag","relative":{"0":"vandag","1":"môre","2":"oormôre","-2":"eergister","-1":"gister"},"relativeTime":{"future":{"one":"oor {0} dag","other":"oor {0} dae"},"past":{"one":"{0} dag gelede","other":"{0} dae gelede"}}},"day-short":{"displayName":"d.","relative":{"0":"vandag","1":"môre","2":"oormôre","-2":"eergister","-1":"gister"},"relativeTime":{"future":{"one":"oor {0} dag","other":"oor {0} dae"},"past":{"one":"{0} dag gelede","other":"{0} dae gelede"}}},"hour":{"displayName":"uur","relative":{"0":"hierdie uur"},"relativeTime":{"future":{"one":"oor {0} uur","other":"oor {0} uur"},"past":{"one":"{0} uur gelede","other":"{0} uur gelede"}}},"hour-short":{"displayName":"u.","relative":{"0":"hierdie uur"},"relativeTime":{"future":{"one":"oor {0} u.","other":"oor {0} u."},"past":{"one":"{0} u. gelede","other":"{0} u. gelede"}}},"minute":{"displayName":"minuut","relative":{"0":"hierdie minuut"},"relativeTime":{"future":{"one":"oor {0} minuut","other":"oor {0} minute"},"past":{"one":"{0} minuut gelede","other":"{0} minute gelede"}}},"minute-short":{"displayName":"min.","relative":{"0":"hierdie minuut"},"relativeTime":{"future":{"one":"oor {0} min.","other":"oor {0} min."},"past":{"one":"{0} min. gelede","other":"{0} min. gelede"}}},"second":{"displayName":"sekonde","relative":{"0":"nou"},"relativeTime":{"future":{"one":"oor {0} sekonde","other":"oor {0} sekondes"},"past":{"one":"{0} sekonde gelede","other":"{0} sekondes gelede"}}},"second-short":{"displayName":"s.","relative":{"0":"nou"},"relativeTime":{"future":{"one":"oor {0} s.","other":"oor {0} s."},"past":{"one":"{0} s. gelede","other":"{0} s. gelede"}}}}},{"locale":"af-NA","parentLocale":"af"},
    {"locale":"agq","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"kɨnûm","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"kɨnûm","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"ndzɔŋ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"ndzɔŋ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"ewɨn","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"ewɨn","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"utsuʔ","relative":{"0":"nɛ","1":"tsʉtsʉ","-1":"ā zūɛɛ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"utsuʔ","relative":{"0":"nɛ","1":"tsʉtsʉ","-1":"ā zūɛɛ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"tàm","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"tàm","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"menè","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"menè","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"sɛkɔ̀n","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"sɛkɔ̀n","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ak","pluralRuleFunction":function(n
    ) {
      return ((n == 0
              || n == 1)) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Afe","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Afe","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Bosome","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Bosome","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Dapɛn","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Dapɛn","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Da","relative":{"0":"Ndɛ","1":"Ɔkyena","-1":"Ndeda"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Da","relative":{"0":"Ndɛ","1":"Ɔkyena","-1":"Ndeda"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Dɔnhwer","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Dɔnhwer","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Sema","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Sema","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sɛkɛnd","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sɛkɛnd","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"am","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n >= 0 && n <= 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ዓመት","relative":{"0":"በዚህ ዓመት","1":"የሚቀጥለው ዓመት","-1":"ያለፈው ዓመት"},"relativeTime":{"future":{"one":"በ{0} ዓመታት ውስጥ","other":"በ{0} ዓመታት ውስጥ"},"past":{"one":"ከ{0} ዓመት በፊት","other":"ከ{0} ዓመታት በፊት"}}},"year-short":{"displayName":"ዓመት","relative":{"0":"በዚህ ዓመት","1":"የሚቀጥለው ዓመት","-1":"ያለፈው ዓመት"},"relativeTime":{"future":{"one":"በ{0} ዓመታት ውስጥ","other":"በ{0} ዓመታት ውስጥ"},"past":{"one":"ከ{0} ዓመታት በፊት","other":"ከ{0} ዓመታት በፊት"}}},"month":{"displayName":"ወር","relative":{"0":"በዚህ ወር","1":"የሚቀጥለው ወር","-1":"ያለፈው ወር"},"relativeTime":{"future":{"one":"በ{0} ወር ውስጥ","other":"በ{0} ወራት ውስጥ"},"past":{"one":"ከ{0} ወር በፊት","other":"ከ{0} ወራት በፊት"}}},"month-short":{"displayName":"ወር","relative":{"0":"በዚህ ወር","1":"የሚቀጥለው ወር","-1":"ያለፈው ወር"},"relativeTime":{"future":{"one":"በ{0} ወራት ውስጥ","other":"በ{0} ወራት ውስጥ"},"past":{"one":"ከ{0} ወራት በፊት","other":"ከ{0} ወራት በፊት"}}},"week":{"displayName":"ሳምንት","relativePeriod":"{0} ሳምንት","relative":{"0":"በዚህ ሳምንት","1":"የሚቀጥለው ሳምንት","-1":"ያለፈው ሳምንት"},"relativeTime":{"future":{"one":"በ{0} ሳምንት ውስጥ","other":"በ{0} ሳምንታት ውስጥ"},"past":{"one":"ከ{0} ሳምንት በፊት","other":"ከ{0} ሳምንታት በፊት"}}},"week-short":{"displayName":"ሳምንት","relativePeriod":"{0} ሳምንት","relative":{"0":"በዚህ ሣምንት","1":"የሚቀጥለው ሳምንት","-1":"ባለፈው ሳምንት"},"relativeTime":{"future":{"one":"በ{0} ሳምንታት ውስጥ","other":"በ{0} ሳምንታት ውስጥ"},"past":{"one":"ከ{0} ሳምንታት በፊት","other":"ከ{0} ሳምንታት በፊት"}}},"day":{"displayName":"ቀን","relative":{"0":"ዛሬ","1":"ነገ","2":"ከነገ ወዲያ","-2":"ከትናንት ወዲያ","-1":"ትናንት"},"relativeTime":{"future":{"one":"በ{0} ቀን ውስጥ","other":"በ{0} ቀናት ውስጥ"},"past":{"one":"ከ{0} ቀን በፊት","other":"ከ{0} ቀናት በፊት"}}},"day-short":{"displayName":"ቀን","relative":{"0":"ዛሬ","1":"ነገ","2":"ከነገ ወዲያ","-2":"ከትናንት ወዲያ","-1":"ትላንትና"},"relativeTime":{"future":{"one":"በ{0} ቀን ውስጥ","other":"በ{0} ቀኖች ውስጥ"},"past":{"one":"ከ {0} ቀን በፊት","other":"ከ{0} ቀኖች በፊት"}}},"hour":{"displayName":"ሰዓት","relative":{"0":"ይህ ሰዓት"},"relativeTime":{"future":{"one":"በ{0} ሰዓት ውስጥ","other":"በ{0} ሰዓቶች ውስጥ"},"past":{"one":"ከ{0} ሰዓት በፊት","other":"ከ{0} ሰዓቶች በፊት"}}},"hour-short":{"displayName":"ሰዓት","relative":{"0":"ይህ ሰዓት"},"relativeTime":{"future":{"one":"በ{0} ሰዓት ውስጥ","other":"በ{0} ሰዓቶች ውስጥ"},"past":{"one":"ከ{0} ሰዓት በፊት","other":"ከ{0} ሰዓቶች በፊት"}}},"minute":{"displayName":"ደቂቃ","relative":{"0":"ይህ ደቂቃ"},"relativeTime":{"future":{"one":"በ{0} ደቂቃ ውስጥ","other":"በ{0} ደቂቃዎች ውስጥ"},"past":{"one":"ከ{0} ደቂቃ በፊት","other":"ከ{0} ደቂቃዎች በፊት"}}},"minute-short":{"displayName":"ደቂቃ","relative":{"0":"ይህ ደቂቃ"},"relativeTime":{"future":{"one":"በ{0} ደቂቃ ውስጥ","other":"በ{0} ደቂቃዎች ውስጥ"},"past":{"one":"ከ{0} ደቂቃ በፊት","other":"ከ{0} ደቂቃዎች በፊት"}}},"second":{"displayName":"ሰከንድ","relative":{"0":"አሁን"},"relativeTime":{"future":{"one":"በ{0} ሰከንድ ውስጥ","other":"በ{0} ሰከንዶች ውስጥ"},"past":{"one":"ከ{0} ሰከንድ በፊት","other":"ከ{0} ሰከንዶች በፊት"}}},"second-short":{"displayName":"ሰከንድ","relative":{"0":"አሁን"},"relativeTime":{"future":{"one":"በ{0} ሰከንድ ውስጥ","other":"በ{0} ሰከንዶች ውስጥ"},"past":{"one":"ከ{0} ሰከንድ በፊት","other":"ከ{0} ሰከንዶች በፊት"}}}}},
    {"locale":"ar","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), t0 = Number(s[0]) == n,
          n100 = t0 && s[0].slice(-2);
      if (ord) return 'other';
      return (n == 0) ? 'zero'
          : (n == 1) ? 'one'
          : (n == 2) ? 'two'
          : ((n100 >= 3 && n100 <= 10)) ? 'few'
          : ((n100 >= 11 && n100 <= 99)) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"السنة","relative":{"0":"السنة الحالية","1":"السنة القادمة","-1":"السنة الماضية"},"relativeTime":{"future":{"zero":"خلال {0} سنة","one":"خلال سنة واحدة","two":"خلال سنتين","few":"خلال {0} سنوات","many":"خلال {0} سنة","other":"خلال {0} سنة"},"past":{"zero":"قبل {0} سنة","one":"قبل سنة واحدة","two":"قبل سنتين","few":"قبل {0} سنوات","many":"قبل {0} سنة","other":"قبل {0} سنة"}}},"year-short":{"displayName":"السنة","relative":{"0":"السنة الحالية","1":"السنة القادمة","-1":"السنة الماضية"},"relativeTime":{"future":{"zero":"خلال {0} سنة","one":"خلال سنة واحدة","two":"خلال سنتين","few":"خلال {0} سنوات","many":"خلال {0} سنة","other":"خلال {0} سنة"},"past":{"zero":"قبل {0} سنة","one":"قبل سنة واحدة","two":"قبل سنتين","few":"قبل {0} سنوات","many":"قبل {0} سنة","other":"قبل {0} سنة"}}},"month":{"displayName":"الشهر","relative":{"0":"هذا الشهر","1":"الشهر القادم","-1":"الشهر الماضي"},"relativeTime":{"future":{"zero":"خلال {0} شهر","one":"خلال شهر واحد","two":"خلال شهرين","few":"خلال {0} أشهر","many":"خلال {0} شهرًا","other":"خلال {0} شهر"},"past":{"zero":"قبل {0} شهر","one":"قبل شهر واحد","two":"قبل شهرين","few":"قبل {0} أشهر","many":"قبل {0} شهرًا","other":"قبل {0} شهر"}}},"month-short":{"displayName":"الشهر","relative":{"0":"هذا الشهر","1":"الشهر القادم","-1":"الشهر الماضي"},"relativeTime":{"future":{"zero":"خلال {0} شهر","one":"خلال شهر واحد","two":"خلال شهرين","few":"خلال {0} أشهر","many":"خلال {0} شهرًا","other":"خلال {0} شهر"},"past":{"zero":"قبل {0} شهر","one":"قبل شهر واحد","two":"قبل شهرين","few":"خلال {0} أشهر","many":"قبل {0} شهرًا","other":"قبل {0} شهر"}}},"week":{"displayName":"الأسبوع","relativePeriod":"أسبوع {0}","relative":{"0":"هذا الأسبوع","1":"الأسبوع القادم","-1":"الأسبوع الماضي"},"relativeTime":{"future":{"zero":"خلال {0} أسبوع","one":"خلال أسبوع واحد","two":"خلال أسبوعين","few":"خلال {0} أسابيع","many":"خلال {0} أسبوعًا","other":"خلال {0} أسبوع"},"past":{"zero":"قبل {0} أسبوع","one":"قبل أسبوع واحد","two":"قبل أسبوعين","few":"قبل {0} أسابيع","many":"قبل {0} أسبوعًا","other":"قبل {0} أسبوع"}}},"week-short":{"displayName":"الأسبوع","relativePeriod":"أسبوع {0}","relative":{"0":"هذا الأسبوع","1":"الأسبوع القادم","-1":"الأسبوع الماضي"},"relativeTime":{"future":{"zero":"خلال {0} أسبوع","one":"خلال أسبوع واحد","two":"خلال {0} أسبوعين","few":"خلال {0} أسابيع","many":"خلال {0} أسبوعًا","other":"خلال {0} أسبوع"},"past":{"zero":"قبل {0} أسبوع","one":"قبل أسبوع واحد","two":"قبل أسبوعين","few":"قبل {0} أسابيع","many":"قبل {0} أسبوعًا","other":"قبل {0} أسبوع"}}},"day":{"displayName":"يوم","relative":{"0":"اليوم","1":"غدًا","2":"بعد الغد","-2":"أول أمس","-1":"أمس"},"relativeTime":{"future":{"zero":"خلال {0} يوم","one":"خلال يوم واحد","two":"خلال يومين","few":"خلال {0} أيام","many":"خلال {0} يومًا","other":"خلال {0} يوم"},"past":{"zero":"قبل {0} يوم","one":"قبل يوم واحد","two":"قبل يومين","few":"قبل {0} أيام","many":"قبل {0} يومًا","other":"قبل {0} يوم"}}},"day-short":{"displayName":"يوم","relative":{"0":"اليوم","1":"غدًا","2":"بعد الغد","-2":"أول أمس","-1":"أمس"},"relativeTime":{"future":{"zero":"خلال {0} يوم","one":"خلال يوم واحد","two":"خلال يومين","few":"خلال {0} أيام","many":"خلال {0} يومًا","other":"خلال {0} يوم"},"past":{"zero":"قبل {0} يوم","one":"قبل يوم واحد","two":"قبل يومين","few":"قبل {0} أيام","many":"قبل {0} يومًا","other":"قبل {0} يوم"}}},"hour":{"displayName":"الساعات","relative":{"0":"الساعة الحالية"},"relativeTime":{"future":{"zero":"خلال {0} ساعة","one":"خلال ساعة واحدة","two":"خلال ساعتين","few":"خلال {0} ساعات","many":"خلال {0} ساعة","other":"خلال {0} ساعة"},"past":{"zero":"قبل {0} ساعة","one":"قبل ساعة واحدة","two":"قبل ساعتين","few":"قبل {0} ساعات","many":"قبل {0} ساعة","other":"قبل {0} ساعة"}}},"hour-short":{"displayName":"الساعات","relative":{"0":"الساعة الحالية"},"relativeTime":{"future":{"zero":"خلال {0} ساعة","one":"خلال ساعة واحدة","two":"خلال ساعتين","few":"خلال {0} ساعات","many":"خلال {0} ساعة","other":"خلال {0} ساعة"},"past":{"zero":"قبل {0} ساعة","one":"قبل ساعة واحدة","two":"قبل ساعتين","few":"قبل {0} ساعات","many":"قبل {0} ساعة","other":"قبل {0} ساعة"}}},"minute":{"displayName":"الدقائق","relative":{"0":"هذه الدقيقة"},"relativeTime":{"future":{"zero":"خلال {0} دقيقة","one":"خلال دقيقة واحدة","two":"خلال دقيقتين","few":"خلال {0} دقائق","many":"خلال {0} دقيقة","other":"خلال {0} دقيقة"},"past":{"zero":"قبل {0} دقيقة","one":"قبل دقيقة واحدة","two":"قبل دقيقتين","few":"قبل {0} دقائق","many":"قبل {0} دقيقة","other":"قبل {0} دقيقة"}}},"minute-short":{"displayName":"الدقائق","relative":{"0":"هذه الدقيقة"},"relativeTime":{"future":{"zero":"خلال {0} دقيقة","one":"خلال دقيقة واحدة","two":"خلال دقيقتين","few":"خلال {0} دقائق","many":"خلال {0} دقيقة","other":"خلال {0} دقيقة"},"past":{"zero":"قبل {0} دقيقة","one":"قبل دقيقة واحدة","two":"قبل دقيقتين","few":"قبل {0} دقائق","many":"قبل {0} دقيقة","other":"قبل {0} دقيقة"}}},"second":{"displayName":"الثواني","relative":{"0":"الآن"},"relativeTime":{"future":{"zero":"خلال {0} ثانية","one":"خلال ثانية واحدة","two":"خلال ثانيتين","few":"خلال {0} ثوانٍ","many":"خلال {0} ثانية","other":"خلال {0} ثانية"},"past":{"zero":"قبل {0} ثانية","one":"قبل ثانية واحدة","two":"قبل ثانيتين","few":"قبل {0} ثوانِ","many":"قبل {0} ثانية","other":"قبل {0} ثانية"}}},"second-short":{"displayName":"الثواني","relative":{"0":"الآن"},"relativeTime":{"future":{"zero":"خلال {0} ثانية","one":"خلال ثانية واحدة","two":"خلال ثانيتين","few":"خلال {0} ثوانٍ","many":"خلال {0} ثانية","other":"خلال {0} ثانية"},"past":{"zero":"قبل {0} ثانية","one":"قبل ثانية واحدة","two":"قبل ثانيتين","few":"قبل {0} ثوانٍ","many":"قبل {0} ثانية","other":"قبل {0} ثانية"}}}}},{"locale":"ar-AE","parentLocale":"ar","fields":{"year":{"displayName":"السنة","relative":{"0":"هذه السنة","1":"السنة التالية","-1":"السنة الماضية"},"relativeTime":{"future":{"zero":"خلال {0} سنة","one":"خلال سنة واحدة","two":"خلال سنتين","few":"خلال {0} سنوات","many":"خلال {0} سنة","other":"خلال {0} سنة"},"past":{"zero":"قبل {0} سنة","one":"قبل سنة واحدة","two":"قبل سنتين","few":"قبل {0} سنوات","many":"قبل {0} سنة","other":"قبل {0} سنة"}}},"year-short":{"displayName":"السنة","relative":{"0":"هذه السنة","1":"السنة التالية","-1":"السنة الماضية"},"relativeTime":{"future":{"zero":"خلال {0} سنة","one":"خلال سنة واحدة","two":"خلال سنتين","few":"خلال {0} سنوات","many":"خلال {0} سنة","other":"خلال {0} سنة"},"past":{"zero":"قبل {0} سنة","one":"قبل سنة واحدة","two":"قبل سنتين","few":"قبل {0} سنوات","many":"قبل {0} سنة","other":"قبل {0} سنة"}}},"month":{"displayName":"الشهر","relative":{"0":"هذا الشهر","1":"الشهر القادم","-1":"الشهر الماضي"},"relativeTime":{"future":{"zero":"خلال {0} شهر","one":"خلال شهر واحد","two":"خلال شهرين","few":"خلال {0} أشهر","many":"خلال {0} شهرًا","other":"خلال {0} شهر"},"past":{"zero":"قبل {0} شهر","one":"قبل شهر واحد","two":"قبل شهرين","few":"قبل {0} أشهر","many":"قبل {0} شهرًا","other":"قبل {0} شهر"}}},"month-short":{"displayName":"الشهر","relative":{"0":"هذا الشهر","1":"الشهر القادم","-1":"الشهر الماضي"},"relativeTime":{"future":{"zero":"خلال {0} شهر","one":"خلال شهر واحد","two":"خلال شهرين","few":"خلال {0} أشهر","many":"خلال {0} شهرًا","other":"خلال {0} شهر"},"past":{"zero":"قبل {0} شهر","one":"قبل شهر واحد","two":"قبل شهرين","few":"خلال {0} أشهر","many":"قبل {0} شهرًا","other":"قبل {0} شهر"}}},"week":{"displayName":"الأسبوع","relativePeriod":"أسبوع {0}","relative":{"0":"هذا الأسبوع","1":"الأسبوع القادم","-1":"الأسبوع الماضي"},"relativeTime":{"future":{"zero":"خلال {0} أسبوع","one":"خلال أسبوع واحد","two":"خلال أسبوعين","few":"خلال {0} أسابيع","many":"خلال {0} أسبوعًا","other":"خلال {0} أسبوع"},"past":{"zero":"قبل {0} أسبوع","one":"قبل أسبوع واحد","two":"قبل أسبوعين","few":"قبل {0} أسابيع","many":"قبل {0} أسبوعًا","other":"قبل {0} أسبوع"}}},"week-short":{"displayName":"الأسبوع","relativePeriod":"أسبوع {0}","relative":{"0":"هذا الأسبوع","1":"الأسبوع القادم","-1":"الأسبوع الماضي"},"relativeTime":{"future":{"zero":"خلال {0} أسبوع","one":"خلال أسبوع واحد","two":"خلال {0} أسبوعين","few":"خلال {0} أسابيع","many":"خلال {0} أسبوعًا","other":"خلال {0} أسبوع"},"past":{"zero":"قبل {0} أسبوع","one":"قبل أسبوع واحد","two":"قبل أسبوعين","few":"قبل {0} أسابيع","many":"قبل {0} أسبوعًا","other":"قبل {0} أسبوع"}}},"day":{"displayName":"يوم","relative":{"0":"اليوم","1":"غدًا","2":"بعد الغد","-2":"أول أمس","-1":"أمس"},"relativeTime":{"future":{"zero":"خلال {0} يوم","one":"خلال يوم واحد","two":"خلال يومين","few":"خلال {0} أيام","many":"خلال {0} يومًا","other":"خلال {0} يوم"},"past":{"zero":"قبل {0} يوم","one":"قبل يوم واحد","two":"قبل يومين","few":"قبل {0} أيام","many":"قبل {0} يومًا","other":"قبل {0} يوم"}}},"day-short":{"displayName":"يوم","relative":{"0":"اليوم","1":"غدًا","2":"بعد الغد","-2":"أول أمس","-1":"أمس"},"relativeTime":{"future":{"zero":"خلال {0} يوم","one":"خلال يوم واحد","two":"خلال يومين","few":"خلال {0} أيام","many":"خلال {0} يومًا","other":"خلال {0} يوم"},"past":{"zero":"قبل {0} يوم","one":"قبل يوم واحد","two":"قبل يومين","few":"قبل {0} أيام","many":"قبل {0} يومًا","other":"قبل {0} يوم"}}},"hour":{"displayName":"الساعات","relative":{"0":"الساعة الحالية"},"relativeTime":{"future":{"zero":"خلال {0} ساعة","one":"خلال ساعة واحدة","two":"خلال ساعتين","few":"خلال {0} ساعات","many":"خلال {0} ساعة","other":"خلال {0} ساعة"},"past":{"zero":"قبل {0} ساعة","one":"قبل ساعة واحدة","two":"قبل ساعتين","few":"قبل {0} ساعات","many":"قبل {0} ساعة","other":"قبل {0} ساعة"}}},"hour-short":{"displayName":"الساعات","relative":{"0":"الساعة الحالية"},"relativeTime":{"future":{"zero":"خلال {0} ساعة","one":"خلال ساعة واحدة","two":"خلال ساعتين","few":"خلال {0} ساعات","many":"خلال {0} ساعة","other":"خلال {0} ساعة"},"past":{"zero":"قبل {0} ساعة","one":"قبل ساعة واحدة","two":"قبل ساعتين","few":"قبل {0} ساعات","many":"قبل {0} ساعة","other":"قبل {0} ساعة"}}},"minute":{"displayName":"الدقائق","relative":{"0":"هذه الدقيقة"},"relativeTime":{"future":{"zero":"خلال {0} دقيقة","one":"خلال دقيقة واحدة","two":"خلال دقيقتين","few":"خلال {0} دقائق","many":"خلال {0} دقيقة","other":"خلال {0} دقيقة"},"past":{"zero":"قبل {0} دقيقة","one":"قبل دقيقة واحدة","two":"قبل دقيقتين","few":"قبل {0} دقائق","many":"قبل {0} دقيقة","other":"قبل {0} دقيقة"}}},"minute-short":{"displayName":"الدقائق","relative":{"0":"هذه الدقيقة"},"relativeTime":{"future":{"zero":"خلال {0} دقيقة","one":"خلال دقيقة واحدة","two":"خلال دقيقتين","few":"خلال {0} دقائق","many":"خلال {0} دقيقة","other":"خلال {0} دقيقة"},"past":{"zero":"قبل {0} دقيقة","one":"قبل دقيقة واحدة","two":"قبل دقيقتين","few":"قبل {0} دقائق","many":"قبل {0} دقيقة","other":"قبل {0} دقيقة"}}},"second":{"displayName":"الثواني","relative":{"0":"الآن"},"relativeTime":{"future":{"zero":"خلال {0} ثانية","one":"خلال ثانية واحدة","two":"خلال ثانيتين","few":"خلال {0} ثوانٍ","many":"خلال {0} ثانية","other":"خلال {0} ثانية"},"past":{"zero":"قبل {0} ثانية","one":"قبل ثانية واحدة","two":"قبل ثانيتين","few":"قبل {0} ثوانِ","many":"قبل {0} ثانية","other":"قبل {0} ثانية"}}},"second-short":{"displayName":"الثواني","relative":{"0":"الآن"},"relativeTime":{"future":{"zero":"خلال {0} ثانية","one":"خلال ثانية واحدة","two":"خلال ثانيتين","few":"خلال {0} ثوانٍ","many":"خلال {0} ثانية","other":"خلال {0} ثانية"},"past":{"zero":"قبل {0} ثانية","one":"قبل ثانية واحدة","two":"قبل ثانيتين","few":"قبل {0} ثوانٍ","many":"قبل {0} ثانية","other":"قبل {0} ثانية"}}}}},{"locale":"ar-BH","parentLocale":"ar"},{"locale":"ar-DJ","parentLocale":"ar"},{"locale":"ar-DZ","parentLocale":"ar"},{"locale":"ar-EG","parentLocale":"ar"},{"locale":"ar-EH","parentLocale":"ar"},{"locale":"ar-ER","parentLocale":"ar"},{"locale":"ar-IL","parentLocale":"ar"},{"locale":"ar-IQ","parentLocale":"ar"},{"locale":"ar-JO","parentLocale":"ar"},{"locale":"ar-KM","parentLocale":"ar"},{"locale":"ar-KW","parentLocale":"ar"},{"locale":"ar-LB","parentLocale":"ar"},{"locale":"ar-LY","parentLocale":"ar"},{"locale":"ar-MA","parentLocale":"ar"},{"locale":"ar-MR","parentLocale":"ar"},{"locale":"ar-OM","parentLocale":"ar"},{"locale":"ar-PS","parentLocale":"ar"},{"locale":"ar-QA","parentLocale":"ar"},{"locale":"ar-SA","parentLocale":"ar"},{"locale":"ar-SD","parentLocale":"ar"},{"locale":"ar-SO","parentLocale":"ar"},{"locale":"ar-SS","parentLocale":"ar"},{"locale":"ar-SY","parentLocale":"ar"},{"locale":"ar-TD","parentLocale":"ar"},{"locale":"ar-TN","parentLocale":"ar"},{"locale":"ar-YE","parentLocale":"ar"},
    {"locale":"ars","pluralRuleFunction":function(n
    ) {
      var s = String(n).split('.'), t0 = Number(s[0]) == n,
          n100 = t0 && s[0].slice(-2);
      return (n == 0) ? 'zero'
          : (n == 1) ? 'one'
          : (n == 2) ? 'two'
          : ((n100 >= 3 && n100 <= 10)) ? 'few'
          : ((n100 >= 11 && n100 <= 99)) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"as","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return ((n == 1 || n == 5 || n == 7 || n == 8 || n == 9
              || n == 10)) ? 'one'
          : ((n == 2
              || n == 3)) ? 'two'
          : (n == 4) ? 'few'
          : (n == 6) ? 'many'
          : 'other';
      return (n >= 0 && n <= 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"বছৰ","relative":{"0":"এই বছৰ","1":"অহা বছৰ","-1":"যোৱা বছৰ"},"relativeTime":{"future":{"one":"{0} বছৰত","other":"{0} বছৰত"},"past":{"one":"{0} বছৰৰ পূৰ্বে","other":"{0} বছৰৰ পূৰ্বে"}}},"year-short":{"displayName":"বছৰ","relative":{"0":"এই বছৰ","1":"অহা বছৰ","-1":"যোৱা বছৰ"},"relativeTime":{"future":{"one":"{0} বছৰত","other":"{0} বছৰত"},"past":{"one":"{0} বছৰৰ পূৰ্বে","other":"{0} বছৰৰ পূৰ্বে"}}},"month":{"displayName":"মাহ","relative":{"0":"এই মাহ","1":"অহা মাহ","-1":"যোৱা মাহ"},"relativeTime":{"future":{"one":"{0} মাহত","other":"{0} মাহত"},"past":{"one":"{0} মাহ পূৰ্বে","other":"{0} মাহ পূৰ্বে"}}},"month-short":{"displayName":"মাহ","relative":{"0":"এই মাহ","1":"অহা মাহ","-1":"যোৱা মাহ"},"relativeTime":{"future":{"one":"{0} মাহত","other":"{0} মাহত"},"past":{"one":"{0} মাহ পূৰ্বে","other":"{0} মাহ পূৰ্বে"}}},"week":{"displayName":"সপ্তাহ","relativePeriod":"{0}ৰ সপ্তাহ","relative":{"0":"এই সপ্তাহ","1":"অহা সপ্তাহ","-1":"যোৱা সপ্তাহ"},"relativeTime":{"future":{"one":"{0} সপ্তাহত","other":"{0} সপ্তাহত"},"past":{"one":"{0} সপ্তাহ পূৰ্বে","other":"{0} সপ্তাহ পূৰ্বে"}}},"week-short":{"displayName":"সপ্তাহ","relativePeriod":"{0}ৰ সপ্তাহ","relative":{"0":"এই সপ্তাহ","1":"অহা সপ্তাহ","-1":"যোৱা সপ্তাহ"},"relativeTime":{"future":{"one":"{0} সপ্তাহত","other":"{0} সপ্তাহত"},"past":{"one":"{0} সপ্তাহ পূৰ্বে","other":"{0} সপ্তাহ পূৰ্বে"}}},"day":{"displayName":"দিন","relative":{"0":"আজি","1":"কাইলৈ","2":"পৰহিলৈ","-2":"পৰহি","-1":"কালি"},"relativeTime":{"future":{"one":"{0} দিনত","other":"{0} দিনত"},"past":{"one":"{0} দিন পূৰ্বে","other":"{0} দিন পূৰ্বে"}}},"day-short":{"displayName":"দিন","relative":{"0":"আজি","1":"কাইলৈ","2":"পৰহিলৈ","-2":"পৰহি","-1":"কালি"},"relativeTime":{"future":{"one":"{0} দিনত","other":"{0} দিনত"},"past":{"one":"{0} দিন পূৰ্বে","other":"{0} দিন পূৰ্বে"}}},"hour":{"displayName":"ঘণ্টা","relative":{"0":"এইটো ঘণ্টাত"},"relativeTime":{"future":{"one":"{0} ঘণ্টাত","other":"{0} ঘণ্টাত"},"past":{"one":"{0} ঘণ্টা পূৰ্বে","other":"{0} ঘণ্টা পূৰ্বে"}}},"hour-short":{"displayName":"ঘণ্টা","relative":{"0":"এইটো ঘণ্টাত"},"relativeTime":{"future":{"one":"{0} ঘণ্টাত","other":"{0} ঘণ্টাত"},"past":{"one":"{0} ঘণ্টা পূৰ্বে","other":"{0} ঘণ্টা পূৰ্বে"}}},"minute":{"displayName":"মিনিট","relative":{"0":"এইটো মিনিটত"},"relativeTime":{"future":{"one":"{0} মিনিটত","other":"{0} মিনিটত"},"past":{"one":"{0} মিনিট পূৰ্বে","other":"{0} মিনিট পূৰ্বে"}}},"minute-short":{"displayName":"মিনিট","relative":{"0":"এইটো মিনিটত"},"relativeTime":{"future":{"one":"{0} মিনিটত","other":"{0} মিনিটত"},"past":{"one":"{0} মিনিট পূৰ্বে","other":"{0} মিনিট পূৰ্বে"}}},"second":{"displayName":"ছেকেণ্ড","relative":{"0":"এতিয়া"},"relativeTime":{"future":{"one":"{0} ছেকেণ্ডত","other":"{0} ছেকেণ্ডত"},"past":{"one":"{0} ছেকেণ্ড পূৰ্বে","other":"{0} ছেকেণ্ড পূৰ্বে"}}},"second-short":{"displayName":"ছেকেণ্ড","relative":{"0":"এতিয়া"},"relativeTime":{"future":{"one":"{0} ছেকেণ্ডত","other":"{0} ছেকেণ্ডত"},"past":{"one":"{0} ছেকেণ্ড পূৰ্বে","other":"{0} ছেকেণ্ড পূৰ্বে"}}}}},
    {"locale":"asa","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mweji","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mweji","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Ndisha","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Ndisha","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Thiku","relative":{"0":"Iyoo","1":"Yavo","-1":"Ighuo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Thiku","relative":{"0":"Iyoo","1":"Yavo","-1":"Ighuo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Thaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Thaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Dakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Dakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Thekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Thekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ast","pluralRuleFunction":function(n
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"añu","relative":{"0":"esti añu","1":"l’añu viniente","-1":"l’añu pasáu"},"relativeTime":{"future":{"one":"en {0} añu","other":"en {0} años"},"past":{"one":"hai {0} añu","other":"hai {0} años"}}},"year-short":{"displayName":"añu","relative":{"0":"esti añu","1":"l’añu vin.","-1":"l’añu pas."},"relativeTime":{"future":{"one":"en {0} añu","other":"en {0} años"},"past":{"one":"hai {0} añu","other":"hai {0} años"}}},"month":{"displayName":"mes","relative":{"0":"esti mes","1":"el mes viniente","-1":"el mes pasáu"},"relativeTime":{"future":{"one":"en {0} mes","other":"en {0} meses"},"past":{"one":"hai {0} mes","other":"hai {0} meses"}}},"month-short":{"displayName":"mes","relative":{"0":"esti mes","1":"mes vin.","-1":"mes pas."},"relativeTime":{"future":{"one":"en {0} mes","other":"en {0} meses"},"past":{"one":"hai {0} mes","other":"hai {0} meses"}}},"week":{"displayName":"selmana","relativePeriod":"la selmana del {0}","relative":{"0":"esta selmana","1":"la selmana viniente","-1":"la selmana pasada"},"relativeTime":{"future":{"one":"en {0} selmana","other":"en {0} selmanes"},"past":{"one":"hai {0} selmana","other":"hai {0} selmanes"}}},"week-short":{"displayName":"sel.","relativePeriod":"la selmana del {0}","relative":{"0":"esta selm.","1":"selm. viniente","-1":"selm. pasada"},"relativeTime":{"future":{"one":"en {0} selm.","other":"en {0} selm."},"past":{"one":"hai {0} selm.","other":"hai {0} selm."}}},"day":{"displayName":"día","relative":{"0":"güei","1":"mañana","2":"pasao mañana","-2":"antayeri","-1":"ayeri"},"relativeTime":{"future":{"one":"en {0} día","other":"en {0} díes"},"past":{"one":"hai {0} día","other":"hai {0} díes"}}},"day-short":{"displayName":"día","relative":{"0":"güei","1":"mañana","2":"pasao mañana","-2":"antayeri","-1":"ayeri"},"relativeTime":{"future":{"one":"en {0} día","other":"en {0} díes"},"past":{"one":"hai {0} día","other":"hai {0} díes"}}},"hour":{"displayName":"hora","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"en {0} hora","other":"en {0} hores"},"past":{"one":"hai {0} hora","other":"hai {0} hores"}}},"hour-short":{"displayName":"h.","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"en {0} h.","other":"en {0} h."},"past":{"one":"hai {0} h.","other":"hai {0} h."}}},"minute":{"displayName":"minutu","relative":{"0":"esti minutu"},"relativeTime":{"future":{"one":"en {0} minutu","other":"en {0} minutos"},"past":{"one":"hai {0} minutu","other":"hai {0} minutos"}}},"minute-short":{"displayName":"min.","relative":{"0":"esti min."},"relativeTime":{"future":{"one":"en {0} min.","other":"en {0} min."},"past":{"one":"hai {0} min.","other":"hai {0} min."}}},"second":{"displayName":"segundu","relative":{"0":"agora"},"relativeTime":{"future":{"one":"en {0} segundu","other":"en {0} segundos"},"past":{"one":"hai {0} segundu","other":"hai {0} segundos"}}},"second-short":{"displayName":"s.","relative":{"0":"agora"},"relativeTime":{"future":{"one":"en {0} seg.","other":"en {0} seg."},"past":{"one":"hai {0} seg.","other":"hai {0} seg."}}}}},
    {"locale":"az","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], i10 = i.slice(-1),
          i100 = i.slice(-2), i1000 = i.slice(-3);
      if (ord) return ((i10 == 1 || i10 == 2 || i10 == 5 || i10 == 7 || i10 == 8)
              || (i100 == 20 || i100 == 50 || i100 == 70
              || i100 == 80)) ? 'one'
          : ((i10 == 3 || i10 == 4) || (i1000 == 100 || i1000 == 200
              || i1000 == 300 || i1000 == 400 || i1000 == 500 || i1000 == 600 || i1000 == 700
              || i1000 == 800
              || i1000 == 900)) ? 'few'
          : (i == 0 || i10 == 6 || (i100 == 40 || i100 == 60
              || i100 == 90)) ? 'many'
          : 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"İl","relative":{"0":"bu il","1":"gələn il","-1":"keçən il"},"relativeTime":{"future":{"one":"{0} il ərzində","other":"{0} il ərzində"},"past":{"one":"{0} il öncə","other":"{0} il öncə"}}},"year-short":{"displayName":"il","relative":{"0":"bu il","1":"gələn il","-1":"keçən il"},"relativeTime":{"future":{"one":"{0} il ərzində","other":"{0} il ərzində"},"past":{"one":"{0} il öncə","other":"{0} il öncə"}}},"month":{"displayName":"Ay","relative":{"0":"bu ay","1":"gələn ay","-1":"keçən ay"},"relativeTime":{"future":{"one":"{0} ay ərzində","other":"{0} ay ərzində"},"past":{"one":"{0} ay öncə","other":"{0} ay öncə"}}},"month-short":{"displayName":"ay","relative":{"0":"bu ay","1":"gələn ay","-1":"keçən ay"},"relativeTime":{"future":{"one":"{0} ay ərzində","other":"{0} ay ərzində"},"past":{"one":"{0} ay öncə","other":"{0} ay öncə"}}},"week":{"displayName":"Həftə","relativePeriod":"{0} həftəsi","relative":{"0":"bu həftə","1":"gələn həftə","-1":"keçən həftə"},"relativeTime":{"future":{"one":"{0} həftə ərzində","other":"{0} həftə ərzində"},"past":{"one":"{0} həftə öncə","other":"{0} həftə öncə"}}},"week-short":{"displayName":"həftə","relativePeriod":"{0} həftəsi","relative":{"0":"bu həftə","1":"gələn həftə","-1":"keçən həftə"},"relativeTime":{"future":{"one":"{0} həftə ərzində","other":"{0} həftə ərzində"},"past":{"one":"{0} həftə öncə","other":"{0} həftə öncə"}}},"day":{"displayName":"Gün","relative":{"0":"bu gün","1":"sabah","-1":"dünən"},"relativeTime":{"future":{"one":"{0} gün ərzində","other":"{0} gün ərzində"},"past":{"one":"{0} gün öncə","other":"{0} gün öncə"}}},"day-short":{"displayName":"Gün","relative":{"0":"bu gün","1":"sabah","-1":"dünən"},"relativeTime":{"future":{"one":"{0} gün ərzində","other":"{0} gün ərzində"},"past":{"one":"{0} gün öncə","other":"{0} gün öncə"}}},"hour":{"displayName":"Saat","relative":{"0":"bu saat"},"relativeTime":{"future":{"one":"{0} saat ərzində","other":"{0} saat ərzində"},"past":{"one":"{0} saat öncə","other":"{0} saat öncə"}}},"hour-short":{"displayName":"saat","relative":{"0":"bu saat"},"relativeTime":{"future":{"one":"{0} saat ərzində","other":"{0} saat ərzində"},"past":{"one":"{0} saat öncə","other":"{0} saat öncə"}}},"minute":{"displayName":"Dəqiqə","relative":{"0":"bu dəqiqə"},"relativeTime":{"future":{"one":"{0} dəqiqə ərzində","other":"{0} dəqiqə ərzində"},"past":{"one":"{0} dəqiqə öncə","other":"{0} dəqiqə öncə"}}},"minute-short":{"displayName":"dəq.","relative":{"0":"bu dəqiqə"},"relativeTime":{"future":{"one":"{0} dəqiqə ərzində","other":"{0} dəqiqə ərzində"},"past":{"one":"{0} dəqiqə öncə","other":"{0} dəqiqə öncə"}}},"second":{"displayName":"Saniyə","relative":{"0":"indi"},"relativeTime":{"future":{"one":"{0} saniyə ərzində","other":"{0} saniyə ərzində"},"past":{"one":"{0} saniyə öncə","other":"{0} saniyə öncə"}}},"second-short":{"displayName":"san.","relative":{"0":"indi"},"relativeTime":{"future":{"one":"{0} saniyə ərzində","other":"{0} saniyə ərzində"},"past":{"one":"{0} saniyə öncə","other":"{0} saniyə öncə"}}}}},{"locale":"az-Arab","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"az-Cyrl","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"az-Latn","parentLocale":"az"},
    {"locale":"bas","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"ŋwìi","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"ŋwìi","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"soŋ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"soŋ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"sɔndɛ̂","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"sɔndɛ̂","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"kɛl","relative":{"0":"lɛ̀n","1":"yàni","-1":"yààni"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"kɛl","relative":{"0":"lɛ̀n","1":"yàni","-1":"yààni"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"ŋgɛŋ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"ŋgɛŋ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"ŋget","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"ŋget","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"hìŋgeŋget","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"hìŋgeŋget","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"be","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), t0 = Number(s[0]) == n,
          n10 = t0 && s[0].slice(-1), n100 = t0 && s[0].slice(-2);
      if (ord) return ((n10 == 2
              || n10 == 3) && n100 != 12 && n100 != 13) ? 'few' : 'other';
      return (n10 == 1 && n100 != 11) ? 'one'
          : ((n10 >= 2 && n10 <= 4) && (n100 < 12
              || n100 > 14)) ? 'few'
          : (t0 && n10 == 0 || (n10 >= 5 && n10 <= 9)
              || (n100 >= 11 && n100 <= 14)) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"год","relative":{"0":"у гэтым годзе","1":"у наступным годзе","-1":"у мінулым годзе"},"relativeTime":{"future":{"one":"праз {0} год","few":"праз {0} гады","many":"праз {0} гадоў","other":"праз {0} года"},"past":{"one":"{0} год таму","few":"{0} гады таму","many":"{0} гадоў таму","other":"{0} года таму"}}},"year-short":{"displayName":"г.","relative":{"0":"у гэтым годзе","1":"у наступным годзе","-1":"у мінулым годзе"},"relativeTime":{"future":{"one":"праз {0} г.","few":"праз {0} г.","many":"праз {0} г.","other":"праз {0} г."},"past":{"one":"{0} г. таму","few":"{0} г. таму","many":"{0} г. таму","other":"{0} г. таму"}}},"month":{"displayName":"месяц","relative":{"0":"у гэтым месяцы","1":"у наступным месяцы","-1":"у мінулым месяцы"},"relativeTime":{"future":{"one":"праз {0} месяц","few":"праз {0} месяцы","many":"праз {0} месяцаў","other":"праз {0} месяца"},"past":{"one":"{0} месяц таму","few":"{0} месяцы таму","many":"{0} месяцаў таму","other":"{0} месяца таму"}}},"month-short":{"displayName":"мес.","relative":{"0":"у гэтым месяцы","1":"у наступным месяцы","-1":"у мінулым месяцы"},"relativeTime":{"future":{"one":"праз {0} мес.","few":"праз {0} мес.","many":"праз {0} мес.","other":"праз {0} мес."},"past":{"one":"{0} мес. таму","few":"{0} мес. таму","many":"{0} мес. таму","other":"{0} мес. таму"}}},"week":{"displayName":"тыд","relativePeriod":"тыдзень {0}","relative":{"0":"на гэтым тыдні","1":"на наступным тыдні","-1":"на мінулым тыдні"},"relativeTime":{"future":{"one":"праз {0} тыдзень","few":"праз {0} тыдні","many":"праз {0} тыдняў","other":"праз {0} тыдня"},"past":{"one":"{0} тыдзень таму","few":"{0} тыдні таму","many":"{0} тыдняў таму","other":"{0} тыдня таму"}}},"week-short":{"displayName":"тыд","relativePeriod":"тыдзень {0}","relative":{"0":"на гэтым тыдні","1":"на наступным тыдні","-1":"на мінулым тыдні"},"relativeTime":{"future":{"one":"праз {0} тыд","few":"праз {0} тыд","many":"праз {0} тыд","other":"праз {0} тыд"},"past":{"one":"{0} тыд таму","few":"{0} тыд таму","many":"{0} тыд таму","other":"{0} тыд таму"}}},"day":{"displayName":"дзень","relative":{"0":"сёння","1":"заўтра","2":"паслязаўтра","-2":"пазаўчора","-1":"учора"},"relativeTime":{"future":{"one":"праз {0} дзень","few":"праз {0} дні","many":"праз {0} дзён","other":"праз {0} дня"},"past":{"one":"{0} дзень таму","few":"{0} дні таму","many":"{0} дзён таму","other":"{0} дня таму"}}},"day-short":{"displayName":"дзень","relative":{"0":"сёння","1":"заўтра","2":"паслязаўтра","-2":"пазаўчора","-1":"учора"},"relativeTime":{"future":{"one":"праз {0} дзень","few":"праз {0} дні","many":"праз {0} дзён","other":"праз {0} дня"},"past":{"one":"{0} дзень таму","few":"{0} дні таму","many":"{0} дзён таму","other":"{0} дня таму"}}},"hour":{"displayName":"гадзіна","relative":{"0":"у гэту гадзіну"},"relativeTime":{"future":{"one":"праз {0} гадзіну","few":"праз {0} гадзіны","many":"праз {0} гадзін","other":"праз {0} гадзіны"},"past":{"one":"{0} гадзіну таму","few":"{0} гадзіны таму","many":"{0} гадзін таму","other":"{0} гадзіны таму"}}},"hour-short":{"displayName":"гадз","relative":{"0":"у гэту гадзіну"},"relativeTime":{"future":{"one":"праз {0} гадз","few":"праз {0} гадз","many":"праз {0} гадз","other":"праз {0} гадз"},"past":{"one":"{0} гадз таму","few":"{0} гадз таму","many":"{0} гадз таму","other":"{0} гадз таму"}}},"minute":{"displayName":"хвіліна","relative":{"0":"у гэту хвіліну"},"relativeTime":{"future":{"one":"праз {0} хвіліну","few":"праз {0} хвіліны","many":"праз {0} хвілін","other":"праз {0} хвіліны"},"past":{"one":"{0} хвіліну таму","few":"{0} хвіліны таму","many":"{0} хвілін таму","other":"{0} хвіліны таму"}}},"minute-short":{"displayName":"хв","relative":{"0":"у гэту хвіліну"},"relativeTime":{"future":{"one":"праз {0} хв","few":"праз {0} хв","many":"праз {0} хв","other":"праз {0} хв"},"past":{"one":"{0} хв таму","few":"{0} хв таму","many":"{0} хв таму","other":"{0} хв таму"}}},"second":{"displayName":"секунда","relative":{"0":"цяпер"},"relativeTime":{"future":{"one":"праз {0} секунду","few":"праз {0} секунды","many":"праз {0} секунд","other":"праз {0} секунды"},"past":{"one":"{0} секунду таму","few":"{0} секунды таму","many":"{0} секунд таму","other":"{0} секунды таму"}}},"second-short":{"displayName":"с","relative":{"0":"цяпер"},"relativeTime":{"future":{"one":"праз {0} с","few":"праз {0} с","many":"праз {0} с","other":"праз {0} с"},"past":{"one":"{0} с таму","few":"{0} с таму","many":"{0} с таму","other":"{0} с таму"}}}}},
    {"locale":"bem","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Umwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Umwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Umweshi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Umweshi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Umulungu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Umulungu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Ubushiku","relative":{"0":"Lelo","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Ubushiku","relative":{"0":"Lelo","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Insa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Insa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Mineti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Mineti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekondi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekondi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"bez","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Mwaha","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Mwaha","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mwedzi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mwedzi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Mlungu gumamfu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Mlungu gumamfu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Sihu","relative":{"0":"Neng’u ni","1":"Hilawu","-1":"Igolo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Sihu","relative":{"0":"Neng’u ni","1":"Hilawu","-1":"Igolo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Dakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Dakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"bg","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"година","relative":{"0":"тази година","1":"следващата година","-1":"миналата година"},"relativeTime":{"future":{"one":"след {0} година","other":"след {0} години"},"past":{"one":"преди {0} година","other":"преди {0} години"}}},"year-short":{"displayName":"г.","relative":{"0":"т. г.","1":"следв. г.","-1":"мин. г."},"relativeTime":{"future":{"one":"след {0} г.","other":"след {0} г."},"past":{"one":"преди {0} г.","other":"преди {0} г."}}},"month":{"displayName":"месец","relative":{"0":"този месец","1":"следващ месец","-1":"предходен месец"},"relativeTime":{"future":{"one":"след {0} месец","other":"след {0} месеца"},"past":{"one":"преди {0} месец","other":"преди {0} месеца"}}},"month-short":{"displayName":"мес.","relative":{"0":"този мес.","1":"следв. мес.","-1":"мин. мес."},"relativeTime":{"future":{"one":"след {0} м.","other":"след {0} м."},"past":{"one":"преди {0} м.","other":"преди {0} м."}}},"week":{"displayName":"седмица","relativePeriod":"седмицата от {0}","relative":{"0":"тази седмица","1":"следващата седмица","-1":"предходната седмица"},"relativeTime":{"future":{"one":"след {0} седмица","other":"след {0} седмици"},"past":{"one":"преди {0} седмица","other":"преди {0} седмици"}}},"week-short":{"displayName":"седм.","relativePeriod":"седмицата от {0}","relative":{"0":"тази седм.","1":"следв. седм.","-1":"миналата седмица"},"relativeTime":{"future":{"one":"след {0} седм.","other":"след {0} седм."},"past":{"one":"преди {0} седм.","other":"преди {0} седм."}}},"day":{"displayName":"ден","relative":{"0":"днес","1":"утре","2":"вдругиден","-2":"онзи ден","-1":"вчера"},"relativeTime":{"future":{"one":"след {0} ден","other":"след {0} дни"},"past":{"one":"преди {0} ден","other":"преди {0} дни"}}},"day-short":{"displayName":"д","relative":{"0":"днес","1":"утре","2":"вдругиден","-2":"онзи ден","-1":"вчера"},"relativeTime":{"future":{"one":"след {0} ден","other":"след {0} дни"},"past":{"one":"преди {0} ден","other":"преди {0} дни"}}},"hour":{"displayName":"час","relative":{"0":"в този час"},"relativeTime":{"future":{"one":"след {0} час","other":"след {0} часа"},"past":{"one":"преди {0} час","other":"преди {0} часа"}}},"hour-short":{"displayName":"ч","relative":{"0":"в този час"},"relativeTime":{"future":{"one":"след {0} ч","other":"след {0} ч"},"past":{"one":"преди {0} ч","other":"преди {0} ч"}}},"minute":{"displayName":"минута","relative":{"0":"в тази минута"},"relativeTime":{"future":{"one":"след {0} минута","other":"след {0} минути"},"past":{"one":"преди {0} минута","other":"преди {0} минути"}}},"minute-short":{"displayName":"мин","relative":{"0":"в тази минута"},"relativeTime":{"future":{"one":"след {0} мин","other":"след {0} мин"},"past":{"one":"преди {0} мин","other":"преди {0} мин"}}},"second":{"displayName":"секунда","relative":{"0":"сега"},"relativeTime":{"future":{"one":"след {0} секунда","other":"след {0} секунди"},"past":{"one":"преди {0} секунда","other":"преди {0} секунди"}}},"second-short":{"displayName":"сек","relative":{"0":"сега"},"relativeTime":{"future":{"one":"след {0} сек","other":"след {0} сек"},"past":{"one":"преди {0} сек","other":"преди {0} сек"}}}}},
    {"locale":"bh","pluralRuleFunction":function(n
    ) {
      return ((n == 0
              || n == 1)) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"bm","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"san","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"san","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"kalo","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"kalo","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"dɔgɔkun","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"dɔgɔkun","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"don","relative":{"0":"bi","1":"sini","-1":"kunu"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"don","relative":{"0":"bi","1":"sini","-1":"kunu"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"lɛrɛ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"lɛrɛ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"miniti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"miniti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"sekondi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"sekondi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"bm-Nkoo","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"bn","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return ((n == 1 || n == 5 || n == 7 || n == 8 || n == 9
              || n == 10)) ? 'one'
          : ((n == 2
              || n == 3)) ? 'two'
          : (n == 4) ? 'few'
          : (n == 6) ? 'many'
          : 'other';
      return (n >= 0 && n <= 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"বছর","relative":{"0":"এই বছর","1":"পরের বছর","-1":"গত বছর"},"relativeTime":{"future":{"one":"{0} বছরে","other":"{0} বছরে"},"past":{"one":"{0} বছর পূর্বে","other":"{0} বছর পূর্বে"}}},"year-short":{"displayName":"বছর","relative":{"0":"এই বছর","1":"পরের বছর","-1":"গত বছর"},"relativeTime":{"future":{"one":"{0} বছরে","other":"{0} বছরে"},"past":{"one":"{0} বছর পূর্বে","other":"{0} বছর পূর্বে"}}},"month":{"displayName":"মাস","relative":{"0":"এই মাস","1":"পরের মাস","-1":"গত মাস"},"relativeTime":{"future":{"one":"{0} মাসে","other":"{0} মাসে"},"past":{"one":"{0} মাস আগে","other":"{0} মাস আগে"}}},"month-short":{"displayName":"মাস","relative":{"0":"এই মাস","1":"পরের মাস","-1":"গত মাস"},"relativeTime":{"future":{"one":"{0} মাসে","other":"{0} মাসে"},"past":{"one":"{0} মাস আগে","other":"{0} মাস আগে"}}},"week":{"displayName":"সপ্তাহ","relativePeriod":"{0} তম সপ্তাহে","relative":{"0":"এই সপ্তাহ","1":"পরের সপ্তাহ","-1":"গত সপ্তাহ"},"relativeTime":{"future":{"one":"{0} সপ্তাহে","other":"{0} সপ্তাহে"},"past":{"one":"{0} সপ্তাহ আগে","other":"{0} সপ্তাহ আগে"}}},"week-short":{"displayName":"সপ্তাহ","relativePeriod":"{0} তম সপ্তাহে","relative":{"0":"এই সপ্তাহ","1":"পরের সপ্তাহ","-1":"গত সপ্তাহ"},"relativeTime":{"future":{"one":"{0} সপ্তাহে","other":"{0} সপ্তাহে"},"past":{"one":"{0} সপ্তাহ আগে","other":"{0} সপ্তাহ আগে"}}},"day":{"displayName":"দিন","relative":{"0":"আজ","1":"আগামীকাল","2":"আগামী পরশু","-2":"গত পরশু","-1":"গতকাল"},"relativeTime":{"future":{"one":"{0} দিনের মধ্যে","other":"{0} দিনের মধ্যে"},"past":{"one":"{0} দিন আগে","other":"{0} দিন আগে"}}},"day-short":{"displayName":"দিন","relative":{"0":"আজ","1":"আগামীকাল","2":"আগামী পরশু","-2":"গত পরশু","-1":"গতকাল"},"relativeTime":{"future":{"one":"{0} দিনের মধ্যে","other":"{0} দিনের মধ্যে"},"past":{"one":"{0} দিন আগে","other":"{0} দিন আগে"}}},"hour":{"displayName":"ঘণ্টা","relative":{"0":"এই ঘণ্টায়"},"relativeTime":{"future":{"one":"{0} ঘন্টায়","other":"{0} ঘন্টায়"},"past":{"one":"{0} ঘন্টা আগে","other":"{0} ঘন্টা আগে"}}},"hour-short":{"displayName":"ঘণ্টা","relative":{"0":"এই ঘণ্টায়"},"relativeTime":{"future":{"one":"{0} ঘন্টায়","other":"{0} ঘন্টায়"},"past":{"one":"{0} ঘন্টা আগে","other":"{0} ঘন্টা আগে"}}},"minute":{"displayName":"মিনিট","relative":{"0":"এই মিনিট"},"relativeTime":{"future":{"one":"{0} মিনিটে","other":"{0} মিনিটে"},"past":{"one":"{0} মিনিট আগে","other":"{0} মিনিট আগে"}}},"minute-short":{"displayName":"মিনিট","relative":{"0":"এই মিনিট"},"relativeTime":{"future":{"one":"{0} মিনিটে","other":"{0} মিনিটে"},"past":{"one":"{0} মিনিট আগে","other":"{0} মিনিট আগে"}}},"second":{"displayName":"সেকেন্ড","relative":{"0":"এখন"},"relativeTime":{"future":{"one":"{0} সেকেন্ডে","other":"{0} সেকেন্ডে"},"past":{"one":"{0} সেকেন্ড পূর্বে","other":"{0} সেকেন্ড পূর্বে"}}},"second-short":{"displayName":"সেকেন্ড","relative":{"0":"এখন"},"relativeTime":{"future":{"one":"{0} সেকেন্ডে","other":"{0} সেকেন্ডে"},"past":{"one":"{0} সেকেন্ড পূর্বে","other":"{0} সেকেন্ড পূর্বে"}}}}},{"locale":"bn-IN","parentLocale":"bn"},
    {"locale":"bo","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"ལོ།","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"ལོ།","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"ཟླ་བ་","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"ཟླ་བ་","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"ཉིན།","relative":{"0":"དེ་རིང་","1":"སང་ཉིན་","2":"གནངས་ཉིན་","-2":"ཁས་ཉིན་","-1":"ཁས་ས་"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"ཉིན།","relative":{"0":"དེ་རིང་","1":"སང་ཉིན་","2":"གནངས་ཉིན་","-2":"ཁས་ཉིན་","-1":"ཁས་ས་"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"ཆུ་ཚོད་","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"ཆུ་ཚོད་","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"སྐར་མ།","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"སྐར་མ།","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"སྐར་ཆ།","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"སྐར་ཆ།","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"bo-IN","parentLocale":"bo"},
    {"locale":"br","pluralRuleFunction":function(n
    ) {
      var s = String(n).split('.'), t0 = Number(s[0]) == n,
          n10 = t0 && s[0].slice(-1), n100 = t0 && s[0].slice(-2),
          n1000000 = t0 && s[0].slice(-6);
      return (n10 == 1 && n100 != 11 && n100 != 71 && n100 != 91) ? 'one'
          : (n10 == 2 && n100 != 12 && n100 != 72 && n100 != 92) ? 'two'
          : (((n10 == 3 || n10 == 4) || n10 == 9) && (n100 < 10
              || n100 > 19) && (n100 < 70 || n100 > 79) && (n100 < 90
              || n100 > 99)) ? 'few'
          : (n != 0 && t0 && n1000000 == 0) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"bloaz","relative":{"0":"hevlene","1":"ar bloaz a zeu","-1":"warlene"},"relativeTime":{"future":{"one":"a-benn {0} bloaz","two":"a-benn {0} vloaz","few":"a-benn {0} bloaz","many":"a-benn {0} a vloazioù","other":"a-benn {0} vloaz"},"past":{"one":"{0} bloaz zo","two":"{0} vloaz zo","few":"{0} bloaz zo","many":"{0} a vloazioù zo","other":"{0} vloaz zo"}}},"year-short":{"displayName":"bl.","relative":{"0":"hevlene","1":"ar bl. a zeu","-1":"warlene"},"relativeTime":{"future":{"one":"a-benn {0} bl.","two":"a-benn {0} bl.","few":"a-benn {0} bl.","many":"a-benn {0} bl.","other":"a-benn {0} bl."},"past":{"one":"{0} bl. zo","two":"{0} bl. zo","few":"{0} bl. zo","many":"{0} bl. zo","other":"{0} bl. zo"}}},"month":{"displayName":"miz","relative":{"0":"ar miz-mañ","1":"ar miz a zeu","-1":"ar miz diaraok"},"relativeTime":{"future":{"one":"a-benn {0} miz","two":"a-benn {0} viz","few":"a-benn {0} miz","many":"a-benn {0} a vizioù","other":"a-benn {0} miz"},"past":{"one":"{0} miz zo","two":"{0} viz zo","few":"{0} miz zo","many":"{0} a vizioù zo","other":"{0} miz zo"}}},"month-short":{"displayName":"miz","relative":{"0":"ar miz-mañ","1":"ar miz a zeu","-1":"ar miz diaraok"},"relativeTime":{"future":{"one":"a-benn {0} miz","two":"a-benn {0} viz","few":"a-benn {0} miz","many":"a-benn {0} a vizioù","other":"a-benn {0} miz"},"past":{"one":"{0} miz zo","two":"{0} viz zo","few":"{0} miz zo","many":"{0} a vizioù zo","other":"{0} miz zo"}}},"week":{"displayName":"sizhun","relativePeriod":"the week of {0}","relative":{"0":"ar sizhun-mañ","1":"ar sizhun a zeu","-1":"ar sizhun diaraok"},"relativeTime":{"future":{"one":"a-benn {0} sizhun","two":"a-benn {0} sizhun","few":"a-benn {0} sizhun","many":"a-benn {0} a sizhunioù","other":"a-benn {0} sizhun"},"past":{"one":"{0} sizhun zo","two":"{0} sizhun zo","few":"{0} sizhun zo","many":"{0} a sizhunioù zo","other":"{0} sizhun zo"}}},"week-short":{"displayName":"sizhun","relativePeriod":"the week of {0}","relative":{"0":"ar sizhun-mañ","1":"ar sizhun a zeu","-1":"ar sizhun diaraok"},"relativeTime":{"future":{"one":"a-benn {0} sizhun","two":"a-benn {0} sizhun","few":"a-benn {0} sizhun","many":"a-benn {0} a sizhunioù","other":"a-benn {0} sizhun"},"past":{"one":"{0} sizhun zo","two":"{0} sizhun zo","few":"{0} sizhun zo","many":"{0} a sizhunioù zo","other":"{0} sizhun zo"}}},"day":{"displayName":"deiz","relative":{"0":"hiziv","1":"warcʼhoazh","-2":"dercʼhent-decʼh","-1":"decʼh"},"relativeTime":{"future":{"one":"a-benn {0} deiz","two":"a-benn {0} zeiz","few":"a-benn {0} deiz","many":"a-benn {0} a zeizioù","other":"a-benn {0} deiz"},"past":{"one":"{0} deiz zo","two":"{0} zeiz zo","few":"{0} deiz zo","many":"{0} a zeizioù zo","other":"{0} deiz zo"}}},"day-short":{"displayName":"d","relative":{"0":"hiziv","1":"warcʼhoazh","-2":"dercʼhent-decʼh","-1":"decʼh"},"relativeTime":{"future":{"one":"a-benn {0} d","two":"a-benn {0} d","few":"a-benn {0} d","many":"a-benn {0} d","other":"a-benn {0} d"},"past":{"one":"{0} d zo","two":"{0} d zo","few":"{0} d zo","many":"{0} d zo","other":"{0} d zo"}}},"hour":{"displayName":"eur","relative":{"0":"dʼan eur-mañ"},"relativeTime":{"future":{"one":"a-benn {0} eur","two":"a-benn {0} eur","few":"a-benn {0} eur","many":"a-benn {0} a eurioù","other":"a-benn {0} eur"},"past":{"one":"{0} eur zo","two":"{0} eur zo","few":"{0} eur zo","many":"{0} a eurioù zo","other":"{0} eur zo"}}},"hour-short":{"displayName":"e","relative":{"0":"dʼan eur-mañ"},"relativeTime":{"future":{"one":"a-benn {0} e","two":"a-benn {0} e","few":"a-benn {0} e","many":"a-benn {0} e","other":"a-benn {0} e"},"past":{"one":"{0} e zo","two":"{0} e zo","few":"{0} e zo","many":"{0} e zo","other":"{0} e zo"}}},"minute":{"displayName":"munut","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"a-benn {0} munut","two":"a-benn {0} vunut","few":"a-benn {0} munut","many":"a-benn {0} a vunutoù","other":"a-benn {0} munut"},"past":{"one":"{0} munut zo","two":"{0} vunut zo","few":"{0} munut zo","many":"{0} a vunutoù zo","other":"{0} munut zo"}}},"minute-short":{"displayName":"min","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"a-benn {0} min","two":"a-benn {0} min","few":"a-benn {0} min","many":"a-benn {0} min","other":"a-benn {0} min"},"past":{"one":"{0} min zo","two":"{0} min zo","few":"{0} min zo","many":"{0} min zo","other":"{0} min zo"}}},"second":{"displayName":"eilenn","relative":{"0":"bremañ"},"relativeTime":{"future":{"one":"a-benn {0} eilenn","two":"a-benn {0} eilenn","few":"a-benn {0} eilenn","many":"a-benn {0} a eilennoù","other":"a-benn {0} eilenn"},"past":{"one":"{0} eilenn zo","two":"{0} eilenn zo","few":"{0} eilenn zo","many":"{0} eilenn zo","other":"{0} eilenn zo"}}},"second-short":{"displayName":"s","relative":{"0":"brem."},"relativeTime":{"future":{"one":"a-benn {0} s","two":"a-benn {0} s","few":"a-benn {0} s","many":"a-benn {0} s","other":"a-benn {0} s"},"past":{"one":"{0} s zo","two":"{0} s zo","few":"{0} s zo","many":"{0} s zo","other":"{0} s zo"}}}}},
    {"locale":"brx","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"बोसोर","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"बोसोर","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"दान","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"दान","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"सबथा\u002Fहबथा","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"सबथा\u002Fहबथा","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"सान","relative":{"0":"दिनै","1":"गाबोन","-1":"मैया"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"सान","relative":{"0":"दिनै","1":"गाबोन","-1":"मैया"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"रिंगा","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"रिंगा","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"मिनिथ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"मिनिथ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"सेखेन्द","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"सेखेन्द","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"bs","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], f = s[1] || '', v0 = !s[1],
          i10 = i.slice(-1), i100 = i.slice(-2), f10 = f.slice(-1), f100 = f.slice(-2);
      if (ord) return 'other';
      return (v0 && i10 == 1 && i100 != 11
              || f10 == 1 && f100 != 11) ? 'one'
          : (v0 && (i10 >= 2 && i10 <= 4) && (i100 < 12 || i100 > 14)
              || (f10 >= 2 && f10 <= 4) && (f100 < 12
              || f100 > 14)) ? 'few'
          : 'other';
    },"fields":{"year":{"displayName":"godina","relative":{"0":"ove godine","1":"sljedeće godine","-1":"prošle godine"},"relativeTime":{"future":{"one":"za {0} godinu","few":"za {0} godine","other":"za {0} godina"},"past":{"one":"prije {0} godinu","few":"prije {0} godine","other":"prije {0} godina"}}},"year-short":{"displayName":"god.","relative":{"0":"ove godine","1":"sljedeće godine","-1":"prošle godine"},"relativeTime":{"future":{"one":"za {0} god.","few":"za {0} god.","other":"za {0} god."},"past":{"one":"prije {0} god.","few":"prije {0} god.","other":"prije {0} god."}}},"month":{"displayName":"mjesec","relative":{"0":"ovaj mjesec","1":"sljedeći mjesec","-1":"prošli mjesec"},"relativeTime":{"future":{"one":"za {0} mjesec","few":"za {0} mjeseca","other":"za {0} mjeseci"},"past":{"one":"prije {0} mjesec","few":"prije {0} mjeseca","other":"prije {0} mjeseci"}}},"month-short":{"displayName":"mj.","relative":{"0":"ovaj mjesec","1":"sljedeći mjesec","-1":"prošli mjesec"},"relativeTime":{"future":{"one":"za {0} mj.","few":"za {0} mj.","other":"za {0} mj."},"past":{"one":"prije {0} mj.","few":"prije {0} mj.","other":"prije {0} mj."}}},"week":{"displayName":"sedmica","relativePeriod":"sedmica u kojoj je {0}","relative":{"0":"ove sedmice","1":"sljedeće sedmice","-1":"prošle sedmice"},"relativeTime":{"future":{"one":"za {0} sedmicu","few":"za {0} sedmice","other":"za {0} sedmica"},"past":{"one":"prije {0} sedmicu","few":"prije {0} sedmice","other":"prije {0} sedmica"}}},"week-short":{"displayName":"sed.","relativePeriod":"sedmica u kojoj je {0}","relative":{"0":"ove sedmice","1":"sljedeće sedmice","-1":"prošle sedmice"},"relativeTime":{"future":{"one":"za {0} sed.","few":"za {0} sed.","other":"za {0} sed."},"past":{"one":"prije {0} sed.","few":"prije {0} sed.","other":"prije {0} sed."}}},"day":{"displayName":"dan","relative":{"0":"danas","1":"sutra","2":"prekosutra","-2":"prekjučer","-1":"jučer"},"relativeTime":{"future":{"one":"za {0} dan","few":"za {0} dana","other":"za {0} dana"},"past":{"one":"prije {0} dan","few":"prije {0} dana","other":"prije {0} dana"}}},"day-short":{"displayName":"dan","relative":{"0":"danas","1":"sutra","2":"prekosutra","-2":"prekjučer","-1":"jučer"},"relativeTime":{"future":{"one":"za {0} d.","few":"za {0} d.","other":"za {0} d."},"past":{"one":"prije {0} d.","few":"prije {0} d.","other":"prije {0} d."}}},"hour":{"displayName":"sat","relative":{"0":"ovaj sat"},"relativeTime":{"future":{"one":"za {0} sat","few":"za {0} sata","other":"za {0} sati"},"past":{"one":"prije {0} sat","few":"prije {0} sata","other":"prije {0} sati"}}},"hour-short":{"displayName":"h","relative":{"0":"ovaj sat"},"relativeTime":{"future":{"one":"za {0} sat","few":"za {0} sata","other":"za {0} sati"},"past":{"one":"prije {0} sat","few":"prije {0} sata","other":"prije {0} sati"}}},"minute":{"displayName":"minuta","relative":{"0":"ova minuta"},"relativeTime":{"future":{"one":"za {0} minutu","few":"za {0} minute","other":"za {0} minuta"},"past":{"one":"prije {0} minutu","few":"prije {0} minute","other":"prije {0} minuta"}}},"minute-short":{"displayName":"min.","relative":{"0":"ova minuta"},"relativeTime":{"future":{"one":"za {0} min.","few":"za {0} min.","other":"za {0} min."},"past":{"one":"prije {0} min.","few":"prije {0} min.","other":"prije {0} min."}}},"second":{"displayName":"sekunda","relative":{"0":"sada"},"relativeTime":{"future":{"one":"za {0} sekundu","few":"za {0} sekunde","other":"za {0} sekundi"},"past":{"one":"prije {0} sekundu","few":"prije {0} sekunde","other":"prije {0} sekundi"}}},"second-short":{"displayName":"sek.","relative":{"0":"sada"},"relativeTime":{"future":{"one":"za {0} sek.","few":"za {0} sek.","other":"za {0} sek."},"past":{"one":"prije {0} sek.","few":"prije {0} sek.","other":"prije {0} sek."}}}}},{"locale":"bs-Cyrl","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"година","relative":{"0":"Ове године","1":"Следеће године","-1":"Прошле године"},"relativeTime":{"future":{"one":"за {0} годину","few":"за {0} године","other":"за {0} година"},"past":{"one":"пре {0} годину","few":"пре {0} године","other":"пре {0} година"}}},"year-short":{"displayName":"година","relative":{"0":"Ове године","1":"Следеће године","-1":"Прошле године"},"relativeTime":{"future":{"one":"за {0} годину","few":"за {0} године","other":"за {0} година"},"past":{"one":"пре {0} годину","few":"пре {0} године","other":"пре {0} година"}}},"month":{"displayName":"месец","relative":{"0":"Овог месеца","1":"Следећег месеца","-1":"Прошлог месеца"},"relativeTime":{"future":{"one":"за {0} месец","few":"за {0} месеца","other":"за {0} месеци"},"past":{"one":"пре {0} месец","few":"пре {0} месеца","other":"пре {0} месеци"}}},"month-short":{"displayName":"месец","relative":{"0":"Овог месеца","1":"Следећег месеца","-1":"Прошлог месеца"},"relativeTime":{"future":{"one":"за {0} месец","few":"за {0} месеца","other":"за {0} месеци"},"past":{"one":"пре {0} месец","few":"пре {0} месеца","other":"пре {0} месеци"}}},"week":{"displayName":"недеља","relativePeriod":"the week of {0}","relative":{"0":"Ове недеље","1":"Следеће недеље","-1":"Прошле недеље"},"relativeTime":{"future":{"one":"за {0} недељу","few":"за {0} недеље","other":"за {0} недеља"},"past":{"one":"пре {0} недељу","few":"пре {0} недеље","other":"пре {0} недеља"}}},"week-short":{"displayName":"недеља","relativePeriod":"the week of {0}","relative":{"0":"Ове недеље","1":"Следеће недеље","-1":"Прошле недеље"},"relativeTime":{"future":{"one":"за {0} недељу","few":"за {0} недеље","other":"за {0} недеља"},"past":{"one":"пре {0} недељу","few":"пре {0} недеље","other":"пре {0} недеља"}}},"day":{"displayName":"дан","relative":{"0":"данас","1":"сутра","2":"прекосутра","-2":"прекјуче","-1":"јуче"},"relativeTime":{"future":{"one":"за {0} дан","few":"за {0} дана","other":"за {0} дана"},"past":{"one":"пре {0} дан","few":"пре {0} дана","other":"пре {0} дана"}}},"day-short":{"displayName":"дан","relative":{"0":"данас","1":"сутра","2":"прекосутра","-2":"прекјуче","-1":"јуче"},"relativeTime":{"future":{"one":"за {0} дан","few":"за {0} дана","other":"за {0} дана"},"past":{"one":"пре {0} дан","few":"пре {0} дана","other":"пре {0} дана"}}},"hour":{"displayName":"час","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"за {0} сат","few":"за {0} сата","other":"за {0} сати"},"past":{"one":"пре {0} сат","few":"пре {0} сата","other":"пре {0} сати"}}},"hour-short":{"displayName":"час","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"за {0} сат","few":"за {0} сата","other":"за {0} сати"},"past":{"one":"пре {0} сат","few":"пре {0} сата","other":"пре {0} сати"}}},"minute":{"displayName":"минут","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"за {0} минут","few":"за {0} минута","other":"за {0} минута"},"past":{"one":"пре {0} минут","few":"пре {0} минута","other":"пре {0} минута"}}},"minute-short":{"displayName":"минут","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"за {0} минут","few":"за {0} минута","other":"за {0} минута"},"past":{"one":"пре {0} минут","few":"пре {0} минута","other":"пре {0} минута"}}},"second":{"displayName":"секунд","relative":{"0":"now"},"relativeTime":{"future":{"one":"за {0} секунд","few":"за {0} секунде","other":"за {0} секунди"},"past":{"one":"пре {0} секунд","few":"пре {0} секунде","other":"пре {0} секунди"}}},"second-short":{"displayName":"секунд","relative":{"0":"now"},"relativeTime":{"future":{"one":"за {0} секунд","few":"за {0} секунде","other":"за {0} секунди"},"past":{"one":"пре {0} секунд","few":"пре {0} секунде","other":"пре {0} секунди"}}}}},{"locale":"bs-Latn","parentLocale":"bs"},
    {"locale":"ca","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      if (ord) return ((n == 1
              || n == 3)) ? 'one'
          : (n == 2) ? 'two'
          : (n == 4) ? 'few'
          : 'other';
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"any","relative":{"0":"enguany","1":"l’any que ve","-1":"l’any passat"},"relativeTime":{"future":{"one":"d’aquí a {0} any","other":"d’aquí a {0} anys"},"past":{"one":"fa {0} any","other":"fa {0} anys"}}},"year-short":{"displayName":"any","relative":{"0":"enguany","1":"l’any que ve","-1":"l’any passat"},"relativeTime":{"future":{"one":"d’aquí a {0} any","other":"d’aquí a {0} anys"},"past":{"one":"fa {0} any","other":"fa {0} anys"}}},"month":{"displayName":"mes","relative":{"0":"aquest mes","1":"el mes que ve","-1":"el mes passat"},"relativeTime":{"future":{"one":"d’aquí a {0} mes","other":"d’aquí a {0} mesos"},"past":{"one":"fa {0} mes","other":"fa {0} mesos"}}},"month-short":{"displayName":"mes","relative":{"0":"aquest mes","1":"el mes que ve","-1":"el mes passat"},"relativeTime":{"future":{"one":"d’aquí a {0} mes","other":"d’aquí a {0} mesos"},"past":{"one":"fa {0} mes","other":"fa {0} mesos"}}},"week":{"displayName":"setmana","relativePeriod":"la setmana del {0}","relative":{"0":"aquesta setmana","1":"la setmana que ve","-1":"la setmana passada"},"relativeTime":{"future":{"one":"d’aquí a {0} setmana","other":"d’aquí a {0} setmanes"},"past":{"one":"fa {0} setmana","other":"fa {0} setmanes"}}},"week-short":{"displayName":"setm.","relativePeriod":"la setmana de: {0}","relative":{"0":"aquesta setm.","1":"la setm. que ve","-1":"la setm. passada"},"relativeTime":{"future":{"one":"d’aquí a {0} setm.","other":"d’aquí a {0} setm."},"past":{"one":"fa {0} setm.","other":"fa {0} setm."}}},"day":{"displayName":"dia","relative":{"0":"avui","1":"demà","2":"demà passat","-2":"abans-d’ahir","-1":"ahir"},"relativeTime":{"future":{"one":"d’aquí a {0} dia","other":"d’aquí a {0} dies"},"past":{"one":"fa {0} dia","other":"fa {0} dies"}}},"day-short":{"displayName":"dia","relative":{"0":"avui","1":"demà","2":"demà passat","-2":"abans-d’ahir","-1":"ahir"},"relativeTime":{"future":{"one":"d’aquí a {0} dia","other":"d’aquí a {0} dies"},"past":{"one":"fa {0} dia","other":"fa {0} dies"}}},"hour":{"displayName":"hora","relative":{"0":"aquesta hora"},"relativeTime":{"future":{"one":"d’aquí a {0} hora","other":"d’aquí a {0} hores"},"past":{"one":"fa {0} hora","other":"fa {0} hores"}}},"hour-short":{"displayName":"h","relative":{"0":"aquesta hora"},"relativeTime":{"future":{"one":"d’aquí a {0} h","other":"d’aquí a {0} h"},"past":{"one":"fa {0} h","other":"fa {0} h"}}},"minute":{"displayName":"minut","relative":{"0":"aquest minut"},"relativeTime":{"future":{"one":"d’aquí a {0} minut","other":"d’aquí a {0} minuts"},"past":{"one":"fa {0} minut","other":"fa {0} minuts"}}},"minute-short":{"displayName":"min","relative":{"0":"aquest minut"},"relativeTime":{"future":{"one":"d’aquí a {0} min","other":"d’aquí a {0} min"},"past":{"one":"fa {0} min","other":"fa {0} min"}}},"second":{"displayName":"segon","relative":{"0":"ara"},"relativeTime":{"future":{"one":"d’aquí a {0} segon","other":"d’aquí a {0} segons"},"past":{"one":"fa {0} segon","other":"fa {0} segons"}}},"second-short":{"displayName":"s","relative":{"0":"ara"},"relativeTime":{"future":{"one":"d’aquí a {0} s","other":"d’aquí a {0} s"},"past":{"one":"fa {0} s","other":"fa {0} s"}}}}},{"locale":"ca-AD","parentLocale":"ca"},{"locale":"ca-ES-VALENCIA","parentLocale":"ca-ES","fields":{"year":{"displayName":"any","relative":{"0":"enguany","1":"l’any que ve","-1":"l’any passat"},"relativeTime":{"future":{"one":"d’aquí a {0} any","other":"d’aquí a {0} anys"},"past":{"one":"fa {0} any","other":"fa {0} anys"}}},"year-short":{"displayName":"any","relative":{"0":"enguany","1":"l’any que ve","-1":"l’any passat"},"relativeTime":{"future":{"one":"d’aquí a {0} any","other":"d’aquí a {0} anys"},"past":{"one":"fa {0} any","other":"fa {0} anys"}}},"month":{"displayName":"mes","relative":{"0":"aquest mes","1":"el mes que ve","-1":"el mes passat"},"relativeTime":{"future":{"one":"d’aquí a {0} mes","other":"d’aquí a {0} mesos"},"past":{"one":"fa {0} mes","other":"fa {0} mesos"}}},"month-short":{"displayName":"mes","relative":{"0":"aquest mes","1":"el mes que ve","-1":"el mes passat"},"relativeTime":{"future":{"one":"d’aquí a {0} mes","other":"d’aquí a {0} mesos"},"past":{"one":"fa {0} mes","other":"fa {0} mesos"}}},"week":{"displayName":"setmana","relativePeriod":"la setmana del {0}","relative":{"0":"aquesta setmana","1":"la setmana que ve","-1":"la setmana passada"},"relativeTime":{"future":{"one":"d’aquí a {0} setmana","other":"d’aquí a {0} setmanes"},"past":{"one":"fa {0} setmana","other":"fa {0} setmanes"}}},"week-short":{"displayName":"setm.","relativePeriod":"la setmana de: {0}","relative":{"0":"aquesta setm.","1":"la setm. que ve","-1":"la setm. passada"},"relativeTime":{"future":{"one":"d’aquí a {0} setm.","other":"d’aquí a {0} setm."},"past":{"one":"fa {0} setm.","other":"fa {0} setm."}}},"day":{"displayName":"dia","relative":{"0":"avui","1":"demà","2":"demà passat","-2":"abans-d’ahir","-1":"ahir"},"relativeTime":{"future":{"one":"d’aquí a {0} dia","other":"d’aquí a {0} dies"},"past":{"one":"fa {0} dia","other":"fa {0} dies"}}},"day-short":{"displayName":"dia","relative":{"0":"avui","1":"demà","2":"demà passat","-2":"abans-d’ahir","-1":"ahir"},"relativeTime":{"future":{"one":"d’aquí a {0} dia","other":"d’aquí a {0} dies"},"past":{"one":"fa {0} dia","other":"fa {0} dies"}}},"hour":{"displayName":"hora","relative":{"0":"aquesta hora"},"relativeTime":{"future":{"one":"d’aquí a {0} hora","other":"d’aquí a {0} hores"},"past":{"one":"fa {0} hora","other":"fa {0} hores"}}},"hour-short":{"displayName":"h","relative":{"0":"aquesta hora"},"relativeTime":{"future":{"one":"d’aquí a {0} h","other":"d’aquí a {0} h"},"past":{"one":"fa {0} h","other":"fa {0} h"}}},"minute":{"displayName":"minut","relative":{"0":"aquest minut"},"relativeTime":{"future":{"one":"d’aquí a {0} minut","other":"d’aquí a {0} minuts"},"past":{"one":"fa {0} minut","other":"fa {0} minuts"}}},"minute-short":{"displayName":"min","relative":{"0":"aquest minut"},"relativeTime":{"future":{"one":"d’aquí a {0} min","other":"d’aquí a {0} min"},"past":{"one":"fa {0} min","other":"fa {0} min"}}},"second":{"displayName":"segon","relative":{"0":"ara"},"relativeTime":{"future":{"one":"d’aquí a {0} segon","other":"d’aquí a {0} segons"},"past":{"one":"fa {0} segon","other":"fa {0} segons"}}},"second-short":{"displayName":"s","relative":{"0":"ara"},"relativeTime":{"future":{"one":"d’aquí a {0} s","other":"d’aquí a {0} s"},"past":{"one":"fa {0} s","other":"fa {0} s"}}}}},{"locale":"ca-ES","parentLocale":"ca"},{"locale":"ca-FR","parentLocale":"ca"},{"locale":"ca-IT","parentLocale":"ca"},
    {"locale":"ccp","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"𑄝𑄧𑄏𑄧𑄢𑄴","relative":{"0":"𑄃𑄬 𑄝𑄧𑄏𑄧𑄢𑄴","1":"𑄎𑄬𑄢𑄧 𑄝𑄧𑄏𑄧𑄢𑄴","-1":"𑄉𑄬𑄣𑄳𑄠𑄬 𑄝𑄧𑄏𑄧𑄢𑄴"},"relativeTime":{"future":{"one":"{0} 𑄝𑄧𑄏𑄧𑄢𑄬","other":"{0} 𑄝𑄧𑄏𑄧𑄢𑄬"},"past":{"one":"{0} 𑄝𑄧𑄏𑄧𑄢𑄴 𑄃𑄉𑄬","other":"{0} 𑄝𑄧𑄏𑄧𑄢𑄴 𑄃𑄉𑄬"}}},"year-short":{"displayName":"𑄝𑄧𑄏𑄧𑄢𑄴","relative":{"0":"𑄃𑄳𑄆𑄬 𑄝𑄧𑄏𑄧𑄢𑄴","1":"𑄛𑄧𑄢𑄬 𑄝𑄧𑄏𑄧𑄢𑄴","-1":"𑄉𑄬𑄣𑄳𑄠𑄬 𑄝𑄧𑄏𑄧𑄢𑄴"},"relativeTime":{"future":{"one":"{0} 𑄝𑄧𑄏𑄧𑄢𑄬","other":"{0} 𑄝𑄧𑄏𑄧𑄢𑄬"},"past":{"one":"{0} 𑄝𑄧𑄏𑄧𑄢𑄴 𑄃𑄉𑄬","other":"{0} 𑄝𑄧𑄏𑄧𑄢𑄴 𑄃𑄉𑄬"}}},"month":{"displayName":"𑄟𑄏𑄴","relative":{"0":"𑄃𑄳𑄆𑄬 𑄟𑄏𑄴","1":"𑄛𑄧𑄢𑄬 𑄟𑄏𑄴","-1":"𑄉𑄬𑄣𑄧𑄘𑄬 𑄟𑄏𑄴"},"relativeTime":{"future":{"one":"{0} 𑄟𑄏𑄬","other":"{0} 𑄟𑄏𑄬"},"past":{"one":"{0} 𑄟𑄏𑄧 𑄃𑄉𑄬","other":"{0} 𑄟𑄏𑄧 𑄃𑄉𑄬"}}},"month-short":{"displayName":"𑄟𑄏𑄴","relative":{"0":"𑄃𑄳𑄆𑄬 𑄟𑄏𑄴","1":"𑄛𑄧𑄢𑄬 𑄟𑄏𑄴","-1":"𑄉𑄬𑄣𑄧𑄉𑄬 𑄟𑄏𑄴"},"relativeTime":{"future":{"one":"{0} 𑄟𑄏𑄬","other":"{0} 𑄟𑄏𑄬"},"past":{"one":"{0} 𑄇𑄏𑄧 𑄃𑄉𑄬","other":"{0} 𑄟𑄏𑄧 𑄃𑄉𑄬"}}},"week":{"displayName":"𑄥𑄛𑄴𑄖","relativePeriod":"{0} 𑄥𑄛𑄴𑄖","relative":{"0":"𑄃𑄳𑄆𑄬 𑄥𑄛𑄴𑄖","1":"𑄛𑄧𑄢𑄬 𑄥𑄛𑄴𑄖","-1":"𑄉𑄬𑄣𑄧𑄘𑄬 𑄥𑄛𑄴𑄖"},"relativeTime":{"future":{"one":"{0} 𑄥𑄛𑄴𑄖𑄠𑄴","other":"{0} 𑄥𑄛𑄴𑄖𑄠𑄴"},"past":{"one":"{0} 𑄥𑄛𑄴𑄖 𑄃𑄉𑄬","other":"{0} 𑄥𑄛𑄴𑄖 𑄃𑄉𑄬"}}},"week-short":{"displayName":"𑄥𑄛𑄴𑄖","relativePeriod":"{0} 𑄃𑄳𑄆𑄬 𑄥𑄛𑄴𑄖𑄠𑄴","relative":{"0":"𑄃𑄳𑄆𑄬 𑄥𑄛𑄴𑄖","1":"𑄛𑄧𑄢𑄬 𑄥𑄛𑄴𑄖","-1":"𑄉𑄬𑄣𑄧𑄘𑄬 𑄥𑄛𑄴𑄖"},"relativeTime":{"future":{"one":"{0} 𑄥𑄛𑄴𑄖𑄠𑄴","other":"{0} 𑄥𑄛𑄴𑄖𑄠𑄴"},"past":{"one":"{0} 𑄥𑄛𑄴𑄖 𑄃𑄉𑄬","other":"{0} 𑄥𑄛𑄴𑄖 𑄃𑄉𑄬"}}},"day":{"displayName":"𑄘𑄨𑄚𑄴","relative":{"0":"𑄃𑄬𑄌𑄴𑄥𑄳𑄠","1":"𑄃𑄬𑄎𑄬𑄖𑄴𑄖𑄳𑄠𑄇𑄬𑄣𑄳𑄠𑄬","2":"𑄃𑄬𑄎𑄬𑄖𑄴𑄖𑄳𑄠𑄬 𑄛𑄧𑄢𑄴𑄥𑄪","-2":"𑄉𑄬𑄣𑄧𑄘𑄬 𑄛𑄧𑄢𑄴𑄥𑄪","-1":"𑄉𑄬𑄣𑄴𑄣𑄳𑄠𑄇𑄬𑄣𑄳𑄠𑄬"},"relativeTime":{"future":{"one":"{0} 𑄘𑄨𑄚𑄮 𑄟𑄧𑄖𑄴𑄙𑄳𑄠","other":"{0} 𑄘𑄨𑄚𑄮 𑄟𑄧𑄖𑄴𑄙𑄳𑄠"},"past":{"one":"{0} 𑄘𑄨𑄚𑄴 𑄃𑄉𑄬","other":"{0} 𑄘𑄨𑄚𑄴 𑄃𑄉𑄬"}}},"day-short":{"displayName":"𑄘𑄨𑄚𑄴","relative":{"0":"𑄃𑄬𑄌𑄴𑄥𑄳𑄠𑄬","1":"𑄃𑄬𑄎𑄬𑄖𑄴𑄖𑄳𑄠𑄇𑄬𑄣𑄴𑄣𑄳𑄠𑄬","2":"𑄃𑄬𑄎𑄬𑄖𑄴𑄖𑄳𑄠𑄇𑄬𑄣𑄴𑄣𑄳𑄠𑄬 𑄛𑄧𑄢𑄴𑄥𑄪","-2":"𑄉𑄬𑄣𑄧𑄘𑄬 𑄛𑄧𑄢𑄴𑄥𑄪","-1":"𑄉𑄬𑄣𑄴𑄣𑄳𑄠𑄇𑄬𑄣𑄴𑄣𑄳𑄠𑄬"},"relativeTime":{"future":{"one":"{0} 𑄘𑄨𑄚𑄮 𑄟𑄧𑄖𑄴𑄙𑄳𑄠","other":"{0} 𑄘𑄨𑄚𑄮 𑄟𑄧𑄖𑄴𑄙𑄳𑄠"},"past":{"one":"{0} 𑄘𑄨𑄚𑄴 𑄃𑄉𑄬","other":"{0} 𑄘𑄨𑄚𑄴 𑄃𑄉𑄬"}}},"hour":{"displayName":"𑄊𑄮𑄚𑄴𑄓","relative":{"0":"𑄃𑄳𑄆𑄬 𑄊𑄮𑄚𑄴𑄓𑄠𑄴"},"relativeTime":{"future":{"one":"{0} 𑄊𑄮𑄚𑄴𑄓𑄠𑄴","other":"{0} 𑄊𑄮𑄚𑄴𑄓𑄠𑄴"},"past":{"one":"{0} 𑄊𑄮𑄚𑄴𑄓 𑄃𑄉𑄬","other":"{0} 𑄊𑄮𑄚𑄴𑄓 𑄃𑄉𑄬"}}},"hour-short":{"displayName":"𑄊𑄮𑄚𑄴𑄓","relative":{"0":"𑄃𑄳𑄆𑄬 𑄊𑄮𑄚𑄴𑄓𑄠𑄴"},"relativeTime":{"future":{"one":"{0} 𑄊𑄮𑄚𑄴𑄓𑄠𑄴","other":"{0} 𑄊𑄮𑄚𑄴𑄓𑄠𑄴"},"past":{"one":"{0} 𑄊𑄮𑄚𑄴𑄓 𑄃𑄉𑄬","other":"{0} 𑄊𑄮𑄚𑄴𑄓 𑄃𑄉𑄬"}}},"minute":{"displayName":"𑄟𑄨𑄚𑄨𑄖𑄴","relative":{"0":"𑄃𑄳𑄆𑄬 𑄟𑄨𑄚𑄨𑄖𑄴"},"relativeTime":{"future":{"one":"{0} 𑄟𑄨𑄚𑄨𑄘𑄬","other":"{0} 𑄟𑄨𑄚𑄨𑄘𑄬"},"past":{"one":"{0} 𑄟𑄨𑄚𑄨𑄖𑄴 𑄃𑄉𑄬","other":"{0} 𑄟𑄨𑄚𑄨𑄖𑄴 𑄃𑄉𑄬"}}},"minute-short":{"displayName":"𑄟𑄨𑄚𑄨𑄖𑄴","relative":{"0":"𑄃𑄳𑄆𑄬 𑄟𑄨𑄚𑄨𑄖𑄴"},"relativeTime":{"future":{"one":"{0} 𑄟𑄨𑄚𑄨𑄘𑄬","other":"{0} 𑄟𑄨𑄚𑄨𑄘𑄬"},"past":{"one":"{0} 𑄟𑄨𑄚𑄨𑄖𑄴 𑄃𑄉𑄬","other":"{0} 𑄟𑄨𑄚𑄨𑄖𑄴 𑄃𑄉𑄬"}}},"second":{"displayName":"𑄥𑄬𑄉𑄬𑄚𑄴","relative":{"0":"𑄃𑄨𑄇𑄴𑄅𑄚𑄪"},"relativeTime":{"future":{"one":"{0} 𑄥𑄬𑄉𑄬𑄚𑄴𑄘𑄬","other":"{0} 𑄥𑄬𑄉𑄬𑄚𑄴𑄘𑄬"},"past":{"one":"{0} 𑄥𑄬𑄉𑄬𑄚𑄴 𑄃𑄉𑄬","other":"{0} 𑄥𑄬𑄉𑄬𑄚𑄴 𑄃𑄉𑄬"}}},"second-short":{"displayName":"𑄥𑄬𑄉𑄬𑄚𑄴","relative":{"0":"𑄃𑄨𑄇𑄴𑄅𑄚𑄪"},"relativeTime":{"future":{"one":"{0} 𑄥𑄬𑄉𑄬𑄚𑄴𑄘𑄬","other":"{0} 𑄥𑄬𑄉𑄬𑄚𑄴𑄘𑄬"},"past":{"one":"{0} 𑄥𑄬𑄉𑄬𑄚𑄴 𑄃𑄉𑄬","other":"{0} 𑄥𑄬𑄉𑄬𑄚𑄴 𑄃𑄉𑄬"}}}}},{"locale":"ccp-IN","parentLocale":"ccp"},
    {"locale":"ce","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"шо","relative":{"0":"карарчу шарахь","1":"рогӀерчу шарахь","-1":"даханчу шарахь"},"relativeTime":{"future":{"one":"{0} шо даьлча","other":"{0} шо даьлча"},"past":{"one":"{0} шо хьалха","other":"{0} шо хьалха"}}},"year-short":{"displayName":"ш.","relative":{"0":"карарчу шарахь","1":"рогӀерчу шарахь","-1":"даханчу шарахь"},"relativeTime":{"future":{"one":"{0} ш. даьлча","other":"{0} ш. даьлча"},"past":{"one":"{0} ш. хьалха","other":"{0} ш. хьалха"}}},"month":{"displayName":"бутт","relative":{"0":"карарчу баттахь","1":"рогӀерчу баттахь","-1":"баханчу баттахь"},"relativeTime":{"future":{"one":"{0} бутт баьлча","other":"{0} бутт баьлча"},"past":{"one":"{0} бутт хьалха","other":"{0} бутт хьалха"}}},"month-short":{"displayName":"бут.","relative":{"0":"карарчу баттахь","1":"рогӀерчу баттахь","-1":"баханчу баттахь"},"relativeTime":{"future":{"one":"{0} б. баьлча","other":"{0} б. баьлча"},"past":{"one":"{0} б. хьалха","other":"{0} б. хьалха"}}},"week":{"displayName":"кӀира","relativePeriod":"the week of {0}","relative":{"0":"карарчу кӀирнахь","1":"рогӀерчу кӀирнахь","-1":"даханчу кӀирнахь"},"relativeTime":{"future":{"one":"{0} кӀира даьлча","other":"{0} кӀира даьлча"},"past":{"one":"{0} кӀира хьалха","other":"{0} кӀира хьалха"}}},"week-short":{"displayName":"кӀир.","relativePeriod":"кӀирнахь","relative":{"0":"карарчу кӀирнахь","1":"рогӀерчу кӀирнахь","-1":"даханчу кӀирнахь"},"relativeTime":{"future":{"one":"{0} кӀир. даьлча","other":"{0} кӀир. даьлча"},"past":{"one":"{0} кӀир. хьалха","other":"{0} кӀир. хьалха"}}},"day":{"displayName":"де","relative":{"0":"тахана","1":"кхана","-1":"селхана"},"relativeTime":{"future":{"one":"{0} де даьлча","other":"{0} де даьлча"},"past":{"one":"{0} де хьалха","other":"{0} де хьалха"}}},"day-short":{"displayName":"де","relative":{"0":"тахана","1":"кхана","-1":"селхана"},"relativeTime":{"future":{"one":"{0} д. даьлча","other":"{0} д. даьлча"},"past":{"one":"{0} д. хьалха","other":"{0} де хьалха"}}},"hour":{"displayName":"сахьт","relative":{"0":"хӀокху сахьтехь"},"relativeTime":{"future":{"one":"{0} сахьт даьлча","other":"{0} сахьт даьлча"},"past":{"one":"{0} сахьт хьалха","other":"{0} сахьт хьалха"}}},"hour-short":{"displayName":"сахь.","relative":{"0":"хӀокху сахьтехь"},"relativeTime":{"future":{"one":"{0} сахь. даьлча","other":"{0} сахь. даьлча"},"past":{"one":"{0} сахь. хьалха","other":"{0} сахь. хьалха"}}},"minute":{"displayName":"минот","relative":{"0":"хӀокху минотехь"},"relativeTime":{"future":{"one":"{0} минот яьлча","other":"{0} минот яьлча"},"past":{"one":"{0} минот хьалха","other":"{0} минот хьалха"}}},"minute-short":{"displayName":"мин.","relative":{"0":"хӀокху минотехь"},"relativeTime":{"future":{"one":"{0} мин. яьлча","other":"{0} мин. яьлча"},"past":{"one":"{0} мин. хьалха","other":"{0} мин. хьалха"}}},"second":{"displayName":"секунд","relative":{"0":"хӀинца"},"relativeTime":{"future":{"one":"{0} секунд яьлча","other":"{0} секунд яьлча"},"past":{"one":"{0} секунд хьалха","other":"{0} секунд хьалха"}}},"second-short":{"displayName":"сек.","relative":{"0":"хӀинца"},"relativeTime":{"future":{"one":"{0} сек. яьлча","other":"{0} сек. яьлча"},"past":{"one":"{0} сек. хьалха","other":"{0} сек. хьалха"}}}}},
    {"locale":"cgg","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Omwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Omwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Omwezi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Omwezi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Esande","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Esande","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Eizooba","relative":{"0":"Erizooba","1":"Nyenkyakare","-1":"Nyomwabazyo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Eizooba","relative":{"0":"Erizooba","1":"Nyenkyakare","-1":"Nyomwabazyo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Shaaha","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Shaaha","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Edakiika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Edakiika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Obucweka\u002FEsekendi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Obucweka\u002FEsekendi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"chr","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ᎤᏕᏘᏴᏌᏗᏒᎢ","relative":{"0":"ᎯᎠ ᏧᏕᏘᏴᏒᏘ","1":"ᎡᏘᏴᎢ","-1":"ᎡᏘ ᏥᎨᏒ"},"relativeTime":{"future":{"one":"ᎾᎿ {0} ᎤᏕᏘᏴᏌᏗᏒᎢ","other":"ᎾᎿ {0} ᎢᏧᏕᏘᏴᏌᏗᏒᎢ"},"past":{"one":"{0} ᎤᏕᏘᏴᏌᏗᏒᎢ ᏥᎨᏒ","other":"{0} ᎢᏧᏕᏘᏴᏌᏗᏒᎢ ᏥᎨᏒ"}}},"year-short":{"displayName":"ᎤᏕ.","relative":{"0":"ᎯᎠ ᏧᏕᏘᏴᏒᏘ","1":"ᎡᏘᏴᎢ","-1":"ᎡᏘ ᏥᎨᏒ"},"relativeTime":{"future":{"one":"ᎾᎿ {0} ᎤᏕ.","other":"ᎾᎿ {0} ᎤᏕ."},"past":{"one":"{0} ᎤᏕ. ᏥᎨᏒ","other":"{0} ᎤᏕ. ᏥᎨᏒ"}}},"month":{"displayName":"ᎧᎸᎢ","relative":{"0":"ᎯᎠ ᎧᎸᎢ","1":"ᏔᎵᏁ ᎧᎸᎢ","-1":"ᎧᎸᎢ ᏥᎨᏒ"},"relativeTime":{"future":{"one":"ᎾᎿ {0} ᎧᎸᎢ","other":"ᎾᎿ {0} ᏗᎧᎸᎢ"},"past":{"one":"{0} ᎧᎸᎢ ᏥᎨᏒ","other":"{0} ᏗᎧᎸᎢ ᏥᎨᏒ"}}},"month-short":{"displayName":"ᎧᎸ.","relative":{"0":"ᎯᎠ ᎧᎸᎢ","1":"ᏔᎵᏁ ᎧᎸᎢ","-1":"ᎧᎸᎢ ᏥᎨᏒ"},"relativeTime":{"future":{"one":"ᎾᎿ {0} ᎧᎸ.","other":"ᎾᎿ {0} ᎧᎸ."},"past":{"one":"{0} ᎧᎸ. ᏥᎨᏒ","other":"{0} ᎧᎸ. ᏥᎨᏒ"}}},"week":{"displayName":"ᏒᎾᏙᏓᏆᏍᏗ","relativePeriod":"Ꮎ ᏒᎾᏙᏓᏆᏍᏗ ᎾᏍᎩ {0}","relative":{"0":"ᎯᎠ ᎠᎵᎵᏌ","1":"ᏐᏆᎴᏅᎲ","-1":"ᏥᏛᎵᏱᎵᏒᎢ"},"relativeTime":{"future":{"one":"ᎾᎿ {0} ᏒᎾᏙᏓᏆᏍᏗ","other":"ᎾᎿ {0} ᎢᏳᎾᏙᏓᏆᏍᏗ"},"past":{"one":"{0} ᏒᎾᏙᏓᏆᏍᏗ ᏥᎨᏒ","other":"{0} ᎢᏳᎾᏙᏓᏆᏍᏗ ᏥᎨᏒ"}}},"week-short":{"displayName":"ᏒᎾ.","relativePeriod":"Ꮎ ᏒᎾᏙᏓᏆᏍᏗ ᎾᏍᎩ {0}","relative":{"0":"ᎯᎠ ᎠᎵᎵᏌ","1":"ᏐᏆᎴᏅᎲ","-1":"ᏥᏛᎵᏱᎵᏒᎢ"},"relativeTime":{"future":{"one":"ᎾᎿ {0} ᏒᎾ.","other":"ᎾᎿ {0} ᏒᎾ."},"past":{"one":"{0} ᏒᎾ. ᏥᎨᏒ","other":"{0} ᏒᎾ. ᏥᎨᏒ"}}},"day":{"displayName":"ᎢᎦ","relative":{"0":"ᎪᎯ ᎢᎦ","1":"ᏌᎾᎴᎢ","-1":"ᏒᎯ"},"relativeTime":{"future":{"one":"ᎾᎿ {0} ᎢᎦ","other":"ᎾᎿ {0} ᎯᎸᏍᎩ ᏧᏒᎯᏛ"},"past":{"one":"{0} ᎢᎦ ᏥᎨᏒ","other":"{0} ᎯᎸᏍᎩ ᏧᏒᎯᏛ ᏥᎨᏒ"}}},"day-short":{"displayName":"ᎢᎦ","relative":{"0":"ᎪᎯ ᎢᎦ","1":"ᏌᎾᎴᎢ","-1":"ᏒᎯ"},"relativeTime":{"future":{"one":"ᎾᎿ {0} ᎢᎦ","other":"ᎾᎿ {0} ᎯᎸᏍᎩ ᏧᏒᎯᏛ"},"past":{"one":"{0} ᎢᎦ ᏥᎨᏒ","other":"{0} ᎯᎸᏍᎩ ᏧᏒᎯᏛ ᏥᎨᏒ"}}},"hour":{"displayName":"ᏑᏟᎶᏓ","relative":{"0":"ᎯᎠ ᏑᏟᎶᏓ"},"relativeTime":{"future":{"one":"ᎾᎿ {0} ᏑᏟᎶᏓ","other":"ᎾᎿ {0} ᎢᏳᏟᎶᏓ"},"past":{"one":"{0} ᏑᏟᎶᏓ ᏥᎨᏒ","other":"{0} ᎢᏳᏟᎶᏓ ᏥᎨᏒ"}}},"hour-short":{"displayName":"ᏑᏟ.","relative":{"0":"ᎯᎠ ᏑᏟᎶᏓ"},"relativeTime":{"future":{"one":"ᎾᎿ {0} ᏑᏟ.","other":"ᎾᎿ {0} ᏑᏟ."},"past":{"one":"{0} ᏑᏟ. ᏥᎨᏒ","other":"{0} ᏑᏟ. ᏥᎨᏒ"}}},"minute":{"displayName":"ᎢᏯᏔᏬᏍᏔᏅ","relative":{"0":"ᎯᎠ ᎢᏯᏔᏬᏍᏔᏅ"},"relativeTime":{"future":{"one":"ᎾᎿ {0} ᎢᏯᏔᏬᏍᏔᏅ","other":"ᎾᎿ {0} ᎢᏯᏔᏬᏍᏔᏅ"},"past":{"one":"{0} ᎢᏯᏔᏬᏍᏔᏅ ᏥᎨᏒ","other":"{0} ᎢᏯᏔᏬᏍᏔᏅ ᏥᎨᏒ"}}},"minute-short":{"displayName":"ᎢᏯᏔ.","relative":{"0":"ᎯᎠ ᎢᏯᏔᏬᏍᏔᏅ"},"relativeTime":{"future":{"one":"ᎾᎿ {0} ᎢᏯᏔ.","other":"ᎾᎿ {0} ᎢᏯᏔ."},"past":{"one":"{0} ᎢᏯᏔ. ᏥᎨᏒ","other":"{0} ᎢᏯᏔ. ᏥᎨᏒ"}}},"second":{"displayName":"ᎠᏎᏢ","relative":{"0":"ᏃᏊ"},"relativeTime":{"future":{"one":"ᎾᎿ {0} ᎠᏎᏢ","other":"ᎾᎿ {0} ᏓᏓᎾᏩᏍᎬ ᏥᎨᏒ"},"past":{"one":"{0} ᎠᏎᏢ ᏥᎨᏒ","other":"{0} ᏓᏓᎾᏩᏍᎬ ᏥᎨᏒ"}}},"second-short":{"displayName":"ᎠᏎ.","relative":{"0":"ᏃᏊ"},"relativeTime":{"future":{"one":"ᎾᎿ {0} ᎠᏎ.","other":"ᎾᎿ {0} ᎠᏎ."},"past":{"one":"{0} ᎠᏎ. ᏥᎨᏒ","other":"{0} ᎠᏎ. ᏥᎨᏒ"}}}}},
    {"locale":"ckb","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"ckb-IR","parentLocale":"ckb"},
    {"locale":"cs","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], v0 = !s[1];
      if (ord) return 'other';
      return (n == 1 && v0) ? 'one'
          : ((i >= 2 && i <= 4) && v0) ? 'few'
          : (!v0) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"rok","relative":{"0":"tento rok","1":"příští rok","-1":"minulý rok"},"relativeTime":{"future":{"one":"za {0} rok","few":"za {0} roky","many":"za {0} roku","other":"za {0} let"},"past":{"one":"před {0} rokem","few":"před {0} lety","many":"před {0} roku","other":"před {0} lety"}}},"year-short":{"displayName":"r.","relative":{"0":"tento rok","1":"příští rok","-1":"minulý rok"},"relativeTime":{"future":{"one":"za {0} r.","few":"za {0} r.","many":"za {0} r.","other":"za {0} l."},"past":{"one":"před {0} r.","few":"před {0} r.","many":"před {0} r.","other":"před {0} l."}}},"month":{"displayName":"měsíc","relative":{"0":"tento měsíc","1":"příští měsíc","-1":"minulý měsíc"},"relativeTime":{"future":{"one":"za {0} měsíc","few":"za {0} měsíce","many":"za {0} měsíce","other":"za {0} měsíců"},"past":{"one":"před {0} měsícem","few":"před {0} měsíci","many":"před {0} měsíce","other":"před {0} měsíci"}}},"month-short":{"displayName":"měs.","relative":{"0":"tento měs.","1":"příští měs.","-1":"minulý měs."},"relativeTime":{"future":{"one":"za {0} měs.","few":"za {0} měs.","many":"za {0} měs.","other":"za {0} měs."},"past":{"one":"před {0} měs.","few":"před {0} měs.","many":"před {0} měs.","other":"před {0} měs."}}},"week":{"displayName":"týden","relativePeriod":"v týdnu {0}","relative":{"0":"tento týden","1":"příští týden","-1":"minulý týden"},"relativeTime":{"future":{"one":"za {0} týden","few":"za {0} týdny","many":"za {0} týdne","other":"za {0} týdnů"},"past":{"one":"před {0} týdnem","few":"před {0} týdny","many":"před {0} týdne","other":"před {0} týdny"}}},"week-short":{"displayName":"týd.","relativePeriod":"v týd. {0}","relative":{"0":"tento týd.","1":"příští týd.","-1":"minulý týd."},"relativeTime":{"future":{"one":"za {0} týd.","few":"za {0} týd.","many":"za {0} týd.","other":"za {0} týd."},"past":{"one":"před {0} týd.","few":"před {0} týd.","many":"před {0} týd.","other":"před {0} týd."}}},"day":{"displayName":"den","relative":{"0":"dnes","1":"zítra","2":"pozítří","-2":"předevčírem","-1":"včera"},"relativeTime":{"future":{"one":"za {0} den","few":"za {0} dny","many":"za {0} dne","other":"za {0} dní"},"past":{"one":"před {0} dnem","few":"před {0} dny","many":"před {0} dne","other":"před {0} dny"}}},"day-short":{"displayName":"den","relative":{"0":"dnes","1":"zítra","2":"pozítří","-2":"předevčírem","-1":"včera"},"relativeTime":{"future":{"one":"za {0} den","few":"za {0} dny","many":"za {0} dne","other":"za {0} dní"},"past":{"one":"před {0} dnem","few":"před {0} dny","many":"před {0} dne","other":"před {0} dny"}}},"hour":{"displayName":"hodina","relative":{"0":"tuto hodinu"},"relativeTime":{"future":{"one":"za {0} hodinu","few":"za {0} hodiny","many":"za {0} hodiny","other":"za {0} hodin"},"past":{"one":"před {0} hodinou","few":"před {0} hodinami","many":"před {0} hodiny","other":"před {0} hodinami"}}},"hour-short":{"displayName":"h","relative":{"0":"tuto hodinu"},"relativeTime":{"future":{"one":"za {0} h","few":"za {0} h","many":"za {0} h","other":"za {0} h"},"past":{"one":"před {0} h","few":"před {0} h","many":"před {0} h","other":"před {0} h"}}},"minute":{"displayName":"minuta","relative":{"0":"tuto minutu"},"relativeTime":{"future":{"one":"za {0} minutu","few":"za {0} minuty","many":"za {0} minuty","other":"za {0} minut"},"past":{"one":"před {0} minutou","few":"před {0} minutami","many":"před {0} minuty","other":"před {0} minutami"}}},"minute-short":{"displayName":"min","relative":{"0":"tuto minutu"},"relativeTime":{"future":{"one":"za {0} min","few":"za {0} min","many":"za {0} min","other":"za {0} min"},"past":{"one":"před {0} min","few":"před {0} min","many":"před {0} min","other":"před {0} min"}}},"second":{"displayName":"sekunda","relative":{"0":"nyní"},"relativeTime":{"future":{"one":"za {0} sekundu","few":"za {0} sekundy","many":"za {0} sekundy","other":"za {0} sekund"},"past":{"one":"před {0} sekundou","few":"před {0} sekundami","many":"před {0} sekundy","other":"před {0} sekundami"}}},"second-short":{"displayName":"s","relative":{"0":"nyní"},"relativeTime":{"future":{"one":"za {0} s","few":"za {0} s","many":"za {0} s","other":"za {0} s"},"past":{"one":"před {0} s","few":"před {0} s","many":"před {0} s","other":"před {0} s"}}}}},
    {"locale":"cu","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"cy","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return ((n == 0 || n == 7 || n == 8
              || n == 9)) ? 'zero'
          : (n == 1) ? 'one'
          : (n == 2) ? 'two'
          : ((n == 3
              || n == 4)) ? 'few'
          : ((n == 5
              || n == 6)) ? 'many'
          : 'other';
      return (n == 0) ? 'zero'
          : (n == 1) ? 'one'
          : (n == 2) ? 'two'
          : (n == 3) ? 'few'
          : (n == 6) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"blwyddyn","relative":{"0":"eleni","1":"blwyddyn nesaf","-1":"llynedd"},"relativeTime":{"future":{"zero":"ymhen {0} mlynedd","one":"ymhen blwyddyn","two":"ymhen {0} flynedd","few":"ymhen {0} blynedd","many":"ymhen {0} blynedd","other":"ymhen {0} mlynedd"},"past":{"zero":"{0} o flynyddoedd yn ôl","one":"blwyddyn yn ôl","two":"{0} flynedd yn ôl","few":"{0} blynedd yn ôl","many":"{0} blynedd yn ôl","other":"{0} o flynyddoedd yn ôl"}}},"year-short":{"displayName":"bl.","relative":{"0":"eleni","1":"blwyddyn nesaf","-1":"llynedd"},"relativeTime":{"future":{"zero":"ymhen {0} mlynedd","one":"ymhen blwyddyn","two":"ymhen {0} flynedd","few":"ymhen {0} blynedd","many":"ymhen {0} blynedd","other":"ymhen {0} mlynedd"},"past":{"zero":"{0} o flynyddoedd yn ôl","one":"blwyddyn yn ôl","two":"{0} flynedd yn ôl","few":"{0} blynedd yn ôl","many":"{0} blynedd yn ôl","other":"{0} o flynyddoedd yn ôl"}}},"month":{"displayName":"mis","relative":{"0":"y mis hwn","1":"mis nesaf","-1":"mis diwethaf"},"relativeTime":{"future":{"zero":"ymhen {0} mis","one":"ymhen mis","two":"ymhen deufis","few":"ymhen {0} mis","many":"ymhen {0} mis","other":"ymhen {0} mis"},"past":{"zero":"{0} mis yn ôl","one":"{0} mis yn ôl","two":"{0} fis yn ôl","few":"{0} mis yn ôl","many":"{0} mis yn ôl","other":"{0} mis yn ôl"}}},"month-short":{"displayName":"mis","relative":{"0":"y mis hwn","1":"mis nesaf","-1":"mis diwethaf"},"relativeTime":{"future":{"zero":"ymhen {0} mis","one":"ymhen mis","two":"ymhen deufis","few":"ymhen {0} mis","many":"ymhen {0} mis","other":"ymhen {0} mis"},"past":{"zero":"{0} mis yn ôl","one":"{0} mis yn ôl","two":"deufis yn ôl","few":"{0} mis yn ôl","many":"{0} mis yn ôl","other":"{0} mis yn ôl"}}},"week":{"displayName":"wythnos","relativePeriod":"wythnos {0}","relative":{"0":"yr wythnos hon","1":"wythnos nesaf","-1":"wythnos ddiwethaf"},"relativeTime":{"future":{"zero":"ymhen {0} wythnos","one":"ymhen wythnos","two":"ymhen pythefnos","few":"ymhen {0} wythnos","many":"ymhen {0} wythnos","other":"ymhen {0} wythnos"},"past":{"zero":"{0} wythnos yn ôl","one":"{0} wythnos yn ôl","two":"{0} wythnos yn ôl","few":"{0} wythnos yn ôl","many":"{0} wythnos yn ôl","other":"{0} wythnos yn ôl"}}},"week-short":{"displayName":"wythnos","relativePeriod":"wythnos {0}","relative":{"0":"yr wythnos hon","1":"wythnos nesaf","-1":"wythnos ddiwethaf"},"relativeTime":{"future":{"zero":"ymhen {0} wythnos","one":"ymhen wythnos","two":"ymhen pythefnos","few":"ymhen {0} wythnos","many":"ymhen {0} wythnos","other":"ymhen {0} wythnos"},"past":{"zero":"{0} wythnos yn ôl","one":"{0} wythnos yn ôl","two":"pythefnos yn ôl","few":"{0} wythnos yn ôl","many":"{0} wythnos yn ôl","other":"{0} wythnos yn ôl"}}},"day":{"displayName":"diwrnod","relative":{"0":"heddiw","1":"yfory","2":"drennydd","-2":"echdoe","-1":"ddoe"},"relativeTime":{"future":{"zero":"ymhen {0} diwrnod","one":"ymhen diwrnod","two":"ymhen deuddydd","few":"ymhen {0} diwrnod","many":"ymhen {0} diwrnod","other":"ymhen {0} diwrnod"},"past":{"zero":"{0} diwrnod yn ôl","one":"{0} diwrnod yn ôl","two":"{0} ddiwrnod yn ôl","few":"{0} diwrnod yn ôl","many":"{0} diwrnod yn ôl","other":"{0} diwrnod yn ôl"}}},"day-short":{"displayName":"diwrnod","relative":{"0":"heddiw","1":"yfory","2":"drennydd","-2":"echdoe","-1":"ddoe"},"relativeTime":{"future":{"zero":"ymhen {0} diwrnod","one":"ymhen diwrnod","two":"ymhen deuddydd","few":"ymhen {0} diwrnod","many":"ymhen {0} diwrnod","other":"ymhen {0} diwrnod"},"past":{"zero":"{0} diwrnod yn ôl","one":"{0} diwrnod yn ôl","two":"{0} ddiwrnod yn ôl","few":"{0} diwrnod yn ôl","many":"{0} diwrnod yn ôl","other":"{0} diwrnod yn ôl"}}},"hour":{"displayName":"awr","relative":{"0":"yr awr hon"},"relativeTime":{"future":{"zero":"ymhen {0} awr","one":"ymhen awr","two":"ymhen {0} awr","few":"ymhen {0} awr","many":"ymhen {0} awr","other":"ymhen {0} awr"},"past":{"zero":"{0} awr yn ôl","one":"{0} awr yn ôl","two":"{0} awr yn ôl","few":"{0} awr yn ôl","many":"{0} awr yn ôl","other":"{0} awr yn ôl"}}},"hour-short":{"displayName":"awr","relative":{"0":"yr awr hon"},"relativeTime":{"future":{"zero":"ymhen {0} awr","one":"ymhen awr","two":"ymhen {0} awr","few":"ymhen {0} awr","many":"ymhen {0} awr","other":"ymhen {0} awr"},"past":{"zero":"{0} awr yn ôl","one":"awr yn ôl","two":"{0} awr yn ôl","few":"{0} awr yn ôl","many":"{0} awr yn ôl","other":"{0} awr yn ôl"}}},"minute":{"displayName":"munud","relative":{"0":"y funud hon"},"relativeTime":{"future":{"zero":"ymhen {0} munud","one":"ymhen {0} munud","two":"ymhen {0} munud","few":"ymhen {0} munud","many":"ymhen {0} munud","other":"ymhen {0} munud"},"past":{"zero":"{0} munud yn ôl","one":"{0} munud yn ôl","two":"{0} munud yn ôl","few":"{0} munud yn ôl","many":"{0} munud yn ôl","other":"{0} munud yn ôl"}}},"minute-short":{"displayName":"mun.","relative":{"0":"y funud hon"},"relativeTime":{"future":{"zero":"ymhen {0} munud","one":"ymhen {0} mun.","two":"ymhen {0} fun.","few":"ymhen {0} munud","many":"ymhen {0} munud","other":"ymhen {0} munud"},"past":{"zero":"{0} munud yn ôl","one":"{0} munud yn ôl","two":"{0} fun. yn ôl","few":"{0} munud yn ôl","many":"{0} munud yn ôl","other":"{0} munud yn ôl"}}},"second":{"displayName":"eiliad","relative":{"0":"nawr"},"relativeTime":{"future":{"zero":"ymhen {0} eiliad","one":"ymhen {0} eiliad","two":"ymhen {0} eiliad","few":"ymhen {0} eiliad","many":"ymhen {0} eiliad","other":"ymhen {0} eiliad"},"past":{"zero":"{0} eiliad yn ôl","one":"{0} eiliad yn ôl","two":"{0} eiliad yn ôl","few":"{0} eiliad yn ôl","many":"{0} eiliad yn ôl","other":"{0} eiliad yn ôl"}}},"second-short":{"displayName":"eiliad","relative":{"0":"nawr"},"relativeTime":{"future":{"zero":"ymhen {0} eiliad","one":"ymhen {0} eiliad","two":"ymhen {0} eiliad","few":"ymhen {0} eiliad","many":"ymhen {0} eiliad","other":"ymhen {0} eiliad"},"past":{"zero":"{0} eiliad yn ôl","one":"{0} eiliad yn ôl","two":"{0} eiliad yn ôl","few":"{0} eiliad yn ôl","many":"{0} eiliad yn ôl","other":"{0} eiliad yn ôl"}}}}},
    {"locale":"da","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], t0 = Number(s[0]) == n;
      if (ord) return 'other';
      return (n == 1 || !t0 && (i == 0
              || i == 1)) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"år","relative":{"0":"i år","1":"næste år","-1":"sidste år"},"relativeTime":{"future":{"one":"om {0} år","other":"om {0} år"},"past":{"one":"for {0} år siden","other":"for {0} år siden"}}},"year-short":{"displayName":"år","relative":{"0":"i år","1":"næste år","-1":"sidste år"},"relativeTime":{"future":{"one":"om {0} år","other":"om {0} år"},"past":{"one":"for {0} år siden","other":"for {0} år siden"}}},"month":{"displayName":"måned","relative":{"0":"denne måned","1":"næste måned","-1":"sidste måned"},"relativeTime":{"future":{"one":"om {0} måned","other":"om {0} måneder"},"past":{"one":"for {0} måned siden","other":"for {0} måneder siden"}}},"month-short":{"displayName":"md.","relative":{"0":"denne md.","1":"næste md.","-1":"sidste md."},"relativeTime":{"future":{"one":"om {0} md.","other":"om {0} mdr."},"past":{"one":"for {0} md. siden","other":"for {0} mdr. siden"}}},"week":{"displayName":"uge","relativePeriod":"i ugen med {0}","relative":{"0":"denne uge","1":"næste uge","-1":"sidste uge"},"relativeTime":{"future":{"one":"om {0} uge","other":"om {0} uger"},"past":{"one":"for {0} uge siden","other":"for {0} uger siden"}}},"week-short":{"displayName":"uge","relativePeriod":"i ugen med {0}","relative":{"0":"denne uge","1":"næste uge","-1":"sidste uge"},"relativeTime":{"future":{"one":"om {0} uge","other":"om {0} uger"},"past":{"one":"for {0} uge siden","other":"for {0} uger siden"}}},"day":{"displayName":"dag","relative":{"0":"i dag","1":"i morgen","2":"i overmorgen","-2":"i forgårs","-1":"i går"},"relativeTime":{"future":{"one":"om {0} dag","other":"om {0} dage"},"past":{"one":"for {0} dag siden","other":"for {0} dage siden"}}},"day-short":{"displayName":"dag","relative":{"0":"i dag","1":"i morgen","2":"i overmorgen","-2":"i forgårs","-1":"i går"},"relativeTime":{"future":{"one":"om {0} dag","other":"om {0} dage"},"past":{"one":"for {0} dag siden","other":"for {0} dage siden"}}},"hour":{"displayName":"time","relative":{"0":"i den kommende time"},"relativeTime":{"future":{"one":"om {0} time","other":"om {0} timer"},"past":{"one":"for {0} time siden","other":"for {0} timer siden"}}},"hour-short":{"displayName":"t.","relative":{"0":"i den kommende time"},"relativeTime":{"future":{"one":"om {0} time","other":"om {0} timer"},"past":{"one":"for {0} time siden","other":"for {0} timer siden"}}},"minute":{"displayName":"minut","relative":{"0":"i det kommende minut"},"relativeTime":{"future":{"one":"om {0} minut","other":"om {0} minutter"},"past":{"one":"for {0} minut siden","other":"for {0} minutter siden"}}},"minute-short":{"displayName":"min.","relative":{"0":"i det kommende minut"},"relativeTime":{"future":{"one":"om {0} min.","other":"om {0} min."},"past":{"one":"for {0} min. siden","other":"for {0} min. siden"}}},"second":{"displayName":"sekund","relative":{"0":"nu"},"relativeTime":{"future":{"one":"om {0} sekund","other":"om {0} sekunder"},"past":{"one":"for {0} sekund siden","other":"for {0} sekunder siden"}}},"second-short":{"displayName":"sek.","relative":{"0":"nu"},"relativeTime":{"future":{"one":"om {0} sek.","other":"om {0} sek."},"past":{"one":"for {0} sek. siden","other":"for {0} sek. siden"}}}}},{"locale":"da-GL","parentLocale":"da"},
    {"locale":"dav","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mori","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mori","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Juma","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Juma","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Ituku","relative":{"0":"Idime","1":"Kesho","-1":"Iguo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Ituku","relative":{"0":"Idime","1":"Kesho","-1":"Iguo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Dakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Dakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"de","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      if (ord) return 'other';
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Jahr","relative":{"0":"dieses Jahr","1":"nächstes Jahr","-1":"letztes Jahr"},"relativeTime":{"future":{"one":"in {0} Jahr","other":"in {0} Jahren"},"past":{"one":"vor {0} Jahr","other":"vor {0} Jahren"}}},"year-short":{"displayName":"Jahr","relative":{"0":"dieses Jahr","1":"nächstes Jahr","-1":"letztes Jahr"},"relativeTime":{"future":{"one":"in {0} Jahr","other":"in {0} Jahren"},"past":{"one":"vor {0} Jahr","other":"vor {0} Jahren"}}},"month":{"displayName":"Monat","relative":{"0":"diesen Monat","1":"nächsten Monat","-1":"letzten Monat"},"relativeTime":{"future":{"one":"in {0} Monat","other":"in {0} Monaten"},"past":{"one":"vor {0} Monat","other":"vor {0} Monaten"}}},"month-short":{"displayName":"Monat","relative":{"0":"diesen Monat","1":"nächsten Monat","-1":"letzten Monat"},"relativeTime":{"future":{"one":"in {0} Monat","other":"in {0} Monaten"},"past":{"one":"vor {0} Monat","other":"vor {0} Monaten"}}},"week":{"displayName":"Woche","relativePeriod":"die Woche vom {0}","relative":{"0":"diese Woche","1":"nächste Woche","-1":"letzte Woche"},"relativeTime":{"future":{"one":"in {0} Woche","other":"in {0} Wochen"},"past":{"one":"vor {0} Woche","other":"vor {0} Wochen"}}},"week-short":{"displayName":"Woche","relativePeriod":"die Woche vom {0}","relative":{"0":"diese Woche","1":"nächste Woche","-1":"letzte Woche"},"relativeTime":{"future":{"one":"in {0} Woche","other":"in {0} Wochen"},"past":{"one":"vor {0} Woche","other":"vor {0} Wochen"}}},"day":{"displayName":"Tag","relative":{"0":"heute","1":"morgen","2":"übermorgen","-2":"vorgestern","-1":"gestern"},"relativeTime":{"future":{"one":"in {0} Tag","other":"in {0} Tagen"},"past":{"one":"vor {0} Tag","other":"vor {0} Tagen"}}},"day-short":{"displayName":"Tag","relative":{"0":"heute","1":"morgen","2":"übermorgen","-2":"vorgestern","-1":"gestern"},"relativeTime":{"future":{"one":"in {0} Tag","other":"in {0} Tagen"},"past":{"one":"vor {0} Tag","other":"vor {0} Tagen"}}},"hour":{"displayName":"Stunde","relative":{"0":"in dieser Stunde"},"relativeTime":{"future":{"one":"in {0} Stunde","other":"in {0} Stunden"},"past":{"one":"vor {0} Stunde","other":"vor {0} Stunden"}}},"hour-short":{"displayName":"Std.","relative":{"0":"in dieser Stunde"},"relativeTime":{"future":{"one":"in {0} Std.","other":"in {0} Std."},"past":{"one":"vor {0} Std.","other":"vor {0} Std."}}},"minute":{"displayName":"Minute","relative":{"0":"in dieser Minute"},"relativeTime":{"future":{"one":"in {0} Minute","other":"in {0} Minuten"},"past":{"one":"vor {0} Minute","other":"vor {0} Minuten"}}},"minute-short":{"displayName":"Min.","relative":{"0":"in dieser Minute"},"relativeTime":{"future":{"one":"in {0} Min.","other":"in {0} Min."},"past":{"one":"vor {0} Min.","other":"vor {0} Min."}}},"second":{"displayName":"Sekunde","relative":{"0":"jetzt"},"relativeTime":{"future":{"one":"in {0} Sekunde","other":"in {0} Sekunden"},"past":{"one":"vor {0} Sekunde","other":"vor {0} Sekunden"}}},"second-short":{"displayName":"Sek.","relative":{"0":"jetzt"},"relativeTime":{"future":{"one":"in {0} Sek.","other":"in {0} Sek."},"past":{"one":"vor {0} Sek.","other":"vor {0} Sek."}}}}},{"locale":"de-AT","parentLocale":"de"},{"locale":"de-BE","parentLocale":"de"},{"locale":"de-CH","parentLocale":"de"},{"locale":"de-IT","parentLocale":"de"},{"locale":"de-LI","parentLocale":"de"},{"locale":"de-LU","parentLocale":"de"},
    {"locale":"dje","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Jiiri","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Jiiri","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Handu","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Handu","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Hebu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Hebu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Zaari","relative":{"0":"Hõo","1":"Suba","-1":"Bi"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Zaari","relative":{"0":"Hõo","1":"Suba","-1":"Bi"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Guuru","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Guuru","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Miniti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Miniti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Miti","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Miti","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"dsb","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], f = s[1] || '', v0 = !s[1],
          i100 = i.slice(-2), f100 = f.slice(-2);
      if (ord) return 'other';
      return (v0 && i100 == 1
              || f100 == 1) ? 'one'
          : (v0 && i100 == 2
              || f100 == 2) ? 'two'
          : (v0 && (i100 == 3 || i100 == 4) || (f100 == 3
              || f100 == 4)) ? 'few'
          : 'other';
    },"fields":{"year":{"displayName":"lěto","relative":{"0":"lětosa","1":"znowa","-1":"łoni"},"relativeTime":{"future":{"one":"za {0} lěto","two":"za {0} lěśe","few":"za {0} lěta","other":"za {0} lět"},"past":{"one":"pśed {0} lětom","two":"pśed {0} lětoma","few":"pśed {0} lětami","other":"pśed {0} lětami"}}},"year-short":{"displayName":"l.","relative":{"0":"lětosa","1":"znowa","-1":"łoni"},"relativeTime":{"future":{"one":"za {0} l.","two":"za {0} l.","few":"za {0} l.","other":"za {0} l."},"past":{"one":"pśed {0} l.","two":"pśed {0} l.","few":"pśed {0} l.","other":"pśed {0} l."}}},"month":{"displayName":"mjasec","relative":{"0":"ten mjasec","1":"pśiducy mjasec","-1":"slědny mjasec"},"relativeTime":{"future":{"one":"za {0} mjasec","two":"za {0} mjaseca","few":"za {0} mjasecy","other":"za {0} mjasecow"},"past":{"one":"pśed {0} mjasecom","two":"pśed {0} mjasecoma","few":"pśed {0} mjasecami","other":"pśed {0} mjasecami"}}},"month-short":{"displayName":"mjas.","relative":{"0":"ten mjasec","1":"pśiducy mjasec","-1":"slědny mjasec"},"relativeTime":{"future":{"one":"za {0} mjas.","two":"za {0} mjas.","few":"za {0} mjas.","other":"za {0} mjas."},"past":{"one":"pśed {0} mjas.","two":"pśed {0} mjas.","few":"pśed {0} mjas.","other":"pśed {0} mjas."}}},"week":{"displayName":"tyźeń","relativePeriod":"the week of {0}","relative":{"0":"ten tyźeń","1":"pśiducy tyźeń","-1":"slědny tyźeń"},"relativeTime":{"future":{"one":"za {0} tyźeń","two":"za {0} tyźenja","few":"za {0} tyźenje","other":"za {0} tyźenjow"},"past":{"one":"pśed {0} tyźenjom","two":"pśed {0} tyźenjoma","few":"pśed {0} tyźenjami","other":"pśed {0} tyźenjami"}}},"week-short":{"displayName":"tyź.","relativePeriod":"the week of {0}","relative":{"0":"ten tyźeń","1":"pśiducy tyźeń","-1":"slědny tyźeń"},"relativeTime":{"future":{"one":"za {0} tyź.","two":"za {0} tyź.","few":"za {0} tyź.","other":"za {0} tyź."},"past":{"one":"pśed {0} tyź.","two":"pśed {0} tyź.","few":"pśed {0} tyź.","other":"pśed {0} tyź."}}},"day":{"displayName":"źeń","relative":{"0":"źinsa","1":"witśe","-1":"cora"},"relativeTime":{"future":{"one":"za {0} źeń","two":"za {0} dnja","few":"za {0} dny","other":"za {0} dnjow"},"past":{"one":"pśed {0} dnjom","two":"pśed {0} dnjoma","few":"pśed {0} dnjami","other":"pśed {0} dnjami"}}},"day-short":{"displayName":"źeń","relative":{"0":"źinsa","1":"witśe","-1":"cora"},"relativeTime":{"future":{"one":"za {0} źeń","two":"za {0} dnj.","few":"za {0} dny","other":"za {0} dnj."},"past":{"one":"pśed {0} dnj.","two":"pśed {0} dnj.","few":"pśed {0} dnj.","other":"pśed {0} dnj."}}},"hour":{"displayName":"góźina","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"za {0} góźinu","two":"za {0} góźinje","few":"za {0} góźiny","other":"za {0} góźin"},"past":{"one":"pśed {0} góźinu","two":"pśed {0} góźinoma","few":"pśed {0} góźinami","other":"pśed {0} góźinami"}}},"hour-short":{"displayName":"góź.","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"za {0} góź.","two":"za {0} góź.","few":"za {0} góź.","other":"za {0} góź."},"past":{"one":"pśed {0} góź.","two":"pśed {0} góź.","few":"pśed {0} góź.","other":"pśed {0} góź."}}},"minute":{"displayName":"minuta","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"za {0} minutu","two":"za {0} minuśe","few":"za {0} minuty","other":"za {0} minutow"},"past":{"one":"pśed {0} minutu","two":"pśed {0} minutoma","few":"pśed {0} minutami","other":"pśed {0} minutami"}}},"minute-short":{"displayName":"min.","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"za {0} min.","two":"za {0} min.","few":"za {0} min.","other":"za {0} min."},"past":{"one":"pśed {0} min.","two":"pśed {0} min.","few":"pśed {0} min.","other":"pśed {0} min."}}},"second":{"displayName":"sekunda","relative":{"0":"now"},"relativeTime":{"future":{"one":"za {0} sekundu","two":"za {0} sekunźe","few":"za {0} sekundy","other":"za {0} sekundow"},"past":{"one":"pśed {0} sekundu","two":"pśed {0} sekundoma","few":"pśed {0} sekundami","other":"pśed {0} sekundami"}}},"second-short":{"displayName":"sek.","relative":{"0":"now"},"relativeTime":{"future":{"one":"za {0} sek.","two":"za {0} sek.","few":"za {0} sek.","other":"za {0} sek."},"past":{"one":"pśed {0} sek.","two":"pśed {0} sek.","few":"pśed {0} sek.","other":"pśed {0} sek."}}}}},
    {"locale":"dua","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"mbú","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"mbú","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"mɔ́di","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"mɔ́di","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"disama","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"disama","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"búnyá","relative":{"0":"wɛ́ŋgɛ̄","1":"kíɛlɛ","-1":"kíɛlɛ nítómb́í"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"búnyá","relative":{"0":"wɛ́ŋgɛ̄","1":"kíɛlɛ","-1":"kíɛlɛ nítómb́í"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"ŋgandɛ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"ŋgandɛ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"ndɔkɔ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"ndɔkɔ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"píndí","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"píndí","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"dv","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"dyo","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Emit","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Emit","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Fuleeŋ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Fuleeŋ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Lóokuŋ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Lóokuŋ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Funak","relative":{"0":"Jaat","1":"Kajom","-1":"Fucen"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Funak","relative":{"0":"Jaat","1":"Kajom","-1":"Fucen"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"dz","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"ལོ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"ལོ་འཁོར་ {0} ནང་"},"past":{"other":"ལོ་འཁོར་ {0} ཧེ་མ་"}}},"year-short":{"displayName":"ལོ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"ལོ་འཁོར་ {0} ནང་"},"past":{"other":"ལོ་འཁོར་ {0} ཧེ་མ་"}}},"month":{"displayName":"ཟླ་ཝ་","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"ཟླཝ་ {0} ནང་"},"past":{"other":"ཟླཝ་ {0} ཧེ་མ་"}}},"month-short":{"displayName":"ཟླ་ཝ་","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"ཟླཝ་ {0} ནང་"},"past":{"other":"ཟླཝ་ {0} ཧེ་མ་"}}},"week":{"displayName":"བདུན་ཕྲག","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"བངུན་ཕྲག་ {0} ནང་"},"past":{"other":"བངུན་ཕྲག་ {0} ཧེ་མ་"}}},"week-short":{"displayName":"བདུན་ཕྲག","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"བངུན་ཕྲག་ {0} ནང་"},"past":{"other":"བངུན་ཕྲག་ {0} ཧེ་མ་"}}},"day":{"displayName":"ཚེས་","relative":{"0":"ད་རིས་","1":"ནངས་པ་","2":"གནངས་ཚེ","-2":"ཁ་ཉིམ","-1":"ཁ་ཙ་"},"relativeTime":{"future":{"other":"ཉིནམ་ {0} ནང་"},"past":{"other":"ཉིནམ་ {0} ཧེ་མ་"}}},"day-short":{"displayName":"ཚེས་","relative":{"0":"ད་རིས་","1":"ནངས་པ་","2":"གནངས་ཚེ","-2":"ཁ་ཉིམ","-1":"ཁ་ཙ་"},"relativeTime":{"future":{"other":"ཉིནམ་ {0} ནང་"},"past":{"other":"ཉིནམ་ {0} ཧེ་མ་"}}},"hour":{"displayName":"ཆུ་ཚོད","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"ཆུ་ཚོད་ {0} ནང་"},"past":{"other":"ཆུ་ཚོད་ {0} ཧེ་མ་"}}},"hour-short":{"displayName":"ཆུ་ཚོད","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"ཆུ་ཚོད་ {0} ནང་"},"past":{"other":"ཆུ་ཚོད་ {0} ཧེ་མ་"}}},"minute":{"displayName":"སྐར་མ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"སྐར་མ་ {0} ནང་"},"past":{"other":"སྐར་མ་ {0} ཧེ་མ་"}}},"minute-short":{"displayName":"སྐར་མ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"སྐར་མ་ {0} ནང་"},"past":{"other":"སྐར་མ་ {0} ཧེ་མ་"}}},"second":{"displayName":"སྐར་ཆཱ་","relative":{"0":"now"},"relativeTime":{"future":{"other":"སྐར་ཆ་ {0} ནང་"},"past":{"other":"སྐར་ཆ་ {0} ཧེ་མ་"}}},"second-short":{"displayName":"སྐར་ཆཱ་","relative":{"0":"now"},"relativeTime":{"future":{"other":"སྐར་ཆ་ {0} ནང་"},"past":{"other":"སྐར་ཆ་ {0} ཧེ་མ་"}}}}},
    {"locale":"ebu","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mweri","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mweri","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Kiumia","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Kiumia","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Mũthenya","relative":{"0":"Ũmũnthĩ","1":"Rũciũ","-1":"Ĩgoro"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Mũthenya","relative":{"0":"Ũmũnthĩ","1":"Rũciũ","-1":"Ĩgoro"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Ithaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Ithaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Ndagĩka","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Ndagĩka","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekondi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekondi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ee","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ƒe","relative":{"0":"ƒe sia","1":"ƒe si gbɔ na","-1":"ƒe si va yi"},"relativeTime":{"future":{"one":"le ƒe {0} me","other":"le ƒe {0} me"},"past":{"one":"ƒe {0} si va yi","other":"ƒe {0} si wo va yi"}}},"year-short":{"displayName":"ƒe","relative":{"0":"ƒe sia","1":"ƒe si gbɔ na","-1":"ƒe si va yi"},"relativeTime":{"future":{"one":"le ƒe {0} me","other":"le ƒe {0} me"},"past":{"one":"le ƒe {0} si va yi me","other":"le ƒe {0} si va yi me"}}},"month":{"displayName":"ɣleti","relative":{"0":"ɣleti sia","1":"ɣleti si gbɔ na","-1":"ɣleti si va yi"},"relativeTime":{"future":{"one":"le ɣleti {0} me","other":"le ɣleti {0} wo me"},"past":{"one":"ɣleti {0} si va yi","other":"ɣleti {0} si wo va yi"}}},"month-short":{"displayName":"ɣleti","relative":{"0":"ɣleti sia","1":"ɣleti si gbɔ na","-1":"ɣleti si va yi"},"relativeTime":{"future":{"one":"le ɣleti {0} me","other":"le ɣleti {0} wo me"},"past":{"one":"ɣleti {0} si va yi","other":"ɣleti {0} si wo va yi"}}},"week":{"displayName":"kɔsiɖa ɖeka","relativePeriod":"the week of {0}","relative":{"0":"kɔsiɖa sia","1":"kɔsiɖa si gbɔ na","-1":"kɔsiɖa si va yi"},"relativeTime":{"future":{"one":"le kɔsiɖa {0} me","other":"le kɔsiɖa {0} wo me"},"past":{"one":"kɔsiɖa {0} si va yi","other":"kɔsiɖa {0} si wo va yi"}}},"week-short":{"displayName":"kɔsiɖa ɖeka","relativePeriod":"the week of {0}","relative":{"0":"kɔsiɖa sia","1":"kɔsiɖa si gbɔ na","-1":"kɔsiɖa si va yi"},"relativeTime":{"future":{"one":"le kɔsiɖa {0} me","other":"le kɔsiɖa {0} wo me"},"past":{"one":"kɔsiɖa {0} si va yi","other":"kɔsiɖa {0} si wo va yi"}}},"day":{"displayName":"ŋkeke","relative":{"0":"egbe","1":"etsɔ si gbɔna","2":"nyitsɔ si gbɔna","-2":"nyitsɔ si va yi","-1":"etsɔ si va yi"},"relativeTime":{"future":{"one":"le ŋkeke {0} me","other":"le ŋkeke {0} wo me"},"past":{"one":"ŋkeke {0} si va yi","other":"ŋkeke {0} si wo va yi"}}},"day-short":{"displayName":"ŋkeke","relative":{"0":"egbe","1":"etsɔ si gbɔna","2":"nyitsɔ si gbɔna","-2":"nyitsɔ si va yi","-1":"etsɔ si va yi"},"relativeTime":{"future":{"one":"le ŋkeke {0} me","other":"le ŋkeke {0} wo me"},"past":{"one":"ŋkeke {0} si va yi","other":"ŋkeke {0} si wo va yi"}}},"hour":{"displayName":"gaƒoƒo","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"le gaƒoƒo {0} me","other":"le gaƒoƒo {0} wo me"},"past":{"one":"gaƒoƒo {0} si va yi","other":"gaƒoƒo {0} si wo va yi"}}},"hour-short":{"displayName":"gaƒoƒo","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"le gaƒoƒo {0} me","other":"le gaƒoƒo {0} wo me"},"past":{"one":"gaƒoƒo {0} si va yi","other":"gaƒoƒo {0} si wo va yi"}}},"minute":{"displayName":"aɖabaƒoƒo","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"le aɖabaƒoƒo {0} me","other":"le aɖabaƒoƒo {0} wo me"},"past":{"one":"aɖabaƒoƒo {0} si va yi","other":"aɖabaƒoƒo {0} si wo va yi"}}},"minute-short":{"displayName":"aɖabaƒoƒo","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"le aɖabaƒoƒo {0} me","other":"le aɖabaƒoƒo {0} wo me"},"past":{"one":"aɖabaƒoƒo {0} si va yi","other":"aɖabaƒoƒo {0} si wo va yi"}}},"second":{"displayName":"sekend","relative":{"0":"fifi"},"relativeTime":{"future":{"one":"le sekend {0} me","other":"le sekend {0} wo me"},"past":{"one":"sekend {0} si va yi","other":"sekend {0} si wo va yi"}}},"second-short":{"displayName":"sekend","relative":{"0":"fifi"},"relativeTime":{"future":{"one":"le sekend {0} me","other":"le sekend {0} wo me"},"past":{"one":"sekend {0} si va yi","other":"sekend {0} si wo va yi"}}}}},{"locale":"ee-TG","parentLocale":"ee"},
    {"locale":"el","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"έτος","relative":{"0":"φέτος","1":"επόμενο έτος","-1":"πέρσι"},"relativeTime":{"future":{"one":"σε {0} έτος","other":"σε {0} έτη"},"past":{"one":"πριν από {0} έτος","other":"πριν από {0} έτη"}}},"year-short":{"displayName":"έτ.","relative":{"0":"φέτος","1":"επόμενο έτος","-1":"πέρσι"},"relativeTime":{"future":{"one":"σε {0} έτος","other":"σε {0} έτη"},"past":{"one":"πριν από {0} έτος","other":"πριν από {0} έτη"}}},"month":{"displayName":"μήνας","relative":{"0":"τρέχων μήνας","1":"επόμενος μήνας","-1":"προηγούμενος μήνας"},"relativeTime":{"future":{"one":"σε {0} μήνα","other":"σε {0} μήνες"},"past":{"one":"πριν από {0} μήνα","other":"πριν από {0} μήνες"}}},"month-short":{"displayName":"μήν.","relative":{"0":"τρέχων μήνας","1":"επόμενος μήνας","-1":"προηγούμενος μήνας"},"relativeTime":{"future":{"one":"σε {0} μήνα","other":"σε {0} μήνες"},"past":{"one":"πριν από {0} μήνα","other":"πριν από {0} μήνες"}}},"week":{"displayName":"εβδομάδα","relativePeriod":"την εβδομάδα {0}","relative":{"0":"τρέχουσα εβδομάδα","1":"επόμενη εβδομάδα","-1":"προηγούμενη εβδομάδα"},"relativeTime":{"future":{"one":"σε {0} εβδομάδα","other":"σε {0} εβδομάδες"},"past":{"one":"πριν από {0} εβδομάδα","other":"πριν από {0} εβδομάδες"}}},"week-short":{"displayName":"εβδ.","relativePeriod":"την εβδ. {0}","relative":{"0":"τρέχουσα εβδομάδα","1":"επόμενη εβδομάδα","-1":"προηγούμενη εβδομάδα"},"relativeTime":{"future":{"one":"σε {0} εβδ.","other":"σε {0} εβδ."},"past":{"one":"πριν από {0} εβδ.","other":"πριν από {0} εβδ."}}},"day":{"displayName":"ημέρα","relative":{"0":"σήμερα","1":"αύριο","2":"μεθαύριο","-2":"προχθές","-1":"χθες"},"relativeTime":{"future":{"one":"σε {0} ημέρα","other":"σε {0} ημέρες"},"past":{"one":"πριν από {0} ημέρα","other":"πριν από {0} ημέρες"}}},"day-short":{"displayName":"ημ.","relative":{"0":"σήμερα","1":"αύριο","2":"μεθαύριο","-2":"προχθές","-1":"χθες"},"relativeTime":{"future":{"one":"σε {0} ημ.","other":"σε {0} ημ."},"past":{"one":"πριν από {0} ημ.","other":"πριν από {0} ημ."}}},"hour":{"displayName":"ώρα","relative":{"0":"τρέχουσα ώρα"},"relativeTime":{"future":{"one":"σε {0} ώρα","other":"σε {0} ώρες"},"past":{"one":"πριν από {0} ώρα","other":"πριν από {0} ώρες"}}},"hour-short":{"displayName":"ώ.","relative":{"0":"τρέχουσα ώρα"},"relativeTime":{"future":{"one":"σε {0} ώ.","other":"σε {0} ώ."},"past":{"one":"πριν από {0} ώ.","other":"πριν από {0} ώ."}}},"minute":{"displayName":"λεπτό","relative":{"0":"τρέχον λεπτό"},"relativeTime":{"future":{"one":"σε {0} λεπτό","other":"σε {0} λεπτά"},"past":{"one":"πριν από {0} λεπτό","other":"πριν από {0} λεπτά"}}},"minute-short":{"displayName":"λεπ.","relative":{"0":"τρέχον λεπτό"},"relativeTime":{"future":{"one":"σε {0} λεπ.","other":"σε {0} λεπ."},"past":{"one":"πριν από {0} λεπ.","other":"πριν από {0} λεπ."}}},"second":{"displayName":"δευτερόλεπτο","relative":{"0":"τώρα"},"relativeTime":{"future":{"one":"σε {0} δευτερόλεπτο","other":"σε {0} δευτερόλεπτα"},"past":{"one":"πριν από {0} δευτερόλεπτο","other":"πριν από {0} δευτερόλεπτα"}}},"second-short":{"displayName":"δευτ.","relative":{"0":"τώρα"},"relativeTime":{"future":{"one":"σε {0} δευτ.","other":"σε {0} δευτ."},"past":{"one":"πριν από {0} δευτ.","other":"πριν από {0} δευτ."}}}}},{"locale":"el-CY","parentLocale":"el"},
    {"locale":"en","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1], t0 = Number(s[0]) == n,
          n10 = t0 && s[0].slice(-1), n100 = t0 && s[0].slice(-2);
      if (ord) return (n10 == 1 && n100 != 11) ? 'one'
          : (n10 == 2 && n100 != 12) ? 'two'
          : (n10 == 3 && n100 != 13) ? 'few'
          : 'other';
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"one":"in {0} year","other":"in {0} years"},"past":{"one":"{0} year ago","other":"{0} years ago"}}},"year-short":{"displayName":"yr.","relative":{"0":"this yr.","1":"next yr.","-1":"last yr."},"relativeTime":{"future":{"one":"in {0} yr.","other":"in {0} yr."},"past":{"one":"{0} yr. ago","other":"{0} yr. ago"}}},"month":{"displayName":"month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"in {0} month","other":"in {0} months"},"past":{"one":"{0} month ago","other":"{0} months ago"}}},"month-short":{"displayName":"mo.","relative":{"0":"this mo.","1":"next mo.","-1":"last mo."},"relativeTime":{"future":{"one":"in {0} mo.","other":"in {0} mo."},"past":{"one":"{0} mo. ago","other":"{0} mo. ago"}}},"week":{"displayName":"week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"in {0} week","other":"in {0} weeks"},"past":{"one":"{0} week ago","other":"{0} weeks ago"}}},"week-short":{"displayName":"wk.","relativePeriod":"the week of {0}","relative":{"0":"this wk.","1":"next wk.","-1":"last wk."},"relativeTime":{"future":{"one":"in {0} wk.","other":"in {0} wk."},"past":{"one":"{0} wk. ago","other":"{0} wk. ago"}}},"day":{"displayName":"day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"in {0} day","other":"in {0} days"},"past":{"one":"{0} day ago","other":"{0} days ago"}}},"day-short":{"displayName":"day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"in {0} day","other":"in {0} days"},"past":{"one":"{0} day ago","other":"{0} days ago"}}},"hour":{"displayName":"hour","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"in {0} hour","other":"in {0} hours"},"past":{"one":"{0} hour ago","other":"{0} hours ago"}}},"hour-short":{"displayName":"hr.","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"in {0} hr.","other":"in {0} hr."},"past":{"one":"{0} hr. ago","other":"{0} hr. ago"}}},"minute":{"displayName":"minute","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"in {0} minute","other":"in {0} minutes"},"past":{"one":"{0} minute ago","other":"{0} minutes ago"}}},"minute-short":{"displayName":"min.","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"in {0} min.","other":"in {0} min."},"past":{"one":"{0} min. ago","other":"{0} min. ago"}}},"second":{"displayName":"second","relative":{"0":"now"},"relativeTime":{"future":{"one":"in {0} second","other":"in {0} seconds"},"past":{"one":"{0} second ago","other":"{0} seconds ago"}}},"second-short":{"displayName":"sec.","relative":{"0":"now"},"relativeTime":{"future":{"one":"in {0} sec.","other":"in {0} sec."},"past":{"one":"{0} sec. ago","other":"{0} sec. ago"}}}}},{"locale":"en-001","parentLocale":"en","fields":{"year":{"displayName":"year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"one":"in {0} year","other":"in {0} years"},"past":{"one":"{0} year ago","other":"{0} years ago"}}},"year-short":{"displayName":"yr","relative":{"0":"this yr.","1":"next yr.","-1":"last yr."},"relativeTime":{"future":{"one":"in {0} yr","other":"in {0} yr"},"past":{"one":"{0} yr ago","other":"{0} yr ago"}}},"month":{"displayName":"month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"in {0} month","other":"in {0} months"},"past":{"one":"{0} month ago","other":"{0} months ago"}}},"month-short":{"displayName":"mo","relative":{"0":"this mo.","1":"next mo.","-1":"last mo."},"relativeTime":{"future":{"one":"in {0} mo","other":"in {0} mo"},"past":{"one":"{0} mo ago","other":"{0} mo ago"}}},"week":{"displayName":"week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"in {0} week","other":"in {0} weeks"},"past":{"one":"{0} week ago","other":"{0} weeks ago"}}},"week-short":{"displayName":"wk","relativePeriod":"the week of {0}","relative":{"0":"this wk.","1":"next wk.","-1":"last wk."},"relativeTime":{"future":{"one":"in {0} wk","other":"in {0} wk"},"past":{"one":"{0} wk ago","other":"{0} wk ago"}}},"day":{"displayName":"day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"in {0} day","other":"in {0} days"},"past":{"one":"{0} day ago","other":"{0} days ago"}}},"day-short":{"displayName":"day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"in {0} day","other":"in {0} days"},"past":{"one":"{0} day ago","other":"{0} days ago"}}},"hour":{"displayName":"hour","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"in {0} hour","other":"in {0} hours"},"past":{"one":"{0} hour ago","other":"{0} hours ago"}}},"hour-short":{"displayName":"hr","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"in {0} hr","other":"in {0} hr"},"past":{"one":"{0} hr ago","other":"{0} hr ago"}}},"minute":{"displayName":"minute","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"in {0} minute","other":"in {0} minutes"},"past":{"one":"{0} minute ago","other":"{0} minutes ago"}}},"minute-short":{"displayName":"min","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"in {0} min","other":"in {0} min"},"past":{"one":"{0} min ago","other":"{0} min ago"}}},"second":{"displayName":"second","relative":{"0":"now"},"relativeTime":{"future":{"one":"in {0} second","other":"in {0} seconds"},"past":{"one":"{0} second ago","other":"{0} seconds ago"}}},"second-short":{"displayName":"sec","relative":{"0":"now"},"relativeTime":{"future":{"one":"in {0} sec","other":"in {0} sec"},"past":{"one":"{0} sec ago","other":"{0} sec ago"}}}}},{"locale":"en-150","parentLocale":"en-001"},{"locale":"en-AG","parentLocale":"en-001"},{"locale":"en-AI","parentLocale":"en-001"},{"locale":"en-AS","parentLocale":"en"},{"locale":"en-AT","parentLocale":"en-150"},{"locale":"en-AU","parentLocale":"en-001","fields":{"year":{"displayName":"year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"one":"in {0} year","other":"in {0} years"},"past":{"one":"{0} year ago","other":"{0} years ago"}}},"year-short":{"displayName":"yr","relative":{"0":"this yr.","1":"next yr.","-1":"last yr."},"relativeTime":{"future":{"one":"in {0} yr","other":"in {0} yrs"},"past":{"one":"{0} yr ago","other":"{0} yrs ago"}}},"month":{"displayName":"month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"in {0} month","other":"in {0} months"},"past":{"one":"{0} month ago","other":"{0} months ago"}}},"month-short":{"displayName":"mo.","relative":{"0":"this mo.","1":"next mo.","-1":"last mo."},"relativeTime":{"future":{"one":"in {0} mo.","other":"in {0} mo."},"past":{"one":"{0} mo. ago","other":"{0} mo. ago"}}},"week":{"displayName":"week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"in {0} week","other":"in {0} weeks"},"past":{"one":"{0} week ago","other":"{0} weeks ago"}}},"week-short":{"displayName":"wk","relativePeriod":"the week of {0}","relative":{"0":"this wk.","1":"next wk.","-1":"last wk."},"relativeTime":{"future":{"one":"in {0} wk","other":"in {0} wks"},"past":{"one":"{0} wk ago","other":"{0} wks ago"}}},"day":{"displayName":"day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"in {0} day","other":"in {0} days"},"past":{"one":"{0} day ago","other":"{0} days ago"}}},"day-short":{"displayName":"day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"in {0} day","other":"in {0} days"},"past":{"one":"{0} day ago","other":"{0} days ago"}}},"hour":{"displayName":"hour","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"in {0} hour","other":"in {0} hours"},"past":{"one":"{0} hour ago","other":"{0} hours ago"}}},"hour-short":{"displayName":"h","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"in {0} hr","other":"in {0} hrs"},"past":{"one":"{0} hr ago","other":"{0} hrs ago"}}},"minute":{"displayName":"minute","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"in {0} minute","other":"in {0} minutes"},"past":{"one":"{0} minute ago","other":"{0} minutes ago"}}},"minute-short":{"displayName":"min.","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"in {0} min.","other":"in {0} mins"},"past":{"one":"{0} min. ago","other":"{0} mins ago"}}},"second":{"displayName":"second","relative":{"0":"now"},"relativeTime":{"future":{"one":"in {0} second","other":"in {0} seconds"},"past":{"one":"{0} second ago","other":"{0} seconds ago"}}},"second-short":{"displayName":"sec.","relative":{"0":"now"},"relativeTime":{"future":{"one":"in {0} sec.","other":"in {0} secs"},"past":{"one":"{0} sec. ago","other":"{0} secs ago"}}}}},{"locale":"en-BB","parentLocale":"en-001"},{"locale":"en-BE","parentLocale":"en-001"},{"locale":"en-BI","parentLocale":"en"},{"locale":"en-BM","parentLocale":"en-001"},{"locale":"en-BS","parentLocale":"en-001"},{"locale":"en-BW","parentLocale":"en-001"},{"locale":"en-BZ","parentLocale":"en-001"},{"locale":"en-CA","parentLocale":"en-001","fields":{"year":{"displayName":"year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"one":"in {0} year","other":"in {0} years"},"past":{"one":"{0} year ago","other":"{0} years ago"}}},"year-short":{"displayName":"yr.","relative":{"0":"this yr.","1":"next yr.","-1":"last yr."},"relativeTime":{"future":{"one":"in {0} yr.","other":"in {0} yrs."},"past":{"one":"{0} yr. ago","other":"{0} yrs. ago"}}},"month":{"displayName":"month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"in {0} month","other":"in {0} months"},"past":{"one":"{0} month ago","other":"{0} months ago"}}},"month-short":{"displayName":"mo.","relative":{"0":"this mo.","1":"next mo.","-1":"last mo."},"relativeTime":{"future":{"one":"in {0} mo.","other":"in {0} mos."},"past":{"one":"{0} mo. ago","other":"{0} mos. ago"}}},"week":{"displayName":"week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"in {0} week","other":"in {0} weeks"},"past":{"one":"{0} week ago","other":"{0} weeks ago"}}},"week-short":{"displayName":"wk.","relativePeriod":"the wk. of {0}","relative":{"0":"this wk.","1":"next wk.","-1":"last wk."},"relativeTime":{"future":{"one":"in {0} wk.","other":"in {0} wks."},"past":{"one":"{0} wk. ago","other":"{0} wks. ago"}}},"day":{"displayName":"day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"in {0} day","other":"in {0} days"},"past":{"one":"{0} day ago","other":"{0} days ago"}}},"day-short":{"displayName":"day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"in {0} day","other":"in {0} days"},"past":{"one":"{0} day ago","other":"{0} days ago"}}},"hour":{"displayName":"hour","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"in {0} hour","other":"in {0} hours"},"past":{"one":"{0} hour ago","other":"{0} hours ago"}}},"hour-short":{"displayName":"hr.","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"in {0} hr.","other":"in {0} hrs."},"past":{"one":"{0} hr. ago","other":"{0} hrs. ago"}}},"minute":{"displayName":"minute","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"in {0} minute","other":"in {0} minutes"},"past":{"one":"{0} minute ago","other":"{0} minutes ago"}}},"minute-short":{"displayName":"min.","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"in {0} min.","other":"in {0} mins."},"past":{"one":"{0} min. ago","other":"{0} mins. ago"}}},"second":{"displayName":"second","relative":{"0":"now"},"relativeTime":{"future":{"one":"in {0} second","other":"in {0} seconds"},"past":{"one":"{0} second ago","other":"{0} seconds ago"}}},"second-short":{"displayName":"sec.","relative":{"0":"now"},"relativeTime":{"future":{"one":"in {0} sec.","other":"in {0} secs."},"past":{"one":"{0} sec. ago","other":"{0} secs. ago"}}}}},{"locale":"en-CC","parentLocale":"en-001"},{"locale":"en-CH","parentLocale":"en-150"},{"locale":"en-CK","parentLocale":"en-001"},{"locale":"en-CM","parentLocale":"en-001"},{"locale":"en-CX","parentLocale":"en-001"},{"locale":"en-CY","parentLocale":"en-001"},{"locale":"en-DE","parentLocale":"en-150"},{"locale":"en-DG","parentLocale":"en-001"},{"locale":"en-DK","parentLocale":"en-150"},{"locale":"en-DM","parentLocale":"en-001"},{"locale":"en-Dsrt","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"en-ER","parentLocale":"en-001"},{"locale":"en-FI","parentLocale":"en-150"},{"locale":"en-FJ","parentLocale":"en-001"},{"locale":"en-FK","parentLocale":"en-001"},{"locale":"en-FM","parentLocale":"en-001"},{"locale":"en-GB","parentLocale":"en-001"},{"locale":"en-GD","parentLocale":"en-001"},{"locale":"en-GG","parentLocale":"en-001"},{"locale":"en-GH","parentLocale":"en-001"},{"locale":"en-GI","parentLocale":"en-001"},{"locale":"en-GM","parentLocale":"en-001"},{"locale":"en-GU","parentLocale":"en"},{"locale":"en-GY","parentLocale":"en-001"},{"locale":"en-HK","parentLocale":"en-001"},{"locale":"en-IE","parentLocale":"en-001"},{"locale":"en-IL","parentLocale":"en-001"},{"locale":"en-IM","parentLocale":"en-001"},{"locale":"en-IN","parentLocale":"en-001"},{"locale":"en-IO","parentLocale":"en-001"},{"locale":"en-JE","parentLocale":"en-001"},{"locale":"en-JM","parentLocale":"en-001"},{"locale":"en-KE","parentLocale":"en-001"},{"locale":"en-KI","parentLocale":"en-001"},{"locale":"en-KN","parentLocale":"en-001"},{"locale":"en-KY","parentLocale":"en-001"},{"locale":"en-LC","parentLocale":"en-001"},{"locale":"en-LR","parentLocale":"en-001"},{"locale":"en-LS","parentLocale":"en-001"},{"locale":"en-MG","parentLocale":"en-001"},{"locale":"en-MH","parentLocale":"en"},{"locale":"en-MO","parentLocale":"en-001"},{"locale":"en-MP","parentLocale":"en"},{"locale":"en-MS","parentLocale":"en-001"},{"locale":"en-MT","parentLocale":"en-001"},{"locale":"en-MU","parentLocale":"en-001"},{"locale":"en-MW","parentLocale":"en-001"},{"locale":"en-MY","parentLocale":"en-001"},{"locale":"en-NA","parentLocale":"en-001"},{"locale":"en-NF","parentLocale":"en-001"},{"locale":"en-NG","parentLocale":"en-001"},{"locale":"en-NL","parentLocale":"en-150"},{"locale":"en-NR","parentLocale":"en-001"},{"locale":"en-NU","parentLocale":"en-001"},{"locale":"en-NZ","parentLocale":"en-001"},{"locale":"en-PG","parentLocale":"en-001"},{"locale":"en-PH","parentLocale":"en-001"},{"locale":"en-PK","parentLocale":"en-001"},{"locale":"en-PN","parentLocale":"en-001"},{"locale":"en-PR","parentLocale":"en"},{"locale":"en-PW","parentLocale":"en-001"},{"locale":"en-RW","parentLocale":"en-001"},{"locale":"en-SB","parentLocale":"en-001"},{"locale":"en-SC","parentLocale":"en-001"},{"locale":"en-SD","parentLocale":"en-001"},{"locale":"en-SE","parentLocale":"en-150"},{"locale":"en-SG","parentLocale":"en-001","fields":{"year":{"displayName":"year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"one":"in {0} year","other":"in {0} years"},"past":{"one":"{0} year ago","other":"{0} years ago"}}},"year-short":{"displayName":"yr","relative":{"0":"this yr","1":"next yr","-1":"last yr"},"relativeTime":{"future":{"one":"in {0} yr","other":"in {0} yr"},"past":{"one":"{0} yr ago","other":"{0} yr ago"}}},"month":{"displayName":"month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"in {0} month","other":"in {0} months"},"past":{"one":"{0} month ago","other":"{0} months ago"}}},"month-short":{"displayName":"mth","relative":{"0":"this mth","1":"next mth","-1":"last mth"},"relativeTime":{"future":{"one":"in {0} mth","other":"in {0} mth"},"past":{"one":"{0} mth ago","other":"{0} mth ago"}}},"week":{"displayName":"week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"in {0} week","other":"in {0} weeks"},"past":{"one":"{0} week ago","other":"{0} weeks ago"}}},"week-short":{"displayName":"wk","relativePeriod":"the week of {0}","relative":{"0":"this wk","1":"next wk","-1":"last wk"},"relativeTime":{"future":{"one":"in {0} wk","other":"in {0} wk"},"past":{"one":"{0} wk ago","other":"{0} wk ago"}}},"day":{"displayName":"day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"in {0} day","other":"in {0} days"},"past":{"one":"{0} day ago","other":"{0} days ago"}}},"day-short":{"displayName":"day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"in {0} day","other":"in {0} days"},"past":{"one":"{0} day ago","other":"{0} days ago"}}},"hour":{"displayName":"hour","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"in {0} hour","other":"in {0} hours"},"past":{"one":"{0} hour ago","other":"{0} hours ago"}}},"hour-short":{"displayName":"hr","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"in {0} hr","other":"in {0} hr"},"past":{"one":"{0} hr ago","other":"{0} hr ago"}}},"minute":{"displayName":"minute","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"in {0} minute","other":"in {0} minutes"},"past":{"one":"{0} minute ago","other":"{0} minutes ago"}}},"minute-short":{"displayName":"min","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"in {0} min","other":"in {0} min"},"past":{"one":"{0} min ago","other":"{0} min ago"}}},"second":{"displayName":"second","relative":{"0":"now"},"relativeTime":{"future":{"one":"in {0} second","other":"in {0} seconds"},"past":{"one":"{0} second ago","other":"{0} seconds ago"}}},"second-short":{"displayName":"sec","relative":{"0":"now"},"relativeTime":{"future":{"one":"in {0} sec","other":"in {0} sec"},"past":{"one":"{0} sec ago","other":"{0} sec ago"}}}}},{"locale":"en-SH","parentLocale":"en-001"},{"locale":"en-SI","parentLocale":"en-150"},{"locale":"en-SL","parentLocale":"en-001"},{"locale":"en-SS","parentLocale":"en-001"},{"locale":"en-SX","parentLocale":"en-001"},{"locale":"en-SZ","parentLocale":"en-001"},{"locale":"en-Shaw","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"en-TC","parentLocale":"en-001"},{"locale":"en-TK","parentLocale":"en-001"},{"locale":"en-TO","parentLocale":"en-001"},{"locale":"en-TT","parentLocale":"en-001"},{"locale":"en-TV","parentLocale":"en-001"},{"locale":"en-TZ","parentLocale":"en-001"},{"locale":"en-UG","parentLocale":"en-001"},{"locale":"en-UM","parentLocale":"en"},{"locale":"en-US","parentLocale":"en"},{"locale":"en-VC","parentLocale":"en-001"},{"locale":"en-VG","parentLocale":"en-001"},{"locale":"en-VI","parentLocale":"en"},{"locale":"en-VU","parentLocale":"en-001"},{"locale":"en-WS","parentLocale":"en-001"},{"locale":"en-ZA","parentLocale":"en-001"},{"locale":"en-ZM","parentLocale":"en-001"},{"locale":"en-ZW","parentLocale":"en-001"},
    {"locale":"eo","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"es","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"año","relative":{"0":"este año","1":"el próximo año","-1":"el año pasado"},"relativeTime":{"future":{"one":"dentro de {0} año","other":"dentro de {0} años"},"past":{"one":"hace {0} año","other":"hace {0} años"}}},"year-short":{"displayName":"a","relative":{"0":"este año","1":"el próximo año","-1":"el año pasado"},"relativeTime":{"future":{"one":"dentro de {0} a","other":"dentro de {0} a"},"past":{"one":"hace {0} a","other":"hace {0} a"}}},"month":{"displayName":"mes","relative":{"0":"este mes","1":"el próximo mes","-1":"el mes pasado"},"relativeTime":{"future":{"one":"dentro de {0} mes","other":"dentro de {0} meses"},"past":{"one":"hace {0} mes","other":"hace {0} meses"}}},"month-short":{"displayName":"m","relative":{"0":"este mes","1":"el próximo mes","-1":"el mes pasado"},"relativeTime":{"future":{"one":"dentro de {0} m","other":"dentro de {0} m"},"past":{"one":"hace {0} m","other":"hace {0} m"}}},"week":{"displayName":"semana","relativePeriod":"la semana del {0}","relative":{"0":"esta semana","1":"la próxima semana","-1":"la semana pasada"},"relativeTime":{"future":{"one":"dentro de {0} semana","other":"dentro de {0} semanas"},"past":{"one":"hace {0} semana","other":"hace {0} semanas"}}},"week-short":{"displayName":"sem.","relativePeriod":"la sem. del {0}","relative":{"0":"esta semana","1":"la próxima semana","-1":"la semana pasada"},"relativeTime":{"future":{"one":"dentro de {0} sem.","other":"dentro de {0} sem."},"past":{"one":"hace {0} sem.","other":"hace {0} sem."}}},"day":{"displayName":"día","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"anteayer","-1":"ayer"},"relativeTime":{"future":{"one":"dentro de {0} día","other":"dentro de {0} días"},"past":{"one":"hace {0} día","other":"hace {0} días"}}},"day-short":{"displayName":"d","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"anteayer","-1":"ayer"},"relativeTime":{"future":{"one":"dentro de {0} día","other":"dentro de {0} días"},"past":{"one":"hace {0} día","other":"hace {0} días"}}},"hour":{"displayName":"hora","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} hora","other":"dentro de {0} horas"},"past":{"one":"hace {0} hora","other":"hace {0} horas"}}},"hour-short":{"displayName":"h","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} h","other":"dentro de {0} h"},"past":{"one":"hace {0} h","other":"hace {0} h"}}},"minute":{"displayName":"minuto","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} minuto","other":"dentro de {0} minutos"},"past":{"one":"hace {0} minuto","other":"hace {0} minutos"}}},"minute-short":{"displayName":"min","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} min","other":"dentro de {0} min"},"past":{"one":"hace {0} min","other":"hace {0} min"}}},"second":{"displayName":"segundo","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"dentro de {0} segundo","other":"dentro de {0} segundos"},"past":{"one":"hace {0} segundo","other":"hace {0} segundos"}}},"second-short":{"displayName":"s","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"dentro de {0} s","other":"dentro de {0} s"},"past":{"one":"hace {0} s","other":"hace {0} s"}}}}},{"locale":"es-419","parentLocale":"es","fields":{"year":{"displayName":"año","relative":{"0":"este año","1":"el próximo año","-1":"el año pasado"},"relativeTime":{"future":{"one":"dentro de {0} año","other":"dentro de {0} años"},"past":{"one":"hace {0} año","other":"hace {0} años"}}},"year-short":{"displayName":"a","relative":{"0":"este año","1":"el próximo año","-1":"el año pasado"},"relativeTime":{"future":{"one":"dentro de {0} a","other":"dentro de {0} a"},"past":{"one":"hace {0} a","other":"hace {0} a"}}},"month":{"displayName":"mes","relative":{"0":"este mes","1":"el próximo mes","-1":"el mes pasado"},"relativeTime":{"future":{"one":"dentro de {0} mes","other":"dentro de {0} meses"},"past":{"one":"hace {0} mes","other":"hace {0} meses"}}},"month-short":{"displayName":"m","relative":{"0":"este mes","1":"el próximo mes","-1":"el mes pasado"},"relativeTime":{"future":{"one":"dentro de {0} m","other":"dentro de {0} m"},"past":{"one":"hace {0} m","other":"hace {0} m"}}},"week":{"displayName":"semana","relativePeriod":"la semana del {0}","relative":{"0":"esta semana","1":"la próxima semana","-1":"la semana pasada"},"relativeTime":{"future":{"one":"dentro de {0} semana","other":"dentro de {0} semanas"},"past":{"one":"hace {0} semana","other":"hace {0} semanas"}}},"week-short":{"displayName":"sem.","relativePeriod":"la semana del {0}","relative":{"0":"esta semana","1":"la próxima semana","-1":"la semana pasada"},"relativeTime":{"future":{"one":"dentro de {0} sem.","other":"dentro de {0} sem."},"past":{"one":"hace {0} sem.","other":"hace {0} sem."}}},"day":{"displayName":"día","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"anteayer","-1":"ayer"},"relativeTime":{"future":{"one":"dentro de {0} día","other":"dentro de {0} días"},"past":{"one":"hace {0} día","other":"hace {0} días"}}},"day-short":{"displayName":"d","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"anteayer","-1":"ayer"},"relativeTime":{"future":{"one":"dentro de {0} día","other":"dentro de {0} días"},"past":{"one":"hace {0} día","other":"hace {0} días"}}},"hour":{"displayName":"hora","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} hora","other":"dentro de {0} horas"},"past":{"one":"hace {0} hora","other":"hace {0} horas"}}},"hour-short":{"displayName":"h","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} h","other":"dentro de {0} h"},"past":{"one":"hace {0} h","other":"hace {0} h"}}},"minute":{"displayName":"minuto","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} minuto","other":"dentro de {0} minutos"},"past":{"one":"hace {0} minuto","other":"hace {0} minutos"}}},"minute-short":{"displayName":"min","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} min","other":"dentro de {0} min"},"past":{"one":"hace {0} min","other":"hace {0} min"}}},"second":{"displayName":"segundo","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"dentro de {0} segundo","other":"dentro de {0} segundos"},"past":{"one":"hace {0} segundo","other":"hace {0} segundos"}}},"second-short":{"displayName":"s","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"dentro de {0} s","other":"dentro de {0} s"},"past":{"one":"hace {0} s","other":"hace {0} s"}}}}},{"locale":"es-AR","parentLocale":"es-419","fields":{"year":{"displayName":"año","relative":{"0":"este año","1":"el próximo año","-1":"el año pasado"},"relativeTime":{"future":{"one":"dentro de {0} año","other":"dentro de {0} años"},"past":{"one":"hace {0} año","other":"hace {0} años"}}},"year-short":{"displayName":"a","relative":{"0":"este año","1":"el próximo año","-1":"el año pasado"},"relativeTime":{"future":{"one":"dentro de {0} a","other":"dentro de {0} a"},"past":{"one":"hace {0} a","other":"hace {0} a"}}},"month":{"displayName":"mes","relative":{"0":"este mes","1":"el próximo mes","-1":"el mes pasado"},"relativeTime":{"future":{"one":"dentro de {0} mes","other":"dentro de {0} meses"},"past":{"one":"hace {0} mes","other":"hace {0} meses"}}},"month-short":{"displayName":"m","relative":{"0":"este mes","1":"el próximo mes","-1":"el mes pasado"},"relativeTime":{"future":{"one":"dentro de {0} m","other":"dentro de {0} m"},"past":{"one":"hace {0} m","other":"hace {0} m"}}},"week":{"displayName":"semana","relativePeriod":"la semana del {0}","relative":{"0":"esta semana","1":"la próxima semana","-1":"la semana pasada"},"relativeTime":{"future":{"one":"dentro de {0} semana","other":"dentro de {0} semanas"},"past":{"one":"hace {0} semana","other":"hace {0} semanas"}}},"week-short":{"displayName":"sem.","relativePeriod":"la semana del {0}","relative":{"0":"esta semana","1":"la próxima semana","-1":"la semana pasada"},"relativeTime":{"future":{"one":"dentro de {0} sem.","other":"dentro de {0} sem."},"past":{"one":"hace {0} sem.","other":"hace {0} sem."}}},"day":{"displayName":"día","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"anteayer","-1":"ayer"},"relativeTime":{"future":{"one":"dentro de {0} día","other":"dentro de {0} días"},"past":{"one":"hace {0} día","other":"hace {0} días"}}},"day-short":{"displayName":"d","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"anteayer","-1":"ayer"},"relativeTime":{"future":{"one":"dentro de {0} días","other":"dentro de {0} días"},"past":{"one":"hace {0} días","other":"hace {0} días"}}},"hour":{"displayName":"hora","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} hora","other":"dentro de {0} horas"},"past":{"one":"hace {0} hora","other":"hace {0} horas"}}},"hour-short":{"displayName":"h","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} h","other":"dentro de {0} h"},"past":{"one":"hace {0} h","other":"hace {0} h"}}},"minute":{"displayName":"minuto","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} minuto","other":"dentro de {0} minutos"},"past":{"one":"hace {0} minuto","other":"hace {0} minutos"}}},"minute-short":{"displayName":"min","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} min","other":"dentro de {0} min"},"past":{"one":"hace {0} min","other":"hace {0} min"}}},"second":{"displayName":"segundo","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"dentro de {0} segundo","other":"dentro de {0} segundos"},"past":{"one":"hace {0} segundo","other":"hace {0} segundos"}}},"second-short":{"displayName":"seg.","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"dentro de {0} seg.","other":"dentro de {0} seg."},"past":{"one":"hace {0} seg.","other":"hace {0} seg."}}}}},{"locale":"es-BO","parentLocale":"es-419"},{"locale":"es-BR","parentLocale":"es-419"},{"locale":"es-BZ","parentLocale":"es-419"},{"locale":"es-CL","parentLocale":"es-419"},{"locale":"es-CO","parentLocale":"es-419"},{"locale":"es-CR","parentLocale":"es-419"},{"locale":"es-CU","parentLocale":"es-419"},{"locale":"es-DO","parentLocale":"es-419","fields":{"year":{"displayName":"Año","relative":{"0":"este año","1":"el próximo año","-1":"el año pasado"},"relativeTime":{"future":{"one":"dentro de {0} año","other":"dentro de {0} años"},"past":{"one":"hace {0} año","other":"hace {0} años"}}},"year-short":{"displayName":"a","relative":{"0":"este año","1":"el próximo año","-1":"el año pasado"},"relativeTime":{"future":{"one":"dentro de {0} a","other":"dentro de {0} a"},"past":{"one":"hace {0} a","other":"hace {0} a"}}},"month":{"displayName":"Mes","relative":{"0":"este mes","1":"el próximo mes","-1":"el mes pasado"},"relativeTime":{"future":{"one":"dentro de {0} mes","other":"dentro de {0} meses"},"past":{"one":"hace {0} mes","other":"hace {0} meses"}}},"month-short":{"displayName":"m","relative":{"0":"este mes","1":"el próximo mes","-1":"el mes pasado"},"relativeTime":{"future":{"one":"dentro de {0} m","other":"dentro de {0} m"},"past":{"one":"hace {0} m","other":"hace {0} m"}}},"week":{"displayName":"Semana","relativePeriod":"la semana del {0}","relative":{"0":"esta semana","1":"la próxima semana","-1":"la semana pasada"},"relativeTime":{"future":{"one":"dentro de {0} semana","other":"dentro de {0} semanas"},"past":{"one":"hace {0} semana","other":"hace {0} semanas"}}},"week-short":{"displayName":"sem.","relativePeriod":"la semana del {0}","relative":{"0":"esta semana","1":"la próxima semana","-1":"la semana pasada"},"relativeTime":{"future":{"one":"dentro de {0} sem.","other":"dentro de {0} sem."},"past":{"one":"hace {0} sem.","other":"hace {0} sem."}}},"day":{"displayName":"Día","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"anteayer","-1":"ayer"},"relativeTime":{"future":{"one":"dentro de {0} día","other":"dentro de {0} días"},"past":{"one":"hace {0} día","other":"hace {0} días"}}},"day-short":{"displayName":"d","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"anteayer","-1":"ayer"},"relativeTime":{"future":{"one":"dentro de {0} día","other":"dentro de {0} días"},"past":{"one":"hace {0} día","other":"hace {0} días"}}},"hour":{"displayName":"hora","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} hora","other":"dentro de {0} horas"},"past":{"one":"hace {0} hora","other":"hace {0} horas"}}},"hour-short":{"displayName":"h","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} h","other":"dentro de {0} h"},"past":{"one":"hace {0} h","other":"hace {0} h"}}},"minute":{"displayName":"Minuto","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} minuto","other":"dentro de {0} minutos"},"past":{"one":"hace {0} minuto","other":"hace {0} minutos"}}},"minute-short":{"displayName":"min","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} min","other":"dentro de {0} min"},"past":{"one":"hace {0} min","other":"hace {0} min"}}},"second":{"displayName":"Segundo","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"dentro de {0} segundo","other":"dentro de {0} segundos"},"past":{"one":"hace {0} segundo","other":"hace {0} segundos"}}},"second-short":{"displayName":"s","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"dentro de {0} s","other":"dentro de {0} s"},"past":{"one":"hace {0} s","other":"hace {0} s"}}}}},{"locale":"es-EA","parentLocale":"es"},{"locale":"es-EC","parentLocale":"es-419"},{"locale":"es-GQ","parentLocale":"es"},{"locale":"es-GT","parentLocale":"es-419"},{"locale":"es-HN","parentLocale":"es-419"},{"locale":"es-IC","parentLocale":"es"},{"locale":"es-MX","parentLocale":"es-419","fields":{"year":{"displayName":"año","relative":{"0":"este año","1":"el año próximo","-1":"el año pasado"},"relativeTime":{"future":{"one":"dentro de {0} año","other":"dentro de {0} años"},"past":{"one":"hace {0} año","other":"hace {0} años"}}},"year-short":{"displayName":"a","relative":{"0":"este año","1":"el próximo año","-1":"el año pasado"},"relativeTime":{"future":{"one":"en {0} a","other":"en {0} a"},"past":{"one":"hace {0} a","other":"hace {0} a"}}},"month":{"displayName":"mes","relative":{"0":"este mes","1":"el mes próximo","-1":"el mes pasado"},"relativeTime":{"future":{"one":"en {0} mes","other":"en {0} meses"},"past":{"one":"hace {0} mes","other":"hace {0} meses"}}},"month-short":{"displayName":"m","relative":{"0":"este mes","1":"el próximo mes","-1":"el mes pasado"},"relativeTime":{"future":{"one":"en {0} m","other":"en {0} m"},"past":{"one":"hace {0} m","other":"hace {0} m"}}},"week":{"displayName":"semana","relativePeriod":"la semana del {0}","relative":{"0":"esta semana","1":"la semana próxima","-1":"la semana pasada"},"relativeTime":{"future":{"one":"dentro de {0} semana","other":"dentro de {0} semanas"},"past":{"one":"hace {0} semana","other":"hace {0} semanas"}}},"week-short":{"displayName":"sem.","relativePeriod":"la semana del {0}","relative":{"0":"esta semana","1":"la semana próxima","-1":"la semana pasada"},"relativeTime":{"future":{"one":"en {0} sem.","other":"en {0} sem."},"past":{"one":"hace {0} sem.","other":"hace {0} sem."}}},"day":{"displayName":"día","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"anteayer","-1":"ayer"},"relativeTime":{"future":{"one":"dentro de {0} día","other":"dentro de {0} días"},"past":{"one":"hace {0} día","other":"hace {0} días"}}},"day-short":{"displayName":"d","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"anteayer","-1":"ayer"},"relativeTime":{"future":{"one":"en {0} día","other":"en {0} días"},"past":{"one":"hace {0} día","other":"hace {0} días"}}},"hour":{"displayName":"hora","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} hora","other":"dentro de {0} horas"},"past":{"one":"hace {0} hora","other":"hace {0} horas"}}},"hour-short":{"displayName":"h","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"en {0} h","other":"en {0} n"},"past":{"one":"hace {0} h","other":"hace {0} h"}}},"minute":{"displayName":"minuto","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} minuto","other":"dentro de {0} minutos"},"past":{"one":"hace {0} minuto","other":"hace {0} minutos"}}},"minute-short":{"displayName":"min","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"en {0} min","other":"en {0} min"},"past":{"one":"hace {0} min","other":"hace {0} min"}}},"second":{"displayName":"segundo","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"dentro de {0} segundo","other":"dentro de {0} segundos"},"past":{"one":"hace {0} segundo","other":"hace {0} segundos"}}},"second-short":{"displayName":"s","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"en {0} s","other":"en {0} s"},"past":{"one":"hace {0} s","other":"hace {0} s"}}}}},{"locale":"es-NI","parentLocale":"es-419"},{"locale":"es-PA","parentLocale":"es-419"},{"locale":"es-PE","parentLocale":"es-419"},{"locale":"es-PH","parentLocale":"es"},{"locale":"es-PR","parentLocale":"es-419"},{"locale":"es-PY","parentLocale":"es-419","fields":{"year":{"displayName":"año","relative":{"0":"este año","1":"el próximo año","-1":"el año pasado"},"relativeTime":{"future":{"one":"dentro de {0} año","other":"dentro de {0} años"},"past":{"one":"hace {0} año","other":"hace {0} años"}}},"year-short":{"displayName":"a","relative":{"0":"este año","1":"el próximo año","-1":"el año pasado"},"relativeTime":{"future":{"one":"dentro de {0} a","other":"dentro de {0} a"},"past":{"one":"hace {0} a","other":"hace {0} a"}}},"month":{"displayName":"mes","relative":{"0":"este mes","1":"el próximo mes","-1":"el mes pasado"},"relativeTime":{"future":{"one":"dentro de {0} mes","other":"dentro de {0} meses"},"past":{"one":"hace {0} mes","other":"hace {0} meses"}}},"month-short":{"displayName":"m","relative":{"0":"este mes","1":"el próximo mes","-1":"el mes pasado"},"relativeTime":{"future":{"one":"dentro de {0} m","other":"dentro de {0} m"},"past":{"one":"hace {0} m","other":"hace {0} m"}}},"week":{"displayName":"semana","relativePeriod":"la semana del {0}","relative":{"0":"esta semana","1":"la próxima semana","-1":"la semana pasada"},"relativeTime":{"future":{"one":"dentro de {0} semana","other":"dentro de {0} semanas"},"past":{"one":"hace {0} semana","other":"hace {0} semanas"}}},"week-short":{"displayName":"sem.","relativePeriod":"la semana del {0}","relative":{"0":"esta semana","1":"la próxima semana","-1":"la semana pasada"},"relativeTime":{"future":{"one":"dentro de {0} sem.","other":"dentro de {0} sem."},"past":{"one":"hace {0} sem.","other":"hace {0} sem."}}},"day":{"displayName":"día","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"anteayer","-1":"ayer"},"relativeTime":{"future":{"one":"dentro de {0} día","other":"dentro de {0} días"},"past":{"one":"hace {0} día","other":"hace {0} días"}}},"day-short":{"displayName":"d","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"anteayer","-1":"ayer"},"relativeTime":{"future":{"one":"dentro de {0} día","other":"dentro de {0} días"},"past":{"one":"hace {0} día","other":"hace {0} días"}}},"hour":{"displayName":"hora","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} hora","other":"dentro de {0} horas"},"past":{"one":"hace {0} hora","other":"hace {0} horas"}}},"hour-short":{"displayName":"h","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} h","other":"dentro de {0} h"},"past":{"one":"hace {0} h","other":"hace {0} h"}}},"minute":{"displayName":"minuto","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} minuto","other":"dentro de {0} minutos"},"past":{"one":"hace {0} minuto","other":"hace {0} minutos"}}},"minute-short":{"displayName":"min","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} min","other":"dentro de {0} min"},"past":{"one":"hace {0} min","other":"hace {0} min"}}},"second":{"displayName":"segundo","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"dentro de {0} segundo","other":"dentro de {0} segundos"},"past":{"one":"hace {0} segundo","other":"hace {0} segundos"}}},"second-short":{"displayName":"seg.","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"dentro de {0} seg.","other":"dentro de {0} seg."},"past":{"one":"hace {0} seg.","other":"hace {0} seg."}}}}},{"locale":"es-SV","parentLocale":"es-419","fields":{"year":{"displayName":"año","relative":{"0":"este año","1":"el próximo año","-1":"el año pasado"},"relativeTime":{"future":{"one":"dentro de {0} año","other":"dentro de {0} años"},"past":{"one":"hace {0} año","other":"hace {0} años"}}},"year-short":{"displayName":"a","relative":{"0":"este año","1":"el próximo año","-1":"el año pasado"},"relativeTime":{"future":{"one":"dentro de {0} a","other":"dentro de {0} a"},"past":{"one":"hace {0} a","other":"hace {0} a"}}},"month":{"displayName":"mes","relative":{"0":"este mes","1":"el próximo mes","-1":"el mes pasado"},"relativeTime":{"future":{"one":"dentro de {0} mes","other":"dentro de {0} meses"},"past":{"one":"hace {0} mes","other":"hace {0} meses"}}},"month-short":{"displayName":"m","relative":{"0":"este mes","1":"el próximo mes","-1":"el mes pasado"},"relativeTime":{"future":{"one":"dentro de {0} m","other":"dentro de {0} m"},"past":{"one":"hace {0} m","other":"hace {0} m"}}},"week":{"displayName":"semana","relativePeriod":"la semana del {0}","relative":{"0":"esta semana","1":"la próxima semana","-1":"la semana pasada"},"relativeTime":{"future":{"one":"dentro de {0} semana","other":"dentro de {0} semanas"},"past":{"one":"hace {0} semana","other":"hace {0} semanas"}}},"week-short":{"displayName":"sem.","relativePeriod":"la semana del {0}","relative":{"0":"esta semana","1":"la próxima semana","-1":"la semana pasada"},"relativeTime":{"future":{"one":"dentro de {0} sem.","other":"dentro de {0} sem."},"past":{"one":"hace {0} sem.","other":"hace {0} sem."}}},"day":{"displayName":"día","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"antier","-1":"ayer"},"relativeTime":{"future":{"one":"dentro de {0} día","other":"dentro de {0} días"},"past":{"one":"hace {0} día","other":"hace {0} días"}}},"day-short":{"displayName":"d","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"anteayer","-1":"ayer"},"relativeTime":{"future":{"one":"dentro de {0} día","other":"dentro de {0} días"},"past":{"one":"hace {0} día","other":"hace {0} días"}}},"hour":{"displayName":"hora","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} hora","other":"dentro de {0} horas"},"past":{"one":"hace {0} hora","other":"hace {0} horas"}}},"hour-short":{"displayName":"h","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} h","other":"dentro de {0} h"},"past":{"one":"hace {0} h","other":"hace {0} h"}}},"minute":{"displayName":"minuto","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} minuto","other":"dentro de {0} minutos"},"past":{"one":"hace {0} minuto","other":"hace {0} minutos"}}},"minute-short":{"displayName":"min","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} min","other":"dentro de {0} min"},"past":{"one":"hace {0} min","other":"hace {0} min"}}},"second":{"displayName":"segundo","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"dentro de {0} segundo","other":"dentro de {0} segundos"},"past":{"one":"hace {0} segundo","other":"hace {0} segundos"}}},"second-short":{"displayName":"s","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"dentro de {0} s","other":"dentro de {0} s"},"past":{"one":"hace {0} s","other":"hace {0} s"}}}}},{"locale":"es-US","parentLocale":"es-419","fields":{"year":{"displayName":"año","relative":{"0":"este año","1":"el año próximo","-1":"el año pasado"},"relativeTime":{"future":{"one":"dentro de {0} año","other":"dentro de {0} años"},"past":{"one":"hace {0} año","other":"hace {0} años"}}},"year-short":{"displayName":"a","relative":{"0":"este año","1":"el próximo año","-1":"el año pasado"},"relativeTime":{"future":{"one":"dentro de {0} a","other":"dentro de {0} a"},"past":{"one":"hace {0} a","other":"hace {0} a"}}},"month":{"displayName":"mes","relative":{"0":"este mes","1":"el mes próximo","-1":"el mes pasado"},"relativeTime":{"future":{"one":"dentro de {0} mes","other":"dentro de {0} meses"},"past":{"one":"hace {0} mes","other":"hace {0} meses"}}},"month-short":{"displayName":"m","relative":{"0":"este mes","1":"el próximo mes","-1":"el mes pasado"},"relativeTime":{"future":{"one":"dentro de {0} m","other":"dentro de {0} m"},"past":{"one":"hace {0} m","other":"hace {0} m"}}},"week":{"displayName":"semana","relativePeriod":"la semana del {0}","relative":{"0":"esta semana","1":"la semana próxima","-1":"la semana pasada"},"relativeTime":{"future":{"one":"dentro de {0} semana","other":"dentro de {0} semanas"},"past":{"one":"hace {0} semana","other":"hace {0} semanas"}}},"week-short":{"displayName":"sem.","relativePeriod":"la semana del {0}","relative":{"0":"esta semana","1":"la semana próxima","-1":"la semana pasada"},"relativeTime":{"future":{"one":"dentro de {0} sem.","other":"dentro de {0} sem."},"past":{"one":"hace {0} sem.","other":"hace {0} sem."}}},"day":{"displayName":"día","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"anteayer","-1":"ayer"},"relativeTime":{"future":{"one":"dentro de {0} día","other":"dentro de {0} días"},"past":{"one":"hace {0} día","other":"hace {0} días"}}},"day-short":{"displayName":"d","relative":{"0":"hoy","1":"mañana","2":"pasado mañana","-2":"anteayer","-1":"ayer"},"relativeTime":{"future":{"one":"dentro de {0} día","other":"dentro de {0} días"},"past":{"one":"hace {0} día","other":"hace {0} días"}}},"hour":{"displayName":"hora","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} hora","other":"dentro de {0} horas"},"past":{"one":"hace {0} hora","other":"hace {0} horas"}}},"hour-short":{"displayName":"h","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} h","other":"dentro de {0} h"},"past":{"one":"hace {0} h","other":"hace {0} h"}}},"minute":{"displayName":"minuto","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} minuto","other":"dentro de {0} minutos"},"past":{"one":"hace {0} minuto","other":"hace {0} minutos"}}},"minute-short":{"displayName":"min","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} min","other":"dentro de {0} min"},"past":{"one":"hace {0} min","other":"hace {0} min"}}},"second":{"displayName":"segundo","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"dentro de {0} segundo","other":"dentro de {0} segundos"},"past":{"one":"hace {0} segundo","other":"hace {0} segundos"}}},"second-short":{"displayName":"s","relative":{"0":"ahora"},"relativeTime":{"future":{"one":"dentro de {0} s","other":"dentro de {0} s"},"past":{"one":"hace {0} s","other":"hace {0} s"}}}}},{"locale":"es-UY","parentLocale":"es-419"},{"locale":"es-VE","parentLocale":"es-419"},
    {"locale":"et","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      if (ord) return 'other';
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"aasta","relative":{"0":"käesolev aasta","1":"järgmine aasta","-1":"eelmine aasta"},"relativeTime":{"future":{"one":"{0} aasta pärast","other":"{0} aasta pärast"},"past":{"one":"{0} aasta eest","other":"{0} aasta eest"}}},"year-short":{"displayName":"a","relative":{"0":"käesolev aasta","1":"järgmine aasta","-1":"eelmine aasta"},"relativeTime":{"future":{"one":"{0} a pärast","other":"{0} a pärast"},"past":{"one":"{0} a eest","other":"{0} a eest"}}},"month":{"displayName":"kuu","relative":{"0":"käesolev kuu","1":"järgmine kuu","-1":"eelmine kuu"},"relativeTime":{"future":{"one":"{0} kuu pärast","other":"{0} kuu pärast"},"past":{"one":"{0} kuu eest","other":"{0} kuu eest"}}},"month-short":{"displayName":"k","relative":{"0":"käesolev kuu","1":"järgmine kuu","-1":"eelmine kuu"},"relativeTime":{"future":{"one":"{0} kuu pärast","other":"{0} kuu pärast"},"past":{"one":"{0} kuu eest","other":"{0} kuu eest"}}},"week":{"displayName":"nädal","relativePeriod":"{0} nädal","relative":{"0":"käesolev nädal","1":"järgmine nädal","-1":"eelmine nädal"},"relativeTime":{"future":{"one":"{0} nädala pärast","other":"{0} nädala pärast"},"past":{"one":"{0} nädala eest","other":"{0} nädala eest"}}},"week-short":{"displayName":"näd","relativePeriod":"{0} näd","relative":{"0":"käesolev nädal","1":"järgmine nädal","-1":"eelmine nädal"},"relativeTime":{"future":{"one":"{0} näd pärast","other":"{0} näd pärast"},"past":{"one":"{0} näd eest","other":"{0} näd eest"}}},"day":{"displayName":"päev","relative":{"0":"täna","1":"homme","2":"ülehomme","-2":"üleeile","-1":"eile"},"relativeTime":{"future":{"one":"{0} päeva pärast","other":"{0} päeva pärast"},"past":{"one":"{0} päeva eest","other":"{0} päeva eest"}}},"day-short":{"displayName":"p","relative":{"0":"täna","1":"homme","2":"ülehomme","-2":"üleeile","-1":"eile"},"relativeTime":{"future":{"one":"{0} p pärast","other":"{0} p pärast"},"past":{"one":"{0} p eest","other":"{0} p eest"}}},"hour":{"displayName":"tund","relative":{"0":"praegusel tunnil"},"relativeTime":{"future":{"one":"{0} tunni pärast","other":"{0} tunni pärast"},"past":{"one":"{0} tunni eest","other":"{0} tunni eest"}}},"hour-short":{"displayName":"t","relative":{"0":"praegusel tunnil"},"relativeTime":{"future":{"one":"{0} t pärast","other":"{0} t pärast"},"past":{"one":"{0} t eest","other":"{0} t eest"}}},"minute":{"displayName":"minut","relative":{"0":"praegusel minutil"},"relativeTime":{"future":{"one":"{0} minuti pärast","other":"{0} minuti pärast"},"past":{"one":"{0} minuti eest","other":"{0} minuti eest"}}},"minute-short":{"displayName":"min","relative":{"0":"praegusel minutil"},"relativeTime":{"future":{"one":"{0} min pärast","other":"{0} min pärast"},"past":{"one":"{0} min eest","other":"{0} min eest"}}},"second":{"displayName":"sekund","relative":{"0":"nüüd"},"relativeTime":{"future":{"one":"{0} sekundi pärast","other":"{0} sekundi pärast"},"past":{"one":"{0} sekundi eest","other":"{0} sekundi eest"}}},"second-short":{"displayName":"sek","relative":{"0":"nüüd"},"relativeTime":{"future":{"one":"{0} sek pärast","other":"{0} sek pärast"},"past":{"one":"{0} sek eest","other":"{0} sek eest"}}}}},
    {"locale":"eu","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"urtea","relative":{"0":"aurten","1":"hurrengo urtean","-1":"iaz"},"relativeTime":{"future":{"one":"{0} urte barru","other":"{0} urte barru"},"past":{"one":"Duela {0} urte","other":"Duela {0} urte"}}},"year-short":{"displayName":"urtea","relative":{"0":"aurten","1":"hurrengo urtea","-1":"aurreko urtea"},"relativeTime":{"future":{"one":"{0} urte barru","other":"{0} urte barru"},"past":{"one":"Duela {0} urte","other":"Duela {0} urte"}}},"month":{"displayName":"hilabetea","relative":{"0":"hilabete honetan","1":"hurrengo hilabetean","-1":"aurreko hilabetean"},"relativeTime":{"future":{"one":"{0} hilabete barru","other":"{0} hilabete barru"},"past":{"one":"Duela {0} hilabete","other":"Duela {0} hilabete"}}},"month-short":{"displayName":"hil.","relative":{"0":"hilabete honetan","1":"hurrengo hilabetean","-1":"aurreko hilabetean"},"relativeTime":{"future":{"one":"{0} hilabete barru","other":"{0} hilabete barru"},"past":{"one":"Duela {0} hilabete","other":"Duela {0} hilabete"}}},"week":{"displayName":"astea","relativePeriod":"{0} astea","relative":{"0":"aste honetan","1":"hurrengo astean","-1":"aurreko astean"},"relativeTime":{"future":{"one":"{0} aste barru","other":"{0} aste barru"},"past":{"one":"Duela {0} aste","other":"Duela {0} aste"}}},"week-short":{"displayName":"ast.","relativePeriod":"{0} astea","relative":{"0":"aste honetan","1":"hurrengo astean","-1":"aurreko astean"},"relativeTime":{"future":{"one":"{0} aste barru","other":"{0} aste barru"},"past":{"one":"Duela {0} aste","other":"Duela {0} aste"}}},"day":{"displayName":"eguna","relative":{"0":"gaur","1":"bihar","2":"etzi","-2":"herenegun","-1":"atzo"},"relativeTime":{"future":{"one":"{0} egun barru","other":"{0} egun barru"},"past":{"one":"Duela {0} egun","other":"Duela {0} egun"}}},"day-short":{"displayName":"eg.","relative":{"0":"gaur","1":"bihar","2":"etzi","-2":"herenegun","-1":"atzo"},"relativeTime":{"future":{"one":"{0} egun barru","other":"{0} egun barru"},"past":{"one":"Duela {0} egun","other":"Duela {0} egun"}}},"hour":{"displayName":"ordua","relative":{"0":"ordu honetan"},"relativeTime":{"future":{"one":"{0} ordu barru","other":"{0} ordu barru"},"past":{"one":"Duela {0} ordu","other":"Duela {0} ordu"}}},"hour-short":{"displayName":"h","relative":{"0":"ordu honetan"},"relativeTime":{"future":{"one":"{0} ordu barru","other":"{0} ordu barru"},"past":{"one":"Duela {0} ordu","other":"Duela {0} ordu"}}},"minute":{"displayName":"minutua","relative":{"0":"minutu honetan"},"relativeTime":{"future":{"one":"{0} minutu barru","other":"{0} minutu barru"},"past":{"one":"Duela {0} minutu","other":"Duela {0} minutu"}}},"minute-short":{"displayName":"min","relative":{"0":"minutu honetan"},"relativeTime":{"future":{"one":"{0} minutu barru","other":"{0} minutu barru"},"past":{"one":"Duela {0} minutu","other":"Duela {0} minutu"}}},"second":{"displayName":"segundoa","relative":{"0":"orain"},"relativeTime":{"future":{"one":"{0} segundo barru","other":"{0} segundo barru"},"past":{"one":"Duela {0} segundo","other":"Duela {0} segundo"}}},"second-short":{"displayName":"s","relative":{"0":"orain"},"relativeTime":{"future":{"one":"{0} segundo barru","other":"{0} segundo barru"},"past":{"one":"Duela {0} segundo","other":"Duela {0} segundo"}}}}},
    {"locale":"ewo","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"M̀bú","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"M̀bú","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Ngɔn","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Ngɔn","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Sɔ́ndɔ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Sɔ́ndɔ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Amǒs","relative":{"0":"Aná","1":"Okírí","-1":"Angogé"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Amǒs","relative":{"0":"Aná","1":"Okírí","-1":"Angogé"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Awola","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Awola","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Enútɛn","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Enútɛn","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Akábəga","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Akábəga","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"fa","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n >= 0 && n <= 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"سال","relative":{"0":"امسال","1":"سال آینده","-1":"سال گذشته"},"relativeTime":{"future":{"one":"{0} سال بعد","other":"{0} سال بعد"},"past":{"one":"{0} سال پیش","other":"{0} سال پیش"}}},"year-short":{"displayName":"سال","relative":{"0":"امسال","1":"سال آینده","-1":"سال گذشته"},"relativeTime":{"future":{"one":"{0} سال بعد","other":"{0} سال بعد"},"past":{"one":"{0} سال پیش","other":"{0} سال پیش"}}},"month":{"displayName":"ماه","relative":{"0":"این ماه","1":"ماه آینده","-1":"ماه گذشته"},"relativeTime":{"future":{"one":"{0} ماه بعد","other":"{0} ماه بعد"},"past":{"one":"{0} ماه پیش","other":"{0} ماه پیش"}}},"month-short":{"displayName":"ماه","relative":{"0":"این ماه","1":"ماه آینده","-1":"ماه پیش"},"relativeTime":{"future":{"one":"{0} ماه بعد","other":"{0} ماه بعد"},"past":{"one":"{0} ماه پیش","other":"{0} ماه پیش"}}},"week":{"displayName":"هفته","relativePeriod":"هفتهٔ {0}","relative":{"0":"این هفته","1":"هفتهٔ آینده","-1":"هفتهٔ گذشته"},"relativeTime":{"future":{"one":"{0} هفته بعد","other":"{0} هفته بعد"},"past":{"one":"{0} هفته پیش","other":"{0} هفته پیش"}}},"week-short":{"displayName":"هفته","relativePeriod":"هفتهٔ {0}","relative":{"0":"این هفته","1":"هفتهٔ آینده","-1":"هفتهٔ گذشته"},"relativeTime":{"future":{"one":"{0} هفته بعد","other":"{0} هفته بعد"},"past":{"one":"{0} هفته پیش","other":"{0} هفته پیش"}}},"day":{"displayName":"روز","relative":{"0":"امروز","1":"فردا","2":"پس‌فردا","-2":"پریروز","-1":"دیروز"},"relativeTime":{"future":{"one":"{0} روز بعد","other":"{0} روز بعد"},"past":{"one":"{0} روز پیش","other":"{0} روز پیش"}}},"day-short":{"displayName":"روز","relative":{"0":"امروز","1":"فردا","2":"پس‌فردا","-2":"پریروز","-1":"دیروز"},"relativeTime":{"future":{"one":"{0} روز بعد","other":"{0} روز بعد"},"past":{"one":"{0} روز پیش","other":"{0} روز پیش"}}},"hour":{"displayName":"ساعت","relative":{"0":"همین ساعت"},"relativeTime":{"future":{"one":"{0} ساعت بعد","other":"{0} ساعت بعد"},"past":{"one":"{0} ساعت پیش","other":"{0} ساعت پیش"}}},"hour-short":{"displayName":"ساعت","relative":{"0":"همین ساعت"},"relativeTime":{"future":{"one":"{0} ساعت بعد","other":"{0} ساعت بعد"},"past":{"one":"{0} ساعت پیش","other":"{0} ساعت پیش"}}},"minute":{"displayName":"دقیقه","relative":{"0":"همین دقیقه"},"relativeTime":{"future":{"one":"{0} دقیقه بعد","other":"{0} دقیقه بعد"},"past":{"one":"{0} دقیقه پیش","other":"{0} دقیقه پیش"}}},"minute-short":{"displayName":"دقیقه","relative":{"0":"همین دقیقه"},"relativeTime":{"future":{"one":"{0} دقیقه بعد","other":"{0} دقیقه بعد"},"past":{"one":"{0} دقیقه پیش","other":"{0} دقیقه پیش"}}},"second":{"displayName":"ثانیه","relative":{"0":"اکنون"},"relativeTime":{"future":{"one":"{0} ثانیه بعد","other":"{0} ثانیه بعد"},"past":{"one":"{0} ثانیه پیش","other":"{0} ثانیه پیش"}}},"second-short":{"displayName":"ثانیه","relative":{"0":"اکنون"},"relativeTime":{"future":{"one":"{0} ثانیه بعد","other":"{0} ثانیه بعد"},"past":{"one":"{0} ثانیه پیش","other":"{0} ثانیه پیش"}}}}},{"locale":"fa-AF","parentLocale":"fa"},
    {"locale":"ff","pluralRuleFunction":function(n
    ) {
      return (n >= 0 && n < 2) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Hitaande","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Hitaande","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Lewru","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Lewru","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Yontere","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Yontere","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Ñalnde","relative":{"0":"Hannde","1":"Jaŋngo","-1":"Haŋki"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Ñalnde","relative":{"0":"Hannde","1":"Jaŋngo","-1":"Haŋki"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Waktu","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Waktu","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Hoƴom","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Hoƴom","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Majaango","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Majaango","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"ff-Adlm","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"ff-Latn","parentLocale":"ff"},{"locale":"ff-Latn-BF","parentLocale":"ff-Latn"},{"locale":"ff-Latn-CM","parentLocale":"ff-Latn"},{"locale":"ff-Latn-GH","parentLocale":"ff-Latn"},{"locale":"ff-Latn-GM","parentLocale":"ff-Latn"},{"locale":"ff-Latn-GN","parentLocale":"ff-Latn"},{"locale":"ff-Latn-GW","parentLocale":"ff-Latn"},{"locale":"ff-Latn-LR","parentLocale":"ff-Latn"},{"locale":"ff-Latn-MR","parentLocale":"ff-Latn"},{"locale":"ff-Latn-NE","parentLocale":"ff-Latn"},{"locale":"ff-Latn-NG","parentLocale":"ff-Latn"},{"locale":"ff-Latn-SL","parentLocale":"ff-Latn"},
    {"locale":"fi","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      if (ord) return 'other';
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"vuosi","relative":{"0":"tänä vuonna","1":"ensi vuonna","-1":"viime vuonna"},"relativeTime":{"future":{"one":"{0} vuoden päästä","other":"{0} vuoden päästä"},"past":{"one":"{0} vuosi sitten","other":"{0} vuotta sitten"}}},"year-short":{"displayName":"v","relative":{"0":"tänä v","1":"ensi v","-1":"viime v"},"relativeTime":{"future":{"one":"{0} v päästä","other":"{0} v päästä"},"past":{"one":"{0} v sitten","other":"{0} v sitten"}}},"month":{"displayName":"kuukausi","relative":{"0":"tässä kuussa","1":"ensi kuussa","-1":"viime kuussa"},"relativeTime":{"future":{"one":"{0} kuukauden päästä","other":"{0} kuukauden päästä"},"past":{"one":"{0} kuukausi sitten","other":"{0} kuukautta sitten"}}},"month-short":{"displayName":"kk","relative":{"0":"tässä kk","1":"ensi kk","-1":"viime kk"},"relativeTime":{"future":{"one":"{0} kk päästä","other":"{0} kk päästä"},"past":{"one":"{0} kk sitten","other":"{0} kk sitten"}}},"week":{"displayName":"viikko","relativePeriod":"päivän {0} viikolla","relative":{"0":"tällä viikolla","1":"ensi viikolla","-1":"viime viikolla"},"relativeTime":{"future":{"one":"{0} viikon päästä","other":"{0} viikon päästä"},"past":{"one":"{0} viikko sitten","other":"{0} viikkoa sitten"}}},"week-short":{"displayName":"vk","relativePeriod":"päivän {0} viikolla","relative":{"0":"tällä vk","1":"ensi vk","-1":"viime vk"},"relativeTime":{"future":{"one":"{0} vk päästä","other":"{0} vk päästä"},"past":{"one":"{0} vk sitten","other":"{0} vk sitten"}}},"day":{"displayName":"päivä","relative":{"0":"tänään","1":"huomenna","2":"ylihuomenna","-2":"toissa päivänä","-1":"eilen"},"relativeTime":{"future":{"one":"{0} päivän päästä","other":"{0} päivän päästä"},"past":{"one":"{0} päivä sitten","other":"{0} päivää sitten"}}},"day-short":{"displayName":"pv","relative":{"0":"tänään","1":"huom.","2":"ylihuom.","-2":"toissap.","-1":"eilen"},"relativeTime":{"future":{"one":"{0} pv päästä","other":"{0} pv päästä"},"past":{"one":"{0} pv sitten","other":"{0} pv sitten"}}},"hour":{"displayName":"tunti","relative":{"0":"tämän tunnin aikana"},"relativeTime":{"future":{"one":"{0} tunnin päästä","other":"{0} tunnin päästä"},"past":{"one":"{0} tunti sitten","other":"{0} tuntia sitten"}}},"hour-short":{"displayName":"t","relative":{"0":"tunnin sisällä"},"relativeTime":{"future":{"one":"{0} t päästä","other":"{0} t päästä"},"past":{"one":"{0} t sitten","other":"{0} t sitten"}}},"minute":{"displayName":"minuutti","relative":{"0":"tämän minuutin aikana"},"relativeTime":{"future":{"one":"{0} minuutin päästä","other":"{0} minuutin päästä"},"past":{"one":"{0} minuutti sitten","other":"{0} minuuttia sitten"}}},"minute-short":{"displayName":"min","relative":{"0":"minuutin sisällä"},"relativeTime":{"future":{"one":"{0} min päästä","other":"{0} min päästä"},"past":{"one":"{0} min sitten","other":"{0} min sitten"}}},"second":{"displayName":"sekunti","relative":{"0":"nyt"},"relativeTime":{"future":{"one":"{0} sekunnin päästä","other":"{0} sekunnin päästä"},"past":{"one":"{0} sekunti sitten","other":"{0} sekuntia sitten"}}},"second-short":{"displayName":"s","relative":{"0":"nyt"},"relativeTime":{"future":{"one":"{0} s päästä","other":"{0} s päästä"},"past":{"one":"{0} s sitten","other":"{0} s sitten"}}}}},
    {"locale":"fil","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], f = s[1] || '', v0 = !s[1],
          i10 = i.slice(-1), f10 = f.slice(-1);
      if (ord) return (n == 1) ? 'one' : 'other';
      return (v0 && (i == 1 || i == 2 || i == 3)
              || v0 && i10 != 4 && i10 != 6 && i10 != 9
              || !v0 && f10 != 4 && f10 != 6 && f10 != 9) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"taon","relative":{"0":"ngayong taon","1":"susunod na taon","-1":"nakaraang taon"},"relativeTime":{"future":{"one":"sa {0} taon","other":"sa {0} (na) taon"},"past":{"one":"{0} taon ang nakalipas","other":"{0} (na) taon ang nakalipas"}}},"year-short":{"displayName":"taon","relative":{"0":"ngayong taon","1":"susunod na taon","-1":"nakaraang taon"},"relativeTime":{"future":{"one":"sa {0} taon","other":"sa {0} (na) taon"},"past":{"one":"{0} taon ang nakalipas","other":"{0} (na) taon ang nakalipas"}}},"month":{"displayName":"buwan","relative":{"0":"ngayong buwan","1":"susunod na buwan","-1":"nakaraang buwan"},"relativeTime":{"future":{"one":"sa {0} buwan","other":"sa {0} (na) buwan"},"past":{"one":"{0} buwan ang nakalipas","other":"{0} (na) buwan ang nakalipas"}}},"month-short":{"displayName":"buwan","relative":{"0":"ngayong buwan","1":"susunod na buwan","-1":"nakaraang buwan"},"relativeTime":{"future":{"one":"sa {0} buwan","other":"sa {0} (na) buwan"},"past":{"one":"{0} buwan ang nakalipas","other":"{0} (na) buwan ang nakalipas"}}},"week":{"displayName":"linggo","relativePeriod":"linggo ng {0}","relative":{"0":"sa linggong ito","1":"susunod na linggo","-1":"nakalipas na linggo"},"relativeTime":{"future":{"one":"sa {0} linggo","other":"sa {0} (na) linggo"},"past":{"one":"{0} linggo ang nakalipas","other":"{0} (na) linggo ang nakalipas"}}},"week-short":{"displayName":"linggo","relativePeriod":"linggo ng {0}","relative":{"0":"ngayong linggo","1":"susunod na linggo","-1":"nakaraang linggo"},"relativeTime":{"future":{"one":"sa {0} linggo","other":"sa {0} (na) linggo"},"past":{"one":"{0} linggo ang nakalipas","other":"{0} (na) linggo ang nakalipas"}}},"day":{"displayName":"araw","relative":{"0":"ngayong araw","1":"bukas","2":"Samakalawa","-2":"Araw bago ang kahapon","-1":"kahapon"},"relativeTime":{"future":{"one":"sa {0} araw","other":"sa {0} (na) araw"},"past":{"one":"{0} araw ang nakalipas","other":"{0} (na) araw ang nakalipas"}}},"day-short":{"displayName":"araw","relative":{"0":"ngayong araw","1":"bukas","2":"Samakalawa","-2":"Araw bago ang kahapon","-1":"kahapon"},"relativeTime":{"future":{"one":"sa {0} (na) araw","other":"sa {0} (na) araw"},"past":{"one":"{0} (na) araw ang nakalipas","other":"{0} (na) araw ang nakalipas"}}},"hour":{"displayName":"oras","relative":{"0":"ngayong oras"},"relativeTime":{"future":{"one":"sa {0} oras","other":"sa {0} (na) oras"},"past":{"one":"{0} oras ang nakalipas","other":"{0} (na) oras ang nakalipas"}}},"hour-short":{"displayName":"oras","relative":{"0":"ngayong oras"},"relativeTime":{"future":{"one":"sa {0} oras","other":"sa {0} (na) oras"},"past":{"one":"{0} oras ang nakalipas","other":"{0} (na) oras ang nakalipas"}}},"minute":{"displayName":"minuto","relative":{"0":"sa minutong ito"},"relativeTime":{"future":{"one":"sa {0} minuto","other":"sa {0} (na) minuto"},"past":{"one":"{0} minuto ang nakalipas","other":"{0} (na) minuto ang nakalipas"}}},"minute-short":{"displayName":"min.","relative":{"0":"sa minutong ito"},"relativeTime":{"future":{"one":"sa {0} min.","other":"sa {0} (na) min."},"past":{"one":"{0} min. ang nakalipas","other":"{0} (na) min. ang nakalipas"}}},"second":{"displayName":"segundo","relative":{"0":"ngayon"},"relativeTime":{"future":{"one":"sa {0} segundo","other":"sa {0} (na) segundo"},"past":{"one":"{0} segundo ang nakalipas","other":"{0} (na) segundo ang nakalipas"}}},"second-short":{"displayName":"seg.","relative":{"0":"ngayon"},"relativeTime":{"future":{"one":"sa {0} seg.","other":"sa {0} (na) seg."},"past":{"one":"{0} seg. ang nakalipas","other":"{0} (na) seg. nakalipas"}}}}},
    {"locale":"fo","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ár","relative":{"0":"í ár","1":"næsta ár","-1":"í fjør"},"relativeTime":{"future":{"one":"um {0} ár","other":"um {0} ár"},"past":{"one":"{0} ár síðan","other":"{0} ár síðan"}}},"year-short":{"displayName":"ár","relative":{"0":"í ár","1":"næsta ár","-1":"í fjør"},"relativeTime":{"future":{"one":"um {0} ár","other":"um {0} ár"},"past":{"one":"{0} ár síðan","other":"{0} ár síðan"}}},"month":{"displayName":"mánaður","relative":{"0":"henda mánaðin","1":"næsta mánað","-1":"seinasta mánað"},"relativeTime":{"future":{"one":"um {0} mánað","other":"um {0} mánaðir"},"past":{"one":"{0} mánað síðan","other":"{0} mánaðir síðan"}}},"month-short":{"displayName":"mnð.","relative":{"0":"henda mánaðin","1":"næsta mánað","-1":"seinasta mánað"},"relativeTime":{"future":{"one":"um {0} mnð.","other":"um {0} mnð."},"past":{"one":"{0} mnð. síðan","other":"{0} mnð. síðan"}}},"week":{"displayName":"vika","relativePeriod":"vika nummar {0}","relative":{"0":"hesu viku","1":"næstu viku","-1":"seinastu viku"},"relativeTime":{"future":{"one":"um {0} viku","other":"um {0} vikur"},"past":{"one":"{0} vika síðan","other":"{0} vikur síðan"}}},"week-short":{"displayName":"vi.","relativePeriod":"vika nummar {0}","relative":{"0":"hesu viku","1":"næstu viku","-1":"seinastu viku"},"relativeTime":{"future":{"one":"um {0} vi.","other":"um {0} vi."},"past":{"one":"{0} vi. síðan","other":"{0} vi. síðan"}}},"day":{"displayName":"dagur","relative":{"0":"í dag","1":"í morgin","2":"í ovurmorgin","-2":"fyrradagin","-1":"í gjár"},"relativeTime":{"future":{"one":"um {0} dag","other":"um {0} dagar"},"past":{"one":"{0} dagur síðan","other":"{0} dagar síðan"}}},"day-short":{"displayName":"da.","relative":{"0":"í dag","1":"í morgin","2":"í ovurmorgin","-2":"fyrradagin","-1":"í gjár"},"relativeTime":{"future":{"one":"um {0} da.","other":"um {0} da."},"past":{"one":"{0} da. síðan","other":"{0} da. síðan"}}},"hour":{"displayName":"tími","relative":{"0":"hendan tíman"},"relativeTime":{"future":{"one":"um {0} tíma","other":"um {0} tímar"},"past":{"one":"{0} tími síðan","other":"{0} tímar síðan"}}},"hour-short":{"displayName":"t.","relative":{"0":"hendan tíman"},"relativeTime":{"future":{"one":"um {0} t.","other":"um {0} t."},"past":{"one":"{0} t. síðan","other":"{0} t. síðan"}}},"minute":{"displayName":"minuttur","relative":{"0":"hendan minuttin"},"relativeTime":{"future":{"one":"um {0} minutt","other":"um {0} minuttir"},"past":{"one":"{0} minutt síðan","other":"{0} minuttir síðan"}}},"minute-short":{"displayName":"min.","relative":{"0":"hendan minuttin"},"relativeTime":{"future":{"one":"um {0} min.","other":"um {0} min."},"past":{"one":"{0} min. síðan","other":"{0} min. síðan"}}},"second":{"displayName":"sekund","relative":{"0":"nú"},"relativeTime":{"future":{"one":"um {0} sekund","other":"um {0} sekund"},"past":{"one":"{0} sekund síðan","other":"{0} sekund síðan"}}},"second-short":{"displayName":"sek.","relative":{"0":"nú"},"relativeTime":{"future":{"one":"um {0} sek.","other":"um {0} sek."},"past":{"one":"{0} sek. síðan","other":"{0} sek. síðan"}}}}},{"locale":"fo-DK","parentLocale":"fo"},
    {"locale":"fr","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return (n == 1) ? 'one' : 'other';
      return (n >= 0 && n < 2) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"année","relative":{"0":"cette année","1":"l’année prochaine","-1":"l’année dernière"},"relativeTime":{"future":{"one":"dans {0} an","other":"dans {0} ans"},"past":{"one":"il y a {0} an","other":"il y a {0} ans"}}},"year-short":{"displayName":"an","relative":{"0":"cette année","1":"l’année prochaine","-1":"l’année dernière"},"relativeTime":{"future":{"one":"dans {0} a","other":"dans {0} a"},"past":{"one":"il y a {0} a","other":"il y a {0} a"}}},"month":{"displayName":"mois","relative":{"0":"ce mois-ci","1":"le mois prochain","-1":"le mois dernier"},"relativeTime":{"future":{"one":"dans {0} mois","other":"dans {0} mois"},"past":{"one":"il y a {0} mois","other":"il y a {0} mois"}}},"month-short":{"displayName":"m.","relative":{"0":"ce mois-ci","1":"le mois prochain","-1":"le mois dernier"},"relativeTime":{"future":{"one":"dans {0} m.","other":"dans {0} m."},"past":{"one":"il y a {0} m.","other":"il y a {0} m."}}},"week":{"displayName":"semaine","relativePeriod":"la semaine du {0}","relative":{"0":"cette semaine","1":"la semaine prochaine","-1":"la semaine dernière"},"relativeTime":{"future":{"one":"dans {0} semaine","other":"dans {0} semaines"},"past":{"one":"il y a {0} semaine","other":"il y a {0} semaines"}}},"week-short":{"displayName":"sem.","relativePeriod":"sem. du {0}","relative":{"0":"cette semaine","1":"la semaine prochaine","-1":"la semaine dernière"},"relativeTime":{"future":{"one":"dans {0} sem.","other":"dans {0} sem."},"past":{"one":"il y a {0} sem.","other":"il y a {0} sem."}}},"day":{"displayName":"jour","relative":{"0":"aujourd’hui","1":"demain","2":"après-demain","-2":"avant-hier","-1":"hier"},"relativeTime":{"future":{"one":"dans {0} jour","other":"dans {0} jours"},"past":{"one":"il y a {0} jour","other":"il y a {0} jours"}}},"day-short":{"displayName":"j","relative":{"0":"aujourd’hui","1":"demain","2":"après-demain","-2":"avant-hier","-1":"hier"},"relativeTime":{"future":{"one":"dans {0} j","other":"dans {0} j"},"past":{"one":"il y a {0} j","other":"il y a {0} j"}}},"hour":{"displayName":"heure","relative":{"0":"cette heure-ci"},"relativeTime":{"future":{"one":"dans {0} heure","other":"dans {0} heures"},"past":{"one":"il y a {0} heure","other":"il y a {0} heures"}}},"hour-short":{"displayName":"h","relative":{"0":"cette heure-ci"},"relativeTime":{"future":{"one":"dans {0} h","other":"dans {0} h"},"past":{"one":"il y a {0} h","other":"il y a {0} h"}}},"minute":{"displayName":"minute","relative":{"0":"cette minute-ci"},"relativeTime":{"future":{"one":"dans {0} minute","other":"dans {0} minutes"},"past":{"one":"il y a {0} minute","other":"il y a {0} minutes"}}},"minute-short":{"displayName":"min","relative":{"0":"cette minute-ci"},"relativeTime":{"future":{"one":"dans {0} min","other":"dans {0} min"},"past":{"one":"il y a {0} min","other":"il y a {0} min"}}},"second":{"displayName":"seconde","relative":{"0":"maintenant"},"relativeTime":{"future":{"one":"dans {0} seconde","other":"dans {0} secondes"},"past":{"one":"il y a {0} seconde","other":"il y a {0} secondes"}}},"second-short":{"displayName":"s","relative":{"0":"maintenant"},"relativeTime":{"future":{"one":"dans {0} s","other":"dans {0} s"},"past":{"one":"il y a {0} s","other":"il y a {0} s"}}}}},{"locale":"fr-BE","parentLocale":"fr"},{"locale":"fr-BF","parentLocale":"fr"},{"locale":"fr-BI","parentLocale":"fr"},{"locale":"fr-BJ","parentLocale":"fr"},{"locale":"fr-BL","parentLocale":"fr"},{"locale":"fr-CA","parentLocale":"fr","fields":{"year":{"displayName":"année","relative":{"0":"cette année","1":"l’année prochaine","-1":"l’année dernière"},"relativeTime":{"future":{"one":"Dans {0} an","other":"Dans {0} ans"},"past":{"one":"Il y a {0} an","other":"Il y a {0} ans"}}},"year-short":{"displayName":"a","relative":{"0":"cette année","1":"l’année prochaine","-1":"l’année dernière"},"relativeTime":{"future":{"one":"dans {0} a","other":"dans {0} a"},"past":{"one":"il y a {0} a","other":"il y a {0} a"}}},"month":{"displayName":"mois","relative":{"0":"ce mois-ci","1":"le mois prochain","-1":"le mois dernier"},"relativeTime":{"future":{"one":"dans {0} mois","other":"dans {0} mois"},"past":{"one":"il y a {0} mois","other":"il y a {0} mois"}}},"month-short":{"displayName":"m.","relative":{"0":"ce mois-ci","1":"le mois prochain","-1":"le mois dernier"},"relativeTime":{"future":{"one":"dans {0} m.","other":"dans {0} m."},"past":{"one":"il y a {0} m.","other":"il y a {0} m."}}},"week":{"displayName":"semaine","relativePeriod":"la semaine du {0}","relative":{"0":"cette semaine","1":"la semaine prochaine","-1":"la semaine dernière"},"relativeTime":{"future":{"one":"dans {0} semaine","other":"dans {0} semaines"},"past":{"one":"il y a {0} semaine","other":"il y a {0} semaines"}}},"week-short":{"displayName":"sem.","relativePeriod":"sem. du {0}","relative":{"0":"cette semaine","1":"la semaine prochaine","-1":"la semaine dernière"},"relativeTime":{"future":{"one":"dans {0} sem.","other":"dans {0} sem."},"past":{"one":"il y a {0} sem.","other":"il y a {0} sem."}}},"day":{"displayName":"jour","relative":{"0":"aujourd’hui","1":"demain","2":"après-demain","-2":"avant-hier","-1":"hier"},"relativeTime":{"future":{"one":"dans {0} jour","other":"dans {0} jours"},"past":{"one":"il y a {0} jour","other":"il y a {0} jours"}}},"day-short":{"displayName":"j","relative":{"0":"aujourd’hui","1":"demain","2":"après-demain","-2":"avant-hier","-1":"hier"},"relativeTime":{"future":{"one":"dans {0} j","other":"dans {0} j"},"past":{"one":"il y a {0} j","other":"il y a {0} j"}}},"hour":{"displayName":"heure","relative":{"0":"cette heure-ci"},"relativeTime":{"future":{"one":"dans {0} heure","other":"dans {0} heures"},"past":{"one":"il y a {0} heure","other":"il y a {0} heures"}}},"hour-short":{"displayName":"h","relative":{"0":"cette heure-ci"},"relativeTime":{"future":{"one":"dans {0} h","other":"dans {0} h"},"past":{"one":"il y a {0} h","other":"il y a {0} h"}}},"minute":{"displayName":"minute","relative":{"0":"cette minute-ci"},"relativeTime":{"future":{"one":"dans {0} minute","other":"dans {0} minutes"},"past":{"one":"il y a {0} minute","other":"il y a {0} minutes"}}},"minute-short":{"displayName":"min","relative":{"0":"cette minute-ci"},"relativeTime":{"future":{"one":"dans {0} min","other":"dans {0} min"},"past":{"one":"il y a {0} min","other":"il y a {0} min"}}},"second":{"displayName":"seconde","relative":{"0":"maintenant"},"relativeTime":{"future":{"one":"dans {0} seconde","other":"dans {0} secondes"},"past":{"one":"il y a {0} seconde","other":"il y a {0} secondes"}}},"second-short":{"displayName":"s","relative":{"0":"maintenant"},"relativeTime":{"future":{"one":"dans {0} s","other":"dans {0} s"},"past":{"one":"il y a {0} s","other":"il y a {0} s"}}}}},{"locale":"fr-CD","parentLocale":"fr"},{"locale":"fr-CF","parentLocale":"fr"},{"locale":"fr-CG","parentLocale":"fr"},{"locale":"fr-CH","parentLocale":"fr"},{"locale":"fr-CI","parentLocale":"fr"},{"locale":"fr-CM","parentLocale":"fr"},{"locale":"fr-DJ","parentLocale":"fr"},{"locale":"fr-DZ","parentLocale":"fr"},{"locale":"fr-GA","parentLocale":"fr"},{"locale":"fr-GF","parentLocale":"fr"},{"locale":"fr-GN","parentLocale":"fr"},{"locale":"fr-GP","parentLocale":"fr"},{"locale":"fr-GQ","parentLocale":"fr"},{"locale":"fr-HT","parentLocale":"fr","fields":{"year":{"displayName":"année","relative":{"0":"cette année","1":"l’année prochaine","-1":"l’année dernière"},"relativeTime":{"future":{"one":"dans {0} an","other":"dans {0} ans"},"past":{"one":"il y a {0} an","other":"il y a {0} ans"}}},"year-short":{"displayName":"an","relative":{"0":"cette année","1":"l’année prochaine","-1":"l’année dernière"},"relativeTime":{"future":{"one":"dans {0} a","other":"dans {0} a"},"past":{"one":"il y a {0} a","other":"il y a {0} a"}}},"month":{"displayName":"mois","relative":{"0":"ce mois-ci","1":"le mois prochain","-1":"le mois dernier"},"relativeTime":{"future":{"one":"dans {0} mois","other":"dans {0} mois"},"past":{"one":"il y a {0} mois","other":"il y a {0} mois"}}},"month-short":{"displayName":"m.","relative":{"0":"ce mois-ci","1":"le mois prochain","-1":"le mois dernier"},"relativeTime":{"future":{"one":"dans {0} m.","other":"dans {0} m."},"past":{"one":"il y a {0} m.","other":"il y a {0} m."}}},"week":{"displayName":"semaine","relativePeriod":"la semaine du {0}","relative":{"0":"cette semaine","1":"la semaine prochaine","-1":"la semaine dernière"},"relativeTime":{"future":{"one":"dans {0} semaine","other":"dans {0} semaines"},"past":{"one":"il y a {0} semaine","other":"il y a {0} semaines"}}},"week-short":{"displayName":"sem.","relativePeriod":"sem. du {0}","relative":{"0":"cette semaine","1":"la semaine prochaine","-1":"la semaine dernière"},"relativeTime":{"future":{"one":"dans {0} sem.","other":"dans {0} sem."},"past":{"one":"il y a {0} sem.","other":"il y a {0} sem."}}},"day":{"displayName":"jour","relative":{"0":"aujourd’hui","1":"demain","2":"après-demain","-2":"avant-hier","-1":"hier"},"relativeTime":{"future":{"one":"dans {0} jour","other":"dans {0} jours"},"past":{"one":"il y a {0} jour","other":"il y a {0} jours"}}},"day-short":{"displayName":"jr.","relative":{"0":"aujourd’hui","1":"demain","2":"après-demain","-2":"avant-hier","-1":"hier"},"relativeTime":{"future":{"one":"dans {0} j","other":"dans {0} j"},"past":{"one":"il y a {0} j","other":"il y a {0} j"}}},"hour":{"displayName":"heure","relative":{"0":"cette heure-ci"},"relativeTime":{"future":{"one":"dans {0} heure","other":"dans {0} heures"},"past":{"one":"il y a {0} heure","other":"il y a {0} heures"}}},"hour-short":{"displayName":"hr","relative":{"0":"cette heure-ci"},"relativeTime":{"future":{"one":"dans {0} h","other":"dans {0} h"},"past":{"one":"il y a {0} h","other":"il y a {0} h"}}},"minute":{"displayName":"minute","relative":{"0":"cette minute-ci"},"relativeTime":{"future":{"one":"dans {0} minute","other":"dans {0} minutes"},"past":{"one":"il y a {0} minute","other":"il y a {0} minutes"}}},"minute-short":{"displayName":"min.","relative":{"0":"cette minute-ci"},"relativeTime":{"future":{"one":"dans {0} min","other":"dans {0} min"},"past":{"one":"il y a {0} min","other":"il y a {0} min"}}},"second":{"displayName":"seconde","relative":{"0":"maintenant"},"relativeTime":{"future":{"one":"dans {0} seconde","other":"dans {0} secondes"},"past":{"one":"il y a {0} seconde","other":"il y a {0} secondes"}}},"second-short":{"displayName":"s","relative":{"0":"maintenant"},"relativeTime":{"future":{"one":"dans {0} s","other":"dans {0} s"},"past":{"one":"il y a {0} s","other":"il y a {0} s"}}}}},{"locale":"fr-KM","parentLocale":"fr"},{"locale":"fr-LU","parentLocale":"fr"},{"locale":"fr-MA","parentLocale":"fr"},{"locale":"fr-MC","parentLocale":"fr"},{"locale":"fr-MF","parentLocale":"fr"},{"locale":"fr-MG","parentLocale":"fr"},{"locale":"fr-ML","parentLocale":"fr"},{"locale":"fr-MQ","parentLocale":"fr"},{"locale":"fr-MR","parentLocale":"fr"},{"locale":"fr-MU","parentLocale":"fr"},{"locale":"fr-NC","parentLocale":"fr"},{"locale":"fr-NE","parentLocale":"fr"},{"locale":"fr-PF","parentLocale":"fr"},{"locale":"fr-PM","parentLocale":"fr"},{"locale":"fr-RE","parentLocale":"fr"},{"locale":"fr-RW","parentLocale":"fr"},{"locale":"fr-SC","parentLocale":"fr"},{"locale":"fr-SN","parentLocale":"fr"},{"locale":"fr-SY","parentLocale":"fr"},{"locale":"fr-TD","parentLocale":"fr"},{"locale":"fr-TG","parentLocale":"fr"},{"locale":"fr-TN","parentLocale":"fr"},{"locale":"fr-VU","parentLocale":"fr"},{"locale":"fr-WF","parentLocale":"fr"},{"locale":"fr-YT","parentLocale":"fr"},
    {"locale":"fur","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"an","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"one":"ca di {0} an","other":"ca di {0} agns"},"past":{"one":"{0} an indaûr","other":"{0} agns indaûr"}}},"year-short":{"displayName":"an","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"one":"ca di {0} an","other":"ca di {0} agns"},"past":{"one":"{0} an indaûr","other":"{0} agns indaûr"}}},"month":{"displayName":"mês","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"ca di {0} mês","other":"ca di {0} mês"},"past":{"one":"{0} mês indaûr","other":"{0} mês indaûr"}}},"month-short":{"displayName":"mês","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"ca di {0} mês","other":"ca di {0} mês"},"past":{"one":"{0} mês indaûr","other":"{0} mês indaûr"}}},"week":{"displayName":"setemane","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"ca di {0} setemane","other":"ca di {0} setemanis"},"past":{"one":"{0} setemane indaûr","other":"{0} setemanis indaûr"}}},"week-short":{"displayName":"setemane","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"ca di {0} setemane","other":"ca di {0} setemanis"},"past":{"one":"{0} setemane indaûr","other":"{0} setemanis indaûr"}}},"day":{"displayName":"dì","relative":{"0":"vuê","1":"doman","2":"passantdoman","-2":"îr l’altri","-1":"îr"},"relativeTime":{"future":{"one":"ca di {0} zornade","other":"ca di {0} zornadis"},"past":{"one":"{0} zornade indaûr","other":"{0} zornadis indaûr"}}},"day-short":{"displayName":"dì","relative":{"0":"vuê","1":"doman","2":"passantdoman","-2":"îr l’altri","-1":"îr"},"relativeTime":{"future":{"one":"ca di {0} zornade","other":"ca di {0} zornadis"},"past":{"one":"{0} zornade indaûr","other":"{0} zornadis indaûr"}}},"hour":{"displayName":"ore","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"ca di {0} ore","other":"ca di {0} oris"},"past":{"one":"{0} ore indaûr","other":"{0} oris indaûr"}}},"hour-short":{"displayName":"ore","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"ca di {0} ore","other":"ca di {0} oris"},"past":{"one":"{0} ore indaûr","other":"{0} oris indaûr"}}},"minute":{"displayName":"minût","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"ca di {0} minût","other":"ca di {0} minûts"},"past":{"one":"{0} minût indaûr","other":"{0} minûts indaûr"}}},"minute-short":{"displayName":"minût","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"ca di {0} minût","other":"ca di {0} minûts"},"past":{"one":"{0} minût indaûr","other":"{0} minûts indaûr"}}},"second":{"displayName":"secont","relative":{"0":"now"},"relativeTime":{"future":{"one":"ca di {0} secont","other":"ca di {0} seconts"},"past":{"one":"{0} secont indaûr","other":"{0} seconts indaûr"}}},"second-short":{"displayName":"secont","relative":{"0":"now"},"relativeTime":{"future":{"one":"ca di {0} secont","other":"ca di {0} seconts"},"past":{"one":"{0} secont indaûr","other":"{0} seconts indaûr"}}}}},
    {"locale":"fy","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      if (ord) return 'other';
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Jier","relative":{"0":"dit jier","1":"folgjend jier","-1":"foarich jier"},"relativeTime":{"future":{"one":"Oer {0} jier","other":"Oer {0} jier"},"past":{"one":"{0} jier lyn","other":"{0} jier lyn"}}},"year-short":{"displayName":"Jier","relative":{"0":"dit jier","1":"folgjend jier","-1":"foarich jier"},"relativeTime":{"future":{"one":"Oer {0} jier","other":"Oer {0} jier"},"past":{"one":"{0} jier lyn","other":"{0} jier lyn"}}},"month":{"displayName":"Moanne","relative":{"0":"dizze moanne","1":"folgjende moanne","-1":"foarige moanne"},"relativeTime":{"future":{"one":"Oer {0} moanne","other":"Oer {0} moannen"},"past":{"one":"{0} moanne lyn","other":"{0} moannen lyn"}}},"month-short":{"displayName":"Moanne","relative":{"0":"dizze moanne","1":"folgjende moanne","-1":"foarige moanne"},"relativeTime":{"future":{"one":"Oer {0} moanne","other":"Oer {0} moannen"},"past":{"one":"{0} moanne lyn","other":"{0} moannen lyn"}}},"week":{"displayName":"Wike","relativePeriod":"the week of {0}","relative":{"0":"dizze wike","1":"folgjende wike","-1":"foarige wike"},"relativeTime":{"future":{"one":"Oer {0} wike","other":"Oer {0} wiken"},"past":{"one":"{0} wike lyn","other":"{0} wiken lyn"}}},"week-short":{"displayName":"Wike","relativePeriod":"the week of {0}","relative":{"0":"dizze wike","1":"folgjende wike","-1":"foarige wike"},"relativeTime":{"future":{"one":"Oer {0} wike","other":"Oer {0} wiken"},"past":{"one":"{0} wike lyn","other":"{0} wiken lyn"}}},"day":{"displayName":"dei","relative":{"0":"vandaag","1":"morgen","2":"Oermorgen","-2":"eergisteren","-1":"gisteren"},"relativeTime":{"future":{"one":"Oer {0} dei","other":"Oer {0} deien"},"past":{"one":"{0} dei lyn","other":"{0} deien lyn"}}},"day-short":{"displayName":"dei","relative":{"0":"vandaag","1":"morgen","2":"Oermorgen","-2":"eergisteren","-1":"gisteren"},"relativeTime":{"future":{"one":"Oer {0} dei","other":"Oer {0} deien"},"past":{"one":"{0} dei lyn","other":"{0} deien lyn"}}},"hour":{"displayName":"oere","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"Oer {0} oere","other":"Oer {0} oere"},"past":{"one":"{0} oere lyn","other":"{0} oere lyn"}}},"hour-short":{"displayName":"oere","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"Oer {0} oere","other":"Oer {0} oere"},"past":{"one":"{0} oere lyn","other":"{0} oere lyn"}}},"minute":{"displayName":"Minút","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"Oer {0} minút","other":"Oer {0} minuten"},"past":{"one":"{0} minút lyn","other":"{0} minuten lyn"}}},"minute-short":{"displayName":"Minút","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"Oer {0} minút","other":"Oer {0} minuten"},"past":{"one":"{0} minút lyn","other":"{0} minuten lyn"}}},"second":{"displayName":"Sekonde","relative":{"0":"nu"},"relativeTime":{"future":{"one":"Oer {0} sekonde","other":"Oer {0} sekonden"},"past":{"one":"{0} sekonde lyn","other":"{0} sekonden lyn"}}},"second-short":{"displayName":"Sekonde","relative":{"0":"nu"},"relativeTime":{"future":{"one":"Oer {0} sekonde","other":"Oer {0} sekonden"},"past":{"one":"{0} sekonde lyn","other":"{0} sekonden lyn"}}}}},
    {"locale":"ga","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), t0 = Number(s[0]) == n;
      if (ord) return (n == 1) ? 'one' : 'other';
      return (n == 1) ? 'one'
          : (n == 2) ? 'two'
          : ((t0 && n >= 3 && n <= 6)) ? 'few'
          : ((t0 && n >= 7 && n <= 10)) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"Bliain","relative":{"0":"an bhliain seo","1":"an bhliain seo chugainn","-1":"anuraidh"},"relativeTime":{"future":{"one":"i gceann {0} bhliain","two":"i gceann {0} bhliain","few":"i gceann {0} bliana","many":"i gceann {0} mbliana","other":"i gceann {0} bliain"},"past":{"one":"{0} bhliain ó shin","two":"{0} bhliain ó shin","few":"{0} bliana ó shin","many":"{0} mbliana ó shin","other":"{0} bliain ó shin"}}},"year-short":{"displayName":"bl.","relative":{"0":"an bhl. seo","1":"an bhl. seo chugainn","-1":"anuraidh"},"relativeTime":{"future":{"one":"i gceann {0} bl.","two":"i gceann {0} bhl.","few":"i gceann {0} bl.","many":"i gceann {0} mbl.","other":"i gceann {0} bl."},"past":{"one":"{0} bhl. ó shin","two":"{0} bhl. ó shin","few":"{0} bl. ó shin","many":"{0} mbl. ó shin","other":"{0} bl. ó shin"}}},"month":{"displayName":"Mí","relative":{"0":"an mhí seo","1":"an mhí seo chugainn","-1":"an mhí seo caite"},"relativeTime":{"future":{"one":"i gceann {0} mhí","two":"i gceann {0} mhí","few":"i gceann {0} mhí","many":"i gceann {0} mí","other":"i gceann {0} mí"},"past":{"one":"{0} mhí ó shin","two":"{0} mhí ó shin","few":"{0} mhí ó shin","many":"{0} mí ó shin","other":"{0} mí ó shin"}}},"month-short":{"displayName":"mí","relative":{"0":"an mhí seo","1":"an mhí seo chugainn","-1":"an mhí seo caite"},"relativeTime":{"future":{"one":"i gceann {0} mhí","two":"i gceann {0} mhí","few":"i gceann {0} mhí","many":"i gceann {0} mí","other":"i gceann {0} mí"},"past":{"one":"{0} mhí ó shin","two":"{0} mhí ó shin","few":"{0} mhí ó shin","many":"{0} mí ó shin","other":"{0} mí ó shin"}}},"week":{"displayName":"Seachtain","relativePeriod":"seachtain {0}","relative":{"0":"an tseachtain seo","1":"an tseachtain seo chugainn","-1":"an tseachtain seo caite"},"relativeTime":{"future":{"one":"i gceann {0} seachtain","two":"i gceann {0} sheachtain","few":"i gceann {0} seachtaine","many":"i gceann {0} seachtaine","other":"i gceann {0} seachtain"},"past":{"one":"{0} seachtain ó shin","two":"{0} sheachtain ó shin","few":"{0} seachtaine ó shin","many":"{0} seachtaine ó shin","other":"{0} seachtain ó shin"}}},"week-short":{"displayName":"scht.","relativePeriod":"seachtain {0}","relative":{"0":"an tscht. seo","1":"an tscht. seo chugainn","-1":"an tscht. seo caite"},"relativeTime":{"future":{"one":"i gceann {0} scht.","two":"i gceann {0} shcht.","few":"i gceann {0} scht.","many":"i gceann {0} scht.","other":"i gceann {0} scht."},"past":{"one":"{0} scht. ó shin","two":"{0} scht. ó shin","few":"{0} scht. ó shin","many":"{0} scht. ó shin","other":"{0} scht. ó shin"}}},"day":{"displayName":"Lá","relative":{"0":"inniu","1":"amárach","2":"arú amárach","-2":"arú inné","-1":"inné"},"relativeTime":{"future":{"one":"i gceann {0} lá","two":"i gceann {0} lá","few":"i gceann {0} lá","many":"i gceann {0} lá","other":"i gceann {0} lá"},"past":{"one":"{0} lá ó shin","two":"{0} lá ó shin","few":"{0} lá ó shin","many":"{0} lá ó shin","other":"{0} lá ó shin"}}},"day-short":{"displayName":"Lá","relative":{"0":"inniu","1":"amárach","2":"arú amárach","-2":"arú inné","-1":"inné"},"relativeTime":{"future":{"one":"i gceann {0} lá","two":"i gceann {0} lá","few":"i gceann {0} lá","many":"i gceann {0} lá","other":"i gceann {0} lá"},"past":{"one":"{0} lá ó shin","two":"{0} lá ó shin","few":"{0} lá ó shin","many":"{0} lá ó shin","other":"{0} lá ó shin"}}},"hour":{"displayName":"Uair","relative":{"0":"an uair seo"},"relativeTime":{"future":{"one":"i gceann {0} uair an chloig","two":"i gceann {0} uair an chloig","few":"i gceann {0} huaire an chloig","many":"i gceann {0} n-uaire an chloig","other":"i gceann {0} uair an chloig"},"past":{"one":"{0} uair an chloig ó shin","two":"{0} uair an chloig ó shin","few":"{0} huaire an chloig ó shin","many":"{0} n-uaire an chloig ó shin","other":"{0} uair an chloig ó shin"}}},"hour-short":{"displayName":"uair","relative":{"0":"an uair seo"},"relativeTime":{"future":{"one":"i gceann {0} uair","two":"i gceann {0} uair","few":"i gceann {0} huaire","many":"i gceann {0} n-uaire","other":"i gceann {0} uair"},"past":{"one":"{0} uair ó shin","two":"{0} uair ó shin","few":"{0} huaire ó shin","many":"{0} n-uaire ó shin","other":"{0} uair ó shin"}}},"minute":{"displayName":"Nóiméad","relative":{"0":"an nóiméad seo"},"relativeTime":{"future":{"one":"i gceann {0} nóiméad","two":"i gceann {0} nóiméad","few":"i gceann {0} nóiméad","many":"i gceann {0} nóiméad","other":"i gceann {0} nóiméad"},"past":{"one":"{0} nóiméad ó shin","two":"{0} nóiméad ó shin","few":"{0} nóiméad ó shin","many":"{0} nóiméad ó shin","other":"{0} nóiméad ó shin"}}},"minute-short":{"displayName":"nóim.","relative":{"0":"an nóiméad seo"},"relativeTime":{"future":{"one":"i gceann {0} nóim.","two":"i gceann {0} nóim.","few":"i gceann {0} nóim.","many":"i gceann {0} nóim.","other":"i gceann {0} nóim."},"past":{"one":"{0} nóim. ó shin","two":"{0} nóim. ó shin","few":"{0} nóim. ó shin","many":"{0} nóim. ó shin","other":"{0} nóim. ó shin"}}},"second":{"displayName":"Soicind","relative":{"0":"anois"},"relativeTime":{"future":{"one":"i gceann {0} soicind","two":"i gceann {0} shoicind","few":"i gceann {0} shoicind","many":"i gceann {0} soicind","other":"i gceann {0} soicind"},"past":{"one":"{0} soicind ó shin","two":"{0} shoicind ó shin","few":"{0} shoicind ó shin","many":"{0} soicind ó shin","other":"{0} soicind ó shin"}}},"second-short":{"displayName":"soic.","relative":{"0":"anois"},"relativeTime":{"future":{"one":"i gceann {0} soic.","two":"i gceann {0} shoic.","few":"i gceann {0} shoic.","many":"i gceann {0} soic.","other":"i gceann {0} soic."},"past":{"one":"{0} soic. ó shin","two":"{0} shoic. ó shin","few":"{0} shoic. ó shin","many":"{0} soic. ó shin","other":"{0} soic. ó shin"}}}}},
    {"locale":"gd","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), t0 = Number(s[0]) == n;
      if (ord) return ((n == 1
              || n == 11)) ? 'one'
          : ((n == 2
              || n == 12)) ? 'two'
          : ((n == 3
              || n == 13)) ? 'few'
          : 'other';
      return ((n == 1
              || n == 11)) ? 'one'
          : ((n == 2
              || n == 12)) ? 'two'
          : (((t0 && n >= 3 && n <= 10)
              || (t0 && n >= 13 && n <= 19))) ? 'few'
          : 'other';
    },"fields":{"year":{"displayName":"bliadhna","relative":{"0":"am bliadhna","1":"an ath-bhliadhna","-2":"a-bhòn-uiridh","-1":"an-uiridh"},"relativeTime":{"future":{"one":"an ceann {0} bhliadhna","two":"an ceann {0} bhliadhna","few":"an ceann {0} bliadhnaichean","other":"an ceann {0} bliadhna"},"past":{"one":"{0} bhliadhna air ais","two":"{0} bhliadhna air ais","few":"{0} bhliadhnaichean air ais","other":"{0} bliadhna air ais"}}},"year-short":{"displayName":"blia.","relative":{"0":"am bliadhna","1":"an ath-bhliadhna","-2":"a-bhòn-uiridh","-1":"an-uiridh"},"relativeTime":{"future":{"one":"an {0} bhlia.","two":"an {0} bhlia.","few":"an {0} blia.","other":"an {0} blia."},"past":{"one":"o {0} bhlia.","two":"o {0} bhlia.","few":"o {0} blia.","other":"o {0} blia."}}},"month":{"displayName":"mìos","relative":{"0":"am mìos seo","1":"an ath-mhìos","-1":"am mìos seo chaidh"},"relativeTime":{"future":{"one":"an ceann {0} mhìosa","two":"an ceann {0} mhìosa","few":"an ceann {0} mìosan","other":"an ceann {0} mìosa"},"past":{"one":"{0} mhìos air ais","two":"{0} mhìos air ais","few":"{0} mìosan air ais","other":"{0} mìos air ais"}}},"month-short":{"displayName":"mìos","relative":{"0":"am mìos seo","1":"an ath-mhìos","-1":"am mìos sa chaidh"},"relativeTime":{"future":{"one":"an {0} mhìos.","two":"an {0} mhìos.","few":"an {0} mìos.","other":"an {0} mìos."},"past":{"one":"o {0} mhìos.","two":"o {0} mhìos.","few":"o {0} mìos.","other":"o {0} mìos."}}},"week":{"displayName":"seachdain","relativePeriod":"an t-seachdain aig {0}","relative":{"0":"an t-seachdain seo","1":"an ath-sheachdain","-1":"an t-seachdain seo chaidh"},"relativeTime":{"future":{"one":"an ceann {0} seachdain","two":"an ceann {0} sheachdain","few":"an ceann {0} seachdainean","other":"an ceann {0} seachdain"},"past":{"one":"{0} seachdain air ais","two":"{0} sheachdain air ais","few":"{0} seachdainean air ais","other":"{0} seachdain air ais"}}},"week-short":{"displayName":"seachd.","relativePeriod":"an t-seachdain aig {0}","relative":{"0":"an t-seachd. seo","1":"an ath-sheachd.","-1":"seachd. sa chaidh"},"relativeTime":{"future":{"one":"an {0} sheachd.","two":"an {0} sheachd.","few":"an {0} seachd.","other":"an {0} seachd."},"past":{"one":"o {0} sheachd.","two":"o {0} sheachd.","few":"o {0} seachd.","other":"o {0} seachd."}}},"day":{"displayName":"latha","relative":{"0":"an-diugh","1":"a-màireach","2":"an-earar","3":"an-eararais","-2":"a-bhòin-dè","-1":"an-dè"},"relativeTime":{"future":{"one":"an ceann {0} latha","two":"an ceann {0} latha","few":"an ceann {0} làithean","other":"an ceann {0} latha"},"past":{"one":"{0} latha air ais","two":"{0} latha air ais","few":"{0} làithean air ais","other":"{0} latha air ais"}}},"day-short":{"displayName":"là","relative":{"0":"an-diugh","1":"a-màireach","2":"an-earar","3":"an-eararais","-2":"a-bhòin-dè","-1":"an-dè"},"relativeTime":{"future":{"one":"an {0} là","two":"an {0} là","few":"an {0} là.","other":"an {0} là"},"past":{"one":"o {0} là","two":"o {0} là","few":"o {0} là.","other":"o {0} là"}}},"hour":{"displayName":"uair a thìde","relative":{"0":"am broinn uair a thìde"},"relativeTime":{"future":{"one":"an ceann {0} uair a thìde","two":"an ceann {0} uair a thìde","few":"an ceann {0} uairean a thìde","other":"an ceann {0} uair a thìde"},"past":{"one":"{0} uair a thìde air ais","two":"{0} uair a thìde air ais","few":"{0} uairean a thìde air ais","other":"{0} uair a thìde air ais"}}},"hour-short":{"displayName":"uair","relative":{"0":"am broinn uair"},"relativeTime":{"future":{"one":"an {0} uair","two":"an {0} uair","few":"an {0} uair.","other":"an {0} uair"},"past":{"one":"o {0} uair","two":"o {0} uair","few":"o {0} uair.","other":"o {0} uair"}}},"minute":{"displayName":"mionaid","relative":{"0":"am broinn mionaid"},"relativeTime":{"future":{"one":"an ceann {0} mhionaid","two":"an ceann {0} mhionaid","few":"an ceann {0} mionaidean","other":"an ceann {0} mionaid"},"past":{"one":"{0} mhionaid air ais","two":"{0} mhionaid air ais","few":"{0} mionaidean air ais","other":"{0} mionaid air ais"}}},"minute-short":{"displayName":"mion.","relative":{"0":"am broinn mion."},"relativeTime":{"future":{"one":"an {0} mhion.","two":"an {0} mhion.","few":"an {0} mion.","other":"an {0} mion."},"past":{"one":"o {0} mhion.","two":"o {0} mhion.","few":"o {0} mion.","other":"o {0} mion."}}},"second":{"displayName":"diog","relative":{"0":"an-dràsta"},"relativeTime":{"future":{"one":"an ceann {0} diog","two":"an ceann {0} dhiog","few":"an ceann {0} diogan","other":"an ceann {0} diog"},"past":{"one":"{0} diog air ais","two":"{0} dhiog air ais","few":"{0} diogan air ais","other":"{0} diog air ais"}}},"second-short":{"displayName":"diog","relative":{"0":"an-dràsta"},"relativeTime":{"future":{"one":"an {0} diog","two":"an {0} dhiog","few":"an {0} diog.","other":"an {0} diog"},"past":{"one":"o {0} diog","two":"o {0} dhiog","few":"o {0} diog.","other":"o {0} diog"}}}}},
    {"locale":"gl","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      if (ord) return 'other';
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ano","relative":{"0":"este ano","1":"o próximo ano","-1":"o ano pasado"},"relativeTime":{"future":{"one":"en {0} ano","other":"en {0} anos"},"past":{"one":"hai {0} ano","other":"hai {0} anos"}}},"year-short":{"displayName":"ano","relative":{"0":"este ano","1":"seguinte ano","-1":"ano pasado"},"relativeTime":{"future":{"one":"en {0} ano","other":"en {0} anos"},"past":{"one":"hai {0} ano","other":"hai {0} anos"}}},"month":{"displayName":"mes","relative":{"0":"este mes","1":"o próximo mes","-1":"o mes pasado"},"relativeTime":{"future":{"one":"en {0} mes","other":"en {0} meses"},"past":{"one":"hai {0} mes","other":"hai {0} meses"}}},"month-short":{"displayName":"mes","relative":{"0":"este m.","1":"m. seguinte","-1":"m. pasado"},"relativeTime":{"future":{"one":"en {0} mes","other":"en {0} meses"},"past":{"one":"hai {0} mes","other":"hai {0} meses"}}},"week":{"displayName":"semana","relativePeriod":"a semana do {0}","relative":{"0":"esta semana","1":"a próxima semana","-1":"a semana pasada"},"relativeTime":{"future":{"one":"en {0} semana","other":"en {0} semanas"},"past":{"one":"hai {0} semana","other":"hai {0} semanas"}}},"week-short":{"displayName":"sem.","relativePeriod":"a semana do {0}","relative":{"0":"esta sem.","1":"sem. seguinte","-1":"sem. pasada"},"relativeTime":{"future":{"one":"en {0} sem.","other":"en {0} sem."},"past":{"one":"hai {0} sem.","other":"hai {0} sem."}}},"day":{"displayName":"día","relative":{"0":"hoxe","1":"mañá","2":"pasadomañá","-2":"antonte","-1":"onte"},"relativeTime":{"future":{"one":"en {0} día","other":"en {0} días"},"past":{"one":"hai {0} día","other":"hai {0} días"}}},"day-short":{"displayName":"día","relative":{"0":"hoxe","1":"mañá","2":"pasadomañá","-2":"antonte","-1":"onte"},"relativeTime":{"future":{"one":"en {0} día","other":"en {0} días"},"past":{"one":"hai {0} día","other":"hai {0} días"}}},"hour":{"displayName":"hora","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"en {0} hora","other":"en {0} horas"},"past":{"one":"hai {0} hora","other":"hai {0} horas"}}},"hour-short":{"displayName":"h","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"en {0} h","other":"en {0} h"},"past":{"one":"hai {0} h","other":"hai {0} h"}}},"minute":{"displayName":"minuto","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"en {0} minuto","other":"en {0} minutos"},"past":{"one":"hai {0} minuto","other":"hai {0} minutos"}}},"minute-short":{"displayName":"min","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"en {0} min","other":"en {0} min"},"past":{"one":"hai {0} min","other":"hai {0} min"}}},"second":{"displayName":"segundo","relative":{"0":"agora"},"relativeTime":{"future":{"one":"en {0} segundo","other":"en {0} segundos"},"past":{"one":"hai {0} segundo","other":"hai {0} segundos"}}},"second-short":{"displayName":"s","relative":{"0":"agora"},"relativeTime":{"future":{"one":"en {0} s","other":"en {0} s"},"past":{"one":"hai {0} s","other":"hai {0} s"}}}}},
    {"locale":"gsw","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Jaar","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Jaar","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Monet","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Monet","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Wuche","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Wuche","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Tag","relative":{"0":"hüt","1":"moorn","2":"übermoorn","-2":"vorgeschter","-1":"geschter"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Tag","relative":{"0":"hüt","1":"moorn","2":"übermoorn","-2":"vorgeschter","-1":"geschter"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Schtund","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Schtund","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minuute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minuute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"gsw-FR","parentLocale":"gsw"},{"locale":"gsw-LI","parentLocale":"gsw"},
    {"locale":"gu","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return (n == 1) ? 'one'
          : ((n == 2
              || n == 3)) ? 'two'
          : (n == 4) ? 'few'
          : (n == 6) ? 'many'
          : 'other';
      return (n >= 0 && n <= 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"વર્ષ","relative":{"0":"આ વર્ષે","1":"આવતા વર્ષે","-1":"ગયા વર્ષે"},"relativeTime":{"future":{"one":"{0} વર્ષમાં","other":"{0} વર્ષમાં"},"past":{"one":"{0} વર્ષ પહેલાં","other":"{0} વર્ષ પહેલાં"}}},"year-short":{"displayName":"વ.","relative":{"0":"આ વર્ષે","1":"આવતા વર્ષે","-1":"ગયા વર્ષે"},"relativeTime":{"future":{"one":"{0} વર્ષમાં","other":"{0} વર્ષમાં"},"past":{"one":"{0} વર્ષ પહેલાં","other":"{0} વર્ષ પહેલાં"}}},"month":{"displayName":"મહિનો","relative":{"0":"આ મહિને","1":"આવતા મહિને","-1":"ગયા મહિને"},"relativeTime":{"future":{"one":"{0} મહિનામાં","other":"{0} મહિનામાં"},"past":{"one":"{0} મહિના પહેલાં","other":"{0} મહિના પહેલાં"}}},"month-short":{"displayName":"મ.","relative":{"0":"આ મહિને","1":"આવતા મહિને","-1":"ગયા મહિને"},"relativeTime":{"future":{"one":"{0} મહિનામાં","other":"{0} મહિનામાં"},"past":{"one":"{0} મહિના પહેલાં","other":"{0} મહિના પહેલાં"}}},"week":{"displayName":"અઠવાડિયું","relativePeriod":"{0} નું અઠવાડિયું","relative":{"0":"આ અઠવાડિયે","1":"આવતા અઠવાડિયે","-1":"ગયા અઠવાડિયે"},"relativeTime":{"future":{"one":"{0} અઠવાડિયામાં","other":"{0} અઠવાડિયામાં"},"past":{"one":"{0} અઠવાડિયા પહેલાં","other":"{0} અઠવાડિયા પહેલાં"}}},"week-short":{"displayName":"અઠ.","relativePeriod":"{0} નું અઠવાડિયું","relative":{"0":"આ અઠવાડિયે","1":"આવતા અઠવાડિયે","-1":"ગયા અઠવાડિયે"},"relativeTime":{"future":{"one":"{0} અઠ. માં","other":"{0} અઠ. માં"},"past":{"one":"{0} અઠ. પહેલાં","other":"{0} અઠ. પહેલાં"}}},"day":{"displayName":"દિવસ","relative":{"0":"આજે","1":"આવતીકાલે","2":"પરમદિવસે","-2":"ગયા પરમદિવસે","-1":"ગઈકાલે"},"relativeTime":{"future":{"one":"{0} દિવસમાં","other":"{0} દિવસમાં"},"past":{"one":"{0} દિવસ પહેલાં","other":"{0} દિવસ પહેલાં"}}},"day-short":{"displayName":"દિવસ","relative":{"0":"આજે","1":"આવતીકાલે","2":"પરમદિવસે","-2":"ગયા પરમદિવસે","-1":"ગઈકાલે"},"relativeTime":{"future":{"one":"{0} દિવસમાં","other":"{0} દિવસમાં"},"past":{"one":"{0} દિવસ પહેલાં","other":"{0} દિવસ પહેલાં"}}},"hour":{"displayName":"કલાક","relative":{"0":"આ કલાક"},"relativeTime":{"future":{"one":"{0} કલાકમાં","other":"{0} કલાકમાં"},"past":{"one":"{0} કલાક પહેલાં","other":"{0} કલાક પહેલાં"}}},"hour-short":{"displayName":"ક.","relative":{"0":"આ કલાક"},"relativeTime":{"future":{"one":"{0} કલાકમાં","other":"{0} કલાકમાં"},"past":{"one":"{0} કલાક પહેલાં","other":"{0} કલાક પહેલાં"}}},"minute":{"displayName":"મિનિટ","relative":{"0":"આ મિનિટ"},"relativeTime":{"future":{"one":"{0} મિનિટમાં","other":"{0} મિનિટમાં"},"past":{"one":"{0} મિનિટ પહેલાં","other":"{0} મિનિટ પહેલાં"}}},"minute-short":{"displayName":"મિ.","relative":{"0":"આ મિનિટ"},"relativeTime":{"future":{"one":"{0} મિનિટમાં","other":"{0} મિનિટમાં"},"past":{"one":"{0} મિનિટ પહેલાં","other":"{0} મિનિટ પહેલાં"}}},"second":{"displayName":"સેકન્ડ","relative":{"0":"હમણાં"},"relativeTime":{"future":{"one":"{0} સેકંડમાં","other":"{0} સેકંડમાં"},"past":{"one":"{0} સેકંડ પહેલાં","other":"{0} સેકંડ પહેલાં"}}},"second-short":{"displayName":"સે.","relative":{"0":"હમણાં"},"relativeTime":{"future":{"one":"{0} સેકંડમાં","other":"{0} સેકંડમાં"},"past":{"one":"{0} સેકંડ પહેલાં","other":"{0} સેકંડ પહેલાં"}}}}},
    {"locale":"guw","pluralRuleFunction":function(n
    ) {
      return ((n == 0
              || n == 1)) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"guz","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Omwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Omwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Omotienyi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Omotienyi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Omokubio","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Omokubio","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Rituko","relative":{"0":"Rero","1":"Mambia","-1":"Igoro"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Rituko","relative":{"0":"Rero","1":"Mambia","-1":"Igoro"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Ensa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Ensa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Edakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Edakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Esekendi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Esekendi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"gv","pluralRuleFunction":function(n
    ) {
      var s = String(n).split('.'), i = s[0], v0 = !s[1], i10 = i.slice(-1),
          i100 = i.slice(-2);
      return (v0 && i10 == 1) ? 'one'
          : (v0 && i10 == 2) ? 'two'
          : (v0 && (i100 == 0 || i100 == 20 || i100 == 40 || i100 == 60
              || i100 == 80)) ? 'few'
          : (!v0) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ha","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Shekara","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Shekara","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Wata","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Wata","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Mako","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Mako","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Kwana","relative":{"0":"Yau","1":"Gobe","-1":"Jiya"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Kwana","relative":{"0":"Yau","1":"Gobe","-1":"Jiya"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Awa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Awa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Daƙiƙa","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Daƙiƙa","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"ha-Arab","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"ha-GH","parentLocale":"ha"},{"locale":"ha-NE","parentLocale":"ha"},
    {"locale":"haw","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"he","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], v0 = !s[1], t0 = Number(s[0]) == n,
          n10 = t0 && s[0].slice(-1);
      if (ord) return 'other';
      return (n == 1 && v0) ? 'one'
          : (i == 2 && v0) ? 'two'
          : (v0 && (n < 0
              || n > 10) && t0 && n10 == 0) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"שנה","relative":{"0":"השנה","1":"השנה הבאה","-1":"השנה שעברה"},"relativeTime":{"future":{"one":"בעוד שנה","two":"בעוד שנתיים","many":"בעוד {0} שנה","other":"בעוד {0} שנים"},"past":{"one":"לפני שנה","two":"לפני שנתיים","many":"לפני {0} שנה","other":"לפני {0} שנים"}}},"year-short":{"displayName":"שנ׳","relative":{"0":"השנה","1":"השנה הבאה","-1":"השנה שעברה"},"relativeTime":{"future":{"one":"בעוד שנה","two":"בעוד שנתיים","many":"בעוד {0} שנה","other":"בעוד {0} שנים"},"past":{"one":"לפני שנה","two":"לפני שנתיים","many":"לפני {0} שנה","other":"לפני {0} שנים"}}},"month":{"displayName":"חודש","relative":{"0":"החודש","1":"החודש הבא","-1":"החודש שעבר"},"relativeTime":{"future":{"one":"בעוד חודש","two":"בעוד חודשיים","many":"בעוד {0} חודשים","other":"בעוד {0} חודשים"},"past":{"one":"לפני חודש","two":"לפני חודשיים","many":"לפני {0} חודשים","other":"לפני {0} חודשים"}}},"month-short":{"displayName":"חו׳","relative":{"0":"החודש","1":"החודש הבא","-1":"החודש שעבר"},"relativeTime":{"future":{"one":"בעוד חודש","two":"בעוד חודשיים","many":"בעוד {0} חודשים","other":"בעוד {0} חודשים"},"past":{"one":"לפני חודש","two":"לפני חודשיים","many":"לפני {0} חודשים","other":"לפני {0} חודשים"}}},"week":{"displayName":"שבוע","relativePeriod":"השבוע של","relative":{"0":"השבוע","1":"השבוע הבא","-1":"השבוע שעבר"},"relativeTime":{"future":{"one":"בעוד שבוע","two":"בעוד שבועיים","many":"בעוד {0} שבועות","other":"בעוד {0} שבועות"},"past":{"one":"לפני שבוע","two":"לפני שבועיים","many":"לפני {0} שבועות","other":"לפני {0} שבועות"}}},"week-short":{"displayName":"שב׳","relativePeriod":"השבוע של {0}","relative":{"0":"השבוע","1":"השבוע הבא","-1":"השבוע שעבר"},"relativeTime":{"future":{"one":"בעוד שב׳","two":"בעוד שבועיים","many":"בעוד {0} שב׳","other":"בעוד {0} שב׳"},"past":{"one":"לפני שב׳","two":"לפני שבועיים","many":"לפני {0} שב׳","other":"לפני {0} שב׳"}}},"day":{"displayName":"יום","relative":{"0":"היום","1":"מחר","2":"מחרתיים","-2":"שלשום","-1":"אתמול"},"relativeTime":{"future":{"one":"בעוד יום {0}","two":"בעוד יומיים","many":"בעוד {0} ימים","other":"בעוד {0} ימים"},"past":{"one":"לפני יום {0}","two":"לפני יומיים","many":"לפני {0} ימים","other":"לפני {0} ימים"}}},"day-short":{"displayName":"יום","relative":{"0":"היום","1":"מחר","2":"מחרתיים","-2":"שלשום","-1":"אתמול"},"relativeTime":{"future":{"one":"מחר","two":"בעוד יומיים","many":"בעוד {0} ימים","other":"בעוד {0} ימים"},"past":{"one":"אתמול","two":"לפני יומיים","many":"לפני {0} ימים","other":"לפני {0} ימים"}}},"hour":{"displayName":"שעה","relative":{"0":"בשעה זו"},"relativeTime":{"future":{"one":"בעוד שעה","two":"בעוד שעתיים","many":"בעוד {0} שעות","other":"בעוד {0} שעות"},"past":{"one":"לפני שעה","two":"לפני שעתיים","many":"לפני {0} שעות","other":"לפני {0} שעות"}}},"hour-short":{"displayName":"שעה","relative":{"0":"בשעה זו"},"relativeTime":{"future":{"one":"בעוד שעה","two":"בעוד שעתיים","many":"בעוד {0} שע׳","other":"בעוד {0} שע׳"},"past":{"one":"לפני שעה","two":"לפני שעתיים","many":"לפני {0} שע׳","other":"לפני {0} שע׳"}}},"minute":{"displayName":"דקה","relative":{"0":"בדקה זו"},"relativeTime":{"future":{"one":"בעוד דקה","two":"בעוד שתי דקות","many":"בעוד {0} דקות","other":"בעוד {0} דקות"},"past":{"one":"לפני דקה","two":"לפני שתי דקות","many":"לפני {0} דקות","other":"לפני {0} דקות"}}},"minute-short":{"displayName":"דק׳","relative":{"0":"בדקה זו"},"relativeTime":{"future":{"one":"בעוד דקה","two":"בעוד שתי דק׳","many":"בעוד {0} דק׳","other":"בעוד {0} דק׳"},"past":{"one":"לפני דקה","two":"לפני {0} דק׳","many":"לפני {0} דק׳","other":"לפני {0} דק׳"}}},"second":{"displayName":"שנייה","relative":{"0":"עכשיו"},"relativeTime":{"future":{"one":"בעוד שנייה","two":"בעוד שתי שניות","many":"בעוד {0} שניות","other":"בעוד {0} שניות"},"past":{"one":"לפני שנייה","two":"לפני שתי שניות","many":"לפני {0} שניות","other":"לפני {0} שניות"}}},"second-short":{"displayName":"שנ׳","relative":{"0":"עכשיו"},"relativeTime":{"future":{"one":"בעוד שנ׳","two":"בעוד שתי שנ׳","many":"בעוד {0} שנ׳","other":"בעוד {0} שנ׳"},"past":{"one":"לפני שנ׳","two":"לפני שתי שנ׳","many":"לפני {0} שנ׳","other":"לפני {0} שנ׳"}}}}},
    {"locale":"hi","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return (n == 1) ? 'one'
          : ((n == 2
              || n == 3)) ? 'two'
          : (n == 4) ? 'few'
          : (n == 6) ? 'many'
          : 'other';
      return (n >= 0 && n <= 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"वर्ष","relative":{"0":"इस वर्ष","1":"अगला वर्ष","-1":"पिछला वर्ष"},"relativeTime":{"future":{"one":"{0} वर्ष में","other":"{0} वर्ष में"},"past":{"one":"{0} वर्ष पहले","other":"{0} वर्ष पहले"}}},"year-short":{"displayName":"वर्ष","relative":{"0":"इस वर्ष","1":"अगला वर्ष","-1":"पिछला वर्ष"},"relativeTime":{"future":{"one":"{0} वर्ष में","other":"{0} वर्ष में"},"past":{"one":"{0} वर्ष पहले","other":"{0} वर्ष पहले"}}},"month":{"displayName":"माह","relative":{"0":"इस माह","1":"अगला माह","-1":"पिछला माह"},"relativeTime":{"future":{"one":"{0} माह में","other":"{0} माह में"},"past":{"one":"{0} माह पहले","other":"{0} माह पहले"}}},"month-short":{"displayName":"माह","relative":{"0":"इस माह","1":"अगला माह","-1":"पिछला माह"},"relativeTime":{"future":{"one":"{0} माह में","other":"{0} माह में"},"past":{"one":"{0} माह पहले","other":"{0} माह पहले"}}},"week":{"displayName":"सप्ताह","relativePeriod":"{0} के सप्ताह","relative":{"0":"इस सप्ताह","1":"अगला सप्ताह","-1":"पिछला सप्ताह"},"relativeTime":{"future":{"one":"{0} सप्ताह में","other":"{0} सप्ताह में"},"past":{"one":"{0} सप्ताह पहले","other":"{0} सप्ताह पहले"}}},"week-short":{"displayName":"सप्ताह","relativePeriod":"{0} के सप्ताह","relative":{"0":"इस सप्ताह","1":"अगला सप्ताह","-1":"पिछला सप्ताह"},"relativeTime":{"future":{"one":"{0} सप्ताह में","other":"{0} सप्ताह में"},"past":{"one":"{0} सप्ताह पहले","other":"{0} सप्ताह पहले"}}},"day":{"displayName":"दिन","relative":{"0":"आज","1":"कल","2":"परसों","-2":"परसों","-1":"कल"},"relativeTime":{"future":{"one":"{0} दिन में","other":"{0} दिन में"},"past":{"one":"{0} दिन पहले","other":"{0} दिन पहले"}}},"day-short":{"displayName":"दिन","relative":{"0":"आज","1":"कल","2":"परसों","-2":"परसों","-1":"कल"},"relativeTime":{"future":{"one":"{0} दिन में","other":"{0} दिन में"},"past":{"one":"{0} दिन पहले","other":"{0} दिन पहले"}}},"hour":{"displayName":"घंटा","relative":{"0":"यह घंटा"},"relativeTime":{"future":{"one":"{0} घंटे में","other":"{0} घंटे में"},"past":{"one":"{0} घंटे पहले","other":"{0} घंटे पहले"}}},"hour-short":{"displayName":"घं॰","relative":{"0":"यह घंटा"},"relativeTime":{"future":{"one":"{0} घं॰ में","other":"{0} घं॰ में"},"past":{"one":"{0} घं॰ पहले","other":"{0} घं॰ पहले"}}},"minute":{"displayName":"मिनट","relative":{"0":"यह मिनट"},"relativeTime":{"future":{"one":"{0} मिनट में","other":"{0} मिनट में"},"past":{"one":"{0} मिनट पहले","other":"{0} मिनट पहले"}}},"minute-short":{"displayName":"मि॰","relative":{"0":"यह मिनट"},"relativeTime":{"future":{"one":"{0} मि॰ में","other":"{0} मि॰ में"},"past":{"one":"{0} मि॰ पहले","other":"{0} मि॰ पहले"}}},"second":{"displayName":"सेकंड","relative":{"0":"अब"},"relativeTime":{"future":{"one":"{0} सेकंड में","other":"{0} सेकंड में"},"past":{"one":"{0} सेकंड पहले","other":"{0} सेकंड पहले"}}},"second-short":{"displayName":"से॰","relative":{"0":"अब"},"relativeTime":{"future":{"one":"{0} से॰ में","other":"{0} से॰ में"},"past":{"one":"{0} से॰ पहले","other":"{0} से॰ पहले"}}}}},
    {"locale":"hr","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], f = s[1] || '', v0 = !s[1],
          i10 = i.slice(-1), i100 = i.slice(-2), f10 = f.slice(-1), f100 = f.slice(-2);
      if (ord) return 'other';
      return (v0 && i10 == 1 && i100 != 11
              || f10 == 1 && f100 != 11) ? 'one'
          : (v0 && (i10 >= 2 && i10 <= 4) && (i100 < 12 || i100 > 14)
              || (f10 >= 2 && f10 <= 4) && (f100 < 12
              || f100 > 14)) ? 'few'
          : 'other';
    },"fields":{"year":{"displayName":"godina","relative":{"0":"ove godine","1":"sljedeće godine","-1":"prošle godine"},"relativeTime":{"future":{"one":"za {0} godinu","few":"za {0} godine","other":"za {0} godina"},"past":{"one":"prije {0} godinu","few":"prije {0} godine","other":"prije {0} godina"}}},"year-short":{"displayName":"g.","relative":{"0":"ove god.","1":"sljedeće god.","-1":"prošle god."},"relativeTime":{"future":{"one":"za {0} g.","few":"za {0} g.","other":"za {0} g."},"past":{"one":"prije {0} g.","few":"prije {0} g.","other":"prije {0} g."}}},"month":{"displayName":"mjesec","relative":{"0":"ovaj mjesec","1":"sljedeći mjesec","-1":"prošli mjesec"},"relativeTime":{"future":{"one":"za {0} mjesec","few":"za {0} mjeseca","other":"za {0} mjeseci"},"past":{"one":"prije {0} mjesec","few":"prije {0} mjeseca","other":"prije {0} mjeseci"}}},"month-short":{"displayName":"mj.","relative":{"0":"ovaj mj.","1":"sljedeći mj.","-1":"prošli mj."},"relativeTime":{"future":{"one":"za {0} mj.","few":"za {0} mj.","other":"za {0} mj."},"past":{"one":"prije {0} mj.","few":"prije {0} mj.","other":"prije {0} mj."}}},"week":{"displayName":"tjedan","relativePeriod":"tjedan od {0}","relative":{"0":"ovaj tjedan","1":"sljedeći tjedan","-1":"prošli tjedan"},"relativeTime":{"future":{"one":"za {0} tjedan","few":"za {0} tjedna","other":"za {0} tjedana"},"past":{"one":"prije {0} tjedan","few":"prije {0} tjedna","other":"prije {0} tjedana"}}},"week-short":{"displayName":"tj.","relativePeriod":"tjedan od {0}","relative":{"0":"ovaj tj.","1":"sljedeći tj.","-1":"prošli tj."},"relativeTime":{"future":{"one":"za {0} tj.","few":"za {0} tj.","other":"za {0} tj."},"past":{"one":"prije {0} tj.","few":"prije {0} tj.","other":"prije {0} tj."}}},"day":{"displayName":"dan","relative":{"0":"danas","1":"sutra","2":"prekosutra","-2":"prekjučer","-1":"jučer"},"relativeTime":{"future":{"one":"za {0} dan","few":"za {0} dana","other":"za {0} dana"},"past":{"one":"prije {0} dan","few":"prije {0} dana","other":"prije {0} dana"}}},"day-short":{"displayName":"d.","relative":{"0":"danas","1":"sutra","2":"prekosutra","-2":"prekjučer","-1":"jučer"},"relativeTime":{"future":{"one":"za {0} dan","few":"za {0} dana","other":"za {0} dana"},"past":{"one":"prije {0} dan","few":"prije {0} dana","other":"prije {0} dana"}}},"hour":{"displayName":"sat","relative":{"0":"ovaj sat"},"relativeTime":{"future":{"one":"za {0} sat","few":"za {0} sata","other":"za {0} sati"},"past":{"one":"prije {0} sat","few":"prije {0} sata","other":"prije {0} sati"}}},"hour-short":{"displayName":"h","relative":{"0":"ovaj sat"},"relativeTime":{"future":{"one":"za {0} h","few":"za {0} h","other":"za {0} h"},"past":{"one":"prije {0} h","few":"prije {0} h","other":"prije {0} h"}}},"minute":{"displayName":"minuta","relative":{"0":"ova minuta"},"relativeTime":{"future":{"one":"za {0} minutu","few":"za {0} minute","other":"za {0} minuta"},"past":{"one":"prije {0} minutu","few":"prije {0} minute","other":"prije {0} minuta"}}},"minute-short":{"displayName":"min","relative":{"0":"ova minuta"},"relativeTime":{"future":{"one":"za {0} min","few":"za {0} min","other":"za {0} min"},"past":{"one":"prije {0} min","few":"prije {0} min","other":"prije {0} min"}}},"second":{"displayName":"sekunda","relative":{"0":"sad"},"relativeTime":{"future":{"one":"za {0} sekundu","few":"za {0} sekunde","other":"za {0} sekundi"},"past":{"one":"prije {0} sekundu","few":"prije {0} sekunde","other":"prije {0} sekundi"}}},"second-short":{"displayName":"s","relative":{"0":"sad"},"relativeTime":{"future":{"one":"za {0} s","few":"za {0} s","other":"za {0} s"},"past":{"one":"prije {0} s","few":"prije {0} s","other":"prije {0} s"}}}}},{"locale":"hr-BA","parentLocale":"hr"},
    {"locale":"hsb","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], f = s[1] || '', v0 = !s[1],
          i100 = i.slice(-2), f100 = f.slice(-2);
      if (ord) return 'other';
      return (v0 && i100 == 1
              || f100 == 1) ? 'one'
          : (v0 && i100 == 2
              || f100 == 2) ? 'two'
          : (v0 && (i100 == 3 || i100 == 4) || (f100 == 3
              || f100 == 4)) ? 'few'
          : 'other';
    },"fields":{"year":{"displayName":"lěto","relative":{"0":"lětsa","1":"klětu","-1":"loni"},"relativeTime":{"future":{"one":"za {0} lěto","two":"za {0} lěće","few":"za {0} lěta","other":"za {0} lět"},"past":{"one":"před {0} lětom","two":"před {0} lětomaj","few":"před {0} lětami","other":"před {0} lětami"}}},"year-short":{"displayName":"l.","relative":{"0":"lětsa","1":"klětu","-1":"loni"},"relativeTime":{"future":{"one":"za {0} l.","two":"za {0} l.","few":"za {0} l.","other":"za {0} l."},"past":{"one":"před {0} l.","two":"před {0} l.","few":"před {0} l.","other":"před {0} l."}}},"month":{"displayName":"měsac","relative":{"0":"tutón měsac","1":"přichodny měsac","-1":"zašły měsac"},"relativeTime":{"future":{"one":"za {0} měsac","two":"za {0} měsacaj","few":"za {0} měsacy","other":"za {0} měsacow"},"past":{"one":"před {0} měsacom","two":"před {0} měsacomaj","few":"před {0} měsacami","other":"před {0} měsacami"}}},"month-short":{"displayName":"měs.","relative":{"0":"tutón měsac","1":"přichodny měsac","-1":"zašły měsac"},"relativeTime":{"future":{"one":"za {0} měs.","two":"za {0} měs.","few":"za {0} měs.","other":"za {0} měs."},"past":{"one":"před {0} měs.","two":"před {0} měs.","few":"před {0} měs.","other":"před {0} měs."}}},"week":{"displayName":"tydźeń","relativePeriod":"the week of {0}","relative":{"0":"tutón tydźeń","1":"přichodny tydźeń","-1":"zašły tydźeń"},"relativeTime":{"future":{"one":"za {0} tydźeń","two":"za {0} tydźenjej","few":"za {0} tydźenje","other":"za {0} tydźenjow"},"past":{"one":"před {0} tydźenjom","two":"před {0} tydźenjomaj","few":"před {0} tydźenjemi","other":"před {0} tydźenjemi"}}},"week-short":{"displayName":"tydź.","relativePeriod":"the week of {0}","relative":{"0":"tutón tydźeń","1":"přichodny tydźeń","-1":"zašły tydźeń"},"relativeTime":{"future":{"one":"za {0} tydź.","two":"za {0} tydź.","few":"za {0} tydź.","other":"za {0} tydź."},"past":{"one":"před {0} tydź.","two":"před {0} tydź.","few":"před {0} tydź.","other":"před {0} tydź."}}},"day":{"displayName":"dźeń","relative":{"0":"dźensa","1":"jutře","-1":"wčera"},"relativeTime":{"future":{"one":"za {0} dźeń","two":"za {0} dnjej","few":"za {0} dny","other":"za {0} dnjow"},"past":{"one":"před {0} dnjom","two":"před {0} dnjomaj","few":"před {0} dnjemi","other":"před {0} dnjemi"}}},"day-short":{"displayName":"dźeń","relative":{"0":"dźensa","1":"jutře","-1":"wčera"},"relativeTime":{"future":{"one":"za {0} dźeń","two":"za {0} dnj.","few":"za {0} dny","other":"za {0} dnj."},"past":{"one":"před {0} dnj.","two":"před {0} dnj.","few":"před {0} dnj.","other":"před {0} dnj."}}},"hour":{"displayName":"hodźina","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"za {0} hodźinu","two":"za {0} hodźinje","few":"za {0} hodźiny","other":"za {0} hodźin"},"past":{"one":"před {0} hodźinu","two":"před {0} hodźinomaj","few":"před {0} hodźinami","other":"před {0} hodźinami"}}},"hour-short":{"displayName":"hodź.","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"za {0} hodź.","two":"za {0} hodź.","few":"za {0} hodź.","other":"za {0} hodź."},"past":{"one":"před {0} hodź.","two":"před {0} hodź.","few":"před {0} hodź.","other":"před {0} hodź."}}},"minute":{"displayName":"minuta","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"za {0} minutu","two":"za {0} minuće","few":"za {0} minuty","other":"za {0} minutow"},"past":{"one":"před {0} minutu","two":"před {0} minutomaj","few":"před {0} minutami","other":"před {0} minutami"}}},"minute-short":{"displayName":"min.","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"za {0} min.","two":"za {0} min.","few":"za {0} min.","other":"za {0} min."},"past":{"one":"před {0} min.","two":"před {0} min.","few":"před {0} min.","other":"před {0} min."}}},"second":{"displayName":"sekunda","relative":{"0":"now"},"relativeTime":{"future":{"one":"za {0} sekundu","two":"za {0} sekundźe","few":"za {0} sekundy","other":"za {0} sekundow"},"past":{"one":"před {0} sekundu","two":"před {0} sekundomaj","few":"před {0} sekundami","other":"před {0} sekundami"}}},"second-short":{"displayName":"sek.","relative":{"0":"now"},"relativeTime":{"future":{"one":"za {0} sek.","two":"za {0} sek.","few":"za {0} sek.","other":"za {0} sek."},"past":{"one":"před {0} sek.","two":"před {0} sek.","few":"před {0} sek.","other":"před {0} sek."}}}}},
    {"locale":"hu","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return ((n == 1
              || n == 5)) ? 'one' : 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"év","relative":{"0":"ez az év","1":"következő év","-1":"előző év"},"relativeTime":{"future":{"one":"{0} év múlva","other":"{0} év múlva"},"past":{"one":"{0} évvel ezelőtt","other":"{0} évvel ezelőtt"}}},"year-short":{"displayName":"év","relative":{"0":"ez az év","1":"következő év","-1":"előző év"},"relativeTime":{"future":{"one":"{0} év múlva","other":"{0} év múlva"},"past":{"one":"{0} évvel ezelőtt","other":"{0} évvel ezelőtt"}}},"month":{"displayName":"hónap","relative":{"0":"ez a hónap","1":"következő hónap","-1":"előző hónap"},"relativeTime":{"future":{"one":"{0} hónap múlva","other":"{0} hónap múlva"},"past":{"one":"{0} hónappal ezelőtt","other":"{0} hónappal ezelőtt"}}},"month-short":{"displayName":"hónap","relative":{"0":"ez a hónap","1":"következő hónap","-1":"előző hónap"},"relativeTime":{"future":{"one":"{0} hónap múlva","other":"{0} hónap múlva"},"past":{"one":"{0} hónappal ezelőtt","other":"{0} hónappal ezelőtt"}}},"week":{"displayName":"hét","relativePeriod":"{0} hete","relative":{"0":"ez a hét","1":"következő hét","-1":"előző hét"},"relativeTime":{"future":{"one":"{0} hét múlva","other":"{0} hét múlva"},"past":{"one":"{0} héttel ezelőtt","other":"{0} héttel ezelőtt"}}},"week-short":{"displayName":"hét","relativePeriod":"{0} hete","relative":{"0":"ez a hét","1":"következő hét","-1":"előző hét"},"relativeTime":{"future":{"one":"{0} hét múlva","other":"{0} hét múlva"},"past":{"one":"{0} héttel ezelőtt","other":"{0} héttel ezelőtt"}}},"day":{"displayName":"nap","relative":{"0":"ma","1":"holnap","2":"holnapután","-2":"tegnapelőtt","-1":"tegnap"},"relativeTime":{"future":{"one":"{0} nap múlva","other":"{0} nap múlva"},"past":{"one":"{0} nappal ezelőtt","other":"{0} nappal ezelőtt"}}},"day-short":{"displayName":"nap","relative":{"0":"ma","1":"holnap","2":"holnapután","-2":"tegnapelőtt","-1":"tegnap"},"relativeTime":{"future":{"one":"{0} nap múlva","other":"{0} nap múlva"},"past":{"one":"{0} napja","other":"{0} napja"}}},"hour":{"displayName":"óra","relative":{"0":"ebben az órában"},"relativeTime":{"future":{"one":"{0} óra múlva","other":"{0} óra múlva"},"past":{"one":"{0} órával ezelőtt","other":"{0} órával ezelőtt"}}},"hour-short":{"displayName":"óra","relative":{"0":"ebben az órában"},"relativeTime":{"future":{"one":"{0} óra múlva","other":"{0} óra múlva"},"past":{"one":"{0} órával ezelőtt","other":"{0} órával ezelőtt"}}},"minute":{"displayName":"perc","relative":{"0":"ebben a percben"},"relativeTime":{"future":{"one":"{0} perc múlva","other":"{0} perc múlva"},"past":{"one":"{0} perccel ezelőtt","other":"{0} perccel ezelőtt"}}},"minute-short":{"displayName":"perc","relative":{"0":"ebben a percben"},"relativeTime":{"future":{"one":"{0} perc múlva","other":"{0} perc múlva"},"past":{"one":"{0} perccel ezelőtt","other":"{0} perccel ezelőtt"}}},"second":{"displayName":"másodperc","relative":{"0":"most"},"relativeTime":{"future":{"one":"{0} másodperc múlva","other":"{0} másodperc múlva"},"past":{"one":"{0} másodperccel ezelőtt","other":"{0} másodperccel ezelőtt"}}},"second-short":{"displayName":"másodperc","relative":{"0":"most"},"relativeTime":{"future":{"one":"{0} másodperc múlva","other":"{0} másodperc múlva"},"past":{"one":"{0} másodperccel ezelőtt","other":"{0} másodperccel ezelőtt"}}}}},
    {"locale":"hy","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return (n == 1) ? 'one' : 'other';
      return (n >= 0 && n < 2) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"տարի","relative":{"0":"այս տարի","1":"հաջորդ տարի","-1":"նախորդ տարի"},"relativeTime":{"future":{"one":"{0} տարուց","other":"{0} տարուց"},"past":{"one":"{0} տարի առաջ","other":"{0} տարի առաջ"}}},"year-short":{"displayName":"տ","relative":{"0":"այս տարի","1":"հաջորդ տարի","-1":"նախորդ տարի"},"relativeTime":{"future":{"one":"{0} տարուց","other":"{0} տարուց"},"past":{"one":"{0} տ առաջ","other":"{0} տ առաջ"}}},"month":{"displayName":"ամիս","relative":{"0":"այս ամիս","1":"հաջորդ ամիս","-1":"նախորդ ամիս"},"relativeTime":{"future":{"one":"{0} ամսից","other":"{0} ամսից"},"past":{"one":"{0} ամիս առաջ","other":"{0} ամիս առաջ"}}},"month-short":{"displayName":"ամս","relative":{"0":"այս ամիս","1":"հաջորդ ամիս","-1":"անցյալ ամիս"},"relativeTime":{"future":{"one":"{0} ամսից","other":"{0} ամսից"},"past":{"one":"{0} ամիս առաջ","other":"{0} ամիս առաջ"}}},"week":{"displayName":"շաբաթ","relativePeriod":"{0} շաբաթում","relative":{"0":"այս շաբաթ","1":"հաջորդ շաբաթ","-1":"նախորդ շաբաթ"},"relativeTime":{"future":{"one":"{0} շաբաթից","other":"{0} շաբաթից"},"past":{"one":"{0} շաբաթ առաջ","other":"{0} շաբաթ առաջ"}}},"week-short":{"displayName":"շաբ","relativePeriod":"{0} շաբ-ում","relative":{"0":"այս շաբաթ","1":"հաջորդ շաբաթ","-1":"նախորդ շաբաթ"},"relativeTime":{"future":{"one":"{0} շաբ-ից","other":"{0} շաբ-ից"},"past":{"one":"{0} շաբ առաջ","other":"{0} շաբ առաջ"}}},"day":{"displayName":"օր","relative":{"0":"այսօր","1":"վաղը","2":"վաղը չէ մյուս օրը","-2":"երեկ չէ առաջի օրը","-1":"երեկ"},"relativeTime":{"future":{"one":"{0} օրից","other":"{0} օրից"},"past":{"one":"{0} օր առաջ","other":"{0} օր առաջ"}}},"day-short":{"displayName":"օր","relative":{"0":"այսօր","1":"վաղը","2":"վաղը չէ մյուս օրը","-2":"երեկ չէ առաջի օրը","-1":"երեկ"},"relativeTime":{"future":{"one":"{0} օրից","other":"{0} օրից"},"past":{"one":"{0} օր առաջ","other":"{0} օր առաջ"}}},"hour":{"displayName":"ժամ","relative":{"0":"այս ժամին"},"relativeTime":{"future":{"one":"{0} ժամից","other":"{0} ժամից"},"past":{"one":"{0} ժամ առաջ","other":"{0} ժամ առաջ"}}},"hour-short":{"displayName":"ժ","relative":{"0":"այս ժամին"},"relativeTime":{"future":{"one":"{0} ժ-ից","other":"{0} ժ-ից"},"past":{"one":"{0} ժ առաջ","other":"{0} ժ առաջ"}}},"minute":{"displayName":"րոպե","relative":{"0":"այս րոպեին"},"relativeTime":{"future":{"one":"{0} րոպեից","other":"{0} րոպեից"},"past":{"one":"{0} րոպե առաջ","other":"{0} րոպե առաջ"}}},"minute-short":{"displayName":"ր","relative":{"0":"այս րոպեին"},"relativeTime":{"future":{"one":"{0} ր-ից","other":"{0} ր-ից"},"past":{"one":"{0} ր առաջ","other":"{0} ր առաջ"}}},"second":{"displayName":"վայրկյան","relative":{"0":"հիմա"},"relativeTime":{"future":{"one":"{0} վայրկյանից","other":"{0} վայրկյանից"},"past":{"one":"{0} վայրկյան առաջ","other":"{0} վայրկյան առաջ"}}},"second-short":{"displayName":"վ","relative":{"0":"հիմա"},"relativeTime":{"future":{"one":"{0} վրկ-ից","other":"{0} վրկ-ից"},"past":{"one":"{0} վրկ առաջ","other":"{0} վրկ առաջ"}}}}},
    {"locale":"ia","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      if (ord) return 'other';
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"anno","relative":{"0":"iste anno","1":"le anno proxime","-1":"le anno passate"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"an.","relative":{"0":"iste anno","1":"le anno proxime","-1":"le anno passate"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"mense","relative":{"0":"iste mense","1":"le mense proxime","-1":"le mense passate"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"mns.","relative":{"0":"iste mense","1":"le mense proxime","-1":"le mense passate"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"septimana","relativePeriod":"le septimana de {0}","relative":{"0":"iste septimana","1":"le septimana proxime","-1":"le septimana passate"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"sept.","relativePeriod":"le sept. de {0}","relative":{"0":"iste septimana","1":"le septimana proxime","-1":"le septimana passate"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"die","relative":{"0":"hodie","1":"deman","-1":"heri"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"die","relative":{"0":"hodie","1":"deman","-1":"heri"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"hora","relative":{"0":"iste hora"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"hr.","relative":{"0":"iste hora"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"minuta","relative":{"0":"iste minuta"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"min.","relative":{"0":"iste minuta"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"secunda","relative":{"0":"ora"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"sec.","relative":{"0":"ora"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"id","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return 'other';
    },"fields":{"year":{"displayName":"tahun","relative":{"0":"tahun ini","1":"tahun depan","-1":"tahun lalu"},"relativeTime":{"future":{"other":"dalam {0} tahun"},"past":{"other":"{0} tahun yang lalu"}}},"year-short":{"displayName":"thn.","relative":{"0":"tahun ini","1":"tahun depan","-1":"tahun lalu"},"relativeTime":{"future":{"other":"dlm {0} thn"},"past":{"other":"{0} thn lalu"}}},"month":{"displayName":"bulan","relative":{"0":"bulan ini","1":"bulan berikutnya","-1":"bulan lalu"},"relativeTime":{"future":{"other":"dalam {0} bulan"},"past":{"other":"{0} bulan yang lalu"}}},"month-short":{"displayName":"bln.","relative":{"0":"bulan ini","1":"bulan berikutnya","-1":"bulan lalu"},"relativeTime":{"future":{"other":"dlm {0} bln"},"past":{"other":"{0} bln lalu"}}},"week":{"displayName":"minggu","relativePeriod":"minggu ke-{0}","relative":{"0":"minggu ini","1":"minggu depan","-1":"minggu lalu"},"relativeTime":{"future":{"other":"dalam {0} minggu"},"past":{"other":"{0} minggu yang lalu"}}},"week-short":{"displayName":"mgg.","relativePeriod":"mgg ke-{0}","relative":{"0":"minggu ini","1":"minggu depan","-1":"minggu lalu"},"relativeTime":{"future":{"other":"dlm {0} mgg"},"past":{"other":"{0} mgg lalu"}}},"day":{"displayName":"hari","relative":{"0":"hari ini","1":"besok","2":"lusa","-2":"kemarin dulu","-1":"kemarin"},"relativeTime":{"future":{"other":"dalam {0} hari"},"past":{"other":"{0} hari yang lalu"}}},"day-short":{"displayName":"h","relative":{"0":"hari ini","1":"besok","2":"lusa","-2":"kemarin dulu","-1":"kemarin"},"relativeTime":{"future":{"other":"dalam {0} h"},"past":{"other":"{0} h lalu"}}},"hour":{"displayName":"Jam","relative":{"0":"jam ini"},"relativeTime":{"future":{"other":"dalam {0} jam"},"past":{"other":"{0} jam yang lalu"}}},"hour-short":{"displayName":"jam","relative":{"0":"jam ini"},"relativeTime":{"future":{"other":"dalam {0} jam"},"past":{"other":"{0} jam lalu"}}},"minute":{"displayName":"menit","relative":{"0":"menit ini"},"relativeTime":{"future":{"other":"dalam {0} menit"},"past":{"other":"{0} menit yang lalu"}}},"minute-short":{"displayName":"mnt.","relative":{"0":"menit ini"},"relativeTime":{"future":{"other":"dlm {0} mnt"},"past":{"other":"{0} mnt lalu"}}},"second":{"displayName":"detik","relative":{"0":"sekarang"},"relativeTime":{"future":{"other":"dalam {0} detik"},"past":{"other":"{0} detik yang lalu"}}},"second-short":{"displayName":"dtk.","relative":{"0":"sekarang"},"relativeTime":{"future":{"other":"dlm {0} dtk"},"past":{"other":"{0} dtk lalu"}}}}},
    {"locale":"ig","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Afọ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Afọ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Ọnwa","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Ọnwa","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Izu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Izu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Ụbọchị","relative":{"0":"Taata","1":"Echi","-1":"Nnyaafụ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Ụbọchị","relative":{"0":"Taata","1":"Echi","-1":"Nnyaafụ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Elekere","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Elekere","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Nkeji","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Nkeji","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Nkejinta","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Nkejinta","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ii","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"ꈎ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"ꈎ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"ꆪ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"ꆪ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"ꑭꆏ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"ꑭꆏ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"ꑍ","relative":{"0":"ꀃꑍ","1":"ꃆꏂꑍ","2":"ꌕꀿꑍ","-2":"ꎴꂿꋍꑍ","-1":"ꀋꅔꉈ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"ꑍ","relative":{"0":"ꀃꑍ","1":"ꃆꏂꑍ","2":"ꌕꀿꑍ","-2":"ꎴꂿꋍꑍ","-1":"ꀋꅔꉈ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"ꄮꈉ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"ꄮꈉ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"ꃏ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"ꃏ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"ꇙ","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"ꇙ","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"in","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"io","pluralRuleFunction":function(n
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"is","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], t0 = Number(s[0]) == n,
          i10 = i.slice(-1), i100 = i.slice(-2);
      if (ord) return 'other';
      return (t0 && i10 == 1 && i100 != 11
              || !t0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ár","relative":{"0":"á þessu ári","1":"á næsta ári","-1":"á síðasta ári"},"relativeTime":{"future":{"one":"eftir {0} ár","other":"eftir {0} ár"},"past":{"one":"fyrir {0} ári","other":"fyrir {0} árum"}}},"year-short":{"displayName":"ár","relative":{"0":"á þessu ári","1":"á næsta ári","-1":"á síðasta ári"},"relativeTime":{"future":{"one":"eftir {0} ár","other":"eftir {0} ár"},"past":{"one":"fyrir {0} ári","other":"fyrir {0} árum"}}},"month":{"displayName":"mánuður","relative":{"0":"í þessum mánuði","1":"í næsta mánuði","-1":"í síðasta mánuði"},"relativeTime":{"future":{"one":"eftir {0} mánuð","other":"eftir {0} mánuði"},"past":{"one":"fyrir {0} mánuði","other":"fyrir {0} mánuðum"}}},"month-short":{"displayName":"mán.","relative":{"0":"í þessum mán.","1":"í næsta mán.","-1":"í síðasta mán."},"relativeTime":{"future":{"one":"eftir {0} mán.","other":"eftir {0} mán."},"past":{"one":"fyrir {0} mán.","other":"fyrir {0} mán."}}},"week":{"displayName":"vika","relativePeriod":"vika {0}","relative":{"0":"í þessari viku","1":"í næstu viku","-1":"í síðustu viku"},"relativeTime":{"future":{"one":"eftir {0} viku","other":"eftir {0} vikur"},"past":{"one":"fyrir {0} viku","other":"fyrir {0} vikum"}}},"week-short":{"displayName":"vika","relativePeriod":"vika {0}","relative":{"0":"í þessari viku","1":"í næstu viku","-1":"í síðustu viku"},"relativeTime":{"future":{"one":"eftir {0} viku","other":"eftir {0} vikur"},"past":{"one":"fyrir {0} viku","other":"fyrir {0} vikum"}}},"day":{"displayName":"dagur","relative":{"0":"í dag","1":"á morgun","2":"eftir tvo daga","-2":"í fyrradag","-1":"í gær"},"relativeTime":{"future":{"one":"eftir {0} dag","other":"eftir {0} daga"},"past":{"one":"fyrir {0} degi","other":"fyrir {0} dögum"}}},"day-short":{"displayName":"dagur","relative":{"0":"í dag","1":"á morgun","2":"eftir tvo daga","-2":"í fyrradag","-1":"í gær"},"relativeTime":{"future":{"one":"eftir {0} dag","other":"eftir {0} daga"},"past":{"one":"fyrir {0} degi","other":"fyrir {0} dögum"}}},"hour":{"displayName":"klukkustund","relative":{"0":"þessa stundina"},"relativeTime":{"future":{"one":"eftir {0} klukkustund","other":"eftir {0} klukkustundir"},"past":{"one":"fyrir {0} klukkustund","other":"fyrir {0} klukkustundum"}}},"hour-short":{"displayName":"klst.","relative":{"0":"þessa stundina"},"relativeTime":{"future":{"one":"eftir {0} klst.","other":"eftir {0} klst."},"past":{"one":"fyrir {0} klst.","other":"fyrir {0} klst."}}},"minute":{"displayName":"mínúta","relative":{"0":"á þessari mínútu"},"relativeTime":{"future":{"one":"eftir {0} mínútu","other":"eftir {0} mínútur"},"past":{"one":"fyrir {0} mínútu","other":"fyrir {0} mínútum"}}},"minute-short":{"displayName":"mín.","relative":{"0":"á þessari mínútu"},"relativeTime":{"future":{"one":"eftir {0} mín.","other":"eftir {0} mín."},"past":{"one":"fyrir {0} mín.","other":"fyrir {0} mín."}}},"second":{"displayName":"sekúnda","relative":{"0":"núna"},"relativeTime":{"future":{"one":"eftir {0} sekúndu","other":"eftir {0} sekúndur"},"past":{"one":"fyrir {0} sekúndu","other":"fyrir {0} sekúndum"}}},"second-short":{"displayName":"sek.","relative":{"0":"núna"},"relativeTime":{"future":{"one":"eftir {0} sek.","other":"eftir {0} sek."},"past":{"one":"fyrir {0} sek.","other":"fyrir {0} sek."}}}}},
    {"locale":"it","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      if (ord) return ((n == 11 || n == 8 || n == 80
              || n == 800)) ? 'many' : 'other';
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"anno","relative":{"0":"quest’anno","1":"anno prossimo","-1":"anno scorso"},"relativeTime":{"future":{"one":"tra {0} anno","other":"tra {0} anni"},"past":{"one":"{0} anno fa","other":"{0} anni fa"}}},"year-short":{"displayName":"anno","relative":{"0":"quest’anno","1":"anno prossimo","-1":"anno scorso"},"relativeTime":{"future":{"one":"tra {0} anno","other":"tra {0} anni"},"past":{"one":"{0} anno fa","other":"{0} anni fa"}}},"month":{"displayName":"mese","relative":{"0":"questo mese","1":"mese prossimo","-1":"mese scorso"},"relativeTime":{"future":{"one":"tra {0} mese","other":"tra {0} mesi"},"past":{"one":"{0} mese fa","other":"{0} mesi fa"}}},"month-short":{"displayName":"mese","relative":{"0":"questo mese","1":"mese prossimo","-1":"mese scorso"},"relativeTime":{"future":{"one":"tra {0} mese","other":"tra {0} mesi"},"past":{"one":"{0} mese fa","other":"{0} mesi fa"}}},"week":{"displayName":"settimana","relativePeriod":"la settimana del {0}","relative":{"0":"questa settimana","1":"settimana prossima","-1":"settimana scorsa"},"relativeTime":{"future":{"one":"tra {0} settimana","other":"tra {0} settimane"},"past":{"one":"{0} settimana fa","other":"{0} settimane fa"}}},"week-short":{"displayName":"sett.","relativePeriod":"la settimana del {0}","relative":{"0":"questa settimana","1":"settimana prossima","-1":"settimana scorsa"},"relativeTime":{"future":{"one":"tra {0} sett.","other":"tra {0} sett."},"past":{"one":"{0} sett. fa","other":"{0} sett. fa"}}},"day":{"displayName":"giorno","relative":{"0":"oggi","1":"domani","2":"dopodomani","-2":"l’altro ieri","-1":"ieri"},"relativeTime":{"future":{"one":"tra {0} giorno","other":"tra {0} giorni"},"past":{"one":"{0} giorno fa","other":"{0} giorni fa"}}},"day-short":{"displayName":"g","relative":{"0":"oggi","1":"domani","2":"dopodomani","-2":"l’altro ieri","-1":"ieri"},"relativeTime":{"future":{"one":"tra {0} g","other":"tra {0} gg"},"past":{"one":"{0} g fa","other":"{0} gg fa"}}},"hour":{"displayName":"ora","relative":{"0":"quest’ora"},"relativeTime":{"future":{"one":"tra {0} ora","other":"tra {0} ore"},"past":{"one":"{0} ora fa","other":"{0} ore fa"}}},"hour-short":{"displayName":"h.","relative":{"0":"quest’ora"},"relativeTime":{"future":{"one":"tra {0} h","other":"tra {0} h"},"past":{"one":"{0} h fa","other":"{0} h fa"}}},"minute":{"displayName":"minuto","relative":{"0":"questo minuto"},"relativeTime":{"future":{"one":"tra {0} minuto","other":"tra {0} minuti"},"past":{"one":"{0} minuto fa","other":"{0} minuti fa"}}},"minute-short":{"displayName":"min","relative":{"0":"questo minuto"},"relativeTime":{"future":{"one":"tra {0} min","other":"tra {0} min"},"past":{"one":"{0} min fa","other":"{0} min fa"}}},"second":{"displayName":"secondo","relative":{"0":"ora"},"relativeTime":{"future":{"one":"tra {0} secondo","other":"tra {0} secondi"},"past":{"one":"{0} secondo fa","other":"{0} secondi fa"}}},"second-short":{"displayName":"s","relative":{"0":"ora"},"relativeTime":{"future":{"one":"tra {0} s","other":"tra {0} sec."},"past":{"one":"{0} s fa","other":"{0} sec. fa"}}}}},{"locale":"it-CH","parentLocale":"it"},{"locale":"it-SM","parentLocale":"it"},{"locale":"it-VA","parentLocale":"it"},
    {"locale":"iu","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one'
          : (n == 2) ? 'two'
          : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"iu-Latn","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"iw","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], v0 = !s[1], t0 = Number(s[0]) == n,
          n10 = t0 && s[0].slice(-1);
      if (ord) return 'other';
      return (n == 1 && v0) ? 'one'
          : (i == 2 && v0) ? 'two'
          : (v0 && (n < 0
              || n > 10) && t0 && n10 == 0) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ja","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return 'other';
    },"fields":{"year":{"displayName":"年","relative":{"0":"今年","1":"翌年","-1":"昨年"},"relativeTime":{"future":{"other":"{0} 年後"},"past":{"other":"{0} 年前"}}},"year-short":{"displayName":"年","relative":{"0":"今年","1":"翌年","-1":"昨年"},"relativeTime":{"future":{"other":"{0} 年後"},"past":{"other":"{0} 年前"}}},"month":{"displayName":"月","relative":{"0":"今月","1":"翌月","-1":"先月"},"relativeTime":{"future":{"other":"{0} か月後"},"past":{"other":"{0} か月前"}}},"month-short":{"displayName":"月","relative":{"0":"今月","1":"翌月","-1":"先月"},"relativeTime":{"future":{"other":"{0} か月後"},"past":{"other":"{0} か月前"}}},"week":{"displayName":"週","relativePeriod":"{0} 日の週","relative":{"0":"今週","1":"翌週","-1":"先週"},"relativeTime":{"future":{"other":"{0} 週間後"},"past":{"other":"{0} 週間前"}}},"week-short":{"displayName":"週","relativePeriod":"{0} 日の週","relative":{"0":"今週","1":"翌週","-1":"先週"},"relativeTime":{"future":{"other":"{0} 週間後"},"past":{"other":"{0} 週間前"}}},"day":{"displayName":"日","relative":{"0":"今日","1":"明日","2":"明後日","-2":"一昨日","-1":"昨日"},"relativeTime":{"future":{"other":"{0} 日後"},"past":{"other":"{0} 日前"}}},"day-short":{"displayName":"日","relative":{"0":"今日","1":"明日","2":"明後日","-2":"一昨日","-1":"昨日"},"relativeTime":{"future":{"other":"{0} 日後"},"past":{"other":"{0} 日前"}}},"hour":{"displayName":"時","relative":{"0":"1 時間以内"},"relativeTime":{"future":{"other":"{0} 時間後"},"past":{"other":"{0} 時間前"}}},"hour-short":{"displayName":"時","relative":{"0":"1 時間以内"},"relativeTime":{"future":{"other":"{0} 時間後"},"past":{"other":"{0} 時間前"}}},"minute":{"displayName":"分","relative":{"0":"1 分以内"},"relativeTime":{"future":{"other":"{0} 分後"},"past":{"other":"{0} 分前"}}},"minute-short":{"displayName":"分","relative":{"0":"1 分以内"},"relativeTime":{"future":{"other":"{0} 分後"},"past":{"other":"{0} 分前"}}},"second":{"displayName":"秒","relative":{"0":"今"},"relativeTime":{"future":{"other":"{0} 秒後"},"past":{"other":"{0} 秒前"}}},"second-short":{"displayName":"秒","relative":{"0":"今"},"relativeTime":{"future":{"other":"{0} 秒後"},"past":{"other":"{0} 秒前"}}}}},
    {"locale":"jbo","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"jgo","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"one":"Nǔu ŋguꞋ {0}","other":"Nǔu ŋguꞋ {0}"},"past":{"one":"Ɛ́gɛ́ mɔ́ ŋguꞋ {0}","other":"Ɛ́gɛ́ mɔ́ ŋguꞋ {0}"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"one":"Nǔu ŋguꞋ {0}","other":"Nǔu ŋguꞋ {0}"},"past":{"one":"Ɛ́gɛ́ mɔ́ ŋguꞋ {0}","other":"Ɛ́gɛ́ mɔ́ ŋguꞋ {0}"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"Nǔu {0} saŋ","other":"Nǔu {0} saŋ"},"past":{"one":"ɛ́ gɛ́ mɔ́ pɛsaŋ {0}","other":"ɛ́ gɛ́ mɔ́ pɛsaŋ {0}"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"Nǔu {0} saŋ","other":"Nǔu {0} saŋ"},"past":{"one":"ɛ́ gɛ́ mɔ́ pɛsaŋ {0}","other":"ɛ́ gɛ́ mɔ́ pɛsaŋ {0}"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"Nǔu ŋgap-mbi {0}","other":"Nǔu ŋgap-mbi {0}"},"past":{"one":"Ɛ́ gɛ́ mɔ {0} ŋgap-mbi","other":"Ɛ́ gɛ́ mɔ {0} ŋgap-mbi"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"Nǔu ŋgap-mbi {0}","other":"Nǔu ŋgap-mbi {0}"},"past":{"one":"Ɛ́ gɛ́ mɔ {0} ŋgap-mbi","other":"Ɛ́ gɛ́ mɔ {0} ŋgap-mbi"}}},"day":{"displayName":"Day","relative":{"0":"lɔꞋɔ","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"Nǔu lɛ́Ꞌ {0}","other":"Nǔu lɛ́Ꞌ {0}"},"past":{"one":"Ɛ́ gɛ́ mɔ́ lɛ́Ꞌ {0}","other":"Ɛ́ gɛ́ mɔ́ lɛ́Ꞌ {0}"}}},"day-short":{"displayName":"Day","relative":{"0":"lɔꞋɔ","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"Nǔu lɛ́Ꞌ {0}","other":"Nǔu lɛ́Ꞌ {0}"},"past":{"one":"Ɛ́ gɛ́ mɔ́ lɛ́Ꞌ {0}","other":"Ɛ́ gɛ́ mɔ́ lɛ́Ꞌ {0}"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"nǔu háwa {0}","other":"nǔu háwa {0}"},"past":{"one":"ɛ́ gɛ mɔ́ {0} háwa","other":"ɛ́ gɛ mɔ́ {0} háwa"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"nǔu háwa {0}","other":"nǔu háwa {0}"},"past":{"one":"ɛ́ gɛ mɔ́ {0} háwa","other":"ɛ́ gɛ mɔ́ {0} háwa"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"nǔu {0} minút","other":"nǔu {0} minút"},"past":{"one":"ɛ́ gɛ́ mɔ́ minút {0}","other":"ɛ́ gɛ́ mɔ́ minút {0}"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"nǔu {0} minút","other":"nǔu {0} minút"},"past":{"one":"ɛ́ gɛ́ mɔ́ minút {0}","other":"ɛ́ gɛ́ mɔ́ minút {0}"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ji","pluralRuleFunction":function(n
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"jmc","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Maka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Maka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mori","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mori","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Wiikyi","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Wiikyi","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Mfiri","relative":{"0":"Inu","1":"Ngama","-1":"Ukou"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Mfiri","relative":{"0":"Inu","1":"Ngama","-1":"Ukou"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Dakyika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Dakyika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"jv","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"taun","relative":{"0":"taun iki","1":"taun ngarep","-1":"taun wingi"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"taun","relative":{"0":"taun iki","1":"taun ngarep","-1":"taun wingi"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"sasi","relative":{"0":"sasi iki","1":"sasi ngarep","-1":"sasi wingi"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"sasi","relative":{"0":"sasi iki","1":"sasi ngarep","-1":"sasi wingi"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"pekan","relativePeriod":"pekan kaping {0}","relative":{"0":"pekan iki","1":"pekan ngarep","-1":"pekan wingi"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"pekan","relativePeriod":"pekan kaping {0}","relative":{"0":"pekan iki","1":"pekan ngarep","-1":"pekan wingi"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"dino","relative":{"0":"saiki","1":"sesuk","-1":"wingi"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"dino","relative":{"0":"saiki","1":"sesuk","-1":"wingi"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"jam","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"jam","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"menit","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"menit","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"detik","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"detik","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"jw","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ka","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], i100 = i.slice(-2);
      if (ord) return (i == 1) ? 'one'
          : (i == 0 || ((i100 >= 2 && i100 <= 20) || i100 == 40 || i100 == 60
              || i100 == 80)) ? 'many'
          : 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"წელი","relative":{"0":"ამ წელს","1":"მომავალ წელს","-1":"გასულ წელს"},"relativeTime":{"future":{"one":"{0} წელიწადში","other":"{0} წელიწადში"},"past":{"one":"{0} წლის წინ","other":"{0} წლის წინ"}}},"year-short":{"displayName":"წ.","relative":{"0":"ამ წელს","1":"მომავალ წელს","-1":"გასულ წელს"},"relativeTime":{"future":{"one":"{0} წელში","other":"{0} წელში"},"past":{"one":"{0} წლის წინ","other":"{0} წლის წინ"}}},"month":{"displayName":"თვე","relative":{"0":"ამ თვეში","1":"მომავალ თვეს","-1":"გასულ თვეს"},"relativeTime":{"future":{"one":"{0} თვეში","other":"{0} თვეში"},"past":{"one":"{0} თვის წინ","other":"{0} თვის წინ"}}},"month-short":{"displayName":"თვე","relative":{"0":"ამ თვეში","1":"მომავალ თვეს","-1":"გასულ თვეს"},"relativeTime":{"future":{"one":"{0} თვეში","other":"{0} თვეში"},"past":{"one":"{0} თვის წინ","other":"{0} თვის წინ"}}},"week":{"displayName":"კვირა","relativePeriod":"{0}-ის კვირაში","relative":{"0":"ამ კვირაში","1":"მომავალ კვირაში","-1":"გასულ კვირაში"},"relativeTime":{"future":{"one":"{0} კვირაში","other":"{0} კვირაში"},"past":{"one":"{0} კვირის წინ","other":"{0} კვირის წინ"}}},"week-short":{"displayName":"კვ.","relativePeriod":"{0}-ის კვირაში","relative":{"0":"ამ კვირაში","1":"მომავალ კვირაში","-1":"გასულ კვირაში"},"relativeTime":{"future":{"one":"{0} კვირაში","other":"{0} კვირაში"},"past":{"one":"{0} კვ. წინ","other":"{0} კვ. წინ"}}},"day":{"displayName":"დღე","relative":{"0":"დღეს","1":"ხვალ","2":"ზეგ","-2":"გუშინწინ","-1":"გუშინ"},"relativeTime":{"future":{"one":"{0} დღეში","other":"{0} დღეში"},"past":{"one":"{0} დღის წინ","other":"{0} დღის წინ"}}},"day-short":{"displayName":"დღე","relative":{"0":"დღეს","1":"ხვალ","2":"ზეგ","-2":"გუშინწინ","-1":"გუშინ"},"relativeTime":{"future":{"one":"{0} დღეში","other":"{0} დღეში"},"past":{"one":"{0} დღის წინ","other":"{0} დღის წინ"}}},"hour":{"displayName":"საათი","relative":{"0":"ამ საათში"},"relativeTime":{"future":{"one":"{0} საათში","other":"{0} საათში"},"past":{"one":"{0} საათის წინ","other":"{0} საათის წინ"}}},"hour-short":{"displayName":"სთ.","relative":{"0":"ამ საათში"},"relativeTime":{"future":{"one":"{0} საათში","other":"{0} საათში"},"past":{"one":"{0} სთ წინ","other":"{0} სთ წინ"}}},"minute":{"displayName":"წუთი","relative":{"0":"ამ წუთში"},"relativeTime":{"future":{"one":"{0} წუთში","other":"{0} წუთში"},"past":{"one":"{0} წუთის წინ","other":"{0} წუთის წინ"}}},"minute-short":{"displayName":"წთ.","relative":{"0":"ამ წუთში"},"relativeTime":{"future":{"one":"{0} წუთში","other":"{0} წუთში"},"past":{"one":"{0} წთ წინ","other":"{0} წთ წინ"}}},"second":{"displayName":"წამი","relative":{"0":"ახლა"},"relativeTime":{"future":{"one":"{0} წამში","other":"{0} წამში"},"past":{"one":"{0} წამის წინ","other":"{0} წამის წინ"}}},"second-short":{"displayName":"წმ.","relative":{"0":"ახლა"},"relativeTime":{"future":{"one":"{0} წამში","other":"{0} წამში"},"past":{"one":"{0} წმ წინ","other":"{0} წმ წინ"}}}}},
    {"locale":"kab","pluralRuleFunction":function(n
    ) {
      return (n >= 0 && n < 2) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Aseggas","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Aseggas","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Aggur","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Aggur","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Ddurt","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Ddurt","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Ass","relative":{"0":"Ass-a","1":"Azekka","-1":"Iḍelli"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Ass","relative":{"0":"Ass-a","1":"Azekka","-1":"Iḍelli"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Tamert","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Tamert","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Tamrect","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Tamrect","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Tasint","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Tasint","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"kaj","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"kam","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mwai","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mwai","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Kyumwa","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Kyumwa","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Mũthenya","relative":{"0":"Ũmũnthĩ","1":"Ũnĩ","-1":"Ĩyoo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Mũthenya","relative":{"0":"Ũmũnthĩ","1":"Ũnĩ","-1":"Ĩyoo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Ndatĩka","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Ndatĩka","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"sekondi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"sekondi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"kcg","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"kde","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mwedi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mwedi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Lijuma","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Lijuma","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Lihiku","relative":{"0":"Nelo","1":"Nundu","-1":"Lido"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Lihiku","relative":{"0":"Nelo","1":"Nundu","-1":"Lido"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Dakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Dakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"kea","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Anu","relative":{"0":"es anu li","1":"prósimu anu","-1":"anu pasadu"},"relativeTime":{"future":{"other":"di li {0} anu"},"past":{"other":"a ten {0} anu"}}},"year-short":{"displayName":"anu","relative":{"0":"es anu li","1":"prósimu anu","-1":"anu pasadu"},"relativeTime":{"future":{"other":"di li {0} anu"},"past":{"other":"a ten {0} anu"}}},"month":{"displayName":"Mes","relative":{"0":"es mes li","1":"prósimu mes","-1":"mes pasadu"},"relativeTime":{"future":{"other":"di li {0} mes"},"past":{"other":"a ten {0} mes"}}},"month-short":{"displayName":"mes","relative":{"0":"es mes li","1":"prósimu mes","-1":"mes pasadu"},"relativeTime":{"future":{"other":"di li {0} mes"},"past":{"other":"a ten {0} mes"}}},"week":{"displayName":"Simana","relativePeriod":"the week of {0}","relative":{"0":"es simana li","1":"prósimu simana","-1":"simana pasadu"},"relativeTime":{"future":{"other":"di li {0} simana"},"past":{"other":"a ten {0} simana"}}},"week-short":{"displayName":"sim.","relativePeriod":"the week of {0}","relative":{"0":"es simana li","1":"prósimu simana","-1":"simana pasadu"},"relativeTime":{"future":{"other":"di li {0} sim."},"past":{"other":"a ten {0} sim."}}},"day":{"displayName":"Dia","relative":{"0":"oji","1":"manha","-1":"onti"},"relativeTime":{"future":{"other":"di li {0} dia"},"past":{"other":"a ten {0} dia"}}},"day-short":{"displayName":"dia","relative":{"0":"oji","1":"manha","-1":"onti"},"relativeTime":{"future":{"other":"di li {0} dia"},"past":{"other":"a ten {0} dia"}}},"hour":{"displayName":"Ora","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"di li {0} ora"},"past":{"other":"a ten {0} ora"}}},"hour-short":{"displayName":"ora","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"di li {0} ora"},"past":{"other":"a ten {0} ora"}}},"minute":{"displayName":"Minutu","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"di li {0} minutu"},"past":{"other":"a ten {0} minutu"}}},"minute-short":{"displayName":"min","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"di li {0} min"},"past":{"other":"a ten {0} min"}}},"second":{"displayName":"Sigundu","relative":{"0":"now"},"relativeTime":{"future":{"other":"di li {0} sigundu"},"past":{"other":"a ten {0} sigundu"}}},"second-short":{"displayName":"sig","relative":{"0":"now"},"relativeTime":{"future":{"other":"di li {0} sig"},"past":{"other":"a ten {0} sig"}}}}},
    {"locale":"khq","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Jiiri","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Jiiri","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Handu","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Handu","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Hebu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Hebu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Jaari","relative":{"0":"Hõo","1":"Suba","-1":"Bi"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Jaari","relative":{"0":"Hõo","1":"Suba","-1":"Bi"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Guuru","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Guuru","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Miniti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Miniti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Miti","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Miti","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ki","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mweri","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mweri","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Kiumia","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Kiumia","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Mũthenya","relative":{"0":"Ũmũthĩ","1":"Rũciũ","-1":"Ira"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Mũthenya","relative":{"0":"Ũmũthĩ","1":"Rũciũ","-1":"Ira"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Ithaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Ithaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Ndagĩka","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Ndagĩka","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"kk","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), t0 = Number(s[0]) == n,
          n10 = t0 && s[0].slice(-1);
      if (ord) return (n10 == 6 || n10 == 9
              || t0 && n10 == 0 && n != 0) ? 'many' : 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"жыл","relative":{"0":"биылғы жыл","1":"келесі жыл","-1":"былтырғы жыл"},"relativeTime":{"future":{"one":"{0} жылдан кейін","other":"{0} жылдан кейін"},"past":{"one":"{0} жыл бұрын","other":"{0} жыл бұрын"}}},"year-short":{"displayName":"ж.","relative":{"0":"биылғы жыл","1":"келесі жыл","-1":"былтырғы жыл"},"relativeTime":{"future":{"one":"{0} ж. кейін","other":"{0} ж. кейін"},"past":{"one":"{0} ж. бұрын","other":"{0} ж. бұрын"}}},"month":{"displayName":"ай","relative":{"0":"осы ай","1":"келесі ай","-1":"өткен ай"},"relativeTime":{"future":{"one":"{0} айдан кейін","other":"{0} айдан кейін"},"past":{"one":"{0} ай бұрын","other":"{0} ай бұрын"}}},"month-short":{"displayName":"ай","relative":{"0":"осы ай","1":"келесі ай","-1":"өткен ай"},"relativeTime":{"future":{"one":"{0} айдан кейін","other":"{0} айдан кейін"},"past":{"one":"{0} ай бұрын","other":"{0} ай бұрын"}}},"week":{"displayName":"апта","relativePeriod":"{0} аптасы","relative":{"0":"осы апта","1":"келесі апта","-1":"өткен апта"},"relativeTime":{"future":{"one":"{0} аптадан кейін","other":"{0} аптадан кейін"},"past":{"one":"{0} апта бұрын","other":"{0} апта бұрын"}}},"week-short":{"displayName":"ап.","relativePeriod":"{0} аптасы","relative":{"0":"осы апта","1":"келесі апта","-1":"өткен апта"},"relativeTime":{"future":{"one":"{0} ап. кейін","other":"{0} ап. кейін"},"past":{"one":"{0} ап. бұрын","other":"{0} ап. бұрын"}}},"day":{"displayName":"күн","relative":{"0":"бүгін","1":"ертең","2":"бүрсігүні","-2":"алдыңгүні","-1":"кеше"},"relativeTime":{"future":{"one":"{0} күннен кейін","other":"{0} күннен кейін"},"past":{"one":"{0} күн бұрын","other":"{0} күн бұрын"}}},"day-short":{"displayName":"күн","relative":{"0":"бүгін","1":"ертең","2":"бүрсігүні","-2":"алдыңғы күні","-1":"кеше"},"relativeTime":{"future":{"one":"{0} күннен кейін","other":"{0} күннен кейін"},"past":{"one":"{0} күн бұрын","other":"{0} күн бұрын"}}},"hour":{"displayName":"сағат","relative":{"0":"осы сағат"},"relativeTime":{"future":{"one":"{0} сағаттан кейін","other":"{0} сағаттан кейін"},"past":{"one":"{0} сағат бұрын","other":"{0} сағат бұрын"}}},"hour-short":{"displayName":"сағ","relative":{"0":"осы сағат"},"relativeTime":{"future":{"one":"{0} сағ. кейін","other":"{0} сағ. кейін"},"past":{"one":"{0} сағ. бұрын","other":"{0} сағ. бұрын"}}},"minute":{"displayName":"минут","relative":{"0":"осы минут"},"relativeTime":{"future":{"one":"{0} минуттан кейін","other":"{0} минуттан кейін"},"past":{"one":"{0} минут бұрын","other":"{0} минут бұрын"}}},"minute-short":{"displayName":"мин","relative":{"0":"осы минут"},"relativeTime":{"future":{"one":"{0} мин. кейін","other":"{0} мин. кейін"},"past":{"one":"{0} мин. бұрын","other":"{0} мин. бұрын"}}},"second":{"displayName":"секунд","relative":{"0":"қазір"},"relativeTime":{"future":{"one":"{0} секундтан кейін","other":"{0} секундтан кейін"},"past":{"one":"{0} секунд бұрын","other":"{0} секунд бұрын"}}},"second-short":{"displayName":"с","relative":{"0":"қазір"},"relativeTime":{"future":{"one":"{0} сек. кейін","other":"{0} сек. кейін"},"past":{"one":"{0} сек. бұрын","other":"{0} сек. бұрын"}}}}},
    {"locale":"kkj","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"muka","1":"nɛmɛnɔ","-1":"kwey"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"muka","1":"nɛmɛnɔ","-1":"kwey"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"kl","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"one":"om {0} ukioq","other":"om {0} ukioq"},"past":{"one":"for {0} ukioq siden","other":"for {0} ukioq siden"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"one":"om {0} ukioq","other":"om {0} ukioq"},"past":{"one":"for {0} ukioq siden","other":"for {0} ukioq siden"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"om {0} qaammat","other":"om {0} qaammat"},"past":{"one":"for {0} qaammat siden","other":"for {0} qaammat siden"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"om {0} qaammat","other":"om {0} qaammat"},"past":{"one":"for {0} qaammat siden","other":"for {0} qaammat siden"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"om {0} sapaatip-akunnera","other":"om {0} sapaatip-akunnera"},"past":{"one":"for {0} sapaatip-akunnera siden","other":"for {0} sapaatip-akunnera siden"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"om {0} sapaatip-akunnera","other":"om {0} sapaatip-akunnera"},"past":{"one":"for {0} sapaatip-akunnera siden","other":"for {0} sapaatip-akunnera siden"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"om {0} ulloq unnuarlu","other":"om {0} ulloq unnuarlu"},"past":{"one":"for {0} ulloq unnuarlu siden","other":"for {0} ulloq unnuarlu siden"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"om {0} ulloq unnuarlu","other":"om {0} ulloq unnuarlu"},"past":{"one":"for {0} ulloq unnuarlu siden","other":"for {0} ulloq unnuarlu siden"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"om {0} nalunaaquttap-akunnera","other":"om {0} nalunaaquttap-akunnera"},"past":{"one":"for {0} nalunaaquttap-akunnera siden","other":"for {0} nalunaaquttap-akunnera siden"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"om {0} nalunaaquttap-akunnera","other":"om {0} nalunaaquttap-akunnera"},"past":{"one":"for {0} nalunaaquttap-akunnera siden","other":"for {0} nalunaaquttap-akunnera siden"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"om {0} minutsi","other":"om {0} minutsi"},"past":{"one":"for {0} minutsi siden","other":"for {0} minutsi siden"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"om {0} minutsi","other":"om {0} minutsi"},"past":{"one":"for {0} minutsi siden","other":"for {0} minutsi siden"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"one":"om {0} sekundi","other":"om {0} sekundi"},"past":{"one":"for {0} sekundi siden","other":"for {0} sekundi siden"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"one":"om {0} sekundi","other":"om {0} sekundi"},"past":{"one":"for {0} sekundi siden","other":"for {0} sekundi siden"}}}}},
    {"locale":"kln","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Kenyit","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Kenyit","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Arawet","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Arawet","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Wikit","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Wikit","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Betut","relative":{"0":"Raini","1":"Mutai","-1":"Amut"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Betut","relative":{"0":"Raini","1":"Mutai","-1":"Amut"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Sait","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Sait","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minitit","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minitit","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekondit","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekondit","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"km","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return 'other';
    },"fields":{"year":{"displayName":"ឆ្នាំ","relative":{"0":"ឆ្នាំ​នេះ","1":"ឆ្នាំ​ក្រោយ","-1":"ឆ្នាំ​មុន"},"relativeTime":{"future":{"other":"{0} ឆ្នាំទៀត"},"past":{"other":"{0} ឆ្នាំ​មុន"}}},"year-short":{"displayName":"ឆ្នាំ","relative":{"0":"ឆ្នាំ​នេះ","1":"ឆ្នាំ​ក្រោយ","-1":"ឆ្នាំ​មុន"},"relativeTime":{"future":{"other":"{0} ឆ្នាំទៀត"},"past":{"other":"{0} ឆ្នាំ​មុន"}}},"month":{"displayName":"ខែ","relative":{"0":"ខែ​នេះ","1":"ខែ​ក្រោយ","-1":"ខែ​មុន"},"relativeTime":{"future":{"other":"{0} ខែទៀត"},"past":{"other":"{0} ខែមុន"}}},"month-short":{"displayName":"ខែ","relative":{"0":"ខែ​នេះ","1":"ខែ​ក្រោយ","-1":"ខែ​មុន"},"relativeTime":{"future":{"other":"{0} ខែទៀត"},"past":{"other":"{0} ខែមុន"}}},"week":{"displayName":"សប្ដាហ៍","relativePeriod":"សប្តាហ៍នៃ {0}","relative":{"0":"សប្ដាហ៍​នេះ","1":"សប្ដាហ៍​ក្រោយ","-1":"សប្ដាហ៍​មុន"},"relativeTime":{"future":{"other":"{0} សប្ដាហ៍ទៀត"},"past":{"other":"{0} សប្ដាហ៍​មុន"}}},"week-short":{"displayName":"សប្ដាហ៍","relativePeriod":"សប្តាហ៍នៃ {0}","relative":{"0":"សប្ដាហ៍​នេះ","1":"សប្ដាហ៍​ក្រោយ","-1":"សប្ដាហ៍​មុន"},"relativeTime":{"future":{"other":"{0} សប្ដាហ៍ទៀត"},"past":{"other":"{0} សប្ដាហ៍​មុន"}}},"day":{"displayName":"ថ្ងៃ","relative":{"0":"ថ្ងៃ​នេះ","1":"ថ្ងៃ​ស្អែក","2":"​ខាន​ស្អែក","-2":"ម្សិល​ម៉្ងៃ","-1":"ម្សិលមិញ"},"relativeTime":{"future":{"other":"{0} ថ្ងៃទៀត"},"past":{"other":"{0} ថ្ងៃ​មុន"}}},"day-short":{"displayName":"ថ្ងៃ","relative":{"0":"ថ្ងៃ​នេះ","1":"ថ្ងៃស្អែក","2":"​ខាន​ស្អែក","-2":"ម្សិល​ម៉្ងៃ","-1":"ម្សិលមិញ"},"relativeTime":{"future":{"other":"{0} ថ្ងៃទៀត"},"past":{"other":"{0} ថ្ងៃ​​មុន"}}},"hour":{"displayName":"ម៉ោង","relative":{"0":"ម៉ោងនេះ"},"relativeTime":{"future":{"other":"ក្នុង​រយៈ​ពេល {0} ម៉ោង"},"past":{"other":"{0} ម៉ោង​មុន"}}},"hour-short":{"displayName":"ម៉ោង","relative":{"0":"ម៉ោងនេះ"},"relativeTime":{"future":{"other":"{0} ម៉ោងទៀត"},"past":{"other":"{0} ម៉ោង​មុន"}}},"minute":{"displayName":"នាទី","relative":{"0":"នាទីនេះ"},"relativeTime":{"future":{"other":"{0} នាទីទៀត"},"past":{"other":"{0} នាទី​មុន"}}},"minute-short":{"displayName":"នាទី","relative":{"0":"នាទីនេះ"},"relativeTime":{"future":{"other":"{0} នាទីទៀត"},"past":{"other":"{0} នាទី​​មុន"}}},"second":{"displayName":"វិនាទី","relative":{"0":"ឥឡូវ"},"relativeTime":{"future":{"other":"{0} វិនាទីទៀត"},"past":{"other":"{0} វិនាទី​មុន"}}},"second-short":{"displayName":"វិនាទី","relative":{"0":"ឥឡូវ"},"relativeTime":{"future":{"other":"{0} វិនាទីទៀត"},"past":{"other":"{0} វិនាទី​មុន"}}}}},
    {"locale":"kn","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n >= 0 && n <= 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ವರ್ಷ","relative":{"0":"ಈ ವರ್ಷ","1":"ಮುಂದಿನ ವರ್ಷ","-1":"ಹಿಂದಿನ ವರ್ಷ"},"relativeTime":{"future":{"one":"{0} ವರ್ಷದಲ್ಲಿ","other":"{0} ವರ್ಷಗಳಲ್ಲಿ"},"past":{"one":"{0} ವರ್ಷದ ಹಿಂದೆ","other":"{0} ವರ್ಷಗಳ ಹಿಂದೆ"}}},"year-short":{"displayName":"ವರ್ಷ","relative":{"0":"ಈ ವರ್ಷ","1":"ಮುಂದಿನ ವರ್ಷ","-1":"ಕಳೆದ ವರ್ಷ"},"relativeTime":{"future":{"one":"{0} ವರ್ಷದಲ್ಲಿ","other":"{0} ವರ್ಷಗಳಲ್ಲಿ"},"past":{"one":"{0} ವರ್ಷದ ಹಿಂದೆ","other":"{0} ವರ್ಷಗಳ ಹಿಂದೆ"}}},"month":{"displayName":"ತಿಂಗಳು","relative":{"0":"ಈ ತಿಂಗಳು","1":"ಮುಂದಿನ ತಿಂಗಳು","-1":"ಕಳೆದ ತಿಂಗಳು"},"relativeTime":{"future":{"one":"{0} ತಿಂಗಳಲ್ಲಿ","other":"{0} ತಿಂಗಳುಗಳಲ್ಲಿ"},"past":{"one":"{0} ತಿಂಗಳ ಹಿಂದೆ","other":"{0} ತಿಂಗಳುಗಳ ಹಿಂದೆ"}}},"month-short":{"displayName":"ತಿಂಗಳು","relative":{"0":"ಈ ತಿಂಗಳು","1":"ಮುಂದಿನ ತಿಂಗಳು","-1":"ಕಳೆದ ತಿಂಗಳು"},"relativeTime":{"future":{"one":"{0} ತಿಂಗಳಲ್ಲಿ","other":"{0} ತಿಂಗಳುಗಳಲ್ಲಿ"},"past":{"one":"{0} ತಿಂಗಳು ಹಿಂದೆ","other":"{0} ತಿಂಗಳುಗಳ ಹಿಂದೆ"}}},"week":{"displayName":"ವಾರ","relativePeriod":"{0} ವಾರ","relative":{"0":"ಈ ವಾರ","1":"ಮುಂದಿನ ವಾರ","-1":"ಕಳೆದ ವಾರ"},"relativeTime":{"future":{"one":"{0} ವಾರದಲ್ಲಿ","other":"{0} ವಾರಗಳಲ್ಲಿ"},"past":{"one":"{0} ವಾರದ ಹಿಂದೆ","other":"{0} ವಾರಗಳ ಹಿಂದೆ"}}},"week-short":{"displayName":"ವಾರ","relativePeriod":"{0} ವಾರ","relative":{"0":"ಈ ವಾರ","1":"ಮುಂದಿನ ವಾರ","-1":"ಕಳೆದ ವಾರ"},"relativeTime":{"future":{"one":"{0} ವಾರದಲ್ಲಿ","other":"{0} ವಾರಗಳಲ್ಲಿ"},"past":{"one":"{0} ವಾರದ ಹಿಂದೆ","other":"{0} ವಾರಗಳ ಹಿಂದೆ"}}},"day":{"displayName":"ದಿನ","relative":{"0":"ಇಂದು","1":"ನಾಳೆ","2":"ನಾಡಿದ್ದು","-2":"ಮೊನ್ನೆ","-1":"ನಿನ್ನೆ"},"relativeTime":{"future":{"one":"{0} ದಿನದಲ್ಲಿ","other":"{0} ದಿನಗಳಲ್ಲಿ"},"past":{"one":"{0} ದಿನದ ಹಿಂದೆ","other":"{0} ದಿನಗಳ ಹಿಂದೆ"}}},"day-short":{"displayName":"ದಿನ","relative":{"0":"ಇಂದು","1":"ನಾಳೆ","2":"ನಾಡಿದ್ದು","-2":"ಮೊನ್ನೆ","-1":"ನಿನ್ನೆ"},"relativeTime":{"future":{"one":"{0} ದಿನದಲ್ಲಿ","other":"{0} ದಿನಗಳಲ್ಲಿ"},"past":{"one":"{0} ದಿನದ ಹಿಂದೆ","other":"{0} ದಿನಗಳ ಹಿಂದೆ"}}},"hour":{"displayName":"ಗಂಟೆ","relative":{"0":"ಈ ಗಂಟೆ"},"relativeTime":{"future":{"one":"{0} ಗಂಟೆಯಲ್ಲಿ","other":"{0} ಗಂಟೆಗಳಲ್ಲಿ"},"past":{"one":"{0} ಗಂಟೆ ಹಿಂದೆ","other":"{0} ಗಂಟೆಗಳ ಹಿಂದೆ"}}},"hour-short":{"displayName":"ಗಂಟೆ","relative":{"0":"ಈ ಗಂಟೆ"},"relativeTime":{"future":{"one":"{0} ಗಂಟೆಯಲ್ಲಿ","other":"{0} ಗಂಟೆಗಳಲ್ಲಿ"},"past":{"one":"{0} ಗಂಟೆ ಹಿಂದೆ","other":"{0} ಗಂಟೆಗಳ ಹಿಂದೆ"}}},"minute":{"displayName":"ನಿಮಿಷ","relative":{"0":"ಈ ನಿಮಿಷ"},"relativeTime":{"future":{"one":"{0} ನಿಮಿಷದಲ್ಲಿ","other":"{0} ನಿಮಿಷಗಳಲ್ಲಿ"},"past":{"one":"{0} ನಿಮಿಷದ ಹಿಂದೆ","other":"{0} ನಿಮಿಷಗಳ ಹಿಂದೆ"}}},"minute-short":{"displayName":"ನಿಮಿಷ","relative":{"0":"ಈ ನಿಮಿಷ"},"relativeTime":{"future":{"one":"{0} ನಿಮಿಷದಲ್ಲಿ","other":"{0} ನಿಮಿಷಗಳಲ್ಲಿ"},"past":{"one":"{0} ನಿಮಿಷದ ಹಿಂದೆ","other":"{0} ನಿಮಿಷಗಳ ಹಿಂದೆ"}}},"second":{"displayName":"ಸೆಕೆಂಡ್","relative":{"0":"ಈಗ"},"relativeTime":{"future":{"one":"{0} ಸೆಕೆಂಡ್‌ನಲ್ಲಿ","other":"{0} ಸೆಕೆಂಡ್‌ಗಳಲ್ಲಿ"},"past":{"one":"{0} ಸೆಕೆಂಡ್ ಹಿಂದೆ","other":"{0} ಸೆಕೆಂಡುಗಳ ಹಿಂದೆ"}}},"second-short":{"displayName":"ಸೆಕೆಂಡ್","relative":{"0":"ಈಗ"},"relativeTime":{"future":{"one":"{0} ಸೆಕೆಂಡ್‌ನಲ್ಲಿ","other":"{0} ಸೆಕೆಂಡ್‌ಗಳಲ್ಲಿ"},"past":{"one":"{0} ಸೆಕೆಂಡ್ ಹಿಂದೆ","other":"{0} ಸೆಕೆಂಡುಗಳ ಹಿಂದೆ"}}}}},
    {"locale":"ko","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return 'other';
    },"fields":{"year":{"displayName":"년","relative":{"0":"올해","1":"내년","-1":"작년"},"relativeTime":{"future":{"other":"{0}년 후"},"past":{"other":"{0}년 전"}}},"year-short":{"displayName":"년","relative":{"0":"올해","1":"내년","-1":"작년"},"relativeTime":{"future":{"other":"{0}년 후"},"past":{"other":"{0}년 전"}}},"month":{"displayName":"월","relative":{"0":"이번 달","1":"다음 달","-1":"지난달"},"relativeTime":{"future":{"other":"{0}개월 후"},"past":{"other":"{0}개월 전"}}},"month-short":{"displayName":"월","relative":{"0":"이번 달","1":"다음 달","-1":"지난달"},"relativeTime":{"future":{"other":"{0}개월 후"},"past":{"other":"{0}개월 전"}}},"week":{"displayName":"주","relativePeriod":"{0}번째 주","relative":{"0":"이번 주","1":"다음 주","-1":"지난주"},"relativeTime":{"future":{"other":"{0}주 후"},"past":{"other":"{0}주 전"}}},"week-short":{"displayName":"주","relativePeriod":"{0}번째 주","relative":{"0":"이번 주","1":"다음 주","-1":"지난주"},"relativeTime":{"future":{"other":"{0}주 후"},"past":{"other":"{0}주 전"}}},"day":{"displayName":"일","relative":{"0":"오늘","1":"내일","2":"모레","-2":"그저께","-1":"어제"},"relativeTime":{"future":{"other":"{0}일 후"},"past":{"other":"{0}일 전"}}},"day-short":{"displayName":"일","relative":{"0":"오늘","1":"내일","2":"모레","-2":"그저께","-1":"어제"},"relativeTime":{"future":{"other":"{0}일 후"},"past":{"other":"{0}일 전"}}},"hour":{"displayName":"시","relative":{"0":"현재 시간"},"relativeTime":{"future":{"other":"{0}시간 후"},"past":{"other":"{0}시간 전"}}},"hour-short":{"displayName":"시","relative":{"0":"현재 시간"},"relativeTime":{"future":{"other":"{0}시간 후"},"past":{"other":"{0}시간 전"}}},"minute":{"displayName":"분","relative":{"0":"현재 분"},"relativeTime":{"future":{"other":"{0}분 후"},"past":{"other":"{0}분 전"}}},"minute-short":{"displayName":"분","relative":{"0":"현재 분"},"relativeTime":{"future":{"other":"{0}분 후"},"past":{"other":"{0}분 전"}}},"second":{"displayName":"초","relative":{"0":"지금"},"relativeTime":{"future":{"other":"{0}초 후"},"past":{"other":"{0}초 전"}}},"second-short":{"displayName":"초","relative":{"0":"지금"},"relativeTime":{"future":{"other":"{0}초 후"},"past":{"other":"{0}초 전"}}}}},{"locale":"ko-KP","parentLocale":"ko"},
    {"locale":"kok","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"वर्स","relative":{"0":"हें वर्स","1":"फुडलें वर्स","-1":"फाटलें वर्स"},"relativeTime":{"future":{"other":"{0} वर्सांनीं"},"past":{"other":"{0} वर्सां आदीं"}}},"year-short":{"displayName":"वर्स","relative":{"0":"हें वर्स","1":"फुडलें वर्स","-1":"फाटलें वर्स"},"relativeTime":{"future":{"other":"{0} वर्सांनीं"},"past":{"other":"{0} वर्स आदीं"}}},"month":{"displayName":"म्हयनो","relative":{"0":"हो म्हयनो","1":"फुडलो म्हयनो","-1":"फाटलो म्हयनो"},"relativeTime":{"future":{"other":"{0} म्हयन्यानीं"},"past":{"other":"{0} म्हयन्यां आदीं"}}},"month-short":{"displayName":"म्हयनो","relative":{"0":"हो म्हयनो","1":"फुडलो म्हयनो","-1":"फाटलो म्हयनो"},"relativeTime":{"future":{"other":"{0} म्हयन्यानीं"},"past":{"other":"{0} म्हयन्यां आदीं"}}},"week":{"displayName":"सप्तक","relativePeriod":"{0} चो सप्तक","relative":{"0":"हो सप्तक","1":"फुडलो सप्तक","-1":"निमाणो सप्तक"},"relativeTime":{"future":{"other":"{0} सप्तकांनीं"},"past":{"other":"{0} सप्तकां आदीं"}}},"week-short":{"displayName":"सप्तक","relativePeriod":"{0} चो सप्तक","relative":{"0":"हो सप्तक","1":"फुडलो सप्तक","-1":"निमाणो सप्तक"},"relativeTime":{"future":{"other":"{0} सप्त."},"past":{"other":"{0} सप्तकां आदीं"}}},"day":{"displayName":"दीस","relative":{"0":"आयज","1":"फाल्यां","-1":"काल"},"relativeTime":{"future":{"other":"{0} दिसानीं"},"past":{"other":"{0} दीस आदीं"}}},"day-short":{"displayName":"दीस","relative":{"0":"आयज","1":"फाल्यां","-1":"काल"},"relativeTime":{"future":{"other":"{0} दिसानीं"},"past":{"other":"{0} दीस आदीं"}}},"hour":{"displayName":"वर","relative":{"0":"हें वर"},"relativeTime":{"future":{"other":"{0} वरांनीं"},"past":{"other":"{0} वरा आदीं"}}},"hour-short":{"displayName":"वर","relative":{"0":"हें वर"},"relativeTime":{"future":{"other":"{0} वरांनीं"},"past":{"other":"{0} वरा आदीं"}}},"minute":{"displayName":"मिनीट","relative":{"0":"हें मिनीट"},"relativeTime":{"future":{"other":"{0} मिन्टां"},"past":{"other":"{0} मिन्टां आदीं"}}},"minute-short":{"displayName":"मिनीट","relative":{"0":"हें मिनीट"},"relativeTime":{"future":{"other":"{0} मिन्टां"},"past":{"other":"{0} मिन्टां आदीं"}}},"second":{"displayName":"सेकंद","relative":{"0":"आतां"},"relativeTime":{"future":{"other":"{0} सेकंदानीं"},"past":{"other":"{0} सेकंद आदीं"}}},"second-short":{"displayName":"सेकंद","relative":{"0":"आतां"},"relativeTime":{"future":{"other":"{0} सेकंदानीं"},"past":{"other":"{0} से. आदीं"}}}}},
    {"locale":"ks","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ؤری","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"ؤری","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"رٮ۪تھ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"رٮ۪تھ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"ہفتہٕ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"ہفتہٕ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"دۄہ","relative":{"0":"اَز","1":"پگاہ","-1":"راتھ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"دۄہ","relative":{"0":"اَز","1":"پگاہ","-1":"راتھ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"گٲنٛٹہٕ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"گٲنٛٹہٕ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"مِنَٹ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"مِنَٹ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"سٮ۪کَنڑ","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"سٮ۪کَنڑ","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ksb","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Ng’waka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Ng’waka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Ng’ezi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Ng’ezi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Niki","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Niki","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Siku","relative":{"0":"Evi eo","1":"Keloi","-1":"Ghuo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Siku","relative":{"0":"Evi eo","1":"Keloi","-1":"Ghuo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Dakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Dakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ksf","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Bǝk","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Bǝk","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Ŋwíí","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Ŋwíí","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Sɔ́ndǝ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Sɔ́ndǝ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Ŋwós","relative":{"0":"Gɛ́ɛnǝ","1":"Ridúrǝ́","-1":"Rinkɔɔ́"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Ŋwós","relative":{"0":"Gɛ́ɛnǝ","1":"Ridúrǝ́","-1":"Rinkɔɔ́"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Cámɛɛn","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Cámɛɛn","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Mǝnít","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Mǝnít","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Háu","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Háu","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ksh","pluralRuleFunction":function(n
    ) {
      return (n == 0) ? 'zero'
          : (n == 1) ? 'one'
          : 'other';
    },"fields":{"year":{"displayName":"Johr","relative":{"0":"diß Johr","1":"näx Johr","-1":"läz Johr"},"relativeTime":{"future":{"zero":"en keinem Johr","one":"en {0} Johr","other":"en {0} Johre"},"past":{"zero":"vör keijnem Johr","one":"vör {0} Johr","other":"vör {0} Johre"}}},"year-short":{"displayName":"J.","relative":{"0":"diß Johr","1":"näx Johr","-1":"läz Johr"},"relativeTime":{"future":{"zero":"en keinem Johr","one":"en {0} Johr","other":"en {0} Johre"},"past":{"zero":"vör keijnem Johr","one":"vör {0} Johr","other":"vör {0} Johre"}}},"month":{"displayName":"Mohnd","relative":{"0":"diese Mohnd","1":"nächste Mohnd","-1":"lätzde Mohnd"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mohnd","relative":{"0":"diese Mohnd","1":"nächste Mohnd","-1":"lätzde Mohnd"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Woch","relativePeriod":"the week of {0}","relative":{"0":"di Woch","1":"nächste Woche","-1":"läz Woch"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"W.","relativePeriod":"the week of {0}","relative":{"0":"di Woch","1":"nächste Woche","-1":"läz Woch"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Daach","relative":{"0":"hück","1":"morje","2":"övvermorje","-2":"vörjestere","-1":"jestere"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"D.","relative":{"0":"hück","1":"morje","2":"övvermorje","-2":"vörjestere","-1":"jestere"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Schtund","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Std.","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Menutt","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"min.","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekond","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"sek.","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ku","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"sal","relative":{"0":"îsal","1":"sala piştî","-1":"par"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"sal","relative":{"0":"îsal","1":"sala piştî","-1":"par"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"meh","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"m.","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"hefte","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"hf.","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"roj","relative":{"0":"îro","1":"sibe","-1":"duh"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"r.","relative":{"0":"îro","1":"sibe","-1":"duh"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"saet","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"st.","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"deqîqe","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"d.","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"saniye","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"s.","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"kw","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one'
          : (n == 2) ? 'two'
          : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ky","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"жыл","relative":{"0":"быйыл","1":"эмдиги жылы","-1":"былтыр"},"relativeTime":{"future":{"one":"{0} жылдан кийин","other":"{0} жылдан кийин"},"past":{"one":"{0} жыл мурун","other":"{0} жыл мурун"}}},"year-short":{"displayName":"ж.","relative":{"0":"быйыл","1":"эмдиги жылы","-1":"былтыр"},"relativeTime":{"future":{"one":"{0} жыл. кийин","other":"{0} жыл. кийин"},"past":{"one":"{0} жыл мурун","other":"{0} жыл мурун"}}},"month":{"displayName":"ай","relative":{"0":"бул айда","1":"эмдиги айда","-1":"өткөн айда"},"relativeTime":{"future":{"one":"{0} айдан кийин","other":"{0} айдан кийин"},"past":{"one":"{0} ай мурун","other":"{0} ай мурун"}}},"month-short":{"displayName":"ай","relative":{"0":"бул айда","1":"эмдиги айда","-1":"өткөн айда"},"relativeTime":{"future":{"one":"{0} айд. кийин","other":"{0} айд. кийин"},"past":{"one":"{0} ай мурун","other":"{0} ай мурун"}}},"week":{"displayName":"апта","relativePeriod":"{0} апта ичинде","relative":{"0":"ушул аптада","1":"келерки аптада","-1":"өткөн аптада"},"relativeTime":{"future":{"one":"{0} аптадан кийин","other":"{0} аптадан кийин"},"past":{"one":"{0} апта мурун","other":"{0} апта мурун"}}},"week-short":{"displayName":"апт","relativePeriod":"{0} апта ичинде","relative":{"0":"ушул апт.","1":"келерки апт.","-1":"өткөн апт."},"relativeTime":{"future":{"one":"{0} апт. кийин","other":"{0} апт. кийин"},"past":{"one":"{0} апт. мурун","other":"{0} апт. мурун"}}},"day":{"displayName":"күн","relative":{"0":"бүгүн","1":"эртең","2":"бүрсүгүнү","-2":"мурдагы күнү","-1":"кечээ"},"relativeTime":{"future":{"one":"{0} күндөн кийин","other":"{0} күндөн кийин"},"past":{"one":"{0} күн мурун","other":"{0} күн мурун"}}},"day-short":{"displayName":"күн","relative":{"0":"бүгүн","1":"эртең","2":"бүрсүгүнү","-2":"мурдагы күнү","-1":"кечээ"},"relativeTime":{"future":{"one":"{0} күн. кийин","other":"{0} күн. кийин"},"past":{"one":"{0} күн мурун","other":"{0} күн мурун"}}},"hour":{"displayName":"саат","relative":{"0":"ушул саатта"},"relativeTime":{"future":{"one":"{0} сааттан кийин","other":"{0} сааттан кийин"},"past":{"one":"{0} саат мурун","other":"{0} саат мурун"}}},"hour-short":{"displayName":"ст","relative":{"0":"ушул саатта"},"relativeTime":{"future":{"one":"{0} саат. кийин","other":"{0} саат. кийин"},"past":{"one":"{0} саат. мурун","other":"{0} саат. мурун"}}},"minute":{"displayName":"мүнөт","relative":{"0":"ушул мүнөттө"},"relativeTime":{"future":{"one":"{0} мүнөттөн кийин","other":"{0} мүнөттөн кийин"},"past":{"one":"{0} мүнөт мурун","other":"{0} мүнөт мурун"}}},"minute-short":{"displayName":"мүн.","relative":{"0":"ушул мүнөттө"},"relativeTime":{"future":{"one":"{0} мүн. кийин","other":"{0} мүн. кийин"},"past":{"one":"{0} мүн. мурун","other":"{0} мүн. мурун"}}},"second":{"displayName":"секунд","relative":{"0":"азыр"},"relativeTime":{"future":{"one":"{0} секунддан кийин","other":"{0} секунддан кийин"},"past":{"one":"{0} секунд мурун","other":"{0} секунд мурун"}}},"second-short":{"displayName":"сек.","relative":{"0":"азыр"},"relativeTime":{"future":{"one":"{0} сек. кийин","other":"{0} сек. кийин"},"past":{"one":"{0} сек. мурун","other":"{0} сек. мурун"}}}}},
    {"locale":"lag","pluralRuleFunction":function(n
    ) {
      var s = String(n).split('.'), i = s[0];
      return (n == 0) ? 'zero'
          : ((i == 0
              || i == 1) && n != 0) ? 'one'
          : 'other';
    },"fields":{"year":{"displayName":"Mwaáka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Mwaáka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mweéri","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mweéri","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Wíiki","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Wíiki","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Sikʉ","relative":{"0":"Isikʉ","1":"Lamʉtoondo","-1":"Niijo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Sikʉ","relative":{"0":"Isikʉ","1":"Lamʉtoondo","-1":"Niijo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Sáa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Sáa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Dakíka","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Dakíka","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekúunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekúunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"lb","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Joer","relative":{"0":"dëst Joer","1":"nächst Joer","-1":"lescht Joer"},"relativeTime":{"future":{"one":"an {0} Joer","other":"a(n) {0} Joer"},"past":{"one":"virun {0} Joer","other":"viru(n) {0} Joer"}}},"year-short":{"displayName":"J.","relative":{"0":"dëst Joer","1":"nächst Joer","-1":"lescht Joer"},"relativeTime":{"future":{"one":"an {0} J.","other":"a(n) {0} J."},"past":{"one":"virun {0} J.","other":"viru(n) {0} J."}}},"month":{"displayName":"Mount","relative":{"0":"dëse Mount","1":"nächste Mount","-1":"leschte Mount"},"relativeTime":{"future":{"one":"an {0} Mount","other":"a(n) {0} Méint"},"past":{"one":"virun {0} Mount","other":"viru(n) {0} Méint"}}},"month-short":{"displayName":"M.","relative":{"0":"dëse Mount","1":"nächste Mount","-1":"leschte Mount"},"relativeTime":{"future":{"one":"an {0} M.","other":"a(n) {0} M."},"past":{"one":"virun {0} M.","other":"viru(n) {0} M."}}},"week":{"displayName":"Woch","relativePeriod":"the week of {0}","relative":{"0":"dës Woch","1":"nächst Woch","-1":"lescht Woch"},"relativeTime":{"future":{"one":"an {0} Woch","other":"a(n) {0} Wochen"},"past":{"one":"virun {0} Woch","other":"viru(n) {0} Wochen"}}},"week-short":{"displayName":"W.","relativePeriod":"the week of {0}","relative":{"0":"dës Woch","1":"nächst Woch","-1":"lescht Woch"},"relativeTime":{"future":{"one":"an {0} W.","other":"a(n) {0} W."},"past":{"one":"virun {0} W.","other":"viru(n) {0} W."}}},"day":{"displayName":"Dag","relative":{"0":"haut","1":"muer","-1":"gëschter"},"relativeTime":{"future":{"one":"an {0} Dag","other":"a(n) {0} Deeg"},"past":{"one":"virun {0} Dag","other":"viru(n) {0} Deeg"}}},"day-short":{"displayName":"D.","relative":{"0":"haut","1":"muer","-1":"gëschter"},"relativeTime":{"future":{"one":"an {0} D.","other":"a(n) {0} D."},"past":{"one":"virun {0} D.","other":"viru(n) {0} D."}}},"hour":{"displayName":"Stonn","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"an {0} Stonn","other":"a(n) {0} Stonnen"},"past":{"one":"virun {0} Stonn","other":"viru(n) {0} Stonnen"}}},"hour-short":{"displayName":"St.","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"an {0} St.","other":"a(n) {0} St."},"past":{"one":"virun {0} St.","other":"viru(n) {0} St."}}},"minute":{"displayName":"Minutt","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"an {0} Minutt","other":"a(n) {0} Minutten"},"past":{"one":"virun {0} Minutt","other":"viru(n) {0} Minutten"}}},"minute-short":{"displayName":"Min.","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"an {0} Min.","other":"a(n) {0} Min."},"past":{"one":"virun {0} Min.","other":"viru(n) {0} Min."}}},"second":{"displayName":"Sekonn","relative":{"0":"now"},"relativeTime":{"future":{"one":"an {0} Sekonn","other":"a(n) {0} Sekonnen"},"past":{"one":"virun {0} Sekonn","other":"viru(n) {0} Sekonnen"}}},"second-short":{"displayName":"Sek.","relative":{"0":"now"},"relativeTime":{"future":{"one":"an {0} Sek.","other":"a(n) {0} Sek."},"past":{"one":"virun {0} Sek.","other":"viru(n) {0} Sek."}}}}},
    {"locale":"lg","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mwezi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mwezi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Sabbiiti","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Sabbiiti","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Lunaku","relative":{"0":"Lwaleero","1":"Nkya","-1":"Ggulo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Lunaku","relative":{"0":"Lwaleero","1":"Nkya","-1":"Ggulo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Saawa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Saawa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Dakiika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Dakiika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Kasikonda","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Kasikonda","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"lkt","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Ómakȟa","relative":{"0":"Lé ómakȟa kiŋ","1":"Tȟokáta ómakȟa kiŋháŋ","-1":"Ómakȟa kʼuŋ héhaŋ"},"relativeTime":{"future":{"other":"Letáŋhaŋ ómakȟa {0} kiŋháŋ"},"past":{"other":"Hékta ómakȟa {0} kʼuŋ héhaŋ"}}},"year-short":{"displayName":"Ómakȟa","relative":{"0":"Lé ómakȟa kiŋ","1":"Tȟokáta ómakȟa kiŋháŋ","-1":"Ómakȟa kʼuŋ héhaŋ"},"relativeTime":{"future":{"other":"Letáŋhaŋ ómakȟa {0} kiŋháŋ"},"past":{"other":"Hékta ómakȟa {0} kʼuŋ héhaŋ"}}},"month":{"displayName":"Wí","relative":{"0":"Lé wí kiŋ","1":"Tȟokáta wí kiŋháŋ","-1":"Wí kʼuŋ héhaŋ"},"relativeTime":{"future":{"other":"Letáŋhaŋ wíyawapi {0} kiŋháŋ"},"past":{"other":"Hékta wíyawapi {0} kʼuŋ héhaŋ"}}},"month-short":{"displayName":"Wí","relative":{"0":"Lé wí kiŋ","1":"Tȟokáta wí kiŋháŋ","-1":"Wí kʼuŋ héhaŋ"},"relativeTime":{"future":{"other":"Letáŋhaŋ wíyawapi {0} kiŋháŋ"},"past":{"other":"Hékta wíyawapi {0} kʼuŋ héhaŋ"}}},"week":{"displayName":"Okó","relativePeriod":"the week of {0}","relative":{"0":"Lé okó kiŋ","1":"Tȟokáta okó kiŋháŋ","-1":"Okó kʼuŋ héhaŋ"},"relativeTime":{"future":{"other":"Letáŋhaŋ okó {0} kiŋháŋ"},"past":{"other":"Hékta okó {0} kʼuŋ héhaŋ"}}},"week-short":{"displayName":"Okó","relativePeriod":"the week of {0}","relative":{"0":"Lé okó kiŋ","1":"Tȟokáta okó kiŋháŋ","-1":"Okó kʼuŋ héhaŋ"},"relativeTime":{"future":{"other":"Letáŋhaŋ okó {0} kiŋháŋ"},"past":{"other":"Hékta okó {0} kʼuŋ héhaŋ"}}},"day":{"displayName":"Aŋpétu","relative":{"0":"Lé aŋpétu kiŋ","1":"Híŋhaŋni kiŋháŋ","-1":"Ȟtálehaŋ"},"relativeTime":{"future":{"other":"Letáŋhaŋ {0}-čháŋ kiŋháŋ"},"past":{"other":"Hékta {0}-čháŋ k’uŋ héhaŋ"}}},"day-short":{"displayName":"Aŋpétu","relative":{"0":"Lé aŋpétu kiŋ","1":"Híŋhaŋni kiŋháŋ","-1":"Ȟtálehaŋ"},"relativeTime":{"future":{"other":"Letáŋhaŋ {0}-čháŋ kiŋháŋ"},"past":{"other":"Hékta {0}-čháŋ k’uŋ héhaŋ"}}},"hour":{"displayName":"Owápȟe","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"Letáŋhaŋ owápȟe {0} kiŋháŋ"},"past":{"other":"Hékta owápȟe {0} kʼuŋ héhaŋ"}}},"hour-short":{"displayName":"Owápȟe","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"Letáŋhaŋ owápȟe {0} kiŋháŋ"},"past":{"other":"Hékta owápȟe {0} kʼuŋ héhaŋ"}}},"minute":{"displayName":"Owápȟe oȟʼáŋkȟo","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"Letáŋhaŋ oȟ’áŋkȟo {0} kiŋháŋ"},"past":{"other":"Hékta oȟ’áŋkȟo {0} k’uŋ héhaŋ"}}},"minute-short":{"displayName":"Owápȟe oȟʼáŋkȟo","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"Letáŋhaŋ oȟ’áŋkȟo {0} kiŋháŋ"},"past":{"other":"Hékta oȟ’áŋkȟo {0} k’uŋ héhaŋ"}}},"second":{"displayName":"Okpí","relative":{"0":"now"},"relativeTime":{"future":{"other":"Letáŋhaŋ okpí {0} kiŋháŋ"},"past":{"other":"Hékta okpí {0} k’uŋ héhaŋ"}}},"second-short":{"displayName":"Okpí","relative":{"0":"now"},"relativeTime":{"future":{"other":"Letáŋhaŋ okpí {0} kiŋháŋ"},"past":{"other":"Hékta okpí {0} k’uŋ héhaŋ"}}}}},
    {"locale":"ln","pluralRuleFunction":function(n
    ) {
      return ((n == 0
              || n == 1)) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Mobú","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Mobú","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Sánzá","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Sánzá","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Pɔ́sɔ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Pɔ́sɔ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Mokɔlɔ","relative":{"0":"Lɛlɔ́","1":"Lóbi ekoyâ","-1":"Lóbi elékí"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Mokɔlɔ","relative":{"0":"Lɛlɔ́","1":"Lóbi ekoyâ","-1":"Lóbi elékí"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Ngonga","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Ngonga","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Monúti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Monúti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sɛkɔ́ndɛ","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sɛkɔ́ndɛ","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"ln-AO","parentLocale":"ln"},{"locale":"ln-CF","parentLocale":"ln"},{"locale":"ln-CG","parentLocale":"ln"},
    {"locale":"lo","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return (n == 1) ? 'one' : 'other';
      return 'other';
    },"fields":{"year":{"displayName":"ປີ","relative":{"0":"ປີນີ້","1":"ປີໜ້າ","-1":"ປີກາຍ"},"relativeTime":{"future":{"other":"ໃນອີກ {0} ປີ"},"past":{"other":"{0} ປີກ່ອນ"}}},"year-short":{"displayName":"ປີ","relative":{"0":"ປີນີ້","1":"ປີໜ້າ","-1":"ປີກາຍ"},"relativeTime":{"future":{"other":"ໃນອີກ {0} ປີ"},"past":{"other":"{0} ປີກ່ອນ"}}},"month":{"displayName":"ເດືອນ","relative":{"0":"ເດືອນນີ້","1":"ເດືອນໜ້າ","-1":"ເດືອນແລ້ວ"},"relativeTime":{"future":{"other":"ໃນອີກ {0} ເດືອນ"},"past":{"other":"{0} ເດືອນກ່ອນ"}}},"month-short":{"displayName":"ດ.","relative":{"0":"ເດືອນນີ້","1":"ເດືອນໜ້າ","-1":"ເດືອນແລ້ວ"},"relativeTime":{"future":{"other":"ໃນອີກ {0} ດ."},"past":{"other":"{0} ດ. ກ່ອນ"}}},"week":{"displayName":"ອາທິດ","relativePeriod":"ອາທິດທີ {0}","relative":{"0":"ອາທິດນີ້","1":"ອາທິດໜ້າ","-1":"ອາທິດແລ້ວ"},"relativeTime":{"future":{"other":"ໃນອີກ {0} ອາທິດ"},"past":{"other":"{0} ອາທິດກ່ອນ"}}},"week-short":{"displayName":"ອ.","relativePeriod":"ອາທິດທີ {0}","relative":{"0":"ອາທິດນີ້","1":"ອາທິດໜ້າ","-1":"ອາທິດແລ້ວ"},"relativeTime":{"future":{"other":"ໃນອີກ {0} ອທ."},"past":{"other":"{0} ອທ. ກ່ອນ"}}},"day":{"displayName":"ມື້","relative":{"0":"ມື້ນີ້","1":"ມື້ອື່ນ","2":"ມື້ຮື","-2":"ມື້ກ່ອນ","-1":"ມື້ວານ"},"relativeTime":{"future":{"other":"ໃນອີກ {0} ມື້"},"past":{"other":"{0} ມື້ກ່ອນ"}}},"day-short":{"displayName":"ມື້","relative":{"0":"ມື້ນີ້","1":"ມື້ອື່ນ","2":"ມື້ຮື","-2":"ມື້ກ່ອນ","-1":"ມື້ວານ"},"relativeTime":{"future":{"other":"ໃນອີກ {0} ມື້"},"past":{"other":"{0} ມື້ກ່ອນ"}}},"hour":{"displayName":"ຊົ່ວໂມງ","relative":{"0":"ຊົ່ວໂມງນີ້"},"relativeTime":{"future":{"other":"ໃນອີກ {0} ຊົ່ວໂມງ"},"past":{"other":"{0} ຊົ່ວໂມງກ່ອນ"}}},"hour-short":{"displayName":"ຊມ.","relative":{"0":"ຊົ່ວໂມງນີ້"},"relativeTime":{"future":{"other":"ໃນອີກ {0} ຊມ."},"past":{"other":"{0} ຊມ. ກ່ອນ"}}},"minute":{"displayName":"ນາທີ","relative":{"0":"ນາທີນີ້"},"relativeTime":{"future":{"other":"{0} ໃນອີກ 0 ນາທີ"},"past":{"other":"{0} ນາທີກ່ອນ"}}},"minute-short":{"displayName":"ນທ.","relative":{"0":"ນາທີນີ້"},"relativeTime":{"future":{"other":"ໃນ {0} ນທ."},"past":{"other":"{0} ນທ. ກ່ອນ"}}},"second":{"displayName":"ວິນາທີ","relative":{"0":"ຕອນນີ້"},"relativeTime":{"future":{"other":"ໃນອີກ {0} ວິນາທີ"},"past":{"other":"{0} ວິນາທີກ່ອນ"}}},"second-short":{"displayName":"ວິ.","relative":{"0":"ຕອນນີ້"},"relativeTime":{"future":{"other":"ໃນ {0} ວິ."},"past":{"other":"{0} ວິ. ກ່ອນ"}}}}},
    {"locale":"lrc","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"سال","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"سال","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"ما","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"ما","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"ھأفتە","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"ھأفتە","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"روٙز","relative":{"0":"أمروٙ","1":"شوٙصوٙ","-1":"دیروٙز"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"روٙز","relative":{"0":"أمروٙ","1":"شوٙصوٙ","-1":"دیروٙز"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"ساأت","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"ساأت","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"دئیقە","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"دئیقە","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"ثانیە","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"ثانیە","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"lrc-IQ","parentLocale":"lrc"},
    {"locale":"lt","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), f = s[1] || '', t0 = Number(s[0]) == n,
          n10 = t0 && s[0].slice(-1), n100 = t0 && s[0].slice(-2);
      if (ord) return 'other';
      return (n10 == 1 && (n100 < 11
              || n100 > 19)) ? 'one'
          : ((n10 >= 2 && n10 <= 9) && (n100 < 11
              || n100 > 19)) ? 'few'
          : (f != 0) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"metai","relative":{"0":"šiais metais","1":"kitais metais","-1":"praėjusiais metais"},"relativeTime":{"future":{"one":"po {0} metų","few":"po {0} metų","many":"po {0} metų","other":"po {0} metų"},"past":{"one":"prieš {0} metus","few":"prieš {0} metus","many":"prieš {0} metų","other":"prieš {0} metų"}}},"year-short":{"displayName":"m.","relative":{"0":"šiais metais","1":"kitais metais","-1":"praėjusiais metais"},"relativeTime":{"future":{"one":"po {0} m.","few":"po {0} m.","many":"po {0} m.","other":"po {0} m."},"past":{"one":"prieš {0} m.","few":"prieš {0} m.","many":"prieš {0} m.","other":"prieš {0} m."}}},"month":{"displayName":"mėnuo","relative":{"0":"šį mėnesį","1":"kitą mėnesį","-1":"praėjusį mėnesį"},"relativeTime":{"future":{"one":"po {0} mėnesio","few":"po {0} mėnesių","many":"po {0} mėnesio","other":"po {0} mėnesių"},"past":{"one":"prieš {0} mėnesį","few":"prieš {0} mėnesius","many":"prieš {0} mėnesio","other":"prieš {0} mėnesių"}}},"month-short":{"displayName":"mėn.","relative":{"0":"šį mėnesį","1":"kitą mėnesį","-1":"praėjusį mėnesį"},"relativeTime":{"future":{"one":"po {0} mėn.","few":"po {0} mėn.","many":"po {0} mėn.","other":"po {0} mėn."},"past":{"one":"prieš {0} mėn.","few":"prieš {0} mėn.","many":"prieš {0} mėn.","other":"prieš {0} mėn."}}},"week":{"displayName":"savaitė","relativePeriod":"{0} savaitę","relative":{"0":"šią savaitę","1":"kitą savaitę","-1":"praėjusią savaitę"},"relativeTime":{"future":{"one":"po {0} savaitės","few":"po {0} savaičių","many":"po {0} savaitės","other":"po {0} savaičių"},"past":{"one":"prieš {0} savaitę","few":"prieš {0} savaites","many":"prieš {0} savaitės","other":"prieš {0} savaičių"}}},"week-short":{"displayName":"sav.","relativePeriod":"{0} savaitę","relative":{"0":"šią savaitę","1":"kitą savaitę","-1":"praėjusią savaitę"},"relativeTime":{"future":{"one":"po {0} sav.","few":"po {0} sav.","many":"po {0} sav.","other":"po {0} sav."},"past":{"one":"prieš {0} sav.","few":"prieš {0} sav.","many":"prieš {0} sav.","other":"prieš {0} sav."}}},"day":{"displayName":"diena","relative":{"0":"šiandien","1":"rytoj","2":"poryt","-2":"užvakar","-1":"vakar"},"relativeTime":{"future":{"one":"po {0} dienos","few":"po {0} dienų","many":"po {0} dienos","other":"po {0} dienų"},"past":{"one":"prieš {0} dieną","few":"prieš {0} dienas","many":"prieš {0} dienos","other":"prieš {0} dienų"}}},"day-short":{"displayName":"d.","relative":{"0":"šiandien","1":"rytoj","2":"poryt","-2":"užvakar","-1":"vakar"},"relativeTime":{"future":{"one":"po {0} d.","few":"po {0} d.","many":"po {0} d.","other":"po {0} d."},"past":{"one":"prieš {0} d.","few":"prieš {0} d.","many":"prieš {0} d.","other":"prieš {0} d."}}},"hour":{"displayName":"valanda","relative":{"0":"šią valandą"},"relativeTime":{"future":{"one":"po {0} valandos","few":"po {0} valandų","many":"po {0} valandos","other":"po {0} valandų"},"past":{"one":"prieš {0} valandą","few":"prieš {0} valandas","many":"prieš {0} valandos","other":"prieš {0} valandų"}}},"hour-short":{"displayName":"val.","relative":{"0":"šią valandą"},"relativeTime":{"future":{"one":"po {0} val.","few":"po {0} val.","many":"po {0} val.","other":"po {0} val."},"past":{"one":"prieš {0} val.","few":"prieš {0} val.","many":"prieš {0} val.","other":"prieš {0} val."}}},"minute":{"displayName":"minutė","relative":{"0":"šią minutę"},"relativeTime":{"future":{"one":"po {0} minutės","few":"po {0} minučių","many":"po {0} minutės","other":"po {0} minučių"},"past":{"one":"prieš {0} minutę","few":"prieš {0} minutes","many":"prieš {0} minutės","other":"prieš {0} minučių"}}},"minute-short":{"displayName":"min.","relative":{"0":"šią minutę"},"relativeTime":{"future":{"one":"po {0} min.","few":"po {0} min.","many":"po {0} min.","other":"po {0} min."},"past":{"one":"prieš {0} min.","few":"prieš {0} min.","many":"prieš {0} min.","other":"prieš {0} min."}}},"second":{"displayName":"sekundė","relative":{"0":"dabar"},"relativeTime":{"future":{"one":"po {0} sekundės","few":"po {0} sekundžių","many":"po {0} sekundės","other":"po {0} sekundžių"},"past":{"one":"prieš {0} sekundę","few":"prieš {0} sekundes","many":"prieš {0} sekundės","other":"prieš {0} sekundžių"}}},"second-short":{"displayName":"sek.","relative":{"0":"dabar"},"relativeTime":{"future":{"one":"po {0} sek.","few":"po {0} sek.","many":"po {0} sek.","other":"po {0} sek."},"past":{"one":"prieš {0} sek.","few":"prieš {0} sek.","many":"prieš {0} sek.","other":"prieš {0} sek."}}}}},
    {"locale":"lu","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Tshidimu","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Tshidimu","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Ngondo","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Ngondo","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Lubingu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Lubingu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Dituku","relative":{"0":"Lelu","1":"Malaba","-1":"Makelela"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Dituku","relative":{"0":"Lelu","1":"Malaba","-1":"Makelela"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Diba","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Diba","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Kasunsu","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Kasunsu","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Kasunsukusu","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Kasunsukusu","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"luo","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"higa","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"higa","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"dwe","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"dwe","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"juma","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"juma","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"chieng’","relative":{"0":"kawuono","1":"kiny","-1":"nyoro"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"chieng’","relative":{"0":"kawuono","1":"kiny","-1":"nyoro"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"dakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"dakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"nyiriri mar saa","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"nyiriri mar saa","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"luy","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Muhiga","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Muhiga","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mweri","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mweri","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Risiza","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Risiza","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Ridiku","relative":{"0":"Lero","1":"Mgamba","-1":"Mgorova"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Ridiku","relative":{"0":"Lero","1":"Mgamba","-1":"Mgorova"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Isaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Isaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Idagika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Idagika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"lv","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), f = s[1] || '', v = f.length,
          t0 = Number(s[0]) == n, n10 = t0 && s[0].slice(-1),
          n100 = t0 && s[0].slice(-2), f100 = f.slice(-2), f10 = f.slice(-1);
      if (ord) return 'other';
      return (t0 && n10 == 0 || (n100 >= 11 && n100 <= 19)
              || v == 2 && (f100 >= 11 && f100 <= 19)) ? 'zero'
          : (n10 == 1 && n100 != 11 || v == 2 && f10 == 1 && f100 != 11
              || v != 2 && f10 == 1) ? 'one'
          : 'other';
    },"fields":{"year":{"displayName":"gads","relative":{"0":"šajā gadā","1":"nākamajā gadā","-1":"pagājušajā gadā"},"relativeTime":{"future":{"zero":"pēc {0} gadiem","one":"pēc {0} gada","other":"pēc {0} gadiem"},"past":{"zero":"pirms {0} gadiem","one":"pirms {0} gada","other":"pirms {0} gadiem"}}},"year-short":{"displayName":"g.","relative":{"0":"šajā gadā","1":"nākamajā gadā","-1":"pagājušajā gadā"},"relativeTime":{"future":{"zero":"pēc {0} g.","one":"pēc {0} g.","other":"pēc {0} g."},"past":{"zero":"pirms {0} g.","one":"pirms {0} g.","other":"pirms {0} g."}}},"month":{"displayName":"mēnesis","relative":{"0":"šajā mēnesī","1":"nākamajā mēnesī","-1":"pagājušajā mēnesī"},"relativeTime":{"future":{"zero":"pēc {0} mēnešiem","one":"pēc {0} mēneša","other":"pēc {0} mēnešiem"},"past":{"zero":"pirms {0} mēnešiem","one":"pirms {0} mēneša","other":"pirms {0} mēnešiem"}}},"month-short":{"displayName":"mēn.","relative":{"0":"šajā mēnesī","1":"nākamajā mēnesī","-1":"pagājušajā mēnesī"},"relativeTime":{"future":{"zero":"pēc {0} mēn.","one":"pēc {0} mēn.","other":"pēc {0} mēn."},"past":{"zero":"pirms {0} mēn.","one":"pirms {0} mēn.","other":"pirms {0} mēn."}}},"week":{"displayName":"nedēļa","relativePeriod":"{0}. nedēļa","relative":{"0":"šajā nedēļā","1":"nākamajā nedēļā","-1":"pagājušajā nedēļā"},"relativeTime":{"future":{"zero":"pēc {0} nedēļām","one":"pēc {0} nedēļas","other":"pēc {0} nedēļām"},"past":{"zero":"pirms {0} nedēļām","one":"pirms {0} nedēļas","other":"pirms {0} nedēļām"}}},"week-short":{"displayName":"ned.","relativePeriod":"{0}. ned.","relative":{"0":"šajā nedēļā","1":"nākamajā nedēļā","-1":"pagājušajā nedēļā"},"relativeTime":{"future":{"zero":"pēc {0} ned.","one":"pēc {0} ned.","other":"pēc {0} ned."},"past":{"zero":"pirms {0} ned.","one":"pirms {0} ned.","other":"pirms {0} ned."}}},"day":{"displayName":"diena","relative":{"0":"šodien","1":"rīt","2":"parīt","-2":"aizvakar","-1":"vakar"},"relativeTime":{"future":{"zero":"pēc {0} dienām","one":"pēc {0} dienas","other":"pēc {0} dienām"},"past":{"zero":"pirms {0} dienām","one":"pirms {0} dienas","other":"pirms {0} dienām"}}},"day-short":{"displayName":"d.","relative":{"0":"šodien","1":"rīt","2":"parīt","-2":"aizvakar","-1":"vakar"},"relativeTime":{"future":{"zero":"pēc {0} d.","one":"pēc {0} d.","other":"pēc {0} d."},"past":{"zero":"pirms {0} d.","one":"pirms {0} d.","other":"pirms {0} d."}}},"hour":{"displayName":"stundas","relative":{"0":"šajā stundā"},"relativeTime":{"future":{"zero":"pēc {0} stundām","one":"pēc {0} stundas","other":"pēc {0} stundām"},"past":{"zero":"pirms {0} stundām","one":"pirms {0} stundas","other":"pirms {0} stundām"}}},"hour-short":{"displayName":"st.","relative":{"0":"šajā stundā"},"relativeTime":{"future":{"zero":"pēc {0} st.","one":"pēc {0} st.","other":"pēc {0} st."},"past":{"zero":"pirms {0} st.","one":"pirms {0} st.","other":"pirms {0} st."}}},"minute":{"displayName":"minūtes","relative":{"0":"šajā minūtē"},"relativeTime":{"future":{"zero":"pēc {0} minūtēm","one":"pēc {0} minūtes","other":"pēc {0} minūtēm"},"past":{"zero":"pirms {0} minūtēm","one":"pirms {0} minūtes","other":"pirms {0} minūtēm"}}},"minute-short":{"displayName":"min.","relative":{"0":"šajā minūtē"},"relativeTime":{"future":{"zero":"pēc {0} min.","one":"pēc {0} min.","other":"pēc {0} min."},"past":{"zero":"pirms {0} min.","one":"pirms {0} min.","other":"pirms {0} min."}}},"second":{"displayName":"sekundes","relative":{"0":"tagad"},"relativeTime":{"future":{"zero":"pēc {0} sekundēm","one":"pēc {0} sekundes","other":"pēc {0} sekundēm"},"past":{"zero":"pirms {0} sekundēm","one":"pirms {0} sekundes","other":"pirms {0} sekundēm"}}},"second-short":{"displayName":"sek.","relative":{"0":"tagad"},"relativeTime":{"future":{"zero":"pēc {0} sek.","one":"pēc {0} sek.","other":"pēc {0} sek."},"past":{"zero":"pirms {0} sek.","one":"pirms {0} sek.","other":"pirms {0} sek."}}}}},
    {"locale":"mas","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Ɔlárì","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Ɔlárì","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Ɔlápà","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Ɔlápà","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Ewíkî","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Ewíkî","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Ɛnkɔlɔ́ŋ","relative":{"0":"Táatá","1":"Tááisérè","-1":"Ŋolé"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Ɛnkɔlɔ́ŋ","relative":{"0":"Táatá","1":"Tááisérè","-1":"Ŋolé"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Ɛ́sáâ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Ɛ́sáâ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Oldákikaè","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Oldákikaè","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"mas-TZ","parentLocale":"mas"},
    {"locale":"mer","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Mwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mweri","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mweri","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Kiumia","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Kiumia","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Ntukũ","relative":{"0":"Narua","1":"Rũjũ","-1":"Ĩgoro"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Ntukũ","relative":{"0":"Narua","1":"Rũjũ","-1":"Ĩgoro"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Ĩthaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Ĩthaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Ndagika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Ndagika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekondi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekondi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"mfe","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Lane","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Lane","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mwa","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mwa","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Semenn","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Semenn","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Zour","relative":{"0":"Zordi","1":"Demin","-1":"Yer"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Zour","relative":{"0":"Zordi","1":"Demin","-1":"Yer"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Ler","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Ler","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minit","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minit","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Segonn","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Segonn","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"mg","pluralRuleFunction":function(n
    ) {
      return ((n == 0
              || n == 1)) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Taona","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Taona","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Volana","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Volana","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Herinandro","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Herinandro","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Andro","relative":{"0":"Anio","1":"Rahampitso","-1":"Omaly"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Andro","relative":{"0":"Anio","1":"Rahampitso","-1":"Omaly"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Ora","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Ora","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minitra","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minitra","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Segondra","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Segondra","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"mgh","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"yaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"yaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"mweri","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"mweri","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"iwiki mocha","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"iwiki mocha","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"nihuku","relative":{"0":"lel’lo","1":"me’llo","-1":"n’chana"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"nihuku","relative":{"0":"lel’lo","1":"me’llo","-1":"n’chana"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"isaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"isaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"idakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"idakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"isekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"isekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"mgo","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"fituʼ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"fituʼ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"iməg","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"+{0} m","other":"+{0} m"},"past":{"one":"-{0} m","other":"-{0} m"}}},"month-short":{"displayName":"iməg","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"+{0} m","other":"+{0} m"},"past":{"one":"-{0} m","other":"-{0} m"}}},"week":{"displayName":"nkap","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"nkap","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"anəg","relative":{"0":"tèchɔ̀ŋ","1":"isu","2":"isu ywi","-1":"ikwiri"},"relativeTime":{"future":{"one":"+{0} d","other":"+{0} d"},"past":{"one":"-{0} d","other":"-{0} d"}}},"day-short":{"displayName":"anəg","relative":{"0":"tèchɔ̀ŋ","1":"isu","2":"isu ywi","-1":"ikwiri"},"relativeTime":{"future":{"one":"+{0} d","other":"+{0} d"},"past":{"one":"-{0} d","other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"+{0} h","other":"+{0} h"},"past":{"one":"-{0} h","other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"+{0} h","other":"+{0} h"},"past":{"one":"-{0} h","other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"+{0} min","other":"+{0} min"},"past":{"one":"-{0} min","other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"+{0} min","other":"+{0} min"},"past":{"one":"-{0} min","other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"one":"+{0} s","other":"+{0} s"},"past":{"one":"-{0} s","other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"one":"+{0} s","other":"+{0} s"},"past":{"one":"-{0} s","other":"-{0} s"}}}}},
    {"locale":"mi","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"tau","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"t","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"marama","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"m","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"wiki","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"w","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"rā","relative":{"0":"āianei","1":"āpōpō","-1":"inanahi"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"rā","relative":{"0":"āianei","1":"āpōpō","-1":"inanahi"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"hāora","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"hr","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"meneti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"men","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"hēkona","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"hēk","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"mk","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], f = s[1] || '', v0 = !s[1],
          i10 = i.slice(-1), i100 = i.slice(-2), f10 = f.slice(-1), f100 = f.slice(-2);
      if (ord) return (i10 == 1 && i100 != 11) ? 'one'
          : (i10 == 2 && i100 != 12) ? 'two'
          : ((i10 == 7
              || i10 == 8) && i100 != 17 && i100 != 18) ? 'many'
          : 'other';
      return (v0 && i10 == 1 && i100 != 11
              || f10 == 1 && f100 != 11) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"година","relative":{"0":"оваа година","1":"следната година","-1":"минатата година"},"relativeTime":{"future":{"one":"за {0} година","other":"за {0} години"},"past":{"one":"пред {0} година","other":"пред {0} години"}}},"year-short":{"displayName":"год.","relative":{"0":"оваа година","1":"следната година","-1":"минатата година"},"relativeTime":{"future":{"one":"за {0} год.","other":"за {0} год."},"past":{"one":"пред {0} год.","other":"пред {0} год."}}},"month":{"displayName":"месец","relative":{"0":"овој месец","1":"следниот месец","-1":"минатиот месец"},"relativeTime":{"future":{"one":"за {0} месец","other":"за {0} месеци"},"past":{"one":"пред {0} месец","other":"пред {0} месеци"}}},"month-short":{"displayName":"мес.","relative":{"0":"овој месец","1":"следниот месец","-1":"минатиот месец"},"relativeTime":{"future":{"one":"за {0} месец","other":"за {0} месеци"},"past":{"one":"пред {0} месец","other":"пред {0} месеци"}}},"week":{"displayName":"седмица","relativePeriod":"{0} седмица","relative":{"0":"оваа седмица","1":"следната седмица","-1":"минатата седмица"},"relativeTime":{"future":{"one":"за {0} седмица","other":"за {0} седмици"},"past":{"one":"пред {0} седмица","other":"пред {0} седмици"}}},"week-short":{"displayName":"сед.","relativePeriod":"{0} седмица","relative":{"0":"оваа седмица","1":"следната седмица","-1":"минатата седмица"},"relativeTime":{"future":{"one":"за {0} седмица","other":"за {0} седмици"},"past":{"one":"пред {0} седмица","other":"пред {0} седмици"}}},"day":{"displayName":"ден","relative":{"0":"денес","1":"утре","2":"задутре","-2":"завчера","-1":"вчера"},"relativeTime":{"future":{"one":"за {0} ден","other":"за {0} дена"},"past":{"one":"пред {0} ден","other":"пред {0} дена"}}},"day-short":{"displayName":"ден","relative":{"0":"денес","1":"утре","2":"задутре","-2":"завчера","-1":"вчера"},"relativeTime":{"future":{"one":"за {0} ден","other":"за {0} дена"},"past":{"one":"пред {0} ден","other":"пред {0} дена"}}},"hour":{"displayName":"час","relative":{"0":"часов"},"relativeTime":{"future":{"one":"за {0} час","other":"за {0} часа"},"past":{"one":"пред {0} час","other":"пред {0} часа"}}},"hour-short":{"displayName":"ч.","relative":{"0":"часов"},"relativeTime":{"future":{"one":"за {0} час","other":"за {0} часа"},"past":{"one":"пред {0} час","other":"пред {0} часа"}}},"minute":{"displayName":"минута","relative":{"0":"оваа минута"},"relativeTime":{"future":{"one":"за {0} минута","other":"за {0} минути"},"past":{"one":"пред {0} минута","other":"пред {0} минути"}}},"minute-short":{"displayName":"мин.","relative":{"0":"оваа минута"},"relativeTime":{"future":{"one":"за {0} мин.","other":"за {0} мин."},"past":{"one":"пред {0} мин.","other":"пред {0} мин."}}},"second":{"displayName":"секунда","relative":{"0":"сега"},"relativeTime":{"future":{"one":"за {0} секунда","other":"за {0} секунди"},"past":{"one":"пред {0} секунда","other":"пред {0} секунди"}}},"second-short":{"displayName":"сек.","relative":{"0":"сега"},"relativeTime":{"future":{"one":"за {0} сек.","other":"за {0} сек."},"past":{"one":"пред {0} сек.","other":"пред {0} сек."}}}}},
    {"locale":"ml","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"വർഷം","relative":{"0":"ഈ വർ‌ഷം","1":"അടുത്തവർഷം","-1":"കഴിഞ്ഞ വർഷം"},"relativeTime":{"future":{"one":"{0} വർഷത്തിൽ","other":"{0} വർഷത്തിൽ"},"past":{"one":"{0} വർഷം മുമ്പ്","other":"{0} വർഷം മുമ്പ്"}}},"year-short":{"displayName":"വ.","relative":{"0":"ഈ വർ‌ഷം","1":"അടുത്തവർഷം","-1":"കഴിഞ്ഞ വർഷം"},"relativeTime":{"future":{"one":"{0} വർഷത്തിൽ","other":"{0} വർഷത്തിൽ"},"past":{"one":"{0} വർഷം മുമ്പ്","other":"{0} വർഷം മുമ്പ്"}}},"month":{"displayName":"മാസം","relative":{"0":"ഈ മാസം","1":"അടുത്ത മാസം","-1":"കഴിഞ്ഞ മാസം"},"relativeTime":{"future":{"one":"{0} മാസത്തിൽ","other":"{0} മാസത്തിൽ"},"past":{"one":"{0} മാസം മുമ്പ്","other":"{0} മാസം മുമ്പ്"}}},"month-short":{"displayName":"മാ.","relative":{"0":"ഈ മാസം","1":"അടുത്ത മാസം","-1":"കഴിഞ്ഞ മാസം"},"relativeTime":{"future":{"one":"{0} മാസത്തിൽ","other":"{0} മാസത്തിൽ"},"past":{"one":"{0} മാസം മുമ്പ്","other":"{0} മാസം മുമ്പ്"}}},"week":{"displayName":"ആഴ്ച","relativePeriod":"{0} വരുന്ന ആഴ്ച","relative":{"0":"ഈ ആഴ്ച","1":"അടുത്ത ആഴ്ച","-1":"കഴിഞ്ഞ ആഴ്‌ച"},"relativeTime":{"future":{"one":"{0} ആഴ്ചയിൽ","other":"{0} ആഴ്ചയിൽ"},"past":{"one":"{0} ആഴ്ച മുമ്പ്","other":"{0} ആഴ്ച മുമ്പ്"}}},"week-short":{"displayName":"ആ.","relativePeriod":"{0} വരുന്ന ആഴ്ച","relative":{"0":"ഈ ആഴ്ച","1":"അടുത്ത ആഴ്ച","-1":"കഴിഞ്ഞ ആഴ്‌ച"},"relativeTime":{"future":{"one":"{0} ആഴ്ചയിൽ","other":"{0} ആഴ്ചയിൽ"},"past":{"one":"{0} ആഴ്ച മുമ്പ്","other":"{0} ആഴ്ച മുമ്പ്"}}},"day":{"displayName":"ദിവസം","relative":{"0":"ഇന്ന്","1":"നാളെ","2":"മറ്റന്നാൾ","-2":"മിനിഞ്ഞാന്ന്","-1":"ഇന്നലെ"},"relativeTime":{"future":{"one":"{0} ദിവസത്തിൽ","other":"{0} ദിവസത്തിൽ"},"past":{"one":"{0} ദിവസം മുമ്പ്","other":"{0} ദിവസം മുമ്പ്"}}},"day-short":{"displayName":"ദിവസം","relative":{"0":"ഇന്ന്","1":"നാളെ","2":"മറ്റന്നാൾ","-2":"മിനിഞ്ഞാന്ന്","-1":"ഇന്നലെ"},"relativeTime":{"future":{"one":"{0} ദിവസത്തിൽ","other":"{0} ദിവസത്തിൽ"},"past":{"one":"{0} ദിവസം മുമ്പ്","other":"{0} ദിവസം മുമ്പ്"}}},"hour":{"displayName":"മണിക്കൂർ","relative":{"0":"ഈ മണിക്കൂറിൽ"},"relativeTime":{"future":{"one":"{0} മണിക്കൂറിൽ","other":"{0} മണിക്കൂറിൽ"},"past":{"one":"{0} മണിക്കൂർ മുമ്പ്","other":"{0} മണിക്കൂർ മുമ്പ്"}}},"hour-short":{"displayName":"മ.","relative":{"0":"ഈ മണിക്കൂറിൽ"},"relativeTime":{"future":{"one":"{0} മണിക്കൂറിൽ","other":"{0} മണിക്കൂറിൽ"},"past":{"one":"{0} മണിക്കൂർ മുമ്പ്","other":"{0} മണിക്കൂർ മുമ്പ്"}}},"minute":{"displayName":"മിനിറ്റ്","relative":{"0":"ഈ മിനിറ്റിൽ"},"relativeTime":{"future":{"one":"{0} മിനിറ്റിൽ","other":"{0} മിനിറ്റിൽ"},"past":{"one":"{0} മിനിറ്റ് മുമ്പ്","other":"{0} മിനിറ്റ് മുമ്പ്"}}},"minute-short":{"displayName":"മി.","relative":{"0":"ഈ മിനിറ്റിൽ"},"relativeTime":{"future":{"one":"{0} മിനിറ്റിൽ","other":"{0} മിനിറ്റിൽ"},"past":{"one":"{0} മിനിറ്റ് മുമ്പ്","other":"{0} മിനിറ്റ് മുമ്പ്"}}},"second":{"displayName":"സെക്കൻഡ്","relative":{"0":"ഇപ്പോൾ"},"relativeTime":{"future":{"one":"{0} സെക്കൻഡിൽ","other":"{0} സെക്കൻഡിൽ"},"past":{"one":"{0} സെക്കൻഡ് മുമ്പ്","other":"{0} സെക്കൻഡ് മുമ്പ്"}}},"second-short":{"displayName":"സെ.","relative":{"0":"ഇപ്പോൾ"},"relativeTime":{"future":{"one":"{0} സെക്കൻഡിൽ","other":"{0} സെക്കൻഡിൽ"},"past":{"one":"{0} സെക്കൻഡ് മുമ്പ്","other":"{0} സെക്കൻഡ് മുമ്പ്"}}}}},
    {"locale":"mn","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"жил","relative":{"0":"энэ жил","1":"ирэх жил","-1":"өнгөрсөн жил"},"relativeTime":{"future":{"one":"{0} жилийн дараа","other":"{0} жилийн дараа"},"past":{"one":"{0} жилийн өмнө","other":"{0} жилийн өмнө"}}},"year-short":{"displayName":"жил","relative":{"0":"энэ жил","1":"ирэх жил","-1":"өнгөрсөн жил"},"relativeTime":{"future":{"one":"{0} жилийн дараа","other":"{0} жилийн дараа"},"past":{"one":"{0} жилийн өмнө","other":"{0} жилийн өмнө"}}},"month":{"displayName":"сар","relative":{"0":"энэ сар","1":"ирэх сар","-1":"өнгөрсөн сар"},"relativeTime":{"future":{"one":"{0} сарын дараа","other":"{0} сарын дараа"},"past":{"one":"{0} сарын өмнө","other":"{0} сарын өмнө"}}},"month-short":{"displayName":"сар","relative":{"0":"энэ сар","1":"ирэх сар","-1":"өнгөрсөн сар"},"relativeTime":{"future":{"one":"{0} сарын дараа","other":"{0} сарын дараа"},"past":{"one":"{0} сарын өмнө","other":"{0} сарын өмнө"}}},"week":{"displayName":"долоо хоног","relativePeriod":"{0}-н долоо хоног","relative":{"0":"энэ долоо хоног","1":"ирэх долоо хоног","-1":"өнгөрсөн долоо хоног"},"relativeTime":{"future":{"one":"{0} долоо хоногийн дараа","other":"{0} долоо хоногийн дараа"},"past":{"one":"{0} долоо хоногийн өмнө","other":"{0} долоо хоногийн өмнө"}}},"week-short":{"displayName":"7 хоног","relativePeriod":"{0}-н 7 хоног","relative":{"0":"энэ долоо хоног","1":"ирэх долоо хоног","-1":"өнгөрсөн долоо хоног"},"relativeTime":{"future":{"one":"{0} 7 хоногийн дараа","other":"{0} 7 хоногийн дараа"},"past":{"one":"{0} 7 хоногийн өмнө","other":"{0} 7 хоногийн өмнө"}}},"day":{"displayName":"өдөр","relative":{"0":"өнөөдөр","1":"маргааш","2":"нөгөөдөр","-2":"уржигдар","-1":"өчигдөр"},"relativeTime":{"future":{"one":"{0} өдрийн дараа","other":"{0} өдрийн дараа"},"past":{"one":"{0} өдрийн өмнө","other":"{0} өдрийн өмнө"}}},"day-short":{"displayName":"өдөр","relative":{"0":"өнөөдөр","1":"маргааш","2":"нөгөөдөр","-2":"уржигдар","-1":"өчигдөр"},"relativeTime":{"future":{"one":"{0} өдрийн дараа","other":"{0} өдрийн дараа"},"past":{"one":"{0} өдрийн өмнө","other":"{0} өдрийн өмнө"}}},"hour":{"displayName":"цаг","relative":{"0":"энэ цаг"},"relativeTime":{"future":{"one":"{0} цагийн дараа","other":"{0} цагийн дараа"},"past":{"one":"{0} цагийн өмнө","other":"{0} цагийн өмнө"}}},"hour-short":{"displayName":"ц","relative":{"0":"энэ цаг"},"relativeTime":{"future":{"one":"{0} ц дараа","other":"{0} ц дараа"},"past":{"one":"{0} ц өмнө","other":"{0} ц өмнө"}}},"minute":{"displayName":"минут","relative":{"0":"энэ минут"},"relativeTime":{"future":{"one":"{0} минутын дараа","other":"{0} минутын дараа"},"past":{"one":"{0} минутын өмнө","other":"{0} минутын өмнө"}}},"minute-short":{"displayName":"мин","relative":{"0":"энэ минут"},"relativeTime":{"future":{"one":"{0} мин дараа","other":"{0} мин дараа"},"past":{"one":"{0} мин өмнө","other":"{0} мин өмнө"}}},"second":{"displayName":"секунд","relative":{"0":"одоо"},"relativeTime":{"future":{"one":"{0} секундын дараа","other":"{0} секундын дараа"},"past":{"one":"{0} секундын өмнө","other":"{0} секундын өмнө"}}},"second-short":{"displayName":"сек","relative":{"0":"одоо"},"relativeTime":{"future":{"one":"{0} сек дараа","other":"{0} сек дараа"},"past":{"one":"{0} сек өмнө","other":"{0} сек өмнө"}}}}},{"locale":"mn-Mong","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"mo","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1], t0 = Number(s[0]) == n,
          n100 = t0 && s[0].slice(-2);
      if (ord) return (n == 1) ? 'one' : 'other';
      return (n == 1 && v0) ? 'one'
          : (!v0 || n == 0
              || n != 1 && (n100 >= 1 && n100 <= 19)) ? 'few'
          : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"mr","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return (n == 1) ? 'one'
          : ((n == 2
              || n == 3)) ? 'two'
          : (n == 4) ? 'few'
          : 'other';
      return (n >= 0 && n <= 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"वर्ष","relative":{"0":"हे वर्ष","1":"पुढील वर्ष","-1":"मागील वर्ष"},"relativeTime":{"future":{"one":"येत्या {0} वर्षामध्ये","other":"येत्या {0} वर्षांमध्ये"},"past":{"one":"{0} वर्षापूर्वी","other":"{0} वर्षांपूर्वी"}}},"year-short":{"displayName":"वर्ष","relative":{"0":"हे वर्ष","1":"पुढील वर्ष","-1":"मागील वर्ष"},"relativeTime":{"future":{"one":"{0} वर्षामध्ये","other":"{0} वर्षांमध्ये"},"past":{"one":"{0} वर्षापूर्वी","other":"{0} वर्षांपूर्वी"}}},"month":{"displayName":"महिना","relative":{"0":"हा महिना","1":"पुढील महिना","-1":"मागील महिना"},"relativeTime":{"future":{"one":"येत्या {0} महिन्यामध्ये","other":"येत्या {0} महिन्यांमध्ये"},"past":{"one":"{0} महिन्यापूर्वी","other":"{0} महिन्यांपूर्वी"}}},"month-short":{"displayName":"महिना","relative":{"0":"हा महिना","1":"पुढील महिना","-1":"मागील महिना"},"relativeTime":{"future":{"one":"{0} महिन्यामध्ये","other":"{0} महिन्यामध्ये"},"past":{"one":"{0} महिन्यापूर्वी","other":"{0} महिन्यांपूर्वी"}}},"week":{"displayName":"आठवडा","relativePeriod":"{0} चा आठवडा","relative":{"0":"हा आठवडा","1":"पुढील आठवडा","-1":"मागील आठवडा"},"relativeTime":{"future":{"one":"{0} आठवड्यामध्ये","other":"{0} आठवड्यांमध्ये"},"past":{"one":"{0} आठवड्यापूर्वी","other":"{0} आठवड्यांपूर्वी"}}},"week-short":{"displayName":"आठवडा","relativePeriod":"{0} चा आठवडा","relative":{"0":"हा आठवडा","1":"पुढील आठवडा","-1":"मागील आठवडा"},"relativeTime":{"future":{"one":"येत्या {0} आठवड्यामध्ये","other":"येत्या {0} आठवड्यांमध्ये"},"past":{"one":"{0} आठवड्यापूर्वी","other":"{0} आठवड्यांपूर्वी"}}},"day":{"displayName":"दिवस","relative":{"0":"आज","1":"उद्या","-1":"काल"},"relativeTime":{"future":{"one":"येत्या {0} दिवसामध्ये","other":"येत्या {0} दिवसांमध्ये"},"past":{"one":"{0} दिवसापूर्वी","other":"{0} दिवसांपूर्वी"}}},"day-short":{"displayName":"दिवस","relative":{"0":"आज","1":"उद्या","-1":"काल"},"relativeTime":{"future":{"one":"{0} दिवसामध्ये","other":"येत्या {0} दिवसांमध्ये"},"past":{"one":"{0} दिवसापूर्वी","other":"{0} दिवसांपूर्वी"}}},"hour":{"displayName":"तास","relative":{"0":"तासात"},"relativeTime":{"future":{"one":"{0} तासामध्ये","other":"{0} तासांमध्ये"},"past":{"one":"{0} तासापूर्वी","other":"{0} तासांपूर्वी"}}},"hour-short":{"displayName":"तास","relative":{"0":"तासात"},"relativeTime":{"future":{"one":"{0} तासामध्ये","other":"{0} तासांमध्ये"},"past":{"one":"{0} तासापूर्वी","other":"{0} तासांपूर्वी"}}},"minute":{"displayName":"मिनिट","relative":{"0":"या मिनिटात"},"relativeTime":{"future":{"one":"{0} मिनिटामध्ये","other":"{0} मिनिटांमध्ये"},"past":{"one":"{0} मिनिटापूर्वी","other":"{0} मिनिटांपूर्वी"}}},"minute-short":{"displayName":"मि.","relative":{"0":"या मिनिटात"},"relativeTime":{"future":{"one":"{0} मिनि. मध्ये","other":"{0} मिनि. मध्ये"},"past":{"one":"{0} मिनि. पूर्वी","other":"{0} मिनि. पूर्वी"}}},"second":{"displayName":"सेकंद","relative":{"0":"आत्ता"},"relativeTime":{"future":{"one":"{0} सेकंदामध्ये","other":"{0} सेकंदांमध्ये"},"past":{"one":"{0} सेकंदापूर्वी","other":"{0} सेकंदांपूर्वी"}}},"second-short":{"displayName":"से.","relative":{"0":"आत्ता"},"relativeTime":{"future":{"one":"{0} से. मध्ये","other":"{0} से. मध्ये"},"past":{"one":"{0} से. पूर्वी","other":"{0} से. पूर्वी"}}}}},
    {"locale":"ms","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return (n == 1) ? 'one' : 'other';
      return 'other';
    },"fields":{"year":{"displayName":"tahun","relative":{"0":"tahun ini","1":"tahun depan","-1":"tahun lalu"},"relativeTime":{"future":{"other":"dalam {0} tahun"},"past":{"other":"{0} tahun lalu"}}},"year-short":{"displayName":"thn","relative":{"0":"thn ini","1":"thn depan","-1":"thn lepas"},"relativeTime":{"future":{"other":"dalam {0} thn"},"past":{"other":"{0} thn lalu"}}},"month":{"displayName":"bulan","relative":{"0":"bulan ini","1":"bulan depan","-1":"bulan lalu"},"relativeTime":{"future":{"other":"dalam {0} bulan"},"past":{"other":"{0} bulan lalu"}}},"month-short":{"displayName":"bln","relative":{"0":"bln ini","1":"bln depan","-1":"bln lalu"},"relativeTime":{"future":{"other":"dlm {0} bln"},"past":{"other":"{0} bln lalu"}}},"week":{"displayName":"minggu","relativePeriod":"minggu ke-{0}","relative":{"0":"minggu ini","1":"minggu depan","-1":"minggu lalu"},"relativeTime":{"future":{"other":"dalam {0} minggu"},"past":{"other":"{0} minggu lalu"}}},"week-short":{"displayName":"mgu","relativePeriod":"minggu ke-{0}","relative":{"0":"mng ini","1":"mng depan","-1":"mng lepas"},"relativeTime":{"future":{"other":"dlm {0} mgu"},"past":{"other":"{0} mgu lalu"}}},"day":{"displayName":"hari","relative":{"0":"hari ini","1":"esok","2":"lusa","-2":"kelmarin","-1":"semalam"},"relativeTime":{"future":{"other":"dalam {0} hari"},"past":{"other":"{0} hari lalu"}}},"day-short":{"displayName":"hari","relative":{"0":"hari ini","1":"esok","2":"lusa","-2":"kelmarin","-1":"semlm"},"relativeTime":{"future":{"other":"dlm {0} hari"},"past":{"other":"{0} hari lalu"}}},"hour":{"displayName":"jam","relative":{"0":"jam ini"},"relativeTime":{"future":{"other":"dalam {0} jam"},"past":{"other":"{0} jam lalu"}}},"hour-short":{"displayName":"jam","relative":{"0":"jam ini"},"relativeTime":{"future":{"other":"dlm {0} jam"},"past":{"other":"{0} jam lalu"}}},"minute":{"displayName":"minit","relative":{"0":"pada minit ini"},"relativeTime":{"future":{"other":"dalam {0} minit"},"past":{"other":"{0} minit lalu"}}},"minute-short":{"displayName":"min","relative":{"0":"pada minit ini"},"relativeTime":{"future":{"other":"dlm {0} min"},"past":{"other":"{0} min lalu"}}},"second":{"displayName":"saat","relative":{"0":"sekarang"},"relativeTime":{"future":{"other":"dalam {0} saat"},"past":{"other":"{0} saat lalu"}}},"second-short":{"displayName":"saat","relative":{"0":"sekarang"},"relativeTime":{"future":{"other":"dlm {0} saat"},"past":{"other":"{0} saat lalu"}}}}},{"locale":"ms-Arab","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"ms-BN","parentLocale":"ms"},{"locale":"ms-SG","parentLocale":"ms"},
    {"locale":"mt","pluralRuleFunction":function(n
    ) {
      var s = String(n).split('.'), t0 = Number(s[0]) == n,
          n100 = t0 && s[0].slice(-2);
      return (n == 1) ? 'one'
          : (n == 0
              || (n100 >= 2 && n100 <= 10)) ? 'few'
          : ((n100 >= 11 && n100 <= 19)) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"Sena","relative":{"0":"din is-sena","1":"is-sena d-dieħla","-1":"is-sena l-oħra"},"relativeTime":{"future":{"one":"fi żmien sena","few":"fi żmien {0} snin oħra","many":"fi żmien {0} snin oħra","other":"fi żmien {0} snin oħra"},"past":{"one":"sena ilu","few":"{0} snin ilu","many":"{0} snin ilu","other":"{0} snin ilu"}}},"year-short":{"displayName":"Sena","relative":{"0":"din is-sena","1":"is-sena d-dieħla","-1":"is-sena l-oħra"},"relativeTime":{"future":{"one":"fi żmien sena","few":"fi żmien {0} snin oħra","many":"fi żmien {0} snin oħra","other":"fi żmien {0} snin oħra"},"past":{"one":"sa sena ilu","few":"{0} snin ilu","many":"{0} snin ilu","other":"{0} snin ilu"}}},"month":{"displayName":"xahar","relative":{"0":"Dan ix-xahar","1":"Ix-xahar id-dieħel","-1":"Ix-xahar li għadda"},"relativeTime":{"future":{"one":"sa xahar ieħor","few":"fi {0} xhur oħra","many":"fi {0} xhur oħra","other":"fi {0} xhur oħra"},"past":{"one":"xahar ilu","few":"{0} xhur ilu","many":"{0} xhur ilu","other":"{0} xhur ilu"}}},"month-short":{"displayName":"Xahar","relative":{"0":"Dan ix-xahar","1":"Ix-xahar id-dieħel","-1":"Ix-xahar li għadda"},"relativeTime":{"future":{"one":"sa xahar ieħor","few":"sa {0} xhur oħra","many":"sa {0} xhur oħra","other":"sa {0} xhur oħra"},"past":{"one":"{0} xahar ilu","few":"{0} xhur ilu","many":"{0} xhur ilu","other":"{0} xhur ilu"}}},"week":{"displayName":"ġimgħa","relativePeriod":"fil-ġimgħa ta’ {0}","relative":{"0":"din il-ġimgħa","1":"il-ġimgħa d-dieħla","-1":"il-ġimgħa li għaddiet"},"relativeTime":{"future":{"one":"sa ġimgħa oħra","few":"sa {0} ġimgħat oħra","many":"sa {0} ġimgħat oħra","other":"sa {0} ġimgħat oħra"},"past":{"one":"ġimgħa ilu","few":"{0} ġimgħat ilu","many":"{0} ġimgħat ilu","other":"{0} ġimgħat ilu"}}},"week-short":{"displayName":"ġimgħa","relativePeriod":"fil-ġimgħa ta’ {0}","relative":{"0":"din il-ġimgħa","1":"il-ġimgħa d-dieħla","-1":"il-ġimgħa li għaddiet"},"relativeTime":{"future":{"one":"sa ġimgħa oħra","few":"sa {0} ġimgħat oħra","many":"sa {0} ġimgħat oħra","other":"+{0} w"},"past":{"one":"ġimgħa ilu","few":"{0} ġimgħat ilu","many":"{0} ġimgħat ilu","other":"{0} ġimgħat ilu"}}},"day":{"displayName":"jum","relative":{"0":"illum","1":"għada","-1":"lbieraħ"},"relativeTime":{"future":{"one":"fi żmien ġurnata","few":"fi żmien {0} ġurnata oħra","many":"fi żmien {0} ġurnata oħra","other":"fi żmien {0} ġurnata oħra"},"past":{"one":"ġurnata ilu","few":"{0} ġranet ilu","many":"{0}-il ġurnata ilu","other":"{0}-il ġurnata ilu"}}},"day-short":{"displayName":"Jum","relative":{"0":"illum","1":"għada","-1":"lbieraħ"},"relativeTime":{"future":{"one":"fi żmien ġurnata","few":"fi żmien {0} ġurnata oħra","many":"fi żmien {0} ġurnata oħra","other":"fi żmien {0} ġurnata oħra"},"past":{"one":"ġurnata ilu","few":"{0} ġranet ilu","many":"{0}-il ġurnata ilu","other":"{0}-il ġurnata ilu"}}},"hour":{"displayName":"siegħa","relative":{"0":"din is-siegħa"},"relativeTime":{"future":{"one":"fi żmien siegħa oħra","few":"fi żmien {0} sigħat","many":"fi żmien{0} sigħat","other":"fi żmien {0} sigħat"},"past":{"one":"siegħa ilu","few":"{0} sigħat ilu","many":"{0} sigħat ilu","other":"{0} sigħat ilu"}}},"hour-short":{"displayName":"siegħa","relative":{"0":"din is-siegħa"},"relativeTime":{"future":{"one":"fi żmien siegħa oħra","few":"fi żmien {0} sigħat","many":"+{0} h","other":"fi żmien {0} sigħat"},"past":{"one":"siegħa ilu","few":"{0} sigħat ilu","many":"{0} sigħat ilu","other":"{0} sigħat ilu"}}},"minute":{"displayName":"minuta","relative":{"0":"din il-minuta"},"relativeTime":{"future":{"one":"sa minuta oħra","few":"sa {0} minuti oħra","many":"sa {0} minuti oħra","other":"sa {0} minuti oħra"},"past":{"one":"minuta ilu","few":"{0} minuti ilu","many":"{0} minuti ilu","other":"{0} minuti ilu"}}},"minute-short":{"displayName":"min.","relative":{"0":"din il-minuta"},"relativeTime":{"future":{"one":"sa min. oħra","few":"sa {0} min. oħra","many":"sa {0} min. oħra","other":"sa {0} min. oħra"},"past":{"one":"min. ilu","few":"{0} min. ilu","many":"{0} minuti ilu","other":"{0} min. ilu"}}},"second":{"displayName":"sekonda","relative":{"0":"issa"},"relativeTime":{"future":{"one":"sa {0} sekondi oħra","few":"sa {0} sekondi oħra","many":"sa {0} sekondi oħra","other":"sa {0} sekondi oħra"},"past":{"one":"sekonda ilu","few":"{0} sekondi ilu","many":"{0} sekondi ilu","other":"{0} sekondi ilu"}}},"second-short":{"displayName":"sek.","relative":{"0":"issa"},"relativeTime":{"future":{"one":"sa {0} sekondi oħra","few":"sa {0} sek. oħra","many":"sa {0} sek. oħra","other":"sa {0} sekondi oħra"},"past":{"one":"sek. ilu","few":"{0} sek. ilu","many":"{0} sek. ilu","other":"{0} sek. ilu"}}}}},
    {"locale":"mua","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Syii","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Syii","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Fĩi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Fĩi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Luma","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Luma","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Zah’nane\u002F Comme","relative":{"0":"Tǝ’nahko","1":"Tǝ’nane","-1":"Tǝsoo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Zah’nane\u002F Comme","relative":{"0":"Tǝ’nahko","1":"Tǝ’nane","-1":"Tǝsoo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Cok comme","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Cok comme","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Cok comme ma laŋne","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Cok comme ma laŋne","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Cok comme ma laŋ tǝ biŋ","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Cok comme ma laŋ tǝ biŋ","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"my","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return 'other';
    },"fields":{"year":{"displayName":"နှစ်","relative":{"0":"ယခုနှစ်","1":"လာမည့်နှစ်","-1":"ယမန်နှစ်"},"relativeTime":{"future":{"other":"{0} နှစ်အတွင်း"},"past":{"other":"ပြီးခဲ့သည့် {0} နှစ်"}}},"year-short":{"displayName":"နှစ်","relative":{"0":"ယခုနှစ်","1":"လာမည့်နှစ်","-1":"ယမန်နှစ်"},"relativeTime":{"future":{"other":"{0} နှစ်အတွင်း"},"past":{"other":"ပြီးခဲ့သည့် {0} နှစ်"}}},"month":{"displayName":"လ","relative":{"0":"ယခုလ","1":"လာမည့်လ","-1":"ပြီးခဲ့သည့်လ"},"relativeTime":{"future":{"other":"{0} လအတွင်း"},"past":{"other":"ပြီးခဲ့သည့် {0} လ"}}},"month-short":{"displayName":"လ","relative":{"0":"ယခုလ","1":"လာမည့်လ","-1":"ပြီးခဲ့သည့်လ"},"relativeTime":{"future":{"other":"{0} လအတွင်း"},"past":{"other":"ပြီးခဲ့သည့် {0} လ"}}},"week":{"displayName":"ပတ်","relativePeriod":"{0} ပတ်မြောက် သီတင်းပတ်","relative":{"0":"ယခု သီတင်းပတ်","1":"လာမည့် သီတင်းပတ်","-1":"ပြီးခဲ့သည့် သီတင်းပတ်"},"relativeTime":{"future":{"other":"{0} ပတ်အတွင်း"},"past":{"other":"ပြီးခဲ့သည့် {0} ပတ်"}}},"week-short":{"displayName":"ပတ်","relativePeriod":"{0} ပတ်မြောက် သီတင်းပတ်","relative":{"0":"ယခု သီတင်းပတ်","1":"လာမည့် သီတင်းပတ်","-1":"ပြီးခဲ့သည့် သီတင်းပတ်"},"relativeTime":{"future":{"other":"{0} ပတ်အတွင်း"},"past":{"other":"ပြီးခဲ့သည့် {0} ပတ်"}}},"day":{"displayName":"ရက်","relative":{"0":"ယနေ့","1":"မနက်ဖြန်","2":"သန်ဘက်ခါ","-2":"တစ်နေ့က","-1":"မနေ့က"},"relativeTime":{"future":{"other":"{0} ရက်အတွင်း"},"past":{"other":"ပြီးခဲ့သည့် {0} ရက်"}}},"day-short":{"displayName":"ရက်","relative":{"0":"ယနေ့","1":"မနက်ဖြန်","2":"သန်ဘက်ခါ","-2":"တစ်နေ့က","-1":"မနေ့က"},"relativeTime":{"future":{"other":"{0} ရက်အတွင်း"},"past":{"other":"ပြီးခဲ့သည့် {0} ရက်"}}},"hour":{"displayName":"နာရီ","relative":{"0":"ဤအချိန်"},"relativeTime":{"future":{"other":"{0} နာရီအတွင်း"},"past":{"other":"ပြီးခဲ့သည့် {0} နာရီ"}}},"hour-short":{"displayName":"နာရီ","relative":{"0":"ဤအချိန်"},"relativeTime":{"future":{"other":"{0} နာရီအတွင်း"},"past":{"other":"ပြီးခဲ့သည့် {0} နာရီ"}}},"minute":{"displayName":"မိနစ်","relative":{"0":"ဤမိနစ်"},"relativeTime":{"future":{"other":"{0} မိနစ်အတွင်း"},"past":{"other":"ပြီးခဲ့သည့် {0} မိနစ်"}}},"minute-short":{"displayName":"မိနစ်","relative":{"0":"ဤမိနစ်"},"relativeTime":{"future":{"other":"{0} မိနစ်အတွင်း"},"past":{"other":"ပြီးခဲ့သည့် {0} မိနစ်"}}},"second":{"displayName":"စက္ကန့်","relative":{"0":"ယခု"},"relativeTime":{"future":{"other":"{0} စက္ကန့်အတွင်း"},"past":{"other":"ပြီးခဲ့သည့် {0} စက္ကန့်"}}},"second-short":{"displayName":"စက္ကန့်","relative":{"0":"ယခု"},"relativeTime":{"future":{"other":"{0} စက္ကန့်အတွင်း"},"past":{"other":"ပြီးခဲ့သည့် {0} စက္ကန့်"}}}}},
    {"locale":"mzn","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"سال","relative":{"0":"امسال","1":"سال دیگه","-1":"پارسال"},"relativeTime":{"future":{"other":"{0} سال دله"},"past":{"other":"{0} سال پیش"}}},"year-short":{"displayName":"سال","relative":{"0":"امسال","1":"سال دیگه","-1":"پارسال"},"relativeTime":{"future":{"other":"{0} سال دله"},"past":{"other":"{0} سال پیش"}}},"month":{"displayName":"ماه","relative":{"0":"این ماه","1":"ماه ِبعد","-1":"ماه قبل"},"relativeTime":{"future":{"other":"{0} ماه دله"},"past":{"other":"{0} ماه پیش"}}},"month-short":{"displayName":"ماه","relative":{"0":"این ماه","1":"ماه ِبعد","-1":"ماه قبل"},"relativeTime":{"future":{"other":"{0} ماه دله"},"past":{"other":"{0} ماه پیش"}}},"week":{"displayName":"هفته","relativePeriod":"the week of {0}","relative":{"0":"این هفته","1":"بعدی هفته","-1":"قبلی هفته"},"relativeTime":{"future":{"other":"{0} هفته دله"},"past":{"other":"{0} هفته پیش"}}},"week-short":{"displayName":"هفته","relativePeriod":"the week of {0}","relative":{"0":"این هفته","1":"بعدی هفته","-1":"قبلی هفته"},"relativeTime":{"future":{"other":"{0} هفته دله"},"past":{"other":"{0} هفته پیش"}}},"day":{"displayName":"روز","relative":{"0":"اَمروز","1":"فِردا","-1":"دیروز"},"relativeTime":{"future":{"other":"{0} روز دله"},"past":{"other":"{0} روز پیش"}}},"day-short":{"displayName":"روز","relative":{"0":"اَمروز","1":"فِردا","-1":"دیروز"},"relativeTime":{"future":{"other":"{0} روز دله"},"past":{"other":"{0} روز پیش"}}},"hour":{"displayName":"ساعِت","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"{0} ساعِت دله"},"past":{"other":"{0} ساعِت پیش"}}},"hour-short":{"displayName":"ساعت","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"{0} ساعت دله"},"past":{"other":"{0} ساعت پیش"}}},"minute":{"displayName":"دقیقه","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"{0} دقیقه دله"},"past":{"other":"{0} دَقه پیش"}}},"minute-short":{"displayName":"دَقه","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"{0} دَقه دله"},"past":{"other":"{0} دَقه پیش"}}},"second":{"displayName":"ثانیه","relative":{"0":"now"},"relativeTime":{"future":{"other":"{0} ثانیه دله"},"past":{"other":"{0} ثانیه پیش"}}},"second-short":{"displayName":"ثانیه","relative":{"0":"now"},"relativeTime":{"future":{"other":"{0} ثانیه دله"},"past":{"other":"{0} ثانیه پیش"}}}}},
    {"locale":"nah","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"naq","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one'
          : (n == 2) ? 'two'
          : 'other';
    },"fields":{"year":{"displayName":"Kurib","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Kurib","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"ǁKhâb","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"ǁKhâb","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Wekheb","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Wekheb","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Tsees","relative":{"0":"Neetsee","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Tsees","relative":{"0":"Neetsee","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Iiri","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Iiri","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Haib","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Haib","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"ǀGâub","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"ǀGâub","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"nb","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"år","relative":{"0":"i år","1":"neste år","-1":"i fjor"},"relativeTime":{"future":{"one":"om {0} år","other":"om {0} år"},"past":{"one":"for {0} år siden","other":"for {0} år siden"}}},"year-short":{"displayName":"år","relative":{"0":"i år","1":"neste år","-1":"i fjor"},"relativeTime":{"future":{"one":"om {0} år","other":"om {0} år"},"past":{"one":"for {0} år siden","other":"for {0} år siden"}}},"month":{"displayName":"måned","relative":{"0":"denne måneden","1":"neste måned","-1":"forrige måned"},"relativeTime":{"future":{"one":"om {0} måned","other":"om {0} måneder"},"past":{"one":"for {0} måned siden","other":"for {0} måneder siden"}}},"month-short":{"displayName":"mnd.","relative":{"0":"denne md.","1":"neste md.","-1":"forrige md."},"relativeTime":{"future":{"one":"om {0} md.","other":"om {0} md."},"past":{"one":"for {0} md. siden","other":"for {0} md. siden"}}},"week":{"displayName":"uke","relativePeriod":"uken som inneholder {0}","relative":{"0":"denne uken","1":"neste uke","-1":"forrige uke"},"relativeTime":{"future":{"one":"om {0} uke","other":"om {0} uker"},"past":{"one":"for {0} uke siden","other":"for {0} uker siden"}}},"week-short":{"displayName":"uke","relativePeriod":"uken med {0}","relative":{"0":"denne uken","1":"neste uke","-1":"forrige uke"},"relativeTime":{"future":{"one":"om {0} u.","other":"om {0} u."},"past":{"one":"for {0} u. siden","other":"for {0} u. siden"}}},"day":{"displayName":"dag","relative":{"0":"i dag","1":"i morgen","2":"i overmorgen","-2":"i forgårs","-1":"i går"},"relativeTime":{"future":{"one":"om {0} døgn","other":"om {0} døgn"},"past":{"one":"for {0} døgn siden","other":"for {0} døgn siden"}}},"day-short":{"displayName":"dag","relative":{"0":"i dag","1":"i morgen","2":"i overmorgen","-2":"i forgårs","-1":"i går"},"relativeTime":{"future":{"one":"om {0} d.","other":"om {0} d."},"past":{"one":"for {0} d. siden","other":"for {0} d. siden"}}},"hour":{"displayName":"time","relative":{"0":"denne timen"},"relativeTime":{"future":{"one":"om {0} time","other":"om {0} timer"},"past":{"one":"for {0} time siden","other":"for {0} timer siden"}}},"hour-short":{"displayName":"t","relative":{"0":"denne timen"},"relativeTime":{"future":{"one":"om {0} t","other":"om {0} t"},"past":{"one":"for {0} t siden","other":"for {0} t siden"}}},"minute":{"displayName":"minutt","relative":{"0":"dette minuttet"},"relativeTime":{"future":{"one":"om {0} minutt","other":"om {0} minutter"},"past":{"one":"for {0} minutt siden","other":"for {0} minutter siden"}}},"minute-short":{"displayName":"min","relative":{"0":"dette minuttet"},"relativeTime":{"future":{"one":"om {0} min","other":"om {0} min"},"past":{"one":"for {0} min siden","other":"for {0} min siden"}}},"second":{"displayName":"sekund","relative":{"0":"nå"},"relativeTime":{"future":{"one":"om {0} sekund","other":"om {0} sekunder"},"past":{"one":"for {0} sekund siden","other":"for {0} sekunder siden"}}},"second-short":{"displayName":"sek","relative":{"0":"nå"},"relativeTime":{"future":{"one":"om {0} sek","other":"om {0} sek"},"past":{"one":"for {0} sek siden","other":"for {0} sek siden"}}}}},{"locale":"nb-SJ","parentLocale":"nb"},
    {"locale":"nd","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Umnyaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Umnyaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Inyangacale","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Inyangacale","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Iviki","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Iviki","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Ilanga","relative":{"0":"Lamuhla","1":"Kusasa","-1":"Izolo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Ilanga","relative":{"0":"Lamuhla","1":"Kusasa","-1":"Izolo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Ihola","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Ihola","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Umuzuzu","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Umuzuzu","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Isekendi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Isekendi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"nds","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"nds-NL","parentLocale":"nds"},
    {"locale":"ne","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), t0 = Number(s[0]) == n;
      if (ord) return ((t0 && n >= 1 && n <= 4)) ? 'one' : 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"वर्ष","relative":{"0":"यो वर्ष","1":"आगामी वर्ष","-1":"गत वर्ष"},"relativeTime":{"future":{"one":"{0} वर्षमा","other":"{0} वर्षमा"},"past":{"one":"{0} वर्ष अघि","other":"{0} वर्ष अघि"}}},"year-short":{"displayName":"वर्ष","relative":{"0":"यो वर्ष","1":"आगामी वर्ष","-1":"गत वर्ष"},"relativeTime":{"future":{"one":"{0} वर्षमा","other":"{0} वर्षमा"},"past":{"one":"{0} वर्ष अघि","other":"{0} वर्ष अघि"}}},"month":{"displayName":"महिना","relative":{"0":"यो महिना","1":"अर्को महिना","-1":"गत महिना"},"relativeTime":{"future":{"one":"{0} महिनामा","other":"{0} महिनामा"},"past":{"one":"{0} महिना पहिले","other":"{0} महिना पहिले"}}},"month-short":{"displayName":"महिना","relative":{"0":"यो महिना","1":"अर्को महिना","-1":"गत महिना"},"relativeTime":{"future":{"one":"{0} महिनामा","other":"{0} महिनामा"},"past":{"one":"{0} महिना पहिले","other":"{0} महिना पहिले"}}},"week":{"displayName":"हप्ता","relativePeriod":"{0}को हप्ता","relative":{"0":"यो हप्ता","1":"आउने हप्ता","-1":"गत हप्ता"},"relativeTime":{"future":{"one":"{0} हप्तामा","other":"{0} हप्तामा"},"past":{"one":"{0} हप्ता पहिले","other":"{0} हप्ता पहिले"}}},"week-short":{"displayName":"हप्ता","relativePeriod":"{0} को हप्ता","relative":{"0":"यो हप्ता","1":"आउने हप्ता","-1":"गत हप्ता"},"relativeTime":{"future":{"one":"{0} हप्तामा","other":"{0} हप्तामा"},"past":{"one":"{0} हप्ता पहिले","other":"{0} हप्ता पहिले"}}},"day":{"displayName":"बार","relative":{"0":"आज","1":"भोलि","2":"पर्सि","-2":"अस्ति","-1":"हिजो"},"relativeTime":{"future":{"one":"{0} दिनमा","other":"{0} दिनमा"},"past":{"one":"{0} दिन पहिले","other":"{0} दिन पहिले"}}},"day-short":{"displayName":"बार","relative":{"0":"आज","1":"भोलि","2":"पर्सि","-2":"अस्ति","-1":"हिजो"},"relativeTime":{"future":{"one":"{0} दिनमा","other":"{0} दिनमा"},"past":{"one":"{0} दिन पहिले","other":"{0} दिन पहिले"}}},"hour":{"displayName":"घण्टा","relative":{"0":"यस घडीमा"},"relativeTime":{"future":{"one":"{0} घण्टामा","other":"{0} घण्टामा"},"past":{"one":"{0} घण्टा पहिले","other":"{0} घण्टा पहिले"}}},"hour-short":{"displayName":"घण्टा","relative":{"0":"यस घडीमा"},"relativeTime":{"future":{"one":"{0} घण्टामा","other":"{0} घण्टामा"},"past":{"one":"{0} घण्टा पहिले","other":"{0} घण्टा पहिले"}}},"minute":{"displayName":"मिनेट","relative":{"0":"यही मिनेटमा"},"relativeTime":{"future":{"one":"{0} मिनेटमा","other":"{0} मिनेटमा"},"past":{"one":"{0} मिनेट पहिले","other":"{0} मिनेट पहिले"}}},"minute-short":{"displayName":"मिनेट","relative":{"0":"यही मिनेटमा"},"relativeTime":{"future":{"one":"{0} मिनेटमा","other":"{0} मिनेटमा"},"past":{"one":"{0} मिनेट पहिले","other":"{0} मिनेट पहिले"}}},"second":{"displayName":"सेकेन्ड","relative":{"0":"अहिले"},"relativeTime":{"future":{"one":"{0} सेकेन्डमा","other":"{0} सेकेन्डमा"},"past":{"one":"{0} सेकेन्ड पहिले","other":"{0} सेकेन्ड पहिले"}}},"second-short":{"displayName":"सेकेन्ड","relative":{"0":"अहिले"},"relativeTime":{"future":{"one":"{0} सेकेन्डमा","other":"{0} सेकेन्डमा"},"past":{"one":"{0} सेकेन्ड पहिले","other":"{0} सेकेन्ड पहिले"}}}}},{"locale":"ne-IN","parentLocale":"ne"},
    {"locale":"nl","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      if (ord) return 'other';
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"jaar","relative":{"0":"dit jaar","1":"volgend jaar","-1":"vorig jaar"},"relativeTime":{"future":{"one":"over {0} jaar","other":"over {0} jaar"},"past":{"one":"{0} jaar geleden","other":"{0} jaar geleden"}}},"year-short":{"displayName":"jr","relative":{"0":"dit jaar","1":"volgend jaar","-1":"vorig jaar"},"relativeTime":{"future":{"one":"over {0} jaar","other":"over {0} jaar"},"past":{"one":"{0} jaar geleden","other":"{0} jaar geleden"}}},"month":{"displayName":"maand","relative":{"0":"deze maand","1":"volgende maand","-1":"vorige maand"},"relativeTime":{"future":{"one":"over {0} maand","other":"over {0} maanden"},"past":{"one":"{0} maand geleden","other":"{0} maanden geleden"}}},"month-short":{"displayName":"mnd","relative":{"0":"deze maand","1":"volgende maand","-1":"vorige maand"},"relativeTime":{"future":{"one":"over {0} maand","other":"over {0} maanden"},"past":{"one":"{0} maand geleden","other":"{0} maanden geleden"}}},"week":{"displayName":"week","relativePeriod":"de week van {0}","relative":{"0":"deze week","1":"volgende week","-1":"vorige week"},"relativeTime":{"future":{"one":"over {0} week","other":"over {0} weken"},"past":{"one":"{0} week geleden","other":"{0} weken geleden"}}},"week-short":{"displayName":"wk","relativePeriod":"de week van {0}","relative":{"0":"deze week","1":"volgende week","-1":"vorige week"},"relativeTime":{"future":{"one":"over {0} week","other":"over {0} weken"},"past":{"one":"{0} week geleden","other":"{0} weken geleden"}}},"day":{"displayName":"dag","relative":{"0":"vandaag","1":"morgen","2":"overmorgen","-2":"eergisteren","-1":"gisteren"},"relativeTime":{"future":{"one":"over {0} dag","other":"over {0} dagen"},"past":{"one":"{0} dag geleden","other":"{0} dagen geleden"}}},"day-short":{"displayName":"dag","relative":{"0":"vandaag","1":"morgen","2":"overmorgen","-2":"eergisteren","-1":"gisteren"},"relativeTime":{"future":{"one":"over {0} dag","other":"over {0} dgn"},"past":{"one":"{0} dag geleden","other":"{0} dgn geleden"}}},"hour":{"displayName":"uur","relative":{"0":"binnen een uur"},"relativeTime":{"future":{"one":"over {0} uur","other":"over {0} uur"},"past":{"one":"{0} uur geleden","other":"{0} uur geleden"}}},"hour-short":{"displayName":"uur","relative":{"0":"binnen een uur"},"relativeTime":{"future":{"one":"over {0} uur","other":"over {0} uur"},"past":{"one":"{0} uur geleden","other":"{0} uur geleden"}}},"minute":{"displayName":"minuut","relative":{"0":"binnen een minuut"},"relativeTime":{"future":{"one":"over {0} minuut","other":"over {0} minuten"},"past":{"one":"{0} minuut geleden","other":"{0} minuten geleden"}}},"minute-short":{"displayName":"min","relative":{"0":"binnen een minuut"},"relativeTime":{"future":{"one":"over {0} min.","other":"over {0} min."},"past":{"one":"{0} min. geleden","other":"{0} min. geleden"}}},"second":{"displayName":"seconde","relative":{"0":"nu"},"relativeTime":{"future":{"one":"over {0} seconde","other":"over {0} seconden"},"past":{"one":"{0} seconde geleden","other":"{0} seconden geleden"}}},"second-short":{"displayName":"sec","relative":{"0":"nu"},"relativeTime":{"future":{"one":"over {0} sec.","other":"over {0} sec."},"past":{"one":"{0} sec. geleden","other":"{0} sec. geleden"}}}}},{"locale":"nl-AW","parentLocale":"nl"},{"locale":"nl-BE","parentLocale":"nl"},{"locale":"nl-BQ","parentLocale":"nl"},{"locale":"nl-CW","parentLocale":"nl"},{"locale":"nl-SR","parentLocale":"nl"},{"locale":"nl-SX","parentLocale":"nl"},
    {"locale":"nmg","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Mbvu","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Mbvu","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Ngwɛn","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Ngwɛn","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Sɔ́ndɔ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Sɔ́ndɔ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Duö","relative":{"0":"Dɔl","1":"Namáná","-1":"Nakugú"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Duö","relative":{"0":"Dɔl","1":"Namáná","-1":"Nakugú"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Wulā","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Wulā","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Mpálâ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Mpálâ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Nyiɛl","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Nyiɛl","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"nn","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"år","relative":{"0":"i år","1":"neste år","-1":"i fjor"},"relativeTime":{"future":{"one":"om {0} år","other":"om {0} år"},"past":{"one":"for {0} år sidan","other":"for {0} år sidan"}}},"year-short":{"displayName":"år","relative":{"0":"i år","1":"neste år","-1":"i fjor"},"relativeTime":{"future":{"one":"om {0} år","other":"om {0} år"},"past":{"one":"for {0} år sidan","other":"for {0} år sidan"}}},"month":{"displayName":"månad","relative":{"0":"denne månaden","1":"neste månad","-1":"førre månad"},"relativeTime":{"future":{"one":"om {0} månad","other":"om {0} månadar"},"past":{"one":"for {0} månad sidan","other":"for {0} månadar sidan"}}},"month-short":{"displayName":"mnd.","relative":{"0":"denne månaden","1":"neste månad","-1":"førre månad"},"relativeTime":{"future":{"one":"om {0} md.","other":"om {0} md."},"past":{"one":"for {0} md. sidan","other":"for {0} md. sidan"}}},"week":{"displayName":"veke","relativePeriod":"veka som inneheld {0}","relative":{"0":"denne veka","1":"neste veke","-1":"førre veke"},"relativeTime":{"future":{"one":"om {0} veke","other":"om {0} veker"},"past":{"one":"for {0} veke sidan","other":"for {0} veker sidan"}}},"week-short":{"displayName":"veke","relativePeriod":"veka med {0}","relative":{"0":"denne veka","1":"neste veke","-1":"førre veke"},"relativeTime":{"future":{"one":"om {0} v.","other":"om {0} v."},"past":{"one":"for {0} v. sidan","other":"for {0} v. sidan"}}},"day":{"displayName":"dag","relative":{"0":"i dag","1":"i morgon","2":"i overmorgon","-2":"i førgår","-1":"i går"},"relativeTime":{"future":{"one":"om {0} døgn","other":"om {0} døgn"},"past":{"one":"for {0} døgn sidan","other":"for {0} døgn sidan"}}},"day-short":{"displayName":"dag","relative":{"0":"i dag","1":"i morgon","2":"i overmorgon","-2":"i førgår","-1":"i går"},"relativeTime":{"future":{"one":"om {0} d.","other":"om {0} d."},"past":{"one":"for {0} d. sidan","other":"for {0} d. sidan"}}},"hour":{"displayName":"time","relative":{"0":"denne timen"},"relativeTime":{"future":{"one":"om {0} time","other":"om {0} timar"},"past":{"one":"for {0} time sidan","other":"for {0} timar sidan"}}},"hour-short":{"displayName":"t","relative":{"0":"denne timen"},"relativeTime":{"future":{"one":"om {0} t","other":"om {0} t"},"past":{"one":"for {0} t sidan","other":"for {0} t sidan"}}},"minute":{"displayName":"minutt","relative":{"0":"dette minuttet"},"relativeTime":{"future":{"one":"om {0} minutt","other":"om {0} minutt"},"past":{"one":"for {0} minutt sidan","other":"for {0} minutt sidan"}}},"minute-short":{"displayName":"min","relative":{"0":"dette minuttet"},"relativeTime":{"future":{"one":"om {0} min","other":"om {0} min"},"past":{"one":"for {0} min sidan","other":"for {0} min sidan"}}},"second":{"displayName":"sekund","relative":{"0":"no"},"relativeTime":{"future":{"one":"om {0} sekund","other":"om {0} sekund"},"past":{"one":"for {0} sekund sidan","other":"for {0} sekund sidan"}}},"second-short":{"displayName":"sek","relative":{"0":"no"},"relativeTime":{"future":{"one":"om {0} sek","other":"om {0} sek"},"past":{"one":"for {0} sek sidan","other":"for {0} sek sidan"}}}}},
    {"locale":"nnh","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ngùʼ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"ngùʼ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"lyɛ̌ʼ","relative":{"0":"lyɛ̌ʼɔɔn","1":"jǔɔ gẅie à ne ntóo","-1":"jǔɔ gẅie à ka tɔ̌g"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"lyɛ̌ʼ","relative":{"0":"lyɛ̌ʼɔɔn","1":"jǔɔ gẅie à ne ntóo","-1":"jǔɔ gẅie à ka tɔ̌g"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"fʉ̀ʼ nèm","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"fʉ̀ʼ nèm","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"no","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"nqo","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"nr","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"nso","pluralRuleFunction":function(n
    ) {
      return ((n == 0
              || n == 1)) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"nus","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Ruɔ̱n","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Ruɔ̱n","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Pay","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Pay","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Jiɔk","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Jiɔk","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Cäŋ","relative":{"0":"Walɛ","1":"Ruun","-1":"Pan"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Cäŋ","relative":{"0":"Walɛ","1":"Ruun","-1":"Pan"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Thaak","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Thaak","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minit","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minit","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Thɛkɛni","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Thɛkɛni","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ny","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"nyn","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Omwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Omwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Omwezi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Omwezi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Esande","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Esande","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Eizooba","relative":{"0":"Erizooba","1":"Nyenkyakare","-1":"Nyomwabazyo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Eizooba","relative":{"0":"Erizooba","1":"Nyenkyakare","-1":"Nyomwabazyo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Shaaha","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Shaaha","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Edakiika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Edakiika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Obucweka\u002FEsekendi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Obucweka\u002FEsekendi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"om","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"om-KE","parentLocale":"om"},
    {"locale":"or","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), t0 = Number(s[0]) == n;
      if (ord) return ((n == 1 || n == 5
              || (t0 && n >= 7 && n <= 9))) ? 'one'
          : ((n == 2
              || n == 3)) ? 'two'
          : (n == 4) ? 'few'
          : (n == 6) ? 'many'
          : 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ବର୍ଷ","relative":{"0":"ଏହି ବର୍ଷ","1":"ଆଗାମୀ ବର୍ଷ","-1":"ଗତ ବର୍ଷ"},"relativeTime":{"future":{"one":"{0} ବର୍ଷରେ","other":"{0} ବର୍ଷରେ"},"past":{"one":"{0} ବର୍ଷ ପୂର୍ବେ","other":"{0} ବର୍ଷ ପୂର୍ବେ"}}},"year-short":{"displayName":"ବ.","relative":{"0":"ଏହି ବର୍ଷ","1":"ଆଗାମୀ ବର୍ଷ","-1":"ଗତ ବର୍ଷ"},"relativeTime":{"future":{"one":"{0} ବ. ରେ","other":"{0} ବ. ରେ"},"past":{"one":"{0} ବ. ପୂର୍ବେ","other":"{0} ବ. ପୂର୍ବେ"}}},"month":{"displayName":"ମାସ","relative":{"0":"ଏହି ମାସ","1":"ଆଗାମୀ ମାସ","-1":"ଗତ ମାସ"},"relativeTime":{"future":{"one":"{0} ମାସରେ","other":"{0} ମାସରେ"},"past":{"one":"{0} ମାସ ପୂର୍ବେ","other":"{0} ମାସ ପୂର୍ବେ"}}},"month-short":{"displayName":"ମା.","relative":{"0":"ଏହି ମାସ","1":"ଆଗାମୀ ମାସ","-1":"ଗତ ମାସ"},"relativeTime":{"future":{"one":"{0} ମା. ରେ","other":"{0} ମା. ରେ"},"past":{"one":"{0} ମା. ପୂର୍ବେ","other":"{0} ମା. ପୂର୍ବେ"}}},"week":{"displayName":"ସପ୍ତାହ","relativePeriod":"{0} ର ସପ୍ତାହ","relative":{"0":"ଏହି ସପ୍ତାହ","1":"ଆଗାମୀ ସପ୍ତାହ","-1":"ଗତ ସପ୍ତାହ"},"relativeTime":{"future":{"one":"{0} ସପ୍ତାହରେ","other":"{0} ସପ୍ତାହରେ"},"past":{"one":"{0} ସପ୍ତାହରେ","other":"{0} ସପ୍ତାହ ପୂର୍ବେ"}}},"week-short":{"displayName":"ସ.","relativePeriod":"{0} ର ସପ୍ତାହ","relative":{"0":"ଏହି ସପ୍ତାହ","1":"ଆଗାମୀ ସପ୍ତାହ","-1":"ଗତ ସପ୍ତାହ"},"relativeTime":{"future":{"one":"{0} ସପ୍ତା. ରେ","other":"{0} ସପ୍ତା. ରେ"},"past":{"one":"{0} ସପ୍ତା. ପୂର୍ବେ","other":"{0} ସପ୍ତା. ପୂର୍ବେ"}}},"day":{"displayName":"ଦିନ","relative":{"0":"ଆଜି","1":"ଆସନ୍ତାକାଲି","-1":"ଗତକାଲି"},"relativeTime":{"future":{"one":"{0} ଦିନରେ","other":"{0} ଦିନରେ"},"past":{"one":"{0} ଦିନ ପୂର୍ବେ","other":"{0} ଦିନ ପୂର୍ବେ"}}},"day-short":{"displayName":"ଦିନ","relative":{"0":"ଆଜି","1":"ଆସନ୍ତାକାଲି","-1":"ଗତକାଲି"},"relativeTime":{"future":{"one":"{0} ଦିନରେ","other":"{0} ଦିନରେ"},"past":{"one":"{0} ଦିନ ପୂର୍ବେ","other":"{0} ଦିନ ପୂର୍ବେ"}}},"hour":{"displayName":"ଘଣ୍ଟା","relative":{"0":"ଏହି ଘଣ୍ଟା"},"relativeTime":{"future":{"one":"{0} ଘଣ୍ଟାରେ","other":"{0} ଘଣ୍ଟାରେ"},"past":{"one":"{0} ଘଣ୍ଟା ପୂର୍ବେ","other":"{0} ଘଣ୍ଟା ପୂର୍ବେ"}}},"hour-short":{"displayName":"ଘ.","relative":{"0":"ଏହି ଘଣ୍ଟା"},"relativeTime":{"future":{"one":"{0} ଘ. ରେ","other":"{0} ଘ. ରେ"},"past":{"one":"{0} ଘ. ପୂର୍ବେ","other":"{0} ଘ. ପୂର୍ବେ"}}},"minute":{"displayName":"ମିନିଟ୍","relative":{"0":"ଏହି ମିନିଟ୍"},"relativeTime":{"future":{"one":"{0} ମିନିଟ୍‌‌ରେ","other":"{0} ମିନିଟ୍‌‌ରେ"},"past":{"one":"{0} ମିନିଟ୍ ପୂର୍ବେ","other":"{0} ମିନିଟ୍ ପୂର୍ବେ"}}},"minute-short":{"displayName":"ମି.","relative":{"0":"ଏହି ମିନିଟ୍"},"relativeTime":{"future":{"one":"{0} ମି. ରେ","other":"{0} ମି. ରେ"},"past":{"one":"{0} ମି. ପୂର୍ବେ","other":"{0} ମି. ପୂର୍ବେ"}}},"second":{"displayName":"ସେକେଣ୍ଡ୍","relative":{"0":"ବର୍ତ୍ତମାନ"},"relativeTime":{"future":{"one":"{0} ସେକେଣ୍ଡରେ","other":"{0} ସେକେଣ୍ଡରେ"},"past":{"one":"{0} ସେକେଣ୍ଡ ପୂର୍ବେ","other":"{0} ସେକେଣ୍ଡ ପୂର୍ବେ"}}},"second-short":{"displayName":"ସେକେଣ୍ଡ୍","relative":{"0":"ବର୍ତ୍ତମାନ"},"relativeTime":{"future":{"one":"{0} ସେ. ରେ","other":"{0} ସେ. ରେ"},"past":{"one":"{0} ସେ. ପୂର୍ବେ","other":"{0} ସେ. ପୂର୍ବେ"}}}}},
    {"locale":"os","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Аз","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Аз","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Мӕй","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Мӕй","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Къуыри","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Къуыри","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Бон","relative":{"0":"Абон","1":"Сом","2":"Иннӕбон","-2":"Ӕндӕрӕбон","-1":"Знон"},"relativeTime":{"future":{"one":"{0} боны фӕстӕ","other":"{0} боны фӕстӕ"},"past":{"one":"{0} бон раздӕр","other":"{0} боны размӕ"}}},"day-short":{"displayName":"Бон","relative":{"0":"Абон","1":"Сом","2":"Иннӕбон","-2":"Ӕндӕрӕбон","-1":"Знон"},"relativeTime":{"future":{"one":"{0} боны фӕстӕ","other":"{0} боны фӕстӕ"},"past":{"one":"{0} бон раздӕр","other":"{0} боны размӕ"}}},"hour":{"displayName":"Сахат","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"{0} сахаты фӕстӕ","other":"{0} сахаты фӕстӕ"},"past":{"one":"{0} сахаты размӕ","other":"{0} сахаты размӕ"}}},"hour-short":{"displayName":"Сахат","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"{0} сахаты фӕстӕ","other":"{0} сахаты фӕстӕ"},"past":{"one":"{0} сахаты размӕ","other":"{0} сахаты размӕ"}}},"minute":{"displayName":"Минут","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Минут","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Секунд","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Секунд","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"os-RU","parentLocale":"os"},
    {"locale":"pa","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return ((n == 0
              || n == 1)) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ਸਾਲ","relative":{"0":"ਇਹ ਸਾਲ","1":"ਅਗਲਾ ਸਾਲ","-1":"ਪਿਛਲਾ ਸਾਲ"},"relativeTime":{"future":{"one":"{0} ਸਾਲ ਵਿੱਚ","other":"{0} ਸਾਲਾਂ ਵਿੱਚ"},"past":{"one":"{0} ਸਾਲ ਪਹਿਲਾਂ","other":"{0} ਸਾਲ ਪਹਿਲਾਂ"}}},"year-short":{"displayName":"ਸਾਲ","relative":{"0":"ਇਹ ਸਾਲ","1":"ਅਗਲਾ ਸਾਲ","-1":"ਪਿਛਲਾ ਸਾਲ"},"relativeTime":{"future":{"one":"{0} ਸਾਲ ਵਿੱਚ","other":"{0} ਸਾਲਾਂ ਵਿੱਚ"},"past":{"one":"{0} ਸਾਲ ਪਹਿਲਾਂ","other":"{0} ਸਾਲ ਪਹਿਲਾਂ"}}},"month":{"displayName":"ਮਹੀਨਾ","relative":{"0":"ਇਹ ਮਹੀਨਾ","1":"ਅਗਲਾ ਮਹੀਨਾ","-1":"ਪਿਛਲਾ ਮਹੀਨਾ"},"relativeTime":{"future":{"one":"{0} ਮਹੀਨੇ ਵਿੱਚ","other":"{0} ਮਹੀਨਿਆਂ ਵਿੱਚ"},"past":{"one":"{0} ਮਹੀਨਾ ਪਹਿਲਾਂ","other":"{0} ਮਹੀਨੇ ਪਹਿਲਾਂ"}}},"month-short":{"displayName":"ਮਹੀਨਾ","relative":{"0":"ਇਹ ਮਹੀਨਾ","1":"ਅਗਲਾ ਮਹੀਨਾ","-1":"ਪਿਛਲਾ ਮਹੀਨਾ"},"relativeTime":{"future":{"one":"{0} ਮਹੀਨੇ ਵਿੱਚ","other":"{0} ਮਹੀਨਿਆਂ ਵਿੱਚ"},"past":{"one":"{0} ਮਹੀਨਾ ਪਹਿਲਾਂ","other":"{0} ਮਹੀਨੇ ਪਹਿਲਾਂ"}}},"week":{"displayName":"ਹਫ਼ਤਾ","relativePeriod":"{0} ਦਾ ਹਫ਼ਤਾ","relative":{"0":"ਇਹ ਹਫ਼ਤਾ","1":"ਅਗਲਾ ਹਫ਼ਤਾ","-1":"ਪਿਛਲਾ ਹਫ਼ਤਾ"},"relativeTime":{"future":{"one":"{0} ਹਫ਼ਤੇ ਵਿੱਚ","other":"{0} ਹਫ਼ਤਿਆਂ ਵਿੱਚ"},"past":{"one":"{0} ਹਫ਼ਤਾ ਪਹਿਲਾਂ","other":"{0} ਹਫ਼ਤੇ ਪਹਿਲਾਂ"}}},"week-short":{"displayName":"ਹਫ਼ਤਾ","relativePeriod":"{0} ਦਾ ਹਫ਼ਤਾ","relative":{"0":"ਇਹ ਹਫ਼ਤਾ","1":"ਅਗਲਾ ਹਫ਼ਤਾ","-1":"ਪਿਛਲਾ ਹਫ਼ਤਾ"},"relativeTime":{"future":{"one":"{0} ਹਫ਼ਤੇ ਵਿੱਚ","other":"{0} ਹਫ਼ਤਿਆਂ ਵਿੱਚ"},"past":{"one":"{0} ਹਫ਼ਤਾ ਪਹਿਲਾਂ","other":"{0} ਹਫ਼ਤੇ ਪਹਿਲਾਂ"}}},"day":{"displayName":"ਦਿਨ","relative":{"0":"ਅੱਜ","1":"ਭਲਕੇ","-1":"ਬੀਤਿਆ ਕੱਲ੍ਹ"},"relativeTime":{"future":{"one":"{0} ਦਿਨ ਵਿੱਚ","other":"{0} ਦਿਨਾਂ ਵਿੱਚ"},"past":{"one":"{0} ਦਿਨ ਪਹਿਲਾਂ","other":"{0} ਦਿਨ ਪਹਿਲਾਂ"}}},"day-short":{"displayName":"ਦਿਨ","relative":{"0":"ਅੱਜ","1":"ਭਲਕੇ","-1":"ਬੀਤਿਆ ਕੱਲ੍ਹ"},"relativeTime":{"future":{"one":"{0} ਦਿਨ ਵਿੱਚ","other":"{0} ਦਿਨਾਂ ਵਿੱਚ"},"past":{"one":"{0} ਦਿਨ ਪਹਿਲਾਂ","other":"{0} ਦਿਨ ਪਹਿਲਾਂ"}}},"hour":{"displayName":"ਘੰਟਾ","relative":{"0":"ਇਸ ਘੰਟੇ"},"relativeTime":{"future":{"one":"{0} ਘੰਟੇ ਵਿੱਚ","other":"{0} ਘੰਟਿਆਂ ਵਿੱਚ"},"past":{"one":"{0} ਘੰਟਾ ਪਹਿਲਾਂ","other":"{0} ਘੰਟੇ ਪਹਿਲਾਂ"}}},"hour-short":{"displayName":"ਘੰਟਾ","relative":{"0":"ਇਸ ਘੰਟੇ"},"relativeTime":{"future":{"one":"{0} ਘੰਟੇ ਵਿੱਚ","other":"{0} ਘੰਟਿਆਂ ਵਿੱਚ"},"past":{"one":"{0} ਘੰਟਾ ਪਹਿਲਾਂ","other":"{0} ਘੰਟੇ ਪਹਿਲਾਂ"}}},"minute":{"displayName":"ਮਿੰਟ","relative":{"0":"ਇਸ ਮਿੰਟ"},"relativeTime":{"future":{"one":"{0} ਮਿੰਟ ਵਿੱਚ","other":"{0} ਮਿੰਟਾਂ ਵਿੱਚ"},"past":{"one":"{0} ਮਿੰਟ ਪਹਿਲਾਂ","other":"{0} ਮਿੰਟ ਪਹਿਲਾਂ"}}},"minute-short":{"displayName":"ਮਿੰਟ","relative":{"0":"ਇਸ ਮਿੰਟ"},"relativeTime":{"future":{"one":"{0} ਮਿੰਟ ਵਿੱਚ","other":"{0} ਮਿੰਟਾਂ ਵਿੱਚ"},"past":{"one":"{0} ਮਿੰਟ ਪਹਿਲਾਂ","other":"{0} ਮਿੰਟ ਪਹਿਲਾਂ"}}},"second":{"displayName":"ਸਕਿੰਟ","relative":{"0":"ਹੁਣ"},"relativeTime":{"future":{"one":"{0} ਸਕਿੰਟ ਵਿੱਚ","other":"{0} ਸਕਿੰਟਾਂ ਵਿੱਚ"},"past":{"one":"{0} ਸਕਿੰਟ ਪਹਿਲਾਂ","other":"{0} ਸਕਿੰਟ ਪਹਿਲਾਂ"}}},"second-short":{"displayName":"ਸਕਿੰਟ","relative":{"0":"ਹੁਣ"},"relativeTime":{"future":{"one":"{0} ਸਕਿੰਟ ਵਿੱਚ","other":"{0} ਸਕਿੰਟਾਂ ਵਿੱਚ"},"past":{"one":"{0} ਸਕਿੰਟ ਪਹਿਲਾਂ","other":"{0} ਸਕਿੰਟ ਪਹਿਲਾਂ"}}}}},{"locale":"pa-Arab","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"ورھا","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"ورھا","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"مہينا","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"مہينا","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"ہفتہ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"ہفتہ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"دئن","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"دئن","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"گھنٹا","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"گھنٹا","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"منٹ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"منٹ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"pa-Guru","parentLocale":"pa"},
    {"locale":"pap","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"pl","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], v0 = !s[1], i10 = i.slice(-1),
          i100 = i.slice(-2);
      if (ord) return 'other';
      return (n == 1 && v0) ? 'one'
          : (v0 && (i10 >= 2 && i10 <= 4) && (i100 < 12
              || i100 > 14)) ? 'few'
          : (v0 && i != 1 && (i10 == 0 || i10 == 1)
              || v0 && (i10 >= 5 && i10 <= 9)
              || v0 && (i100 >= 12 && i100 <= 14)) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"rok","relative":{"0":"w tym roku","1":"w przyszłym roku","-1":"w zeszłym roku"},"relativeTime":{"future":{"one":"za {0} rok","few":"za {0} lata","many":"za {0} lat","other":"za {0} roku"},"past":{"one":"{0} rok temu","few":"{0} lata temu","many":"{0} lat temu","other":"{0} roku temu"}}},"year-short":{"displayName":"r.","relative":{"0":"w tym roku","1":"w przyszłym roku","-1":"w zeszłym roku"},"relativeTime":{"future":{"one":"za {0} rok","few":"za {0} lata","many":"za {0} lat","other":"za {0} roku"},"past":{"one":"{0} rok temu","few":"{0} lata temu","many":"{0} lat temu","other":"{0} roku temu"}}},"month":{"displayName":"miesiąc","relative":{"0":"w tym miesiącu","1":"w przyszłym miesiącu","-1":"w zeszłym miesiącu"},"relativeTime":{"future":{"one":"za {0} miesiąc","few":"za {0} miesiące","many":"za {0} miesięcy","other":"za {0} miesiąca"},"past":{"one":"{0} miesiąc temu","few":"{0} miesiące temu","many":"{0} miesięcy temu","other":"{0} miesiąca temu"}}},"month-short":{"displayName":"mies.","relative":{"0":"w tym miesiącu","1":"w przyszłym miesiącu","-1":"w zeszłym miesiącu"},"relativeTime":{"future":{"one":"za {0} mies.","few":"za {0} mies.","many":"za {0} mies.","other":"za {0} mies."},"past":{"one":"{0} mies. temu","few":"{0} mies. temu","many":"{0} mies. temu","other":"{0} mies. temu"}}},"week":{"displayName":"tydzień","relativePeriod":"tydzień {0}","relative":{"0":"w tym tygodniu","1":"w przyszłym tygodniu","-1":"w zeszłym tygodniu"},"relativeTime":{"future":{"one":"za {0} tydzień","few":"za {0} tygodnie","many":"za {0} tygodni","other":"za {0} tygodnia"},"past":{"one":"{0} tydzień temu","few":"{0} tygodnie temu","many":"{0} tygodni temu","other":"{0} tygodnia temu"}}},"week-short":{"displayName":"tydz.","relativePeriod":"tydzień {0}","relative":{"0":"w tym tygodniu","1":"w przyszłym tygodniu","-1":"w zeszłym tygodniu"},"relativeTime":{"future":{"one":"za {0} tydz.","few":"za {0} tyg.","many":"za {0} tyg.","other":"za {0} tyg."},"past":{"one":"{0} tydz. temu","few":"{0} tyg. temu","many":"{0} tyg. temu","other":"{0} tyg. temu"}}},"day":{"displayName":"dzień","relative":{"0":"dzisiaj","1":"jutro","2":"pojutrze","-2":"przedwczoraj","-1":"wczoraj"},"relativeTime":{"future":{"one":"za {0} dzień","few":"za {0} dni","many":"za {0} dni","other":"za {0} dnia"},"past":{"one":"{0} dzień temu","few":"{0} dni temu","many":"{0} dni temu","other":"{0} dnia temu"}}},"day-short":{"displayName":"dzień","relative":{"0":"dzisiaj","1":"jutro","2":"pojutrze","-2":"przedwczoraj","-1":"wczoraj"},"relativeTime":{"future":{"one":"za {0} dzień","few":"za {0} dni","many":"za {0} dni","other":"za {0} dnia"},"past":{"one":"{0} dzień temu","few":"{0} dni temu","many":"{0} dni temu","other":"{0} dnia temu"}}},"hour":{"displayName":"godzina","relative":{"0":"ta godzina"},"relativeTime":{"future":{"one":"za {0} godzinę","few":"za {0} godziny","many":"za {0} godzin","other":"za {0} godziny"},"past":{"one":"{0} godzinę temu","few":"{0} godziny temu","many":"{0} godzin temu","other":"{0} godziny temu"}}},"hour-short":{"displayName":"godz.","relative":{"0":"ta godzina"},"relativeTime":{"future":{"one":"za {0} godz.","few":"za {0} godz.","many":"za {0} godz.","other":"za {0} godz."},"past":{"one":"{0} godz. temu","few":"{0} godz. temu","many":"{0} godz. temu","other":"{0} godz. temu"}}},"minute":{"displayName":"minuta","relative":{"0":"ta minuta"},"relativeTime":{"future":{"one":"za {0} minutę","few":"za {0} minuty","many":"za {0} minut","other":"za {0} minuty"},"past":{"one":"{0} minutę temu","few":"{0} minuty temu","many":"{0} minut temu","other":"{0} minuty temu"}}},"minute-short":{"displayName":"min","relative":{"0":"ta minuta"},"relativeTime":{"future":{"one":"za {0} min","few":"za {0} min","many":"za {0} min","other":"za {0} min"},"past":{"one":"{0} min temu","few":"{0} min temu","many":"{0} min temu","other":"{0} min temu"}}},"second":{"displayName":"sekunda","relative":{"0":"teraz"},"relativeTime":{"future":{"one":"za {0} sekundę","few":"za {0} sekundy","many":"za {0} sekund","other":"za {0} sekundy"},"past":{"one":"{0} sekundę temu","few":"{0} sekundy temu","many":"{0} sekund temu","other":"{0} sekundy temu"}}},"second-short":{"displayName":"sek.","relative":{"0":"teraz"},"relativeTime":{"future":{"one":"za {0} sek.","few":"za {0} sek.","many":"za {0} sek.","other":"za {0} sek."},"past":{"one":"{0} sek. temu","few":"{0} sek. temu","many":"{0} sek. temu","other":"{0} sek. temu"}}}}},
    {"locale":"prg","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), f = s[1] || '', v = f.length,
          t0 = Number(s[0]) == n, n10 = t0 && s[0].slice(-1),
          n100 = t0 && s[0].slice(-2), f100 = f.slice(-2), f10 = f.slice(-1);
      if (ord) return 'other';
      return (t0 && n10 == 0 || (n100 >= 11 && n100 <= 19)
              || v == 2 && (f100 >= 11 && f100 <= 19)) ? 'zero'
          : (n10 == 1 && n100 != 11 || v == 2 && f10 == 1 && f100 != 11
              || v != 2 && f10 == 1) ? 'one'
          : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ps","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"کال","relative":{"0":"سږکال","1":"بل کال","-1":"پروسږکال"},"relativeTime":{"future":{"one":"په {0} کال کې","other":"په {0} کالونو کې"},"past":{"one":"{0} کال مخکې","other":"{0} کاله مخکې"}}},"year-short":{"displayName":"کال","relative":{"0":"سږکال","1":"بل کال","-1":"پروسږکال"},"relativeTime":{"future":{"one":"په {0} کال کې","other":"په {0} کالونو کې"},"past":{"one":"{0} کال مخکې","other":"{0} کاله مخکې"}}},"month":{"displayName":"مياشت","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"+{0} m","other":"+{0} m"},"past":{"one":"-{0} m","other":"-{0} m"}}},"month-short":{"displayName":"مياشت","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"+{0} m","other":"+{0} m"},"past":{"one":"-{0} m","other":"-{0} m"}}},"week":{"displayName":"اونۍ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"+{0} w","other":"+{0} w"},"past":{"one":"-{0} w","other":"-{0} w"}}},"week-short":{"displayName":"اونۍ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"+{0} w","other":"+{0} w"},"past":{"one":"-{0} w","other":"-{0} w"}}},"day":{"displayName":"ورځ","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"+{0} d","other":"+{0} d"},"past":{"one":"-{0} d","other":"-{0} d"}}},"day-short":{"displayName":"ورځ","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"one":"+{0} d","other":"+{0} d"},"past":{"one":"-{0} d","other":"-{0} d"}}},"hour":{"displayName":"ساعت","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"+{0} h","other":"+{0} h"},"past":{"one":"-{0} h","other":"-{0} h"}}},"hour-short":{"displayName":"ساعت","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"+{0} h","other":"+{0} h"},"past":{"one":"-{0} h","other":"-{0} h"}}},"minute":{"displayName":"دقيقه","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"+{0} min","other":"+{0} min"},"past":{"one":"-{0} min","other":"-{0} min"}}},"minute-short":{"displayName":"دقيقه","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"+{0} min","other":"+{0} min"},"past":{"one":"-{0} min","other":"-{0} min"}}},"second":{"displayName":"ثانيه","relative":{"0":"now"},"relativeTime":{"future":{"one":"+{0} s","other":"+{0} s"},"past":{"one":"-{0} s","other":"-{0} s"}}},"second-short":{"displayName":"ثانيه","relative":{"0":"now"},"relativeTime":{"future":{"one":"+{0} s","other":"+{0} s"},"past":{"one":"-{0} s","other":"-{0} s"}}}}},
    {"locale":"pt","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0];
      if (ord) return 'other';
      return ((i == 0
              || i == 1)) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ano","relative":{"0":"este ano","1":"próximo ano","-1":"ano passado"},"relativeTime":{"future":{"one":"em {0} ano","other":"em {0} anos"},"past":{"one":"há {0} ano","other":"há {0} anos"}}},"year-short":{"displayName":"ano","relative":{"0":"este ano","1":"próximo ano","-1":"ano passado"},"relativeTime":{"future":{"one":"em {0} ano","other":"em {0} anos"},"past":{"one":"há {0} ano","other":"há {0} anos"}}},"month":{"displayName":"mês","relative":{"0":"este mês","1":"próximo mês","-1":"mês passado"},"relativeTime":{"future":{"one":"em {0} mês","other":"em {0} meses"},"past":{"one":"há {0} mês","other":"há {0} meses"}}},"month-short":{"displayName":"mês","relative":{"0":"este mês","1":"próximo mês","-1":"mês passado"},"relativeTime":{"future":{"one":"em {0} mês","other":"em {0} meses"},"past":{"one":"há {0} mês","other":"há {0} meses"}}},"week":{"displayName":"semana","relativePeriod":"a semana de {0}","relative":{"0":"esta semana","1":"próxima semana","-1":"semana passada"},"relativeTime":{"future":{"one":"em {0} semana","other":"em {0} semanas"},"past":{"one":"há {0} semana","other":"há {0} semanas"}}},"week-short":{"displayName":"sem.","relativePeriod":"a semana de {0}","relative":{"0":"esta semana","1":"próxima semana","-1":"semana passada"},"relativeTime":{"future":{"one":"em {0} sem.","other":"em {0} sem."},"past":{"one":"há {0} sem.","other":"há {0} sem."}}},"day":{"displayName":"dia","relative":{"0":"hoje","1":"amanhã","2":"depois de amanhã","-2":"anteontem","-1":"ontem"},"relativeTime":{"future":{"one":"em {0} dia","other":"em {0} dias"},"past":{"one":"há {0} dia","other":"há {0} dias"}}},"day-short":{"displayName":"dia","relative":{"0":"hoje","1":"amanhã","2":"depois de amanhã","-2":"anteontem","-1":"ontem"},"relativeTime":{"future":{"one":"em {0} dia","other":"em {0} dias"},"past":{"one":"há {0} dia","other":"há {0} dias"}}},"hour":{"displayName":"hora","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"em {0} hora","other":"em {0} horas"},"past":{"one":"há {0} hora","other":"há {0} horas"}}},"hour-short":{"displayName":"h","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"em {0} h","other":"em {0} h"},"past":{"one":"há {0} h","other":"há {0} h"}}},"minute":{"displayName":"minuto","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"em {0} minuto","other":"em {0} minutos"},"past":{"one":"há {0} minuto","other":"há {0} minutos"}}},"minute-short":{"displayName":"min.","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"em {0} min.","other":"em {0} min."},"past":{"one":"há {0} min.","other":"há {0} min."}}},"second":{"displayName":"segundo","relative":{"0":"agora"},"relativeTime":{"future":{"one":"em {0} segundo","other":"em {0} segundos"},"past":{"one":"há {0} segundo","other":"há {0} segundos"}}},"second-short":{"displayName":"seg.","relative":{"0":"agora"},"relativeTime":{"future":{"one":"em {0} seg.","other":"em {0} seg."},"past":{"one":"há {0} seg.","other":"há {0} seg."}}}}},{"locale":"pt-AO","parentLocale":"pt-PT"},{"locale":"pt-PT","parentLocale":"pt","pluralRuleFunction":function(n
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ano","relative":{"0":"este ano","1":"próximo ano","-1":"ano passado"},"relativeTime":{"future":{"one":"dentro de {0} ano","other":"dentro de {0} anos"},"past":{"one":"há {0} ano","other":"há {0} anos"}}},"year-short":{"displayName":"ano","relative":{"0":"este ano","1":"próximo ano","-1":"ano passado"},"relativeTime":{"future":{"one":"dentro de {0} ano","other":"dentro de {0} anos"},"past":{"one":"há {0} ano","other":"há {0} anos"}}},"month":{"displayName":"mês","relative":{"0":"este mês","1":"próximo mês","-1":"mês passado"},"relativeTime":{"future":{"one":"dentro de {0} mês","other":"dentro de {0} meses"},"past":{"one":"há {0} mês","other":"há {0} meses"}}},"month-short":{"displayName":"mês","relative":{"0":"este mês","1":"próximo mês","-1":"mês passado"},"relativeTime":{"future":{"one":"dentro de {0} mês","other":"dentro de {0} meses"},"past":{"one":"há {0} mês","other":"há {0} meses"}}},"week":{"displayName":"semana","relativePeriod":"a semana de {0}","relative":{"0":"esta semana","1":"próxima semana","-1":"semana passada"},"relativeTime":{"future":{"one":"dentro de {0} semana","other":"dentro de {0} semanas"},"past":{"one":"há {0} semana","other":"há {0} semanas"}}},"week-short":{"displayName":"sem.","relativePeriod":"a sem. de {0}","relative":{"0":"esta semana","1":"próxima semana","-1":"semana passada"},"relativeTime":{"future":{"one":"dentro de {0} sem.","other":"dentro de {0} sem."},"past":{"one":"há {0} sem.","other":"há {0} sem."}}},"day":{"displayName":"dia","relative":{"0":"hoje","1":"amanhã","2":"depois de amanhã","-2":"anteontem","-1":"ontem"},"relativeTime":{"future":{"one":"dentro de {0} dia","other":"dentro de {0} dias"},"past":{"one":"há {0} dia","other":"há {0} dias"}}},"day-short":{"displayName":"dia","relative":{"0":"hoje","1":"amanhã","2":"depois de amanhã","-2":"anteontem","-1":"ontem"},"relativeTime":{"future":{"one":"dentro de {0} dia","other":"dentro de {0} dias"},"past":{"one":"há {0} dia","other":"há {0} dias"}}},"hour":{"displayName":"hora","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} hora","other":"dentro de {0} horas"},"past":{"one":"há {0} hora","other":"há {0} horas"}}},"hour-short":{"displayName":"h","relative":{"0":"esta hora"},"relativeTime":{"future":{"one":"dentro de {0} h","other":"dentro de {0} h"},"past":{"one":"há {0} h","other":"há {0} h"}}},"minute":{"displayName":"minuto","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} minuto","other":"dentro de {0} minutos"},"past":{"one":"há {0} minuto","other":"há {0} minutos"}}},"minute-short":{"displayName":"min","relative":{"0":"este minuto"},"relativeTime":{"future":{"one":"dentro de {0} min","other":"dentro de {0} min"},"past":{"one":"há {0} min","other":"há {0} min"}}},"second":{"displayName":"segundo","relative":{"0":"agora"},"relativeTime":{"future":{"one":"dentro de {0} segundo","other":"dentro de {0} segundos"},"past":{"one":"há {0} segundo","other":"há {0} segundos"}}},"second-short":{"displayName":"s","relative":{"0":"agora"},"relativeTime":{"future":{"one":"dentro de {0} s","other":"dentro de {0} s"},"past":{"one":"há {0} s","other":"há {0} s"}}}}},{"locale":"pt-CH","parentLocale":"pt-PT"},{"locale":"pt-CV","parentLocale":"pt-PT"},{"locale":"pt-GQ","parentLocale":"pt-PT"},{"locale":"pt-GW","parentLocale":"pt-PT"},{"locale":"pt-LU","parentLocale":"pt-PT"},{"locale":"pt-MO","parentLocale":"pt-PT"},{"locale":"pt-MZ","parentLocale":"pt-PT"},{"locale":"pt-ST","parentLocale":"pt-PT"},{"locale":"pt-TL","parentLocale":"pt-PT"},
    {"locale":"qu","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"kunan wata","1":"hamuq wata","-1":"qayna wata"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"kunan wata","1":"hamuq wata","-1":"qayna wata"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"kunan killa","1":"hamuq killa","-1":"qayna killa"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"kunan killa","1":"hamuq killa","-1":"qayna killa"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"{0} semanapi","relative":{"0":"kunan semana","1":"hamuq semana","-1":"qayna semana"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"{0} semanapi","relative":{"0":"kunan semana","1":"hamuq semana","-1":"qayna semana"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"kunan punchaw","1":"paqarin","-1":"qayna punchaw"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"kunan punchaw","1":"paqarin","-1":"qayna punchaw"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"kay hora"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"kay hora"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"kay minuto"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"kay minuto"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"qu-BO","parentLocale":"qu"},{"locale":"qu-EC","parentLocale":"qu"},
    {"locale":"rm","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"onn","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"onn","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"mais","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"mais","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"emna","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"emna","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Tag","relative":{"0":"oz","1":"damaun","2":"puschmaun","-2":"stersas","-1":"ier"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Tag","relative":{"0":"oz","1":"damaun","2":"puschmaun","-2":"stersas","-1":"ier"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"ura","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"ura","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"minuta","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"minuta","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"secunda","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"secunda","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"rn","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Umwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Umwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Ukwezi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Ukwezi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Indwi, Iyinga","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Indwi, Iyinga","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Umusi","relative":{"0":"Uyu musi","1":"Ejo (hazoza)","-1":"Ejo (haheze)"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Umusi","relative":{"0":"Uyu musi","1":"Ejo (hazoza)","-1":"Ejo (haheze)"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Isaha","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Isaha","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Umunota","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Umunota","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Isegonda","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Isegonda","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ro","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1], t0 = Number(s[0]) == n,
          n100 = t0 && s[0].slice(-2);
      if (ord) return (n == 1) ? 'one' : 'other';
      return (n == 1 && v0) ? 'one'
          : (!v0 || n == 0
              || n != 1 && (n100 >= 1 && n100 <= 19)) ? 'few'
          : 'other';
    },"fields":{"year":{"displayName":"an","relative":{"0":"anul acesta","1":"anul viitor","-1":"anul trecut"},"relativeTime":{"future":{"one":"peste {0} an","few":"peste {0} ani","other":"peste {0} de ani"},"past":{"one":"acum {0} an","few":"acum {0} ani","other":"acum {0} de ani"}}},"year-short":{"displayName":"an","relative":{"0":"anul acesta","1":"anul viitor","-1":"anul trecut"},"relativeTime":{"future":{"one":"peste {0} an","few":"peste {0} ani","other":"peste {0} de ani"},"past":{"one":"acum {0} an","few":"acum {0} ani","other":"acum {0} de ani"}}},"month":{"displayName":"lună","relative":{"0":"luna aceasta","1":"luna viitoare","-1":"luna trecută"},"relativeTime":{"future":{"one":"peste {0} lună","few":"peste {0} luni","other":"peste {0} de luni"},"past":{"one":"acum {0} lună","few":"acum {0} luni","other":"acum {0} de luni"}}},"month-short":{"displayName":"lună","relative":{"0":"luna aceasta","1":"luna viitoare","-1":"luna trecută"},"relativeTime":{"future":{"one":"peste {0} lună","few":"peste {0} luni","other":"peste {0} luni"},"past":{"one":"acum {0} lună","few":"acum {0} luni","other":"acum {0} luni"}}},"week":{"displayName":"săptămână","relativePeriod":"săptămâna cu {0}","relative":{"0":"săptămâna aceasta","1":"săptămâna viitoare","-1":"săptămâna trecută"},"relativeTime":{"future":{"one":"peste {0} săptămână","few":"peste {0} săptămâni","other":"peste {0} de săptămâni"},"past":{"one":"acum {0} săptămână","few":"acum {0} săptămâni","other":"acum {0} de săptămâni"}}},"week-short":{"displayName":"săpt.","relativePeriod":"săpt. cu {0}","relative":{"0":"săpt. aceasta","1":"săpt. viitoare","-1":"săpt. trecută"},"relativeTime":{"future":{"one":"peste {0} săpt.","few":"peste {0} săpt.","other":"peste {0} săpt."},"past":{"one":"acum {0} săpt.","few":"acum {0} săpt.","other":"acum {0} săpt."}}},"day":{"displayName":"zi","relative":{"0":"azi","1":"mâine","2":"poimâine","-2":"alaltăieri","-1":"ieri"},"relativeTime":{"future":{"one":"peste {0} zi","few":"peste {0} zile","other":"peste {0} de zile"},"past":{"one":"acum {0} zi","few":"acum {0} zile","other":"acum {0} de zile"}}},"day-short":{"displayName":"zi","relative":{"0":"azi","1":"mâine","2":"poimâine","-2":"alaltăieri","-1":"ieri"},"relativeTime":{"future":{"one":"peste {0} zi","few":"peste {0} zile","other":"peste {0} de zile"},"past":{"one":"acum {0} zi","few":"acum {0} zile","other":"acum {0} de zile"}}},"hour":{"displayName":"oră","relative":{"0":"ora aceasta"},"relativeTime":{"future":{"one":"peste {0} oră","few":"peste {0} ore","other":"peste {0} de ore"},"past":{"one":"acum {0} oră","few":"acum {0} ore","other":"acum {0} de ore"}}},"hour-short":{"displayName":"h","relative":{"0":"ora aceasta"},"relativeTime":{"future":{"one":"peste {0} h","few":"peste {0} h","other":"peste {0} h"},"past":{"one":"acum {0} h","few":"acum {0} h","other":"acum {0} h"}}},"minute":{"displayName":"minut","relative":{"0":"minutul acesta"},"relativeTime":{"future":{"one":"peste {0} minut","few":"peste {0} minute","other":"peste {0} de minute"},"past":{"one":"acum {0} minut","few":"acum {0} minute","other":"acum {0} de minute"}}},"minute-short":{"displayName":"min.","relative":{"0":"minutul acesta"},"relativeTime":{"future":{"one":"peste {0} min.","few":"peste {0} min.","other":"peste {0} min."},"past":{"one":"acum {0} min.","few":"acum {0} min.","other":"acum {0} min."}}},"second":{"displayName":"secundă","relative":{"0":"acum"},"relativeTime":{"future":{"one":"peste {0} secundă","few":"peste {0} secunde","other":"peste {0} de secunde"},"past":{"one":"acum {0} secundă","few":"acum {0} secunde","other":"acum {0} de secunde"}}},"second-short":{"displayName":"sec.","relative":{"0":"acum"},"relativeTime":{"future":{"one":"peste {0} sec.","few":"peste {0} sec.","other":"peste {0} sec."},"past":{"one":"acum {0} sec.","few":"acum {0} sec.","other":"acum {0} sec."}}}}},{"locale":"ro-MD","parentLocale":"ro"},
    {"locale":"rof","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Muaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Muaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mweri","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mweri","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Iwiki","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Iwiki","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Mfiri","relative":{"0":"Linu","1":"Ng’ama","-1":"Hiyo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Mfiri","relative":{"0":"Linu","1":"Ng’ama","-1":"Hiyo"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Isaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Isaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Dakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Dakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ru","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], v0 = !s[1], i10 = i.slice(-1),
          i100 = i.slice(-2);
      if (ord) return 'other';
      return (v0 && i10 == 1 && i100 != 11) ? 'one'
          : (v0 && (i10 >= 2 && i10 <= 4) && (i100 < 12
              || i100 > 14)) ? 'few'
          : (v0 && i10 == 0 || v0 && (i10 >= 5 && i10 <= 9)
              || v0 && (i100 >= 11 && i100 <= 14)) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"год","relative":{"0":"в этом году","1":"в следующем году","-1":"в прошлом году"},"relativeTime":{"future":{"one":"через {0} год","few":"через {0} года","many":"через {0} лет","other":"через {0} года"},"past":{"one":"{0} год назад","few":"{0} года назад","many":"{0} лет назад","other":"{0} года назад"}}},"year-short":{"displayName":"г.","relative":{"0":"в этом г.","1":"в след. г.","-1":"в прошлом г."},"relativeTime":{"future":{"one":"через {0} г.","few":"через {0} г.","many":"через {0} л.","other":"через {0} г."},"past":{"one":"{0} г. назад","few":"{0} г. назад","many":"{0} л. назад","other":"{0} г. назад"}}},"month":{"displayName":"месяц","relative":{"0":"в этом месяце","1":"в следующем месяце","-1":"в прошлом месяце"},"relativeTime":{"future":{"one":"через {0} месяц","few":"через {0} месяца","many":"через {0} месяцев","other":"через {0} месяца"},"past":{"one":"{0} месяц назад","few":"{0} месяца назад","many":"{0} месяцев назад","other":"{0} месяца назад"}}},"month-short":{"displayName":"мес.","relative":{"0":"в этом мес.","1":"в следующем мес.","-1":"в прошлом мес."},"relativeTime":{"future":{"one":"через {0} мес.","few":"через {0} мес.","many":"через {0} мес.","other":"через {0} мес."},"past":{"one":"{0} мес. назад","few":"{0} мес. назад","many":"{0} мес. назад","other":"{0} мес. назад"}}},"week":{"displayName":"неделя","relativePeriod":"на неделе {0}","relative":{"0":"на этой неделе","1":"на следующей неделе","-1":"на прошлой неделе"},"relativeTime":{"future":{"one":"через {0} неделю","few":"через {0} недели","many":"через {0} недель","other":"через {0} недели"},"past":{"one":"{0} неделю назад","few":"{0} недели назад","many":"{0} недель назад","other":"{0} недели назад"}}},"week-short":{"displayName":"нед.","relativePeriod":"на нед. {0}","relative":{"0":"на этой нед.","1":"на следующей нед.","-1":"на прошлой нед."},"relativeTime":{"future":{"one":"через {0} нед.","few":"через {0} нед.","many":"через {0} нед.","other":"через {0} нед."},"past":{"one":"{0} нед. назад","few":"{0} нед. назад","many":"{0} нед. назад","other":"{0} нед. назад"}}},"day":{"displayName":"день","relative":{"0":"сегодня","1":"завтра","2":"послезавтра","-2":"позавчера","-1":"вчера"},"relativeTime":{"future":{"one":"через {0} день","few":"через {0} дня","many":"через {0} дней","other":"через {0} дня"},"past":{"one":"{0} день назад","few":"{0} дня назад","many":"{0} дней назад","other":"{0} дня назад"}}},"day-short":{"displayName":"дн.","relative":{"0":"сегодня","1":"завтра","2":"послезавтра","-2":"позавчера","-1":"вчера"},"relativeTime":{"future":{"one":"через {0} дн.","few":"через {0} дн.","many":"через {0} дн.","other":"через {0} дн."},"past":{"one":"{0} дн. назад","few":"{0} дн. назад","many":"{0} дн. назад","other":"{0} дн. назад"}}},"hour":{"displayName":"час","relative":{"0":"в этот час"},"relativeTime":{"future":{"one":"через {0} час","few":"через {0} часа","many":"через {0} часов","other":"через {0} часа"},"past":{"one":"{0} час назад","few":"{0} часа назад","many":"{0} часов назад","other":"{0} часа назад"}}},"hour-short":{"displayName":"ч","relative":{"0":"в этот час"},"relativeTime":{"future":{"one":"через {0} ч.","few":"через {0} ч.","many":"через {0} ч.","other":"через {0} ч."},"past":{"one":"{0} ч. назад","few":"{0} ч. назад","many":"{0} ч. назад","other":"{0} ч. назад"}}},"minute":{"displayName":"минута","relative":{"0":"в эту минуту"},"relativeTime":{"future":{"one":"через {0} минуту","few":"через {0} минуты","many":"через {0} минут","other":"через {0} минуты"},"past":{"one":"{0} минуту назад","few":"{0} минуты назад","many":"{0} минут назад","other":"{0} минуты назад"}}},"minute-short":{"displayName":"мин.","relative":{"0":"в эту минуту"},"relativeTime":{"future":{"one":"через {0} мин.","few":"через {0} мин.","many":"через {0} мин.","other":"через {0} мин."},"past":{"one":"{0} мин. назад","few":"{0} мин. назад","many":"{0} мин. назад","other":"{0} мин. назад"}}},"second":{"displayName":"секунда","relative":{"0":"сейчас"},"relativeTime":{"future":{"one":"через {0} секунду","few":"через {0} секунды","many":"через {0} секунд","other":"через {0} секунды"},"past":{"one":"{0} секунду назад","few":"{0} секунды назад","many":"{0} секунд назад","other":"{0} секунды назад"}}},"second-short":{"displayName":"сек.","relative":{"0":"сейчас"},"relativeTime":{"future":{"one":"через {0} сек.","few":"через {0} сек.","many":"через {0} сек.","other":"через {0} сек."},"past":{"one":"{0} сек. назад","few":"{0} сек. назад","many":"{0} сек. назад","other":"{0} сек. назад"}}}}},{"locale":"ru-BY","parentLocale":"ru"},{"locale":"ru-KG","parentLocale":"ru"},{"locale":"ru-KZ","parentLocale":"ru"},{"locale":"ru-MD","parentLocale":"ru"},{"locale":"ru-UA","parentLocale":"ru"},
    {"locale":"rw","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"rwk","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Maka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Maka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mori","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mori","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Wiikyi","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Wiikyi","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Mfiri","relative":{"0":"Inu","1":"Ngama","-1":"Ukou"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Mfiri","relative":{"0":"Inu","1":"Ngama","-1":"Ukou"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Dakyika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Dakyika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"sah","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Сыл","relative":{"0":"быйыл","1":"эһиил","-1":"Былырыын"},"relativeTime":{"future":{"other":"{0} сылынан"},"past":{"other":"{0} сыл ынараа өттүгэр"}}},"year-short":{"displayName":"Сыл","relative":{"0":"быйыл","1":"эһиил","-1":"Былырыын"},"relativeTime":{"future":{"other":"{0} сылынан"},"past":{"other":"{0} сыл ынараа өттүгэр"}}},"month":{"displayName":"Ый","relative":{"0":"бу ый","1":"аныгыскы ый","-1":"ааспыт ый"},"relativeTime":{"future":{"other":"{0} ыйынан"},"past":{"other":"{0} ый ынараа өттүгэр"}}},"month-short":{"displayName":"Ый","relative":{"0":"бу ый","1":"аныгыскы ый","-1":"ааспыт ый"},"relativeTime":{"future":{"other":"{0} ыйынан"},"past":{"other":"{0} ый ынараа өттүгэр"}}},"week":{"displayName":"Нэдиэлэ","relativePeriod":"the week of {0}","relative":{"0":"бу нэдиэлэ","1":"кэлэр нэдиэлэ","-1":"ааспыт нэдиэлэ"},"relativeTime":{"future":{"other":"{0} нэдиэлэннэн"},"past":{"other":"{0} нэдиэлэ анараа өттүгэр"}}},"week-short":{"displayName":"Нэдиэлэ","relativePeriod":"the week of {0}","relative":{"0":"бу нэдиэлэ","1":"кэлэр нэдиэлэ","-1":"ааспыт нэдиэлэ"},"relativeTime":{"future":{"other":"{0} нэдиэлэннэн"},"past":{"other":"{0} нэдиэлэ анараа өттүгэр"}}},"day":{"displayName":"Күн","relative":{"0":"Бүгүн","1":"Сарсын","2":"Өйүүн","-2":"Иллэрээ күн","-1":"Бэҕэһээ"},"relativeTime":{"future":{"other":"{0} күнүнэн"},"past":{"other":"{0} күн ынараа өттүгэр"}}},"day-short":{"displayName":"Күн","relative":{"0":"Бүгүн","1":"Сарсын","2":"Өйүүн","-2":"Иллэрээ күн","-1":"Бэҕэһээ"},"relativeTime":{"future":{"other":"{0} күнүнэн"},"past":{"other":"{0} күн ынараа өттүгэр"}}},"hour":{"displayName":"Чаас","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"{0} чааһынан"},"past":{"other":"{0} чаас ынараа өттүгэр"}}},"hour-short":{"displayName":"Чаас","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"{0} чааһынан"},"past":{"other":"{0} чаас ынараа өттүгэр"}}},"minute":{"displayName":"Мүнүүтэ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"{0} мүнүүтэннэн"},"past":{"other":"{0} мүнүүтэ ынараа өттүгэр"}}},"minute-short":{"displayName":"Мүнүүтэ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"{0} мүнүүтэннэн"},"past":{"other":"{0} мүнүүтэ ынараа өттүгэр"}}},"second":{"displayName":"Сөкүүндэ","relative":{"0":"билигин"},"relativeTime":{"future":{"other":"{0} сөкүүндэннэн"},"past":{"other":"{0} сөкүүндэ ынараа өттүгэр"}}},"second-short":{"displayName":"Сөкүүндэ","relative":{"0":"билигин"},"relativeTime":{"future":{"other":"{0} сөкүүндэннэн"},"past":{"other":"{0} сөк. анараа өттүгэр"}}}}},
    {"locale":"saq","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Lari","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Lari","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Lapa","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Lapa","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Saipa napo","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Saipa napo","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Mpari","relative":{"0":"Duo","1":"Taisere","-1":"Ng’ole"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Mpari","relative":{"0":"Duo","1":"Taisere","-1":"Ng’ole"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Saai","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Saai","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Idakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Idakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Isekondi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Isekondi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"sbp","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Mwakha","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Mwakha","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mwesi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mwesi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Ilijuma","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Ilijuma","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Lusiku","relative":{"0":"Ineng’uni","1":"Pamulaawu","-1":"Imehe"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Lusiku","relative":{"0":"Ineng’uni","1":"Pamulaawu","-1":"Imehe"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Ilisala","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Ilisala","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Idakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Idakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Isekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Isekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"sc","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      if (ord) return ((n == 11 || n == 8 || n == 80
              || n == 800)) ? 'many' : 'other';
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"scn","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      if (ord) return ((n == 11 || n == 8 || n == 80
              || n == 800)) ? 'many' : 'other';
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"sd","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"سال","relative":{"0":"پويون سال","1":"پويون سال","-1":"پويون سال"},"relativeTime":{"future":{"one":"{0} سالن ۾","other":"{0} سالن ۾"},"past":{"one":"{0} سال پهرين","other":"{0} سال پهرين"}}},"year-short":{"displayName":"سال","relative":{"0":"پويون سال","1":"پويون سال","-1":"پويون سال"},"relativeTime":{"future":{"one":"{0} سالن ۾","other":"{0} سالن ۾"},"past":{"one":"{0} سال پهرين","other":"{0} سال پهرين"}}},"month":{"displayName":"مهينو","relative":{"0":"هن مهيني","1":"اڳين مهيني","-1":"پوئين مهيني"},"relativeTime":{"future":{"one":"{0} مهينن ۾","other":"{0} مهينن ۾"},"past":{"one":"{0} مهينا پهرين","other":"{0} مهينا پهرين"}}},"month-short":{"displayName":"مهينو","relative":{"0":"هن مهيني","1":"اڳين مهيني","-1":"پوئين مهيني"},"relativeTime":{"future":{"one":"{0} مهينن ۾","other":"{0} مهينن ۾"},"past":{"one":"{0} مهينا پهرين","other":"{0} مهينا پهرين"}}},"week":{"displayName":"هفتو","relativePeriod":"{0} جي هفتي","relative":{"0":"هن هفتي","1":"اڳين هفتي","-1":"پوئين هفتي"},"relativeTime":{"future":{"one":"{0} هفتن ۾","other":"{0} هفتن ۾"},"past":{"one":"{0} هفتا پهرين","other":"{0} هفتا پهرين"}}},"week-short":{"displayName":"هفتو","relativePeriod":"{0} جي هفتي","relative":{"0":"هن هفتي","1":"اڳين هفتي","-1":"پوئين هفتي"},"relativeTime":{"future":{"one":"{0} هفتن ۾","other":"{0} هفتن ۾"},"past":{"one":"{0} هفتا پهرين","other":"{0} هفتا پهرين"}}},"day":{"displayName":"ڏينهن","relative":{"0":"اڄ","1":"سڀاڻي","-1":"ڪل"},"relativeTime":{"future":{"one":"{0} ڏينهن ۾","other":"{0} ڏينهن ۾"},"past":{"one":"{0} ڏينهن پهرين","other":"{0} ڏينهن پهرين"}}},"day-short":{"displayName":"ڏينهن","relative":{"0":"اڄ","1":"سڀاڻي","-1":"ڪل"},"relativeTime":{"future":{"one":"{0} ڏينهن ۾","other":"{0} ڏينهن ۾"},"past":{"one":"{0} ڏينهن پهرين","other":"{0} ڏينهن پهرين"}}},"hour":{"displayName":"ڪلاڪ","relative":{"0":"هن ڪلڪ"},"relativeTime":{"future":{"one":"{0} ڪلاڪ ۾","other":"{0} ڪلاڪ ۾"},"past":{"one":"{0} ڪلاڪ پهرين","other":"{0} ڪلاڪ پهرين"}}},"hour-short":{"displayName":"ڪلاڪ","relative":{"0":"هن ڪلڪ"},"relativeTime":{"future":{"one":"{0} ڪلاڪ ۾","other":"{0} ڪلاڪ ۾"},"past":{"one":"{0} ڪلاڪ پهرين","other":"{0} ڪلاڪ پهرين"}}},"minute":{"displayName":"منٽ","relative":{"0":"هن منٽ"},"relativeTime":{"future":{"one":"{0} منٽن ۾","other":"+{0} min"},"past":{"one":"{0} منٽ پهرين","other":"{0} منٽ پهرين"}}},"minute-short":{"displayName":"منٽ","relative":{"0":"هن منٽ"},"relativeTime":{"future":{"one":"{0} منٽن ۾","other":"{0} منٽن ۾"},"past":{"one":"{0} منٽ پهرين","other":"{0} منٽ پهرين"}}},"second":{"displayName":"سيڪنڊ","relative":{"0":"هاڻي"},"relativeTime":{"future":{"one":"{0} سيڪنڊن ۾","other":"{0} سيڪنڊن ۾"},"past":{"one":"{0} سيڪنڊ پهرين","other":"{0} سيڪنڊ پهرين"}}},"second-short":{"displayName":"سيڪنڊ","relative":{"0":"هاڻي"},"relativeTime":{"future":{"one":"{0} سيڪنڊن ۾","other":"{0} سيڪنڊن ۾"},"past":{"one":"{0} سيڪنڊ پهرين","other":"{0} سيڪنڊ پهرين"}}}}},
    {"locale":"sdh","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"se","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one'
          : (n == 2) ? 'two'
          : 'other';
    },"fields":{"year":{"displayName":"jáhki","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"one":"{0} jahki maŋŋilit","two":"{0} jahkki maŋŋilit","other":"{0} jahkki maŋŋilit"},"past":{"one":"{0} jahki árat","two":"{0} jahkki árat","other":"{0} jahkki árat"}}},"year-short":{"displayName":"jáhki","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"one":"{0} jahki maŋŋilit","two":"{0} jahkki maŋŋilit","other":"{0} jahkki maŋŋilit"},"past":{"one":"{0} jahki árat","two":"{0} jahkki árat","other":"{0} jahkki árat"}}},"month":{"displayName":"mánnu","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"{0} mánotbadji maŋŋilit","two":"{0} mánotbadji maŋŋilit","other":"{0} mánotbadji maŋŋilit"},"past":{"one":"{0} mánotbadji árat","two":"{0} mánotbadji árat","other":"{0} mánotbadji árat"}}},"month-short":{"displayName":"mánnu","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"{0} mánotbadji maŋŋilit","two":"{0} mánotbadji maŋŋilit","other":"{0} mánotbadji maŋŋilit"},"past":{"one":"{0} mánotbadji árat","two":"{0} mánotbadji árat","other":"{0} mánotbadji árat"}}},"week":{"displayName":"váhkku","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"{0} vahku maŋŋilit","two":"{0} vahkku maŋŋilit","other":"{0} vahkku maŋŋilit"},"past":{"one":"{0} vahku árat","two":"{0} vahkku árat","other":"{0} vahkku árat"}}},"week-short":{"displayName":"váhkku","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"{0} vahku maŋŋilit","two":"{0} vahkku maŋŋilit","other":"{0} vahkku maŋŋilit"},"past":{"one":"{0} vahku árat","two":"{0} vahkku árat","other":"{0} vahkku árat"}}},"day":{"displayName":"beaivi","relative":{"0":"odne","1":"ihttin","2":"paijeelittáá","-2":"oovdebpeivvi","-1":"ikte"},"relativeTime":{"future":{"one":"{0} jándor maŋŋilit","two":"{0} jándor amaŋŋilit","other":"{0} jándora maŋŋilit"},"past":{"one":"{0} jándor árat","two":"{0} jándora árat","other":"{0} jándora árat"}}},"day-short":{"displayName":"beaivi","relative":{"0":"odne","1":"ihttin","2":"paijeelittáá","-2":"oovdebpeivvi","-1":"ikte"},"relativeTime":{"future":{"one":"{0} jándor maŋŋilit","two":"{0} jándor amaŋŋilit","other":"{0} jándora maŋŋilit"},"past":{"one":"{0} jándor árat","two":"{0} jándora árat","other":"{0} jándora árat"}}},"hour":{"displayName":"diibmu","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"{0} diibmu maŋŋilit","two":"{0} diibmur maŋŋilit","other":"{0} diibmur maŋŋilit"},"past":{"one":"{0} diibmu árat","two":"{0} diibmur árat","other":"{0} diibmur árat"}}},"hour-short":{"displayName":"diibmu","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"{0} diibmu maŋŋilit","two":"{0} diibmur maŋŋilit","other":"{0} diibmur maŋŋilit"},"past":{"one":"{0} diibmu árat","two":"{0} diibmur árat","other":"{0} diibmur árat"}}},"minute":{"displayName":"minuhtta","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"{0} minuhta maŋŋilit","two":"{0} minuhtta maŋŋilit","other":"{0} minuhtta maŋŋilit"},"past":{"one":"{0} minuhta árat","two":"{0} minuhtta árat","other":"{0} minuhtta árat"}}},"minute-short":{"displayName":"minuhtta","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"{0} minuhta maŋŋilit","two":"{0} minuhtta maŋŋilit","other":"{0} minuhtta maŋŋilit"},"past":{"one":"{0} minuhta árat","two":"{0} minuhtta árat","other":"{0} minuhtta árat"}}},"second":{"displayName":"sekunda","relative":{"0":"now"},"relativeTime":{"future":{"one":"{0} sekunda maŋŋilit","two":"{0} sekundda maŋŋilit","other":"{0} sekundda maŋŋilit"},"past":{"one":"{0} sekunda árat","two":"{0} sekundda árat","other":"{0} sekundda árat"}}},"second-short":{"displayName":"sekunda","relative":{"0":"now"},"relativeTime":{"future":{"one":"{0} sekunda maŋŋilit","two":"{0} sekundda maŋŋilit","other":"{0} sekundda maŋŋilit"},"past":{"one":"{0} sekunda árat","two":"{0} sekundda árat","other":"{0} sekundda árat"}}}}},{"locale":"se-FI","parentLocale":"se","fields":{"year":{"displayName":"jahki","relative":{"0":"dán jagi","1":"boahtte jagi","-1":"diibmá"},"relativeTime":{"future":{"one":"{0} jagi siste","two":"{0} jagi siste","other":"{0} jagi siste"},"past":{"one":"diibmá","two":"ovddet jagi","other":"{0} jagi dás ovdal"}}},"year-short":{"displayName":"j.","relative":{"0":"dán jagi","1":"boahtte jagi","-1":"diibmá"},"relativeTime":{"future":{"one":"{0} j. siste","two":"{0} jagi siste","other":"{0} j. siste"},"past":{"one":"diibmá","two":"ovddet jagi","other":"{0} j. dás ovdal"}}},"month":{"displayName":"mánnu","relative":{"0":"dán mánu","1":"boahtte mánu","-1":"mannan mánu"},"relativeTime":{"future":{"one":"{0} mánu siste","two":"{0} mánu siste","other":"{0} mánu siste"},"past":{"one":"{0} mánnu dás ovdal","two":"{0} mánu dás ovdal","other":"{0} mánu dás ovdal"}}},"month-short":{"displayName":"m.","relative":{"0":"dán mánu","1":"boahtte mánu","-1":"mannan mánu"},"relativeTime":{"future":{"one":"{0} mánu siste","two":"{0} mánu siste","other":"{0} mánu siste"},"past":{"one":"{0} mánnu dás ovdal","two":"{0} mánu dás ovdal","other":"{0} mánu dás ovdal"}}},"week":{"displayName":"vahkku","relativePeriod":"{0} vahkku","relative":{"0":"dán vahku","1":"boahtte vahku","-1":"mannan vahku"},"relativeTime":{"future":{"one":"{0} vahku geahčen","two":"{0} vahku geahčen","other":"{0} vahku geahčen"},"past":{"one":"{0} vahkku dás ovdal","two":"{0} vahku dás ovdal","other":"{0} vahku dás ovdal"}}},"week-short":{"displayName":"v(k)","relativePeriod":"{0} vahkku","relative":{"0":"dán vahku","1":"boahtte vahku","-1":"mannan vahku"},"relativeTime":{"future":{"one":"{0} v(k) siste","two":"{0} vahku siste","other":"{0} v(k) siste"},"past":{"one":"{0} v(k) dás ovdal","two":"{0} vahku dás ovdal","other":"{0} v(k) dás ovdal"}}},"day":{"displayName":"beaivi","relative":{"0":"odne","1":"ihttin","2":"don beaivve","-2":"ovddet beaivvi","-1":"ikte"},"relativeTime":{"future":{"one":"{0} beaivve siste","two":"{0} beaivve siste","other":"{0} beaivve siste"},"past":{"one":"ikte","two":"ovddet beaivve","other":"{0} beaivve dás ovdal"}}},"day-short":{"displayName":"b.","relative":{"0":"odne","1":"ihttin","2":"don beaivve","-2":"ovddet beaivvi","-1":"ikte"},"relativeTime":{"future":{"one":"{0} beaivve siste","two":"{0} beaivve siste","other":"{0} beaivve siste"},"past":{"one":"ikte","two":"ovddet beaivve","other":"{0} beaivve dás ovdal"}}},"hour":{"displayName":"diibmu","relative":{"0":"dán diimmu"},"relativeTime":{"future":{"one":"{0} diimmu siste","two":"{0} diimmu siste","other":"{0} diimmu siste"},"past":{"one":"{0} diibmu áigi","two":"{0} diimmu áigi","other":"{0} diimmu áigi"}}},"hour-short":{"displayName":"dmu","relative":{"0":"dán diimmu"},"relativeTime":{"future":{"one":"{0} dmu siste","two":"{0} diimmu siste","other":"{0} dmu siste"},"past":{"one":"{0} dmu áigi","two":"{0} diimmu áigi","other":"{0} dmu áigi"}}},"minute":{"displayName":"minuhtta","relative":{"0":"dán minuhta"},"relativeTime":{"future":{"one":"{0} minuhta siste","two":"{0} minuhta siste","other":"{0} minuhta siste"},"past":{"one":"{0} minuhtta áigi","two":"{0} minuhta áigi","other":"{0} minuhta áigi"}}},"minute-short":{"displayName":"min.","relative":{"0":"dán minuhta"},"relativeTime":{"future":{"one":"{0} min. siste","two":"{0} minuhta siste","other":"{0} min. siste"},"past":{"one":"{0} min. áigi","two":"{0} minuhta áigi","other":"{0} min. áigi"}}},"second":{"displayName":"sekunda","relative":{"0":"dál"},"relativeTime":{"future":{"one":"{0} sekundda siste","two":"{0} sekundda siste","other":"{0} sekundda siste"},"past":{"one":"{0} sekunda áigi","two":"{0} sekundda áigi","other":"{0} sekundda áigi"}}},"second-short":{"displayName":"sek.","relative":{"0":"dál"},"relativeTime":{"future":{"one":"{0} sek. siste","two":"{0} sekundda siste","other":"{0} sek. siste"},"past":{"one":"{0} sek. áigi","two":"{0} sekundda áigi","other":"{0} sek. áigi"}}}}},{"locale":"se-SE","parentLocale":"se"},
    {"locale":"seh","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Chaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Chaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mwezi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mwezi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Ntsiku","relative":{"0":"Lero","1":"Manguana","-1":"Zuro"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Ntsiku","relative":{"0":"Lero","1":"Manguana","-1":"Zuro"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hora","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hora","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minuto","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minuto","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Segundo","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Segundo","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ses","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Jiiri","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Jiiri","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Handu","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Handu","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Hebu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Hebu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Zaari","relative":{"0":"Hõo","1":"Suba","-1":"Bi"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Zaari","relative":{"0":"Hõo","1":"Suba","-1":"Bi"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Guuru","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Guuru","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Miniti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Miniti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Miti","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Miti","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"sg","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Ngû","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Ngû","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Nze","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Nze","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Dimâsi","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Dimâsi","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Lâ","relative":{"0":"Lâsô","1":"Kêkerêke","-1":"Bîrï"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Lâ","relative":{"0":"Lâsô","1":"Kêkerêke","-1":"Bîrï"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Ngbonga","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Ngbonga","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Ndurü ngbonga","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Ndurü ngbonga","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Nzîna ngbonga","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Nzîna ngbonga","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"sh","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], f = s[1] || '', v0 = !s[1],
          i10 = i.slice(-1), i100 = i.slice(-2), f10 = f.slice(-1), f100 = f.slice(-2);
      if (ord) return 'other';
      return (v0 && i10 == 1 && i100 != 11
              || f10 == 1 && f100 != 11) ? 'one'
          : (v0 && (i10 >= 2 && i10 <= 4) && (i100 < 12 || i100 > 14)
              || (f10 >= 2 && f10 <= 4) && (f100 < 12
              || f100 > 14)) ? 'few'
          : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"shi","pluralRuleFunction":function(n
    ) {
      var s = String(n).split('.'), t0 = Number(s[0]) == n;
      return (n >= 0 && n <= 1) ? 'one'
          : ((t0 && n >= 2 && n <= 10)) ? 'few'
          : 'other';
    },"fields":{"year":{"displayName":"ⴰⵙⴳⴳⵯⴰⵙ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"ⴰⵙⴳⴳⵯⴰⵙ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"ⴰⵢⵢⵓⵔ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"ⴰⵢⵢⵓⵔ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"ⵉⵎⴰⵍⴰⵙⵙ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"ⵉⵎⴰⵍⴰⵙⵙ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"ⴰⵙⵙ","relative":{"0":"ⴰⵙⵙⴰ","1":"ⴰⵙⴽⴽⴰ","-1":"ⵉⴹⵍⵍⵉ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"ⴰⵙⵙ","relative":{"0":"ⴰⵙⵙⴰ","1":"ⴰⵙⴽⴽⴰ","-1":"ⵉⴹⵍⵍⵉ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"ⵜⴰⵙⵔⴰⴳⵜ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"ⵜⴰⵙⵔⴰⴳⵜ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"ⵜⵓⵙⴷⵉⴷⵜ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"ⵜⵓⵙⴷⵉⴷⵜ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"ⵜⴰⵙⵉⵏⵜ","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"ⵜⴰⵙⵉⵏⵜ","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"shi-Latn","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"asggʷas","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"asggʷas","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"ayyur","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"ayyur","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"imalass","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"imalass","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"ass","relative":{"0":"assa","1":"askka","-1":"iḍlli"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"ass","relative":{"0":"assa","1":"askka","-1":"iḍlli"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"tasragt","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"tasragt","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"tusdidt","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"tusdidt","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"tasint","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"tasint","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"shi-Tfng","parentLocale":"shi"},
    {"locale":"si","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], f = s[1] || '';
      if (ord) return 'other';
      return ((n == 0 || n == 1)
              || i == 0 && f == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"වර්ෂය","relative":{"0":"මෙම වසර","1":"ඊළඟ වසර","-1":"පසුගිය වසර"},"relativeTime":{"future":{"one":"වසර {0}කින්","other":"වසර {0}කින්"},"past":{"one":"වසර {0}කට පෙර","other":"වසර {0}කට පෙර"}}},"year-short":{"displayName":"වර්.","relative":{"0":"මෙම වසර","1":"ඊළඟ වසර","-1":"පසුගිය වසර"},"relativeTime":{"future":{"one":"වසර {0}කින්","other":"වසර {0}කින්"},"past":{"one":"වසර {0}කට පෙර","other":"වසර {0}කට පෙර"}}},"month":{"displayName":"මාසය","relative":{"0":"මෙම මාසය","1":"ඊළඟ මාසය","-1":"පසුගිය මාසය"},"relativeTime":{"future":{"one":"මාස {0}කින්","other":"මාස {0}කින්"},"past":{"one":"මාස {0}කට පෙර","other":"මාස {0}කට පෙර"}}},"month-short":{"displayName":"මාස.","relative":{"0":"මෙම මාස.","1":"ඊළඟ මාස.","-1":"පසුගිය මාස."},"relativeTime":{"future":{"one":"මාස {0}කින්","other":"මාස {0}කින්"},"past":{"one":"මාස {0}කට පෙර","other":"මාස {0}කට පෙර"}}},"week":{"displayName":"සතිය","relativePeriod":"{0} වෙනි සතිය","relative":{"0":"මෙම සතිය","1":"ඊළඟ සතිය","-1":"පසුගිය සතිය"},"relativeTime":{"future":{"one":"සති {0}කින්","other":"සති {0}කින්"},"past":{"one":"සති {0}කට පෙර","other":"සති {0}කට පෙර"}}},"week-short":{"displayName":"සති.","relativePeriod":"{0} වෙනි සතිය","relative":{"0":"මෙම සති.","1":"ඊළඟ සති.","-1":"පසුගිය සති."},"relativeTime":{"future":{"one":"සති {0}කින්","other":"සති {0}කින්"},"past":{"one":"සති {0}කට පෙර","other":"සති {0}කට පෙර"}}},"day":{"displayName":"දිනය","relative":{"0":"අද","1":"හෙට","2":"අනිද්දා","-2":"පෙරේදා","-1":"ඊයේ"},"relativeTime":{"future":{"one":"දින {0}න්","other":"දින {0}න්"},"past":{"one":"දින {0}කට පෙර","other":"දින {0}කට පෙර"}}},"day-short":{"displayName":"දිනය","relative":{"0":"අද","1":"හෙට","2":"අනිද්දා","-2":"පෙරේදා","-1":"ඊයේ"},"relativeTime":{"future":{"one":"දින {0}න්","other":"දින {0}න්"},"past":{"one":"දින {0}කට පෙර","other":"දින {0}කට පෙර"}}},"hour":{"displayName":"පැය","relative":{"0":"මෙම පැය"},"relativeTime":{"future":{"one":"පැය {0}කින්","other":"පැය {0}කින්"},"past":{"one":"පැය {0}කට පෙර","other":"පැය {0}කට පෙර"}}},"hour-short":{"displayName":"පැය","relative":{"0":"මෙම පැය"},"relativeTime":{"future":{"one":"පැය {0}කින්","other":"පැය {0}කින්"},"past":{"one":"පැය {0}කට පෙර","other":"පැය {0}කට පෙර"}}},"minute":{"displayName":"මිනිත්තුව","relative":{"0":"මෙම මිනිත්තුව"},"relativeTime":{"future":{"one":"මිනිත්තු {0}කින්","other":"මිනිත්තු {0}කින්"},"past":{"one":"මිනිත්තු {0}කට පෙර","other":"මිනිත්තු {0}කට පෙර"}}},"minute-short":{"displayName":"මිනි.","relative":{"0":"මෙම මිනිත්තුව"},"relativeTime":{"future":{"one":"මිනිත්තු {0}කින්","other":"මිනිත්තු {0}කින්"},"past":{"one":"මිනිත්තු {0}කට පෙර","other":"මිනිත්තු {0}කට පෙර"}}},"second":{"displayName":"තත්පරය","relative":{"0":"දැන්"},"relativeTime":{"future":{"one":"තත්පර {0}කින්","other":"තත්පර {0}කින්"},"past":{"one":"තත්පර {0}කට පෙර","other":"තත්පර {0}කට පෙර"}}},"second-short":{"displayName":"තත්.","relative":{"0":"දැන්"},"relativeTime":{"future":{"one":"තත්පර {0}කින්","other":"තත්පර {0}කින්"},"past":{"one":"තත්පර {0}කට පෙර","other":"තත්පර {0}කට පෙර"}}}}},
    {"locale":"sk","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], v0 = !s[1];
      if (ord) return 'other';
      return (n == 1 && v0) ? 'one'
          : ((i >= 2 && i <= 4) && v0) ? 'few'
          : (!v0) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"rok","relative":{"0":"tento rok","1":"budúci rok","-1":"minulý rok"},"relativeTime":{"future":{"one":"o {0} rok","few":"o {0} roky","many":"o {0} roka","other":"o {0} rokov"},"past":{"one":"pred {0} rokom","few":"pred {0} rokmi","many":"pred {0} roka","other":"pred {0} rokmi"}}},"year-short":{"displayName":"r.","relative":{"0":"tento rok","1":"budúci rok","-1":"minulý rok"},"relativeTime":{"future":{"one":"o {0} r.","few":"o {0} r.","many":"o {0} r.","other":"o {0} r."},"past":{"one":"pred {0} r.","few":"pred {0} r.","many":"pred {0} r.","other":"pred {0} r."}}},"month":{"displayName":"mesiac","relative":{"0":"tento mesiac","1":"budúci mesiac","-1":"minulý mesiac"},"relativeTime":{"future":{"one":"o {0} mesiac","few":"o {0} mesiace","many":"o {0} mesiaca","other":"o {0} mesiacov"},"past":{"one":"pred {0} mesiacom","few":"pred {0} mesiacmi","many":"pred {0} mesiaca","other":"pred {0} mesiacmi"}}},"month-short":{"displayName":"mes.","relative":{"0":"tento mes.","1":"budúci mes.","-1":"minulý mes."},"relativeTime":{"future":{"one":"o {0} mes.","few":"o {0} mes.","many":"o {0} mes.","other":"o {0} mes."},"past":{"one":"pred {0} mes.","few":"pred {0} mes.","many":"pred {0} mes.","other":"pred {0} mes."}}},"week":{"displayName":"týždeň","relativePeriod":"týždeň dňa {0}","relative":{"0":"tento týždeň","1":"budúci týždeň","-1":"minulý týždeň"},"relativeTime":{"future":{"one":"o {0} týždeň","few":"o {0} týždne","many":"o {0} týždňa","other":"o {0} týždňov"},"past":{"one":"pred {0} týždňom","few":"pred {0} týždňami","many":"pred {0} týždňa","other":"pred {0} týždňami"}}},"week-short":{"displayName":"týž.","relativePeriod":"týž. dňa {0}","relative":{"0":"tento týž.","1":"budúci týž.","-1":"minulý týž."},"relativeTime":{"future":{"one":"o {0} týž.","few":"o {0} týž.","many":"o {0} týž.","other":"o {0} týž."},"past":{"one":"pred {0} týž.","few":"pred {0} týž.","many":"pred {0} týž.","other":"pred {0} týž."}}},"day":{"displayName":"deň","relative":{"0":"dnes","1":"zajtra","2":"pozajtra","-2":"predvčerom","-1":"včera"},"relativeTime":{"future":{"one":"o {0} deň","few":"o {0} dni","many":"o {0} dňa","other":"o {0} dní"},"past":{"one":"pred {0} dňom","few":"pred {0} dňami","many":"pred {0} dňa","other":"pred {0} dňami"}}},"day-short":{"displayName":"d.","relative":{"0":"dnes","1":"zajtra","2":"pozajtra","-2":"predvčerom","-1":"včera"},"relativeTime":{"future":{"one":"o {0} d.","few":"o {0} d.","many":"o {0} d.","other":"o {0} d."},"past":{"one":"pred {0} d.","few":"pred {0} d.","many":"pred {0} d.","other":"pred {0} d."}}},"hour":{"displayName":"hodina","relative":{"0":"v tejto hodine"},"relativeTime":{"future":{"one":"o {0} hodinu","few":"o {0} hodiny","many":"o {0} hodiny","other":"o {0} hodín"},"past":{"one":"pred {0} hodinou","few":"pred {0} hodinami","many":"pred {0} hodinou","other":"pred {0} hodinami"}}},"hour-short":{"displayName":"h","relative":{"0":"v tejto hodine"},"relativeTime":{"future":{"one":"o {0} h","few":"o {0} h","many":"o {0} h","other":"o {0} h"},"past":{"one":"pred {0} h","few":"pred {0} h","many":"pred {0} h","other":"pred {0} h"}}},"minute":{"displayName":"minúta","relative":{"0":"v tejto minúte"},"relativeTime":{"future":{"one":"o {0} minútu","few":"o {0} minúty","many":"o {0} minúty","other":"o {0} minút"},"past":{"one":"pred {0} minútou","few":"pred {0} minútami","many":"pred {0} minúty","other":"pred {0} minútami"}}},"minute-short":{"displayName":"min","relative":{"0":"v tejto minúte"},"relativeTime":{"future":{"one":"o {0} min","few":"o {0} min","many":"o {0} min","other":"o {0} min"},"past":{"one":"pred {0} min","few":"pred {0} min","many":"pred {0} min","other":"pred {0} min"}}},"second":{"displayName":"sekunda","relative":{"0":"teraz"},"relativeTime":{"future":{"one":"o {0} sekundu","few":"o {0} sekundy","many":"o {0} sekundy","other":"o {0} sekúnd"},"past":{"one":"pred {0} sekundou","few":"pred {0} sekundami","many":"pred {0} sekundy","other":"pred {0} sekundami"}}},"second-short":{"displayName":"s","relative":{"0":"teraz"},"relativeTime":{"future":{"one":"o {0} s","few":"o {0} s","many":"o {0} s","other":"o {0} s"},"past":{"one":"pred {0} s","few":"pred {0} s","many":"pred {0} s","other":"pred {0} s"}}}}},
    {"locale":"sl","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], v0 = !s[1], i100 = i.slice(-2);
      if (ord) return 'other';
      return (v0 && i100 == 1) ? 'one'
          : (v0 && i100 == 2) ? 'two'
          : (v0 && (i100 == 3 || i100 == 4)
              || !v0) ? 'few'
          : 'other';
    },"fields":{"year":{"displayName":"leto","relative":{"0":"letos","1":"naslednje leto","-1":"lani"},"relativeTime":{"future":{"one":"čez {0} leto","two":"čez {0} leti","few":"čez {0} leta","other":"čez {0} let"},"past":{"one":"pred {0} letom","two":"pred {0} letoma","few":"pred {0} leti","other":"pred {0} leti"}}},"year-short":{"displayName":"leto","relative":{"0":"letos","1":"naslednje leto","-1":"lani"},"relativeTime":{"future":{"one":"čez {0} leto","two":"čez {0} leti","few":"čez {0} leta","other":"čez {0} let"},"past":{"one":"pred {0} letom","two":"pred {0} letoma","few":"pred {0} leti","other":"pred {0} leti"}}},"month":{"displayName":"mesec","relative":{"0":"ta mesec","1":"naslednji mesec","-1":"prejšnji mesec"},"relativeTime":{"future":{"one":"čez {0} mesec","two":"čez {0} meseca","few":"čez {0} mesece","other":"čez {0} mesecev"},"past":{"one":"pred {0} mesecem","two":"pred {0} mesecema","few":"pred {0} meseci","other":"pred {0} meseci"}}},"month-short":{"displayName":"mes.","relative":{"0":"ta mesec","1":"naslednji mesec","-1":"prejšnji mesec"},"relativeTime":{"future":{"one":"čez {0} mes.","two":"čez {0} mes.","few":"čez {0} mes.","other":"čez {0} mes."},"past":{"one":"pred {0} mes.","two":"pred {0} mes.","few":"pred {0} mes.","other":"pred {0} mes."}}},"week":{"displayName":"teden","relativePeriod":"v tednu {0}","relative":{"0":"ta teden","1":"naslednji teden","-1":"prejšnji teden"},"relativeTime":{"future":{"one":"čez {0} teden","two":"čez {0} tedna","few":"čez {0} tedne","other":"čez {0} tednov"},"past":{"one":"pred {0} tednom","two":"pred {0} tednoma","few":"pred {0} tedni","other":"pred {0} tedni"}}},"week-short":{"displayName":"ted.","relativePeriod":"v tednu {0}","relative":{"0":"ta teden","1":"naslednji teden","-1":"prejšnji teden"},"relativeTime":{"future":{"one":"čez {0} ted.","two":"čez {0} ted.","few":"čez {0} ted.","other":"čez {0} ted."},"past":{"one":"pred {0} ted.","two":"pred {0} ted.","few":"pred {0} ted.","other":"pred {0} ted."}}},"day":{"displayName":"dan","relative":{"0":"danes","1":"jutri","2":"pojutrišnjem","-2":"predvčerajšnjim","-1":"včeraj"},"relativeTime":{"future":{"one":"čez {0} dan","two":"čez {0} dneva","few":"čez {0} dni","other":"čez {0} dni"},"past":{"one":"pred {0} dnevom","two":"pred {0} dnevoma","few":"pred {0} dnevi","other":"pred {0} dnevi"}}},"day-short":{"displayName":"dan","relative":{"0":"danes","1":"jutri","2":"pojutrišnjem","-2":"predvčerajšnjim","-1":"včeraj"},"relativeTime":{"future":{"one":"čez {0} dan","two":"čez {0} dneva","few":"čez {0} dni","other":"čez {0} dni"},"past":{"one":"pred {0} dnevom","two":"pred {0} dnevoma","few":"pred {0} dnevi","other":"pred {0} dnevi"}}},"hour":{"displayName":"ura","relative":{"0":"v tej uri"},"relativeTime":{"future":{"one":"čez {0} uro","two":"čez {0} uri","few":"čez {0} ure","other":"čez {0} ur"},"past":{"one":"pred {0} uro","two":"pred {0} urama","few":"pred {0} urami","other":"pred {0} urami"}}},"hour-short":{"displayName":"ura","relative":{"0":"v tej uri"},"relativeTime":{"future":{"one":"čez {0} uro","two":"čez {0} uri","few":"čez {0} ure","other":"čez {0} ur"},"past":{"one":"pred {0} uro","two":"pred {0} urama","few":"pred {0} urami","other":"pred {0} urami"}}},"minute":{"displayName":"minuta","relative":{"0":"to minuto"},"relativeTime":{"future":{"one":"čez {0} minuto","two":"čez {0} minuti","few":"čez {0} minute","other":"čez {0} minut"},"past":{"one":"pred {0} minuto","two":"pred {0} minutama","few":"pred {0} minutami","other":"pred {0} minutami"}}},"minute-short":{"displayName":"min.","relative":{"0":"to minuto"},"relativeTime":{"future":{"one":"čez {0} min.","two":"čez {0} min.","few":"čez {0} min.","other":"čez {0} min."},"past":{"one":"pred {0} min.","two":"pred {0} min.","few":"pred {0} min.","other":"pred {0} min."}}},"second":{"displayName":"sekunda","relative":{"0":"zdaj"},"relativeTime":{"future":{"one":"čez {0} sekundo","two":"čez {0} sekundi","few":"čez {0} sekunde","other":"čez {0} sekund"},"past":{"one":"pred {0} sekundo","two":"pred {0} sekundama","few":"pred {0} sekundami","other":"pred {0} sekundami"}}},"second-short":{"displayName":"sek.","relative":{"0":"zdaj"},"relativeTime":{"future":{"one":"čez {0} s","two":"čez {0} s","few":"čez {0} s","other":"čez {0} s"},"past":{"one":"pred {0} s","two":"pred {0} s","few":"pred {0} s","other":"pred {0} s"}}}}},
    {"locale":"sma","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one'
          : (n == 2) ? 'two'
          : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"smi","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one'
          : (n == 2) ? 'two'
          : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"smj","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one'
          : (n == 2) ? 'two'
          : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"smn","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one'
          : (n == 2) ? 'two'
          : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"sms","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one'
          : (n == 2) ? 'two'
          : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"sn","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Gore","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Gore","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mwedzi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mwedzi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Vhiki","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Vhiki","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Zuva","relative":{"0":"Nhasi","1":"Mangwana","-1":"Nezuro"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Zuva","relative":{"0":"Nhasi","1":"Mangwana","-1":"Nezuro"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Awa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Awa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Mineti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Mineti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekondi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekondi","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"so","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"Sannadkan","1":"Sannadka xiga","-1":"Sannadkii la soo dhaafay"},"relativeTime":{"future":{"one":"+{0} y","other":"+{0} y"},"past":{"one":"-{0} y","other":"-{0} y"}}},"year-short":{"displayName":"Sanadkii","relative":{"0":"Sannadkan","1":"Sannadka xiga","-1":"Sannadkii la soo dhaafay"},"relativeTime":{"future":{"one":"+{0} y","other":"+{0} y"},"past":{"one":"-{0} y","other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"Bishan","1":"Bisha xigta","-1":"Bishii la soo dhaafay"},"relativeTime":{"future":{"one":"+{0} m","other":"+{0} m"},"past":{"one":"-{0} m","other":"-{0} m"}}},"month-short":{"displayName":"Bil-gaaban","relative":{"0":"Bishan","1":"Bisha xigta","-1":"Bishii la soo dhaafay"},"relativeTime":{"future":{"one":"+{0} m","other":"+{0} m"},"past":{"one":"-{0} m","other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"Usbuucan","1":"Usbuuca xiga","-1":"Usbuucii la soo dhaafay"},"relativeTime":{"future":{"one":"+{0} w","other":"+{0} w"},"past":{"one":"-{0} w","other":"-{0} w"}}},"week-short":{"displayName":"Usbuuc-gaaban","relativePeriod":"the week of {0}","relative":{"0":"Usbuucan","1":"Usbuuca xiga","-1":"Usbuucii la soo dhaafay"},"relativeTime":{"future":{"one":"+{0} w","other":"+{0} w"},"past":{"one":"-{0} w","other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"Maanta","1":"Berri","-1":"Shalay"},"relativeTime":{"future":{"one":"+{0} d","other":"+{0} d"},"past":{"one":"-{0} d","other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"Maanta","1":"Berri","-1":"Shalay"},"relativeTime":{"future":{"one":"+{0} d","other":"+{0} d"},"past":{"one":"-{0} d","other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"+{0} h","other":"+{0} h"},"past":{"one":"-{0} h","other":"-{0} h"}}},"hour-short":{"displayName":"Saacad-gaaban","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"+{0} h","other":"+{0} h"},"past":{"one":"-{0} h","other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"+{0} min","other":"+{0} min"},"past":{"one":"-{0} min","other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"+{0} min","other":"+{0} min"},"past":{"one":"-{0} min","other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"one":"+{0} s","other":"+{0} s"},"past":{"one":"-{0} s","other":"-{0} s"}}},"second-short":{"displayName":"Il-biriqsi-gaaban","relative":{"0":"now"},"relativeTime":{"future":{"one":"+{0} s","other":"+{0} s"},"past":{"one":"-{0} s","other":"-{0} s"}}}}},{"locale":"so-DJ","parentLocale":"so"},{"locale":"so-ET","parentLocale":"so"},{"locale":"so-KE","parentLocale":"so"},
    {"locale":"sq","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), t0 = Number(s[0]) == n,
          n10 = t0 && s[0].slice(-1), n100 = t0 && s[0].slice(-2);
      if (ord) return (n == 1) ? 'one'
          : (n10 == 4 && n100 != 14) ? 'many'
          : 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"vit","relative":{"0":"sivjet","1":"mot","-1":"vjet"},"relativeTime":{"future":{"one":"pas {0} viti","other":"pas {0} vjetësh"},"past":{"one":"{0} vit më parë","other":"{0} vjet më parë"}}},"year-short":{"displayName":"vit","relative":{"0":"këtë vit","1":"vitin e ardhshëm","-1":"vitin e kaluar"},"relativeTime":{"future":{"one":"pas {0} viti","other":"pas {0} vjetësh"},"past":{"one":"{0} vit më parë","other":"{0} vjet më parë"}}},"month":{"displayName":"muaj","relative":{"0":"këtë muaj","1":"muajin e ardhshëm","-1":"muajin e kaluar"},"relativeTime":{"future":{"one":"pas {0} muaji","other":"pas {0} muajsh"},"past":{"one":"{0} muaj më parë","other":"{0} muaj më parë"}}},"month-short":{"displayName":"muaj","relative":{"0":"këtë muaj","1":"muajin e ardhshëm","-1":"muajin e kaluar"},"relativeTime":{"future":{"one":"pas {0} muaji","other":"pas {0} muajsh"},"past":{"one":"{0} muaj më parë","other":"{0} muaj më parë"}}},"week":{"displayName":"javë","relativePeriod":"java e {0}","relative":{"0":"këtë javë","1":"javën e ardhshme","-1":"javën e kaluar"},"relativeTime":{"future":{"one":"pas {0} jave","other":"pas {0} javësh"},"past":{"one":"{0} javë më parë","other":"{0} javë më parë"}}},"week-short":{"displayName":"javë","relativePeriod":"java e {0}","relative":{"0":"këtë javë","1":"javën e ardhshme","-1":"javën e kaluar"},"relativeTime":{"future":{"one":"pas {0} jave","other":"pas {0} javësh"},"past":{"one":"{0} javë më parë","other":"{0} javë më parë"}}},"day":{"displayName":"ditë","relative":{"0":"sot","1":"nesër","-1":"dje"},"relativeTime":{"future":{"one":"pas {0} dite","other":"pas {0} ditësh"},"past":{"one":"{0} ditë më parë","other":"{0} ditë më parë"}}},"day-short":{"displayName":"ditë","relative":{"0":"sot","1":"nesër","-1":"dje"},"relativeTime":{"future":{"one":"pas {0} dite","other":"pas {0} ditësh"},"past":{"one":"{0} ditë më parë","other":"{0} ditë më parë"}}},"hour":{"displayName":"orë","relative":{"0":"këtë orë"},"relativeTime":{"future":{"one":"pas {0} ore","other":"pas {0} orësh"},"past":{"one":"{0} orë më parë","other":"{0} orë më parë"}}},"hour-short":{"displayName":"orë","relative":{"0":"këtë orë"},"relativeTime":{"future":{"one":"pas {0} ore","other":"pas {0} orësh"},"past":{"one":"{0} orë më parë","other":"{0} orë më parë"}}},"minute":{"displayName":"minutë","relative":{"0":"këtë minutë"},"relativeTime":{"future":{"one":"pas {0} minute","other":"pas {0} minutash"},"past":{"one":"{0} minutë më parë","other":"{0} minuta më parë"}}},"minute-short":{"displayName":"min","relative":{"0":"këtë minutë"},"relativeTime":{"future":{"one":"pas {0} min","other":"pas {0} min"},"past":{"one":"{0} min më parë","other":"{0} min më parë"}}},"second":{"displayName":"sekondë","relative":{"0":"tani"},"relativeTime":{"future":{"one":"pas {0} sekonde","other":"pas {0} sekondash"},"past":{"one":"{0} sekondë më parë","other":"{0} sekonda më parë"}}},"second-short":{"displayName":"sek","relative":{"0":"tani"},"relativeTime":{"future":{"one":"pas {0} sek","other":"pas {0} sek"},"past":{"one":"{0} sek më parë","other":"{0} sek më parë"}}}}},{"locale":"sq-MK","parentLocale":"sq"},{"locale":"sq-XK","parentLocale":"sq"},
    {"locale":"sr","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], f = s[1] || '', v0 = !s[1],
          i10 = i.slice(-1), i100 = i.slice(-2), f10 = f.slice(-1), f100 = f.slice(-2);
      if (ord) return 'other';
      return (v0 && i10 == 1 && i100 != 11
              || f10 == 1 && f100 != 11) ? 'one'
          : (v0 && (i10 >= 2 && i10 <= 4) && (i100 < 12 || i100 > 14)
              || (f10 >= 2 && f10 <= 4) && (f100 < 12
              || f100 > 14)) ? 'few'
          : 'other';
    },"fields":{"year":{"displayName":"година","relative":{"0":"ове године","1":"следеће године","-1":"прошле године"},"relativeTime":{"future":{"one":"за {0} годину","few":"за {0} године","other":"за {0} година"},"past":{"one":"пре {0} године","few":"пре {0} године","other":"пре {0} година"}}},"year-short":{"displayName":"год.","relative":{"0":"ове год.","1":"следеће год.","-1":"прошле год."},"relativeTime":{"future":{"one":"за {0} год.","few":"за {0} год.","other":"за {0} год."},"past":{"one":"пре {0} год.","few":"пре {0} год.","other":"пре {0} год."}}},"month":{"displayName":"месец","relative":{"0":"овог месеца","1":"следећег месеца","-1":"прошлог месеца"},"relativeTime":{"future":{"one":"за {0} месец","few":"за {0} месеца","other":"за {0} месеци"},"past":{"one":"пре {0} месеца","few":"пре {0} месеца","other":"пре {0} месеци"}}},"month-short":{"displayName":"мес.","relative":{"0":"овог мес.","1":"следећег мес.","-1":"прошлог мес."},"relativeTime":{"future":{"one":"за {0} мес.","few":"за {0} мес.","other":"за {0} мес."},"past":{"one":"пре {0} мес.","few":"пре {0} мес.","other":"пре {0} мес."}}},"week":{"displayName":"недеља","relativePeriod":"недеља која почиње {0}.","relative":{"0":"ове недеље","1":"следеће недеље","-1":"прошле недеље"},"relativeTime":{"future":{"one":"за {0} недељу","few":"за {0} недеље","other":"за {0} недеља"},"past":{"one":"пре {0} недеље","few":"пре {0} недеље","other":"пре {0} недеља"}}},"week-short":{"displayName":"нед.","relativePeriod":"недеља која почиње {0}.","relative":{"0":"ове нед.","1":"следеће нед.","-1":"прошле нед."},"relativeTime":{"future":{"one":"за {0} нед.","few":"за {0} нед.","other":"за {0} нед."},"past":{"one":"пре {0} нед.","few":"пре {0} нед.","other":"пре {0} нед."}}},"day":{"displayName":"дан","relative":{"0":"данас","1":"сутра","2":"прекосутра","-2":"прекјуче","-1":"јуче"},"relativeTime":{"future":{"one":"за {0} дан","few":"за {0} дана","other":"за {0} дана"},"past":{"one":"пре {0} дана","few":"пре {0} дана","other":"пре {0} дана"}}},"day-short":{"displayName":"д.","relative":{"0":"данас","1":"сутра","2":"прекосутра","-2":"прекјуче","-1":"јуче"},"relativeTime":{"future":{"one":"за {0} д.","few":"за {0} д.","other":"за {0} д."},"past":{"one":"пре {0} д.","few":"пре {0} д.","other":"пре {0} д."}}},"hour":{"displayName":"сат","relative":{"0":"овог сата"},"relativeTime":{"future":{"one":"за {0} сат","few":"за {0} сата","other":"за {0} сати"},"past":{"one":"пре {0} сата","few":"пре {0} сата","other":"пре {0} сати"}}},"hour-short":{"displayName":"ч.","relative":{"0":"овог сата"},"relativeTime":{"future":{"one":"за {0} ч.","few":"за {0} ч.","other":"за {0} ч."},"past":{"one":"пре {0} ч.","few":"пре {0} ч.","other":"пре {0} ч."}}},"minute":{"displayName":"минут","relative":{"0":"овог минута"},"relativeTime":{"future":{"one":"за {0} минут","few":"за {0} минута","other":"за {0} минута"},"past":{"one":"пре {0} минута","few":"пре {0} минута","other":"пре {0} минута"}}},"minute-short":{"displayName":"мин.","relative":{"0":"овог минута"},"relativeTime":{"future":{"one":"за {0} мин.","few":"за {0} мин.","other":"за {0} мин."},"past":{"one":"пре {0} мин.","few":"пре {0} мин.","other":"пре {0} мин."}}},"second":{"displayName":"секунд","relative":{"0":"сада"},"relativeTime":{"future":{"one":"за {0} секунду","few":"за {0} секунде","other":"за {0} секунди"},"past":{"one":"пре {0} секунде","few":"пре {0} секунде","other":"пре {0} секунди"}}},"second-short":{"displayName":"сек.","relative":{"0":"сада"},"relativeTime":{"future":{"one":"за {0} сек.","few":"за {0} сек.","other":"за {0} сек."},"past":{"one":"пре {0} сек.","few":"пре {0} сек.","other":"пре {0} сек."}}}}},{"locale":"sr-Cyrl","parentLocale":"sr"},{"locale":"sr-Cyrl-BA","parentLocale":"sr-Cyrl"},{"locale":"sr-Cyrl-ME","parentLocale":"sr-Cyrl"},{"locale":"sr-Cyrl-XK","parentLocale":"sr-Cyrl"},{"locale":"sr-Latn","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"godina","relative":{"0":"ove godine","1":"sledeće godine","-1":"prošle godine"},"relativeTime":{"future":{"one":"za {0} godinu","few":"za {0} godine","other":"za {0} godina"},"past":{"one":"pre {0} godine","few":"pre {0} godine","other":"pre {0} godina"}}},"year-short":{"displayName":"god.","relative":{"0":"ove god.","1":"sledeće god.","-1":"prošle god."},"relativeTime":{"future":{"one":"za {0} god.","few":"za {0} god.","other":"za {0} god."},"past":{"one":"pre {0} god.","few":"pre {0} god.","other":"pre {0} god."}}},"month":{"displayName":"mesec","relative":{"0":"ovog meseca","1":"sledećeg meseca","-1":"prošlog meseca"},"relativeTime":{"future":{"one":"za {0} mesec","few":"za {0} meseca","other":"za {0} meseci"},"past":{"one":"pre {0} meseca","few":"pre {0} meseca","other":"pre {0} meseci"}}},"month-short":{"displayName":"mes.","relative":{"0":"ovog mes.","1":"sledećeg mes.","-1":"prošlog mes."},"relativeTime":{"future":{"one":"za {0} mes.","few":"za {0} mes.","other":"za {0} mes."},"past":{"one":"pre {0} mes.","few":"pre {0} mes.","other":"pre {0} mes."}}},"week":{"displayName":"nedelja","relativePeriod":"nedelja koja počinje {0}.","relative":{"0":"ove nedelje","1":"sledeće nedelje","-1":"prošle nedelje"},"relativeTime":{"future":{"one":"za {0} nedelju","few":"za {0} nedelje","other":"za {0} nedelja"},"past":{"one":"pre {0} nedelje","few":"pre {0} nedelje","other":"pre {0} nedelja"}}},"week-short":{"displayName":"ned.","relativePeriod":"nedelja koja počinje {0}.","relative":{"0":"ove ned.","1":"sledeće ned.","-1":"prošle ned."},"relativeTime":{"future":{"one":"za {0} ned.","few":"za {0} ned.","other":"za {0} ned."},"past":{"one":"pre {0} ned.","few":"pre {0} ned.","other":"pre {0} ned."}}},"day":{"displayName":"dan","relative":{"0":"danas","1":"sutra","2":"prekosutra","-2":"prekjuče","-1":"juče"},"relativeTime":{"future":{"one":"za {0} dan","few":"za {0} dana","other":"za {0} dana"},"past":{"one":"pre {0} dana","few":"pre {0} dana","other":"pre {0} dana"}}},"day-short":{"displayName":"d.","relative":{"0":"danas","1":"sutra","2":"prekosutra","-2":"prekjuče","-1":"juče"},"relativeTime":{"future":{"one":"za {0} d.","few":"za {0} d.","other":"za {0} d."},"past":{"one":"pre {0} d.","few":"pre {0} d.","other":"pre {0} d."}}},"hour":{"displayName":"sat","relative":{"0":"ovog sata"},"relativeTime":{"future":{"one":"za {0} sat","few":"za {0} sata","other":"za {0} sati"},"past":{"one":"pre {0} sata","few":"pre {0} sata","other":"pre {0} sati"}}},"hour-short":{"displayName":"č.","relative":{"0":"ovog sata"},"relativeTime":{"future":{"one":"za {0} č.","few":"za {0} č.","other":"za {0} č."},"past":{"one":"pre {0} č.","few":"pre {0} č.","other":"pre {0} č."}}},"minute":{"displayName":"minut","relative":{"0":"ovog minuta"},"relativeTime":{"future":{"one":"za {0} minut","few":"za {0} minuta","other":"za {0} minuta"},"past":{"one":"pre {0} minuta","few":"pre {0} minuta","other":"pre {0} minuta"}}},"minute-short":{"displayName":"min.","relative":{"0":"ovog minuta"},"relativeTime":{"future":{"one":"za {0} min.","few":"za {0} min.","other":"za {0} min."},"past":{"one":"pre {0} min.","few":"pre {0} min.","other":"pre {0} min."}}},"second":{"displayName":"sekund","relative":{"0":"sada"},"relativeTime":{"future":{"one":"za {0} sekundu","few":"za {0} sekunde","other":"za {0} sekundi"},"past":{"one":"pre {0} sekunde","few":"pre {0} sekunde","other":"pre {0} sekundi"}}},"second-short":{"displayName":"sek.","relative":{"0":"sada"},"relativeTime":{"future":{"one":"za {0} sek.","few":"za {0} sek.","other":"za {0} sek."},"past":{"one":"pre {0} sek.","few":"pre {0} sek.","other":"pre {0} sek."}}}}},{"locale":"sr-Latn-BA","parentLocale":"sr-Latn"},{"locale":"sr-Latn-ME","parentLocale":"sr-Latn"},{"locale":"sr-Latn-XK","parentLocale":"sr-Latn"},
    {"locale":"ss","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ssy","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"st","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"sv","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1], t0 = Number(s[0]) == n,
          n10 = t0 && s[0].slice(-1), n100 = t0 && s[0].slice(-2);
      if (ord) return ((n10 == 1
              || n10 == 2) && n100 != 11 && n100 != 12) ? 'one' : 'other';
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"år","relative":{"0":"i år","1":"nästa år","-1":"i fjol"},"relativeTime":{"future":{"one":"om {0} år","other":"om {0} år"},"past":{"one":"för {0} år sedan","other":"för {0} år sedan"}}},"year-short":{"displayName":"år","relative":{"0":"i år","1":"nästa år","-1":"i fjol"},"relativeTime":{"future":{"one":"om {0} år","other":"om {0} år"},"past":{"one":"för {0} år sen","other":"för {0} år sen"}}},"month":{"displayName":"månad","relative":{"0":"denna månad","1":"nästa månad","-1":"förra månaden"},"relativeTime":{"future":{"one":"om {0} månad","other":"om {0} månader"},"past":{"one":"för {0} månad sedan","other":"för {0} månader sedan"}}},"month-short":{"displayName":"m","relative":{"0":"denna mån.","1":"nästa mån.","-1":"förra mån."},"relativeTime":{"future":{"one":"om {0} mån.","other":"om {0} mån."},"past":{"one":"för {0} mån. sen","other":"för {0} mån. sen"}}},"week":{"displayName":"vecka","relativePeriod":"veckan för {0}","relative":{"0":"denna vecka","1":"nästa vecka","-1":"förra veckan"},"relativeTime":{"future":{"one":"om {0} vecka","other":"om {0} veckor"},"past":{"one":"för {0} vecka sedan","other":"för {0} veckor sedan"}}},"week-short":{"displayName":"v","relativePeriod":"veckan för {0}","relative":{"0":"denna v.","1":"nästa v.","-1":"förra v."},"relativeTime":{"future":{"one":"om {0} v.","other":"om {0} v."},"past":{"one":"för {0} v. sedan","other":"för {0} v. sedan"}}},"day":{"displayName":"dag","relative":{"0":"i dag","1":"i morgon","2":"i övermorgon","-2":"i förrgår","-1":"i går"},"relativeTime":{"future":{"one":"om {0} dag","other":"om {0} dagar"},"past":{"one":"för {0} dag sedan","other":"för {0} dagar sedan"}}},"day-short":{"displayName":"dag","relative":{"0":"i dag","1":"i morgon","2":"i övermorgon","-2":"i förrgår","-1":"i går"},"relativeTime":{"future":{"one":"om {0} d","other":"om {0} d"},"past":{"one":"för {0} d sedan","other":"för {0} d sedan"}}},"hour":{"displayName":"timme","relative":{"0":"denna timme"},"relativeTime":{"future":{"one":"om {0} timme","other":"om {0} timmar"},"past":{"one":"för {0} timme sedan","other":"för {0} timmar sedan"}}},"hour-short":{"displayName":"tim","relative":{"0":"denna timme"},"relativeTime":{"future":{"one":"om {0} tim","other":"om {0} tim"},"past":{"one":"för {0} tim sedan","other":"för {0} tim sedan"}}},"minute":{"displayName":"minut","relative":{"0":"denna minut"},"relativeTime":{"future":{"one":"om {0} minut","other":"om {0} minuter"},"past":{"one":"för {0} minut sedan","other":"för {0} minuter sedan"}}},"minute-short":{"displayName":"min","relative":{"0":"denna minut"},"relativeTime":{"future":{"one":"om {0} min","other":"om {0} min"},"past":{"one":"för {0} min sen","other":"för {0} min sen"}}},"second":{"displayName":"sekund","relative":{"0":"nu"},"relativeTime":{"future":{"one":"om {0} sekund","other":"om {0} sekunder"},"past":{"one":"för {0} sekund sedan","other":"för {0} sekunder sedan"}}},"second-short":{"displayName":"sek","relative":{"0":"nu"},"relativeTime":{"future":{"one":"om {0} sek","other":"om {0} sek"},"past":{"one":"för {0} s sen","other":"för {0} s sen"}}}}},{"locale":"sv-AX","parentLocale":"sv"},{"locale":"sv-FI","parentLocale":"sv"},
    {"locale":"sw","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      if (ord) return 'other';
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"mwaka","relative":{"0":"mwaka huu","1":"mwaka ujao","-1":"mwaka uliopita"},"relativeTime":{"future":{"one":"baada ya mwaka {0}","other":"baada ya miaka {0}"},"past":{"one":"mwaka {0} uliopita","other":"miaka {0} iliyopita"}}},"year-short":{"displayName":"mwaka","relative":{"0":"mwaka huu","1":"mwaka ujao","-1":"mwaka uliopita"},"relativeTime":{"future":{"one":"baada ya mwaka {0}","other":"baada ya miaka {0}"},"past":{"one":"mwaka {0} uliopita","other":"miaka {0} iliyopita"}}},"month":{"displayName":"mwezi","relative":{"0":"mwezi huu","1":"mwezi ujao","-1":"mwezi uliopita"},"relativeTime":{"future":{"one":"baada ya mwezi {0}","other":"baada ya miezi {0}"},"past":{"one":"mwezi {0} uliopita","other":"miezi {0} iliyopita"}}},"month-short":{"displayName":"mwezi","relative":{"0":"mwezi huu","1":"mwezi ujao","-1":"mwezi uliopita"},"relativeTime":{"future":{"one":"baada ya mwezi {0}","other":"baada ya miezi {0}"},"past":{"one":"mwezi {0} uliopita","other":"miezi {0} iliyopita"}}},"week":{"displayName":"wiki","relativePeriod":"wiki ya {0}","relative":{"0":"wiki hii","1":"wiki ijayo","-1":"wiki iliyopita"},"relativeTime":{"future":{"one":"baada ya wiki {0}","other":"baada ya wiki {0}"},"past":{"one":"wiki {0} iliyopita","other":"wiki {0} zilizopita"}}},"week-short":{"displayName":"wiki","relativePeriod":"wiki ya {0}","relative":{"0":"wiki hii","1":"wiki ijayo","-1":"wiki iliyopita"},"relativeTime":{"future":{"one":"baada ya wiki {0}","other":"baada ya wiki {0}"},"past":{"one":"wiki {0} iliyopita","other":"wiki {0} zilizopita"}}},"day":{"displayName":"siku","relative":{"0":"leo","1":"kesho","2":"kesho kutwa","-2":"juzi","-1":"jana"},"relativeTime":{"future":{"one":"baada ya siku {0}","other":"baada ya siku {0}"},"past":{"one":"siku {0} iliyopita","other":"siku {0} zilizopita"}}},"day-short":{"displayName":"siku","relative":{"0":"leo","1":"kesho","2":"kesho kutwa","-2":"juzi","-1":"jana"},"relativeTime":{"future":{"one":"baada ya siku {0}","other":"baada ya siku {0}"},"past":{"one":"siku {0} iliyopita","other":"siku {0} zilizopita"}}},"hour":{"displayName":"saa","relative":{"0":"saa hii"},"relativeTime":{"future":{"one":"baada ya saa {0}","other":"baada ya saa {0}"},"past":{"one":"saa {0} iliyopita","other":"saa {0} zilizopita"}}},"hour-short":{"displayName":"saa","relative":{"0":"saa hii"},"relativeTime":{"future":{"one":"baada ya saa {0}","other":"baada ya saa {0}"},"past":{"one":"saa {0} iliyopita","other":"saa {0} zilizopita"}}},"minute":{"displayName":"dakika","relative":{"0":"dakika hii"},"relativeTime":{"future":{"one":"baada ya dakika {0}","other":"baada ya dakika {0}"},"past":{"one":"dakika {0} iliyopita","other":"dakika {0} zilizopita"}}},"minute-short":{"displayName":"dak","relative":{"0":"dakika hii"},"relativeTime":{"future":{"one":"baada ya dakika {0}","other":"baada ya dakika {0}"},"past":{"one":"dakika {0} iliyopita","other":"dakika {0} zilizopita"}}},"second":{"displayName":"sekunde","relative":{"0":"sasa hivi"},"relativeTime":{"future":{"one":"baada ya sekunde {0}","other":"baada ya sekunde {0}"},"past":{"one":"Sekunde {0} iliyopita","other":"Sekunde {0} zilizopita"}}},"second-short":{"displayName":"sek","relative":{"0":"sasa hivi"},"relativeTime":{"future":{"one":"baada ya sekunde {0}","other":"baada ya sekunde {0}"},"past":{"one":"sekunde {0} iliyopita","other":"sekunde {0} zilizopita"}}}}},{"locale":"sw-CD","parentLocale":"sw","fields":{"year":{"displayName":"mwaka","relative":{"0":"mwaka huu","1":"mwaka ujao","-1":"mwaka uliopita"},"relativeTime":{"future":{"one":"baada ya mwaka {0}","other":"baada ya miaka {0}"},"past":{"one":"mwaka {0} uliopita","other":"miaka {0} iliyopita"}}},"year-short":{"displayName":"mwaka","relative":{"0":"mwaka huu","1":"mwaka ujao","-1":"mwaka uliopita"},"relativeTime":{"future":{"one":"baada ya mwaka {0}","other":"baada ya miaka {0}"},"past":{"one":"mwaka {0} uliopita","other":"miaka {0} iliyopita"}}},"month":{"displayName":"mwezi","relative":{"0":"mwezi huu","1":"mwezi ujao","-1":"mwezi uliopita"},"relativeTime":{"future":{"one":"baada ya mwezi {0}","other":"baada ya miezi {0}"},"past":{"one":"mwezi {0} uliopita","other":"miezi {0} iliyopita"}}},"month-short":{"displayName":"mwezi","relative":{"0":"mwezi huu","1":"mwezi ujao","-1":"mwezi uliopita"},"relativeTime":{"future":{"one":"baada ya mwezi {0}","other":"baada ya miezi {0}"},"past":{"one":"mwezi {0} uliopita","other":"miezi {0} iliyopita"}}},"week":{"displayName":"Juma","relativePeriod":"wiki ya {0}","relative":{"0":"wiki hii","1":"wiki ijayo","-1":"wiki iliyopita"},"relativeTime":{"future":{"one":"baada ya wiki {0}","other":"baada ya wiki {0}"},"past":{"one":"wiki {0} iliyopita","other":"wiki {0} zilizopita"}}},"week-short":{"displayName":"wiki","relativePeriod":"wiki ya {0}","relative":{"0":"wiki hii","1":"wiki ijayo","-1":"wiki iliyopita"},"relativeTime":{"future":{"one":"baada ya wiki {0}","other":"baada ya wiki {0}"},"past":{"one":"wiki {0} iliyopita","other":"wiki {0} zilizopita"}}},"day":{"displayName":"siku","relative":{"0":"leo","1":"kesho","2":"kesho kutwa","-2":"juzi","-1":"jana"},"relativeTime":{"future":{"one":"baada ya siku {0}","other":"baada ya siku {0}"},"past":{"one":"siku {0} iliyopita","other":"siku {0} zilizopita"}}},"day-short":{"displayName":"siku","relative":{"0":"leo","1":"kesho","2":"kesho kutwa","-2":"juzi","-1":"jana"},"relativeTime":{"future":{"one":"baada ya siku {0}","other":"baada ya siku {0}"},"past":{"one":"siku {0} iliyopita","other":"siku {0} zilizopita"}}},"hour":{"displayName":"saa","relative":{"0":"saa hii"},"relativeTime":{"future":{"one":"baada ya saa {0}","other":"baada ya saa {0}"},"past":{"one":"saa {0} iliyopita","other":"saa {0} zilizopita"}}},"hour-short":{"displayName":"saa","relative":{"0":"saa hii"},"relativeTime":{"future":{"one":"baada ya saa {0}","other":"baada ya saa {0}"},"past":{"one":"saa {0} iliyopita","other":"saa {0} zilizopita"}}},"minute":{"displayName":"dakika","relative":{"0":"dakika hii"},"relativeTime":{"future":{"one":"baada ya dakika {0}","other":"baada ya dakika {0}"},"past":{"one":"dakika {0} iliyopita","other":"dakika {0} zilizopita"}}},"minute-short":{"displayName":"dak","relative":{"0":"dakika hii"},"relativeTime":{"future":{"one":"baada ya dakika {0}","other":"baada ya dakika {0}"},"past":{"one":"dakika {0} iliyopita","other":"dakika {0} zilizopita"}}},"second":{"displayName":"sekunde","relative":{"0":"sasa hivi"},"relativeTime":{"future":{"one":"baada ya sekunde {0}","other":"baada ya sekunde {0}"},"past":{"one":"Sekunde {0} iliyopita","other":"Sekunde {0} zilizopita"}}},"second-short":{"displayName":"sek","relative":{"0":"sasa hivi"},"relativeTime":{"future":{"one":"baada ya sekunde {0}","other":"baada ya sekunde {0}"},"past":{"one":"sekunde {0} iliyopita","other":"sekunde {0} zilizopita"}}}}},{"locale":"sw-KE","parentLocale":"sw"},{"locale":"sw-UG","parentLocale":"sw"},
    {"locale":"syr","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ta","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ஆண்டு","relative":{"0":"இந்த ஆண்டு","1":"அடுத்த ஆண்டு","-1":"கடந்த ஆண்டு"},"relativeTime":{"future":{"one":"{0} ஆண்டில்","other":"{0} ஆண்டுகளில்"},"past":{"one":"{0} ஆண்டிற்கு முன்","other":"{0} ஆண்டுகளுக்கு முன்"}}},"year-short":{"displayName":"ஆண்டு","relative":{"0":"இந்த ஆண்டு","1":"அடுத்த ஆண்டு","-1":"கடந்த ஆண்டு"},"relativeTime":{"future":{"one":"{0} ஆண்டில்","other":"{0} ஆண்டுகளில்"},"past":{"one":"{0} ஆண்டிற்கு முன்","other":"{0} ஆண்டுகளுக்கு முன்"}}},"month":{"displayName":"மாதம்","relative":{"0":"இந்த மாதம்","1":"அடுத்த மாதம்","-1":"கடந்த மாதம்"},"relativeTime":{"future":{"one":"{0} மாதத்தில்","other":"{0} மாதங்களில்"},"past":{"one":"{0} மாதத்துக்கு முன்","other":"{0} மாதங்களுக்கு முன்"}}},"month-short":{"displayName":"மாத.","relative":{"0":"இந்த மாதம்","1":"அடுத்த மாதம்","-1":"கடந்த மாதம்"},"relativeTime":{"future":{"one":"{0} மாத.","other":"{0} மாத."},"past":{"one":"{0} மாத. முன்","other":"{0} மாத. முன்"}}},"week":{"displayName":"வாரம்","relativePeriod":"{0} -இன் வாரம்","relative":{"0":"இந்த வாரம்","1":"அடுத்த வாரம்","-1":"கடந்த வாரம்"},"relativeTime":{"future":{"one":"{0} வாரத்தில்","other":"{0} வாரங்களில்"},"past":{"one":"{0} வாரத்திற்கு முன்","other":"{0} வாரங்களுக்கு முன்"}}},"week-short":{"displayName":"வாரம்","relativePeriod":"{0} -இன் வாரம்","relative":{"0":"இந்த வாரம்","1":"அடுத்த வாரம்","-1":"கடந்த வாரம்"},"relativeTime":{"future":{"one":"{0} வார.","other":"{0} வார."},"past":{"one":"{0} வார. முன்","other":"{0} வார. முன்"}}},"day":{"displayName":"நாள்","relative":{"0":"இன்று","1":"நாளை","2":"நாளை மறுநாள்","-2":"நேற்று முன் தினம்","-1":"நேற்று"},"relativeTime":{"future":{"one":"{0} நாளில்","other":"{0} நாட்களில்"},"past":{"one":"{0} நாளுக்கு முன்","other":"{0} நாட்களுக்கு முன்"}}},"day-short":{"displayName":"நாள்","relative":{"0":"இன்று","1":"நாளை","2":"நாளை மறுநாள்","-2":"நேற்று முன் தினம்","-1":"நேற்று"},"relativeTime":{"future":{"one":"{0} நாளில்","other":"{0} நாட்களில்"},"past":{"one":"{0} நாளுக்கு முன்","other":"{0} நாட்களுக்கு முன்"}}},"hour":{"displayName":"மணி","relative":{"0":"இந்த ஒரு மணிநேரத்தில்"},"relativeTime":{"future":{"one":"{0} மணிநேரத்தில்","other":"{0} மணிநேரத்தில்"},"past":{"one":"{0} மணிநேரம் முன்","other":"{0} மணிநேரம் முன்"}}},"hour-short":{"displayName":"மணி.","relative":{"0":"இந்த ஒரு மணிநேரத்தில்"},"relativeTime":{"future":{"one":"{0} மணி.","other":"{0} மணி."},"past":{"one":"{0} மணி. முன்","other":"{0} மணி. முன்"}}},"minute":{"displayName":"நிமிடம்","relative":{"0":"இந்த ஒரு நிமிடத்தில்"},"relativeTime":{"future":{"one":"{0} நிமிடத்தில்","other":"{0} நிமிடங்களில்"},"past":{"one":"{0} நிமிடத்திற்கு முன்","other":"{0} நிமிடங்களுக்கு முன்"}}},"minute-short":{"displayName":"நிமி.","relative":{"0":"இந்த ஒரு நிமிடத்தில்"},"relativeTime":{"future":{"one":"{0} நிமி.","other":"{0} நிமி."},"past":{"one":"{0} நிமி. முன்","other":"{0} நிமி. முன்"}}},"second":{"displayName":"விநாடி","relative":{"0":"இப்போது"},"relativeTime":{"future":{"one":"{0} விநாடியில்","other":"{0} விநாடிகளில்"},"past":{"one":"{0} விநாடிக்கு முன்","other":"{0} விநாடிகளுக்கு முன்"}}},"second-short":{"displayName":"விநா.","relative":{"0":"இப்போது"},"relativeTime":{"future":{"one":"{0} விநா.","other":"{0} விநா."},"past":{"one":"{0} விநா. முன்","other":"{0} விநா. முன்"}}}}},{"locale":"ta-LK","parentLocale":"ta"},{"locale":"ta-MY","parentLocale":"ta"},{"locale":"ta-SG","parentLocale":"ta"},
    {"locale":"te","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"సంవత్సరం","relative":{"0":"ఈ సంవత్సరం","1":"తదుపరి సంవత్సరం","-1":"గత సంవత్సరం"},"relativeTime":{"future":{"one":"{0} సంవత్సరంలో","other":"{0} సంవత్సరాల్లో"},"past":{"one":"{0} సంవత్సరం క్రితం","other":"{0} సంవత్సరాల క్రితం"}}},"year-short":{"displayName":"సం.","relative":{"0":"ఈ సంవత్సరం","1":"తదుపరి సంవత్సరం","-1":"గత సంవత్సరం"},"relativeTime":{"future":{"one":"{0} సం.లో","other":"{0} సం.ల్లో"},"past":{"one":"{0} సం. క్రితం","other":"{0} సం. క్రితం"}}},"month":{"displayName":"నెల","relative":{"0":"ఈ నెల","1":"తదుపరి నెల","-1":"గత నెల"},"relativeTime":{"future":{"one":"{0} నెలలో","other":"{0} నెలల్లో"},"past":{"one":"{0} నెల క్రితం","other":"{0} నెలల క్రితం"}}},"month-short":{"displayName":"నెల","relative":{"0":"ఈ నెల","1":"తదుపరి నెల","-1":"గత నెల"},"relativeTime":{"future":{"one":"{0} నెలలో","other":"{0} నెలల్లో"},"past":{"one":"{0} నెల క్రితం","other":"{0} నెలల క్రితం"}}},"week":{"displayName":"వారము","relativePeriod":"{0} వారం","relative":{"0":"ఈ వారం","1":"తదుపరి వారం","-1":"గత వారం"},"relativeTime":{"future":{"one":"{0} వారంలో","other":"{0} వారాల్లో"},"past":{"one":"{0} వారం క్రితం","other":"{0} వారాల క్రితం"}}},"week-short":{"displayName":"వా","relativePeriod":"{0}లో వారం","relative":{"0":"ఈ వారం","1":"తదుపరి వారం","-1":"గత వారం"},"relativeTime":{"future":{"one":"{0} వారంలో","other":"{0} వారాల్లో"},"past":{"one":"{0} వారం క్రితం","other":"{0} వారాల క్రితం"}}},"day":{"displayName":"దినం","relative":{"0":"ఈ రోజు","1":"రేపు","2":"ఎల్లుండి","-2":"మొన్న","-1":"నిన్న"},"relativeTime":{"future":{"one":"{0} రోజులో","other":"{0} రోజుల్లో"},"past":{"one":"{0} రోజు క్రితం","other":"{0} రోజుల క్రితం"}}},"day-short":{"displayName":"దినం","relative":{"0":"ఈ రోజు","1":"రేపు","2":"ఎల్లుండి","-2":"మొన్న","-1":"నిన్న"},"relativeTime":{"future":{"one":"{0} రోజులో","other":"{0} రోజుల్లో"},"past":{"one":"{0} రోజు క్రితం","other":"{0} రోజుల క్రితం"}}},"hour":{"displayName":"గంట","relative":{"0":"ఈ గంట"},"relativeTime":{"future":{"one":"{0} గంటలో","other":"{0} గంటల్లో"},"past":{"one":"{0} గంట క్రితం","other":"{0} గంటల క్రితం"}}},"hour-short":{"displayName":"గం.","relative":{"0":"ఈ గంట"},"relativeTime":{"future":{"one":"{0} గం.లో","other":"{0} గం.లో"},"past":{"one":"{0} గం. క్రితం","other":"{0} గం. క్రితం"}}},"minute":{"displayName":"నిమిషము","relative":{"0":"ఈ నిమిషం"},"relativeTime":{"future":{"one":"{0} నిమిషంలో","other":"{0} నిమిషాల్లో"},"past":{"one":"{0} నిమిషం క్రితం","other":"{0} నిమిషాల క్రితం"}}},"minute-short":{"displayName":"నిమి.","relative":{"0":"ఈ నిమిషం"},"relativeTime":{"future":{"one":"{0} నిమి.లో","other":"{0} నిమి.లో"},"past":{"one":"{0} నిమి. క్రితం","other":"{0} నిమి. క్రితం"}}},"second":{"displayName":"సెకను","relative":{"0":"ప్రస్తుతం"},"relativeTime":{"future":{"one":"{0} సెకనులో","other":"{0} సెకన్లలో"},"past":{"one":"{0} సెకను క్రితం","other":"{0} సెకన్ల క్రితం"}}},"second-short":{"displayName":"సెక.","relative":{"0":"ప్రస్తుతం"},"relativeTime":{"future":{"one":"{0} సెకనులో","other":"{0} సెకన్లలో"},"past":{"one":"{0} సెక. క్రితం","other":"{0} సెక. క్రితం"}}}}},
    {"locale":"teo","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Ekan","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Ekan","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Elap","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Elap","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Ewiki","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Ewiki","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Aparan","relative":{"0":"Lolo","1":"Moi","-1":"Jaan"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Aparan","relative":{"0":"Lolo","1":"Moi","-1":"Jaan"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Esaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Esaa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Idakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Idakika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Isekonde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Isekonde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"teo-KE","parentLocale":"teo"},
    {"locale":"tg","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"сол","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"с.","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"моҳ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"м.","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"ҳафта","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"ҳ.","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"рӯз","relative":{"0":"имрӯз","1":"фардо","-1":"дирӯз"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"рӯз","relative":{"0":"имрӯз","1":"фардо","-1":"дирӯз"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"соат","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"ст.","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"дақиқа","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"дақ.","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"сония","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"сон.","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"th","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return 'other';
    },"fields":{"year":{"displayName":"ปี","relative":{"0":"ปีนี้","1":"ปีหน้า","-1":"ปีที่แล้ว"},"relativeTime":{"future":{"other":"ในอีก {0} ปี"},"past":{"other":"{0} ปีที่แล้ว"}}},"year-short":{"displayName":"ปี","relative":{"0":"ปีนี้","1":"ปีหน้า","-1":"ปีที่แล้ว"},"relativeTime":{"future":{"other":"ใน {0} ปี"},"past":{"other":"{0} ปีที่แล้ว"}}},"month":{"displayName":"เดือน","relative":{"0":"เดือนนี้","1":"เดือนหน้า","-1":"เดือนที่แล้ว"},"relativeTime":{"future":{"other":"ในอีก {0} เดือน"},"past":{"other":"{0} เดือนที่ผ่านมา"}}},"month-short":{"displayName":"เดือน","relative":{"0":"เดือนนี้","1":"เดือนหน้า","-1":"เดือนที่แล้ว"},"relativeTime":{"future":{"other":"ใน {0} เดือน"},"past":{"other":"{0} เดือนที่แล้ว"}}},"week":{"displayName":"สัปดาห์","relativePeriod":"สัปดาห์ที่เริ่มต้นวันที่","relative":{"0":"สัปดาห์นี้","1":"สัปดาห์หน้า","-1":"สัปดาห์ที่แล้ว"},"relativeTime":{"future":{"other":"ในอีก {0} สัปดาห์"},"past":{"other":"{0} สัปดาห์ที่ผ่านมา"}}},"week-short":{"displayName":"สัปดาห์","relativePeriod":"สัปดาห์ที่เริ่มต้นวันที่","relative":{"0":"สัปดาห์นี้","1":"สัปดาห์หน้า","-1":"สัปดาห์ที่แล้ว"},"relativeTime":{"future":{"other":"ใน {0} สัปดาห์"},"past":{"other":"{0} สัปดาห์ที่แล้ว"}}},"day":{"displayName":"วัน","relative":{"0":"วันนี้","1":"พรุ่งนี้","2":"มะรืนนี้","-2":"เมื่อวานซืน","-1":"เมื่อวาน"},"relativeTime":{"future":{"other":"ในอีก {0} วัน"},"past":{"other":"{0} วันที่ผ่านมา"}}},"day-short":{"displayName":"วัน","relative":{"0":"วันนี้","1":"พรุ่งนี้","2":"มะรืนนี้","-2":"เมื่อวานซืน","-1":"เมื่อวาน"},"relativeTime":{"future":{"other":"ใน {0} วัน"},"past":{"other":"{0} วันที่แล้ว"}}},"hour":{"displayName":"ชั่วโมง","relative":{"0":"ชั่วโมงนี้"},"relativeTime":{"future":{"other":"ในอีก {0} ชั่วโมง"},"past":{"other":"{0} ชั่วโมงที่ผ่านมา"}}},"hour-short":{"displayName":"ชม.","relative":{"0":"ชั่วโมงนี้"},"relativeTime":{"future":{"other":"ใน {0} ชม."},"past":{"other":"{0} ชม. ที่แล้ว"}}},"minute":{"displayName":"นาที","relative":{"0":"นาทีนี้"},"relativeTime":{"future":{"other":"ในอีก {0} นาที"},"past":{"other":"{0} นาทีที่ผ่านมา"}}},"minute-short":{"displayName":"น.","relative":{"0":"นาทีนี้"},"relativeTime":{"future":{"other":"ใน {0} นาที"},"past":{"other":"{0} นาทีที่แล้ว"}}},"second":{"displayName":"วินาที","relative":{"0":"ขณะนี้"},"relativeTime":{"future":{"other":"ในอีก {0} วินาที"},"past":{"other":"{0} วินาทีที่ผ่านมา"}}},"second-short":{"displayName":"วิ","relative":{"0":"ขณะนี้"},"relativeTime":{"future":{"other":"ใน {0} วินาที"},"past":{"other":"{0} วินาทีที่แล้ว"}}}}},
    {"locale":"ti","pluralRuleFunction":function(n
    ) {
      return ((n == 0
              || n == 1)) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ዓመት","relative":{"0":"ሎሚ ዓመት","1":"ንዓመታ","-1":"ዓሚ"},"relativeTime":{"future":{"one":"ኣብ {0} ዓ","other":"ኣብ {0} ዓ"},"past":{"one":"ቅድሚ {0} ዓ","other":"ቅድሚ {0} ዓ"}}},"year-short":{"displayName":"ዓመት","relative":{"0":"ሎሚ ዓመት","1":"ንዓመታ","-1":"ዓሚ"},"relativeTime":{"future":{"one":"ኣብ {0} ዓ","other":"ኣብ {0} ዓ"},"past":{"one":"ቅድሚ -{0} ዓ","other":"ቅድሚ {0} ዓ"}}},"month":{"displayName":"ወርሒ","relative":{"0":"ህሉው ወርሒ","1":"ዝመጽእ ወርሒ","-1":"last month"},"relativeTime":{"future":{"one":"ኣብ {0} ወርሒ","other":"ኣብ {0} ወርሒ"},"past":{"one":"ቅድሚ {0} ወርሒ","other":"ቅድሚ {0} ወርሒ"}}},"month-short":{"displayName":"ወርሒ","relative":{"0":"ህሉው ወርሒ","1":"ዝመጽእ ወርሒ","-1":"last month"},"relativeTime":{"future":{"one":"ኣብ {0} ወርሒ","other":"ኣብ {0} ወርሒ"},"past":{"one":"ቅድሚ {0} ወርሒ","other":"ቅድሚ {0} ወርሒ"}}},"week":{"displayName":"ሰሙን","relativePeriod":"ሰሙን ናይ {0}","relative":{"0":"ህሉው ሰሙን","1":"ዝመጽእ ሰሙን","-1":"ዝሓለፈ ሰሙን"},"relativeTime":{"future":{"one":"ኣብ {0} ሰሙን","other":"ኣብ {0} ሰሙን"},"past":{"one":"ቅድሚ {0} ሰሙን","other":"ቅድሚ {0} ሰሙን"}}},"week-short":{"displayName":"ሰሙን","relativePeriod":"ሰሙን ናይ {0}","relative":{"0":"ህሉው ሰሙን","1":"ዝመጽእ ሰሙን","-1":"ዝሓለፈ ሰሙን"},"relativeTime":{"future":{"one":"ኣብ {0} ሰሙን","other":"ኣብ {0} ሰሙን"},"past":{"one":"ቅድሚ {0} ሰሙን","other":"ቅድሚ {0} ሰሙን"}}},"day":{"displayName":"መዓልቲ","relative":{"0":"ሎሚ","1":"ጽባሕ","-1":"ትማሊ"},"relativeTime":{"future":{"one":"ኣብ {0} መዓልቲ","other":"ኣብ {0} መዓልቲ"},"past":{"one":"ቅድሚ {0} መዓልቲ","other":"ኣብ {0} መዓልቲ"}}},"day-short":{"displayName":"መዓልቲ","relative":{"0":"ሎሚ","1":"ጽባሕ","-1":"ትማሊ"},"relativeTime":{"future":{"one":"ኣብ {0} መዓልቲ","other":"ኣብ {0} መዓልቲ"},"past":{"one":"ቅድሚ {0} መዓልቲ","other":"ቅድሚ {0} መዓልቲ"}}},"hour":{"displayName":"ሰዓት","relative":{"0":"ኣብዚ ሰዓት"},"relativeTime":{"future":{"one":"ኣብ {0} ሰዓት","other":"ኣብ {0} ሰዓት"},"past":{"one":"ቅድሚ {0} ሰዓት","other":"ቅድሚ {0} ሰዓት"}}},"hour-short":{"displayName":"ሰዓት","relative":{"0":"ኣብዚ ሰዓት"},"relativeTime":{"future":{"one":"ኣብ {0} ሰዓት","other":"ኣብ {0} ሰዓት"},"past":{"one":"ቅድሚ {0} ሰዓት","other":"ቅድሚ {0} ሰዓት"}}},"minute":{"displayName":"ደቒቕ","relative":{"0":"ኣብዚ ደቒቕ"},"relativeTime":{"future":{"one":"ኣብ {0} ደቒቕ","other":"ኣብ {0} ደቒቕ"},"past":{"one":"ቅድሚ {0} ደቒቕ","other":"ቅድሚ {0} ደቒቕ"}}},"minute-short":{"displayName":"ደቒቕ","relative":{"0":"ኣብዚ ደቒቕ"},"relativeTime":{"future":{"one":"ኣብ {0} ደቒቕ","other":"ኣብ {0} ደቒቕ"},"past":{"one":"ቅድሚ {0} ደቒቕ","other":"ቅድሚ {0} ደቒቕ"}}},"second":{"displayName":"ካልኢት","relative":{"0":"ሕጂ"},"relativeTime":{"future":{"one":"ኣብ {0} ካልኢት","other":"ኣብ {0} ካልኢት"},"past":{"one":"ቅድሚ {0} ካልኢት","other":"ቅድሚ {0} ካልኢት"}}},"second-short":{"displayName":"ካልኢት","relative":{"0":"ሕጂ"},"relativeTime":{"future":{"one":"ኣብ {0} ካልኢት","other":"ኣብ {0} ካልኢት"},"past":{"one":"ቅድሚ {0} ካልኢት","other":"ቅድሚ {0} ካልኢት"}}}}},{"locale":"ti-ER","parentLocale":"ti"},
    {"locale":"tig","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"tk","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), t0 = Number(s[0]) == n,
          n10 = t0 && s[0].slice(-1);
      if (ord) return ((n10 == 6 || n10 == 9)
              || n == 10) ? 'few' : 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"ýyl","relative":{"0":"şu ýyl","1":"indiki ýyl","-1":"geçen ýyl"},"relativeTime":{"future":{"one":"{0} ýyldan","other":"{0} ýyldan"},"past":{"one":"{0} ýyl öň","other":"{0} ýyl öň"}}},"year-short":{"displayName":"ý.","relative":{"0":"şu ýyl","1":"indiki ýyl","-1":"geçen ýyl"},"relativeTime":{"future":{"one":"{0} ý-dan","other":"{0} ý-dan"},"past":{"one":"{0} ý. öň","other":"{0} ý. öň"}}},"month":{"displayName":"aý","relative":{"0":"şu aý","1":"indiki aý","-1":"geçen aý"},"relativeTime":{"future":{"one":"{0} aýdan","other":"{0} aýdan"},"past":{"one":"{0} aý öň","other":"{0} aý öň"}}},"month-short":{"displayName":"aý","relative":{"0":"şu aý","1":"indiki aý","-1":"geçen aý"},"relativeTime":{"future":{"one":"{0} aýdan","other":"{0} aýdan"},"past":{"one":"{0} aý öň","other":"{0} aý öň"}}},"week":{"displayName":"hepde","relativePeriod":"{0} hepdesi","relative":{"0":"şu hepde","1":"indiki hepde","-1":"geçen hepde"},"relativeTime":{"future":{"one":"{0} hepdeden","other":"{0} hepdeden"},"past":{"one":"{0} hepde öň","other":"{0} hepde öň"}}},"week-short":{"displayName":"hep.","relativePeriod":"{0} hepdesi","relative":{"0":"şu hepde","1":"indiki hepde","-1":"geçen hepde"},"relativeTime":{"future":{"one":"{0} hep-den","other":"{0} hep-den"},"past":{"one":"{0} hep. öň","other":"{0} hep. öň"}}},"day":{"displayName":"gün","relative":{"0":"şu gün","1":"ertir","-1":"düýn"},"relativeTime":{"future":{"one":"{0} günden","other":"{0} günden"},"past":{"one":"{0} gün öň","other":"{0} gün öň"}}},"day-short":{"displayName":"gün","relative":{"0":"şu gün","1":"ertir","-1":"düýn"},"relativeTime":{"future":{"one":"{0} g-den","other":"{0} g-den"},"past":{"one":"{0} g. öň","other":"{0} g. öň"}}},"hour":{"displayName":"sagat","relative":{"0":"şu sagat"},"relativeTime":{"future":{"one":"{0} sagatdan","other":"{0} sagatdan"},"past":{"one":"{0} sagat öň","other":"{0} sagat öň"}}},"hour-short":{"displayName":"sag.","relative":{"0":"şu sagat"},"relativeTime":{"future":{"one":"{0} sag-dan","other":"{0} sag-dan"},"past":{"one":"{0} sag. öň","other":"{0} sag. öň"}}},"minute":{"displayName":"minut","relative":{"0":"şu minut"},"relativeTime":{"future":{"one":"{0} minutdan","other":"{0} minutdan"},"past":{"one":"{0} minut öň","other":"{0} minut öň"}}},"minute-short":{"displayName":"min.","relative":{"0":"şu minut"},"relativeTime":{"future":{"one":"{0} min-dan","other":"{0} min-dan"},"past":{"one":"{0} min. öň","other":"{0} min. öň"}}},"second":{"displayName":"sekunt","relative":{"0":"häzir"},"relativeTime":{"future":{"one":"{0} sekuntdan","other":"{0} sekuntdan"},"past":{"one":"{0} sekunt öň","other":"{0} sekunt öň"}}},"second-short":{"displayName":"sek.","relative":{"0":"häzir"},"relativeTime":{"future":{"one":"{0} sek-dan","other":"{0} sek-dan"},"past":{"one":"{0} sek. öň","other":"{0} sek. öň"}}}}},
    {"locale":"tl","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], f = s[1] || '', v0 = !s[1],
          i10 = i.slice(-1), f10 = f.slice(-1);
      if (ord) return (n == 1) ? 'one' : 'other';
      return (v0 && (i == 1 || i == 2 || i == 3)
              || v0 && i10 != 4 && i10 != 6 && i10 != 9
              || !v0 && f10 != 4 && f10 != 6 && f10 != 9) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"tn","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"to","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"taʻu","relative":{"0":"taʻú ni","1":"taʻu kahaʻu","-1":"taʻu kuoʻosi"},"relativeTime":{"future":{"other":"ʻi he taʻu ʻe {0}"},"past":{"other":"taʻu ʻe {0} kuoʻosi"}}},"year-short":{"displayName":"taʻu","relative":{"0":"taʻú ni","1":"taʻu kahaʻu","-1":"taʻu kuoʻosi"},"relativeTime":{"future":{"other":"ʻi he taʻu ʻe {0}"},"past":{"other":"taʻu ʻe {0} kuoʻosi"}}},"month":{"displayName":"māhina","relative":{"0":"māhiná ni","1":"māhina kahaʻu","-1":"māhina kuoʻosi"},"relativeTime":{"future":{"other":"ʻi he māhina ʻe {0}"},"past":{"other":"māhina ʻe {0} kuoʻosi"}}},"month-short":{"displayName":"māhina","relative":{"0":"māhiná ni","1":"māhina kahaʻu","-1":"māhina kuoʻosi"},"relativeTime":{"future":{"other":"ʻi he māhina ʻe {0}"},"past":{"other":"māhina ʻe {0} kuoʻosi"}}},"week":{"displayName":"uike","relativePeriod":"the week of {0}","relative":{"0":"uiké ni","1":"uike kahaʻu","-1":"uike kuoʻosi"},"relativeTime":{"future":{"other":"ʻi he uike ʻe {0}"},"past":{"other":"uike ʻe {0} kuoʻosi"}}},"week-short":{"displayName":"uike","relativePeriod":"the week of {0}","relative":{"0":"uiké ni","1":"uike kahaʻu","-1":"uike kuoʻosi"},"relativeTime":{"future":{"other":"ʻi he uike ʻe {0}"},"past":{"other":"uike ʻe {0} kuoʻosi"}}},"day":{"displayName":"ʻaho","relative":{"0":"ʻahó ni","1":"ʻapongipongi","2":"ʻahepongipongi","-2":"ʻaneheafi","-1":"ʻaneafi"},"relativeTime":{"future":{"other":"ʻi he ʻaho ʻe {0}"},"past":{"other":"ʻaho ʻe {0} kuoʻosi"}}},"day-short":{"displayName":"ʻaho","relative":{"0":"ʻahó ni","1":"ʻapongipongi","2":"ʻahepongipongi","-2":"ʻaneheafi","-1":"ʻaneafi"},"relativeTime":{"future":{"other":"ʻi he ʻaho ʻe {0}"},"past":{"other":"ʻaho ʻe {0} kuoʻosi"}}},"hour":{"displayName":"houa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"ʻi he houa ʻe {0}"},"past":{"other":"houa ʻe {0} kuoʻosi"}}},"hour-short":{"displayName":"houa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"ʻi he houa ʻe {0}"},"past":{"other":"houa ʻe {0} kuoʻosi"}}},"minute":{"displayName":"miniti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"ʻi he miniti ʻe {0}"},"past":{"other":"miniti ʻe {0} kuoʻosi"}}},"minute-short":{"displayName":"miniti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"ʻi he miniti ʻe {0}"},"past":{"other":"miniti ʻe {0} kuoʻosi"}}},"second":{"displayName":"sekoni","relative":{"0":"taimí ni"},"relativeTime":{"future":{"other":"ʻi he sekoni ʻe {0}"},"past":{"other":"sekoni ʻe {0} kuoʻosi"}}},"second-short":{"displayName":"sekoni","relative":{"0":"taimí ni"},"relativeTime":{"future":{"other":"ʻi he sekoni ʻe {0}"},"past":{"other":"sekoni ʻe {0} kuoʻosi"}}}}},
    {"locale":"tr","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"yıl","relative":{"0":"bu yıl","1":"gelecek yıl","-1":"geçen yıl"},"relativeTime":{"future":{"one":"{0} yıl sonra","other":"{0} yıl sonra"},"past":{"one":"{0} yıl önce","other":"{0} yıl önce"}}},"year-short":{"displayName":"yıl","relative":{"0":"bu yıl","1":"gelecek yıl","-1":"geçen yıl"},"relativeTime":{"future":{"one":"{0} yıl sonra","other":"{0} yıl sonra"},"past":{"one":"{0} yıl önce","other":"{0} yıl önce"}}},"month":{"displayName":"ay","relative":{"0":"bu ay","1":"gelecek ay","-1":"geçen ay"},"relativeTime":{"future":{"one":"{0} ay sonra","other":"{0} ay sonra"},"past":{"one":"{0} ay önce","other":"{0} ay önce"}}},"month-short":{"displayName":"ay","relative":{"0":"bu ay","1":"gelecek ay","-1":"geçen ay"},"relativeTime":{"future":{"one":"{0} ay sonra","other":"{0} ay sonra"},"past":{"one":"{0} ay önce","other":"{0} ay önce"}}},"week":{"displayName":"hafta","relativePeriod":"{0} haftası","relative":{"0":"bu hafta","1":"gelecek hafta","-1":"geçen hafta"},"relativeTime":{"future":{"one":"{0} hafta sonra","other":"{0} hafta sonra"},"past":{"one":"{0} hafta önce","other":"{0} hafta önce"}}},"week-short":{"displayName":"hf.","relativePeriod":"{0} haftası","relative":{"0":"bu hafta","1":"gelecek hafta","-1":"geçen hafta"},"relativeTime":{"future":{"one":"{0} hf. sonra","other":"{0} hf. sonra"},"past":{"one":"{0} hf. önce","other":"{0} hf. önce"}}},"day":{"displayName":"gün","relative":{"0":"bugün","1":"yarın","2":"öbür gün","-2":"evvelsi gün","-1":"dün"},"relativeTime":{"future":{"one":"{0} gün sonra","other":"{0} gün sonra"},"past":{"one":"{0} gün önce","other":"{0} gün önce"}}},"day-short":{"displayName":"gün","relative":{"0":"bugün","1":"yarın","2":"öbür gün","-2":"evvelsi gün","-1":"dün"},"relativeTime":{"future":{"one":"{0} gün sonra","other":"{0} gün sonra"},"past":{"one":"{0} gün önce","other":"{0} gün önce"}}},"hour":{"displayName":"saat","relative":{"0":"bu saat"},"relativeTime":{"future":{"one":"{0} saat sonra","other":"{0} saat sonra"},"past":{"one":"{0} saat önce","other":"{0} saat önce"}}},"hour-short":{"displayName":"sa.","relative":{"0":"bu saat"},"relativeTime":{"future":{"one":"{0} sa. sonra","other":"{0} sa. sonra"},"past":{"one":"{0} sa. önce","other":"{0} sa. önce"}}},"minute":{"displayName":"dakika","relative":{"0":"bu dakika"},"relativeTime":{"future":{"one":"{0} dakika sonra","other":"{0} dakika sonra"},"past":{"one":"{0} dakika önce","other":"{0} dakika önce"}}},"minute-short":{"displayName":"dk.","relative":{"0":"bu dakika"},"relativeTime":{"future":{"one":"{0} dk. sonra","other":"{0} dk. sonra"},"past":{"one":"{0} dk. önce","other":"{0} dk. önce"}}},"second":{"displayName":"saniye","relative":{"0":"şimdi"},"relativeTime":{"future":{"one":"{0} saniye sonra","other":"{0} saniye sonra"},"past":{"one":"{0} saniye önce","other":"{0} saniye önce"}}},"second-short":{"displayName":"sn.","relative":{"0":"şimdi"},"relativeTime":{"future":{"one":"{0} sn. sonra","other":"{0} sn. sonra"},"past":{"one":"{0} sn. önce","other":"{0} sn. önce"}}}}},{"locale":"tr-CY","parentLocale":"tr"},
    {"locale":"ts","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"tt","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"ел","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"ел","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"ай","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"ай","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"атна","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"атна","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"көн","relative":{"0":"бүген","1":"иртәгә","-1":"кичә"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"көн","relative":{"0":"бүген","1":"иртәгә","-1":"кичә"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"сәгать","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"сәг.","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"минут","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"мин.","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"секунд","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"с.","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"twq","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Jiiri","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Jiiri","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Handu","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Handu","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Hebu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Hebu","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Zaari","relative":{"0":"Hõo","1":"Suba","-1":"Bi"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Zaari","relative":{"0":"Hõo","1":"Suba","-1":"Bi"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Guuru","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Guuru","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Miniti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Miniti","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Miti","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Miti","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"tzm","pluralRuleFunction":function(n
    ) {
      var s = String(n).split('.'), t0 = Number(s[0]) == n;
      return ((n == 0 || n == 1)
              || (t0 && n >= 11 && n <= 99)) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Asseggas","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Asseggas","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Ayur","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Ayur","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Imalass","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Imalass","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Ass","relative":{"0":"Assa","1":"Asekka","-1":"Assenaṭ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Ass","relative":{"0":"Assa","1":"Asekka","-1":"Assenaṭ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Tasragt","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Tasragt","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Tusdat","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Tusdat","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Tusnat","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Tusnat","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"ug","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"يىل","relative":{"0":"بۇ يىل","1":"كېلەر يىل","-1":"ئۆتكەن يىل"},"relativeTime":{"future":{"one":"{0} يىلدىن كېيىن","other":"{0} يىلدىن كېيىن"},"past":{"one":"{0} يىل ئىلگىرى","other":"{0} يىل ئىلگىرى"}}},"year-short":{"displayName":"يىل","relative":{"0":"بۇ يىل","1":"كېلەر يىل","-1":"ئۆتكەن يىل"},"relativeTime":{"future":{"one":"{0} يىلدىن كېيىن","other":"{0} يىلدىن كېيىن"},"past":{"one":"{0} يىل ئىلگىرى","other":"{0} يىل ئىلگىرى"}}},"month":{"displayName":"ئاي","relative":{"0":"بۇ ئاي","1":"كېلەر ئاي","-1":"ئۆتكەن ئاي"},"relativeTime":{"future":{"one":"{0} ئايدىن كېيىن","other":"{0} ئايدىن كېيىن"},"past":{"one":"{0} ئاي ئىلگىرى","other":"{0} ئاي ئىلگىرى"}}},"month-short":{"displayName":"ئاي","relative":{"0":"بۇ ئاي","1":"كېلەر ئاي","-1":"ئۆتكەن ئاي"},"relativeTime":{"future":{"one":"{0} ئايدىن كېيىن","other":"{0} ئايدىن كېيىن"},"past":{"one":"{0} ئاي ئىلگىرى","other":"{0} ئاي ئىلگىرى"}}},"week":{"displayName":"ھەپتە","relativePeriod":"the week of {0}","relative":{"0":"بۇ ھەپتە","1":"كېلەر ھەپتە","-1":"ئۆتكەن ھەپتە"},"relativeTime":{"future":{"one":"{0} ھەپتىدىن كېيىن","other":"{0} ھەپتىدىن كېيىن"},"past":{"one":"{0} ھەپتە ئىلگىرى","other":"{0} ھەپتە ئىلگىرى"}}},"week-short":{"displayName":"ھەپتە","relativePeriod":"the week of {0}","relative":{"0":"بۇ ھەپتە","1":"كېلەر ھەپتە","-1":"ئۆتكەن ھەپتە"},"relativeTime":{"future":{"one":"{0} ھەپتىدىن كېيىن","other":"{0} ھەپتىدىن كېيىن"},"past":{"one":"{0} ھەپتە ئىلگىرى","other":"{0} ھەپتە ئىلگىرى"}}},"day":{"displayName":"كۈن","relative":{"0":"بۈگۈن","1":"ئەتە","-1":"تۈنۈگۈن"},"relativeTime":{"future":{"one":"{0} كۈندىن كېيىن","other":"{0} كۈندىن كېيىن"},"past":{"one":"{0} كۈن ئىلگىرى","other":"{0} كۈن ئىلگىرى"}}},"day-short":{"displayName":"كۈن","relative":{"0":"بۈگۈن","1":"ئەتە","-1":"تۈنۈگۈن"},"relativeTime":{"future":{"one":"{0} كۈندىن كېيىن","other":"{0} كۈندىن كېيىن"},"past":{"one":"{0} كۈن ئىلگىرى","other":"{0} كۈن ئىلگىرى"}}},"hour":{"displayName":"سائەت","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"{0} سائەتتىن كېيىن","other":"{0} سائەتتىن كېيىن"},"past":{"one":"{0} سائەت ئىلگىرى","other":"{0} سائەت ئىلگىرى"}}},"hour-short":{"displayName":"سائەت","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"{0} سائەتتىن كېيىن","other":"{0} سائەتتىن كېيىن"},"past":{"one":"{0} سائەت ئىلگىرى","other":"{0} سائەت ئىلگىرى"}}},"minute":{"displayName":"مىنۇت","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"{0} مىنۇتتىن كېيىن","other":"{0} مىنۇتتىن كېيىن"},"past":{"one":"{0} مىنۇت ئىلگىرى","other":"{0} مىنۇت ئىلگىرى"}}},"minute-short":{"displayName":"مىنۇت","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"{0} مىنۇتتىن كېيىن","other":"{0} مىنۇتتىن كېيىن"},"past":{"one":"{0} مىنۇت ئىلگىرى","other":"{0} مىنۇت ئىلگىرى"}}},"second":{"displayName":"سېكۇنت","relative":{"0":"now"},"relativeTime":{"future":{"one":"{0} سېكۇنتتىن كېيىن","other":"{0} سېكۇنتتىن كېيىن"},"past":{"one":"{0} سېكۇنت ئىلگىرى","other":"{0} سېكۇنت ئىلگىرى"}}},"second-short":{"displayName":"سېكۇنت","relative":{"0":"now"},"relativeTime":{"future":{"one":"{0} سېكۇنتتىن كېيىن","other":"{0} سېكۇنتتىن كېيىن"},"past":{"one":"{0} سېكۇنت ئىلگىرى","other":"{0} سېكۇنت ئىلگىرى"}}}}},
    {"locale":"uk","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), i = s[0], v0 = !s[1], t0 = Number(s[0]) == n,
          n10 = t0 && s[0].slice(-1), n100 = t0 && s[0].slice(-2), i10 = i.slice(-1),
          i100 = i.slice(-2);
      if (ord) return (n10 == 3 && n100 != 13) ? 'few' : 'other';
      return (v0 && i10 == 1 && i100 != 11) ? 'one'
          : (v0 && (i10 >= 2 && i10 <= 4) && (i100 < 12
              || i100 > 14)) ? 'few'
          : (v0 && i10 == 0 || v0 && (i10 >= 5 && i10 <= 9)
              || v0 && (i100 >= 11 && i100 <= 14)) ? 'many'
          : 'other';
    },"fields":{"year":{"displayName":"рік","relative":{"0":"цього року","1":"наступного року","-1":"торік"},"relativeTime":{"future":{"one":"через {0} рік","few":"через {0} роки","many":"через {0} років","other":"через {0} року"},"past":{"one":"{0} рік тому","few":"{0} роки тому","many":"{0} років тому","other":"{0} року тому"}}},"year-short":{"displayName":"р.","relative":{"0":"цього року","1":"наступного року","-1":"торік"},"relativeTime":{"future":{"one":"через {0} р.","few":"через {0} р.","many":"через {0} р.","other":"через {0} р."},"past":{"one":"{0} р. тому","few":"{0} р. тому","many":"{0} р. тому","other":"{0} р. тому"}}},"month":{"displayName":"місяць","relative":{"0":"цього місяця","1":"наступного місяця","-1":"минулого місяця"},"relativeTime":{"future":{"one":"через {0} місяць","few":"через {0} місяці","many":"через {0} місяців","other":"через {0} місяця"},"past":{"one":"{0} місяць тому","few":"{0} місяці тому","many":"{0} місяців тому","other":"{0} місяця тому"}}},"month-short":{"displayName":"міс.","relative":{"0":"цього місяця","1":"наступного місяця","-1":"минулого місяця"},"relativeTime":{"future":{"one":"через {0} міс.","few":"через {0} міс.","many":"через {0} міс.","other":"через {0} міс."},"past":{"one":"{0} міс. тому","few":"{0} міс. тому","many":"{0} міс. тому","other":"{0} міс. тому"}}},"week":{"displayName":"тиждень","relativePeriod":"тиждень з {0}","relative":{"0":"цього тижня","1":"наступного тижня","-1":"минулого тижня"},"relativeTime":{"future":{"one":"через {0} тиждень","few":"через {0} тижні","many":"через {0} тижнів","other":"через {0} тижня"},"past":{"one":"{0} тиждень тому","few":"{0} тижні тому","many":"{0} тижнів тому","other":"{0} тижня тому"}}},"week-short":{"displayName":"тиж.","relativePeriod":"тиждень з {0}","relative":{"0":"цього тижня","1":"наступного тижня","-1":"минулого тижня"},"relativeTime":{"future":{"one":"через {0} тиж.","few":"через {0} тиж.","many":"через {0} тиж.","other":"через {0} тиж."},"past":{"one":"{0} тиж. тому","few":"{0} тиж. тому","many":"{0} тиж. тому","other":"{0} тиж. тому"}}},"day":{"displayName":"день","relative":{"0":"сьогодні","1":"завтра","2":"післязавтра","-2":"позавчора","-1":"учора"},"relativeTime":{"future":{"one":"через {0} день","few":"через {0} дні","many":"через {0} днів","other":"через {0} дня"},"past":{"one":"{0} день тому","few":"{0} дні тому","many":"{0} днів тому","other":"{0} дня тому"}}},"day-short":{"displayName":"д.","relative":{"0":"сьогодні","1":"завтра","2":"післязавтра","-2":"позавчора","-1":"учора"},"relativeTime":{"future":{"one":"через {0} дн.","few":"через {0} дн.","many":"через {0} дн.","other":"через {0} дн."},"past":{"one":"{0} дн. тому","few":"{0} дн. тому","many":"{0} дн. тому","other":"{0} дн. тому"}}},"hour":{"displayName":"година","relative":{"0":"цієї години"},"relativeTime":{"future":{"one":"через {0} годину","few":"через {0} години","many":"через {0} годин","other":"через {0} години"},"past":{"one":"{0} годину тому","few":"{0} години тому","many":"{0} годин тому","other":"{0} години тому"}}},"hour-short":{"displayName":"год.","relative":{"0":"цієї години"},"relativeTime":{"future":{"one":"через {0} год","few":"через {0} год","many":"через {0} год","other":"через {0} год"},"past":{"one":"{0} год тому","few":"{0} год тому","many":"{0} год тому","other":"{0} год тому"}}},"minute":{"displayName":"хвилина","relative":{"0":"цієї хвилини"},"relativeTime":{"future":{"one":"через {0} хвилину","few":"через {0} хвилини","many":"через {0} хвилин","other":"через {0} хвилини"},"past":{"one":"{0} хвилину тому","few":"{0} хвилини тому","many":"{0} хвилин тому","other":"{0} хвилини тому"}}},"minute-short":{"displayName":"хв.","relative":{"0":"цієї хвилини"},"relativeTime":{"future":{"one":"через {0} хв","few":"через {0} хв","many":"через {0} хв","other":"через {0} хв"},"past":{"one":"{0} хв тому","few":"{0} хв тому","many":"{0} хв тому","other":"{0} хв тому"}}},"second":{"displayName":"секунда","relative":{"0":"зараз"},"relativeTime":{"future":{"one":"через {0} секунду","few":"через {0} секунди","many":"через {0} секунд","other":"через {0} секунди"},"past":{"one":"{0} секунду тому","few":"{0} секунди тому","many":"{0} секунд тому","other":"{0} секунди тому"}}},"second-short":{"displayName":"с","relative":{"0":"зараз"},"relativeTime":{"future":{"one":"через {0} с","few":"через {0} с","many":"через {0} с","other":"через {0} с"},"past":{"one":"{0} с тому","few":"{0} с тому","many":"{0} с тому","other":"{0} с тому"}}}}},
    {"locale":"ur","pluralRuleFunction":function(n, ord
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      if (ord) return 'other';
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"سال","relative":{"0":"اس سال","1":"اگلے سال","-1":"گزشتہ سال"},"relativeTime":{"future":{"one":"{0} سال میں","other":"{0} سال میں"},"past":{"one":"{0} سال پہلے","other":"{0} سال پہلے"}}},"year-short":{"displayName":"سال","relative":{"0":"اس سال","1":"اگلے سال","-1":"گزشتہ سال"},"relativeTime":{"future":{"one":"{0} سال میں","other":"{0} سال میں"},"past":{"one":"{0} سال پہلے","other":"{0} سال پہلے"}}},"month":{"displayName":"مہینہ","relative":{"0":"اس مہینہ","1":"اگلا مہینہ","-1":"پچھلا مہینہ"},"relativeTime":{"future":{"one":"{0} مہینہ میں","other":"{0} مہینے میں"},"past":{"one":"{0} مہینہ پہلے","other":"{0} مہینے پہلے"}}},"month-short":{"displayName":"ماہ","relative":{"0":"اس مہینہ","1":"اگلے مہینہ","-1":"پچھلے مہینہ"},"relativeTime":{"future":{"one":"{0} ماہ میں","other":"{0} ماہ میں"},"past":{"one":"{0} ماہ قبل","other":"{0} ماہ قبل"}}},"week":{"displayName":"ہفتہ","relativePeriod":"{0} کے ہفتے","relative":{"0":"اس ہفتہ","1":"اگلے ہفتہ","-1":"پچھلے ہفتہ"},"relativeTime":{"future":{"one":"{0} ہفتہ میں","other":"{0} ہفتے میں"},"past":{"one":"{0} ہفتہ پہلے","other":"{0} ہفتے پہلے"}}},"week-short":{"displayName":"ہفتہ","relativePeriod":"{0} کے ہفتے","relative":{"0":"اس ہفتہ","1":"اگلے ہفتہ","-1":"پچھلے ہفتہ"},"relativeTime":{"future":{"one":"{0} ہفتے میں","other":"{0} ہفتے میں"},"past":{"one":"{0} ہفتے پہلے","other":"{0} ہفتے پہلے"}}},"day":{"displayName":"دن","relative":{"0":"آج","1":"آئندہ کل","2":"آنے والا پرسوں","-2":"گزشتہ پرسوں","-1":"گزشتہ کل"},"relativeTime":{"future":{"one":"{0} دن میں","other":"{0} دنوں میں"},"past":{"one":"{0} دن پہلے","other":"{0} دنوں پہلے"}}},"day-short":{"displayName":"دن","relative":{"0":"آج","1":"آئندہ کل","2":"آنے والا پرسوں","-2":"گزشتہ پرسوں","-1":"گزشتہ کل"},"relativeTime":{"future":{"one":"{0} دن میں","other":"{0} دنوں میں"},"past":{"one":"{0} دن پہلے","other":"{0} دنوں پہلے"}}},"hour":{"displayName":"گھنٹہ","relative":{"0":"اس گھنٹے"},"relativeTime":{"future":{"one":"{0} گھنٹے میں","other":"{0} گھنٹے میں"},"past":{"one":"{0} گھنٹہ پہلے","other":"{0} گھنٹے پہلے"}}},"hour-short":{"displayName":"گھنٹہ","relative":{"0":"اس گھنٹے"},"relativeTime":{"future":{"one":"{0} گھنٹے میں","other":"{0} گھنٹے میں"},"past":{"one":"{0} گھنٹے پہلے","other":"{0} گھنٹے پہلے"}}},"minute":{"displayName":"منٹ","relative":{"0":"اس منٹ"},"relativeTime":{"future":{"one":"{0} منٹ میں","other":"{0} منٹ میں"},"past":{"one":"{0} منٹ پہلے","other":"{0} منٹ پہلے"}}},"minute-short":{"displayName":"منٹ","relative":{"0":"اس منٹ"},"relativeTime":{"future":{"one":"{0} منٹ میں","other":"{0} منٹ میں"},"past":{"one":"{0} منٹ پہلے","other":"{0} منٹ پہلے"}}},"second":{"displayName":"سیکنڈ","relative":{"0":"اب"},"relativeTime":{"future":{"one":"{0} سیکنڈ میں","other":"{0} سیکنڈ میں"},"past":{"one":"{0} سیکنڈ پہلے","other":"{0} سیکنڈ پہلے"}}},"second-short":{"displayName":"سیکنڈ","relative":{"0":"اب"},"relativeTime":{"future":{"one":"{0} سیکنڈ میں","other":"{0} سیکنڈ میں"},"past":{"one":"{0} سیکنڈ پہلے","other":"{0} سیکنڈ پہلے"}}}}},{"locale":"ur-IN","parentLocale":"ur","fields":{"year":{"displayName":"سال","relative":{"0":"اس سال","1":"اگلے سال","-1":"گزشتہ سال"},"relativeTime":{"future":{"one":"{0} سال میں","other":"{0} سالوں میں"},"past":{"one":"{0} سال پہلے","other":"{0} سال پہلے"}}},"year-short":{"displayName":"سال","relative":{"0":"اس سال","1":"اگلے سال","-1":"گزشتہ سال"},"relativeTime":{"future":{"one":"{0} سال میں","other":"{0} سالوں میں"},"past":{"one":"{0} سال پہلے","other":"{0} سالوں پہلے"}}},"month":{"displayName":"مہینہ","relative":{"0":"اس ماہ","1":"اگلے ماہ","-1":"گزشتہ ماہ"},"relativeTime":{"future":{"one":"{0} ماہ میں","other":"{0} ماہ میں"},"past":{"one":"{0} ماہ قبل","other":"{0} ماہ قبل"}}},"month-short":{"displayName":"مہینہ","relative":{"0":"اس مہینہ","1":"اگلے مہینہ","-1":"پچھلے مہینہ"},"relativeTime":{"future":{"one":"{0} ماہ میں","other":"{0} ماہ میں"},"past":{"one":"{0} ماہ قبل","other":"{0} ماہ قبل"}}},"week":{"displayName":"ہفتہ","relativePeriod":"{0} کے ہفتے","relative":{"0":"اس ہفتہ","1":"اگلے ہفتہ","-1":"گزشتہ ہفتہ"},"relativeTime":{"future":{"one":"{0} ہفتہ میں","other":"{0} ہفتوں میں"},"past":{"one":"{0} ہفتہ قبل","other":"{0} ہفتے قبل"}}},"week-short":{"displayName":"ہفتہ","relativePeriod":"{0} کے ہفتے","relative":{"0":"اس ہفتہ","1":"اگلے ہفتہ","-1":"پچھلے ہفتہ"},"relativeTime":{"future":{"one":"{0} ہفتے میں","other":"{0} ہفتے میں"},"past":{"one":"{0} ہفتے قبل","other":"{0} ہفتے قبل"}}},"day":{"displayName":"دن","relative":{"0":"آج","1":"آئندہ کل","2":"آنے والا پرسوں","-2":"گزشتہ پرسوں","-1":"گزشتہ کل"},"relativeTime":{"future":{"one":"{0} دن میں","other":"{0} دنوں میں"},"past":{"one":"{0} دن پہلے","other":"{0} دنوں پہلے"}}},"day-short":{"displayName":"دن","relative":{"0":"آج","1":"آئندہ کل","2":"آنے والا پرسوں","-2":"گزشتہ پرسوں","-1":"گزشتہ کل"},"relativeTime":{"future":{"one":"{0} دنوں میں","other":"{0} دنوں میں"},"past":{"one":"{0} دن پہلے","other":"{0} دنوں پہلے"}}},"hour":{"displayName":"گھنٹہ","relative":{"0":"اس گھنٹے"},"relativeTime":{"future":{"one":"{0} گھنٹے میں","other":"{0} گھنٹے میں"},"past":{"one":"{0} گھنٹہ پہلے","other":"{0} گھنٹے پہلے"}}},"hour-short":{"displayName":"گھنٹہ","relative":{"0":"اس گھنٹے"},"relativeTime":{"future":{"one":"{0} گھنٹے میں","other":"{0} گھنٹے میں"},"past":{"one":"{0} گھنٹے قبل","other":"{0} گھنٹے قبل"}}},"minute":{"displayName":"منٹ","relative":{"0":"اس منٹ"},"relativeTime":{"future":{"one":"{0} منٹ میں","other":"{0} منٹ میں"},"past":{"one":"{0} منٹ قبل","other":"{0} منٹ قبل"}}},"minute-short":{"displayName":"منٹ","relative":{"0":"اس منٹ"},"relativeTime":{"future":{"one":"{0} منٹ میں","other":"{0} منٹ میں"},"past":{"one":"{0} منٹ قبل","other":"{0} منٹ قبل"}}},"second":{"displayName":"سیکنڈ","relative":{"0":"اب"},"relativeTime":{"future":{"one":"{0} سیکنڈ میں","other":"{0} سیکنڈ میں"},"past":{"one":"{0} سیکنڈ قبل","other":"{0} سیکنڈ قبل"}}},"second-short":{"displayName":"سیکنڈ","relative":{"0":"اب"},"relativeTime":{"future":{"one":"{0} سیکنڈ میں","other":"{0} سیکنڈ میں"},"past":{"one":"{0} سیکنڈ قبل","other":"{0} سیکنڈ قبل"}}}}},
    {"locale":"uz","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"yil","relative":{"0":"shu yil","1":"keyingi yil","-1":"o‘tgan yil"},"relativeTime":{"future":{"one":"{0} yildan keyin","other":"{0} yildan keyin"},"past":{"one":"{0} yil oldin","other":"{0} yil oldin"}}},"year-short":{"displayName":"yil","relative":{"0":"bu yil","1":"keyingi yil","-1":"oʻtgan yil"},"relativeTime":{"future":{"one":"{0} yildan keyin","other":"{0} yildan keyin"},"past":{"one":"{0} yil oldin","other":"{0} yil oldin"}}},"month":{"displayName":"oy","relative":{"0":"shu oy","1":"keyingi oy","-1":"o‘tgan oy"},"relativeTime":{"future":{"one":"{0} oydan keyin","other":"{0} oydan keyin"},"past":{"one":"{0} oy oldin","other":"{0} oy oldin"}}},"month-short":{"displayName":"oy","relative":{"0":"shu oy","1":"keyingi oy","-1":"o‘tgan oy"},"relativeTime":{"future":{"one":"{0} oydan keyin","other":"{0} oydan keyin"},"past":{"one":"{0} oy oldin","other":"{0} oy oldin"}}},"week":{"displayName":"hafta","relativePeriod":"{0}-hafta","relative":{"0":"shu hafta","1":"keyingi hafta","-1":"o‘tgan hafta"},"relativeTime":{"future":{"one":"{0} haftadan keyin","other":"{0} haftadan keyin"},"past":{"one":"{0} hafta oldin","other":"{0} hafta oldin"}}},"week-short":{"displayName":"hafta","relativePeriod":"{0}-hafta","relative":{"0":"shu hafta","1":"keyingi hafta","-1":"o‘tgan hafta"},"relativeTime":{"future":{"one":"{0} haftadan keyin","other":"{0} haftadan keyin"},"past":{"one":"{0} hafta oldin","other":"{0} hafta oldin"}}},"day":{"displayName":"kun","relative":{"0":"bugun","1":"ertaga","-1":"kecha"},"relativeTime":{"future":{"one":"{0} kundan keyin","other":"{0} kundan keyin"},"past":{"one":"{0} kun oldin","other":"{0} kun oldin"}}},"day-short":{"displayName":"kun","relative":{"0":"bugun","1":"ertaga","-1":"kecha"},"relativeTime":{"future":{"one":"{0} kundan keyin","other":"{0} kundan keyin"},"past":{"one":"{0} kun oldin","other":"{0} kun oldin"}}},"hour":{"displayName":"soat","relative":{"0":"shu soatda"},"relativeTime":{"future":{"one":"{0} soatdan keyin","other":"{0} soatdan keyin"},"past":{"one":"{0} soat oldin","other":"{0} soat oldin"}}},"hour-short":{"displayName":"soat","relative":{"0":"shu soatda"},"relativeTime":{"future":{"one":"{0} soatdan keyin","other":"{0} soatdan keyin"},"past":{"one":"{0} soat oldin","other":"{0} soat oldin"}}},"minute":{"displayName":"daqiqa","relative":{"0":"shu daqiqada"},"relativeTime":{"future":{"one":"{0} daqiqadan keyin","other":"{0} daqiqadan keyin"},"past":{"one":"{0} daqiqa oldin","other":"{0} daqiqa oldin"}}},"minute-short":{"displayName":"daq.","relative":{"0":"shu daqiqada"},"relativeTime":{"future":{"one":"{0} daqiqadan keyin","other":"{0} daqiqadan keyin"},"past":{"one":"{0} daqiqa oldin","other":"{0} daqiqa oldin"}}},"second":{"displayName":"soniya","relative":{"0":"hozir"},"relativeTime":{"future":{"one":"{0} soniyadan keyin","other":"{0} soniyadan keyin"},"past":{"one":"{0} soniya oldin","other":"{0} soniya oldin"}}},"second-short":{"displayName":"son.","relative":{"0":"hozir"},"relativeTime":{"future":{"one":"{0} soniyadan keyin","other":"{0} soniyadan keyin"},"past":{"one":"{0} soniya oldin","other":"{0} soniya oldin"}}}}},{"locale":"uz-Arab","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"uz-Cyrl","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Йил","relative":{"0":"бу йил","1":"кейинги йил","-1":"ўтган йил"},"relativeTime":{"future":{"one":"{0} йилдан сўнг","other":"{0} йилдан сўнг"},"past":{"one":"{0} йил аввал","other":"{0} йил аввал"}}},"year-short":{"displayName":"Йил","relative":{"0":"бу йил","1":"кейинги йил","-1":"ўтган йил"},"relativeTime":{"future":{"one":"{0} йилдан сўнг","other":"{0} йилдан сўнг"},"past":{"one":"{0} йил аввал","other":"{0} йил аввал"}}},"month":{"displayName":"Ой","relative":{"0":"бу ой","1":"кейинги ой","-1":"ўтган ой"},"relativeTime":{"future":{"one":"{0} ойдан сўнг","other":"{0} ойдан сўнг"},"past":{"one":"{0} ой аввал","other":"{0} ой аввал"}}},"month-short":{"displayName":"Ой","relative":{"0":"бу ой","1":"кейинги ой","-1":"ўтган ой"},"relativeTime":{"future":{"one":"{0} ойдан сўнг","other":"{0} ойдан сўнг"},"past":{"one":"{0} ой аввал","other":"{0} ой аввал"}}},"week":{"displayName":"Ҳафта","relativePeriod":"the week of {0}","relative":{"0":"бу ҳафта","1":"кейинги ҳафта","-1":"ўтган ҳафта"},"relativeTime":{"future":{"one":"{0} ҳафтадан сўнг","other":"{0} ҳафтадан сўнг"},"past":{"one":"{0} ҳафта олдин","other":"{0} ҳафта олдин"}}},"week-short":{"displayName":"Ҳафта","relativePeriod":"the week of {0}","relative":{"0":"бу ҳафта","1":"кейинги ҳафта","-1":"ўтган ҳафта"},"relativeTime":{"future":{"one":"{0} ҳафтадан сўнг","other":"{0} ҳафтадан сўнг"},"past":{"one":"{0} ҳафта олдин","other":"{0} ҳафта олдин"}}},"day":{"displayName":"Кун","relative":{"0":"бугун","1":"эртага","-1":"кеча"},"relativeTime":{"future":{"one":"{0} кундан сўнг","other":"{0} кундан сўнг"},"past":{"one":"{0} кун олдин","other":"{0} кун олдин"}}},"day-short":{"displayName":"Кун","relative":{"0":"бугун","1":"эртага","-1":"кеча"},"relativeTime":{"future":{"one":"{0} кундан сўнг","other":"{0} кундан сўнг"},"past":{"one":"{0} кун олдин","other":"{0} кун олдин"}}},"hour":{"displayName":"Соат","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"{0} соатдан сўнг","other":"{0} соатдан сўнг"},"past":{"one":"{0} соат олдин","other":"{0} соат олдин"}}},"hour-short":{"displayName":"Соат","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"{0} соатдан сўнг","other":"{0} соатдан сўнг"},"past":{"one":"{0} соат олдин","other":"{0} соат олдин"}}},"minute":{"displayName":"Дақиқа","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"{0} дақиқадан сўнг","other":"{0} дақиқадан сўнг"},"past":{"one":"{0} дақиқа олдин","other":"{0} дақиқа олдин"}}},"minute-short":{"displayName":"Дақиқа","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"{0} дақиқадан сўнг","other":"{0} дақиқадан сўнг"},"past":{"one":"{0} дақиқа олдин","other":"{0} дақиқа олдин"}}},"second":{"displayName":"Сония","relative":{"0":"ҳозир"},"relativeTime":{"future":{"one":"{0} сониядан сўнг","other":"{0} сониядан сўнг"},"past":{"one":"{0} сония олдин","other":"{0} сония олдин"}}},"second-short":{"displayName":"Сония","relative":{"0":"ҳозир"},"relativeTime":{"future":{"one":"{0} сониядан сўнг","other":"{0} сониядан сўнг"},"past":{"one":"{0} сония олдин","other":"{0} сония олдин"}}}}},{"locale":"uz-Latn","parentLocale":"uz"},
    {"locale":"vai","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"ꕢꘋ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"ꕢꘋ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"ꕪꖃ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"ꕪꖃ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"ꔨꔤꕃ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"ꔨꔤꕃ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"ꔎꔒ","relative":{"0":"ꗦꗷ","1":"ꔻꕯ","-1":"ꖴꖸ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"ꔎꔒ","relative":{"0":"ꗦꗷ","1":"ꔻꕯ","-1":"ꖴꖸ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"ꕌꕎ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"ꕌꕎ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"ꕆꕇ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"ꕆꕇ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"ꕧꕃꕧꕪ","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"ꕧꕃꕧꕪ","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"vai-Latn","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"saŋ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"saŋ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"kalo","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"kalo","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"wiki","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"wiki","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"tele","relative":{"0":"wɛlɛ","1":"sina","-1":"kunu"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"tele","relative":{"0":"wɛlɛ","1":"sina","-1":"kunu"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"hawa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"hawa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"mini","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"mini","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"jaki-jaka","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"jaki-jaka","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"vai-Vaii","parentLocale":"vai"},
    {"locale":"ve","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"vi","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return (n == 1) ? 'one' : 'other';
      return 'other';
    },"fields":{"year":{"displayName":"Năm","relative":{"0":"năm nay","1":"năm sau","-1":"năm ngoái"},"relativeTime":{"future":{"other":"sau {0} năm nữa"},"past":{"other":"{0} năm trước"}}},"year-short":{"displayName":"Năm","relative":{"0":"năm nay","1":"năm sau","-1":"năm ngoái"},"relativeTime":{"future":{"other":"sau {0} năm nữa"},"past":{"other":"{0} năm trước"}}},"month":{"displayName":"Tháng","relative":{"0":"tháng này","1":"tháng sau","-1":"tháng trước"},"relativeTime":{"future":{"other":"sau {0} tháng nữa"},"past":{"other":"{0} tháng trước"}}},"month-short":{"displayName":"Tháng","relative":{"0":"tháng này","1":"tháng sau","-1":"tháng trước"},"relativeTime":{"future":{"other":"sau {0} tháng nữa"},"past":{"other":"{0} tháng trước"}}},"week":{"displayName":"Tuần","relativePeriod":"tuần {0}","relative":{"0":"tuần này","1":"tuần sau","-1":"tuần trước"},"relativeTime":{"future":{"other":"sau {0} tuần nữa"},"past":{"other":"{0} tuần trước"}}},"week-short":{"displayName":"Tuần","relativePeriod":"tuần {0}","relative":{"0":"tuần này","1":"tuần sau","-1":"tuần trước"},"relativeTime":{"future":{"other":"sau {0} tuần nữa"},"past":{"other":"{0} tuần trước"}}},"day":{"displayName":"Ngày","relative":{"0":"Hôm nay","1":"Ngày mai","2":"Ngày kia","-2":"Hôm kia","-1":"Hôm qua"},"relativeTime":{"future":{"other":"sau {0} ngày nữa"},"past":{"other":"{0} ngày trước"}}},"day-short":{"displayName":"Ngày","relative":{"0":"Hôm nay","1":"Ngày mai","2":"Ngày kia","-2":"Hôm kia","-1":"Hôm qua"},"relativeTime":{"future":{"other":"sau {0} ngày nữa"},"past":{"other":"{0} ngày trước"}}},"hour":{"displayName":"Giờ","relative":{"0":"giờ này"},"relativeTime":{"future":{"other":"sau {0} giờ nữa"},"past":{"other":"{0} giờ trước"}}},"hour-short":{"displayName":"Giờ","relative":{"0":"giờ này"},"relativeTime":{"future":{"other":"sau {0} giờ nữa"},"past":{"other":"{0} giờ trước"}}},"minute":{"displayName":"Phút","relative":{"0":"phút này"},"relativeTime":{"future":{"other":"sau {0} phút nữa"},"past":{"other":"{0} phút trước"}}},"minute-short":{"displayName":"Phút","relative":{"0":"phút này"},"relativeTime":{"future":{"other":"sau {0} phút nữa"},"past":{"other":"{0} phút trước"}}},"second":{"displayName":"Giây","relative":{"0":"bây giờ"},"relativeTime":{"future":{"other":"sau {0} giây nữa"},"past":{"other":"{0} giây trước"}}},"second-short":{"displayName":"Giây","relative":{"0":"bây giờ"},"relativeTime":{"future":{"other":"sau {0} giây nữa"},"past":{"other":"{0} giây trước"}}}}},
    {"locale":"vo","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"vun","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Maka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Maka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Mori","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Mori","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Wiikyi","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Wiikyi","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Mfiri","relative":{"0":"Inu","1":"Ngama","-1":"Ukou"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Mfiri","relative":{"0":"Inu","1":"Ngama","-1":"Ukou"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Saa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Dakyika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Dakyika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Sekunde","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"wa","pluralRuleFunction":function(n
    ) {
      return ((n == 0
              || n == 1)) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"wae","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Jár","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"one":"I {0} jár","other":"I {0} jár"},"past":{"one":"vor {0} jár","other":"cor {0} jár"}}},"year-short":{"displayName":"Jár","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"one":"I {0} jár","other":"I {0} jár"},"past":{"one":"vor {0} jár","other":"cor {0} jár"}}},"month":{"displayName":"Mánet","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"I {0} mánet","other":"I {0} mánet"},"past":{"one":"vor {0} mánet","other":"vor {0} mánet"}}},"month-short":{"displayName":"Mánet","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"one":"I {0} mánet","other":"I {0} mánet"},"past":{"one":"vor {0} mánet","other":"vor {0} mánet"}}},"week":{"displayName":"Wuča","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"i {0} wuča","other":"i {0} wučä"},"past":{"one":"vor {0} wuča","other":"cor {0} wučä"}}},"week-short":{"displayName":"Wuča","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"one":"i {0} wuča","other":"i {0} wučä"},"past":{"one":"vor {0} wuča","other":"cor {0} wučä"}}},"day":{"displayName":"Tag","relative":{"0":"Hitte","1":"Móre","2":"Ubermóre","-2":"Vorgešter","-1":"Gešter"},"relativeTime":{"future":{"one":"i {0} tag","other":"i {0} täg"},"past":{"one":"vor {0} tag","other":"vor {0} täg"}}},"day-short":{"displayName":"Tag","relative":{"0":"Hitte","1":"Móre","2":"Ubermóre","-2":"Vorgešter","-1":"Gešter"},"relativeTime":{"future":{"one":"i {0} tag","other":"i {0} täg"},"past":{"one":"vor {0} tag","other":"vor {0} täg"}}},"hour":{"displayName":"Schtund","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"i {0} stund","other":"i {0} stunde"},"past":{"one":"vor {0} stund","other":"vor {0} stunde"}}},"hour-short":{"displayName":"Schtund","relative":{"0":"this hour"},"relativeTime":{"future":{"one":"i {0} stund","other":"i {0} stunde"},"past":{"one":"vor {0} stund","other":"vor {0} stunde"}}},"minute":{"displayName":"Mínütta","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"i {0} minüta","other":"i {0} minüte"},"past":{"one":"vor {0} minüta","other":"vor {0} minüte"}}},"minute-short":{"displayName":"Mínütta","relative":{"0":"this minute"},"relativeTime":{"future":{"one":"i {0} minüta","other":"i {0} minüte"},"past":{"one":"vor {0} minüta","other":"vor {0} minüte"}}},"second":{"displayName":"Sekunda","relative":{"0":"now"},"relativeTime":{"future":{"one":"i {0} sekund","other":"i {0} sekunde"},"past":{"one":"vor {0} sekund","other":"vor {0} sekunde"}}},"second-short":{"displayName":"Sekunda","relative":{"0":"now"},"relativeTime":{"future":{"one":"i {0} sekund","other":"i {0} sekunde"},"past":{"one":"vor {0} sekund","other":"vor {0} sekunde"}}}}},
    {"locale":"wo","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"at","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"at.","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"weer","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"we.","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"ayu-bis","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"ayu-b.","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"fan","relative":{"0":"tay","1":"suba","-1":"démb"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"fan","relative":{"0":"tay","1":"suba","-1":"démb"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"waxtu","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"wxt.","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"simili","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"sim.","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"saa","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"saa.","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"xh","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Year","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Month","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Week","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Day","relative":{"0":"today","1":"tomorrow","-1":"yesterday"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Hour","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Minute","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Second","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"xog","pluralRuleFunction":function(n
    ) {
      return (n == 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Omwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Omwaka","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Omwezi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Omwezi","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Esabiiti","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Esabiiti","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Olunaku","relative":{"0":"Olwaleelo (leelo)","1":"Enkyo","-1":"Edho"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Olunaku","relative":{"0":"Olwaleelo (leelo)","1":"Enkyo","-1":"Edho"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"Essawa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"Essawa","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Edakiika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Edakiika","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Obutikitiki","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Obutikitiki","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"yav","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"yɔɔŋ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"yɔɔŋ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"oóli","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"oóli","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"sɔ́ndiɛ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"sɔ́ndiɛ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"puɔ́sɛ́","relative":{"0":"ínaan","1":"nakinyám","-1":"púyoó"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"puɔ́sɛ́","relative":{"0":"ínaan","1":"nakinyám","-1":"púyoó"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"kisikɛl,","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"kisikɛl,","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"minít","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"minít","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"síkɛn","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"síkɛn","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"yi","pluralRuleFunction":function(n
    ) {
      var s = String(n).split('.'), v0 = !s[1];
      return (n == 1 && v0) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"יאָר","relative":{"0":"הײַ יאָר","1":"איבער א יאָר","-1":"פֿאַראַיאָר"},"relativeTime":{"future":{"one":"איבער {0} יאָר","other":"איבער {0} יאָר"},"past":{"one":"פֿאַר {0} יאָר","other":"פֿאַר {0} יאָר"}}},"year-short":{"displayName":"יאָר","relative":{"0":"הײַ יאָר","1":"איבער א יאָר","-1":"פֿאַראַיאָר"},"relativeTime":{"future":{"one":"איבער א יאָר","other":"איבער {0} יאָר"},"past":{"one":"פֿאַר {0} יאָר","other":"פֿאַר {0} יאָר"}}},"month":{"displayName":"מאנאַט","relative":{"0":"דעם חודש","1":"קומענדיקן חודש","-1":"פֿאַרגאנגענעם חודש"},"relativeTime":{"future":{"one":"איבער {0} חודש","other":"איבער {0} חדשים"},"past":{"one":"פֿאַר {0} חודש","other":"פֿאַר {0} חדשים"}}},"month-short":{"displayName":"מאנאַט","relative":{"0":"דעם חודש","1":"קומענדיקן חודש","-1":"פֿאַרגאנגענעם חודש"},"relativeTime":{"future":{"one":"איבער {0} חודש","other":"איבער {0} חדשים"},"past":{"one":"פֿאַר {0} חודש","other":"פֿאַר {0} חדשים"}}},"week":{"displayName":"וואך","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"איבער אַכט טאָג","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"וואך","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"איבער אַכט טאָג","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"טאָג","relative":{"0":"היינט","1":"מארגן","-1":"נעכטן"},"relativeTime":{"future":{"one":"אין {0} טאָג אַרום","other":"אין {0} טעג אַרום"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"טאָג","relative":{"0":"היינט","1":"מארגן","-1":"נעכטן"},"relativeTime":{"future":{"one":"אין {0} טאָג אַרום","other":"אין {0} טעג אַרום"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"שעה","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"שעה","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"מינוט","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"מינוט","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"סעקונדע","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"סעקונדע","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"yo","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"Ọdún","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Ọdún","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Osù","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Osù","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Ọ̀sè","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Ọ̀sè","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Ọjọ́","relative":{"0":"Òní","1":"Ọ̀la","2":"òtúùnla","-2":"íjẹta","-1":"Àná"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Ọjọ́","relative":{"0":"Òní","1":"Ọ̀la","2":"òtúùnla","-2":"íjẹta","-1":"Àná"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"wákàtí","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"wákàtí","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Ìsẹ́jú","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Ìsẹ́jú","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Ìsẹ́jú Ààyá","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Ìsẹ́jú Ààyá","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},{"locale":"yo-BJ","parentLocale":"yo","fields":{"year":{"displayName":"Ɔdún","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"Ɔdún","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"Osù","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"Osù","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"Ɔ̀sè","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"Ɔ̀sè","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"Ɔjɔ́","relative":{"0":"Òní","1":"Ɔ̀la","2":"òtúùnla","-2":"íjɛta","-1":"Àná"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"Ɔjɔ́","relative":{"0":"Òní","1":"Ɔ̀la","2":"òtúùnla","-2":"íjɛta","-1":"Àná"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"wákàtí","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"wákàtí","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"Ìsɛ́jú","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"Ìsɛ́jú","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"Ìsɛ́jú Ààyá","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"Ìsɛ́jú Ààyá","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"yue","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return 'other';
    },"fields":{"year":{"displayName":"年","relative":{"0":"今年","1":"下年","-1":"舊年"},"relativeTime":{"future":{"other":"{0} 年後"},"past":{"other":"{0} 年前"}}},"year-short":{"displayName":"年","relative":{"0":"今年","1":"下年","-1":"舊年"},"relativeTime":{"future":{"other":"{0} 年後"},"past":{"other":"{0} 年前"}}},"month":{"displayName":"月","relative":{"0":"今個月","1":"下個月","-1":"上個月"},"relativeTime":{"future":{"other":"{0} 個月後"},"past":{"other":"{0} 個月前"}}},"month-short":{"displayName":"月","relative":{"0":"今個月","1":"下個月","-1":"上個月"},"relativeTime":{"future":{"other":"{0} 個月後"},"past":{"other":"{0} 個月前"}}},"week":{"displayName":"週","relativePeriod":"{0}嘅星期","relative":{"0":"今個星期","1":"下星期","-1":"上星期"},"relativeTime":{"future":{"other":"{0} 個星期後"},"past":{"other":"{0} 個星期前"}}},"week-short":{"displayName":"週","relativePeriod":"{0}嘅星期","relative":{"0":"今個星期","1":"下星期","-1":"上星期"},"relativeTime":{"future":{"other":"{0} 個星期後"},"past":{"other":"{0} 個星期前"}}},"day":{"displayName":"日","relative":{"0":"今日","1":"聽日","2":"後天","-2":"前天","-1":"尋日"},"relativeTime":{"future":{"other":"{0} 日後"},"past":{"other":"{0} 日前"}}},"day-short":{"displayName":"日","relative":{"0":"今日","1":"聽日","2":"後天","-2":"前天","-1":"尋日"},"relativeTime":{"future":{"other":"{0} 日後"},"past":{"other":"{0} 日前"}}},"hour":{"displayName":"小時","relative":{"0":"呢個小時"},"relativeTime":{"future":{"other":"{0} 小時後"},"past":{"other":"{0} 小時前"}}},"hour-short":{"displayName":"小時","relative":{"0":"呢個小時"},"relativeTime":{"future":{"other":"{0} 小時後"},"past":{"other":"{0} 小時前"}}},"minute":{"displayName":"分鐘","relative":{"0":"呢分鐘"},"relativeTime":{"future":{"other":"{0} 分鐘後"},"past":{"other":"{0} 分鐘前"}}},"minute-short":{"displayName":"分鐘","relative":{"0":"呢分鐘"},"relativeTime":{"future":{"other":"{0} 分鐘後"},"past":{"other":"{0} 分鐘前"}}},"second":{"displayName":"秒","relative":{"0":"宜家"},"relativeTime":{"future":{"other":"{0} 秒後"},"past":{"other":"{0} 秒前"}}},"second-short":{"displayName":"秒","relative":{"0":"宜家"},"relativeTime":{"future":{"other":"{0} 秒後"},"past":{"other":"{0} 秒前"}}}}},{"locale":"yue-Hans","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"年","relative":{"0":"今年","1":"下年","-1":"旧年"},"relativeTime":{"future":{"other":"{0} 年后"},"past":{"other":"{0} 年前"}}},"year-short":{"displayName":"年","relative":{"0":"今年","1":"下年","-1":"旧年"},"relativeTime":{"future":{"other":"{0} 年后"},"past":{"other":"{0} 年前"}}},"month":{"displayName":"月","relative":{"0":"今个月","1":"下个月","-1":"上个月"},"relativeTime":{"future":{"other":"{0} 个月后"},"past":{"other":"{0} 个月前"}}},"month-short":{"displayName":"月","relative":{"0":"今个月","1":"下个月","-1":"上个月"},"relativeTime":{"future":{"other":"{0} 个月后"},"past":{"other":"{0} 个月前"}}},"week":{"displayName":"周","relativePeriod":"{0}嘅星期","relative":{"0":"今个星期","1":"下星期","-1":"上星期"},"relativeTime":{"future":{"other":"{0} 个星期后"},"past":{"other":"{0} 个星期前"}}},"week-short":{"displayName":"周","relativePeriod":"{0}嘅星期","relative":{"0":"今个星期","1":"下星期","-1":"上星期"},"relativeTime":{"future":{"other":"{0} 个星期后"},"past":{"other":"{0} 个星期前"}}},"day":{"displayName":"日","relative":{"0":"今日","1":"听日","2":"后天","-2":"前天","-1":"寻日"},"relativeTime":{"future":{"other":"{0} 日后"},"past":{"other":"{0} 日前"}}},"day-short":{"displayName":"日","relative":{"0":"今日","1":"听日","2":"后天","-2":"前天","-1":"寻日"},"relativeTime":{"future":{"other":"{0} 日后"},"past":{"other":"{0} 日前"}}},"hour":{"displayName":"小时","relative":{"0":"呢个小时"},"relativeTime":{"future":{"other":"{0} 小时后"},"past":{"other":"{0} 小时前"}}},"hour-short":{"displayName":"小时","relative":{"0":"呢个小时"},"relativeTime":{"future":{"other":"{0} 小时后"},"past":{"other":"{0} 小时前"}}},"minute":{"displayName":"分钟","relative":{"0":"呢分钟"},"relativeTime":{"future":{"other":"{0} 分钟后"},"past":{"other":"{0} 分钟前"}}},"minute-short":{"displayName":"分钟","relative":{"0":"呢分钟"},"relativeTime":{"future":{"other":"{0} 分钟后"},"past":{"other":"{0} 分钟前"}}},"second":{"displayName":"秒","relative":{"0":"宜家"},"relativeTime":{"future":{"other":"{0} 秒后"},"past":{"other":"{0} 秒前"}}},"second-short":{"displayName":"秒","relative":{"0":"宜家"},"relativeTime":{"future":{"other":"{0} 秒后"},"past":{"other":"{0} 秒前"}}}}},{"locale":"yue-Hant","parentLocale":"yue"},
    {"locale":"zgh","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"ⴰⵙⴳⴳⵯⴰⵙ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"year-short":{"displayName":"ⴰⵙⴳⴳⵯⴰⵙ","relative":{"0":"this year","1":"next year","-1":"last year"},"relativeTime":{"future":{"other":"+{0} y"},"past":{"other":"-{0} y"}}},"month":{"displayName":"ⴰⵢⵢⵓⵔ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"month-short":{"displayName":"ⴰⵢⵢⵓⵔ","relative":{"0":"this month","1":"next month","-1":"last month"},"relativeTime":{"future":{"other":"+{0} m"},"past":{"other":"-{0} m"}}},"week":{"displayName":"ⵉⵎⴰⵍⴰⵙⵙ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"week-short":{"displayName":"ⵉⵎⴰⵍⴰⵙⵙ","relativePeriod":"the week of {0}","relative":{"0":"this week","1":"next week","-1":"last week"},"relativeTime":{"future":{"other":"+{0} w"},"past":{"other":"-{0} w"}}},"day":{"displayName":"ⴰⵙⵙ","relative":{"0":"ⴰⵙⵙⴰ","1":"ⴰⵙⴽⴽⴰ","-1":"ⵉⴹⵍⵍⵉ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"day-short":{"displayName":"ⴰⵙⵙ","relative":{"0":"ⴰⵙⵙⴰ","1":"ⴰⵙⴽⴽⴰ","-1":"ⵉⴹⵍⵍⵉ"},"relativeTime":{"future":{"other":"+{0} d"},"past":{"other":"-{0} d"}}},"hour":{"displayName":"ⵜⴰⵙⵔⴰⴳⵜ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"hour-short":{"displayName":"ⵜⴰⵙⵔⴰⴳⵜ","relative":{"0":"this hour"},"relativeTime":{"future":{"other":"+{0} h"},"past":{"other":"-{0} h"}}},"minute":{"displayName":"ⵜⵓⵙⴷⵉⴷⵜ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"minute-short":{"displayName":"ⵜⵓⵙⴷⵉⴷⵜ","relative":{"0":"this minute"},"relativeTime":{"future":{"other":"+{0} min"},"past":{"other":"-{0} min"}}},"second":{"displayName":"ⵜⴰⵙⵉⵏⵜ","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}},"second-short":{"displayName":"ⵜⴰⵙⵉⵏⵜ","relative":{"0":"now"},"relativeTime":{"future":{"other":"+{0} s"},"past":{"other":"-{0} s"}}}}},
    {"locale":"zh","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return 'other';
    },"fields":{"year":{"displayName":"年","relative":{"0":"今年","1":"明年","-1":"去年"},"relativeTime":{"future":{"other":"{0}年后"},"past":{"other":"{0}年前"}}},"year-short":{"displayName":"年","relative":{"0":"今年","1":"明年","-1":"去年"},"relativeTime":{"future":{"other":"{0}年后"},"past":{"other":"{0}年前"}}},"month":{"displayName":"月","relative":{"0":"本月","1":"下个月","-1":"上个月"},"relativeTime":{"future":{"other":"{0}个月后"},"past":{"other":"{0}个月前"}}},"month-short":{"displayName":"月","relative":{"0":"本月","1":"下个月","-1":"上个月"},"relativeTime":{"future":{"other":"{0}个月后"},"past":{"other":"{0}个月前"}}},"week":{"displayName":"周","relativePeriod":"{0}这周","relative":{"0":"本周","1":"下周","-1":"上周"},"relativeTime":{"future":{"other":"{0}周后"},"past":{"other":"{0}周前"}}},"week-short":{"displayName":"周","relativePeriod":"{0}这周","relative":{"0":"本周","1":"下周","-1":"上周"},"relativeTime":{"future":{"other":"{0}周后"},"past":{"other":"{0}周前"}}},"day":{"displayName":"日","relative":{"0":"今天","1":"明天","2":"后天","-2":"前天","-1":"昨天"},"relativeTime":{"future":{"other":"{0}天后"},"past":{"other":"{0}天前"}}},"day-short":{"displayName":"日","relative":{"0":"今天","1":"明天","2":"后天","-2":"前天","-1":"昨天"},"relativeTime":{"future":{"other":"{0}天后"},"past":{"other":"{0}天前"}}},"hour":{"displayName":"小时","relative":{"0":"这一时间 \u002F 此时"},"relativeTime":{"future":{"other":"{0}小时后"},"past":{"other":"{0}小时前"}}},"hour-short":{"displayName":"小时","relative":{"0":"这一时间 \u002F 此时"},"relativeTime":{"future":{"other":"{0}小时后"},"past":{"other":"{0}小时前"}}},"minute":{"displayName":"分钟","relative":{"0":"此刻"},"relativeTime":{"future":{"other":"{0}分钟后"},"past":{"other":"{0}分钟前"}}},"minute-short":{"displayName":"分","relative":{"0":"此刻"},"relativeTime":{"future":{"other":"{0}分钟后"},"past":{"other":"{0}分钟前"}}},"second":{"displayName":"秒","relative":{"0":"现在"},"relativeTime":{"future":{"other":"{0}秒钟后"},"past":{"other":"{0}秒钟前"}}},"second-short":{"displayName":"秒","relative":{"0":"现在"},"relativeTime":{"future":{"other":"{0}秒后"},"past":{"other":"{0}秒前"}}}}},{"locale":"zh-Hans","parentLocale":"zh"},{"locale":"zh-Hans-HK","parentLocale":"zh-Hans","fields":{"year":{"displayName":"年","relative":{"0":"今年","1":"明年","-1":"去年"},"relativeTime":{"future":{"other":"{0}年后"},"past":{"other":"{0}年前"}}},"year-short":{"displayName":"年","relative":{"0":"今年","1":"明年","-1":"去年"},"relativeTime":{"future":{"other":"{0}年后"},"past":{"other":"{0}年前"}}},"month":{"displayName":"月","relative":{"0":"本月","1":"下个月","-1":"上个月"},"relativeTime":{"future":{"other":"{0}个月后"},"past":{"other":"{0}个月前"}}},"month-short":{"displayName":"月","relative":{"0":"本月","1":"下个月","-1":"上个月"},"relativeTime":{"future":{"other":"{0}个月后"},"past":{"other":"{0}个月前"}}},"week":{"displayName":"周","relativePeriod":"{0}这周","relative":{"0":"本周","1":"下周","-1":"上周"},"relativeTime":{"future":{"other":"{0}周后"},"past":{"other":"{0}周前"}}},"week-short":{"displayName":"周","relativePeriod":"{0}这周","relative":{"0":"本周","1":"下周","-1":"上周"},"relativeTime":{"future":{"other":"{0}周后"},"past":{"other":"{0}周前"}}},"day":{"displayName":"日","relative":{"0":"今天","1":"明天","2":"后天","-2":"前天","-1":"昨天"},"relativeTime":{"future":{"other":"{0}天后"},"past":{"other":"{0}天前"}}},"day-short":{"displayName":"日","relative":{"0":"今天","1":"明天","2":"后天","-2":"前天","-1":"昨天"},"relativeTime":{"future":{"other":"{0}天后"},"past":{"other":"{0}天前"}}},"hour":{"displayName":"小时","relative":{"0":"这一时间 \u002F 此时"},"relativeTime":{"future":{"other":"{0}小时后"},"past":{"other":"{0}小时前"}}},"hour-short":{"displayName":"小时","relative":{"0":"这一时间 \u002F 此时"},"relativeTime":{"future":{"other":"{0}小时后"},"past":{"other":"{0}小时前"}}},"minute":{"displayName":"分钟","relative":{"0":"此刻"},"relativeTime":{"future":{"other":"{0}分钟后"},"past":{"other":"{0}分钟前"}}},"minute-short":{"displayName":"分","relative":{"0":"此刻"},"relativeTime":{"future":{"other":"{0}分钟后"},"past":{"other":"{0}分钟前"}}},"second":{"displayName":"秒","relative":{"0":"现在"},"relativeTime":{"future":{"other":"{0}秒后"},"past":{"other":"{0}秒前"}}},"second-short":{"displayName":"秒","relative":{"0":"现在"},"relativeTime":{"future":{"other":"{0}秒后"},"past":{"other":"{0}秒前"}}}}},{"locale":"zh-Hans-MO","parentLocale":"zh-Hans","fields":{"year":{"displayName":"年","relative":{"0":"今年","1":"明年","-1":"去年"},"relativeTime":{"future":{"other":"{0}年后"},"past":{"other":"{0}年前"}}},"year-short":{"displayName":"年","relative":{"0":"今年","1":"明年","-1":"去年"},"relativeTime":{"future":{"other":"{0}年后"},"past":{"other":"{0}年前"}}},"month":{"displayName":"月","relative":{"0":"本月","1":"下个月","-1":"上个月"},"relativeTime":{"future":{"other":"{0}个月后"},"past":{"other":"{0}个月前"}}},"month-short":{"displayName":"月","relative":{"0":"本月","1":"下个月","-1":"上个月"},"relativeTime":{"future":{"other":"{0}个月后"},"past":{"other":"{0}个月前"}}},"week":{"displayName":"周","relativePeriod":"{0}这周","relative":{"0":"本周","1":"下周","-1":"上周"},"relativeTime":{"future":{"other":"{0}周后"},"past":{"other":"{0}周前"}}},"week-short":{"displayName":"周","relativePeriod":"{0}这周","relative":{"0":"本周","1":"下周","-1":"上周"},"relativeTime":{"future":{"other":"{0}周后"},"past":{"other":"{0}周前"}}},"day":{"displayName":"日","relative":{"0":"今天","1":"明天","2":"后天","-2":"前天","-1":"昨天"},"relativeTime":{"future":{"other":"{0}天后"},"past":{"other":"{0}天前"}}},"day-short":{"displayName":"日","relative":{"0":"今天","1":"明天","2":"后天","-2":"前天","-1":"昨天"},"relativeTime":{"future":{"other":"{0}天后"},"past":{"other":"{0}天前"}}},"hour":{"displayName":"小时","relative":{"0":"这一时间 \u002F 此时"},"relativeTime":{"future":{"other":"{0}小时后"},"past":{"other":"{0}小时前"}}},"hour-short":{"displayName":"小时","relative":{"0":"这一时间 \u002F 此时"},"relativeTime":{"future":{"other":"{0}小时后"},"past":{"other":"{0}小时前"}}},"minute":{"displayName":"分钟","relative":{"0":"此刻"},"relativeTime":{"future":{"other":"{0}分钟后"},"past":{"other":"{0}分钟前"}}},"minute-short":{"displayName":"分","relative":{"0":"此刻"},"relativeTime":{"future":{"other":"{0}分钟后"},"past":{"other":"{0}分钟前"}}},"second":{"displayName":"秒","relative":{"0":"现在"},"relativeTime":{"future":{"other":"{0}秒后"},"past":{"other":"{0}秒前"}}},"second-short":{"displayName":"秒","relative":{"0":"现在"},"relativeTime":{"future":{"other":"{0}秒后"},"past":{"other":"{0}秒前"}}}}},{"locale":"zh-Hans-SG","parentLocale":"zh-Hans","fields":{"year":{"displayName":"年","relative":{"0":"今年","1":"明年","-1":"去年"},"relativeTime":{"future":{"other":"{0}年后"},"past":{"other":"{0}年前"}}},"year-short":{"displayName":"年","relative":{"0":"今年","1":"明年","-1":"去年"},"relativeTime":{"future":{"other":"{0}年后"},"past":{"other":"{0}年前"}}},"month":{"displayName":"月","relative":{"0":"本月","1":"下个月","-1":"上个月"},"relativeTime":{"future":{"other":"{0}个月后"},"past":{"other":"{0}个月前"}}},"month-short":{"displayName":"月","relative":{"0":"本月","1":"下个月","-1":"上个月"},"relativeTime":{"future":{"other":"{0}个月后"},"past":{"other":"{0}个月前"}}},"week":{"displayName":"周","relativePeriod":"{0}这周","relative":{"0":"本周","1":"下周","-1":"上周"},"relativeTime":{"future":{"other":"{0}周后"},"past":{"other":"{0}周前"}}},"week-short":{"displayName":"周","relativePeriod":"{0}这周","relative":{"0":"本周","1":"下周","-1":"上周"},"relativeTime":{"future":{"other":"{0}周后"},"past":{"other":"{0}周前"}}},"day":{"displayName":"日","relative":{"0":"今天","1":"明天","2":"后天","-2":"前天","-1":"昨天"},"relativeTime":{"future":{"other":"{0}天后"},"past":{"other":"{0}天前"}}},"day-short":{"displayName":"日","relative":{"0":"今天","1":"明天","2":"后天","-2":"前天","-1":"昨天"},"relativeTime":{"future":{"other":"{0}天后"},"past":{"other":"{0}天前"}}},"hour":{"displayName":"小时","relative":{"0":"这一时间 \u002F 此时"},"relativeTime":{"future":{"other":"{0}小时后"},"past":{"other":"{0}小时前"}}},"hour-short":{"displayName":"小时","relative":{"0":"这一时间 \u002F 此时"},"relativeTime":{"future":{"other":"{0}小时后"},"past":{"other":"{0}小时前"}}},"minute":{"displayName":"分钟","relative":{"0":"此刻"},"relativeTime":{"future":{"other":"{0}分钟后"},"past":{"other":"{0}分钟前"}}},"minute-short":{"displayName":"分","relative":{"0":"此刻"},"relativeTime":{"future":{"other":"{0}分钟后"},"past":{"other":"{0}分钟前"}}},"second":{"displayName":"秒","relative":{"0":"现在"},"relativeTime":{"future":{"other":"{0}秒后"},"past":{"other":"{0}秒前"}}},"second-short":{"displayName":"秒","relative":{"0":"现在"},"relativeTime":{"future":{"other":"{0}秒后"},"past":{"other":"{0}秒前"}}}}},{"locale":"zh-Hant","pluralRuleFunction":function(n
    ) {
      return 'other';
    },"fields":{"year":{"displayName":"年","relative":{"0":"今年","1":"明年","-1":"去年"},"relativeTime":{"future":{"other":"{0} 年後"},"past":{"other":"{0} 年前"}}},"year-short":{"displayName":"年","relative":{"0":"今年","1":"明年","-1":"去年"},"relativeTime":{"future":{"other":"{0} 年後"},"past":{"other":"{0} 年前"}}},"month":{"displayName":"月","relative":{"0":"本月","1":"下個月","-1":"上個月"},"relativeTime":{"future":{"other":"{0} 個月後"},"past":{"other":"{0} 個月前"}}},"month-short":{"displayName":"月","relative":{"0":"本月","1":"下個月","-1":"上個月"},"relativeTime":{"future":{"other":"{0} 個月後"},"past":{"other":"{0} 個月前"}}},"week":{"displayName":"週","relativePeriod":"{0} 當週","relative":{"0":"本週","1":"下週","-1":"上週"},"relativeTime":{"future":{"other":"{0} 週後"},"past":{"other":"{0} 週前"}}},"week-short":{"displayName":"週","relativePeriod":"{0} 當週","relative":{"0":"本週","1":"下週","-1":"上週"},"relativeTime":{"future":{"other":"{0} 週後"},"past":{"other":"{0} 週前"}}},"day":{"displayName":"日","relative":{"0":"今天","1":"明天","2":"後天","-2":"前天","-1":"昨天"},"relativeTime":{"future":{"other":"{0} 天後"},"past":{"other":"{0} 天前"}}},"day-short":{"displayName":"日","relative":{"0":"今天","1":"明天","2":"後天","-2":"前天","-1":"昨天"},"relativeTime":{"future":{"other":"{0} 天後"},"past":{"other":"{0} 天前"}}},"hour":{"displayName":"小時","relative":{"0":"這一小時"},"relativeTime":{"future":{"other":"{0} 小時後"},"past":{"other":"{0} 小時前"}}},"hour-short":{"displayName":"小時","relative":{"0":"這一小時"},"relativeTime":{"future":{"other":"{0} 小時後"},"past":{"other":"{0} 小時前"}}},"minute":{"displayName":"分鐘","relative":{"0":"這一分鐘"},"relativeTime":{"future":{"other":"{0} 分鐘後"},"past":{"other":"{0} 分鐘前"}}},"minute-short":{"displayName":"分鐘","relative":{"0":"這一分鐘"},"relativeTime":{"future":{"other":"{0} 分鐘後"},"past":{"other":"{0} 分鐘前"}}},"second":{"displayName":"秒","relative":{"0":"現在"},"relativeTime":{"future":{"other":"{0} 秒後"},"past":{"other":"{0} 秒前"}}},"second-short":{"displayName":"秒","relative":{"0":"現在"},"relativeTime":{"future":{"other":"{0} 秒後"},"past":{"other":"{0} 秒前"}}}}},{"locale":"zh-Hant-HK","parentLocale":"zh-Hant","fields":{"year":{"displayName":"年","relative":{"0":"今年","1":"下年","-1":"上年"},"relativeTime":{"future":{"other":"{0} 年後"},"past":{"other":"{0} 年前"}}},"year-short":{"displayName":"年","relative":{"0":"今年","1":"下年","-1":"上年"},"relativeTime":{"future":{"other":"{0} 年後"},"past":{"other":"{0} 年前"}}},"month":{"displayName":"月","relative":{"0":"本月","1":"下個月","-1":"上個月"},"relativeTime":{"future":{"other":"{0} 個月後"},"past":{"other":"{0} 個月前"}}},"month-short":{"displayName":"月","relative":{"0":"本月","1":"下個月","-1":"上個月"},"relativeTime":{"future":{"other":"{0} 個月後"},"past":{"other":"{0} 個月前"}}},"week":{"displayName":"星期","relativePeriod":"{0} 當週","relative":{"0":"本星期","1":"下星期","-1":"上星期"},"relativeTime":{"future":{"other":"{0} 星期後"},"past":{"other":"{0} 星期前"}}},"week-short":{"displayName":"星期","relativePeriod":"{0} 當週","relative":{"0":"本星期","1":"下星期","-1":"上星期"},"relativeTime":{"future":{"other":"{0} 星期後"},"past":{"other":"{0} 星期前"}}},"day":{"displayName":"日","relative":{"0":"今日","1":"明日","2":"後日","-2":"前日","-1":"昨日"},"relativeTime":{"future":{"other":"{0} 日後"},"past":{"other":"{0} 日前"}}},"day-short":{"displayName":"日","relative":{"0":"今日","1":"明日","2":"後日","-2":"前日","-1":"昨日"},"relativeTime":{"future":{"other":"{0} 日後"},"past":{"other":"{0} 日前"}}},"hour":{"displayName":"小時","relative":{"0":"這個小時"},"relativeTime":{"future":{"other":"{0} 小時後"},"past":{"other":"{0} 小時前"}}},"hour-short":{"displayName":"小時","relative":{"0":"這個小時"},"relativeTime":{"future":{"other":"{0} 小時後"},"past":{"other":"{0} 小時前"}}},"minute":{"displayName":"分鐘","relative":{"0":"這分鐘"},"relativeTime":{"future":{"other":"{0} 分鐘後"},"past":{"other":"{0} 分鐘前"}}},"minute-short":{"displayName":"分鐘","relative":{"0":"這分鐘"},"relativeTime":{"future":{"other":"{0} 分鐘後"},"past":{"other":"{0} 分鐘前"}}},"second":{"displayName":"秒","relative":{"0":"現在"},"relativeTime":{"future":{"other":"{0} 秒後"},"past":{"other":"{0} 秒前"}}},"second-short":{"displayName":"秒","relative":{"0":"現在"},"relativeTime":{"future":{"other":"{0} 秒後"},"past":{"other":"{0} 秒前"}}}}},{"locale":"zh-Hant-MO","parentLocale":"zh-Hant-HK"},
    {"locale":"zu","pluralRuleFunction":function(n, ord
    ) {
      if (ord) return 'other';
      return (n >= 0 && n <= 1) ? 'one' : 'other';
    },"fields":{"year":{"displayName":"Unyaka","relative":{"0":"kulo nyaka","1":"unyaka ozayo","-1":"onyakeni odlule"},"relativeTime":{"future":{"one":"onyakeni ongu-{0} ozayo","other":"eminyakeni engu-{0} ezayo"},"past":{"one":"{0} unyaka odlule","other":"{0} iminyaka edlule"}}},"year-short":{"displayName":"Unyaka","relative":{"0":"kulo nyaka","1":"unyaka ozayo","-1":"onyakeni odlule"},"relativeTime":{"future":{"one":"onyakeni ongu-{0} ozayo","other":"eminyakeni engu-{0} ezayo"},"past":{"one":"{0} unyaka odlule","other":"{0} unyaka odlule"}}},"month":{"displayName":"Inyanga","relative":{"0":"le nyanga","1":"inyanga ezayo","-1":"inyanga edlule"},"relativeTime":{"future":{"one":"enyangeni engu-{0}","other":"ezinyangeni ezingu-{0} ezizayo"},"past":{"one":"{0} inyanga edlule","other":"{0} izinyanga ezedlule"}}},"month-short":{"displayName":"Inyanga","relative":{"0":"le nyanga","1":"inyanga ezayo","-1":"inyanga edlule"},"relativeTime":{"future":{"one":"ezinyangeni ezingu-{0} ezizayo","other":"ezinyangeni ezingu-{0} ezizayo"},"past":{"one":"{0} izinyanga ezedlule","other":"{0} izinyanga ezedlule"}}},"week":{"displayName":"Iviki","relativePeriod":"evikini le-{0}","relative":{"0":"leli viki","1":"iviki elizayo","-1":"iviki eledlule"},"relativeTime":{"future":{"one":"evikini elingu-{0}","other":"emavikini angu-{0}"},"past":{"one":"evikini elingu-{0} eledlule","other":"amaviki angu-{0} edlule"}}},"week-short":{"displayName":"Iviki","relativePeriod":"evikini le-{0}","relative":{"0":"leli viki","1":"iviki elizayo","-1":"iviki eledlule"},"relativeTime":{"future":{"one":"evikini elingu-{0} elizayo","other":"emavikini angu-{0} ezayo"},"past":{"one":"amaviki angu-{0} edlule","other":"amaviki angu-{0} edlule"}}},"day":{"displayName":"Usuku","relative":{"0":"namhlanje","1":"kusasa","2":"usuku olulandela olwakusasa","-2":"usuku olwandulela olwayizolo","-1":"izolo"},"relativeTime":{"future":{"one":"osukwini olungu-{0} oluzayo","other":"ezinsukwini ezingu-{0} ezizayo"},"past":{"one":"osukwini olungu-{0} olwedlule","other":"ezinsukwini ezingu-{0} ezedlule."}}},"day-short":{"displayName":"Usuku","relative":{"0":"namhlanje","1":"kusasa","2":"usuku olulandela olwakusasa","-2":"usuku olwandulela olwayizolo","-1":"izolo"},"relativeTime":{"future":{"one":"osukwini olungu-{0} oluzayo","other":"ezinsukwini ezingu-{0} ezizayo"},"past":{"one":"{0} usuku olwedlule","other":"{0} izinsuku ezedlule"}}},"hour":{"displayName":"Ihora","relative":{"0":"leli hora"},"relativeTime":{"future":{"one":"ehoreni elingu-{0} elizayo","other":"emahoreni angu-{0} ezayo"},"past":{"one":"{0} ihora eledlule","other":"emahoreni angu-{0} edlule"}}},"hour-short":{"displayName":"Ihora","relative":{"0":"leli hora"},"relativeTime":{"future":{"one":"ehoreni elingu-{0} elizayo","other":"emahoreni angu-{0} ezayo"},"past":{"one":"{0} ihora eledlule","other":"emahoreni angu-{0} edlule"}}},"minute":{"displayName":"Iminithi","relative":{"0":"leli minithi"},"relativeTime":{"future":{"one":"kuminithi elingu-{0} elizayo","other":"kumaminithi angu-{0} ezayo"},"past":{"one":"{0} iminithi eledlule","other":"{0} amaminithi edlule"}}},"minute-short":{"displayName":"Iminithi","relative":{"0":"leli minithi"},"relativeTime":{"future":{"one":"kuminithi elingu-{0} elizayo","other":"kumaminithi angu-{0} ezayo"},"past":{"one":"{0} iminithi eledlule","other":"{0} amaminithi edlule"}}},"second":{"displayName":"Isekhondi","relative":{"0":"manje"},"relativeTime":{"future":{"one":"kusekhondi elingu-{0} elizayo","other":"kumasekhondi angu-{0} ezayo"},"past":{"one":"{0} isekhondi eledlule","other":"{0} amasekhondi edlule"}}},"second-short":{"displayName":"Isekhondi","relative":{"0":"manje"},"relativeTime":{"future":{"one":"kusekhondi elingu-{0} elizayo","other":"kumasekhondi angu-{0} ezayo"},"past":{"one":"{0} isekhondi eledlule","other":"{0} amasekhondi edlule"}}}}});

    return RelativeFormat;

}));
//# sourceMappingURL=intl-relativeformat-with-locales.js.map
