// import { Random } from 'mockjs';
import { random } from 'lodash';

const NAMES = [
  '冯芳',
  '徐勇',
  '余刚',
  '尹静',
  '廖静',
  '吕勇',
  '周敏',
  '胡杰',
  '胡秀英',
  '曾霞',
  '于芳',
  '谢敏',
  '董刚',
  '孟杰',
  '廖娟',
  '田刚',
  '程刚',
  '夏涛',
  '彭娜',
  '石丽',
  '郭娜',
  '蔡娜',
  '程娟',
  '陈伟',
  '锺刚',
  '赖勇',
  '蒋伟',
  '郑勇',
  '侯勇',
  '梁娟',
  '戴涛',
  '戴艳',
  '杜洋',
  '康霞',
  '熊芳',
  '汤丽',
  '贺娜',
  '史磊',
  '曹勇',
  '叶磊',
  '孔磊',
  '胡勇',
  '锺勇',
  '曾伟',
  '徐涛',
  '赖艳',
  '何静',
  '吴涛',
  '龚霞',
  '张秀兰',
  '龚秀英',
  '许洋',
  '邱艳',
  '郝明',
  '崔芳',
  '王平',
  '万洋',
  '任敏',
  '姚敏',
  '郭艳',
  '郝丽',
  '郝涛',
  '丁平',
  '戴丽',
  '白军',
  '邵秀英',
  '段磊',
  '冯涛',
  '苏磊',
  '宋敏',
  '罗秀英',
  '赖娜',
  '邓超',
  '袁艳',
  '周娜',
  '邱艳',
  '常洋',
  '李秀兰',
  '雷超',
  '陈静',
  '刘丽',
  '程丽',
  '文杰',
  '邓军',
  '高平',
  '熊洋',
  '毛平',
  '吴秀英',
  '周敏',
  '汤丽',
  '侯超',
  '潘涛',
  '易娜',
  '范娟',
  '崔军',
  '戴强',
  '胡刚',
  '张娜',
  '潘勇',
  '常敏',
];
const TEXTS = [
  '青况果际等面青员',
  '发去精提由音山十志',
  '和放该第极确那会等装任体或少难圆住',
  '统种其再解老通场圆',
  '身组风报分要',
  '然都建安起认们装济九位产',
  '民的相西面知离东性很权事',
  '教将主特四联交委交重我他着叫较出正量种',
  '工真分离料三六门不然世往况进将委许',
  '流二我改后发',
  '的体家去社法手道严运过看话上',
  '个生何对领采',
  '还半直力老人便复立那应至们于价其三称调',
  '易深江斯须美每养构造组度素何图公几',
  '被我美斯整器务即',
  '区至按布口快县速去',
  '解务规支或查省容省格比已油活回南',
  '维理治史七严起听对识或至志同必社加持',
  '老局研听我群一易观按量',
  '张此许界立就习马素军清水油',
  '合算几林己如度术化花史走工',
  '元水活社必参可场热为军此党才命从',
  '权却农万号天北思表',
  '土物年质法说除先效委即电断点',
  '识非利为种下解和很北百运',
  '交酸设满进位小',
  '多接步规以放六数代志你',
  '程直次类及点很精月',
  '五号步一制战发',
  '自整状般周精各习多把斯我民亲速金',
  '酸五县认标么快非相和',
  '研面区光北用非影变解角该合火提片路意群边',
  '活外算关见次很相见完下色结林解系斗长构',
  '列效车族平往确治斗派阶心习流样它府温线织',
  '派农海数水应其已可月状别最片',
  '真根次决力活',
  '受石性资群快组',
  '什立值发好度那气形区圆万对响年',
  '上们林克划京造标后生张无办就第体以',
  '切万经委采八划划运政认和方八入近什自相',
  '始行参市别',
  '精备下为光也边受周八报六向养矿龙切',
  '主主作般各列他林九党酸',
  '王办影直议',
  '眼大意段实长干石就南清论集前分参果',
  '业那车为直看斯采',
  '最管克度化命确音劳矿它手将',
  '连格又提无程文流选军四么',
  '易队住确事空相九六机物会派从今',
  '过支见须在教你果与件改全断八信部听代',
  '别而备采放实保非并道部品组证干',
  '被被向万元要有展次还山',
  '单器但之进出',
  '青认有走把准月用把员得维眼规',
  '任认料论传内看先流取次领资件又',
  '立议约己土角证个',
  '照因名文时究际加气很说系之求先权千',
  '接值目七计我近同长内青切性气识',
  '千商见知率新手油改克此被级共变新变',
  '品压己划听林再形酸它局约四',
  '才适这世化件这问山活今斯消联议',
  '米系分业据放专明然龙即表放情加会北',
  '人斯运住军派带路对指达各样验件质们',
  '方说业间等决同',
  '行油权造我我已带书石们各参三理回',
  '思群火家需海西',
  '业资道现头能报',
  '直外约集已问资和时织打备下各际等我族会热',
  '程加现每少白例再什就千龙构',
  '美办今断前参查龙决开划林己济感到难',
  '下你命联构但特型明世北身',
  '须名话律矿示通列时学',
  '消及把军老放但装龙及红回里件研',
  '议交地公称局出院二那中次下选',
  '习员并象作务以书局给般族至里消',
  '京却族院社持',
  '矿声二济则',
  '位打儿权候调度成干实规指入放带点六眼很示',
  '划接办根产提到器采东最',
  '派口王出干',
  '号名存它二片教际',
  '声石适开候四性北',
  '养此飞支各元',
  '十明火员拉',
  '建地矿龙影角建组部圆商局始断示速三',
  '水力制往展外直北',
  '定候深近市红书意类群据共没布',
  '千今放千月命心',
  '太满京学个海关',
  '中义具日七信明火',
  '想花百龙指种调则计位计是构打然布省花养太',
  '打安权况半务重儿权量速',
  '开能片都机温深值斗称达角酸精再按度记',
  '按生常元情工成运等家知断流论',
  '史小阶许事平见育期',
  '记决指求角收在式',
  '极受水儿原实由提器飞格心深口前件',
  '华增小上术界却十回务品周习广分严公',
  '花养统做手拉教积技',
  '声没型利人走法连发决议度指划共或金料指压',
];

export function getName(count = 5) {
  const realCounter = count > 100 ? 100 : count;
  return NAMES.slice(0, realCounter);
  // return new Array(realCounter).fill(0).map(() => {
  //   return Random.cname(min, max);
  // });
}

export function getText(count = 5, min: number = 5, max = 20) {
  const realCounter = count > 100 ? 100 : count;
  return TEXTS.slice(0, count);
  // return new Array(realCounter).fill(0).map(() => {
  //   return Random.ctitle(min, max);
  // });
}

export function getDate(count = 10) {
  const realCounter = count > 100 ? 100 : count;
  let month: string | number = new Date().getMonth() + 1;
  month = month < 10 ? `0${month}` : month;
  return new Array(realCounter).fill(0).map((_, index) => {
    const dateIndex = index + 1;
    const date = dateIndex < 10 ? `0${dateIndex}` : dateIndex;
    return `${month}-${date}`;
  });
}

export function getNumberValue(count = 10, min = 0, max = 200) {
  return new Array(count).fill(0).map((_) => {
    return random(min, max, false);
  });
}

export function getSeries(count = 2) {
  return new Array(count).fill(0).map((_, index) => {
    return `系列${index + 1}`;
  });
}
