const IMAGE_FALLBACK =
  'data:image/png;base64,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';

const MAX_LAYER_WIDTH = 500;

const MIN_LAYER_WIDTH = 250;

const GUIDE_LINE_PADDING = 2;

// 组件可被缩小的最小尺寸
const MIN_COMPONENT_WIDTH = 20;
const MIN_COMPONENT_HEIGHT = 20;

// iframe组件页面接收数据通知的示例代码
const IFRAME_COMPONENT_ON_MESSAGE_CODE_EXAMPLE = `
  function onMessage(e) {
    const { data, origin } = e 
    const parseData = JSON.parse(data)
    const {  
      // 唯一标识id
      id,
      // 操作类型
      // INIT_RELATION_PARAMS 初始化 关联属性
      // RELATION_PARAMS_CHANGE 关联属性 发生改变
      // POST_PARAMS 传递所有params
      actionType,
      // 实际返回的数据
      value
    } = parseData
    console.log('新改变的数据：' + parseData)
    console.log('发送数据的页面：' + origin)
  }
  window.addEventListener('message', onMessage)
`;
// iframe组件页面发送数据改变通知的示例代码
const IFRAME_COMPONENT_POST_MESSAGE_CODE_EXAMPLE = `
  function postMessage() {
    const sendValue = {
      custom_field: '需要发送的数据',
      id: '来自上层页面传递下来的id，在onmessage事件中可以获取到，比如上面的actionType==INIT_RELATION_PARAMS',
      // 操作类型，如果格式不对可能会被忽略
      // GET_PARAMS 获取大屏指定的 全局 params
      // RELATION_PARAMS_CHANGE 在ifrmae中修改大屏的属性时
      actionType: 'RELATION_PARAMS_CHANGE'
    }
    // 接收数据的目标页面域名
    const domain = 'http://www.example.com'
    if(window.parent) window.parent.postMessage(JSON.stringify(sendValue), domain)
  }
`;

// selecto 公共className
const SELECTO_CLASSNAME = 'react-select-to-prefix';

// 懒更新api请求的标识
const API_CONTAIN_PARAMS_LAZY_REQUEST_URL_FLAG = '(LAZY_REQUEST_FLAG)';
// 按钮标识强制更新的标识
const API_CONTAIN_PARAMS_IMMEDIATELY_REQUEST_URL_FLAG =
  'IMMEDIATELY_REQUEST_FLAG';

// 键盘操作快捷键
const KEY_PRESS_MAP = {
  'Ctrl + Q': '打开调试面板',
  'Ctrl + T': '打开日志面板',
  'Ctrl + C': '复制',
  'Ctrl + V': '粘贴',
  'Ctrl + Z': '撤销',
  'Ctrl + Y': '重做',
  Backspace: '删除',
  'Shift + ↑': '上移动',
  'Shift + ↓': '下移动',
  'Shift + ←': '左移动',
  'Shift + →': '右移动',
};

export {
  IMAGE_FALLBACK,
  MIN_LAYER_WIDTH,
  MAX_LAYER_WIDTH,
  GUIDE_LINE_PADDING,
  MIN_COMPONENT_WIDTH,
  MIN_COMPONENT_HEIGHT,
  IFRAME_COMPONENT_ON_MESSAGE_CODE_EXAMPLE,
  IFRAME_COMPONENT_POST_MESSAGE_CODE_EXAMPLE,
  SELECTO_CLASSNAME,
  API_CONTAIN_PARAMS_LAZY_REQUEST_URL_FLAG,
  API_CONTAIN_PARAMS_IMMEDIATELY_REQUEST_URL_FLAG,
  KEY_PRESS_MAP,
};
