import { CSSProperties, useMemo } from 'react';
import { shuffle } from 'lodash';

const COMMON_STYLE = {
  strokeWidth: 4,
  file: 'none',
};

const COLOR_LIST = [
  '#4ea397',
  '#22c3aa',
  '#7bd9a5',
  '#d0648a',
  '#f58db2',
  '#f2b3c9',
];

const LinearGradient = ({ id }: { id: string }) => {
  const colorList = useMemo(() => {
    const counter = COLOR_LIST.length;
    return shuffle(COLOR_LIST).map((item, index) => {
      let offset = 0;
      if (index === 0) {
        offset = 0;
      } else if (index === counter - 1) {
        offset = 100;
      } else {
        offset = Math.floor(100 / (counter - 1)) * index;
      }

      return <stop key={item} offset={`${offset}%`} stopColor={item} />;
    });
  }, []);

  return (
    <defs>
      <linearGradient id={id} x1="0%" y1="0%" x2="0%" y2="100%">
        {colorList}
      </linearGradient>
    </defs>
  );
};

export const AreaChart = ({ style }: { style?: CSSProperties }) => {
  return (
    <svg
      id="area-chart"
      style={style}
      xmlns="http://www.w3.org/2000/svg"
      className="icon"
      width="200px"
      height="200.00px"
      viewBox="0 0 1024 1024"
      version="1.1"
    >
      <LinearGradient id="area-chart-linear" />
      <path
        {...COMMON_STYLE}
        stroke="url(#area-chart-linear)"
        d="M888 792H200V168c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v688c0 4.4 3.6 8 8 8h752c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM272 728h536c4.4 0 8-3.6 8-8V284c0-7.2-8.7-10.7-13.7-5.7L592 488.6l-125.4-124c-3.1-3.1-8.2-3.1-11.3 0l-189 189.6c-1.5 1.5-2.3 3.5-2.3 5.6V720c0 4.4 3.6 8 8 8z"
      />
    </svg>
  );
};

export const BarChart = ({ style }: { style?: CSSProperties }) => {
  return (
    <svg
      id="bar-chart"
      style={style}
      xmlns="http://www.w3.org/2000/svg"
      className="icon"
      width="200px"
      height="200.00px"
      viewBox="0 0 1024 1024"
      version="1.1"
    >
      <LinearGradient id="bar-chart-linear" />
      <path
        {...COMMON_STYLE}
        stroke="url(#bar-chart-linear)"
        d="M888 792H200V168c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v688c0 4.4 3.6 8 8 8h752c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM288 712h56c4.4 0 8-3.6 8-8V560c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v144c0 4.4 3.6 8 8 8zM440 712h56c4.4 0 8-3.6 8-8V384c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v320c0 4.4 3.6 8 8 8zM592 712h56c4.4 0 8-3.6 8-8V462c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v242c0 4.4 3.6 8 8 8zM744 712h56c4.4 0 8-3.6 8-8V304c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v400c0 4.4 3.6 8 8 8z"
      />
    </svg>
  );
};

export const DotChart = ({ style }: { style?: CSSProperties }) => {
  return (
    <svg
      id="dot-chart"
      style={style}
      xmlns="http://www.w3.org/2000/svg"
      className="icon"
      width="200px"
      height="200.00px"
      viewBox="0 0 1024 1024"
      version="1.1"
    >
      <LinearGradient id="dot-chart-linear" />
      <path
        {...COMMON_STYLE}
        stroke="url(#dot-chart-linear)"
        d="M941.714286 832H155.428571V118.857143c0-5.028571-4.114286-9.142857-9.142857-9.142857h-64c-5.028571 0-9.142857 4.114286-9.142857 9.142857v786.285714c0 5.028571 4.114286 9.142857 9.142857 9.142857h859.428572c5.028571 0 9.142857-4.114286 9.142857-9.142857v-64c0-5.028571-4.114286-9.142857-9.142857-9.142857zM256 617.142857a73.142857 73.142857 0 1 0 146.285714 0 73.142857 73.142857 0 1 0-146.285714 0z m134.857143-256a54.857143 54.857143 0 1 0 109.714286 0 54.857143 54.857143 0 1 0-109.714286 0z m180.571428 260.571429a109.714286 109.714286 0 1 0 219.428572 0 109.714286 109.714286 0 1 0-219.428572 0z m169.142858-358.857143a64 64 0 1 0 128 0 64 64 0 1 0-128 0z"
      />
    </svg>
  );
};

export const ImageChart = ({ style }: { style?: CSSProperties }) => {
  return (
    <svg
      id="image-chart"
      style={style}
      xmlns="http://www.w3.org/2000/svg"
      className="icon"
      width="200px"
      height="200.00px"
      viewBox="0 0 1024 1024"
      version="1.1"
    >
      <LinearGradient id="image-chart-linear" />
      <path
        {...COMMON_STYLE}
        stroke="url(#image-chart-linear)"
        d="M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32z m-40 632H136v-39.9l138.5-164.3 150.1 178L658.1 489 888 761.6V792z m0-129.8L664.2 396.8c-3.2-3.8-9-3.8-12.2 0L424.6 666.4l-144-170.7c-3.2-3.8-9-3.8-12.2 0L136 652.7V232h752v430.2zM304 456c48.6 0 88-39.4 88-88s-39.4-88-88-88-88 39.4-88 88 39.4 88 88 88z m0-116c15.5 0 28 12.5 28 28s-12.5 28-28 28-28-12.5-28-28 12.5-28 28-28z"
      />
    </svg>
  );
};

export const LineChart = ({ style }: { style?: CSSProperties }) => {
  return (
    <svg
      id="line-chart"
      style={style}
      xmlns="http://www.w3.org/2000/svg"
      className="icon"
      width="200px"
      height="200.00px"
      viewBox="0 0 1024 1024"
      version="1.1"
    >
      <LinearGradient id="line-chart-linear" />
      <path
        {...COMMON_STYLE}
        stroke="url(#line-chart-linear)"
        d="M888 792H200V168c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v688c0 4.4 3.6 8 8 8h752c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM305.8 637.7c3.1 3.1 8.1 3.1 11.3 0l138.3-137.6L583 628.5c3.1 3.1 8.2 3.1 11.3 0l275.4-275.3c3.1-3.1 3.1-8.2 0-11.3l-39.6-39.6c-3.1-3.1-8.2-3.1-11.3 0l-230 229.9L461.4 404c-3.1-3.1-8.2-3.1-11.3 0L266.3 586.7c-3.1 3.1-3.1 8.2 0 11.3l39.5 39.7z"
      />
    </svg>
  );
};

export const ListChart = ({ style }: { style?: CSSProperties }) => {
  return (
    <svg
      id="list-chart"
      style={style}
      xmlns="http://www.w3.org/2000/svg"
      className="icon"
      width="200px"
      height="200.00px"
      viewBox="0 0 1024 1024"
      version="1.1"
    >
      <LinearGradient id="list-chart-linear" />
      <path
        {...COMMON_STYLE}
        stroke="url(#list-chart-linear)"
        d="M998.4 819.2h-768a25.6 25.6 0 0 1 0-51.2h768a25.6 25.6 0 0 1 0 51.2zM998.4 563.2h-768a25.6 25.6 0 0 1 0-51.2h768a25.6 25.6 0 0 1 0 51.2zM998.4 307.2h-768a25.6 25.6 0 0 1 0-51.2h768a25.6 25.6 0 0 1 0 51.2zM76.8 358.4C34.4576 358.4 0 323.9424 0 281.6S34.4576 204.8 76.8 204.8 153.6 239.2576 153.6 281.6 119.1424 358.4 76.8 358.4z m0-102.4a25.6 25.6 0 1 0 0 51.2 25.6 25.6 0 0 0 0-51.2zM76.8 614.4C34.4576 614.4 0 579.9424 0 537.6S34.4576 460.8 76.8 460.8 153.6 495.2576 153.6 537.6 119.1424 614.4 76.8 614.4z m0-102.4a25.6 25.6 0 1 0 0 51.2 25.6 25.6 0 0 0 0-51.2zM76.8 870.4C34.4576 870.4 0 835.9424 0 793.6S34.4576 716.8 76.8 716.8s76.8 34.4576 76.8 76.8S119.1424 870.4 76.8 870.4z m0-102.4a25.6 25.6 0 1 0 0 51.2 25.6 25.6 0 0 0 0-51.2z"
      />
    </svg>
  );
};

export const MapChart = ({ style }: { style?: CSSProperties }) => {
  return (
    <svg
      id="map-chart"
      style={style}
      xmlns="http://www.w3.org/2000/svg"
      className="icon"
      width="200px"
      height="200.00px"
      viewBox="0 0 1024 1024"
      version="1.1"
    >
      <LinearGradient id="map-chart-linear" />
      <path
        {...COMMON_STYLE}
        stroke="url(#map-chart-linear)"
        d="M500.824985 433.376315c0.059352-0.122797 0.11768-0.181125 0.177032-0.239454-0.177032-0.950651-0.353041-1.661849-0.411369-2.196015C500.708328 431.714466 500.765633 432.54232 500.824985 433.376315L500.824985 433.376315zM671.759075 619.9762 671.759075 619.9762c0 0-0.118704 0-0.118704-0.064468C671.640372 619.9762 671.699724 619.9762 671.759075 619.9762L671.759075 619.9762zM676.151106 620.568694c-1.068332-0.181125-3.441379 0.11768-4.332678-0.592494C671.223886 621.990067 672.052764 622.76471 676.151106 620.568694L676.151106 620.568694zM509.610068 63.792908c-245.825778 0-445.127963 199.243857-445.127963 445.13615 0 245.89127 199.302185 445.135126 445.127963 445.135126 245.892293 0 445.13615-199.243857 445.13615-445.135126C954.746218 263.035742 755.502361 63.792908 509.610068 63.792908L509.610068 63.792908zM793.900903 237.69254c-15.309684 0.474814-25.990954 0.474814-38.340213 8.961092-4.926196 3.445472-8.368598 8.014534-14.59951 9.735735-5.695722 1.544169-11.750625 0.176009-17.392112 2.136663-20.23588 6.824429-16.97051 50.208519-43.61945 43.560098-12.524245-3.02387-21.310352-17.862833-27.65792-27.476795-5.580089-8.5487-15.672958-15.549138-8.785084-26.177196-3.146667 0.832971-6.411013-0.11768-9.496282 0.474814 4.211928-9.376555 18.575054-8.602935 20.954241-13.353123 5.990434-11.985986-16.266475-13.294794-22.615067-14.95562 7.594979-8.129144 11.393491 2.788509 18.932188 0.950651 7.182586-1.779529-3.797489-11.216459-8.132214-12.344143-1.544169-0.415462-26.941606 7.000438-12.283768-6.175653-18.105357-11.510148-36.20355-23.144116-54.366212-34.717709-3.088338 12.877285 24.094768 20.177552 32.996508 24.746614-1.363044 5.342682-9.612938 13.05841-15.962553 10.804067-5.992481-2.137687-3.562129-11.991102-12.524245-11.098779-6.41306 14.956643 13.5936 10.622942 15.432481 19.765159 2.078335 10.44591-7.597025 5.990434-11.278881 5.872754-0.88823-0.059352-7.833409-7.240915-8.187473-1.837858-0.475837 6.470365 11.099802 3.917216 11.870352 10.506285-13.473873 0.533143-20.301372-4.275373-31.159674-11.515265-12.760628-8.485255-19.290345-7.715729-34.898835-7.715729 4.686742-1.89721 11.157107-3.323699 15.0733-6.407943 2.196015-1.725294 10.740622-10.033517 11.275811-11.872399 2.436492-8.010441-0.11768-7.416923-7.77508-12.641925-6.824429-4.686742-15.0733-13.054317-23.323195-14.716166-29.910217-5.936199-9.261944 27.006074-31.924083 31.515784 0.353041 0.059352 0.828878 0.059352 1.12666 0.059352l-1.248434 0c0.058328 0 0.058328-0.059352 0.121773-0.059352-5.222955-0.059352-15.075347-1.36816-18.458397 1.363044-2.431376 1.902326-2.612501 9.794064-5.28026 12.641925-4.750187 5.0449-11.81407 6.053879-17.509792 9.735735-5.579065 3.499707-17.746176 12.69616-20.952194 18.932188-11.984962 22.849404 26.946722 29.971615 41.726334 36.617989 6.64842 3.085268 26.167986 7.182586 29.842679 12.285814 4.867868 6.765077-4.267187 13.118785 5.936199 17.863856 3.264347 1.543146 9.971096 1.842974 12.759605-1.245364 4.510734-5.161556-1.838881-6.230911-2.964518-12.226462-2.078335-11.397584 1.364067-6.882757 7.122211-11.098779 11.750625-8.667404 9.078773-9.142218 4.869914-22.970154-1.961678-6.349615-9.318226-24.213471-2.790556-28.962635 8.425903-6.17156 26.409486 3.38305 32.937157 4.15667 7.482415 0.946558 11.809977 11.392468 15.908318 15.667841 2.729158 2.789533 7.593955 8.78406 12.343119 8.190543 7.599072-1.068332 4.394077-7.656377 8.78713-10.744715 11.80793-8.128121 14.835893 2.910283 19.523659 14.010085 4.451382 10.44591 8.667404 14.240329 16.441461 21.010523 3.681856 3.14155 19.643386 14.182001 18.162662 21.068851-1.010003 4.569062-19.290345 11.574616-24.157189 13.113669-17.863856 5.700839-51.340295-9.255805-54.958706 19.053961 7.001461-2.553149 26.707268-18.637476 32.585139-11.039427 2.666736 3.499707-2.136663 8.544607-1.070378 11.927657 3.442402 10.328229 11.395538 6.705726 19.702738 5.107321-0.533143 0.353041-1.12666 0.651846-1.779529 0.946558 11.397584-5.873778 10.211573-4.628414 15.433504-14.182001 1.720178-3.14769 4.216022-10.628058 6.646374-12.818957 8.309246-7.599072 9.553587-2.378164 14.657838 3.559059 1.308809 1.484817 14.010085 19.765159 9.499351 18.872836-14.72026-3.024893-28.906353-2.612501-41.075511 5.460362-7.05672 4.627391-13.706163 10.981099-22.137183 14.06432-2.01489 0.715291-16.971533 2.196015-15.249309-0.353041 2.610454-3.740184 11.513218-6.236028 14.954597-10.211573-9.676383-3.975545-17.803481 4.808516-25.402553 9.971096-8.132214 3.799536-9.971096 10.981099-16.853853 17.21201-2.970658 2.729158-8.667404 3.206018-11.631922 6.769171-2.913353 3.499707-3.207042 8.901741-5.936199 12.283768-1.90335 2.314719-6.830569 0.946558-8.78713 4.39203-2.610454 4.569062 2.373047 8.843412 1.303692 12.108782-2.013867 5.932106-13.353123 10.975982-17.684778 15.250332 0.592494-0.593518 1.190105-1.128707 1.720178-1.720178-4.387937 4.627391-9.907651 8.010441-13.354146 13.353123 1.602498 7.479345 6.529717 25.343201 5.108345 29.437449-4.514827 13.535271-13.292748-7.299243-16.914228-12.760628-12.339026-18.576077-36.972053-6.17156-53.708226-4.570085-21.48636 1.961678-42.555212 29.853935-29.319769 52.52733 6.353708 10.858302 17.09433 15.074324 29.378098 12.583596 10.921747-2.319835 14.187117-17.569144 24.452925-17.868973 18.932188-0.473791 0.474814 18.580171-1.187035 25.584702-1.484817 6.407943 2.373047 7.000438 9.020444 8.662287 4.925173 1.186012 11.93175-2.137687 16.145725 0.710175 2.665713 1.725294 2.548032 11.45489 6.287193 8.371668-7.296173 6.049786-5.575995 20.354584 1.836835 25.520233 8.3072 5.756097 18.042935 0.475837 26.64587 2.608407 16.442484 4.157693 8.608052-1.245364 22.912849-9.911744 9.731642-5.815449 11.275811 1.130753 17.97949 1.130753 4.453429 0 7.363711-6.470365 14.899338-4.631484 6.112208 1.602498 8.5487 6.352685 15.848966 7.42204 3.024893 0.411369 6.17156-1.191128 8.961092-0.832971 13.5936 1.484817 23.917736 10.147104 34.662451 18.044982 8.78099 6.407943 14.598486 5.103228 24.928762 8.068769 7.534604 2.137687 21.36254 13.060457 20.710694 22.614044-0.11768 1.661849-6.705726 10.269901-7.833409 14.128789 1.89721 1.303692 15.313777-1.661849 19.166525-1.901303-1.245364 1.426489-10.382465 7.892761-10.382465 4.451382 0 1.721201 6.40692 5.343705 8.010441 6.412037 4.750187-15.431457 12.58462-5.519714 21.960151-1.661849 8.012488 3.264347 17.865903 3.441379 26.351158 5.461385 7.181563 1.721201 23.147186 6.647397 28.490891 12.520151 6.411013 7.122211 1.957585 18.637476-2.789533 25.819039-6.230911 9.259898-15.667841 12.818957-19.525706 23.740704-3.088338 8.662287-0.833995 17.32969-2.553149 26.942629-2.373047 13.000082-4.276397 8.490372-12.642948 16.32378-7.062859 6.647397-0.116657 5.519714-9.730619 9.794064-9.559727 4.210905-18.044982 3.024893-24.750707 13.588483 0.294712-0.710175 0.534166-1.303692 0.710175-2.020006-2.789533 3.921309-4.210905 11.991102-5.580089 14.603603-3.322675 6.706749-7.951089 11.039427-13.291724 16.618493-2.023076 2.137687-20.772093 27.717272-21.841447 25.697265-1.367137-2.671852-16.084327 2.670829-16.797571-1.187035 0.590448 3.207042-0.178055 2.137687 3.5038 3.917216-3.38305 21.010523-12.226462 24.157189-32.883945 24.393573 1.721201 10.092869-7.476275 8.073886-11.811 13.534248-2.493797 3.207042-3.738138 12.108782-5.460362 16.142655-1.066285 2.613524-9.078773 12.93766-9.078773 14.956643-0.057305 1.89721 2.667759 4.627391 5.221932 7.299243-14.541181 2.907213-29.320793 4.926196-44.452421 6.17156 2.847861-3.617387 3.560082-6.647397-5.460362-7.122211 2.373047-6.466272 8.068769-10.265808 10.444886-16.560164 1.128707-2.965541 0.178055-4.152577 1.187035-7.118118 3.264347-10.211573 1.838881-6.294356 0-14.245446-4.331655-18.579147 1.544169-23.683399 6.588045-40.717354 5.220908-17.505699 4.686742-40.179095 8.069793-58.992579 1.544169-9.024537 4.15667-27.7756 1.069355-36.264948-3.559059-9.613962-19.049868-17.153682-26.113751-23.559579-10.088776-9.143241-15.433504-19.054985-22.908756-30.447453-3.740184-5.760191-8.132214-11.339256-11.098779-17.628496-6.293333-13.412474 0-5.461385 1.127683-13.354146 1.010003-7.656377-0.950651-14.422478 2.078335-22.437012 3.384074-8.844435 11.69332-14.363126 14.422478-23.325241 2.489704-8.009418 0.653893-17.980513-7.538697-20.594037-4.569062-1.484817-9.55461 1.89721-14.128789 1.187035-6.346545-1.010003-13.524015-5.815449-18.566868-9.613962-7.005554-5.284353-9.613962-13.887288-17.034978-18.995633-6.17156-4.152577-10.622942-1.661849-17.270339-3.676739-7.005554-2.020006-11.274788-10.621918-16.917298-13.234419-8.367575-4.033873-13.054317 1.721201-22.01541 0.534166-7.53972-0.950651-19.054985-9.31925-26.055422-12.525268-14.364149-6.348592-23.088858-13.471826-28.849048-28.010961-4.922103-12.465916-12.044314-18.280342-20.476357-28.728298-8.544607-10.504238-11.216459-19.466354-24.329105-22.319331-1.602498-0.292666 3.142573 11.099802 3.676739 12.050454 4.691859 8.66638 11.749602 16.618493 17.393135 24.750707 8.426927 11.927657 4.862751 14.182001-3.681856 2.671852-9.736758-13.235442-21.010523-26.412556-29.438473-40.418548-3.204995-5.225001-2.612501-8.667404-7.832386-13.652951-5.050016-4.926196-11.755742-7.299243-16.85897-11.869329-18.399045-16.559141-21.780049-38.696324-19.643386-62.320371 0.651846-7.716752 3.441379-13.82896 2.196015-21.245883-0.951675-6.1777-4.631484-11.221576-9.142218-15.732309-1.422396-2.313695-5.161556-8.068769-5.342682-8.366551-4.151553-6.942109-7.417947-13.770632-14.06432-19.466354-3.741207-3.324722-13.651928-10.981099-22.967084-17.388019 41.723264-52.051493 96.263437-93.185332 158.88466-118.823246 0.470721 3.146667 1.837858 6.230911 3.857864 9.258874 5.16258 7.652284 10.029424 7.059789 20.1182 9.138124-1.067308 11.692297-14.72026 11.749602-23.916712 10.505261-10.981099-1.544169-22.614044-5.161556-32.168654 4.451382 5.279237 3.206018 19.761066 15.549138 17.863856 2.670829 10.56359-0.593518 20.770046-0.892323 30.980595 0.357134 4.152577 0.594541 18.040888 5.221932 21.780049 3.085268 1.603521-0.88823 3.26537-8.662287 4.986571-11.098779-2.965541 0-6.113231-1.422396-9.019421-1.186012 6.823406-8.725732 13.589506-1.89721 22.373567 2.078335-9.67229 5.872754-3.975545 19.882839 5.402033 8.485255 7.715729-9.259898-1.89721-16.084327-11.632945-21.427008 9.853415-12.344143 15.907295-13.471826 25.104771 0.474814 1.602498-8.602935 8.490372-5.220908 15.730263-4.50971l0-2.255367c-3.206018 0.118704-6.588045-1.720178-9.735735-1.363044 7.358595-11.754718 2.671852-14.422478 13.177114-18.343787 8.367575-2.966565 32.340569-0.118704 35.250852-8.010441-16.73515 3.204995-36.972053 3.976568-52.046377 11.632945-6.470365 3.264347-14.245446 13.651928-20.775162 6.883781-6.647397-6.883781 4.750187-17.981537 10.622942-21.364587l-1.422396 0c26.471908-5.695722 53.889351-8.725732 82.074274-8.725732 18.222013 0 36.084846 1.36816 53.594639 3.741207-6.053879 3.264347-1.544169 5.460362-5.995551 8.662287-8.42488 6.176676-23.440875 11.397584-33.469276 15.314801 12.758582-0.059352 43.677778 11.93175 49.612954-5.936199-4.093225-0.652869-8.191566-1.246387-12.344143-1.956561 7.715729-5.103228 16.261359-9.200546 25.344225-12.226462 81.370239 16.084327 153.719011 57.390082 208.798467 115.25907C794.734898 237.69254 794.317389 237.69254 793.900903 237.69254L793.900903 237.69254zM866.016361 393.962653c0.711198-1.539053 2.431376-2.073218 3.142573-3.382027 1.484817-2.670829 1.191128-4.50971 2.968611-6.823406 1.957585-2.555196 4.629437-3.14769 6.765077-5.104251 0.952698-0.832971 1.427512-1.544169 1.781576-2.313695 6.588045 18.33867 11.813047 37.33021 15.669888 56.737212-0.12075 0.177032-0.239454 0.35918-0.35918 0.476861-0.949628 0.769526-7.18054 1.661849-8.484232 1.720178-4.513804 0.177032-7.897877-2.847861-11.162224-5.637394-3.323699-2.907213-7.181563-6.707772-9.553587-10.446933-2.490727-3.916193-0.951675-8.073886-0.77055-12.58462C866.251721 402.807089 864.413863 397.409149 866.016361 393.962653L866.016361 393.962653zM871.062284 598.072331c-7.6574-6.647397-16.617469-15.608489-22.079878-24.157189-5.819542-9.138124-2.196015-18.574031-1.778506-29.138644 0.352017-8.785084-3.916193-21.366633-0.239454-29.318746 1.720178-3.681856 5.700839-4.867868 7.303336-7.833409 3.499707-6.294356 2.725064-10.564613 6.942109-16.024975 4.508687-5.818519 10.680247-7.240915 15.666818-11.754718 5.344728-4.804423 5.166673-8.603959 8.608052-14.716166 2.432399-4.451382 8.250918-11.93175 13.650905-15.907295 3.025916 19.466354 4.630461 39.408545 4.630461 59.70787 0 35.07382-4.691859 69.084425-13.355169 101.429087C883.050316 608.519264 876.934015 603.176582 871.062284 598.072331L871.062284 598.072331zM871.062284 598.072331"
      />
    </svg>
  );
};

export const PieChart = ({ style }: { style?: CSSProperties }) => {
  return (
    <svg
      style={style}
      xmlns="http://www.w3.org/2000/svg"
      className="icon"
      width="200px"
      height="200.00px"
      viewBox="0 0 1024 1024"
      version="1.1"
      id="pie-chart"
    >
      <LinearGradient id="pie-chart-linear" />
      <path
        {...COMMON_STYLE}
        stroke="url(#pie-chart-linear)"
        d="M864 518H506V160c0-4.4-3.6-8-8-8h-26c-54 0-106.4 10.6-155.7 31.4-47.6 20.1-90.4 49-127.1 85.7-36.7 36.7-65.6 79.5-85.7 127.1C82.6 445.6 72 498 72 552c0 54 10.6 106.4 31.4 155.7 20.1 47.6 49 90.4 85.7 127.1 36.7 36.7 79.5 65.6 127.1 85.7C365.6 941.4 418 952 472 952c54 0 106.4-10.6 155.7-31.4 47.6-20.1 90.4-49 127.1-85.7 36.7-36.7 65.6-79.5 85.7-127.1C861.4 658.4 872 606 872 552v-26c0-4.4-3.6-8-8-8zM705.7 787.8c-62.6 62.1-147.1 96.6-235.3 96.2-88.1-0.4-170.9-34.9-233.2-97.2C174.5 724.1 140 640.7 140 552c0-88.7 34.5-172.1 97.2-234.8 54.6-54.6 124.9-87.9 200.8-95.5V586h364.3c-7.7 76.3-41.3 147-96.6 201.8zM952 462.4l-2.6-28.2c-8.5-92.1-49.4-179-115.2-244.6-65.8-65.7-152.8-106.5-245.2-115L560.7 72c-4.7-0.4-8.7 3.2-8.7 7.9V464c0 4.4 3.6 8 8 8l384-1c4.7 0 8.4-4 8-8.6z m-332.2-58.2V147.6c62.6 13.1 120.7 44.2 166.4 89.8 45.7 45.6 77 103.6 90 166.1l-256.4 0.7z"
      />
    </svg>
  );
};

export const RadarChart = ({ style }: { style?: CSSProperties }) => {
  return (
    <svg
      id="radar-chart"
      style={style}
      xmlns="http://www.w3.org/2000/svg"
      className="icon"
      width="200px"
      height="200.00px"
      viewBox="0 0 1024 1024"
      version="1.1"
    >
      <LinearGradient id="radar-chart-linear" />
      <path
        {...COMMON_STYLE}
        stroke="url(#radar-chart-linear)"
        d="M926.8 397.1l-396-288a31.81 31.81 0 0 0-37.6 0l-396 288c-11.2 8.1-15.9 22.6-11.6 35.8l151.3 466c4.3 13.2 16.6 22.1 30.4 22.1h489.5c13.9 0 26.1-8.9 30.4-22.1l151.3-466c4.2-13.2-0.5-27.6-11.7-35.8zM838.6 417l-98.5 32-200-144.7V199.9L838.6 417zM466 567.2l-89.1 122.3-55.2-169.2L466 567.2z m-116.3-96.8L484 373.3v140.8l-134.3-43.7zM512 599.2l93.9 128.9H418.1L512 599.2z m28.1-225.9l134.2 97.1L540.1 514V373.3zM558 567.2l144.3-46.9-55.2 169.2L558 567.2z m-74-367.3v104.4L283.9 449l-98.5-32L484 199.9zM169.3 470.8l86.5 28.1 80.4 246.4-53.8 73.9-113.1-348.4zM327.1 853l50.3-69h269.3l50.3 69H327.1z m414.5-33.8l-53.8-73.9 80.4-246.4 86.5-28.1-113.1 348.4z"
      />
    </svg>
  );
};

export const ThermogramChart = ({ style }: { style?: CSSProperties }) => {
  return (
    <svg
      id="thermogram-chart"
      style={style}
      xmlns="http://www.w3.org/2000/svg"
      className="icon"
      width="200px"
      height="200.00px"
      viewBox="0 0 1024 1024"
      version="1.1"
    >
      <LinearGradient id="thermogram-chart-linear" />
      <path
        {...COMMON_STYLE}
        stroke="url(#thermogram-chart-linear)"
        d="M961.901714 585.142857c-161.938286-171.617524-145.505524-237.056-121.61219-305.566476C864.182857 211.139048 806.278095-90.453333 591.652571 26.819048c-214.552381 117.272381-150.625524 274.236952-303.713523 267.166476-153.088-6.89981-341.211429 78.360381-228.937143 392.728381 43.885714 122.88 127.195429 241.980952 256.292571 259.169524 129.072762 17.188571 341.089524-26.648381 470.162286 39.984761 129.048381 66.779429 338.432-229.10781 176.444952-400.725333zM750.689524 906.971429c-108.934095-52.614095-287.183238-21.723429-396.580572-34.230858-109.421714-12.507429-193.77981-91.818667-229.741714-191.000381-92.086857-253.659429 85.894095-325.36381 215.868952-321.389714 129.828571 3.998476 74.752-152.990476 258.02362-250.221714 183.222857-97.28 194.901333 154.575238 174.006857 210.407619-24.283429 64.487619-22.089143 125.537524 119.710476 269.019429 135.728762 137.532952-32.426667 370.078476-141.287619 317.44zM206.262857 526.945524c-58.953143 52.614095-8.362667 177.225143 67.535238 202.800762 76.01981 25.624381 151.161905-2.511238 210.115048-55.954286 58.904381-53.394286 51.102476-237.202286-46.908953-189.488762-97.987048 47.713524-110.592-64.75581-230.741333 42.642286zM633.782857 173.446095c-70.339048 18.773333-136.630857 141.385143-108.251428 195.876572 28.379429 54.369524 89.624381 151.113143 69.583238 221.232762-19.992381 69.924571-5.12 154.819048 62.025143 180.028952 67.193905 25.136762 210.651429 16.774095 212.455619-56.661333 1.755429-73.411048-169.423238-151.503238-174.275048-271.433143-4.778667-119.954286 52.809143-299.568762-61.537524-269.04381z"
      />
    </svg>
  );
};

export const TitleChart = ({ style }: { style?: CSSProperties }) => {
  return (
    <svg
      id="title-chart"
      style={style}
      xmlns="http://www.w3.org/2000/svg"
      className="icon"
      width="200px"
      height="200.00px"
      viewBox="0 0 1024 1024"
      version="1.1"
    >
      <LinearGradient id="title-chart-linear" />
      <path
        {...COMMON_STYLE}
        stroke="url(#title-chart-linear)"
        d="M782.222222 128H241.777778c-31.288889 0-56.888889 25.6-56.888889 56.888889v42.666667c0 15.644444 12.8 28.444444 28.444444 28.444444s28.444444-12.8 28.444445-28.444444v-42.666667h241.777778v654.222222h-56.888889c-15.644444 0-28.444444 12.8-28.444445 28.444445s12.8 28.444444 28.444445 28.444444h184.888889c15.644444 0 28.444444-12.8 28.444444-28.444444s-12.8-28.444444-28.444444-28.444445h-71.111112V184.888889h241.777778v42.666667c0 15.644444 12.8 28.444444 28.444445 28.444444s28.444444-12.8 28.444444-28.444444v-42.666667c0-31.288889-25.6-56.888889-56.888889-56.888889z"
      />
    </svg>
  );
};

export const VideoChart = ({ style }: { style?: CSSProperties }) => {
  return (
    <svg
      id="video-chart"
      style={style}
      xmlns="http://www.w3.org/2000/svg"
      className="icon"
      width="200px"
      height="200.00px"
      viewBox="0 0 1024 1024"
      version="1.1"
    >
      <LinearGradient id="video-chart-linear" />
      <path
        {...COMMON_STYLE}
        stroke="url(#video-chart-linear)"
        d="M914.98766 0H109.01234A53.988777 53.988777 0 0 0 55.023562 53.988777v916.009591a53.988777 53.988777 0 0 0 53.988778 53.988778h805.97532a53.988777 53.988777 0 0 0 53.988778-53.988778V53.988777a53.988777 53.988777 0 0 0-53.988778-53.988777z m-28.279836 221.443969h-73.411882L766.749903 82.268613H886.707824z m-530.439738 0L309.722047 82.268613h141.771959l46.546039 139.175356z m228.513928 0L538.235975 82.268613H680.007934l46.546038 139.175356zM222.980078 82.268613l46.546039 139.175356H137.292176V82.268613zM137.292176 941.718532V303.712582h749.415648V941.718532zM710.511593 563.128658l-267.07734-154.25365a53.988777 53.988777 0 0 0-80.983167 46.75171v308.455882a53.988777 53.988777 0 0 0 80.983167 46.75171l267.07734-154.253649a53.988777 53.988777 0 0 0 0-93.503421zM444.7197 715.055648V504.666524l182.237833 105.213844z"
      />
    </svg>
  );
};
