
# 大致结构    

## 页面
### 列表页  
- 操作：新增、删除、编辑、预览、分享、复制（再说）  
- 内容：id、名称、描述、背景、创建时间、更新时间、创建人、更新人  
### 设计页
- 整体结构使用`react-split-pane`进行分割，方便拖拽    
#### 头部
- 右边操作：保存、预览
- 左侧：展开收起图层，展开收起组件列表，主题切换  

#### 左侧列表  
- 左边工具条  
  1. 展开收起图层图标  
  2. 撤销重做  
  3. 显示隐藏辅助线 
  4. 显示隐藏图层  
- 中间图层列表  
  1. 头部
    - 搜索图层  
    - 全部展开、全部收起  
    - 成组、取消成组    
  2. 长列表  
    - 显示名称，可进行修改  
    - 左侧选择图标可进行显示隐藏  
    - 右侧图标可进行拖拽排序（react-sortable-hoc）  
    - 右键展示操作（向前、向后、置顶、置底、删除、复制、成组|取消成组、单独显示|取消单独显示）  
    - 图层结构（普通组件图层为2、置底图层为1、置顶图层为3，选中图层为4）
- 右边组件列表  
  1. 头部  
    - 搜索组件  
  2. 左侧分组  
    - 从上至下显示对应的分组图标
  3. 右侧组件列表  
    - 左右两个显示组件  
    - 上面图片下面名称   
    - 拖拽至中间画布进行放置（react-beautiful-dnd）    
#### 中间画布  
- 标尺  
  尝试是否能使用 RulersGuides.js  
- 辅助线  
  设置外部`class`，方便后面实现吸附效果  
- 点状背景  
  设置为可配置，根据外部传递  
- 点击展示对应配置，多个选中不显示配置  
- 选中的状态在全局保存  
- 图表  
  <!-- - 使用流式布局  
  - 右边两角拖动放大缩小  
  - 右上角图标排序   -->  
  - 右键操作同图层  
  - 选中时cv复制粘贴  
  - cmd+z 撤销、cmd+r 重做  
- 下方工具栏  
  - 右对齐  
  - 暂时只有缩放  

#### 右侧配置  
- 全局配置  
  1. 画布尺寸  
  2. 配色选择，及自定义配色    
  3. 背景选择  
- 组件配置全局配置  
  1. 切换组件  
- 通用配置  
  - 宽高、透明度、旋转  
  - 数据  
    - 静态资源  
      数据编辑
    - api调用  
      - get、post  
      - header  
      - body  
      - url  
      - 原始数据  
      - 字段映射  
      - 过滤器  
        - 选择、新增  
        - 过滤函数  
          - 支持第二参数，全局回调参数  
          - 每种只能选择一个  
          - 组件只引用id  
          - 过滤函数名称不能重复  
          - 展示前进行非空过滤  
        - 测试  
  - 交互  
    - 点击事件  
    - 回调参数，用于别的组件过滤函数（再说）  
    - 载入动画（再说） 
    - 自定义事件（再说）  



**注意**  
  - 列表将一二级左对齐  
  - 子孙级的使用在左侧添加边框来实现  
### 预览页  
- 显示组件  
- 当前只有h5，需要判断是否在手机端（is-mobile）  

### 分享页  
- 同预览页，多一步骤输入密码  

## 组件  

### 颜色选择组件  
- react-color  
- 设置为表单形式(value-onChange)  
### pc预览手机端窗口(winbox)  
- winbox  
- 根据传递的`id`或者配置进行显示  
- 中间细节关于手机适配问题再说  
### 文字样式配置通用  
- `antd`  
- 根据`antd`的组件做一下简单的配置封装  
- 表单形式(value-onChange)  

### 进度条  
- 这个暂时先不做，想不到有啥用到的地方  

### Loading  
- antd  
- loading状态  

### 背景设置组件  
- `antd`  
- 通用的组件设置背景  
- 包括图片以及颜色   
- 表单形式(value-onChange)  

### 代码编辑器组件  
- react-monaco-editor  
- 书写代码  
- 表单形式(value-onChange)  

### 代码预览  
- react-syntax-highlighter  
- 只读形式查看代码  

### tooltip图标提示  
- antd  
- 用于在配置中做弹出提醒   

### 配色  
- 进行简单的配色风格选择  
- 颜色内容通过外部可定义配置的形式传递  

### 标尺  
- RulersGuides.js  
- 设计页面画布的标尺显示  

### 公共渲染组件的父组件  
- 处理内部多层component的结构  

### 列表组件  
- 将`antd`的列表组件封装下  

### 关联组件  
- 使用无有边框的空组件当做关联标志  

### 渐变色设置组件  
- 两种颜色  
- 百分比  
- 方向  