import { useMantineTheme } from '@mantine/core';

import classes from './LogoText.module.css';

interface LogoProps extends React.ComponentPropsWithoutRef<'svg'> {
	isHeader?: boolean;
}

const LogoText = ({ height, isHeader, ...others }: LogoProps) => {
	const theme = useMantineTheme();

	const markWrapFill = isHeader ? theme.colors.purple[0] : 'white';
	const markFill = isHeader ? theme.colors.text[0] : theme.colors.text[1];
	return (
		<svg
			height={height ?? 31}
			viewBox="0 0 161 31"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
			{...others}
		>
			<title>Fontsource Logo</title>
			<rect y="0.5" width="30" height="30" rx="4" fill={markWrapFill} />
			<path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M11.7 7.7H20.1L22.5 7.7V13.1H20.1V10.1L11.7 10.1V14.3L17.1 14.3V16.7H11.7V20.9H13.5V23.3H11.7H9.3L7.5 23.3V20.9H9.3V16.7H7.5V14.3H9.3V10.1H7.5V7.7L9.3 7.7H11.7Z"
				fill={markFill}
			/>
			<path
				className={classes.header}
				data-is-header={isHeader}
				d="M38.3 23V8.4H49.26V11.62H42.04V15.06H47.94V17.72H42.04V23H38.3ZM55.9884 23.2C54.9751 23.2 54.0818 23.06 53.3084 22.78C52.5351 22.4867 51.8884 22.0867 51.3684 21.58C50.8618 21.0733 50.4818 20.4667 50.2284 19.76C49.9751 19.04 49.8484 18.26 49.8484 17.42C49.8484 16.5933 49.9818 15.82 50.2484 15.1C50.5284 14.38 50.9284 13.76 51.4484 13.24C51.9684 12.72 52.6084 12.3133 53.3684 12.02C54.1418 11.7267 55.0151 11.58 55.9884 11.58C56.9884 11.58 57.8751 11.7333 58.6484 12.04C59.4218 12.3333 60.0618 12.74 60.5684 13.26C61.0884 13.78 61.4751 14.4 61.7284 15.12C61.9951 15.8267 62.1284 16.5867 62.1284 17.4C62.1284 18.2133 61.9884 18.98 61.7084 19.7C61.4418 20.4067 61.0484 21.02 60.5284 21.54C60.0084 22.0467 59.3618 22.4533 58.5884 22.76C57.8284 23.0533 56.9618 23.2 55.9884 23.2ZM55.9884 20.36C56.8418 20.36 57.4551 20.0933 57.8284 19.56C58.2018 19.0267 58.3884 18.3067 58.3884 17.4C58.3884 16.4667 58.2018 15.7267 57.8284 15.18C57.4684 14.6333 56.8551 14.36 55.9884 14.36C55.1618 14.36 54.5551 14.64 54.1684 15.2C53.7818 15.7467 53.5884 16.48 53.5884 17.4C53.5751 18.32 53.7484 19.0467 54.1084 19.58C54.4818 20.1 55.1084 20.36 55.9884 20.36ZM64.0403 23V11.8H67.6403V14.38C68.0003 13.42 68.507 12.7133 69.1603 12.26C69.8136 11.8067 70.5803 11.58 71.4603 11.58C72.7003 11.58 73.667 11.98 74.3603 12.78C75.0536 13.5667 75.4003 14.6267 75.4003 15.96V23H71.7803V17.04C71.7803 16.1467 71.627 15.4867 71.3203 15.06C71.0136 14.6333 70.5003 14.42 69.7803 14.42C69.087 14.42 68.5603 14.6867 68.2003 15.22C67.8403 15.7533 67.6603 16.5333 67.6603 17.56V23H64.0403ZM85.3155 19.96V22.6C85.0221 22.7733 84.6688 22.9133 84.2555 23.02C83.8555 23.14 83.4088 23.2 82.9155 23.2C81.4888 23.2 80.5021 22.8667 79.9555 22.2C79.4221 21.5333 79.1555 20.5667 79.1555 19.3V14.62H76.7555V11.8H79.1955V9.04L82.5355 7.44V11.8H85.3155V14.62H82.5355V18.74C82.5355 19.3 82.6488 19.7 82.8755 19.94C83.1155 20.1667 83.4688 20.28 83.9355 20.28C84.2155 20.28 84.4555 20.2533 84.6555 20.2C84.8688 20.1333 85.0888 20.0533 85.3155 19.96ZM86.3783 21.1L88.8183 18.82C89.2849 19.3533 89.8049 19.7467 90.3783 20C90.9516 20.2533 91.5649 20.38 92.2183 20.38C92.7783 20.38 93.1716 20.2867 93.3983 20.1C93.6383 19.9 93.7583 19.6667 93.7583 19.4C93.7583 19.04 93.4783 18.8067 92.9183 18.7C92.3583 18.58 91.5383 18.4333 90.4583 18.26C89.3516 18.0867 88.4716 17.7733 87.8183 17.32C87.1649 16.8667 86.8383 16.1467 86.8383 15.16C86.8383 14.6667 86.9383 14.2 87.1383 13.76C87.3383 13.32 87.6316 12.9333 88.0183 12.6C88.4183 12.2667 88.9116 12.0067 89.4983 11.82C90.0983 11.62 90.7783 11.52 91.5383 11.52C92.6983 11.52 93.7449 11.6933 94.6783 12.04C95.6249 12.3733 96.4583 12.9333 97.1783 13.72L94.7183 15.92C94.3049 15.4 93.8116 15.0133 93.2383 14.76C92.6649 14.4933 92.0383 14.36 91.3583 14.36C90.7849 14.36 90.3849 14.4533 90.1583 14.64C89.9449 14.8133 89.8383 15.0267 89.8383 15.28C89.8383 15.6133 90.0649 15.84 90.5183 15.96C90.9716 16.08 91.6849 16.2133 92.6583 16.36C93.9116 16.5467 94.9183 16.8733 95.6783 17.34C96.4516 17.7933 96.8383 18.54 96.8383 19.58C96.8383 20.6467 96.4383 21.5267 95.6383 22.22C94.8383 22.9 93.7116 23.24 92.2583 23.24C90.8849 23.24 89.7183 23.0533 88.7583 22.68C87.7983 22.2933 87.0049 21.7667 86.3783 21.1ZM104.387 23.2C103.374 23.2 102.48 23.06 101.707 22.78C100.934 22.4867 100.287 22.0867 99.7669 21.58C99.2602 21.0733 98.8802 20.4667 98.6269 19.76C98.3735 19.04 98.2469 18.26 98.2469 17.42C98.2469 16.5933 98.3802 15.82 98.6469 15.1C98.9269 14.38 99.3269 13.76 99.8469 13.24C100.367 12.72 101.007 12.3133 101.767 12.02C102.54 11.7267 103.414 11.58 104.387 11.58C105.387 11.58 106.274 11.7333 107.047 12.04C107.82 12.3333 108.46 12.74 108.967 13.26C109.487 13.78 109.874 14.4 110.127 15.12C110.394 15.8267 110.527 16.5867 110.527 17.4C110.527 18.2133 110.387 18.98 110.107 19.7C109.84 20.4067 109.447 21.02 108.927 21.54C108.407 22.0467 107.76 22.4533 106.987 22.76C106.227 23.0533 105.36 23.2 104.387 23.2ZM104.387 20.36C105.24 20.36 105.854 20.0933 106.227 19.56C106.6 19.0267 106.787 18.3067 106.787 17.4C106.787 16.4667 106.6 15.7267 106.227 15.18C105.867 14.6333 105.254 14.36 104.387 14.36C103.56 14.36 102.954 14.64 102.567 15.2C102.18 15.7467 101.987 16.48 101.987 17.4C101.974 18.32 102.147 19.0467 102.507 19.58C102.88 20.1 103.507 20.36 104.387 20.36ZM123.419 11.8V23H119.819V20.44C119.459 21.3867 118.965 22.0867 118.339 22.54C117.725 22.9933 116.999 23.22 116.159 23.22C114.879 23.22 113.919 22.8267 113.279 22.04C112.652 21.24 112.339 20.1733 112.339 18.84V11.8H115.959V17.78C115.959 18.6733 116.099 19.3333 116.379 19.76C116.672 20.1867 117.159 20.4 117.839 20.4C118.505 20.4 118.999 20.12 119.319 19.56C119.639 19 119.799 18.22 119.799 17.22V11.8H123.419ZM132.517 11.64C132.877 11.64 133.197 11.6667 133.477 11.72C133.77 11.7733 134.023 11.8467 134.237 11.94L133.357 15.28C133.103 15.16 132.837 15.0667 132.557 15C132.29 14.9333 131.977 14.9 131.617 14.9C131.03 14.9 130.523 15.1333 130.097 15.6C129.683 16.0667 129.477 16.76 129.477 17.68V23H125.857V11.8H129.457V14.9C129.683 13.7667 130.03 12.94 130.497 12.42C130.977 11.9 131.65 11.64 132.517 11.64ZM146.494 15.7L142.794 16.56C142.7 15.88 142.5 15.3467 142.194 14.96C141.887 14.56 141.387 14.36 140.694 14.36C139.894 14.36 139.307 14.6333 138.934 15.18C138.56 15.7267 138.367 16.4667 138.354 17.4C138.354 18.3333 138.527 19.06 138.874 19.58C139.234 20.1 139.84 20.36 140.694 20.36C141.374 20.36 141.867 20.1667 142.174 19.78C142.494 19.38 142.707 18.8467 142.814 18.18L146.534 18.88C146.254 20.1867 145.62 21.2333 144.634 22.02C143.647 22.8067 142.334 23.2 140.694 23.2C139.68 23.2 138.794 23.06 138.034 22.78C137.274 22.4867 136.64 22.0867 136.134 21.58C135.64 21.0733 135.267 20.4667 135.014 19.76C134.76 19.04 134.634 18.26 134.634 17.42C134.634 16.5933 134.767 15.82 135.034 15.1C135.314 14.38 135.714 13.76 136.234 13.24C136.754 12.72 137.4 12.3133 138.174 12.02C138.947 11.7267 139.827 11.58 140.814 11.58C142.52 11.58 143.82 11.96 144.714 12.72C145.607 13.4667 146.2 14.46 146.494 15.7ZM159.299 20.08C158.832 21 158.152 21.7533 157.259 22.34C156.365 22.9133 155.205 23.2 153.779 23.2C152.765 23.2 151.879 23.06 151.119 22.78C150.372 22.4867 149.745 22.0867 149.239 21.58C148.745 21.0733 148.372 20.4733 148.119 19.78C147.879 19.0733 147.759 18.3133 147.759 17.5C147.759 16.6867 147.892 15.92 148.159 15.2C148.439 14.48 148.832 13.8533 149.339 13.32C149.859 12.7867 150.499 12.3667 151.259 12.06C152.019 11.74 152.879 11.58 153.839 11.58C154.825 11.58 155.679 11.7333 156.399 12.04C157.132 12.3467 157.732 12.7533 158.199 13.26C158.665 13.7533 159.012 14.3333 159.239 15C159.465 15.6667 159.579 16.36 159.579 17.08V18.16H151.219C151.312 18.8933 151.579 19.4533 152.019 19.84C152.459 20.2267 153.065 20.42 153.839 20.42C154.425 20.42 154.899 20.3067 155.259 20.08C155.619 19.84 155.925 19.4533 156.179 18.92L159.299 20.08ZM153.759 14.22C153.065 14.22 152.505 14.4067 152.079 14.78C151.652 15.1533 151.379 15.6867 151.259 16.38H156.059C156.019 15.74 155.812 15.22 155.439 14.82C155.079 14.42 154.519 14.22 153.759 14.22Z"
			/>
		</svg>
	);
};

export { LogoText };
