export const METADATA_URL =
	'https://raw.githubusercontent.com/fontsource/font-files/main/metadata/fontsource.json';

export const VARIABLE_URL =
	'https://raw.githubusercontent.com/fontsource/font-files/main/metadata/variable.json';

export const VARIABLE_ICONS_URL =
	'https://raw.githubusercontent.com/fontsource/font-files/main/metadata/icons-variable.json';

export const AXIS_REGISTRY_URL =
	'https://raw.githubusercontent.com/fontsource/font-files/main/metadata/axis-registry.json';

export const API_BROWSER_TTL = 60 * 5; // 5 minutes

export const CF_EDGE_TTL = 60 * 60 * 24; // 24 hours

export const KV_TTL = 60 * 60 * 3; // 3 hours

// Metadata keys
export const METADATA_KEYS = {
	fonts: 'metadata',
	fonts_arr: 'metadata_arr',
	variable_list: 'variable_list',
	axisRegistry: 'axis_registry',
	fontlist: (key: string) => `fontlist:${key}`,
	version: (id: string) => `version:${id}`,
	downloads: 'download_stats',
};
