""" Fontman server font faces consumer

Consume and sync with fontman server font faces REST API.

Created by Lahiru Pathirage @ Mooniak<lpsandaruwan@gmail.com> on 5/1/2017
"""

from session import api_base_url

import json, requests


class FontFacesConsumer:
    
    def consume_all_fontfaces(self):
        response = requests.get(api_base_url + "/fontfaces")
        return json.loads(response.text)

    def consume_by_fontface_id(self, fontface_id):
        response = requests.get(api_base_url + "/fontfaces/" + str(fontface_id))
        return json.loads(response.text)

    def consume_by_query(self, font_id):
        response = requests.get(
            api_base_url + "/fontfaces/?font_id=" + str(font_id)
        )
        return json.loads(response.text)
