CREATE TABLE public."Bookmarks" (
    id integer NOT NULL,
    "user" uuid NOT NULL,
    learning_path integer NOT NULL
);
CREATE SEQUENCE public."Bookmark_id_seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER SEQUENCE public."Bookmark_id_seq" OWNED BY public."Bookmarks".id;
CREATE TABLE public."Networks" (
    id integer NOT NULL,
    "user" uuid NOT NULL,
    following uuid NOT NULL
);
CREATE SEQUENCE public."Followers_id_seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER SEQUENCE public."Followers_id_seq" OWNED BY public."Networks".id;
CREATE TABLE public."Footsteps" (
    id integer NOT NULL,
    title text NOT NULL,
    description text NOT NULL,
    resource_type text NOT NULL,
    resource_url text NOT NULL,
    level integer NOT NULL,
    tags text,
    learning_path integer NOT NULL,
    resource_icon text
);
CREATE SEQUENCE public."FootStep_id_seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER SEQUENCE public."FootStep_id_seq" OWNED BY public."Footsteps".id;
CREATE TABLE public."Learning_Paths" (
    id integer NOT NULL,
    title text NOT NULL,
    description text NOT NULL,
    author uuid NOT NULL,
    icon text
);
CREATE SEQUENCE public."LearningPath_id_seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER SEQUENCE public."LearningPath_id_seq" OWNED BY public."Learning_Paths".id;
CREATE TABLE public."Progress" (
    id integer NOT NULL,
    "user" uuid NOT NULL,
    footstep integer NOT NULL
);
CREATE SEQUENCE public."Progress_id_seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER SEQUENCE public."Progress_id_seq" OWNED BY public."Progress".id;
CREATE TABLE public."Users" (
    id uuid DEFAULT public.gen_random_uuid() NOT NULL,
    username text NOT NULL,
    first_name text NOT NULL,
    last_name text NOT NULL,
    profile_pic text,
    email text NOT NULL,
    bio text,
    about text,
    skills text,
    github text,
    linkedin text,
    facebook text
);
CREATE TABLE public."Votes" (
    id integer NOT NULL,
    learning_path integer NOT NULL,
    "user" uuid NOT NULL
);
CREATE SEQUENCE public."Vote_id_seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
ALTER SEQUENCE public."Vote_id_seq" OWNED BY public."Votes".id;
ALTER TABLE ONLY public."Bookmarks" ALTER COLUMN id SET DEFAULT nextval('public."Bookmark_id_seq"'::regclass);
ALTER TABLE ONLY public."Footsteps" ALTER COLUMN id SET DEFAULT nextval('public."FootStep_id_seq"'::regclass);
ALTER TABLE ONLY public."Learning_Paths" ALTER COLUMN id SET DEFAULT nextval('public."LearningPath_id_seq"'::regclass);
ALTER TABLE ONLY public."Networks" ALTER COLUMN id SET DEFAULT nextval('public."Followers_id_seq"'::regclass);
ALTER TABLE ONLY public."Progress" ALTER COLUMN id SET DEFAULT nextval('public."Progress_id_seq"'::regclass);
ALTER TABLE ONLY public."Votes" ALTER COLUMN id SET DEFAULT nextval('public."Vote_id_seq"'::regclass);
ALTER TABLE ONLY public."Bookmarks"
    ADD CONSTRAINT "Bookmarks_pkey" PRIMARY KEY ("user", learning_path);
ALTER TABLE ONLY public."Footsteps"
    ADD CONSTRAINT "FootStep_pkey" PRIMARY KEY (id);
ALTER TABLE ONLY public."Learning_Paths"
    ADD CONSTRAINT "LearningPath_pkey" PRIMARY KEY (id);
ALTER TABLE ONLY public."Networks"
    ADD CONSTRAINT "Networks_pkey" PRIMARY KEY ("user", following);
ALTER TABLE ONLY public."Progress"
    ADD CONSTRAINT "Progress_pkey" PRIMARY KEY ("user", footstep);
ALTER TABLE ONLY public."Users"
    ADD CONSTRAINT "User_id_key" UNIQUE (id);
ALTER TABLE ONLY public."Users"
    ADD CONSTRAINT "Users_email_key" UNIQUE (email);
ALTER TABLE ONLY public."Users"
    ADD CONSTRAINT "Users_pkey" PRIMARY KEY (id);
ALTER TABLE ONLY public."Users"
    ADD CONSTRAINT "Users_username_key" UNIQUE (username);
ALTER TABLE ONLY public."Votes"
    ADD CONSTRAINT "Votes_pkey" PRIMARY KEY ("user", learning_path);
ALTER TABLE ONLY public."Bookmarks"
    ADD CONSTRAINT "Bookmark_learning_path_fkey" FOREIGN KEY (learning_path) REFERENCES public."Learning_Paths"(id) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE ONLY public."Bookmarks"
    ADD CONSTRAINT "Bookmark_user_fkey" FOREIGN KEY ("user") REFERENCES public."Users"(id) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE ONLY public."Networks"
    ADD CONSTRAINT "Followers_following_fkey" FOREIGN KEY (following) REFERENCES public."Users"(id) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE ONLY public."Networks"
    ADD CONSTRAINT "Followers_user_fkey" FOREIGN KEY ("user") REFERENCES public."Users"(id) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE ONLY public."Footsteps"
    ADD CONSTRAINT "FootStep_learning_path_fkey" FOREIGN KEY (learning_path) REFERENCES public."Learning_Paths"(id) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE ONLY public."Learning_Paths"
    ADD CONSTRAINT "LearningPath_author_fkey" FOREIGN KEY (author) REFERENCES public."Users"(id) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE ONLY public."Progress"
    ADD CONSTRAINT "Progress_footstep_fkey" FOREIGN KEY (footstep) REFERENCES public."Footsteps"(id) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE ONLY public."Progress"
    ADD CONSTRAINT "Progress_user_fkey" FOREIGN KEY ("user") REFERENCES public."Users"(id) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE ONLY public."Votes"
    ADD CONSTRAINT "Vote_learning_path_fkey" FOREIGN KEY (learning_path) REFERENCES public."Learning_Paths"(id) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE ONLY public."Votes"
    ADD CONSTRAINT "Vote_user_fkey" FOREIGN KEY ("user") REFERENCES public."Users"(id) ON UPDATE RESTRICT ON DELETE RESTRICT;
