use anyhow::Result;
use encoding_rs::Encoding;

pub fn parse_encoding(label: &str) -> Result<&'static Encoding> {
    match Encoding::for_label((label).as_bytes()) {
        Some(encoding) => Ok(encoding),
        None => Err(anyhow::anyhow!("failed to parse encoding {}", label)),
    }
}

// This list comes from encoding_rs, which is licensed under Apache 2.0 or MIT.
// https://github.com/hsivonen/encoding_rs/blob/19efaf064f5b95477cc1e0b487566d213a6d67f3/src/lib.rs#L2140
pub static LABELS_SORTED: [&str; 219] = [
    "l1",
    "l2",
    "l3",
    "l4",
    "l5",
    "l6",
    "l9",
    "866",
    "mac",
    "koi",
    "gbk",
    "big5",
    "utf8",
    "koi8",
    "sjis",
    "ms932",
    "cp866",
    "utf-8",
    "cp819",
    "ascii",
    "x-gbk",
    "greek",
    "cp1250",
    "cp1251",
    "latin1",
    "gb2312",
    "cp1252",
    "latin2",
    "cp1253",
    "latin3",
    "cp1254",
    "latin4",
    "cp1255",
    "csbig5",
    "latin5",
    "utf-16",
    "cp1256",
    "ibm866",
    "latin6",
    "cp1257",
    "cp1258",
    "greek8",
    "ibm819",
    "arabic",
    "visual",
    "korean",
    "euc-jp",
    "koi8-r",
    "koi8_r",
    "euc-kr",
    "x-sjis",
    "koi8-u",
    "hebrew",
    "tis-620",
    "gb18030",
    "ksc5601",
    "gb_2312",
    "dos-874",
    "cn-big5",
    "chinese",
    "logical",
    "cskoi8r",
    "cseuckr",
    "koi8-ru",
    "x-cp1250",
    "ksc_5601",
    "x-cp1251",
    "iso88591",
    "csgb2312",
    "x-cp1252",
    "iso88592",
    "x-cp1253",
    "iso88593",
    "ecma-114",
    "x-cp1254",
    "iso88594",
    "x-cp1255",
    "iso88595",
    "x-x-big5",
    "x-cp1256",
    "csibm866",
    "iso88596",
    "x-cp1257",
    "iso88597",
    "asmo-708",
    "ecma-118",
    "elot_928",
    "x-cp1258",
    "iso88598",
    "iso88599",
    "cyrillic",
    "utf-16be",
    "utf-16le",
    "us-ascii",
    "ms_kanji",
    "x-euc-jp",
    "iso885910",
    "iso8859-1",
    "iso885911",
    "iso8859-2",
    "iso8859-3",
    "iso885913",
    "iso8859-4",
    "iso885914",
    "iso8859-5",
    "iso885915",
    "iso8859-6",
    "iso8859-7",
    "iso8859-8",
    "iso-ir-58",
    "iso8859-9",
    "macintosh",
    "shift-jis",
    "shift_jis",
    "iso-ir-100",
    "iso8859-10",
    "iso-ir-110",
    "gb_2312-80",
    "iso-8859-1",
    "iso_8859-1",
    "iso-ir-101",
    "iso8859-11",
    "iso-8859-2",
    "iso_8859-2",
    "hz-gb-2312",
    "iso-8859-3",
    "iso_8859-3",
    "iso8859-13",
    "iso-8859-4",
    "iso_8859-4",
    "iso8859-14",
    "iso-ir-144",
    "iso-8859-5",
    "iso_8859-5",
    "iso8859-15",
    "iso-8859-6",
    "iso_8859-6",
    "iso-ir-126",
    "iso-8859-7",
    "iso_8859-7",
    "iso-ir-127",
    "iso-ir-157",
    "iso-8859-8",
    "iso_8859-8",
    "iso-ir-138",
    "iso-ir-148",
    "iso-8859-9",
    "iso_8859-9",
    "iso-ir-109",
    "iso-ir-149",
    "big5-hkscs",
    "csshiftjis",
    "iso-8859-10",
    "iso-8859-11",
    "csisolatin1",
    "csisolatin2",
    "iso-8859-13",
    "csisolatin3",
    "iso-8859-14",
    "windows-874",
    "csisolatin4",
    "iso-8859-15",
    "iso_8859-15",
    "csisolatin5",
    "iso-8859-16",
    "csisolatin6",
    "windows-949",
    "csisolatin9",
    "csiso88596e",
    "csiso88598e",
    "csmacintosh",
    "csiso88596i",
    "csiso88598i",
    "windows-31j",
    "x-mac-roman",
    "iso-2022-cn",
    "iso-2022-jp",
    "csiso2022jp",
    "iso-2022-kr",
    "csiso2022kr",
    "replacement",
    "windows-1250",
    "windows-1251",
    "windows-1252",
    "windows-1253",
    "windows-1254",
    "windows-1255",
    "windows-1256",
    "windows-1257",
    "windows-1258",
    "iso-8859-6-e",
    "iso-8859-8-e",
    "iso-8859-6-i",
    "iso-8859-8-i",
    "sun_eu_greek",
    "csksc56011987",
    "ks_c_5601-1987",
    "ansi_x3.4-1968",
    "ks_c_5601-1989",
    "x-mac-cyrillic",
    "x-user-defined",
    "csiso58gb231280",
    "iso_8859-1:1987",
    "iso_8859-2:1987",
    "iso_8859-6:1987",
    "iso_8859-7:1987",
    "iso_8859-3:1988",
    "iso_8859-4:1988",
    "iso_8859-5:1988",
    "iso_8859-8:1988",
    "iso_8859-9:1989",
    "csisolatingreek",
    "x-mac-ukrainian",
    "iso-2022-cn-ext",
    "csisolatinarabic",
    "csisolatinhebrew",
    "unicode-1-1-utf-8",
    "csisolatincyrillic",
    "cseucpkdfmtjapanese",
];
