<div align="center">
  <a href="https://github.com/filippofinke/WordGPT">
    <img src="assets/robot.png" alt="Logo" height="100">
  </a>

  <br />
  <h3 align="center">WordGPT</h3>

  <p align="center">
    Enhance your writing experience with WordGPT, the Microsoft Office add-in that brings ChatGPT's language model directly into Word.
    <br />
    <a href="https://github.com/filippofinke/WordGPT"><strong>Explore the docs »</strong></a>
    <br />
    <br />
    <a href="https://github.com/filippofinke/WordGPT/issues">Report Bug</a>
    ·
    <a href="https://github.com/filippofinke/WordGPT/issues">Request Feature</a>
  </p>

![ezgif-2-3b6a659c22](https://user-images.githubusercontent.com/37296364/221949219-4aba4e03-125f-4d81-a58b-7cffa4c9c03c.gif)

</div>



## About The Project
WordGPT is project that integrates OpenAI's powerful language model, text-davinci-003, directly into Microsoft Word. With WordGPT, users can benefit from the advanced natural language processing capabilities of text-davinci-003 to generate text.

## Getting Started
To get started with WordGPT, you will need to sideload the add-in into Microsoft Word. Sideloading allows you to install and test add-ins that are not yet available on the Microsoft Store.

To sideload WordGPT, you will need to follow the instructions provided by Microsoft. You can find these instructions at the following link: https://learn.microsoft.com/en-us/office/dev/add-ins/testing/sideload-office-add-ins-for-testing

### Windows

Follow this guide https://learn.microsoft.com/en-us/office/dev/add-ins/testing/create-a-network-shared-folder-catalog-for-task-pane-and-content-add-ins

### MacOS

To sideload WordGPT on MacOS you can follow theses steps:
1. Close Word.
2. Go to the add-in folder for Word.
```sh
cd ~/Library/Containers/com.microsoft.Word/Data/Documents/wef
```
3. Download the manifest file.
```sh
wget https://word-gpt-filippofinke.vercel.app/manifest.xml -O wordgpt.xml
```
4. Open Word.

## Contributing

Contributions are what make the open source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**.

If you have a suggestion that would make this better, please fork the repo and create a pull request. You can also simply open an issue with the tag "enhancement".

1. Fork the Project
2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
3. Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the Branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

## License

WordGPT is released under the MIT License. See the LICENSE file for more details.

## Author

👤 **Filippo Finke**

- Website: https://filippofinke.ch
- Github: [@filippofinke](https://github.com/filippofinke)
- LinkedIn: [@filippofinke](https://linkedin.com/in/filippofinke)

## Show your support

Give a ⭐️ if this project helped you!

<a href="https://www.buymeacoffee.com/filippofinke">
  <img src="https://github.com/filippofinke/filippofinke/raw/main/images/buymeacoffe.png" alt="Buy Me A McFlurry">
</a>
