.\" Manual for wmrc.
.TH "wikiman" 1 "15 September 2023" "wikiman 2.13.2" "wikiman manual"

.SH NAME
.B wikiman
\- Offline search engine for manual pages, Arch Wiki, Gentoo Wiki and other documentation.

.SH SYNOPSIS
.B wikiman
[-q] [-a] [-p] [-k] [-c]
.br
        [-l <comma separated languages>] [-s <comma separated sources>]
.br
        [-f <fuzzy finder>] [-H <html viewer>] [-R] <keyword>...
.br
.B wikiman
-S
.br
.B wikiman
-W <shell>
.br
.B wikiman
-v
.br
.B wikiman
-h

If no keywords are provided, show all pages.

.SH DESCRIPTION
.P
Wikiman is an offline search engine for manual pages, Arch Wiki, Gentoo Wiki and other documentation.

Wikiman provides an easy interface for browsing documentation without the need to be exact and connected to the internet.
This is achieved by utilizing full text search for wikis, partial name and description matching for man pages,
and fuzzy filtering for search results.


.SH OPTIONS
.HP
.B -l
<comma separated languages>
.br
search language(s)
.br
default: en

.HP
.B -s
<comma separated sources>
.br
sources to use
.br
default: (all available)

.HP
.B -f
<fuzzy finder>
.br
fuzzy finder to use
.br
default: fzf

.HP
.B -q
.br
enable quick search mode

.HP
.B -a
.br
enable AND operator mode

.HP
.B -p
.br
disable quick result preview

.HP
.B -k
.br
keep open after viewing a result

.HP
.B -c
.br
show source column

.HP
.B -H
<html viewer>
.br
viewer for HTML pages
.br
default: w3m

.HP
.B -R
.br
print raw output

.HP
.B -S
.br
list available sources and exit

.HP
.B -W
<shell>
.br
print widget code for specified shell and exit

.HP
.B -v
.br
print version and exit

.HP
.B -h
.br
display help and exit

.SH CONFIGURATION:

Default user configuration file location:
.I
~/.config/wikiman/wikiman.conf
(if XDG_CONFIG_HOME is not set).

System-wide configuration location:
.I
/etc/wikiman.conf

.SS Sources
sources =

.SS Fuzzy finder
fuzzy_finder = fzf

.SS Quick search mode
quick_search = false

.SS AND operator mode
and_operator = false

.SS Raw output
raw_output = false

.SS Language(s)
man_lang = en

wiki_lang = en
.PP
.B
List all man languages besides English (en):
.br
find '/usr/share/man' -maxdepth 1 -type d -not -name 'man*' -printf '%P '
.PP
.B
List all Arch Wiki languages:
.br
find '/usr/share/doc/arch-wiki/html' -maxdepth 1 -type d -printf '%P '
.PP
.B
List all FreeBSD Documentation languages:
.br
find '/usr/share/doc/freebsd-docs' -maxdepth 1 -type d -printf '%P '

.SS TUI preview
tui_preview = true

.SS TUI keep open
tui_keep_open = false

.SS TUI show source column
tui_source_column = false

.SS TUI viewer for HTML pages
tui_html = w3m


.SH ADDITIONAL SOURCES:

Default user sources directory:
.I
~/.config/wikiman/sources
(if XDG_CONFIG_HOME is not set).

System-wide sources directory:
.I
/usr/share/wikiman/sources

.SS Installing a source:
To install an additional source called <name>, download it using Wikiman's Makefile:

sudo make install source-<name>
