# 从日程管理软件到个人助理Agent

## 背景

在计算的时代，我们想要有开发一个好用的日程管理服务，很快就会发现这并不简单。比如我们会有各种各样的重复任务提醒要求：比如每个工作周周五的下午去游泳，每个工作周的第一天要开例会，和某人的纪念日要做什么等等。允许用户创建，并识别这些复杂的条件是非常繁琐的。而在计算机发明以前，你的秘书只需要一张纸就可以搞定各种复杂的日程管理：秘书把你的要求原样记录下，然后秘书只要每天Review一遍，确定好今天的行程就好。

一些有更复杂的条件的日程，秘书可以通过定期Review代办来搞定。

理解上述区别，就理解了 PC 和  PI （CPU vs LLM）的核心区别。

## 基于Agent 的日程管理基础设施

为了支持秘书Agent，aios所构建的机制是:

1. Task创建: 模拟秘书在记事本上记录下日程相关的任务（注意不要让Agent创建重复的任务）
2. ListTask,可查询未标记为结束的Task
3. 大Review（定期LLM调用），Agent浏览未完成的Task，并给这些Task一个比较精确的`下次处理时间`
4. 当处理事件的时间点到达时，Agent会尝试处理Task，此时决定是否满足日程发生的条件，并发送正确的提醒信息。

上面的所有的Agent处理，都是让 LLM处理一段文本，并做出反应。因此没有存储格式的需求，用自然语言记录下各种条件就可以了。

## 过渡：混合使用日程管理软件和 秘书Agent

1. 秘书Agent主要使用日程管理软件来查询已有日程
2. Agent创建通过日程管理软件的目的，通常是为了公开日程，或则创建的是具有`一定协作需求`，或有`公开需求`的`确定`日程
3. Agent依旧依靠自己的LLM Based逻辑来Review并处理日程, 通过日程管理软件得到的需要处理的日程会有特殊标记，以能正确的操作来保持处理结果。