# **OpenDAN: Personal AI OS**
[![Official Website](https://img.shields.io/badge/Official%20Website-opendan.ai-blue?style=flat&logo=world&logoColor=white)](https://opendan.ai)
[![GitHub Repo stars](https://img.shields.io/github/stars/fiatrete/OpenDAN-Personal-AI-OS?style=social)](https://github.com/fiatrete/OpenDAN-Personal-AI-OS/stargazers)
[![Twitter Follow](https://img.shields.io/twitter/follow/openDAN_AI?style=social)](https://twitter.com/openDAN_AI)

OpenDAN is an open source Personal AI OS , which consolidates various AI modules in one place for your personal use.

## **Project Introduction**

The goal of OpenDAN (Open and Do Anything Now with AI) is to create a Personal AI OS , which provides a runtime environment for various Al modules as well as protocols for interoperability between them. With OpenDAN, users can securely collaborate with various AI modules using their private data to create powerful personal AI agents, such as butler, lawyer, doctor, teacher, assistant, girl or boy friends.

This project is still in its very early stages, and there may be significant changes in the future.

## **Updates**

### 1. Adding Knowledge Base Infrastructure
We're currently working on implementing the infrastructure for the Knowledge Base, aiming to enhance AI agent's access to Personal Data stored on Personal Servers. Leveraging these new features, we want to empower everyone to build their own personal homepage in the AI era using OpenDAN.

### 2. Development Based on SourceDAO Contract
We are in the process of developing the OpenDAN's DAO page, which is based on the SourceDAO contract. The future of OpenDAN should be determined by the community.

### 3. Welcoming waterflier as a Core Contributor
We're excited to officially invite waterflier to join as a core contributor to our community. We recognize and appreciate his innovative ideas and deep insights in the realm of Personal AI OS. Waterflier will be spearheading the development of the MVP version. As a key contributor to the CYFS CoreDev Team, he brings extensive experience in the domain of Personal Servers.

## **Intro video - What is OpenDAN?**
Click the image below for a demo:

[![Intro Video](https://github-production-user-asset-6210df.s3.amazonaws.com/126534313/243310994-4d1ece51-b06d-413d-a2ac-ea5099bb6e94.png)](https://www.youtube.com/watch?v=l2QmsIOXhdQ "Intro Video")

## **Demo video - What can OpenDAN do?**
Click the image below for a demo:

[![Demo Video](https://github-production-user-asset-6210df.s3.amazonaws.com/126534313/243309993-cf6abfd5-0a56-420b-ac56-99b18dbd3c5f.png)](https://youtu.be/13wdyoT0VHQ "Demo Video")

<center class="half">
    <img src="https://github.com/fiatrete/OpenDAN-Personal-AI-OS/assets/126534313/a0251e66-67e1-40e8-a05e-54ff8b4cafa2" width="400"/><img src="https://github.com/fiatrete/OpenDAN-Personal-AI-OS/assets/126534313/f36a8d92-c3e5-423f-906c-7bb692bae4d6" width="400"/>
    <img src="https://github.com/fiatrete/OpenDAN-Personal-AI-OS/assets/126534313/b26019c8-27da-49a8-ba8e-8dbae674a4a4" width="400"/><img src="https://github.com/fiatrete/OpenDAN-Personal-AI-OS/assets/126534313/23e2a296-de67-451b-8f4a-422c9844dd23" width="400"/>
    <img src="https://github.com/fiatrete/OpenDAN-Personal-AI-OS/assets/126534313/5661259a-d69a-4923-a864-b05521aef26b" width="400"/><img src="https://github.com/fiatrete/OpenDAN-Personal-AI-OS/assets/126534313/c0ecf73e-6db1-4c06-b948-f5bf75ba440f" width="400"/>
</center>


## **Subscribe to updates here**

https://twitter.com/openDAN_AI

## **Core Features of OpenDAN**

To achieve the goal of OpenDAN, we provide the following key features:

1. **Hardware-specific optimization**: Optimize for specific hardware to enable smooth local running of most open-source AI applications.
2. **Open AI App Marketplace**: Offer a solution for one-click installation and use of various AI applications, helping users easily access and manage AI apps.
3. **Open AI Model Solution**: Provide a unified entry point for model search, download, and access control, making it convenient for users to find and use models suitable for their needs.
4. **Strict Privacy Protection and Management**: Strictly manage personal data, ranging from family albums to chat records and social media records, and provide a unified access control interface for AI applications.
5. **Integrated Tools**: Offer tools for users to train their own voice models, Lora models, knowledge models, etc., using personal data.
6. **AI Butler Assistant**: Driven by a large language model, the AI assistant completes tasks through natural language interaction.
7. **Development Framework**: Provide a development framework for customizing AI assistants for specific purposes, making it easy for developers to create unique AI applications for users.

## **Roadmap**

- [x] Project Initialization
    - [x] Basic code for operating system image packaging script
    - [x] Opendan.ai website homepage
- [x] OpenDAN Prototype Version
    - [x] AI butler assistant driven by GPT-3.5 or GPT-4.0
    - [x] Integration of Stable Diffusion
    - [x] Integration of TTS (Text-to-Speech)
    - [x] Integration of Telegram Chatbot as an interaction entrance
- [ ] OpenDAN 1.0
    - [ ] AI butler assistant's large language model core switched to locally running open-source model
    - [ ] Offer more AI applications through AI App Marketplace
    - [ ] Provide an AI application development framework to support the community in integrating more AI applications
    - [ ] Provide a model management framework

## **Contributing**

We welcome community members to contribute to the project, including but not limited to submitting issues, improving documentation, fixing bugs, or providing new features. You can participate in the contribution through the following ways:

- Submit an Issue in the GitHub repository
- Submit a Pull Request to the repository
- Participate in discussions and development

## **⭐Star History**


[![Star History Chart](https://api.star-history.com/svg?repos=fiatrete/OpenDAN-Personal-AI-Server-OS&type=Date)](https://star-history.com/#fiatrete/OpenDAN-Personal-AI-Server-OS&Date)


## **License**

MIT
