![contribution guidelines](https://i.imgur.com/FaNNcVH.png)

**30 seconds of code** is a community effort, so feel free to contribute in any way you can. Every contribution helps!

Here's what you can do to help:

- Submit [pull requests](https://github.com/nycJSorg/30-seconds-of-angular/pulls) with snippets that you have created (see below for guidelines).
- [Open issues](https://github.com/nycJSorg/30-seconds-of-angular/issues/new) for things you want to see added or modified.
- Be part of the discussion by helping out with [existing issues](https://github.com/nycJSorg/30-seconds-of-angular/issues).
- Fix typos in existing snippets, improve snippet descriptions and explanations or provide better examples.

### Snippet submission and Pull request guidelines

- **DO NOT MODIFY THE README.md!** Make changes to individual snippet files. **Travis CI** will automatically build the `README.md` files when your pull request is merged.
- **Snippet filenames** must correspond to the title of the snippet. For example, if your snippet is titled `title: Awesome Snippet` the filename should be `awesome-snippet.md`.
  - Use `kebab-case`, not `camelCase` or `snake_case`.
  - Avoid capitalization of words, except if the whole word is capitalized (e.g. `URL` should be capitalized in the filename and the snippet title).
- **Snippet level** should be `beginner`, `invermediate` or `advanced`
- **Snippet titles** should briefly describe what the snippet is about
  - Snippet titles must be unique (although if you cannot find a better title, just add some placeholder at the end of the filename and title and we will figure it out).
- **Snippet content** should have a brief description and a code snippet and must not exceed 25 lines
- **Snippet demo** 
  - It's possible to add an interactive demo by adding headers for appropriate files: `#file:app.component.ts`, `#file:app.module.ts`, or `#file:main.ts` headers.   
- Snippets *should* solve real-world problems, no matter how simple.
- Snippets *should* be abstract enough to be applied to different scenarios.
- You can start creating a new snippet, by using the [snippet template](snippet-template.md) to format your snippets.
 
