# 目录
本文档主要使用于PyTorch入门学者，主要参考PyTorch官方文档。
## 第一章：PyTorch之简介与下载
### 1.[PyTorch简介](https://github.com/fendouai/PyTorchDocs/blob/master/FirstSection/PyTorchIntro.md)
### 2.[PyTorch环境搭建](https://github.com/fendouai/PyTorchDocs/blob/master/FirstSection/InstallIutorial.md)

## 第二章：PyTorch之60min入门
### 1.[PyTorch 入门](https://github.com/fendouai/PyTorchDocs/blob/master/SecondSection/what_is_pytorch.md)
### 2.[PyTorch 自动微分](https://github.com/fendouai/PyTorchDocs/blob/master/SecondSection/autograd_automatic_differentiation.md)
### 3.[PyTorch 神经网络](https://github.com/fendouai/PyTorchDocs/blob/master/SecondSection/neural_networks.md)
### 4.[PyTorch 图像分类器](https://github.com/fendouai/PyTorchDocs/blob/master/SecondSection/training_a_classifier.md)
### 5.[PyTorch 数据并行处理](https://github.com/fendouai/PyTorchDocs/blob/master/SecondSection/optional_data_parallelism.md)

## 第三章：PyTorch之入门强化
### 1.[数据加载和处理](https://github.com/fendouai/PyTorchDocs/blob/master/ThirdSection/DataLoding.md)
### 2.[PyTorch小试牛刀](https://github.com/fendouai/PyTorchDocs/blob/master/ThirdSection/LearningPyTorch.md)
### 3.[迁移学习](https://github.com/fendouai/PyTorchDocs/blob/master/ThirdSection/TransferLearning.md)
### 4.[混合前端的seq2seq模型部署](https://github.com/fendouai/PyTorchDocs/blob/master/ThirdSection/DeployingSeq2SeqModelwithHybridFrontend.MD)
### 5.[保存和加载模型](https://github.com/fendouai/PyTorchDocs/blob/master/ThirdSection/SaveModel.md)

## 第四章：PyTorch之图像篇
### 1.[微调基于torchvision 0.3的目标检测模型](https://github.com/fendouai/PyTorchDocs/blob/master/fourSection/ObjectDetectionFinetuning.md)
### 2.[微调TorchVision模型](https://github.com/fendouai/PyTorchDocs/blob/master/fourSection/FinetuningTorchVisionModel.md)
### 3.[空间变换器网络](https://github.com/fendouai/PyTorchDocs/blob/master/fourSection/SpatialTranNet.md)
### 4.[使用PyTorch进行Neural-Transfer](https://github.com/fendouai/PyTorchDocs/blob/master/fourSection/NeuralTransfer.md)
### 5.[生成对抗示例](https://github.com/fendouai/PyTorchDocs/blob/master/fourSection/AdversarialExampleGene.md)
### 6.[使用ONNX将模型转移至Caffe2和移动端](https://github.com/fendouai/PyTorchDocs/blob/master/fourSection/ONNX.md)

## 第五章：PyTorch之文本篇
### 1.[聊天机器人教程](https://github.com/fendouai/PyTorchDocs/blob/master/FifthSection/Chatbot.md)
### 2.[使用字符级RNN生成名字](https://github.com/fendouai/PyTorchDocs/blob/master/FifthSection/Char%20RNN%20Generation.MD)
### 3.[使用字符级RNN进行名字分类](https://github.com/fendouai/PyTorchDocs/blob/master/FifthSection/Char%20RNN%20Classification.md)
### 4.[在深度学习和NLP中使用Pytorch](https://github.com/fendouai/PyTorchDocs/blob/master/FifthSection/DeepLearning%20NLP.md)
### 5.[使用Sequence2Sequence网络和注意力进行翻译](https://github.com/fendouai/PyTorchDocs/blob/master/FifthSection/Translation_S2S%20Network.md)

## 第六章：[PyTorch之深度卷积对抗生成网络](https://github.com/fendouai/PyTorchDocs/blob/master/SixthSection/Dcgan.md)
## 第七章：[PyTorch之强化学习（DQN）教程](https://github.com/fendouai/PyTorchDocs/blob/master/SeventhSection/ReinforcementLearning.md)

## 第八章：在生产中部署PyTorch模型
### 1.[通过带Flask的REST API在Python中部署PyTorch](https://github.com/fendouai/PyTorchDocs/blob/master/EigthSection/Deploying%20PyTorch%20in%20Python%20via%20a%20REST%20APIwith%20Flask.md)
### 2.[TorchScript简介](https://github.com/fendouai/PyTorchDocs/blob/master/EigthSection/torchScript.md)
### 3.[在C++中加载TorchScript模型](https://github.com/fendouai/PyTorchDocs/blob/master/EigthSection/torchScript_in_C%2B%2B.md)

磐创AI 聊天机器人，智能客服：

[http://www.panchuangai.com/](http://www.panchuangai.com/)

磐创教程网站，TensorFlow，Pytorch，Keras：

[http://panchuang.net/](http://panchuang.net/)

魔图互联 知识图谱推荐系统：

[http://motuhulian.com](http://motuhulian.com)

