import { Popover, Tooltip } from 'antd';
import React, { useCallback } from 'react';

import { emojis } from './emojis';

export const Emoji = ({ editor, monaco }) => {
  const insert = useCallback(
    (key) => {
      const result = emojis[key];
      const p = editor.getPosition();
      editor.executeEdits('', [
        {
          range: new monaco.Range(p.lineNumber, p.column, p.lineNumber, p.column),
          text: result,
        },
      ]);
    },
    [editor, monaco]
  );

  return (
    <Popover
      content={
        <ul style={{ width: 300, height: 300, overflow: 'auto', display: 'flex', flexWrap: 'wrap' }}>
          {Object.keys(emojis).map((key) => {
            return (
              <li
                style={{ display: 'inline-flex', padding: 4, fontSize: 16, cursor: 'pointer' }}
                key={key}
                onClick={() => insert(key)}
              >
                {emojis[key]}
              </li>
            );
          })}
        </ul>
      }
      placement="bottom"
      trigger="click"
    >
      <Tooltip title={'插入表情'}>
        <svg viewBox="0 0 1024 1024" width="16px" height="16px">
          <path
            d="M288.92672 400.45568c0 30.80192 24.97024 55.77216 55.77216 55.77216s55.77216-24.97024 55.77216-55.77216c0-30.7968-24.97024-55.76704-55.77216-55.76704s-55.77216 24.97024-55.77216 55.76704z m334.60224 0c0 30.80192 24.97024 55.77216 55.77216 55.77216s55.77216-24.97024 55.77216-55.77216c0-30.7968-24.97024-55.76704-55.77216-55.76704s-55.77216 24.97024-55.77216 55.76704z m-111.5392 362.4704c-78.05952 0-156.13952-39.08096-200.75008-100.3776-16.77312-22.31296-27.84256-50.15552-39.08096-72.45824-5.53472-16.77312 5.5296-33.4592 16.77312-39.08096 16.77312-5.53472 27.84256 5.53472 33.46432 16.768 5.53472 22.30784 16.77312 39.08608 27.84256 55.77728 44.61568 55.76704 100.38272 83.69664 161.664 83.69664 61.30176 0 122.7008-27.84256 156.16-78.07488 11.15136-16.77824 22.30784-38.99904 27.84256-55.77728 5.62176-16.768 22.30784-22.30272 33.4592-16.768 16.768 5.53472 22.30784 22.30272 16.768 33.4592-5.61152 27.84256-22.2976 50.14528-39.08096 72.45824-38.912 61.37856-116.98176 100.3776-195.06176 100.3776z m0 194.51392C268.4928 957.44 66.56 755.52256 66.56 511.99488 66.56 268.48256 268.4928 66.56 511.98976 66.56 755.50208 66.56 957.44 268.48256 957.44 511.99488 957.44 755.52256 755.50208 957.44 511.98976 957.44z m0-831.45728c-213.78048 0-386.00192 172.21632-386.00192 386.01216 0 213.8112 172.22144 386.0224 386.00192 386.0224 213.80096 0 386.0224-172.2112 386.0224-386.0224 0-213.79584-172.22144-386.01216-386.0224-386.01216z"
            fill="currentColor"
          ></path>
        </svg>
      </Tooltip>
    </Popover>
  );
};
