export const Svg = () => {
  return (
    <svg width="800" height="800" viewBox="0 0 800 800" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M800 0H0V800H800V0Z" fill="white" />
      <mask id="mask0" mask-type="alpha" maskUnits="userSpaceOnUse" x="31" y="109" width="739" height="582">
        <path
          d="M727.234 690.135C781.624 521.931 784.134 406.365 734.763 343.437C660.706 249.046 600.092 283.295 424.853 169.535C249.613 55.7748 53.2639 117.327 39.1688 237.149C29.7721 317.031 28.9583 467.8 36.7274 689.458L727.234 690.135Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask0)">
        <path
          d="M727.234 690.135C781.624 521.931 784.134 406.365 734.763 343.437C660.706 249.046 600.092 283.295 424.853 169.535C249.613 55.7748 53.2639 117.327 39.1688 237.149C29.7721 317.031 28.9583 467.8 36.7274 689.458L727.234 690.135Z"
          fill="#F3F9FF"
        />
        <path d="M26.2524 188.93H205.378V689.64H26.2524V188.93Z" fill="url(#paint0_linear)" />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M31.0001 184.236L134.833 210.949V676.849L25.888 691L31.0001 184.236Z"
          fill="#F3F9FF"
        />
        <path
          d="M121.872 414.639C116.854 414.639 112.786 410.573 112.786 405.558C112.786 400.543 116.854 396.478 121.872 396.478C126.891 396.478 130.958 400.543 130.958 405.558C130.958 410.573 126.891 414.639 121.872 414.639Z"
          fill="#A7CCFF"
        />
        <path d="M25.808 169.535H224.836V691H25.808V169.535Z" stroke="#80B6FF" strokeWidth="1.1" />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M285.558 255.096C272.068 261.655 261.537 260.726 253.965 252.309C242.607 239.684 247.162 227.04 258.718 221.331C270.274 215.621 270.274 208.219 276.012 198.519C281.749 188.819 306.068 182.507 314.47 199.667C319.064 200.448 321.596 205.009 322.064 213.352C323.116 220.121 326.675 224.958 332.741 227.866C341.84 232.226 342.5 250.769 324.853 248.179C328.032 265.562 322.065 274.254 306.951 274.254C291.836 274.254 284.706 267.868 285.558 255.096Z"
          fill="#903032"
        />
        <mask id="mask1" mask-type="alpha" maskUnits="userSpaceOnUse" x="215" y="257" width="193" height="136">
          <path
            d="M278.656 257.142C258.965 264.838 247.224 269.915 243.433 272.371C237.746 276.055 222.618 327.848 217.56 345.655C212.501 363.462 214.838 381.414 226.078 383.419C233.571 384.756 244.944 383.208 260.196 378.773V392.395H335.597L332.703 328.449C340.373 347.975 346.727 359.097 351.766 361.815C356.805 364.533 375.477 364.897 407.781 362.906V337.77H369.459C364.945 337.77 344.208 283.183 339.013 274.253C335.55 268.3 322.88 263.037 301.004 258.464L278.656 257.142ZM255.139 319.047L260.136 352.083L243.182 353.797L255.139 319.047Z"
            fill="white"
          />
        </mask>
        <g mask="url(#mask1)">
          <path
            d="M278.656 257.142C258.965 264.838 247.224 269.915 243.433 272.371C237.746 276.055 222.618 327.848 217.56 345.655C212.501 363.462 214.838 381.414 226.078 383.419C233.571 384.756 244.944 383.208 260.196 378.773V392.395H335.597L332.703 328.449C340.373 347.975 346.727 359.097 351.766 361.815C356.805 364.533 375.477 364.897 407.781 362.906V337.77H369.459C364.945 337.77 344.208 283.183 339.013 274.253C335.55 268.3 322.88 263.037 301.004 258.464L278.656 257.142ZM255.139 319.047L260.136 352.083L243.182 353.797L255.139 319.047Z"
            fill="#006A86"
          />
          <path d="M324.187 296.677L332.049 329.317" stroke="#053947" />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M295.174 324.171C295.174 310.968 281.443 283.531 277.046 267.517C275.53 261.998 276.506 258.235 279.973 256.228C290.553 252.402 297.122 253.059 299.68 258.2C306.332 265.187 310.55 270.538 312.336 274.253C316.383 282.674 318.26 291.624 320.266 295.422C326.578 307.375 331.794 313.189 333.009 319.239C333.589 322.128 332.249 326.486 330.864 329.922C325.973 342.057 324.713 362.882 327.084 392.395H295.174C292.52 388.497 291.193 381.539 291.193 371.524C291.193 356.5 295.174 337.374 295.174 324.171Z"
            fill="#D2F6FF"
          />
          <path d="M369.459 337.77L361.547 344.672" stroke="#053947" />
        </g>
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M407.782 343.443C412.46 343.991 415.167 343.913 415.902 343.21C417.005 342.155 423.35 336.528 423.986 336.016C424.41 335.674 427.639 334.342 433.676 332.019C434.555 333.25 434.667 334.582 434.01 336.016C433.704 336.683 431.923 337.78 428.668 339.307L426.237 342.461H453.147C455.27 342.496 456.331 343.059 456.331 344.149C456.331 345.24 455.27 345.785 453.147 345.785L442.742 347.495L454.928 347.89C456.779 348.138 457.704 348.689 457.704 349.543C457.704 350.396 456.779 350.911 454.928 351.087L442.278 352.988L452.386 353.276C453.567 353.382 454.157 353.926 454.157 354.908C454.157 355.889 453.567 356.379 452.386 356.379L441.362 357.738L448.661 358.706C449.632 358.953 450.117 359.444 450.117 360.18C450.117 360.916 449.632 361.284 448.661 361.284C439.473 362.497 432.946 363.017 429.08 362.846C423.282 362.588 418.743 362.157 413.678 359.732H407.782V343.443Z"
          fill="#FFA990"
        />
        <path d="M448.059 346.67L440.24 347.826" stroke="#4C1819" />
        <path d="M447.48 352.259L440.24 353.293" stroke="#4C1819" />
        <path d="M446.263 357.164L440.24 357.738" stroke="#4C1819" />
        <path d="M439.64 345.448C440.636 350.614 440.551 355.453 439.386 359.963" stroke="#4C1819" />
        <path
          d="M425.744 358.683C429.707 353.563 429.707 348.814 425.744 344.436C424.153 349.444 421.047 351.74 416.427 351.323"
          stroke="#4C1819"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M287.56 351.745C293.798 347.868 297.119 345.835 297.523 345.645C297.834 345.5 300.596 344.871 305.217 343.292C306.141 342.976 307.622 342.36 309.66 341.443C310.54 343.256 310.54 344.752 309.66 345.929C308.781 347.107 306.339 348.252 302.335 349.364H320.591H325.641C327.082 349.364 327.802 349.797 327.802 350.665C327.802 351.533 327.082 352.11 325.641 352.397L315.981 354.405L328.842 355.166C330.19 355.293 330.864 355.875 330.864 356.913C330.864 357.95 330.19 358.527 328.842 358.644L314.765 360.141L325.641 360.919C326.94 361.023 327.59 361.572 327.59 362.566C327.59 363.56 326.94 364.094 325.641 364.168L313.363 364.825L321.531 366.812C322.588 367.123 323.117 367.607 323.117 368.264C323.117 368.922 322.588 369.234 321.531 369.202C313.209 369.202 308.013 369.202 305.942 369.202C303.871 369.202 297.744 368.51 287.56 367.126L283.557 368.285V352.905L287.56 351.745Z"
          fill="#FFA990"
        />
        <path d="M303.685 348.953C303.685 348.953 302.648 349.302 300.574 350" stroke="#4C1819" />
        <path d="M321.778 354.847L313.225 354.2" stroke="#4C1819" />
        <path d="M320.047 360.503L313.225 359.982" stroke="#4C1819" />
        <path d="M316.955 366.089L312.2 364.386" stroke="#4C1819" />
        <path
          d="M226.721 369.205C226.721 364.848 229.269 360.221 234.365 355.324L283.557 350V369.205L260.196 378.773"
          stroke="#053947"
        />
        <mask id="mask2" mask-type="alpha" maskUnits="userSpaceOnUse" x="278" y="203" width="43" height="87">
          <path
            d="M291.36 245.041C293.407 234.733 286.37 228.588 281.735 224.448C279.529 222.478 279.212 217.352 282.551 216.96C284.777 216.699 286.502 217.439 287.727 219.18C294.016 217.963 298.897 216.561 302.372 214.975C305.846 213.389 309.715 209.497 313.979 203.3C315.436 204.532 316.45 205.583 317.02 206.453C317.905 207.805 318.535 208.718 319.237 211.307C320.557 216.387 323.643 248.532 304.679 247.146C301.421 253.489 300.305 258.133 301.332 261.079C302.871 265.497 313.783 277.485 310.759 285.722C307.735 293.96 291.454 289.302 285.313 277.372C281.22 269.418 279 262.675 278.656 257.142C285.761 255.946 289.995 251.912 291.36 245.041Z"
            fill="white"
          />
        </mask>
        <g mask="url(#mask2)">
          <path
            d="M291.36 245.041C293.407 234.733 286.37 228.588 281.735 224.448C279.529 222.478 279.212 217.352 282.551 216.96C284.777 216.699 286.502 217.439 287.727 219.18C294.016 217.963 298.897 216.561 302.372 214.975C305.846 213.389 309.715 209.497 313.979 203.3C315.436 204.532 316.45 205.583 317.02 206.453C317.905 207.805 318.535 208.718 319.237 211.307C320.557 216.387 323.643 248.532 304.679 247.146C301.421 253.489 300.305 258.133 301.332 261.079C302.871 265.497 313.783 277.485 310.759 285.722C307.735 293.96 291.454 289.302 285.313 277.372C281.22 269.418 279 262.675 278.656 257.142C285.761 255.946 289.995 251.912 291.36 245.041Z"
            fill="#FFA990"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M304.679 247.146C301.2 245.882 298.096 244.197 295.367 242.089C296.337 254.768 299.441 262.433 304.679 265.086C309.917 267.739 309.917 261.759 304.679 247.146Z"
            fill="#E79279"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M315.537 236.209C315.537 236.209 312.633 236.209 306.825 236.209C307.546 238.387 309.071 239.475 311.402 239.475C314.897 239.475 315.537 236.209 315.537 236.209Z"
            fill="white"
          />
          <path
            d="M312.288 223.407C314.795 228.563 316.049 231.559 316.049 232.393C316.049 233.228 314.012 233.446 309.939 233.047"
            stroke="#4C1819"
          />
          <path
            d="M306.339 223.013C305.698 223.013 305.178 222.494 305.178 221.853C305.178 221.213 305.698 220.694 306.339 220.694C306.98 220.694 307.499 221.213 307.499 221.853C307.499 222.494 306.98 223.013 306.339 223.013Z"
            fill="#4C1819"
          />
          <path
            d="M317.945 223.013C317.304 223.013 316.784 222.494 316.784 221.853C316.784 221.213 317.304 220.694 317.945 220.694C318.586 220.694 319.105 221.213 319.105 221.853C319.105 222.494 318.586 223.013 317.945 223.013Z"
            fill="#4C1819"
          />
          <path d="M319.105 215.79C319.105 215.79 317.566 214.731 314.373 215.79" stroke="#4C1819" />
          <path d="M309.055 216.135C306.955 214.95 304.599 215.085 301.987 216.538" stroke="#4C1819" />
          <path d="M313.528 202.719C310.604 213.359 302.002 218.846 287.724 219.18" stroke="#903032" />
        </g>
        <path
          d="M318.671 226.704C316.108 226.704 314.029 224.627 314.029 222.066C314.029 219.504 316.108 217.427 318.671 217.427C321.235 217.427 323.314 219.504 323.314 222.066C323.314 224.627 321.235 226.704 318.671 226.704Z"
          stroke="white"
        />
        <path
          d="M305.905 226.704C303.341 226.704 301.262 224.627 301.262 222.066C301.262 219.504 303.341 217.427 305.905 217.427C308.469 217.427 310.547 219.504 310.547 222.066C310.547 224.627 308.469 226.704 305.905 226.704Z"
          stroke="white"
        />
        <path d="M314.029 222.066H310.547" stroke="white" />
        <path d="M301.262 222.066L287.725 218.795" stroke="white" />
        <path
          d="M291.26 190.029C282.33 190.029 275.345 195.132 270.307 205.338C262.75 220.646 256.624 217.908 250.235 224.383C243.847 230.858 244.006 245.016 254.732 251.725"
          stroke="#903032"
        />
        <path
          d="M320.266 206.707C322.265 217.222 326.258 223.888 332.246 226.704C341.228 230.928 342.768 238.654 335.639 245.19"
          stroke="#903032"
        />
        <path
          d="M281.811 225.318C281.811 225.948 297.315 235.434 291.261 249.543C285.206 263.653 252.789 262.637 252.789 246.587"
          stroke="#903032"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M785.014 386.101H176.681V396.478H785.014V386.101Z"
          fill="#5EA4EC"
        />
        <mask id="mask3" mask-type="alpha" maskUnits="userSpaceOnUse" x="190" y="396" width="596" height="294">
          <path d="M785.014 396.478H190.526V689.219H785.014V396.478Z" fill="white" />
        </mask>
        <g mask="url(#mask3)">
          <path d="M785.014 396.478H190.526V689.219H785.014V396.478Z" fill="#F3F9FF" />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M785.014 448.365H335.038V689.64H785.014V448.365Z"
            stroke="#D1E7FF"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M785.014 474.309H360.998V715.583H785.014V474.309Z"
            stroke="#D1E7FF"
          />
        </g>
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M298.694 396.478H190.526V689.219H298.694V396.478Z"
          fill="#D1E7FF"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M785.014 396.478H190.526V406.855H785.014V396.478Z"
          fill="#4E94DD"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M298.694 386.101H176.681V396.478H298.694V386.101Z"
          fill="#4181C4"
        />
        <path d="M325.448 650.068C320.772 620.751 307.332 588.713 285.129 553.956" stroke="#AAC9F1" />
        <path d="M328.965 650.068C328.434 606.605 322.299 574.915 310.558 555" stroke="#AAC9F1" />
        <path d="M328.966 648.276C331.302 607.322 334.73 576.876 339.251 556.94" stroke="#AAC9F1" />
        <path d="M330.794 650.068C327.147 635.111 338.561 612.684 365.036 582.786" stroke="#AAC9F1" />
        <mask id="mask4" mask-type="alpha" maskUnits="userSpaceOnUse" x="162" y="489" width="142" height="98">
          <path
            d="M303.777 586.668C279.868 524.928 232.808 492.443 162.597 489.213C175.418 499.274 183.854 506.633 187.903 511.29C197.271 522.065 200.334 533.004 203.74 533.959L217.487 536.153C227.252 548.717 235.73 555 242.923 555C253.25 562.89 263.622 567.335 274.041 568.333C284.459 569.332 294.371 575.444 303.777 586.668Z"
            fill="white"
          />
        </mask>
        <g mask="url(#mask4)">
          <path
            d="M303.777 586.668C279.868 524.928 232.808 492.443 162.597 489.213C175.418 499.274 183.854 506.633 187.903 511.29C197.271 522.065 200.334 533.004 203.74 533.959L217.487 536.153C227.252 548.717 235.73 555 242.923 555C253.25 562.89 263.622 567.335 274.041 568.333C284.459 569.332 294.371 575.444 303.777 586.668Z"
            fill="#E4F0FF"
          />
          <path d="M293.609 564.054C291.965 564.054 275.572 545.945 242.923 554.999" stroke="#F1F7FF" />
          <path d="M277.261 536.194C251.14 527.676 229.435 528.258 212.147 537.94" stroke="#F1F7FF" />
          <path d="M257.903 517.442C257.903 517.442 215.876 492.639 169.255 502.694" stroke="#F1F7FF" />
        </g>
        <mask id="mask5" mask-type="alpha" maskUnits="userSpaceOnUse" x="323" y="426" width="46" height="150">
          <path
            d="M335.552 575.849C349.649 565.637 357.942 553.001 360.431 537.941C364.166 515.35 369.218 520.21 366.692 503.421C364.166 486.632 360.255 477.392 366.692 459.655C373.128 441.918 360.431 433.509 360.431 426.745C353.031 432.036 347.995 440.849 345.324 453.182C341.316 471.683 332.107 482.936 330.148 492.117C328.188 501.297 331.317 514.287 327.154 519.828C322.991 525.369 321.752 533.426 327.154 549.652C330.755 560.47 333.554 569.202 335.552 575.849Z"
            fill="white"
          />
        </mask>
        <g mask="url(#mask5)">
          <path
            d="M335.552 575.849C349.649 565.637 357.942 553.001 360.431 537.941C364.166 515.35 369.218 520.21 366.692 503.421C364.166 486.632 360.255 477.392 366.692 459.655C373.128 441.918 360.431 433.509 360.431 426.745C353.031 432.036 347.995 440.849 345.324 453.182C341.316 471.683 332.107 482.936 330.148 492.117C328.188 501.297 331.317 514.287 327.154 519.828C322.991 525.369 321.752 533.426 327.154 549.652C330.755 560.47 333.554 569.202 335.552 575.849Z"
            fill="#E4F0FF"
          />
          <path
            d="M360.431 426.745C355.323 448.255 352.769 463.515 352.769 472.527C352.769 486.045 353.211 496.288 347.584 515.857C343.832 528.902 339.822 548.9 335.552 575.849"
            stroke="white"
          />
        </g>
        <mask id="mask6" mask-type="alpha" maskUnits="userSpaceOnUse" x="339" y="491" width="107" height="126">
          <path
            d="M339.251 616.675C356.579 549.516 392.075 507.703 445.738 491.236C447.211 504.373 440.713 516.075 426.244 526.343C432.687 538.475 425.503 548.573 404.694 556.639C397.66 560.369 391.491 568.46 386.188 580.911C380.884 593.362 365.239 605.283 339.251 616.675Z"
            fill="white"
          />
        </mask>
        <g mask="url(#mask6)">
          <path
            d="M339.251 616.675C356.579 549.516 392.075 507.703 445.738 491.236C447.211 504.373 440.713 516.075 426.244 526.343C432.687 538.475 425.503 548.573 404.694 556.639C397.66 560.369 391.491 568.46 386.188 580.911C380.884 593.362 365.239 605.283 339.251 616.675Z"
            fill="#B6D6FF"
          />
          <path d="M344.282 597.839L377.713 595.335" stroke="#C3DDFF" />
          <path d="M351.136 579.966L395.233 573.559" stroke="#C3DDFF" />
          <path d="M360.998 559.718L409.982 555" stroke="#C3DDFF" />
          <path d="M375.067 537.941C402.574 531.66 421.806 527.389 432.764 525.126" stroke="#C3DDFF" />
        </g>
        <mask id="mask7" mask-type="alpha" maskUnits="userSpaceOnUse" x="269" y="470" width="55" height="110">
          <path
            d="M320.915 579.966C324.628 568.455 323.754 560.133 318.29 555C314.617 550.089 313.729 543.317 315.626 534.685C318.472 521.736 308.824 517.068 303.777 509.183C303.207 500.38 299.851 494.674 293.71 492.065C287.568 489.456 282.085 482.196 277.261 470.287C266.295 488.141 266.295 501.745 277.261 511.097C278.73 521.204 282.241 528.852 287.792 534.042C296.12 541.827 291.3 546.474 293.71 553.956C295.317 558.943 304.385 567.613 320.915 579.966Z"
            fill="white"
          />
        </mask>
        <g mask="url(#mask7)">
          <path
            d="M320.915 579.966C324.628 568.455 323.754 560.133 318.29 555C314.617 550.089 313.729 543.317 315.626 534.685C318.472 521.736 308.824 517.068 303.777 509.183C303.207 500.38 299.851 494.674 293.71 492.065C287.568 489.456 282.085 482.196 277.261 470.287C266.295 488.141 266.295 501.745 277.261 511.097C278.73 521.204 282.241 528.852 287.792 534.042C296.12 541.827 291.3 546.474 293.71 553.956C295.317 558.943 304.385 567.613 320.915 579.966Z"
            fill="#B6D6FF"
          />
          <path
            d="M277.261 470.287C279.831 481.708 281.889 489.622 283.436 494.028C288.164 507.495 293.397 516.094 296.103 522.685C309.39 555.05 319.706 574.207 320.915 579.966"
            stroke="white"
          />
        </g>
        <mask id="mask8" mask-type="alpha" maskUnits="userSpaceOnUse" x="301" y="636" width="53" height="53">
          <path d="M353.864 636.542H301.189L306.734 688.801H348.319L353.864 636.542Z" fill="white" />
        </mask>
        <g mask="url(#mask8)">
          <path d="M353.864 636.542H301.189L306.734 688.801H348.319L353.864 636.542Z" fill="#72A7DE" />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M301.189 644.185L355.381 659.85V642.414L301.189 644.185Z"
            fill="#4580BD"
          />
        </g>
        <path d="M295.645 628.24H359.408V644.844H295.645V628.24Z" fill="#4E94DD" />
        <path d="M224.836 169.535L206.066 190.248" stroke="#80B6FF" />
        <path d="M32.9626 235.789L105.285 250.642V638.162L40.2603 642.809" stroke="#A7CCFF" strokeWidth="8" />
      </g>
      <path
        d="M734.953 530.193V443C734.953 429.193 723.76 418 709.953 418H686.144C672.336 418 661.144 429.193 661.144 443V530.193"
        stroke="#B4B4B4"
        strokeWidth="5"
      />
      <path
        d="M726.397 668.161C726.397 664.826 729.1 662.123 732.435 662.123C735.77 662.123 738.473 664.826 738.473 668.161V684.471C738.473 687.806 735.77 690.509 732.435 690.509C729.1 690.509 726.397 687.806 726.397 684.471V668.161Z"
        fill="#38372D"
      />
      <path
        d="M657.389 668.161C657.389 664.826 660.093 662.123 663.428 662.123C666.762 662.123 669.466 664.826 669.466 668.161V684.471C669.466 687.806 666.762 690.509 663.428 690.509C660.093 690.509 657.389 687.806 657.389 684.471V668.161Z"
        fill="#38372D"
      />
      <mask id="mask9" mask-type="alpha" maskUnits="userSpaceOnUse" x="641" y="516" width="113" height="163">
        <path
          d="M665 516.752H730C743.255 516.752 754 527.497 754 540.752V654.466C754 667.721 743.255 678.466 730 678.466H665C651.745 678.466 641 667.721 641 654.466V540.752C641 527.497 651.745 516.752 665 516.752Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask9)">
        <path
          d="M665 516.752H730C743.255 516.752 754 527.497 754 540.752V654.466C754 667.721 743.255 678.466 730 678.466H665C651.745 678.466 641 667.721 641 654.466V540.752C641 527.497 651.745 516.752 665 516.752Z"
          fill="#E38F00"
        />
        <path
          d="M661.55 520.193H726.55C739.804 520.193 750.55 530.938 750.55 544.193V657.907C750.55 671.162 739.804 681.907 726.55 681.907H661.55C648.295 681.907 637.55 671.162 637.55 657.907V544.193C637.55 530.938 648.295 520.193 661.55 520.193Z"
          fill="#F5B315"
        />
        <path
          d="M678.252 545.138H716.748C727.794 545.138 736.748 554.092 736.748 565.138V637.822C736.748 648.868 727.794 657.822 716.748 657.822H678.252C667.206 657.822 658.252 648.868 658.252 637.822V565.138C658.252 554.092 667.206 545.138 678.252 545.138Z"
          fill="#E38F00"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M713.298 548.579H674.801C663.756 548.579 654.801 557.533 654.801 568.579V636.962C654.801 648.008 663.756 656.962 674.801 656.962H713.298C724.343 656.962 733.298 648.008 733.298 636.962V568.579C733.298 557.533 724.343 548.579 713.298 548.579Z"
          fill="#F5B315"
        />
        <path
          d="M682.954 569.223H712.046C714.255 569.223 716.046 571.014 716.046 573.223V577.266C716.046 579.475 714.255 581.266 712.046 581.266H682.954C680.745 581.266 678.954 579.475 678.954 577.266V573.223C678.954 571.014 680.745 569.223 682.954 569.223Z"
          fill="white"
        />
      </g>
      <path d="M720.403 419.268H675.693" stroke="#56565F" strokeWidth="11" strokeLinecap="round" />
      <mask id="mask10" mask-type="alpha" maskUnits="userSpaceOnUse" x="504" y="645" width="63" height="44">
        <path
          d="M564.497 645.945L566.497 688.678H556.441V681.781L544.067 688.678H504.324C503.632 685.1 505.089 682.331 508.696 680.37C512.304 678.409 524.604 673.149 545.599 664.588L543.599 645.945H564.497Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask10)">
        <path
          d="M564.497 645.945L566.497 688.678H556.441V681.781L544.067 688.678H504.324C503.632 685.1 505.089 682.331 508.696 680.37C512.304 678.409 524.604 673.149 545.599 664.588L543.599 645.945H564.497Z"
          fill="#FFA990"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M566.497 661.964C559.998 667.408 553.178 671.014 546.038 672.781C542.556 673.245 540.241 671.107 539.092 666.369L502.603 680.426L501.145 691.252L567.793 690.412V661.964H566.497Z"
          fill="#201F1D"
        />
      </g>
      <mask id="mask11" mask-type="alpha" maskUnits="userSpaceOnUse" x="558" y="645" width="63" height="44">
        <path
          d="M620.497 645.945V688.678H610.441V681.781L598.067 688.678H558.324C557.632 685.1 559.089 682.331 562.696 680.37C566.304 678.409 578.604 673.149 599.599 664.588V645.945H620.497Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask11)">
        <path
          d="M620.497 645.945V688.678H610.441V681.781L598.067 688.678H558.324C557.632 685.1 559.089 682.331 562.696 680.37C566.304 678.409 578.604 673.149 599.599 664.588V645.945H620.497Z"
          fill="#FFA990"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M620.497 661.964C613.998 667.408 607.178 671.014 600.038 672.781C596.556 673.245 594.241 671.107 593.092 666.369L556.603 680.426L555.145 691.252L621.793 690.412V661.964H620.497Z"
          fill="#201F1D"
        />
      </g>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M630.355 382.404C635.949 394.861 637.348 410.394 634.551 429C631.754 447.607 629.319 521.647 627.246 651.122H590.521L581.804 456.857L564.527 506.497L573.282 651.122H534.368C524.055 557.616 519.494 504.87 520.686 492.885C521.878 480.9 533.664 444.073 556.045 382.404H630.355Z"
        fill="#222942"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M638.294 404.607L625.908 319.303L645.296 322.862C644.728 291.752 641.305 273.814 635.026 269.046C629.9 265.154 617.651 261.424 598.279 257.857C570.418 259.372 554.492 261.199 550.503 263.337C546.513 265.476 533.283 277.368 510.813 299.015L534.303 327.647L543.839 320C544.463 376.404 544.775 404.607 544.775 404.607C544.775 404.607 575.948 404.607 638.294 404.607Z"
        fill="#13BB84"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M559.366 324.995L546.366 335.334C582.296 361.263 604.027 373.066 611.556 370.743C619.086 368.42 628.655 351.999 640.262 321.48L612.652 315.405L603.21 343.311L559.366 324.995Z"
        fill="#FFA990"
      />
      <path d="M544.285 299.613L544.285 361.749" stroke="#052043" strokeWidth="0.935714" />
      <mask id="mask12" mask-type="alpha" maskUnits="userSpaceOnUse" x="418" y="246" width="115" height="100">
        <path
          d="M532.313 324.939L512.793 301.159L494.838 313.486C480.321 302.732 470.33 294.208 464.865 287.912C455.205 276.785 451.754 269.027 450.988 268.156C448.864 265.741 448.864 262.839 444.327 260.038C442.269 258.767 439.913 255.396 438.705 253.045C437.899 251.477 437.227 249.321 436.69 246.576C434.194 247.035 432.946 248.592 432.946 251.248C432.946 253.904 433.771 256.963 435.421 260.425C426.551 259.668 421.632 259.538 420.665 260.038C419.214 260.787 417.674 263.709 420.404 265.741C418.748 267.646 418.953 269.291 421.019 270.675C420.352 273.224 420.937 274.856 422.774 275.573C422.298 276.938 422.694 278.077 423.964 278.99C425.868 280.359 426.537 281.671 440.241 282.334C447.928 296.664 454.062 307.048 458.646 313.486C477.596 340.102 485.609 346.897 493.131 345.225C499.964 343.705 513.025 336.944 532.313 324.939Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask12)">
        <path
          d="M532.313 324.939L512.793 301.159L494.838 313.486C480.321 302.732 470.33 294.208 464.865 287.912C455.205 276.785 451.754 269.027 450.988 268.156C448.864 265.741 448.864 262.839 444.327 260.038C442.269 258.767 439.913 255.396 438.705 253.045C437.899 251.477 437.227 249.321 436.69 246.576C434.194 247.035 432.946 248.592 432.946 251.248C432.946 253.904 433.771 256.963 435.421 260.425C426.551 259.668 421.632 259.538 420.665 260.038C419.214 260.787 417.674 263.709 420.404 265.741C418.748 267.646 418.953 269.291 421.019 270.675C420.352 273.224 420.937 274.856 422.774 275.573C422.298 276.938 422.694 278.077 423.964 278.99C425.868 280.359 426.537 281.671 440.241 282.334C447.928 296.664 454.062 307.048 458.646 313.486C477.596 340.102 485.609 346.897 493.131 345.225C499.964 343.705 513.025 336.944 532.313 324.939Z"
          fill="#FFA990"
        />
        <path
          d="M419.553 265.427C422.717 265.579 426.083 265.655 429.649 265.655C435 265.655 436.003 260.881 429.649 260.881"
          stroke="#4C1819"
          strokeWidth="0.857738"
        />
        <path
          d="M419.227 270.082C426.244 270.764 430.509 270.976 432.021 270.718C434.289 270.329 435.562 267.016 431.409 265.311"
          stroke="#4C1819"
          strokeWidth="0.857738"
        />
        <path
          d="M421.277 274.917C427.385 274.977 431 275.006 432.122 275.006C433.806 275.006 435.661 271.833 432.021 270.718"
          stroke="#4C1819"
          strokeWidth="0.857738"
        />
        <path
          d="M423.964 278.99C429.344 279.611 432.506 279.648 433.449 279.102C434.863 278.283 434.687 275.474 432.586 274.917"
          stroke="#4C1819"
          strokeWidth="0.857738"
        />
        <path
          d="M434.046 262.222L435.421 262.065C434.686 268.723 437.029 273.377 442.449 276.027"
          stroke="#4C1819"
          strokeWidth="0.857738"
        />
      </g>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M559.838 325.177C553.334 320.219 549.838 317.612 549.35 317.356C546.502 315.863 545.462 313.154 540.222 312.165C537.846 311.716 534.439 309.412 532.468 307.651C531.154 306.476 529.754 304.704 528.269 302.333C526.103 303.657 525.496 305.558 526.448 308.037C527.4 310.517 529.266 313.077 532.047 315.718C523.494 318.189 518.856 319.832 518.132 320.644C517.046 321.863 516.656 325.143 519.932 326.062C519.069 328.434 519.85 329.896 522.275 330.448C522.566 333.066 523.697 334.381 525.669 334.392C525.713 335.837 526.491 336.758 528.004 337.155C530.272 337.752 531.367 338.736 544.398 334.444C545.994 335.465 548.282 336.943 551.265 338.878L559.838 325.177Z"
        fill="#FFA990"
      />
      <path
        d="M534.126 315.173C524.049 318.035 518.769 319.787 518.287 320.43C517.563 321.395 515.795 324.569 519.932 326.062C518.997 328.264 519.807 329.784 522.362 330.622C522.731 332.838 523.859 334.066 525.746 334.305C525.96 336.965 528.179 338.065 532.404 337.604"
        stroke="#4C1819"
        strokeWidth="0.857738"
      />
      <path d="M645.297 322.436L612.444 315.145L603.124 342.617" stroke="#052043" strokeWidth="0.935714" />
      <path d="M613.876 294.705L612.443 315.145" stroke="#052043" strokeWidth="0.935714" />
      <path
        d="M532.047 315.718C525.765 308.828 524.506 304.366 528.269 302.333"
        stroke="#4C1819"
        strokeWidth="0.857738"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M556.954 211.038C552.816 201.985 553.301 197.078 558.409 196.315C557.478 191.459 559.374 188.319 564.095 186.896C571.176 184.761 601.322 178.853 603.172 194.37C611.272 195.406 613.432 203.437 609.651 218.462C605.038 231.653 600.164 239.497 595.028 241.995C589.892 244.493 577.201 234.174 556.954 211.038Z"
        fill="#30150D"
      />
      <mask id="mask13" mask-type="alpha" maskUnits="userSpaceOnUse" x="557" y="199" width="45" height="79">
        <path
          d="M593.998 227.34C600.172 222.939 599.217 215.763 594.707 215.763C590.197 215.763 590.873 224.672 589.788 224.526C589.066 224.429 588.861 222.711 589.174 219.374C586.909 218.674 585.582 216.437 585.194 212.664C572.059 212.106 564.865 207.595 563.615 199.13C561.453 201.667 559.669 203.143 558.262 203.557C556.898 220.097 557.188 231.688 559.133 238.328C561.534 246.525 564.391 247.782 574.293 246.364C576.078 253.519 575.798 258.303 573.453 260.716C569.935 264.336 563.717 273.924 575.373 276.944C583.144 278.958 591.929 272.948 601.727 258.914L593.998 227.34Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask13)">
        <path
          d="M593.998 227.34C600.172 222.939 599.217 215.763 594.707 215.763C590.197 215.763 590.873 224.672 589.788 224.526C589.066 224.429 588.861 222.711 589.174 219.374C586.909 218.674 585.582 216.437 585.194 212.664C572.059 212.106 564.865 207.595 563.615 199.13C561.453 201.667 559.669 203.143 558.262 203.557C556.898 220.097 557.188 231.688 559.133 238.328C561.534 246.525 564.391 247.782 574.293 246.364C576.078 253.519 575.798 258.303 573.453 260.716C569.935 264.336 563.717 273.924 575.373 276.944C583.144 278.958 591.929 272.948 601.727 258.914L593.998 227.34Z"
          fill="#FFA990"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M567.184 246.783C574.162 247.057 579.67 244.745 583.706 239.848C582.29 252.473 578.277 260.6 571.668 264.227C565.058 267.855 563.563 262.04 567.184 246.783Z"
          fill="#E79279"
        />
        <path
          d="M562.342 218.708C560.158 224.592 559.513 227.842 560.408 228.459C561.304 229.077 562.739 229.236 564.714 228.937"
          stroke="#4C1819"
          strokeWidth="0.982499"
        />
        <path
          d="M559.417 219.684C560.046 219.684 560.557 219.174 560.557 218.544C560.557 217.915 560.046 217.405 559.417 217.405C558.787 217.405 558.276 217.915 558.276 218.544C558.276 219.174 558.787 219.684 559.417 219.684Z"
          fill="#4C1819"
        />
        <path
          d="M568.855 219.684C569.485 219.684 569.995 219.174 569.995 218.544C569.995 217.915 569.485 217.405 568.855 217.405C568.225 217.405 567.714 217.915 567.714 218.544C567.714 219.174 568.225 219.684 568.855 219.684Z"
          fill="#4C1819"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M563.731 238.43C561.551 238.43 559.986 237.117 559.035 234.491C560.668 234.955 562.085 235.186 563.286 235.186C564.488 235.186 566.211 234.955 568.456 234.491C567.486 237.117 565.911 238.43 563.731 238.43Z"
          fill="white"
        />
        <path
          d="M566.555 214.23C569.061 213.063 571.414 213.242 573.614 214.767"
          stroke="#4C1819"
          strokeWidth="0.982499"
        />
        <path
          d="M558.276 214.119C559.437 213.394 560.801 213.511 562.366 214.469"
          stroke="#4C1819"
          strokeWidth="0.982499"
        />
      </g>
      <g filter="url(#filter0_d)">
        <path
          d="M528.7 105H362.3C358.821 105 356 107.821 356 111.3V191.934C356 195.414 358.821 198.234 362.3 198.234H490.356L521.593 221V198.234H528.7C532.179 198.234 535 195.414 535 191.934V111.3C535 107.821 532.179 105 528.7 105Z"
          fill="black"
        />
      </g>
      <path
        d="M528.7 105H362.3C358.821 105 356 107.821 356 111.3V191.934C356 195.414 358.821 198.234 362.3 198.234H490.356L521.593 221V198.234H528.7C532.179 198.234 535 195.414 535 191.934V111.3C535 107.821 532.179 105 528.7 105Z"
        fill="white"
      />
      <mask id="mask14" mask-type="alpha" maskUnits="userSpaceOnUse" x="413" y="73" width="60" height="60">
        <path
          d="M443 133C459.569 133 473 119.569 473 103C473 86.4315 459.569 73 443 73C426.431 73 413 86.4315 413 103C413 119.569 426.431 133 443 133Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask14)">
        <g filter="url(#filter1_d)">
          <path
            d="M443 133C459.569 133 473 119.569 473 103C473 86.4315 459.569 73 443 73C426.431 73 413 86.4315 413 103C413 119.569 426.431 133 443 133Z"
            fill="black"
          />
        </g>
        <path
          d="M443 133C459.569 133 473 119.569 473 103C473 86.4315 459.569 73 443 73C426.431 73 413 86.4315 413 103C413 119.569 426.431 133 443 133Z"
          fill="#4A92E0"
        />
        <mask id="mask15" mask-type="alpha" maskUnits="userSpaceOnUse" x="428" y="78" width="25" height="23">
          <path
            d="M432.321 96.2588C428.932 92.7794 428.125 90.2514 429.901 88.6748C427.794 86.6112 431.42 74.7111 447.109 80.5162C449.345 80.7185 450.843 81.6997 451.602 83.4599C453.766 88.4777 452.774 94.0379 448.624 100.14L432.321 96.2588Z"
            fill="white"
          />
        </mask>
        <g mask="url(#mask15)">
          <path
            d="M432.321 96.2588C428.932 92.7794 428.125 90.2514 429.901 88.6748C427.794 86.6112 431.42 74.7111 447.109 80.5162C449.345 80.7185 450.843 81.6997 451.602 83.4599C453.766 88.4777 452.774 94.0379 448.624 100.14L432.321 96.2588Z"
            fill="#3D2423"
          />
        </g>
        <mask id="mask16" mask-type="alpha" maskUnits="userSpaceOnUse" x="415" y="106" width="55" height="54">
          <path
            d="M451.644 106.327C462.013 111.647 467.197 115.278 467.197 117.223C467.197 120.14 473.425 158.438 464.878 157.381C462.938 157.372 460.68 156.919 458.102 156.021L458.334 159.133L423.306 157.381L423.923 153.826C419.822 153.957 417.019 151.827 415.512 147.437L420.822 143.832C421.727 124.12 422.556 113.522 423.306 112.038C424.433 109.813 427.622 106.327 442.449 106.327H451.644Z"
            fill="white"
          />
        </mask>
        <g mask="url(#mask16)">
          <path
            d="M451.644 106.327C462.013 111.647 467.197 115.278 467.197 117.223C467.197 120.14 473.425 158.438 464.878 157.381C462.938 157.372 460.68 156.919 458.102 156.021L458.334 159.133L423.306 157.381L423.923 153.826C419.822 153.957 417.019 151.827 415.512 147.437L420.822 143.832C421.727 124.12 422.556 113.522 423.306 112.038C424.433 109.813 427.622 106.327 442.449 106.327H451.644Z"
            fill="#13BB84"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M439.065 106.327C436.197 116.279 436.495 129.51 439.958 146.02C441.867 133.166 444.073 124.632 446.574 120.418C450.327 114.097 453.634 108.667 454.346 107.438C455.763 104.989 450.967 104.329 439.958 105.457L439.065 106.327Z"
            fill="#00BC83"
          />
        </g>
        <path
          d="M426.697 117.639C427.418 130.797 427.418 139.673 426.697 144.267C425.615 151.158 426.146 155.21 420.17 153.046C418.035 151.976 416.488 150.137 415.531 147.53L420.941 143.775L424.273 145.097"
          stroke="#201F1D"
          strokeWidth="0.52"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M416.083 146.888C414.531 145.737 413.755 144.683 413.755 143.725C412.091 142.475 411.287 141.443 411.343 140.629C410.167 138.92 409.717 137.329 409.994 135.858C410.27 134.387 410.615 133.017 411.028 131.75L414.352 127.477C414.887 128.672 414.887 129.619 414.352 130.316C413.817 131.013 413.25 131.818 412.651 132.73L412.035 135.858L416.367 131.75L419.369 130.149C419.938 131.361 419.442 132.425 417.882 133.34L413.601 138.002C415.838 137.182 417.395 136.542 418.271 136.083C419.585 135.395 421.03 134.037 421.579 134.716C422.128 135.395 421.317 136.664 419.794 137.614C418.778 138.248 417.636 139 416.367 139.872C418.18 139.45 419.662 138.904 420.813 138.234C422.539 137.228 422.825 138.159 422.682 138.638C422.587 138.957 420.883 140.2 417.571 142.368C418.897 142.652 419.869 143.141 420.487 143.835L416.083 146.888Z"
          fill="#FFA990"
        />
        <path d="M455.974 124.948L458.096 144.267" stroke="#201F1D" strokeWidth="0.52" />
        <mask id="mask17" mask-type="alpha" maskUnits="userSpaceOnUse" x="431" y="88" width="22" height="29">
          <path
            d="M449.954 96.1131C450.596 95.7086 450.679 94.6246 450.931 93.7117C451.177 92.8216 451.601 92.1083 451.601 91.2428C451.601 89.4899 449.001 89.117 447.852 90.3892C446.702 91.6615 447.461 94.6732 447.098 94.6944C446.997 94.7003 446.594 94.114 445.887 92.9357C445.083 92.6713 444.44 92.2493 443.957 91.6698C443.804 91.486 443.624 91.0592 443.415 90.3892C440.616 91.3221 438.194 91.6066 436.152 91.2428C434.85 91.011 433.359 90.1901 431.679 88.7799C431.679 90.9795 431.498 92.2907 431.137 92.7137C433.557 101.986 436.716 107 440.615 107.755C438.915 112.567 439.17 115.446 441.379 116.393C444.692 117.813 451.71 111.654 452.622 106.812C450.998 102.452 450.109 99.9617 449.954 99.3403C449.799 98.7189 449.799 97.6432 449.954 96.1131Z"
            fill="white"
          />
        </mask>
        <g mask="url(#mask17)">
          <path
            d="M449.954 96.1131C450.596 95.7086 450.679 94.6246 450.931 93.7117C451.177 92.8216 451.601 92.1083 451.601 91.2428C451.601 89.4899 449.001 89.117 447.852 90.3892C446.702 91.6615 447.461 94.6732 447.098 94.6944C446.997 94.7003 446.594 94.114 445.887 92.9357C445.083 92.6713 444.44 92.2493 443.957 91.6698C443.804 91.486 443.624 91.0592 443.415 90.3892C440.616 91.3221 438.194 91.6066 436.152 91.2428C434.85 91.011 433.359 90.1901 431.679 88.7799C431.679 90.9795 431.498 92.2907 431.137 92.7137C433.557 101.986 436.716 107 440.615 107.755C438.915 112.567 439.17 115.446 441.379 116.393C444.692 117.813 451.71 111.654 452.622 106.812C450.998 102.452 450.109 99.9617 449.954 99.3403C449.799 98.7189 449.799 97.6432 449.954 96.1131Z"
            fill="#FFA990"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M439.821 107.614C442.809 108.349 445.44 106.961 447.715 103.448C447.302 105.586 445.949 107.306 443.655 108.609C440.215 110.563 438.018 114 440.727 116.245C442.686 117.555 442.929 117.941 441.455 117.405C439.244 116.6 437.795 114.307 438.808 112.002C439.483 110.466 439.821 109.003 439.821 107.614Z"
            fill="#E79279"
          />
        </g>
      </g>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M389.45 165.675L383.308 168.904L384.481 162.065L379.511 157.221L386.379 156.223L389.45 150L392.521 156.223L399.389 157.221L394.419 162.065L395.592 168.904L389.45 165.675Z"
        fill="#FFB400"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M416.35 165.675L410.208 168.904L411.381 162.065L406.411 157.221L413.279 156.223L416.35 150L419.421 156.223L426.289 157.221L421.319 162.065L422.492 168.904L416.35 165.675Z"
        fill="#FFB400"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M443.25 165.675L437.108 168.904L438.281 162.065L433.312 157.221L440.179 156.223L443.25 150L446.321 156.223L453.189 157.221L448.219 162.065L449.392 168.904L443.25 165.675Z"
        fill="#FFB400"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M470.15 165.675L464.008 168.904L465.181 162.065L460.211 157.221L467.079 156.223L470.15 150L473.221 156.223L480.089 157.221L475.119 162.065L476.292 168.904L470.15 165.675Z"
        fill="#FFB400"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M496.05 165.675L489.908 168.904L491.081 162.065L486.111 157.221L492.979 156.223L496.05 150L499.121 156.223L505.989 157.221L501.019 162.065L502.192 168.904L496.05 165.675Z"
        fill="#FFB400"
      />
      <defs>
        <filter
          id="filter0_d"
          x="341"
          y="99"
          width="201"
          height="138"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" />
          <feOffset dx="-4" dy="5" />
          <feGaussianBlur stdDeviation="5.5" />
          <feColorMatrix type="matrix" values="0 0 0 0 0.119118 0 0 0 0 0.174156 0 0 0 0 0.229195 0 0 0 0.2441 0" />
          <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow" />
          <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow" result="shape" />
        </filter>
        <filter
          id="filter1_d"
          x="398"
          y="67"
          width="82"
          height="82"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" />
          <feOffset dx="-4" dy="5" />
          <feGaussianBlur stdDeviation="5.5" />
          <feColorMatrix type="matrix" values="0 0 0 0 0.305882 0 0 0 0 0.580392 0 0 0 0 0.866667 0 0 0 0.360741 0" />
          <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow" />
          <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow" result="shape" />
        </filter>
        <linearGradient
          id="paint0_linear"
          x1="122.027"
          y1="205.947"
          x2="-6.38047"
          y2="639.969"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#95C9FF" />
          <stop offset="1" stopColor="#F3F9FF" />
        </linearGradient>
      </defs>
    </svg>
  );
};
