import { Icon } from '@douyinfe/semi-ui';

export const IconWord: React.FC<{ style?: React.CSSProperties }> = ({ style = {} }) => {
  return (
    <Icon
      style={style}
      svg={
        <svg viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em">
          <path
            d="M901.08928 925.3888a48.13824 48.13824 0 0 1-14.24896 34.38592 48.77312 48.77312 0 0 1-34.38592 14.24896H171.07456a48.13824 48.13824 0 0 1-34.3808-14.24896 48.74752 48.74752 0 0 1-14.24896-34.38592V49.42336a48.18944 48.18944 0 0 1 14.24896-34.40128A48.74752 48.74752 0 0 1 171.07456 0.77824h417.9968a48.5888 48.5888 0 0 1 34.59072 14.09024l263.3472 263.33184a48.68096 48.68096 0 0 1 14.08 34.59072z"
            fill="#EBECF0"
          ></path>
          <path
            d="M901.08928 925.3888v48.68608a48.18944 48.18944 0 0 1-14.24896 34.39616 48.77312 48.77312 0 0 1-34.38592 14.24896H171.07456a48.70656 48.70656 0 0 1-48.68096-48.69632v-48.63488a48.13824 48.13824 0 0 0 14.24384 34.38592 48.74752 48.74752 0 0 0 34.38592 14.24896h681.32864a48.81408 48.81408 0 0 0 48.68608-48.68608z"
            fill="#C1C7D0"
          ></path>
          <path
            d="M25.11872 536.09472h973.24544v243.33824a48.81408 48.81408 0 0 1-48.61952 48.68096H73.81504a48.18944 48.18944 0 0 1-34.39616-14.24384 48.74752 48.74752 0 0 1-14.24896-34.38592z"
            fill="#317BFF"
          ></path>
          <path
            d="M122.496 536.08448V438.71744L25.11872 536.08448z m778.59328 0l0.93184-97.36704 96.86016 97.36704z"
            fill="#234AE8"
          ></path>
          <path
            d="M901.08928 312.73984v6.84032h-263.3216a48.6912 48.6912 0 0 1-48.6912-48.68096V0.72704a48.5888 48.5888 0 0 1 34.5856 14.09024l263.76192 263.22944a49.3312 49.3312 0 0 1 13.66528 34.69312z"
            fill="#C1C7D0"
          ></path>
          <path
            d="M259.67616 606.58176l19.7888 102.54848 18.8928-102.5536h52.1728l-40.47872 165.52448H256.0768l-18.8928-96.25088h-0.90112l-18.88768 96.25088H164.32128l-41.37984-165.51936h53.07392l17.99168 102.54848h0.90112l19.7888-102.5536zM447.68256 602.0864q81.8432 3.60448 87.25504 86.35392-3.6096 82.77504-87.25504 86.35904-83.6608-2.69824-86.35904-87.26016 4.49024-80.95232 86.35904-85.4528z m0 40.47872q-30.59712 0.90624-32.384 45.8752 1.792 46.78656 32.384 47.67744 32.384-0.89088 33.28-47.67744-1.81248-45.8752-33.28-45.8752zM628.49024 714.53184h-16.18944V772.096h-53.96992v-165.51936h78.2592q76.4416-1.792 72.8576 46.77632-0.896 32.38912-27.88864 40.48384 30.5664 6.2976 28.78976 44.07296v7.19872q-0.90112 24.28416 5.4016 21.59104v5.39648h-54.88128q-2.68288-5.4016-2.688-28.78464 3.584-31.47776-29.69088-28.78464z m-16.18944-69.26848v32.384h21.59104q26.9824 0.90624 26.07616-15.29344-0.896-16.18944-22.4768-17.09056zM809.29792 772.096h-71.0656v-165.51424h72.86784q85.4528 0.90624 86.35904 79.16544 0 86.35392-88.16128 86.35392z m-17.08544-126.83264v88.15616h11.68896q38.66624 0 38.67648-44.9792 2.70336-46.76096-39.5776-43.17696z"
            fill="#FFFFFF"
          ></path>
        </svg>
      }
    />
  );
};

export const IconFileWord: React.FC<{ style?: React.CSSProperties }> = ({ style = {} }) => {
  return (
    <Icon
      style={style}
      svg={
        <svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em">
          <path fill="none" d="M0 0h24v24H0z" />
          <path d="M16 8v8h-2l-2-2-2 2H8V8h2v5l2-2 2 2V8h1V4H5v16h14V8h-3zM3 2.992C3 2.444 3.447 2 3.999 2H16l5 5v13.993A1 1 0 0 1 20.007 22H3.993A1 1 0 0 1 3 21.008V2.992z" />
        </svg>
      }
    />
  );
};
