import { Icon } from '@douyinfe/semi-ui';

export const IconQuote: React.FC<{ style?: React.CSSProperties }> = ({ style = {} }) => {
  return (
    <Icon
      style={style}
      svg={
        <svg width="16" height="16" viewBox="0 0 256 256" role="presentation">
          <g fill="none" fillRule="evenodd">
            <g fill="currentColor">
              <path d="M36 143h44c6.627 0 12 5.373 12 12v44c0 6.627-5.373 12-12 12H36c-6.627 0-12-5.373-12-12v-44c0-6.627 5.373-12 12-12Z"></path>
              <path
                d="M84.144 53.257c5.502-.485 10.355 3.582 10.84 9.084.476 5.408-3.447 10.19-8.806 10.81l-.279.029c-23.384 2.06-41.533 21.544-41.894 45.105L44 119v41.723c0 5.523-4.477 10-10 10-5.43 0-9.848-4.326-9.996-9.72l-.004-.28V119c0-34.269 26.22-62.755 60.144-65.743Z"
                fillRule="nonzero"
              ></path>
              <path d="M43.272 120.769 38.56 142.58a9.567 9.567 0 0 0 13.93 10.42l11.401-6.216a2.015 2.015 0 0 0-.964-3.784h-2.933c-8.837 0-16-7.164-16-16v-6.155a.365.365 0 0 0-.722-.077Z"></path>
            </g>
            <g fill="currentColor">
              <path d="M176 143h44c6.627 0 12 5.373 12 12v44c0 6.627-5.373 12-12 12h-44c-6.627 0-12-5.373-12-12v-44c0-6.627 5.373-12 12-12Z"></path>
              <path
                d="M224.144 53.257c5.502-.485 10.355 3.582 10.84 9.084.476 5.408-3.447 10.19-8.806 10.81l-.279.029c-23.384 2.06-41.533 21.544-41.894 45.105L184 119v41.723c0 5.523-4.477 10-10 10-5.43 0-9.848-4.326-9.996-9.72l-.004-.28V119c0-34.269 26.22-62.755 60.144-65.743Z"
                fillRule="nonzero"
              ></path>
              <path d="m183.272 120.769-4.712 21.812a9.567 9.567 0 0 0 13.93 10.42l11.401-6.216a2.015 2.015 0 0 0-.964-3.784h-2.933c-8.837 0-16-7.164-16-16v-6.155a.365.365 0 0 0-.722-.077Z"></path>
            </g>
          </g>
        </svg>
      }
    />
  );
};
