import { Icon } from '@douyinfe/semi-ui';

export const IconCodeBlock: React.FC<{ style?: React.CSSProperties }> = ({ style = {} }) => {
  return (
    <Icon
      style={style}
      svg={
        <svg width="16" height="16" viewBox="0 0 256 256" role="presentation">
          <g fill="currentColor" fillRule="evenodd">
            <path
              d="M64 40c5.523 0 10 4.477 10 10 0 5.43-4.327 9.848-9.72 9.996L64 60H54a6 6 0 0 0-5.996 5.775L48 66v42.5a10 10 0 0 1-1.667 5.529l-.21.303L36.31 128l9.813 13.668a10 10 0 0 1 1.87 5.463l.007.369V190a6 6 0 0 0 5.775 5.996L54 196h10c5.523 0 10 4.477 10 10 0 5.43-4.327 9.848-9.72 9.996L64 216H54c-14.216 0-25.767-11.409-25.997-25.57L28 190v-39.281l-12.123-16.887a10 10 0 0 1-.179-11.407l.179-.257L28 105.28V66c0-14.216 11.409-25.767 25.57-25.997L54 40h10ZM192 40c-5.523 0-10 4.477-10 10 0 5.43 4.327 9.848 9.72 9.996L192 60h10a6 6 0 0 1 5.996 5.775L208 66v42.5a10 10 0 0 0 1.667 5.529l.21.303L219.69 128l-9.813 13.668a10 10 0 0 0-1.87 5.463l-.007.369V190a6 6 0 0 1-5.775 5.996L202 196h-10c-5.523 0-10 4.477-10 10 0 5.43 4.327 9.848 9.72 9.996l.28.004h10c14.216 0 25.767-11.409 25.997-25.57L228 190v-39.281l12.123-16.887a10 10 0 0 0 .179-11.407l-.179-.257L228 105.28V66c0-14.216-11.409-25.767-25.57-25.997L202 40h-10Z"
              fillRule="nonzero"
            ></path>
            <rect x="72" y="78" width="112" height="20" rx="10"></rect>
            <path d="M82 118h36c5.523 0 10 4.477 10 10s-4.477 10-10 10H82c-5.523 0-10-4.477-10-10s4.477-10 10-10ZM82 158h92c5.523 0 10 4.477 10 10s-4.477 10-10 10H82c-5.523 0-10-4.477-10-10s4.477-10 10-10Z"></path>
          </g>
        </svg>
      }
    />
  );
};
