import { Icon } from '@douyinfe/semi-ui';

export const IconAttachment: React.FC<{ style?: React.CSSProperties }> = ({ style = {} }) => {
  return (
    <Icon
      style={style}
      svg={
        <svg width="16" height="16" viewBox="0 0 256 256" role="presentation">
          <path
            d="M152.765 31.222c16.836-16.774 44.065-16.774 60.9 0 16.617 16.554 16.832 43.341.61 60.16l-.61.62-88.75 88.422c-10.261 10.223-26.858 10.223-37.119 0-10.139-10.101-10.27-26.446-.372-36.709l.372-.378 64.689-64.449c3.912-3.898 10.244-3.886 14.142.026 3.827 3.842 3.885 10.015.183 13.927l-.21.215-64.704 64.466a6.176 6.176 0 0 0 .016 8.734 6.296 6.296 0 0 0 8.7.178l.187-.178 88.81-88.483c8.927-8.959 8.9-23.457-.06-32.383-8.934-8.902-23.327-8.997-32.378-.284l-.29.284-99.113 98.747c-15.186 15.243-15.14 39.91.102 55.096 15.19 15.135 39.667 15.286 55.044.454l.463-.454 74.95-74.672c3.912-3.898 10.244-3.887 14.142.026 3.827 3.841 3.885 10.015.183 13.927l-.21.215-74.949 74.672c-23.149 23.064-60.59 23.064-83.74 0-22.836-22.752-23.132-59.567-.836-82.684l.837-.85 99.011-98.645Z"
            fill="currentColor"
            fillRule="nonzero"
          ></path>
        </svg>
      }
    />
  );
};
