/* 21HTTT1 - Nhóm 3
 * 21127004 - Trần Nguyễn An Phong
 * 21127135 - Diệp Hữu Phúc
 * 21127149 - Huỳnh Minh Quang
 * 21127296 - Đặng Hà Huy
 */
USE [Nhom3_QLNhaKhoa]
GO

CREATE OR ALTER PROC USP_NHANVIEN_INS
    @HOTEN NVARCHAR(25),
    @NGAYSINH DATE,
    @DIACHI NVARCHAR(100),
    @SODT VARCHAR(11),
    @LOAINHANVIEN INT,
    @MATKHAU VARCHAR(20),
    @MANHANVIEN VARCHAR(5) = NULL OUTPUT
AS BEGIN TRAN
    DECLARE @TYPE CHAR(2)
    IF (@LOAINHANVIEN = 0) SET @TYPE = 'NV'
    ELSE IF (@LOAINHANVIEN = 1) SET @TYPE = 'NS'
    ELSE IF (@LOAINHANVIEN = 2) SET @TYPE = 'AD'
    ELSE BEGIN
        RAISERROR('INVALID LOAINHANVIEN', 16, 1)
        ROLLBACK TRAN
        RETURN -1
    END
    
    SELECT @MANHANVIEN = MANHANVIEN FROM NHANVIEN
    WHERE MANHANVIEN = (SELECT MAX(MANHANVIEN) FROM NHANVIEN
        WHERE MANHANVIEN LIKE @TYPE + '%')

    SET @MANHANVIEN = dbo.F_MAKE_ID(@TYPE, @MANHANVIEN)

    INSERT INTO NHANVIEN
    VALUES (@MANHANVIEN, @HOTEN, @NGAYSINH, @DIACHI, @SODT, @LOAINHANVIEN, @MATKHAU)
COMMIT TRAN
RETURN 0
GO

CREATE OR ALTER PROC USP_NHANVIEN_UPD
    @MANHANVIEN VARCHAR(5),
    @HOTEN NVARCHAR(25),
    @NGAYSINH DATE,
    @DIACHI NVARCHAR(100),
    @SODT VARCHAR(11),
    @LOAINHANVIEN INT, -- 0: NHANVIEN, 1: NHASI, 2: QUANTRIVIEN
    @MATKHAU VARCHAR(20)
AS BEGIN TRAN
    IF NOT EXISTS (SELECT * FROM NHANVIEN WHERE MANHANVIEN = @MANHANVIEN) BEGIN
        RAISERROR('INVALID MANHANVIEN', 16, 1)
        ROLLBACK TRAN
        RETURN -1
    END

    IF @LOAINHANVIEN != 0 AND @LOAINHANVIEN != 1 AND @LOAINHANVIEN != 2 BEGIN
        RAISERROR('INVALID LOAINHANVIEN', 16, 1)
        ROLLBACK TRAN
        RETURN -2
    END

    IF @HOTEN IS NULL OR @NGAYSINH IS NULL OR @DIACHI IS NULL
        OR @SODT IS NULL OR @MATKHAU IS NULL BEGIN
        RAISERROR('INVALID DATA', 16, 1)
        ROLLBACK TRAN
        RETURN -3
    END

    UPDATE NHANVIEN SET HOTEN = @HOTEN, NGAYSINH = @NGAYSINH,
        DIACHI = @DIACHI, SODT = @SODT, LOAINHANVIEN = @LOAINHANVIEN,
        MATKHAU = @MATKHAU
    WHERE MANHANVIEN = @MANHANVIEN
COMMIT TRAN
RETURN 0
GO