/* 21HTTT1 - Nhóm 3
 * 21127004 - Trần Nguyễn An Phong
 * 21127135 - Diệp Hữu Phúc
 * 21127149 - Huỳnh Minh Quang
 * 21127296 - Đặng Hà Huy
 */
USE [Nhom3_QLNhaKhoa]
GO

CREATE OR ALTER PROC USP_LICHHEN_INS
    @NGAY DATE,
    @GIO INT,
    @MAKHACHHANG VARCHAR(5),
    @MANHASI VARCHAR(5),
    @MANVDATLICH VARCHAR(5) = NULL,
    @MALICHHEN VARCHAR(5) = NULL OUTPUT
AS BEGIN TRAN
    IF @GIO < 480 OR @GIO > 1020 BEGIN
        RAISERROR('GIO HAS TO BE BETWEEN 480 AND 1020 (8AM - 5PM)', 16, 1)
        ROLLBACK TRAN
        RETURN -1
    END

    IF NOT EXISTS (SELECT * FROM KHACHHANG
        WHERE MAKHACHHANG = @MAKHACHHANG) BEGIN
        RAISERROR('INVALID MAKHACHHANG', 16, 1)
        ROLLBACK TRAN
        RETURN -2
    END

    IF NOT EXISTS (SELECT * FROM NHANVIEN
        WHERE MANHANVIEN = @MANHASI) BEGIN
        RAISERROR('INVALID MANHASI', 16, 1)
        ROLLBACK TRAN
        RETURN -3
    END

    IF @MANVDATLICH IS NOT NULL AND NOT EXISTS
        (SELECT * FROM NHANVIEN WHERE MANHANVIEN = @MANVDATLICH) BEGIN
        RAISERROR('INVALID MANVDATLICH', 16, 1)
        ROLLBACK TRAN
        RETURN -4
    END

    IF EXISTS (SELECT * FROM LICHHEN
        WHERE MANHASI = @MANHASI AND (ABS(GIO - @GIO) <= 60)) BEGIN
        RAISERROR('NHASI IS NOT AVAILABLE AT THAT TIME', 16, 1)
        ROLLBACK TRAN
        RETURN -4
    END

    SELECT @MALICHHEN = MALICHHEN FROM LICHHEN
    WHERE MALICHHEN = (SELECT MAX(MALICHHEN) FROM LICHHEN)

    SET @MALICHHEN = dbo.F_MAKE_ID('LH', @MALICHHEN)

    INSERT INTO LICHHEN
    VALUES (@MALICHHEN, @NGAY, @GIO, @MAKHACHHANG, @MANHASI, @MANVDATLICH)
COMMIT TRAN
GO

CREATE OR ALTER PROC USP_LICHHEN_UPD
    @MALICHHEN VARCHAR(5),
    @NGAY DATE,
    @GIO INT,
    @MAKHACHHANG VARCHAR(5),
    @MANHASI VARCHAR(5),
    @MANVDATLICH VARCHAR(5) = NULL,
    @NGUOIUPDATE VARCHAR(5)
AS BEGIN TRAN
    IF NOT EXISTS (SELECT * FROM LICHHEN WHERE MALICHHEN = @MALICHHEN) BEGIN
        RAISERROR('INVALID MALICHHEN', 16, 1)
        ROLLBACK TRAN
        RETURN -1
    END

    IF @NGAY IS NULL OR @GIO IS NULL OR @MAKHACHHANG IS NULL
        OR @MANHASI IS NULL OR @NGUOIUPDATE IS NULL BEGIN
        RAISERROR('INVALID DATA', 16, 1)
        ROLLBACK TRAN
        RETURN -2
    END

    IF @GIO < 480 OR @GIO > 1020 BEGIN
        RAISERROR('GIO HAS TO BE BETWEEN 480 AND 1020 (8AM - 5PM)', 16, 1)
        ROLLBACK TRAN
        RETURN -3
    END

    IF NOT EXISTS (SELECT * FROM KHACHHANG
        WHERE MAKHACHHANG = @MAKHACHHANG) BEGIN
        RAISERROR('INVALID MAKHACHHANG', 16, 1)
        ROLLBACK TRAN
        RETURN -4
    END

    IF NOT EXISTS (SELECT * FROM NHANVIEN WHERE MANHANVIEN = @MANHASI) BEGIN
        RAISERROR('INVALID MANHASI', 16, 1)
        ROLLBACK TRAN
        RETURN -5
    END

    IF NOT EXISTS (SELECT * FROM NHANVIEN WHERE MANHANVIEN = @NGUOIUPDATE)
        AND NOT EXISTS (SELECT * FROM KHACHHANG
            WHERE MAKHACHHANG = @NGUOIUPDATE) BEGIN
        RAISERROR('INVALID NGUOIUPDATE', 16, 1)
        ROLLBACK TRAN
        RETURN -6
    END

    IF @NGUOIUPDATE LIKE 'NS%' AND @NGUOIUPDATE != @MANVDATLICH BEGIN
        RAISERROR('NHASI CAN ONLY UPDATE THEIR OWN SCHEDULE', 16, 1)
        ROLLBACK TRAN
        RETURN -7
    END

    IF @NGUOIUPDATE LIKE 'NV%' SET @MANVDATLICH = @NGUOIUPDATE

    UPDATE LICHHEN SET NGAY = @NGAY, GIO = @GIO, MAKHACHHANG = @MAKHACHHANG,
        MANHASI = @MANHASI, MANVDATLICH = @MANVDATLICH
    WHERE MALICHHEN = @MALICHHEN
COMMIT TRAN
RETURN 0
GO

CREATE OR ALTER PROC USP_LICHHEN_DEL
    @MALICHHEN VARCHAR(5)
AS BEGIN TRAN
    IF NOT EXISTS (SELECT * FROM LICHHEN WHERE MALICHHEN = @MALICHHEN) BEGIN
        RAISERROR('INVALID MALICHHEN', 16, 1)
        ROLLBACK TRAN
        RETURN -1
    END

    DELETE FROM LICHHEN WHERE MALICHHEN = @MALICHHEN
COMMIT TRAN
RETURN 0
GO