/* 21HTTT1 - Nhóm 3
 * 21127004 - Trần Nguyễn An Phong
 * 21127135 - Diệp Hữu Phúc
 * 21127149 - Huỳnh Minh Quang
 * 21127296 - Đặng Hà Huy
 */
USE [Nhom3_QLNhaKhoa]
GO

CREATE OR ALTER PROC USP_HOADON_INS
    @NGAYLAP DATE,
    @MAHSBA VARCHAR(5),
    @MAGIAYKHAMBENH VARCHAR(5),
    @MANVLAP VARCHAR(5),
    @MAHOADON VARCHAR(5) = NULL OUTPUT
AS BEGIN TRAN
    IF NOT EXISTS (SELECT * FROM GIAYKHAMBENH WHERE MAHSBA = @MAHSBA
        AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH) BEGIN
        RAISERROR('INVALID MAGIAYKHAMBENH', 16, 1)
        ROLLBACK TRAN
        RETURN -1
    END

    IF @MANVLAP NOT LIKE 'NV%' AND NOT EXISTS (SELECT * FROM NHANVIEN
        WHERE MANHANVIEN = @MANVLAP) BEGIN
        RAISERROR('INVALID MANVLAP', 16, 1)
        ROLLBACK TRAN
        RETURN -2
    END

    DECLARE @TONGTIEN INT
    SELECT @TONGTIEN = TONGTIENTHUOC + TONGTIENDICHVU
        FROM GIAYKHAMBENH WHERE MAHSBA = @MAHSBA
            AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH

    SELECT @MAHOADON = MAHOADON FROM HOADON
    WHERE MAHOADON = (SELECT MAX(MAHOADON) FROM HOADON)
    
    SET @MAHOADON = dbo.F_MAKE_ID('HD', @MAHOADON)

    INSERT INTO HOADON
    VALUES (@MAHOADON, @NGAYLAP, @TONGTIEN, @MAHSBA, @MAGIAYKHAMBENH, @MANVLAP)
COMMIT TRAN
RETURN 0
GO