/* 21HTTT1 - Nhóm 3
 * 21127004 - Trần Nguyễn An Phong
 * 21127135 - Diệp Hữu Phúc
 * 21127149 - Huỳnh Minh Quang
 * 21127296 - Đặng Hà Huy
 */
USE [Nhom3_QLNhaKhoa]
GO

CREATE OR ALTER PROC USP_GIAYKHAMBENH_INS
    @MAHSBA VARCHAR(5),
    @NGAYKHAM DATE,
    @MAGIAYKHAMBENH VARCHAR(5) = NULL OUTPUT
AS BEGIN TRAN
    IF NOT EXISTS (SELECT * FROM HOSOBENHAN WHERE MAHSBA = @MAHSBA) BEGIN
        RAISERROR('INVALID MAHSBA', 16, 1)
        ROLLBACK TRAN
        RETURN -1
    END

    SELECT @MAGIAYKHAMBENH = MAGIAYKHAMBENH FROM GIAYKHAMBENH
    WHERE MAGIAYKHAMBENH = (SELECT MAX(MAGIAYKHAMBENH) FROM GIAYKHAMBENH
        WHERE MAHSBA = @MAHSBA)
    
    SET @MAGIAYKHAMBENH = dbo.F_MAKE_ID('GK', @MAGIAYKHAMBENH)

    INSERT INTO GIAYKHAMBENH
    VALUES (@MAHSBA, @MAGIAYKHAMBENH, @NGAYKHAM, 0, 0)
COMMIT TRAN
RETURN 0
GO