﻿/* 21HTTT1 - Nhóm 3
 * 21127004 - Trần Nguyễn An Phong
 * 21127135 - Diệp Hữu Phúc
 * 21127149 - Huỳnh Minh Quang
 * 21127296 - Đặng Hà Huy
 */
USE [Nhom3_QLNhaKhoa]
GO

CREATE OR ALTER PROC USP_DICHVUSUDUNG_INS
    @MAHSBA VARCHAR(5),
    @MAGIAYKHAMBENH VARCHAR(5),
    @MADICHVU VARCHAR(5),
    @GHICHU NVARCHAR(100) = NULL
AS BEGIN TRAN
    IF NOT EXISTS (SELECT * FROM GIAYKHAMBENH
        WHERE MAHSBA = @MAHSBA
            AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH) BEGIN
        RAISERROR('INVALID GIAYKHAMBENH', 16, 1)
        ROLLBACK TRAN
        RETURN -1
    END

    IF NOT EXISTS (SELECT * FROM DICHVUKHAM WHERE MADICHVU = @MADICHVU) BEGIN
        RAISERROR('INVALID MADICHVU', 16, 1)
        ROLLBACK TRAN
        RETURN -2
    END

    IF EXISTS (SELECT * FROM DICHVUSUDUNG
        WHERE MAHSBA = @MAHSBA AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH
            AND MADICHVU = @MADICHVU) BEGIN
        RAISERROR('DICHVUSUDUNG ALREADY EXISTS', 16, 1)
        ROLLBACK TRAN
        RETURN -3
    END

    DECLARE @COST INT
    SET @COST = (SELECT GIATIEN FROM DICHVUKHAM
        WHERE MADICHVU = @MADICHVU)

    INSERT INTO DICHVUSUDUNG
    VALUES (@MAHSBA, @MAGIAYKHAMBENH, @MADICHVU, @GHICHU)

    UPDATE GIAYKHAMBENH SET TONGTIENDICHVU += @COST
    WHERE MAHSBA = @MAHSBA AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH
COMMIT TRAN
RETURN 0
GO

CREATE OR ALTER PROC USP_DICHVUSUDUNG_UPD
    @MAHSBA VARCHAR(5),
    @MAGIAYKHAMBENH VARCHAR(5),
    @MADICHVU VARCHAR(5),
    @GHICHU NVARCHAR(100) = NULL
AS BEGIN TRAN
    IF NOT EXISTS (SELECT * FROM DICHVUSUDUNG
        WHERE MAHSBA = @MAHSBA AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH
            AND MADICHVU = @MADICHVU) BEGIN
        RAISERROR('INVALID DICHVUSUDUNG', 16, 1)
        ROLLBACK TRAN
        RETURN -1
    END

    UPDATE DICHVUSUDUNG SET GHICHU = @GHICHU
    WHERE MAHSBA = @MAHSBA AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH
        AND MADICHVU = @MADICHVU
COMMIT TRAN
RETURN 0
GO

CREATE OR ALTER PROC USP_DICHVUSUDUNG_DEL
    @MAHSBA VARCHAR(5),
    @MAGIAYKHAMBENH VARCHAR(5),
    @MADICHVU VARCHAR(5),
    @GHICHU NVARCHAR(100) = NULL
AS BEGIN TRAN
    IF NOT EXISTS (SELECT * FROM DICHVUSUDUNG
        WHERE MAHSBA = @MAHSBA AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH
            AND MADICHVU = @MADICHVU) BEGIN
        RAISERROR('INVALID DICHVUSUDUNG', 16, 1)
        ROLLBACK TRAN
        RETURN -1
    END

    DECLARE @COST INT
    SET @COST = (SELECT GIATIEN FROM DICHVUKHAM
        WHERE MADICHVU = @MADICHVU)

    DELETE FROM DICHVUSUDUNG
    WHERE MAHSBA = @MAHSBA AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH
        AND MADICHVU = @MADICHVU

    UPDATE GIAYKHAMBENH SET TONGTIENDICHVU -= @COST
    WHERE MAHSBA = @MAHSBA AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH
COMMIT TRAN
RETURN 0
GO