﻿/* 21HTTT1 - Nhóm 3
 * 21127004 - Trần Nguyễn An Phong
 * 21127135 - Diệp Hữu Phúc
 * 21127149 - Huỳnh Minh Quang
 * 21127296 - Đặng Hà Huy
 */
USE [Nhom3_QLNhaKhoa]
GO

-------- LOGINS AND USERS --------
/* KHACHHANG
 */
CREATE LOGIN KH001 WITH PASSWORD = '123',
    DEFAULT_DATABASE = [Nhom3_QLNhaKhoa]

CREATE USER KH001 FOR LOGIN KH001

CREATE LOGIN KH002 WITH PASSWORD = '123',
    DEFAULT_DATABASE = [Nhom3_QLNhaKhoa]

CREATE USER KH002 FOR LOGIN KH002

CREATE LOGIN KH003 WITH PASSWORD = '123',
    DEFAULT_DATABASE = [Nhom3_QLNhaKhoa]

CREATE USER KH003 FOR LOGIN KH003

GO

/* NHANVIEN - NHANVIEN
 */
CREATE LOGIN NV001 WITH PASSWORD = '123',
    DEFAULT_DATABASE = [Nhom3_QLNhaKhoa]

CREATE USER NV001 FOR LOGIN NV001

CREATE LOGIN NV002 WITH PASSWORD = '123',
    DEFAULT_DATABASE = [Nhom3_QLNhaKhoa]

CREATE USER NV002 FOR LOGIN NV002

GO

/* NHANVIEN - NHASI
 */
CREATE LOGIN NS001 WITH PASSWORD = '123',
    DEFAULT_DATABASE = [Nhom3_QLNhaKhoa]

CREATE USER NS001 FOR LOGIN NS001

CREATE LOGIN NS002 WITH PASSWORD = '123',
    DEFAULT_DATABASE = [Nhom3_QLNhaKhoa]

CREATE USER NS002 FOR LOGIN NS002

GO

/* NHANVIEN - QUANTRIVIEN
 */
CREATE LOGIN AD001 WITH PASSWORD = '123',
    DEFAULT_DATABASE = [Nhom3_QLNhaKhoa]

CREATE USER AD001 FOR LOGIN AD001

CREATE LOGIN AD002 WITH PASSWORD = '123',
    DEFAULT_DATABASE = [Nhom3_QLNhaKhoa]

CREATE USER AD002 FOR LOGIN AD002
GO

-------- ROLES --------
CREATE ROLE KHACHHANG
ALTER ROLE KHACHHANG ADD MEMBER KH001
ALTER ROLE KHACHHANG ADD MEMBER KH002
ALTER ROLE KHACHHANG ADD MEMBER KH003
GO

CREATE ROLE NHANVIEN
ALTER ROLE NHANVIEN ADD MEMBER NV001
ALTER ROLE NHANVIEN ADD MEMBER NV002
GO

CREATE ROLE NHASI
ALTER ROLE NHASI ADD MEMBER NS001
ALTER ROLE NHASI ADD MEMBER NS002
GO

CREATE ROLE ADM
ALTER ROLE ADM ADD MEMBER AD001
ALTER ROLE ADM ADD MEMBER AD002
ALTER SERVER ROLE securityadmin ADD MEMBER AD001
ALTER SERVER ROLE securityadmin ADD MEMBER AD002
GO

-------- PERMISSIONS --------
/* KHACHHANG
 */
GRANT SELECT, UPDATE ON KHACHHANG TO KHACHHANG
GRANT SELECT, INSERT ON LICHHEN TO KHACHHANG
GRANT SELECT ON HOSOBENHAN TO KHACHHANG

GRANT EXEC ON OBJECT::USP_KHACHHANG_INS TO KHACHHANG
GRANT EXEC ON OBJECT::USP_KHACHHANG_UPD TO KHACHHANG

GRANT EXEC ON OBJECT::USP_LICHHEN_INS TO KHACHHANG
GO

/* NHANVIEN - NHANVIEN
 */
GRANT SELECT, UPDATE ON NHANVIEN TO NHANVIEN
GRANT SELECT, INSERT, UPDATE ON LICHHEN TO NHANVIEN

GRANT SELECT ON HOSOBENHAN TO NHANVIEN
GRANT SELECT ON GIAYKHAMBENH TO NHANVIEN

GRANT SELECT ON DICHVUSUDUNG TO NHANVIEN
GRANT SELECT ON DICHVUKHAM TO NHANVIEN

GRANT SELECT ON TOATHUOC TO NHANVIEN
GRANT SELECT ON THUOC TO NHANVIEN

GRANT SELECT, INSERT, UPDATE ON HOADON TO NHANVIEN

GRANT EXEC ON OBJECT::USP_NHANVIEN_INS TO NHANVIEN
GRANT EXEC ON OBJECT::USP_NHANVIEN_UPD TO NHANVIEN

GRANT EXEC ON OBJECT::USP_LICHHEN_INS TO NHANVIEN
GRANT EXEC ON OBJECT::USP_LICHHEN_UPD TO NHANVIEN

GRANT EXEC ON OBJECT::USP_THUOC_SEARCH TO NHANVIEN

GRANT EXEC ON OBJECT::USP_HOADON_INS TO NHANVIEN
GO

/* NHANVIEN - NHASI
 */
GRANT SELECT, UPDATE ON NHANVIEN TO NHASI
GRANT SELECT, INSERT, UPDATE, DELETE ON LICHHEN TO NHASI

GRANT SELECT, INSERT, UPDATE ON HOSOBENHAN TO NHASI
GRANT SELECT, INSERT, UPDATE ON GIAYKHAMBENH TO NHASI

GRANT SELECT, INSERT, UPDATE, DELETE ON TOATHUOC TO NHASI
GRANT SELECT ON THUOC TO NHASI

GRANT SELECT, INSERT, UPDATE, DELETE ON DICHVUSUDUNG TO NHASI
GRANT SELECT ON DICHVUKHAM TO NHASI

GRANT EXEC ON OBJECT::USP_LICHHEN_INS TO NHASI
GRANT EXEC ON OBJECT::USP_LICHHEN_UPD TO NHASI

GRANT EXEC ON OBJECT::USP_HSBA_INS TO NHASI

GRANT EXEC ON OBJECT::USP_GIAYKHAMBENH_INS TO NHASI

GRANT EXEC ON OBJECT::USP_TOATHUOC_INS TO NHASI
GRANT EXEC ON OBJECT::USP_TOATHUOC_UPD TO NHASI
GRANT EXEC ON OBJECT::USP_TOATHUOC_DEL TO NHASI

GRANT EXEC ON OBJECT::USP_DICHVUSUDUNG_INS TO NHASI
GRANT EXEC ON OBJECT::USP_DICHVUSUDUNG_UPD TO NHASI
GRANT EXEC ON OBJECT::USP_DICHVUSUDUNG_DEL TO NHASI

GRANT EXEC ON OBJECT::USP_THUOC_SEARCH TO NHASI
GO

/* NHANVIEN - QUANTRIVIEN
 */
GRANT SELECT, INSERT, UPDATE, DELETE ON THUOC TO ADM

GRANT EXEC ON OBJECT::USP_KHACHHANG_INS TO ADM
GRANT EXEC ON OBJECT::USP_KHACHHANG_UPD TO ADM

GRANT EXEC ON OBJECT::USP_NHANVIEN_INS TO ADM
GRANT EXEC ON OBJECT::USP_NHANVIEN_UPD TO ADM

GRANT EXEC ON OBJECT::USP_THUOC_INS TO ADM
GRANT EXEC ON OBJECT::USP_THUOC_UPD TO ADM
GRANT EXEC ON OBJECT::USP_THUOC_SEARCH TO ADM
GO