/* 21HTTT1 - Nhóm 3
 * 21127004 - Trần Nguyễn An Phong
 * 21127135 - Diệp Hữu Phúc
 * 21127149 - Huỳnh Minh Quang
 * 21127296 - Đặng Hà Huy
 */
USE [Nhom3_QLNhaKhoa]
GO

-- TRAN 1
CREATE OR ALTER PROC USP_TOATHUOC_UPD
    @MAHSBA VARCHAR(5),
    @MAGIAYKHAMBENH VARCHAR(5),
    @MATHUOC VARCHAR(5),
    @SOLUONG INT = 1
AS BEGIN TRAN
    IF NOT EXISTS (SELECT * FROM TOATHUOC
        WHERE MAHSBA = @MAHSBA AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH
            AND MATHUOC = @MATHUOC) BEGIN
        RAISERROR('INVALID TOATHUOC', 16, 1)
        ROLLBACK TRAN
        RETURN -1
    END

    IF NOT EXISTS (SELECT * FROM THUOC WHERE MATHUOC = @MATHUOC
        AND SOLUONGTONKHO >= @SOLUONG) BEGIN
        RAISERROR('INVALID MATHUOC, OR SOLUONGTONKHO IS INSUFFICIENT', 16, 1)
        ROLLBACK TRAN
        RETURN -2
    END

    DECLARE @DIFFSOLUONG INT, @DIFFCOST INT
    SELECT @DIFFSOLUONG = SOLUONG FROM TOATHUOC WHERE MAHSBA = @MAHSBA
        AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH AND MATHUOC = @MATHUOC

    SET @DIFFSOLUONG = @SOLUONG - @DIFFSOLUONG
    SET @DIFFCOST = (SELECT GIATIEN FROM THUOC
        WHERE MATHUOC = @MATHUOC) * @DIFFSOLUONG

    WAITFOR DELAY '00:00:05'

    UPDATE TOATHUOC SET SOLUONG = @SOLUONG
    WHERE MAHSBA = @MAHSBA AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH
        AND MATHUOC = @MATHUOC

    WAITFOR DELAY '00:00:05'

    UPDATE GIAYKHAMBENH SET TONGTIENTHUOC += @DIFFCOST
    WHERE MAHSBA = @MAHSBA AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH

    UPDATE THUOC SET SOLUONGTONKHO -= @DIFFSOLUONG WHERE MATHUOC = @MATHUOC
COMMIT TRAN
RETURN 0
GO

-- TRAN 2
CREATE OR ALTER PROC USP_TOATHUOC_DEL
    @MAHSBA VARCHAR(5),
    @MAGIAYKHAMBENH VARCHAR(5),
    @MATHUOC VARCHAR(5)
AS BEGIN TRAN
    IF NOT EXISTS (SELECT * FROM TOATHUOC
        WHERE MAHSBA = @MAHSBA AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH
            AND MATHUOC = @MATHUOC) BEGIN
        RAISERROR('INVALID TOATHUOC', 16, 1)
        ROLLBACK TRAN
        RETURN -1
    END

    DECLARE @SOLUONG INT, @COST INT
    SELECT @SOLUONG = SOLUONG FROM TOATHUOC WHERE MAHSBA = @MAHSBA
        AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH AND MATHUOC = @MATHUOC

    SET @COST = (SELECT GIATIEN FROM THUOC WHERE MATHUOC = @MATHUOC)
        * @SOLUONG

    WAITFOR DELAY '00:00:05'

    DELETE FROM TOATHUOC WHERE MAHSBA = @MAHSBA
        AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH AND MATHUOC = @MATHUOC

    WAITFOR DELAY '00:00:05'

    UPDATE GIAYKHAMBENH SET TONGTIENTHUOC -= @COST
    WHERE MAHSBA = @MAHSBA AND MAGIAYKHAMBENH = @MAGIAYKHAMBENH

    UPDATE THUOC SET SOLUONGTONKHO += @SOLUONG WHERE MATHUOC = @MATHUOC
COMMIT TRAN
RETURN 0
GO