-- Adminer 4.6.3 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

DROP TABLE IF EXISTS `sl_address`;
CREATE TABLE `sl_address` (
  `A_id` int(11) NOT NULL AUTO_INCREMENT,
  `A_mid` int(11) NOT NULL DEFAULT '0',
  `A_address` text NOT NULL,
  `A_name` text NOT NULL,
  `A_phone` text NOT NULL,
  `A_del` int(11) NOT NULL DEFAULT '0',
  `A_default` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`A_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_address` (`A_id`, `A_mid`, `A_address`, `A_name`, `A_phone`, `A_del`, `A_default`) VALUES
(1,	3,	'北京市XX区XX路XX小区XX号楼XX单元XXXX号',	'张三',	'15555555555',	0,	0),
(2,	3,	'上海市XX区XX路XX小区XX号楼XX单元XXXX号',	'李四',	'13333333333',	0,	1),
(3,	12,	'555',	'555',	'555',	0,	0),
(4,	12,	'5345345aa',	'435345aa',	'34534aa',	0,	1);

DROP TABLE IF EXISTS `sl_admin`;
CREATE TABLE `sl_admin` (
  `A_id` int(11) NOT NULL AUTO_INCREMENT,
  `A_login` text NOT NULL,
  `A_pwd` text NOT NULL,
  `A_del` int(11) NOT NULL DEFAULT '0',
  `A_head` text NOT NULL,
  `A_part` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`A_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_admin` (`A_id`, `A_login`, `A_pwd`, `A_del`, `A_head`, `A_part`) VALUES
(1,	'admin',	'7fef6171469e80d32c0559f88b377245',	0,	'201911192123112i.jpg',	'A0_0:1,A1_0:1,A1_1:1,A1_2:1,A1_3:1,A1_4:1,A1_5:1,A2_0:1,A2_1:1,A2_2:1,A2_3:1,A3_0:1,A3_1:1,A3_2:1,A3_3:1,A3_4:1,A4_0:1,A4_1:1,A4_2:1,A5_0:1,A5_1:1,A5_2:1,A5_3:1,A6_0:1,');

DROP TABLE IF EXISTS `sl_card`;
CREATE TABLE `sl_card` (
  `C_id` int(11) NOT NULL AUTO_INCREMENT,
  `C_content` text NOT NULL,
  `C_use` int(11) NOT NULL DEFAULT '0',
  `C_sort` int(11) NOT NULL DEFAULT '0',
  `C_del` int(11) NOT NULL DEFAULT '0',
  `C_mid` int(11) DEFAULT '0',
  `C_type` int(11) DEFAULT '0',
  PRIMARY KEY (`C_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_card` (`C_id`, `C_content`, `C_use`, `C_sort`, `C_del`, `C_mid`, `C_type`) VALUES
(35,	'Ei70HZQs0n4ifHdZuIR0rxdk97dEFIkz',	1,	3,	0,	0,	0),
(36,	'h3X88BkTMvD0ZPaJxJtEgKWOukfstRwr',	1,	3,	0,	0,	0),
(37,	'2oD2zsIQf9ESD75qrT7UsHBfVWaDTmht',	1,	3,	0,	0,	0),
(38,	'xifMiFcPTPxncHiaMsp4DW87sgJkIDMh',	1,	3,	0,	0,	0),
(39,	'lklbrQNHLnmQIV57t8HSSkQgFRwh9lui',	1,	3,	0,	0,	0),
(40,	'5ENZUlmhqb3aFyblLDE4Xr65KznzoBa5',	1,	3,	0,	0,	0),
(41,	'FTNptKMNaPOfNBIJszcQvm47LuDbDD3m',	1,	3,	0,	0,	0),
(42,	'LUnlWS4keCYfVkIvH8a99Fu4CHbatP3N',	1,	3,	0,	0,	0),
(43,	'55kAcFQvAkoUdi3ZCKgVbmJJt1gopve2',	1,	3,	0,	0,	0),
(44,	'EPxxRrLWieabGkbZAUvwTZ2Ald7GG7Sp',	0,	3,	0,	0,	0),
(45,	'OsbORCneoXmqoXKXXdmxBy0xX8839gMk',	0,	3,	0,	0,	0),
(46,	'ztPLx6A15QkX1qBlDc4c5XlS5WII2oRU',	0,	3,	0,	0,	0),
(47,	'NXrkObI4h1M05BCtSOPADpNMUBP5zONc',	0,	3,	0,	0,	0),
(48,	'Q7yh2WeuRY0WQz3VKhubwNizhZXiKJdl',	0,	3,	0,	0,	0),
(49,	'i8LN0ZK0qzpDX7Iga0KdpBvqpyyoqZKC',	0,	3,	0,	0,	0),
(50,	'2m85mKNseRb12jKZ30FjgRViSB0ucyrd',	0,	3,	0,	0,	0),
(51,	'ept9NraQeVGvsodAFOcH7L7aH5wXpWRP',	0,	3,	0,	0,	0),
(52,	'2epfQ1xPJuHFK4pRxAv7ehgHKKFCh1Mq',	0,	3,	0,	0,	0),
(53,	'HIeuWDrRoSp4OoVUE87uNKeiqRYxA2z7',	0,	3,	0,	0,	0),
(54,	'9HMYyAIwYAdEH1YHp1qcdfwaIQeTrPFV',	0,	3,	0,	0,	0),
(55,	'6qaZMLD7zTnzkOUEgbZrk9OqrD49uCwB',	0,	3,	0,	0,	0),
(56,	'Y73ZuQxhm1weUGMUnTYchtQ3dGz5TRaP',	0,	3,	0,	0,	0),
(57,	'bs2JlA1cfijk4lakYQBzz3PG96kKBKFj',	0,	3,	0,	0,	0),
(58,	'dD0XOexrzQnBVB3SFd0bfxkx7QijoBTY',	0,	3,	0,	0,	0),
(59,	'pdmglJucJBIka2r5EivlLhDQ2Ouqvv3o',	0,	3,	0,	0,	0),
(60,	'6vmMaLF5mkRhZW5epl548vOo49wSf0en',	0,	3,	0,	0,	0),
(61,	'wtR5MyQKIkFVArRx6F3UjjE79oF88bvQ',	0,	3,	0,	0,	0),
(62,	'WSZYCjEavxJvreHc8OiUDgLFzm60kfci',	0,	3,	0,	0,	0),
(63,	'OwrK7twkm31uP7YRUflS2BxU5DGGgNLe',	0,	3,	0,	0,	0),
(64,	'DrDbERTuc237qD0WIDvJP6hiXM9VAhXc',	0,	3,	0,	0,	0),
(65,	'TUmsMyO0hTm555xtPoK3EBuJkqbBYrGg',	0,	3,	0,	0,	0),
(66,	'0xH8cQk3IFS9SIqOG0xpDHT1C6GkrmUv',	0,	3,	0,	0,	0),
(67,	'xbyDmfHhF9mni84lCQuoaR0x9mnk96lr',	0,	3,	0,	0,	0),
(68,	'hi0mQEwSxOkJd4uyyja59WNd4ee22Ids',	0,	3,	0,	0,	0),
(69,	'jAlH9790FvZ2F6Y4Cnq9NOpc70XJ68DY',	0,	3,	0,	0,	0),
(70,	'lXgXNxPeIybXLpzqjfozCJleEpn89339',	0,	3,	0,	0,	0),
(71,	'QJQmoqrZg55oRUGIJTZFqPmF4MKr8Tez',	0,	3,	0,	0,	0),
(72,	'30Pr1rcQFhOuFpyhWu8iJupN4tytSW3q',	0,	3,	0,	0,	0),
(73,	'qNOBFLgxJgIOM9KsP2xTqgVXPnzQR8p0',	0,	3,	0,	0,	0),
(74,	'1kt4iYMeqyPsnr5h2kUViXLFhiJpgBYk',	0,	3,	0,	0,	0),
(75,	'AND0TyqmN72DcYW4tTMgnAc8nh1FJ7of',	0,	3,	0,	0,	0),
(76,	'SpRah8H3lKYTQS4VwWezq5kk18GnMX0N',	0,	3,	0,	0,	0),
(77,	'ngB5aNTwVYFUsv6mCnXJBNQFyKwLRUfX',	0,	3,	0,	0,	0),
(78,	'qLL3nn0V1niZOi3PlZougCSQFjO23c4o',	0,	3,	0,	0,	0),
(79,	'0DEcA84SJ6JKJkKk5eppSs1OdiYblzue',	0,	3,	0,	0,	0),
(80,	'GwuRqh8evj82Lt4XQDcdlMCaQvRRUIMt',	0,	3,	0,	0,	0),
(81,	'kvyoLXBuPZvCuZDe8HmD43ZUlaLsf5iL',	0,	3,	0,	0,	0),
(82,	'Ua3Qcdefwk14AtHy9dhRNcaGq6YpFR82',	0,	3,	0,	0,	0),
(83,	'W0dEs9yISIOyJPo4HXmd71HKcXquA7vh',	0,	3,	0,	0,	0),
(84,	'sWbQBlfIPCEH0HrrL9csT62997KMtGPs',	0,	3,	0,	0,	0),
(85,	'oVPgZWdYACjf7ZKakiFh1yXwJzMCW905',	0,	2,	0,	0,	0),
(86,	'7gb7Ioc6mgm9eYzfpSkuCeOrrrOyZqrr',	0,	2,	0,	0,	0),
(87,	'dahNGuyWwSFjX4edJTnZCzVy1BdPJweV',	0,	2,	0,	0,	0),
(88,	'0pweC2ElblmcCViFvmDjH3faVz2jBMcg',	0,	2,	0,	0,	0),
(89,	'kKjaGjg6NZ2UulpxEblikTGYs3d5fygU',	0,	2,	0,	0,	0),
(90,	'dv0vzSzuCPMmZem2xZyGOWE9L2aKT3Il',	0,	2,	0,	0,	0),
(91,	'2Y9YJu27z4ktnJ2i7QV6k0b5Knxvj3tY',	0,	2,	0,	0,	0),
(92,	'1JRlHZfycRUE4HFEPgv8yjAMy52nCtKM',	0,	2,	0,	0,	0),
(93,	'ryvwVgZ3AGU1Ui5n6enWG7V4Fzew3RrH',	0,	2,	0,	0,	0),
(94,	'9KcbHOx96l4hs6d35rBq26jM8pCb71CN',	0,	2,	0,	0,	0),
(95,	'5sfpYKvGBxeW69nDJInqrt9RzwQ9vjMs',	0,	2,	0,	0,	0),
(96,	'Uu0fADyYy0GXneFgyQ1TV97Tkjap6Y0X',	0,	2,	0,	0,	0),
(97,	'Qsp35SKXcNoEzfUnVAOkb0iwUNrhpoo4',	0,	2,	0,	0,	0),
(98,	'tsF7XuWAIFgsfoV6O1FR9Ej1i33PTE2q',	0,	2,	0,	0,	0),
(99,	'wCpELl3PuQws6LjnxSCH7VOkKPiJ5WpT',	0,	2,	0,	0,	0),
(100,	'zRMghA0Gr5yLX9Zoa8GUOKgxWWPsCdDf',	0,	2,	0,	0,	0),
(101,	'V5sbCFeAYjMEcoSKekUqoHeo7FxQRWM0',	0,	2,	0,	0,	0),
(102,	'CYMVoph97nqtRisjAO5eeMqnxF7d0Kgt',	0,	2,	0,	0,	0),
(103,	'NtBLVuqKaOb8Yh4GggZbB7cG6iC1HFv5',	0,	2,	0,	0,	0),
(104,	'7ZJl60t75WqSeDKNz5I41YZkeILBzwUM',	0,	2,	0,	0,	0),
(105,	'OKBfSl7fHGTDEot08s6pVGJvNMKG1CgG',	0,	2,	0,	0,	0),
(106,	'M808RfpDwhBRetckog2V9KqFoxEuapS9',	0,	2,	0,	0,	0),
(107,	'pwQv6XCCdJDVf43hdjN2MWohSYv3c7v8',	0,	2,	0,	0,	0),
(108,	'uFIdTfgMy04IyqqvZYFVfadV1YrkVi2C',	0,	2,	0,	0,	0),
(109,	'B5yfu4SbyidmC71Hqj40CyzM9vHFo5Fy',	0,	2,	0,	0,	0),
(110,	'7iHlgsN8P7QuPYz9lS8cOQVYEA9L0wRl',	0,	2,	0,	0,	0),
(111,	'cdAZf9dhcIKKCqbeKJ1hBVUxDQls6KMz',	0,	2,	0,	0,	0),
(112,	'acQ0BBYQhVRD2ttGO32hGzAsKgtzn5cp',	0,	2,	0,	0,	0),
(113,	'bOZ6hhWpiJnc65MVa0uKaVGB7553wBx1',	0,	2,	0,	0,	0),
(114,	'zksbjG0sgynReym1Iuk3td7PSpMMaMJs',	0,	2,	0,	0,	0),
(115,	'tEdVLueHTj9SoebBQNksKN5F74vIKxKR',	0,	2,	0,	0,	0),
(116,	'bmSG0yq4ytekqlH86gItJIWk3lzb2g7X',	0,	2,	0,	0,	0),
(117,	'JqDH5WRcx0gsgAkWAaJut8mibOLa8XEd',	0,	2,	0,	0,	0),
(118,	'rqTdh5vZQfqrSJApsC3xxbZFFjF2GdUM',	0,	2,	0,	0,	0),
(119,	'uuO8rBLgStOVU8yize3suucJ8aTfvqCR',	0,	2,	0,	0,	0),
(120,	'YBvcUrXI3dw52dZ15hP7opko31XWmRqO',	0,	2,	0,	0,	0),
(121,	'naWYgS2hGqZeQcv6NsCAWrGwuxWsIpsY',	0,	2,	0,	0,	0),
(122,	'MzzigFCpvj4pIRR8rVMZI1canDmXKyZb',	0,	2,	0,	0,	0),
(123,	'GQT9SXllYuSzNzM6jOE6RGyItiTM6DOu',	0,	2,	0,	0,	0),
(124,	'tHPjSGYAH642sbd5rlSifAzYlfQaCo3j',	0,	2,	0,	0,	0),
(125,	'G98GBsTuiUwKeACKfx2JwipyOsEWA7CQ',	0,	2,	0,	0,	0),
(126,	'Wg9AcU6ButQhgvBlOp8XLoBPEgnEC4Wg',	0,	2,	0,	0,	0),
(127,	'GyxjWCAUZi6Zh6uNi56QER402Gwl3wF3',	0,	2,	0,	0,	0),
(128,	'HkRhLNPUWePJBAir6OubDfnpZ7nEYiM1',	0,	2,	0,	0,	0),
(129,	'rJigda2CXSF4LNVQ6CHfOKegPdZQx9Ee',	0,	2,	0,	0,	0),
(130,	'035epq4rZY0DiiUJq3F6Rh3FgO2LRoGQ',	0,	2,	0,	0,	0),
(131,	'9JGhhgy9mtZ3qyI5jdPy3qzFAF46UXHW',	0,	2,	0,	0,	0),
(132,	'mdqPfTrb54LepdqdgVwp7SytkF1K8en1',	0,	2,	0,	0,	0),
(133,	'wueKXr9fYshcD9QDEwQ9OVxDl6V48cwO',	0,	2,	0,	0,	0),
(134,	'WDs0apJWMBgkGP0zGSKEKLhZvMVzmm9P',	0,	2,	0,	0,	0),
(135,	'lwDhLEpjqVWF0NRzvnyWbS5htNfzb6ff',	1,	1,	0,	0,	0),
(136,	'TXkQnW5zzvbw0q8saweCOdDBV1ZdfBqz',	0,	1,	0,	0,	0),
(137,	'79WIWRHYHod8g1XhDpEIMviYHFw0OPXl',	0,	1,	0,	0,	0),
(138,	'tU5sIDPsyIgHzro1IGQEG1ejGfy5JQ0x',	0,	1,	0,	0,	0),
(139,	'O71AS64w1KjLSxAPMz5p78b4uv3Q2flK',	0,	1,	0,	0,	0),
(140,	'mZiONYCptyroOY5CJQSvfuAGnSEmK1BH',	0,	1,	0,	0,	0),
(141,	'kjKiH8C3pDoIfPNYJQjdobJQQSDISYkN',	0,	1,	0,	0,	0),
(142,	'YONlyUTWdJShHR5l4DvVhEGbQ4APkVow',	0,	1,	0,	0,	0),
(143,	'IWDdIeB19pYtO77k0pKKfpV4uRbsuMcS',	0,	1,	0,	0,	0),
(144,	'VyuzLW6aLNmlHEi4mPb9GQn4eP8WA1Kk',	0,	1,	0,	0,	0),
(145,	'uWUtck9lrQT0UOXmYxF8lWX6PzNfux18',	0,	1,	0,	0,	0),
(146,	'oiezOfduDxqTt4IaMfClX0LgFz9tHNLl',	0,	1,	0,	0,	0),
(147,	'AyNqDMCVJr01hwziz5MdOSbLVNb4qHPB',	0,	1,	0,	0,	0),
(148,	'IdZHsKnk4wLH4JdDEM31zUFGYXH1k7G1',	0,	1,	0,	0,	0),
(149,	'eG4QrNO60L9LVr0MznwjUyQtDfqOffwc',	0,	1,	0,	0,	0),
(150,	'jqpb6PKxFl8rk9j8pHu5cKXNJJXn5kYP',	0,	1,	0,	0,	0),
(151,	'QDuVPqNpJpieHuF9C2ygQUJiUQgAyXzs',	0,	1,	0,	0,	0),
(152,	'lEnmvD0aZRifPigSTE68l7aCE3eLBBL6',	0,	1,	0,	0,	0),
(153,	'Rh9HdjoUtA3AmZwhhsGOaSLW8MqKQhJ4',	0,	1,	0,	0,	0),
(154,	'9eyauqQ8dF1T3o2cSvqbPK72yVrfpgM9',	0,	1,	0,	0,	0),
(155,	'DJpYdUlPlphzXGWIJMnLAzNCARsIrZXk',	0,	1,	0,	0,	0),
(156,	'hUTyUz5PUYJvNZLnTWyXtPllWXyxLskN',	0,	1,	0,	0,	0),
(157,	'SFnPw7ZRG9pE6fhfKurjHfh0cu8aWXiK',	0,	1,	0,	0,	0),
(158,	'P4RuddnfhFVkQUEhVf1YqpoCFBet1ggc',	0,	1,	0,	0,	0),
(159,	'28Fcv21lp7rS6Sb8Q90kFt4IDWcbdtC0',	0,	1,	0,	0,	0),
(160,	'K4MJbMieShWTiBQs9mThhb33qn9ZVVRm',	0,	1,	0,	0,	0),
(161,	'HJb4mJx8S2FvHNOjw3gHkVgasutDpyJ4',	0,	1,	0,	0,	0),
(162,	'UslnRpOwiPw2A3d7CwK2rcvPE0jzB8QD',	0,	1,	0,	0,	0),
(163,	'jnRoNwhqj0nhvaQGNqEtMUIBsNRBTKki',	0,	1,	0,	0,	0),
(164,	'I4j7RXWh9931UNHWCPliqzFcUVBagZs5',	0,	1,	0,	0,	0),
(165,	'zJapiWXiCvQW5da5IzIMJT87Rk9QQ1cw',	0,	1,	0,	0,	0),
(166,	'rgMSXAWesfA6HOyenUOoLGw2ytMJdygL',	0,	1,	0,	0,	0),
(167,	'etxdnOK2HytdHUyLe7Nu4aYxAheaYf24',	0,	1,	0,	0,	0),
(168,	'uhVuVSsvlD8AKQfdpQsAaPKdsySuXFg3',	0,	1,	0,	0,	0),
(169,	'X2I1hN1bfgtX1284Km0QkDNw4xyUgAF6',	0,	1,	0,	0,	0),
(170,	'5joWzCgpcPJZmfW75OzweJ3jgD9lOHbW',	0,	1,	0,	0,	0),
(171,	'7YRwcZyXJ5A9bRy5UKa9h6VDvrmb6q3n',	0,	1,	0,	0,	0),
(172,	'DNUe5cAxnT1uHsdNWlZ6SVe47dthxIy0',	0,	1,	0,	0,	0),
(173,	'DICKIBJZGy4y3kI5IvgGVC21rcu23BTh',	0,	1,	0,	0,	0),
(174,	'zKPGRyk8VYZ9YHEXs3pj9U8YiYOQB46u',	0,	1,	0,	0,	0),
(175,	'ukOr9tBiHjQFcEGienEFdvEQxSghj5Tw',	0,	1,	0,	0,	0),
(176,	'5QeUGYOFkMN62EzAXUfeAUNHh85Z6fep',	0,	1,	0,	0,	0),
(177,	'XnE4MGCy3lwcXf1NoK531l0gOnu87Ife',	0,	1,	0,	0,	0),
(178,	'Dv4K4l0JTdRyeVlsVRG3kH91Yq8xNj3t',	0,	1,	0,	0,	0),
(179,	'u1siu5FCgIpPmTgcitzmmMI37lRIdwqX',	0,	1,	0,	0,	0),
(180,	'TZmylJPJKMIVhff53KQdXI52cZdOX9Ma',	0,	1,	0,	0,	0),
(181,	'bqO9hMyBcSIqtFNnIee1UDXOXi3dEKLf',	0,	1,	0,	0,	0),
(182,	'6mCsvZ4tqfYJOzEzYJkVuesuOgg9fW5m',	0,	1,	0,	0,	0),
(183,	'OtwgZdXh5DT7xvOQlLESvPPzafQdzxMu',	0,	1,	0,	0,	0),
(184,	'Ruj4kqjXvHTVPdXtOEYoTb5gcVXqiY1O',	0,	1,	0,	0,	0);

DROP TABLE IF EXISTS `sl_colletion`;
CREATE TABLE `sl_colletion` (
  `C_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `C_type` int(10) DEFAULT '0',
  `C_cid` int(10) DEFAULT '0',
  `C_mid` int(10) DEFAULT '0',
  PRIMARY KEY (`C_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `sl_config`;
CREATE TABLE `sl_config` (
  `C_id` int(11) NOT NULL AUTO_INCREMENT,
  `C_title` text NOT NULL,
  `C_keyword` text NOT NULL,
  `C_description` text NOT NULL,
  `C_copyright` text NOT NULL,
  `C_code` text NOT NULL,
  `C_alipay_pid` text NOT NULL,
  `C_alipay_pkey` text NOT NULL,
  `C_wx_appid` text NOT NULL,
  `C_wx_appsecret` text NOT NULL,
  `C_wx_mchid` text NOT NULL,
  `C_wx_key` text NOT NULL,
  `C_7pay_pid` text NOT NULL,
  `C_7pay_pkey` text NOT NULL,
  `C_logo` text NOT NULL,
  `C_ico` text NOT NULL,
  `C_vip1` decimal(10,2) NOT NULL DEFAULT '0.00',
  `C_vip2` decimal(10,2) NOT NULL DEFAULT '0.00',
  `C_vip3` decimal(10,2) NOT NULL DEFAULT '0.00',
  `C_vip6` decimal(10,2) NOT NULL DEFAULT '0.00',
  `C_vip12` decimal(10,2) NOT NULL DEFAULT '0.00',
  `C_vip0` decimal(10,2) NOT NULL DEFAULT '0.00',
  `C_p_discount` decimal(10,2) DEFAULT NULL,
  `C_n_discount` decimal(10,2) DEFAULT NULL,
  `C_alipayon` int(11) NOT NULL DEFAULT '0',
  `C_wxpayon` int(11) NOT NULL DEFAULT '0',
  `C_alicodeon` int(11) NOT NULL DEFAULT '0',
  `C_wxcodeon` int(11) NOT NULL DEFAULT '0',
  `C_kefu` text NOT NULL,
  `C_template` text NOT NULL,
  `C_qrcode` text NOT NULL,
  `C_email` text NOT NULL,
  `C_phone` text NOT NULL,
  `C_beian` text NOT NULL,
  `C_alicode` text NOT NULL,
  `C_wxcode` text NOT NULL,
  `C_qqid` text NOT NULL,
  `C_qqkey` text NOT NULL,
  `C_qqon` int(11) NOT NULL DEFAULT '0',
  `C_wxon` int(11) NOT NULL DEFAULT '0',
  `C_authcode` text NOT NULL,
  `C_7payon` int(11) DEFAULT '0',
  `C_rzon` int(11) DEFAULT '0',
  `C_fee` int(11) DEFAULT '0',
  `C_html` int(11) DEFAULT '0',
  `C_mailtype` int(11) DEFAULT '0',
  `C_mailcode` varchar(200) DEFAULT NULL,
  `C_smtp` varchar(200) DEFAULT NULL,
  `C_wxapp_id` varchar(200) DEFAULT NULL,
  `C_wxapp_key` varchar(200) DEFAULT NULL,
  `C_aliapp_id` varchar(200) DEFAULT NULL,
  `C_aliapp_key` varchar(200) DEFAULT NULL,
  `C_aliapp_key2` varchar(200) DEFAULT NULL,
  `C_bdapp_id` varchar(200) DEFAULT NULL,
  `C_bdapp_key` varchar(200) DEFAULT NULL,
  `C_bdapp_key2` varchar(200) DEFAULT NULL,
  `C_qqapp_id` varchar(200) DEFAULT NULL,
  `C_qqapp_key` varchar(200) DEFAULT NULL,
  `C_zjapp_id` varchar(200) DEFAULT NULL,
  `C_zjapp_key` varchar(200) DEFAULT NULL,
  `C_appt` varchar(200) DEFAULT NULL,
  `fx1` int(11) DEFAULT '0',
  `fx2` int(11) DEFAULT '0',
  `fx3` int(11) DEFAULT '0',
  `C_fx1` int(11) DEFAULT '0',
  `C_fx2` int(11) DEFAULT '0',
  `C_fx3` int(11) DEFAULT '0',
  `C_codepayon` int(11) DEFAULT '0',
  `C_codepay_id` varchar(200) DEFAULT NULL,
  `C_codepay_key` varchar(200) DEFAULT NULL,
  `C_p_discount2` decimal(10,2) DEFAULT NULL,
  `C_n_discount2` decimal(10,2) DEFAULT NULL,
  `C_memberon` int(11) DEFAULT '0',
  `C_rzfee` decimal(10,2) DEFAULT NULL,
  `C_wap` varchar(200) DEFAULT NULL,
  `C_zd` decimal(10,2) DEFAULT NULL,
  `C_rzfeetype` int(11) DEFAULT '0',
  `C_pwdcode` varchar(200) DEFAULT NULL,
  `C_twice` int(11) DEFAULT '0',
  `C_uncopy` int(11) DEFAULT '0',
  `C_slide` int(11) DEFAULT '0',
  `C_backup` int(11) DEFAULT '0',
  `C_mobile` varchar(200) DEFAULT NULL,
  `C_smssign` varchar(200) DEFAULT NULL,
  `C_userid` varchar(200) DEFAULT NULL,
  `C_codeid` varchar(200) DEFAULT NULL,
  `C_codekey` varchar(200) DEFAULT NULL,
  `C_payjson` int(11) DEFAULT '0',
  `C_payjs_id` varchar(200) DEFAULT NULL,
  `C_payjs_key` varchar(200) DEFAULT NULL,
  `C_kefuon` int(11) DEFAULT '0',
  `C_punsh` int(11) DEFAULT '0',
  `C_nunsh` int(11) DEFAULT '0',
  `C_dxon` int(11) DEFAULT '0',
  `C_notice` varchar(500) DEFAULT NULL,
  `C_regon` int(11) DEFAULT '0',
  `C_fzon` int(11) DEFAULT '0',
  `C_fzk` int(11) DEFAULT '0',
  `C_fdomain` varchar(200) DEFAULT NULL,
  `C_bd_token` varchar(200) DEFAULT NULL,
  `C_m_logo` varchar(200) DEFAULT NULL,
  `C_m_position` int(11) DEFAULT '0',
  `C_m_width` int(11) DEFAULT '0',
  `C_m_height` int(11) DEFAULT '0',
  `C_m_transparent` int(11) DEFAULT '0',
  `C_dmfon` int(11) DEFAULT '0',
  `C_format` varchar(500) DEFAULT NULL,
  `C_dmf_id` varchar(200) DEFAULT NULL,
  `C_dmf_key` varchar(2000) DEFAULT NULL,
  `C_dmf_key2` varchar(2000) DEFAULT NULL,
  `C_codepay_type` varchar(200) DEFAULT NULL,
  `C_osson` int(11) DEFAULT '0',
  `C_oss_id` varchar(200) DEFAULT NULL,
  `C_oss_key` varchar(200) DEFAULT NULL,
  `C_oss_domain` varchar(200) DEFAULT NULL,
  `C_bucket` varchar(200) DEFAULT NULL,
  `C_region` varchar(200) DEFAULT NULL,
  `C_admin` varchar(200) DEFAULT NULL,
  `C_dx1` int(11) DEFAULT '0',
  `C_dx2` int(11) DEFAULT '0',
  `C_dx3` int(11) DEFAULT '0',
  `C_dx4` int(11) DEFAULT '0',
  `C_dx5` int(11) DEFAULT '0',
  `C_hotwords` varchar(200) DEFAULT NULL,
  `C_fzvip` int(11) DEFAULT '0',
  `C_qpayon` int(11) DEFAULT '0',
  `C_qpay_appid` varchar(200) DEFAULT NULL,
  `C_qpay_mchid` varchar(200) DEFAULT NULL,
  `C_qpay_key` varchar(200) DEFAULT NULL,
  `C_ttpay_appid` varchar(200) DEFAULT NULL,
  `C_ttpay_mchid` varchar(200) DEFAULT NULL,
  `C_ttpay_secret` varchar(200) DEFAULT NULL,
  `C_epay_url` varchar(200) DEFAULT NULL,
  `C_epay_id` varchar(200) DEFAULT NULL,
  `C_epay_key` varchar(200) DEFAULT NULL,
  `C_epay_type` varchar(200) DEFAULT NULL,
  `C_kd` varchar(200) DEFAULT NULL,
  `C_zzk` int(11) DEFAULT '0',
  `C_c_discount` decimal(10,2) DEFAULT '0.00',
  `C_c_discount2` decimal(10,2) DEFAULT '0.00',
  `C_regr` varchar(200) DEFAULT NULL,
  `C_fen1` int(11) DEFAULT '0',
  `C_fen2` int(11) DEFAULT '0',
  `C_fen3` decimal(10,2) DEFAULT '0.00',
  `C_baoyou` decimal(10,2) DEFAULT '0.00',
  `C_postage` decimal(10,2) DEFAULT '0.00',
  `C_qqon2` int(11) DEFAULT '0',
  `C_wxon2` int(11) DEFAULT '0',
  `C_newsds` text,
  `C_buylimit` int(11) DEFAULT '0',
  `C_viplimit` int(11) DEFAULT '0',
  `C_cache` int(11) DEFAULT '0',
  `C_bondtype` int(11) DEFAULT '0',
  `C_bond` decimal(10,2) DEFAULT '0.00',
  `C_alipaynewon` int(11) DEFAULT '0',
  `C_reuseid` int(11) DEFAULT '0',
  `C_hupay_id` text,
  `C_hupay_key` text,
  `C_hupay_id2` text,
  `C_hupay_key2` text,
  `C_hupay_type` text,
  `C_jipay_id` text,
  `C_jipay_key` text,
  `C_jipay_type` text,
  `C_alipaynewid` text,
  `C_alipaynewkey` text,
  `C_alipaynewkey2` text,
  `C_payjs_type` text,
  `C_payjs_id2` text,
  `C_payjs_key2` text,
  PRIMARY KEY (`C_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_config` (`C_id`, `C_title`, `C_keyword`, `C_description`, `C_copyright`, `C_code`, `C_alipay_pid`, `C_alipay_pkey`, `C_wx_appid`, `C_wx_appsecret`, `C_wx_mchid`, `C_wx_key`, `C_7pay_pid`, `C_7pay_pkey`, `C_logo`, `C_ico`, `C_vip1`, `C_vip2`, `C_vip3`, `C_vip6`, `C_vip12`, `C_vip0`, `C_p_discount`, `C_n_discount`, `C_alipayon`, `C_wxpayon`, `C_alicodeon`, `C_wxcodeon`, `C_kefu`, `C_template`, `C_qrcode`, `C_email`, `C_phone`, `C_beian`, `C_alicode`, `C_wxcode`, `C_qqid`, `C_qqkey`, `C_qqon`, `C_wxon`, `C_authcode`, `C_7payon`, `C_rzon`, `C_fee`, `C_html`, `C_mailtype`, `C_mailcode`, `C_smtp`, `C_wxapp_id`, `C_wxapp_key`, `C_aliapp_id`, `C_aliapp_key`, `C_aliapp_key2`, `C_bdapp_id`, `C_bdapp_key`, `C_bdapp_key2`, `C_qqapp_id`, `C_qqapp_key`, `C_zjapp_id`, `C_zjapp_key`, `C_appt`, `fx1`, `fx2`, `fx3`, `C_fx1`, `C_fx2`, `C_fx3`, `C_codepayon`, `C_codepay_id`, `C_codepay_key`, `C_p_discount2`, `C_n_discount2`, `C_memberon`, `C_rzfee`, `C_wap`, `C_zd`, `C_rzfeetype`, `C_pwdcode`, `C_twice`, `C_uncopy`, `C_slide`, `C_backup`, `C_mobile`, `C_smssign`, `C_userid`, `C_codeid`, `C_codekey`, `C_payjson`, `C_payjs_id`, `C_payjs_key`, `C_kefuon`, `C_punsh`, `C_nunsh`, `C_dxon`, `C_notice`, `C_regon`, `C_fzon`, `C_fzk`, `C_fdomain`, `C_bd_token`, `C_m_logo`, `C_m_position`, `C_m_width`, `C_m_height`, `C_m_transparent`, `C_dmfon`, `C_format`, `C_dmf_id`, `C_dmf_key`, `C_dmf_key2`, `C_codepay_type`, `C_osson`, `C_oss_id`, `C_oss_key`, `C_oss_domain`, `C_bucket`, `C_region`, `C_admin`, `C_dx1`, `C_dx2`, `C_dx3`, `C_dx4`, `C_dx5`, `C_hotwords`, `C_fzvip`, `C_qpayon`, `C_qpay_appid`, `C_qpay_mchid`, `C_qpay_key`, `C_ttpay_appid`, `C_ttpay_mchid`, `C_ttpay_secret`, `C_epay_url`, `C_epay_id`, `C_epay_key`, `C_epay_type`, `C_kd`, `C_zzk`, `C_c_discount`, `C_c_discount2`, `C_regr`, `C_fen1`, `C_fen2`, `C_fen3`, `C_baoyou`, `C_postage`, `C_qqon2`, `C_wxon2`, `C_newsds`, `C_buylimit`, `C_viplimit`, `C_cache`, `C_bondtype`, `C_bond`, `C_alipaynewon`, `C_reuseid`, `C_hupay_id`, `C_hupay_key`, `C_hupay_id2`, `C_hupay_key2`, `C_hupay_type`, `C_jipay_id`, `C_jipay_key`, `C_jipay_type`, `C_alipaynewid`, `C_alipaynewkey`, `C_alipaynewkey2`, `C_payjs_type`, `C_payjs_id2`, `C_payjs_key2`) VALUES
(1,	'您的网站名称',	'虚拟商品,自动发货,在线支付,付费阅读',	'发货100-虚拟商品自动发货系统',	'Copyright © 2015-2020 您的公司名称 版权所有',	'',	'',	'',	'',	'',	'',	'',	'',	'',	'20191202214409zX.png',	'20191208113035eM.ico',	10.00,	20.00,	30.00,	60.00,	120.00,	999.00,	9.00,	5.00,	1,	1,	0,	0,	'123123123_qq_售前咨询|taobao_ww_售后服务|010-10086_phone_代理咨询',	't15',	'20191126224352Wf.jpg',	'450245869@qq.com',	'010-10086',	'京ICP备00000000号',	'',	'',	'',	'',	0,	0,	'',	0,	0,	10,	0,	0,	'',	'',	'',	'',	'',	'',	'',	'',	'',	'',	'',	'',	'',	'',	'shop',	0,	0,	0,	0,	0,	0,	0,	'',	'',	1.00,	1.00,	1,	100.00,	't15',	100.00,	0,	'',	1,	0,	1,	0,	'',	'',	'0',	'',	'',	0,	'',	'',	1,	0,	0,	0,	'声明：本站所有游戏来源于互联网！若侵犯到您的权益，请联系站长，我们将及时处理。 若您需要使用非免费的软件或服务，请购买正版授权并合法使用 游戏失效联系客服补发每天都上传游戏  游戏群号XXXXXXXXX',	1,	0,	0,	'',	'',	'20191202214409zX.png',	0,	100,	0,	50,	0,	'jpg,jpeg,png,gif,bmp,ico,xls,xlsx,txt,sql,csv,mp4,rar,apk,doc',	'',	'',	'',	'alipay,wxpay,qqpay',	0,	'',	'',	'',	'',	'',	'admin',	0,	0,	0,	0,	0,	'点卡,教程,源码',	30,	0,	'',	'',	'',	'',	'',	'',	'',	'',	'',	'',	'',	1,	8.00,	2.00,	'email',	1,	1,	0.01,	0.00,	0.00,	0,	0,	'',	0,	0,	0,	0,	0.00,	0,	0,	'',	'',	'',	'',	'alipay,wxpay',	'',	'',	'alipay,wxpay',	'',	'',	'',	'alipay,wxpay',	'',	'');

DROP TABLE IF EXISTS `sl_course`;
CREATE TABLE `sl_course` (
  `C_id` int(11) NOT NULL AUTO_INCREMENT,
  `C_title` text NOT NULL,
  `C_pic` text NOT NULL,
  `C_lesson` text NOT NULL,
  `C_time` datetime NOT NULL,
  `C_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `C_content` text NOT NULL,
  `C_order` int(11) NOT NULL DEFAULT '0',
  `C_del` int(11) NOT NULL DEFAULT '0',
  `C_sort` int(11) NOT NULL,
  `C_top` int(11) NOT NULL DEFAULT '0',
  `C_view` int(11) NOT NULL DEFAULT '0',
  `C_author` text NOT NULL,
  `C_mid` int(11) NOT NULL DEFAULT '0',
  `C_sh` int(11) NOT NULL DEFAULT '1',
  `C_shuxing` text NOT NULL,
  PRIMARY KEY (`C_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `sl_csort`;
CREATE TABLE `sl_csort` (
  `S_id` int(11) NOT NULL AUTO_INCREMENT,
  `S_title` text NOT NULL,
  `S_del` int(11) NOT NULL DEFAULT '0',
  `S_content` text NOT NULL,
  `S_mid` int(11) DEFAULT '0',
  `S_order` int(11) DEFAULT '0',
  `S_sub` int(11) DEFAULT '0',
  PRIMARY KEY (`S_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_csort` (`S_id`, `S_title`, `S_del`, `S_content`, `S_mid`, `S_order`, `S_sub`) VALUES
(1,	'点卡充值',	0,	'',	0,	0,	9999),
(2,	'VIP会员帐号',	0,	'121212',	0,	0,	9999),
(3,	'激活码',	0,	'12',	0,	0,	9999),
(9999,	'主分类',	0,	'主分类',	0,	0,	0);

DROP TABLE IF EXISTS `sl_evaluate`;
CREATE TABLE `sl_evaluate` (
  `E_id` int(11) NOT NULL AUTO_INCREMENT,
  `E_mid` int(11) NOT NULL DEFAULT '0',
  `E_content` text NOT NULL,
  `E_oid` int(11) NOT NULL DEFAULT '0',
  `E_time` datetime NOT NULL,
  `E_reply` text NOT NULL,
  `E_del` int(11) NOT NULL DEFAULT '0',
  `E_star` int(11) NOT NULL DEFAULT '5',
  PRIMARY KEY (`E_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_evaluate` (`E_id`, `E_mid`, `E_content`, `E_oid`, `E_time`, `E_reply`, `E_del`, `E_star`) VALUES
(1,	3,	'产品非常好',	28,	'2019-12-10 10:49:16',	'谢谢您的购买',	0,	5),
(2,	3,	'调然后柔荑花的个人复合弓的鬼地方',	29,	'2019-12-10 11:27:37',	'2222',	0,	5),
(3,	3,	'123123',	28,	'2019-12-10 15:00:34',	'现在的保罗打球进入了另一个境界，身体状态的下滑已无法避免，可保罗对场上局势的判断和清晰的头脑一直没变，在击败森林狼的比赛中保罗抓住对手延误比赛的机会帮助球队加上取胜，在对阵开拓者的比赛中同样指了安东尼一个技术犯规，在进攻端或许保罗已经无法攻城拔寨，但只要他在场就一定会给球队做出贡献。',	0,	5),
(4,	3,	'11122333',	26,	'0000-00-00 00:00:00',	'',	0,	3);

DROP TABLE IF EXISTS `sl_guestbook`;
CREATE TABLE `sl_guestbook` (
  `G_id` int(11) NOT NULL AUTO_INCREMENT,
  `G_name` text NOT NULL,
  `G_title` text NOT NULL,
  `G_phone` text NOT NULL,
  `G_msg` text NOT NULL,
  `G_sh` int(11) NOT NULL DEFAULT '0',
  `G_mail` text NOT NULL,
  `G_del` int(11) NOT NULL DEFAULT '0',
  `G_time` datetime NOT NULL,
  `G_reply` text NOT NULL,
  PRIMARY KEY (`G_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_guestbook` (`G_id`, `G_name`, `G_title`, `G_phone`, `G_msg`, `G_sh`, `G_mail`, `G_del`, `G_time`, `G_reply`) VALUES
(1,	'2',	'1',	'15555555555',	'44',	0,	'',	0,	'2019-12-08 11:22:42',	'12121212');

DROP TABLE IF EXISTS `sl_history`;
CREATE TABLE `sl_history` (
  `H_id` int(11) NOT NULL AUTO_INCREMENT,
  `H_hid` int(11) NOT NULL DEFAULT '0',
  `H_hid2` int(11) NOT NULL DEFAULT '0',
  `H_type` int(11) NOT NULL DEFAULT '0',
  `H_mid` int(11) NOT NULL DEFAULT '0',
  `H_time` datetime DEFAULT NULL,
  PRIMARY KEY (`H_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `sl_link`;
CREATE TABLE `sl_link` (
  `L_id` int(11) NOT NULL AUTO_INCREMENT,
  `L_title` text NOT NULL,
  `L_link` text NOT NULL,
  `L_pic` text NOT NULL,
  `L_order` int(11) NOT NULL DEFAULT '0',
  `L_del` int(11) NOT NULL DEFAULT '0',
  `L_content` text NOT NULL,
  PRIMARY KEY (`L_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_link` (`L_id`, `L_title`, `L_link`, `L_pic`, `L_order`, `L_del`, `L_content`) VALUES
(1, '微信对话生成器',  'https://www.baituling.com',  '20191120222544D2.png', 5,  0,  '微信对话生成器'),
(2, '闪灵短链', 'http://dwz.s-cms.cn',  '20191120222606G6.png', 1,  0,  '闪灵短链'),
(4, '新浪', 'http://www.sina.com',  '20191120223409Ld.png', 3,  0,  '新浪'),
(5, '淘宝网',  'http://www.taobao.com',  '20191203142808Og.png', 2,  0,  '淘宝网'),
(6, '360搜索',  'http://www.so.com',  '201912031428507G.png', 4,  0,  '360搜索'),
(7, '企业建站系统', 'https://www.s-cms.cn', 'scms.png', 4,  0,  '企业建站系统'),
(8, '发货100',  'https://www.fahuo100.cn',  '20191203142923qI.png', 6,  0,  '发货100');

DROP TABLE IF EXISTS `sl_list`;
CREATE TABLE `sl_list` (
  `L_id` int(11) NOT NULL AUTO_INCREMENT,
  `L_mid` int(11) NOT NULL DEFAULT '0',
  `L_no` text NOT NULL,
  `L_title` text NOT NULL,
  `L_money` decimal(10,2) NOT NULL DEFAULT '0.00',
  `L_del` int(11) NOT NULL DEFAULT '0',
  `L_time` datetime NOT NULL,
  `L_genkey` text NOT NULL,
  `L_sh` int(11) DEFAULT '1',
  `L_no2` varchar(200) DEFAULT NULL,
  `L_type` int(11) DEFAULT '0',
  PRIMARY KEY (`L_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `sl_log`;
CREATE TABLE `sl_log` (
  `L_id` int(11) NOT NULL AUTO_INCREMENT,
  `L_time` text NOT NULL,
  `L_add` text NOT NULL,
  `L_ip` text NOT NULL,
  `L_title` text NOT NULL,
  `L_del` int(11) NOT NULL DEFAULT '0',
  `L_aid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`L_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_log` (`L_id`, `L_time`, `L_add`, `L_ip`, `L_title`, `L_del`, `L_aid`) VALUES
(1,	'2020-01-19 20:14:59',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(32,	'2020-04-10 21:55:53',	'山东省淄博市',	'::1',	'新增菜单',	0,	1),
(33,	'2020-04-15 23:39:32',	'',	'::1',	'后台登录成功',	0,	0),
(34,	'2020-04-15 23:39:38',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(35,	'2020-04-15 23:39:58',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(36,	'2020-04-15 23:40:05',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(37,	'2020-04-15 23:40:41',	'山东省淄博市',	'::1',	'新增菜单',	0,	1),
(38,	'2020-07-15 16:34:54',	'',	'::1',	'后台登录成功',	0,	0),
(39,	'2020-07-16 14:26:08',	'山东省',	'::1',	'后台登录成功',	0,	1),
(40,	'2020-07-17 09:10:10',	'山东省',	'::1',	'后台登录成功',	0,	1),
(41,	'2020-07-18 00:58:30',	'山东省',	'::1',	'后台登录成功',	0,	1),
(42,	'2020-07-18 00:58:49',	'山东省',	'::1',	'编辑基本设置',	0,	1),
(43,	'2020-07-21 10:10:46',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(44,	'2020-07-24 09:41:20',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(45,	'2020-08-03 12:45:21',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(46,	'2020-08-04 09:27:30',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(47,	'2020-08-05 00:59:55',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(48,	'2020-08-07 10:00:13',	'山东省',	'::1',	'后台登录成功',	0,	1),
(49,	'2020-08-07 10:03:22',	'山东省',	'::1',	'后台登录成功',	0,	1),
(50,	'2020-08-09 00:17:36',	'山东省',	'::1',	'后台登录成功',	0,	1),
(51,	'2020-08-11 08:57:37',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(52,	'2020-08-14 09:22:29',	'山东省',	'::1',	'后台登录成功',	0,	1),
(53,	'2020-08-16 11:11:45',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(54,	'2020-08-17 11:08:56',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(55,	'2020-08-18 10:10:46',	'山东省',	'::1',	'后台登录成功',	0,	1),
(56,	'2020-10-11 17:16:32',	'',	'::1',	'后台登录成功',	0,	0),
(57,	'2020-10-13 09:40:32',	'山东省',	'::1',	'后台登录成功',	0,	1),
(58,	'2020-10-14 09:36:29',	'山东省',	'::1',	'后台登录成功',	0,	1),
(59,	'2020-10-15 10:02:45',	'山东省',	'::1',	'后台登录成功',	0,	1),
(60,	'2020-10-17 10:21:38',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(61,	'2020-10-20 10:12:38',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(62,	'2020-10-22 22:18:30',	'山东省',	'::1',	'编辑基本设置',	0,	1),
(63,	'2020-10-23 00:56:22',	'山东省',	'::1',	'后台登录成功',	0,	1),
(64,	'2020-10-23 10:21:52',	'山东省',	'::1',	'后台登录成功',	0,	1),
(65,	'2020-10-27 10:49:41',	'山东省',	'::1',	'后台登录成功',	0,	1),
(66,	'2020-11-01 14:52:06',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(67,	'2020-11-03 10:00:37',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(68,	'2020-11-06 10:28:08',	'山东省',	'::1',	'后台登录成功',	0,	1),
(69,	'2020-11-10 09:37:08',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(70,	'2020-11-16 09:53:09',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(71,	'2020-11-17 17:40:41',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(72,	'2020-11-19 11:25:27',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(73,	'2020-11-20 10:09:54',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(74,	'2020-11-22 10:17:44',	'山东省',	'::1',	'后台登录成功',	0,	1),
(75,	'2020-11-23 09:09:28',	'山东省',	'::1',	'后台登录失败',	0,	0),
(76,	'2020-11-23 09:09:36',	'山东省',	'::1',	'后台登录成功',	0,	1),
(77,	'2020-11-24 09:44:48',	'山东省',	'::1',	'后台登录成功',	0,	1),
(78,	'2020-11-24 21:45:55',	'山东省',	'::1',	'后台登录成功',	0,	1),
(79,	'2020-11-30 14:28:21',	'山东省',	'::1',	'后台登录成功',	0,	1),
(80,	'2020-11-30 14:28:47',	'山东省',	'::1',	'编辑基本设置',	0,	1),
(81,	'2020-12-01 10:42:10',	'山东省',	'::1',	'后台登录成功',	0,	1),
(82,	'2020-12-02 09:30:12',	'山东省',	'::1',	'后台登录成功',	0,	1),
(83,	'2020-12-04 09:39:31',	'山东省',	'::1',	'后台登录失败',	0,	0),
(84,	'2020-12-04 09:39:36',	'山东省',	'::1',	'后台登录成功',	0,	1),
(85,	'2020-12-06 12:32:59',	'山东省',	'::1',	'后台登录成功',	0,	1),
(86,	'2020-12-08 09:14:59',	'山东省',	'::1',	'后台登录成功',	0,	1),
(87,	'2020-12-08 09:24:39',	'山东省',	'::1',	'后台登录成功',	0,	1),
(88,	'2020-12-09 09:25:37',	'山东省',	'::1',	'后台登录失败',	0,	0),
(89,	'2020-12-09 09:25:42',	'山东省',	'::1',	'后台登录成功',	0,	1),
(90,	'2020-12-11 10:06:14',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(91,	'2020-12-11 11:54:40',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(92,	'2020-12-12 17:16:21',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(93,	'2020-12-18 10:16:33',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(94,	'2020-12-18 10:17:57',	'山东省淄博市',	'::1',	'新增单页',	0,	1),
(95,	'2020-12-22 09:47:59',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(96,	'2021-01-04 09:51:13',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(97,	'2021-01-06 10:57:42',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(98,	'2021-01-08 09:56:53',	'山东省淄博市',	'::1',	'后台登录失败',	0,	0),
(99,	'2021-01-08 09:56:59',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(100,	'2021-01-12 10:21:36',	'山东省淄博市',	'::1',	'后台登录失败',	0,	0),
(101,	'2021-01-12 10:21:40',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(102,	'2021-01-13 09:53:04',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(103,	'2021-01-15 10:04:04',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(104,	'2021-01-19 10:56:58',	'山东省淄博市',	'::1',	'后台登录失败',	0,	0),
(105,	'2021-01-19 10:57:03',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(106,	'2021-01-20 09:42:10',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(107,	'2021-01-22 11:05:54',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(108,	'2021-02-02 09:28:01',	'山东省',	'::1',	'后台登录成功',	0,	1),
(109,	'2021-02-04 08:25:39',	'山东省',	'::1',	'后台登录成功',	0,	1),
(110,	'2021-02-05 08:47:26',	'山东省',	'::1',	'后台登录成功',	0,	1),
(111,	'2021-02-19 09:06:47',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(112,	'2021-02-19 09:12:54',	'山东省淄博市',	'::1',	'编辑商品分类',	0,	1),
(113,	'2021-02-19 09:13:03',	'山东省淄博市',	'::1',	'编辑商品分类',	0,	1),
(114,	'2021-02-19 09:13:11',	'山东省淄博市',	'::1',	'编辑商品分类',	0,	1),
(115,	'2021-02-19 09:13:18',	'山东省淄博市',	'::1',	'编辑商品分类',	0,	1),
(116,	'2021-02-19 09:13:29',	'山东省淄博市',	'::1',	'编辑商品分类',	0,	1),
(117,	'2021-02-19 09:13:47',	'山东省淄博市',	'::1',	'编辑商品分类',	0,	1),
(118,	'2021-02-19 09:14:00',	'山东省淄博市',	'::1',	'编辑商品分类',	0,	1),
(119,	'2021-09-27 09:18:16',	'',	'::1',	'后台登录成功',	0,	0),
(120,	'2021-09-27 09:18:27',	'山东省淄博市',	'::1',	'后台登录成功',	0,	1),
(121,	'2021-09-27 09:18:48',	'山东省淄博市',	'::1',	'切换模板',	0,	1),
(122,	'2021-09-27 09:18:48',	'山东省淄博市',	'::1',	'切换模板',	0,	1),
(123,	'2021-09-27 09:19:51',	'山东省淄博市',	'::1',	'编辑基本设置',	0,	1),
(124,	'2021-09-27 09:20:58',	'山东省淄博市',	'::1',	'编辑焦点图',	0,	1),
(125,	'2021-09-27 09:21:03',	'山东省淄博市',	'::1',	'编辑焦点图',	0,	1),
(126,	'2021-09-27 09:21:08',	'山东省淄博市',	'::1',	'编辑焦点图',	0,	1),
(127,	'2021-09-27 09:35:45',	'山东省淄博市',	'::1',	'编辑商品分类',	0,	1),
(128,	'2021-09-27 09:36:09',	'山东省淄博市',	'::1',	'编辑商品分类',	0,	1),
(129,	'2021-09-27 09:37:16',	'山东省淄博市',	'::1',	'删除商品分类',	0,	1),
(130,	'2021-09-27 09:37:19',	'山东省淄博市',	'::1',	'删除商品分类',	0,	1),
(131,	'2021-09-27 09:37:22',	'山东省淄博市',	'::1',	'删除商品分类',	0,	1),
(132,	'2021-09-27 09:37:30',	'山东省淄博市',	'::1',	'删除商品分类',	0,	1),
(133,	'2021-09-27 09:37:43',	'山东省淄博市',	'::1',	'删除商品分类',	0,	1),
(134,	'2021-09-27 09:58:23',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(135,	'2021-09-27 09:58:30',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(136,	'2021-09-27 09:58:35',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(137,	'2021-09-27 09:58:42',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(138,	'2021-09-27 09:59:04',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(139,	'2021-09-27 09:59:22',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(140,	'2021-09-27 09:59:35',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(141,	'2021-09-27 09:59:44',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(142,	'2021-09-27 09:59:51',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(143,	'2021-09-27 09:59:57',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(144,	'2021-09-27 10:00:22',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(145,	'2021-09-27 10:00:40',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(146,	'2021-09-27 10:00:50',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(147,	'2021-09-27 10:00:58',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(148,	'2021-09-27 10:01:09',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(149,	'2021-09-27 10:01:20',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1),
(150,	'2021-09-27 10:01:35',	'山东省淄博市',	'::1',	'编辑菜单',	0,	1);

DROP TABLE IF EXISTS `sl_member`;
CREATE TABLE `sl_member` (
  `M_id` int(11) NOT NULL AUTO_INCREMENT,
  `M_login` text NOT NULL,
  `M_pwd` text NOT NULL,
  `M_head` text NOT NULL,
  `M_money` decimal(10,2) NOT NULL DEFAULT '0.00',
  `M_regtime` datetime NOT NULL,
  `M_email` text NOT NULL,
  `M_del` int(11) NOT NULL DEFAULT '0',
  `M_viptime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `M_viplong` int(11) NOT NULL DEFAULT '0',
  `M_fen` int(11) NOT NULL DEFAULT '0',
  `M_pwdcode` text NOT NULL,
  `M_openid` text NOT NULL,
  `M_shop` varchar(200) DEFAULT NULL,
  `M_from` int(11) DEFAULT '0',
  `M_wxid` varchar(200) DEFAULT NULL,
  `M_type` int(11) DEFAULT '0',
  `M_sellertime` datetime DEFAULT NULL,
  `M_sellerlong` int(11) DEFAULT '0',
  `M_qq` varchar(200) DEFAULT NULL,
  `M_notice` varchar(500) DEFAULT NULL,
  `M_mobile` varchar(200) DEFAULT NULL,
  `M_webtitle` varchar(200) DEFAULT NULL,
  `M_keyword` varchar(200) DEFAULT NULL,
  `M_description` varchar(500) DEFAULT NULL,
  `M_beian` varchar(200) DEFAULT NULL,
  `M_code` varchar(5000) DEFAULT NULL,
  `M_copyright` varchar(500) DEFAULT NULL,
  `M_qrcode` varchar(500) DEFAULT NULL,
  `M_contact` varchar(1000) DEFAULT NULL,
  `M_kefu` varchar(1000) DEFAULT NULL,
  `M_logo` varchar(200) DEFAULT NULL,
  `M_ico` varchar(200) DEFAULT NULL,
  `M_domain` varchar(200) DEFAULT NULL,
  `M_priceup` int(11) DEFAULT '0',
  `M_template` varchar(200) DEFAULT NULL,
  `M_wap` varchar(200) DEFAULT NULL,
  `M_show` int(11) DEFAULT '0',
  `M_stop` int(11) DEFAULT '0',
  `M_stopinfo` varchar(500) DEFAULT NULL,
  `M_product` varchar(2000) DEFAULT NULL,
  `M_news` varchar(2000) DEFAULT NULL,
  `M_postage` decimal(10,2) DEFAULT '0.00',
  `M_baoyou` decimal(10,2) DEFAULT '0.00',
  `M_bond` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`M_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_member` (`M_id`, `M_login`, `M_pwd`, `M_head`, `M_money`, `M_regtime`, `M_email`, `M_del`, `M_viptime`, `M_viplong`, `M_fen`, `M_pwdcode`, `M_openid`, `M_shop`, `M_from`, `M_wxid`, `M_type`, `M_sellertime`, `M_sellerlong`, `M_qq`, `M_notice`, `M_mobile`, `M_webtitle`, `M_keyword`, `M_description`, `M_beian`, `M_code`, `M_copyright`, `M_qrcode`, `M_contact`, `M_kefu`, `M_logo`, `M_ico`, `M_domain`, `M_priceup`, `M_template`, `M_wap`, `M_show`, `M_stop`, `M_stopinfo`, `M_product`, `M_news`, `M_postage`, `M_baoyou`, `M_bond`) VALUES
(1,	'未登录帐号',	'内置会员（误删！否则系统无法正常运行！）',	'head.jpg',	0.00,	'2019-11-16 13:02:41',	'222@qq.com',	0,	'1970-01-01 00:00:00',	0,	0,	'',	'',	'店铺名称',	0,	'',	0,	'2000-01-01 00:00:00',	0,	'',	'店铺公告',	'',	'网站名称',	'SEO网站关键词',	'SEO网站描述',	'',	'',	'',	'',	'',	'',	'nopic.png',	'',	'',	10,	'',	'',	0,	0,	'',	'',	'',	0.00,	0.00,	0.00),
(9,	'Q_闪灵Anchen',	'e2376380336559eb7f8a538ffe3c3827',	'20191201225749pw9.jpg',	0.30,	'2019-12-01 22:57:49',	'@qq.com',	0,	'1970-01-01 00:00:00',	0,	0,	'',	'DAAE6D665D3931C6C7A61145C97C7BF5',	'店铺名称',	0,	'',	0,	'2000-01-01 00:00:00',	0,	'',	'店铺公告',	'',	'网站名称',	'SEO网站关键词',	'SEO网站描述',	'',	'',	'',	'',	'',	'',	'nopic.png',	'',	'',	10,	'',	'',	0,	0,	'',	'',	'',	0.00,	0.00,	0.00),
(11,	'W_闪灵网络',	'bbd32490d09a1ef553e6d94c12772de0',	'20191202121243niR.jpg',	0.00,	'2019-12-02 12:12:43',	'未设置邮箱@qq.com',	0,	'2019-12-03 10:46:59',	31,	0,	'EnLAgDf25t57p69ftwAm',	'o9DdM0ffTbm_vecejmTJs4cBId9E',	'店铺名称',	0,	'',	0,	'2000-01-01 00:00:00',	0,	'',	'店铺公告',	'',	'网站名称',	'SEO网站关键词',	'SEO网站描述',	'',	'',	'',	'',	'',	'',	'nopic.png',	'',	'',	10,	'',	'',	0,	0,	'',	'',	'',	0.00,	0.00,	0.00);

DROP TABLE IF EXISTS `sl_menu`;
CREATE TABLE `sl_menu` (
  `U_id` int(11) NOT NULL AUTO_INCREMENT,
  `U_title` text NOT NULL,
  `U_type` text NOT NULL,
  `U_typeid` int(11) NOT NULL DEFAULT '0',
  `U_order` int(11) NOT NULL DEFAULT '0',
  `U_sub` int(11) NOT NULL DEFAULT '0',
  `U_link` text NOT NULL,
  `U_del` int(11) NOT NULL DEFAULT '0',
  `U_hide` int(11) DEFAULT '0',
  `U_icon` text,
  PRIMARY KEY (`U_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_menu` (`U_id`, `U_title`, `U_type`, `U_typeid`, `U_order`, `U_sub`, `U_link`, `U_del`, `U_hide`, `U_icon`) VALUES
(1,	'网站首页',	'index',	1,	1,	0,	'',	0,	0,	'nopic.png'),
(2,	'游戏资源',	'product',	0,	4,	0,	'',	0,	0,	'nopic.png'),
(3,	'联机对战',	'product',	121,	2,	2,	'',	0,	0,	'nopic.png'),
(4,	'社区资源',	'product',	123,	1,	2,	'',	0,	0,	'nopic.png'),
(5,	'付费阅读',	'news',	0,	3,	0,	'',	0,	0,	'nopic.png'),
(6,	'性感',	'news',	43,	1,	5,	'',	0,	0,	'nopic.png'),
(7,	'联系我们',	'text',	3,	6,	0,	'http://www.baidu.com',	0,	0,	'nopic.png'),
(8,	'商家入驻',	'seller',	1,	5,	0,	'http://weibo.com',	0,	0,	'nopic.png'),
(9,	'关于我们',	'text',	2,	2,	0,	'',	0,	0,	'nopic.png'),
(10,	'品牌故事',	'text',	2,	1,	9,	'',	0,	0,	'nopic.png'),
(11,	'隐私申明',	'text',	1,	2,	9,	'',	0,	0,	'nopic.png'),
(12,	'清纯',	'news',	44,	2,	5,	'',	0,	0,	'nopic.png'),
(13,	'加盟合作',	'text',	4,	3,	9,	'',	0,	0,	'nopic.png'),
(14,	'手机游戏',	'product',	119,	3,	2,	'',	0,	0,	'nopic.png'),
(15,	'电脑游戏',	'product',	25,	4,	2,	'',	0,	0,	'nopic.png'),
(16,	'掌机游戏',	'product',	102,	5,	2,	'',	0,	0,	'nopic.png'),
(17,	'在线留言',	'text',	5,	2,	7,	'',	0,	0,	'nopic.png'),
(18,	'联系方式',	'text',	3,	1,	7,	'',	0,	0,	'nopic.png'),
(22,	'街拍',	'news',	48,	6,	5,	'',	0,	0,	'nopic.png'),
(21,	'制服',	'news',	47,	5,	5,	'',	0,	0,	'nopic.png'),
(20,	'古风',	'news',	46,	4,	5,	'',	0,	0,	'nopic.png'),
(19,	'校园',	'news',	45,	3,	5,	'',	0,	0,	'nopic.png'),
(23,	'订单查询',	'query',	1,	3,	7,	'',	0,	0,	'nopic.png'),
(24,	'官方微博',	'link',	1,	4,	7,	'http://weibo.com',	0,	0,	'nopic.png');

DROP TABLE IF EXISTS `sl_news`;
CREATE TABLE `sl_news` (
  `N_id` int(11) NOT NULL AUTO_INCREMENT,
  `N_title` text NOT NULL,
  `N_content` longtext,
  `N_pic` text NOT NULL,
  `N_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `N_sort` int(11) NOT NULL DEFAULT '0',
  `N_del` int(11) NOT NULL DEFAULT '0',
  `N_order` int(11) NOT NULL DEFAULT '0',
  `N_long` int(11) NOT NULL DEFAULT '0',
  `N_date` datetime NOT NULL,
  `N_author` text NOT NULL,
  `N_view` int(11) NOT NULL DEFAULT '0',
  `N_preview` int(11) NOT NULL DEFAULT '0',
  `N_mid` int(11) DEFAULT '0',
  `N_sh` int(11) DEFAULT '0',
  `N_tag` varchar(500) DEFAULT NULL,
  `N_fx` int(11) DEFAULT '0',
  `N_video` varchar(500) DEFAULT NULL,
  `N_top` int(11) DEFAULT '0',
  `N_tpl` int(11) DEFAULT '0',
  `N_shuxing` varchar(500) DEFAULT NULL,
  `N_vshow` int(11) DEFAULT '0',
  `N_price2` decimal(10,2) DEFAULT '0.00',
  `N_keywords` varchar(200) DEFAULT NULL,
  `N_description` varchar(500) DEFAULT NULL,
  `N_ds` int(11) DEFAULT '0',
  `N_dsintro` text,
  PRIMARY KEY (`N_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_news` (`N_id`, `N_title`, `N_content`, `N_pic`, `N_price`, `N_sort`, `N_del`, `N_order`, `N_long`, `N_date`, `N_author`, `N_view`, `N_preview`, `N_mid`, `N_sh`, `N_tag`, `N_fx`, `N_video`, `N_top`, `N_tpl`, `N_shuxing`, `N_vshow`, `N_price2`, `N_keywords`, `N_description`, `N_ds`, `N_dsintro`) VALUES
(154,	'极品女神吊带睡裙漂亮脸蛋苗条身材美女私密写真集',	'<img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(2).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(10).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(11).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(12).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(13).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(14).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(15).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(16).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(17).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(18).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(19).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/1/1%20(20).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318200614cp.jpg',	0.00,	46,	0,	0,	0,	'2020-03-18 20:05:42',	'admin',	243,	0,	0,	1,	'极品女神 吊带 睡裙 漂亮脸蛋 苗条身材',	1,	'',	0,	0,	'',	0,	0.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(155,	'芭蕾舞美女白色连衣裙日式丸子头虎白女粉嫩在线看',	'<img src=\"https://fhdemo.s-cms.cn/pic/2/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/2/1%20(2).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/2/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/2/1%20(4).jpg\" /> \r\n[fh_free]\r\n<img src=\"https://fhdemo.s-cms.cn/pic/2/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/2/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/2/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/2/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/2/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/2/1%20(10).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/2/1%20(11).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/2/1%20(12).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/202003182014136j.jpg',	1.00,	46,	0,	0,	0,	'2020-03-18 20:13:47',	'admin',	337,	0,	0,	1,	'芭蕾舞 白色连衣裙 日式丸子头 粉嫩',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(156,	'校园美女学生制服黑长直发皮肤白皙美女图片天天看',	'<img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(2).jpg\" />\r\n[fh_free]\r\n <img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(10).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(11).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(12).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(13).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(14).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(15).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/3/1%20(16).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/202003182015446o.jpg',	1.00,	45,	0,	0,	0,	'2020-03-18 20:15:15',	'admin',	73,	0,	0,	1,	'校园美女 学生制服 黑长直发 皮肤白皙',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(165,	'俏皮可爱的小萝莉cosplay洛丽塔风格萝莉控宅福利',	'<img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(10).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(11).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(12).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(13).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(14).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(15).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(16).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(17).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(18).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(19).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/12/1%20(20).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318203630ou.jpg',	1.00,	44,	0,	0,	0,	'2020-03-18 20:36:07',	'admin',	47,	0,	0,	1,	'俏皮可爱 小萝莉 cosplay 洛丽塔 萝莉控 宅福利',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(157,	'肌肤白嫩的甜美女孩身材纤细明眸善睐养眼个性写真',	'<img src=\"https://fhdemo.s-cms.cn/pic/4/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/4/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/4/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/4/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/4/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/4/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/4/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/4/1%20(8).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318201821hE.jpg',	1.00,	45,	0,	0,	0,	'2020-03-18 20:17:55',	'admin',	521,	0,	0,	1,	'肌肤白嫩 甜美女孩 身材纤细 明眸善睐 养眼',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(158,	'娇俏可爱的萝莉少女文艺小清新风美女照片',	'<img src=\"https://fhdemo.s-cms.cn/pic/5/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/5/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/5/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/5/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/5/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/5/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/5/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/5/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/5/1%20(9).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318201912Ug.jpg',	1.00,	45,	0,	0,	0,	'2020-03-18 20:18:49',	'admin',	404,	0,	0,	1,	'娇俏可爱 萝莉少女 文艺小清新',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(159,	'光滑雪肌美女修长美腿萝莉亚洲女孩清纯写真图片',	'<img src=\"https://fhdemo.s-cms.cn/pic/6/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/6/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/6/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/6/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/6/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/6/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/6/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/6/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/6/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/6/1%20(10).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318202021jb.jpg',	1.00,	45,	0,	0,	0,	'2020-03-18 20:19:59',	'admin',	771,	0,	0,	1,	'光滑雪肌 美女 修长美腿 萝莉 清纯',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(160,	'清纯可爱格纹衬衫美女养眼光滑美腿诱人写真',	'<img src=\"https://fhdemo.s-cms.cn/pic/7/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/7/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/7/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/7/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/7/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/7/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/7/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/7/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/7/1%20(9).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318202126ra.jpg',	1.00,	45,	0,	0,	0,	'2020-03-18 20:20:53',	'admin',	181,	0,	0,	1,	'清纯可爱 格纹衬衫 美女 养眼 光滑美腿 诱人',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(161,	'长得貌美如花的甜美女孩阳光下养眼漂亮美女照片',	'<img src=\"https://fhdemo.s-cms.cn/pic/8/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/8/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/8/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/8/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/8/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/8/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/8/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/8/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/8/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/8/1%20(10).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/8/1%20(11).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/8/1%20(12).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318202327XU.jpg',	1.00,	44,	0,	0,	0,	'2020-03-18 20:23:05',	'admin',	213,	0,	0,	1,	'貌美如花 甜美女孩 阳光下 养眼 漂亮 美女',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(162,	'户外小清新美女淡雅脱俗性感自然写真图片',	'<img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(10).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(11).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(12).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(13).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(14).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(15).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(16).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(17).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(18).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(19).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(20).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(21).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/9/1%20(22).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318202438hd.jpg',	1.00,	44,	0,	0,	0,	'2020-03-18 20:24:01',	'admin',	60,	0,	0,	1,	'户外 小清新 美女 淡雅脱俗 性感 自然',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(163,	'娇艳柔美的花房少女养眼漂亮的五官唯美艺术写真集',	'<img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(10).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(11).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(12).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(13).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(14).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(15).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(16).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(17).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/10/1%20(18).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318202648ZD.jpg',	1.00,	44,	0,	0,	0,	'2020-03-18 20:26:21',	'admin',	88,	0,	0,	1,	'娇艳柔美 花房少女 养眼  唯美',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(164,	'日系小清新美少女甜美天使清纯面孔写真图片',	'<img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(10).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(11).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(12).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(13).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(14).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(15).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(16).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(17).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(18).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(19).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(20).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(21).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(22).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(23).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(24).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/11/1%20(25).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318202853zB.jpg',	1.00,	44,	0,	0,	0,	'2020-03-18 20:28:28',	'admin',	96,	0,	0,	1,	'日系小清新 美少女 甜美 天使 清纯面孔',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(166,	'热辣好身材美女酥胸热裤清纯养眼自拍丰满写真',	'<img src=\"https://fhdemo.s-cms.cn/pic/13/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/13/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/13/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/13/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/13/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/13/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/13/1%20(7).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/202003182037503D.jpg',	1.00,	43,	0,	0,	0,	'2020-03-18 20:37:36',	'admin',	73,	0,	0,	1,	'热辣 好身材 美女 酥胸 热裤 清纯 养眼',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(167,	'短发美女香肩锁骨清纯文艺诱人自拍写真图片',	'<img src=\"https://fhdemo.s-cms.cn/pic/14/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/14/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/14/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/14/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/14/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/14/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/14/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/14/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/14/1%20(9).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318203825eE.jpg',	1.00,	43,	0,	0,	0,	'2020-03-18 20:38:13',	'admin',	50,	0,	0,	1,	'短发美女 香肩 锁骨 清纯 文艺 诱人',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(168,	'明眸皓齿的甜美女孩美腿白皙温顺无害可爱女生图片',	'<img src=\"https://fhdemo.s-cms.cn/pic/15/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/15/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/15/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/15/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/15/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/15/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/15/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/15/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/15/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/15/1%20(10).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318203939EQ.jpg',	1.00,	43,	0,	0,	0,	'2020-03-18 20:38:48',	'admin',	53,	0,	0,	1,	'明眸皓齿 甜美 女孩 美腿 白皙 温顺 无害 可爱',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(169,	'娃娃脸美女俏皮可爱居家治愈甜美笑容写真图片',	'<img src=\"https://fhdemo.s-cms.cn/pic/16/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/16/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/16/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/16/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/16/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/16/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/16/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/16/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/16/1%20(9).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/202003182040201m.jpg',	1.00,	43,	0,	0,	0,	'2020-03-18 20:40:05',	'admin',	208,	0,	0,	1,	'娃娃脸 美女 俏皮可爱 居家 治愈 甜美笑容',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(170,	'白月光女朋友肌肤娇嫩可爱气质清新脱俗唯美另类图片',	'<img src=\"https://fhdemo.s-cms.cn/pic/17/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/17/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/17/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/17/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/17/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/17/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/17/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/17/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/17/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/17/1%20(10).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/17/1%20(11).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/17/1%20(12).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/17/1%20(13).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/17/1%20(14).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318204102PP.jpg',	1.00,	43,	0,	0,	0,	'2020-03-18 20:40:43',	'admin',	137,	0,	0,	1,	'白月光 女朋友 肌肤 娇嫩 可爱 气质 清新脱俗 唯美',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(171,	'丸子头美女白皙美腿俏皮可爱清纯居家写真图片',	'<img src=\"https://fhdemo.s-cms.cn/pic/18/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/18/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/18/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/18/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/18/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/18/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/18/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/18/1%20(8).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318204151Pz.jpg',	1.00,	43,	0,	0,	0,	'2020-03-18 20:41:37',	'admin',	162,	0,	0,	1,	'丸子头 美女 白皙 美腿 俏皮 可爱 清纯 居家 写真 图片',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(172,	'鹅蛋脸美女条纹毛衣清纯女朋友私房诱人写真',	'<img src=\"https://fhdemo.s-cms.cn/pic/19/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/19/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/19/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/19/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/19/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/19/1%20(6).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318204238gm.jpg',	1.00,	49,	0,	0,	0,	'2020-03-18 20:42:25',	'admin',	58,	0,	0,	1,	'鹅蛋脸 美女 条纹毛衣 清纯 女朋友 私房',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(173,	'娇媚可人的邻家小妹白丝蕾丝裙美女香肩美颈诱人艺术照',	'<img src=\"https://fhdemo.s-cms.cn/pic/20/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/20/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/20/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/20/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/20/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/20/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/20/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/20/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/20/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/20/1%20(10).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/20/1%20(11).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/20/1%20(12).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318204412zG.jpg',	1.00,	49,	0,	0,	0,	'2020-03-18 20:43:42',	'admin',	96,	0,	0,	1,	'娇媚可人 邻家小妹 白丝 蕾丝裙 香肩美颈',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(174,	'粉嫩少女养眼小蛮腰露香肩清纯诱惑私房写真',	'<img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(10).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(11).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(12).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(13).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(14).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(15).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(16).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(17).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/21/1%20(18).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318204506vr.jpg',	1.00,	49,	0,	0,	0,	'2020-03-18 20:44:50',	'admin',	250,	0,	0,	1,	'粉嫩  养眼 小蛮腰 露香肩 清纯 诱惑',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(175,	'气质清爽养眼的短发妹子明眸皓齿肌肤雪白迷人艺术照',	'<img src=\"https://fhdemo.s-cms.cn/pic/22/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/22/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/22/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/22/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/22/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/22/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/22/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/22/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/22/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/22/1%20(10).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/22/1%20(11).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/22/1%20(12).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/22/1%20(13).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318204610W2.jpg',	1.00,	49,	0,	0,	0,	'2020-03-18 20:45:59',	'admin',	57,	0,	0,	1,	'气质清爽 养眼 短发妹子 明眸皓齿 肌肤雪白',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(176,	'邻家大姐姐清纯养眼背带裤撩人养眼小清新写真图片',	'<img src=\"https://fhdemo.s-cms.cn/pic/23/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/23/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/23/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/23/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/23/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/23/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/23/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/23/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/23/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/23/1%20(10).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318204700Y8.jpg',	1.00,	49,	0,	0,	0,	'2020-03-18 20:46:50',	'admin',	65,	0,	0,	1,	'邻家大姐姐 清纯 养眼 背带裤',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(177,	'又纯又性感的娇艳小妹白嫩酮体娇艳欲滴私房照',	'<img src=\"https://fhdemo.s-cms.cn/pic/24/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/24/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/24/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/24/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/24/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/24/1%20(6).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318205633QL.jpg',	1.00,	49,	0,	0,	0,	'2020-03-18 20:56:22',	'admin',	50,	0,	0,	1,	'性感 娇艳 白嫩 酮体 娇艳欲滴',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(178,	'粉嫩美女清纯镂空内衣养眼居家天然诱惑写真',	'<img src=\"https://fhdemo.s-cms.cn/pic/25/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/25/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/25/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/25/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/25/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/25/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/25/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/25/1%20(8).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/202003182057080G.jpg',	1.00,	48,	0,	0,	0,	'2020-03-18 20:56:57',	'admin',	165,	0,	0,	1,	'粉嫩  清纯 镂空内衣 养眼 居家 天然',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(179,	'长得清新脱俗的元气少女肌肤白皙唯美养眼私房照',	'<img src=\"https://fhdemo.s-cms.cn/pic/26/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/26/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/26/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/26/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/26/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/26/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/26/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/26/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/26/1%20(9).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318210000yT.jpg',	1.00,	47,	0,	0,	0,	'2020-03-18 20:59:48',	'admin',	625,	0,	0,	1,	'清新脱俗 元气少女 肌肤白皙 唯美 养眼',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(180,	'运动风元气美少女明眸善睐容颜养眼漂亮艺术写真',	'<img src=\"https://fhdemo.s-cms.cn/pic/27/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/27/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/27/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/27/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/27/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/27/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/27/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/27/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/27/1%20(9).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318210241t0.jpg',	1.00,	46,	0,	0,	0,	'2020-03-18 21:02:30',	'admin',	82,	0,	0,	1,	'运动风 元气美少女 明眸善睐 养眼',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(181,	'校园制服少女养眼小清新清纯户外眼镜娘写真',	'<img src=\"https://fhdemo.s-cms.cn/pic/28/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/28/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/28/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/28/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/28/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/28/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/28/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/28/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/28/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/28/1%20(10).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318210337dB.jpg',	1.00,	48,	0,	0,	0,	'2020-03-18 21:03:23',	'admin',	1776,	0,	0,	1,	'校园制服 少女 养眼 小清新 清纯 户外 眼镜娘',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(182,	'身材前凸后翘美若天仙的邻家姐姐丰胸长腿惹火艺术照',	'<img src=\"https://fhdemo.s-cms.cn/pic/29/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/29/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/29/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/29/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/29/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/29/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/29/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/29/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/29/1%20(9).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318210510nf.jpg',	1.00,	48,	0,	0,	0,	'2020-03-18 21:04:57',	'admin',	609,	0,	0,	1,	'前凸后翘 美若天仙 邻家姐姐 丰胸 长腿 惹火',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(183,	'森系唯美好女孩光线柔和阳光下养眼唯美的写真摄影图片',	'<img src=\"https://fhdemo.s-cms.cn/pic/30/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/30/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/30/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/30/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/30/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/30/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/30/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/30/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/30/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/30/1%20(10).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318210641Be.jpg',	1.00,	48,	0,	0,	0,	'2020-03-18 21:05:41',	'admin',	128,	0,	0,	1,	'森系 唯美 好女孩 光线柔和  养眼',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(184,	'校园萌妹治愈系美女开衫毛衣户外清纯写真',	'<img src=\"https://fhdemo.s-cms.cn/pic/31/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/31/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/31/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/31/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/31/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/31/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/31/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/31/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/31/1%20(9).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318210731i0.jpg',	1.00,	48,	0,	0,	0,	'2020-03-18 21:07:18',	'admin',	526,	0,	0,	1,	'校园萌妹 治愈系 美女 开衫毛衣 户外 ',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(185,	'校园美女御姐刀光剑影帅气不良感jk制服清纯写真',	'<img src=\"https://fhdemo.s-cms.cn/pic/32/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/32/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/32/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/32/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/32/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/32/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/32/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/32/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/32/1%20(9).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318210831y8.jpg',	1.00,	47,	0,	0,	0,	'2020-03-18 21:08:13',	'admin',	73,	0,	0,	1,	'校园美女 御姐 刀光剑影 帅气',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(186,	'香肩雪白迷人的吊带少女肌肤白洁无暇粉嫩诱人艺术照',	'<img src=\"https://fhdemo.s-cms.cn/pic/33/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/33/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/33/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/33/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/33/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/33/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/33/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/33/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/33/1%20(9).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/202003182109295C.jpg',	1.00,	47,	0,	0,	0,	'2020-03-18 21:09:16',	'admin',	175,	0,	0,	1,	'香肩 雪白 吊带少女 白洁无暇 粉嫩诱人',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(187,	'性感美艳的清纯美女化身霸道女总裁美女气质高冷御姐范图集',	'<img src=\"https://fhdemo.s-cms.cn/pic/34/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/34/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/34/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/34/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/34/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/34/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/34/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/34/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/34/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/34/1%20(10).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/34/1%20(11).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/34/1%20(12).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/34/1%20(13).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/34/1%20(14).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/34/1%20(15).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318211009rH.jpg',	1.00,	47,	0,	0,	0,	'2020-03-18 21:09:58',	'admin',	340,	0,	0,	1,	'性感 美艳 清纯 霸道女总裁 气质高冷 御姐范',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(188,	'成熟女神露肩吊带粉嫩养眼白富美清纯写真图片',	'<img src=\"https://fhdemo.s-cms.cn/pic/35/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/35/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/35/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/35/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/35/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/35/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/35/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/35/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/35/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/35/1%20(10).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/35/1%20(11).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/35/1%20(12).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/35/1%20(13).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/35/1%20(14).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/202003182111076d.jpg',	1.00,	47,	0,	0,	0,	'2020-03-18 21:10:51',	'admin',	114,	0,	0,	1,	'成熟 女神 露肩 吊带 粉嫩 白富美 清纯',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(189,	'十八岁粉嫩小女生俏皮可爱减龄丸子头少女心十足妹子图',	'<img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(10).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(11).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(12).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(13).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(14).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(15).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(16).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/36/1%20(17).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318211210ye.jpg',	1.00,	46,	0,	0,	0,	'2020-03-18 21:11:56',	'admin',	520,	0,	0,	1,	'十八岁 粉嫩 小女生 俏皮可爱 减龄丸子头 少女心',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(190,	'清纯可爱萌琪琪大姐姐私房诱人美腿写真图片',	'<img src=\"https://fhdemo.s-cms.cn/pic/37/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/37/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/37/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/37/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/37/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/37/1%20(6).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318211311XA.jpg',	1.00,	46,	0,	0,	0,	'2020-03-18 21:12:53',	'admin',	340,	0,	0,	1,	'清纯可爱  大姐姐 私房 诱人 美腿',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(191,	'校园漂亮学生妹教室制服诱惑人体艺术写真图片',	'<img src=\"https://fhdemo.s-cms.cn/pic/38/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/38/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/38/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/38/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/38/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/38/1%20(6).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318215501nC.jpg',	1.00,	48,	0,	0,	0,	'2020-03-18 21:52:46',	'admin',	734,	0,	0,	1,	'校园 漂亮 学生妹 教室 制服 诱惑 人体艺术',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(192,	'性感女神魔鬼好身材美女妩媚撩人的拍照姿势惹火销魂图库',	'<img src=\"https://fhdemo.s-cms.cn/pic/39/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/39/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/39/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/39/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/39/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/39/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/39/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/39/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/39/1%20(9).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318215652va.jpg',	1.00,	47,	0,	0,	0,	'2020-03-18 21:56:18',	'admin',	408,	0,	0,	1,	'性感女神 魔鬼好身材  妩媚撩人姿势惹火',	1,	'',	0,	0,	'',	0,	1.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(193,	'知性优雅的头条女神阳光下肌肤雪白气质慵懒迷人艺术照',	'<img src=\"https://fhdemo.s-cms.cn/pic/40/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/40/1%20(2).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/40/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/40/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/40/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/40/1%20(6).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318215738sg.jpg',	0.00,	46,	0,	0,	0,	'2020-03-18 21:57:23',	'admin',	259,	0,	0,	1,	'知性优雅  女神 肌肤雪白 气质慵懒 迷人',	1,	'',	0,	0,	'',	0,	0.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(194,	'蕾丝内衣美女粉嫩可爱小女生居家性感自拍写真',	'<img src=\"https://fhdemo.s-cms.cn/pic/41/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/41/1%20(2).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/41/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/41/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/41/1%20(5).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/20200318215822aZ.jpg',	0.00,	45,	0,	0,	0,	'2020-03-18 21:58:04',	'admin',	997,	0,	0,	1,	'蕾丝内衣  粉嫩 可爱 小女生 居家 性感',	1,	'',	0,	0,	'',	0,	0.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！'),
(195,	'火辣美女牛仔背带裤露内衣性感极品尤物诱人写真',	'<img src=\"https://fhdemo.s-cms.cn/pic/42/1%20(1).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/42/1%20(2).jpg\" />[fh_free] <img src=\"https://fhdemo.s-cms.cn/pic/42/1%20(3).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/42/1%20(4).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/42/1%20(5).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/42/1%20(6).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/42/1%20(7).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/42/1%20(8).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/42/1%20(9).jpg\" /> <img src=\"https://fhdemo.s-cms.cn/pic/42/1%20(10).jpg\" />',	'https://fhdemo.s-cms.cn/t7/media/202003182159114T.jpg',	0.00,	44,	0,	0,	0,	'2020-03-18 21:58:56',	'admin',	258,	0,	0,	1,	'火辣美女 牛仔背带裤 露内衣 性感 极品尤物',	1,	'',	0,	0,	'',	0,	0.00,	'',	'',	0,	'文章很值，打赏犒劳作者一下！');

DROP TABLE IF EXISTS `sl_nsort`;
CREATE TABLE `sl_nsort` (
  `S_id` int(11) NOT NULL AUTO_INCREMENT,
  `S_title` text NOT NULL,
  `S_content` text NOT NULL,
  `S_pic` text NOT NULL,
  `S_del` int(11) NOT NULL DEFAULT '0',
  `S_sub` int(11) NOT NULL DEFAULT '0',
  `S_order` int(11) NOT NULL DEFAULT '0',
  `S_show` int(11) DEFAULT '1',
  `S_keywords` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`S_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_nsort` (`S_id`, `S_title`, `S_content`, `S_pic`, `S_del`, `S_sub`, `S_order`, `S_show`, `S_keywords`) VALUES
(42,	'写真',	'美女写真',	'nopic.png',	0,	0,	1,	1,	''),
(43,	'性感',	'性感',	'nopic.png',	0,	42,	0,	1,	''),
(44,	'清纯',	'清纯',	'nopic.png',	0,	42,	1,	1,	''),
(45,	'校园',	'校园',	'nopic.png',	0,	42,	2,	1,	''),
(46,	'古风',	'古风',	'nopic.png',	0,	42,	3,	1,	''),
(47,	'制服',	'制服',	'nopic.png',	0,	42,	4,	1,	''),
(48,	'街拍',	'街拍',	'nopic.png',	0,	42,	5,	1,	''),
(49,	'长腿',	'长腿',	'nopic.png',	0,	42,	6,	1,	'');

DROP TABLE IF EXISTS `sl_orders`;
CREATE TABLE `sl_orders` (
  `O_id` int(11) NOT NULL AUTO_INCREMENT,
  `O_mid` int(11) NOT NULL DEFAULT '0',
  `O_pid` int(11) NOT NULL DEFAULT '0',
  `O_num` int(11) NOT NULL DEFAULT '0',
  `O_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `O_time` datetime NOT NULL,
  `O_del` int(11) NOT NULL DEFAULT '0',
  `O_type` int(11) NOT NULL DEFAULT '0',
  `O_nid` int(11) NOT NULL DEFAULT '0',
  `O_content` longtext,
  `O_title` text NOT NULL,
  `O_pic` text NOT NULL,
  `O_address` text NOT NULL,
  `O_state` int(11) NOT NULL DEFAULT '0',
  `O_genkey` varchar(200) DEFAULT NULL,
  `O_sellmid` int(11) DEFAULT '0',
  `O_wl` varchar(200) DEFAULT NULL,
  `O_wlno` varchar(200) DEFAULT NULL,
  `O_gg` varchar(200) DEFAULT NULL,
  `O_paytype` varchar(200) DEFAULT NULL,
  `O_wlinfo` varchar(5000) DEFAULT NULL,
  `O_cid` int(11) DEFAULT '0',
  `O_wlinfotime` datetime DEFAULT NULL,
  `O_time2` datetime DEFAULT NULL,
  `O_today` datetime DEFAULT NULL,
  `O_quan` decimal(10,2) DEFAULT '0.00',
  `O_postage` decimal(10,2) DEFAULT '0.00',
  `O_qid` int(11) DEFAULT '0',
  `O_city` text,
  `O_ip` text,
  `O_bz` text,
  `O_client` text,
  PRIMARY KEY (`O_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_orders` (`O_id`, `O_mid`, `O_pid`, `O_num`, `O_price`, `O_time`, `O_del`, `O_type`, `O_nid`, `O_content`, `O_title`, `O_pic`, `O_address`, `O_state`, `O_genkey`, `O_sellmid`, `O_wl`, `O_wlno`, `O_gg`, `O_paytype`, `O_wlinfo`, `O_cid`, `O_wlinfotime`, `O_time2`, `O_today`, `O_quan`, `O_postage`, `O_qid`, `O_city`, `O_ip`, `O_bz`, `O_client`) VALUES
(14,	3,	52,	1,	50.00,	'2019-12-01 16:13:00',	0,	0,	0,	'Ei70HZQs0n4ifHdZuIR0rxdk97dEFIkz',	'windows10正版激活码',	'20191201161206eo.jpg',	'',	0,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(15,	3,	52,	2,	90.00,	'2019-12-01 16:16:53',	0,	0,	0,	'h3X88BkTMvD0ZPaJxJtEgKWOukfstRwr||2oD2zsIQf9ESD75qrT7UsHBfVWaDTmht',	'windows10正版激活码',	'20191201161206eo.jpg',	'',	0,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(16,	3,	0,	1,	1.00,	'2019-12-01 19:37:54',	0,	1,	2,	'',	'斥资3.5亿 亨得利首次布局XX钟表2',	'20191117134303C6.jpg',	'',	0,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(17,	3,	0,	1,	0.02,	'2019-12-02 00:23:09',	0,	1,	3,	'',	'共享单车的印度崛起：东方不亮西方亮？',	'20191117134418m4.jpg',	'',	0,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(18,	3,	52,	1,	100.00,	'2019-12-02 00:23:26',	0,	0,	0,	'xifMiFcPTPxncHiaMsp4DW87sgJkIDMh',	'windows10正版激活码',	'20191201161206eo.jpg',	'',	0,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(19,	3,	52,	1,	100.00,	'2019-12-02 08:30:01',	0,	0,	0,	'lklbrQNHLnmQIV57t8HSSkQgFRwh9lui',	'windows10正版激活码',	'20191201161206eo.jpg',	'',	0,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(20,	11,	0,	1,	0.02,	'2019-12-03 08:00:44',	0,	1,	3,	'',	'共享单车的印度崛起：东方不亮西方亮？',	'20191117134418m4.jpg',	'',	0,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(21,	3,	0,	1,	1.00,	'2019-12-05 09:13:59',	0,	1,	20,	'',	'滴滴“官宣”巨亏——是卖惨，还是真难',	'20191203142307Ts.jpg',	'',	0,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(22,	3,	0,	1,	1.00,	'2019-12-05 09:15:45',	0,	1,	6,	'',	'抖音运营团队：抖音运营思维攻略',	'20191203140832NZ.jpg',	'',	0,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(23,	3,	0,	1,	1.00,	'2019-12-05 19:57:06',	0,	1,	18,	'',	'咪蒙关停，靠“伪女权”挣钱还能撑多久',	'20191203142126a2.jpg',	'',	0,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(24,	3,	69,	1,	50.00,	'2019-12-05 19:59:05',	0,	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	'短域名、缩短网址生成网站系统源码 可自行广告位',	'20191202220109pf.jpg',	'',	0,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(25,	3,	0,	1,	1.00,	'2019-12-07 13:38:16',	0,	1,	11,	'',	'区块链未死！2019区块链+农业或将浴火重生',	'201912031413561o.jpg',	'',	0,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(26,	3,	97,	2,	98.00,	'2019-12-07 21:55:19',	0,	0,	0,	'实物商品，由商家手动发货',	'梦幻西游2点卡100元梦幻西游点卡1000点网易一卡通100元自动充值',	'20191203094443cv.jpg',	'  ',	1,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(27,	3,	97,	2,	98.00,	'2019-12-07 21:56:36',	0,	0,	0,	'实物商品，由商家手动发货',	'梦幻西游2点卡100元梦幻西游点卡1000点网易一卡通100元自动充值',	'20191203094443cv.jpg',	'山东省淄博市',	1,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(28,	3,	54,	1,	9.80,	'2019-12-08 11:39:55',	0,	0,	0,	'发货内容（测试数据）',	'photoshop教程 教你玩转photoshop教程|ps教程含色彩系统',	'20191202212321aS.jpg',	'anchen0000159@vip.qq.com',	1,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(29,	3,	54,	1,	9.80,	'2019-12-10 21:18:49',	0,	0,	0,	'发货内容（测试数据）',	'photoshop教程 教你玩转photoshop教程|ps教程含色彩系统',	'20191202212321aS.jpg',	'anchen0000159@vip.qq.com',	1,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(30,	3,	0,	1,	1.00,	'2019-12-11 11:08:20',	0,	1,	19,	'',	'短视频的彷徨与退让：积蓄力量，正待春暖花开',	'20191203142156Sn.jpg',	'',	1,	'',	0,	'',	'',	'',	'',	'',	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	''),
(31,	1,	96,	1,	190.00,	'2020-12-11 11:56:24',	0,	0,	0,	'',	'爱奇艺VIP黄金会员12个月 爱奇艺vip会员1年卡自动充值即时到账',	'20191203094308S6.jpg',	'',	0,	'202012111156224350',	0,	NULL,	NULL,	'标配',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	0.00,	0.00,	0,	'',	'',	'',	'');

DROP TABLE IF EXISTS `sl_oss`;
CREATE TABLE `sl_oss` (
  `O_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `O_name` text,
  `C_md5` text,
  `O_md5` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`O_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `sl_product`;
CREATE TABLE `sl_product` (
  `P_id` int(11) NOT NULL AUTO_INCREMENT,
  `P_title` text NOT NULL,
  `P_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `P_content` longtext,
  `P_sort` int(11) NOT NULL DEFAULT '0',
  `P_pic` text NOT NULL,
  `P_del` int(11) NOT NULL DEFAULT '0',
  `P_order` int(11) NOT NULL DEFAULT '0',
  `P_sell` longtext,
  `P_selltype` int(11) NOT NULL DEFAULT '0',
  `P_rest` int(11) NOT NULL DEFAULT '100',
  `P_view` int(11) DEFAULT '0',
  `P_sold` int(11) DEFAULT '0',
  `P_time` datetime DEFAULT NULL,
  `P_mid` int(11) DEFAULT '0',
  `P_sh` int(11) DEFAULT '0',
  `P_unlogin` int(11) DEFAULT '0',
  `P_tag` varchar(500) DEFAULT NULL,
  `P_fx` int(11) DEFAULT '0',
  `P_shuxing` varchar(500) DEFAULT NULL,
  `P_video` varchar(500) DEFAULT NULL,
  `P_tpl` int(11) DEFAULT '0',
  `P_vshow` int(11) DEFAULT '0',
  `P_top` int(11) DEFAULT '0',
  `P_address` varchar(200) DEFAULT NULL,
  `P_vip` int(11) DEFAULT '0',
  `P_taobao` varchar(500) DEFAULT NULL,
  `P_price2` decimal(10,2) DEFAULT '0.00',
  `P_keywords` varchar(200) DEFAULT NULL,
  `P_description` varchar(500) DEFAULT NULL,
  `P_gg` varchar(5000) DEFAULT NULL,
  `P_ggsell` text,
  `P_price3` decimal(10,2) DEFAULT '0.00',
  `P_viponly` int(11) DEFAULT '0',
  `P_code` text,
  `P_viponly2` int(11) DEFAULT '0',
  `P_sort2` int(11) DEFAULT '0',
  `P_msg` text,
  `P_bz` text,
  `P_limit` decimal(10,2) DEFAULT '0.00',
  `P_limitlong` int(11) DEFAULT '0',
  `P_limittime` datetime DEFAULT NULL,
  PRIMARY KEY (`P_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_product` (`P_id`, `P_title`, `P_price`, `P_content`, `P_sort`, `P_pic`, `P_del`, `P_order`, `P_sell`, `P_selltype`, `P_rest`, `P_view`, `P_sold`, `P_time`, `P_mid`, `P_sh`, `P_unlogin`, `P_tag`, `P_fx`, `P_shuxing`, `P_video`, `P_tpl`, `P_vshow`, `P_top`, `P_address`, `P_vip`, `P_taobao`, `P_price2`, `P_keywords`, `P_description`, `P_gg`, `P_ggsell`, `P_price3`, `P_viponly`, `P_code`, `P_viponly2`, `P_sort2`, `P_msg`, `P_bz`, `P_limit`, `P_limitlong`, `P_limittime`) VALUES
(105,	'侍道外传刀神',	0.00,	'<p>\r\n	<span style=\"color:#556772;font-weight:700;background-color:#FFE500;\"> </span> \r\n</p>\r\n<div class=\"subtitle column\" style=\"margin:0px;padding:0px 10px 0px 0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	<span style=\"background-color:#FFE500;font-size:24px;font-family:;\">游戏视频STEAM详细介绍链接点击即可跳转</span> \r\n</div>\r\n<p>\r\n	<span style=\"color:#556772;font-weight:700;background-color:#FFE500;\"></span> \r\n</p>\r\n<p>\r\n	<span style=\"color:#556772;font-weight:700;background-color:#FFE500;\"><a href=\"https://store.steampowered.com/app/1062340/KATANA_KAMI_A_Way_of_the_Samurai_Story/\" target=\"_blank\">https://store.steampowered.com/app/1062340/KATANA_KAMI_A_Way_of_the_Samurai_Story/</a></span> \r\n</p>\r\n<p>\r\n	<span style=\"color:#556772;font-weight:700;background-color:#FFE500;\"></span> \r\n</p>\r\n<p style=\"list-style: none; padding: 20px 0px 0px; border: currentColor; border-image: none; color: rgb(102, 102, 102); font-family: Microsoft Yahei, Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 13px; margin-top: 0px; margin-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;font-weight:700;\">游戏介绍：</span> \r\n	</p>\r\n<p style=\"list-style: none; padding: 20px 0px 0px; border: currentColor; border-image: none; color: rgb(102, 102, 102); font-family: Microsoft Yahei, Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 13px; margin-top: 0px; margin-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">《侍道外传：刀神》是一款冒险RPG游戏，保留了前作侍道的经典世界观，但同时也新增了不少全新的环法，内容更加丰富多彩，操作感更加爽快！\r\n</p>\r\n<p style=\"list-style: none; padding: 20px 0px 0px; border: currentColor; border-image: none; color: rgb(102, 102, 102); font-family: Microsoft Yahei, Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 13px; margin-top: 0px; margin-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;font-weight:700;\">游戏特色：</span> \r\n	</p>\r\n<ul class=\"bb_ul\" style=\"list-style: none; margin: 0px; padding: 0px; border: currentColor; border-image: none; color: rgb(102, 102, 102); font-family: Microsoft Yahei, Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 13px; white-space: normal; background-color: rgb(255, 255, 255);\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">\r\n	<li>\r\n		磨练技能-超过100种不同的武器和9种格斗风格，意味着您可以随心所欲地战斗！\r\n	</li>\r\n	<li>\r\n		神秘的地下城-等距的砍伐和砍伐与随机生成的地牢一起在日本的历史环境中探索。\r\n	</li>\r\n	<li>\r\n		两剑胜于一剑-与他人一起探索地牢\r\n	</li>\r\n	<li>\r\n		力量平衡-与城镇的三个派系交战时保持盟友，出卖或保持中立的态度。六甲通的命运在刀尖上保持平衡！\r\n	</li>\r\n	<li>\r\n		熟悉的面孔-拥有《武士之路》系列中粉丝最喜欢的角色！\r\n	</li>\r\n		</ul>\r\n<br />\r\n		<p>\r\n			<br />\r\n		</p>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201101174659Ru.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	153,	12,	'2020-11-01 17:45:51',	0,	1,	1,	'动作 角色扮演 暴力 血腥 迷宫探索 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256775816/movie480.webm?t=1582215649',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(106,	'恐怖黎明 Grim Dawn',	0.00,	'<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"margin:0px;padding:0px 10px 0px 0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		<br />\r\n	</div>\r\n	<p>\r\n		<br />\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">《恐怖黎明 Grim Dawn》是一款非常棒的ARPG游戏，玩家将要投身于黑暗而又充满战乱的Cairn的世界之中，这个世界曾经是一个光荣的帝国，而如今却化作一片废墟，人类也濒临灭绝的边缘。Carin如今已经变成两股外来世界力量永恒战争的战场，其中一股力量把人类的尸体当作他们的资源，而另外一股力量为了防止对方获得资源，想要先一步抹杀人类种族。这场灾难性的战争不仅灭绝了人类文明，还在不断地扭曲游戏中现实的构造，并且当某种东西觉醒的时候，将给人们带来全新的灾难。\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><br />\r\n</p>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201101174831Z4.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	143,	27,	'2020-11-01 17:48:04',	0,	1,	1,	'作角色扮演 黑暗奇幻 砍杀 角色扮演 好评如潮 特别好评',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/2029862/movie480.webm?t=1457088973',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	'2021-08-07 11:55:24'),
(107,	'刺客信条7起源',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		<br />\r\n	</div>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《刺客信条7：起源 Assassin’s Creed Origins》是一款开放世界角色扮演游戏，冉冉升起的烈日，清风吹拂过的滚烫沙子，古城市民们辛勤的劳作深刻的刻画的栩栩如生。骑着心爱的独角兽漫步在沙原当中，看着种种壮阔的的历史景观，不经油然感叹古埃及人民智慧结晶是多么宏伟！（支持简繁中文）\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;font-size:14pt;\">游戏特色：</span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">等待发现的国度<br />\r\n朝着尼罗河下游航行，在探索这片巨大未知国度的过程中，逐步揭开金字塔的神秘面纱，与危险的古代宗教派别和野兽展开殊死一搏。<br />\r\n每场游历都是全新故事<br />\r\n从富有的权贵人士到绝望的被驱逐者，跟着众多色彩鲜明、令人难忘的角色一同参与各项任务，进入扣人心弦的故事情节。<br />\r\n畅享动作角色扮演体验<br />\r\n感受全新的战斗方式。掠夺并使用数十款特色和稀有程度各不相同的武器。精研深度发展的机械，并迎战独特强大的头目，发挥你的战术技能。\r\n</p>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201101175222JS.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	543,	87,	'2020-11-01 17:51:58',	0,	1,	1,	'放世界 暗杀 动作 角色扮演 潜行 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256686955/movie480.webm?t=1506610148',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(108,	'刺客信条6枭雄',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		<span style=\"color:#666666;font-family:\" font-size:14pt;font-weight:700;\"=\"\">游戏介绍：</span> \r\n	</div>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《刺客信条6：枭雄 Assassin’s Creed: Syndicate》是一款开放世界角色扮演游戏，现代刺客组织前往密室后发现圣殿骑士团已经到达，虽进行伏击但无法组织圣裹布被带走，刺客组织发现圣殿骑士团想用圣裹布使第一文明成员复活，藏匿于Abstergo网络内的第一文明成员朱诺在幕后操纵现代圣殿骑士团，透露将用圣裹布拯救人类。（支持简繁中文）\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;font-size:14pt;\">游戏特色：</span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"> 首个诞生在近代的刺客：扮演傲慢、桀骜不驯的雅各布·弗莱，举起双手，用快如闪电的连击和反击来对付你的敌人。使用进阶潜行躲避敌人，然后释放你所有的新武器，包括库克利弯刀、黄铜指虎和手杖剑。使用例如绳镖这样的全新技术在数秒内攀爬建筑并奇袭敌人。\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201101175434y6.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	243,	78,	'2020-11-01 17:54:07',	0,	1,	1,	'开放世界 动作 潜行 跑酷 历史 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256658414/movie480.webm?t=1447967814',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(109,	'《底特律变人 Detroit：Become Human》中文版免安装百度云',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;\">\r\n			<br />\r\n		</div>\r\n	</div>\r\n	<p>\r\n		<br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《底特律：变人 Detroit：Become Human》是一款未来世界科幻背景的剧情冒险游戏。底特律，2038年。科技已高度发展，到处都是人形仿生机器人。他们能像人一样交流、移动并做出与人类一样的行为。但它们却只是一些服务于人类的机器。<br />\r\n扮演三名不同的机器人，透过他们的眼睛见证一个处于混乱边缘的世界——这或许就是我们的未来。您的每个决定都将直接影响到游戏那紧张、错综复杂的故事结局。<br />\r\n您将面对道德困境，做出谁生谁死的艰难抉择。面对数千种选择和多种结局，您将如何影响底特律的未来，以及人类的命运呢？\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;font-size:14pt;\">游戏特色：</span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">在扣人心弦的故事中做出您的选择<br />\r\n进入一个充满道德困境和艰难选择的世界，您可以将机器人奴隶转变为改变世界的革命力量。站在“他者”的角度去发掘人类的意义，并以机械之眼见证整个世界。\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 10 (64 bit)<br />\r\n处理器: Intel Core i5-2300 @ 2.8 GHz or AMD Ryzen 3 1200 @ 3.1GHz or AMD FX-8350 @ 4.2GHz<br />\r\n内存: 8 GB RAM<br />\r\n显卡: Nvidia GeForce GTX 780 or AMD HD 7950 with 3GB VRAM minimum (Support of Vulkan 1.1 required)<br />\r\n存储空间: 需要 55 GB 可用空间\r\n</p>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201101175641Wc.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	596,	89,	'2020-11-01 17:55:14',	0,	1,	1,	'取向 剧情丰富 多结局 冒险 情感 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256784014/movie480_vp9.webm?t=1590429401',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(110,	'密不可分 Indivisible',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2019年10月8日\r\n	</div>\r\n<span style=\"font-size:18px;background-color:#FFE500;\"></span><span style=\"font-size:18px;background-color:#FFE500;\"><span style=\"color:#666666;font-size:18px;font-weight:700;background-color:#FFE500;\">游戏STEAM详细介绍链接点击即可跳转</span></span><span style=\"font-size:18px;background-color:#FFE500;\"></span> \r\n	<p>\r\n		<span style=\"color:#ACB2B8;font-family:\" font-size:14px;background-color:#1b2838;\"=\"\">Indivisible是一款动作RPG平台游戏，具有令人惊叹的手绘艺术和动画，以及独特的实时战斗力学</span> \r\n	</p>\r\n	<p>\r\n		<a href=\"https://store.steampowered.com/app/421170/Indivisible/\" target=\"_blank\">https://store.steampowered.com/app/421170/Indivisible/</a> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:18px;background-color:#FFE500;\"><br />\r\n</span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n</p>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201101175812dU.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	113,	15,	'2020-11-01 17:57:41',	0,	1,	1,	'扮演 动作 独立 女性主角 动漫 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256764040/movie480.webm?t=1570546852',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(111,	'飞向月球中文版百度云',	0.00,	'<p style=\"text-align: justify; color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\"><span style=\"font-size:14pt;\"><strong><span style=\"color:#666666;font-size:18px;font-weight:700;background-color:#FFE500;\">游戏STEAM详细介绍链接点击即可跳转</span><br />\r\n</strong></span> \r\n	</p>\r\n<p style=\"text-align: justify; color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\"><span style=\"font-size:14pt;\"><strong><a href=\"https://store.steampowered.com/app/428660/Deliver_Us_The_Moon/\" target=\"_blank\">https://store.steampowered.com/app/428660/Deliver_Us_The_Moon/</a><br />\r\n</strong></span> \r\n</p>\r\n<p style=\"text-align: justify; color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\"><span style=\"font-size:14pt;\"><strong><br />\r\n</strong></span> \r\n	</p>\r\n<p style=\"text-align: justify; color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\"><span style=\"font-size:14pt;\"><strong>游戏介绍：</strong></span> \r\n</p>\r\n<p style=\"text-align: justify; color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\">《飞向月球 Deliver Us The Moon》是一款科幻惊悚游戏，以地球自然资源枯竭的近未来末世为背景。为解决能源危机，全球大国合力创建 World Space Agency，并从月球上获得了一种可靠的新能源。 World Space Agency 殖民月球并开展运作，直到一个致命的夜晚，月球与地球断绝所有通讯，能源也就此消失。数年后的今天，你将充当地球上最后一名宇航员的角色，执行一项生死攸关的任务，调查情况并拯救全人类。\r\n	</p>\r\n<p style=\"text-align: justify; color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\"><strong>游戏特色：</strong> \r\n</p>\r\n<p style=\"text-align: justify; color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\">真实世界主题<br />\r\n故事聚焦于当今热门话题，例如气候变化与全球自然资源的枯竭。<br />\r\n多种游戏风格<br />\r\n体验第 1 与第 3 人称游戏场景，跟随《Deliver Us The Moon》踏上不拘类型的冒险历程<br />\r\n成为宇航员<br />\r\n从地球发射火箭，穿越 WSA 空间站，在自由的失重环境下探索开阔的月球风光——任选步行、漫游者或单轨车<br />\r\n揭示过去<br />\r\n早期月球任务的废墟隐藏着许多故事和秘密。使用你的 Astrotool 来揭示月球殖民地的历史<br />\r\n太空时代科技装备<br />\r\n借助唯一的同伴无人机 ASE，充分利用人类最为先进的科技产品，包括新时代太空服、切割激光、火箭<br />\r\n和机械臂<br />\r\n在危险环境中生存氧气罐随时耗尽，无尽的虚空时刻笼罩着你——生存并非易事<br />\r\n破解谜题<br />\r\n利用各种工具和所有智慧解决复杂的谜题，克服拦路的障碍与危险，揭开过去的秘密<br />\r\n在激动人心的恢宏配乐中体验失重感<br />\r\n《Deliver Us The Moon》以最伟大的科幻作品为灵感来源，内含长达三小时的原创配乐，足以与电影媲美<br />\r\n基于 Unreal&reg; Engine 4 开发<br />\r\n《Deliver Us The Moon》借助 Unreal&reg; Engine 4 打造精彩绝伦的游戏体验与美轮美奂的游戏画面\r\n	</p>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201101180052Yp.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	110,	14,	'2020-11-01 18:00:13',	0,	1,	1,	'冒险 独立 动作 太空 科幻 单人 氛围 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256770580/movie480.webm?t=1576764051',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(112,	'彼岸花 Othercide',	1.00,	'<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">\r\n<div class=\"subtitle column\" style=\"margin:0px;padding:0px 10px 0px 0px;color:#556772;font-family:Arial, Helvetica, sans-serif;font-size:12px;font-style:normal;font-weight:400;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"margin:0px;padding:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;font-size:12px;font-style:normal;font-weight:400;background-color:#1B2838;\">\r\n	2020年7月28日\r\n</div>\r\n</span></span>\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;background-color:#FFE500;\"><span style=\"font-weight:700;background-color:#FFE500;\">游戏STEAM详细介绍链接点击即可跳转</span></span>\r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;background-color:#FFE500;\"><span style=\"font-weight:700;background-color:#FFE500;\"><a href=\"https://store.steampowered.com/app/798490/Othercide/\" target=\"_blank\">https://store.steampowered.com/app/798490/Othercide/</a></span></span>\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">《彼岸花 Othercide》是一款策略模拟游戏<span style=\"background-color:#FFFFFF;\"></span>。人类最后的希望。灵女是人类史上最杰出的战士遗留下来的回响，也是对抗痛苦与死亡的唯一力量。 统领你的灵女军队，利用你力所能及的一切技巧来作战。你作战时的英姿将决定她们的未来与命运，塑造她们的能力与个性。你需要作出无比艰难的抉择：通过献祭一个灵<span style=\"background-color:#000000;\"></span>女的方式来治愈另一个。活下来的灵女会变得更强，足以迎接下一场战斗。 每场战斗都是一套由华丽动作与反击交织而成的繁复舞步：预先做好计划，利用令人惊艳的连锁技能智取敌人。在史诗般的 Boss 战中抗击痛苦的根源——因人类对自身犯下的极端罪行而衍生出的一众恐怖生物。 你会去作战。你会失败。你还会重新站起身来。\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><br />\r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n	</p>\r\n<ul class=\"bb_ul\" style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">\r\n	<li>\r\n		统领、进化并献祭你的灵女军队\r\n	</li>\r\n	<li>\r\n		华丽的战术 RPG，让您设法智取各种梦魇生物\r\n	</li>\r\n	<li>\r\n		动态时间轴系统，缔造无限战斗可能\r\n	</li>\r\n	<li>\r\n		深刻而丰富的剧情，覆盖千劫万世的时间跨度\r\n	</li>\r\n	<li>\r\n	</li>\r\n		</ul>',	58,	'https://fhdemo.s-cms.cn/t15/media/202011011803146n.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	202,	14,	'2020-11-01 18:02:14',	0,	1,	1,	'策略 独立 回合制战术 回合制战斗 战术 \r\n',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256794222/movie480_vp9.webm?t=1595930688',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(113,	'暴君 Tyranny',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span>\r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	</div>\r\n	<p>\r\n		<br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><br />\r\n</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《暴君 Tyranny》是一款传达着传统古典韵味，又不乏新颖设定的CRPG角色扮演类游戏。角色创建系统选项丰富，非职业而以技能为主定义人物特性的改变颇具新意。与此同时，融入了略带策略要素的“征服模式”来使得游戏更具深度，使玩家的旅程演变出了更多的可能性。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n</p>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201101180437cd.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	80,	8,	'2020-11-01 18:03:59',	0,	1,	1,	'色扮演 剧情丰富 选择取向 等角 冒险 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256736183/movie480.webm?t=1542725629',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(114,	'杀手2黄金版 Hitman 2',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span>\r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		<br />\r\n	</div>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《杀手2 Hitman 2》是一款第三人称视角的单人动作冒险类游戏，在各式各类的动作和射击类题材游戏中，身手矫捷，手法利落的刺客不仅是作品中的常客，也是不少玩家憧憬的对象。而要论起资历最老，形象最为鲜明的刺客，自然有那位条形码杀手47的一席之地经历了大半年的人事迁移和变动后，制作组归纳到了华纳旗下。如今，重新安定的I-O interactive能否给传奇杀手47的篇章续写新的高峰呢？（支持繁简中文）\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: OS 64-bit Windows 7<br />\r\n处理器: Intel CPU Core i5-2500K 3.3GHz / AMD CPU Phenom II X4 940<br />\r\n内存: 8 GB RAM<br />\r\n显卡: NVIDIA GeForce GTX 660 / Radeon HD 7870<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 60 GB 可用空间\r\n</p>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201101180604jK.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	197,	41,	'2020-11-01 18:05:28',	0,	1,	1,	'单人 第三人称 潜行 动作 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256738783/movie480.webm?t=1545171866',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(115,	'死人之国',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">\r\n<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	2018年9月26日\r\n</div>\r\n<span style=\"background-color:#FFE500;\"></span><span style=\"background-color:#FFE500;\">游戏STEAM详细介绍链接点击即可跳转</span></span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/351100/Niffelheim/\" target=\"_blank\">https://store.steampowered.com/app/351100/Niffelheim/</a><br />\r\n</span></span>\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;font-weight:700;\">游戏特色：</span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">不要成为被遗忘的人之一。<br />\r\n摧毁任何干预攻击你土地的人。每个被击败的敌人都将向仙宫迈出一步！骨头，牙齿皮: 一切都将作为武器或盔甲。建立一个堡垒， 不仅可以保护你免受攻击，还可以帮助你击败的敌人。死神牧师会对你施加挑战。你会执行还是会拒绝加入他们的仆人之战?<br />\r\n去找出口<br />\r\n收集所有向仙宫的门户碎片。但要小心。应为强大的巨人，不死生物和致命的蜘蛛守护着每一个。<br />\r\n创建\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7 and newest<br />\r\n处理器: 1.7 GHz Dual Core<br />\r\n内存: 4 GB RAM<br />\r\n显卡: Intel Iris 4800<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 1 GB 可用空间\r\n	</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/202011011807277L.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	125,	10,	'2020-11-01 18:07:20',	0,	1,	1,	'角色扮演  生存 冒险 独立 恐怖',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256761324/movie480.webm?t=1567780912',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(116,	'夜间城邦 中文版',	0.00,	'<p>\r\n	<span style=\"font-size:18px;\"> </span> \r\n</p>\r\n<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	2019年11月1日\r\n</div>\r\n<p>\r\n	<span style=\"font-size:18px;background-color:#FFE500;\"><strong>游戏STEAM详细介绍链接点击即可跳转</strong></span> \r\n</p>\r\n<p>\r\n	<span style=\"font-size:18px;\"><a href=\"https://store.steampowered.com/app/1108370/Ratropolis/\" target=\"_blank\">https://store.steampowered.com/app/1108370/Ratropolis/</a><br />\r\n</span> \r\n</p>',	54,	'https://fhdemo.s-cms.cn/t15/media/20201101181138gW.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	67,	9,	'2020-11-01 18:11:01',	0,	1,	1,	'纸牌 策略 卡牌',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256760552/movie480.webm?t=1567086963',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(117,	'骰子地下城',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">\r\n<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	2019年8月14日\r\n</div>\r\n<span style=\"background-color:#FFE500;\"></span><span style=\"background-color:#FFE500;\">游戏STEAM详细介绍链接点击即可跳转</span><span style=\"background-color:#FFE500;\"></span></span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><span style=\"background-color:#FFE500;\"><a href=\"https://store.steampowered.com/app/861540/Dicey_Dungeons/\" target=\"_blank\">https://store.steampowered.com/app/861540/Dicey_Dungeons/</a><br />\r\n</span></span></span>\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《骰子地下城 Dicey Dungeons》是由独立游戏制作人 Terry Cavanagh ，知名游戏音乐人 Chipzel 和插画师 Marlowe Dobbe 开发的快节奏卡牌构建式 Roguelike 游戏。尝试掌握每一种职业，看看那一种风格最适合自己，你将闯入一个充满惊喜、翻转，秘密的神奇地下城，屠戮怪物，搜刮宝藏，在挑战幸运女神的道路上变得越来越强大。但是，你能不能闯出一条生路呢？幸运可不会永远站在你的那边。\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;font-size:14pt;\">游戏特色：</span>\r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	拿来主义，随机偷窃敌人技能的盗贼；\r\n</li>\r\n<li>\r\n	人狠话不多、见面就是莽的战士；\r\n</li>\r\n<li>\r\n	需要精密计划、运筹帷幄的女巫；\r\n</li>\r\n<li>\r\n	挑战运气、高风险高回报的机器人；\r\n</li>\r\n<li>\r\n	创意为王，变废为宝，但每次战斗都会损坏一件装备的发明家；\r\n</li>\r\n<li>\r\n	以及更多即将登场的英雄。\r\n</li>\r\n<li>\r\n	六种风格迥异的可玩职业：战士，盗贼，机器人，小丑，发明家和女巫。\r\n</li>\r\n<li>\r\n	种类繁多的敌人：从会吸血的真空吸尘器，到爱尔兰的神话生物，甚至连脾气温和的恶毒雪人都登了场。\r\n</li>\r\n<li>\r\n	由《超级六边形》配乐 Chipzel 负责音乐：采用了扣人心弦，欢快激昂的电子风配乐。\r\n</li>\r\n<li>\r\n	由插画家 Marlowe Dobbe 负责美术：活泼，可爱，充满想象力。\r\n</li>\r\n<li>\r\n	关卡随机生成，允许反复挑战。\r\n</li>\r\n	</ul>',	73,	'https://fhdemo.s-cms.cn/t15/media/20201101181417DW.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	25,	6,	'2020-11-01 18:14:01',	0,	1,	1,	'快节奏 卡牌  卡牌战斗',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(118,	'巫师之昆特牌：王权的陨落',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<br />\r\n</p>\r\n<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	2018年11月10日\r\n</div>\r\n<span style=\"font-size:18px;background-color:#FFE500;\"><strong></strong></span><span style=\"font-size:18px;background-color:#FFE500;\"><strong>游戏STEAM详细介绍链接点击即可跳转</strong></span><span style=\"font-size:18px;background-color:#FFE500;\"><strong></strong></span> \r\n<p>\r\n	<br />\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:18px;background-color:#FFE500;\"><strong><a href=\"https://store.steampowered.com/app/973760/Thronebreaker_The_Witcher_Tales/\" target=\"_blank\">https://store.steampowered.com/app/973760/Thronebreaker_The_Witcher_Tales/</a><br />\r\n</strong></span> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:18px;\"><strong><br />\r\n</strong></span> \r\n</p>',	54,	'https://fhdemo.s-cms.cn/t15/media/20201101181550yl.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	157,	31,	'2020-11-01 18:15:15',	0,	1,	1,	'角色扮演 冒险 卡牌游戏 剧情丰富 单人 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256735206/movie480.webm?t=1541940358',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(119,	'《不动就会死 Move or Die》',	0.00,	'<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	2016年1月22日\r\n</div>\r\n<p>\r\n	<span style=\"font-size:18px;background-color:#FFE500;\"><strong></strong></span><span style=\"font-size:18px;background-color:#FFE500;\"><strong>游戏STEAM详细介绍链接点击即可跳转</strong></span><span style=\"font-size:18px;background-color:#FFE500;\"><strong></strong></span>\r\n</p>\r\n<p>\r\n	<span style=\"font-size:18px;background-color:#FFE500;\"><strong><a href=\"https://store.steampowered.com/app/323850/Move_or_Die/\" target=\"_blank\">https://store.steampowered.com/app/323850/Move_or_Die/</a><br />\r\n</strong></span>\r\n</p>\r\n<p>\r\n	<span style=\"font-size:18px;\"><strong><br />\r\n</strong></span>\r\n</p>',	26,	'https://fhdemo.s-cms.cn/t15/media/20201101182052kI.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	28,	5,	'2020-11-01 18:20:38',	0,	1,	1,	'人 欢乐 本地多人 动作 快节奏 二维 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256738992/movie480.webm?t=1545329368',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(120,	'黑相集：稀望镇-（官中）单机-联机',	0.00,	'<div class=\"game_page_autocollapse_ctn\" style=\"padding:0px;margin:0px;color:#ACB2B8;font-family:Arial, Helvetica, sans-serif;font-size:14px;background-color:#1B2838;\">\r\n	<div class=\"game_page_autocollapse\" style=\"padding:0px;margin:0px;\">\r\n		<div id=\"game_area_description\" class=\"game_area_description\" style=\"padding:0px;margin:30px 0px 0px;font-family:;\">\r\n			<h2 style=\"font-weight:normal;font-size:14px;color:#FFFFFF;\">\r\n				关于这款游戏\r\n			</h2>\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/1194630/extras/LittleHope_Steam_Gif_01.gif?t=1604413395\" /><br />\r\n<br />\r\n《黑相集》是一系列惊险刺激的独立电影式恐怖游戏作品，情节具有多重分支，包含单人及多人游戏模式。<br />\r\n<br />\r\n有四名大学生与他们的教授意外受困于荒废的“稀望镇”。他们被无法穿越的迷雾包围，死命地试着逃脱，又目睹了来自过去的恐怖幻觉。他们必须在邪恶力量将所有成员的灵魂拽进地狱前，厘清这些亡灵的动机。<br />\r\n<br />\r\n见证来自过去的恐怖幻觉，十七世纪安多佛女巫审判案的阴影盘桓不去。<br />\r\n<br />\r\n逃离在迷雾中紧追着他们不放的恐怖亡灵！<br />\r\n<br />\r\n与一名朋友连线或与至多五名朋友一起脱机游玩…… <br />\r\n所有踏进此地的人……终将无所“稀望”！<br />\r\n<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/1194630/extras/LittleHope_Steam_Gif_02.gif?t=1604413395\" /> \r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"padding:0px;margin:0px;color:#ACB2B8;font-family:Arial, Helvetica, sans-serif;font-size:14px;background-color:#1B2838;\">\r\n	<div class=\"game_page_autocollapse\" style=\"padding:0px;margin:0px;\">\r\n		<div id=\"game_area_content_descriptors\" class=\"game_area_description\" style=\"padding:0px;margin:30px 0px 0px;font-family:;\">\r\n			<h2 style=\"font-weight:normal;font-size:14px;color:#FFFFFF;\">\r\n				成人内容描述\r\n			</h2>\r\n			<p>\r\n				开发者对内容描述如下：\r\n			</p>\r\n			<p>\r\n				<i>The game contains scenes of violence and bad language, and mild alcohol use. <br />\r\n</i> \r\n			</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"padding:0px;margin:0px;color:#ACB2B8;font-family:Arial, Helvetica, sans-serif;font-size:14px;background-color:#1B2838;\">\r\n	<div class=\"game_page_autocollapse sys_req\" style=\"padding:0px;margin:30px 0px 0px;\">\r\n		<h2 style=\"font-weight:normal;font-size:14px;color:#FFFFFF;font-family:;\">\r\n			系统需求\r\n		</h2>\r\n		<div class=\"sysreq_contents\" style=\"padding:0px;margin:10px 0px 0px;\">\r\n			<div class=\"game_area_sys_req sysreq_content active\" style=\"padding:0px;margin:0px;font-size:12px;font-family:;\">\r\n				<div class=\"game_area_sys_req_leftCol\" style=\"padding:0px;margin:0px;\">\r\n					<ul>\r\n						<span style=\"font-family:Arial, Helvetica, sans-serif;font-size:10px;color:#BCC6CD;\">最低配置:</span><br />\r\n						<ul class=\"bb_ul\">\r\n							<li>\r\n								需要 64 位处理器和操作系统<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">操作系统:</span> Windows 10 64bit<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">处理器:</span> Intel Core i5-3470 or AMD FX-8350<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">内存:</span> 8 GB RAM<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">显卡:</span> NVIDIA GeForce GTX 750 Ti or AMD Radeon HD 8570<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">DirectX 版本:</span> 12<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">网络:</span> 宽带互联网连接<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">存储空间:</span> 需要 80 GB 可用空间\r\n							</li>\r\n						</ul>\r\n					</ul>\r\n				</div>\r\n				<div class=\"game_area_sys_req_rightCol\" style=\"padding:0px;margin:0px 0px 0px 8px;\">\r\n					<ul>\r\n						<span style=\"font-family:Arial, Helvetica, sans-serif;font-size:10px;color:#BCC6CD;\">推荐配置:</span><br />\r\n						<ul class=\"bb_ul\">\r\n							<li>\r\n								需要 64 位处理器和操作系统<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">操作系统:</span> Windows 10 64-bit<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">处理器:</span> Intel Core i5- 8400 or AMD Ryzen 5 1600<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">内存:</span> 8 GB RAM<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">显卡:</span> NVIDIA GeForce GTX 1060 or AMD Radeon RX 580<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">DirectX 版本:</span> 12<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">网络:</span> 宽带互联网连接<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">存储空间:</span> 需要 80 GB 可用空间\r\n							</li>\r\n						</ul>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	26,	'https://fhdemo.s-cms.cn/t15/media/20201101182410gd.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	153,	36,	'2020-11-01 18:23:43',	0,	1,	1,	'独立 电影 恐怖 冒险解密',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(121,	'追踪地平线 双人',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">\r\n<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	2018年5月15日\r\n</div>\r\n游戏STEAM详细介绍链接点击即可跳转</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/389140/Horizon_Chase_Turbo/\" target=\"_blank\">https://store.steampowered.com/app/389140/Horizon_Chase_Turbo/</a><br />\r\n</span></span>\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《追踪地平线Turbo Horizon Chase Turbo》是一款赛车竞速类(RAC)游戏，在游戏中，玩家可以在世界各地巡回比赛，感受美丽风景。并提供多人分屏模式，让你找到多年前的沙发共乐友谊。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n</p>',	26,	'https://fhdemo.s-cms.cn/t15/media/20201101182655hu.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	127,	11,	'2020-11-01 18:26:25',	0,	1,	1,	'竞速 休闲 独立 体育 街机 动作 怀旧 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256750867/movie480.webm?t=1558044267',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(122,	'蛋糕狂欢节 本地联机 ',	0.00,	'<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span>\r\n<div class=\"subtitle column\" style=\"margin:0px;padding:0px 10px 0px 0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"margin:0px;padding:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	2020年10月15日\r\n</div>\r\n游戏STEAM详细介绍链接点击即可跳转\r\n<p>\r\n	<br />\r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/971690/Cake_Bash/\" target=\"_blank\">https://store.steampowered.com/app/971690/Cake_Bash/</a></span></span> \r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><span style=\"color:#666666;font-size:14px;\"><span style=\"font-size:14px;font-weight:700;\">最低配置:</span></span><br />\r\n<span style=\"color:#666666;background-color:rgba(255, 255, 255, 0.95);\">需要 64 位处理器和操作系统</span><br />\r\n<span style=\"color:#666666;background-color:rgba(255, 255, 255, 0.95);\">操作系统: Windows 7, 8, 10</span><br />\r\n<span style=\"color:#666666;background-color:rgba(255, 255, 255, 0.95);\">处理器: Intel Core i3 2.5GHz or equivalent</span><br />\r\n<span style=\"color:#666666;background-color:rgba(255, 255, 255, 0.95);\">内存: 2 GB RAM</span><br />\r\n<span style=\"color:#666666;background-color:rgba(255, 255, 255, 0.95);\">显卡: NVIDIA GeForce 550 or equivalent</span><br />\r\n<span style=\"color:#666666;background-color:rgba(255, 255, 255, 0.95);\">DirectX 版本: 11</span><br />\r\n<span style=\"color:#666666;background-color:rgba(255, 255, 255, 0.95);\">存储空间: 需要 800 MB 可用空间</span><span style=\"font-size:14px;\"></span><br />\r\n</span></span> \r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><br />\r\n	</p>',	26,	'https://fhdemo.s-cms.cn/t15/media/20201101182747s3.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	71,	11,	'2020-11-01 18:27:34',	0,	1,	1,	'休闲 清版动作 可爱3D 格斗 玩家对战\r\n',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256804889/movie480_vp9.webm?t=1602738683',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	'2021-08-07 11:58:31'),
(123,	'革命曲途  双人',	0.00,	'<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏EPIC详细介绍链接点击即可跳转<br />\r\n</strong></span> \r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong><a href=\"https://www.epicgames.com/store/en-US/product/no-straight-roads/home\" target=\"_blank\">https://www.epicgames.com/store/en-US/product/no-straight-roads/home</a><br />\r\n</strong></span> \r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏介绍：</strong></span> \r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">《革命曲途 》是一款冒险解密类游戏，玩家控制主角，为了夺回音乐都市而与统治阶层EDM帝国进行战斗。游戏结合了音乐节奏与第三人称视角动作的内容。游戏的一大想法是希望提升音效在游戏设计中的地位，而非只是单纯作为节奏游戏，他们希望藉由强大No Straight Roads的视觉效果结合音乐，来讲述音乐文化与理想等故事。\r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><a class=\"highslide-image\" href=\"https://s1.jiligame.com/images/2020/08/30/c25f4292c2554456c57e0c166c289e45.jpg\"><br />\r\n</a> \r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>最低配置：</strong></span><br />\r\n操作系统: Windows 7<br />\r\n处理器: Intel i5-3570 或 AMD FX-8350<br />\r\n内存: 6 GB 内存<br />\r\n存储空间: 25 GB\r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><br />\r\n	</p>',	26,	'https://fhdemo.s-cms.cn/t15/media/20201101182951iD.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	119,	12,	'2020-11-01 18:29:29',	0,	1,	1,	'音乐 打怪升级 幻想 星际 冒险解密',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(124,	'堕落天使路西法 双人',	0.00,	'<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><span style=\"font-size:18px;background-color:#FFE500;\"><br />\r\n</span></span></span>\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><span style=\"background-color:#FFE500;\"><span style=\"color:#000000;\"></span><br />\r\n</span></span></span> \r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：<span style=\"background-color:#FFFFFF;\"></span></span></span> \r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">《堕落天使路西法 Fallen Angel》是Matrioshka Games制作，V Publishing发行的一款像素风格的动作冒险游戏，在游戏中玩家将成为一名堕天使，为了重回天堂而和大天使军团开启了战争，不断地强化自己，探索自己所在的区域，战胜各个区域的大天使。\r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;font-weight:700;\">最低配置:</span> \r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"> 操作系统: Windows 7 and above<br />\r\n处理器: 2 GHz<br />\r\n内存: 3 GB RAM<br />\r\n显卡: 512 mb video memory<br />\r\n存储空间: 需要 1 GB 可用空间\r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。 <br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。 <br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！ <br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。 <br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n	</p>',	26,	'https://fhdemo.s-cms.cn/t15/media/20201101183056Zu.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	40,	6,	'2020-11-01 18:30:41',	0,	1,	1,	'像素风格 俯视视角 动作 角色扮演',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256805850/movie480_vp9.webm?t=1603294358',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	'2021-08-07 11:58:28'),
(125,	'黑暗之魂重制版/Dark Souls：Remastered',	0.00,	'<div class=\"game_page_autocollapse_ctn\" style=\"padding:0px;margin:0px;color:#ACB2B8;font-family:Arial, Helvetica, sans-serif;font-size:14px;background-color:#1B2838;\">\r\n	<div class=\"game_page_autocollapse\" style=\"padding:0px;margin:0px;\">\r\n		<div id=\"game_area_description\" class=\"game_area_description\" style=\"padding:0px;margin:30px 0px 0px;font-family:;\">\r\n			<h2 style=\"font-weight:normal;font-size:14px;color:#FFFFFF;\">\r\n				关于这款游戏\r\n			</h2>\r\n有一天，燃起了第一团火。<br />\r\n<br />\r\n重新体验话题性、代表性十足的经典游戏。<br />\r\n经过画质提升，将以惊艳的60fps形式呈现，做好重返罗德兰的准备吧。<br />\r\n黑暗灵魂 Remastered包含游戏本体，以及DLC《Artorias of the Abyss》。<br />\r\n<br />\r\n游戏特色：<br />\r\n- 黑暗与深沉的世界观<br />\r\n- 每一次结束都是一个新开始<br />\r\n- 游戏丰富性与各种可能性<br />\r\n- 体验学习、克服、获得成就感的连锁效应<br />\r\n- 可多人联机游玩（人数最多可至6人）\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"padding:0px;margin:0px;color:#ACB2B8;font-family:Arial, Helvetica, sans-serif;font-size:14px;background-color:#1B2838;\">\r\n	<div class=\"game_page_autocollapse sys_req\" style=\"padding:0px;margin:30px 0px 0px;\">\r\n		<h2 style=\"font-weight:normal;font-size:14px;color:#FFFFFF;font-family:;\">\r\n			系统需求\r\n		</h2>\r\n		<div class=\"sysreq_contents\" style=\"padding:0px;margin:10px 0px 0px;\">\r\n			<div class=\"game_area_sys_req sysreq_content active\" style=\"padding:0px;margin:0px;font-size:12px;font-family:;\">\r\n				<div class=\"game_area_sys_req_leftCol\" style=\"padding:0px;margin:0px;\">\r\n					<ul>\r\n						<span style=\"font-family:Arial, Helvetica, sans-serif;font-size:10px;color:#BCC6CD;\">最低配置:</span><br />\r\n						<ul class=\"bb_ul\">\r\n							<li>\r\n								需要 64 位处理器和操作系统<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">操作系统:</span> Windows 7 64-bit, Service Pack 1<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">处理器:</span> Intel Core i5-2300 2.8 GHz / AMD FX-6300, 3.5 GHz<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">内存:</span> 6 GB RAM<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">显卡:</span> GeForce GTX 460, 1 GB / Radeon HD 6870, 1 GB<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">DirectX 版本:</span> 11<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">存储空间:</span> 需要 8 GB 可用空间<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">声卡:</span> DirectX 11 sound device<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">附注事项:</span> Low Settings, 60 FPS @ 1080p\r\n							</li>\r\n						</ul>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201101183425h8.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	18,	5,	'2020-11-01 18:32:55',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(126,	'星球大战：前线2（Star Wars Battlefront 2）',	1.00,	'<h3 style=\"color:#555555;font-family:Lato, sans-serif;font-size:18px;\">\r\n	<div class=\"subtitle column\" style=\"margin:0px;padding:0px 10px 0px 0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		<br />\r\n	</div>\r\n</h3>\r\n<p>\r\n	<br />\r\n</p>\r\n<div class=\"sysreq_contents\" style=\"margin:10px 0px 0px;padding:0px;color:#ACB2B8;font-family:Arial, Helvetica, sans-serif;font-size:14px;background-color:#1B2838;\">\r\n	<div class=\"game_area_sys_req sysreq_content active\" style=\"margin:0px;padding:0px;font-family:;font-size:12px;\">\r\n		<div class=\"game_area_sys_req_leftCol\" style=\"margin:0px;padding:0px;\">\r\n			<ul>\r\n				<span style=\"color:#BCC6CD;font-family:Arial, Helvetica, sans-serif;font-size:10px;\">最低配置:</span><br />\r\n				<ul class=\"bb_ul\">\r\n					<li>\r\n						需要 64 位处理器和操作系统<br />\r\n					</li>\r\n					<li>\r\n						<span style=\"color:#61686D;font-family:Arial, Helvetica, sans-serif;\">操作系统:</span> 64-bit Windows 7 SP1/Windows 8.1/Windows 10<br />\r\n					</li>\r\n					<li>\r\n						<span style=\"color:#61686D;font-family:Arial, Helvetica, sans-serif;\">处理器:</span> Processor (AMD): AMD FX 6350 Processor (Intel): Intel Core i5 6600K<br />\r\n					</li>\r\n					<li>\r\n						<span style=\"color:#61686D;font-family:Arial, Helvetica, sans-serif;\">内存:</span> 8 GB RAM<br />\r\n					</li>\r\n					<li>\r\n						<span style=\"color:#61686D;font-family:Arial, Helvetica, sans-serif;\">显卡:</span> Graphics card (AMD): AMD Radeon™ HD 7850 2GB Graphics card (NVIDIA): NVIDIA GeForce&reg; GTX 660 2GB<br />\r\n					</li>\r\n					<li>\r\n						<span style=\"color:#61686D;font-family:Arial, Helvetica, sans-serif;\">DirectX 版本:</span> 11<br />\r\n					</li>\r\n					<li>\r\n						<span style=\"color:#61686D;font-family:Arial, Helvetica, sans-serif;\">网络:</span> 宽带互联网连接<br />\r\n					</li>\r\n					<li>\r\n						<span style=\"color:#61686D;font-family:Arial, Helvetica, sans-serif;\">存储空间:</span> 需要 60 GB 可用空间\r\n					</li>\r\n				</ul>\r\n			</ul>\r\n		</div>\r\n	</div>\r\n</div>\r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<br />\r\n</p>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201101183617Rq.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	261,	31,	'2020-11-01 18:35:35',	0,	1,	1,	'多人 第一人称射击 射击 第三人称射击  星球大战',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256789731/movie480_vp9.webm?t=1592407744',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	'2021-08-07 11:58:27'),
(127,	'《GTFO》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">\r\n<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	2019年12月10日\r\n</div>\r\n游戏STEAM详细介绍链接点击即可跳转</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/493520/GTFO/\" target=\"_blank\">https://store.steampowered.com/app/493520/GTFO/</a></span></span>\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;font-size:14pt;\">游戏介绍：</span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《GTFO》是一款四人合作硬核第一人称射击游戏，强调团队合作，氛围恐怖浓厚。游戏战斗紧张，悬念迭出，另外需要多人协同破解难题。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>',	37,	'https://fhdemo.s-cms.cn/t15/media/20201101184004Mn.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	148,	12,	'2020-11-01 18:39:24',	0,	1,	1,	'抢先体验 恐怖 在线合作 动作 多人 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256702878/movie480.webm?t=1512706915',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(241,	'灵魂摆渡者《Spiritfarer》中文版百度云',	1.00,	'<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：STEAM售价132</span></span> \r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">《Spiritfarer》是一款关于死亡的休闲管理游戏。你扮演逝者的船主斯特拉，也是一名灵魂摆渡者。建造一艘船去探索世界，然后帮助和关爱幽灵，最终将他们送到来世。耕种、采矿、捕鱼、收割、烹饪，并用你自己的方法渡过神秘之海。加入小猫达芙迪尔的冒险之旅，开启双人合作模式。与你的幽灵乘客一起度过悠闲的美好时光，创造永恒的回忆，最终学会如何向你珍爱的朋友道别。\r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><br />\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul class=\"bb_ul\" style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">\r\n<li>\r\n	享受美丽的手绘艺术和动画。\r\n</li>\r\n<li>\r\n	建造、管理和改进你的渡船。\r\n</li>\r\n<li>\r\n	耕种、采矿、捕鱼、收割、烹饪、编织、制作！各种各样的活动在等着你！\r\n</li>\r\n<li>\r\n	结识一群令人难忘的角色，带他们上船，关爱他们，与他们建立良好的关系。\r\n</li>\r\n<li>\r\n	你可以采用奔跑、跳跃和滑行的方式一路闯过精心设计的平台关卡。\r\n</li>\r\n<li>\r\n	探索奇幻和充满想象力的世界。寻找和收集各种资源，以升级你的船只并为乘客制作礼物。\r\n</li>\r\n<li>\r\n	体验充满难忘瞬间的感人故事。\r\n</li>\r\n<li>\r\n	放松几个小时，进入舒适且令人放松的游戏。花上30个小时即可完成整个游戏，花上几百个小时则能详细感受《Spiritfarer》的所有细节。\r\n</li>\r\n<li>\r\n	游戏内针对船只、角色甚至是小猫都有丰富的自定义选项，助你打造独一无二的冒险之旅！\r\n</li>\r\n<li>\r\n	在可选的本地合作模式下扮演小猫达芙迪尔。\r\n</li>\r\n	</ul>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Microsoft&reg; Windows&reg; 7 SP1<br />\r\n处理器: Dual Core 3.0 GHz Processor<br />\r\n内存: 4 GB RAM<br />\r\n显卡: DirectX 10-compatible graphics card with at least 1GB of video memory<br />\r\nDirectX 版本: 10<br />\r\n存储空间: 需要 7 GB 可用空间\r\n		</p>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102162846eH.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	217,	21,	'2020-11-02 16:27:59',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256797231/movie480_vp9.webm?t=1597770054',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(128,	'《惊恐航海 Dread Nautical》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		<span style=\"font-weight:700;font-size:14pt;color:#666666;font-family:\">游戏介绍：</span>\r\n	</div>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《惊恐航海 Dread Nautical》是一款异常令人着迷的战术回合制角色扮演游戏。你安逸的休闲旅行，被异次元来的、屠虐一切的怪兽打破。击退他们，高效管理自己的资源，并且说服其他分散的幸存者加入你的队伍。一款异常令人着迷的战术回合制角色扮演游戏。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;font-size:14pt;\">最低配置：</span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"> 操作系统：Windows 7<br />\r\n处理器：Intel Core i5-2500K 或 AMD 同等产品<br />\r\n内存：4 GB<br />\r\n存储空间： 2.5GB<br />\r\nDirectX: 11<br />\r\n显示卡：Intel HD 4400 或 Nvidia / AMD 出品的同等产品。\r\n</p>',	45,	'https://fhdemo.s-cms.cn/t15/media/20201102091208vi.png',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	25,	6,	'2020-11-02 09:12:02',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256806836/movie480_vp9.webm?t=1603828651',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(129,	'永生之境：吸血鬼战争 ',	0.00,	'<p>\r\n	<strong> </strong> \r\n</p>\r\n<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	<strong>发行日期:</strong> \r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	<strong>2020年8月29日</strong> \r\n</div>\r\n<strong><span style=\"font-size:18px;\"></span><span style=\"font-size:18px;\">游戏STEAM详细介绍链接点击即可跳转</span><span style=\"font-size:18px;\"></span><br />\r\n</strong> \r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<strong><span style=\"font-size:18px;\"><a href=\"https://store.steampowered.com/app/1024480/Immortal_Realms_Vampire_Wars/\" target=\"_blank\">https://store.steampowered.com/app/1024480/Immortal_Realms_Vampire_Wars/</a><br />\r\n</span></strong> \r\n</p>\r\n<p>\r\n	<strong>游戏介绍：</strong> \r\n</p>\r\n<p>\r\n	《永生之境：吸血鬼战争 Immortal Realms: Vampire Wars》是一款具有独特卡牌的回合制策略游戏。从四位强大的吸血鬼领主的角度，探索Nemire的秘并体验一个引人入胜的故事，同时指挥三个独特的吸血鬼家族中的一个，拥有独特的单位、力量、游戏机制和角色。\r\n</p>\r\n<p>\r\n	<strong>最低配置:</strong> \r\n</p>\r\n<p>\r\n	需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 10 64-bit<br />\r\n处理器: Quad Core 3.2 GHz<br />\r\n内存: 8 GB RAM<br />\r\n显卡: Geforce GTX 770 equivalent<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 24 GB 可用空间\r\n</p>\r\n<p>\r\n	<br />\r\n</p>',	54,	'https://fhdemo.s-cms.cn/t15/media/202011020915278w.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	95,	9,	'2020-11-02 09:14:41',	0,	1,	1,	'策略 吸血鬼 回合战斗 回合战略 单人 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256798894/movie480_vp9.webm?t=1598613468',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(130,	'涅克罗蒙达：下巢战争 Necromunda: Underhive Wars',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2020年9月8日\r\n	</div>\r\n<span style=\"font-size:18px;\">游戏STEAM详细介绍链接点击即可跳转</span> \r\n	<p>\r\n		<br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/566440/_Necromunda_Underhive_Wars/\" target=\"_blank\">https://store.steampowered.com/app/566440/_Necromunda_Underhive_Wars/</a><br />\r\n</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《涅克罗蒙达：下巢战争 Necromunda: Underhive Wars》是一款回合战略游戏，污秽不堪、噩梦般的涅克洛蒙达——蜂巢之都的深处，在下巢那些黑暗曲折、令人晕眩的隧道中，势不两立的帮派势力打打杀杀，争夺个人权力、财富、生存权和荣耀。只有最强的一方才能生存下去。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>',	45,	'https://fhdemo.s-cms.cn/t15/media/202011020916363W.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	70,	8,	'2020-11-02 09:16:07',	0,	1,	1,	'策略 战锤40K 回合战略 多人 单人 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256798782/movie480_vp9.webm?t=1599517133',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(131,	'装甲军团2 Panzer Corps 2',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span>\r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2020年3月20日\r\n	</div>\r\n游戏STEAM详细介绍链接点击即可跳转\r\n	<p>\r\n		<br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/1072040/Panzer_Corps_2/#app_reviews_hash\" target=\"_blank\">https://store.steampowered.com/app/1072040/Panzer_Corps_2/#app_reviews_hash</a><br />\r\n</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《装甲军团2 Panzer Corps 2》是一款回合战略游戏，战争游戏之王再次归来！易于上手难于精通，在这款精心制作的回合制游戏中，你的每一个决定，而不是鼠标的点击频率，将会决定战争的结果。要从智慧上超越你的敌人，而不是速度！游戏的玩法机制种类繁多，包括模型单位的移动，战斗，侦查，包围，天气，占领敌人物资等等。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"> <span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: 64-bit Windows 8/10 (the game runs on Windows 7 but no support will be provided)<br />\r\n处理器: Intel or AMD, Dual Core or better (Requires a 64-bit processor and operating system)<br />\r\n内存: 8 GB RAM<br />\r\n显卡: nVidia or AMD, 2GB VRAM<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 12 GB 可用空间\r\n</p>',	33,	'https://fhdemo.s-cms.cn/t15/media/20201102091725Ys.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	127,	11,	'2020-11-02 09:17:02',	0,	1,	1,	'略 二战 军事 回合制 回合战略 管理 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256778558/movie480.webm?t=1584636953',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(132,	'凯旋堡 Fort Triumph',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span>\r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2020年4月16日\r\n	</div>\r\n游戏STEAM详细介绍链接点击即可跳转\r\n	<p>\r\n		<br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><a href=\"https://store.steampowered.com/app/612570/Fort_Triumph/\" target=\"_blank\">https://store.steampowered.com/app/612570/Fort_Triumph/</a> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	利用你的环境：每棵树或巨石在战斗中都可以作为潜在武器。\r\n</li>\r\n<li>\r\n	制定策略：在四大派系和四种职业之间进行选择。建立你的基地、收集资源，并给你的角色解锁新的技能！\r\n</li>\r\n<li>\r\n	培养你的英雄：获得特技和跨职业技能，使你的英雄每次游戏都独一无二！\r\n</li>\r\n<li>\r\n	探索程序生成的地图：《Fort Triumph》拥有灵活的世界地图，具有可变的地点和活动。每场战斗都需要一个新的计划。\r\n</li>\r\n<li>\r\n	调高音量：Marco Valerio Antonini为游戏创作了原声音乐。\r\n</li>\r\n	</ul>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7 SP1+ (64bit)<br />\r\n处理器: Intel I3 4160 processor or equivalent<br />\r\n内存: 8 GB RAM<br />\r\n显卡: NVIDIA GeForce GT 630 or Equivalent<br />\r\nDirectX 版本: 10<br />\r\n存储空间: 需要 3 GB 可用空间<br />\r\n附注事项: DX10 with Shader 4.0 support required.\r\n		</p>',	45,	'https://fhdemo.s-cms.cn/t15/media/20201102091850PJ.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	89,	6,	'2020-11-02 09:18:40',	0,	1,	1,	'策略 回合制战术 角色扮演 独立 战术 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256781901/movie480_vp9.webm?t=1587053649',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(133,	'暴战机甲兵 BATTLETECH',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2018年4月25日\r\n	</div>\r\n<span style=\"font-size:18px;\">游戏STEAM详细介绍链接点击即可跳转</span> \r\n	<p>\r\n		<br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/637090/BATTLETECH/\" target=\"_blank\">https://store.steampowered.com/app/637090/BATTLETECH/</a><br />\r\n</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《暴战机甲兵 BATTLETECH》是一款机甲回合制策略类游戏，玩家扮演的是一位机甲部队指挥官，可以操控部署各种机甲在星际战场中利用地形、定位、武器选择和特殊能力智取和打败对手。而游戏中的机甲可以跑动、跳跃、摧毁建筑以及进行远程、近身战斗。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: 64-bit Windows 7 or Higher<br />\r\n处理器: Intel&reg; Core™ i3-2105 or AMD&reg; Phenom™ II X3 720<br />\r\n内存: 8 GB RAM<br />\r\n显卡: Nvidia&reg; GeForce™ GTX 560 Ti or AMD&reg; ATI Radeon™ HD 5870 (1 GB VRAM)<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 35 GB 可用空间\r\n</p>',	33,	'https://fhdemo.s-cms.cn/t15/media/202011020920452I.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	74,	6,	'2020-11-02 09:20:17',	0,	1,	1,	'世界 策略 回合制战术 回合制 科幻 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256715066/movie480.webm?t=1524585594',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(134,	'病毒恶化 VirusCrisis',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">\r\n<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	2020年1月1日\r\n</div>\r\n游戏STEAM详细介绍链接点击即可跳转<br />\r\n</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/1036120/_VirusCrisis/\" target=\"_blank\">https://store.steampowered.com/app/1036120/_VirusCrisis/</a><br />\r\n</span></span>\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《病毒恶化 VirusCrisis》是一款回合制策略类游戏。在这个世界中，主角在努力生存的同时要不停的收集资源建设基地，救助不同的人使之成为自己的活下去的希望，这些人有善有恶，一起来投身于这错乱的乱世中吧。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7/8/10<br />\r\n处理器: i5-2400 @3.60GHz<br />\r\n内存: 4 GB RAM<br />\r\n图形: GT 640<br />\r\n存储空间: 需要 2 GB 可用空间\r\n</p>',	73,	'https://fhdemo.s-cms.cn/t15/media/20201102092204fG.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	13,	3,	'2020-11-02 09:21:44',	0,	1,	1,	'策略 独立 模拟 休闲 血腥 裸露 僵尸 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256743692/movie480.webm?t=1555315775',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(135,	'四海旅人 As Far As The Eye',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2020年9月10日\r\n	</div>\r\n<span style=\"font-size:18px;\">游戏STEAM详细介绍链接点击即可跳转</span> \r\n	<p>\r\n		<br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/1119700/_/\" target=\"_blank\">https://store.steampowered.com/app/1119700/_/</a><br />\r\n</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《四海旅人 As Far As The Eye》是一款基于回合制的游牧城市建造游戏。开始一个程序生成的旅程，在一次又一次的艰难困苦中生存下来，直到世界的中心。你将扮演风，指引部落学生们到达世界的中心。你必须帮助他们管理资源，建筑物，以及他们的生活。在世界被淹没前，通过种植业，手工业，以及科学和神话研究增进他们的智慧。值得注意得时，你需要运营你的族人，确保他们免受饥饿困扰，以及被水淹没时得不知所措。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;font-size:14pt;\">最低配置:</span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"> 操作系统: Windows 7 / 8 / 8.1 / 10<br />\r\n处理器: Intel Core2 Duo E4300 / AMD Athlon Dual Core 4450e<br />\r\n内存: 4 GB RAM<br />\r\n显卡: GeForce 8800 GTX / Intel HD 4600 / Radeon HD 3850<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 2 GB 可用空间\r\n	</p>',	45,	'https://fhdemo.s-cms.cn/t15/media/20201102092242Q2.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	105,	10,	'2020-11-02 09:22:32',	0,	1,	1,	'策略 单人 建造 生存 殖民模拟 沙盒 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256799689/movie480_vp9.webm?t=1599147993',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(136,	'魔王大人，击退勇者吧 Legend of Keepers',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span>\r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2020年3月20日\r\n	</div>\r\n<span style=\"font-size:18px;\">游戏介绍点击链接即可</span> \r\n	<p>\r\n		<br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/978520/_/\" target=\"_blank\">https://store.steampowered.com/app/978520/_/</a><br />\r\n</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>',	73,	'https://fhdemo.s-cms.cn/t15/media/20201102092437DO.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	20,	4,	'2020-11-02 09:24:17',	0,	1,	1,	'回合制战斗 迷宫探索 类 Rogue 角色扮演 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256803335/movie480_vp9.webm?t=1601649145',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(137,	'索拉斯塔：法师之冠 Solasta: Crown of the Magister',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2020年10月20日\r\n	</div>\r\n	<p>\r\n		<span style=\"font-size:18px;\">游戏STEAM详细介绍链接点击即可跳转</span> \r\n	</p>\r\n	<p>\r\n		<a href=\"https://store.steampowered.com/app/1096530/Solasta_Crown_of_the_Magister/\" target=\"_blank\">https://store.steampowered.com/app/1096530/Solasta_Crown_of_the_Magister/</a> \r\n	</p>\r\n	<p>\r\n		<br />\r\n	</p>\r\n	<p>\r\n		<br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《索拉斯塔：法师之冠 Solasta: Crown of the Magister》是一款奇幻风格的回合制角色扮演游戏。在游戏中你需要控制角色开始战斗，管理自己的角色，操控4名角色，让这些拥有独特技能的角色互相配合，进行战斗，让你能够做到战斗的胜利！\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;font-weight:700;\">最低配置:</span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"> 操作系统: Windows 7 / 8.1 / 10<br />\r\n处理器: AMD FX 4300 / Intel Core i5-3570K<br />\r\n内存: 8 GB RAM<br />\r\n显卡: Radeon R9 285 / GeForce GTX 950<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 20 GB 可用空间\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n</p>',	45,	'https://fhdemo.s-cms.cn/t15/media/202011020925250s.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	97,	9,	'2020-11-02 09:24:59',	0,	1,	1,	'下城 单人 电脑角色扮演 角色扮演 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256789335/movie480_vp9.webm?t=1592298629',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(138,	'变形金刚战场',	0.00,	'<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong> </strong></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		<strong>发行日期:</strong> \r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		<strong>2020年10月23日</strong> \r\n	</div>\r\n	<p>\r\n		<span style=\"font-size:18px;\">游戏STEAM详细介绍链接点击即可跳转</span><span style=\"font-size:18px;\"></span> \r\n	</p>\r\n	<p>\r\n		<strong>https://store.steampowered.com/app/1177000/TRANSFORMERS_BATTLEGROUNDS/<br />\r\n</strong> \r\n	</p>\r\n	<p>\r\n		<span style=\"font-size:18px;\"><strong>游戏介绍：</strong></span> \r\n	</p>\r\n	<p>\r\n		<br />\r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">《变形金刚：战场 TRANSFORMERS: BATTLEGROUNDS》是一款由Coatsink制作发行的动作格斗游戏。变形金刚：战场支持单人和多人模式。游戏中邪恶的威震天正逐渐逼近火种源，大黄蜂和汽车人需要一个新的指挥官来领导他们拯救地球，玩家就是这个天选之人。\r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><strong>最低配置:</strong> \r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"> 需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 10 64-bit<br />\r\n处理器: Intel i3 Skylake | AMD FX-6000<br />\r\n内存: 8 GB RAM<br />\r\n显卡: AMD Radeon R7 260X | NVIDIA GeForce GTX 750 Ti<br />\r\nDirectX 版本: 12<br />\r\n存储空间: 需要 6 GB 可用空间\r\n</p>',	33,	'https://fhdemo.s-cms.cn/t15/media/202011020926566N.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	78,	7,	'2020-11-02 09:26:19',	0,	1,	1,	'回合制战术 本地合作 单人 机器人 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256805840/movie480_vp9.webm?t=1603436350',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(139,	'文明6-全DLC豪华版-重大更新20201023版-新纪元-拜占庭和高卢包',	1.00,	'<p>\r\n	<span style=\"font-size:18px;\"> </span> \r\n</p>\r\n<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	2019年2月14日\r\n</div>\r\n<p>\r\n	<strong><span style=\"font-size:18px;\">文明6-全DLC豪华版-重大更新20201023版-新纪元-拜占庭和高卢包<br />\r\n</span></strong> \r\n</p>\r\n<p>\r\n	<strong><span style=\"font-size:18px;\">游戏STEAM详细介绍链接点击即可跳转</span></strong> \r\n</p>\r\n<p>\r\n	<a href=\"https://store.steampowered.com/app/947510/Sid_Meiers_Civilization_VI_Gathering_Storm/\" target=\"_blank\">https://store.steampowered.com/app/947510/Sid_Meiers_Civilization_VI_Gathering_Storm/</a>\r\n</p>\r\n<p>\r\n	<br />\r\n</p>',	45,	'https://fhdemo.s-cms.cn/t15/media/20201102092727LX.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	66,	19,	'2020-11-02 09:27:07',	0,	1,	1,	'策略 回合战略 历史 多人 单人 回合制 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256786004/movie480_vp9.webm?t=1590034863',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(140,	'激荡海渊 Stirring Abyss',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		<span style=\"font-size:16px;\">发行日期:</span> \r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		<span style=\"font-size:16px;\">2020年10月30日</span> \r\n	</div>\r\n<span style=\"color:#666666;font-size:18px;font-family:;\"><strong>游戏</strong></span><span style=\"font-size:18px;font-family:\" color:#666666;\"=\"\"><strong>STEAM详细介绍链接点击即可跳转</strong></span><a href=\"https://store.steampowered.com/app/1178210/Stirring_Abyss/\" target=\"_blank\">https://store.steampowered.com/app/1178210/Stirring_Abyss/</a><p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《激荡海渊 Stirring Abyss》是一款基于战术小队的独立游戏，同时拥有丰富的RPG元素。在游戏中你将体验到经典的洛式恐怖内容，并解开埋葬在远古深渊中的奥秘。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;font-size:14pt;\">最低配置:</span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"> 操作系统: Windows 8<br />\r\n处理器: 2 GHz Processor or Equivalent<br />\r\n内存: 2 GB RAM<br />\r\n显卡: OpenGL 4.5-compatible, 512 MB video memory<br />\r\nDirectX 版本: 9.0c<br />\r\n存储空间: 需要 1 GB 可用空间\r\n</p>',	33,	'https://fhdemo.s-cms.cn/t15/media/20201102092806ew.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	73,	7,	'2020-11-02 09:27:50',	0,	1,	1,	'洛夫克拉夫特式 角色扮演 心理恐怖 \r\n\r\n',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256807373/movie480_vp9.webm?t=1603987257',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(141,	'废土3 Wasteland 3',	0.00,	'<p>\r\n	<strong> </strong> \r\n</p>\r\n<div class=\"subtitle column\" style=\"margin:0px;padding:0px 10px 0px 0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	<strong>发行日期:</strong> \r\n</div>\r\n<div class=\"date\" style=\"margin:0px;padding:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	<strong>2020年8月28日</strong> \r\n</div>\r\n<strong><span style=\"color:#666666;font-family:KaiTi_GB2312;font-size:18px;\"></span><span style=\"color:#666666;font-family:KaiTi_GB2312;font-size:18px;\">游戏视频STEAM详细介绍点击<strong><span style=\"color:#666666;font-family:KaiTi_GB2312;font-size:18px;\">链接</span></strong>即可跳转</span><span style=\"color:#666666;font-family:KaiTi_GB2312;font-size:18px;\"></span><br />\r\n</strong> \r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<strong><span style=\"color:#666666;font-family:KaiTi_GB2312;font-size:18px;\"><a href=\"https://store.steampowered.com/app/719040/Wasteland_3/#app_reviews_hash\" target=\"_blank\">https://store.steampowered.com/app/719040/Wasteland_3/#app_reviews_hash</a><br />\r\n</span></strong> \r\n</p>\r\n<p>\r\n	<strong><br />\r\n</strong> \r\n</p>\r\n<p>\r\n	<strong>游戏介绍：</strong> \r\n</p>\r\n<p>\r\n	《废土3 Wasteland 3》是一款末日题材生存RPG，是《废土》系列的最新正统续作。《废土3》的游戏世界观设定在美国科罗拉多州荒芜冻土，这里是一片极寒的荒芜之地，玩家将要在这里面临困难的道德选择和牺牲。\r\n</p>\r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<strong>最低配置:</strong><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 10<br />\r\n处理器: Intel Core i5-3.3 GHz or better, or AMD Equivalent<br />\r\n内存: 8 GB RAM<br />\r\n显卡: Nvidia GTX 760 or AMD Equivalent<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 52 GB 可用空间\r\n</p>',	45,	'https://fhdemo.s-cms.cn/t15/media/202011020930340i.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	184,	14,	'2020-11-02 09:29:46',	0,	1,	1,	'角色扮演 策略 回合制战斗 末日 合作 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256798637/movie480_vp9.webm?t=1598573056',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	'2021-08-07 12:03:13'),
(142,	'地痞街区 Streets of Rogue',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\"> </span></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2019年7月13日\r\n	</div>\r\n<span style=\"font-size:14pt;font-weight:700;\">游戏视频STEAM详细介绍点击链接即可跳转</span> \r\n	<p>\r\n		<br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;font-weight:700;\"><a href=\"https://store.steampowered.com/app/512900/Streets_of_Rogue/\" target=\"_blank\">https://store.steampowered.com/app/512900/Streets_of_Rogue/</a><br />\r\n</span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;font-size:18px;\">游戏介绍</span><span style=\"font-size:14pt;font-weight:700;\">：</span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《地痞街区 Streets of Rogue》是一款Rogue-lite类游戏，这款游戏并非发生在地下城中，而是设定在一个程序生成的正常城市中，其中有复杂的 AI 来通知各行各业的居民，后者只是在按部就班地完成日常活动。\r\n</p>',	46,	'https://fhdemo.s-cms.cn/t15/media/20201102093334K8.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	104,	11,	'2020-11-02 09:31:58',	0,	1,	1,	' Rogue 角色扮演 动作类 Rogue 动作 \r\n',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256755948/movie480.webm?t=1562965494',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(143,	'时间使者破碎的时间线/',	0.00,	'<p style=\"font-size:15px;color:#555555;font-family:Lato, sans-serif;background-color:#FFFFFF;\">\r\n	<br />\r\n</p>\r\n<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	2020年8月13日\r\n</div>\r\n<h3>\r\n	游戏详情STEAM介绍点击链接即可跳转\r\n</h3>\r\n<h3>\r\n</h3>\r\n<h3>\r\n	<a href=\"https://store.steampowered.com/app/1171660/The_Ambassador_Fractured_Timelines/\" target=\"_blank\">https://store.steampowered.com/app/1171660/The_Ambassador_Fractured_Timelines/</a>\r\n</h3>\r\n<h3>\r\n	时间使者：破碎的时间线是一款双摇杆射击游戏，围绕着让时间停止这一能力而展开。你将扮演格雷戈尔，一名永世同仁会的新晋成员，同时也是一名时间使者。正当你学习如何使用新能力时，同仁会都城被神秘地摧毁了！作为仅有的几名成员之一，你必须找到幕后黑手，让塔玛丽斯重回往日的荣耀。\r\n</h3>\r\n<p>\r\n	<br />\r\n</p>',	46,	'https://fhdemo.s-cms.cn/t15/media/20201102093500od.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	58,	6,	'2020-11-02 09:34:15',	0,	1,	1,	'摇杆射击 奇幻 像素图形 动作 冒险 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256794529/movie480_vp9.webm?t=1597688669',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(144,	'风来之国',	0.00,	'<h3>\r\n	<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\"><span style=\"font-size:16px;\">游戏详情STEAM介绍点击链接即可跳转</span><span style=\"font-size:16px;\"></span></span>\r\n</h3>\r\n<p>\r\n	<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\"><span style=\"font-size:16px;\"><a href=\"https://store.steampowered.com/app/977880/_/\" target=\"_blank\">https://store.steampowered.com/app/977880/_/</a><br />\r\n</span></span>\r\n</p>\r\n<p>\r\n	<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\">登上火车，穿越神秘的大陆。在那里邂逅壮丽的风景，目睹倒错的世界文明。</span>\r\n</p>\r\n<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\">不被注意的角落，也许就藏着解开“末日”秘密的线索。</span><br />\r\n<img src=\"http://www.32r.com/uppic/200625/202006251430384782.jpg\" alt=\"\" /><br />\r\n<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\">2、奇妙的二人组</span><br />\r\n<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\">切换你的角色，是拥有神力的少女，或是强壮可靠的硬汉。</span><br />\r\n<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\">看似柔弱的珊，也可以成为一名出色的冒险家。</span><br />\r\n<img src=\"http://www.32r.com/uppic/200625/202006251430415066.jpg\" alt=\"\" /><br />\r\n<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\">3、智慧才是最好的伙伴</span><br />\r\n<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\">战斗好手约翰，能熟练地使用各种武器。</span><br />\r\n<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\">但是记住，有时候最好的选择，并不是“火”力最强的那一个。</span><br />\r\n<img src=\"http://www.32r.com/uppic/200625/202006251430446045.jpg\" alt=\"\" /><br />\r\n<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\">4、有趣的人物</span><br />\r\n<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\">古怪世界里古怪的人们。“末日”来临也要打游戏的邻家孩子、心慈手软的黑帮头目、猴子组成的电影剧组、拥有同一个名字的五金店老板们。</span><br />\r\n<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\">都在准备为你带来感动和欢乐。</span><br />\r\n<img src=\"http://www.32r.com/uppic/200625/202006251430467944.jpg\" alt=\"\" /><br />\r\n<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\">5、怀旧之声</span><br />\r\n<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\">来自Joel Corelitz (Hohokum, The Unfinished Swan, The Tomorrow Children, Gorogoa)的美妙音乐和Hyperduck Soundworks的音效。</span><br />\r\n<img src=\"http://www.32r.com/uppic/200625/202006251430519666.jpg\" alt=\"\" />',	46,	'https://fhdemo.s-cms.cn/t15/media/20201102093653al.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	105,	23,	'2020-11-02 09:35:47',	0,	1,	1,	'独立 冒险 角色扮演 像素图形 末日 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256735199/movie480.webm?t=1541933838',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(145,	'超级寄生虫/HyperParasite',	0.00,	'<p>\r\n	<p>\r\n		<p>\r\n			<p>\r\n				<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n					<span style=\"font-size:16px;\">发行日期:</span>\r\n				</div>\r\n				<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n					<span style=\"font-size:16px;\">2020年4月3日</span>\r\n				</div>\r\n<span style=\"font-size:16px;color:#666666;\"><strong>游戏详情STEAM介绍点击链接即可跳转</strong></span>\r\n			</p>\r\n			<p>\r\n				<span style=\"font-size:16px;color:#666666;\"><strong><a href=\"https://store.steampowered.com/app/838110/HyperParasite/\" target=\"_blank\">https://store.steampowered.com/app/838110/HyperParasite/</a><br />\r\n</strong></span>\r\n			</p>\r\n			<p>\r\n				你是来自外星的超寄生物，入侵了八十年代肮脏的反乌托邦，官方已向公众发出警告，告诫他们只要见到你，就一定不要手下留情。你拖着黏滑的触手，怒气冲冲地冲过城市的大街小巷。这是最繁华的时代，穷奢极欲是这个时代的底色，你必须突破重重障碍，杀上流行文化食物链的顶端，才能按下红色按钮，升起末日的蘑菇云。这个轻度类似Rogue的双摇杆清版动作游戏并不简单，你只有足够心狠手辣，才能在程序化生成的凶恶街道上活下去，才不会死在这个无药可救的混账未来。\r\n			</p>\r\n			<p>\r\n				<br />\r\n			</p>\r\n		</p>\r\n	</p>\r\n</p>',	26,	'https://fhdemo.s-cms.cn/t15/media/20201102093911Hq.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	45,	5,	'2020-11-02 09:37:54',	0,	1,	1,	'射击 迷宫探索 射击 永久死亡 困难 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256776953/movie480.webm?t=1584562580',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(146,	'柯尔特峡谷 Colt Canyon',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2020年6月16日\r\n	</div>\r\n游戏详情STEAM介绍点击链接即可跳转\r\n	<p>\r\n		<br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/940710/Colt_Canyon/\" target=\"_blank\">https://store.steampowered.com/app/940710/Colt_Canyon/</a><br />\r\n</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《柯尔特峡谷 Colt Canyon》是一款2D像素风射击类游戏，你将操控一名牛仔或者多款可解锁角色中的一员进行游戏，你的使命便是从残虐无道的暴徒手中拯救被绑架的伴侣。在这样一个满是隐藏宝藏、武器、障碍以及各色杀戮成性人渣的峡谷之中，拿起你的枪与TNT炸药，杀出一条血路吧。也许，除了你的伴侣之外，你还能拯救更多的人。但是，请务必小心。就算救出了自己的伴侣，你的任务也尚未完成。你还得安全归家……\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;font-size:14pt;\">最低配置:</span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"> DirectX 版本: 11<br />\r\n存储空间: 需要 300 MB 可用空间\r\n</p>',	46,	'https://fhdemo.s-cms.cn/t15/media/20201102094121iH.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	122,	7,	'2020-11-02 09:39:27',	0,	1,	1,	'动作 暴力 动作类 Rogue 独立 血腥 ',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(147,	'极渊/Inmost',	0.00,	'<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<br />\r\n</p>\r\n<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2020年8月21日\r\n	</div>\r\n游戏详情STEAM介绍点击链接即可跳转\r\n</h2>\r\n<p>\r\n	<a href=\"https://store.steampowered.com/app/938560/INMOST/\" target=\"_blank\">https://store.steampowered.com/app/938560/INMOST/</a> \r\n</p>\r\n<p>\r\n	<span style=\"color:#000000;\">介绍</span><span style=\"color:#000000;font-family:\" font-size:14px;background-color:#1b2838;\"=\"\">由立陶宛独立游戏工作室</span><strong><span style=\"color:#000000;\">Hidden Layer Games</span></strong><span style=\"color:#000000;font-family:\" font-size:14px;background-color:#1b2838;\"=\"\">开发的《Inmost》是一款充满感染力且极富氛围感的叙事型悬疑风平台游戏。玩家将和一个爱冒险的年轻女孩、一个坚毅克制的骑士以及一个追寻答案的男子一起，一步步揭开这个故事。</span> \r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial, Helvetica, sans-serif;font-size:10px;\">最低配置:</span> \r\n</p>\r\n<p>\r\n	<span style=\"color:#ACB2B8;font-family:\" font-size:14px;background-color:#1b2838;\"=\"\"> </span> \r\n</p>\r\n<ul style=\"color:#ACB2B8;font-family:\" background-color:#1b2838;\"=\"\">\r\n<ul class=\"bb_ul\">\r\n	<li>\r\n		<span style=\"color:#000000;\">需要 64 位处理器和操作系统</span><br />\r\n	</li>\r\n	<li>\r\n		<span style=\"font-family:Arial, Helvetica, sans-serif;color:#000000;\">操作系统:</span><span style=\"color:#000000;\"> Windows 7 or later</span><br />\r\n	</li>\r\n	<li>\r\n		<span style=\"font-family:Arial, Helvetica, sans-serif;color:#000000;\">处理器:</span><span style=\"color:#000000;\"> Intel i5</span><br />\r\n	</li>\r\n	<li>\r\n		<span style=\"font-family:Arial, Helvetica, sans-serif;color:#000000;\">内存:</span><span style=\"color:#000000;\"> 1 GB RAM</span><br />\r\n	</li>\r\n	<li>\r\n		<span style=\"font-family:Arial, Helvetica, sans-serif;color:#000000;\">显卡:</span><span style=\"color:#000000;\"> Nvidia 450 GTS</span><br />\r\n	</li>\r\n	<li>\r\n		<span style=\"font-family:Arial, Helvetica, sans-serif;color:#000000;\">DirectX 版本:</span><span style=\"color:#000000;\"> 9.0c</span><br />\r\n	</li>\r\n	<li>\r\n		<span style=\"font-family:Arial, Helvetica, sans-serif;color:#000000;\">存储空间:</span><span style=\"color:#000000;\"> 需要 2 GB 可用空间</span> \r\n	</li>\r\n</ul>\r\n	</ul>\r\n<span style=\"color:#000000;\"></span><br />\r\n	<p>\r\n		<br />\r\n	</p>\r\n	<p>\r\n		<br />\r\n	</p>\r\n	<p>\r\n		<br />\r\n	</p>\r\n	<p>\r\n		<br />\r\n	</p>\r\n	<p>\r\n		<br />\r\n	</p>',	46,	'https://fhdemo.s-cms.cn/t15/media/20201102094322Mp.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	102,	9,	'2020-11-02 09:42:09',	0,	1,	1,	'独立 冒险 像素图形 平台解谜 氛围 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256787900/movie480_vp9.webm?t=1591386882',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(148,	'通路/Pathway',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:18px;\"> </span> \r\n</p>\r\n<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	2019年4月11日\r\n</div>\r\n<span style=\"font-size:18px;\">游戏详情STEAM介绍点击链接即可跳转</span> \r\n<p>\r\n	<br />\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:18px;\"><a href=\"https://store.steampowered.com/app/546430/Pathway/\" target=\"_blank\">https://store.steampowered.com/app/546430/Pathway/</a><br />\r\n</span> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	【游戏介绍】\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	一款战略冒险游戏，Pathway游戏中具有回合制的战斗和独特的故事剧情。玩家可以探索金字塔，坟墓和沙漠荒野在一个自由的世界中展开各种探索冒险，游戏的自由度也是非常的开阔。\r\n</p>',	33,	'https://fhdemo.s-cms.cn/t15/media/202011020944453i.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	80,	7,	'2020-11-02 09:43:47',	0,	1,	1,	'角色扮演 独立 冒险 策略 像素图形 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256747272/movie480.webm?t=1554836697',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(149,	'超级像素赛车/Super Pixel Racers',	0.00,	'<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<br />\r\n</p>\r\n<h2 style=\"font-size:20px;\">\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2019年1月31日\r\n	</div>\r\n游戏详情STEAM介绍点击链接即可跳转\r\n</h2>\r\n<p>\r\n	https://store.steampowered.com/app/501020/Super_Pixel_Racers/\r\n</p>\r\n<p>\r\n	<span style=\"font-size:20px;\">关于这款游戏</span> \r\n</p>\r\n<p>\r\n	《超级像素赛车》是以复古点阵图风格为诉求的竞速游戏，采用俯视式的镜头与轻快节奏的 16 位元音乐。游戏收录各种赛道、天气效果和成就。玩家可以在单人游玩的「生涯模式」中驾驶可升级的赛车参与竞速。支援最多4名玩家同时可享受的分屏本地多人模式，还支援透过网络与全世界玩家一起竞速的在线多人模式。\r\n</p>\r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<br />\r\n</p>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse sys_req\">\r\n		<h2 style=\"font-size:20px;\">\r\n			<br />\r\n		</h2>\r\n	</div>\r\n</div>',	46,	'https://fhdemo.s-cms.cn/t15/media/20201102094617o3.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	87,	6,	'2020-11-02 09:45:18',	0,	1,	1,	'竞速 动作 独立 像素图形 赛车',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256740179/movie480.webm?t=1547775904',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(150,	'迷雾侦探 新版v1.0.86',	0.00,	'<h2 class=\"bb_tag\" style=\"color:#555555;font-size:20px;font-family:Lato, sans-serif;background-color:#FFFFFF;\">\r\n</h2>\r\n<h2 class=\"bb_tag\" style=\"color:#555555;font-size:20px;font-family:Lato, sans-serif;background-color:#FFFFFF;\">\r\n	游戏特色\r\n</h2>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<span style=\"font-weight:bolder;\">引人入胜的侦探故事</span><br />\r\n玩家将在游戏中通过勘查现场、分析物品、询问NPC等手段，解开一个又一个的谜题和案件，是成功剥离真实上的谎言，还是被汹涌的谜团吞噬？当真相被揭开的时，往往已深陷更大的阴谋中。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/828740/extras/0.png?t=1571024173\" style=\"height:auto;\" /><br />\r\n<span style=\"font-weight:bolder;\">复古像素画风和精美的音乐音效</span><br />\r\n复古的像素风格，配合精美的画面表现，将带给你难忘的视觉体验。搭配各种精心打磨的音乐，造就了一个迷幻和喧嚣的未来世界。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/828740/extras/1.png?t=1571024173\" style=\"height:auto;\" /><br />\r\n<span style=\"font-weight:bolder;\">丰富的成就与收集要素</span><br />\r\n大量搞怪的成就与档案的收集要素等待玩家的发掘，如果你是收集癖的话，千万不要错过！<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/828740/extras/2.png?t=1571024173\" style=\"height:auto;\" /><br />\r\n<span style=\"font-weight:bolder;\">多元化的解密元素</span><br />\r\n游戏中的谜题由简入难，穿插在游戏的场景与故事中。它们将考验玩家的推理能力、观察能力和逻辑能力。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/828740/extras/3.png?t=1571024173\" style=\"height:auto;\" /><br />\r\n<span style=\"font-weight:bolder;\">双主角？化身喵尔摩斯！</span><br />\r\n玩家在扮演主角侦探外，还将化身他的得力助手——小黑猫威廉，它将深入那些主角无法到达的地方，合力完成侦破。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/828740/extras/4.png?t=1571024173\" style=\"height:auto;\" /><br />\r\n<span style=\"font-weight:bolder;\">奇妙的世界观</span><br />\r\n如果机械人有信仰的话，他们眼中的神会是什么样子？倘若机器人与人类有完全一样的权利，他们是否还会背叛我们？假如血肉与机械没有了分界，什么才能被称为活着？<br />\r\n这一切的答案，尽在这个光怪陆离的赛博世界中。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/828740/extras/5.png?t=1571024173\" style=\"height:auto;\" /> \r\n</p>\r\n<h2 style=\"color:#555555;font-size:20px;font-family:Lato, sans-serif;background-color:#FFFFFF;\">\r\n</h2>\r\n<div class=\"sysreq_contents\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_area_sys_req sysreq_content active\">\r\n		<div class=\"game_area_sys_req_leftCol\">\r\n			<p>\r\n				<span style=\"font-weight:bolder;\">最低配置:</span> \r\n			</p>\r\n			<ul>\r\n				<li>\r\n					<ul class=\"bb_ul\">\r\n						<li>\r\n							<span style=\"font-weight:bolder;\">操作系统:</span> Windows 7\r\n						</li>\r\n						<li>\r\n							<span style=\"font-weight:bolder;\">处理器:</span> Intel Core2 Duo E6400 @ 2.13GHz\r\n						</li>\r\n						<li>\r\n							<span style=\"font-weight:bolder;\">内存:</span> 8 GB RAM\r\n						</li>\r\n						<li>\r\n							<span style=\"font-weight:bolder;\">显卡:</span> GeForce GT 730 OR Radeon HD 4830\r\n						</li>\r\n						<li>\r\n							<span style=\"font-weight:bolder;\">DirectX 版本:</span> 11\r\n						</li>\r\n						<li>\r\n							<span style=\"font-weight:bolder;\">存储空间:</span> 需要 2 GB 可用空间\r\n						</li>\r\n					</ul>\r\n				</li>\r\n			</ul>\r\n		</div>\r\n	</div>\r\n</div>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<br />\r\n</p>',	46,	'https://fhdemo.s-cms.cn/t15/media/20201102094735IV.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	134,	8,	'2020-11-02 09:46:57',	0,	1,	1,	'独立 赛博朋克 像素图形 冒险 解谜 猫',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256787304/movie480_vp9.webm?t=1590997753',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(151,	'女巫之眼 Witcheye',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2020年8月28日\r\n	</div>\r\n<span style=\"font-size:18px;\">游戏详情STEAM介绍点击链接即可跳转</span> \r\n	<p>\r\n		<br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/1284950/Witcheye/\" target=\"_blank\">https://store.steampowered.com/app/1284950/Witcheye/</a><br />\r\n</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《女巫之眼 Witcheye》是一款规模浩大、色彩绚丽又十分复古的平台冒险类游戏。它有着独特的触屏控制体系，让玩家对主角的掌控精准无比。一划即走、一点即停，玩家可在六个世界地图中闪转腾挪、踩踏敌人。游戏里，你将扮演一个性格温和的女巫，她在一个油嘴滑舌的巫师和骑士偷了她施法原料后，变身为一颗飞翔的复仇之眼。你将带领她冲破五十多个关卡，每个关卡都富含着：诡计多端的敌人、神秘莫测的环境以及令人困惑的新谜题。这些种种元素，辅以明亮的色彩、干净的像素画和生机盎然、声声入耳的原创音乐，带给你独特的体验。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7, 8, 8.1, 10 x64<br />\r\n处理器: Intel Core i3-2100 3.1GHz / AMD Athlon II X4 645 AM3 3100GHz<br />\r\n内存: 1 GB RAM<br />\r\n显卡: Intel HD 4400<br />\r\n存储空间: 需要 200 MB 可用空间\r\n</p>',	46,	'https://fhdemo.s-cms.cn/t15/media/20201102094901Oc.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	76,	6,	'2020-11-02 09:48:17',	0,	1,	1,	'冒险 休闲 动作冒险 2D 平台 街机 二维 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256798608/movie480_vp9.webm?t=1598469896',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(152,	'咬紧牙关 Bite the Bullet',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2020年8月14日\r\n	</div>\r\n<span style=\"font-size:18px;\"></span><span style=\"font-size:18px;\">游戏详情STEAM介绍点击链接即可跳转</span> \r\n	<p>\r\n		<br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/1075550/Bite_the_Bullet/\" target=\"_blank\">https://store.steampowered.com/app/1075550/Bite_the_Bullet/</a><br />\r\n</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《咬紧牙关 Bite the Bullet》是一款roguelite RPG射击游戏。在当今世界，每一个敌人是可以食用的，你吃什么，你吃了多少驱动器一切从你的腰围分支的技能树，以各具特色的武器（在你的肚子，当然）。拍摄快速。吃大了。满足您的胃口破坏。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;font-size:14pt;\">最低配置:</span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"> 操作系统: Windows 7 SP1+, 8, 10<br />\r\n处理器: Dual Core 2 Ghz CPU<br />\r\n内存: 4 GB RAM<br />\r\n显卡: Graphics card with DX10 capabilites<br />\r\nDirectX 版本: 10<br />\r\n存储空间: 需要 3 GB 可用空间\r\n</p>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102094944Bm.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	80,	6,	'2020-11-02 09:49:33',	0,	1,	1,	'动作 独立 角色扮演 像素图形 冒险',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256779370/movie480_vp9.webm?t=1597338036',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(153,	'僵尸王归来 Return Of The Zombie King',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">\r\n<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	2019年11月4日\r\n</div>\r\n游戏详情STEAM介绍点击链接即可跳转</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/1152020/Return_Of_The_Zombie_King/\" target=\"_blank\">https://store.steampowered.com/app/1152020/Return_Of_The_Zombie_King/</a><br />\r\n</span></span>\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《僵尸王归来 Return Of The Zombie King》是一款像素风横版动作游戏，游戏中你控制一名已经过世的国王，变成僵尸之后你对自己曾经的王国念念不忘，现在你准备把他抢回来。作为一款2D像素游戏，本作的操作很简单，一开始你只有一个老国王的脑袋，看不见听不见，也不能跳跃，随着游戏的进行，你要通过收集金币来赎回你的身体其他部分，这样你才能升级你的躯体，然后解锁魔法和其他有用的技能。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7 or Later<br />\r\n处理器: 2 GHz<br />\r\n内存: 1 GB RAM<br />\r\n显卡: 512 MB VRAM<br />\r\nDirectX 版本: 9.0c<br />\r\n存储空间: 需要 50 MB 可用空间\r\n</p>',	28,	'https://fhdemo.s-cms.cn/t15/media/202011020950357G.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	64,	6,	'2020-11-02 09:50:29',	0,	1,	1,	'奔跑 横向滚屏 平台游戏 僵尸 中世纪 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256766019/movie480.webm?t=1572548129',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(154,	'超时空打球 Ultra Space Battle Brawl',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span>\r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2018年10月5日\r\n	</div>\r\n游戏详情STEAM介绍点击链接即可跳转\r\n	<p>\r\n		<br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/658500/Ultra_Space_Battle_Brawl/\" target=\"_blank\">https://store.steampowered.com/app/658500/Ultra_Space_Battle_Brawl/</a><br />\r\n</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《超时空打球 Ultra Space Battle Brawl》是一款趣味性的竞技游戏，主旨是解决争端，一决雌雄，无论是与您的朋友、家人还是敌人和死对头。如果您没有朋友或敌人与您对战，可玩单人故事模式战役。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7 or newer<br />\r\n处理器: Intel Core™ Duo or faster<br />\r\n内存: 2 GB RAM<br />\r\n显卡: Shader Model 2.0 compatible<br />\r\n存储空间: 需要 800 MB 可用空间\r\n</p>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102095142A9.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	58,	7,	'2020-11-02 09:51:38',	0,	1,	1,	'体育 动作 独立 4 人本地 本地多人 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256722538/movie480.webm?t=1536727141',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(155,	'像素黑暗史 Chronicon',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"> </span></span>\r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		发行日期:\r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		2020年8月21日\r\n	</div>\r\n游戏详情STEAM介绍点击链接即可跳转\r\n	<p>\r\n		<br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/375480/Chronicon/\" target=\"_blank\">https://store.steampowered.com/app/375480/Chronicon/</a><br />\r\n</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《像素黑暗史 Chronicon》是一款在一个最后的邪恶势力都已经倒下、最后一个任务已经被圆满完成、最后一个宝箱也已经被搜刮一空的世界里，会发生什么呢？在这个世界里，旧日英雄们的伟大成就被一个伟大的魔法装置所永远铭记。这个装置的名字就叫做Chronicon。它能够开启一道属于旧日英雄们的记忆之门。每一年，都会有少数男女获取重现这些伟大旅程的荣耀。<br />\r\n而今年，这个幸运儿就是你…\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;font-size:14pt;\">最低配置:</span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"> 操作系统: Windows 7 / 8 / 10<br />\r\n处理器: Dual Core, 2.4 GHz<br />\r\n内存: 4 GB RAM<br />\r\n显卡: DirectX 11 and Shader Model 3.0 Compatible Dedicated Video Card, 512 MB VRAM<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 500 MB 可用空间\r\n</p>',	46,	'https://fhdemo.s-cms.cn/t15/media/20201102095327ZZ.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	48,	6,	'2020-11-02 09:53:22',	0,	1,	1,	'动作 寻宝  角色扮演 冒险',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256796056/movie480_vp9.webm?t=1597140493',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(156,	'加拿大死亡之路 Death Road To Canada',	0.00,	'<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>\r\n<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	2016年7月22日\r\n</div>\r\n游戏详情STEAM介绍点击链接即可跳转</strong></span>\r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong><a href=\"https://store.steampowered.com/app/252610/Death_Road_to_Canada/\" target=\"_blank\">https://store.steampowered.com/app/252610/Death_Road_to_Canada/</a><br />\r\n</strong></span>\r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏介绍：</strong></span> \r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">《加拿大死亡之路 Death Road To Canada》是一款生存冒险类的游戏，和其他生存游戏不一样的就是本作是小狗最终拿起了武器和僵尸进行战斗。游戏的思路还是比较清晰有创意的，对冒险游戏感兴趣的玩家可以下载游戏试试看。\r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><a class=\"highslide-image\" href=\"https://s1.jiligame.com/images/2020/09/30/1b42aa2e3e9dc876f49e9f2de0b779ff.jpg\"><br />\r\n</a> \r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>最低配置:</strong></span><br />\r\n操作系统: Windows 7, XP, Vista, 8, and newer<br />\r\n处理器: 1.3 ghz<br />\r\n内存: 128 MB RAM<br />\r\n显卡: Minimum Supported Texture Size 2048×2048<br />\r\n存储空间: 需要 60 MB 可用空间\r\n</p>',	85,	'https://fhdemo.s-cms.cn/t15/media/202011020954305p.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	81,	10,	'2020-11-02 09:53:52',	0,	1,	1,	'动作类 Rogue 像素 僵尸 动作 独立',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256701428/movie480.webm?t=1510954504',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(157,	'赃物与巫术 Swag and Sorcery',	0.00,	'<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>\r\n<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	发行日期:\r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	2019年5月10日\r\n</div>\r\n游戏详情STEAM介绍点击链接即可跳转</strong></span>\r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong><a href=\"https://store.steampowered.com/app/929010/Swag_and_Sorcery/\" target=\"_blank\">https://store.steampowered.com/app/929010/Swag_and_Sorcery/</a><br />\r\n</strong></span>\r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏介绍：</strong></span> \r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">《赃物和巫术 Swag and Sorcery》是一款角色扮演类(RPG)游戏，由《拳击俱乐部》和《守墓人》团队创作！建造你自己的幻想村庄，训练 和装备你的英雄，然后派他们去收集赃物！开始史诗级任务，夺回国王的失踪…套装。他 真的很喜欢。想要拿回来。让所有英雄奋不顾身地 执行这次重要的任务！\r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><strong>最低配置:</strong>\r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"> 操作系统: Windows 7<br />\r\n处理器: i5 and up<br />\r\n内存: 4 GB RAM<br />\r\n图形: Dedicated video card is required<br />\r\n存储空间: 需要 700 MB 可用空间\r\n</p>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201102095603Fe.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	58,	7,	'2020-11-02 09:55:17',	0,	1,	1,	'像素图形 角色扮演 单人 独立 冒险 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256749020/movie480.webm?t=1556230735',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(158,	'《深渊矿坑》',	0.00,	'<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	<span style=\"font-size:16px;\">发行日期:</span>\r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	<span style=\"font-size:16px;\">2018年7月31日</span>\r\n</div>\r\n<p>\r\n	<span style=\"font-size:16px;\"></span><span style=\"font-size:16px;\">游戏详情STEAM介绍点击链接即可跳转</span><span style=\"font-size:16px;\"></span>\r\n</p>\r\n<p>\r\n	<span style=\"font-size:16px;\"><a href=\"https://store.steampowered.com/app/312200/Chasm/\" target=\"_blank\">https://store.steampowered.com/app/312200/Chasm/</a><br />\r\n</span>\r\n</p>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102095735h0.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	79,	7,	'2020-11-02 09:57:28',	0,	1,	1,	'类银河战士恶魔城 独立 像素图形 冒险 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256763681/movie480.webm?t=1570079636',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(159,	'奇幻东征中文版',	0.00,	'<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	<span style=\"font-size:16px;\">发行日期:</span> \r\n</div>\r\n<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n	<span style=\"font-size:16px;\">2020年9月14日</span> \r\n</div>\r\n<p>\r\n	<span style=\"font-size:18px;\"></span><span style=\"font-size:18px;\">游戏详情STEAM介绍点击链接即可跳转</span><span style=\"font-size:18px;\"></span> \r\n</p>\r\n<p>\r\n	<a href=\"https://store.steampowered.com/app/780670/_/\" target=\"_blank\">https://store.steampowered.com/app/780670/_/</a> \r\n</p>\r\n<p>\r\n	<span style=\"color:#ACB2B8;font-family:\" font-size:14px;background-color:#1b2838;\"=\"\">《奇幻东征》是一款Roguelike的冒险动作游戏，玩家扮演受天神诏示而踏上征途的领导者。</span><br />\r\n<span style=\"color:#ACB2B8;font-family:\" font-size:14px;background-color:#1b2838;\"=\"\">在随机的地图与路线上做出抉择、招兵买马、搜集宝物、通过各种战斗和奇遇来完成使命！</span> \r\n</p>\r\n<p>\r\n	<br />\r\n</p>',	46,	'https://fhdemo.s-cms.cn/t15/media/202011020959353w.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	68,	7,	'2020-11-02 09:59:17',	0,	1,	1,	'角色扮演 独立 动作 策略 休闲 冒险 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256800460/movie480_vp9.webm?t=1599741289',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(160,	'《攻城英雄/英雄攻城 Hero Siege》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《英雄攻城 Hero Siege》是一款带有roguelike和RPG元素的Hack’n’Slash游戏。消灭成群的敌人，成长你的天赋树，研磨更好的战利品，并探索多达7种使用美丽的像素艺术图形增强的行为！这个游戏提供无数个小时的游戏玩法和最多4个玩家在线多人游戏！\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span>\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">– 最多4名玩家的在线多人游戏！<br />\r\n– 随机生成的关卡，物品，地下城，老板，秘密和事件。你玩的每个游戏都是不同的！<br />\r\n– 超过170种独特的制作物品，无论是被动的，可用的还是轨道的。<br />\r\n– 超过80个不同的敌人可以产生稀有或精英，具有额外的马力/伤害和能力，但是掉落更好的战利品并提供更多的exp！<br />\r\n– 超过30项成就解锁！<br />\r\n– 使用60多种不同的帽子定制您的角色！<br />\r\n– 4种行为通过！扩展套装带来额外的行为！<br />\r\n– 随机地牢和地穴来探索和清除战利品和敌人！<br />\r\n– 8个可玩的课程！额外的课程配有扩展套装！<br />\r\n– 6个不同的难度级别解锁！<br />\r\n– 吨随机！开始发现所有美妙的秘密和内容！<br />\r\n– 战斗系统：正常，优越，稀有，传奇，神话和撒旦战利品！\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7/8/10<br />\r\n处理器: DualCore 1.8 GHZ<br />\r\n内存: 4 GB RAM<br />\r\n显卡: 512 mb<br />\r\n存储空间: 需要 900 MB 可用空间\r\n</p>',	46,	'https://fhdemo.s-cms.cn/t15/media/20201102100112B0.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	5,	1,	'2020-11-02 10:00:20',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256756764/movie480.webm?t=1563594706',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(161,	'高卢战争：战斗模拟器-正式版-(官中)',	0.00,	'<p style=\"color:#333333;font-family:-apple-system-font, BlinkMacSystemFont, \" font-size:17px;background-color:#ffffff;\"=\"\"> <span style=\"color:#FF0000;\"><strong> </strong></span> \r\n	</p>\r\n	<div class=\"subtitle column\" style=\"padding:0px 10px 0px 0px;margin:0px;color:#556772;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		<strong>发行日期:</strong> \r\n	</div>\r\n	<div class=\"date\" style=\"padding:0px;margin:0px;color:#8F98A0;font-family:Arial, Helvetica, sans-serif;background-color:#1B2838;\">\r\n		<strong>2020年10月31日</strong> \r\n	</div>\r\n<strong><span style=\"font-size:18px;\">游戏详情STEAM介绍点击链接即可跳转</span></strong> \r\n	<p>\r\n		<br />\r\n	</p>\r\n<p style=\"color:#333333;font-family:-apple-system-font, BlinkMacSystemFont, \" font-size:17px;background-color:#ffffff;\"=\"\"> <span style=\"color:#FF0000;\"><strong><a href=\"https://store.steampowered.com/app/1067760/Gallic_Wars_Battle_Simulator/\" target=\"_blank\">https://store.steampowered.com/app/1067760/Gallic_Wars_Battle_Simulator/</a><br />\r\n</strong></span> \r\n</p>\r\n<p style=\"color:#333333;font-family:-apple-system-font, BlinkMacSystemFont, \" font-size:17px;background-color:#ffffff;\"=\"\"> <span style=\"color:#FF0000;\"><strong>游戏介绍</strong></span> \r\n	</p>\r\n<p style=\"color:#333333;font-family:-apple-system-font, BlinkMacSystemFont, \" font-size:17px;background-color:#ffffff;\"=\"\">\r\n	来征服罗马吧！在这个每次地图都会随机生成的游戏里，领导高卢战士，摧毁罗马帝国。\r\n</p>\r\n<p style=\"color:#333333;font-family:-apple-system-font, BlinkMacSystemFont, \" font-size:17px;background-color:#ffffff;\"=\"\"><br />\r\n	</p>\r\n<p style=\"color:#333333;font-family:-apple-system-font, BlinkMacSystemFont, \" font-size:17px;background-color:#ffffff;\"=\"\">\r\n	中文名: 高卢战争：战斗模拟器<br />\r\n名称: Gallic Wars: Battle Simulator<br />\r\n类型: 动作, 休闲, 独立, 模拟, 策略<br />\r\n开发商: MadGamesmith<br />\r\n发行商: Gaming Factory S.A.<br />\r\n系列: Gaming Factory S.A.<br />\r\n发行日期: 2020年10月31日\r\n</p>\r\n<p style=\"color:#333333;font-family:-apple-system-font, BlinkMacSystemFont, \" font-size:17px;background-color:#ffffff;\"=\"\"> <span style=\"color:#FF0000;\"><strong>配置要求</strong></span> \r\n	</p>\r\n<p style=\"color:#333333;font-family:-apple-system-font, BlinkMacSystemFont, \" font-size:17px;background-color:#ffffff;\"=\"\">\r\n	最低配置:<br />\r\n操作系统: Windows XP, Windows Vista, Windows 7, Windows 8, Windows 8.1, Windows 10<br />\r\n处理器: 3.1 Ghz<br />\r\n内存: 8 GB RAM<br />\r\n显卡: GTX 660<br />\r\n存储空间: 需要 1 GB 可用空间\r\n</p>',	31,	'https://fhdemo.s-cms.cn/t15/media/20201102102033U4.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	91,	8,	'2020-11-02 10:02:09',	0,	1,	1,	'动作, 休闲, 独立, 模拟, 策略',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256791944/movie480_vp9.webm?t=1594104817',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(162,	'全面战争三国 v1.5.3全DLC',	0.00,	'<p style=\"color:#454545;font-family:\" font-size:13px;background-color:#ffffff;\"=\"\">\r\n	在A World Betrayed中，我们描绘了一个对三国时代的历史走向有着重要影响的时间点。许多Total War: THREE KINGDOMS原版战役中的知名诸侯都已辞世，但随之而来的乱世中又诞生了新一代的主公，他们将书写一段属于自己的传奇。\r\n	</p>\r\n<div style=\"border:none;color:#454545;font-family:\" font-size:13px;background-color:#ffffff;\"=\"\">\r\n	<div style=\"border:none;\">\r\n		<div style=\"border:none;\">\r\n			<p>\r\n				<a href=\"https://store.steampowered.com/app/1209110/Total_War_THREE_KINGDOMS__A_World_Betrayed/\" target=\"_blank\"><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1209110/header.jpg?t=1586441297\" alt=\"\" style=\"height:auto;\" /></a> \r\n			</p>\r\n		</div>\r\n		<div style=\"border:none;\">\r\n			<h2 style=\"color:#313131;font-size:15px;\">\r\n				TOTAL WAR ACADEMY\r\n			</h2>\r\n			<p>\r\n				<a href=\"https://steamcommunity.com/linkfilter/?url=https://academy.totalwar.com/three-kingdoms/?utm_source=steam&utm_medium=banner&utm_campaign=academy\" target=\"_blank\"><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/779340/extras/Three_Kingdoms-TW_Academy.jpg?t=1602263355\" /></a> \r\n			</p>\r\n		</div>\r\n	</div>\r\n		</div>\r\n<div style=\"border:none;color:#454545;font-family:\" font-size:13px;background-color:#ffffff;\"=\"\">\r\n		<div style=\"border:none;\">\r\n			<div style=\"border:none;\">\r\n				<h2 style=\"color:#313131;font-size:15px;\">\r\n					关于这款游戏\r\n				</h2>\r\n《Total War: THREE KINGDOMS》首次在这一获奖无数的策略类游戏系列中重塑中国古代的烽火传奇。在扣人心弦的回合制战役中，可以建设国家，治国理政；在令人叹为观止的即时战斗中，则可以征战沙场，破军杀敌。《Total War: THREE KINGDOMS》将二者巧妙结合，重新定义了那段英雄辈出的传奇历史。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/779340/extras/01.jpg?t=1602263355\" /><br />\r\n公元190年的中国<br />\r\n欢迎来到传奇征战的新时代。<br />\r\n江山如画，奈何诸侯裂土称王，此时需有新人君临天下，变更世道。你需要一统天下，再立新朝，建万古之基业。<br />\r\n从十二位传奇诸侯中做出选择，进而征服天下。征募英雄人物助你完成大业，通过军事、科技、政治和经济手段迫使敌人就范。<br />\r\n你究竟是会建立牢不可破的兄弟之盟并获取敌人的尊敬？还是会两面三刀，行阴谋诡计，成一代奸雄？<br />\r\n传奇等你来书写，但毫无疑问，壮美山河等你征服。\r\n				<h2 style=\"color:#313131;font-size:15px;\">\r\n					再塑天下\r\n				</h2>\r\n<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/779340/extras/02.jpg?t=1602263355\" /><br />\r\n三国时代，江山如画。从南国丛林，到茫茫大漠，再到皑皑雪山，皆可演兵于此。而诸如长城长江等地标奇观更是令人叹为观止。此刻天下兵荒马乱，在平复天下之际，大可访古探今，探索天下。\r\n				<h2 style=\"color:#313131;font-size:15px;\">\r\n					天下传奇\r\n				</h2>\r\n<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/779340/extras/03.jpg?t=1602263355\" /><br />\r\n从传奇巨著《三国演义》中选择十二位诸侯之一君临天下。无论是无双将帅，强力猛士，还是治国奇才，都有自己独特的玩法和目标。你可以选取强大的英雄阵容指挥军队，管理州郡，治国理政，强化自己的统治。人物是本作的核心，天下尽在英雄手中掌握。\r\n				<h2 style=\"color:#313131;font-size:15px;\">\r\n					关系机制\r\n				</h2>\r\n<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/779340/extras/04.jpg?t=1602263355\" /><br />\r\n关系是中国的一种动态联系观念，有基于此，《Total War: THREE KINGDOMS》改编塑造了一批形象的传奇英雄及其关系，他们可以决定天下大势。每个人物都有其独特的性格、动机与好恶。他们相互之间也各有喜恶关系，这决定了你的剧本的走向。\r\n				<h2 style=\"color:#313131;font-size:15px;\">\r\n					艺术精粹\r\n				</h2>\r\n<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/779340/extras/05.jpg?t=1602263355\" /><br />\r\n本作视觉效果绝佳，武术打斗激烈，可谓战争的艺术。再加上用户界面美观，场景令人震撼，还有真实的中国风艺术，本作重塑的古代中国可谓一场视觉盛宴。\r\n				<h2 style=\"color:#313131;font-size:15px;\">\r\n					缓急相济\r\n				</h2>\r\n<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/779340/extras/06.jpg?t=1602263355\" /><br />\r\n《Total War: THREE KINGDOMS》的回合制战役与即时战斗比之前结合得更为流畅。战斗中的表现会产生更大的影响，会影响英雄与你之间的关系，也会影响他们与其他角色之间的敌友关系。如今强援也是制胜关键所在，这也提供了一种全新的取胜元素。\r\n			</div>\r\n		</div>\r\n	</div>\r\n<div style=\"border:none;color:#454545;font-family:\" font-size:13px;background-color:#ffffff;\"=\"\">\r\n	<div style=\"border:none;\">\r\n		<div style=\"border:none;\">\r\n			<h2 style=\"color:#313131;font-size:15px;\">\r\n				系统需求\r\n			</h2>\r\n		</div>\r\n	</div>\r\n		</div>\r\n<div style=\"border:none;color:#454545;font-family:\" font-size:13px;background-color:#ffffff;\"=\"\">\r\n		<div style=\"border:none;\">\r\n			<div style=\"border:none;\">\r\n				<div style=\"border:none;\">\r\n					Windows\r\n				</div>\r\n				<div style=\"border:none;\">\r\n					Mac OS X\r\n				</div>\r\n				<div style=\"border:none;\">\r\n					SteamOS + Linux\r\n				</div>\r\n				<div style=\"border:none;\">\r\n				</div>\r\n			</div>\r\n			<div style=\"border:none;\">\r\n				<div style=\"border:none;\">\r\n					<div style=\"border:none;\">\r\n						<ul>\r\n							最低配置:<br />\r\n							<ul>\r\n								<li>\r\n									需要 64 位处理器和操作系统<br />\r\n								</li>\r\n								<li>\r\n									操作系统:&nbsp;Windows 7 64 Bit<br />\r\n								</li>\r\n								<li>\r\n									处理器:&nbsp;Intel Core 2 Duo 3.00Ghz<br />\r\n								</li>\r\n								<li>\r\n									内存:&nbsp;4 GB RAM<br />\r\n								</li>\r\n								<li>\r\n									显卡:&nbsp;GTX 650 Ti 1GB|HD 7850 1GB|Intel UHD Graphics 620<br />\r\n								</li>\r\n								<li>\r\n									DirectX 版本:&nbsp;11<br />\r\n								</li>\r\n								<li>\r\n									存储空间:&nbsp;需要 60 GB 可用空间<br />\r\n								</li>\r\n								<li>\r\n									附注事项:&nbsp;6GB Memory if using integrated GPU\r\n								</li>\r\n							</ul>\r\n						</ul>\r\n					</div>\r\n					<div style=\"border:none;\">\r\n						<ul>\r\n							推荐配置:<br />\r\n							<ul>\r\n								<li>\r\n									需要 64 位处理器和操作系统<br />\r\n								</li>\r\n								<li>\r\n									操作系统:&nbsp;Windows 10 64 Bit<br />\r\n								</li>\r\n								<li>\r\n									处理器:&nbsp;Intel i5-6600 | Ryzen 5 2600X<br />\r\n								</li>\r\n								<li>\r\n									内存:&nbsp;8 GB RAM<br />\r\n								</li>\r\n								<li>\r\n									显卡:&nbsp;GTX 970 | R9 Fury X 4GB VRAM<br />\r\n								</li>\r\n								<li>\r\n									DirectX 版本:&nbsp;11<br />\r\n								</li>\r\n								<li>\r\n									存储空间:&nbsp;需要 60 GB 可用空间\r\n								</li>\r\n							</ul>\r\n						</ul>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n<div style=\"border:none;color:#454545;font-family:\" font-size:13px;background-color:#ffffff;\"=\"\"> <br />\r\n		</div>\r\n<p style=\"color:#454545;font-family:\" font-size:13px;background-color:#ffffff;\"=\"\"> <b>声明：</b><br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。 <br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。 <br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！ <br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。 <br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n			</p>',	31,	'https://fhdemo.s-cms.cn/t15/media/20201102102136o6.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	559,	122,	'2020-11-02 10:21:22',	0,	1,	1,	'策略 历史 战争 回合战略 大战略 军事 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256751449/movie480.webm?t=1558620935',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(163,	'8位军队 8-Bit Armies',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;font-weight:700;\">游戏详情STEAM介绍点击链接即可跳转</span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/427250/8Bit_Armies/\" target=\"_blank\">https://store.steampowered.com/app/427250/8Bit_Armies/</a><br />\r\n</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《8位军队 8-Bit Armies》是一款复古式即时战略游戏。这款由 Petroglyph 倾情打造的游戏采用了色彩欢快的像素风，是现今市场上节奏最快和友善的即时战略游戏。该游戏提供 25 个单人任务、12 个合作任务、多人模式和遭遇战模式。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;font-weight:700;\">最低配置:</span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"> 操作系统: Windows Vista SP2<br />\r\n处理器: 2.6 GHz Dual Core Processor<br />\r\n内存: 4 GB RAM<br />\r\n显卡: Nvidia Geforce GTS 250 or ATI Radeon HD 3870<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 2 GB 可用空间\r\n</p>',	31,	'https://fhdemo.s-cms.cn/t15/media/2020110210234407.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	80,	6,	'2020-11-02 10:22:50',	0,	1,	1,	'策略 模拟 独立 即时战略 像素图形 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256661544/movie480.webm?t=1457655028',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(164,	'帝国时代3决定版 Age of Empires III: Definitive Edition',	1.00,	'<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏详情STEAM介绍点击链接即可跳转</span></span> \r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/933110/Age_of_Empires_III_Definitive_Edition/\" target=\"_blank\">https://store.steampowered.com/app/933110/Age_of_Empires_III_Definitive_Edition/</a><br />\r\n</span></span> \r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">《帝国时代3：决定版 Age of Empires III: Definitive Edition》是一款即时战略游戏，以最完美的形式、增强的功能和充满现代感的玩法，让这款受到广大玩家喜爱的即时战略系列游戏更臻完善。\r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><br />\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 10 version 18362.0 or higher<br />\r\n处理器: Intel i3-2105 @ 3.1GHz or AMD Phenom II X4 973 with an average CPU Passmark score of 3735 or better<br />\r\n内存: 8 GB RAM<br />\r\n显卡: GeForce GT 430, Radeon HD 5570, or Intel HD 4400 with an average Passmark G3D Mark of 570 or better<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 42 GB 可用空间\r\n</p>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102103402nN.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	377,	53,	'2020-11-02 10:24:39',	0,	1,	1,	'策略 即时战略 军事 历史 多人 三维 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256798809/movie480_vp9.webm?t=1598557667',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(165,	'全面战争传奇特洛伊 中文版百度云下载',	1.00,	'<p style=\"color:#454545;font-family:\" font-size:13px;background-color:#ffffff;\"=\"\">\r\n	名称: Total War Saga: TROY<br />\r\n类型: 动作, 模拟, 策略<br />\r\n开发商: CREATIVE ASSEMBLY<br />\r\n发行商: SEGA<br />\r\n系列: Total War<br />\r\n发行日期: Coming 2021<br />\r\n最低配置<br />\r\n操作系统: Windows 7/8.1/10（64 位）<br />\r\n处理器: Intel Core 2 Duo 3.0 GHz/Intel i7 8550U 1.80GHz<br />\r\n内存: 4 GB（若为独立显卡）/ 6 GB（若为集成显卡）<br />\r\n存储空间: 26 GB<br />\r\nDirect X: 版本 11<br />\r\n显卡: Nvidia GTX 460 1 GB/AMD Radeon HD 5770 1 GB/Intel UHD Graphics 620\r\n	</p>\r\n<p style=\"color:#454545;font-family:\" font-size:13px;background-color:#ffffff;\"=\"\">\r\n	在这传说中的时代，英雄层出不穷。然而，只需要一个冲动之举，便会点起燃遍世界的战火。特洛伊的王子，鲁莽的帕里斯，从斯巴达的宫殿里抢走了美丽的海伦。当他们起帆远航，海伦的丈夫墨涅拉俄斯王诅咒着她的名字。他会将不忠的妻子带回故乡——无论付出什么代价！<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1099410/extras/MacLinux_Banner.jpg?t=1591115637\" alt=\"\" style=\"height:auto;\" /><br />\r\n疆域广泛的阿伽门农王，城墙巍峨的迈锡尼之主，听到了他兄弟的呼唤。他从四海召集亚该亚人的英雄，其中包括捷足的阿喀琉斯与银舌的奥德修斯。希腊人向着特洛伊进发，走向无可避免的战争与屠杀。在这座伟大城市前的战场上，将诞生一段传奇……\r\n</p>',	31,	'https://fhdemo.s-cms.cn/t15/media/20201102103657yO.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	112,	8,	'2020-11-02 10:36:00',	0,	1,	1,	'动作, 模拟, 策略 即时',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(166,	'要塞军阀之战 中文版',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏详情STEAM介绍点击链接即可跳转</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/907650/Stronghold_Warlords/\" target=\"_blank\">https://store.steampowered.com/app/907650/Stronghold_Warlords/</a><br />\r\n</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《要塞：军阀之战 Stronghold: Warlords》是一款经典即时战略系列新作。游戏将来到远东地区，你可以通过游戏内“军阀”的形式招募、升级并在战场上直接指挥AI。指挥蒙古游牧部落、帝国战士和武士部族，围攻日本城堡和加强中国城市防御。利用新的火炮型攻城武器、经典部队和全新游戏方式围攻历史军阀。自带中文字幕和中文配音。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;font-size:14pt;\">游戏特色：</span> \r\n	</p>\r\n<ul font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">\r\n	<li>\r\n		在战场上征服并指挥军阀，解锁更多强大城堡、军队和技能。\r\n	</li>\r\n	<li>\r\n		招募新的部队，包括帝国火枪手、训练有素的武士、蒙古弓箭手和辅助云梯手。\r\n	</li>\r\n	<li>\r\n		从公元前3世纪的中国，到幕府时代的崛起和蒙古帝国的到来，重现历史战役。\r\n	</li>\r\n	<li>\r\n		借助火药以及火枪、攻城塔和火牛等新的攻城武器消灭你的敌人！\r\n	</li>\r\n	<li>\r\n		通过一系列中世纪娱乐、征税和酷刑让人们对你敬畏交加，从而成为最伟大的领主。\r\n	</li>\r\n		</ul>',	31,	'https://fhdemo.s-cms.cn/t15/media/20201102103853GE.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	20,	4,	'2020-11-02 10:38:23',	0,	1,	1,	'策略 模拟 建设 即时战略 城市营造 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256797436/movie480_vp9.webm?t=1597841831',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(167,	'8位部落 8-Bit Hordes',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏详情STEAM介绍点击链接即可跳转</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/497850/8Bit_Hordes/\" target=\"_blank\">https://store.steampowered.com/app/497850/8Bit_Hordes/</a><br />\r\n</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《8位部落 8-Bit Hordes》是Petroglyph制作发行的一款即时战略游戏，是游戏前作《8位军队（8-Bit Armies）》升级改进的过后的一款全新的游戏。熟悉的画风带给玩家的是不一样的战斗方式，你可以选择兽人以及人类军团进行战斗，通过收集资源建立自己的基地攻占所有的势力，并且值得一提的是，游戏本身设置多种模式供玩家选择，支持多人以及pvp模式，喜欢这款复古风战略游戏的玩家千万不能错过。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows Vista SP2<br />\r\n处理器: 2.6 GHz Dual Core Processor<br />\r\n内存: 4 GB RAM<br />\r\n显卡: Nvidia Geforce GTS 250 or ATI Radeon HD 3870<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 2 GB 可用空间\r\n</p>',	31,	'https://fhdemo.s-cms.cn/t15/media/202011021041399b.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	59,	6,	'2020-11-02 10:41:00',	0,	1,	1,	'策略 独立 即时战略 模拟 像素图形 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256668274/movie480.webm?t=1478812285',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(168,	'魔君致命错误 Necronator: Dead Wrong',	0.00,	'<p 0.95);\"=\"\" 255,=\"\" noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏详情STEAM介绍点击链接即可跳转</strong></span> \r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong><a href=\"https://store.steampowered.com/app/1144970/Necronator_Dead_Wrong/\" target=\"_blank\">https://store.steampowered.com/app/1144970/Necronator_Dead_Wrong/</a><br />\r\n</strong></span> \r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏介绍：</strong></span> \r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">《魔君：致命错误 Necronator: Dead Wrong》是一款喜剧微策略即时战略游戏，同时还揉合了卡牌玩法的特点。快来收集并部署亡灵单位，建立一支军队来征服那些令人厌恶的、自利弗莫尔联盟的伪君子们。召唤亡灵，放手大干吧。\r\n</p>\r\n<span 0.95);\"=\"\" 255,=\"\" noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:14pt;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><strong>最低配置:</strong></span><br />\r\n<span 0.95);\"=\"\" 255,=\"\" noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">操作系统: Windows 7 or later</span><br />\r\n<span 0.95);\"=\"\" 255,=\"\" noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">处理器: 2.4 GHz or faster processor</span><br />\r\n<span 0.95);\"=\"\" 255,=\"\" noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">内存: 1 GB RAM</span><br />\r\n<span 0.95);\"=\"\" 255,=\"\" noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">显卡: 512 MB VRAM, support Pixel Shader version 2.x or above</span><br />\r\n<span 0.95);\"=\"\" 255,=\"\" noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">DirectX 版本: 10</span><br />\r\n<p>\r\n	<span 0.95);\"=\"\" 255,=\"\" noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">存储空间: 需要 1 GB 可用空间</span> \r\n</p>',	31,	'https://fhdemo.s-cms.cn/t15/media/202011021043084A.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	147,	8,	'2020-11-02 10:42:34',	0,	1,	1,	'即时战术  轻度 Rogue 卡牌战斗 塔防 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256774037/movie480.webm?t=1580756004',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(169,	'《全面战争阿提拉 Total War: ATTILA》全DLC',	0.00,	'<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><strong><span style=\"font-size:14pt;\">游戏详情STEAM介绍点击链接即可跳转</span></strong> \r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><strong><span style=\"font-size:14pt;\"><a href=\"https://store.steampowered.com/app/325610/Total_War_ATTILA/#app_reviews_hash\" target=\"_blank\">https://store.steampowered.com/app/325610/Total_War_ATTILA/#app_reviews_hash</a><br />\r\n</span></strong> \r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><strong><span style=\"font-size:14pt;\">游戏介绍：</span></strong> \r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">《全面战争：阿提拉 Total War: ATTILA》是一款策略战棋SLG游戏，在饥荒，疾病和战争的黑暗背景下，东部大草原上出现了新的力量。在他的背后有一百万骑士，最终的战士之王接近，他的目标定在罗马…… 屡获殊荣的PC系列的下一部分结合了回合制战略与实时战术，全面战争：ATTILA演员表球员回到公元395年。在黑暗时代的黎明时代的世界末日动荡时期。 你会在多远的生存？你会从世界上扫除压迫，并开辟出自己的野蛮或东方王国吗？或者，在最终的生存战略挑战中，你会支持即将到来的风暴作为罗马帝国的最后残余吗？ 上帝的灾祸即将来临。你的世界将燃烧。\r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><strong><span style=\"font-size:14pt;\">最低配置:</span></strong><br />\r\n操作系统: Windows Vista*<br />\r\n处理器: Intel Core 2 Duo 3 GHz<br />\r\n内存: 3 GB RAM<br />\r\n图形: 512 MB NVIDIA GeForce 8800 GT, AMD Radeon HD 2900 XT or Intel HD 4000<br />\r\nDirectX 版本: 10<br />\r\n存储空间: 需要 35 GB 可用空间\r\n</p>',	31,	'https://fhdemo.s-cms.cn/t15/media/20201102104436Fj.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	76,	12,	'2020-11-02 10:43:59',	0,	1,	1,	'策略 历史 战争 回合战略 大战略 战术',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/2037310/movie480.webm?t=1447369526',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(170,	'祖先遗产 Ancestors Legacy',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏详情STEAM介绍点击链接即可跳转</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\"><a href=\"https://store.steampowered.com/app/620590/Ancestors_Legacy/\" target=\"_blank\">https://store.steampowered.com/app/620590/Ancestors_Legacy/</a><br />\r\n</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《祖先遗产 Ancestors Legacy》是一款基于小队作战、极具战术性的即时战略游戏。本游戏灵感源自欧洲中世纪历史，再现了四个不同的民族及其之间的冲突，而解决冲突的方式往往是战争。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows&reg; 7 (Service Pack 1) , Windows 8.1 and Windows 10 – (64-bit only).<br />\r\n处理器: 2.6 GHz Intel&reg; Core™ i5-750 or 3.2 GHz AMD Phenom™ II X4 955<br />\r\n内存: 4 GB RAM<br />\r\n显卡: NVIDIA GeForce GTX 460 or AMD Radeon HD5850 (1 GB VRAM)<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 24 GB 可用空间\r\n</p>',	31,	'https://fhdemo.s-cms.cn/t15/media/20201102104525f3.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	120,	9,	'2020-11-02 10:45:19',	0,	1,	1,	'策略 中世纪 即时战略 历史 即时 战术 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256736841/movie480.webm?t=1543410477',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(171,	'哥特舰队：阿玛达2 Battlefleet Gothic: Armada 2',	0.00,	'<p style=\"text-align: justify; color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\"><span style=\"font-size:14pt;\"><strong>游戏详情STEAM介绍点击链接即可跳转</strong></span> \r\n	</p>\r\n<p style=\"text-align: justify; color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\"><span style=\"font-size:14pt;\"><strong><a href=\"https://store.steampowered.com/app/573100/Battlefleet_Gothic_Armada_2/\" target=\"_blank\">https://store.steampowered.com/app/573100/Battlefleet_Gothic_Armada_2/</a><br />\r\n</strong></span> \r\n</p>\r\n<p style=\"text-align: justify; color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\"><span style=\"font-size:14pt;\"><strong>游戏介绍：</strong></span> \r\n	</p>\r\n<p style=\"text-align: justify; color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\">《哥特舰队：阿玛达2 Battlefleet Gothic: Armada 2》是一款即时战略类(RTS)游戏。战斗规模更大，游戏制作更精良，且改良了多人游戏模式，在线游戏体验更好、更平衡。游戏经过整体改良，添加了更多舰队和飞船的自定义选项，定会让您享受到终极《战锤：40,000》太空战斗体验。\r\n</p>\r\n<p style=\"text-align: justify; color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\"><strong><span style=\"font-size:14pt;\">最低配置:</span></strong> \r\n	</p>\r\n<p style=\"text-align: justify; color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\"> 需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7/8/10 (64 bits)<br />\r\n处理器: Intel Core i5-3450 (3.1 GHz)/AMD FX-6300 (3.5 GHz)<br />\r\n内存: 8 GB RAM<br />\r\n图形: 2 GB, GeForce GTX 660/Radeon HD 7870<br />\r\n存储空间: 需要 50 GB 可用空间<br />\r\n附注事项: INTERNET CONNECTION REQUIRED FOR THE ONLINE GAME\r\n</p>',	33,	'https://fhdemo.s-cms.cn/t15/media/20201102104629NE.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	96,	14,	'2020-11-02 10:46:09',	0,	1,	1,	'战锤40K 策略 太空 即时战术 即时战略 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256740220/movie480.webm?t=1547206973',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(172,	'帝国全面战争',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	版本介绍：V1.5.0版|集成1332.21992升级档|集成简体中文汉化|支持键盘.鼠标|赠官方原声32首BGM|赠多项修改器|赠初始存档|赠游戏攻略|赠油画集|2019年01月27号更新\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	《帝国：全面战争》故事背景设定在18世纪，一个伴随着全球战争，革命热潮和先进科技的狂暴时期。正如工业革命这个主题，美国为了独立而斗争，为了控制东部贸易路线和应对全球海陆大战，《帝国：全面战争》是PC的RTS游戏史上最充实和流畅的游戏。\r\n</p>',	31,	'https://fhdemo.s-cms.cn/t15/media/20201102104742Fs.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	74,	23,	'2020-11-02 10:47:03',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(173,	'北境之地 Northgard',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《北境之地 Northgard》是一款即时战略类游戏，勇猛的‘北方人’已经开始探索和征服这些新的海岸，为的就是让他们的部落声名鹊起，通过征服、交易或对诸神的供奉名留青史。为此，他们必须在狼群肆虐和亡灵军队出没的土地上保住性命；要么与巨人结交好友，要么将其打败；并在北方有史以来最严酷的冬天里生存下来。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	在新发现的Northgard大陆建造你的殖民地。\r\n</li>\r\n<li>\r\n	把你的维京人分配到不同的工作岗位(农民、战士、水手、学者等……)\r\n</li>\r\n<li>\r\n	谨慎管理你的资源，抵御严酷的冬季环境并和恶毒的敌人对抗以求得生机。\r\n</li>\r\n<li>\r\n	开拓新领域，发现其独特的战略机遇。\r\n</li>\r\n<li>\r\n	在各个领域取得胜利(征服、名望、知识、交易等……)\r\n</li>\r\n<li>\r\n	与你的好友对战，或与有不同难度等级和人格的人工智能对抗\r\n</li>\r\n	</ul>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows Vista or better<br />\r\n处理器: Intel 2.0ghz Core 2 Duo or equivalent<br />\r\n内存: 1 GB RAM<br />\r\n显卡: Nvidia 450 GTS / Radeon HD 5750 or better<br />\r\nDirectX 版本: 10<br />\r\n存储空间: 需要 1 GB 可用空间\r\n		</p>',	31,	'https://fhdemo.s-cms.cn/t15/media/20201102105024N1.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	42,	14,	'2020-11-02 10:49:59',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256668473/movie480.webm?t=1507541937',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(174,	'帝国时代2：决定版/终极版/20周年纪念版 38G游戏',	1.00,	'<div class=\"game_page_autocollapse_ctn\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse\">\r\n		<div id=\"game_area_description\" class=\"game_area_description\">\r\n			<h2 style=\"font-size:20px;\">\r\n				关于这款游戏\r\n			</h2>\r\n			<p>\r\n				有史以来最受欢迎的战略游戏之一迎来 20 周年，为此我们推出了《帝国时代 II：决定版》。本作拥有惊人的 4K 超高清画质，全面重置的新原声音乐，以及内含 3 个新战役和 4 个新文明的全新内容：《最后的可汗》。\r\n			</p>\r\n			<p>\r\n				横跨人类 1000 年的历史，超过 200 个小时的游戏时长，以前所未有的方式探索全部的原版战役以及热销扩展包的内容。在线挑战主宰 35 个不同文明的其他玩家，伴随着时代的更迭，踏上支配世界的征程。\r\n			</p>\r\n			<p>\r\n				在这款有史以来最受喜爱的战略游戏决定性重制版中，选择您成就非凡的道路。\r\n			</p>\r\n		</div>\r\n		<div>\r\n			<p>\r\n				【游戏截图】\r\n			</p>\r\n			<p>\r\n				<img src=\"http://images.ali213.net/picfile/pic/2019/06/11/2019061193142570.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" />\r\n			</p>\r\n			<p>\r\n				<img src=\"http://images.ali213.net/picfile/pic/2019/06/11/2019061193145982.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" />\r\n			</p>\r\n			<p>\r\n				<img src=\"http://images.ali213.net/picfile/pic/2019/06/11/2019061193148292.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" />\r\n			</p>\r\n			<p>\r\n				<img src=\"http://images.ali213.net/picfile/pic/2019/06/11/2019061193152638.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" />\r\n			</p>\r\n			<p>\r\n				<img src=\"http://images.ali213.net/picfile/pic/2019/06/11/2019061193156365.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" />\r\n			</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse sys_req\">\r\n		<h2 style=\"font-size:20px;\">\r\n			系统需求\r\n		</h2>\r\n		<div class=\"sysreq_contents\">\r\n			<div class=\"game_area_sys_req sysreq_content active\">\r\n				<div class=\"game_area_sys_req_leftCol\">\r\n					<p>\r\n						<span style=\"font-weight:bolder;\">最低配置:</span>\r\n					</p>\r\n					<ul>\r\n						<li>\r\n							<ul class=\"bb_ul\">\r\n								<li>\r\n									需要 64 位处理器和操作系统\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">操作系统:</span>&nbsp;Windows 10 64bit\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">处理器:</span>&nbsp;Intel Core 2 Duo or AMD Athlon 64×2 5600+\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">内存:</span>&nbsp;4 GB RAM\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">显卡:</span>&nbsp;NVIDIA&reg; GeForce&reg; GT 420 or ATI™ Radeon™ HD 6850 or Intel&reg; HD Graphics 3000 or better with 2 GB VRAM\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">DirectX 版本:</span>&nbsp;11\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">网络:</span>&nbsp;宽带互联网连接\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">存储空间:</span>&nbsp;需要 30 GB 可用空间\r\n								</li>\r\n							</ul>\r\n						</li>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	31,	'https://fhdemo.s-cms.cn/t15/media/20201102105127wQ.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	190,	28,	'2020-11-02 10:50:46',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(175,	'钢铁收割/Iron Harvest豪华版',	0.00,	'<h2 style=\"color:#313131;font-size:15px;\">\r\n	<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\">游戏介绍：</span>\r\n		</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"color: rgb(102, 102, 102);\">《钢铁收割 Iron Harvest》是一款以二战后的世界为背景的RTS游戏。游戏采用了虚构的架空历史，在二战的战后世界里，神秘的军事集团正准备将战火重新复燃，最终夺取世界的控制权。而你要阻止这一切的发生，将这个邪恶的计划彻底粉碎。\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"color: rgb(102, 102, 102);\"><br />\r\n		</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\">最低配置:</span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 10 x64<br />\r\n处理器: Intel(R) Core(TM) i5-4460 or AMD equivalent<br />\r\n内存: 8 GB RAM<br />\r\n显卡: GeForce GTX 960 or AMD equivalent, 4 GB VRAM<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 30 GB 可用空间\r\n	</p>\r\n关于这款游戏\r\n</h2>\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/826630/extras/IronHarvest-LogoHeader_V4.gif?t=1598981056\" /><br />\r\n<span style=\"color:#454545;font-size:12.6316px;\">I</span>',	31,	'https://fhdemo.s-cms.cn/t15/media/20201102105243qJ.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	71,	9,	'2020-11-02 10:52:13',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256799296/movie480_vp9.webm?t=1598940358',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(176,	'环形帝国：竞争者 Circle Empires Rivals',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《环形帝国：竞争者 Circle Empires Rivals》是一款即时战略多人游戏，为全球逾30万玩家所乐享！快节奏的战斗、数百个各具风格的单位，再加上程序生成的圆圈世界，每一次游玩都刺激又独特。无论是单打独斗，还是和朋友联机游玩，都必须制定崭新策略和聪明战术，如此才能击败敌人、收获资源并增强自身实力！\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span>\r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	快节奏多人即时战略游戏\r\n</li>\r\n<li>\r\n	可与朋友一起畅玩各种联机游戏模式，包括合作模式\r\n</li>\r\n<li>\r\n	单位可获得经验值并升级\r\n</li>\r\n<li>\r\n	这个世界是由圆圈组成，每个圆圈都有不同的战利品和敌人。\r\n</li>\r\n<li>\r\n	一圈一圈地扩展你的帝国\r\n</li>\r\n<li>\r\n	程序生成的世界包含独特的动植物群\r\n</li>\r\n<li>\r\n	250+种不同的生物和建筑、可收获的资源和升级物品\r\n</li>\r\n<li>\r\n	25+不同派别的领导人，各种各样的加成\r\n</li>\r\n<li>\r\n	40个可狩猎的头目怪物\r\n</li>\r\n<li>\r\n	丰富难度选项，适合任何技能水平\r\n</li>\r\n	</ul>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Microsoft Windows 7 SP1, Windows 8, Windows 10<br />\r\n处理器: 3GHz dual core or 2GHz quad core<br />\r\n内存: 8 GB RAM<br />\r\n显卡: Intel/AMD Integrated Graphics, 1GB VRAM<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 3 GB 可用空间\r\n		</p>\r\n		<p style=\"font-size:12.6316px;\">\r\n			游戏名称：环形帝国对决<br />\r\n英文名称：Circle Empires Rivals<br />\r\n游戏类型：策略战棋SLG<br />\r\n游戏制作：Luminous<br />\r\n游戏发行：Iceberg Interactive<br />\r\n游戏平台：PC<br />\r\n游戏语言：中文,英文,日文,其他<br />\r\n发售日期：2020-04-15\r\n		</p>\r\n		<p style=\"font-size:12.6316px;\">\r\n			<br />\r\n		</p>',	31,	'https://fhdemo.s-cms.cn/t15/media/20201102105435DP.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	76,	6,	'2020-11-02 10:53:55',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256779798/movie480.webm?t=1585831501',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(177,	'钢铁之师2/Steel Division 2',	0.00,	'<p style=\"font-size:12.6316px;\">\r\n	游戏介绍】\r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	本作的背景设定在了巴格拉季昂行动中，此次行动是第二次世界大战时苏联于1944年对白俄罗斯发动大规模攻势的代号。游戏将包含上百种作战单位，25张新地图，以及全新的回合制单人即时战略玩法。\r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	【游戏截图】\r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	<img width=\"800\" height=\"450\" alt=\"\" src=\"http://images.ali213.net/picfile/pic/2019/04/05/2019040513435197.jpg\" /> \r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	<img width=\"800\" height=\"450\" alt=\"\" src=\"http://images.ali213.net/picfile/pic/2019/04/05/201904051343718.jpg\" /> \r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	<img width=\"800\" height=\"450\" alt=\"\" src=\"http://images.ali213.net/picfile/pic/2019/04/05/2019040513439520.jpg\" /> \r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	<img width=\"800\" height=\"450\" alt=\"\" src=\"http://images.ali213.net/picfile/pic/2019/04/05/2019040513442660.jpg\" /> \r\n</p>',	33,	'https://fhdemo.s-cms.cn/t15/media/20201102105721uJ.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	35,	11,	'2020-11-02 10:55:17',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256753972/movie480.webm?t=1561043997',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(178,	'幕府将军2：全面战争(Shogun 2: Total War)',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	《幕府将军2：全面战争》是由The Creative Assembly开发，SEGA发行的一款即时战略游戏，于2011年3月15日发行。该游戏为《全面战争》系列的第六代，也是继其第一代作品《幕府将军1：全面战争》之后第二次将游戏的主题设在日本。\r\n</p>\r\n<h3 style=\"color:#555555;font-size:18px;font-family:Lato, sans-serif;background-color:#FFFFFF;\">\r\n	游戏背景\r\n</h3>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	《幕府将军2》的游戏时代设定在十六世纪的日本战国时代，这个时候的日本被众多大名把持着，各大名之间为了争夺土地和日本的统治权，互相讨伐不断，这给游戏提供了充分的素材，游戏中。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	玩家的任务就是扮演一名战国时代的大名，培植亲信，建立军队，通过外交、经济、暗杀等手段，逐步达到目的——作为胜利条件，玩家的目的有四个：消灭玩家的敌对家族；让玩家家族存活七十年；占领日本四十个藩国；统一日本。游戏提供了九方势力可选，每一方都有自己的根据地及军/政强项。其中几家孤悬海外偏安一隅，自给自足但难以干预时政；另一些则整天大小阵仗不断，要靠手下的武士拼死维持局面。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	这是一个时局变幻莫测的时代，由荷兰及葡萄牙输入的火枪此时尚未登岛，能主宰战场的只有武士们的血肉之躯。游戏专注于战场细节，同屏作战单位通常不超过40个（每方20个左右），每一个单位都有自己明确的目的和用途且提供升级选项。角色级别由甲胄颜色及背后所插旗帜区分，较以往更易分辨。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	除亚洲特有的人物崇拜之外，到处筑墙的习惯也对游戏战役产生了实质性影响。每一座城池都有五层防御体系，甚至筑垒地域也因临海或依山从而拥有某些防御加成。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	全战系列中经典的海战场面也将出现在《幕府将军2》中，只不过双方的船都由桨驱动，无需担心风向的影响。海战的主要模式就是双方成堆的弓箭手互射，然后互抛抓勾使双方靠帮从而爆发决定性的接舷战。与以往全战作品所不同的是，首次实现了多人模式下的组队对抗；最多可支持八人游戏，每一方都可使用特定的人物形象，且获得的经验值可为自己所扮演的角色升级。\r\n</p>\r\n<h3 style=\"color:#555555;font-size:18px;font-family:Lato, sans-serif;background-color:#FFFFFF;\">\r\n	游戏系统\r\n</h3>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<span style=\"font-weight:bolder;\">联机系统</span>\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	游戏中玩家可以加入一个网上对战，派遣部队在队友身后安营扎寨。游戏增加了一个更棒的要素，当玩家的队友没有疲于战斗的时候，玩家能把玩家的部队分配给队友来掌管，邀请他操控玩家委任给他的部队和玩家一同战斗。简单明了。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	在多人游戏的开始，玩家的将军以及他的军队将会出现在地图65个领地中属于他的那一块。当玩家扩张侵入新的领地时，主机会自动寻找和玩家差不多等级的别的玩家，然后打响战斗。战斗结束，成王败寇决定这篇领地的归属权。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	几个特定的领地掌握了一些能加强玩家军队实力的科技。玩家必须在家族中扮演自己的角色，在大地图上玩家占有的领地会给玩家的家族分数加分。而且，家族的领袖能够在特定的领地上做标记，来分派家族成员的动向。每个家族成员都能在自己的大地图上看到这个标志。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	在大地图上玩家不会看到别的玩家的军队，不过通过这些标志，玩家便能能够了解哪些领地丢了，而又得了哪些，据点占据与否，加分以及最终掌控权。选择权都在玩家自己手里。大名能少量的增加玩家部队的能力。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<span style=\"font-weight:bolder;\">成就系统</span>\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	成就系统不是简单的“我已经取得了20常胜利，哇哈哈”这种简单的设定。这些成就是靠完成独特的胜利条件，或者在战争中遵守了一些特别的规定来取得的。完成这些成就的乐趣来自于作为回报得到的新战场技巧以及独特科技，它们能增强玩家的战斗力，同时还会抬升玩家的在线等级。同时，部队外观上改进也是游戏的基础乐趣之一。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	成就系统不再是网络对战的特权，在《幕府将军2》中，单人战役也能解锁这些成就，将会方便很多玩家。玩家必须为了自己的家族，为了给大名留下深刻印象提升自己的地位，抗下一场又一场的硬仗。\r\n</p>',	31,	'https://fhdemo.s-cms.cn/t15/media/202011021059067L.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	137,	13,	'2020-11-02 10:57:51',	0,	1,	1,	'',	1,	'',	'https://player.youku.com/embed/XNDUzODY0NTEzMg==',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(179,	'全面战争战锤2 中文版百度云迅雷下载v1.9.2|容量57GB|集成当前版本全DLCs',	1.00,	'<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏介绍：</strong></span> \r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">《全面战争：战锤2 Total War: WARHAMMER II》是一款策略战棋游戏，巨大的世界地图，真正各具特色的派系，相对保持了自由度的系统，血腥壮观的战场，《全面战争：战锤2》会在新世界给大家带来一次令人吃惊的探索、扩张、和征服旅程。（支持繁简中文）\r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏特色：</strong></span> \r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">卫护自己，殄灭仇敌<br />\r\nTotal War: WARHAMMER II是一款规模宏大的战略游戏。在此，玩家将会使用四个各具特色的独特种族来踏足战争之路，从而拯救或是毁灭这个广阔而多彩的奇幻世界。<br />\r\n这款游戏主要分为两个部分：其一是在开放世界中进行的回合制策略模拟游戏，其二则是在新世界的奇幻战场上进行的即时战术游戏。<br />\r\n随心所欲地游玩：深入探索引人入胜的战役，亲身体验久玩不腻的游戏世界，用你最喜欢的部队组建军队挑战多人游戏的世界！Total War: WARHAMMER II会让您经历数百个小时的游戏体验，每一次的体验也都将别具一格。<br />\r\n经天纬地的征服之路<br />\r\n施政理民，合纵连横，探索未知，每个回合的点滴积累，逐步建设你的帝国！你要夺占、建设与管理大量的城镇，招募大量的军队，提升传奇领主与英雄们的等级，并为他们装备精良的武器与护甲。至于那些胆敢挡在你的目标前方的家伙，就请要么以外交解决，要么发动一场全面战争吧！<br />\r\n史诗般的即时战斗<br />\r\n在战术战场上，玩家可以指挥由上千名强大战士组成的军团。率领凶残而扭曲的怪物，喷吐火焰的巨龙，操控强大的魔法！制定策略，安排伏击，或者使用残暴的军队来扭转战斗的局势，引领你的军队走向胜利！<br />\r\n作为三部曲中的第二部，备受赞誉的Total War: WARHAMMER的续作，Total War: WARHAMMER II将会为玩家们带来一款扣人心弦的战役故事，让玩家们领略露丝契亚、奥苏安、纳迦罗斯与南地大陆的风光。在大漩涡战役中，玩家们会逐步地领略这一战役中惊心动魄的高潮部分，而这是此前任何一款Total War游戏都不曾带来的游戏体验。<br />\r\n在Warhammer的奇幻战斗中，玩家们将在来自四个种族的八名传奇领主中选择一位，致力于成功举办一系列的神秘仪式来稳定或扰乱大漩涡，并同时挫败其它种族的仪式进程。<br />\r\n每位传奇领主的初始地理位置都是不同的，而每个种族都拥有着独特的战斗机器、游戏故事、战斗方式、军队、怪兽、魔法派系、传奇人物以及千差万别的战斗技能。<br />\r\n而在发售后不久，同时拥有游戏本体和Total War™ WARHAMMER II的玩家将可以解锁第三部独特的战役：探索同时包含拥有旧世界与新世界的史诗级开放世界，在此，玩家们将可以使用两部作品中所包含的所有可用种族！<br />\r\n携手征服世界！<br />\r\n在Total War™ WARHAMMER II中，每个可用种族都可以同时在单人游戏和多人游戏中，以及自定义与多人战斗中进行游玩。鉴于游戏中每个种族的两位传奇领主的初始位置各不相同，所以两位玩家甚至可以在双人合作游戏中同时游玩同个种族。如果玩家同时拥有了1代与2代游戏，那么玩家将可以在多人战役中随意游玩已拥有的任何种族。<br />\r\nTotal War: WARHAMMER II的世界<br />\r\n数个千年以前，当混沌的入侵兵临城下之际，高等精灵的法师会议决定创建一座巨大的魔法漩涡，从而如同排水管道一般抽干世上的魔法之风，进而将恶魔们赶回混沌魔域。如今，这座大漩涡正在颤抖，世界再次走上了毁灭的边缘。<br />\r\n强大的国度正致力于修复大漩涡，从而避免这场灾难。然而，有些人却在收集着它可怕的能量并谋划着自己的阴谋。竞赛已经打响，而胜者将就此掌控整个世界的命运。<br />\r\n泰瑞昂王子，奥苏安的守卫者，率领着高等精灵们竭尽全力稳定大漩涡，因为它所搅动的正是精灵故乡的天空。<br />\r\n史兰魔祭司马兹达穆迪端坐于乘舆之上，他正率领着麾下的蜥蜴人战群离开故乡露丝契亚并向北开进。他的目标也是阻止这场天地浩劫，但他要遵循的却是古圣们所制定的『大计划』。<br />\r\n巫王马雷基斯统帅着施虐成性的黑暗精灵，还有迷宫般的黑方舟们杀出了位于纳迦罗斯的巢穴。他已敏锐地感觉到了大漩涡的衰落——这是他重夺凤凰王位的绝好时机！<br />\r\n此外，奎克·猎头者率领的斯卡文鼠人们也正在恶臭的隧道中蠢蠢欲动。他们在地下疯狂繁殖，饥渴地仰望着地面的局势。他们的动机无人知晓，但确凿无疑的是，天启已是近在眼前…<br />\r\n四个种族，心思各异，然而有一点却是相同：无论是为善举抑或恶行，都必须夺下大漩涡！\r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>最低配置:</strong></span><br />\r\n操作系统: Windows 7 64Bit<br />\r\n处理器: Intel&reg; Core™ 2 Duo 3.0Ghz<br />\r\n内存: 5 GB RAM<br />\r\n显卡: NVIDIA GTX 460 1GB | AMD Radeon HD 5770 1GB | Intel HD4000 @720p<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 60 GB 可用空间\r\n</p>',	31,	'https://fhdemo.s-cms.cn/t15/media/20201102110320Be.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	325,	38,	'2020-11-02 11:01:01',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256696684/movie480.webm?t=1506534394',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(180,	'《火星Z：战术基地防御 MarZ: Tactical Base Defense》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《火星Z：战术基地防御 MarZ: Tactical Base Defense》是一款即时战略游戏。建立您的防御基地来击退火星的僵尸群，保证这颗红色星球的安全。您必须精心管理您的队员和资源，同时尝试揭开僵尸的可怕秘密。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">最低配置:</span></span><br />\r\n操作系统: 64-bit Windows 7/8/10<br />\r\n处理器: Intel Core i5<br />\r\n内存: 4 GB RAM<br />\r\n图形: DirectX 10 compliant graphics card with 6GB dedicated memory<br />\r\nDirectX 版本: 10<br />\r\n存储空间: 需要 6 GB 可用空间\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	31,	'https://fhdemo.s-cms.cn/t15/media/20201102110637Ux.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	31,	9,	'2020-11-02 11:04:44',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256746944/movie480.webm?t=1554393232',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(181,	'《大将军罗马 Imperator: Rome》',	0.00,	'<div font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; border: none; color: rgb(69, 69, 69);\">\r\n<div style=\"border:none;\">\r\n	<div style=\"border:none;\">\r\n		<h2 style=\"color:#313131;font-size:15px;\">\r\n			关于这款游戏\r\n		</h2>\r\n亚历山大、汉尼拔、凯撒。这片大陆的命运就掌握在这些伟人及诸多类似之人的手中。伟大的国王、聪明的将军及半神之人皆在古地中海沿岸打出名号。在沿海区域中，关系紧密的诸多国家通过激烈的征战测试自己的意志与品德。其文化与政治遗产和我们所理解的现代西方文化，具有密不可分的关系。然而，没有什么事情是绝对的。您是否能够在 Imperator: Rome 中改变历史的轨迹？现已包括《Punic Wars Content Pack》<br />\r\nImperator: Rome 是由 Paradox Development Studio 推出的最新大战略游戏。Imperator: Rome 的时代背景为介于继承亚历山大的东方诸王朝至罗马帝国建立之间的混乱世纪，游戏邀请您一同回味在古典时代建立帝国的盛况与挑战。管理您的人民、注意是否有人暗中策划谋反，并信奉您的神明。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/859580/extras/title_character_management_SCH.gif?t=1597162854\" /><br />\r\n在这个活生生的世界中，每个角色皆拥有独特的技能与个性，并会随时间改变。他们会带领您的国家、统治您的领土，并指挥您的军队与舰队。我们也推出了全新、更加逼真的角色设计。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/859580/extras/title_diverse_populations_SCH.gif?t=1597162854\" /><br />\r\n市民、自由民、部族及奴隶，每个族群都拥有自己的文化和宗教信仰。无论他们是否能补充您的军队、金库或殖民地，千万要注意他们的满意度，这将能决定您的成功与否。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/859580/extras/title_battle_tactics_SCH.gif?t=1597162854\" /><br />\r\n在战斗开始前，选择您的战术来对抗敌人的计谋。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/859580/extras/title_military_traditions_SCH.gif?t=1597162854\" /><br />\r\n每个文化都有自己发动战争的独特方式。罗马人与凯尔特人会有不同的选项可供选择。解锁特殊加成、能力及单位。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/859580/extras/title_different_government_types_SCH.gif?t=1597162854\" /><br />\r\n管理共和国中的参议院、通过君主制掌控宫廷、在部落社会中向氏族效忠。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/859580/extras/title_barbarian_rebellions_SCH.gif?t=1597162854\" /><br />\r\n迁移的野蛮人可能会洗劫或定居在您的领土上，而不忠的诸侯或将军则可能会选择背叛您，并带着他们的军队离开！<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/859580/extras/title_trade_SCH.gif?t=1597162854\" /><br />\r\n商品可为其产地提供奖励。您会为了提升当地实力而储备商品，还是选择交易多出来的商品以提升各地经济？<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/859580/extras/title_provincinal_improvement_SCH.gif?t=1597162854\" /><br />\r\n投资建筑物、道路及防御措施，让您的王国更加强盛且繁荣。\r\n	</div>\r\n</div>\r\n	</div>\r\n<div font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; border: none; color: rgb(69, 69, 69);\">\r\n	<div style=\"border:none;\">\r\n		<h2 style=\"color:#313131;font-size:15px;\">\r\n			系统需求\r\n		</h2>\r\n		<div style=\"border:none;\">\r\n			<div style=\"border:none;\">\r\n				Windows\r\n			</div>\r\n			<div style=\"border:none;\">\r\n				Mac OS X\r\n			</div>\r\n			<div style=\"border:none;\">\r\n				SteamOS + Linux\r\n			</div>\r\n			<div style=\"border:none;\">\r\n			</div>\r\n		</div>\r\n		<div style=\"border:none;\">\r\n			<div style=\"border:none;\">\r\n				<div style=\"border:none;\">\r\n					<ul>\r\n						最低配置:<br />\r\n						<ul>\r\n							<li>\r\n								需要 64 位处理器和操作系统<br />\r\n							</li>\r\n							<li>\r\n								操作系统:&nbsp;Windows&reg; 7 Home Premium 64 bit SP1<br />\r\n							</li>\r\n							<li>\r\n								处理器:&nbsp;Intel&reg; iCore™ i3-550 or AMD&reg; Phenom II X6 1055T<br />\r\n							</li>\r\n							<li>\r\n								内存:&nbsp;4 GB RAM<br />\r\n							</li>\r\n							<li>\r\n								显卡:&nbsp;Nvidia&reg; GeForce™ GTX 460 or AMD&reg; Radeon™ HD 6970\r\n							</li>\r\n						</ul>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	33,	'https://fhdemo.s-cms.cn/t15/media/20201102110720nV.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	36,	9,	'2020-11-02 11:06:57',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(182,	'《广播将军 Radio General》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《广播将军 Radio General》是一款即时战略游戏。这是第二次世界大战。 你是本次战斗中的将军，你现在坐在帐篷里。你手上可用的只有地图和广播。你会赢吗？广播将军是一个独特的游戏，在这个游戏里面，你可以和你的队伍通过语音进行互动。作为二战的将军，这个游戏会测试你的战斗能力和魄力。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">清清嗓子，发出最洪亮的命令。本游戏通过将语音识别与完整的语音演练相结合，你会感到身临其境的感觉，仿佛就是将军在战场上用军号指挥你的士兵。<br />\r\n除了战场以外，弹药，士气，伪装，远见和耐力都完全模拟第二次世界大战。海拔和地势都会影响战争的成败。小部队相比与大部队更容易在森林的埋伏站中获胜。在陆战中，简易的伪装让快速前行的陆军更容易获胜。尽管山上的视野会更好，但是队伍会更容易遭到袭击。认真研究地图，做好认真部署。<br />\r\n慎重选择调拨的部队，因为各个部队都有自己的优势和短处。研究各个队伍的习惯和性格，例如，争强好胜的军官可能会拒绝服从彻退的命令。 退伍军人的部队会有更多的战斗经验。 每个队伍都有各自的特长。<br />\r\n在战争中，一定要给与各个部队适当的休息，只有充分休息才能让部队的作战能力迅速恢复。精疲力竭的队伍是没办法打赢战斗的，所以在战斗中一定要做出合理的军事任务安排。<br />\r\n让我们从鲜为人知的加拿大第一军队开始入手。玩家会参与从灾难性的迪耶普突袭，从而打败希特勒和意大利的哥特，接着诺曼底海岸登陆，穿越法莱兹峡谷。<br />\r\n让我们一起再看看100多张二战时期的老照片，材料和记录。学习战士们是如何在战争中生活，获得战争经历的更好体验。<br />\r\n本游戏通过重新编辑地图来重现这场有名的战役。在steam 工坊上分享你的创意。 创造出具有挑战性的情景，让其他的玩家去挑战！<br />\r\n三个臭皮匠胜过诸葛亮，当你游戏的时候不要忘记带上你的谋士。 共同合作完成本游戏，或你可以尝试在Steam创意工坊中重新设置你的游戏。\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7 or higher<br />\r\n处理器: 64 bit, 3.2 Ghz i3 Processor or equivalent<br />\r\n内存: 4 GB RAM<br />\r\n显卡: GeForce GTX 660 (2048 MB) or Radeon R9 285 (2048 MB) – Integrated GPUs may work but are not supported.<br />\r\nDirectX 版本: 9.0c<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 2 GB 可用空间<br />\r\n声卡: DirectX compatible\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	31,	'https://fhdemo.s-cms.cn/t15/media/202011021108516R.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	105,	7,	'2020-11-02 11:08:27',	0,	1,	1,	'即时 战略',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256778948/movie480.webm?t=1585031326',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(183,	'中世纪王国战争',	0.00,	'<div style=\"font-size:12.6316px;\">\r\n	<h2>\r\n		关于这款游戏\r\n	</h2>\r\n《中世纪王国战争》开创大战略类型游戏先河，将大地图王国管理和即时战略战斗融合为一。时值1336年，英法百年战争即将拉开序幕。\r\n	<h2>\r\n		宏伟战局\r\n	</h2>\r\n作为中世纪欧洲的小领主之一开始游戏。游戏包含十余个国家，五十多名领主供您选择，每次游戏体验都将独一无二。游戏模式多种多样：大战略模式、支持单人，合作和多人游戏的经典RTS遭遇战模式、还有带有故事解说的九关精心制作的战役关卡。\r\n	<h2>\r\n		全新模式\r\n	</h2>\r\n类rogue式游戏进程，配上全即时游戏模式，玩家所做的一切都将即时保存，就算在战斗中也一样。没有第二次机会，没有回合，没有读档重来。这是第一款采用了RTS机制的固定军队战略游戏。玩家不仅能将自己的部队带入战场，更能在战场上立起营地，随着战局事态现场训练士兵。<br />\r\n<br />\r\n	<h2>\r\n		史诗战场\r\n	</h2>\r\n本游戏中单战场支持超过120支部队作战。无论是血腥的攻城战，绞肉机般的平原战还是波澜壮阔的海战都将以史实还原，玩家甚至可以劫掠尸体，拆毁城镇换取资源。\r\n	<h2>\r\n		亲手管理\r\n	</h2>\r\n玩家可以通过以RTS模式进入城镇来亲手细致管理城镇。指挥农民，建造建筑与城墙，排布士兵。当然，您也可以在世界地图上进行宏观管理。\r\n	<h2>\r\n		繁复科技\r\n	</h2>\r\n中世纪晚期是一个科技蓬勃发展的年代。游戏用复杂的史实科技树还原了这点 - 游戏中有着超过240种科技选项，从宗教，军事到新型攻城战术应有尽有。<br />\r\n<br />\r\n	<h2>\r\n		封建外交\r\n	</h2>\r\n随着战果累计，玩家将能接触到王国内的复杂外交关系网络。服务于你的国王，维护与其他领主之间的关系，甚至影响整个欧洲的政局走向。有了足够强大的力量之后，玩家还能够推翻国王，自己做主。这将展开新一层级的游戏内容。玩家能够征募，分封领主，并用复杂的欧洲政治外交系统来凝聚你的王国。\r\n	<h2>\r\n		美丽世界\r\n	</h2>\r\n华丽的动态世界地图。西欧地图板块上有着超过200个城镇与村庄。城镇完全由手工打造，真实还原中世纪历史。<br />\r\n更多精彩… <br />\r\n	<ul>\r\n		<li>\r\n			能够影响游戏世界的动态天气与季节变化<br />\r\n		</li>\r\n		<li>\r\n			包含聊天等社交元素的大战略<br />\r\n		</li>\r\n		<li>\r\n			超过30种单位以及攻城武器，每个派系更有自己的独特单位<br />\r\n		</li>\r\n		<li>\r\n			由乐团演奏的动听音乐<br />\r\n		</li>\r\n		<li>\r\n			功能强大的世界编辑器以及各种mod工具<br />\r\n		</li>\r\n		<li>\r\n			上线后的持续免费更新<br />\r\n		</li>\r\n		<li>\r\n			仅由三名开发者完成的壮举<br />\r\n		</li>\r\n		<li>\r\n			义务管理员和开发者将即时回馈您的问题\r\n		</li>\r\n	</ul>\r\n</div>\r\n<div style=\"font-size:12.6316px;\">\r\n	<h2>\r\n		系统需求\r\n	</h2>\r\n	<div>\r\n		<ul>\r\n			最低配置:<br />\r\n			<ul>\r\n				<li>\r\n					操作系统:&nbsp;Windows Vista<br />\r\n				</li>\r\n				<li>\r\n					处理器:&nbsp;2.4 GHz Dual Core<br />\r\n				</li>\r\n				<li>\r\n					内存:&nbsp;3 GB RAM<br />\r\n				</li>\r\n				<li>\r\n					显卡:&nbsp;NVIDIA GeForce 670 / Radeon R9 280X<br />\r\n				</li>\r\n				<li>\r\n					DirectX 版本:&nbsp;11<br />\r\n				</li>\r\n				<li>\r\n					网络:&nbsp;宽带互联网连接<br />\r\n				</li>\r\n				<li>\r\n					存储空间:&nbsp;需要 5 GB 可用空间\r\n				</li>\r\n			</ul>\r\n		</ul>\r\n	</div>\r\n</div>',	31,	'https://fhdemo.s-cms.cn/t15/media/20201102111001zr.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	89,	8,	'2020-11-02 11:09:41',	0,	1,	1,	'战争 策略 即时 ',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256737690/movie480.webm?t=1544138514',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(184,	'指环王：成长卡牌游戏 The Lord of the Rings',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《指环王：成长卡牌游戏 The Lord of the Rings》是一款刺激有趣的策略卡牌游戏，玩家可组建英雄牌库，挑战索伦的军队。玩家可进行单人游戏，也可与好友组队，探索著名场景，完成故事情节任务，打造玩家专属的中土传奇。请小心索伦之眼，一旦被他盯上，将前功尽弃……\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;font-size:14pt;\">最低配置:</span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">操作系统: Windows 7 / Windows 8 / Windows 10<br />\r\n处理器: Intel Core 2 Duo E6600 (2.4 Ghz) or AMD Athlon 64 X2 5000+ (2.6 Ghz) or better<br />\r\n内存: 2 GB RAM<br />\r\n显卡: Nvidia GeForce 8800 GT (512 MB) or better; ATI Radeon HD 4850 (512 MB) or better; Intel Haswell Iris and HD Graphics<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 6 GB 可用空间\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。 <br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。 <br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！ <br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。 <br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n	</p>',	54,	'https://fhdemo.s-cms.cn/t15/media/20201102111227pS.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	82,	10,	'2020-11-02 11:12:12',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256770462/movie480.webm?t=1576790396',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(185,	'痛苦之戒 Ring of Pain',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《痛苦之戒 Ring of Pain》是一款地牢探险类卡牌游戏，会有什么样的遭遇在等着你呢？在这个环形的世界里，你必须格外谨慎，一步错就有可能走上绝路。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	16个核心主线地牢，外加2个分支结局，考验你最终的实力。\r\n</li>\r\n<li>\r\n	可解锁困难模式，专为那些在苦痛中越战越勇的人准备。\r\n</li>\r\n<li>\r\n	可解锁每日地牢，超过25种特殊限制条件，给你截然不同的体验\r\n</li>\r\n<li>\r\n	勇闯超过25种特殊地牢，掠夺战利品并邂逅奇异的事物。\r\n</li>\r\n<li>\r\n	4种环境区域，每个都有其迥异的恐怖风格。\r\n</li>\r\n<li>\r\n	可解锁180多种物品，利用15个物品栏槽位来组合搭配。\r\n</li>\r\n<li>\r\n	40多种生物需要你去了解和应对。其中既有友好的朋友，也有凶狠的恶棍……\r\n</li>\r\n<li>\r\n	回合制的游戏机制，你可以选择迅速作战，也可以选择运筹帷幄。\r\n</li>\r\n<li>\r\n	暗含深意、耐人寻味的简短诗句\r\n</li>\r\n<li>\r\n	原始粗犷的图形美术风格，灵感来自于心盲症患者。\r\n</li>\r\n<li>\r\n	可爱的青蛙朋友。\r\n</li>\r\n<li>\r\n	一段苦痛之旅。\r\n</li>\r\n	</ul>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows Vista/7/10<br />\r\n处理器: 2 GHz<br />\r\n内存: 4 GB RAM<br />\r\n显卡: OpenGL 2.0 compatible with 512 MB RAM (Shared Memory is not recommended)<br />\r\n存储空间: 需要 1 GB 可用空间\r\n		</p>',	54,	'https://fhdemo.s-cms.cn/t15/media/20201102111345ZA.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	67,	9,	'2020-11-02 11:13:31',	0,	1,	1,	'卡牌 策略',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256799338/movie480_vp9.webm?t=1598930170',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(186,	'Cardpocalypse',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《Cardpocalypse》是由Gambrinous制作发行的一款单人纸牌游戏，区别于扑克牌，在本作中玩家要进行的是一款在学校中非常流行的，类似于《游戏王》的一类变种宠物对战的卡牌游戏。但是奇怪的事情接二连三发生，游戏中的怪物竟然出现在了校园当中，而你要做的就是战胜他们之后将它们送回游戏世界中去。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">成为冠军：围绕你获得的超罕见的冠军卡建立你的牌组。每个冠军都有独特的能力来定制你的牌组。第一个把对手的冠军卡的生命打成零的玩家就赢得了比赛。<br />\r\n走向超级：当他们的生命值减少一半时，冠军卡会进化成超级形态，造成更多攻击伤害并获得新的能量。<br />\r\n改变游戏：孩子们有时会使用自订规则，谁知道异形将会改变什么。在整个游戏过程中，你会选择新的规则和条件，还可以重命名你喜爱的卡牌，并使用贴纸给升级卡牌。使用超级异形能量杂志创造全新的卡牌。但是要注意，这些决定是永久性的。<br />\r\n变得好斗：在整个学校里冒险，以破解达斯代尔小学发生的奇怪事件。完成任务可以获得用来收藏的卡牌、贴纸和糖果，你可以那它们和同学们交换。要小心，没有后援！<br />\r\n不能收集全套：最后，你的牌组和规则对你来说将是独一无二的。贴纸是罕见的，选择很重要，有时你必须做出艰难的决定才能获得最好的卡牌。<br />\r\n20世纪90年代：通过基于选择、互动描述的超酷的游戏形式，Cardpocalypse提供了变成90年代孩子的体验。呦吼！<br />\r\n现在收录Gauntlet Mode！每一次挑战都独一无二的随机关卡模式。选择您的勇士，通过前所未有的困难挑战吧。 每一场胜利可为卡组制定新卡牌，规则与奖励！您是否能连续闯关Gauntlet呢？\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7<br />\r\n处理器: Intel Core2 Duo 2.4GHz or equivalent<br />\r\n内存: 4 GB RAM<br />\r\n显卡: Intel HD Graphics 5000 or better<br />\r\n存储空间: 需要 500 MB 可用空间\r\n</p>',	54,	'https://fhdemo.s-cms.cn/t15/media/202011021114406H.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	110,	6,	'2020-11-02 11:14:24',	0,	1,	1,	'卡牌 策略',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256790917/movie480_vp9.webm?t=1601419459',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(187,	'星陨传说：流浪者的故事',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《星陨传说：流浪者的故事 Meteorfall: Krumit’s Tale》是一款以克鲁姆神话故事为背景的像素类卡牌策略游戏。使用卡片清除地牢，然后使用新卡片和特权升级您的卡组以向前推动。世界的命运掌握在您手中。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span><br />\r\n独特的 roguelike 玩法<br />\r\n你的英雄会携带一套基础牌组（物品和技能）踏入地下城。<br />\r\n这套英雄牌组在游戏开始后，会被洗入地下城牌组（即怪物卡牌）之中，然后，游戏将从这个打乱的牌组中，随时抽出其中九张卡牌排列到3*3的网格中。<br />\r\n这些随机卡牌包括物品，技能以及怪物，玩家需要击败怪物来获得金币，然后用金币来换取地下城中的物品和技能。<br />\r\n每当网格中消掉一张卡牌，卡牌上方的卡牌便会落下，填补这张卡牌的空位，而游戏也会从牌组中抽出一张新的卡牌，补充到网格的最上方。<br />\r\n清理掉整个地下城的怪物，这一轮冒险即宣告结束，玩家会获得一定的奖励，剩余的物资也会被兑换成钻石。<br />\r\n在下一轮冒险开始前，你将可以在牌库中添加更强力的新卡牌，以及选择新的人物能力——改变游戏规则的被动属性。<br />\r\n个性鲜明的角色<br />\r\n《星陨传说：旅程》（已登录iOS与安卓平台，备受好评，MC评分高达95分）中曾经登场过的英雄将在《流浪者的故事》中回归。大家曾经钟爱的喜爱的英雄：布鲁诺、灰胡子、捣蛋鬼、蔷薇和穆道夫又将踏上击败盖世巫妖的全新旅程。你还会遇到克鲁米特，这是位做着神奇的魔法生意的神秘店长。他为何把你召进他的店里？他究竟隐瞒了什么秘密？<br />\r\n解锁英雄与卡牌<br />\r\n你第一次造访克鲁米特的时候，仅能使用布鲁诺这一位英雄。每场游戏结束后，你可以获得一些经验值并自动解锁新的角色与卡牌。《流浪者的故事》不会刻意浪费大家的时间——你可以在正常的游戏流程中轻松地解锁所有内容，没有任何反复的刷怪元素。<br />\r\n……你还可以期待这些<br />\r\n5位独特的英雄将包含在正式发售的版本中（当前可选人物包括布鲁诺，灰胡子以及捣蛋鬼）<br />\r\n40+种能力——能够改变游戏规则的被动技能<br />\r\n每位英雄都有40+种独特的卡牌，以及一套英雄共用通用卡牌<br />\r\n简短的单局游戏长度大约会持续45-60分钟，游戏支持自动保存，你可以随时退出游戏，并在之后继续之前的游戏<br />\r\n20+种敌人，每一个都由才华横溢的 Evgeny Viitman（《星陨传说：旅程》美术）制作了精美的动画<br />\r\n让玩家能够创造各种连击与策略的创新网格系统<br />\r\n系统生成的旅程——每场游戏中的地下城都会有所不同<br />\r\n风格怪诞但又不失深度的世界，幽默的对话和多样的角色与NPC——不断扩张的星陨传说世界观！<br />\r\nEvgeny Viitman 制作的独特美术与动画<br />\r\nCraig Barnes 制作的震撼人心的音乐原声<br />\r\nDanny Wadeson 的幽默文笔<br />\r\n专业配音 Adrian Vaughan 的献声\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7<br />\r\n内存: 4 GB RAM<br />\r\n存储空间: 需要 500 MB 可用空间\r\n	</p>',	54,	'https://fhdemo.s-cms.cn/t15/media/20201102111637Ek.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	54,	11,	'2020-11-02 11:15:19',	0,	1,	1,	'卡牌策略',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256777620/movie480.webm?t=1595377173',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(188,	'对抗月球 Against The Moon',	0.00,	'<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏介绍：</strong></span> \r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">《对抗月球 Against The Moon》是一款融合了多种游戏的优点的卡牌策略类游戏，在这个世界中，地球变成了废墟，人类最后的希望就落在了你的手中，组建一支属于自己的小队，在月球汇中阻挡各种怪物的袭击，成为人类最后的一道保护线。\r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><a class=\"highslide-image\" href=\"https://s1.jiligame.com/images/2020/09/22/339724665d57bd2cd6063759ddd510a3.jpg\"><br />\r\n</a> \r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏特色：</strong></span> \r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">独特的界面系统<br />\r\nAgainst the Moon提供了新的界面创建方式。每张手卡都有两种进化轨迹，可以根据对手的策略做调整。注意你的能量数值并且记住：敌人在观察着你的每一步。<br />\r\n巨型竞技场<br />\r\n带领一队史诗级英雄Ultori。每一位Ultori都有特殊技能和武器，以及最重要的——自己战斗中的分队。有战略地思考，用狡猾的陷阱致胜，用队伍的强大消灭敌人。<br />\r\n唯美而致命<br />\r\n让你沉浸在拥有十几种不同游戏环境和紧张生动的战斗场景的独特后天启世界里。<br />\r\n面向所有玩家<br />\r\nAgainst the Moon既给普通玩家提供易学的游戏设定，又为高阶玩家设置有特别奖励的特殊任务挑战。<br />\r\n宏大的科幻冒险<br />\r\n你将进入一个人类被遗忘的世界，探索神一般先人的秘密。发现奇异邪恶的怪物Furos的起源，并挑战入侵地球的暴君。重振Arx的辉煌——人类最后的堡垒。<br />\r\n每一次新的冒险<br />\r\n未来世界并不允许犯错。在Arx围城之外，每一个决定都可能成为你的最后一个。把圣物和谨慎的战略结合，征战废弃的土地。<br />\r\n受经典启发<br />\r\n我们把经典的RPG理念融入到现代游戏设计中，创造了一个迷人的有挑战性的全新游戏体验。每个复活节彩蛋和隐藏细节都会添加一个新且让人怀旧的冒险。\r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>最低配置:</strong></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows XP, Vista, 7, 8/8.1, 10<br />\r\n处理器: 2.0 Ghz<br />\r\n内存: 8 GB RAM<br />\r\n显卡: 1Gb Video Memory<br />\r\n存储空间: 需要 4 GB 可用空间\r\n</p>',	73,	'https://fhdemo.s-cms.cn/t15/media/20201102111756rm.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	40,	5,	'2020-11-02 11:17:27',	0,	1,	1,	'卡牌',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256801096/movie480_vp9.webm?t=1600433928',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(189,	'永恒之门/Evergate',	0.00,	'<div class=\"game_page_autocollapse_ctn collapsed\" style=\"padding:0px 0px 20px;margin:0px;color:#ACB2B8;font-family:Arial, Helvetica, sans-serif;font-size:14px;background-color:#1B2838;\">\r\n	<div class=\"game_page_autocollapse\" style=\"padding:0px;margin:0px;\">\r\n		<div id=\"game_area_description\" class=\"game_area_description\" style=\"padding:0px;margin:30px 0px 0px;\">\r\n			<h2 style=\"font-weight:normal;font-size:14px;color:#FFFFFF;\">\r\n				于这款游戏\r\n			</h2>\r\n			<h2 class=\"bb_tag\" style=\"font-weight:normal;font-size:15px;color:#2F89BC;\">\r\n				<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/845030/extras/kienter.png?t=1598958653\" /> \r\n			</h2>\r\n运用你的灵魂火焰，释放非凡能量，体会两个知心伴侣的感人故事。在这款独特的 2D 益智平台游戏中，引导孩童般的灵魂 Ki 踏上迷人而难忘的来世之旅。<br />\r\n<strong>灵魂火焰机制</strong><br />\r\n运用独特的灵魂火焰机制减慢时间，瞄准目标，并释放你遇到的每一个水晶中隐藏的神秘力量。同时击中多个水晶，进行试验，以了解它们的能量是如何结合的。<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/845030/extras/GIF_1_ALT.gif?t=1598958653\" /><br />\r\n<strong>揭示遗留下来的生命记忆</strong><br />\r\n穿越时间和空间，揭示 Ki 与另一个灵魂的神秘联系。<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/845030/extras/GIF_2_ALT.gif?t=1598958653\" /><br />\r\n<strong>收集精华，解锁神器</strong><br />\r\n奋起接受挑战，通过完成每一关的挑战来收集精华。利用它们解锁古代神器并提升 Ki 的技能。<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/845030/extras/GIF_3_ALT.gif?t=1598958653\" /><br />\r\n<strong>梦幻美术风格</strong><br />\r\n华丽的环境背景搭配精美的手绘插图，将 Ki 和 Evergate 的环境演绎得栩栩如生。<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/845030/extras/GIF_4.gif?t=1598958653\" /><br />\r\n<strong>让人沉醉的配乐</strong><br />\r\n享受精心编曲的原创配乐，它们由现场管弦乐队录制，并针对每种环境量身定制。<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/845030/extras/gate-sm.png?t=1598958653\" /> \r\n		</div>\r\n	</div>\r\n	<div class=\"game_page_autocollapse_fade\" style=\"padding:0px;margin:0px;background:url(;\">\r\n		<div class=\"game_page_autocollapse_readmore\" style=\"padding:0px 12px 0px 0px;margin:0px;color:#537CA6;font-size:10px;background:url(;\">\r\n			展开阅读\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"padding:0px;margin:0px;color:#ACB2B8;font-family:Arial, Helvetica, sans-serif;font-size:14px;background-color:#1B2838;\">\r\n	<div class=\"game_page_autocollapse sys_req\" style=\"padding:0px;margin:30px 0px 0px;\">\r\n		<h2 style=\"font-weight:normal;font-size:14px;color:#FFFFFF;\">\r\n			系统需求\r\n		</h2>\r\n		<div class=\"sysreq_contents\" style=\"padding:0px;margin:10px 0px 0px;\">\r\n			<div class=\"game_area_sys_req sysreq_content active\" style=\"padding:0px;margin:0px;font-size:12px;\">\r\n				<div class=\"game_area_sys_req_leftCol\" style=\"padding:0px;margin:0px;\">\r\n					<ul>\r\n						<span style=\"font-size:10px;color:#BCC6CD;\">最低配置:</span><br />\r\n						<ul class=\"bb_ul\">\r\n							<li>\r\n								<span style=\"color:#61686D;\">操作系统:</span> 7<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"color:#61686D;\">处理器:</span> Intel Core 2 Duo E4500 @ 2.2GHz or AMD Athlon 64 X2 5600+ @ 2.8 GHz<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"color:#61686D;\">内存:</span> 4 GB RAM<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"color:#61686D;\">显卡:</span> GeForce 240 GT or Radeon HD 6570 – 1024 MB (1 gig)<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"color:#61686D;\">DirectX 版本:</span> 9.0c<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"color:#61686D;\">存储空间:</span> 需要 3 GB 可用空间\r\n							</li>\r\n						</ul>\r\n					</ul>\r\n				</div>\r\n				<div class=\"game_area_sys_req_rightCol\" style=\"padding:0px;margin:0px 0px 0px 8px;\">\r\n					<ul>\r\n						<span style=\"font-size:10px;color:#BCC6CD;\">推荐配置:</span><br />\r\n						<ul class=\"bb_ul\">\r\n							<li>\r\n								<span style=\"color:#61686D;\">存储空间:</span> 需要 3 GB 可用空间\r\n							</li>\r\n						</ul>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	56,	'https://fhdemo.s-cms.cn/t15/media/20201102112725tl.png',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	72,	7,	'2020-11-02 11:22:14',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256798354/movie480_vp9.webm?t=1598555888',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(190,	'斩妖R aksasi ',	1.00,	'<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏介绍：</strong></span>\r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">《Devil Slayer – Raksasi / 斩妖Raksasi》是一款带有 Roguelike 元素的顶视角随机生成地牢动作游戏。战斗采用种类丰富的近战武器，并结合随机多变的各种道具和秘宝。战斗比较偏向魂类的硬核朴实风格，重视走位、攻击距离和时机把握。\r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏特色：</strong></span>\r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">六位女主角的杀戮之旅<br />\r\n白缨——永生不死的神族遗民，武器：长刀<br />\r\n阿芸——爱上人类的魔族少主，武器：长矛<br />\r\n壬戌——性情刚烈的火爆少女，武器：巨锤<br />\r\n无界——阴影中行走的混血儿，武器：双刃<br />\r\n穆兰——全族被诛的名将遗孤，武器：盾刀<br />\r\n江音——叛逃组织的绿林女王，武器：锁镰<br />\r\n我们精心打造了六位女主角，六个系列三十七把武器，每把武器都有自己独特的操作和战斗体验。后续，我们还将继续在这个维度增加游戏内容，敬请期待。<br />\r\nRoguelike式的轮回试炼<br />\r\n边境疆土相争战事不断，各地天灾人祸起义叛乱，妖兽暴动为害民众，魔族反扑蠢蠢欲动。在这千苍百孔的土地上，有一帮人想破除黑暗，把世界推向光明。他们创造了轮回试炼，让天选之人在不断轮回中，找出拯救世界的关键钥匙。<br />\r\n游戏采用Roguelike的方式，您会在随机生成的关卡地图中，面对不同的敌人。您会因为拾取不同的秘宝，而使游戏有无穷无尽的变化。我们期待让您每一局都有新鲜有趣的体验。当前制作了6个章节，150种敌人，150种秘宝。我们还将继续在这个维度增加游戏内容，让游戏变得更丰富有趣。<br />\r\n朴实而极具挑战的动作游戏<br />\r\n不同于大量刷怪的动作游戏，《斩妖Raksasi》采用朴实的战斗风格，重视走位、攻击时机和节奏把握。您需要熟悉自己的武器，也需要掌握敌人的行动方式，谨慎小心处理每一下攻击。处理得当，对敌人致命，处理失当，死亡会是常态。<br />\r\n请不要气馁，随着对游戏的熟悉度提升，您的技术水平也会提升，动作游戏的趣味会源源不断释放。\r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>最低配置:</strong></span><br />\r\n操作系统: Windows 7<br />\r\n处理器: Intel Core 2 Duo E5200<br />\r\n内存: 4 GB RAM<br />\r\n显卡: GeForce 9800GTX+ (1GB)<br />\r\nDirectX 版本: 10<br />\r\n存储空间: 需要 1 GB 可用空间\r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。&nbsp;<br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。&nbsp;<br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！&nbsp;<br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。&nbsp;<br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n	</p>',	56,	'https://fhdemo.s-cms.cn/t15/media/2020110211535603.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	50,	7,	'2020-11-02 11:30:44',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(191,	'《Addle Earth》中文版',	0.00,	'<p style=\"font-size:12.63px;\">\r\n	<strong>游戏介绍：</strong> \r\n</p>\r\n<p style=\"font-size:12.63px;\">\r\n	《Addle Earth》是一款奇幻动作冒险游戏，讲述了三个角色的故事以及他们如何拯救世界：杰特-女孩，车-猿和摩西-外星人，他们穿越一个充满未来感，被遗弃和混乱的行星地球，与机械敌人（机器和机器人）作战。\r\n</p>\r\n<p style=\"font-size:12.63px;\">\r\n	<br />\r\n</p>\r\n<p style=\"font-size:12.63px;\">\r\n	<strong>最低配置:</strong><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7<br />\r\n处理器: Intel Core I3<br />\r\n内存: 8 GB RAM<br />\r\n显卡: Nvidia GTX 920<br />\r\nDirectX 版本: 9.0<br />\r\n存储空间: 需要 10 GB 可用空间\r\n</p>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102124429rp.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	50,	8,	'2020-11-02 11:55:13',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256785430/movie480_vp9.webm?t=1591098451',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(192,	'巫师3狂猎年度版集成18DLC+血与酒+石之心',	1.00,	'集成18DLC+血与酒+石之心|容<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">《巫师3：狂猎年度版 The Witcher 3: Wild Hunt – Game of the Year Edition》是一款情节驱动的开放世界角色扮演游戏。本作的故事发生在一个令人目眩神迷的奇幻宇宙里，玩家做出的每一个选择都意义重大，同时也要面对影响深远的后果。在《巫师》这个广袤的开放世界中，您可以尽情探索商业都市、海盗岛屿、危险的山隘和被遗忘的洞窟。\r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><br />\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span><br />\r\n<span style=\"font-weight:700;\">扮演一名训练有素，收钱办事的怪物杀手</span><br />\r\n猎魔人身处的世界怪物横行。作为一支制衡力量，他们自小接受训练，通过变异来获得超人类的战斗技巧、力量和反应。<br />\r\n扮演一名职业怪物杀手，装备一系列可以升级的武器、变种魔药和战斗法术，无情地把对手大卸八块。<br />\r\n凶残的野兽徘徊于山间，狡猾的灵异掠食者潜伏在人烟稠密的城镇暗处，而您则要捕杀这些各色的奇异怪物。<br />\r\n把您赚取的奖赏用来升级武器，购买订制的盔甲，或者花在赛马、打牌、拳击，还有其它的夜间娱乐生活上。<br />\r\n<span style=\"font-weight:700;\">探索道德沦丧的开放式奇幻世界</span><br />\r\n巫师宏大的开放世界为玩家带来无尽的冒险，并且在规模、深度和复杂性等方面树立了新的标准。<br />\r\n遍历奇幻的开放世界：探索被遗忘的废墟、洞穴和沉船，与城市里的商人和矮人工匠做买卖，在开阔的平原、山地和海洋上进行狩猎。<br />\r\n与谋反的将领、阴险的女巫还有腐败的皇室打交道，替他们去完成见不得光的危险勾当。<br />\r\n做出超越善恶的选择，直面影响深远的后果。<br />\r\n<span style=\"font-weight:700;\">追寻预言之子</span><br />\r\n接下最为重要的一笔委托，追寻预言之子。那是一个可以拯救或是摧毁这个世界的关键。<br />\r\n根据古代精灵的预言，预言之子强大无比，是一件活生生的武器。而您则要在纷飞的战火中找到对方的下落。<br />\r\n和一心想要控制这个世界的残暴统治者、野外的精怪，乃至于来自来世的威胁斗智斗勇。<br />\r\n在这个或许并不值得拯救的世界里，左右自己的命运。<br />\r\n<span style=\"font-weight:700;\">次世代机能的全面发挥</span><br />\r\n专为次世代硬件量身打造的 REDengine 3，把《巫师》的逼真奇幻世界渲染得细腻生动。<br />\r\n动态的天气系统和日夜循环，将会改变城镇居民以及野外怪兽的行为模式。<br />\r\n通过主线和支线的丰富剧情选择，玩家可以通过前所未有的方式，影响这个宏大的开放世界。\r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: 64-bit Windows 7, 64-bit Windows 8 (8.1) or 64-bit Windows 10<br />\r\n处理器: Intel CPU Core i5-2500K 3.3GHz / AMD CPU Phenom II X4 940<br />\r\n内存: 6 GB RAM<br />\r\n显卡: Nvidia GPU GeForce GTX 660 / AMD GPU Radeon HD 7870<br />\r\n存储空间: 需要 35 GB 可用空间\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><br />\r\n</p>',	58,	'https://fhdemo.s-cms.cn/t15/media/202011021639280f.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	541,	121,	'2020-11-02 12:49:53',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256719019/movie480.webm?t=1528288698',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	'2021-08-10 19:01:37'),
(193,	'尼尔机械纪元',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《NieR:Automata》讲述了机器人 2B、9S 和 A2 的故事，以及他们为夺回遭强大机械生命体占领、由机器驱动的反乌托邦而进行的战斗。<br />\r\n人类已经被来自另一个世界的机械生命体赶出了地球。为了夺回地球，人类抵抗军孤注一掷，派遣了一支人形机器人士兵军队，以摧毁入侵者。现在，机械生命体和人形机器人之间的战争开始了……而这场战争可能很快就将揭开一个早已被遗忘的世界真相。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">最低配置:</span></span><br />\r\n操作系统: Windows 7 /8.1 /10 64bit<br />\r\n处理器: Intel Core i3 2100 or AMD A8-6500<br />\r\n内存: 4 GB RAM<br />\r\n图形: NVIDIA GeForce GTX 770 VRAM 2GB or AMD Radeon R9 270X VRAM 2GB<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 50 GB 可用空间\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102125250kH.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	351,	85,	'2020-11-02 12:51:20',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256743980/movie480.webm?t=1551200563',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(194,	'我的朋友佩德罗中文版',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《我的朋友佩德罗 My Friend Pedro》是一款动作冒险类游戏，关于友情、幻想的血色芭蕾，讲述了一个男人如何在一个会说话的香蕉的引导下人挡杀人、佛挡杀佛。通过战略性地使用分别瞄准、慢动作以及经典的破窗而入等战术动作，玩家可以打出一套接一套动感十足的场景，在嗜血暴力的地下世界大杀四方。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7, 8, 8.1, 10 x64<br />\r\n处理器: Intel Core i3-530 (2 * 2930) or equivalent<br />\r\n内存: 4 GB RAM<br />\r\n图形: GeForce GT 440 (1024 MB)<br />\r\n存储空间: 需要 4 GB 可用空间\r\n</p>',	44,	'https://fhdemo.s-cms.cn/t15/media/202011021254071U.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	75,	21,	'2020-11-02 12:53:54',	0,	1,	1,	'动作 冒险',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256745868/movie480.webm?t=1560649283',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(195,	'刺客信条奥德赛 集成全DLCs',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n	<h1 class=\"inn-singular__post__title\" style=\"text-align:center;color:#666666;\">\r\n		刺客信条：奥德赛 Assassins Creed: Odyssey》中文版百度云迅雷下载v1.5.3版|容量100GB|集成全DLCs|官方简体中文|支持键盘.鼠标.手柄|赠官方原声56首BGM|赠多项修改器|赠1.5.3二周目全氪金.全UPLAY.99级地图全开.问号全清.高效率剧情党存档\r\n	</h1>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《刺客信条：奥德赛 Assassins Creed: Odyssey》是一款开放世界角色扮演游戏，从一名流浪者蜕变成传奇人物，踏上这趟奥德赛之旅，找出你过往的秘密并改变古希腊的命运。比起源更加成熟的游戏，更多职业供你选择。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7 SP1, Windows 8.1, Windows 10 (64bit versions only)<br />\r\n处理器: AMD FX 6300 @ 3.8 GHz, Ryzen 3 – 1200, Intel Core i5 2400 @ 3.1 GHz (MORE DETAILS HERE)<br />\r\n内存: 8 GB RAM<br />\r\n显卡: AMD Radeon R9 285, NVIDIA GeForce GTX 660 (2GB VRAM with Shader Model 5.0) (MORE DETAILS HERE)<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 46+ GB 可用空间<br />\r\n附注事项: Video Preset: Lowest (720p)\r\n</p>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102125844if.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	427,	111,	'2020-11-02 12:55:26',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256755149/movie480.webm?t=1562570536',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(196,	'怪物猎人世界',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《怪物猎人：世界 MONSTER HUNTER: WORLD》是一款在这片苍蓝星耀的大陆上，白色之风登场；在战胜巨龙震耳的咆哮声，喧闹整个世界；导虫狂飞的讯号 狩猎时代正来到；星辰逆流而上，铳枪在发烫 猎人也势不可挡。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: WINDOWS&reg; 7, 8, 8.1, 10 (必须为64-BIT)<br />\r\n处理器: Intel&reg; Core™ i5-4460, 3.20GHz 或 AMD FX™-6300以上<br />\r\n内存: 8 GB RAM<br />\r\n显卡: NVIDIA&reg; GeForce&reg; GTX 760 或 AMD Radeon™ R7 260x（VRAM 2GB以上)<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 48 GB 可用空间<br />\r\n声卡: 对应 DirectSound(DirectX&reg; 9.0c以上)<br />\r\n附注事项: 可在画面设置为「低」、1080p／30fps的情况下进行游戏。\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	29,	'https://fhdemo.s-cms.cn/t15/media/202011021259340x.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	210,	34,	'2020-11-02 12:58:56',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256769026/movie480.webm?t=1578591066',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(197,	'《最终幻想15 Final Fantasy XV》中文版百度云迅雷下载联机版',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《最终幻想15亚丹之章 Final Fantasy XV》是一款角色扮演类游戏，”随着开场CG结束，一行人推着车开始了冒险，BGM随即响起[Stand By Me]，直接就被那美好的感觉带入了游戏..虽然可能会有老粉丝对本作不满意，虽然这部最终幻想存在瑕疵，但这款游戏的体验告诉你，它有自己独特的闪光点。（支持简繁中文）\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">与挚友一同踏上这场永生难忘的旅程，穿越令人屏息的开放世界、目睹迷人的大地风采，在旅途中挑战体型惊人的猛兽，并奋力打败强大敌人，夺回家园。<br />\r\n采用动感十足的战斗系统，在惊险刺激的战斗中，轻松引导先祖的力量，穿梭战场时空。和战友携手合作，掌握武器、魔法和团队战斗的技能。<br />\r\n现在推出的 Windows PC 版本，搭配尖端科技的强大功能，包括支持高分辨率画面显示和 HDR10，立即来畅玩这款画面精美且精心制作的《FINAL FANTASY XV》，享受前所未有的游戏体验。\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows&reg; 7 SP1/ Windows&reg; 8.1 / Windows&reg; 10 64-bit<br />\r\n处理器: Intel&reg; Core™ i5-2500（3.3GHz and above）/ AMD FX™-6100 （3.3GHz and above）<br />\r\n内存: 8 GB RAM<br />\r\n图形: NVIDIA&reg; GeForce&reg; GTX 760 / NVIDIA&reg; GeForce&reg; GTX 1050 / AMD Radeon™ R9 280<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 100 GB 可用空间<br />\r\n声卡: DirectSound&reg; compatible sound card, Windows Sonic and Dolby Atmos support<br />\r\n附注事项: 720p 30fps\r\n</p>',	29,	'https://fhdemo.s-cms.cn/t15/media/202011021311110O.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	279,	47,	'2020-11-02 13:10:08',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256735103/movie480.webm?t=1542104574',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(198,	'刺客信条3：重制版 Assassin’s Creed III REMASTERED',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《刺客信条3：重制版 Assassin’s Creed III REMASTERED》是一款开放世界游戏，1775年，美洲殖民地即将揭竿而起。扮演一名美国原住民刺客康纳，为人民和国家保护自由的成果。从熙熙攘攘的街道到混乱的海战，利用众多致命方法和大量不同的武器来刺杀你的敌人。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: W7 SP1, W8.1, W10 (64bit versions only)<br />\r\n处理器: Intel Core i5 2400 @ 3.1 GHz, AMD FX 6350 @ 3.9 GHz<br />\r\n内存: 8 GB RAM<br />\r\n显卡: Nvidia GeForce GTX 660, AMD Radeon R9 270X (2GB VRAM with Shader Model 5.0)<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 45 GB 可用空间\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201102131238MO.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	163,	58,	'2020-11-02 13:12:13',	0,	1,	1,	'动作 冒险',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(199,	'海贼无双4 ',	1.00,	'<div class=\"game_page_autocollapse_ctn\" style=\"border:none;color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse\" style=\"border:none;\">\r\n		<div id=\"game_area_description\" class=\"game_area_description\" style=\"border:none;\">\r\n			<h2 style=\"color:#313131;font-size:25px;\">\r\n				<br />\r\n			</h2>\r\n			<h2 style=\"color:#313131;font-size:25px;\">\r\n				关于这款游戏\r\n			</h2>\r\n			<p>\r\n				<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/1089090/extras/OPPW4_600%C3%97300%EF%BC%88Luffy2).gif?t=1585271707\" style=\"height:auto;\" /><br />\r\n■海贼无双系列是由超人气动画『ONE PIECE』与以爽快动作获得人气的『无双』系列携手合作，累计超过400万套的超人气系列游戏！<br />\r\n以「和一夫当关的伙伴们一起冒险」为游戏主轴，让玩家可透过爽快的ONE PIECE动作体验动画中的冒险旅程！\r\n			</p>\r\n			<p>\r\n				<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/1089090/extras/OPPW4_600%C3%97300%EF%BC%88Nami%EF%BC%89_0206_STEAM.gif?t=1585271707\" style=\"height:auto;\" /> \r\n			</p>\r\n			<p>\r\n				■海贼无双4是进化后的『ONE PIECE』无双游戏！本作以「拟真的ONE PIECE战场体验」为核心概念，在动作场面中加入建筑物的破坏及烟尘弥漫的效果等，力求再现「ONE PIECE战场」。<br />\r\n此外也添加过去的「海贼无双」中从未出现的全新要素，实现前所未有、爽快感十足的『ONE PIECE』无双动作游戏体验！\r\n			</p>\r\n			<p>\r\n				<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/1089090/extras/OPPW4_600%C3%97300%EF%BC%88Law%EF%BC%89_0206_STEAM.gif?t=1585271707\" style=\"height:auto;\" /> \r\n			</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"border:none;color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse sys_req\" style=\"border:none;\">\r\n		<h2 style=\"color:#313131;font-size:25px;\">\r\n			系统需求\r\n		</h2>\r\n		<div class=\"sysreq_contents\" style=\"border:none;\">\r\n			<div class=\"game_area_sys_req sysreq_content active\" style=\"border:none;\">\r\n				<div class=\"game_area_sys_req_leftCol\" style=\"border:none;\">\r\n					<h2 style=\"color:#313131;font-size:15px;\">\r\n						<span style=\"font-weight:bolder;\">最低配置:</span> \r\n					</h2>\r\n					<ul>\r\n						<li>\r\n							<ul class=\"bb_ul\">\r\n								<li>\r\n									需要 64 位处理器和操作系统\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">操作系统:</span> Windows 10, 64bits\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">处理器:</span> Intel Core i5 3450 / AMD Ryzen 3 1300X\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">内存:</span> 8 GB RAM\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">显卡:</span> NVIDIA GeForce GTX 660 (2GB) / AMD Radeon HD 7870 (2GB)\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">DirectX 版本:</span> 11\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">网络:</span> 宽带互联网连接\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">存储空间:</span> 需要 25 GB 可用空间\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">附注事项:</span> Graphics settings: All ‘Low’ or ‘OFF’; Expected Framerate: 30 FPS @ 1280×720\r\n								</li>\r\n							</ul>\r\n						</li>\r\n					</ul>\r\n				</div>\r\n				<div class=\"game_area_sys_req_rightCol\" style=\"border:none;\">\r\n					<h2 style=\"color:#313131;font-size:15px;\">\r\n						<br />\r\n					</h2>\r\n					<div>\r\n						<span style=\"font-weight:bolder;\"><br />\r\n</span> \r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	57,	'https://fhdemo.s-cms.cn/t15/media/202011021316277R.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	186,	39,	'2020-11-02 13:15:46',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(200,	'暗黑血统创世纪3/ 2/ 1',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"color: rgb(102, 102, 102);\">游戏介绍：\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"color: rgb(102, 102, 102);\">《暗黑血统：创世纪 Darksiders Genesis》是一款动作冒险游戏，玩家将在枪林弹雨和刀光剑影之中，穿越成群的恶魔、天使以及所有的拦路者，厮杀出一条去往地狱并返回的道路。《创世纪》将让玩家首次看到游戏初作事件发生之前的《暗黑血统》世界，并介绍了四大天启骑士之一的斗神。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"color: rgb(102, 102, 102);\">游戏特色：\r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"color: rgb(102, 102, 102);\">\r\n<li>\r\n	扮演首次可玩的带枪骑士斗神，轰飞天使和恶魔\r\n</li>\r\n<li>\r\n	在疯狂的单机游戏中，即时切换强大的剑客战神和斗神\r\n</li>\r\n<li>\r\n	在两名玩家的合作模式中，与好友一同探究《暗黑血统》那史诗般的世界\r\n</li>\r\n<li>\r\n	体验发生在初代《暗黑血统》之前的全新剧情战役，追寻七封印的起源\r\n</li>\r\n<li>\r\n	<span style=\"font-size:12.6316px;\">在收集物品、能力和武器强化器、生物核心等等时，实力和力量也会随之</span> \r\n</li>\r\n<li>\r\n</li>\r\n	</ul>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201102131818Bl.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	72,	14,	'2020-11-02 13:17:29',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(201,	'异星探险家 Astroneer',	1.00,	'<div font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; border: none; color: rgb(69, 69, 69);\">\r\n<div style=\"border:none;\">\r\n	<div style=\"border:none;\">\r\n		<h2 style=\"color:#313131;font-size:15px;\">\r\n			关于这款游戏\r\n		</h2>\r\n探索并重塑遥远的世界！《Astroneer》的故事发生在 25 世纪星际发现时代，Astroneer 探索着外太空边境，并冒着生命危险在恶劣的环境中发掘稀世珍宝，解开宇宙的奥秘。<br />\r\n在这次冒险中，玩家可以在地上或地下共同建造个性化基地，制造探索庞大太阳系的载具，以及利用地形创造他们能想象的任何东西。玩家的创造力和独创性，是在紧张刺激的行星冒险中探索和成功发展的关键！您可以在《Astroneer》内：<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/361420/extras/deform_(3).gif?t=1590519257\" /><br />\r\n像玩黏土一样，重塑您脚下的土地。<br />\r\n在《Astroneer》内，玩家可以使用变形工具挖掘、收集、塑造以及建造所想的任何事物。使用这种能力挖掘到行星的中心和建造一个通往星空的桥，或仅通过地形制作磐石！ <br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/361420/extras/planets.gif?t=1590519257\" /><br />\r\n在由精心制作、可以完全变形和遍历的行星上生存和探索。<br />\r\n我们庞大的太阳系包括 7 颗奇妙的行星，玩家可以在它们之间穿梭，并探索每一寸土地：从星球的整个地表，穿越一层层危险的洞穴，直达神秘的核心。每一颗行星都有其独特而富有挑战性的地面和洞穴生物群落，让玩家们能在旅程中体验众多挑战。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/361420/extras/bases.gif?t=1590519257\" /><br />\r\n将零部件和物体拼接在一起，建造基地和载具。<br />\r\nAstroneer 在世界中制造和寻找到的物品可以拼接在一起，以创造出独特物品来应对任何情况。自定义和装饰您的基地和载具，还有装扮你的 Astroneer。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/361420/extras/multiplayer.gif?t=1590519257\" /><br />\r\n与好友玩 4 名玩家在线加入/退出合作模式。 <br />\r\n与好友同乐，使《Astroneer》更好玩。与其他玩家组队，共同创造大规模工业基地，或在具有丰富创造性的沙盒中创造有趣游戏。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/361420/extras/chambers.gif?t=1590519257\" /><br />\r\n发现并揭开太阳系的奥秘。 <br />\r\n一旦 Astroneer 们准备好后，他们可以选择去尝试理解，甚至利用在世界中发现的神秘结构所蕴藏的力量。<br />\r\n《Astroneer》一开始是以一款抢先体验版游戏在 Steam 上架的，而我们今天的成功缺少不了大家的支持，和给予我们的反馈与意见。现在 1.0 版本已经发行了，而我们将信守诺言，以《Astroneer》为基础，持续发布免费的内容更新。如果您对我们为《Astroneer》所计划的发展方向感到好奇，请记得查看我们的开发路线图，以及我们不断发布的开发视频日志 ！\r\n	</div>\r\n</div>\r\n	</div>\r\n<div font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; border: none; color: rgb(69, 69, 69);\">\r\n	<div style=\"border:none;\">\r\n		<h2 style=\"color:#313131;font-size:15px;\">\r\n			系统需求\r\n		</h2>\r\n		<div style=\"border:none;\">\r\n			<div style=\"border:none;\">\r\n				<div style=\"border:none;\">\r\n					<ul>\r\n						最低配置:<br />\r\n						<ul>\r\n							<li>\r\n								需要 64 位处理器和操作系统<br />\r\n							</li>\r\n							<li>\r\n								操作系统:&nbsp;Windows 7 (仅限 64 位), Windows 8 (仅限 64 位), Windows 10 (仅限 64 位)<br />\r\n							</li>\r\n							<li>\r\n								处理器:&nbsp;X64 双核 CPU，2+ GHz<br />\r\n							</li>\r\n							<li>\r\n								内存:&nbsp;4 GB RAM<br />\r\n							</li>\r\n							<li>\r\n								显卡:&nbsp;1 GB 独显<br />\r\n							</li>\r\n							<li>\r\n								DirectX 版本:&nbsp;11<br />\r\n							</li>\r\n							<li>\r\n								存储空间:&nbsp;需要 2 GB 可用空间\r\n							</li>\r\n							<li>\r\n							</li>\r\n						</ul>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	56,	'https://fhdemo.s-cms.cn/t15/media/20201102132134UJ.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	57,	13,	'2020-11-02 13:19:13',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256742413/movie480.webm?t=1549606228',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(202,	'《只狼：影逝二度 Sekiro: Shadows Die Twice》',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《只狼：影逝二度 Sekiro: Shadows Die Twice》是一款单人动作冒险类游戏，一个名誉不再、伤痕累累的忍者，一个从死亡边缘捡回一命的战士。你效忠守护继承古老血统的年轻皇子，与危险的苇名一族以及众多凶恶之徒为敌。年轻的皇子被抓走后，为挽回荣誉，你将不畏死亡，踏上危机四伏的征程。探索生死冲突不断的16世纪后期，感受残酷的日本战国时代，在黑暗、扭曲的世界，与威胁生命的敌人对峙。活用义手装备各种致命武器，大显忍者身手，在血腥对抗中潜行、上下穿梭，与敌人正面激烈交锋。复仇雪耻。夺回荣誉。巧妙杀敌。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7 64-bit | Windows 8 64-bit | Windows 10 64-bit<br />\r\n处理器: Intel Core i3-2100 | AMD FX-6300<br />\r\n内存: 4 GB RAM<br />\r\n显卡: NVIDIA GeForce GTX 760 | AMD Radeon HD 7950<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 25 GB 可用空间\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	29,	'https://fhdemo.s-cms.cn/t15/media/2020110213255898.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	68,	5,	'2020-11-02 13:25:01',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256746284/movie480.webm?t=1553549450',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(203,	'进击的巨人2最终之战 ',	0.00,	'<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">《进击的巨人2：最终之战 Attack on Titan 2: Final Battle》是一款ACT动作游戏，是之前2018年推出的《进击的巨人2》的资料片，加入了第三季的一些新角色，现在可玩角色共计超过40个，并增加了原创的剧情章节和新武器“雷霆之矛”等等。\r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><br />\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">■收录电视动画第３期的剧情！<br />\r\n收录2019年4月（在日本）预定开始播放的最新剧情。<br />\r\n可操作原作中的要角，通过他们的视界体验故事。<br />\r\n■追加可操控角色！<br />\r\n肯尼、吉克、妮法、弗洛克、卡芬等，<br />\r\n于电视动画第３期活跃的主要成员参战！<br />\r\n■追加新装备「雷枪」！<br />\r\n可于关键场面使用的强力武器。<br />\r\n对于「盔甲巨人」等刀刃难以对付的敌人非常有效！<br />\r\n■追加新装备「对人立体机动装置」！<br />\r\n除了以立体机动来回飞翔的爽快感之外，<br />\r\n更可享受使用枪进行攻击的新感觉动作。<br />\r\n不仅是巨人，与人类之间的战斗亦将展开！<br />\r\n■追加新模式「墙外夺还模式」！<br />\r\n招揽喜爱的原作角色加入兵团，以夺还墙外领域为目标的模式。<br />\r\n可自由设定原作中不可能出现的角色组合！<br />\r\n提升角色之间的亲密度，或许会有游戏原创的对话事件等奖赏。\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: 64-bit Windows 7<br />\r\n处理器: Intel Core i3 3 Ghz<br />\r\n内存: 8 GB RAM<br />\r\n图形: NVIDIA GeForce 770 or AMD Radeon 7970 or equivalent DirectX 11 card<br />\r\nDirectX 版本: 11\r\n</p>\r\n<div>\r\n	<br />\r\n</div>\r\n<br />',	57,	'https://fhdemo.s-cms.cn/t15/media/20201102132807Ph.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	133,	31,	'2020-11-02 13:26:33',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(204,	' 仁王 中文版百度云全DLC',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《Nioh: Complete Edition / 仁王 Complete Edition》是一款黑暗风格的战国动作RPG以贼人嚣张跋扈，妖怪们四处蠢动的幽玄日本战国时代为舞台，并以史实人物「三浦按针」为蓝本创造出金发碧眼武士「威廉」，描写他历经几番死斗的故事。本作除了以战国时代末期的史实为基础，有着许多实际存在的战国武将登场，故事原创又深奥札实，也将是能够提供充分的紧张感与极高的成就感，足以称之为「战国殊死游戏」的作品。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows&reg; 10 64bit, Windows&reg; 8.1 64bit, Windows&reg; 7 64bit<br />\r\n处理器: Intel&reg; Core™ i5 3550<br />\r\n内存: 6 GB RAM<br />\r\n显卡: NVIDIA&reg; GeForce&reg; GTX 780 3GB 以上<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 80 GB 可用空间<br />\r\n声卡: 可播放16bit/48KHz wave格式的立体声\r\n</p>',	29,	'https://fhdemo.s-cms.cn/t15/media/202011021414231c.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	231,	48,	'2020-11-02 14:13:37',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256700250/movie480.webm?t=1509958335',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(205,	'怪物猎人世界 整合冰原DLC',	1.00,	'<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><strong>新的生命之地。狩猎, 就是本能! 在系列最新作品「Monster Hunter: World」中,玩家可以体验终极的狩猎生活,活用新建构的世界中各种各样的地形与生态环境享受狩猎的惊喜与兴奋。</strong> \r\n	</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><strong><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1118010/header.jpg?t=1594254718\" alt=\"\" style=\"height:auto;\" /><br />\r\n<img src=\"https://media.st.dl.eccdnx.com/steam/apps/582010/header.jpg?t=1582071559\" alt=\"\" style=\"height:auto;\" /><br />\r\n名称: MONSTER HUNTER: WORLD<br />\r\n类型: 动作<br />\r\n开发商: CAPCOM Co., Ltd.<br />\r\n发行商: CAPCOM Co., Ltd.<br />\r\n系列: Monster Hunter<br />\r\n发行日期: 2018年8月10日<br />\r\n名称: Monster Hunter World: Iceborne<br />\r\n类型: 动作<br />\r\n开发商: CAPCOM Co., Ltd.<br />\r\n发行商: CAPCOM Co., Ltd.<br />\r\n系列: Monster Hunter<br />\r\n发行日期: 2020年1月10日<br />\r\n最低配置:<br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: WINDOWS&reg; 7, 8, 8.1, 10 (必须为64-BIT)<br />\r\n处理器: Intel&reg; Core™ i5-4460, 3.20GHz 或 AMD FX™-6300以上<br />\r\n内存: 8 GB RAM<br />\r\n显卡: NVIDIA&reg; GeForce&reg; GTX 760 或 AMD Radeon™ R7 260x（VRAM 2GB以上)<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 100 GB 可用空间<br />\r\n声卡: 对应 DirectSound(DirectX&reg; 9.0c以上)<br />\r\n附注事项: 可在画面设置为「低」、1080p／30fps的情况下进行游戏。</strong> \r\n</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><strong>●超大型游戏内容扩展包“Monster Hunter World: Iceborne”<br />\r\n多样化的领域孕育出丰富的生态系统。<br />\r\n凭着猎食和争夺领士等本能而生存的怪物们。<br />\r\n利用所有高密度的环境来进行狩猎。<br />\r\n“Monster Hunter: World”的世界中建立的狩猎动作将在超大型游戏内容扩展包“Monster Hunter World: Iceborne”进一步得到扩展。<br />\r\n◆经深化的狩猎动作<br />\r\n为全部14种武器追加新连续技和新要素，使各武器更具特色，玩家可以享受到更多元化的动作。所有武器共通的新动作“抓牢”利用投射器的追加扩张功能“飞翔爪”，发射钩爪并紧抓怪物。攀在怪物身上时虽然会消耗耐力，但会限制怪物的行动，衍生出新的战斗方式。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1118010/extras/iceborne2.gif?t=1594254718\" alt=\"\" style=\"height:auto;\" /><br />\r\n◆超越上位的新任务等级“大师等级”登场！<br />\r\n除了“下位”与“上位”外，还新增了“大师等级”这一全新的任务等级。<br />\r\n只要购买超大型游戏内容扩展包“Monster Hunter World: Iceborne”，便能进行“大师等级”的任务。大师等级的任务中，新素材与比上位更棘手的怪物将等待玩家的挑战！<br />\r\n◆全新的舞台“永霜冻土”<br />\r\n不曾有人涉足的寒地上孕育出未知的生态系统。 “永霜冻土”是一片存在着个性丰富的环境生物和怪物的极寒之地。地形也呈现出这里的特征：厚得令人寸步难行的深雪、热气腾腾的温泉，以及随时有可能崩塌的不安定地面等等，拥有十分丰富的变化。 “Monster Hunter”系列至今的作品中最为细致的雪景亦是看点之一。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1118010/extras/iceborne1.gif?t=1594254718\" alt=\"\" style=\"height:auto;\" /></strong> \r\n	</p>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102141850l1.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	503,	108,	'2020-11-02 14:17:01',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(206,	'《超凡双生 Beyond：Two Souls》中文版免安装百度云',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《超凡双生 Beyond：Two Souls》是一款心理动作惊悚游戏，Jodie生来就与一名具有超凡力量的神秘存在缔结了联系，她的人生注定不凡。面对非凡的挑战、危险以及令人痛心的损失，您的选择将直接决定Jodie的命运，帮助她揭开自己身世的真相。您在扮演Jodie时所作出的选择和行动将创造出一个充实有趣的故事——这位生来就与一位叫做Aiden的超自然存在缔结联系的女孩，您将体验她的人生。通过扮演Jodie和Aiden，您将面对惊人的现实，受到精神上的挑战，从而理解那难以想象的……真相。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">在“进阶实验”中检验您的技术<br />\r\n在PlayStation™上发布的原始DLC任务也将包含在PC版本当中。整部游戏将拥有两个难度模式，以及单人或双人模式。<br />\r\n以您自己的方式游玩游戏剧情<br />\r\n电影顺序还是时间顺序？您可以选择自己想要的剧情体验方式，甚至可以在本地合作模式中与另一名玩家分别操作一个角色，一人操作Jodie而另一个人操作Aiden。您可以完全按照您想要的方式进行游玩。<br />\r\n对于PC端的全面优化<br />\r\n《超凡双生》在PC端上拥有惊人的画面效果，包括4K的分辨率、宽屏21：9适配以及60帧的帧率表现。\r\n	</p>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102142013Ec.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	99,	14,	'2020-11-02 14:19:39',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256784009/movie480_vp9.webm?t=1589294861',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(207,	'真三国无双合集876543',	1.00,	'<div class=\"game_page_autocollapse_ctn expanded\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse\">\r\n		<div class=\"game_area_description\" id=\"game_area_description\">\r\n			<h2 style=\"font-size:25px;\">\r\n				关于这款游戏\r\n			</h2>\r\n			<p>\r\n				以「新生。开放世界的一骑当千」为概念的系列最新作『真・三国无双８』隆重登场！\r\n			</p>\r\n			<p>\r\n				以一张幅员广阔的地图表现中国大陆的“开放世界”。除了维持一向轻松的操作感外，“新无双动作”更能以前所未有、万化自如的行动实现本系列以来最高等级的「一骑当千之爽快感」。再加上“众多的魅力武将”所交织成的宏伟「三国志」世界。融合了这些特点，可让玩家身临体验历史洪流的全新「真・三国无双」于此诞生！<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/730310/extras/%E3%82%B2%E3%83%BC%E3%83%A0%E3%81%AE%E6%B5%81%E3%82%8C5_%E6%B4%9B%E9%99%BD%E3%81%A7%E3%81%AE%E6%88%A6%E3%81%84.jpg?t=1570775406\" style=\"height:auto;\" /><br />\r\n在本作中，除了推动剧情主线发展的「主要任务」外，还有影响主要任务的「任务」，以及其他人给予的「委托」等，各式各样的任务在各地不断发生。根据玩家的选择，情况会不断的产生变化。此外，在中国各地发生的大小战役中，玩家可以使用各种攻略，如「正面突破」、「高处奇袭」、「夜间独自潜入」等，在辽阔的「三国志」世界中，一百个人可以有一百种玩法。<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/730310/extras/%E8%87%AA%E7%94%B1%E3%81%AA%E6%88%A6%E9%97%986_%E9%81%A0%E8%B7%9D%E9%9B%A2%E3%81%8B%E3%82%89%E3%81%AE%E6%94%BB%E6%92%8302_01_noUI.jpg?t=1570775406\" style=\"height:auto;\" /><br />\r\n此外，在广袤的中国大陆上，以精细美丽的画面呈现「雪原」、「丛林」、「沙漠」等多彩多姿的地域，还有即时变化的昼夜、天候等。重现了洛阳、虎牢关等主要都市与边关，也重现黄河、嵩山等地标。玩家可以体验到未曾有的代入感。<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/730310/extras/%E3%83%AA%E3%82%A2%E3%83%AB%E3%82%BF%E3%82%A4%E3%83%A0%E5%A4%89%E5%8C%963_%E5%A4%95%E6%96%B9.jpg?t=1570775406\" style=\"height:auto;\" /><br />\r\n本作保留了「无双」系列的轻松操作外，更有能因应周围状态而产生攻击变化的新招式「易态连击系统」。<br />\r\n主要由依照敌人状态变化的「流水攻击」，依据玩家与敌人间状况、时机所变化的「反应攻击」、使敌人状态发生变化的「触发攻击」等3种攻击方式为中心所构成，玩家能体验此系列最高等级的「一骑当千的爽快感」。<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/730310/extras/%E3%82%B9%E3%83%86%E3%83%BC%E3%83%88%E3%82%B3%E3%83%B3%E3%83%9C2-1_%E6%89%93%E4%B8%8A%E3%83%88%E3%83%AA%E3%82%AC%E3%83%BC00.jpg?t=1570775406\" style=\"height:auto;\" /><br />\r\n此外，本作也采用因应地形与环境产生不同行动的「应变动作」。除了基本的登山、游泳之外，还有「使用钩绳翻墙」、「用火焰箭引爆油壶攻击敌人」等，根据不同状况，玩家可以选择各式各样的行动，战略的选项也变得更加宽广。<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/730310/extras/%E9%89%A4%E7%B8%841_00_noUI.jpg?t=1570775406\" style=\"height:auto;\" /><br />\r\n辅佐孙家三代的吴国武将「程普」将参战！以既已发表参战的蜀国大力士、飞毛腿名将「周仓」为首，魅力十足的新武将们今后将陆续登场。<br />\r\n此外，在至今「真・三国无双」系列中登场的全83名无双武将的服装将会全新亮相，玩家能享受由众多武将所交织成的「三国志」世界。<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/730310/extras/%E7%A8%8B%E6%99%AE%E3%82%A2%E3%82%AF%E3%82%B7%E3%83%A7%E3%83%B3_01.jpg?t=1570775406\" style=\"height:auto;\" />\r\n			</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse sys_req\">\r\n		<h2 style=\"font-size:25px;\">\r\n			系统需求\r\n		</h2>\r\n		<div class=\"sysreq_contents\">\r\n			<div class=\"game_area_sys_req sysreq_content active\">\r\n				<div class=\"game_area_sys_req_leftCol\">\r\n					<h2>\r\n						最低配置:\r\n					</h2>\r\n					<ul>\r\n						<li>\r\n							<ul class=\"bb_ul\">\r\n								<li>\r\n									需要 64 位处理器和操作系统\r\n								</li>\r\n								<li>\r\n									操作系统: Windows 7/8.1/10 64bit\r\n								</li>\r\n								<li>\r\n									处理器: Core i5 2400 or over\r\n								</li>\r\n								<li>\r\n									内存: 6 GB RAM\r\n								</li>\r\n								<li>\r\n									显卡: NVIDIA GeForce GTX 660 or over\r\n								</li>\r\n								<li>\r\n									DirectX 版本: 11\r\n								</li>\r\n								<li>\r\n									网络: 宽带互联网连接\r\n								</li>\r\n								<li>\r\n									存储空间: 需要 50 GB 可用空间\r\n								</li>\r\n								<li>\r\n								</li>\r\n							</ul>\r\n						</li>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	29,	'https://fhdemo.s-cms.cn/t15/media/202011021423471k.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	18,	2,	'2020-11-02 14:22:56',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256768983/movie480.webm?t=1576123907',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(208,	'古墓丽影9中文版百度云迅雷下载容量22GB赠100%装备完成度通关存档|',	1.00,	'<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" microsoft=\"\" yahei\",=\"\" sans-serif;=\"\" color:=\"\" rgb(102,=\"\" 102,=\"\" 102);=\"\" font-size:=\"\" 13px;=\"\" white-space:=\"\" normal;=\"\" background-color:=\"\" rgb(255,=\"\" 255);=\"\" text-align:=\"\" justify;\"=\"\" style=\"margin-top: 0px; margin-bottom: 0px; font-size: 12.6316px; white-space: normal; list-style: none; padding: 20px 0px 0px; border: none;\">古墓丽影9 Tomb Raider》是一款第三人称视角的冒险游戏，探索了劳拉·克劳馥紧张又勇敢的起源故事，以及她从年轻女人变为坚强生存者的成长过程。&nbsp;单凭原始本能以及超越极限的人类耐力，劳拉必须奋力揭开被遗忘的岛屿的黑暗历史，以逃离小岛无情的控制。下载“转折点”预告片，观看劳拉史诗级的冒险的起源。\r\n	</p>\r\n	<div>\r\n		<br />\r\n	</div>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102142614lB.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	55,	12,	'2020-11-02 14:24:14',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256663321/movie480.webm?t=1461660154',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(209,	'罗马之子 中文版百度云',	1.00,	'<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏特色：</strong></span> \r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">完整的Ryse体验<br />\r\nPC版的“ Ryse：罗马之子”提供了完整的体验，将原始的Xbox One发行热销版及其所有DLC捆绑在一起。<br />\r\n充分利用PC<br />\r\n4K游戏是PC游戏玩家图形质量的又一次飞跃，Ryse是当今高端PC游戏中的完美展示。“ Ryse：罗马之子”利用了Crytek的CRYENGINE和最新的高端PC游戏技术的力量，展现了罗马帝国从未有过的冲突。<br />\r\n下一代电影般的沉浸感<br />\r\nMarius的复仇故事通过表演捕捉方面的新进展而栩栩如生，使玩家能够与真实逼真的角色进行互动<br />\r\n残酷的战斗<br />\r\n“ Ryse：罗马之子”通过史诗般的战斗提供了一种内在的，残酷的，逼真的战斗体验。当您与野蛮人进行原始近距离战斗时，重温古罗马的残酷历史。<br />\r\n斗兽场<br />\r\n斗兽场模式下的合作角斗士战斗，使您跳入竞技场，与好友一起对抗千变万化的敌人和挑战，这激怒了数千名观众。<br />\r\n动态的战场<br />\r\n罗马斗兽场模式包括26个多人游戏地图，其中包括从英军营地到罗马别墅和埃及沙漠的瓷砖。<br />\r\n打造自己的传奇<br />\r\n您可以决定自己的命运，使用新的盔甲，武器，盾牌和消耗品通过黄金和勇士（XP）定制角斗士，以赢得人群并在竞技场中生存。<br />\r\n额外奖励内容<br />\r\n“ Ryse：罗马之子”将附带所有最初作为Xbox One版本的可下载内容发布的额外奖励材料，包括：<br />\r\n•包含两个角色皮肤和两个竞技场地图的罗马斗兽场包。<br />\r\n•火星的选择包包含一个新角色皮肤，四张竞技场地图和新的生存模式。<br />\r\n•命运决斗包，内含两个角色皮肤，两个竞技场地图和一个其他生存地图。<br />\r\n•Morituri Pack，其中包含三张新的竞技场地图，两张生存地图和五张单独的竞技场地图。\r\n</p>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102142728vW.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	21,	7,	'2020-11-02 14:26:37',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/2034306/movie480.webm?t=1447363515',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(210,	'机甲战士5雇佣兵 ',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《机甲战士5：雇佣兵 MechWarrior 5：Mercenaries》是一款动作冒险类(ACT)游戏，3015年，人类已经殖民了一片广袤空间内的数千个星系，这片区域内战乱频仍，绵延数世纪之久。 主宰未来战场的是一群操纵着笨重战争机器的精英飞行员，他们号称机甲战士，而这种机器则被称作战斗机甲。 这正是雇佣兵发家致富的大好时机。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">满目疮庚的世界一驾驶数百种独特战斗机甲，荡平整座城市，消灭成群敌军。<br />\r\n探寻真相一雇佣兵公司在废墟的火焰中重生，担任雇佣兵领袖，为了荣耀和复仇追踪星际阴谋的线索。<br />\r\n佣兵生活一管理不断扩张的雇佣兵公司，处理千头万绪的运营事宜，从维护与获取战斗机甲，到雇佣新的机甲战士，事无巨细均需过问。<br />\r\n共同战斗一游玩4玩家PVE合作支援模式，和你的朋友一起战斗。<br />\r\n<span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置：</span></span><br />\r\n操作系统: Windows 7、Windows 8.1或Windows 10（64位版本）<br />\r\nCPU: Intel Core i3-7100或同等产品<br />\r\nGPU: NVIDIA GeForce GTX 770或同等产品<br />\r\n内存: 4GB<br />\r\nDirectX: 版本11<br />\r\nHDD: 80 GB剩余空间\r\n	</p>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102143133hH.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	39,	11,	'2020-11-02 14:28:18',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256714230/movie480.webm?t=1523984704',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(211,	'荒无人烟 DESOLATE',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《荒无人烟 DESOLATE》是一款第一人称的恐怖生存动作冒险游戏。和多达4名玩家组成研究团队，探索充满奥秘和未解之谜的开放世界，或者完全独自探索。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">黑暗的过去<br />\r\n探索充满了废弃定居点、军事基地和绝密设施的神秘岛屿。调查岛上的秘密 —— 从格兰尼契岛从前的定居者那里找到笔记和日记，揭开其神秘的历史。<br />\r\n研究威胁<br />\r\n在对抗怪物，掠夺者和士兵的公开战斗中为你的生命而战，或者使用潜行从阴影中造成暴击伤害。研究格兰尼契岛上的生物 —— 你对它们了解得更多，在战斗中就能获得优势。<br />\r\n变废为宝茁壮成长<br />\r\n加入由四名玩家组成的团队，这样可以使用独特的团队技能，例如复活倒下的队员，因此有更大的机会在危险中存活下来。或者你也可以做一个孤胆英雄，以证明你的勇气。<br />\r\n变废为宝茁壮成长<br />\r\n解锁新的技能并加以训练，以增加你的生存机会。收集配方和元件来制作、改造与升级你的武器和装备。在岛上的整个旅程中一路捡拾东西，用新的衣服和护甲自定义你的志愿者。<br />\r\n对抗疯狂（或者让它毁灭你)<br />\r\n你不仅要照顾好自己的身体状况，还要照顾好精神状态。格兰尼契岛的疯狂将会改变你周围的世界，也会改变你本身\r\n	</p>\r\n	<div>\r\n		<br />\r\n	</div>',	73,	'https://fhdemo.s-cms.cn/t15/media/20201102143602tJ.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	17,	5,	'2020-11-02 14:34:54',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256740702/movie480.webm?t=1547747045',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(212,	'《失落余烬 LOST EMBER》中文版百度云迅雷下载十一国语言',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《失落余烬 LOST EMBER》是一款动作冒险类游戏，一个令人叹为观止的美丽世界以及它背后的秘密等着你去揭开。随意附身于任何一个你遇到的动物，以从未有过的全新视角在失落余烬的世界中展开冒险。以狼为主角，与可靠的伴侣一起揭开一个关于忠诚、绝望和背叛而导致世界分崩离析的故事。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色:</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">你的精神伴侣-曾经是一个古老文明的一部分-现在引导你穿越一个由大自然重新创造的世界。在旅途中，你会发现你过去生活的记忆散落在这片土地上，这将有助于你理解曾经发生在你和你的同伴身上的事情。<br />\r\n你拥有附身于任何动物的能力，使你能够从不同的角度探索世界，寻找隐藏的秘密和地点，同时你会在冒险中经历一个文明的崛起、衰落，并在其中扮演重要角色。\r\n	</p>\r\n	<div>\r\n		<br />\r\n	</div>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102143728RG.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	35,	7,	'2020-11-02 14:36:38',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256767894/movie480.webm?t=1574759959',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(213,	'《恶魔狩猎 Devil\'s Hunt》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《恶魔狩猎 Devil’s Hunt》是一款第三人称动作游戏，天使与恶魔之间的战争使你勇闯地狱，杀进杀出。你将扮演德斯蒙德，拥有恶魔之力的关键之人。无论加入哪一方，他的选择都将决定我们世界的命运。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	沉浸于故事之中——扣人心弦的故事，改编自原创小说\r\n</li>\r\n<li>\r\n	欣赏剧情——近 100 个高质量的过场动画，时长超过 2 小时\r\n</li>\r\n<li>\r\n	改变形态——人类和恶魔都有实用的技能\r\n</li>\r\n<li>\r\n	如恶魔般战斗——攻击手段多样、连招丰富并且敌人种类繁多的第三人称搏杀\r\n</li>\r\n<li>\r\n	探索——丰富多样且联系紧密的环境互动\r\n</li>\r\n	</ul>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7 / 8.1 / 10<br />\r\n处理器: Intel i5 quad core<br />\r\n内存: 8 GB RAM<br />\r\n显卡: 2GB graphics card<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 15 GB 可用空间\r\n		</p>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102144041oG.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	119,	11,	'2020-11-02 14:40:02',	0,	1,	1,	'动作冒险',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256762261/movie480.webm?t=1568731934',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(214,	'《 暗黑地牢Darkest Dungeon》中文版百度下载祖灵版',	0.50,	'<h2 style=\"font-weight:normal;font-size:14px;color:#FFFFFF;font-family:\" background-color:#1b2838;\"=\"\">\r\n	关于这款游戏\r\n	</h2>\r\n<span style=\"color:#ACB2B8;font-family:\" font-size:14px;background-color:#1b2838;\"=\"\">《Darkest Dungeon》是一个极具挑战性的哥特式类 Rogue 回合制 RPG，聚焦冒险的心理压力。</span><br />\r\n<br />\r\n<span style=\"color:#ACB2B8;font-family:\" font-size:14px;background-color:#1b2838;\"=\"\">招募、训练和领导一队有缺点的英雄，穿行扭曲的森林、被遗忘的巢穴、毁坏的地窟等地。你不仅将与不可想象的敌人作战，而且还要面对压力、饥荒、疾病和不断侵蚀的黑暗。揭开奇怪的神秘事件，在创新的战略回合制战斗系统中，让英雄与一群可怕的怪物作战。</span><br />\r\n<br />\r\n<ul class=\"bb_ul\" style=\"color:#ACB2B8;font-family:\" font-size:14px;background-color:#1b2838;\"=\"\">\r\n	<li>\r\n		3 种游戏模式以及 80 小时以上的游戏时间<br />\r\n	</li>\r\n	<li>\r\n		Steam 创意工坊 mod 整合<br />\r\n	</li>\r\n	<li>\r\n		痛苦系统 — 不仅要与怪物战斗，还要与压力作战！与偏执狂、受虐狂、恐惧、非理性和许多和游戏有关的怪癖斗争！<br />\r\n	</li>\r\n	<li>\r\n		惊人的手绘哥特式钢笔画风格<br />\r\n	</li>\r\n	<li>\r\n		创新的基于回合制的战斗，让你与一大群的邪恶的怪物作战<br />\r\n	</li>\r\n	<li>\r\n		叙事系统，为你庆祝成功…也缅怀你的失败<br />\r\n	</li>\r\n	<li>\r\n		15 个（还在不断增加！）可玩的英雄职业，包括瘟疫医生、淘气鬼，甚至麻风病人！<br />\r\n	</li>\r\n	<li>\r\n		扎营以疗伤或进行动员演讲。<br />\r\n	</li>\r\n	<li>\r\n		在酒馆或修道院让你疲惫而惊恐的人物得到休息，以保持他们的压力不超过限度。<br />\r\n	</li>\r\n	<li>\r\n		经典 CRPG 和类 Rogue 功能，包括人物永久死亡、程序生成的地下城，还有惊人的重玩性\r\n	</li>\r\n		</ul>',	45,	'https://fhdemo.s-cms.cn/t15/media/202011021442458b.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	16,	3,	'2020-11-02 14:42:06',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256659907/movie480.webm?t=1453169044',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(215,	'巫师导演剪辑',	0.00,	'<h2 background-color:#ffffff;\"=\"\" style=\"white-space: normal; color: rgb(49, 49, 49); font-size: 15px;\">关于这款游戏\r\n	</h2>\r\n<span font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">角色扮演游戏《巫师》的故事发生在一个道德准绳模糊的黑暗奇幻世界。本作着眼于剧情和角色的发展。除了打破善恶的边界之外，游戏同时也糅合了强调战术深度的即时战斗系统。</span><br />\r\n<br />\r\n<span font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">您将扮演猎魔人利维亚的杰洛特。随着各方势力为了掌控世界争相逐鹿，交织的阴谋将您也卷入其中。玩家将会在这款游戏中做出艰难的抉择，接受的相应的后果，投身一段无与伦比的传奇。</span>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201102144647DP.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	37,	9,	'2020-11-02 14:44:06',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(216,	'《这是我的战争 This War Of Mine》中文版',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《我的战争 This War Of Mine》是一款ACT动作游戏，你扮演的不是精英士兵，而是一群在被围攻的城市中求存的平民。你们食物、药物紧缺，还得时刻防范狙击手和敌对的拾荒者。这款游戏从全新的角度让玩家体验身处战争的感受。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">核心特色：</span></span><br />\r\n• 游戏创作灵感源于现实<br />\r\n• 可控制幸存者以及经营藏身处<br />\r\n• 可制作武器、酒精、床铺、火炉等一切有助于你生存的东西。<br />\r\n• 往往需要在进退两难的情况下狠心做出决定。<br />\r\n• 每次开始新游戏时，都将随机生成世界与角色。<br />\r\n• 灰暗的画面风格与游戏主题相得益彰。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7/8/10<br />\r\n处理器: Intel(R) Core(TM)2 Duo 2.4, AMD Athlon(TM) X2 2.8 Ghz<br />\r\n内存: 2 GB RAM<br />\r\n显卡: Geforce 9600 GS, Radeon HD4000, Shader Model 3.0, 512 MB\r\n	</p>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201102144732mi.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	102,	50,	'2020-11-02 14:47:27',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(217,	'巨人约顿 Jotun Valhalla Edition',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《巨人约顿 Jotun Valhalla Edition》是一款基于北欧神话的手绘风格动作冒险游戏。在巨人约顿中，你将扮演托拉，一位死的毫无荣耀的维京战士，她必须再次向诸神证明自己以便能进入英灵殿。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">•体验手绘动画<br />\r\n•与5位史诗巨人，巨大的元素生物作战<br />\r\n•探索九个充满维京神话的浩瀚而神秘的层面<br />\r\n•在主线故事中了解托拉的一生和死亡<br />\r\n•召唤维京神祗赐予你力量<br />\r\n•听到纯正冰岛语音的旁白<br />\r\n•享受震撼的原声音乐\r\n	</p>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102144840Wg.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	36,	6,	'2020-11-02 14:48:04',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/2040043/movie480.webm?t=1447376268',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(218,	'星球大战绝地陨落的武士团 豪华版',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《星球大战绝地：陨落的武士团 Star Wars Jedi: Fallen Order》是一款由Respawn Entertainment出品的第三人称动作冒险游戏，一场贯穿整个银河系的冒险正在酝酿。一名被抛弃的绝地学徒必须完成他的修行，习得强大的新原力技能，纯熟掌握光剑的使用 – 同时还要步步抢在帝国的前面。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">电影质感的沉浸式战斗 –《绝地：陨落的武士团》的革新性光剑战斗系统让玩家真正化身为绝地武士 – 劈砍突刺，腾挪闪躲 – 还有一系列强大的原力技能，你要充分利用它们来克服前进道路上的各种障碍。直觉式的战斗系统可以迅速上手，但随着你在冒险过程中习得新的力量和技能，就要通过不断训练和实践才能完全掌握它们的精髓。<br />\r\n全新的绝地故事拉开序幕 – 身为一名躲避帝国追捕的前绝地学徒，你必须在帝国判官发现你复兴绝地武士团的计划之前完成自己的修行。协助你的是一位曾经的绝地武士、一位脾气暴躁的飞行员和一个无所畏惧的机器人，你们必须在跌宕起伏的冒险中逃过帝国的邪恶阴谋。大量丰富的战斗、探险和解谜挑战供玩家探索和解决。<br />\r\n银河系等待你的探索 – 古老的森林、风化的岩壁和鬼影幢幢的丛林，所有这些独特的生态环境都可以在《绝地：陨落的武士团》中随心所欲地游历。随着你不断解锁新的力量和技能，就能以新的方式回顾以前走过的地图；灵活运用原力来调整探索的方式。不过行动要迅速，因为帝国正在不遗余力地追捕你，企图消灭绝地武士团的所有幸存者。\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: 64-bit Windows 7/8.1/10<br />\r\n处理器: AMD FX-6100/Intel i3-3220 or Equivalent<br />\r\n内存: 8 GB RAM<br />\r\n显卡: AMD Radeon HD 7750, NVIDIA GeForce GTX 650 or Equivalent<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 55 GB 可用空间\r\n</p>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102145044xh.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	296,	59,	'2020-11-02 14:49:16',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256765709/movie480.webm?t=1572357561',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(219,	'《死亡日/致命时日 Deadly Days》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《死亡日 Deadly Days》是一款动作冒险类(ACT)游戏，管理和保护一群幸存者并帮助他们制止灾难。发现并使用大量疯狂和疯狂的物体，甚至更狂野和更疯狂的幸存者，特殊能力和致命武器。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	60个疯狂的物品，使每个游戏都独一无二，包括牙膏\r\n</li>\r\n<li>\r\n	30种强大的特殊能力，可以极大地改变战斗的结果\r\n</li>\r\n<li>\r\n	三种不同的专业，你可以激活新的能力，幸存者，物体和武器类型\r\n</li>\r\n<li>\r\n	随机生成修改的25种武器\r\n</li>\r\n<li>\r\n	程序生成的城市和任务\r\n</li>\r\n<li>\r\n	50名不同的幸存者，拥有50种不同的能力\r\n</li>\r\n<li>\r\n	超过10种不同类型的僵尸只想要一件事：大脑\r\n</li>\r\n<li>\r\n	还有三个老板必须在最后被击败\r\n</li>\r\n<li>\r\n	超过45项成就需要解锁\r\n</li>\r\n<li>\r\n	精心制作的像素艺术\r\n</li>\r\n<li>\r\n	综合抽搐功能 – 观众成为幸存者并决定接下来应该采取哪些任务\r\n</li>\r\n	</ul>',	29,	'https://fhdemo.s-cms.cn/t15/media/2020110214525073.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	24,	7,	'2020-11-02 14:52:46',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256762391/movie480.webm?t=1568884071',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(220,	'《嘎吱作响 Creaks》中文版百度云迅雷下载',	0.00,	'<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏介绍：</strong></span> \r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">《嘎吱作响 Creaks》是一款2D横版冒险游戏，这款游戏采用手绘风格的视觉效果、精美的动画、诡异的音效和 Hidden Orchestra 带来的热情洋溢的原创音乐。依照自己的步调小心翼翼地解开各种精心设计的谜题、探索豪宅中的隐藏画作并揭开所有秘密吧。\r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><a class=\"highslide-image\" href=\"https://s1.jiligame.com/images/2020/07/22/8f76da8898de5ffef2d9138331ad55a2.jpg\"></a> \r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>最低配置:</strong></span><br />\r\n操作系统: Windows 7 (64-bit) or better<br />\r\n处理器: 2 GHz Intel i5 or better<br />\r\n内存: 4 GB RAM<br />\r\n显卡: DirectX 11 compatible GPU<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 5 GB 可用空间<br />\r\n附注事项: Please note a 64-bit system is required to run the game.\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	73,	'https://fhdemo.s-cms.cn/t15/media/20201102150329na.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	19,	9,	'2020-11-02 14:53:21',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256791563/movie480_vp9.webm?t=1593693655',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(221,	'《超越钢铁苍穹 Beyond a Steel Sky》',	0.00,	'<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《超越钢铁苍穹 Beyond a Steel Sky》是一款激动人心且诙谐幽默的数字朋克惊悚游戏，设定在能够响应玩家操作（并因玩家操作而颠覆）的动态游戏世界中，以各种扣人心弦的谜题推动快节奏的剧情叙事。你的名字叫罗伯特·福斯特(Robert Foster)。有个孩子在一次野蛮袭击中遭到绑架。你发誓一定要带他回家。但脚下的路已经带着你从沙漠荒地居民社区来到了联合城，在这个饱经战火蹂躏和政治崩溃之苦的世界，联合城是最后仅存的几个超大城市之一。 城外筑有坚不可摧的防御工事，城内则是人民安居乐业的桃花源，由良善无害的人工智能进行监视和控制。但这一切远非看上去那么美好…\r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">游戏世界<br />\r\n动态世界中的精彩冒险，其中的角色经过有意的设计，受到各种动机的驱使，而玩家亦可颠覆这些动机。结合独特的黑客工具，玩家选择中会出现多种谜题解决方案。<br />\r\n游戏剧情<br />\r\n在这款激动人心且诙谐幽默的数字朋克惊悚游戏中，揭穿黑暗的阴谋，击败可怕的敌人，并探讨三大当代主题：社会控制、人工智能和全面监视。<br />\r\n游戏谜题<br />\r\n益智谜题与新奇有趣的戏剧性叙事相互交织，带来引人入胜的精彩游戏体验。<br />\r\n游戏外观<br />\r\n精美细腻的漫画书风格的世界，由传奇漫画艺术家Dave Gibbons构思设计。\r\n	</p>\r\n	<div>\r\n		<br />\r\n	</div>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201102151230Az.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	47,	8,	'2020-11-02 15:04:01',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256800205/movie480_vp9.webm?t=1601389191',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(222,	'爪子和灵魂 Paws and Soul',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《爪子和灵魂 Paws and Soul》是一款关于重生的冒险游戏，您将在其中以狼的形象参观一个神秘的森林。 人类生活的故事，你会看到通过捕食者的眼睛，补充了上瘾的游戏基于世界的研究和搜索对象。 找到关于你的过去生活的线索，解锁其他人的奖金故事，享受迷人的看法。 在这里，你是不是在任何危险，所以放松，让你的好奇心！ 找出如何狼和男人的命运，并揭示转世的秘密。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">-佛教的思想，重生和业的教义，这是情节的基础<br />\r\n-冥想：几个小时，你会忘记外面的世界，享受宁静和美丽的神奇森林<br />\r\n-人类生活的一个惊人的故事，所有的跌宕起伏和意想不到的结果<br />\r\n-伟大的配乐\r\n	</p>',	85,	'https://fhdemo.s-cms.cn/t15/media/20201102151658xO.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	23,	9,	'2020-11-02 15:15:46',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256799156/movie480_vp9.webm?t=1598858423',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(223,	'《监狱建筑师 Prison Architect》',	0.00,	'<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《监狱建筑师 Prison Architect》是一款模拟经营类(SIM)游戏，以有趣的方式将资本、建筑、管理和道德融为一体，将多个往往相互矛盾的目标摆在你面前：囚犯的安全、高效利用空间、囚犯的健康、盈利以及确保你的监狱绝对安全。建造一个支持这些目标的空间是一件令人着迷的事。\r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">建造并管理一座最高防备监狱。当清晨的阳光洒落在这片美丽的郊野之地，时钟开始发出滴答滴答的声音。你得抓紧时间努力建造拘留室，因为成批的最高防备囚犯正被黄色大巴车运送到你将建成的监狱。<br />\r\n当你的工人砌好拘留室的最后一块砖，你不能让他们有片刻休息，因为他们需要立刻开始建造第一间合适的牢房，来关押你即将接管的囚犯。一旦工人都有了各自休息的地方，有趣的事才真正开始。<br />\r\n你将需要建造食堂、医务室和保安室，噢，别忘了还要建厕所，否则将脏乱不堪。不过，要不要建一个锻炼场？或者单人禁闭室？或者死囚室？\r\n	</p>',	73,	'https://fhdemo.s-cms.cn/t15/media/20201102152102n3.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	43,	28,	'2020-11-02 15:17:30',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256657032/movie480.webm?t=1447378356',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(224,	'轩辕剑柒:数字豪华版-(官中）',	1.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	关于版本\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	《轩辕剑柒》将提供“数字标准版”和“数字豪华版”两个版本供玩家选购：数字标准版售价为99元，数字豪华版129元。其中数字豪华版除了包含游戏本体外，还会附赠《轩辕剑》艺术设定集，其中内含游戏的数字原声音乐专辑和数字美术设定集。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<img style=\"height:auto;\" alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steamcommunity/public/images/clans/37047233/04340296b4ef3f02709931c5b8dce9e88efb68ec.jpg\" /><br />\r\n<img style=\"height:auto;\" alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E8%BD%A9%E8%BE%95%E5%89%91%E6%9F%92%E9%A6%96%E5%8F%91%E7%89%B9%E5%85%B8%E5%86%85%E5%AE%B9%E4%B8%80%E8%A7%88_%E7%9B%B4%E7%B0%A1.jpg?t=1603918228\" /><br />\r\n《轩辕剑柒》是一款即时制角色扮演游戏，亦是经典RPG系列《轩辕剑》的最新单机作品。玩家将扮演遗孤太史昭，在动荡的西汉末年，为保护家人，踏上斩妖除魔、追寻真相之路。<br />\r\n故事背景<br />\r\n西汉末年，王莽代汉而立，国号为「新」。时年，石文现，石牛出，古墓开，各种符命与异兆纷呈。留侯墓出土了一片奇特的竹简，连夜送交太史令。没想到，当竹简送达以后，当夜竟离奇失火，太史令满门尽亡，竹简也不翼而飞。<br />\r\n十年过去了，符命与异兆所预言的太平盛世并没有到来。连年天灾人祸导致民不聊生，百姓苦不堪言，各地纷纷揭竿而起。就在此时，消失十年的竹简再度出现了，掀起一阵波澜……<br />\r\n游戏特色<br />\r\n战斗系统全面革新<br />\r\n《轩辕剑柒》将采用动作性更强的即时制战斗模式。<br />\r\n连招、武技、闪避、格挡、反击等战斗要素一应俱全，带来更为畅快的战斗体验。<br />\r\n<img style=\"height:auto;\" alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E7%99%BE%E9%AC%BC%E5%A4%9C%E8%A1%8C.gif?t=1602038453\" /><br />\r\n不一样的天书系统<br />\r\n系列经典元素「天书」正式回归，并在太史昭的冒险历程中提供多种机能：<br />\r\n「天书之力」——战斗中可以发动，短时间内大幅提升角色能力。<br />\r\n「收妖」「炼化」——玩家可借助天书之力收伏妖魔，作为炼化的素材；炼化不仅会产生新的妖魔，更有概率生成御魂，强化太史昭自身能力。<br />\r\n「神兵」「天衣」「机关」「聚灵」——多种设施齐聚天书世界，提供武器强化、防具打造、饰品制作、御魂培养等不同功效。<br />\r\n<img style=\"height:auto;\" alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E6%A2%BC%E6%9D%8C1.gif?t=1602038453\" /><br />\r\n机关科技再现，墨家重返舞台<br />\r\n《轩辕剑肆》之后，墨家机关术再度登上舞台。<br />\r\n曾一度与儒家比肩的显学——墨家，经历西汉后更趋衰落。派系分歧愈演愈烈，传承已久的信仰再次受到挑战。墨家会在乱世中彻底分崩离析，还是重新走向振兴之路？将由玩家亲自见证。<br />\r\n<img style=\"height:auto;\" alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E6%94%B6%E5%A6%96.gif?t=1602038453\" /><br />\r\n虚幻4打造 再现乱世百态<br />\r\n《轩辕剑柒》采用全新引擎打造，整体画质相比历代作品将有质的飞跃，带领玩家进入西汉末年的中原大地。<br />\r\nPC版还将支持NVIDIA的光线追踪技术，让场景更加真实。<br />\r\n<img style=\"height:auto;\" alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E7%9C%BA%E6%9C%9B%E9%95%BF%E5%AE%89.gif?t=1602038453\" /><br />\r\n全新动捕技术 演出规格提升<br />\r\n引入全新动作捕捉系统。<br />\r\n<img style=\"height:auto;\" alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E5%87%9D%E8%A7%86.gif?t=1602038453\" /><br />\r\n运用多元化的演出手段，演出效果及人物刻画更上一层楼。\r\n</p>\r\n<p style=\"font-size:12.63px;\">\r\n	丰富的人物神情，流畅的角色动作，让游戏故事更加生动。\r\n</p>\r\n<p style=\"font-size:12.63px;\">\r\n	声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。 <br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。 <br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！ <br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。 <br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102152620QR.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	12,	2,	'2020-11-02 15:21:41',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256798341/movie480_vp9.webm?t=1598372090',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(225,	'Skul：英雄杀手 Skul: The Hero Slayer',	0.00,	'<div font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; border: none; color: rgb(69, 69, 69);\">\r\n<div style=\"border:none;\">\r\n	<div style=\"border:none;\">\r\n		<h2 style=\"color:#313131;font-size:15px;\">\r\n			关于这款游戏\r\n		</h2>\r\n<a href=\"https://steamcommunity.com/linkfilter/?url=https://discordapp.com/invite/RQf6kBK\" target=\"_blank\"><img src=\"https://steamcdn-a.akamaihd.net/steam/apps/1147560/extras/Discord_skul.png?t=1598954475\" /></a><br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/1147560/extras/DemonCastle_Destroyed_W620.gif?t=1598954475\" /> \r\n		<h2 style=\"color:#313131;font-size:15px;\">\r\n			背景\r\n		</h2>\r\n与之前一样，人类再次袭击魔王城，但这次与之前不同，冒险者们决定与帝国军“卡利恩”联手发动全面进攻，以压倒性的攻击彻底摧毁魔王城，攻陷的一干二净。<br />\r\n包括魔王的所有魔王城的魔族被人类抓走，而王座附近只剩下小骷髅的骨头。<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/1147560/extras/Combat.gif?t=1598954475\" /> \r\n		<h2 style=\"color:#313131;font-size:15px;\">\r\n			横版动作游戏\r\n		</h2>\r\nSkul：The Hero Slayer是平台动作游戏，具备每次游戏时都会变化的地图和奖励系统、游戏结束时要重新开始等Rogue-lite的特点。<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/1147560/extras/SwapSkull_W620.gif?t=1598954475\" /> \r\n		<h2 style=\"color:#313131;font-size:15px;\">\r\n			通过多种Skul更换角色\r\n		</h2>\r\nSkul是一个特殊的小骷髅，他可以穿戴其他Skul（头骨）获得新的力量。每一个骷髅都有固有的组合和技能，其特性都不同，可以选择适合自己风格的战斗。<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/1147560/extras/Adventurers.gif?t=1598954475\" /> \r\n		<h2 style=\"color:#313131;font-size:15px;\">\r\n			冒险家\r\n		</h2>\r\n如果遇到了冒险家派对，请大家小心！他们是一群渴望狩猎你而成名的贪婪的勇士。《你还是劝告我加入派对比较好...谁会被猎杀要比一比才会知道的！》<br />\r\n<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/1147560/extras/Boss.gif?t=1598954475\" /> \r\n		<h2 style=\"color:#313131;font-size:15px;\">\r\n			被侵蚀在黑魔石上的可怕的Boss\r\n		</h2>\r\n每个章节的最后一关，可以见到被黑魔石侵蚀的强力的敌人。黑魔石是在生命的痛苦和憎恨中提取的石头，具有强烈的魔力，但几乎没有人可以熟练的改变这个石头。\r\n	</div>\r\n</div>\r\n	</div>\r\n<div font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; border: none; color: rgb(69, 69, 69);\">\r\n	<div style=\"border:none;\">\r\n		<h2 style=\"color:#313131;font-size:15px;\">\r\n			系统需求\r\n		</h2>\r\n		<div style=\"border:none;\">\r\n			<div style=\"border:none;\">\r\n				Windows\r\n			</div>\r\n			<div style=\"border:none;\">\r\n				Mac OS X\r\n			</div>\r\n			<div style=\"border:none;\">\r\n				SteamOS + Linux\r\n			</div>\r\n			<div style=\"border:none;\">\r\n			</div>\r\n		</div>\r\n		<div style=\"border:none;\">\r\n			<div style=\"border:none;\">\r\n				<div style=\"border:none;\">\r\n					<ul>\r\n						最低配置:<br />\r\n						<ul>\r\n							<li>\r\n								操作系统:&nbsp;Windows 7+<br />\r\n							</li>\r\n							<li>\r\n								处理器:&nbsp;Intel i5+<br />\r\n							</li>\r\n							<li>\r\n								内存:&nbsp;4 GB RAM<br />\r\n							</li>\r\n							<li>\r\n								显卡:&nbsp;Nvidia 450 GTS / Radeon HD 5750 or better<br />\r\n							</li>\r\n							<li>\r\n								存储空间:&nbsp;需要 500 MB 可用空间<br />\r\n							</li>\r\n							<li>\r\n								附注事项:&nbsp;DirectX 9.1+ or OpenGL 3.2+\r\n							</li>\r\n						</ul>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102153259uI.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	69,	14,	'2020-11-02 15:28:48',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256786021/movie480_vp9.webm?t=1589958808',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(226,	'奥日与鬼火意志 ',	1.00,	'<div class=\"game_page_autocollapse_ctn\" style=\"padding:0px;margin:0px;color:#ACB2B8;font-family:Arial, Helvetica, sans-serif;font-size:14px;background-color:#1B2838;\">\r\n	<div class=\"game_page_autocollapse\" style=\"padding:0px;margin:0px;\">\r\n		<div id=\"game_area_description\" class=\"game_area_description\" style=\"padding:0px;margin:30px 0px 0px;font-family:;\">\r\n			小精灵奥里对危险并不陌生，但当小猫头鹰库在宿命般的一次飞翔中受到了伤害，重聚家庭、重塑破碎的世界和探索奥里真正的命运就不能只靠勇气。本作是广受好评的动作类平台游戏<a href=\"https://store.steampowered.com/app/387290/Ori_and_the_Blind_Forest_Definitive_Edition/\" target=\"_blank\">《精灵与森林》</a>的续篇，由原班制作团队倾心打造，备受期待。投身满是新朋友和敌人的广大世界，享受令人惊艳的手绘画面，踏上全新的冒险之旅。除了契合游戏的原创音乐之外，《精灵与萤火意志》也延续了 Moon Studios 的风格：精心制作的平台动作游戏和深情的叙事手法。\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"padding:0px;margin:0px;color:#ACB2B8;font-family:Arial, Helvetica, sans-serif;font-size:14px;background-color:#1B2838;\">\r\n	<div class=\"game_page_autocollapse sys_req\" style=\"padding:0px;margin:30px 0px 0px;\">\r\n		<h2 style=\"font-weight:normal;font-size:14px;color:#FFFFFF;font-family:;\">\r\n			系统需求\r\n		</h2>\r\n		<div class=\"sysreq_contents\" style=\"padding:0px;margin:10px 0px 0px;\">\r\n			<div class=\"game_area_sys_req sysreq_content active\" style=\"padding:0px;margin:0px;font-size:12px;font-family:;\">\r\n				<div class=\"game_area_sys_req_leftCol\" style=\"padding:0px;margin:0px;\">\r\n					<ul>\r\n						<span style=\"font-family:Arial, Helvetica, sans-serif;font-size:10px;color:#BCC6CD;\">最低配置:</span><br />\r\n						<ul class=\"bb_ul\">\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">操作系统:</span> Windows 10 Version 18362.0 or higher<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">处理器:</span> AMD Athlon X4 | Intel Core i5 4460<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">内存:</span> 8 GB RAM<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">显卡:</span> Nvidia GTX 950 | AMD R7 370<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">DirectX 版本:</span> 11<br />\r\n							</li>\r\n							<li>\r\n								<span style=\"font-family:Arial, Helvetica, sans-serif;color:#61686D;\">存储空间:</span> 需要 20 GB 可用空间\r\n							</li>\r\n						</ul>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	55,	'https://fhdemo.s-cms.cn/t15/media/202011021536258F.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	33,	7,	'2020-11-02 15:33:15',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256779902/movie480.webm?t=1585866497',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(227,	'《怒之铁拳4 Street of Rage 4》中文版',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《怒之铁拳4 Street of Rage 4》是一款是经典清版动作游戏《怒之铁拳》系列的最新作，该系列作品以不会过时的游戏机制与电子舞曲风的背景音乐而好评连连。4代在经典的游戏方式上，加入了新的游戏机制、精致的手绘特效与大师级音乐团队所创作的背景音乐。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p class=\"bb_tag\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">● 《怒之铁拳》系列最新力作！经典重现，热血沸腾！<br />\r\n● 畅快淋漓的全手绘特效，由Wonder Boy: The Dragon’s Trap背后的工作室倾心打造！<br />\r\n● 首次添加线上多人模式！玩家可以单打独斗清理橡木城，更能呼朋唤友，助你一臂之力！<br />\r\n● 线下多人模式最多支持4个玩家。并肩作战，夺回城镇吧！<br />\r\n● 令人怀念的经典玩法与崭新机制的激烈碰撞！<br />\r\n● 动人心弦的背景音乐，世界级全明星谱曲阵容！<br />\r\n● 不用担心，系列粉丝们津津乐道的烤鸡也将盛势回归！\r\n	</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102153929b6.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	48,	11,	'2020-11-02 15:37:55',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256783873/movie480_vp9.webm?t=1588284716',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(228,	'《红怪 CARRION》中文版百度云',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《红怪&nbsp;<span style=\"font-size:12.6316px;\">CARRION</span><span style=\"font-size:12.6316px;\">》是一款逆转恐怖游戏，玩家将一反常态，扮演一只无固定形态、不明来源的触手生物。通过跟踪、吞噬将你困于囚笼的人，你可以将恐惧和慌乱传播到这座监狱的每处角落。而随着你一步步拆毁这座监狱，你也将掌握越来越强的技能，不断生长、不断进化，最终得以伸张心中正义。</span>\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7 SP1<br />\r\n处理器: 2 core processor<br />\r\n内存: 1024 MB RAM<br />\r\n显卡: compatible with OpenGL 3.0<br />\r\n存储空间: 需要 500 MB 可用空间\r\n</p>',	46,	'https://fhdemo.s-cms.cn/t15/media/20201102154245RS.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	26,	11,	'2020-11-02 15:39:59',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256793612/movie480_vp9.webm?t=1595426760',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(229,	'空洞骑士 Hollow Knight',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《空洞骑士 Hollow Knight》是一款高分好评的2D动作冒险类游戏，穿越一个庞大却废弃的属于昆虫与英雄的王国，开启史诗般的冒险旅程。探索幽深的洞穴，与被感染的生物战斗，结识友好又奇异的昆虫，整个游戏都是经典的手绘 2D 风格。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	经典的横版卷轴游戏关卡，并拥有新时代的游戏特色。\r\n</li>\r\n<li>\r\n	连贯紧凑的 2D 操控：躲避攻击，向前冲刺，并使用骨钉技艺击败致命的敌人。\r\n</li>\r\n<li>\r\n	探索交错相通的庞大世界，在遗忘的山道、杂草丛生的荒地和废弃的城市之间穿梭。\r\n</li>\r\n<li>\r\n	打造属于自己的冒险之旅！圣巢是广阔、开放的世界，你可以自由选择前进的道路和面对的敌人。\r\n</li>\r\n<li>\r\n	不断获得新的技能！学习法术、提升力量和速度，用轻薄的羽翼跳出新高度，在风驰云卷中向前冲刺，还能向敌人发射威力十足的灵魂冲击波！\r\n</li>\r\n<li>\r\n	装备强大的护符！这些古老的宝物能使你具备独特的能力。选择自己钟爱的护符，让你的旅途独一无二！\r\n</li>\r\n<li>\r\n	2D 逐帧动画给数不胜数的可爱又颇具攻击性的角色赋予了生机。\r\n</li>\r\n<li>\r\n	超过 130 种敌人！30 个史诗级 Boss！在旅途中直面凶猛的怪物，并征服古老的骑士。将每一种独特生物的踪迹记录在你的猎人日志之中。\r\n</li>\r\n<li>\r\n	使用梦之钉进入他人的思想，揭开你遇到的角色和敌人心中不为人知的另一面。\r\n</li>\r\n<li>\r\n	如画的风景、华丽的视觉盛宴为游戏世界带来独特的层次感。\r\n</li>\r\n<li>\r\n	使用各种导航工具为你的旅途绘制图景。购买指南针、鹅毛笔、地图、图针等物品，增加你对《空洞骑士》中曲折的世界地形的理解。\r\n</li>\r\n<li>\r\n	游戏全程配有优美的背景音乐，由克里斯托弗·拉金创作。背景音乐衬托出王国的宏伟，同时也奏出失落文明的凄婉。\r\n</li>\r\n<li>\r\n	完成《空洞骑士》后，可以解锁终极挑战：钢铁之魂模式！\r\n</li>\r\n<li>\r\n</li>\r\n	</ul>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102154425ms.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	173,	43,	'2020-11-02 15:43:53',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256679401/movie480.webm?t=1497589417',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(230,	'热血外传好酷啊！小林',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《热血外传：好酷啊！小林 STAY COOL, KOBAYASHI-SAN!: A RIVER CITY RANSOM 》是一款像素动作冒险游戏，「市中心热血物语」之后的故事…… 成为骚乱舞台的「冷峰学园」里，存在着周围高中生害怕的「冷峰四天王」。 其顶点，也是作为头目高高在上的男人，小林政男。 他还有另外一面。 小林在中学时因为遭遇「某些事件」的关系，遇见了一个青年，沟口。 事实上，沟口是来自未来的「时间管理官」， 正在追逐扰乱这个时空秩序的「邪恶组织」。 沟口发现小林体内有「某种力量」的片断， 两人消灭「邪恶组织」而一起行动。 有一天，小林的朋友被「邪恶组织」诱拐了。 虽然看似平静的小林，但他的内心正燃烧着愤怒之火。 为了救出朋友以及消灭组织，小林要对抗「邪恶组织」！！\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">集结原班人马！<br />\r\n「热血硬派国夫君」的Yoshihisa Kishimoto与<br />\r\n「市中心热血物语」的MOQEQE SEKIMOTO<br />\r\n集合制作出的喧闹动作！<br />\r\n唤起回忆，搞笑的像素图！<br />\r\n说到「国夫君」那就是像素图！<br />\r\n让人想念的可爱外形!<br />\r\n20种多重结局！<br />\r\n根据游戏中的行为分成多种结局。<br />\r\n到底，能够完成所有结局吗？！<br />\r\n收集「★」提升能力！<br />\r\n使用游戏中得到的「★」<br />\r\n可以强化角色或获取装备物品。<br />\r\n收集所有「★」成为最强！<br />\r\n不管怎样就是说！<br />\r\n这部作品中所有的角色都会喋喋不休地述说故事！<br />\r\n在游戏中，玩家还可以观看到各种不同的台词！\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7 Professional 64-bit<br />\r\n处理器: Intel(R) Core(TM) i5-4570S CPU @ 2.90GHz (4 CPUs), ~2.9GHz<br />\r\n内存: 8 GB RAM<br />\r\n显卡: NVIDIA GeForce GTX 750 Ti<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 1 GB 可用空间\r\n</p>',	46,	'https://fhdemo.s-cms.cn/t15/media/202011021546002g.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	28,	7,	'2020-11-02 15:44:59',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256764300/movie480.webm?t=1573089343',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(231,	'《细胞迷途 MO: Astray》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《细胞迷途 MO: Astray》是一款像素风格的横向动作解谜游戏，拥有特殊能力的主角MO将藉由跳跃、黏着和各种特异能力，在怪异混沌的敌人和陷阱环伺之下，突破充满巧思的关卡谜题设计。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色 ：</span></span><br />\r\n-前所未见的移动方式和能力，除了黏着、冲撞和寄生等基本动作，还可以读取记忆，揭开更多故事背景！<br />\r\n-细致的像素画风和流畅的动作，充满异星科幻氛围的景色和优美逼真的音乐音效。<br />\r\n-想尽办法在致命的机关中找到出口，等待、观察、规划路线，善用自己的特殊能力。<br />\r\n-不要以为果冻状的生物就好欺负！险恶的环境善加利用，也能成为帮助自己的最大优势。<br />\r\n-搜集要素，解锁更多剧情，拼凑出事件的真相。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7<br />\r\n处理器: Intel Core i5-6200 CPU @ 2.3GHz<br />\r\n内存: 8 GB RAM<br />\r\n显卡: Intel HD Graphics 520<br />\r\nDirectX 版本: 9.0c<br />\r\n存储空间: 需要 10 GB 可用空间\r\n	</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/2020110215472579.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	54,	18,	'2020-11-02 15:46:50',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256766611/movie480.webm?t=1573177498',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(232,	'《瓦尔法瑞斯 Valfaris》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《瓦尔法瑞斯 Valfaris》是一款以太空中一个偏远角落被背景的重金属2D平台动作游戏，其制作团队的上一款作品正是在Unity Awards上获过奖的《Slain:Back From Hell》。残酷的战斗。可怕的敌人。绝美的像素画面。充满野性的原声音乐。准备把星系闹个底朝天吧。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	太空骷髅！太空暴力！太空金属！\r\n</li>\r\n<li>\r\n	用一系列残酷的武器无情地将敌人轰杀至渣\r\n</li>\r\n<li>\r\n	深入Valfaris的黑暗世界，探索风格迥异的污垢之境。\r\n</li>\r\n<li>\r\n	歼灭成群奇形怪状的可怕敌人和首领\r\n</li>\r\n<li>\r\n	由Andrew Gilmour手工打造的绝美像素画面将令你大饱眼福\r\n</li>\r\n<li>\r\n	感受重金属原声音乐震撼人心的力量，演奏者是在Celtic Frost乐队当过吉他手的Curt Victor Bryant\r\n</li>\r\n<li>\r\n	本游戏由制作了知名游戏《Slain: Back From Hell》的团队一手打造\r\n</li>\r\n	</ul>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows XP, Vista, 7 or 8<br />\r\n处理器: 1.5 Ghz or faster<br />\r\n内存: 1 GB RAM<br />\r\n存储空间: 需要 500 MB 可用空间\r\n		</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102154905qw.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	50,	10,	'2020-11-02 15:48:18',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256769075/movie480.webm?t=1575740185',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(233,	'《瓦尔法瑞斯 Valfaris》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《瓦尔法瑞斯 Valfaris》是一款以太空中一个偏远角落被背景的重金属2D平台动作游戏，其制作团队的上一款作品正是在Unity Awards上获过奖的《Slain:Back From Hell》。残酷的战斗。可怕的敌人。绝美的像素画面。充满野性的原声音乐。准备把星系闹个底朝天吧。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span>\r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	太空骷髅！太空暴力！太空金属！\r\n</li>\r\n<li>\r\n	用一系列残酷的武器无情地将敌人轰杀至渣\r\n</li>\r\n<li>\r\n	深入Valfaris的黑暗世界，探索风格迥异的污垢之境。\r\n</li>\r\n<li>\r\n	歼灭成群奇形怪状的可怕敌人和首领\r\n</li>\r\n<li>\r\n	由Andrew Gilmour手工打造的绝美像素画面将令你大饱眼福\r\n</li>\r\n<li>\r\n	感受重金属原声音乐震撼人心的力量，演奏者是在Celtic Frost乐队当过吉他手的Curt Victor Bryant\r\n</li>\r\n<li>\r\n	本游戏由制作了知名游戏《Slain: Back From Hell》的团队一手打造\r\n</li>\r\n	</ul>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows XP, Vista, 7 or 8<br />\r\n处理器: 1.5 Ghz or faster<br />\r\n内存: 1 GB RAM<br />\r\n存储空间: 需要 500 MB 可用空间\r\n		</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102154905qw.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	0,	0,	'2020-11-02 15:48:18',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256769075/movie480.webm?t=1575740185',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(234,	'《瓦尔法瑞斯 Valfaris》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《瓦尔法瑞斯 Valfaris》是一款以太空中一个偏远角落被背景的重金属2D平台动作游戏，其制作团队的上一款作品正是在Unity Awards上获过奖的《Slain:Back From Hell》。残酷的战斗。可怕的敌人。绝美的像素画面。充满野性的原声音乐。准备把星系闹个底朝天吧。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span>\r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	太空骷髅！太空暴力！太空金属！\r\n</li>\r\n<li>\r\n	用一系列残酷的武器无情地将敌人轰杀至渣\r\n</li>\r\n<li>\r\n	深入Valfaris的黑暗世界，探索风格迥异的污垢之境。\r\n</li>\r\n<li>\r\n	歼灭成群奇形怪状的可怕敌人和首领\r\n</li>\r\n<li>\r\n	由Andrew Gilmour手工打造的绝美像素画面将令你大饱眼福\r\n</li>\r\n<li>\r\n	感受重金属原声音乐震撼人心的力量，演奏者是在Celtic Frost乐队当过吉他手的Curt Victor Bryant\r\n</li>\r\n<li>\r\n	本游戏由制作了知名游戏《Slain: Back From Hell》的团队一手打造\r\n</li>\r\n	</ul>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows XP, Vista, 7 or 8<br />\r\n处理器: 1.5 Ghz or faster<br />\r\n内存: 1 GB RAM<br />\r\n存储空间: 需要 500 MB 可用空间\r\n		</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102154905qw.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	0,	0,	'2020-11-02 15:48:18',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256769075/movie480.webm?t=1575740185',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(235,	'《瓦尔法瑞斯 Valfaris》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《瓦尔法瑞斯 Valfaris》是一款以太空中一个偏远角落被背景的重金属2D平台动作游戏，其制作团队的上一款作品正是在Unity Awards上获过奖的《Slain:Back From Hell》。残酷的战斗。可怕的敌人。绝美的像素画面。充满野性的原声音乐。准备把星系闹个底朝天吧。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span>\r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	太空骷髅！太空暴力！太空金属！\r\n</li>\r\n<li>\r\n	用一系列残酷的武器无情地将敌人轰杀至渣\r\n</li>\r\n<li>\r\n	深入Valfaris的黑暗世界，探索风格迥异的污垢之境。\r\n</li>\r\n<li>\r\n	歼灭成群奇形怪状的可怕敌人和首领\r\n</li>\r\n<li>\r\n	由Andrew Gilmour手工打造的绝美像素画面将令你大饱眼福\r\n</li>\r\n<li>\r\n	感受重金属原声音乐震撼人心的力量，演奏者是在Celtic Frost乐队当过吉他手的Curt Victor Bryant\r\n</li>\r\n<li>\r\n	本游戏由制作了知名游戏《Slain: Back From Hell》的团队一手打造\r\n</li>\r\n	</ul>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows XP, Vista, 7 or 8<br />\r\n处理器: 1.5 Ghz or faster<br />\r\n内存: 1 GB RAM<br />\r\n存储空间: 需要 500 MB 可用空间\r\n		</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102154905qw.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	0,	0,	'2020-11-02 15:48:18',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256769075/movie480.webm?t=1575740185',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(236,	'霓虹深渊 Neon Abyss',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《霓虹深渊 Neon Abyss》是一款注重道具迭加效果的横版动作地牢游戏，你还可以根据喜好自由选择地牢的进化路线。身为神秘组织的一员，你将在霓虹闪耀的地下世界中探险，收集千奇百怪的道具，击败恶魔与众神，寻找地牢最深处的宝藏。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span>\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">海量内容<br />\r\n动态生成的地图，超过400种道具，数十种武器，几十种风格迥异的怪物，数不尽的彩蛋和秘密，让每一次冒险都充满了新鲜感。<br />\r\n宠物孵化<br />\r\n在游戏中你将获得宠物蛋，可以孵化出随机的精灵。每一只精灵都有着独特的能力，并可以多次进化。<br />\r\n迷你游戏<br />\r\n游戏中有很多特别的房间，每一个都有全新的规则和玩法。钢琴演奏，斗舞比赛，月球漫步，湖边垂钓，应有尽有。<br />\r\n霓虹神话<br />\r\n药物之神，比特币之神，短视频之神。当今最流行的事物都化身为新的统治者，而你就是那个打破枷锁的人！\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7<br />\r\n处理器: Intel Core 2 Duo E6320 (2*1866)<br />\r\n内存: 2 GB RAM<br />\r\n显卡: GeForce 7600 GS (512 MB)<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 1024 MB 可用空间\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">说明：winRAR解压，安装游戏记得全英文路径，关杀毒软件哦。</span></span>\r\n</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102160522gR.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	34,	10,	'2020-11-02 16:02:05',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256792681/movie480_vp9.webm?t=1594714622',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(237,	'斩妖行',	1.00,	'<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">斩妖行》是一款2D横版动作类游戏，你将在战火不断，世间魑魅魍魉横行作乱的世界中，化身为“斩妖人”一路斩妖前行，体味凶残的妖魔与人类难填的欲壑无尽的纠葛，一幕幕的众生百态。\r\n	</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><br />\r\n</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">名称: 斩妖行<br />\r\n类型: 动作, 冒险, 角色扮演, 抢先体验<br />\r\n开发商: Wildfire Game（无锡野火数字科技有限公司）<br />\r\n发行商: bilibili<br />\r\n发行日期: 2020年8月14日<br />\r\n最低配置:<br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7/8/10 64位<br />\r\n处理器: Intel i3+<br />\r\n内存: 4 GB RAM<br />\r\n显卡: Nvidia GeForce GTS 450<br />\r\nDirectX 版本: 10<br />\r\n存储空间: 需要 8 GB 可用空间<br />\r\n声卡: 100% DirectX 9.0c compatible sound card\r\n	</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">人间战火不断，道德崩坏，世间魑魅魍魉横行作乱，玩家将在这失序混乱的世界中，成为维护秩序和正义“斩妖人”的一员。独自面对这一黑白界限逐渐模糊的世间，一路斩妖前行，体味凶残的妖魔与人类难填的欲壑无尽的纠葛，一幕幕的众生百态。<br />\r\n东方奇幻世界<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120810/extras/%E5%9C%BA%E6%99%AF.gif?t=1592367369\" alt=\"\" style=\"height:auto;\" /><br />\r\n云游四海，斩尽四方妖异。作为“斩妖人”的你在斩妖途中会经过形色各异的村庄和荒野，场景全都由手绘的形式进行制作，呈现出充满生机的东方奇幻世界。<br />\r\n逐帧动画<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120810/extras/%E9%80%90%E5%B8%A7%E5%8A%A8%E7%94%BB.gif?t=1592367369\" alt=\"\" style=\"height:auto;\" /><br />\r\n一招一式如云似水，游戏中角色的战斗与动作采用了手绘逐帧动画的方式，使“斩妖人”的每一招每一式都展现出最佳的表现力与流畅的战斗体验。<br />\r\n斩妖除魔<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120810/extras/%E6%88%98%E6%96%97.gif?t=1592367369\" alt=\"\" style=\"height:auto;\" /><br />\r\n孤剑一身，斩尽世间罪孽。游戏中加入了体力设置使战斗体验更注重时机与距离的把握，配合上技能的使用挖掘出属于你的“斩妖之道”。<br />\r\n人间百态<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120810/extras/%E5%89%A7%E6%83%852.gif?t=1592367369\" alt=\"\" style=\"height:auto;\" /><br />\r\n斩妖前行，体味人间五味杂陈。游戏中将为大家呈现出一个有血有肉的斩妖形象，并且在斩妖途中所遇到的人们，在他们的背后也隐藏着各自的故事。\r\n</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><a href=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120810/ss_02b79614f1cfa5c1cf13980d2d3866f11f6316ee.1920x1080.jpg?t=1592367369\"><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120810/ss_02b79614f1cfa5c1cf13980d2d3866f11f6316ee.1920x1080.jpg?t=1592367369\" alt=\"\" style=\"height:auto;\" /></a><br />\r\n<a href=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120810/ss_480c5a1129bed3c98cd61f1aade1caf729a3a262.1920x1080.jpg?t=1592367369\"><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120810/ss_480c5a1129bed3c98cd61f1aade1caf729a3a262.1920x1080.jpg?t=1592367369\" alt=\"\" style=\"height:auto;\" /></a><br />\r\n<a href=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120810/ss_439fd52dc45b9e77f229681320e09d0d4735b0e5.1920x1080.jpg?t=1592367369\"><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120810/ss_439fd52dc45b9e77f229681320e09d0d4735b0e5.1920x1080.jpg?t=1592367369\" alt=\"\" style=\"height:auto;\" /></a><br />\r\n<a href=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120810/ss_9a17c094b9c63e99a4310b8460502424c9e09fe9.1920x1080.jpg?t=1592367369\"><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120810/ss_9a17c094b9c63e99a4310b8460502424c9e09fe9.1920x1080.jpg?t=1592367369\" alt=\"\" style=\"height:auto;\" /></a><br />\r\n<a href=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120810/ss_c4d8e964ece24cb6dc5751677d4b2200da03e785.1920x1080.jpg?t=1592367369\"><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120810/ss_c4d8e964ece24cb6dc5751677d4b2200da03e785.1920x1080.jpg?t=1592367369\" alt=\"\" style=\"height:auto;\" /></a> \r\n	</p>',	58,	'https://fhdemo.s-cms.cn/t15/media/202011021606578P.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	99,	8,	'2020-11-02 16:06:12',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256757783/movie480.webm?t=1564548308',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(238,	'《尘怒之拳 Dusty Raging Fist》中文版百度云',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《尘怒之拳 Dusty Raging Fist》是一款ACT动作游戏，当黑暗之月发生时，Dusty，Darg和Kitsune知道了有些事情不对劲。一个来自远方的古代恶魔威胁了Double Bill小镇的和平。受到无阻的Elijah访问的影响，三人出发寻找钢铁骑士的帮助。一路上，他们不得已与流氓恶棍作战，遭遇了古代之力和生死之战。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><img src=\"https://ppgame.zijjt.com/kindeditor/attached/image/20200806/20200806202241_98007.jpg\" alt=\"\" /> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7 and above<br />\r\n处理器: Intel Core2Duo i3<br />\r\n内存: 8 GB RAM<br />\r\n图形: 1gb ram and above<br />\r\nDirectX 版本: 9.0<br />\r\n存储空间: 需要 5 GB 可用空间\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/202011021619102V.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	35,	7,	'2020-11-02 16:07:53',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256683770/movie480.webm?t=1552920279',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(239,	'刺客信条编年史俄罗斯',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《刺客信条编年史：俄罗斯 Assassin’s Creed Chronicles: Russia》是由Climax打造、育碧推出的2.5D横版过关游戏。 游戏设定在1918年的俄罗斯，Nikolai Orelov想带着他的家庭离开俄国，不过还必须完成最后一项刺客任务，渗入被布尔什维克控制的沙皇家族，盗取一件刺客与圣殿所争夺的伊甸圣器，期间，他看到了沙皇的孩子被屠杀，设法拯救公主阿纳斯塔西亚，他必须保护伊甸圣器和公主，同时逃脱皇宫。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7 SP1 or Windows 8 or Windows 8.1 (32/64bit versions)<br />\r\n处理器: Intel Core 2 Duo E8200 @ 2.6 GHz or AMD Athlon II X2 240 @ 2.8 GHz<br />\r\n内存: 2 GB RAM<br />\r\n显卡: nVidia GeForce GTS450 or AMD Radeon HD5770 (1024MB VRAM with Shader Model 5.0)<br />\r\nDirectX 版本: 10<br />\r\n存储空间: 需要 4 GB 可用空间\r\n	</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102162024wu.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	50,	10,	'2020-11-02 16:19:36',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256660368/movie480.webm?t=1454422860',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(240,	'刺客信条编年史印度',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	游戏介绍】\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	《刺客信条 编年史 印度篇》，设定1841年，锡克帝国与东印度公司交战期间，一位圣殿大师拿到一件本属刺客的神秘物件，刺客Arbaaz Mir必须重夺，同时保护他的朋友和爱人。《刺客信条 编年史》作品均为2.5D卷轴玩法，还包括支线任务，圣器收集元素，每位刺客为不同作战方法，武器，技能。\r\n</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102162721vR.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	46,	12,	'2020-11-02 16:25:34',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256659589/movie480.webm?t=1452603498',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(242,	'红脖子艾德：太空怪兽秀',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《红脖子艾德：太空怪兽秀 Redneck Ed: Astro Monsters Show》是一款充满活力、丰富多彩的街机风格的清版动作游戏，展现了普通的机械师艾德在星际娱乐圈的不幸经历。探索银河角斗士锦标赛的幕后内部运作，解开谜团，在外星群众中赢得声望，这一切都是为了让艾德被偷的面孔恢复原状！\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 8.1 64bit or Windows 10 64bit<br />\r\n处理器: 3 GHz Dual Core<br />\r\n内存: 2 GB RAM<br />\r\n显卡: GeForce GTX 720<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 4 GB 可用空间\r\n	</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102164505BO.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	16,	7,	'2020-11-02 16:41:41',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256800469/movie480_vp9.webm?t=1599742523',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(243,	'纳特的苏醒 Naught Reawakening',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《纳特的苏醒 Naught Reawakening》是一款冒险过关游戏，由Wild Sphere制作，Genera Games发行。Naught Reawakening游戏中，玩家可以完全控制Naught和他的环境，利用重力，引导Naught通过地下世界，在那里黑暗是最无情的敌人，有着各种各样的形态。非常考验玩家的技巧。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7<br />\r\n处理器: 1.8Ghz<br />\r\n内存: 1 GB RAM<br />\r\n显卡: 3D Graphics Card with 128MB RAM<br />\r\n存储空间: 需要 400 MB 可用空间\r\n</p>',	34,	'https://fhdemo.s-cms.cn/t15/media/202011021645561M.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	22,	6,	'2020-11-02 16:45:27',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256792526/movie480_vp9.webm?t=1594808201',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(244,	'粉碎精神巴西首位拳击手 ',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《粉碎精神：巴西首位拳击手 Smashing Spirits》是一款动作格斗类游戏，在这个疯狂的快节奏战斗平台游戏上，使用激烈的拳击组合在巴西岛上与斯巴达人决斗！女主人公为土著拳击手艾拉，正陷入一场自己的人民与来自海外外人之间的冲突中战斗。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	Steam集成: 云端游戏进度保存\r\n</li>\r\n<li>\r\n	怀旧的魔王: 4个强悍的魔王，具有像经典侧滚动游戏那样基于特定攻击模式的动作。\r\n</li>\r\n<li>\r\n	直接行动: 无需花费大量时间在观看剧情以及自定义设置。只需尽情享受一个拥有分布于5个关卡、超过30多名敌人的单人战役游戏，进行一场艰苦的战斗。\r\n</li>\r\n<li>\r\n	调整困难程度: 对您来说太难了吗？没问题，我们为您打造了一个“能多益(Nutella)”模式！\r\n</li>\r\n<li>\r\n	解锁机制: 获取新技能以拥有更多躲闪和攻击选择！\r\n</li>\r\n<li>\r\n	紧密的操作系统: 使用我们实施的紧密操作系统，可以让您更精确、快速地移动。\r\n</li>\r\n<li>\r\n	完全游戏手柄支持: 我们可以识别多达30多种游戏手柄。使用我们所推荐的配置或配置您自己的按钮操作。\r\n</li>\r\n	</ul>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7 or Later<br />\r\n处理器: Intel Core 2 Duo 1.6 GHz<br />\r\n内存: 3 GB RAM<br />\r\n显卡: DX10, DX11, DX12 Capable.<br />\r\nDirectX 版本: 10<br />\r\n存储空间: 需要 100 MB 可用空间\r\n		</p>',	59,	'https://fhdemo.s-cms.cn/t15/media/20201102164847oc.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	22,	6,	'2020-11-02 16:48:27',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256777378/movie480_vp9.webm?t=1599619943',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(245,	'流浪者 The Vagrant',	0.00,	'<h2 class=\"bb_tag\" style=\"color:#555555;font-size:20px;font-family:Lato, sans-serif;background-color:#FFFFFF;\">\r\n	游戏介绍\r\n</h2>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	流浪者薇薇安依据她父亲留下的笔记来寻求自己家族的秘密，而这唯一的线索最终将薇薇安引导到了世界上最神秘的巨大岛屿——秘银岛上。秘银岛上危机四伏而又环境多变，从茂密的森林到壮阔的古代遗迹，从古老的部落到世界的边缘，在这里薇薇安会遭遇各种已经注定的命运，展开各种意想不到的冒险，而这名坚强的流浪者，绝不会屈服于命运的安排。最终在终点等待她的，是一个什么样的结局？而薇薇安一直在寻求的东西又是什么？<br />\r\n薇薇安可以使用剑术连击，连锁技能以及强大的符文必杀技来与敌人战斗，同时可以通过获得装备品和学习能力来增强主角的能力，从而挑战更加强大的敌人来获取更多报酬来让主角获得最强的力量。在游戏的流程进行中薇薇安在身陷险境的时候，就需要你华丽的操作和培养来让她度过重重难关。\r\n</p>\r\n<h2 class=\"bb_tag\" style=\"color:#555555;font-size:20px;font-family:Lato, sans-serif;background-color:#FFFFFF;\">\r\n	游戏特色\r\n</h2>\r\n<ul class=\"bb_ul\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<li>\r\n		精美的手绘动画。\r\n	</li>\r\n	<li>\r\n		令人血脉偾张的战斗系统。\r\n	</li>\r\n	<li>\r\n		七十余个的充满个性的敌人。\r\n	</li>\r\n	<li>\r\n		六个以上全部手绘的精美区域等待探索。\r\n	</li>\r\n	<li>\r\n		可以获得大量的武器，护甲，装饰品、药物等道具来帮助和丰富你的冒险。\r\n	</li>\r\n	<li>\r\n		通过天赋系统来解锁更多的作战技巧和人物能力，来应对更加复杂的挑战。\r\n	</li>\r\n	<li>\r\n		制造、强化或者附魔你的装备来进一步提升主角的实力。\r\n	</li>\r\n	<li>\r\n		使用多姿多彩的必杀技来摧毁敌人，根据元素属性的不同，必杀技甚至会出现更加进化的变种。\r\n	</li>\r\n	<li>\r\n		多分支结局，让冒险更加充满意外。\r\n	</li>\r\n	<li>\r\n		各种强大的BOSS，是准备万全扎实的挑战，还是靠自己的技术来面对各种致命的危险，皆由你决定。\r\n	</li>\r\n	<li>\r\n		收集怪物图鉴、和各种文献来获知更多关于流浪者世界中的故事。\r\n	</li>\r\n	<li>\r\n		可以通过快速旅行来快速来往于秘银岛的各个区域，以便重复挑战关卡或者探索遗漏的部分。\r\n	</li>\r\n	<li>\r\n		由作曲家Gabe Castro创作的令人振奋、扣人心弦的精美音乐。\r\n	</li>\r\n	<li>\r\n		精彩而又令人意外的残酷冒险故事\r\n	</li>\r\n	<li>\r\n		为玩家准备4种不同的难度，可以根据自己的需求选择适合自己的难度，所有难度都可以带给玩家完整的游戏体验。\r\n	</li>\r\n	<li>\r\n		完全支持XboxONE手柄操作。\r\n	</li>\r\n</ul>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse sys_req\">\r\n		<div class=\"sysreq_contents\">\r\n			<div class=\"game_area_sys_req sysreq_content active\">\r\n				<div class=\"game_area_sys_req_leftCol\">\r\n					<p>\r\n						<span style=\"font-weight:bolder;\">最低配置:</span> \r\n					</p>\r\n					<ul>\r\n						<li>\r\n							<ul class=\"bb_ul\">\r\n								<li>\r\n									需要 64 位处理器和操作系统\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">操作系统:</span> Windows 7/ Windows 8/ Windows 10 x64\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">处理器:</span> 2.0 GHz or better\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">内存:</span> 4 GB RAM\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">显卡:</span> Intel HD 520；1G or higher\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">DirectX 版本:</span> 11\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">存储空间:</span> 需要 1200 MB 可用空间\r\n								</li>\r\n							</ul>\r\n						</li>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	34,	'https://fhdemo.s-cms.cn/t15/media/20201102175623dd.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	26,	7,	'2020-11-02 17:55:54',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256722551/movie480.webm?t=1531473283',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(246,	'硬核机甲/同屏联机',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	版本介绍：v42103版|官方简体中文|支持键盘.鼠标.手柄|赠同屏联机教程|2019年06月27号更新\r\n</p>\r\n<div id=\"game_area_reviews\" class=\"game_area_description\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<p>\r\n		“过场动画的超高质量令人惊讶，在关卡设计方面亦十分优秀，充满细节且总能带来惊喜的关卡让人感受到制作组凝聚其中的心血。密度不低的故事剧情加上分量充足的游玩内容，提供给玩家化身机器人动画主角一般的魅力体验。”<br />\r\n<br />\r\n“变化丰富的关卡，加上怒涛般急速展开的剧情，游玩过程令人舒畅。潜入搜查、特殊援救、定点防守等等，支线任务也多彩多样。配合机师脱离自机进行探索等各式演出，攻略过程变得十分有趣。同时玩家还可以收集地图隐藏区域内的额外武器并对机体施加改装，作为机器人游戏的素质可谓扎实。”<br />\r\n33/40 – Famitsu<br />\r\n“简言之，这是一款十分出色的2D机甲游戏。它不仅有我在相当长时间里见识过的最优秀的二维动画，同时游戏机制也非常扎实。”\r\n	</p>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn expanded\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse\">\r\n		<div id=\"game_area_description\" class=\"game_area_description\">\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				热血、自由、爽快的机甲战斗\r\n			</h2>\r\n			<p>\r\n				<br />\r\n<span style=\"font-weight:bolder;\">两大模式：本地/网络多人对战 和 单人战役</span><br />\r\n多人模式中，选择喜欢的机甲，自由组合出华丽招式，进行热血硬派的钢之对决！既可于在线模式中享受竞技性十足的快节奏激战，也能在本地分屏与亲友来一场增（互）进（相）感（伤）情（害）的大乱斗。<br />\r\n战役模式中，玩法丰富的关卡配合无缝衔接的动画，提供沉浸的故事体验。作为一名职业佣兵，在任务过程中逐渐被卷入一场阴谋重重的叛乱。面对接踵而来的战役和各负使命的敌人，在莫之能御的战争洪流中，逐渐开始思考自己战斗的意义。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				别具魅力的超精细 2D 动画\r\n			</h2>\r\n			<p>\r\n				具备独特力量感的精细骨骼动画将每台机体的特性充分展现，流畅自然的动作也为良好手感奠定了基础。<br />\r\n自然的2D旋转动画，利用错位与适时切换元件的视觉欺骗手法，达成如同3D的立体效果。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				自由与畅快兼备的操作机制\r\n			</h2>\r\n			<p>\r\n				游戏中不存在预设连段招式，无需死记硬背出招表，怎样机动，如何射击，完全由玩家手动操控，每个人都能玩出属于自己的华丽动作。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				风格迥异的多种类机体\r\n			</h2>\r\n			<p>\r\n				美式、日式、超级系、真实系，十数台谱系各异的机甲在此集结，每台机体都有着自己独一无二的战术定位，只有掌握并善用其特性的玩家才能发挥它们的最大战斗力。哪种机体才是最强？用自己的双手在对战模式中证明吧！\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				血肉之躯也能迎战机甲\r\n			</h2>\r\n			<p>\r\n				危急时刻可以控制驾驶员脱离机体单独行动。若运用得当，绝对是战场上一股不可忽视的力量。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				四倍的快乐\r\n			</h2>\r\n			<p>\r\n				除了在线对战外，本作还支持最多4人的本地分屏模式，一次购买，四倍快乐！\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				悉心打造的生动机甲世界\r\n			</h2>\r\n			<p>\r\n				战役模式含 8 个章节共计 18 关。随着剧情的深入，你能在矿坑、水下、市街、宇宙等各种类型的场景中，遭遇超过50种设计各异、细节丰富的敌方机甲，在某些关卡里玩家甚至可以脱离机甲深入敌后。<br />\r\n当然，你的座机也并非一成不变。在任务之间开发新装备并针对性配装，也是王牌驾驶员的宝贵心得。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				无缝沉浸式的故事体验\r\n			</h2>\r\n			<p>\r\n				独具特色、与横版游戏画面无缝切换的动画演出总长超过 40 分钟，且全程配音，提供沉浸故事体验。\r\n			</p>\r\n		</div>\r\n	</div>\r\n</div>',	55,	'https://fhdemo.s-cms.cn/t15/media/202011021758276B.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	3,	1,	'2020-11-02 17:57:15',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(247,	'硬核机甲/同屏联机',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	版本介绍：v42103版|官方简体中文|支持键盘.鼠标.手柄|赠同屏联机教程|2019年06月27号更新\r\n</p>\r\n<div id=\"game_area_reviews\" class=\"game_area_description\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<p>\r\n		“过场动画的超高质量令人惊讶，在关卡设计方面亦十分优秀，充满细节且总能带来惊喜的关卡让人感受到制作组凝聚其中的心血。密度不低的故事剧情加上分量充足的游玩内容，提供给玩家化身机器人动画主角一般的魅力体验。”<br />\r\n<br />\r\n“变化丰富的关卡，加上怒涛般急速展开的剧情，游玩过程令人舒畅。潜入搜查、特殊援救、定点防守等等，支线任务也多彩多样。配合机师脱离自机进行探索等各式演出，攻略过程变得十分有趣。同时玩家还可以收集地图隐藏区域内的额外武器并对机体施加改装，作为机器人游戏的素质可谓扎实。”<br />\r\n33/40 – Famitsu<br />\r\n“简言之，这是一款十分出色的2D机甲游戏。它不仅有我在相当长时间里见识过的最优秀的二维动画，同时游戏机制也非常扎实。”\r\n	</p>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn expanded\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse\">\r\n		<div id=\"game_area_description\" class=\"game_area_description\">\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				热血、自由、爽快的机甲战斗\r\n			</h2>\r\n			<p>\r\n				<br />\r\n<span style=\"font-weight:bolder;\">两大模式：本地/网络多人对战 和 单人战役</span><br />\r\n多人模式中，选择喜欢的机甲，自由组合出华丽招式，进行热血硬派的钢之对决！既可于在线模式中享受竞技性十足的快节奏激战，也能在本地分屏与亲友来一场增（互）进（相）感（伤）情（害）的大乱斗。<br />\r\n战役模式中，玩法丰富的关卡配合无缝衔接的动画，提供沉浸的故事体验。作为一名职业佣兵，在任务过程中逐渐被卷入一场阴谋重重的叛乱。面对接踵而来的战役和各负使命的敌人，在莫之能御的战争洪流中，逐渐开始思考自己战斗的意义。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				别具魅力的超精细 2D 动画\r\n			</h2>\r\n			<p>\r\n				具备独特力量感的精细骨骼动画将每台机体的特性充分展现，流畅自然的动作也为良好手感奠定了基础。<br />\r\n自然的2D旋转动画，利用错位与适时切换元件的视觉欺骗手法，达成如同3D的立体效果。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				自由与畅快兼备的操作机制\r\n			</h2>\r\n			<p>\r\n				游戏中不存在预设连段招式，无需死记硬背出招表，怎样机动，如何射击，完全由玩家手动操控，每个人都能玩出属于自己的华丽动作。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				风格迥异的多种类机体\r\n			</h2>\r\n			<p>\r\n				美式、日式、超级系、真实系，十数台谱系各异的机甲在此集结，每台机体都有着自己独一无二的战术定位，只有掌握并善用其特性的玩家才能发挥它们的最大战斗力。哪种机体才是最强？用自己的双手在对战模式中证明吧！\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				血肉之躯也能迎战机甲\r\n			</h2>\r\n			<p>\r\n				危急时刻可以控制驾驶员脱离机体单独行动。若运用得当，绝对是战场上一股不可忽视的力量。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				四倍的快乐\r\n			</h2>\r\n			<p>\r\n				除了在线对战外，本作还支持最多4人的本地分屏模式，一次购买，四倍快乐！\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				悉心打造的生动机甲世界\r\n			</h2>\r\n			<p>\r\n				战役模式含 8 个章节共计 18 关。随着剧情的深入，你能在矿坑、水下、市街、宇宙等各种类型的场景中，遭遇超过50种设计各异、细节丰富的敌方机甲，在某些关卡里玩家甚至可以脱离机甲深入敌后。<br />\r\n当然，你的座机也并非一成不变。在任务之间开发新装备并针对性配装，也是王牌驾驶员的宝贵心得。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				无缝沉浸式的故事体验\r\n			</h2>\r\n			<p>\r\n				独具特色、与横版游戏画面无缝切换的动画演出总长超过 40 分钟，且全程配音，提供沉浸故事体验。\r\n			</p>\r\n		</div>\r\n	</div>\r\n</div>',	55,	'https://fhdemo.s-cms.cn/t15/media/202011021758276B.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	0,	0,	'2020-11-02 17:57:15',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(248,	'死亡细胞/Dead cells',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	游戏介绍】\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	欢迎来到《死亡细胞》，这是一款将Roguelite与银河战士恶魔城类特点融为一炉的2D平台动作游戏。游戏中并无检查点，玩家将体验魂味战斗，一路挑战诸多守卫，在杀戮与死亡的反复轮回中探索一座房间不断变化的巨大城堡。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	【游戏截图】\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2017/05/12/2017051225651537.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2017/05/12/2017051225654263.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2017/05/12/2017051225656691.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2017/05/12/2017051225658568.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2017/05/12/2017051225700507.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2017/05/12/201705122570149.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	【游戏配置】\r\n</p>\r\n<div class=\"quote\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<blockquote style=\"background:#F0F4F5;font-family:RiPlus-Black;\">\r\n		<p>\r\n			推荐配置<br />\r\n操作系统:&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp;Windows 7<br />\r\n处理器&emsp;:&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp;Intel i5<br />\r\n图形显卡:&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp;Nvidia GTX 460 / Radeon HD 7800 or better<br />\r\n内存容量:&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp;4 GB RAM<br />\r\n硬盘空间:&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp;需要 500 MB 可用空间\r\n		</p>\r\n	</blockquote>\r\n</div>',	73,	'https://fhdemo.s-cms.cn/t15/media/20201102180016tn.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	44,	19,	'2020-11-02 17:59:20',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256796085/movie480_vp9.webm?t=1597159612',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(249,	'剑与勇士2：肉夹末日',	0.00,	'<h3 style=\"color:#555555;font-size:18px;font-family:Lato, sans-serif;background-color:#FFFFFF;\">\r\n	<span class=\"bt\">玩法介绍</span> \r\n</h3>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	侧向滚过你的敌人：保卫你的基地，获取资源，并使用超过45个部队、技能和建筑来削弱你的敌人！\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	找到最完美的沙瓦玛！：根据首领红胡子的命令，你和你的维京人们必须通过穿越冻原、森林、沙漠和地狱深渊完成种类各异的45个等级单人战役来找出谁偷了你们的晚餐！\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	自定义战略：使用自定义军队的功能来征召一支你最喜欢的军队、技能和建筑，然后利用他们来对抗你的朋友！\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	多元化游戏：通过本地网络或分屏进行激烈的1v1在线战斗，来摆平你对手的基地！\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	等待中的游戏：当你在线等待对手出现时，可以享受各式各样的迷你小游戏，在小规模战斗中与AI决一胜负或取得高分。\r\n</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102180149rr.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	29,	6,	'2020-11-02 18:01:06',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(250,	'非常英雄/Unruly Heroes',	0.00,	'<div class=\"game_page_autocollapse_ctn expanded\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse\">\r\n		<div id=\"game_area_description\" class=\"game_area_description\">\r\n			<h2 style=\"font-size:20px;\">\r\n				关于这款游戏\r\n			</h2>\r\n			<p>\r\n				<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/780350/extras/header_package_2_test2.jpg?t=1580118066\" style=\"height:auto;\" /> \r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				滑稽有趣的动作、武术、猴王，还有更多精彩内容！\r\n			</h2>\r\n			<p>\r\n				真经维持着我们世界的和谐，但它已被撕碎，随风四散。现在，可怕的怪物正到处播撒不谐与混乱。《Unruly Heroes》的灵感来自中国古典名著《西游记》，讲述了四位反叛不羁、难以置信的英雄的冒险，他们必须收集所有的经卷碎片，前往奇幻的世界，恢复世界的平衡…牺牲自己也在所不辞！<br />\r\n游戏设置在赏心悦目、活泼生动的环境中，是西游故事的一个有趣版本，融合了跳跃、攀爬、意想不到的挑战，以及在面对大量敌人和令人难忘的头目角色时的激烈战斗。<br />\r\n在这次冒险旅程中，四人组别无选择，只能联合起来，最终了解成为英雄的要素。\r\n			</p>\r\n			<p>\r\n				<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/780350/extras/Monkey_Intro.gif?t=1580118066\" style=\"height:auto;\" /> \r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				主要特色：\r\n			</h2>\r\n			<ul class=\"bb_ul\">\r\n				<li>\r\n					体验美猴王的传奇，单人游戏或在本地游戏中与多达四名玩家合作。\r\n				</li>\r\n				<li>\r\n					通过学习掌握四位不同英雄的综合力量，在每次新的遭遇和挑战中使用最好的英雄。\r\n				</li>\r\n				<li>\r\n					对抗各种具有挑战性的敌人和可怕的头目，测试你的反应能力。\r\n				</li>\r\n				<li>\r\n					附身你的敌人以利用他们的力量和能力。\r\n				</li>\r\n				<li>\r\n					跨越多彩的奇幻宇宙，探索不同的世界，解决难题并克服意想不到的障碍。\r\n				</li>\r\n				<li>\r\n					沉浸在精美的美术、动画和音效中。\r\n				</li>\r\n				<li>\r\n					在本地或在线 PVP 中与好友对战。<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/780350/extras/LadyWhite_Fight.gif?t=1580118066\" style=\"height:auto;\" /> \r\n				</li>\r\n			</ul>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse sys_req\">\r\n		<h2 style=\"font-size:20px;\">\r\n			系统需求\r\n		</h2>\r\n		<div class=\"sysreq_contents\">\r\n			<div class=\"game_area_sys_req sysreq_content active\">\r\n				<div class=\"game_area_sys_req_full\">\r\n					<p>\r\n						<span style=\"font-weight:bolder;\">最低配置:</span> \r\n					</p>\r\n					<ul>\r\n						<li>\r\n							<ul class=\"bb_ul\">\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">操作系统:</span> Windows 7 (32/64bit versions)\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">处理器:</span> Intel Core i3 2100\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">内存:</span> 4 GB RAM\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">显卡:</span> nVidia GeForce GeForce GTX 650\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">存储空间:</span> 需要 4 GB 可用空间\r\n								</li>\r\n							</ul>\r\n						</li>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102180322q3.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	52,	15,	'2020-11-02 18:02:33',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256752191/movie480.webm?t=1559295538',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(251,	'东方月神夜/Touhou Luna Nights',	0.00,	'<div class=\"game_page_autocollapse_ctn expanded\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse\">\r\n		<p>\r\n			<br />\r\n		</p>\r\n		<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n			<br />\r\n		</h2>\r\n		<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n			从背景作图到角色的动作、技能等等方面都能看出作者对游戏制作的热忱与对东方Project的热爱。\r\n		</h2>\r\n		<p>\r\n			本作是类似恶魔城的2D探索型游戏，同时也是在类银河战士恶魔城游戏中偶尔可见的，<br />\r\n不用拘泥于重复要素与道具收集也可以顺利推进的游戏。这样出色的游戏性背后，<br />\r\n可以说是Team Ladybug至今为止一直不断努力，用心培养出的游戏制作技能的出色成果。\r\n		</p>\r\n		<p>\r\n			我个人特别瞩目的地方是精致的动画。不仅是主人公角色的动作，过场与敌方角色也都充满了制作者对动画表现的追求，<br />\r\n有很多第一眼甚至看不出来的细节表现，相信也会让玩家感到非常有趣。\r\n		</p>\r\n		<p>\r\n			Touhou Luna Night’s这款游戏，不仅面向东方Project的粉丝，同时也值得向所有喜欢2D动作类游戏的玩家强烈推荐。\r\n		</p>\r\n		<p>\r\n			<br />\r\n		</p>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse sys_req\">\r\n		<h2 style=\"font-size:20px;\">\r\n			系统需求\r\n		</h2>\r\n		<div class=\"sysreq_contents\">\r\n			<div class=\"game_area_sys_req sysreq_content active\">\r\n				<div class=\"game_area_sys_req_leftCol\">\r\n					<p>\r\n						<span style=\"font-weight:bolder;\">最低配置:</span> \r\n					</p>\r\n					<ul>\r\n						<li>\r\n							<ul class=\"bb_ul\">\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">操作系统:</span> Windows 2000 / XP / Vista / 7 / 8 / 10\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">处理器:</span> Intel Core2 Duo or higher\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">内存:</span> 2 GB RAM\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">显卡:</span> Open GL compliant video card\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">存储空间:</span> 需要 50 MB 可用空间\r\n								</li>\r\n							</ul>\r\n						</li>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102180435sj.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	36,	8,	'2020-11-02 18:04:07',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256753317/movie480.webm?t=1560532061',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(252,	'至暗之光',	0.50,	'<p style=\"font-size:12.6316px;\">\r\n	至暗之光 是一款科幻类的2D动作平台类游戏，包含魂系列和银河恶魔城类游戏元素。在一个充满超自然生物的赛博朋克末日世界里冒险吧！利用你自身和无人机伙伴的能力生存下去，增强自己，击败那些潜伏于黑暗的怪物。\r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	<br />\r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	名称: Dark Light<br />\r\n类型: 动作, 冒险, 独立, 抢先体验<br />\r\n开发商: Mirari&amp;Co.<br />\r\n发行商: Mirari&amp;Co., Maple Whispering Limited<br />\r\n发行日期: 2020年5月8日<br />\r\n最低配置:<br />\r\n操作系统: Widows 7+<br />\r\n处理器: Intel Core i3-2100 / AMD&reg; FX-6300<br />\r\n内存: 4 GB RAM<br />\r\n显卡: Nvidia GTX 560<br />\r\n存储空间: 需要 3 GB 可用空间\r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	<br />\r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	电影级画质，细致的人物和环境设计，生动的动画效果能给你带来一场丰富的视觉盛宴。\r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	<a href=\"https://media.st.dl.pinyuncloud.com/steam/apps/1134520/extras/b_2.gif?t=1588995228\"><img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1134520/extras/b_2.gif?t=1588995228\" /></a>\r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	各类远程，近战和可投掷物品以及特殊的道具。还有多种方法能升级武器和装备，让你的角色技能更加丰富。\r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	<a href=\"https://media.st.dl.pinyuncloud.com/steam/apps/1134520/extras/combat-throw.gif?t=1588995228\"><img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1134520/extras/combat-throw.gif?t=1588995228\" /></a>\r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	开放式地图能让你选择自己的方式去探索那些黑暗区域，遇到可怕的超自然敌人以及恐怖的boss。不过当然，你也会在游戏里遇到一些友好的NPC给你提供帮助。\r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	<a href=\"https://media.st.dl.pinyuncloud.com/steam/apps/1134520/extras/e.gif?t=1588995228\"><img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1134520/extras/e.gif?t=1588995228\" /></a>\r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	利用你身边的小无人机射出的光来调查那些\r\n</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102190256wF.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	15,	3,	'2020-11-02 19:02:44',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256791692/movie480_vp9.webm?t=1593775464',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(253,	'瞬变 Transient',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《瞬变 Transient》是一款赛博朋克游戏，洛夫克拉夫特与赛博朋克风的碰撞。深入反乌托邦世界，在圆顶城内调查即你和你朋友经历的一切。揭开谜题，破解系统，探索其他次元。找出可能破坏你心智和质疑你真实存在的真相。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">洛夫克拉夫特与赛博朋克风的碰撞<br />\r\n洛夫克拉夫特式宇宙存在主义与冷酷、反乌托邦赛博朋克背景相交融，体验先所未有的神秘世界。TRANSIENT兼具两大流派风格，脑洞大开，让你在熟悉的环境中探奇。<br />\r\n探究支离破碎的真实世界<br />\r\n从被人遗憾的 Kor Shehr 荒野到圆顶城的穷街陋巷，在这个世界中满是让人难忘的冒险地点。探索真实世界、自己的梦境和虚拟世界，遇见形形色色的朋友、敌人和中立生物。<br />\r\n逃离现实<br />\r\n唯美环境搭配震撼游戏原声音乐，营造身临其境的刺激体验。<br />\r\n强化人执行任务<br />\r\n在游戏中扮演武装者（即强化人） Randolph Carter 执行任务。利用可突出植入物和 PHI 的高级知觉调查周遭环境，扫描线索，破解阻止你挖掘真想的屏障。\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7 64-bit<br />\r\n处理器: 3.60GHz Intel Core i3-4160<br />\r\n内存: 6 GB RAM<br />\r\n显卡: NVIDIA GeForce GTX 480/570/670, ATI Radeon HD 5870/5850<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 15 GB 可用空间\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。 <br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。 <br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！ <br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。 <br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n	</p>',	56,	'https://fhdemo.s-cms.cn/t15/media/202011021905238X.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	40,	10,	'2020-11-02 19:03:47',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256799395/movie480_vp9.webm?t=1603292954',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(254,	'赤痕夜之仪式',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	《赤痕·：夜之仪式》是一款以探索为主的横向卷轴动作角色扮演游戏，在内容丰富的游戏设定中融入你所了解和喜爱的银河恶魔城类型游戏的所有最佳特色。游戏由505 Games全球发行，2P Games在大中国地区提供联合发行支持。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	扮演米丽亚姆，一个被炼金术士诅咒而导致身体正慢慢变成水晶的孤儿。为了拯救她自己，事实上还有所有人类，她必须通过奋力战斗闯过一座充满恶魔的城堡，这座城堡由她的老朋友吉贝尔召唤而来，吉贝尔的身心已经变成了水晶，不再是一副血肉之躯。\r\n</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102190632z6.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	34,	7,	'2020-11-02 19:06:15',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256749591/movie480.webm?t=1556803197',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(255,	'为埃尔多拉多而战（BE-A Walker官中）',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	由你操控位于外星星球上的巨大机器,你可以击杀或踩扁当地的土著!并且你要做出选择,是为你的 哥哥报仇,还是原谅杀死他们的凶手? 亦或是加入叛军,让充满异域风情的埃尔多拉多星球恢复和平。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<br />\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	名称: BE-A Walker<br />\r\n类型: 动作, 冒险, 独立, 模拟<br />\r\n开发商: Tequilabyte Studio<br />\r\n发行商: Games Operators, PlayWay S.A.<br />\r\n发行日期: 2020年5月7日<br />\r\n最低配置:<br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7 64bit<br />\r\n处理器: Intel Pentium<br />\r\n内存: 2 GB RAM<br />\r\n显卡: Intel HD Graphics 530<br />\r\nDirectX 版本: 9.0<br />\r\n存储空间: 需要 500 MB 可用空间\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<br />\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<a href=\"https://media.st.dl.pinyuncloud.com/steam/apps/864160/extras/gif_steam.gif?t=1588860036\"><img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/864160/extras/gif_steam.gif?t=1588860036\" style=\"height:auto;\" /></a> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	游戏介绍<br />\r\n你是战斗型机器“无畏行者”（两足突击步行机）的操作员。你的任务是打败敌对的本地土著，保护人类殖民地里的居民。但是消灭土著并不是停止战争的唯一途径，你可以选择立场，并做出最适合你的决定：是做一个人类，一个真正的地球之子，为你的种族的生存而战，杀死任何挡在你面前的生物。亦或者是做一个人道主义者，竭尽全力保护受因人类的入侵而受苦受难的当地土著。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	控制大型机器不是件容易的事。先抬起一条腿，再向左或向右移动，然后迈出坚实的一步，重复这个动作。无畏行者就是这样行走的。<br />\r\n你也可以通过操控机器的两条大腿踩扁敌人或躲避手榴弹和导弹。<br />\r\n特点<br />\r\n阴暗的新世界。<br />\r\n少量战利品。<br />\r\n最怪异最残忍的杀戮模式。<br />\r\n升级你的无畏行者和武器使其变得更具威胁。<br />\r\n击败当地土著或带领他们保卫自己的家园。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<a href=\"https://media.st.dl.pinyuncloud.com/steam/apps/864160/ss_9ad0ab4b437a89fe12d41cdfc899c9a4347dfc61.1920x1080.jpg?t=1588860036\"></a><br />\r\n<a href=\"https://media.st.dl.pinyuncloud.com/steam/apps/864160/ss_e13d24f91d222cc087820a0b107280e517932fdb.1920x1080.jpg?t=1588860036\"></a> \r\n</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/202011021918339q.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	15,	6,	'2020-11-02 19:17:41',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256744891/movie480.webm?t=1557378092',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(256,	'地表法则先遣者 体验版(官中）',	0.00,	'<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">这是一款废土题材的生存类游戏。</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">游戏背景设定为太阳发生日冕大爆发，带电粒子持续掠过地球。烧毁了人类所有的电子设备，并切断了人类DNA造成了严重的变异。人类迫不得已在地下建造了巨大的避难所，并带着残存的文明迁入地下。五十年后，部分激进者认为日冕大爆发已经结束，地表已经恢复到了可以生存的状况。于是组织了回到地表的生存比赛，一批勇敢的先遣者参加了这场地表生存大赛，而你就是其中之一。</span><br />\r\n<br />',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102192036Ne.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	42,	11,	'2020-11-02 19:20:09',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256799201/movie480_vp9.webm?t=1598862930',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(257,	'诺亚之雾 Mists of Noyah',	0.00,	'<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏介绍：</strong></span> \r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">《诺亚之雾 Mists of Noyah》是一款带有随机生成世界和许多RPG元素的 合作生存游戏。 在夜晚与日久演变的阵营跟可怕的怪物战斗！ 为增强你的基地， 请营救来自…\r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><a class=\"highslide-image\" href=\"https://s1.jiligame.com/images/2020/06/01/9cab1ffde5403e37bab3c94be2244e90.jpg\"><br />\r\n</a> \r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏特色：</strong></span> \r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">白天打猎，晚上被猎杀<br />\r\n白天 你将必须收集物资，诸如木材，铁，金，特殊矿石，植物，食物之类的资源，并寻 找堡垒失散的居民们!<br />\r\n晚上 你将必须建造防御门墙，与寻回的居民聚集在一起以保护自己，在每一个满月， 恶魔们会疯狂攻击你的堡垒并且越来越强大，而如果你丢失了堡垒又无法在时限内重建它， 你就输了！<br />\r\n制造与 RPG 元素<br />\r\n锻造和附魔你的装备与配件，制造药水，种植，烹饪，分配才能，解锁咒语和技能<br />\r\n堡垒<br />\r\n你从一个废弃的堡垒开始，需要尽快找到所有在袭击中逃离的居民们，其包括士兵，弓箭手， 工程师，机械师，炼金术士，商人等等。<br />\r\n派系<br />\r\n派系由更聪明的怪物所组成，它们会建立越来越强大的基地。 你必须在它们建立一支军队进 攻你的堡垒之前摧毁这些基地！\r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>最低配置:</strong></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7+<br />\r\n处理器: 2.0 Ghz<br />\r\n内存: 2 GB RAM<br />\r\n显卡: 128mb Video Memory, capable of Shader Model 2.0+<br />\r\nDirectX 版本: 9.0c<br />\r\n存储空间: 需要 1 GB 可用空间\r\n</p>',	85,	'https://fhdemo.s-cms.cn/t15/media/202011021946405m.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	68,	10,	'2020-11-02 19:21:09',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256773684/movie480.webm?t=1580895587',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(258,	'太空角斗士逃离塔塔鲁斯',	0.00,	'<p class=\"introTit\" font-family:宋体,=\"\" arial;\"=\"\" style=\"white-space: normal; font-size: 16px; color: rgb(63, 177, 24); background-image: url(\" \");=\"\" background-position:=\"\" initial;=\"\" background-size:=\"\" background-repeat:=\"\" background-attachment:=\"\" background-origin:=\"\" background-clip:=\"\" initial;\"=\"\"><span style=\"font-weight:700;font-family:微软雅黑, arial;color:#333333;\">游戏介绍</span> \r\n	</p>\r\n	<p style=\"font-size:13px;color:#333333;font-family:微软雅黑, 宋体, arial;background-color:#FFFFFF;\">\r\n		太空角斗士逃离塔塔洛斯是一款手绘风格2d平台动作冒险游戏，跟随逃离星球监狱的太空土豆人打败成群的外星人获得自由，游戏具有流畅的动作控制，形象有趣的角色以及roguelite元素，有点类似太空<a href=\"http://www.pc6.com/pc/hengbangdjggyouxi/\" target=\"_blank\">横版</a>以撒的结合。\r\n	</p>\r\n	<p align=\"center\" style=\"font-size:13px;color:#333333;font-family:微软雅黑, 宋体, arial;background-color:#FFFFFF;\">\r\n		<br />\r\n	</p>\r\n<p class=\"introTit\" font-family:宋体,=\"\" arial;\"=\"\" style=\"white-space: normal; font-size: 16px; color: rgb(63, 177, 24); background-image: url(\" \");=\"\" background-position:=\"\" initial;=\"\" background-size:=\"\" background-repeat:=\"\" background-attachment:=\"\" background-origin:=\"\" background-clip:=\"\" initial;\"=\"\"><span style=\"font-weight:700;font-family:微软雅黑, arial;color:#333333;\">游戏特色</span> \r\n</p>\r\n<p style=\"font-size:13px;color:#333333;font-family:微软雅黑, 宋体, arial;background-color:#FFFFFF;\">\r\n	1.你被俘虏了，并被派去招待外星人，在一个遥远的星球名叫塔塔罗斯的角斗士。你必须在随机产生的生物群落中前进，那里有致命的陷阱和怪物阻挡你的道路。在竞技场上选择你的对手。\r\n</p>\r\n<p style=\"font-size:13px;color:#333333;font-family:微软雅黑, 宋体, arial;background-color:#FFFFFF;\">\r\n	2.严密和流畅的控制，让你躲闪和打击敌人而不受打击-唯一的天花板是你自己的技能!数百个手工制作的房间被随机挑选，让每一次新的跑步体验独一无二。50多个敌人和10个老板用不同的招式和攻击模式击败。\r\n</p>\r\n<p style=\"font-size:13px;color:#333333;font-family:微软雅黑, 宋体, arial;background-color:#FFFFFF;\">\r\n	3.300+个物品，包括宠物，武器和饰品，可以为你的角色开启新的能力。把你的心掏出来治好自己，扔肉丸或发射激光枪。8个独特的角色，适合不同的游戏风格，包括一个土豆和一个在内裤里的外星人蠕虫。\r\n</p>\r\n<p style=\"font-size:13px;color:#333333;font-family:微软雅黑, 宋体, arial;background-color:#FFFFFF;\">\r\n	4.如果你感到自信，可以选择更难的路，或者在你濒临死亡的边缘时选择更容易的路来定制你的跑步。高风险，高回报，击败他们获得物品和硬币，你也许可以赢得你的自由!\r\n</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102194747h4.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	49,	7,	'2020-11-02 19:46:54',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256782584/movie480_vp9.webm?t=1587461611',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(259,	'太空角斗士逃离塔塔鲁斯',	0.00,	'<p class=\"introTit\" font-family:宋体,=\"\" arial;\"=\"\" style=\"white-space: normal; font-size: 16px; color: rgb(63, 177, 24); background-image: url(&quot;&quot;); background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><span style=\"font-weight:700;font-family:微软雅黑, arial;color:#333333;\">游戏介绍</span>\r\n	</p>\r\n	<p style=\"font-size:13px;color:#333333;font-family:微软雅黑, 宋体, arial;background-color:#FFFFFF;\">\r\n		太空角斗士逃离塔塔洛斯是一款手绘风格2d平台动作冒险游戏，跟随逃离星球监狱的太空土豆人打败成群的外星人获得自由，游戏具有流畅的动作控制，形象有趣的角色以及roguelite元素，有点类似太空<a href=\"http://www.pc6.com/pc/hengbangdjggyouxi/\" target=\"_blank\">横版</a>以撒的结合。\r\n	</p>\r\n	<p align=\"center\" style=\"font-size:13px;color:#333333;font-family:微软雅黑, 宋体, arial;background-color:#FFFFFF;\">\r\n		<br />\r\n	</p>\r\n<p class=\"introTit\" font-family:宋体,=\"\" arial;\"=\"\" style=\"white-space: normal; font-size: 16px; color: rgb(63, 177, 24); background-image: url(&quot;&quot;); background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><span style=\"font-weight:700;font-family:微软雅黑, arial;color:#333333;\">游戏特色</span>\r\n</p>\r\n<p style=\"font-size:13px;color:#333333;font-family:微软雅黑, 宋体, arial;background-color:#FFFFFF;\">\r\n	1.你被俘虏了，并被派去招待外星人，在一个遥远的星球名叫塔塔罗斯的角斗士。你必须在随机产生的生物群落中前进，那里有致命的陷阱和怪物阻挡你的道路。在竞技场上选择你的对手。\r\n</p>\r\n<p style=\"font-size:13px;color:#333333;font-family:微软雅黑, 宋体, arial;background-color:#FFFFFF;\">\r\n	2.严密和流畅的控制，让你躲闪和打击敌人而不受打击-唯一的天花板是你自己的技能!数百个手工制作的房间被随机挑选，让每一次新的跑步体验独一无二。50多个敌人和10个老板用不同的招式和攻击模式击败。\r\n</p>\r\n<p style=\"font-size:13px;color:#333333;font-family:微软雅黑, 宋体, arial;background-color:#FFFFFF;\">\r\n	3.300+个物品，包括宠物，武器和饰品，可以为你的角色开启新的能力。把你的心掏出来治好自己，扔肉丸或发射激光枪。8个独特的角色，适合不同的游戏风格，包括一个土豆和一个在内裤里的外星人蠕虫。\r\n</p>\r\n<p style=\"font-size:13px;color:#333333;font-family:微软雅黑, 宋体, arial;background-color:#FFFFFF;\">\r\n	4.如果你感到自信，可以选择更难的路，或者在你濒临死亡的边缘时选择更容易的路来定制你的跑步。高风险，高回报，击败他们获得物品和硬币，你也许可以赢得你的自由!\r\n</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102194747h4.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	0,	0,	'2020-11-02 19:46:54',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(260,	'蝙蝠蛮人：古代之约 Batbarian: Testament of the Primordials',	0.00,	'<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏介绍：</strong></span> \r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">《蝙蝠蛮人：古代之约 Batbarian: Testament of the Primordials》是一款带有幽默感的动作冒险益智游戏。探索数百个充满秘密的深渊洞穴，与大恶魔搏斗，为自己的团队征集同伴，并使用皮普Pip（玩家的蝙蝠好队友）的力量解决难题并逃脱魔鬼深渊！\r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><a class=\"highslide-image\" href=\"https://s1.jiligame.com/images/2020/10/02/74bf93705f69955f91e205cb716c6239.jpg\"><br />\r\n</a> \r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏特色：</strong></span> \r\n</p>\r\n<ul class=\"bb_ul\" noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">\r\n<li>\r\n	玩家需要为扮演的野人获得新技能，为皮普Pip，（魔法）蝙蝠聚集自然元素能量！\r\n</li>\r\n<li>\r\n	metroidvania（连接式大地图+通过获得能力扩大冒险范围）的叙事性游戏充满了幽默搞笑的对话。\r\n</li>\r\n<li>\r\n	大数字！ 400多个房间，20多个小时的展开游戏，10多个老怪，60分钟以上的音乐以及将近30,000的文字，玩家一定会迫不及待的跟着野人角色一起读！\r\n</li>\r\n<li>\r\n	谜题\r\n</li>\r\n<li>\r\n	带有角色扮演（RPG）元素的升级迷你游戏。\r\n</li>\r\n<li>\r\n	水果投掷可能比其他任何同款游戏都多。\r\n</li>\r\n<li>\r\n	小伙伴们会根据玩家的要求来帮助参战。\r\n</li>\r\n<li>\r\n	根据玩家的选择和行动会有多种不同的结局。\r\n</li>\r\n<li>\r\n	扔出去的果实不会浪费，会被神奇的蝙蝠吃掉。\r\n</li>\r\n<li>\r\n	大量的秘密和隐藏的战利品无处不在。\r\n</li>\r\n<li>\r\n	魔法蝙蝠有五种不同的吱吱声！\r\n</li>\r\n<li>\r\n	重复性笑话比此描述少。\r\n</li>\r\n	</ul>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>最低配置:</strong></span><br />\r\n操作系统: Windows 7 and Above<br />\r\n处理器: Intel Core 2 Duo E5200<br />\r\n内存: 4 GB RAM<br />\r\n显卡: GeForce 9800GTX+ (1GB)<br />\r\nDirectX 版本: 10<br />\r\n存储空间: 需要 1 GB 可用空间\r\n		</p>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102195125He.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	20,	7,	'2020-11-02 19:50:13',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256800755/movie480_vp9.webm?t=1599948023',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(261,	'地狱边境',	0.00,	'',	55,	'https://fhdemo.s-cms.cn/t15/media/202011021952350Z.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	31,	9,	'2020-11-02 19:51:56',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(262,	'星尘战区 Stardust Theater',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《星尘战区 Stardust Theater》是一款科幻风格的2D横向卷轴射击游戏，包含5个普通关卡和一个特别关卡，总游戏时长约1小时。游戏带有强化要素，容错率高，不需要硬核的技术也可以轻松体验。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows7_64 / Windows8_64 / Windows8.1_64 / Windows10_64<br />\r\n处理器: Core i3-2100<br />\r\n内存: 2 GB RAM<br />\r\n显卡: GeForce GT440<br />\r\nDirectX 版本: 9.0c<br />\r\n存储空间: 需要 350 MB 可用空间\r\n</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102195426P7.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	23,	6,	'2020-11-02 19:53:18',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256801167/movie480_vp9.webm?t=1600772103',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(263,	'灾厄逆刃-正式版',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	转整个地球的命运。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<br />\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	名称: 灾厄逆刃<br />\r\n类型: 动作, 冒险, 独立<br />\r\n开发商: Flying Oak Games, E-Studio<br />\r\n发行商: Dear Villagers, Yooreka Studio<br />\r\n系列: Flying Oak Games<br />\r\n发行日期: 2020年10月21日<br />\r\n最低配置:<br />\r\n操作系统: 64bit Microsoft&reg; Windows&reg; 7 SP1, 8.1, 10 (version 1607 or better)<br />\r\n处理器: 64bit 1.5 GHz CPU<br />\r\n内存: 2048 MB RAM<br />\r\n显卡: OpenGL 3.0 (DirectX&reg; 10) compliant graphics card and driver<br />\r\nDirectX 版本: 10<br />\r\n存储空间: 需要 500 MB 可用空间<br />\r\n附注事项: Intel graphics: please read the GPU compatibility thread on the forum\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	巨石灭世，灾厄降临，手持利刃的你，能否勇闯地牢、逆转人类命运？<br />\r\n《灾厄逆刃》是一款由Flying Oak Games、E-Studio研发，游力卡游戏负责大中华区发行的快节奏平台动作地牢类游戏。游戏设定在一个后末日世界中，在这里，一种神秘的存在已将全人类毁灭殆尽。游戏中，您扮演一位部族中最强大、致命的武士 Kyhra。帮助 Kyhra 探索未知的领域，一路砍杀，穿越上古机器的层层守卫，揭开她过去的封印，更有可能让人类获得救赎。<br />\r\n【像素画风，动感配乐】<br />\r\n《灾厄逆刃》采用了鲜亮明快的像素画风，操纵主角在狭小地牢里闪转腾挪，伴随着Joonas Turner作曲的动感BGM，尽享类银河恶魔城的狂野粗豪！<br />\r\n【足不沾地，爽快连招】<br />\r\n二段跳、爬墙、空中冲刺连招！超流畅的平台动作空战系统让你感受如丝般顺滑的手感和刀刀入肉的爽快战斗。<br />\r\n【重平台动作与轻Roguelite结合】<br />\r\n本作除了包含技能天赋、祝福升级、武器改装等Roguelite元素外，还对大家的反应与操作能力有颇多考验之处，在游玩时，记得保持冷静沉着，观察敌人的破绽后定能一招毙敌！<br />\r\n【探索和速通皆有奖励】<br />\r\n不论你是总想要“打开全图”的探索党，还是追求极致通关速度的速通党，都可以在游玩时获得额外奖励！<br />\r\n<img src=\"https://cdn.cloudflare.steamstatic.com/steam/apps/1037020/extras/Key_Features.gif?t=1603288691\" alt=\"\" style=\"height:auto;\" /><br />\r\n尽享类银河恶魔城游戏的狂野粗豪，畅玩快节奏的轻型地牢砍杀游戏，借助超流畅的平台控制，尽情射击，杀出一条血路<br />\r\n利用仅聚焦于攻击的疯狂战斗系统，磨炼您的技巧<br />\r\n在 Joonas Turner （曾为 Nuclear Throne、Downwell和 Broforce 等多个游戏设计音效）超凡脱俗的适应音效的伴随下，开启动感冲锋！<br />\r\n击败大群可怖的敌人，杀死庞大的头目，取得其手中的灾厄秘密<br />\r\n地牢不断变化，深不可测，等您来探索<br />\r\n揭开各种神秘，找到过去探索者的笔记，解锁扭转现实的秘密<br />\r\n<img src=\"https://cdn.cloudflare.steamstatic.com/steam/apps/1037020/extras/Open_Development.gif?t=1603288691\" alt=\"\" style=\"height:auto;\" /><br />\r\n灾厄逆刃 是在社区的帮助下开发的！声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。 <br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。 <br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！ <br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。 <br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102195650AJ.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	63,	14,	'2020-11-02 19:55:11',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256805676/movie480_vp9.webm?t=1603288313',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(264,	'龙之死印 V3.1.3s中文版百度云下载',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《龙之死印 Dragon Marked For Death》是一款横版2d滚轴动作角色扮演游戏，扮演龙血部落的幸存者完成村民的任务提高你在王国中的地位。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7,8.1,10<br />\r\n处理器: 1Ghz or faster processer<br />\r\n内存: 1 GB RAM<br />\r\n显卡: 512MB VRAM (NVIDIA GeForce, AMD Radeon)<br />\r\nDirectX 版本: 9.0c<br />\r\n存储空间: 需要 1 GB 可用空间\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。 <br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。 <br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！ <br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。 <br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n	</p>\r\n<br />',	55,	'https://fhdemo.s-cms.cn/t15/media/20201102200056dw.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	43,	9,	'2020-11-02 20:00:34',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256780881/movie480.webm?t=1586274338',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(265,	'爱上火车-Last Run!!-国际中文加强版-(官中)',	1.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	●《爱上火车-Last Run!!-》国际中文版内置简体中文、繁体中文并支持在游戏中进行切换，游戏手柄操作等附加功能的支持。并支持Lose社在日文版官网提供的额外内容。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	《爱上火车-Last Run!!-》是日本美少女游戏知名品牌Lose所制作的E-mote视觉小说。本作为本篇故事的二次强化版与各路线后日谈及续集的合集，拥有相当于两部作品的内容，字数高达200万字。本作由Cura担当原画与人物设计，进行豹负责剧本，并由tO(と)主导演出效果。中日文版同步在日本与海外进行发售。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	2016年，美少女游戏名作《爱上火车》诞生。业内顶级的e-mote演出所带来的除爆炸性的口碑外，也一举获得萌系游戏大赏的年度准大奖和剧本金奖。同时在Getchu举办的“美少女游戏大赏2016”中获得综合部门第2名、剧本部门第4名、系统部门第2名、绘图部门第6名、音乐部门第8名、影片部门第7名、角色部门（八六）第3名。可谓是各种奖拿到手软。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	2018年，随着移植PS4主机的剧情改良版《爱上火车-Pure Station-》的宣布，本作也宣布推出中文版。在当年夏天推出的本作中文版特典活动最终取得了超过106万元人民币的优异成绩，并且制造了中文版市场的多个『第一次』。这其中最大家所津津乐道的便是Lose社宣布将回报中国玩家的支持，在续作中添加以中国故事线以及以中国火车为原型创作的新角色。同年9月，《爱上火车-Pure Station-》中文版发售，发售两年来取得了销量与口碑的双丰收。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	声明：本作中的所有角色在游戏剧情发生时均已超过18岁。\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102200313it.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	28,	6,	'2020-11-02 20:01:21',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256804723/movie480_vp9.webm?t=1602677128\r\n\r\n',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(266,	'嗜血印-决战金陵城-更新-20201023-10月23（单机+联机+全DLC）',	1.00,	'<div class=\"entry-content u-text-format u-clearfix\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<p>\r\n		嗜血印》是一款武侠动作类角色扮演游戏，玩法上以核心向战斗为主体，并融合了众多战斗元素及系统与一身。如果你是一名追求热血、勇于挑战极限的玩家，《嗜血印》绝对能激发你的肾上腺素，带给你淋漓尽致的战斗体验。<br />\r\n最低配置:<br />\r\n操作系统: Windows 7+ 需要64位处理器和操作系统<br />\r\n处理器: Intel i3 Processor<br />\r\n内存: 4 GB RAM<br />\r\n显卡: Nvidia GeForce GTX 560<br />\r\nDirectX 版本: 10<br />\r\n存储空间: 需要 10 GB 可用空间\r\n	</p>\r\n	<p>\r\n		版本：单机联机全dlc<br />\r\n更新日志 2020-10-23\r\n	</p>\r\n	<p>\r\n		<a href=\"https://media.st.dl.eccdnx.com/steamcommunity/public/images/clans/34197611/d58c6f6cf7de53945f471d430ab2f29be5b657a2.png\"><img src=\"https://media.st.dl.eccdnx.com/steamcommunity/public/images/clans/34197611/d58c6f6cf7de53945f471d430ab2f29be5b657a2.png\" alt=\"\" style=\"height:auto;\" /></a> \r\n	</p>\r\n	<p>\r\n		《嗜血印》是一款武侠动作类角色扮演游戏，玩法上以核心向战斗为主体，并融合了众多战斗元素及系统与一身。<br />\r\n<a href=\"https://steamcdn-a.akamaihd.net/steam/apps/992300/extras/meimeiweibo5.gif?t=1583474726\"><img src=\"https://steamcdn-a.akamaihd.net/steam/apps/992300/extras/meimeiweibo5.gif?t=1583474726\" alt=\"\" style=\"height:auto;\" /></a><br />\r\n十年前，苏夜锦与妹妹小鲤拜于万法归宗门下修行武艺，自此远离江湖纷嚣，恬静闲逸。十年后，自称灵虚教的神秘组织入侵门派，随之天下大乱，将这对兄妹重新投入风雨飘摇的乱世之中。相依为命的妹妹被掳为人质，同门手足相继惨遭毒手……当嗜血咒印打开的那一刻，重识自我的苏夜锦，能否履行自己对所有人的承诺？而又是谁最后能扶厦将倾，拯救满目疮痍的世间于水火？<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/992300/extras/gif4.gif?t=1591832998\" alt=\"\" style=\"height:auto;\" /><br />\r\n战斗方面，本作以多武器切换为主要特点，并针对每种武器在攻速，威力及定位上的不同，设计出多种功能各异的技能，多样的技能连击，极大地提升游戏爽快度，优异的打击感和操控手感令其锦上添花。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/992300/extras/meimeizhandou.gif?t=1591832998\" alt=\"\" style=\"height:auto;\" /><br />\r\n关卡设计的亮点在于采取随机组合的形式，即玩家在死亡后重生所面对的场景、怪物、装备、机关道具的配置等均不同于之前，使游戏呈现出多样化的特征，增加关卡变数及游戏趣味性。\r\n	</p>\r\n	<div id=\"wordpress-reading-progress-end\">\r\n	</div>\r\n</div>\r\n<div id=\"pay-single-box\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n</div>\r\n<div class=\"entry-tags\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<a href=\"https://www.5dmcity.cn/tag/%e5%86%92%e9%99%a9\">冒险</a><a href=\"https://www.5dmcity.cn/tag/%e5%8a%a8%e4%bd%9c\">动作</a><a href=\"https://www.5dmcity.cn/tag/%e5%9b%bd%e4%ba%a7\">国产</a><a href=\"https://www.5dmcity.cn/tag/%e6%8a%a2%e5%85%88%e4%bd%93%e9%aa%8c\">抢先体验</a><a href=\"https://www.5dmcity.cn/tag/%e7%8b%ac%e7%ab%8b\">独立</a><a href=\"https://www.5dmcity.cn/tag/%e8%a7%92%e8%89%b2%e6%89%ae%e6%bc%94\">角色扮演</a> \r\n</div>\r\n<div class=\"article-copyright\" style=\"font-size:12.6316px;background:#F7FBFF;padding:10px 20px;border:1px dashed #E6E6E6;color:#555555;font-family:Lato, sans-serif;\">\r\n	声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。 <br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。 <br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！ <br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。 <br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除! <br />\r\n</div>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102201102BP.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	539,	53,	'2020-11-02 20:10:49',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.eccdnx.com/steam/apps/256753319/movie480.webm?t=1569898867',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(267,	'死亡搁浅 DEATH STRANDING',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《死亡搁浅 DEATH STRANDING》是由Kojima Production制作发行的一款开放世界互动游戏，是小岛秀夫工作室的最新作。游戏为我们描绘了一个宏大的世界，在人类文明崩塌的未来，你是一名快递员，试图重新连接人类之间的联系，重建人类文明。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows&reg; 10<br />\r\n处理器: Intel&reg; Core™ i5-3470 or AMD Ryzen™ 3 1200<br />\r\n内存: 8 GB RAM<br />\r\n显卡: GeForce GTX 1050 3 GB or AMD Radeon™ RX 560 4 GB<br />\r\nDirectX 版本: 12<br />\r\n存储空间: 需要 80 GB 可用空间<br />\r\n声卡: DirectX compatible<br />\r\n附注事项: 需要高级向量扩展指令集（AVX）\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">说明：winRAR解压，安装游戏记得全英文路径，关杀毒软件哦。</span></span> \r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102205351dw.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	382,	67,	'2020-11-02 20:14:12',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256792616/movie480_vp9.webm?t=1594735429',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(268,	'四海兄弟最终版/黑手党：最终版 Mafia: Definitive Edition',	1.00,	'<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">《四海兄弟: 最终版/黑手党：最终版 Mafia: Definitive Edition》是一款暴力犯罪题材的动作游戏。游戏中玩家将要来到20世纪30年代美国伊利诺伊州，在这里开始自己的黑帮生涯。伴随着禁酒令的实施，各个帮派的利益受到了威胁，帮派之间的火拼也越来越频繁和激烈，而你深处这场漩涡的中心，将该何去何从。\r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><br />\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">参演一部黑帮电影：<br />\r\n扮演一个禁酒令时期的枭雄，在黑手党中平步青云。<br />\r\n伊利诺伊州迷失天堂：<br />\r\n精心还原了20世纪30年代的城市风貌，两次世界大战期间的建筑、汽车和文化元素随处可见，还可以供玩家进行互动。<br />\r\n再造的经典：<br />\r\n高度还原经典的同时，游戏中还包含了更加丰富的故事、游戏内容和原创音乐，它将还原你记忆中的黑手党并为你带来更多惊喜。<br />\r\n入手《四海兄弟: 最终版》即可在《四海兄弟II: 最终版》和《四海兄弟III: 最终版》中解锁汤米的制服和出租车。\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 10 64-bit<br />\r\n处理器: Intel Core-i5 2550K 3.4GHz / AMD FX 8120 3.1 GHz<br />\r\n内存: 6 GB RAM<br />\r\n显卡: NVIDIA GeForce GTX 660 / AMD Radeon HD 7870<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 50 GB 可用空间\r\n</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><br />\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-size: 12.63px; white-space: normal;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">说明：winRAR解压，安装游戏记得全英文路径，关杀毒软件哦。</span></span> \r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102205927W6.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	362,	84,	'2020-11-02 20:59:12',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256801143/movie480_vp9.webm?t=1600290994',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'四海兄弟',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	'0000-00-00 00:00:00'),
(269,	'漫威复仇者联盟/Marvels Avengers',	1.00,	'<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">游戏名称：漫威复仇者联盟<br />\r\n英文名称：Marvel’s Avengers<br />\r\n游戏类型：动作冒险类(ACT)游戏<br />\r\n游戏制作：Crystal Dynamics/Eidos-Montréal/Nixxes<br />\r\n游戏发行：Square Enix<br />\r\n游戏平台：PC<br />\r\n发售时间：2020年9月4日<br />\r\n官方网站：https://www.playavengers.com\r\n	</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/997070/extras/SCOTCH_KeyArt_616.jpg?t=1599845344\" /> \r\n</p>\r\n<h2 background-color:#ffffff;\"=\"\" style=\"white-space: normal; color: rgb(49, 49, 49); font-size: 15px;\">游戏介绍\r\n	</h2>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">《漫威复仇者联盟（Marvel’s Avengers）》是由史克威尔工作室制作发行的一款以漫威系列宇宙为背景的动作冒险游戏，也是近年来大热的漫威系列电影的影改作品之一。游戏根据漫威系列的电影《复仇者联盟》为背景，向我们展示了一个宏大的漫威电影宇宙。\r\n		</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">游戏中玩家将会见到电影中出现的五位主角，美国队长、钢铁侠、雷神、浩克、黑寡妇。不要吐槽鹰眼和其他成员去哪了，这只是第一部游戏，相信后续你们会慢慢见到他们的。\r\n	</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">通过目前放出的消息来看，游戏的质量还是非常过硬的，各种酷炫的技能和英雄们的强大能力被完美体现了出来，仿佛闻到了显卡燃烧的味道。\r\n		</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/997070/ss_79c8eac1a55e0f97e5100714907e0dcce281f3d3.1920x1080.jpg?t=1599845344\" style=\"height:auto;\" /> \r\n	</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/997070/ss_6fa5e7c43513cf65e58d8862c5fad430217b4726.1920x1080.jpg?t=1599845344\" style=\"height:auto;\" /> \r\n		</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/997070/ss_8f5400b3eb53638eb434f0c2e3235f7d892b1800.1920x1080.jpg?t=1599845344\" style=\"height:auto;\" /> \r\n	</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/997070/ss_061b742d833fadf0c795cda97ac125130cfc5f78.1920x1080.jpg?t=1599845344\" style=\"height:auto;\" /> \r\n		</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/997070/ss_c333add23c1515f43b484d1f322b30780ad749b1.1920x1080.jpg?t=1599845344\" style=\"height:auto;\" /> \r\n	</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/997070/ss_2e2eaa8b3848ee55a1b39f8de317c7625ef0be0a.1920x1080.jpg?t=1599845344\" style=\"height:auto;\" /> \r\n		</p>\r\n<h2 background-color:#ffffff;\"=\"\" style=\"white-space: normal; color: rgb(49, 49, 49); font-size: 15px;\">配置要求\r\n			</h2>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">最低配置:\r\n				</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 10 64-bit<br />\r\n处理器: i3-4160 or AMD equivalent<br />\r\n内存: 8 GB RAM<br />\r\n显卡: NVIDIA GTX 950 / AMD 270 (min 2GB video ram)<br />\r\nDirectX 版本: 12<br />\r\n存储空间: 需要 75 GB 可用空间\r\n			</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">推荐配置:\r\n				</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 10 64-bit<br />\r\n处理器: Intel Core i7 4770K, 3.4 Ghz or AMD Ryzen 5 1600, 3.2 Ghz<br />\r\n内存: 16 GB RAM<br />\r\n显卡: NVIDIA GTX 1060 6GB or AMD Radeon RX 480, 8GB<br />\r\nDirectX 版本: 12<br />\r\n存储空间: 需要 110 GB 可用空间\r\n			</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><b>声明：</b><br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。 <br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。 <br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！ <br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。 <br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n				</p>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102210113V9.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	550,	82,	'2020-11-02 21:00:53',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(270,	'生化危机3：重制版/RESIDENT EVIL 3',	1.00,	'<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">不管逃到哪里也会被追至绝路。 浣熊市发生突如其来的生物灾害，更为危险的武器被投入到这个逐渐毁灭的城镇中…… 多重的危机，九死一生的惊险动作和重新构建的逃生剧情，一切超乎你的想象。 你能逃离这片绝望吗？ 同时收录另一款逃生游戏《Resident Evil Resistance》。\r\n	</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><br />\r\n</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">名称: Resident Evil 3/豪华全DLC<br />\r\n类型: 动作<br />\r\n开发商: CAPCOM Co., Ltd.<br />\r\n发行商: CAPCOM Co., Ltd.<br />\r\n系列: Resident Evil<br />\r\n发行日期: 2020年4月3日<br />\r\n最低配置:<br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: WINDOWS&reg; 7, 8.1, 10 (64-BIT Required)<br />\r\n处理器: Intel&reg; Core™ i5-4460 or AMD FX™-6300 or better<br />\r\n内存: 8 GB RAM<br />\r\n显卡: NVIDIA&reg; GeForce&reg; GTX 760 or AMD Radeon™ R7 260x with 2GB Video RAM<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 45 GB 可用空间<br />\r\n附注事项: Anticipated performance at these\r\n	</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">不管逃到哪里也会被追至绝路。\r\n</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">浣熊市发生突如其来的生物灾害，更为危险的武器被投入到这个逐渐毁灭的城镇中……\r\n	</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">多重的危机，九死一生的惊险动作和重新构建的逃生剧情，一切超乎你的想象。\r\n</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">你能逃离这片绝望吗？\r\n	</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">同时收录另一款逃生游戏《Resident Evil Resistance》。\r\n</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/952060/ss_77eda710487b89293f109cf7dcf96b4ffab0d1a1.1920x1080.jpg?t=1601519027\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/952060/ss_ef618256720e6e665f4b8b5dd11726a561e0b16e.1920x1080.jpg?t=1601519027\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/952060/ss_34f01910d65fb171a27e058cb74623c0eb53ba69.1920x1080.jpg?t=1601519027\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/952060/ss_bec8b7cef716135ea5bbd726a3342ed9ca475b31.1920x1080.jpg?t=1601519027\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/952060/ss_4f6eaac14b8e02c0a68a9c9f7627dd84cde1abb8.1920x1080.jpg?t=1601519027\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/952060/ss_43b2e9f4a8ae4669bba7aec19c5c05abcbfa61da.1920x1080.jpg?t=1601519027\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/952060/ss_a5be22331adec8054119e63a3f565a7fbef2f70b.1920x1080.jpg?t=1601519027\" style=\"height:auto;\" />\r\n	</p>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102210317eT.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	0,	0,	'2020-11-02 21:01:41',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256770136/movie480.webm?t=1576626942',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(271,	'生化危机3：重制版/RESIDENT EVIL 3',	1.00,	'<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">不管逃到哪里也会被追至绝路。 浣熊市发生突如其来的生物灾害，更为危险的武器被投入到这个逐渐毁灭的城镇中…… 多重的危机，九死一生的惊险动作和重新构建的逃生剧情，一切超乎你的想象。 你能逃离这片绝望吗？ 同时收录另一款逃生游戏《Resident Evil Resistance》。\r\n	</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><br />\r\n</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">名称: Resident Evil 3/豪华全DLC<br />\r\n类型: 动作<br />\r\n开发商: CAPCOM Co., Ltd.<br />\r\n发行商: CAPCOM Co., Ltd.<br />\r\n系列: Resident Evil<br />\r\n发行日期: 2020年4月3日<br />\r\n最低配置:<br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: WINDOWS&reg; 7, 8.1, 10 (64-BIT Required)<br />\r\n处理器: Intel&reg; Core™ i5-4460 or AMD FX™-6300 or better<br />\r\n内存: 8 GB RAM<br />\r\n显卡: NVIDIA&reg; GeForce&reg; GTX 760 or AMD Radeon™ R7 260x with 2GB Video RAM<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 45 GB 可用空间<br />\r\n附注事项: Anticipated performance at these\r\n	</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">不管逃到哪里也会被追至绝路。\r\n</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">浣熊市发生突如其来的生物灾害，更为危险的武器被投入到这个逐渐毁灭的城镇中……\r\n	</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">多重的危机，九死一生的惊险动作和重新构建的逃生剧情，一切超乎你的想象。\r\n</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">你能逃离这片绝望吗？\r\n	</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">同时收录另一款逃生游戏《Resident Evil Resistance》。\r\n</p>\r\n<p microsoft=\"\" yahei\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;font-size:13px;font-style:normal;font-weight:400;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/952060/ss_77eda710487b89293f109cf7dcf96b4ffab0d1a1.1920x1080.jpg?t=1601519027\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/952060/ss_ef618256720e6e665f4b8b5dd11726a561e0b16e.1920x1080.jpg?t=1601519027\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/952060/ss_34f01910d65fb171a27e058cb74623c0eb53ba69.1920x1080.jpg?t=1601519027\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/952060/ss_bec8b7cef716135ea5bbd726a3342ed9ca475b31.1920x1080.jpg?t=1601519027\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/952060/ss_4f6eaac14b8e02c0a68a9c9f7627dd84cde1abb8.1920x1080.jpg?t=1601519027\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/952060/ss_43b2e9f4a8ae4669bba7aec19c5c05abcbfa61da.1920x1080.jpg?t=1601519027\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/952060/ss_a5be22331adec8054119e63a3f565a7fbef2f70b.1920x1080.jpg?t=1601519027\" style=\"height:auto;\" /> \r\n	</p>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102210317eT.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	561,	88,	'2020-11-02 21:01:41',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256770136/movie480.webm?t=1576626942',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(272,	'荒野大镖客2-全DLC终极版-（官中+送神秘小姐姐补丁+线下内置修改）',	1.00,	'<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">Red Dead Redemption 2 已荣获超过 175 项年度游戏奖项且获得超过 250 个满分评价，游戏中述说亚瑟·摩根和声名狼藉的范德林德帮派的传奇故事，体验在 19 世纪的最后岁月里横跨美国的亡命之旅。\r\n	</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">游戏名称：荒野大镖客2<br />\r\n英文名称：Red Dead Redemption 2<br />\r\n游戏类型：动作冒险类(ACT)游戏<br />\r\n游戏制作：Rockstar Games<br />\r\n游戏发行：Rockstar Games<br />\r\n游戏平台：PC<br />\r\n发售时间：2019年12月5日\r\n</p>\r\n<h2 background-color:#ffffff;\"=\"\" style=\"white-space: normal; color: rgb(49, 49, 49); font-size: 15px;\">游戏介绍\r\n	</h2>\r\n<span font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">《荒野大镖客2（Red Dead: RedemptionⅡ）》作为R星精心打磨了5年的史诗级动作冒险游戏，在PS4平台一经发售就狂热地席卷了全世界玩家的喜爱，IGN甚至给出了10分的满分评价。</span><br />\r\n<br />\r\n<span font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">作为GTA5之后的首部大作，本作中的世界要比GTA5中的世界更加广大，也更具深度。除此之外，广阔的开放世界中每一个细节都做到了完美，你将会在游戏中切实地感受到高协调性和完美互动的游戏体验。</span><br />\r\n<br />\r\n<span font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">游戏以19世纪末20世纪初的美国西部为背景，你要在独狼遍地、匪帮横行的蛮荒世界中开始一段全新的旅程，而这时的西部也正由蛮荒暴力向着文明开化发展，你将有幸成为最后的镖客并见证这一段黑暗肮脏的往事。</span><br />\r\n<br />\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">游戏场景充满丰富多样的美国景观，各种景色自然地融合在一起，像是白雪覆盖的山间小路、泥泞骯脏的城镇、沼泽地、快速现代化的都市以及典型的西南边境景致等，当中充满各个地点独有的活动与谋生机会。\r\n		</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><br />\r\n	</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\">美国，1899 年。<br />\r\n亚瑟·摩根和范德林德帮众是一群逃亡在外的亡命之徒。联邦侦探和全国顶尖的赏金猎人在他们的身后穷追不舍，亚瑟一行人必须在广袤蛮荒的美国腹地上四处劫掠、挣扎求生。而帮派内部的矛盾分化日渐加深，摆在亚瑟面前的将是他无法避免的抉择：究竟是选择自己的理想，还是选择效忠于抚养了自己的帮派。<br />\r\n现已添加额外故事模式内容和功能齐全的照片模式。除此之外，Red Dead Redemption 2 玩家还可免费享受 Red Dead 在线模式中与众多玩家共享的逼真世界。此模式中，玩家可从事各种不同的职业，在边疆开拓属于自己的独特生涯。您可以成为追捕通缉犯的赏金猎人、经营自己生意的商贩、发掘珍奇宝藏的收藏家或运营地下酿酒厂的私酒贩等等。<br />\r\nRed Dead Redemption 2 PC 版借助全新图形和技术改进以增强沉浸感，并充分利用了电脑强大的性能，使这个庞大、丰富而细致的世界的每个角落都栩栩如生。包括更广的渲染距离；为改良的昼夜照明而提供的更高质量的全局照明和环境光遮蔽；改良的反射和所有距离提供更深、更高分辨率的阴影；细分曲面处理树木纹理并改善草地和毛皮纹理，使所有植物和动物都更加逼真。<br />\r\nRed Dead Redemption 2 PC 版还提供 HDR 支持，可在高端显示设置上以 4K 及更高分辨率运行、多显示器配置、宽屏配置、更快的帧速率及更多。\r\n		</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><br />\r\n	</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1174180/ss_66b553f4c209476d3e4ce25fa4714002cc914c4f.600x338.jpg?t=1597419522\" /><br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1174180/ss_bac60bacbf5da8945103648c08d27d5e202444ca.600x338.jpg?t=1597419522\" /><br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1174180/ss_668dafe477743f8b50b818d5bbfcec669e9ba93e.600x338.jpg?t=1597419522\" /><br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1174180/ss_4ce07ae360b166f0f650e9a895a3b4b7bf15e34f.600x338.jpg?t=1597419522\" /><br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1174180/ss_d1a8f5a69155c3186c65d1da90491fcfd43663d9.600x338.jpg?t=1597419522\" /> \r\n		</p>\r\n<div font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; border: none; color: rgb(69, 69, 69);\">\r\n		<div style=\"border:none;\">\r\n			<div style=\"border:none;\">\r\n				<h2 style=\"color:#313131;font-size:15px;\">\r\n					成人内容描述\r\n				</h2>\r\n				<p>\r\n					开发者对内容描述如下：\r\n				</p>\r\n				<p>\r\n					此游戏包含的内容可能不适合所有年龄段，或不宜在工作期间访问：常见成人内容\r\n				</p>\r\n			</div>\r\n		</div>\r\n			</div>\r\n<div font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; border: none; color: rgb(69, 69, 69);\">\r\n			<div style=\"border:none;\">\r\n				<h2 style=\"color:#313131;font-size:15px;\">\r\n					系统需求\r\n				</h2>\r\n				<div style=\"border:none;\">\r\n					<div style=\"border:none;\">\r\n						<div style=\"border:none;\">\r\n							<ul>\r\n								最低配置:<br />\r\n								<ul>\r\n									<li>\r\n										需要 64 位处理器和操作系统<br />\r\n									</li>\r\n									<li>\r\n										操作系统:&nbsp;Windows 7 - Service Pack 1 (6.1.7601)<br />\r\n									</li>\r\n									<li>\r\n										处理器:&nbsp;Intel&reg; Core™ i5-2500K / AMD FX-6300<br />\r\n									</li>\r\n									<li>\r\n										内存:&nbsp;8 GB RAM<br />\r\n									</li>\r\n									<li>\r\n										显卡:&nbsp;Nvidia GeForce GTX 770 2GB / AMD Radeon R9 280 3GB<br />\r\n									</li>\r\n									<li>\r\n										网络:&nbsp;宽带互联网连接<br />\r\n									</li>\r\n									<li>\r\n										存储空间:&nbsp;需要 150 GB 可用空间<br />\r\n									</li>\r\n									<li>\r\n										声卡:&nbsp;Direct X Compatible\r\n									</li>\r\n								</ul>\r\n							</ul>\r\n						</div>\r\n						<div style=\"border:none;\">\r\n							<ul>\r\n								推荐配置:<br />\r\n								<ul>\r\n									<li>\r\n										需要 64 位处理器和操作系统<br />\r\n									</li>\r\n									<li>\r\n										操作系统:&nbsp;Windows 10 - April 2018 Update (v1803)<br />\r\n									</li>\r\n									<li>\r\n										处理器:&nbsp;Intel&reg; Core™ i7-4770K / AMD Ryzen 5 1500X<br />\r\n									</li>\r\n									<li>\r\n										内存:&nbsp;12 GB RAM<br />\r\n									</li>\r\n									<li>\r\n										显卡:&nbsp;Nvidia GeForce GTX 1060 6GB / AMD Radeon RX 480 4GB<br />\r\n									</li>\r\n									<li>\r\n										网络:&nbsp;宽带互联网连接<br />\r\n									</li>\r\n									<li>\r\n										存储空间:&nbsp;需要 150 GB 可用空间<br />\r\n									</li>\r\n									<li>\r\n										声卡:&nbsp;Direct X Compatible\r\n									</li>\r\n								</ul>\r\n							</ul>\r\n						</div>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><br />\r\n	</p>\r\n<p font-size:13px;background-color:#ffffff;\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(69, 69, 69);\"><b>声明：</b><br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。 <br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。 <br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！ <br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。 <br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n		</p>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102210616eH.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	2777,	382,	'2020-11-02 21:05:27',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256768378/movie480.webm?t=1574881290',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(273,	'只狼影逝二度-年度版-1.06版（官中）',	1.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	最低配置:<br />\r\n操作系统: Windows 7 64-bit | Windows 8 64-bit | Windows 10 64-bit<br />\r\n处理器: Intel Core i3-2100 | AMD FX-6300<br />\r\n内存: 4 GB RAM<br />\r\n显卡: NVIDIA GeForce GTX 760 | AMD Radeon HD 7950<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 25 GB 可用空间<br />\r\n声卡: DirectX 11 Compatible\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	在《Sekiro: Shadows Die Twice》中你是“独臂之狼”，一个名誉不再、伤痕累累的忍者，一个从死亡边缘捡回一命的战士。你效忠守护继承古老血统的年轻皇子，与危险的苇名一族以及众多凶恶之徒为敌。年轻的皇子被抓走后，为挽回荣誉，你将不畏死亡，踏上危机四伏的征程。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	探索生死冲突不断的16世纪后期，感受残酷的日本战国时代，在黑暗、扭曲的世界，与威胁生命的敌人对峙。活用义手装备各种致命武器，大显忍者身手，在血腥对抗中潜行、上下穿梭，与敌人正面激烈交锋。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	复仇雪耻。夺回荣誉。巧妙杀敌。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/814380/ss_53d73aff4d439cbd9b9b69430f9b3b6db8d0ecd7.1920x1080.jpg?t=1603904569\" alt=\"\" style=\"height:auto;\" /><br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/814380/ss_2685dd844a2a523b6c7ec207d46a538db6a908cd.1920x1080.jpg?t=1603904569\" alt=\"\" style=\"height:auto;\" /><br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/814380/ss_15f0e9982621aed44900215ad283811af0779b1d.1920x1080.jpg?t=1603904569\" alt=\"\" style=\"height:auto;\" /> \r\n</p>\r\n<div style=\"font-size:12.6316px;\">\r\n	<br />\r\n</div>\r\n<span style=\"font-size:12.6316px;\">声明：</span><br />\r\n<span style=\"font-size:12.6316px;\">1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。 </span><br />\r\n<span style=\"font-size:12.6316px;\">2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。 </span><br />\r\n<span style=\"font-size:12.6316px;\">3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！ </span><br />\r\n<span style=\"font-size:12.6316px;\">4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。 </span><br />\r\n<span style=\"font-size:12.6316px;\">5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!</span>',	58,	'https://fhdemo.s-cms.cn/t15/media/202011022110081G.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	1817,	388,	'2020-11-02 21:09:16',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256806899/movie480_vp9.webm?t=1603837979',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(274,	'幽灵行者-豪华版（官中）',	1.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	ostrunner提供了独特的单玩家游戏体验：快节奏的暴力战斗，以及将科幻故事与世界末日主题相融合的原生环境。它讲述了一个已终结的世界，以及在其中为生存而战的居民的故事。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<br />\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	名称: Ghostrunner – 幽灵行者<br />\r\n类型: 动作<br />\r\n开发商: One More Level, 3D Realms, Slipgate Ironworks™<br />\r\n发行商: 505 Games, All in! Games<br />\r\n系列: 505 Games Official<br />\r\n发行日期: 2020年10月28日<br />\r\n最低配置:<br />\r\n操作系统: Windows 7, 8.1, 10 x64<br />\r\n处理器: Intel Core i5-2500K (4 * 3300) AMD Phenom II X4 965 (4 * 3400) or equivalent<br />\r\n内存: 8 GB RAM<br />\r\n显卡: GeForce GTX 1050 (2048 MB) / Radeon RX 550 (4096 MB)<br />\r\n存储空间: 需要 22 GB 可用空间<br />\r\n附注事项: 60FPS, Low settings, 720p)\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	Ghostrunner是一款第一人称视角硬核斩杀游戏，兼具闪电般的极速动作，故事背景发生在严酷环境里的一座赛博朋克风巨型建筑中。攀登Dharma高塔，这是人类经历末世灾难后最后的避难所。从最底层一直登上顶层，对抗暴君“Keymaster”，展开你的复仇吧。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1139900/extras/Ghostrunner_01.gif?t=1603817021\" alt=\"\" style=\"height:auto;\" /><br />\r\n高塔城市的街道里充满了暴力。“Keymaster”Mara用铁腕统治着城市，任意草菅人命。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1139900/extras/Ghostrunner_02.gif?t=1603817021\" alt=\"\" style=\"height:auto;\" /><br />\r\n随着资源的匮乏，弱肉强食和混乱即将消耗掉所剩无几的秩序。最终的决定性一刻即将来临。这是人类濒临灭绝之前的最后机会。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1139900/extras/Ghostrunner_03.gif?t=1603817021\" alt=\"\" style=\"height:auto;\" /><br />\r\n作为最先进的刀刃战士，你总是能以寡敌众，并且从未被超越。用单分子武士刀斩切敌人，凭借你超人类的反射能力躲避子弹，并利用大量特殊技能在对战中获胜。<br />\r\n一击必杀的机制令战斗激烈而快速。运用超高的机动性（和频繁的存盘点！），你将可毫无畏惧地投身永无止境的死亡之舞。<br />\r\nGhostrunner提供了独特的单玩家游戏体验：快节奏的暴力战斗，以及将科幻故事与世界末日主题相融合的原生环境。它讲述了一个已终结的世界，以及在其中为生存而战的居民的故事。\r\n</p>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102211103Fe.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	0,	0,	'2020-11-02 21:10:41',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256801084/movie480_vp9.webm?t=1600186180',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(275,	'幽灵行者-豪华版（官中）',	1.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	ostrunner提供了独特的单玩家游戏体验：快节奏的暴力战斗，以及将科幻故事与世界末日主题相融合的原生环境。它讲述了一个已终结的世界，以及在其中为生存而战的居民的故事。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<br />\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	名称: Ghostrunner – 幽灵行者<br />\r\n类型: 动作<br />\r\n开发商: One More Level, 3D Realms, Slipgate Ironworks™<br />\r\n发行商: 505 Games, All in! Games<br />\r\n系列: 505 Games Official<br />\r\n发行日期: 2020年10月28日<br />\r\n最低配置:<br />\r\n操作系统: Windows 7, 8.1, 10 x64<br />\r\n处理器: Intel Core i5-2500K (4 * 3300) AMD Phenom II X4 965 (4 * 3400) or equivalent<br />\r\n内存: 8 GB RAM<br />\r\n显卡: GeForce GTX 1050 (2048 MB) / Radeon RX 550 (4096 MB)<br />\r\n存储空间: 需要 22 GB 可用空间<br />\r\n附注事项: 60FPS, Low settings, 720p)\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	Ghostrunner是一款第一人称视角硬核斩杀游戏，兼具闪电般的极速动作，故事背景发生在严酷环境里的一座赛博朋克风巨型建筑中。攀登Dharma高塔，这是人类经历末世灾难后最后的避难所。从最底层一直登上顶层，对抗暴君“Keymaster”，展开你的复仇吧。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1139900/extras/Ghostrunner_01.gif?t=1603817021\" alt=\"\" style=\"height:auto;\" /><br />\r\n高塔城市的街道里充满了暴力。“Keymaster”Mara用铁腕统治着城市，任意草菅人命。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1139900/extras/Ghostrunner_02.gif?t=1603817021\" alt=\"\" style=\"height:auto;\" /><br />\r\n随着资源的匮乏，弱肉强食和混乱即将消耗掉所剩无几的秩序。最终的决定性一刻即将来临。这是人类濒临灭绝之前的最后机会。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1139900/extras/Ghostrunner_03.gif?t=1603817021\" alt=\"\" style=\"height:auto;\" /><br />\r\n作为最先进的刀刃战士，你总是能以寡敌众，并且从未被超越。用单分子武士刀斩切敌人，凭借你超人类的反射能力躲避子弹，并利用大量特殊技能在对战中获胜。<br />\r\n一击必杀的机制令战斗激烈而快速。运用超高的机动性（和频繁的存盘点！），你将可毫无畏惧地投身永无止境的死亡之舞。<br />\r\nGhostrunner提供了独特的单玩家游戏体验：快节奏的暴力战斗，以及将科幻故事与世界末日主题相融合的原生环境。它讲述了一个已终结的世界，以及在其中为生存而战的居民的故事。\r\n</p>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102211103Fe.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	295,	65,	'2020-11-02 21:10:41',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256801084/movie480_vp9.webm?t=1600186180',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(276,	'《OCTOPATH TRAVELER 歧路旅人/八方旅人》',	0.00,	'<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">游戏介绍：</span></span> \r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《OCTOPATH TRAVELER 歧路旅人/八方旅人》是一款由Square Enix制作发行的日式角色扮演类游戏，本作的故事发生在名为奥斯泰拉（オルステラ）的大陆，在这款游戏中，共有八个职业和个性迥异的主角，包括战士、法师、盗贼，舞女、药剂师、猎人、商人、驯兽者各路角色。玩家扮演其中之一在世界各地自由旅行，包括出生的地方也将成为旅行的目的地。\r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">游戏特色：</span></span> \r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">– 可扮演八个不同的角色，每一个角色都有各自的故事和要完成的支线任务<br />\r\n– 探索迷人但危险的奥鲁斯特拉大陆，跨越8片广阔的区域，并随着旅程的展开，揭开每个角色的完整故事<br />\r\n– 使用每个角色的独特能力（地图指令）、技能和属性展开疯狂的战斗<br />\r\n– 享受易上手但深度的回合式对战系统，并可通过识别和瞄准敌人的弱点来突破他们的防线<br />\r\n– 可采取不同方式完成支线任务和故事场景，并做出将塑造角色人生道路的决定<br />\r\n– 体验受启于复古2D RPG游戏的视觉效果，欣赏美不胜收的写实元素打造出来的 3D 世界\r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows&reg; 7 SP1 / 8.1 / 10 64-bit<br />\r\n处理器: AMD FX-4350 / Intel&reg; Core™ i3-3210<br />\r\n内存: 4 GB RAM<br />\r\n显卡: AMD Radeon™ R7 260X (2GB VRAM) / NVIDIA&reg; GeForce&reg; GTX 750(2GB VRAM)<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 5 GB 可用空间<br />\r\n声卡: DirectX Compatible Sound Card<br />\r\n附注事项: 30+ FPS @ 1280×720 / graphics preset “LOW”\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201102221000ZT.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	172,	55,	'2020-11-02 22:06:47',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256747854/movie480.webm?t=1555344057',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(277,	'告别回忆-无垢少女',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《告别回忆-无垢少女- Memories Off Innocent Fille》是一款日系视觉小说，《告别回忆》系列不仅仅是描写出甜蜜的爱情故事，更是展露出因复杂的人际关係所产生的爱情样貌。错综复杂的情感纠缠不清，无论是擦身而过或是相遇都会为剧情的展开掀起波澜。日本KID会社宝藏级作品，大名鼎鼎的美少女恋爱冒险游戏《秋之回忆8：无垢少女》终于登陆steam了！该系列1998年至今共发售8部正传作品，曾经依靠代理家用游戏机游戏起家的KID在多重游戏经济市场竞争打压下，孤注一掷，倾尽所有打造的《秋之回忆》系列不仅挽救了自家公司，也让无数热爱GalGame的粉丝们大呼过瘾，相信这部高水准制作的MO8不会让你失望！\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7/8.1/10<br />\r\n处理器: 第三世代（Ivy Bridge）以降のモバイル向けCore i5以上<br />\r\n内存: 4 GB RAM<br />\r\n显卡: ディスクリートGPUの场合3GB / GPUがオンボードの场合4GB以上<br />\r\nDirectX 版本: 9.0<br />\r\n存储空间: 需要 10 GB 可用空间<br />\r\n声卡: DirectSoundが正常に动作するサウンドデバイス必须\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">说明：winRAR解压，安装游戏记得全英文路径，关杀毒软件哦。</span></span> \r\n	</p>\r\n	<div>\r\n		<br />\r\n	</div>',	59,	'https://fhdemo.s-cms.cn/t15/media/202011022215183n.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	70,	16,	'2020-11-02 22:10:54',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(278,	'脑叶公司',	1.00,	'<h2 class=\"bb_tag\" style=\"font-weight:normal;font-size:15px;color:#2F89BC;font-family:&quot;background-color:#1B2838;\">\r\n	<span>管理五花八门的怪诞生物们，一切超乎您的想象！</span>\r\n</h2>\r\n<br />\r\n<strong>脑叶公司”是一款管理怪物的Rogue-Lite模拟游戏。&nbsp;</strong><br />\r\n<br />\r\n<span style=\"color:#ACB2B8;font-family:&quot;font-size:14px;background-color:#1B2838;\">游戏的灵感来源于那些在小说，游戏和电影中登场的怪物们，例如《SCP基金会》，《林中小屋》，《第十三号仓库》等等。“如果这些怪物都是真实存在的，而你的工作就是管理它们，那会发生些什么呢？”带着这样的想法，我们制作了这款游戏。</span><br />\r\n<br />\r\n<span style=\"color:#ACB2B8;font-family:&quot;font-size:14px;background-color:#1B2838;\">在游戏中，您将扮演一位怪物管理公司的主管，不断解锁新的部门，研发新的科技，并遇见形形色色的怪诞生物们。公司收容的怪物能够产出一种全新的能源，而您的职责就是在尽可能避免员工损失的前提下收集这些能源——这意味着您将在紧张与恐怖的气氛中进行游戏。</span><br />\r\n<br />\r\n<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/568220/extras/Steambanner_Management.png?t=1582851106\" />\r\n<h2 class=\"bb_tag\" style=\"font-weight:normal;font-size:15px;color:#2F89BC;font-family:&quot;background-color:#1B2838;\">\r\n	<span>“我们的新科技将会给人类带来救赎。”</span>\r\n</h2>\r\n<span style=\"color:#ACB2B8;font-family:&quot;font-size:14px;background-color:#1B2838;\">“脑叶公司是一家运用自主研发的科技将怪物从人类社会中隔离，并从它们身上获取无尽能量的新型能源公司。”——然而这只是社会大众对公司的印象，在您加入公司并任职主管后，您将会一步一步揭露这家公司光鲜外表下那不为人知的真相。</span><br />\r\n<br />\r\n<span style=\"color:#ACB2B8;font-family:&quot;font-size:14px;background-color:#1B2838;\">脑叶公司也和其他公司一样，由许多不同的部门构成。随着能源收集总量的增加，您也会获得解锁更多部门的权限。解锁的部门越多，管理怪物们的效率就会越高。</span><br />\r\n<br />\r\n<span style=\"color:#ACB2B8;font-family:&quot;font-size:14px;background-color:#1B2838;\">除此之外，人工智能“Angela”以及各个部门的“Sephirah”们也会陪伴在您的身边，辅佐您顺利完成自己的工作。</span><br />\r\n<br />\r\n<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/568220/extras/Steambanner_Observation.png?t=1582851106\" />\r\n<h2 class=\"bb_tag\" style=\"font-weight:normal;font-size:15px;color:#2F89BC;font-family:&quot;background-color:#1B2838;\">\r\n	<span>它们，是需要您不断观察和研究的存在。</span>\r\n</h2>\r\n<span style=\"color:#ACB2B8;font-family:&quot;font-size:14px;background-color:#1B2838;\">我们将公司收容的怪物们称为“异想体”。</span><br />\r\n<br />\r\n<span style=\"color:#ACB2B8;font-family:&quot;font-size:14px;background-color:#1B2838;\">身为一名主管，您必须竭尽全力使员工们远离异想体带来的威胁，同时保证能源生产效率维持在最优水平。</span><br />\r\n<br />\r\n<span style=\"color:#ACB2B8;font-family:&quot;font-size:14px;background-color:#1B2838;\">最一开始，您不会得到任何有关异想体的情报，能够指引您的唯有《主管手册》和自己的双眼。您需要在实践中推测出每一个异想体的工作偏好，在那之后，您只需派遣员工们对其进行最合适的工作，然后静待结果就好了。除此之外，在管理异想体的过程当中您还将获得能够解锁情报的“独立PE-BOX点数”，这些点数会帮助您更加清晰地了解各个异想体的背景故事以及应对方法。</span><br />\r\n<br />\r\n<span style=\"color:#ACB2B8;font-family:&quot;font-size:14px;background-color:#1B2838;\">对不同的异想体进行不同的工作，您所能获得的能量是有极大差别的。</span><br />\r\n<br />\r\n<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/568220/extras/Steambanner_Escape.png?t=1582851106\" />\r\n<h2 class=\"bb_tag\" style=\"font-weight:normal;font-size:15px;color:#2F89BC;font-family:&quot;background-color:#1B2838;\">\r\n	<span>脑叶公司并不是和谐欢乐的经营大亨类游戏。。</span>\r\n</h2>\r\n<span style=\"color:#ACB2B8;font-family:&quot;font-size:14px;background-color:#1B2838;\">正如之前所说，在管理过程中，您需要时刻警惕这些被称为“异想体”的怪物。有些异想体并不喜欢被弱小的人类关押在收容单元中，它们会费尽心思突破收容，一有机会就尝试逃脱，并摧毁它们遇到的一切，无论是我们的员工，还是这个设施本身——最糟糕的情况是，它们会打开其他异想体的收容单元，将它们一并放出来。</span><br />\r\n<br />\r\n<span style=\"color:#ACB2B8;font-family:&quot;font-size:14px;background-color:#1B2838;\">除此之外，某些异想体还具有对员工进行精神控制，使其腐化堕落并据为己用的能力，被控制的员工会盲目地袭击身边的同事，或是对其他员工造成不良的影响。部分恐怖的异想体还会提高员工的精神污染指数，最终导致员工们陷入恐慌，违抗您的命令。您当然可以“处理”掉这些员工，但请注意员工本身的“信息”和“存在”都会被一并“处理”掉。</span><br />\r\n<br />\r\n<br />\r\n<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/568220/extras/Steambanner_Suppression.png?t=1582851106\" />\r\n<h2 class=\"bb_tag\" style=\"font-weight:normal;font-size:15px;color:#2F89BC;font-family:&quot;background-color:#1B2838;\">\r\n	<span>一场灾难将导致另一场灾难，最终一切都会被引向混乱。</span>\r\n</h2>\r\n<br />\r\n<span style=\"color:#ACB2B8;font-family:&quot;font-size:14px;background-color:#1B2838;\">如果您不能及时镇压出逃的异想体，局势就会逐渐失控，进而使整个公司陷入混乱之中。每当有异想体突破收容的时候，您必须做出抉择——是召集您的员工去镇压危险的异想体？还是牺牲小部分的设施来确保大多数员工的安全？</span><br />\r\n<br />\r\n<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/568220/extras/Steambanner_Story1.png?t=1582851106\" />\r\n<h2 class=\"bb_tag\" style=\"font-weight:normal;font-size:15px;color:#2F89BC;font-family:&quot;background-color:#1B2838;\">\r\n	<span>“主管，您有什么愿望吗？”</span>\r\n</h2>\r\n<span style=\"color:#ACB2B8;font-family:&quot;font-size:14px;background-color:#1B2838;\">游戏分为“管理流程”及“故事情节”这两部分。</span><br />\r\n<br />\r\n<span style=\"color:#ACB2B8;font-family:&quot;font-size:14px;background-color:#1B2838;\">在管理流程中，您将以一位主管的身份来管理公司收容的异想体并生产能源。每天的管理工作结束之后，您将进入游戏相关的故事情节。</span><br />\r\n<br />\r\n<span style=\"color:#ACB2B8;font-family:&quot;font-size:14px;background-color:#1B2838;\">在故事情节中，您将与人工智能“Angela”以及各部门的“Sephirah”们进行简短的对话，他们也会出现在您之后的管理流程当中。通过完成他们提供的任务，您可以发现越来越多有关脑叶公司的秘密。有时，玩家也会置身于必须“回答”或是“提问”的情境之中。而在这个情境中，您将进一步挖掘那掩藏在层层阴霾下的真相。</span>',	36,	'https://fhdemo.s-cms.cn/t15/media/20201102224737ES.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	44,	8,	'2020-11-02 22:46:17',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256704588/movie480.webm?t=1523285123',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(279,	'《噬神者3 God Eater 3》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《噬神者3 God Eater 3》是一款二次元向的动作冒险类游戏，因随时切换打击与射击施展的高速动作、个性鲜明的角色们，以及壮阔的故事而充满魅力的「噬神者」系列最新作，即将带着崭新神机、荒神与进化过的动作登场！\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">■新神机零件登场<br />\r\n近身武器零件方面新追加二刀流神机「噬咬双刃」，以及能变形成斧状的圆月型双手持神机「沉重圆月」！枪身零件则有「雷射枪」新登场，战斗风格将更加多元！<br />\r\n■让战斗更爽快、豪迈进化的新动作<br />\r\n运用让地上、空中、垫步各动作于神机解放中进化为必杀技的「解放技艺」，以及崭新移动攻击「展盾突进」，尽情纵横战场玩弄荒神吧！<br />\r\n■能进行捕食攻击的新威胁──「灰域种」登场<br />\r\n新登场的荒神──「灰域种」，能透过捕食噬神者们进入解放状态，战斗能力将飞跃性提升。以进化过的动作为武器，迎战前所未有的威胁吧！\r\n	</p>\r\n	<div>\r\n		<br />\r\n	</div>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201102225208Km.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	78,	23,	'2020-11-02 22:49:45',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256739725/movie480.webm?t=1547830856',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(280,	'逆转裁判123：成步堂合辑 ',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《逆转裁判123：成步堂合辑 Phoenix Wright: Ace Attorney Trilogy / 逆転裁判123 成歩堂セレクション》是以法庭为舞台的冒险游戏。玩家将扮演律师「成步堂龙一」，为证明委託人的清白而踏上法庭。此精选集收录了作为系列原点的《逆转裁判 復甦的逆转》、《逆转裁判2》和《逆转裁判3》共14话。 ※简繁中文字幕将于发售后以更新包形式追加。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">最低配置:</span></span><br />\r\n操作系统: WINDOWS&reg; 7, 8.1, 10 (64bit)<br />\r\n处理器: Intel&reg; Core™ i3-4160<br />\r\n内存: 4 GB RAM<br />\r\n图形: Intel&reg; HD Graphics 4400<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 1.8 GB 可用空间\r\n</p>',	59,	'https://fhdemo.s-cms.cn/t15/media/20201102232010bN.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	55,	25,	'2020-11-02 23:19:25',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256759771/movie480.webm?t=1566464237',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(281,	'火炬之光3-（官中正式版)',	1.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	名称: Torchlight III<br />\r\n类型: 动作, 冒险, 角色扮演, 抢先体验<br />\r\n开发商: Echtra Inc.<br />\r\n发行商: Perfect World Entertainment<br />\r\n系列: Torchlight<br />\r\n发行日期: 2020年6月14日<br />\r\n最低配置:<br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7, 8.1, 10 (64-Bit)<br />\r\n处理器: Quad-Core Intel or AMD Processor, 2.5 Ghz or Faster<br />\r\n内存: 4 GB RAM<br />\r\n显卡: NVIDIA GeForce 470 GTX or AMD Radeon 6870 HD Series Card or Higher<br />\r\n存储空间: 需要 10 GB 可用空间<br />\r\n附注事项: Specifications are not final and are subject to change.\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	《火炬之光 2》的事件已经过去了一个世纪，烬石帝国进入衰退期。在《火炬之光 3》中，诺瓦特拉亚再一次陷入遭到侵略的危机之中，你必须挺身而出抵挡冥裔和它们的帮凶。打起十二分精神，勇敢地在前线中战斗，赢取声望、荣誉，并体验新的冒险！<br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1030210/extras/Frontier-Steam-Image.jpg?t=1600115984\" style=\"height:auto;\" /><br />\r\n在前线中旅行 —— 探索荒野、与好友组队、收集材料来打造装备或使用魔法来进入未知的地牢！在新的前线，你总能找到有趣的事情可做。<br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1030210/extras/Forts-Steam-Image.jpg?t=1600115984\" style=\"height:auto;\" /><br />\r\n修建并升级你的要塞 —— 现在我们要展开重建，你也必须参与其中！你可以拥有属于自己的要塞，在那里你可以升级装备或改造你的要塞，并向你的朋友们甚至全世界展示你的设计。<br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1030210/extras/Epic-Gear-Steam-Image.jpg?t=1600115984\" style=\"height:auto;\" /><br />\r\n收集史诗装备 —— 不论是护甲、武器、染料、配方、烬石核心，或甚至是新的宠物……随着你在地牢中不断深入、与危险的敌人作战，你永远会找到更多的物品！<br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1030210/extras/Pets-Steam-Image.jpg?t=1600115984\" style=\"height:auto;\" /><br />\r\n宠物回归啦 —— 你可以带着你忠诚的伙伴一同赢得名望与荣耀！你可以让它们学习新的技能或使用装备来让它们变得更强。每一种宠物都拥有多种不同的颜色和样式，所以一定要把它们都收集齐！<br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1030210/extras/Build-Your-Hero-Steam-Image.jpg?t=1600115984\" style=\"height:auto;\" /><br />\r\n培养你的英雄 —— 你可以选择四种独特的职业，并使用职业特有的机制来提高伤害、增加生存能力。你还可以搭配各种史诗装备、圣物能力和职业技能来自定义你的游戏风格。\r\n</p>',	58,	'https://fhdemo.s-cms.cn/t15/media/202011022337266t.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	86,	16,	'2020-11-02 23:36:55',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256787481/movie480_vp9.webm?t=1592515670',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(282,	'轩辕剑柒:数字豪华版-(官中）',	0.00,	'<p style=\"font-family:Lato, sans-serif;color:#555555;font-size:15px;background-color:#F6F6F6;\">\r\n	关于版本\r\n</p>\r\n<p style=\"font-family:Lato, sans-serif;color:#555555;font-size:15px;background-color:#F6F6F6;\">\r\n	《轩辕剑柒》将提供“数字标准版”和“数字豪华版”两个版本供玩家选购：数字标准版售价为99元，数字豪华版129元。其中数字豪华版除了包含游戏本体外，还会附赠《轩辕剑》艺术设定集，其中内含游戏的数字原声音乐专辑和数字美术设定集。\r\n</p>\r\n<p style=\"font-family:Lato, sans-serif;color:#555555;font-size:15px;background-color:#F6F6F6;\">\r\n	<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steamcommunity/public/images/clans/37047233/04340296b4ef3f02709931c5b8dce9e88efb68ec.jpg\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E8%BD%A9%E8%BE%95%E5%89%91%E6%9F%92%E9%A6%96%E5%8F%91%E7%89%B9%E5%85%B8%E5%86%85%E5%AE%B9%E4%B8%80%E8%A7%88_%E7%9B%B4%E7%B0%A1.jpg?t=1603918228\" style=\"height:auto;\" /><br />\r\n《轩辕剑柒》是一款即时制角色扮演游戏，亦是经典RPG系列《轩辕剑》的最新单机作品。玩家将扮演遗孤太史昭，在动荡的西汉末年，为保护家人，踏上斩妖除魔、追寻真相之路。<br />\r\n故事背景<br />\r\n西汉末年，王莽代汉而立，国号为「新」。时年，石文现，石牛出，古墓开，各种符命与异兆纷呈。留侯墓出土了一片奇特的竹简，连夜送交太史令。没想到，当竹简送达以后，当夜竟离奇失火，太史令满门尽亡，竹简也不翼而飞。<br />\r\n十年过去了，符命与异兆所预言的太平盛世并没有到来。连年天灾人祸导致民不聊生，百姓苦不堪言，各地纷纷揭竿而起。就在此时，消失十年的竹简再度出现了，掀起一阵波澜……<br />\r\n游戏特色<br />\r\n战斗系统全面革新<br />\r\n《轩辕剑柒》将采用动作性更强的即时制战斗模式。<br />\r\n连招、武技、闪避、格挡、反击等战斗要素一应俱全，带来更为畅快的战斗体验。<br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E7%99%BE%E9%AC%BC%E5%A4%9C%E8%A1%8C.gif?t=1602038453\" style=\"height:auto;\" /><br />\r\n不一样的天书系统<br />\r\n系列经典元素「天书」正式回归，并在太史昭的冒险历程中提供多种机能：<br />\r\n「天书之力」——战斗中可以发动，短时间内大幅提升角色能力。<br />\r\n「收妖」「炼化」——玩家可借助天书之力收伏妖魔，作为炼化的素材；炼化不仅会产生新的妖魔，更有概率生成御魂，强化太史昭自身能力。<br />\r\n「神兵」「天衣」「机关」「聚灵」——多种设施齐聚天书世界，提供武器强化、防具打造、饰品制作、御魂培养等不同功效。<br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E6%A2%BC%E6%9D%8C1.gif?t=1602038453\" style=\"height:auto;\" /><br />\r\n机关科技再现，墨家重返舞台<br />\r\n《轩辕剑肆》之后，墨家机关术再度登上舞台。<br />\r\n曾一度与儒家比肩的显学——墨家，经历西汉后更趋衰落。派系分歧愈演愈烈，传承已久的信仰再次受到挑战。墨家会在乱世中彻底分崩离析，还是重新走向振兴之路？将由玩家亲自见证。<br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E6%94%B6%E5%A6%96.gif?t=1602038453\" style=\"height:auto;\" /><br />\r\n虚幻4打造 再现乱世百态<br />\r\n《轩辕剑柒》采用全新引擎打造，整体画质相比历代作品将有质的飞跃，带领玩家进入西汉末年的中原大地。<br />\r\nPC版还将支持NVIDIA的光线追踪技术，让场景更加真实。<br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E7%9C%BA%E6%9C%9B%E9%95%BF%E5%AE%89.gif?t=1602038453\" style=\"height:auto;\" /><br />\r\n全新动捕技术 演出规格提升<br />\r\n引入全新动作捕捉系统。<br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E5%87%9D%E8%A7%86.gif?t=1602038453\" style=\"height:auto;\" /><br />\r\n运用多元化的演出手段，演出效果及人物刻画更上一层楼。\r\n</p>\r\n<p style=\"font-family:&quot;color:#666666;background-color:#FFFFFF;font-size:12.63px;\">\r\n	丰富的人物神情，流畅的角色动作，让游戏故事更加生动。\r\n</p>\r\n<p style=\"font-family:&quot;color:#666666;background-color:#FFFFFF;font-size:12.63px;\">\r\n	声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。&nbsp;<br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。&nbsp;<br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！&nbsp;<br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。&nbsp;<br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102234935Fo.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	627,	79,	'2020-11-02 23:49:00',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256798341/movie480_vp9.webm?t=1598372090',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(283,	'轩辕剑柒:数字豪华版-(官中）',	1.00,	'<p style=\"font-family:Lato, sans-serif;color:#555555;font-size:15px;background-color:#F6F6F6;\">\r\n	关于版本\r\n</p>\r\n<p style=\"font-family:Lato, sans-serif;color:#555555;font-size:15px;background-color:#F6F6F6;\">\r\n	《轩辕剑柒》将提供“数字标准版”和“数字豪华版”两个版本供玩家选购：数字标准版售价为99元，数字豪华版129元。其中数字豪华版除了包含游戏本体外，还会附赠《轩辕剑》艺术设定集，其中内含游戏的数字原声音乐专辑和数字美术设定集。\r\n</p>\r\n<p style=\"font-family:Lato, sans-serif;color:#555555;font-size:15px;background-color:#F6F6F6;\">\r\n	<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steamcommunity/public/images/clans/37047233/04340296b4ef3f02709931c5b8dce9e88efb68ec.jpg\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E8%BD%A9%E8%BE%95%E5%89%91%E6%9F%92%E9%A6%96%E5%8F%91%E7%89%B9%E5%85%B8%E5%86%85%E5%AE%B9%E4%B8%80%E8%A7%88_%E7%9B%B4%E7%B0%A1.jpg?t=1603918228\" style=\"height:auto;\" /><br />\r\n《轩辕剑柒》是一款即时制角色扮演游戏，亦是经典RPG系列《轩辕剑》的最新单机作品。玩家将扮演遗孤太史昭，在动荡的西汉末年，为保护家人，踏上斩妖除魔、追寻真相之路。<br />\r\n故事背景<br />\r\n西汉末年，王莽代汉而立，国号为「新」。时年，石文现，石牛出，古墓开，各种符命与异兆纷呈。留侯墓出土了一片奇特的竹简，连夜送交太史令。没想到，当竹简送达以后，当夜竟离奇失火，太史令满门尽亡，竹简也不翼而飞。<br />\r\n十年过去了，符命与异兆所预言的太平盛世并没有到来。连年天灾人祸导致民不聊生，百姓苦不堪言，各地纷纷揭竿而起。就在此时，消失十年的竹简再度出现了，掀起一阵波澜……<br />\r\n游戏特色<br />\r\n战斗系统全面革新<br />\r\n《轩辕剑柒》将采用动作性更强的即时制战斗模式。<br />\r\n连招、武技、闪避、格挡、反击等战斗要素一应俱全，带来更为畅快的战斗体验。<br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E7%99%BE%E9%AC%BC%E5%A4%9C%E8%A1%8C.gif?t=1602038453\" style=\"height:auto;\" /><br />\r\n不一样的天书系统<br />\r\n系列经典元素「天书」正式回归，并在太史昭的冒险历程中提供多种机能：<br />\r\n「天书之力」——战斗中可以发动，短时间内大幅提升角色能力。<br />\r\n「收妖」「炼化」——玩家可借助天书之力收伏妖魔，作为炼化的素材；炼化不仅会产生新的妖魔，更有概率生成御魂，强化太史昭自身能力。<br />\r\n「神兵」「天衣」「机关」「聚灵」——多种设施齐聚天书世界，提供武器强化、防具打造、饰品制作、御魂培养等不同功效。<br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E6%A2%BC%E6%9D%8C1.gif?t=1602038453\" style=\"height:auto;\" /><br />\r\n机关科技再现，墨家重返舞台<br />\r\n《轩辕剑肆》之后，墨家机关术再度登上舞台。<br />\r\n曾一度与儒家比肩的显学——墨家，经历西汉后更趋衰落。派系分歧愈演愈烈，传承已久的信仰再次受到挑战。墨家会在乱世中彻底分崩离析，还是重新走向振兴之路？将由玩家亲自见证。<br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E6%94%B6%E5%A6%96.gif?t=1602038453\" style=\"height:auto;\" /><br />\r\n虚幻4打造 再现乱世百态<br />\r\n《轩辕剑柒》采用全新引擎打造，整体画质相比历代作品将有质的飞跃，带领玩家进入西汉末年的中原大地。<br />\r\nPC版还将支持NVIDIA的光线追踪技术，让场景更加真实。<br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E7%9C%BA%E6%9C%9B%E9%95%BF%E5%AE%89.gif?t=1602038453\" style=\"height:auto;\" /><br />\r\n全新动捕技术 演出规格提升<br />\r\n引入全新动作捕捉系统。<br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1249800/extras/%E5%87%9D%E8%A7%86.gif?t=1602038453\" style=\"height:auto;\" /><br />\r\n运用多元化的演出手段，演出效果及人物刻画更上一层楼。\r\n</p>\r\n<p style=\"font-family:&quot;color:#666666;background-color:#FFFFFF;font-size:12.63px;\">\r\n	丰富的人物神情，流畅的角色动作，让游戏故事更加生动。\r\n</p>\r\n<p style=\"font-family:&quot;color:#666666;background-color:#FFFFFF;font-size:12.63px;\">\r\n	声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。&nbsp;<br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。&nbsp;<br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！&nbsp;<br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。&nbsp;<br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	58,	'https://fhdemo.s-cms.cn/t15/media/20201102234935Fo.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	0,	0,	'2020-11-02 23:49:00',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256798341/movie480_vp9.webm?t=1598372090',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(284,	'冥河暗影大师',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">在《冥河：暗影大师(Styx: Master of Shadows)》中，随着游戏的进行，玩家操控的Styx需要通过暗杀，收集信息，偷盗，探索等手段来完成一系列的任务，最终潜入高塔的顶端盗取一样特殊的神器，从而揭开自己的起源之谜。本作拥有RPG元素，玩家升级之后可以在6种天赋树中解锁更多技能和武器提升选型，游戏同时拥有开放的游关卡景以及多样化的任务完成途径。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">最低配置:</span></span><br />\r\n操作系统: WINDOWS VISTA SP2/WINDOWS 7/WINDOWS 8<br />\r\n处理器: AMD/INTEL DUAL-CORE 2.4 GHZ<br />\r\n内存: 3072 MB RAM<br />\r\n图形: 1024 MB 100% DIRECTX 9 AND SHADERS 4.0 COMPATIBLE AMD RADEON HD 5850/NVIDIA GEFORCE GTX 560 OR HIGHER<br />\r\n存储空间: 需要 8 GB 可用空间\r\n</p>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201102235310LQ.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	24,	7,	'2020-11-02 23:53:03',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/2034896/movie480.webm?t=1447364122',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(285,	'维京人中之狼 ',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《维京：人中之狼 Vikings – Wolves of Midgard》是一款动作角色扮演游戏，你将和可怕的巨人、恐怖的亡灵生物，以及诸神黄昏中的凶兽们交战，并与可能永久终结一切生命的严寒抗争。精通剑盾、战锤、双斧、法杖和弓箭等强力武器，在战斗中获取敌人的鲜血献祭诸神，精进自己的法术与技能。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">北欧神话与奇幻故事相结合<br />\r\n化身骁勇善战的维京战士，深入米德加德之境，转战冰雪国度尼福尔海姆和火巨人王国巴尔海姆。<br />\r\n严酷的芬布尔之冬<br />\r\n忍受致命严寒，千万别在这样的风雪中待太久，小心被大自然吞噬。<br />\r\n献祭诸神<br />\r\n从杀死的敌人身上收集鲜血，通过祭坛献给诸神，提升自身力量。<br />\r\n狂战士之怒<br />\r\n开启狂怒模式浴血奋战，借助怒火之力碾压敌人。<br />\r\n战斗之道<br />\r\n剑、弓、法杖等多中武器可供选择，研习每一类武器，领会其中奥义。<br />\r\n诸神之力<br />\r\n装备神器，如索尔或洛基的护身符，让诸神之力成为你的力量。完成诸神的试炼来提升技能，并获取丰厚的奖励。<br />\r\n团队协作<br />\r\n叫上朋友一同探索米德加德海岸，在双人协作模式中开启史诗之旅。根据自身水平，从四种难度中选择挑战。还可开启残酷的硬核模式，敢来一战否？\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7/8/10 64Bit Versions<br />\r\n处理器: Intel Compatible 2.1 GHz Dual Core<br />\r\n内存: 4 GB RAM<br />\r\n显卡: GTX460 2GB or compatible<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 10 GB 可用空间\r\n</p>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201103000629Ku.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	33,	6,	'2020-11-02 23:55:49',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256678433/movie480.webm?t=1485328802',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(286,	'忍者传三好家的陨落 ',	0.00,	'<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏介绍：</strong></span> \r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">《忍者传：三好家的陨落 Tale of Ninja》是一款以日本战国历史为背景的忍者扮演游戏。玩家会在每关接到一个暗杀目标。但每次接到任务后得到的只有非常有限的情报，接下来怎么去达成目标得靠玩家自己去发现和判断。通常的每次任务都有“风，林，火，山”四种方式通过，既四种不同的忍道。\r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>最低配置:</strong></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7 64-bit | Windows 8 64-bit | Windows 10 64-bit<br />\r\n处理器: intel Core i3-2100 | AMD FX-6300<br />\r\n内存: 4 GB RAM<br />\r\n显卡: NVIDIA GeForce GTX 760 | AMD Radeon HD 7950<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 10 GB 可用空间\r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。 <br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。 <br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！ <br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。 <br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n	</p>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201103000715YV.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	42,	6,	'2020-11-03 00:06:59',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256804044/movie480_vp9.webm?t=1603338089',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(287,	'狙击手：幽灵战士 契约 Sniper Ghost Warrior Contracts',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《狙击手：幽灵战士 契约 Sniper Ghost Warrior Contracts》是一款第一人称射击游戏，在现代西伯利亚的恶劣地形中体验纯粹的狙击手游戏玩法，全新的基于契约的系统鼓励玩家在引人入胜、可重复挑战的任务中进行战略性思考。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">• 扮演一名履行雇佣契约的暗杀者，击败你的竞争对手。<br />\r\n• 开放式的契约、赏金和支线行动提供百玩不厌的选择，可反复多变地完成目标，赚取金钱，兑换升级和奖励。当心与你竞争的狙击手，他们会毫不犹豫地破坏你的完美计划。<br />\r\n• 强化瞄准镜模式提供最逼真的狙击体验，紧张刺激，有各种各样的目标和上百种击杀方式。<br />\r\n• 重新设计了游戏中的显示面板和用户界面，融入战术标记系统，用于标记要杀的敌人。<br />\r\n• 武器库加入大量新奇装置，包括无人机、远程狙击炮塔、粘性炸弹和毒气！<br />\r\n• 尽情展现你的暗杀技巧，悄无声息地击毙目标，凭借机智沉稳的发挥赚取丰厚的报酬。<br />\r\n• 与残酷的西伯利亚荒野作斗争，在冰天雪地的山脉、枝叶繁茂的森林以及深山里的秘密基地中为生存而战。<br />\r\n• 在全新而独特的地图上进行在线团队死亡匹配模式，检验你的狙击技术。\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7/8.1/10 64-bit<br />\r\n处理器: i3 3240 3.4 GHz or AMD FX-6350 3.9 GHz<br />\r\n内存: 8 GB RAM<br />\r\n图形: NVIDIA GeForce GTX 660 2GB or AMD Radeon HD 7850 2GB<br />\r\nDirectX 版本: 11\r\n</p>',	44,	'https://fhdemo.s-cms.cn/t15/media/20201103001148vA.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	123,	23,	'2020-11-03 00:09:18',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256689001/movie480.webm?t=1500290552',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(288,	'昏迷2:恶毒姐妹',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《昏迷2:恶毒姐妹 The Coma 2: Vicious Sisters》是一款设定在韩国的恐怖生存游戏。探索荒废的校园，在黑夜魔物的围猎中求得生存。搜寻世华高中及其附近区域并找出这个黑暗世界的真相。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	黑暗宋老师的无尽追击现在搭载了全新AI，更加可怕。\r\n</li>\r\n<li>\r\n	制造道具来为生死一线的情况做好准备。\r\n</li>\r\n<li>\r\n	探索被噩梦笼罩的世华高中，探索其黑暗的秘密。\r\n</li>\r\n<li>\r\n	收集资源，从致命的遭遇和负面状态下存活。\r\n</li>\r\n<li>\r\n	解锁工具和升级来访问之前无法进入的区域。\r\n</li>\r\n<li>\r\n	栩栩如生的手绘场景以及动画过场。\r\n</li>\r\n<li>\r\n</li>\r\n	</ul>',	85,	'https://fhdemo.s-cms.cn/t15/media/20201103001517gD.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	74,	12,	'2020-11-03 00:14:17',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256758732/movie480.webm?t=1565675568',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(289,	'昏迷2:恶毒姐妹',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《昏迷2:恶毒姐妹 The Coma 2: Vicious Sisters》是一款设定在韩国的恐怖生存游戏。探索荒废的校园，在黑夜魔物的围猎中求得生存。搜寻世华高中及其附近区域并找出这个黑暗世界的真相。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span>\r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	黑暗宋老师的无尽追击现在搭载了全新AI，更加可怕。\r\n</li>\r\n<li>\r\n	制造道具来为生死一线的情况做好准备。\r\n</li>\r\n<li>\r\n	探索被噩梦笼罩的世华高中，探索其黑暗的秘密。\r\n</li>\r\n<li>\r\n	收集资源，从致命的遭遇和负面状态下存活。\r\n</li>\r\n<li>\r\n	解锁工具和升级来访问之前无法进入的区域。\r\n</li>\r\n<li>\r\n	栩栩如生的手绘场景以及动画过场。\r\n</li>\r\n<li>\r\n</li>\r\n	</ul>',	37,	'https://fhdemo.s-cms.cn/t15/media/20201103001517gD.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	0,	0,	'2020-11-03 00:14:17',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256758732/movie480.webm?t=1565675568',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(290,	'遗迹灰烬重生',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">《遗迹：灰烬重生 Remnant: From the Ashes》是一款较为硬核的第三人称射击+角色扮演游戏。出色的射击手感，不错的关卡地图和BOSS，紧张刺激的战斗体验，支持好友联机合作。虽有些许不足之处，但确实是一款品质精良的三线小品游戏。（支持繁简中文）\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span>\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; color: rgb(102, 102, 102);\">人类的残余<br />\r\n世界因另一个方面的古老邪恶而陷入混乱。人类正在努力生存，但他们拥有将门户打开到其他领域和交替现实的技术。他们必须通过这些门户网络来揭开邪恶来自哪里的神秘，寻找资源以保持活力，并反击为人类重建奠定立足点……<br />\r\n无尽的奇妙现实<br />\r\n探索每次玩游戏时动态生成的世界，创建新地图，敌人遭遇，任务机会和世界各地的事件。每个游戏的四个独特世界都充满了怪异的居民和环境，每次游戏都会带来新的挑战。适应和探索……或尝试死亡。<br />\r\n清除。升级。专业化。<br />\r\n在敌对环境中克服艰难的钉子敌人和史诗老板，以获得经验，有价值的战利品和升级材料，你可以用它来建立一个邪恶的武器库，装甲和修改，以接近每个遇到几十种独特的方式。<br />\r\n数量上的优势。<br />\r\n侵略其他世界寻求结束根是危险的，生存远未得到保证。与最多两名其他球员合作，增加你的生存机会。团队合作是完成游戏最艰难的挑战所必需的……并释放其最大的回报。\r\n	</p>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201103001706JQ.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	98,	16,	'2020-11-03 00:15:37',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256747605/movie480.webm?t=1554857990',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(291,	'少女射击2 GALGUN 2',	0.00,	'<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏介绍：</strong></span> \r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">『少女☆射击2』是一款因为奇妙事件而成为超级万人迷的主角，使用眼力（通称：费洛蒙射击）让接二连三前来追求的女孩子们升天，并以属意的女主角为目标的奇特眼力射击游戏。 有点无厘头又色色的内容依然健在！…\r\n</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p noto=\"\" sans=\"\" cjk=\"\" sc\",=\"\" \"helvetica=\"\" neue\",=\"\" helvetica,=\"\" arial,=\"\" verdana,=\"\" geneva,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"font-size: 12.6316px; white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><strong><span style=\"font-size:14pt;\">最低配置:</span></strong><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7, 8.1, 10 (64 bit only)<br />\r\n处理器: Intel Core i5-4670 / AMD FX 8350<br />\r\n内存: 4 GB RAM<br />\r\n图形: NVIDIA GeForce GTX 970 / AMD Radeon RX 570<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 8 GB 可用空间\r\n</p>',	51,	'https://fhdemo.s-cms.cn/t15/media/20201103002621LV.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	275,	54,	'2020-11-03 00:25:17',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256721630/movie480.webm?t=1532095067',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(292,	'我的女友：不可能是超H班主任（神秘无修中文版）',	0.00,	'<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">游戏概述：</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">这是一款由[monoceros＋]制作组出品的日式ADV游戏</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">主打绝妙淑女风格，顶级小马拉大车</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">由【绅士回廊】云翻汉化，进行了较大程度的文本替换，读起来也比以前通顺很多</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">而且，游戏还是版本，全程！也就是无修版本！</span>',	51,	'https://fhdemo.s-cms.cn/t15/media/20201103002748oG.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	561,	111,	'2020-11-03 00:27:34',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(293,	'丝袜测评师',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	名称: 丝袜测评师<br />\r\n类型: 独立, 角色扮演, 模拟<br />\r\n开发商: PlayPlayGame<br />\r\n发行商: PlayPlayGame<br />\r\n发行日期: 2020年10月1日<br />\r\n最低配置:<br />\r\n操作系统: win7/8/10<br />\r\n处理器: i3<br />\r\n内存: 4 GB RAM<br />\r\n显卡: null<br />\r\n存储空间: 需要 2 GB 可用空间\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	这是一款模拟丝袜测评的游戏。和美女模特互动一同探索丝袜的魅力。<br />\r\n· 3D游戏，第三人称视角。<br />\r\n· 参与测评各式各样的丝袜。<br />\r\n· 简单有趣而又丰富的互动。<br />\r\n· 近距离欣赏丝袜穿脱过程，穿脱速度由你控制。<br />\r\n· 五种款式：连裤袜，大腿袜，过膝袜，长袜，短袜。<br />\r\n· 七种颜色：黑色，肉色，白色，灰色，红色，黄色，蓝色。<br />\r\n· 十套服装：白领、空姐、护士、女仆、女王、服务生、学生、啦啦队服、体操服、T恤。<br />\r\n· 更多内容尽在游戏中体验。\r\n</p>',	51,	'https://fhdemo.s-cms.cn/t15/media/202011030028382F.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	529,	114,	'2020-11-03 00:28:24',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(294,	'魔镜-豪华终极版+全DLC-',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	入遊戲的「圖鑑」模式可以查看所有角色的Cosplay寫真，也可以進入遊戲安裝目錄查看，所有圖片均為高清晰版。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	Mirror OST<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/844190/header.jpg?t=1546064350\" alt=\"\" style=\"height:auto;\" /><br />\r\n本DLC包含以下無損音樂：<br />\r\n✿ 黛絲的主題BGM<br />\r\n✿ 陽子的主題BGM<br />\r\n✿ 彩雲的主題BGM<br />\r\n✿ 琳主的題BGM<br />\r\n✿ 尤尼的塔主題BGM<br />\r\n✿ 結野安娜的主題BGM<br />\r\n✿ 特里奧姬的主題BGM<br />\r\n✿ 瑪莎的主題BGM<br />\r\n✿ 幻境主題BGM<br />\r\n✿ 迷情主題BGM<br />\r\n✿ 莉婭主題BGM<br />\r\n✿ 莉婭（魅魔）主題BGM<br />\r\n✿ 柳圓主題BGM<br />\r\n✿ 瑪菲卡主題BGM<br />\r\n✿ 希爾主題BGM<br />\r\n✿ Mirror<br />\r\n✿ Mirror主題曲純音樂版<br />\r\n歌词：仲村芽衣子<br />\r\n成员/主催：丸山公詳<br />\r\n歌手：宇月真織<br />\r\n音乐制作：project lights<br />\r\n[乐器演奏]<br />\r\n钢琴:溝呂木奏<br />\r\n使用說明：<br />\r\n進入遊戲的「音樂」模式可以欣賞這些作品，也可以進入遊戲安裝目錄dlc_music目錄中欣賞。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	Mirror: The Lost Shards<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/907370/header.jpg?t=1547706351\" alt=\"\" style=\"height:auto;\" /><br />\r\n此DLC包含4個全新的角色，相比於本體的角色，她們的動畫和CG數量會更多。<br />\r\nOST DLC中添加了新人物的BGM；新角色的cosplay拍攝完畢後也會免費更新到Mirror Cosplay Album DLC，不需要額外花錢購買。<br />\r\n1、莉婭<br />\r\n美麗善良的女高中生，從小和離異的媽媽一起生活，家境一般。因為媽媽經常在國外出差，大多數時間一個人生活。所以即使在學校受到欺負和孤立，也很難尋求幫助和安慰。<br />\r\n2、柳圓<br />\r\n從小體弱多病，和哥哥相依為命，經常搬家，沒有上學。所以雖然已經成年，但還是像小朋友一樣經常犯錯鬧笑話。<br />\r\n3、瑪菲卡·羅茜<br />\r\n隱居於森林，專註奧術和煉金的魔女，對研究以外的事物都不擅長，甚至有些笨拙。討厭那些喜歡用暴力解決問題的人。<br />\r\n4、希爾<br />\r\n在她19年的人生歲月中，有16年是以奴隸的身份度過的，她對自己的奴隸身份保持認命的態度，對主人的命令言聽計從到了病態的地步，但似乎，在內心深處又有着極其微弱的想要擺脫束縛的渴望。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	Mirror: Songs of the Maidens<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1011890/header.jpg?t=1547716676\" alt=\"\" style=\"height:auto;\" /><br />\r\n本DLC包含了12個少女的無損音質主題曲，每首主題曲都有日語人聲版和純音樂版。<br />\r\n✿ 黛絲——Can’t stop Loving you<br />\r\n✿ 陽子——季節外れ、散る紅葉<br />\r\n✿ 彩雲——Eternity Night<br />\r\n✿ 琳——穏やかな陽だまりの下で<br />\r\n✿ 尤尼塔——Burning Spirit<br />\r\n✿ 結野安娜——華が散れども<br />\r\n✿ 特里奧姬——Beautiful Than Gold<br />\r\n✿ 瑪莎——迷える羊達<br />\r\n✿ 莉婭——Nightmare Dream<br />\r\n✿ 柳圓——カナリア<br />\r\n✿ 瑪菲卡——Beauty like a Magic<br />\r\n✿ 希爾——Moon Prison<br />\r\n✿ 串燒合集——少女の唄<br />\r\n使用說明：<br />\r\n進入遊戲的「音樂」模式可以欣賞這些作品，也可以進入遊戲安裝目錄dlc_song中欣賞。<br />\r\n遊戲中播放的最後一首串燒歌曲《少女の唄》因為無損格式的文件過大，可能會導致遊戲錯誤，所以採用的是ogg格式，敬請諒解。玩家也可以在遊戲目錄「dlc_song」中下載無損音質的wav格式。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	Mirror: Enchanting Reflections<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1011900/header.jpg?t=1547716621\" alt=\"\" style=\"height:auto;\" /><br />\r\n本DLC包含了遊戲中未出現的48張高清插畫，每個少女4張，描繪的是她們在遊戲劇情之外的故事。<br />\r\n使用說明：<br />\r\n進入遊戲的「圖鑑」模式可以查看所有角色的插畫，也可以進入遊戲安裝目錄dlc_Easter Eggs查看，所有圖片均為高清晰版\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	Mirror Ringtone<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120620/header.jpg?t=1563260738\" alt=\"\" style=\"height:auto;\" /><br />\r\n從Mirror的人聲主題曲和BGM中，選出6首製作的手機來電鈴聲和鬧鐘鈴聲ios+安卓<br />\r\n使用說明：<br />\r\n-Mirror Ringtone目錄，把音樂檔導入手機即可。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	Mirror Emoji<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1120630/header.jpg?t=1566811301\" alt=\"\" style=\"height:auto;\" /><br />\r\nMirror表情包共包含了12個角色的48個表情圖片。<br />\r\n使用說明：<br />\r\n找到目錄Mirror Emoji目錄），把圖片導入聊天工具即可。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	本体<br />\r\n這是一款“美少女＋寶石消除＋GALGAME”結合的遊戲。你在异世界里邂逅各种各样的美女，与她们战斗时你套路深似海。这些自認高貴的盜賊精靈，優柔寡斷的龍女僕，喜歡著同性的女王，圈養面首的森林女獵手都被你不擇手段地一一捕獲并进行令人窒息的操作～<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/644560/header.jpg?t=1586470107\" alt=\"\" style=\"height:auto;\" /><br />\r\n系统需求<br />\r\n名称: Mirror<br />\r\n类型: 冒险, 独立, 角色扮演<br />\r\n开发商: KAGAMI WORKs<br />\r\n发行商: Paradise Project<br />\r\n发行日期: 2018年4月19日<br />\r\n最低配置:<br />\r\n操作系统: WIN7 SP1/WIN8/WIN10/XP<br />\r\n处理器: 1.2 GHz<br />\r\n内存: 2 GB RAM<br />\r\n显卡: DirectX 9 compatible graphics card<br />\r\n存储空间: 需要 8 GB 可用空间\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	傳說中，有一面神奇的魔鏡，它關聯著無數美麗女性的命運。<br />\r\n如果你獲得它，就能走進這些美麗女性的世界，體驗一段奇妙的旅程。<br />\r\n有出生高貴，卻生性叛逆，喜歡用劫富濟貧來伸張正義的暗精靈盜賊。<br />\r\n有承襲家族使命，驅妖除魔，需要終身侍奉神靈的巫女。<br />\r\n有道觀後山中封印了百年的美女殭屍。<br />\r\n遊戲特色：<br />\r\n這是一款“美少女＋寶石消除＋RPG”結合的遊戲。<br />\r\n採用傳統三消模式，但是當中加入了可以改變戰局的“技能寶石”。<br />\r\n每種寶石都有自己獨特的技能，出戰之前可以選擇要使用的技能和道具。<br />\r\n遊戲中有一些劇情選項會影響美少女的戰鬥屬性和結局，每個角色有兩個結局和幾張CG。\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	51,	'https://fhdemo.s-cms.cn/t15/media/202011030029477c.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	712,	77,	'2020-11-03 00:29:30',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256716376/movie480.webm?t=1525857919',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(295,	'美少女万華鏡5：理与迷宫的少女',	0.00,	'',	51,	'https://fhdemo.s-cms.cn/t15/media/20201103003142ef.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	354,	118,	'2020-11-03 00:31:14',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(296,	'堕落玩偶：爱欲行动',	0.00,	'<p style=\"font-size:12.6316px;\">\r\n	<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">游戏概述：</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">这是一款由[Project Helius]制作组出品的大型互动3D游戏。</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">也是陪伴大家多年，每个版本都提升画质，绝对有着顶尖画面的极品游戏！</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">9月初最新发售~</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">包含PC+VR双版本，并且是全程高质量</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">而这个版本还有个最大的改动：《增加官方中文》！！</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">对的，这款你们一直吹国人骄傲的神作游戏，终于增加了官方中文版啦！</span> \r\n</p>\r\n<p style=\"font-size:12.6316px;\">\r\n	<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">游戏介绍：<br />\r\n这款神级虚幻4引擎3D游戏想必不需多言<br />\r\n只要你是一位合格的绅士，一定为这几位美艳的玩偶疯狂过~<br />\r\n这是一款拥有着全世界最顶尖画面的R18互动黄鼬！<br />\r\n在充满未来设计感的异星中，和几位绝赞美人邂逅<br />\r\n制造素体，配对试验，开发道具，并且进行绝赞的负♂距♂离♂接♂触！<br />\r\n游戏全程超高质量3D互动，画面精致到爆炸~<br />\r\n每一次更新都是量大带劲，满分！让您都充满期待！<br />\r\n可以说，只有体验过这款游戏，你才算真正的享受到了次时代极品3D！</span> \r\n</p>',	51,	'https://fhdemo.s-cms.cn/t15/media/202011030032125D.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	983,	252,	'2020-11-03 00:31:58',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(297,	'重生之隔壁老王',	1.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	《重生之隔壁老王》是一款角色扮演類包含劇情+角色互動+關卡解密的游戲，同時這個也是個惡搞游戲，有强烈的NTR内容，純愛戰士慎入。称: Rebirth:Mr Wang<br />\r\n类型: 休闲, 独立, 角色扮演<br />\r\n开发商: DSGame<br />\r\n发行商: DSGame<br />\r\n系列: SeekGirl, Rebirth<br />\r\n发行日期: 2020年10月3日<br />\r\n最低配置:<br />\r\n操作系统: Windows7/8/10<br />\r\n处理器: Intel Core i3<br />\r\n内存: 400 MB RAM<br />\r\n显卡: NVIDIA Geforce GT 740<br />\r\n存储空间: 需要 200 MB 可用空间<br />\r\n声卡: DirectX 11 Sound Device\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	《重生之隔壁老王》是一款角色扮演類包含劇情+角色互動+關卡解密的游戲，同時這個也是個惡搞游戲，有强烈的NTR内容，純愛戰士慎入。<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1394800/extras/001.gif?t=1601713537\" alt=\"\" style=\"height:auto;\" /><br />\r\n老王老王表面上是壹名熱心腸的公寓修理工，老王表面上是壹名熱心腸的公寓修理工，喜歡幫助女鄰居解決生活中的小問題，但是背地裏老王是壹個性格猥瑣的人，還特別喜歡綠別人。<br />\r\n劇情中在給鄰居幫忙的同時，會窺探鄰居的隱私，通過各種卑劣的手段，比如撬鎖，安裝將監，對電腦植入病毒，冒充男友和老公等方式接近女鄰居。<br />\r\n游戲包含多種結局<br />\r\n如果你想看老王被繩之以法的過程，那可千萬不要錯過！再次提示有强烈NTR！<br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1394800/extras/002.gif?t=1601713537\" alt=\"\" style=\"height:auto;\" /><br />\r\n隔壁老王是我們的一個全新系類Rebirth重生系列。這此我們將視角放到生活中。<br />\r\n女孩新買的電腦為何會被植入病毒？獨居畫師家裡的鎖為何全被做了手腳？乞丐碗裡的錢為何頻頻失竊？新婚少婦的身上又隱藏着怎樣的秘密？這一次切的背後，是人性的扭曲還是道德的淪喪？是性的爆發還是什麼力量在掌控？<br />\r\n全新鏡頭化敘事更加有代入感<br />\r\n四位個性獨特的角色<br />\r\n超25組live2d動畫<br />\r\n全新日本聲優配音陣容<br />\r\n簡單有趣的角色互動和關卡解密<br />\r\n如果你對老王的故事感興趣，請不要錯過。<br />\r\n紳士萬歲！\r\n</p>',	51,	'https://fhdemo.s-cms.cn/t15/media/202011030035115F.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	560,	117,	'2020-11-03 00:32:44',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(298,	'开心数字 中文版',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	Happy Numbers《开心数字》是一款益智休闲游戏，提供70多个手工制作的小型解密关卡，使您沉浸在其中。游戏还包含许多能解锁的美丽人物。所有的女性角色都有黄油，很多黄油。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1420830/header.jpg?t=1602756038\" alt=\"\" style=\"height:auto;\" />\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	名称: Happy Numbers<br />\r\n类型: 休闲, 独立<br />\r\n开发商: HappyGames<br />\r\n发行商: HappyGames<br />\r\n系列: Happy<br />\r\n发行日期: 2020年10月15日<br />\r\n最低配置:<br />\r\n操作系统: Window 10<br />\r\n处理器: Intel Core 2 Dual or AMD Equivalent<br />\r\n内存: 1 GB RAM<br />\r\n显卡: DirectX 9 Compatible Graphics Card<br />\r\nDirectX 版本: 9.0<br />\r\n存储空间: 需要 200 MB 可用空间\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	Happy Numbers《开心数字》 是一款益智休闲游戏，提供70多个手工制作的小型解密关卡，使您沉浸在其中。<br />\r\n游戏还包含许多能解锁的美丽人物。<br />\r\n所有的女性角色都有黄油，很多黄油。<br />\r\n让我们通过训练您的大脑，以获取漂亮的女孩吧！耶！！！\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	玩法：<br />\r\n❥ 通过滑动带有数字的格子来填充网格。<br />\r\n❥ 绿色的强调表示您可以滑动。<br />\r\n❥ 红色的强调表示您无法滑动。<br />\r\n易玩但不易获胜。 一起尝试吧！\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1420830/ss_741ce212fc2145cf453b00ae33b27a4f6eecbe8f.1920x1080.jpg?t=1602756038\" alt=\"\" style=\"height:auto;\" /><br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1420830/ss_f03564a3b77befac1f2d75e27ee39b408a5750be.1920x1080.jpg?t=1602756038\" alt=\"\" style=\"height:auto;\" /><br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1420830/ss_8e33fd7446ef9d3b17d4f438d62032bec18db8e0.1920x1080.jpg?t=1602756038\" alt=\"\" style=\"height:auto;\" />\r\n</p>\r\n<div style=\"font-size:12.6316px;\">\r\n	声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。&nbsp;<br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。&nbsp;<br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！&nbsp;<br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。&nbsp;<br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!<br />\r\n</div>',	51,	'https://fhdemo.s-cms.cn/t15/media/20201103003535bD.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	220,	48,	'2020-11-03 00:35:16',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(299,	'风流刀客-重大更新-V9.29-新互动模式',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	这是一款敏捷+AVG类型的游戏，故事讲述了刀客聂关西年轻时的江湖风流趣事。用刀来卸下女侠们的层层防御并收集她们的闺房密事吧！\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1209000/header.jpg?t=1594872019\" style=\"height:auto;\" /><br />\r\n办<br />\r\n名称: 风流刀客<br />\r\n类型: 休闲, 独立<br />\r\n开发商: Old High Studio<br />\r\n发行商: WhiteRabbit Games<br />\r\n发行日期: 2020年7月16日<br />\r\n最低配置:<br />\r\n操作系统: Windows 7 – 64 bit<br />\r\n处理器: 1.8 GHz Pentium 4<br />\r\n内存: 4096 MB RAM<br />\r\n显卡: Nvidia GeForce GT610<br />\r\nDirectX 版本: 9.0c<br />\r\n存储空间: 需要 800 MB 可用空间\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	2020-9-29【更新内容】<br />\r\n1、加入第六章节“罗兰”的全新互动模式。<br />\r\n2、将主线剧情战斗结束后的互动替换为新互动。<br />\r\n3、风流史内加入新互动模式。老互动模式保留，作为观赏模式供各位绅士观看。<br />\r\n4、调整部分互动模式配音。<br />\r\n2020-9-19更新内容<br />\r\n【今日更新】<br />\r\n1、加入第五章节“阿菲法”的全新互动模式。<br />\r\n小提示：新互动模式可从&gt;开始游戏&gt;“新互动”按钮进入。<br />\r\n2020-9-11更新内容<br />\r\n1、加入第四章节“琴剑双绝-白玲珑”的全新互动模式。<br />\r\n小提示：新互动模式可从&gt;开始游戏&gt;“新互动”按钮进入。<br />\r\n定期更新2020-9-07<br />\r\n【今日更新内容】<br />\r\n1、加入第三章节“佐佐木”的全新互动模式。<br />\r\n2、将主线剧情战斗结束后的互动替换为新互动。<br />\r\n3、风流史内加入新互动模式，老互动模式剔除互动动画，作为观赏模式供各位绅士观看。<br />\r\n定期更新2020-8-30<br />\r\n今天为各位绅士带来了新的内容!<br />\r\n请大家稍安勿躁，我们已经火力全开正在筹备更多更好的新内容以及互动模式优化。<br />\r\n欢迎各位绅士可以积极体验新内容，给我们提供更多的意见和建议.<br />\r\n【今日更新内容】<br />\r\n1、加入第二章节“巾帼名将-辰炀”的全新互动模式。<br />\r\n2、优化了互动反馈音效，使其更加生动。<br />\r\n3、优化及平衡部分刀的属性，让玩家有更多选择。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	大型更新【2020-8-16】<br />\r\n《风流刀客》在今天更新“互动模式”，目前为尝鲜版，各位绅士可以在开始游戏后选择关卡处进入。<br />\r\n目前仅更新了第一关，接下来我们会继续更新后续关卡&amp;优化，有意见及建议可以加群提交给我们。<br />\r\n互动模式配音也将在近期更新，敬请期待。<br />\r\n中等更新【2020-8-1】<br />\r\n新增内容&amp;优化&amp;修复<br />\r\n今天为各位绅士带来了新的内容 ！<br />\r\n请大家稍安勿躁，我们已经火力全开正在筹备更多更好的新内容以及互动模式优化。<br />\r\n【今日更新内容】<br />\r\n1、加入第四章节“琴剑双绝-白玲珑”的分支剧情，大家可以自由选择和白玲珑的后续剧情。<br />\r\n2、为白玲珑分支剧情增加独立结局。<br />\r\n3、修复因时区导致的游戏无法启动问题。<br />\r\n4、调整难度选择界面UI。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	十年前，拓跋白雪以绝刀刀法独步天下。但因其清冷孤傲的性格，遭来了各界人士的仇视，他们决心合力围杀七香楼。此役，拓跋白雪虽逃得性命，但其家眷爱侣却均数殒命。心灰意冷之下，拓跋白雪将绝刀刀法随手扔在了粪堆之中，便黯然退隐江湖。<br />\r\n退隐江湖的拓跋白雪化名元吹雪，在大漠边陲的龙门集开了一家客栈，名曰龙门客栈。元吹雪对周围的一切都毫不上心，直到一位无人照顾的弃婴意外闯入到她的生活中。龙门集位于大漠边陲，是东西两边经商之人的必经之地。而龙门客栈，是龙门集最大的客栈，既为来往过客提供住宿，也经营着一些不为人知的生意。<br />\r\n龙门客栈有三位名人，从不服侍客人的风流店小二聂关西，艳名远扬卖身不卖艺的清倌琳琳以及从未露面的老板元吹雪。<br />\r\n玩家将在这里进入故事，扮演风流刀客聂关西，在养母元吹雪的指示下去武林各地寻回失落的七把刀，一步步从雏鸟成为大刀客。游戏主线便讲述了聂关西在寻找七把刀的过程中发生得那些不得不说的故事。<br />\r\n<img alt=\"\" src=\"https://steamcdn-a.akamaihd.net/steam/apps/1209000/extras/movie1_2.gif?t=1594872019\" style=\"height:auto;\" /><br />\r\n· 扮演聂关西行走武林，随剧情推进一步步收集到七绝刀。<br />\r\n<img alt=\"\" src=\"https://steamcdn-a.akamaihd.net/steam/apps/1209000/extras/ditiao.png?t=1594872019\" style=\"height:auto;\" /><br />\r\n· 与命中注定相遇的一位位女侠客一较高低，使用高超的刀术卸下一位位女侠的“防御”，走进他们的内心。<br />\r\n· 互动模式，征服6位女侠，让她们的身心都属于你。<br />\r\n· 根据剧情中的抉择，触发不同结局CG。<br />\r\n· 拥有5种不同的结局。<br />\r\n<img alt=\"\" src=\"https://steamcdn-a.akamaihd.net/steam/apps/1209000/extras/888888.gif?t=1594872019\" style=\"height:auto;\" /><br />\r\n大漠，七香楼。这座七色不同建筑组成的阁楼，以北斗七星的样式孤立在大漠深处。<br />\r\n一说沉香阁，供宽脊大刀，一刀之威可沉船搅海，大开大合，刀名沉雷。<br />\r\n二说丁香阁，供短刃压裙刀，藏于最隐蔽之处，出刀即杀人，刀名红袖。<br />\r\n三说檀香阁，供七尺戒刀，无刃无锋，诛心不杀人，刀名非攻。<br />\r\n四说添香阁，供柳叶细刀，出刀如百花缭乱，虚实难辨，刀名紫烟。<br />\r\n五说乳香阁，供子母双刀，以长刀带短刀，立于不败之地，刀名双燕。<br />\r\n六说酒香阁，供直刃陌刀，饮酒横刀斩千人，豪放不羁，刀名霸王。<br />\r\n七说浮香阁，供圆月弯刀，以飞刀术驭弯刀，百步之外取人性命，刀名流星。<br />\r\n七把刀与七种刀法均为一人所创，七香楼主——拓跋白雪。天无绝人之路，刀却可绝人之命，这便是拓跋白雪的绝刀刀法。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1209000/ss_749f812c199c53bb198214836a0cefa07b82881f.1920x1080.jpg?t=1594872019\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1209000/ss_6f78b91de59a7dd9e1a7cec304f598953a8a100d.1920x1080.jpg?t=1594872019\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1209000/ss_47ac0e6561f054b066f10ff978df195b4a706af3.1920x1080.jpg?t=1594872019\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1209000/ss_67c136b65cafe697994f8986bad0391fdd333bc8.1920x1080.jpg?t=1594872019\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1209000/ss_f9b32586d1ce7cbd4c93ca6743b5a58478815854.1920x1080.jpg?t=1594872019\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1209000/ss_6756ce30db646fce9a1a45a35de5763ebd941c3e.1920x1080.jpg?t=1594872019\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1209000/ss_493042a141a7860bf5efa5e07b3d0f951600ed7d.1920x1080.jpg?t=1594872019\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1209000/ss_744a956c21efe894f6da88001d8510d6efc47f99.1920x1080.jpg?t=1594872019\" style=\"height:auto;\" /><br />\r\n<img alt=\"\" src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1209000/ss_f3c3b124bc3972ee8c84ce4d7591d2cc21da8b78.1920x1080.jpg?t=1594872019\" style=\"height:auto;\" /> \r\n</p>',	51,	'https://fhdemo.s-cms.cn/t15/media/20201103003859Eu.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	233,	25,	'2020-11-03 00:38:05',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(300,	'百鬼夜行 劍姬無双-更新V1.12+送存档',	0.00,	'<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">NPC瑕疵很多 对话不完整不连贯</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">．无法离开menu</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">功能改进：</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">．游戏云端存盘功能</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">．自动存盘功能</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">．裤袜指定色系追加</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">．HP按住2秒后可极高速升级</span><br />\r\n<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">．取消战棋桌的设计，改为UI跳关</span><br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1384630/ss_c55594bb05f64d85a720ffc9e7c80e2fa01f78ad.1920x1080.jpg?t=1601368728\" alt=\"\" style=\"height:auto;\" /><br />',	51,	'https://fhdemo.s-cms.cn/t15/media/20201103004046aZ.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	541,	116,	'2020-11-03 00:39:30',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(301,	'百鬼夜行 劍姬無双-更新V1.12+送存档',	0.00,	'',	51,	'https://fhdemo.s-cms.cn/t15/media/20201103004046aZ.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	0,	0,	'2020-11-03 00:39:30',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(302,	'爱之塔-（中文作弊版）-真人互动',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	游戏概述：<br />\r\n类似于SOB，妈妈的密友类型的欧美真人QSP游戏，这种一般都是毛子弄出来的，相信大家也很熟悉了~<br />\r\n全程真人动态CG，动态场景超过了800+，实在是秀的一批~<br />\r\n目前已经更新了多次，已经有大量的上垒场景，全部是动态的~<br />\r\n剧情方面是大家熟悉的欧美经典全家桶模式，包含妈妈，妹妹，大姨，小姨等等，总之绝对好冲！\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	PS：游戏自带作弊+提示功能——（点击男主的图标，再点击【FAQ?】即可）\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。 <br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。 <br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！ <br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。 <br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n</p>',	51,	'https://fhdemo.s-cms.cn/t15/media/20201103004312z1.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	774,	279,	'2020-11-03 00:41:12',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(303,	'爱之塔-（中文作弊版）-真人互动',	1.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	游戏概述：<br />\r\n类似于SOB，妈妈的密友类型的欧美真人QSP游戏，这种一般都是毛子弄出来的，相信大家也很熟悉了~<br />\r\n全程真人动态CG，动态场景超过了800+，实在是秀的一批~<br />\r\n目前已经更新了多次，已经有大量的上垒场景，全部是动态的~<br />\r\n剧情方面是大家熟悉的欧美经典全家桶模式，包含妈妈，妹妹，大姨，小姨等等，总之绝对好冲！\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	PS：游戏自带作弊+提示功能——（点击男主的图标，再点击【FAQ?】即可）\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。&nbsp;<br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。&nbsp;<br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！&nbsp;<br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。&nbsp;<br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n</p>',	51,	'https://fhdemo.s-cms.cn/t15/media/20201103004312z1.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	0,	0,	'2020-11-03 00:41:12',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(304,	'爱之塔-（中文作弊版）-真人互动',	1.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	游戏概述：<br />\r\n类似于SOB，妈妈的密友类型的欧美真人QSP游戏，这种一般都是毛子弄出来的，相信大家也很熟悉了~<br />\r\n全程真人动态CG，动态场景超过了800+，实在是秀的一批~<br />\r\n目前已经更新了多次，已经有大量的上垒场景，全部是动态的~<br />\r\n剧情方面是大家熟悉的欧美经典全家桶模式，包含妈妈，妹妹，大姨，小姨等等，总之绝对好冲！\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	PS：游戏自带作弊+提示功能——（点击男主的图标，再点击【FAQ?】即可）\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。&nbsp;<br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。&nbsp;<br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！&nbsp;<br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。&nbsp;<br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n</p>',	51,	'https://fhdemo.s-cms.cn/t15/media/20201103004312z1.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	0,	0,	'2020-11-03 00:41:12',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(305,	'时尚交际花-(官中）',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	该游戏是关于莫妮卡的…<br />\r\n莫妮卡是个“有钱人”。<br />\r\n更重要的是-莫妮卡是老板。<br />\r\n莫妮卡（Monica）最崇尚权威和控制人，她以一种不太敏感或微妙的方式来管理一切。<br />\r\n如果莫妮卡是你的老板，你可能会被解雇:)<br />\r\n以前每个人都遇到了自己的莫妮卡，这是肯定的！<br />\r\n参加她的奢华生活。莫妮卡确信她的存在将永远一样！你怎么看？如果突然间，您成为她社会逐渐增加下降的见证人？如果她不得不见那些冒犯了她的人？<br />\r\n找她的命运！<br />\r\n如果您认识Monica，她会让您发疯。您将有机会恨她，但请不要冷漠。<br />\r\n游戏将为您提供4300张图像和225个动画剪辑。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#F6F6F6;\">\r\n	<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1364140/ss_b7cfcfd3e396347c7f36ecf98669e8de915637f8.1920x1080.jpg?t=1595322120\" alt=\"\" style=\"height:auto;\" /><br />\r\n<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1364140/ss_96d5a93bebbff2e7f7f111669dea62c00e1262b3.1920x1080.jpg?t=1595322120\" alt=\"\" style=\"height:auto;\" /> \r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	51,	'https://fhdemo.s-cms.cn/t15/media/20201103004439D6.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	724,	62,	'2020-11-03 00:43:31',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(306,	'老司机会员的福利',	0.00,	'<p>\r\n	<span style=\"font-size:24px;\">1<span style=\"font-size:24px;\">8游戏7916款&nbsp; 18漫画4296款 18动画2523款 </span><img alt=\"\" src=\"https://ppgame.zijjt.com/kindeditor/attached/image/20200911/20200911193949_92102.jpg\" /><img alt=\"\" src=\"https://ppgame.zijjt.com/kindeditor/attached/image/20200911/20200911193949_72092.jpg\" /><img alt=\"\" src=\"https://ppgame.zijjt.com/kindeditor/attached/image/20200911/20200911193952_63139.jpg\" /></span>\r\n</p>',	51,	'https://fhdemo.s-cms.cn/t15/media/20201103005332jU.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	727,	687,	'2020-11-03 00:52:52',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	3.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	49,	'',	'',	0.00,	0,	NULL),
(307,	'巨神狩猎/神之祈猎/Praey for the Gods',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:20px;\">关于这款游戏</span> \r\n</p>\r\n<div class=\"game_page_autocollapse_ctn expanded\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse\">\r\n		<div id=\"game_area_description\" class=\"game_area_description\">\r\n			<p>\r\n				在《Praey for the Gods》中，玩家所扮演的孤独英雄将前往绝境边陲，发掘这无尽凛冬下骇人的秘密。一席行囊、少许衣物，独自面对危机四伏的险境。要想恢复世界的平衡、收复边陲领土，你所面临的问题，连上帝都不知道答案。<br />\r\nNOTE: Praey for the Gods 除了一开始的游戏执行对话框外，游戏内有完整的摇杆支援。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				规模庞大的敌人\r\n			</h2>\r\n			<p>\r\n				<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/494430/extras/headerdivider.png?t=1572385609\" style=\"height:auto;\" /><br />\r\n克服不可能的机率来攀登到顶端并击败巨大的敌人。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				攀爬，滑翔，游泳\r\n			</h2>\r\n			<p>\r\n				<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/494430/extras/headerdivider.png?t=1572385609\" style=\"height:auto;\" /><br />\r\n你几乎可以爬上任何东西，从废墟和山脉到居住在这片土地上的大型敌人。登上山顶，然后在开阔的世界上滑翔，到达以前无法进入的地方。在寒冷的水中游泳，发现隐藏的地方，包含秘密和宝藏，但不要停留太久不然这可能成为你最后一次的游泳。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				探索，制作和生存\r\n			</h2>\r\n			<p>\r\n				<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/494430/extras/headerdivider.png?t=1572385609\" style=\"height:auto;\" /><br />\r\n只凭刚抵达这冰封岛屿时的衣服，如何来生存下去。生火，寻找食物，找到渡过无尽凛冬所需的设备。大自然不是唯一的危险，所以制作武器，为了更好的装备而击败敌人，冒险进入长期被遗忘的洞穴并发现他们的秘密。胜过这些试验将为你有更好的机率来面对下一个不可能的任务。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				自由度\r\n			</h2>\r\n			<p>\r\n				<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/494430/extras/headerdivider.png?t=1572385609\" style=\"height:auto;\" /><br />\r\nPraey for the Gods 是一个非线性游戏，你可以选择你的战斗对象和方式。没有固定路线，可以按任何顺序尝试大型敌人。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				发掘秘密\r\n			</h2>\r\n			<p>\r\n				<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/494430/extras/headerdivider.png?t=1572385609\" style=\"height:auto;\" /><br />\r\n为什么冬天不会停止？为什么没有人回来？留下的隐秘画作暗示了曾经被遗忘的故事。为了恢复平衡并收回土地，你将面临甚至连众神都不知道答案的问题。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"font-size:20px;\">\r\n				一个美丽寒冷的世界\r\n			</h2>\r\n			<p>\r\n				<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/494430/extras/headerdivider.png?t=1572385609\" style=\"height:auto;\" /><br />\r\n探索由白雪皑皑的山峰和雾笼罩的无尽冬季景观。一个古老文明的废墟摆在你面前，但不要让敬畏变成粗心大意 – 随时都会出现暴风雪，并将你埋在暴风雪中。幸运的是，如果你迷路的话，你可以在雪地上留下脚印并跟着你的脚步。\r\n			</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse sys_req\">\r\n		<h2 style=\"font-size:20px;\">\r\n			系统需求\r\n		</h2>\r\n		<div class=\"sysreq_contents\">\r\n			<div class=\"game_area_sys_req sysreq_content active\">\r\n				<div class=\"game_area_sys_req_leftCol\">\r\n					<p>\r\n						<span style=\"font-weight:bolder;\">最低配置:</span> \r\n					</p>\r\n					<ul>\r\n						<li>\r\n							<ul class=\"bb_ul\">\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">操作系统:</span> 64-bit Windows 7\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">处理器:</span> Intel CPU Core i5-2500K 3.3GHz, AMD CPU Phenom II X4 940\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">内存:</span> 6 GB RAM\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">显卡:</span> Nvidia GPU GeForce GTX 670 or AMD GPU Radeon HD 7870\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">DirectX 版本:</span> 11\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">存储空间:</span> 需要 8 GB 可用空间\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">附注事项:</span> DirectX 11 is necessary to run the game.\r\n								</li>\r\n							</ul>\r\n						</li>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201103010726TL.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	57,	10,	'2020-11-03 01:07:18',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256741695/movie480.webm?t=1548788151',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(308,	'《风之旅人 Journey》中文版百度云',	0.00,	'<span>《风之旅人 Journey》是一款独立冒险游戏，在古老而神秘的 Journey 世界，滑翔在废墟上空和沙丘之间，探索未知的奥秘。您可以单独行动，或者结伴而行，一起探索游戏中的广阔世界。Journey 拥有令人惊叹的视觉效果和获得格莱美提名的配乐，为玩家带来无可比拟的惊艳体验。</span><p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><a class=\"highslide-image\" href=\"https://s1.jiligame.com/images/2020/06/25/2986c9963c97b76de29d69f6d87f3d1a.jpg\"></a> \r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7<br />\r\n处理器: Intel Core i3-2120 | AMD FX-4350<br />\r\n内存: 4 GB RAM<br />\r\n显卡: Nvidia GTS 450 | AMD Radeon HD 5750<br />\r\n存储空间: 需要 4 GB 可用空间\r\n</p>',	34,	'https://fhdemo.s-cms.cn/t15/media/20201103111914TF.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	57,	26,	'2020-11-03 11:19:04',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(309,	'东方之茵 Eastshade',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">你是一位旅行画家，正在探索东方之茵的奥秘。使用画架和画布捕捉世界。与原住民交流，了解他们的生活。结交朋友，帮助有需要的人。探索未解之迷，揭开这块土地的奥秘。穿越天然屏障，到达被遗忘的地方。体验你的行为如何影响周围的世界。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7<br />\r\n处理器: Intel i5-750/AMD Phenom II X4-945<br />\r\n内存: 6 GB RAM<br />\r\n图形: Nvidia GTX 560 Ti/Radeon HD 6950<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 3 GB 可用空间\r\n</p>',	34,	'https://fhdemo.s-cms.cn/t15/media/202011031122195x.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	28,	10,	'2020-11-03 11:22:15',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(310,	'《俄罗斯方块效应 Tetris Effect》',	0.00,	'<p style=\"color: rgb(102, 102, 102); font-family:;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">游戏介绍：\r\n	</p>\r\n<p style=\"color: rgb(102, 102, 102); font-family:;\" 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\">	《俄罗斯方块效应 Tetris Effect》是一款让您耳目一新的俄罗斯方块游戏，带给您从未有过的感受——史上最流行解谜游戏的华丽重制，独特、惊艳，让人欲罢不能。获奖名作Rez Infinite和传奇解谜游戏Lumines主创团队出品。 两种环境下均可畅玩：在标准屏幕上游玩时，可自由调节分辨率，帧数不设上限（需关闭垂直同步）；或者选择使用Oculus Rift和HTC Vive体验梦幻般的3D效果。\r\n</p>',	34,	'https://fhdemo.s-cms.cn/t15/media/20201103114527wp.png',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	44,	9,	'2020-11-03 11:44:49',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(311,	'妖精的尾巴 FAIRY TAIL',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《妖精的尾巴 FAIRY TAIL》是一款日系角色扮演游戏，魔法×公会×RPG『FAIRY TAIL』、是以『FAIRY TAIL（妖精的尾巴）』的世界观为背景製作的RPG游戏作品。原作『FAIRY TAIL（妖精的尾巴）』是由漫画家真岛浩所绘製，在全球拥有超高人气的漫画、动画作品。故事舞台为存在着龙和魔法的世界，以问题魔导士公会「妖精尾巴」的灭龙魔导士纳兹和露西为…\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">■超越公会的梦之共演<br />\r\n玩家角色多达16位！<br />\r\n也有来自“妖精尾巴”公会之外的多位角色登场！<br />\r\n此外，还将收录游戏独有的原创篇章。<br />\r\n■扣人心弦的魔法大战<br />\r\n从联合攻击到超魔法，再现原作中熟悉的招式！<br />\r\n还可以组合游戏原创的联合攻击。<br />\r\n■以最强公会为目标<br />\r\n还原马格诺利亚的城镇，以及公会内部的全貌。<br />\r\n解决布告板上的委托，提升公会等级，与公会的伙伴们一起努力成为最强公会！\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 8.1 / 10 (64bit)<br />\r\n处理器: Intel Core i5 4460 or over<br />\r\n内存: 8 GB RAM<br />\r\n显卡: NVIDIA GeForce GTX 760 over or 1280×720 over display<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 10 GB 可用空间\r\n</p>',	73,	'https://fhdemo.s-cms.cn/t15/media/202011031150050D.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	25,	7,	'2020-11-03 11:47:29',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256781625/movie480_vp9.webm?t=1587456209',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(312,	'蝙蝠侠阿卡姆骑士 全dlc',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《蝙蝠侠：阿卡姆骑士 Batman™: Arkham Knight》是一款开放世界游戏，哥谭市，蝙蝠侠在暴雨肆虐的夜晚，闪烁的霓虹灯、中国城的標誌性装饰、韦恩塔等建筑物间自由穿梭。《阿甘骑士》开始谱写全新一段《蝙蝠侠》电子游戏篇章，为漫画英雄动作游戏设立了新的標准；它將所有蝙蝠侠在歌谭市里的亲朋好友和对头宿敌全都齐聚一堂，上演了一段高潮迭起的谢幕好戏。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Win 7 SP1, Win 8.1 (64-bit Operating System Required)<br />\r\n处理器: Intel Core i5-750, 2.67 GHz | AMD Phenom II X4 965, 3.4 GHz<br />\r\n内存: 6 GB RAM<br />\r\n显卡: Graphics: NVIDIA GeForce GTX 660 (2 GB Memory Minimum) | AMD Radeon HD 7870 (2 GB Memory Minimum)<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 45 GB 可用空间\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	28,	'https://fhdemo.s-cms.cn/t15/media/202011031210597D.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	104,	29,	'2020-11-03 11:51:32',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/2038213/movie480.webm?t=1447372011',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(313,	'《四海兄弟3：最终版 Mafia III: Definitive Edition》中文版百度云',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《黑手党3：最终版 Mafia III: Definitive Edition》是一款动作冒险游戏，复古的金曲与电台，难以言状的曼妙情调；众多对时代风貌还原的细节，出色的叙事手段和精彩的人物刻画，将一个传统的黑帮复仇故事演绎出了别样的精彩。些许的不足之处却不能否定，它仍是一部值得一品的佳作。（支持简繁中文）\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">新波尔多，1968年新奥尔良的重现<br />\r\n一个巨大，多样化的，由暴徒和贪官污吏所统治的开放世界，并用那个时代的社会气氛下的声光艳影细细刻画<br />\r\n一位不得已之下诞生的致命的反英雄<br />\r\n扮演林肯·克莱，作为孤儿和越战老兵的身份，下定决心要向意大利黑手党复仇，因为他们残忍屠杀了他曾拥有的，如果家人般存在的“黑色暴徒”<br />\r\n以你的方式复仇<br />\r\n选择属于你的游玩方式，利用林肯的军队训练背景，收集情报击倒意大利黑手党，从肉搏、枪战到潜入暗杀皆为你选<br />\r\n从一片疮痍之上崛起的新家族<br />\r\n以你的独特手段建立起一个全新的犯罪帝国，你可选择你要奖励或是背叛的对象……\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7 64-bit<br />\r\n处理器: Intel I5-2500K, AMD FX-8120<br />\r\n内存: 6 GB RAM<br />\r\n显卡: 2GB of Video Memory &amp; NVIDIA GeForce GTX 660, AMD Radeon HD7870<br />\r\n存储空间: 需要 50 GB 可用空间\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201103121425ap.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	135,	33,	'2020-11-03 12:14:10',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(314,	'远征军维京',	0.00,	'<div class=\"game_page_autocollapse_ctn\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse\">\r\n		<div id=\"game_area_description\" class=\"game_area_description\">\r\n			<h2 style=\"font-size:20px;\">\r\n				关于这款游戏\r\n			</h2>\r\n			<p>\r\n				为历史上的冒险做好准备！逻辑艺术家，探险的制作者：征服者，很高兴为您带来探险：海盗。<br />\r\n准备一次大冒险<br />\r\n作为一个朴素的维京部落新任命的酋长，你将拥有一个属于你自己的村庄。但是要把你的名字刻进历史的长河，你需要巨大的力量和财富来发展你的村庄的繁荣和名声。挪威的土地已经所剩无几了，所以你必须把目光投向西边的海洋，那里传说有一个巨大的岛屿，里面装满了可以带走的财宝。<br />\r\n寻找你的财富<br />\r\n如果这是最重要的事情，你信任的哈斯卡尔会跟着你去瓦尔哈拉，但你需要的不仅仅是忠诚，才能留下一份将被铭记千年的遗产。现在你们要聚集一队有价值的勇士，建造船只，在海那边寻求你们的财富和荣耀。不列颠尼亚在等待逻辑艺术家的探险：海盗。<br />\r\n主要特点：<br />\r\n创造你自己的维京酋长！从我们独特的角色系统中划出你的角色，在这里属性、技能和能力定义了你的角色。<br />\r\n抢劫还是交易？维京人不仅被称为暴力战士，而且是精明的商人。用胡萝卜或大棒，你将如何找到财富？<br />\r\n战争和政治：支持不同的派系，不管是北欧人，皮克特人，还是天使<br />\r\n声誉：注意你的选择，你的行为可能会让别人害怕你，但他们会信任你吗？<br />\r\n踏入历史的篇章：在一个美丽和发自内心的北欧历史讲述。\r\n			</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse sys_req\">\r\n		<h2 style=\"font-size:20px;\">\r\n			系统需求\r\n		</h2>\r\n		<div class=\"sysreq_contents\">\r\n			<div class=\"game_area_sys_req sysreq_content active\">\r\n				<div class=\"game_area_sys_req_leftCol\">\r\n					<p>\r\n						<span style=\"font-weight:bolder;\">最低配置:</span> \r\n					</p>\r\n					<ul>\r\n						<li>\r\n							<ul class=\"bb_ul\">\r\n								<li>\r\n									需要 64 位处理器和操作系统\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">操作系统:</span> Windows 7\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">处理器:</span> Intel Core2 Quad Q9400 2.66 GHz\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">内存:</span> 4 GB RAM\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">显卡:</span> NVIDIA GeForce GTS 450\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">DirectX 版本:</span> 11\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">存储空间:</span> 需要 12 GB 可用空间\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">声卡:</span> DirectX Compatible Sound Card\r\n								</li>\r\n							</ul>\r\n						</li>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201103121650jQ.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	32,	6,	'2020-11-03 12:15:23',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256683903/movie480.webm?t=1493218069',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(315,	'禁闭求生 Grounded',	0.00,	'<p>\r\n	游戏名称：禁闭求生<br />\r\n英文名称：Grounded<br />\r\n游戏类型：冒险游戏AVG<br />\r\n游戏制作：Obsidian Entertainment<br />\r\n游戏发行：Xbox Game Studios<br />\r\n游戏平台：PC<br />\r\n游戏语言：英文<br />\r\n发售日期：2020-07-29\r\n</p>\r\n<p>\r\n	【游戏介绍】\r\n</p>\r\n<p>\r\n	《禁闭求生（Grounded）》是一款多人的冒险动作游戏，世界是一个广阔，美丽和危险的地方，特别是当你被缩小到蚂蚁的大小。探索，建立和生存。你能和一群巨大的昆虫一起茁壮成长生存吗？\r\n</p>\r\n<p>\r\n	【游戏截图】\r\n</p>\r\n<p>\r\n	<img width=\"800\" height=\"450\" alt=\"\" src=\"http://images.ali213.net/picfile/pic/2020/05/10/20200510111519774.jpg\" /> \r\n</p>\r\n<p>\r\n	<img width=\"800\" height=\"450\" alt=\"\" src=\"http://images.ali213.net/picfile/pic/2020/05/10/20200510111521206.jpg\" /> \r\n</p>\r\n<p>\r\n	<img width=\"800\" height=\"450\" alt=\"\" src=\"http://images.ali213.net/picfile/pic/2020/05/10/20200510111522161.jpg\" /> \r\n</p>\r\n<p>\r\n	<img width=\"800\" height=\"450\" alt=\"\" src=\"http://images.ali213.net/picfile/pic/2020/05/10/20200510111524381.jpg\" /> \r\n</p>\r\n<p>\r\n	<img width=\"800\" height=\"450\" alt=\"\" src=\"http://images.ali213.net/picfile/pic/2020/05/10/20200510111525244.jpg\" /> \r\n</p>\r\n<h2>\r\n	系统需求\r\n</h2>\r\n<div class=\"sysreq_contents\">\r\n	<div class=\"game_area_sys_req sysreq_content active\">\r\n		<div class=\"game_area_sys_req_leftCol\">\r\n			<p>\r\n				<strong>最低配置:</strong> \r\n			</p>\r\n			<ul>\r\n				<li>\r\n					<ul class=\"bb_ul\">\r\n						<li>\r\n							需要 64 位处理器和操作系统\r\n						</li>\r\n						<li>\r\n							<strong>操作系统:</strong> Windows 10 64bit\r\n						</li>\r\n						<li>\r\n							<strong>处理器:</strong> Intel Core i3-3225\r\n						</li>\r\n						<li>\r\n							<strong>内存:</strong> 4 GB RAM\r\n						</li>\r\n						<li>\r\n							<strong>显卡:</strong> Nvidia GTX 650 Ti\r\n						</li>\r\n						<li>\r\n							<strong>存储空间:</strong> 需要 8 GB 可用空间\r\n						</li>\r\n					</ul>\r\n				</li>\r\n			</ul>\r\n		</div>\r\n	</div>\r\n</div>',	29,	'https://fhdemo.s-cms.cn/t15/media/202011031219064i.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	74,	17,	'2020-11-03 12:18:15',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256793687/movie480_vp9.webm?t=1595535235',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(316,	'吸血鬼（Vampyr） ',	0.00,	'<div class=\"game_page_autocollapse_ctn\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse\">\r\n		<div id=\"game_area_description\" class=\"game_area_description\">\r\n			<p>\r\n				你会拥抱潜藏在身心中的怪物吗？面对吸血鬼猎手、不死的血裔和其它的超自然生物。使用你的邪恶力量，操纵、研习你身边的人类，决定谁是你的下一个受害者。明智选择，挣扎求生……伦敦的命运是毁灭还是救赎，都取决于你的所作所为。\r\n			</p>\r\n			<ul class=\"bb_ul\">\r\n				<li>\r\n					扮演吸血鬼：用你的超自然能力战斗并操控一切\r\n				</li>\r\n				<li>\r\n					捕食求生：既是妙手仁医同时又是潜伏的猎手\r\n				</li>\r\n				<li>\r\n					塑造伦敦面貌：市民之间的紧密联系宛如一张蛛网，并会对你的决定做出反应\r\n				</li>\r\n			</ul>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse sys_req\">\r\n		<h2 style=\"font-size:20px;\">\r\n			系统需求\r\n		</h2>\r\n		<div class=\"sysreq_contents\">\r\n			<div class=\"game_area_sys_req sysreq_content active\">\r\n				<div class=\"game_area_sys_req_leftCol\">\r\n					<span style=\"font-weight:bolder;\">最低配置:</span> \r\n					<ul>\r\n						<li>\r\n							<ul class=\"bb_ul\">\r\n								<li>\r\n									需要 64 位处理器和操作系统\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">操作系统:</span> Windows 7/8/10 (64 bits)\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">处理器:</span> Intel Core i3-2130 (3.4 GHz)/AMD FX-4100 (3.6 GHz)\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">内存:</span> 8 GB RAM\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">显卡:</span> 2 GB, GeForce GTX 1050 (Legacy GPU: GeForce GTX 660) / Radeon R7 370\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">存储空间:</span> 需要 20 GB 可用空间\r\n								</li>\r\n							</ul>\r\n						</li>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	73,	'https://fhdemo.s-cms.cn/t15/media/20201103122121sK.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	28,	10,	'2020-11-03 12:20:10',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256719980/movie480.webm?t=1529064778',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(317,	'范海辛的惊奇之旅:终极剪辑版',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《范海辛的惊奇之旅:终极剪辑版The Incredible Adventures of Van Helsing: Final Cut》是一款精美魔幻风格ARPG游戏，在一个酷似19世纪欧洲的哥特式黑暗世界中，这里充斥着怪兽，魔法和奇异的科技。本作将会带领玩家跟随主人公范海辛的视角，在荒凉的波戈威亚大陆开始传奇般的冒险。形色各异的游戏角色，引人入胜的故事剧情，还有黑暗哥特式的唯美艺术风格，希望为RPG游戏的爱好者们带去前所未有的神奇之旅。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	进入令人难忘的哥特式黑色宇宙&nbsp;–探索妖怪，魔法和怪异科学之地博尔戈维亚。\r\n</li>\r\n<li>\r\n	广告系列中超过50个小时的游戏玩法&nbsp;–播放令人耳目一新的独特故事，并以幽默的幽默和活泼的对话增添趣味。\r\n</li>\r\n<li>\r\n	需要专家！–从六个可玩的类中进行选择，每个类都是狩猎怪物的专家。用钢和枪打败敌人，掌握诡异的科学艺术，或控制魔术和阴影的力量。\r\n</li>\r\n<li>\r\n	各种各样的技能&nbsp;–每个班级都有的庞大而复杂的技能树为您提供了广泛的机会，可以充分利用所选班级。\r\n</li>\r\n<li>\r\n	充满动作的冒险&nbsp;–与具有多种技能和能力的超自然敌人进行激烈的战斗。\r\n</li>\r\n<li>\r\n	狂暴系统&nbsp;–通过花费从令人赞叹的壮举中收集的狂暴点数，您最多可以对三个技能修正器（称为PowerUps）进行收费。\r\n</li>\r\n<li>\r\n	卡塔琳娜夫人（Lady Katarina）&nbsp;–使用特殊能力并量身定制杰出追随者的技能。\r\n</li>\r\n<li>\r\n	猎人巢穴&nbsp;–建立和发展您的藏身处，以藏匿收集到的战利品，与不可玩角色进行交易，在不同地点之间传送并伪造新物品。\r\n</li>\r\n<li>\r\n	塔防迷你游戏&nbsp;–随着敌人的入侵，您有机会通过可部署的陷阱和一些可升级的功能来防御邪恶，捍卫您的巢穴和其他战略要地。\r\n</li>\r\n<li>\r\n	新等级上限&nbsp;–达到100级并在具有荣耀系统，稀有物品和两种独特的终端货币的残局中进一步发展。\r\n</li>\r\n<li>\r\n	场景&nbsp;–播放具有随机生成的地形，怪物，目标和特殊条件的场景图。\r\n</li>\r\n<li>\r\n	在Borgovia从来没有沉闷的一天&nbsp;–尝试每天的任务，挑战和每周活动，这些活动将为您带来新的任务，并在运动后带来长时间的娱乐。\r\n</li>\r\n<li>\r\n	多人游戏&nbsp;–在合作或PvP多人游戏模式（4人合作模式，Touchdown，Arena或Battle Royal）之一中进行游戏时，成为有史以来最伟大的怪物杀手。\r\n</li>\r\n	</ul>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows XP SP3, Windows 7, Windows 8<br />\r\n处理器: Dual Core CPU 2.0 GHz<br />\r\n内存: 2 GB RAM<br />\r\n显卡: GeForce 8800, Radeon HD4000, Intel HD4000 (min. 512 MB VRAM)<br />\r\nDirectX 版本: 9.0<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 40 GB 可用空间<br />\r\n声卡: DirectX 9.0c compatible sound card\r\n		</p>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201103122303Oq.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	44,	6,	'2020-11-03 12:22:47',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256656464/movie480.webm?t=1447378091',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(318,	'《夜勤人 Moonlighter》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《夜勤人 Moonlighter》是一款采用大量类 rogue 元素的动作角色扮演游戏，以威尔的日常生活为主线。威尔是个敢作敢为的掌柜，做着一个英雄梦。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">经营自己的商店<br />\r\n在尼罗卡村做生意时，你可以甩卖商品、精心定价、管理金库、招募售货员和升级商店。不过你得小心谨慎 — 有些人很阴险，可能会偷窃你的贵重商品！<br />\r\n有格调地战斗<br />\r\n打败各种敌人和 boss，揭开艰难而深奥的战斗机制。娴熟地运用武器、精准地把握时机、巧妙地确定位置、深入了解敌人和环境，这些都是你的生存之道。你自己决定如何对战敌人。<br />\r\n重振村庄<br />\r\n在重振这座小商业村庄的繁荣时，了解其他邻居。协助建立新业务，看着业务在这尼罗卡的田园村庄逐渐发展。<br />\r\n制作和施法<br />\r\n掌握制作和施法系统对游戏进展非常重要。和村民交流可以制作新盔甲、武器和给现有装备施法。这样可以提高灵活性和武器的用途。<br />\r\n夺取战利品<br />\r\n穿过神秘古门探索奇异世界，并收集异域文明的珍贵物品：资源、武器、盔甲和特殊神器。不可能卷走一切 — 明智地使用独特的物品栏系统，夺走利益最丰厚的战利品。<br />\r\n获得伙伴<br />\r\n9位忠诚的魔灵愿助你一臂之力，陪你度过千难万险。每个伙伴都有独特的能力，有的能攻击敌人，有的能为你恢复生命值，有的能帮你获取物品，有的能帮你携带物品，本领多多！\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7<br />\r\n处理器: Intel(R) Core(TM)2 Quad 2.7 Ghz, AMD Phenom(TM)II X4 3 Ghz<br />\r\n内存: 4 GB RAM<br />\r\n显卡: GeForce GTX 260, Radeon HD 5770, 1024 MB, Shader Model 3.0<br />\r\n存储空间: 需要 4 GB 可用空间<br />\r\n声卡: DirectX compatible\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201103124922FN.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	39,	10,	'2020-11-03 12:48:42',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/2038213/movie480.webm?t=1447372011',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(319,	'刺客信条4：黑旗',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	游戏名称：刺客信条4：黑旗<br />\r\n英文名称：Assassins Creed IV: Black Flag<br />\r\n游戏类型：动作游戏ACT<br />\r\n游戏制作：Ubisoft Montreal<br />\r\n游戏发行：UbiSoft<br />\r\n登录平台：PC PS3 XBOX360 PS4 XBOX One<br />\r\n游戏语言：中文\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	《刺客信条4：黑旗》时空背景将回到1715年的加勒比海，以《刺客信条3》主角康纳·肯威的祖父英国青年爱德华·肯威为主角，叙述爱德华从参与18世纪逐渐结束的私掠战争、转变成为刺客联盟对圣殿骑士的千年对抗。游戏中将出现如黑胡子、查理斯·范恩等多位历史上着名的海盗王，带领玩家探索西印度群岛的众多岛屿和广大海域，重现那海盗的黄金年代。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	本作将带来一个巨大的开放世界， 收录超过50个可自由探索的地点，战斗系统方面除了使用《刺客信条》经典的刺客武器外，也将导入多项18世纪武器、并同时着重动作与潜行玩法。而系列作中著名的多人游戏体验，也将比以前更加多样化和残暴无情。\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201103125606hz.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	136,	72,	'2020-11-03 12:50:44',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/2030091/movie480.webm?t=1447359487',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(320,	'刺客信条编年史：中国 ',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《刺客信条编年史：中国 Assassin’s Creed Chronicles：China》是一款由育碧蒙特利尔和Climax联合打造的动作冒险游戏。本作的故事发生在十六世纪的中国，并围绕着邵君——中国兄弟会最后一名刺客展开。故事中的邵君在Ezio Auditore那里学到战斗和隐身技能后，决定返回自己的故乡执行复仇任务，而玩家将以她的视角展开一次神奇的中国之旅。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7 SP1 or Windows 8 or Windows 8.1 (32/64bit versions)<br />\r\n处理器: Intel Core 2 Duo E8200 @ 2.6 GHz or AMD Athlon II X2 240 @ 2.8 GHz<br />\r\n内存: 2 GB RAM<br />\r\n显卡: nVidia GeForce GTS450 or AMD Radeon HD5770 (1024MB VRAM with Shader Model 5.0)<br />\r\nDirectX 版本: 10<br />\r\n存储空间: 需要 4 GB 可用空间\r\n</p>',	55,	'https://fhdemo.s-cms.cn/t15/media/20201103130359M5.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	141,	36,	'2020-11-03 12:56:52',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(321,	'人猿星球：最后的边疆/Planet of the Apes: Last Frontier',	0.00,	'<span style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">《人猿星球：最后的边疆(Planet of the Apes: Last Frontier)》是一款由Imaginati Studios制作并发行的动作冒险类游戏，故事发生在电影《人猿星球》一年后，玩家将在游戏中控制人类和猿类的角色，和其他同类游戏一样，根据玩家采取的行动，游戏会有多种不同结局。</span>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201103131629iV.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	57,	9,	'2020-11-03 13:15:59',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(322,	'疯狂的麦克斯/Mad Max',	0.00,	'<div class=\"game_page_autocollapse_ctn\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse\">\r\n		<div id=\"game_area_description\" class=\"game_area_description\">\r\n			<h2 style=\"font-size:20px;\">\r\n				关于这款游戏\r\n			</h2>\r\n			<p>\r\n				扮演Mad Max，末日浩劫后那个以车为生存之本的荒蛮世界中的孤胆战士。在这令人无限期待的开放式世界中，以第三视角的动作游戏模式，你必须在Wasteland中活下来，并用各种无情的载具碾碎那些残暴的土匪团伙。Max，这位打不垮的英雄和生还者，欲将一切疯狂抛在脑后，只为在寓言中的“静谧之原”寻找到属于自己的那份慰藉。玩家将挑战那些似乎不可能完成的任务，扫清一切障碍，并打造属于自己的终极战斗载具。\r\n			</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse sys_req\">\r\n		<h2 style=\"font-size:20px;\">\r\n			系统需求\r\n		</h2>\r\n		<div class=\"sysreq_tabs\">\r\n			<div class=\"sysreq_tab active\">\r\n				Windows\r\n			</div>\r\n			<div class=\"sysreq_tab \">\r\n				Mac OS X\r\n			</div>\r\n			<div class=\"sysreq_tab \">\r\n				SteamOS + Linux\r\n			</div>\r\n			<div>\r\n			</div>\r\n		</div>\r\n		<div class=\"sysreq_contents\">\r\n			<div class=\"game_area_sys_req sysreq_content active\">\r\n				<div class=\"game_area_sys_req_leftCol\">\r\n					<p>\r\n						<span style=\"font-weight:bolder;\">最低配置:</span> \r\n					</p>\r\n					<ul>\r\n						<li>\r\n							<ul class=\"bb_ul\">\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">操作系统:</span> 64 bit: Vista, Win 7, Win 8, Win 10\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">处理器:</span> Intel Core i5-650, 3.2 GHz or AMD Phenom II X4 965, 3.4 Ghz\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">内存:</span> 6 GB RAM\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">显卡:</span> NVIDIA GeForce GTX 660ti (2 GB Memory or higher) or AMD Radeon HD 7870 (2 GB Memory or higher)\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">DirectX 版本:</span> 11\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">存储空间:</span> 需要 32 GB 可用空间\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">附注事项:</span> PlayStation 4 controller support\r\n								</li>\r\n							</ul>\r\n						</li>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201103131920U8.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	53,	17,	'2020-11-03 13:18:15',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/2038914/movie480.webm?t=1447373614',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(323,	'日落过载/落日超驰/Sunset Overdrive',	0.00,	'<span style=\"color:#666666;font-family:微软雅黑;font-size:14px;background-color:#FFFFFF;\">游戏故事内容描述2027年未来世界的日落市，有一间饮料公司开发了一款OverchargeDelirium XT能量饮料，并为新饮料举办上市派对，结果现场喝了这饮料的民众通通都变成黄澄澄的变种人！玩家们的任务就是要消灭这些变种人和阻止这一切恐怖的变身事件。《日落过载》采用广大的开放世界设定，在游戏中玩家可以收集各种道具来组装成各种不同的攻击武器，可创意地采用各种动感、疯狂的动作风格进行战斗体验。</span>',	29,	'https://fhdemo.s-cms.cn/t15/media/20201103143458kg.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	27,	9,	'2020-11-03 13:19:54',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256728972/movie480.webm?t=1541015606',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(324,	'旋塞 COCKHEAD',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《旋塞 COCKHEAD》是一款休闲益智类型的动作冒险独立游戏，这款游戏是由Yoba Games游戏公司所研发，游戏采用经典的手绘风格作为游戏背景，以独特的横向滚屏作为游戏的主要玩法。在游戏中，玩家能够体验到非常有趣的游戏故事剧情。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	1. 完全手绘的图像\r\n</li>\r\n<li>\r\n	2. 不标准环境的经典平台游戏\r\n</li>\r\n<li>\r\n	3. 著名大乐团爵士音乐的伴奏\r\n</li>\r\n<li>\r\n	4. 每人熟悉的故事在一个新的扮演\r\n</li>\r\n	</ul>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7/8/8.1/10 x86 and x64<br />\r\n处理器: Intel Core2 Duo E6750 or equivalent | AMD Athlon 64 X2 Dual Core 6000 or equivalent<br />\r\n内存: 2 GB RAM<br />\r\n显卡: GeForce GT 740 (2048 MB) or equivalent | Radeon HD 5770 (1024 MB)<br />\r\n存储空间: 需要 2 GB 可用空间\r\n		</p>\r\n		<div>\r\n			<br />\r\n		</div>',	34,	'https://fhdemo.s-cms.cn/t15/media/20201103135508lv.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	23,	6,	'2020-11-03 13:53:43',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256767510/movie480.webm?t=1581686524',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(325,	'时代之下 Hidden Through Time',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《时代之下 Hidden Through Time》是一款可爱的“神秘视线”类型游戏，你将在此穿越我们世界的壮阔历史，寻找失散各处的种种物品。在对多彩手绘关卡进行探索时，借助神秘的提示，揭晓每个秘密。<br />\r\n找到足够的物体以前进到下个舞台，穿行于全部四个伟大的时代之间。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7 or later<br />\r\n处理器: Requires a 64-bit processor and operating system<br />\r\n内存: 4 GB RAM<br />\r\n显卡: Geforce GT 430 (1024 MB) / Radeon HD 5570 (1024 MB)<br />\r\nDirectX 版本: 9.0<br />\r\n存储空间: 需要 500 MB 可用空间\r\n</p>',	34,	'https://fhdemo.s-cms.cn/t15/media/20201103135701CM.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	23,	6,	'2020-11-03 13:56:50',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256775417/movie480.webm?t=1581878958',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(326,	'《Disc Room》中文版百度云下载',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《Disc Room》是一款冒险生存游戏，游戏背景设定在了2089年，科学家发现了一个巨大圆盘状的物体出现在了木星轨道上，玩家将扮演被派遣前往勘探的专员，在了解真相前，想尽办法在这个地狱一般的密室中生存下去。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;font-size:14pt;\">最低配置:</span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">操作系统: Windows 7, 8.1, 10 x64<br />\r\n处理器: Intel Core i3-4160 (2 * 3600) or equivalent<br />\r\n内存: 4 GB RAM<br />\r\n显卡: GeForce GT 730 (2048 MB)<br />\r\n存储空间: 需要 1 GB 可用空间\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:18px;\">声明</span>：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。 <br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。 <br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！ <br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。 <br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n	</p>\r\n	<div>\r\n		<br />\r\n	</div>',	73,	'https://fhdemo.s-cms.cn/t15/media/202011031432523q.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	14,	5,	'2020-11-03 14:21:54',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256806074/movie480_vp9.webm?t=1603391870',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(327,	'走过至暗时刻 Through the Darkest of Times',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《走过至暗时刻 Through the Darkest of Times》是一款独立冒险类游戏，柏林，1933 年 1 月。“希特勒成为德国总理了！”我们都知道，这个消息，会把我们引向何方。整个世界，要面临无尽的恐惧和苦难了。面对庞大的德意志帝国，挺身而出的人，少而又少。你会吗？领导一个地下抵抗小组，挺过这历史上的Through the Darkest of Times吧。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	在4个章节中体验最黑暗的年代。\r\n</li>\r\n<li>\r\n	为自由而战、削弱政权并领导你自己的抵抗组织。\r\n</li>\r\n<li>\r\n	策划活动、找到合作者并尽量别被抓到。\r\n</li>\r\n<li>\r\n	肩负重任的你将在进退两难的情况下作出决定，并面对这些决定产生的严重后果。\r\n</li>\r\n<li>\r\n	场景和事件的画面精美而富有表现力。\r\n</li>\r\n	</ul>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7+<br />\r\n处理器: 2.4 GHz<br />\r\n内存: 4 GB RAM<br />\r\n显卡: 1 GB<br />\r\n存储空间: 需要 2 GB 可用空间\r\n		</p>',	56,	'https://fhdemo.s-cms.cn/t15/media/20201103143541GL.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	20,	7,	'2020-11-03 14:35:30',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256773722/movie480.webm?t=1580391076',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(328,	'马赛克 Mosaic',	0.00,	'<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>游戏介绍：</strong></span> \r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"white-space: normal; text-align: justify; color: rgb(102, 102, 102);\">《马赛克 Mosaic》是一款独立冒险游戏，你在一座冰冷的城市里过着枯燥单调的生活，找不到生命的真正意义——直到关键的某一天，怪事自此发生，万物开始变化。Mosaic 是一个极具感染力的冒险游戏，可能会改变你对生活的看法。\r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" sans-serif;font-size:15.6px;font-style:normal;font-weight:400;background-color:rgba(255,=\"\" geneva,=\"\" verdana,=\"\" arial,=\"\" helvetica,=\"\" neue\",=\"\" \"helvetica=\"\" sc\",=\"\" cjk=\"\" sans=\"\" noto=\"\" style=\"white-space: normal; text-align: justify; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><strong>最低配置:</strong></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 10<br />\r\n处理器: Intel i3<br />\r\n内存: 1024 MB RAM<br />\r\n显卡: Geforce GTX 860-series / RX vega 11<br />\r\nDirectX 版本: 9.0c<br />\r\n存储空间: 需要 3 GB 可用空间\r\n</p>',	73,	'https://fhdemo.s-cms.cn/t15/media/20201103143729Vc.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	18,	6,	'2020-11-03 14:36:44',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256769032/movie480.webm?t=1575564497',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(329,	'《过山车之星 Planet Coaster》',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《过山车之星 Planet Coaster》是一款公园模拟游戏！建造您的过山车公园帝国，为人们带来难以置信的惊奇、欢乐和刺激 — 放飞您的想象力，与世界分享您的成就。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">逐件建造：Planet Coaster 能让设计者从人群脱颖而出。铺设道路，构建风景，定制游乐设施，使用一千多种独特的建筑组件，逐件建造，让您公园里的一切都变得独一无二。<br />\r\n塑造地形：与自然为伴，改造您脚下的土地。对地形进行造型，升起山峰，生成湖泊，掘出洞穴，甚至还能修建空中岛屿，让您的过山车穿梭如风。<br />\r\n真实纯粹：重建您最爱的游乐设施抑或把真实世界拒之门外。无论您热衷于何种游戏方式，最真实的游乐设施和来自顾客们最真实的互动都让 Planet Coaster 成为史上最真实的模拟游戏。<br />\r\n模拟性改善：游戏史上最深入的公园模拟游戏将赋予您技巧，让经营充满乐趣。控制顾客体验的方方面面，注意 Planet Coaster 的世界如何即时对您的选择做出响应。<br />\r\n逼真的世界：每个来公园的顾客都是有生命的个体，他们会根据自己的兴趣爱好思考、感受和探索您的公园。新潮的 Planet Coaster 顾客瞥一眼就能知道您公园的运作情况。<br />\r\n公园经营：您就是手握控制权、让经营充满乐趣的老板。在创造性的活动场景中测试您的技巧，或随心建造并改造您的公园，让它为顾客带来惊奇、欢乐和刺激。<br />\r\n共同创作：借助 Steam 创意工坊社区，Planet Coaster 把全世界的过山车迷及创建者连接到一起。您可以与其他玩家进行场景、过山车甚至整个公园的交易，把世界上最大胆的创意添加到自己的公园。<br />\r\n触类旁通：您每天都能在世上最棒的过山车公园创建者那里发现新内容。从您最爱的创建者处浏览并下载内容，或在 Planet Coaster 开发团队挑选出的最新设计中选择内容。<br />\r\n分享您的创意：无论是华丽的冰淇淋商店，还是世界上最刺激的过山车，把它修建出来，为它命名，将它与整个星球分享。加入创建者社区，让您的设计有机会在全世界的公园里出现。\r\n	</p>\r\n	<div>\r\n		<br />\r\n	</div>',	34,	'https://fhdemo.s-cms.cn/t15/media/20201103150100aY.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	80,	37,	'2021-06-29 06:54:58',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256680391/movie480.webm?t=1488290620',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(330,	'深海迷航零度之下 ',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《深海迷航：零度之下 Subnautica: Below Zero》是第一人称冒险游戏，游戏中，玩家将扮演一名失事的宇航员，坠落在一个表面被水覆盖的星球上，这是一个充满惊奇与危险的陌生的海底世界，玩家在这海底中需要搜寻各个物品，不断的合成打造潜艇，创建和地球一样的生存环境，探索各个区域，珊瑚以及火山等等，寻找一切可以帮助自己生存下来的东西，类似于《我的世界》的玩法。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7 64-bit<br />\r\n处理器: Intel Core i3 / AMD Ryzen 3 2.6ghz+<br />\r\n内存: 8 GB RAM<br />\r\n显卡: Intel HD 530 or better<br />\r\nDirectX 版本: 11\r\n	</p>\r\n	<div>\r\n		<br />\r\n	</div>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201103150557ND.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	127,	50,	'2021-06-29 06:55:49',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256741728/movie480.webm?t=1548871336',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(331,	'《荒岛求生 Stranded Deep》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《荒岛求生 Stranded Deep》是一款开放世界生存游戏，担任飞机失事幸存者的角色，被困在太平洋的某个地方。面对一些最危及生命的场景，每次比赛都会产生不同的体验。清除。发现。生存。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	生成无限数量的程序世界&nbsp;– 探索充满详细生物群系的太平洋岛屿，珊瑚礁和无底海洋战壕！<br />\r\n没有两个世界是相同的 – 您可以随时生成一个全新的随机世界。您还可以将使用地图编辑器创建的自己的地图与世界上程序创建的地图混合，以获得更加个性化的体验。如果您想分享，您甚至可以与其他玩家分享您的世界种子。<br />\r\n*请注意，目前生成的世界大小限制为6.25平方公里，但最终的世界规模将大得多。\r\n</li>\r\n<li>\r\n	动态天气和昼夜循环&nbsp;– 在阳光明媚的下午努力驾驭风雨如磐的海洋或享受椰子晒太阳。\r\n</li>\r\n<li>\r\n	独特的基于物理的制作系统&nbsp;– 通过在物理世界中将它们组合在一起来收集资源来创建设备 – 没有精心设计的插槽！\r\n</li>\r\n<li>\r\n	独特的基于物理的建筑系统&nbsp;– 在岛上定居，建造一个避难所或用自己的木筏建造海洋。\r\n</li>\r\n<li>\r\n	详细的生存方面和互动&nbsp;– 管理你的饥饿，口渴，血液和健康的命运，抵御大自然的严酷。\r\n</li>\r\n<li>\r\n	随机掠夺和收集&nbsp;– 搜索沉没的沉船和岛屿，寻找有趣和稀有的设备。\r\n</li>\r\n<li>\r\n	狩猎和捕鱼&nbsp;– 在浅水区长矛小动物或用长矛枪寻找更大的食物。饿死资源岛或维持和管理其增长。\r\n</li>\r\n	</ul>\r\nkAAikHn5A3uZQ 激活码254121',	56,	'https://fhdemo.s-cms.cn/t15/media/20201103151827A9.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	130,	10031,	'2020-11-03 15:06:32',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/2035994/movie480.webm?t=1447365707',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(332,	'一拳超人无名英雄',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《一拳超人：无名英雄 One Punch Man: A Hero Nobody Knows》是一款3v3换人制格斗游戏。不只是广受欢迎的英雄，怪人也以可操作角色的身分参战。因任务的不同而有各种对战条件，例如以埼玉为首的强大英雄们会随后才加入战局。自带中文。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">【最多3对3的换人制格斗游戏】<br />\r\n以『一拳超人』的角色们展开最多3对3的激烈对战！<br />\r\n不只是广受欢迎的英雄，怪人也以可操作角色的身分参战！<br />\r\n操作埼玉及杰诺斯等个性鲜明的角色，享受爽快格斗的乐趣吧！<br />\r\n【玩家本人也能成为新的英雄！】<br />\r\n在主线模式中，玩家操作的是自定义的化身，成为英雄协会的职业英雄后，一边完成任务，一边体验『一拳超人』的世界。<br />\r\n完成与怪人或罪犯战斗等各种任务来提升评价，以S级英雄为目标吧！<br />\r\n在在线大厅里可以和全世界的玩家进行交流。<br />\r\n创造出您理想中的英雄，自豪地展现给全世界的『一拳超人』粉丝看吧！<br />\r\n【英雄总是姗姗来迟！&emsp;「英雄增援系统」】<br />\r\n因任务的不同而有各种对战条件，例如以埼玉为首的强大英雄们会随后才加入战局。<br />\r\n藉由抓准时机防御、打出连段等方式，就能缩短增援角色加入战局所需要的时间！<br />\r\n只要能够让埼玉加入战局，就能一击打倒对手！<br />\r\n善加活用「英雄增援系统」，从危机中奋战到底吧！\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 10 64-bit<br />\r\n处理器: Intel Core i5-2550<br />\r\n内存: 8 GB RAM<br />\r\n显卡: GeForce GTX 570<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 8 GB 可用空间\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	59,	'https://fhdemo.s-cms.cn/t15/media/20201103152519K3.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	81,	15,	'2020-11-03 15:19:23',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256772195/movie480.webm?t=1582816124',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(333,	'《前线Zed/丧尸前线 Frontline Zed》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《前线Zed Frontline Zed》是一款血腥的独立生存冒险游戏，丧尸危机爆发了，晚上借助路障工事抵御丧尸的进攻，白天收集武器，修复防御工事。生存下去，一路穿过美国，获得营救。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	利用好白天的时间 —— 搜寻武器和幸存者，或者修复防御工事。\r\n</li>\r\n<li>\r\n	晚上守住防御工事，消灭蜂拥而至的丧尸。长枪短炮，血肉横飞，杀戮丧尸的画面美不胜收！\r\n</li>\r\n<li>\r\n	长达两小时紧张刺激、情节饱满的游戏内容。一路杀过去，穿越北美大陆，抵达最终的营救点。\r\n</li>\r\n<li>\r\n</li>\r\n	</ul>',	85,	'https://fhdemo.s-cms.cn/t15/media/20201103152734An.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	201,	42,	'2020-11-03 15:26:23',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256763745/movie480.webm?t=1570136365',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(334,	'曼岛TT赛事：边缘竞速2',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《曼岛TT赛事：边缘竞速2 TT Isle of Man Ride on the Edge 2》是一款在超过60公里的超技术赛道上极速赛车，运用真实的骑行技巧一较高下…这就是TT2中等着你的挑战！即将推出许多新功能：开放世界、改版物理、经典摩托车等…\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7<br />\r\n处理器: Intel Core 2 i5-2300 or AMD Phenom II X6 1100<br />\r\n内存: 4 GB RAM<br />\r\n显卡: NVIDIA GeForce GTX 630 2GB, or AMD Radeon HD 5870 2GB<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 18 GB 可用空间\r\n</p>\r\n<div>\r\n	<br />\r\n</div>',	30,	'https://fhdemo.s-cms.cn/t15/media/20201103152939AV.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	66,	17,	'2020-11-03 15:29:00',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256781231/movie480_vp9.webm?t=1586509030',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(335,	'《战地5 Battlefield 5》',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《战地5 Battlefield 5》是一款由DICE制作Electronic Arts发行的第一人称射击类游戏，本作为《战地》系列2018年最新续作，玩家将以前所未见的角度重临二次世界大战。和小队成员一同游玩宏大的大型行动和合作协同作战等全新模式，体验多人模式中的艰苦全面战争，或在单人模式战争故事中见证在全球战火下的精采个人事迹。踏上全球各地壮阔且出人意表的战场，享受史上最为丰富和身临其境的《战地》。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">• 前所未见的二次世界大战 –《战地风云》：回归至系列作的开端，带来别出心裁但至关重大的战争时刻。<br />\r\n• 加入支援64名玩家的多人模式，体验全面战争的混乱：在多人模式的全线战争中领导你的连队，置身广大的大行动模式等全新游戏体验。游玩征服模式等经典游戏模式，或者和好友一同组队作战。<br />\r\n• 有史以来最身临其境的《战地风云》：使用全新的士兵动作组合、防御工事以及灵活的毁灭工具，穿梭整座战场。<br />\r\n• 游玩未曾诉说过的战争故事：在单人模式战争故事中见证在全球战火下的精采个人事迹。从挪威的雪山上顺滑而下，争夺核子武器供给线的控制权;与法国殖民地军队加入前线，或者和一群格格不入的军队边缘人一同深入北非敌后大闹一番。<br />\r\n•战情浪潮：踏上截然不同的战斗旅程，在当中新的内容将不断从天而降，持续将你和连队送往各式各样的二战关键地点，届时将有更多战场和装备等待着你们。\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置：</span></span><br />\r\n操作系统：64位Windows 7，Windows 8.1和Windows 10<br />\r\n处理器（AMD）：AMD FX-8350<br />\r\n处理器（英特尔）：酷睿i5 6600K<br />\r\n内存：8GB RAM<br />\r\n显卡（NVIDIA）：NVIDIA GeForce GTX1050 /NVIDIA GeForce GTX660 2GB<br />\r\n显卡（AMD）：AMD Radeon RX 560 / HD 7850 2GB<br />\r\nDirectX：11.0兼容的显卡或同等产品<br />\r\n在线连接要求：512 KBPS或更快的互联网连接<br />\r\n硬盘空间：50GB\r\n</p>',	44,	'https://fhdemo.s-cms.cn/t15/media/20201103153730DP.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	685,	102,	'2020-11-03 15:36:06',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256787467/movie480_vp9.webm?t=1591887406',	0,	0,	0,	'name,mobile,address',	1,	'',	1.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(336,	'《毁灭战士：永恒 DOOM Eternal》',	1.00,	'<div class=\"game_page_autocollapse_ctn\" style=\"border:currentColor;color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse\" style=\"border:currentColor;\">\r\n		<div class=\"game_area_description\" id=\"game_area_description\" style=\"border:currentColor;\">\r\n			<h2 style=\"color:#313131;font-size:20px;\">\r\n				关于这款游戏\r\n			</h2>\r\n			<p>\r\n				地狱军团入侵了人世间，在恢弘的单人剧情模式中扮演毁灭战士，在各个次元歼灭恶魔，制止人类最终的毁灭。\r\n			</p>\r\n			<p>\r\n				它们唯一所惧怕的……就是你。\r\n			</p>\r\n			<p>\r\n				]在《doom Eternal》中体验速度与力量的终极结合，感受紧张刺激的划时代第一人称射击游戏。\r\n			</p>\r\n		</div>\r\n	</div>\r\n	<div style=\"border:currentColor;\">\r\n		<img class=\"aligncenter\" style=\"height:auto;\" src=\"https://media.st.dl.eccdnx.com/steam/apps/782330/ss_4f93a7c5003d49cb32f6c0c6e547452b284580a0.600x338.jpg?t=1584679348\" /> \r\n	</div>\r\n	<div class=\"game_page_autocollapse\" style=\"border:currentColor;\">\r\n		<div class=\"game_area_description\" style=\"border:currentColor;\">\r\n			<h2 class=\"bb_tag\" style=\"color:#313131;font-size:20px;\">\r\n				毁灭战士的威胁等级达到最高\r\n			</h2>\r\n			<p>\r\n				配备肩扛式火焰喷射器、可伸缩腕带式利刃、升级版枪械、模组以及能力，你将比以往任何时候都更快速、强大和全能。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"color:#313131;font-size:20px;\">\r\n				弑敌三绝招\r\n			</h2>\r\n			<p>\r\n				从敌人身上攫取你的所需，从而成为终极屠魔战士：壮烈击杀可获得额外的生命值；焚烧可增强护甲；使用链锯击杀恶魔可囤积弹药。\r\n			</p>\r\n			<h2 class=\"bb_tag\" style=\"color:#313131;font-size:20px;\">\r\n				进入战斗模式\r\n			</h2>\r\n			<p>\r\n				全新2对1多人游戏模式。一位全副武装的毁灭战士将与两个玩家控制的恶魔展开对决，在五局三胜的激烈第一人称战斗中决一胜负。\r\n			</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"border:currentColor;color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse\" style=\"border:currentColor;\">\r\n		<div class=\"game_area_description\" id=\"game_area_content_descriptors\" style=\"border:currentColor;\">\r\n			<p>\r\n				<img class=\"aligncenter\" style=\"height:auto;\" src=\"https://media.st.dl.eccdnx.com/steam/apps/782330/ss_7e6a2148321c8024285e3924903d8897cac95358.600x338.jpg?t=1584679348\" /> \r\n			</p>\r\n			<p>\r\n				<img class=\"aligncenter\" style=\"height:auto;\" src=\"https://media.st.dl.eccdnx.com/steam/apps/782330/ss_af3b43c4be0029b52ceefaf55ebe1918e2cb3471.600x338.jpg?t=1584679348\" /> \r\n			</p>\r\n			<p>\r\n				<img class=\"aligncenter\" style=\"height:auto;\" src=\"https://media.st.dl.eccdnx.com/steam/apps/782330/ss_ebd31ded4723e991446ededa9e65c980f988567d.600x338.jpg?t=1584679348\" /> \r\n			</p>\r\n			<p>\r\n				<img class=\"aligncenter\" style=\"height:auto;\" src=\"https://media.st.dl.eccdnx.com/steam/apps/782330/ss_1fcebe3689c6a941257509a2ac4b2fdfb1344730.600x338.jpg?t=1584679348\" /> \r\n			</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"border:currentColor;color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse sys_req\" style=\"border:currentColor;\">\r\n		<h2 style=\"color:#313131;font-size:20px;\">\r\n			系统需求\r\n		</h2>\r\n		<div class=\"sysreq_contents\" style=\"border:currentColor;\">\r\n			<div class=\"game_area_sys_req sysreq_content active\" style=\"border:currentColor;\">\r\n				<div class=\"game_area_sys_req_leftCol\" style=\"border:currentColor;\">\r\n					<p>\r\n						<span style=\"font-weight:bolder;\">最低配置:</span> \r\n					</p>\r\n					<ul>\r\n						<li>\r\n							<ul class=\"bb_ul\">\r\n								<li>\r\n									需要 64 位处理器和操作系统\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">操作系统:</span> 64-bit Windows 7 / 64-Bit Windows 10\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">处理器:</span> Intel Core i5 @ 3.3 GHz or better, or AMD Ryzen 3 @ 3.1 GHz or better\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">内存:</span> 8 GB RAM\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">显卡:</span> NVIDIA GeForce GTX 1050Ti (4GB), GTX 1060 (3GB), GTX 1650 (4GB) or AMD Radeon R9 280(3GB), AMD Radeon R9 290 (4GB), RX 470 (4GB)\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">网络:</span> 宽带互联网连接\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">存储空间:</span> 需要 50 GB 可用空间\r\n								</li>\r\n								<li>\r\n								</li>\r\n							</ul>\r\n						</li>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	58,	'https://fhdemo.s-cms.cn/t15/media/202011031545566U.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	188,	41,	'2020-11-03 15:44:30',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256778598/movie480_vp9.webm?t=1586386363',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(337,	'《终结者：抵抗 Terminator: Resistance》',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《终结者：抵抗 Terminator: Resistance》是一款第一人称角色扮演类游戏，游戏中包含许多主线和支线任务，玩家可以按照自己喜欢的方式去进行游戏，既可以和敌人正面刚枪，又可以利用黑客技术暗地里摧毁敌人。主角的技能可以进行升级，逐渐使得Rivers真正成为一名能够和天网对抗的抵抗组织士兵。\r\n</p>\r\n<div>\r\n	<br />\r\n</div>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><a href=\"https://s1.jiligame.com/images/2019/11/15/ia_900000010.jpg\" class=\"highslide-image\"></a> \r\n	</p>',	44,	'https://fhdemo.s-cms.cn/t15/media/202011031547579a.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	81,	11,	'2020-11-03 15:46:55',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256761896/movie480.webm?t=1596218879',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(338,	'使命召唤6现代战争2重制版 ',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《使命召唤6：现代战争2重制版 Call Of Duty: Modern Warfare 2 Campaign》是一款第一人称射击游戏，重新体验 2009 年风靡一时的《使命召唤&reg;：现代战争 2》单人游戏剧情战役，现已为新世代玩家高画质重制。剧情战役紧接划世代巨作《使命召唤&reg;4：现代战争》主线，在全球荣获好评。《现代战争&reg;2》扣人心弦、令人难以喘息，堪称射击游戏巅峰，玩家将面临全新威胁，并全力阻止全球陷入崩溃边缘。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>',	44,	'https://fhdemo.s-cms.cn/t15/media/20201103154958HE.png',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	200,	100,	'2020-11-03 15:49:00',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256691384/movie480.webm?t=1501174612',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(339,	'使命召唤4现代战争',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《使命召唤4：现代战争 Call of Duty: Modern Warfare》是一款射击类游戏。由前几部的以第二次世界大战时期为中心，直接转变为以现代战争为背景。但现在还不清楚游戏是以真实的现代战争为题材，还是选择类似于虚构的国际冲突为主题，也有传言说本作将选取与EA公司的《战地》系列相类似的“中东战争”为题材。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-weight:700;\"><span style=\"font-size:14pt;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7 64-Bit or later<br />\r\n处理器: Intel Core i3-3225 @ 3.30GHz or equivalent<br />\r\n内存: 8 GB RAM<br />\r\n图形: NVIDIA GeForce GTX 660 2GB / AMD Radeon HD 7850 2GB<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n声卡: DirectX 11 Compatible<br />\r\n附注事项: Disk space requirement may change over time.\r\n</p>',	44,	'https://fhdemo.s-cms.cn/t15/media/20201103155048ap.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	166,	84,	'2020-11-03 15:50:04',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256691381/movie480.webm?t=1501174604',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(340,	'《泰坦陨落2 Titanfall 2》',	1.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《泰坦陨落2 Titanfall 2》是一款科幻类第一人称射击游戏《泰坦陨落》的正统续作，依然由Respawn打造。多样的武器装备，可实现短暂飞行和跳跃的火箭包，以及驾驶机甲战斗是本系列主打的特色，也是让玩家们津津乐道的游戏特点。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Win 7/8/8.1/10 64bit<br />\r\n处理器: Intel Core i3-6300t or equivalent [4 or more hardware threads]<br />\r\n内存: 8 GB RAM<br />\r\n显卡: NVIDIA Geforce GTX 660 2GB or AMD Radeon HD 7850 2GB<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 45 GB 可用空间\r\n</p>',	35,	'https://fhdemo.s-cms.cn/t15/media/20201103160502he.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	121,	32,	'2020-11-03 15:57:01',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256789141/movie480_vp9.webm?t=1592506505',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(341,	'《雨中冒险2 Risk of Rain 2》',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《雨中冒险2 Risk of Rain 2》是一款多人侠盗游戏。浴血奋战杀出暴戾的怪物重围，在混乱的外星球上逃过劫难。可孤军奋战，也可与好友并肩作战。 以出人意料的方式合成战利品，同时精通每个角色，直至您自己成为初次迫降时曾颇为惧怕的恐怖威胁。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span>\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">在外星球上生存下来<br />\r\n十几个亲手打造的场景地点恭候大驾，那里满是等待挑战的怪物和巨型Boss，力图将您剪除消灭。 奋力搏杀，直至抵达终极Boss并躲过其击杀，或无限继续游戏，看您最终能坚持生存多久。 独特的调整系统可让您和敌人的力量在一场游戏中无限增长。<br />\r\n发现威力巨大的新物品<br />\r\n超过110件物品可让每轮游戏都充满新鲜感和刺激的挑战。 收集的物品越多，合成的效力越强，其中一些合成品也就越惊艳。 发现的物品越多，您能通过日志发掘的传说或策略也就会越多。<br />\r\n解锁新玩法<br />\r\n解锁一个包含十名可玩幸存者的团队，每名幸存者都拥有其独特的战斗风格和替换技能可以掌握。 学习神器的奥秘以切换友方误伤、随机幸存者生成、物品选择等游戏调整器内容。 随机的关卡、敌人和物品，带给您绝不重复的游戏体验。<br />\r\n单人游戏或合作游戏<br />\r\n您可以独自踏上冒险，也可以与最多三名好友一同线上合作冒险，还可以前往棱镜试炼的车轮挑战进行战斗。 船长和MUL-T等全新的幸存者将加入工程师、女猎人还有指挥官等经典幸存者之列。\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7 or newer, 64-bit<br />\r\n处理器: Intel Core i3-6100 / AMD FX-8350<br />\r\n内存: 4 GB RAM<br />\r\n显卡: GTX 580 / AMD HD 7870<br />\r\nDirectX 版本: 11<br />\r\n网络: 宽带互联网连接<br />\r\n存储空间: 需要 4 GB 可用空间\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏截图：</span></span>\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">说明：winRAR解压，安装游戏记得全英文路径，关杀毒软件哦。</span></span>\r\n	</p>',	41,	'https://fhdemo.s-cms.cn/t15/media/20201103162239Em.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	20,	3,	'2020-11-03 16:21:44',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256795993/movie480_vp9.webm?t=1597157826',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(342,	'黑手党2/四海兄弟2/最终版/Mafia II: Definitive Edition',	1.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:微软雅黑;\"><span style=\"font-size:medium;\">游戏名称：四海兄弟2：决定版<br />\r\n游戏别名：黑手党2最终版<br />\r\n英文名称：Mafia II: Definitive Edition<br />\r\n游戏类型：第三人称射击TPS<br />\r\n游戏制作：Hangar 13,D3T<br />\r\n游戏发行：2K<br />\r\n游戏平台：PS4,XBOX ONE,PC<br />\r\n游戏语言：英文,中文,日文<br />\r\n发售日期：2020-05-20<br />\r\n</span></span> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	【游戏介绍】\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	游戏经过了高清重制，玩家将在四海兄弟的黄金时代扮演一名枭雄。为了还清父亲欠下的债务，战争英雄维托·斯卡莱塔勾搭上了黑手党。在伙伴乔的帮助下，维托努力证明着自己，通过犯下奖励更多、名声更响、后果更严重的罪行，他在黑道家族之中的地位越来越有分量。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	【游戏截图】\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/05/20/2020052091347679.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/05/20/2020052091349683.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/05/20/2020052091350444.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/05/20/2020052091352183.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/05/20/2020052091354332.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/05/20/2020052091355252.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/05/20/2020052091357874.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/05/20/2020052091359708.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/05/20/2020052091401451.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/05/20/202005209140353.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	【游戏配置】\r\n</p>\r\n<div class=\"quote\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<blockquote style=\"margin-left:0px;background:#F0F4F5;font-family:RiPlus-Black;\">\r\n		<p>\r\n			推荐配置<br />\r\n操作系统:&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp;Windows 8.1 64-bit<br />\r\n处理器&emsp;:&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp;Intel i7-3770 or AMD FX 8350<br />\r\n图形显卡:&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp;4GB NVIDIA GeForce GTX 780 or 4GB AMD Radeon R9 290X<br />\r\n内存容量:&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp;8 GB RAM<br />\r\n硬盘空间:&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp;需要 50 GB 可用空间\r\n		</p>\r\n	</blockquote>\r\n</div>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201103162629rh.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	101,	23,	'2020-11-03 16:25:57',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256785635/movie480_vp9.webm?t=1589909147',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(343,	'控制/Control终极版',	1.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	游戏介绍】\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	游戏的主要场景就发生在美国联邦政府下的控制局中，一座庞大且可以不断变换形态的建筑。游戏简单的故事背景是，这个控制局已经被超自然力量腐蚀，玩家扮演的女主杰西·法登需要去调查这个奇异事件。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	【游戏截图】\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2019/07/29/2019072920226713.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" />\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2019/07/29/2019072920228784.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" />\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2019/07/29/2019072920231393.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" />\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2019/07/29/2019072920232859.jpg\" alt=\"\" width=\"800\" height=\"449\" style=\"height:auto;\" />\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2019/07/29/2019072920233256.jpg\" alt=\"\" width=\"800\" height=\"449\" style=\"height:auto;\" />\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	【游戏配置】\r\n</p>\r\n<table class=\"t_table\" cellspacing=\"0\" style=\"font-size:13px;width:936px;color:#555555;font-family:Lato, sans-serif;background-color:#FFFFFF;\">\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"font-size:13px;border:1px solid #F4F4F4;color:#9B9B9B;vertical-align:middle;\">\r\n				Minimum\r\n			</td>\r\n			<td style=\"font-size:13px;border:1px solid #F4F4F4;color:#9B9B9B;vertical-align:middle;\">\r\n				Recommended\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"font-size:13px;border:1px solid #F4F4F4;color:#9B9B9B;vertical-align:middle;\">\r\n				OSWindows 7, 64-bit\r\n			</td>\r\n			<td style=\"font-size:13px;border:1px solid #F4F4F4;color:#9B9B9B;vertical-align:middle;\">\r\n				OSWindows 10, 64-bit\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"font-size:13px;border:1px solid #F4F4F4;color:#9B9B9B;vertical-align:middle;\">\r\n				ProcessorIntel Core i5-4690 / AMD FX 4350\r\n			</td>\r\n			<td style=\"font-size:13px;border:1px solid #F4F4F4;color:#9B9B9B;vertical-align:middle;\">\r\n				ProcessorIntel Core i5-7600K / AMD Ryzen 5 1600X\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"font-size:13px;border:1px solid #F4F4F4;color:#9B9B9B;vertical-align:middle;\">\r\n				Graphics CardNVIDIA GeForce GTX 780 / AMD Radeon R9 280X\r\n			</td>\r\n			<td style=\"font-size:13px;border:1px solid #F4F4F4;color:#9B9B9B;vertical-align:middle;\">\r\n				Graphics CardNVIDIA GeForce GTX 1660/1060 / AMD Radeon RX 580 AMD | For Ray Tracing: GeForce RTX 2060\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"font-size:13px;border:1px solid #F4F4F4;color:#9B9B9B;vertical-align:middle;\">\r\n				RAM8 GB\r\n			</td>\r\n			<td style=\"font-size:13px;border:1px solid #F4F4F4;color:#9B9B9B;vertical-align:middle;\">\r\n				RAM16 GB\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"font-size:13px;border:1px solid #F4F4F4;color:#9B9B9B;vertical-align:middle;\">\r\n				DirectXDX11\r\n			</td>\r\n			<td style=\"font-size:13px;border:1px solid #F4F4F4;color:#9B9B9B;vertical-align:middle;\">\r\n				DirectXDX11 / DX12\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"font-size:13px;border:1px solid #F4F4F4;color:#9B9B9B;vertical-align:middle;\">\r\n				Additional FeaturesWidescreen support 21:9 / Remappable controls / Uncapped frame-rate / G-Sync / Freesync support\r\n			</td>\r\n			<td style=\"font-size:13px;border:1px solid #F4F4F4;color:#9B9B9B;vertical-align:middle;\">\r\n				Additional FeaturesWidescreen support 21:9 / Remappable controls / Uncapped frame-rate / G-Sync / Freesync support\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201103162734rw.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	90,	27,	'2020-11-03 16:26:50',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256795665/movie480_vp9.webm?t=1597237239',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(344,	'疯狂派对2/Party Hard 2',	0.00,	'<div class=\"game_page_autocollapse_ctn expanded\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse\">\r\n		<div id=\"game_area_description\" class=\"game_area_description\">\r\n			<h2 style=\"font-size:20px;\">\r\n				关于这款游戏\r\n			</h2>\r\n			<p>\r\n				你一直希望能好好睡上一觉……但现在又来到了凌晨三点，邻居家里的派对比以往更吵了。你必须不惜一切代价阻止它。\r\n			</p>\r\n			<p>\r\n				<br />\r\n			</p>\r\n			<p>\r\n				最疯狂的的派对暗杀策略游戏回来了！使用数百种方法干掉那些讨厌的派对常客，失手覆灭贩毒集团，并保护地球免遭外星人入侵。《派对杀手 2》在保留原来的疯狂派对破坏核心前提下，同时引入了大量新功能：\r\n			</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse_ctn\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"game_page_autocollapse sys_req\">\r\n		<div class=\"sysreq_contents\">\r\n			<div class=\"game_area_sys_req sysreq_content active\">\r\n				<div class=\"game_area_sys_req_leftCol\">\r\n					<span style=\"font-weight:bolder;\">最低配置:</span> \r\n					<ul>\r\n						<li>\r\n							<ul class=\"bb_ul\">\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">操作系统:</span> Windows XP/7/8/10\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">处理器:</span> Intel Core i3\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">内存:</span> 4096 MB RAM\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">显卡:</span> NVIDIA GeForce GT 920M\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">DirectX 版本:</span> 11\r\n								</li>\r\n								<li>\r\n									<span style=\"font-weight:bolder;\">存储空间:</span> 需要 6 GB 可用空间\r\n								</li>\r\n							</ul>\r\n						</li>\r\n					</ul>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	33,	'https://fhdemo.s-cms.cn/t15/media/20201103163436kt.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	30,	10,	'2020-11-03 16:33:47',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256726021/movie480.webm?t=1545816248',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(345,	'勇者斗恶龙11/追寻逝去的时光/英雄1.2（Dragon Quest XI – Sugi Sarishi Toki o Motomete）',	1.00,	'<div style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	版本介绍：勇者斗恶龙11|完整版|集成3DMv3.5简体汉化|支持键盘.鼠标.手柄|赠官方原声70首BGM|赠多项修改器|赠全收集存档|赠历代游戏《勇者斗恶龙2》《勇者斗恶龙1》\r\n</div>\r\n<div style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	《勇者斗恶龙11(Dragon Quest XI)》是由Square Enix制作发行的一款角色扮演类游戏，游戏中男主角在一个名为石之村的小村庄长大，16岁时村庄为他举办了传统的成人仪式，在仪式上他得知自己正是传说中拯救世界的勇者转生，而他也将背负着重大的使命。为了了解有关勇者的一切，主角离开家乡踏上了冒险之旅。然而出乎意料的是，国王却直指主角是恶魔之子，两边冲出士兵将主角团团围住。身为勇者转世的主角为何会被视为恶魔之子？\r\n</div>\r\n<div style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n</div>\r\n<div style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	操作系统：Windows 7 64bit or betterCPU：Intel Core i3-2105内存：8GB RAM显卡：NVIDIA GeForce GTX 750Ti存储空间：需要32GB可用空间\r\n</div>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201103163611Zm.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	77,	20,	'2020-11-03 16:35:36',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256810686/movie480_vp9.webm?t=1607101931',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(346,	'闪乱神乐少女们的选择',	0.00,	'<div class=\"para-title level-3\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<p>\r\n		《闪乱神乐：少女们的选择(Senran Kagura: Estival Versus)》是由Marvelous Games制作发行的一款美少女激斗类无双游戏，拥有系列最全的可操控角色。游戏的一系列设定如乳摇、碎衣都会让你大呼过瘾。 玩家使用各类招式以及武器来战胜游戏中的敌人(包括猫女等等)。战斗中的声效伴随着痛苦的叫声以及武器击中敌人的声音。进一步的战斗之后，玩家可以撕裂对手的衣物，敌人会出现部分裸露，甚至出现胸部全裸的画面—不过该部分会有一道光芒来充当马赛克的作用。在本作的一个秘密小游戏中，玩家可以通过点击屏幕来脱掉女性角色的衣服。一些游戏画集也包含了许多暴露的妹子出境，此外，在本作的对话中，同时也包含了诸如“我能摸索你的胸部吗?”这样的对话，一些脏话也出现在了游戏中。\r\n	</p>\r\n	<h3 class=\"title-text\" style=\"font-size:18px;\">\r\n		最低配置：\r\n	</h3>\r\n</div>\r\n<div class=\"para\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	操作系统：Windows 7+\r\n</div>\r\n<div class=\"para\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	CPU：Intel Core i3-550 3.2 GHz (2-core)\r\n</div>\r\n<div class=\"para\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	内存：6 GB RAM\r\n</div>\r\n<div class=\"para\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	显卡：NVIDIA GeForce GTS 450\r\n</div>\r\n<div class=\"para\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	DirectX 版本：9.0\r\n</div>\r\n<div class=\"para\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	存储空间：需要19GB可用空间\r\n</div>\r\n<div class=\"para\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	声卡:：Compatible with DirectX 9.0\r\n</div>',	57,	'https://fhdemo.s-cms.cn/t15/media/202011031713355T.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	64,	19,	'2020-11-03 16:36:56',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256681551/movie480.webm?t=1489784131',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(347,	'我的英雄学院2我的正义',	1.00,	'<div class=\"game_page_autocollapse\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div id=\"game_area_description\" class=\"game_area_description\">\r\n		<p>\r\n			游戏介绍】<br />\r\n比获得好评的「我的英雄学院」对战动作游戏前作更加丰富许多，<br />\r\n「我的英雄学院 唯我正义<span style=\"font-weight:bolder;\">2</span>」即将登场！<br />\r\n尽情在关卡奔驰，以来自「个性」的超人力量体验充满魄力的战斗吧！\r\n		</p>\r\n		<p>\r\n			【截图欣赏】\r\n		</p>\r\n		<p>\r\n			<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1058450/ss_fe942b3aef6f5872430aa28f8141658e1802ed6c.1920x1080.jpg\" style=\"height:auto;\" /> \r\n		</p>\r\n		<p>\r\n			<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1058450/ss_0ddda0b27dc6d2cee763aae4ed70639b326623ce.1920x1080.jpg\" style=\"height:auto;\" /> \r\n		</p>\r\n		<p>\r\n			<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1058450/ss_840bb10139792b5174092f6198ceb2b28fb1b831.1920x1080.jpg\" style=\"height:auto;\" /> \r\n		</p>\r\n		<p>\r\n			<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1058450/ss_9cf1d7e42e1ee5305efc40839627f9f371602efe.1920x1080.jpg\" style=\"height:auto;\" /> \r\n		</p>\r\n		<p>\r\n			<img src=\"https://media.st.dl.pinyuncloud.com/steam/apps/1058450/ss_ced333216e9930fa3e91b0c449cedfb9341d2bc9.1920x1080.jpg\" style=\"height:auto;\" /> \r\n		</p>\r\n		<p>\r\n			<br />\r\n		</p>\r\n		<p>\r\n			【动图欣赏】\r\n		</p>\r\n		<p>\r\n			<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/1058450/extras/MHOJ2_GIF.gif?t=1586211510\" style=\"height:auto;\" /> \r\n		</p>\r\n	</div>\r\n</div>\r\n<div class=\"game_page_autocollapse sys_req\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<p>\r\n		【配置要求】\r\n	</p>\r\n	<div class=\"sysreq_contents\">\r\n		<div class=\"game_area_sys_req sysreq_content active\">\r\n			<div class=\"game_area_sys_req_leftCol\">\r\n				<p>\r\n					<span style=\"font-weight:bolder;\">最低配置:</span> \r\n				</p>\r\n				<ul>\r\n					<li>\r\n						<ul class=\"bb_ul\">\r\n							<li>\r\n								需要 64 位处理器和操作系统\r\n							</li>\r\n							<li>\r\n								<span style=\"font-weight:bolder;\">操作系统:</span> WINDOWS 7, 64 bit\r\n							</li>\r\n							<li>\r\n								<span style=\"font-weight:bolder;\">处理器:</span> Intel Core i5-750 / AMD Phenom II X4 940\r\n							</li>\r\n							<li>\r\n								<span style=\"font-weight:bolder;\">内存:</span> 4 GB RAM\r\n							</li>\r\n							<li>\r\n								<span style=\"font-weight:bolder;\">显卡:</span> NVIDIA GeForce GTX 460 / AMD Radeon HD 6870\r\n							</li>\r\n							<li>\r\n								<span style=\"font-weight:bolder;\">DirectX 版本:</span> 11\r\n							</li>\r\n							<li>\r\n								<span style=\"font-weight:bolder;\">网络:</span> 宽带互联网连接\r\n							</li>\r\n							<li>\r\n								<span style=\"font-weight:bolder;\">存储空间:</span> 需要 1<span style=\"font-weight:bolder;\">2</span> GB 可用空间\r\n							</li>\r\n						</ul>\r\n					</li>\r\n				</ul>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	57,	'https://fhdemo.s-cms.cn/t15/media/20201103171544HW.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	19,	5,	'2020-11-03 17:13:48',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(348,	'火星求生/Surviving Mars',	0.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	游戏介绍】\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	一款生存建造类游戏。是时候在这颗红色星球上开疆拓土了，你将在火星上建造第一个人类殖民地，你所需的不仅是补给和氧气，还有大量的实践训练和对付风沙的经验，视频中我们可以看到，从一片荒芜火星，一点点建造成人头攒动的大城市的过程，护罩是保证生存的关键，玩家还面临着许多危机，比如小行星的坠落。\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	【游戏截图】\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2017/08/21/2017082123435784.jpg\" alt=\"\" width=\"800\" height=\"500\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2017/08/21/2017082123438602.jpg\" alt=\"\" width=\"800\" height=\"500\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2017/08/21/2017082123440370.jpg\" alt=\"\" width=\"800\" height=\"500\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2017/08/21/2017082123442617.jpg\" alt=\"\" width=\"800\" height=\"500\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2017/08/21/2017082123444915.jpg\" alt=\"\" width=\"800\" height=\"500\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	【游戏配置】\r\n</p>\r\n<div class=\"quote\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<blockquote style=\"margin-left:0px;background:#F0F4F5;font-family:RiPlus-Black;\">\r\n		<p>\r\n			推荐配置<br />\r\n操作系统:&nbsp; &nbsp; &nbsp; &nbsp; Windows 7 64-bit or newer<br />\r\n处理器&emsp;:&nbsp; &nbsp; &nbsp; &nbsp; Fast quad-core CPUs<br />\r\n图形显卡:&nbsp; &nbsp; &nbsp; &nbsp; GeForce 970-level GPU with 4GB of video RAM<br />\r\n内存容量:&nbsp; &nbsp; &nbsp; &nbsp; 8 GB RAM<br />\r\n硬盘空间:&nbsp; &nbsp; &nbsp; &nbsp; 需要 10 GB 可用空间\r\n		</p>\r\n	</blockquote>\r\n</div>',	85,	'https://fhdemo.s-cms.cn/t15/media/20201103171726cj.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	68,	16,	'2020-11-03 17:16:06',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256737064/movie480.webm?t=1543582962',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(349,	'捕获物：鲤鱼和大鱼',	1.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:微软雅黑;\"><span style=\"font-size:medium;\">游戏名称：捕获物：鲤鱼和大鱼<br />\r\n英文名称：The Catch: Carp &amp; Coarse<br />\r\n游戏类型：模拟经营SIM<br />\r\n游戏制作：Dovetail Games<br />\r\n游戏发行：Dovetail Games – Fishing<br />\r\n游戏平台：PC<br />\r\n游戏语言：中文,英文<br />\r\n发售日期：2020-06-30<br />\r\n</span></span> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	【游戏介绍】\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	追踪和征服世界各地的巨型大鱼，为你带来终生难忘的刺激体验。要钓到游戏中的共 35 种鱼类，你必须有巧妙的作战技巧和精湛的钓鱼技术，这样才能收获各个水域中的全部终极大鱼。要想成为终极玩家，你既要有耐心，又要有战斗力。根据时间和天气状况，谨慎选择你的钓点和渔具装备。准备好后，向水中抛竿，和这些罕见巨怪来一场恶战！\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	【游戏截图】\r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/06/23/20200623112612980.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/06/23/20200623112614573.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/06/23/20200623112615632.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/06/23/20200623112617740.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/06/23/2020062311261830.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/06/23/20200623112620510.jpg\" alt=\"\" width=\"800\" height=\"449\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<img src=\"http://images.ali213.net/picfile/pic/2020/06/23/20200623112622802.jpg\" alt=\"\" width=\"800\" height=\"450\" style=\"height:auto;\" /> \r\n</p>\r\n<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	【游戏配置】\r\n</p>\r\n<div class=\"quote\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<blockquote style=\"margin-left:0px;background:#F0F4F5;font-family:RiPlus-Black;\">\r\n		<p>\r\n			最低配置<br />\r\n操作系统:&nbsp; &nbsp; &nbsp; &nbsp; Windows&reg; 7 64bit / 8 64bit<br />\r\n处理器&emsp;:&nbsp; &nbsp; &nbsp; &nbsp; Quad-Core 3.5 Ghz<br />\r\n图形显卡:&nbsp; &nbsp; &nbsp; &nbsp; Graphics Card with 2 GB Video RAM: Nvidia Geforce GTX 750 or equivalent<br />\r\n内存容量:&nbsp; &nbsp; &nbsp; &nbsp; 8 GB RAM<br />\r\n硬盘空间:&nbsp; &nbsp; &nbsp; &nbsp; 需要 21 GB 可用空间\r\n		</p>\r\n	</blockquote>\r\n</div>',	56,	'https://fhdemo.s-cms.cn/t15/media/20201103171915eE.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	47,	10,	'2020-11-03 17:18:20',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256790990/movie480_vp9.webm?t=1593177641',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(350,	'无主之地3 Borderlands 3',	1.00,	'<p style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	版本介绍：完整版|容量58GB|官方简体中文|支持键盘.鼠标.手柄|赠多项修改器|赠高分等橙装存档\r\n</p>\r\n<div class=\"About-content_36fff402\" style=\"color:#555555;font-family:Lato, sans-serif;font-size:15px;background-color:#FFFFFF;\">\r\n	<div class=\"AccordionWrapper-accordion_90193bfd AccordionWrapper-loaded_36a0aa5d AccordionWrapper-collapsable_5bbc9c29 AccordionWrapper-expanded_6de2c3a1\">\r\n		<div class=\"AccordionWrapper-wrapper_267e06d7\">\r\n			<div class=\"AccordionWrapper-inner_d1b5071e\">\r\n				<div class=\"Markdown-wrapper_cae59fd2 About-content_36fff402 About-markdown_20d97aba\">\r\n					<h2 style=\"font-size:28px;\">\r\n						疯狂一触即发\r\n					</h2>\r\n					<div class=\"Markdown-paragraph_5c6d0ac5\">\r\n						射击夺宝游戏的鼻祖载誉归来，为您带来<em>无穷无尽</em>&nbsp;的枪械和一场躁动无限的冒险旅途！选择四名全新寻宝猎人的其中一位，披挂上阵，在全新的世界中和新型敌人展开殊死之战。您可以单人游玩或是和好友一同与疯狂的敌人作战夺取成堆的战利品，并从星系最为残忍的邪教领袖手中拯救家园。\r\n					</div>\r\n					<h2 style=\"font-size:28px;\">\r\n						一场躁动无限的冒险旅途\r\n					</h2>\r\n					<div class=\"Markdown-paragraph_5c6d0ac5\">\r\n						阻止疯狂的Calypso Twins联合众强盗部族并夺取星系的终极力量。\r\n					</div>\r\n					<h2 style=\"font-size:28px;\">\r\n						寻宝猎人任你挑，玩法任你定\r\n					</h2>\r\n					<div class=\"Markdown-paragraph_5c6d0ac5\">\r\n						扮演四位全新的寻宝猎人的其中一位，每人都有丰富的技能树、能力和自定义选项。\r\n					</div>\r\n					<h2 style=\"font-size:28px;\">\r\n						锁定、装弹和寻宝\r\n					</h2>\r\n					<div class=\"Markdown-paragraph_5c6d0ac5\">\r\n						游戏中巨量的枪支和装备让你每次战斗都有机会获得新兵器。\r\n					</div>\r\n					<h2 style=\"font-size:28px;\">\r\n						全新的《无主之地》\r\n					</h2>\r\n					<div class=\"Markdown-paragraph_5c6d0ac5\">\r\n						探索潘多拉（Pandora）之上的全新世界，每个世界都有不同的环境和敌人。\r\n					</div>\r\n					<h2 style=\"font-size:28px;\">\r\n						快速行动，无间合作\r\n					</h2>\r\n					<div class=\"Markdown-paragraph_5c6d0ac5\">\r\n						无论你是什么等级，任务进度如何，都可以随时随机选择伙伴在线合作。\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>',	44,	'https://fhdemo.s-cms.cn/t15/media/20201103174117mp.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	200,	50,	'2020-11-03 17:39:55',	0,	1,	1,	'',	1,	'',	'',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(351,	'科技狂潮 Techno Tsunami',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《科技狂潮 Techno Tsunami》是一款角色扮演游戏，与机器人战斗或是与之合作？隐藏在机器人背后并操控他们的人类是敌是友？你将解开各种谜题，并逐步揭开太空邮轮神秘的面纱，靠近阴谋或者真相。游轮上出现的未来科技，似乎会带来毁灭性的灾难。你要做的就是收集那些“科技”，以此拯救未来和过去。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<ul class=\"bb_ul\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">\r\n<li>\r\n	神秘的太空游轮上，各时代不同艺术风格的物品齐聚一堂\r\n</li>\r\n<li>\r\n	丰富的解谜元素和未来世界的奥秘可供探索\r\n</li>\r\n<li>\r\n	琳琅满目的未来科技物品，等待你的收集\r\n</li>\r\n<li>\r\n	与被程操控的机器人一起战斗或合作，窥探这些机器人背后操控者的动机\r\n</li>\r\n	</ul>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7 64 bit<br />\r\n处理器: 2.5 GHz Processor or better<br />\r\n内存: 8 GB RAM<br />\r\n显卡: NVIDIA GeForce GTX 470 / AMD Radeon 6870 HD<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 3 GB 可用空间\r\n		</p>',	28,	'https://fhdemo.s-cms.cn/t15/media/20201103182856v0.jpg',	1,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	23,	6,	'2020-11-03 17:42:55',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256807259/movie480_vp9.webm?t=1603945364',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(352,	'《Pacer》中文版',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《Pacer》是一款最具破坏性的澎湃动能反重力竞速游戏。定制飞行器和武器，然后参与战役、单人赛或通过爆炸性的多人在线赛与对手一竞高下，获得终极战斗竞速体验。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n需要 64 位处理器和操作系统<br />\r\n操作系统: Windows 7 64bit<br />\r\n处理器: i5 2.7GHz / AMD A10-5700 OR FX-6300<br />\r\n内存: 8 GB RAM<br />\r\n显卡: Nvidia Geforce 740 / R7 260<br />\r\nDirectX 版本: 10<br />\r\n存储空间: 需要 17 GB 可用空间\r\n</p>',	30,	'https://fhdemo.s-cms.cn/t15/media/20201103183101XS.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	38,	6,	'2020-11-03 18:30:49',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256800372/movie480_vp9.webm?t=1603945430',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(353,	'刑罚 Infliction',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《刑罚 Infliction》是一款互动式心理恐怖游戏，在一个看上去很正常的郊区住宅中，对潜伏其中的黑暗进行一次可怕的探索。徘徊游荡在一个曾经幸福美满的家庭的废墟里，通过阅读信件和日记、听取语音邮件和拼凑线索，来了解这些引导你来到这里的可怕事件。<br />\r\n但是，你并不孤单。这座房子里还剩下一些别的东西，是一种无限的悲伤和愤怒。当你寻找线索时，它会伤害你，等待机会向你发泄它的愤怒。<br />\r\n你可以存活足够长的时间来寻找赎罪机会吗？\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">你并不孤单——一个不安分的AI敌人会跟踪你。你不想被抓住。你会逃跑、躲藏，还是想办法反击?<br />\r\n扭曲的现实——在一个现实的，交互式的郊区住宅里进行探索。你进行的越深入，一切就越破碎和扭曲。<br />\r\n拼凑线索——阅读信件、寻找日记和检查这个破碎家庭的纪念物品，来了解这些引导你来到这里的可怕事件。<br />\r\n几近真实——故事基于现实世界的家庭悲剧，有着我们都知道的恐惧和伤害：心碎，背叛信任，悲伤和失落。<br />\r\n光明与黑暗——虚幻的力量渲染了一个逼真的环境，动态的灯光和阴影让你眼花缭乱或者让你陷入黑暗。<br />\r\n选择你的挑战——标准难度偶尔会为你指出正确的方向，但在困难难度下，你将完全靠自己。\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: 操作系统：64位，Windows 7及更高版本<br />\r\n处理器: 处理器：英特尔&reg;i5-4590/ AMD FX 8350等效或更高<br />\r\n内存: 8 GB RAM<br />\r\n显卡: 显卡：Nvidia GTX 660 2GB / AMD Radeon HD 7870<br />\r\nDirectX 版本: 11<br />\r\n存储空间: 需要 6200 MB 可用空间\r\n</p>',	37,	'https://fhdemo.s-cms.cn/t15/media/202011031831575B.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	34,	7,	'2020-11-03 18:31:47',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256805898/movie480_vp9.webm?t=1603315404',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(354,	'幻想将军2 整合燃烧帝国DLC',	0.00,	'<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">游戏介绍：\r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《幻想将军2 Fantasy General II》是一款经典战略游戏，自从影子战争摧毁了凯尔多尼亚以及艾尔世界的土地已经过去了三百年，过去的争斗早已逐渐变成传说。 在法拉赫高地，野蛮人战士的部落在北方严酷的环境下艰难求生，部落之间经常发生冲突，并袭扰洗劫附近富饶的边疆城镇。边疆部落受够了他们持续不断的骚扰，他们向帝国寻求援助——强大的帝国控制着从斯嘉丽山脉到锡尼海姆山谷以及灰木地区的土地。西部帝国军团被命令前往高地剿灭匪徒，在边疆部落伊塞尔和马尼尔的协助下，在龙关之战中击杀了大王布伦丹。 他们签署了一项和平协议，禁止任何部落进入边境。从那时起，那里没有产生一位大王来重新团结部落，他们陷入了内讧之中。 在这个黑暗的年代，你的部落由独眼法里尔领导，一名德高望重的战士。你是他的儿子和指定继承人，你也渴望向部落长老会和父亲证明自己的能力……\r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">游戏特色：\r\n</p>\r\n<p 0.95);\"=\"\" 255,=\"\" font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">遗产<br />\r\n《Fantasy General II》是90年代经典战略游戏的翻版！ 军队再次在饱受战火蹂躏的凯尔多尼亚土地上部好战线，新一代指挥官们将互相测验他们的勇气与战术。幻想战争游戏回来了！<br />\r\n战斗<br />\r\n忠于原版游戏的传统，《Fantasy General II》是基于回合制的战斗。指挥超过75种不同的独特单位，包括强大的英雄。 考虑地形、武器与盔甲、魔法效果、士气与军队之间的平衡，指定并执行战斗计划，击败敌人，作为野蛮人战争领袖扬名立万。<br />\r\n战役<br />\r\n在一场又一场的战斗之后，你需要做决定并部署军队。年轻的部落成员需要接受训练才能获得足够的经验，这样即使是最稚嫩的新兵也能成为经验丰富的战士。但是要记住：代价高昂的胜利有可能比失败还要糟糕……当身经百战的单位阵亡时，他们取得的进度与所获经验也会随之消失。每个单位都有特殊能力、武器与盔甲，他们可以装备你在战斗中发现的魔法遗物，并利用从敌人那里获得的黄金和资源进行升级。<br />\r\n部落<br />\r\n一个由山地部落组成的自治联盟，他们珍视自己的独立性，不惜为了它而战斗。 指挥斧手、狂战士、女矛兵、巨魔和萨满，召唤祖先的灵魂和强大的元素，或训练敏捷的鹿骑兵和致命战熊，或者招募从长弓兵到半人马作为雇佣兵。<br />\r\n帝国<br />\r\n表面上看是艾尔世界最强大的王国。面对帝国的强大军团和他们的魔物，从龙炮到傀儡，以及他们带向战场的不死生物，或与哈比、蜥蜴人与巨人作战。<br />\r\n世界<br />\r\n艾尔世界充满了美景与奇观。从寒冷、蕴含丰富魔力的法拉赫高地，也就是玩家野蛮人部落的家园，到拥有肥沃河谷和幽深丛林的边境地带，有巫婆和怪物仍然在那里自由生活；从陷落之地，那里承受了巨大的灾难，充满危险沼泽和蜥蜴人，再到南方精致而平静的帝国，这些奇妙的城市是他们的家园，这些地方都是由不死族的劳工建造而成。随着战役，你将在几个不同的战场中作战，这些战斗也需要不同的战术和军队组成。\r\n	</p>',	33,	'https://fhdemo.s-cms.cn/t15/media/20201103183245F7.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	43,	10,	'2020-11-03 18:32:42',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256760722/movie480.webm?t=1567171589',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL),
(355,	'完美世界大逃亡 My Beautiful Paper Smile',	0.00,	'<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏介绍：</span></span> \r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">《完美世界大逃亡 My Beautiful Paper Smile》是一款心理恐怖游戏，讲的是关于一个孩子被困在一个培养完美儿童的机构中。准备好逃离这里吧！揭开这一行动中黑暗的秘密，努力在险境中生存。\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><br />\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">游戏特色：</span></span> \r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">-令人惊叹的手绘制作<br />\r\n-独一无二的不安气氛<br />\r\n-引人入胜的故事<br />\r\n– 解放自己并试图逃离“机构”设立的“教育”设施<br />\r\n-逃避无脸人的追杀<br />\r\n-在通往自由的路上解决令人紧张的难题<br />\r\n-发现失踪儿童的秘密<br />\r\n-发掘行动背后的原委<br />\r\n-揭开“机构”变态计划背后的黑暗面纱\r\n	</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\"><span style=\"font-size:14pt;\"><span style=\"font-weight:700;\">最低配置:</span></span><br />\r\n操作系统: Windows 7 64-bit<br />\r\n处理器: 2.5 GHz Quad-core Intel or AMD processor<br />\r\n内存: 4 GB RAM<br />\r\n显卡: NVIDIA GeForce 470 GTX or AMD Radeon 6870 HD<br />\r\n存储空间: 需要 2 GB 可用空间\r\n</p>\r\n<p font-size:15.6px;text-align:justify;background-color:rgba(255,=\"\" 255,=\"\" 0.95);\"=\"\" style=\"white-space: normal; color: rgb(102, 102, 102);\">声明：<br />\r\n1.本站部分内容转载自其它媒体，但并不代表本站赞同其观点和对其真实性负责。 <br />\r\n2.若您需要商业运营或用于其他商业活动，请您购买正版授权并合法使用。 <br />\r\n3.如果本站有侵犯、不妥之处的资源，请联系我们。将会第一时间解决！ <br />\r\n4.本站部分内容均由互联网收集整理，仅供大家参考、学习，不存在任何商业目的与商业用途。 <br />\r\n5.本站提供的所有资源仅供参考学习使用，版权归原著所有，禁止下载本站资源参与任何商业和非法行为，请于24小时之内删除!\r\n	</p>',	37,	'https://fhdemo.s-cms.cn/t15/media/20201103183346a2.jpg',	0,	0,	'发货内容下载地址：http://www.aaa.com/bbb.zip（测试数据）',	0,	100,	32,	11,	'2020-11-03 18:33:34',	0,	1,	1,	'',	1,	'',	'https://media.st.dl.pinyuncloud.com/steam/apps/256790134/movie480_vp9.webm?t=1592589532',	0,	0,	0,	'name,mobile,address',	1,	'',	0.00,	'',	'',	'',	'',	0.00,	0,	'',	0,	25,	'',	'',	0.00,	0,	NULL);

DROP TABLE IF EXISTS `sl_psort`;
CREATE TABLE `sl_psort` (
  `S_id` int(11) NOT NULL AUTO_INCREMENT,
  `S_title` text NOT NULL,
  `S_pic` text NOT NULL,
  `S_content` text NOT NULL,
  `S_del` int(11) NOT NULL DEFAULT '0',
  `S_sub` int(11) NOT NULL DEFAULT '0',
  `S_order` int(11) NOT NULL DEFAULT '0',
  `S_show` int(11) DEFAULT '1',
  `S_keywords` varchar(200) DEFAULT NULL,
  `S_icon` text,
  PRIMARY KEY (`S_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_psort` (`S_id`, `S_title`, `S_pic`, `S_content`, `S_del`, `S_sub`, `S_order`, `S_show`, `S_keywords`, `S_icon`) VALUES
(5,	'技能培训',	'20191202210208Dz.jpg',	'技能培训',	1,	0,	1,	1,	'',	'20191202210208Dz.jpg'),
(6,	'PS教程视频',	'20191202210713wj.jpg',	'PS教程视频',	1,	5,	1,	1,	'',	'20191202210713wj.jpg'),
(7,	'淘宝开店教程',	'20191202210806rS.jpg',	'淘宝开店教程',	1,	5,	2,	1,	'',	'20191202210806rS.jpg'),
(8,	'SEO培训教程',	'20191202210935Yr.jpg',	'SEO培训教程',	1,	5,	3,	1,	'',	'20191202210935Yr.jpg'),
(9,	'源码交易',	'20191202211009yS.jpg',	'源码交易',	1,	0,	2,	1,	'',	'20191202211009yS.jpg'),
(10,	'淘客/网店/商城',	'201912022111528M.jpg',	'淘客/网店/商城',	1,	9,	1,	1,	'',	'201912022111528M.jpg'),
(11,	'导航/网址/查询',	'201912022112327V.jpg',	'导航/网址/查询',	1,	9,	2,	1,	'',	'201912022112327V.jpg'),
(12,	'聊天/交友/直播',	'201912022113041Y.jpg',	'聊天/交友/直播',	1,	9,	3,	1,	'',	'201912022113041Y.jpg'),
(13,	'营销软件',	'201912022113549k.jpg',	'营销软件',	1,	0,	3,	1,	'',	'201912022113549k.jpg'),
(14,	'群发营销软件',	'201912022114272W.jpg',	'群发营销软件',	1,	13,	1,	1,	'',	'201912022114272W.jpg'),
(15,	'搜索软件工具',	'201912022115062W.jpg',	'搜索软件工具',	1,	13,	2,	1,	'',	'201912022115062W.jpg'),
(16,	'SEO工具软件',	'20191202211545Ib.jpg',	'SEO工具软件',	1,	13,	3,	1,	'',	'20191202211545Ib.jpg'),
(17,	'网络安全',	'20191202211639JI.jpg',	'网络安全',	1,	0,	4,	1,	'',	'20191202211639JI.jpg'),
(18,	'黑客技术教程',	'201912022117180j.jpg',	'黑客技术教程',	1,	17,	1,	1,	'',	'201912022117180j.jpg'),
(19,	'软件破解教程',	'20191202211759lo.jpg',	'软件破解教程',	1,	17,	2,	1,	'',	'20191202211759lo.jpg'),
(20,	'视频加密破解',	'20191202211841p2.jpg',	'视频加密破解',	1,	17,	3,	1,	'',	'20191202211841p2.jpg'),
(21,	'卡密发码',	'20191203092306rJ.jpg',	'卡密发码',	1,	0,	1,	1,	'',	'20191203092306rJ.jpg'),
(22,	'软件激活码',	'20191203092340RK.jpg',	'软件激活码',	1,	21,	1,	1,	'',	'20191203092340RK.jpg'),
(23,	'视频VIP',	'20191203092429yP.jpg',	'视频VIP',	1,	21,	2,	1,	'',	'20191203092429yP.jpg'),
(24,	'点卡充值',	'201912030925410Y.jpg',	'点卡充值',	1,	21,	3,	1,	'',	'201912030925410Y.jpg'),
(25,	'电脑游戏',	'20201212070400JZ.jpg',	'',	0,	0,	0,	1,	'',	'20201212070400JZ.jpg'),
(26,	'联机游戏',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(27,	'角色扮演',	'nopic.png',	'',	1,	0,	0,	1,	'',	'nopic.png'),
(28,	'角色扮演',	'nopic.png',	'',	1,	25,	0,	1,	'',	'nopic.png'),
(29,	'动作冒险',	'nopic.png',	'',	1,	25,	0,	1,	'',	'nopic.png'),
(30,	'赛车竞技',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(31,	'即时战略',	'nopic.png',	'',	1,	25,	0,	1,	'',	'nopic.png'),
(32,	'冒险解谜',	'nopic.png',	'',	0,	121,	0,	1,	'',	'nopic.png'),
(33,	'战术策略',	'nopic.png',	'',	0,	121,	0,	1,	'',	'nopic.png'),
(34,	'休闲益智',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(35,	'弹幕射击',	'nopic.png',	'',	0,	123,	0,	1,	'',	'nopic.png'),
(36,	'模拟经营',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(37,	'恐怖冒险',	'nopic.png',	'',	0,	123,	0,	1,	'',	'nopic.png'),
(38,	'文字游戏',	'nopic.png',	'',	1,	0,	0,	1,	'',	'nopic.png'),
(39,	'文字游戏',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(40,	'塔防游戏',	'nopic.png',	'',	1,	0,	0,	1,	'',	'nopic.png'),
(41,	'沙盒开放',	'nopic.png',	'',	0,	123,	0,	1,	'',	'nopic.png'),
(42,	'塔防游戏',	'nopic.png',	'',	0,	121,	0,	1,	'',	'nopic.png'),
(43,	'体育竞技',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(44,	'射击游戏',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(45,	'回合游戏',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(46,	'像素游戏',	'nopic.png',	'',	0,	102,	0,	1,	'',	'nopic.png'),
(47,	'网盘svip',	'202012120705501y.jpg',	'',	1,	52,	0,	0,	'',	'202012120705501y.jpg'),
(48,	'盘svip',	'nopic.png',	'',	1,	52,	0,	1,	'',	'nopic.png'),
(49,	'美女cos资源',	'20201212070605KH.jpg',	'',	1,	0,	0,	0,	'',	'20201212070605KH.jpg'),
(50,	'福利游戏',	'nopic.png',	'',	1,	0,	0,	1,	'',	'nopic.png'),
(51,	'福利游戏',	'nopic.png',	'',	1,	25,	0,	0,	'',	'nopic.png'),
(52,	'客服',	'nopic.png',	'',	1,	0,	0,	0,	'',	'nopic.png'),
(53,	'卡牌策略',	'nopic.png',	'',	1,	25,	0,	1,	'',	'nopic.png'),
(54,	'卡牌策略',	'nopic.png',	'',	0,	119,	0,	1,	'',	'nopic.png'),
(55,	'横版游戏',	'nopic.png',	'',	1,	25,	0,	1,	'',	'nopic.png'),
(56,	'独立冒险',	'nopic.png',	'',	0,	123,	0,	1,	'',	'nopic.png'),
(57,	'动漫游戏',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(58,	'推荐游戏',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(59,	'动作格斗',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(60,	'日系游戏',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(61,	'电影游戏',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(62,	'电脑软件',	'nopic.png',	'',	1,	97,	0,	1,	'',	'nopic.png'),
(63,	'手机软件',	'nopic.png',	'',	1,	97,	0,	1,	'',	'nopic.png'),
(64,	'经典游戏怀旧',	'nopic.png',	'',	1,	0,	0,	1,	'',	'nopic.png'),
(65,	'经典游戏怀旧',	'nopic.png',	'',	1,	64,	0,	1,	'',	'nopic.png'),
(66,	'恋爱养成',	'20201212070711U3.jpg',	'',	0,	25,	0,	1,	'',	'20201212070711U3.jpg'),
(67,	'视频资源',	'20201212070741zt.jpg',	'',	1,	0,	2,	1,	'',	'20201212070741zt.jpg'),
(68,	'动漫',	'nopic.png',	'',	1,	67,	0,	1,	'',	'nopic.png'),
(69,	'纪录片',	'nopic.png',	'',	1,	67,	0,	1,	'',	'nopic.png'),
(70,	'电影',	'nopic.png',	'',	1,	67,	0,	1,	'',	'nopic.png'),
(71,	'治愈游戏',	'20201212070640j5.jpg',	'',	0,	121,	0,	1,	'',	'20201212070640j5.jpg'),
(72,	'免费专区',	'nopic.png',	'',	1,	0,	5,	1,	'',	'nopic.png'),
(73,	'游戏列表（免费）',	'20201212070445ks.jpg',	'默认子分类',	0,	25,	0,	1,	'默认子分类',	'20201212070445ks.jpg'),
(74,	'手机游戏',	'nopic.png',	'',	1,	0,	0,	0,	'',	'nopic.png'),
(75,	'默认子分类',	'nopic.png',	'默认子分类',	1,	74,	0,	1,	'默认子分类',	'nopic.png'),
(76,	'安卓游戏',	'nopic.png',	'',	1,	74,	0,	0,	'',	'nopic.png'),
(77,	'动漫',	'nopic.png',	'',	1,	67,	0,	1,	'',	'nopic.png'),
(78,	'考研学习区',	'nopic.png',	'',	1,	0,	0,	0,	'',	'nopic.png'),
(79,	'考研学习',	'nopic.png',	'默认子分类',	1,	78,	0,	0,	'默认子分类',	'nopic.png'),
(80,	'软件区',	'nopic.png',	'',	1,	0,	3,	1,	'',	'nopic.png'),
(81,	'默认子分类',	'nopic.png',	'默认子分类',	1,	80,	0,	0,	'默认子分类',	'nopic.png'),
(82,	'番剧',	'nopic.png',	'',	1,	67,	0,	1,	'',	'nopic.png'),
(83,	'纪录片',	'nopic.png',	'',	1,	67,	0,	1,	'',	'nopic.png'),
(84,	'怀旧游戏',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(85,	'生存风格',	'nopic.png',	'',	0,	119,	0,	1,	'',	'nopic.png'),
(86,	'电影',	'nopic.png',	'',	1,	67,	0,	1,	'',	'nopic.png'),
(87,	'动漫',	'nopic.png',	'',	1,	67,	0,	1,	'',	'nopic.png'),
(88,	'电视剧',	'nopic.png',	'',	1,	67,	0,	1,	'',	'nopic.png'),
(89,	'福利视频',	'nopic.png',	'',	1,	49,	0,	0,	'',	'nopic.png'),
(90,	'壁纸',	'nopic.png',	'',	1,	97,	0,	1,	'',	'nopic.png'),
(91,	'插画',	'nopic.png',	'',	1,	49,	0,	0,	'',	'nopic.png'),
(92,	'福利资源',	'nopic.png',	'',	1,	49,	0,	0,	'',	'nopic.png'),
(93,	'COSPLAY',	'nopic.png',	'',	1,	49,	0,	1,	'',	'nopic.png'),
(94,	'默认子分类',	'nopic.png',	'默认子分类',	1,	93,	0,	1,	'默认子分类',	'nopic.png'),
(95,	'二次元美图',	'nopic.png',	'',	1,	49,	0,	1,	'',	'nopic.png'),
(96,	'每日美图',	'nopic.png',	'',	1,	49,	0,	1,	'',	'nopic.png'),
(97,	'日常资源区',	'nopic.png',	'',	1,	0,	0,	1,	'',	'nopic.png'),
(98,	'默认子分类',	'nopic.png',	'默认子分类',	1,	97,	0,	1,	'默认子分类',	'nopic.png'),
(99,	'ASMR',	'nopic.png',	'',	1,	49,	0,	1,	'',	'nopic.png'),
(100,	'会员福利',	'nopic.png',	'',	1,	0,	0,	1,	'',	'nopic.png'),
(101,	'会员福利',	'nopic.png',	'默认子分类',	1,	100,	0,	1,	'默认子分类',	'nopic.png'),
(102,	'掌机游戏资源',	'nopic.png',	'',	0,	0,	0,	1,	'',	'nopic.png'),
(103,	'swich游戏',	'nopic.png',	'默认子分类',	1,	102,	0,	1,	'默认子分类',	'nopic.png'),
(104,	'手机游戏',	'nopic.png',	'',	1,	97,	0,	1,	'',	'nopic.png'),
(105,	'模拟器游戏',	'nopic.png',	'',	0,	102,	0,	1,	'',	'nopic.png'),
(106,	'视觉小说',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(107,	'街机游戏',	'nopic.png',	'',	1,	25,	0,	1,	'',	'nopic.png'),
(108,	'街机风格',	'nopic.png',	'',	0,	121,	0,	1,	'',	'nopic.png'),
(109,	'策略战棋',	'nopic.png',	'',	1,	0,	0,	1,	'',	'nopic.png'),
(110,	'默认子分类',	'nopic.png',	'默认子分类',	1,	109,	0,	1,	'默认子分类',	'nopic.png'),
(111,	'策略战棋',	'nopic.png',	'',	1,	25,	0,	1,	'',	'nopic.png'),
(112,	'模拟逼真',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(113,	'steam免费游戏',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(114,	'动态壁纸',	'nopic.png',	'',	1,	97,	0,	1,	'',	'nopic.png'),
(115,	'学习资源',	'nopic.png',	'',	1,	97,	0,	1,	'',	'nopic.png'),
(116,	'漫画资源',	'nopic.png',	'',	1,	49,	0,	1,	'',	'nopic.png'),
(117,	'冒险游戏 (AVG)',	'nopic.png',	'',	1,	25,	0,	1,	'',	'nopic.png'),
(118,	'GalGame',	'nopic.png',	'',	0,	25,	0,	1,	'',	'nopic.png'),
(119,	'手机游戏',	'nopic.png',	'',	0,	0,	0,	1,	'',	'nopic.png'),
(120,	'默认子分类',	'nopic.png',	'默认子分类',	1,	119,	0,	1,	'默认子分类',	'nopic.png'),
(121,	'联机对战',	'nopic.png',	'',	0,	0,	0,	1,	'',	'nopic.png'),
(122,	'默认子分类',	'nopic.png',	'默认子分类',	1,	121,	0,	1,	'默认子分类',	'nopic.png'),
(123,	'社区资源',	'nopic.png',	'',	0,	0,	0,	1,	'',	'nopic.png'),
(124,	'默认子分类',	'nopic.png',	'默认子分类',	1,	123,	0,	1,	'默认子分类',	'nopic.png');

DROP TABLE IF EXISTS `sl_quan`;
CREATE TABLE `sl_quan` (
  `Q_id` int(11) NOT NULL AUTO_INCREMENT,
  `Q_mid` int(11) NOT NULL DEFAULT '0',
  `Q_title` text,
  `Q_code` text,
  `Q_pid` int(11) NOT NULL DEFAULT '0',
  `Q_money` decimal(10,0) NOT NULL DEFAULT '0',
  `Q_discount` decimal(10,0) NOT NULL DEFAULT '0',
  `Q_minuse` decimal(10,0) NOT NULL DEFAULT '0',
  `Q_usetime` datetime NOT NULL,
  `Q_gettime` datetime NOT NULL,
  `Q_del` int(11) NOT NULL DEFAULT '0',
  `Q_use` int(11) NOT NULL DEFAULT '0',
  `Q_fid` int(11) DEFAULT '0',
  `Q_order` int(11) DEFAULT '0',
  `Q_hide` int(11) DEFAULT '0',
  PRIMARY KEY (`Q_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_quan` (`Q_id`, `Q_mid`, `Q_title`, `Q_code`, `Q_pid`, `Q_money`, `Q_discount`, `Q_minuse`, `Q_usetime`, `Q_gettime`, `Q_del`, `Q_use`, `Q_fid`, `Q_order`, `Q_hide`) VALUES
(1,	0,	'测试优惠券',	'YcoCcD2ZvzlicKKxBlRBBmQLWqxDNkoZ',	0,	100,	0,	10,	'2021-01-06 23:03:16',	'2020-12-17 23:03:16',	0,	0,	1,	0,	0),
(2,	0,	'测试优惠券',	'xj7zuzsKoVnDvKMPX5p1S82J7QVICOvj',	0,	100,	0,	10,	'2021-01-06 23:03:16',	'2020-12-17 23:03:16',	0,	0,	1,	0,	0),
(3,	0,	'测试优惠券',	'bSRzgn6URffTTmnkYggXKVTSfZqXxWSJ',	0,	100,	0,	10,	'2021-01-06 23:03:16',	'2020-12-17 23:03:16',	0,	0,	1,	0,	0),
(4,	0,	'测试优惠券',	'6i9QCzt8QXDs6auTd97umo8wXsI6kRjg',	0,	100,	0,	10,	'2021-01-06 23:03:16',	'2020-12-17 23:03:16',	0,	0,	1,	0,	0),
(5,	0,	'测试优惠券',	'pDpYn7n1A6Knfe3llpns7bZtgbQrexIY',	0,	100,	0,	10,	'2021-01-06 23:03:16',	'2020-12-17 23:03:16',	0,	0,	1,	0,	0),
(6,	0,	'测试优惠券',	'86HcxxzVdhGkfXYlLjAH5Du6eW7ONLM2',	0,	100,	0,	10,	'2021-01-06 23:03:16',	'2020-12-17 23:03:16',	0,	0,	1,	0,	0),
(7,	0,	'测试优惠券',	'h4PorsWbstIi6ncmnM3v0uQIi6hZHYuB',	0,	100,	0,	10,	'2021-01-06 23:03:16',	'2020-12-17 23:03:16',	0,	0,	1,	0,	0),
(8,	0,	'测试优惠券',	'LjvTDFrmapqHohr6jvT6yqJyiYS5KeVj',	0,	100,	0,	10,	'2021-01-06 23:03:16',	'2020-12-17 23:03:16',	0,	0,	1,	0,	0),
(9,	0,	'测试优惠券',	'hydbH0kTHxpKNCRH9dbSrcvTIDq8VP4Y',	0,	100,	0,	10,	'2021-01-06 23:03:16',	'2020-12-17 23:03:16',	0,	0,	1,	0,	0),
(10,	0,	'测试优惠券',	'xCPLFkoVSZxjtH1ZSCTJMWfLzconOk0Q',	0,	100,	0,	10,	'2021-01-06 23:03:16',	'2020-12-17 23:03:16',	0,	0,	1,	0,	0);

DROP TABLE IF EXISTS `sl_rcard`;
CREATE TABLE `sl_rcard` (
  `R_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `R_content` text,
  `R_money` decimal(10,2) DEFAULT '0.00',
  `R_use` int(10) DEFAULT '0',
  `R_mid` int(10) DEFAULT '0',
  `R_del` int(10) DEFAULT '0',
  `R_time` datetime DEFAULT NULL,
  `R_usetime` datetime DEFAULT NULL,
  `R_type` int(11) DEFAULT '0',
  PRIMARY KEY (`R_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `sl_slide`;
CREATE TABLE `sl_slide` (
  `S_id` int(11) NOT NULL AUTO_INCREMENT,
  `S_pic` text NOT NULL,
  `S_title` text NOT NULL,
  `S_content` text NOT NULL,
  `S_link` text NOT NULL,
  `S_del` int(11) NOT NULL DEFAULT '0',
  `S_order` int(11) NOT NULL DEFAULT '0',
  `S_mid` int(11) DEFAULT '0',
  PRIMARY KEY (`S_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_slide` (`S_id`, `S_pic`, `S_title`, `S_content`, `S_link`, `S_del`, `S_order`, `S_mid`) VALUES
(1,	'20210927092107aW.jpg',	'焦点图3777',	'图片12',	'#2',	0,	3,	0),
(2,	'20210927092103VN.jpg',	'焦点图2',	'图片255',	'#55',	0,	2,	0),
(3,	'20210927092057E0.jpg',	'焦点图1',	'ff',	'#',	0,	1,	0);

DROP TABLE IF EXISTS `sl_text`;
CREATE TABLE `sl_text` (
  `T_id` int(11) NOT NULL AUTO_INCREMENT,
  `T_title` text NOT NULL,
  `T_content` text NOT NULL,
  `T_pic` text NOT NULL,
  `T_del` int(11) NOT NULL DEFAULT '0',
  `T_order` int(11) NOT NULL DEFAULT '0',
  `T_type` int(11) NOT NULL DEFAULT '0',
  `T_zb` text NOT NULL,
  `T_address` text NOT NULL,
  `T_keywords` varchar(200) DEFAULT NULL,
  `T_description` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`T_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sl_text` (`T_id`, `T_title`, `T_content`, `T_pic`, `T_del`, `T_order`, `T_type`, `T_zb`, `T_address`, `T_keywords`, `T_description`) VALUES
(1,	'隐私申明',	'<span style=\"color:#222222;font-family:\" font-size:14px;background-color:#ffffff;\"=\"\">欢迎访问进口零食网商城！我们以本隐私声明对访问者隐私保护许诺。以下文字公开我站对信息收集和使用的情况。本站的隐私申明正在不断改进中，随着我站服务范围的扩大，我们会随时更新我们的隐私声明。</span> <p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	在同意进口零食网商城服务协议之时，你已经同意我们按照本隐私申明来使用和披露您的个人信息。本隐私申明的全部条款属于该协议的一部份。\r\n	</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	未成年人的特别注意事项\r\n</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	如果您未满18周岁，您无权使用公司服务，因此我们希望您不要向我们提供任何个人信息。如果您未满18周岁，您只能在父母或监护人的陪同下才可以使用公司服务。\r\n	</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	用户名和密码\r\n</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	当您打算注册成用户后，我们要求您选择一个用户名和密码，还要提供密码提示问题及其答案以便在您丢失密码后我们可以确认您的身份。您只能通过您的密码来使用您的帐号。如果您泄漏了密码，您可能丢失了您的个人识别信息，并且有可能导致对您不利的司法行为。因此不管任何原因使您的密码安全受到危及，您应该立即通过service@lppz.com和我们取得联系。\r\n	</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	注册信息\r\n</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	当您在注册为用户时，我们要求您填写一张注册表。注册表要求提供您的真实姓名，地址，国籍，电话号码，和电子邮件地址。如果您是公司客户，您还被要求提供您的公司的地址，电话号码和贵公司的服务和产品的简短说明。您还有权选择来填写附加信息。这些信息可能包括您公司所在的省份和城市，时区和邮政编码，传真号码，主页和您的职务。我们使用注册信息来获得用户的统计资料。我们将会用这些统计数据来给我们的用户分类，以便有针对性地向我们的用户提供新的服务。我们会通过您的邮件地址来通知您这些新的服务。\r\n	</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	您的交易行为\r\n</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	我们跟踪IP地址仅仅只是为了安全的必要。如果我们没有发现任何安全问题，我们会及时删除我们收集到的IP地址。我们还跟踪全天的页面访问数据。全天页面访问数据被用来反映网站的流量，一是我们可以为未来的发展制定计划（例如，增加服务器）。\r\n	</p>',	'20191126200722i3.jpg',	0,	3,	0,	'',	'',	'',	''),
(2,	'品牌故事',	'<span style=\"color:#222222;font-family:\" font-size:14px;background-color:#ffffff;\"=\"\">进口零食食品有限公司是一家集休闲食品研发、加工分装、零售服务的专业品牌连锁运营公司。2006年8月28日在湖北省武汉市武汉广场对面开立第一家门店，至2014年3月拥有门店数约1200家，涉及湖北、湖南、江西、四川四省，员工人数达到4000余人。</span> <p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	进口零食食品有限公司秉承着品质·快乐·家的企业核心价值观，坚持研发高品质产品，不断引进先进的经营管理思想。\r\n	</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	进口零食食品有限公司注重员工的培养与成长，努力给所有员工营造家的归属感。公司倡导尊重人、培养人、成就人的用人理念，激情共创、快乐分享的团队精神，在优秀的企业文化氛围中培养了一支 年轻且具活力与创造力的团队。\r\n</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	进口零食食品有限公司秉承着品质·快乐·家的企业文化本源，以提供高品质食品，传递快乐，为提高全球华人健康幸福生活而努力奋斗为企业使命。坚持研发高品质产品，不断引进先进的经营管理思想，立志成为全球休闲食品零售服务业的领导品牌。\r\n	</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	进口零食食品有限公司注重员工的培养与成长，努力给所有员工营造家的归属感。公司倡导尊重人、培养人、成就人的用人理念，激情共创、快乐分享的团队精神，在优秀的企业文 化氛围中培养了一支年轻且极具活力与创造力的团队。在良品铺子快速发展之际，热忱欢迎充满朝气，勇于挑战自己的年轻人加入。\r\n</p>',	'20191203103723GF.jpg',	0,	2,	0,	'',	'',	'',	''),
(3,	'联系我们',	'<span style=\"color:#222222;font-family:\" font-size:18px;background-color:#ffffff;\"=\"\">地址：北京市xx区xx路xx广场x号</span><br />\r\n<span style=\"color:#222222;font-family:\" font-size:18px;background-color:#ffffff;\"=\"\">电话：86-010-xxxxxxxx</span><br />\r\n<span style=\"color:#222222;font-family:\" font-size:18px;background-color:#ffffff;\"=\"\">传真：86-010-xxxxxxxxxxxxxxxx</span><br />\r\n<span style=\"color:#222222;font-family:\" font-size:18px;background-color:#ffffff;\"=\"\">邮箱：xxxxxxxxx@qq.com</span><br />\r\n<span style=\"color:#222222;font-family:\" font-size:18px;background-color:#ffffff;\"=\"\">网址：www.xxxxxx.com</span>',	'20191203103700aY.jpg',	0,	1,	1,	'116.376098,39.966935',	'北京市xx区xx路xx广场x号楼xx号',	'',	''),
(4,	'加盟合作',	'<span style=\"color:#222222;font-family:\" font-size:14px;background-color:#ffffff;\"=\"\">商城秉承“诚信第一，客户至上”，倡导“崇尚健康，绿色食品”的原则，保证所有食品绝对正货，有“产品质量保证保险”保障。请放心食用，如在售后过程中感到不满，请与客服联系，可以办理换货或退货事宜，详情如下：</span> <p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	1、包装破损处理\r\n	</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	商城保证发货时的食品外包装的完好无缺。请您收到食品时当场验货，如果发现食品包装破损，请当场与快递人员核实，用户可以当场拒收，并拍下照片发送给我们客服确认，我们将为您重新发货或退款。\r\n</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	2、收到货物与所订购货物不符\r\n	</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	商城寄送食品时，会把发票、送货清单、赠品等一同寄出，请您逐一检查。如您发现收到的食品与定购的食品不符合，请您在签收后的24小时内联系商城客服。如有漏发情况，我们会为您补发食品（或补回所缺差价的代金券面值），运费由我方承担。如有错发情况，商城将为您补偿差价或办理退货/换货，运费由我们承担。\r\n</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	3、食品质量问题\r\n	</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	若收到的食品出现过期问题，请立即与商城客服联系，把食品、赠品、发票等一起寄回我司，商城将为您退货/换货。如用户故意在保质期外食用，造成身体机能受损，我方不承担任何责任。\r\n</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	4、退货/换货流程\r\n	</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	如您要求退/换货，请您先与客服中心联系，核实后请您将要退换的商品、发票、送货单、赠品等一起寄至我司，然后进行重寄食品或退款事宜，我们同时收回您购买此食品所获的相应积分或返利。\r\n</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	5、如发生以下情况，我们将不予办理退/换货\r\n	</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	&nbsp; 5.1 我们没有收到您要退换的商品。\r\n</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	&nbsp; 5.2 退回的食品不齐全。\r\n	</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	&nbsp; 5.3 食品已被拆封食用。\r\n</p>\r\n<p style=\"color:#222222;font-family:\" font-size:14px;\"=\"\">\r\n	&nbsp; 5.4 个人主观原因要求退货/换货（例如：个人觉得所购不符合自己口味，食品颜色不漂亮）。\r\n	</p>',	'20191203103823Zd.jpg',	0,	4,	0,	'',	'',	'',	''),
(5,	'在线留言',	'欢迎给我们留言！',	'20191207111909xo.jpg',	0,	5,	2,	'',	'',	'',	''),
(6,	'订单查询',	'',	'nopic.png',	0,	6,	4,	'',	'',	'',	'');

DROP TABLE IF EXISTS `sl_usort`;
CREATE TABLE `sl_usort` (
  `S_id` int(11) NOT NULL AUTO_INCREMENT,
  `S_title` text NOT NULL,
  `S_pic` text NOT NULL,
  `S_sub` int(11) NOT NULL DEFAULT '0',
  `S_order` int(11) NOT NULL DEFAULT '0',
  `S_del` int(11) NOT NULL DEFAULT '0',
  `S_content` text NOT NULL,
  `S_show` int(11) NOT NULL DEFAULT '0',
  `S_keywords` text NOT NULL,
  PRIMARY KEY (`S_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- 2021-09-27 02:08:43
